/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.test.kerberos;

import com.beust.jcommander.JCommander;
import com.datastax.dse.test.kerberos.EmbeddedADS;
import com.datastax.dse.test.kerberos.EmbeddedADSParameters;
import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmbeddedADSDriver {
    private static final Logger logger = LoggerFactory.getLogger(EmbeddedADSDriver.class);
    private final EmbeddedADSParameters parameters;
    private final EmbeddedADS adsServer;
    private volatile boolean isInit = false;

    public EmbeddedADSDriver(EmbeddedADSParameters parameters) {
        this.parameters = parameters;
        EmbeddedADS.Builder builder = EmbeddedADS.builder().withLdapPort(parameters.ldapport).withRealm(parameters.realm).withAddress(parameters.address).withBaseDn(parameters.dn).withConfDir(parameters.confdir);
        if (parameters.kerberos) {
            builder = builder.withKerberos(parameters.kdcport);
        }
        this.adsServer = builder.build();
    }

    public synchronized void start() throws Exception {
        if (this.isInit) {
            return;
        }
        this.isInit = true;
        try {
            String[] users;
            logger.info("Starting server.");
            this.adsServer.start();
            logger.info("ADS server started.");
            logger.info("LDAP is listening @ {}:{}", (Object)this.parameters.address, (Object)this.parameters.ldapport);
            if (this.parameters.kerberos) {
                logger.info("KDC is listening @ {}:{}", (Object)this.parameters.address, (Object)this.parameters.kdcport);
                logger.info("Generated kerberos config file: {}.  Set KRB5_CONFIG environment variable to this path to authenticate with this KDC.", (Object)this.adsServer.getKrb5Conf().getAbsolutePath());
            }
            logger.info("Initializing Principals.");
            for (String user : users = new String[]{"cassandra", "dseuser", "charlie", "bob", "steve", "bill"}) {
                String userPrincipal = user + "@" + this.parameters.realm;
                File userKeytab = this.adsServer.addUserAndCreateKeytab(user, user, userPrincipal);
                logger.info("Created principal: {} and keytab: {}.", (Object)userPrincipal, (Object)userKeytab.getAbsolutePath());
            }
            String unknownPrincipal = "unknown@" + this.parameters.realm;
            File unknownKeytab = this.adsServer.createKeytab("unknown", "unknown", unknownPrincipal);
            logger.info("Created keytab: {} for non-existent principal: {}", (Object)unknownKeytab.getAbsolutePath(), (Object)unknownPrincipal);
            String dsePrincipal = "dse/" + this.adsServer.getHostname() + "@" + this.parameters.realm;
            File dseKeytab = this.adsServer.addUserAndCreateKeytab("dse", "dse", dsePrincipal);
            logger.info("Created principal: {} and keytab: {}.", (Object)dsePrincipal, (Object)dseKeytab.getAbsolutePath());
            logger.info("Principal Initialization Complete.");
        }
        catch (Exception e) {
            logger.info("Failure starting ADS server.", e);
            this.adsServer.stop();
            throw e;
        }
    }

    public static void main(String[] args) throws Exception {
        EmbeddedADSParameters params = new EmbeddedADSParameters();
        JCommander commander = new JCommander((Object)params, args);
        if (params.help) {
            commander.usage();
            System.exit(-2);
        }
        EmbeddedADSDriver driver = new EmbeddedADSDriver(params);
        driver.start();
    }
}

