// Copyright (c) Microsoft Corporation. All rights reserved.
// SPDX-License-Identifier: MIT

#include <iostream>

#include <azure/identity/environment_credential.hpp>

#include <azure/service/client.hpp>

int main()
{
  try
  {
    // Step 1: Create an EnvironmentCredential instance.
    // Environment Credential would read its parameters from the environment variables, such as
    // AZURE_TENANT_ID, AZURE_CLIENT_ID, AZURE_CLIENT_SECRET. See documentation for details.
    auto environmentCredential = std::make_shared<Azure::Identity::EnvironmentCredential>();

    // Step 2: Pass the credential to an Azure Service Client.
    Azure::Service::Client azureServiceClient("some parameter", environmentCredential);

    // Step 3: Start using the Azure Service Client.
    azureServiceClient.DoSomething(Azure::Core::Context::ApplicationContext);

    std::cout << "Success!" << std::endl;
  }
  catch (const Azure::Core::Credentials::AuthenticationException& exception)
  {
    // Step 4 (optional/oversimplified): Handle authentication errors
    // (invalid credential parameters, insufficient permissions).
    std::cout << "Authentication error: " << exception.what() << std::endl;
  }
}
