﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/ssm/SSM_EXPORTS.h>
#include <aws/ssm/SSMRequest.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSMap.h>
#include <aws/ssm/model/MetadataValue.h>
#include <utility>

namespace Aws
{
namespace SSM
{
namespace Model
{

  /**
   */
  class AWS_SSM_API CreateOpsMetadataRequest : public SSMRequest
  {
  public:
    CreateOpsMetadataRequest();

    // Service request name is the Operation name which will send this request out,
    // each operation should has unique request name, so that we can get operation's name from this request.
    // Note: this is not true for response, multiple operations may have the same response name,
    // so we can not get operation's name from response.
    inline virtual const char* GetServiceRequestName() const override { return "CreateOpsMetadata"; }

    Aws::String SerializePayload() const override;

    Aws::Http::HeaderValueCollection GetRequestSpecificHeaders() const override;


    /**
     * <p>A resource ID for a new Application Manager application.</p>
     */
    inline const Aws::String& GetResourceId() const{ return m_resourceId; }

    /**
     * <p>A resource ID for a new Application Manager application.</p>
     */
    inline bool ResourceIdHasBeenSet() const { return m_resourceIdHasBeenSet; }

    /**
     * <p>A resource ID for a new Application Manager application.</p>
     */
    inline void SetResourceId(const Aws::String& value) { m_resourceIdHasBeenSet = true; m_resourceId = value; }

    /**
     * <p>A resource ID for a new Application Manager application.</p>
     */
    inline void SetResourceId(Aws::String&& value) { m_resourceIdHasBeenSet = true; m_resourceId = std::move(value); }

    /**
     * <p>A resource ID for a new Application Manager application.</p>
     */
    inline void SetResourceId(const char* value) { m_resourceIdHasBeenSet = true; m_resourceId.assign(value); }

    /**
     * <p>A resource ID for a new Application Manager application.</p>
     */
    inline CreateOpsMetadataRequest& WithResourceId(const Aws::String& value) { SetResourceId(value); return *this;}

    /**
     * <p>A resource ID for a new Application Manager application.</p>
     */
    inline CreateOpsMetadataRequest& WithResourceId(Aws::String&& value) { SetResourceId(std::move(value)); return *this;}

    /**
     * <p>A resource ID for a new Application Manager application.</p>
     */
    inline CreateOpsMetadataRequest& WithResourceId(const char* value) { SetResourceId(value); return *this;}


    /**
     * <p>Metadata for a new Application Manager application. </p>
     */
    inline const Aws::Map<Aws::String, MetadataValue>& GetMetadata() const{ return m_metadata; }

    /**
     * <p>Metadata for a new Application Manager application. </p>
     */
    inline bool MetadataHasBeenSet() const { return m_metadataHasBeenSet; }

    /**
     * <p>Metadata for a new Application Manager application. </p>
     */
    inline void SetMetadata(const Aws::Map<Aws::String, MetadataValue>& value) { m_metadataHasBeenSet = true; m_metadata = value; }

    /**
     * <p>Metadata for a new Application Manager application. </p>
     */
    inline void SetMetadata(Aws::Map<Aws::String, MetadataValue>&& value) { m_metadataHasBeenSet = true; m_metadata = std::move(value); }

    /**
     * <p>Metadata for a new Application Manager application. </p>
     */
    inline CreateOpsMetadataRequest& WithMetadata(const Aws::Map<Aws::String, MetadataValue>& value) { SetMetadata(value); return *this;}

    /**
     * <p>Metadata for a new Application Manager application. </p>
     */
    inline CreateOpsMetadataRequest& WithMetadata(Aws::Map<Aws::String, MetadataValue>&& value) { SetMetadata(std::move(value)); return *this;}

    /**
     * <p>Metadata for a new Application Manager application. </p>
     */
    inline CreateOpsMetadataRequest& AddMetadata(const Aws::String& key, const MetadataValue& value) { m_metadataHasBeenSet = true; m_metadata.emplace(key, value); return *this; }

    /**
     * <p>Metadata for a new Application Manager application. </p>
     */
    inline CreateOpsMetadataRequest& AddMetadata(Aws::String&& key, const MetadataValue& value) { m_metadataHasBeenSet = true; m_metadata.emplace(std::move(key), value); return *this; }

    /**
     * <p>Metadata for a new Application Manager application. </p>
     */
    inline CreateOpsMetadataRequest& AddMetadata(const Aws::String& key, MetadataValue&& value) { m_metadataHasBeenSet = true; m_metadata.emplace(key, std::move(value)); return *this; }

    /**
     * <p>Metadata for a new Application Manager application. </p>
     */
    inline CreateOpsMetadataRequest& AddMetadata(Aws::String&& key, MetadataValue&& value) { m_metadataHasBeenSet = true; m_metadata.emplace(std::move(key), std::move(value)); return *this; }

    /**
     * <p>Metadata for a new Application Manager application. </p>
     */
    inline CreateOpsMetadataRequest& AddMetadata(const char* key, MetadataValue&& value) { m_metadataHasBeenSet = true; m_metadata.emplace(key, std::move(value)); return *this; }

    /**
     * <p>Metadata for a new Application Manager application. </p>
     */
    inline CreateOpsMetadataRequest& AddMetadata(const char* key, const MetadataValue& value) { m_metadataHasBeenSet = true; m_metadata.emplace(key, value); return *this; }

  private:

    Aws::String m_resourceId;
    bool m_resourceIdHasBeenSet;

    Aws::Map<Aws::String, MetadataValue> m_metadata;
    bool m_metadataHasBeenSet;
  };

} // namespace Model
} // namespace SSM
} // namespace Aws
