﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/route53/model/ListHostedZonesByNameResult.h>
#include <aws/core/utils/xml/XmlSerializer.h>
#include <aws/core/AmazonWebServiceResult.h>
#include <aws/core/utils/StringUtils.h>

#include <utility>

using namespace Aws::Route53::Model;
using namespace Aws::Utils::Xml;
using namespace Aws::Utils;
using namespace Aws;

ListHostedZonesByNameResult::ListHostedZonesByNameResult() : 
    m_isTruncated(false)
{
}

ListHostedZonesByNameResult::ListHostedZonesByNameResult(const Aws::AmazonWebServiceResult<XmlDocument>& result) : 
    m_isTruncated(false)
{
  *this = result;
}

ListHostedZonesByNameResult& ListHostedZonesByNameResult::operator =(const Aws::AmazonWebServiceResult<XmlDocument>& result)
{
  const XmlDocument& xmlDocument = result.GetPayload();
  XmlNode resultNode = xmlDocument.GetRootElement();

  if(!resultNode.IsNull())
  {
    XmlNode hostedZonesNode = resultNode.FirstChild("HostedZones");
    if(!hostedZonesNode.IsNull())
    {
      XmlNode hostedZonesMember = hostedZonesNode.FirstChild("HostedZone");
      while(!hostedZonesMember.IsNull())
      {
        m_hostedZones.push_back(hostedZonesMember);
        hostedZonesMember = hostedZonesMember.NextNode("HostedZone");
      }

    }
    XmlNode dNSNameNode = resultNode.FirstChild("DNSName");
    if(!dNSNameNode.IsNull())
    {
      m_dNSName = Aws::Utils::Xml::DecodeEscapedXmlText(dNSNameNode.GetText());
    }
    XmlNode hostedZoneIdNode = resultNode.FirstChild("HostedZoneId");
    if(!hostedZoneIdNode.IsNull())
    {
      m_hostedZoneId = Aws::Utils::Xml::DecodeEscapedXmlText(hostedZoneIdNode.GetText());
    }
    XmlNode isTruncatedNode = resultNode.FirstChild("IsTruncated");
    if(!isTruncatedNode.IsNull())
    {
      m_isTruncated = StringUtils::ConvertToBool(StringUtils::Trim(Aws::Utils::Xml::DecodeEscapedXmlText(isTruncatedNode.GetText()).c_str()).c_str());
    }
    XmlNode nextDNSNameNode = resultNode.FirstChild("NextDNSName");
    if(!nextDNSNameNode.IsNull())
    {
      m_nextDNSName = Aws::Utils::Xml::DecodeEscapedXmlText(nextDNSNameNode.GetText());
    }
    XmlNode nextHostedZoneIdNode = resultNode.FirstChild("NextHostedZoneId");
    if(!nextHostedZoneIdNode.IsNull())
    {
      m_nextHostedZoneId = Aws::Utils::Xml::DecodeEscapedXmlText(nextHostedZoneIdNode.GetText());
    }
    XmlNode maxItemsNode = resultNode.FirstChild("MaxItems");
    if(!maxItemsNode.IsNull())
    {
      m_maxItems = Aws::Utils::Xml::DecodeEscapedXmlText(maxItemsNode.GetText());
    }
  }

  return *this;
}
