﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/networkmanager/model/DisassociateTransitGatewayConnectPeerResult.h>
#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/core/AmazonWebServiceResult.h>
#include <aws/core/utils/StringUtils.h>
#include <aws/core/utils/UnreferencedParam.h>

#include <utility>

using namespace Aws::NetworkManager::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;
using namespace Aws;

DisassociateTransitGatewayConnectPeerResult::DisassociateTransitGatewayConnectPeerResult()
{
}

DisassociateTransitGatewayConnectPeerResult::DisassociateTransitGatewayConnectPeerResult(const Aws::AmazonWebServiceResult<JsonValue>& result)
{
  *this = result;
}

DisassociateTransitGatewayConnectPeerResult& DisassociateTransitGatewayConnectPeerResult::operator =(const Aws::AmazonWebServiceResult<JsonValue>& result)
{
  JsonView jsonValue = result.GetPayload().View();
  if(jsonValue.ValueExists("TransitGatewayConnectPeerAssociation"))
  {
    m_transitGatewayConnectPeerAssociation = jsonValue.GetObject("TransitGatewayConnectPeerAssociation");

  }



  return *this;
}
