﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/license-manager/model/DeleteLicenseResult.h>
#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/core/AmazonWebServiceResult.h>
#include <aws/core/utils/StringUtils.h>
#include <aws/core/utils/UnreferencedParam.h>

#include <utility>

using namespace Aws::LicenseManager::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;
using namespace Aws;

DeleteLicenseResult::DeleteLicenseResult() : 
    m_status(LicenseDeletionStatus::NOT_SET)
{
}

DeleteLicenseResult::DeleteLicenseResult(const Aws::AmazonWebServiceResult<JsonValue>& result) : 
    m_status(LicenseDeletionStatus::NOT_SET)
{
  *this = result;
}

DeleteLicenseResult& DeleteLicenseResult::operator =(const Aws::AmazonWebServiceResult<JsonValue>& result)
{
  JsonView jsonValue = result.GetPayload().View();
  if(jsonValue.ValueExists("Status"))
  {
    m_status = LicenseDeletionStatusMapper::GetLicenseDeletionStatusForName(jsonValue.GetString("Status"));

  }

  if(jsonValue.ValueExists("DeletionDate"))
  {
    m_deletionDate = jsonValue.GetString("DeletionDate");

  }



  return *this;
}
