﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/eks/model/ListUpdatesRequest.h>
#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/core/http/URI.h>
#include <aws/core/utils/memory/stl/AWSStringStream.h>

#include <utility>

using namespace Aws::EKS::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;
using namespace Aws::Http;

ListUpdatesRequest::ListUpdatesRequest() : 
    m_nameHasBeenSet(false),
    m_nodegroupNameHasBeenSet(false),
    m_addonNameHasBeenSet(false),
    m_nextTokenHasBeenSet(false),
    m_maxResults(0),
    m_maxResultsHasBeenSet(false)
{
}

Aws::String ListUpdatesRequest::SerializePayload() const
{
  return {};
}

void ListUpdatesRequest::AddQueryStringParameters(URI& uri) const
{
    Aws::StringStream ss;
    if(m_nodegroupNameHasBeenSet)
    {
      ss << m_nodegroupName;
      uri.AddQueryStringParameter("nodegroupName", ss.str());
      ss.str("");
    }

    if(m_addonNameHasBeenSet)
    {
      ss << m_addonName;
      uri.AddQueryStringParameter("addonName", ss.str());
      ss.str("");
    }

    if(m_nextTokenHasBeenSet)
    {
      ss << m_nextToken;
      uri.AddQueryStringParameter("nextToken", ss.str());
      ss.str("");
    }

    if(m_maxResultsHasBeenSet)
    {
      ss << m_maxResults;
      uri.AddQueryStringParameter("maxResults", ss.str());
      ss.str("");
    }

}



