#!/usr/bin/env bash

CLICKHOUSE_CLIENT_SERVER_LOGS_LEVEL=none

CURDIR=$(cd "$(dirname "${BASH_SOURCE[0]}")" && pwd)
# shellcheck source=../shell_config.sh
. "$CURDIR"/../shell_config.sh

echo "EXPLAIN AST ALTER TABLE t ADD COLUMN c Int8;
EXPLAIN AST ALTER TABLE t DROP COLUMN c;
EXPLAIN AST ALTER TABLE t MODIFY COLUMN c Int8;
EXPLAIN AST ALTER TABLE t COMMENT COLUMN c 'comment';
EXPLAIN AST ALTER TABLE t RENAME COLUMN c TO d;
EXPLAIN AST ALTER TABLE t MATERIALIZE COLUMN c;
EXPLAIN AST ALTER TABLE t MODIFY ORDER BY x;
EXPLAIN AST ALTER TABLE t MODIFY SAMPLE BY y;
EXPLAIN AST ALTER TABLE t MODIFY TTL z + INTERVAL 7 DAY;
EXPLAIN AST ALTER TABLE t MATERIALIZE TTL IN PARTITION 'p';
EXPLAIN AST ALTER TABLE t MODIFY SETTING index_granularity = 4096;
EXPLAIN AST ALTER TABLE t RESET SETTING index_granularity;
EXPLAIN AST ALTER TABLE t MODIFY QUERY SELECT 42;
EXPLAIN AST ALTER TABLE t REMOVE TTL;
EXPLAIN AST ALTER TABLE t REMOVE SAMPLE BY;
EXPLAIN AST ALTER TABLE t ADD INDEX i c TYPE minmax GRANULARITY 1;
EXPLAIN AST ALTER TABLE t DROP INDEX i;
EXPLAIN AST ALTER TABLE t MATERIALIZE INDEX i;
EXPLAIN AST ALTER TABLE t ADD CONSTRAINT x CHECK 1;
EXPLAIN AST ALTER TABLE t DROP CONSTRAINT x;
EXPLAIN AST ALTER TABLE t ADD PROJECTION p (SELECT c);
EXPLAIN AST ALTER TABLE t DROP PROJECTION p;
EXPLAIN AST ALTER TABLE t MATERIALIZE PROJECTION p;
EXPLAIN AST ALTER TABLE t DETACH PARTITION 'p';
EXPLAIN AST ALTER TABLE t DROP PARTITION 'p';
EXPLAIN AST ALTER TABLE t ATTACH PARTITION 'p';
EXPLAIN AST ALTER TABLE t ATTACH PART 'p';
EXPLAIN AST ALTER TABLE t ATTACH PARTITION 'p' FROM t2;
EXPLAIN AST ALTER TABLE t REPLACE PARTITION 'p' FROM t2;
EXPLAIN AST ALTER TABLE t MOVE PARTITION 'p' TO TABLE t2;
EXPLAIN AST ALTER TABLE t CLEAR COLUMN c IN PARTITION 'p';
EXPLAIN AST ALTER TABLE t FREEZE;
EXPLAIN AST ALTER TABLE t FREEZE PARTITION 'p';
EXPLAIN AST ALTER TABLE t UNFREEZE WITH NAME 'n';
EXPLAIN AST ALTER TABLE t UNFREEZE PARTITION 'p' WITH NAME 'n';
EXPLAIN AST ALTER TABLE t FETCH PARTITION 'p' FROM '/path';
EXPLAIN AST ALTER TABLE t FETCH PART 'p' FROM '/path';
EXPLAIN AST ALTER TABLE t UPDATE c = 1 WHERE 1;
EXPLAIN AST ALTER TABLE t UPDATE c = 1 IN PARTITION 'p' WHERE 1;
EXPLAIN AST ALTER TABLE t DELETE WHERE c = 1;
EXPLAIN AST ALTER TABLE t DELETE IN PARTITION 'p' WHERE c = 1;" | \
    $CLICKHOUSE_CLIENT --readonly 1 --multiquery 2>&1 | grep 'AlterCommand'
