-- Tags: long, no-fasttest
-- Tag no-fasttest: JSON functions

-- https://github.com/minimaxir/big-list-of-naughty-strings

/*
The MIT License (MIT)

Copyright (c) 2015-2020 Max Woolf

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.
*/

DROP TABLE IF EXISTS test;

CREATE TABLE test
(
  "undefined" String,
  "undef" String,
  "null" String,
  "NULL" String,
  "(null)" String,
  "nil" String,
  "NIL" String,
  "true" String,
  "false" String,
  "True" String,
  "False" String,
  "TRUE" String,
  "FALSE" String,
  "None" String,
  "hasOwnProperty" String,
  "then" String,
  "\\" String,
  "\\\\" String,
  "0" String,
  "1" String,
  "1.00" String,
  "$1.00" String,
  "1/2" String,
  "1E2" String,
  "1E02" String,
  "1E+02" String,
  "-1" String,
  "-1.00" String,
  "-$1.00" String,
  "-1/2" String,
  "-1E2" String,
  "-1E02" String,
  "-1E+02" String,
  "1/0" String,
  "0/0" String,
  "-2147483648/-1" String,
  "-9223372036854775808/-1" String,
  "-0" String,
  "-0.0" String,
  "+0" String,
  "+0.0" String,
  "0.00" String,
  "0..0" String,
  "." String,
  "0.0.0" String,
  "0,00" String,
  "0,,0" String,
  "," String,
  "0,0,0" String,
  "0.0/0" String,
  "1.0/0.0" String,
  "0.0/0.0" String,
  "1,0/0,0" String,
  "0,0/0,0" String,
  "--1" String,
  "-" String,
  "-." String,
  "-," String,
  "999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999" String,
  "NaN" String,
  "Infinity" String,
  "-Infinity" String,
  "INF" String,
  "1#INF" String,
  "-1#IND" String,
  "1#QNAN" String,
  "1#SNAN" String,
  "1#IND" String,
  "0x0" String,
  "0xffffffff" String,
  "0xffffffffffffffff" String,
  "0xabad1dea" String,
  "123456789012345678901234567890123456789" String,
  "1,000.00" String,
  "1 000.00" String,
  "1'000.00" String,
  "1,000,000.00" String,
  "1 000 000.00" String,
  "1'000'000.00" String,
  "1.000,00" String,
  "1 000,00" String,
  "1'000,00" String,
  "1.000.000,00" String,
  "1 000 000,00" String,
  "1'000'000,00" String,
  "01000" String,
  "08" String,
  "09" String,
  "2.2250738585072011e-308" String,
  ",./;'[]\\-=" String,
  "<>?:\"{}|_+" String,
  "!@#$%^&*()`~" String,
  "\u0001\u0002\u0003\u0004\u0005\u0006\u0007\b\u000e\u000f\u0010\u0011\u0012\u0013\u0014\u0015\u0016\u0017\u0018\u0019\u001a\u001b\u001c\u001d\u001e\u001f" String,
  "" String,
  "\t\u000b\f              ​    　" String,
  "­؀؁؂؃؄؅؜۝܏᠎​‌‍‎‏‪‫‬‭‮⁠⁡⁢⁣⁤⁦⁧⁨⁩⁪⁫⁬⁭⁮⁯﻿￹￺￻𑂽𛲠𛲡𛲢𛲣𝅳𝅴𝅵𝅶𝅷𝅸𝅹𝅺󠀁󠀠󠀡󠀢󠀣󠀤󠀥󠀦󠀧󠀨󠀩󠀪󠀫󠀬󠀭󠀮󠀯󠀰󠀱󠀲󠀳󠀴󠀵󠀶󠀷󠀸󠀹󠀺󠀻󠀼󠀽󠀾󠀿󠁀󠁁󠁂󠁃󠁄󠁅󠁆󠁇󠁈󠁉󠁊󠁋󠁌󠁍󠁎󠁏󠁐󠁑󠁒󠁓󠁔󠁕󠁖󠁗󠁘󠁙󠁚󠁛󠁜󠁝󠁞󠁟󠁠󠁡󠁢󠁣󠁤󠁥󠁦󠁧󠁨󠁩󠁪󠁫󠁬󠁭󠁮󠁯󠁰󠁱󠁲󠁳󠁴󠁵󠁶󠁷󠁸󠁹󠁺󠁻󠁼󠁽󠁾󠁿" String,
  "﻿" String,
  "￾" String,
  "Ω≈ç√∫˜µ≤≥÷" String,
  "åß∂ƒ©˙∆˚¬…æ" String,
  "œ∑´®†¥¨ˆøπ“‘" String,
  "¡™£¢∞§¶•ªº–≠" String,
  "¸˛Ç◊ı˜Â¯˘¿" String,
  "ÅÍÎÏ˝ÓÔÒÚÆ☃" String,
  "Œ„´‰ˇÁ¨ˆØ∏”’" String,
  "`⁄€‹›ﬁﬂ‡°·‚—±" String,
  "⅛⅜⅝⅞" String,
  "ЁЂЃЄЅІЇЈЉЊЋЌЍЎЏАБВГДЕЖЗИЙКЛМНОПРСТУФХЦЧШЩЪЫЬЭЮЯабвгдежзийклмнопрстуфхцчшщъыьэюя" String,
  "٠١٢٣٤٥٦٧٨٩" String,
  "⁰⁴⁵" String,
  "₀₁₂" String,
  "⁰⁴⁵₀₁₂" String,
  "ด้้้้้็็็็็้้้้้็็็็็้้้้้้้้็็็็็้้้้้็็็็็้้้้้้้้็็็็็้้้้้็็็็็้้้้้้้้็็็็็้้้้้็็็็ ด้้้้้็็็็็้้้้้็็็็็้้้้้้้้็็็็็้้้้้็็็็็้้้้้้้้็็็็็้้้้้็็็็็้้้้้้้้็็็็็้้้้้็็็็ ด้้้้้็็็็็้้้้้็็็็็้้้้้้้้็็็็็้้้้้็็็็็้้้้้้้้็็็็็้้้้้็็็็็้้้้้้้้็็็็็้้้้้็็็็" String,
  "'" String,
  "\"" String,
  "''" String,
  "\"\"" String,
  "'\"'" String,
  "\"''''\"'\"" String,
  "\"'\"'\"''''\"" String,
  "<foo val=“bar” />" String,
  "<foo val=”bar“ />" String,
  "<foo val=`bar' />" String,
  "田中さんにあげて下さい" String,
  "パーティーへ行かないか" String,
  "和製漢語" String,
  "部落格" String,
  "사회과학원 어학연구소" String,
  "찦차를 타고 온 펲시맨과 쑛다리 똠방각하" String,
  "社會科學院語學研究所" String,
  "울란바토르" String,
  "𠜎𠜱𠝹𠱓𠱸𠲖𠳏" String,
  "𐐜 𐐔𐐇𐐝𐐀𐐡𐐇𐐓 𐐙𐐊𐐡𐐝𐐓/𐐝𐐇𐐗𐐊𐐤𐐔 𐐒𐐋𐐗 𐐒𐐌 𐐜 𐐡𐐀𐐖𐐇𐐤𐐓𐐝 𐐱𐑂 𐑄 𐐔𐐇𐐝𐐀𐐡𐐇𐐓 𐐏𐐆𐐅𐐤𐐆𐐚𐐊𐐡𐐝𐐆𐐓𐐆" String,
  "表ポあA鷗ŒéＢ逍Üßªąñ丂㐀𠀀" String,
  "Ⱥ" String,
  "Ⱦ" String,
  "ヽ༼ຈل͜ຈ༽ﾉ ヽ༼ຈل͜ຈ༽ﾉ" String,
  "(｡◕ ∀ ◕｡)" String,
  "｀ｨ(´∀｀∩" String,
  "__ﾛ(,_,*)" String,
  "・(￣∀￣)・:*:" String,
  "ﾟ･✿ヾ╲(｡◕‿◕｡)╱✿･ﾟ" String,
  ",。・:*:・゜’( ☻ ω ☻ )。・:*:・゜’" String,
  "(╯°□°）╯︵ ┻━┻)" String,
  "(ﾉಥ益ಥ）ﾉ﻿ ┻━┻" String,
  "┬─┬ノ( º _ ºノ)" String,
  "( ͡° ͜ʖ ͡°)" String,
  "¯\\_(ツ)_/¯" String,
  "😍" String,
  "👩🏽" String,
  "👨‍🦰 👨🏿‍🦰 👨‍🦱 👨🏿‍🦱 🦹🏿‍♂️" String,
  "👾 🙇 💁 🙅 🙆 🙋 🙎 🙍" String,
  "🐵 🙈 🙉 🙊" String,
  "❤️ 💔 💌 💕 💞 💓 💗 💖 💘 💝 💟 💜 💛 💚 💙" String,
  "✋🏿 💪🏿 👐🏿 🙌🏿 👏🏿 🙏🏿" String,
  "👨‍👩‍👦 👨‍👩‍👧‍👦 👨‍👨‍👦 👩‍👩‍👧 👨‍👦 👨‍👧‍👦 👩‍👦 👩‍👧‍👦" String,
  "🚾 🆒 🆓 🆕 🆖 🆗 🆙 🏧" String,
  "0️⃣ 1️⃣ 2️⃣ 3️⃣ 4️⃣ 5️⃣ 6️⃣ 7️⃣ 8️⃣ 9️⃣ 🔟" String,
  "🇺🇸🇷🇺🇸 🇦🇫🇦🇲🇸" String,
  "🇺🇸🇷🇺🇸🇦🇫🇦🇲" String,
  "🇺🇸🇷🇺🇸🇦" String,
  "１２３" String,
  "١٢٣" String,
  "ثم نفس سقطت وبالتحديد،, جزيرتي باستخدام أن دنو. إذ هنا؟ الستار وتنصيب كان. أهّل ايطاليا، بريطانيا-فرنسا قد أخذ. سليمان، إتفاقية بين ما , يذكر الحدود أي بعد, معاملة بولندا، الإطلاق عل إيو." String,
  "בְּרֵאשִׁית, בָּרָא אֱלֹהִים, אֵת הַשָּׁמַיִם, וְאֵת הָאָרֶץ" String,
  "הָיְתָהtestالصفحات التّحول" String,
  "﷽" String,
  "ﷺ" String,
  "مُنَاقَشَةُ سُبُلِ اِسْتِخْدَامِ اللُّغَةِ فِي النُّظُمِ الْقَائِمَةِ وَفِيم يَخُصَّ التَّطْبِيقَاتُ الْحاسُوبِيَّةُ، " String,
  "᚛ᚄᚓᚐᚋᚒᚄ ᚑᚄᚂᚑᚏᚅ᚜‪‪‪" String,
  "‪‪᚛                 ᚜‪" String,
  "‪‪test‪" String,
  "‫test‫" String,
  " test " String,
  "test⁠test‫" String,
  "⁦test⁧" String,
  "Ṱ̺̺̕o͞ ̷i̲̬͇̪͙n̝̗͕v̟̜̘̦͟o̶̙̰̠kè͚̮̺̪̹̱̤ ̖t̝͕̳̣̻̪͞h̼͓̲̦̳̘̲e͇̣̰̦̬͎ ̢̼̻̱̘h͚͎͙̜̣̲ͅi̦̲̣̰̤v̻͍e̺̭̳̪̰-m̢iͅn̖̺̞̲̯̰d̵̼̟͙̩̼̘̳ ̞̥̱̳̭r̛̗̘e͙p͠r̼̞̻̭̗e̺̠̣͟s̘͇̳͍̝͉e͉̥̯̞̲͚̬͜ǹ̬͎͎̟̖͇̤t͍̬̤͓̼̭͘ͅi̪̱n͠g̴͉ ͏͉ͅc̬̟h͡a̫̻̯͘o̫̟̖͍̙̝͉s̗̦̲.̨̹͈̣" String,
  "̡͓̞ͅI̗̘̦͝n͇͇͙v̮̫ok̲̫̙͈i̖͙̭̹̠̞n̡̻̮̣̺g̲͈͙̭͙̬͎ ̰t͔̦h̞̲e̢̤ ͍̬̲͖f̴̘͕̣è͖ẹ̥̩l͖͔͚i͓͚̦͠n͖͍̗͓̳̮g͍ ̨o͚̪͡f̘̣̬ ̖̘͖̟͙̮c҉͔̫͖͓͇͖ͅh̵̤̣͚͔á̗̼͕ͅo̼̣̥s̱͈̺̖̦̻͢.̛̖̞̠̫̰" String,
  "̗̺͖̹̯͓Ṯ̤͍̥͇͈h̲́e͏͓̼̗̙̼̣͔ ͇̜̱̠͓͍ͅN͕͠e̗̱z̘̝̜̺͙p̤̺̹͍̯͚e̠̻̠͜r̨̤͍̺̖͔̖̖d̠̟̭̬̝͟i̦͖̩͓͔̤a̠̗̬͉̙n͚͜ ̻̞̰͚ͅh̵͉i̳̞v̢͇ḙ͎͟-҉̭̩̼͔m̤̭̫i͕͇̝̦n̗͙ḍ̟ ̯̲͕͞ǫ̟̯̰̲͙̻̝f ̪̰̰̗̖̭̘͘c̦͍̲̞͍̩̙ḥ͚a̮͎̟̙͜ơ̩̹͎s̤.̝̝ ҉Z̡̖̜͖̰̣͉̜a͖̰͙̬͡l̲̫̳͍̩g̡̟̼̱͚̞̬ͅo̗͜.̟" String,
  "̦H̬̤̗̤͝e͜ ̜̥̝̻͍̟́w̕h̖̯͓o̝͙̖͎̱̮ ҉̺̙̞̟͈W̷̼̭a̺̪͍į͈͕̭͙̯̜t̶̼̮s̘͙͖̕ ̠̫̠B̻͍͙͉̳ͅe̵h̵̬͇̫͙i̹͓̳̳̮͎̫̕n͟d̴̪̜̖ ̰͉̩͇͙̲͞ͅT͖̼͓̪͢h͏͓̮̻e̬̝̟ͅ ̤̹̝W͙̞̝͔͇͝ͅa͏͓͔̹̼̣l̴͔̰̤̟͔ḽ̫.͕" String,
  "Z̮̞̠͙͔ͅḀ̗̞͈̻̗Ḷ͙͎̯̹̞͓G̻O̭̗̮" String,
  "˙ɐnbᴉlɐ ɐuƃɐɯ ǝɹolop ʇǝ ǝɹoqɐl ʇn ʇunpᴉpᴉɔuᴉ ɹodɯǝʇ poɯsnᴉǝ op pǝs 'ʇᴉlǝ ƃuᴉɔsᴉdᴉpɐ ɹnʇǝʇɔǝsuoɔ 'ʇǝɯɐ ʇᴉs ɹolop ɯnsdᴉ ɯǝɹo˥" String,
  "00˙Ɩ$-" String,
  "Ｔｈｅ ｑｕｉｃｋ ｂｒｏｗｎ ｆｏｘ ｊｕｍｐｓ ｏｖｅｒ ｔｈｅ ｌａｚｙ ｄｏｇ" String,
  "𝐓𝐡𝐞 𝐪𝐮𝐢𝐜𝐤 𝐛𝐫𝐨𝐰𝐧 𝐟𝐨𝐱 𝐣𝐮𝐦𝐩𝐬 𝐨𝐯𝐞𝐫 𝐭𝐡𝐞 𝐥𝐚𝐳𝐲 𝐝𝐨𝐠" String,
  "𝕿𝖍𝖊 𝖖𝖚𝖎𝖈𝖐 𝖇𝖗𝖔𝖜𝖓 𝖋𝖔𝖝 𝖏𝖚𝖒𝖕𝖘 𝖔𝖛𝖊𝖗 𝖙𝖍𝖊 𝖑𝖆𝖟𝖞 𝖉𝖔𝖌" String,
  "𝑻𝒉𝒆 𝒒𝒖𝒊𝒄𝒌 𝒃𝒓𝒐𝒘𝒏 𝒇𝒐𝒙 𝒋𝒖𝒎𝒑𝒔 𝒐𝒗𝒆𝒓 𝒕𝒉𝒆 𝒍𝒂𝒛𝒚 𝒅𝒐𝒈" String,
  "𝓣𝓱𝓮 𝓺𝓾𝓲𝓬𝓴 𝓫𝓻𝓸𝔀𝓷 𝓯𝓸𝔁 𝓳𝓾𝓶𝓹𝓼 𝓸𝓿𝓮𝓻 𝓽𝓱𝓮 𝓵𝓪𝔃𝔂 𝓭𝓸𝓰" String,
  "𝕋𝕙𝕖 𝕢𝕦𝕚𝕔𝕜 𝕓𝕣𝕠𝕨𝕟 𝕗𝕠𝕩 𝕛𝕦𝕞𝕡𝕤 𝕠𝕧𝕖𝕣 𝕥𝕙𝕖 𝕝𝕒𝕫𝕪 𝕕𝕠𝕘" String,
  "𝚃𝚑𝚎 𝚚𝚞𝚒𝚌𝚔 𝚋𝚛𝚘𝚠𝚗 𝚏𝚘𝚡 𝚓𝚞𝚖𝚙𝚜 𝚘𝚟𝚎𝚛 𝚝𝚑𝚎 𝚕𝚊𝚣𝚢 𝚍𝚘𝚐" String,
  "⒯⒣⒠ ⒬⒰⒤⒞⒦ ⒝⒭⒪⒲⒩ ⒡⒪⒳ ⒥⒰⒨⒫⒮ ⒪⒱⒠⒭ ⒯⒣⒠ ⒧⒜⒵⒴ ⒟⒪⒢" String,
  "<script>alert(123)</script>" String,
  "&lt;script&gt;alert(&#39;123&#39;);&lt;/script&gt;" String,
  "<img src=x onerror=alert(123) />" String,
  "<svg><script>123<1>alert(123)</script>" String,
  "\"><script>alert(123)</script>" String,
  "'><script>alert(123)</script>" String,
  "><script>alert(123)</script>" String,
  "</script><script>alert(123)</script>" String,
  "< / script >< script >alert(123)< / script >" String,
  " onfocus=JaVaSCript:alert(123) autofocus" String,
  "\" onfocus=JaVaSCript:alert(123) autofocus" String,
  "' onfocus=JaVaSCript:alert(123) autofocus" String,
  "＜script＞alert(123)＜/script＞" String,
  "<sc<script>ript>alert(123)</sc</script>ript>" String,
  "--><script>alert(123)</script>" String,
  "\";alert(123);t=\"" String,
  "';alert(123);t='" String,
  "JavaSCript:alert(123)" String,
  ";alert(123);" String,
  "src=JaVaSCript:prompt(132)" String,
  "\"><script>alert(123);</script x=\"" String,
  "'><script>alert(123);</script x='" String,
  "><script>alert(123);</script x=" String,
  "\" autofocus onkeyup=\"javascript:alert(123)" String,
  "' autofocus onkeyup='javascript:alert(123)" String,
  "<script\\x20type=\"text/javascript\">javascript:alert(1);</script>" String,
  "<script\\x3Etype=\"text/javascript\">javascript:alert(1);</script>" String,
  "<script\\x0Dtype=\"text/javascript\">javascript:alert(1);</script>" String,
  "<script\\x09type=\"text/javascript\">javascript:alert(1);</script>" String,
  "<script\\x0Ctype=\"text/javascript\">javascript:alert(1);</script>" String,
  "<script\\x2Ftype=\"text/javascript\">javascript:alert(1);</script>" String,
  "<script\\x0Atype=\"text/javascript\">javascript:alert(1);</script>" String,
  "'`\"><\\x3Cscript>javascript:alert(1)</script>" String,
  "'`\"><\\x00script>javascript:alert(1)</script>" String,
  "ABC<div style=\"x\\x3Aexpression(javascript:alert(1)\">DEF" String,
  "ABC<div style=\"x:expression\\x5C(javascript:alert(1)\">DEF" String,
  "ABC<div style=\"x:expression\\x00(javascript:alert(1)\">DEF" String,
  "ABC<div style=\"x:exp\\x00ression(javascript:alert(1)\">DEF" String,
  "ABC<div style=\"x:exp\\x5Cression(javascript:alert(1)\">DEF" String,
  "ABC<div style=\"x:\\x0Aexpression(javascript:alert(1)\">DEF" String,
  "ABC<div style=\"x:\\x09expression(javascript:alert(1)\">DEF" String,
  "ABC<div style=\"x:\\xE3\\x80\\x80expression(javascript:alert(1)\">DEF" String,
  "ABC<div style=\"x:\\xE2\\x80\\x84expression(javascript:alert(1)\">DEF" String,
  "ABC<div style=\"x:\\xC2\\xA0expression(javascript:alert(1)\">DEF" String,
  "ABC<div style=\"x:\\xE2\\x80\\x80expression(javascript:alert(1)\">DEF" String,
  "ABC<div style=\"x:\\xE2\\x80\\x8Aexpression(javascript:alert(1)\">DEF" String,
  "ABC<div style=\"x:\\x0Dexpression(javascript:alert(1)\">DEF" String,
  "ABC<div style=\"x:\\x0Cexpression(javascript:alert(1)\">DEF" String,
  "ABC<div style=\"x:\\xE2\\x80\\x87expression(javascript:alert(1)\">DEF" String,
  "ABC<div style=\"x:\\xEF\\xBB\\xBFexpression(javascript:alert(1)\">DEF" String,
  "ABC<div style=\"x:\\x20expression(javascript:alert(1)\">DEF" String,
  "ABC<div style=\"x:\\xE2\\x80\\x88expression(javascript:alert(1)\">DEF" String,
  "ABC<div style=\"x:\\x00expression(javascript:alert(1)\">DEF" String,
  "ABC<div style=\"x:\\xE2\\x80\\x8Bexpression(javascript:alert(1)\">DEF" String,
  "ABC<div style=\"x:\\xE2\\x80\\x86expression(javascript:alert(1)\">DEF" String,
  "ABC<div style=\"x:\\xE2\\x80\\x85expression(javascript:alert(1)\">DEF" String,
  "ABC<div style=\"x:\\xE2\\x80\\x82expression(javascript:alert(1)\">DEF" String,
  "ABC<div style=\"x:\\x0Bexpression(javascript:alert(1)\">DEF" String,
  "ABC<div style=\"x:\\xE2\\x80\\x81expression(javascript:alert(1)\">DEF" String,
  "ABC<div style=\"x:\\xE2\\x80\\x83expression(javascript:alert(1)\">DEF" String,
  "ABC<div style=\"x:\\xE2\\x80\\x89expression(javascript:alert(1)\">DEF" String,
  "<a href=\"\\x0Bjavascript:javascript:alert(1)\" id=\"fuzzelement1\">test</a>" String,
  "<a href=\"\\x0Fjavascript:javascript:alert(1)\" id=\"fuzzelement1\">test</a>" String,
  "<a href=\"\\xC2\\xA0javascript:javascript:alert(1)\" id=\"fuzzelement1\">test</a>" String,
  "<a href=\"\\x05javascript:javascript:alert(1)\" id=\"fuzzelement1\">test</a>" String,
  "<a href=\"\\xE1\\xA0\\x8Ejavascript:javascript:alert(1)\" id=\"fuzzelement1\">test</a>" String,
  "<a href=\"\\x18javascript:javascript:alert(1)\" id=\"fuzzelement1\">test</a>" String,
  "<a href=\"\\x11javascript:javascript:alert(1)\" id=\"fuzzelement1\">test</a>" String,
  "<a href=\"\\xE2\\x80\\x88javascript:javascript:alert(1)\" id=\"fuzzelement1\">test</a>" String,
  "<a href=\"\\xE2\\x80\\x89javascript:javascript:alert(1)\" id=\"fuzzelement1\">test</a>" String,
  "<a href=\"\\xE2\\x80\\x80javascript:javascript:alert(1)\" id=\"fuzzelement1\">test</a>" String,
  "<a href=\"\\x17javascript:javascript:alert(1)\" id=\"fuzzelement1\">test</a>" String,
  "<a href=\"\\x03javascript:javascript:alert(1)\" id=\"fuzzelement1\">test</a>" String,
  "<a href=\"\\x0Ejavascript:javascript:alert(1)\" id=\"fuzzelement1\">test</a>" String,
  "<a href=\"\\x1Ajavascript:javascript:alert(1)\" id=\"fuzzelement1\">test</a>" String,
  "<a href=\"\\x00javascript:javascript:alert(1)\" id=\"fuzzelement1\">test</a>" String,
  "<a href=\"\\x10javascript:javascript:alert(1)\" id=\"fuzzelement1\">test</a>" String,
  "<a href=\"\\xE2\\x80\\x82javascript:javascript:alert(1)\" id=\"fuzzelement1\">test</a>" String,
  "<a href=\"\\x20javascript:javascript:alert(1)\" id=\"fuzzelement1\">test</a>" String,
  "<a href=\"\\x13javascript:javascript:alert(1)\" id=\"fuzzelement1\">test</a>" String,
  "<a href=\"\\x09javascript:javascript:alert(1)\" id=\"fuzzelement1\">test</a>" String,
  "<a href=\"\\xE2\\x80\\x8Ajavascript:javascript:alert(1)\" id=\"fuzzelement1\">test</a>" String,
  "<a href=\"\\x14javascript:javascript:alert(1)\" id=\"fuzzelement1\">test</a>" String,
  "<a href=\"\\x19javascript:javascript:alert(1)\" id=\"fuzzelement1\">test</a>" String,
  "<a href=\"\\xE2\\x80\\xAFjavascript:javascript:alert(1)\" id=\"fuzzelement1\">test</a>" String,
  "<a href=\"\\x1Fjavascript:javascript:alert(1)\" id=\"fuzzelement1\">test</a>" String,
  "<a href=\"\\xE2\\x80\\x81javascript:javascript:alert(1)\" id=\"fuzzelement1\">test</a>" String,
  "<a href=\"\\x1Djavascript:javascript:alert(1)\" id=\"fuzzelement1\">test</a>" String,
  "<a href=\"\\xE2\\x80\\x87javascript:javascript:alert(1)\" id=\"fuzzelement1\">test</a>" String,
  "<a href=\"\\x07javascript:javascript:alert(1)\" id=\"fuzzelement1\">test</a>" String,
  "<a href=\"\\xE1\\x9A\\x80javascript:javascript:alert(1)\" id=\"fuzzelement1\">test</a>" String,
  "<a href=\"\\xE2\\x80\\x83javascript:javascript:alert(1)\" id=\"fuzzelement1\">test</a>" String,
  "<a href=\"\\x04javascript:javascript:alert(1)\" id=\"fuzzelement1\">test</a>" String,
  "<a href=\"\\x01javascript:javascript:alert(1)\" id=\"fuzzelement1\">test</a>" String,
  "<a href=\"\\x08javascript:javascript:alert(1)\" id=\"fuzzelement1\">test</a>" String,
  "<a href=\"\\xE2\\x80\\x84javascript:javascript:alert(1)\" id=\"fuzzelement1\">test</a>" String,
  "<a href=\"\\xE2\\x80\\x86javascript:javascript:alert(1)\" id=\"fuzzelement1\">test</a>" String,
  "<a href=\"\\xE3\\x80\\x80javascript:javascript:alert(1)\" id=\"fuzzelement1\">test</a>" String,
  "<a href=\"\\x12javascript:javascript:alert(1)\" id=\"fuzzelement1\">test</a>" String,
  "<a href=\"\\x0Djavascript:javascript:alert(1)\" id=\"fuzzelement1\">test</a>" String,
  "<a href=\"\\x0Ajavascript:javascript:alert(1)\" id=\"fuzzelement1\">test</a>" String,
  "<a href=\"\\x0Cjavascript:javascript:alert(1)\" id=\"fuzzelement1\">test</a>" String,
  "<a href=\"\\x15javascript:javascript:alert(1)\" id=\"fuzzelement1\">test</a>" String,
  "<a href=\"\\xE2\\x80\\xA8javascript:javascript:alert(1)\" id=\"fuzzelement1\">test</a>" String,
  "<a href=\"\\x16javascript:javascript:alert(1)\" id=\"fuzzelement1\">test</a>" String,
  "<a href=\"\\x02javascript:javascript:alert(1)\" id=\"fuzzelement1\">test</a>" String,
  "<a href=\"\\x1Bjavascript:javascript:alert(1)\" id=\"fuzzelement1\">test</a>" String,
  "<a href=\"\\x06javascript:javascript:alert(1)\" id=\"fuzzelement1\">test</a>" String,
  "<a href=\"\\xE2\\x80\\xA9javascript:javascript:alert(1)\" id=\"fuzzelement1\">test</a>" String,
  "<a href=\"\\xE2\\x80\\x85javascript:javascript:alert(1)\" id=\"fuzzelement1\">test</a>" String,
  "<a href=\"\\x1Ejavascript:javascript:alert(1)\" id=\"fuzzelement1\">test</a>" String,
  "<a href=\"\\xE2\\x81\\x9Fjavascript:javascript:alert(1)\" id=\"fuzzelement1\">test</a>" String,
  "<a href=\"\\x1Cjavascript:javascript:alert(1)\" id=\"fuzzelement1\">test</a>" String,
  "<a href=\"javascript\\x00:javascript:alert(1)\" id=\"fuzzelement1\">test</a>" String,
  "<a href=\"javascript\\x3A:javascript:alert(1)\" id=\"fuzzelement1\">test</a>" String,
  "<a href=\"javascript\\x09:javascript:alert(1)\" id=\"fuzzelement1\">test</a>" String,
  "<a href=\"javascript\\x0D:javascript:alert(1)\" id=\"fuzzelement1\">test</a>" String,
  "<a href=\"javascript\\x0A:javascript:alert(1)\" id=\"fuzzelement1\">test</a>" String,
  "`\"'><img src=xxx:x \\x0Aonerror=javascript:alert(1)>" String,
  "`\"'><img src=xxx:x \\x22onerror=javascript:alert(1)>" String,
  "`\"'><img src=xxx:x \\x0Bonerror=javascript:alert(1)>" String,
  "`\"'><img src=xxx:x \\x0Donerror=javascript:alert(1)>" String,
  "`\"'><img src=xxx:x \\x2Fonerror=javascript:alert(1)>" String,
  "`\"'><img src=xxx:x \\x09onerror=javascript:alert(1)>" String,
  "`\"'><img src=xxx:x \\x0Conerror=javascript:alert(1)>" String,
  "`\"'><img src=xxx:x \\x00onerror=javascript:alert(1)>" String,
  "`\"'><img src=xxx:x \\x27onerror=javascript:alert(1)>" String,
  "`\"'><img src=xxx:x \\x20onerror=javascript:alert(1)>" String,
  "\"`'><script>\\x3Bjavascript:alert(1)</script>" String,
  "\"`'><script>\\x0Djavascript:alert(1)</script>" String,
  "\"`'><script>\\xEF\\xBB\\xBFjavascript:alert(1)</script>" String,
  "\"`'><script>\\xE2\\x80\\x81javascript:alert(1)</script>" String,
  "\"`'><script>\\xE2\\x80\\x84javascript:alert(1)</script>" String,
  "\"`'><script>\\xE3\\x80\\x80javascript:alert(1)</script>" String,
  "\"`'><script>\\x09javascript:alert(1)</script>" String,
  "\"`'><script>\\xE2\\x80\\x89javascript:alert(1)</script>" String,
  "\"`'><script>\\xE2\\x80\\x85javascript:alert(1)</script>" String,
  "\"`'><script>\\xE2\\x80\\x88javascript:alert(1)</script>" String,
  "\"`'><script>\\x00javascript:alert(1)</script>" String,
  "\"`'><script>\\xE2\\x80\\xA8javascript:alert(1)</script>" String,
  "\"`'><script>\\xE2\\x80\\x8Ajavascript:alert(1)</script>" String,
  "\"`'><script>\\xE1\\x9A\\x80javascript:alert(1)</script>" String,
  "\"`'><script>\\x0Cjavascript:alert(1)</script>" String,
  "\"`'><script>\\x2Bjavascript:alert(1)</script>" String,
  "\"`'><script>\\xF0\\x90\\x96\\x9Ajavascript:alert(1)</script>" String,
  "\"`'><script>-javascript:alert(1)</script>" String,
  "\"`'><script>\\x0Ajavascript:alert(1)</script>" String,
  "\"`'><script>\\xE2\\x80\\xAFjavascript:alert(1)</script>" String,
  "\"`'><script>\\x7Ejavascript:alert(1)</script>" String,
  "\"`'><script>\\xE2\\x80\\x87javascript:alert(1)</script>" String,
  "\"`'><script>\\xE2\\x81\\x9Fjavascript:alert(1)</script>" String,
  "\"`'><script>\\xE2\\x80\\xA9javascript:alert(1)</script>" String,
  "\"`'><script>\\xC2\\x85javascript:alert(1)</script>" String,
  "\"`'><script>\\xEF\\xBF\\xAEjavascript:alert(1)</script>" String,
  "\"`'><script>\\xE2\\x80\\x83javascript:alert(1)</script>" String,
  "\"`'><script>\\xE2\\x80\\x8Bjavascript:alert(1)</script>" String,
  "\"`'><script>\\xEF\\xBF\\xBEjavascript:alert(1)</script>" String,
  "\"`'><script>\\xE2\\x80\\x80javascript:alert(1)</script>" String,
  "\"`'><script>\\x21javascript:alert(1)</script>" String,
  "\"`'><script>\\xE2\\x80\\x82javascript:alert(1)</script>" String,
  "\"`'><script>\\xE2\\x80\\x86javascript:alert(1)</script>" String,
  "\"`'><script>\\xE1\\xA0\\x8Ejavascript:alert(1)</script>" String,
  "\"`'><script>\\x0Bjavascript:alert(1)</script>" String,
  "\"`'><script>\\x20javascript:alert(1)</script>" String,
  "\"`'><script>\\xC2\\xA0javascript:alert(1)</script>" String,
  "<img \\x00src=x onerror=\"alert(1)\">" String,
  "<img \\x47src=x onerror=\"javascript:alert(1)\">" String,
  "<img \\x11src=x onerror=\"javascript:alert(1)\">" String,
  "<img \\x12src=x onerror=\"javascript:alert(1)\">" String,
  "<img\\x47src=x onerror=\"javascript:alert(1)\">" String,
  "<img\\x10src=x onerror=\"javascript:alert(1)\">" String,
  "<img\\x13src=x onerror=\"javascript:alert(1)\">" String,
  "<img\\x32src=x onerror=\"javascript:alert(1)\">" String,
  "<img\\x11src=x onerror=\"javascript:alert(1)\">" String,
  "<img \\x34src=x onerror=\"javascript:alert(1)\">" String,
  "<img \\x39src=x onerror=\"javascript:alert(1)\">" String,
  "<img \\x00src=x onerror=\"javascript:alert(1)\">" String,
  "<img src\\x09=x onerror=\"javascript:alert(1)\">" String,
  "<img src\\x10=x onerror=\"javascript:alert(1)\">" String,
  "<img src\\x13=x onerror=\"javascript:alert(1)\">" String,
  "<img src\\x32=x onerror=\"javascript:alert(1)\">" String,
  "<img src\\x12=x onerror=\"javascript:alert(1)\">" String,
  "<img src\\x11=x onerror=\"javascript:alert(1)\">" String,
  "<img src\\x00=x onerror=\"javascript:alert(1)\">" String,
  "<img src\\x47=x onerror=\"javascript:alert(1)\">" String,
  "<img src=x\\x09onerror=\"javascript:alert(1)\">" String,
  "<img src=x\\x10onerror=\"javascript:alert(1)\">" String,
  "<img src=x\\x11onerror=\"javascript:alert(1)\">" String,
  "<img src=x\\x12onerror=\"javascript:alert(1)\">" String,
  "<img src=x\\x13onerror=\"javascript:alert(1)\">" String,
  "<img[a][b][c]src[d]=x[e]onerror=[f]\"alert(1)\">" String,
  "<img src=x onerror=\\x09\"javascript:alert(1)\">" String,
  "<img src=x onerror=\\x10\"javascript:alert(1)\">" String,
  "<img src=x onerror=\\x11\"javascript:alert(1)\">" String,
  "<img src=x onerror=\\x12\"javascript:alert(1)\">" String,
  "<img src=x onerror=\\x32\"javascript:alert(1)\">" String,
  "<img src=x onerror=\\x00\"javascript:alert(1)\">" String,
  "<a href=java&#1&#2&#3&#4&#5&#6&#7&#8&#11&#12script:javascript:alert(1)>XXX</a>" String,
  "<img src=\"x` `<script>javascript:alert(1)</script>\"` `>" String,
  "<img src onerror /\" '\"= alt=javascript:alert(1)//\">" String,
  "<title onpropertychange=javascript:alert(1)></title><title title=>" String,
  "<a href=http://foo.bar/#x=`y></a><img alt=\"`><img src=x:x onerror=javascript:alert(1)></a>\">" String,
  "<!--[if]><script>javascript:alert(1)</script -->" String,
  "<!--[if<img src=x onerror=javascript:alert(1)//]> -->" String,
  "<script src=\"/\\%(jscript)s\"></script>" String,
  "<script src=\"\\\\%(jscript)s\"></script>" String,
  "<IMG \"\"\"><SCRIPT>alert(\"XSS\")</SCRIPT>\">" String,
  "<IMG SRC=javascript:alert(String.fromCharCode(88,83,83))>" String,
  "<IMG SRC=# onmouseover=\"alert('xxs')\">" String,
  "<IMG SRC= onmouseover=\"alert('xxs')\">" String,
  "<IMG onmouseover=\"alert('xxs')\">" String,
  "<IMG SRC=&#106;&#97;&#118;&#97;&#115;&#99;&#114;&#105;&#112;&#116;&#58;&#97;&#108;&#101;&#114;&#116;&#40;&#39;&#88;&#83;&#83;&#39;&#41;>" String,
  "<IMG SRC=&#0000106&#0000097&#0000118&#0000097&#0000115&#0000099&#0000114&#0000105&#0000112&#0000116&#0000058&#0000097&#0000108&#0000101&#0000114&#0000116&#0000040&#0000039&#0000088&#0000083&#0000083&#0000039&#0000041>" String,
  "<IMG SRC=&#x6A&#x61&#x76&#x61&#x73&#x63&#x72&#x69&#x70&#x74&#x3A&#x61&#x6C&#x65&#x72&#x74&#x28&#x27&#x58&#x53&#x53&#x27&#x29>" String,
  "<IMG SRC=\"jav   ascript:alert('XSS');\">" String,
  "<IMG SRC=\"jav&#x09;ascript:alert('XSS');\">" String,
  "<IMG SRC=\"jav&#x0A;ascript:alert('XSS');\">" String,
  "<IMG SRC=\"jav&#x0D;ascript:alert('XSS');\">" String,
  "perl -e 'print \"<IMG SRC=java\\0script:alert(\\\"XSS\\\")>\";' > out" String,
  "<IMG SRC=\" &#14;  javascript:alert('XSS');\">" String,
  "<SCRIPT/XSS SRC=\"http://ha.ckers.org/xss.js\"></SCRIPT>" String,
  "<BODY onload!#$%&()*~+-_.,:;?@[/|\\]^`=alert(\"XSS\")>" String,
  "<SCRIPT/SRC=\"http://ha.ckers.org/xss.js\"></SCRIPT>" String,
  "<<SCRIPT>alert(\"XSS\");//<</SCRIPT>" String,
  "<SCRIPT SRC=http://ha.ckers.org/xss.js?< B >" String,
  "<SCRIPT SRC=//ha.ckers.org/.j>" String,
  "<IMG SRC=\"javascript:alert('XSS')\"" String,
  "<iframe src=http://ha.ckers.org/scriptlet.html <" String,
  "\\\";alert('XSS');//" String,
  "<u oncopy=alert()> Copy me</u>" String,
  "<i onwheel=alert(1)> Scroll over me </i>" String,
  "<plaintext>" String,
  "http://a/%%30%30" String,
  "</textarea><script>alert(123)</script>" String,
  "1;DROP TABLE users" String,
  "1'; DROP TABLE users-- 1" String,
  "' OR 1=1 -- 1" String,
  "' OR '1'='1" String,
  "'; EXEC sp_MSForEachTable 'DROP TABLE ?'; --" String,
  " " String,
  "%" String,
  "_" String,
  "--" String,
  "--version" String,
  "--help" String,
  "$USER" String,
  "/dev/null; touch /tmp/blns.fail ; echo" String,
  "`touch /tmp/blns.fail`" String,
  "$(touch /tmp/blns.fail)" String,
  "@{[system \"touch /tmp/blns.fail\"]}" String,
  "eval(\"puts 'hello world'\")" String,
  "System(\"ls -al /\")" String,
  "`ls -al /`" String,
  "Kernel.exec(\"ls -al /\")" String,
  "Kernel.exit(1)" String,
  "%x('ls -al /')" String,
  "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?><!DOCTYPE foo [ <!ELEMENT foo ANY ><!ENTITY xxe SYSTEM \"file:///etc/passwd\" >]><foo>&xxe;</foo>" String,
  "$HOME" String,
  "$ENV{'HOME'}" String,
  "%d" String,
  "%s%s%s%s%s" String,
  "{0}" String,
  "%*.*s" String,
  "%@" String,
  "%n" String,
  "File:///" String,
  "../../../../../../../../../../../etc/passwd%00" String,
  "../../../../../../../../../../../etc/hosts" String,
  "() { 0; }; touch /tmp/blns.shellshock1.fail;" String,
  "() { _; } >_[$($())] { touch /tmp/blns.shellshock2.fail; }" String,
  "<<< %s(un='%s') = %u" String,
  "+++ATH0" String,
  "CON" String,
  "PRN" String,
  "AUX" String,
  "CLOCK$" String,
  "NUL" String,
  "A:" String,
  "ZZ:" String,
  "COM1" String,
  "LPT1" String,
  "LPT2" String,
  "LPT3" String,
  "COM2" String,
  "COM3" String,
  "COM4" String,
  "DCC SEND STARTKEYLOGGER 0 0 0" String,
  "Scunthorpe General Hospital" String,
  "Penistone Community Church" String,
  "Lightwater Country Park" String,
  "Jimmy Clitheroe" String,
  "Horniman Museum" String,
  "shitake mushrooms" String,
  "RomansInSussex.co.uk" String,
  "http://www.cum.qc.ca/" String,
  "Craig Cockburn, Software Specialist" String,
  "Linda Callahan" String,
  "Dr. Herman I. Libshitz" String,
  "magna cum laude" String,
  "Super Bowl XXX" String,
  "medieval erection of parapets" String,
  "evaluate" String,
  "mocha" String,
  "expression" String,
  "Arsenal canal" String,
  "classic" String,
  "Tyson Gay" String,
  "Dick Van Dyke" String,
  "basement" String,
  "If you're reading this, you've been in a coma for almost 20 years now. We're trying a new technique. We don't know where this message will end up in your dream, but we hope it works. Please wake up, we miss you." String,
  "Roses are \u001b[0;31mred\u001b[0m, violets are \u001b[0;34mblue. Hope you enjoy terminal hue" String,
  "But now...\u001b[20Cfor my greatest trick...\u001b[8m" String,
  "The quic\b\b\b\b\b\bk brown fo\u0007\u0007\u0007\u0007\u0007\u0007\u0007\u0007\u0007\u0007\u0007x... [Beeeep]" String,
  "Powerلُلُصّبُلُلصّبُررً ॣ ॣh ॣ ॣ冗" String,
  "🏳0🌈️" String,
  "జ్ఞ‌ా" String,
  "گچپژ" String,
  "{% print 'x' * 64 * 1024**3 %}" String,
  "{{ \"\".__class__.__mro__[2].__subclasses__()[40](\"/etc/passwd\").read() }}" String
) ENGINE = MergeTree ORDER BY "{{ \"\".__class__.__mro__[2].__subclasses__()[40](\"/etc/passwd\").read() }}" SETTINGS min_bytes_for_wide_part = '100G';

INSERT INTO test ("0") SELECT 'Hello, world!';
SELECT count() FROM test;

DETACH TABLE test;
ATTACH TABLE test;

SELECT count() FROM test;

INSERT INTO test ("0") VALUES ('Hello, world!');
SELECT count() FROM test;

DROP TABLE IF EXISTS test_r1;
DROP TABLE IF EXISTS test_r2;

CREATE TABLE test_r1 AS test ENGINE = ReplicatedMergeTree('/clickhouse/{database}/test_01666', 'r1') ORDER BY "\\" SETTINGS min_bytes_for_wide_part = '100G';
INSERT INTO test_r1 SELECT * FROM test;
CREATE TABLE test_r2 AS test ENGINE = ReplicatedMergeTree('/clickhouse/{database}/test_01666', 'r2') ORDER BY "\\" SETTINGS min_bytes_for_wide_part = '100G';

SYSTEM SYNC REPLICA test_r2;

SELECT count() FROM test_r1;
SELECT count() FROM test_r2;

DROP TABLE test_r1;
DROP TABLE test_r2;

SELECT groupArray(name) FROM system.columns WHERE database = currentDatabase() AND table = 'test';

DROP TABLE test;

SELECT 'undefined','undef','null','NULL','(null)','nil','NIL','true','false','True','False','TRUE','FALSE','None','hasOwnProperty','then','\\','\\\\','0','1','1.00','$1.00','1/2','1E2','1E02','1E+02','-1','-1.00','-$1.00','-1/2','-1E2','-1E02','-1E+02','1/0','0/0','-2147483648/-1','-9223372036854775808/-1','-0','-0.0','+0','+0.0','0.00','0..0','.','0.0.0','0,00','0,,0',',','0,0,0','0.0/0','1.0/0.0','0.0/0.0','1,0/0,0','0,0/0,0','--1','-','-.','-,','999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999','NaN','Infinity','-Infinity','INF','1#INF','-1#IND','1#QNAN','1#SNAN','1#IND','0x0','0xffffffff','0xffffffffffffffff','0xabad1dea','123456789012345678901234567890123456789','1,000.00','1 000.00','1\'000.00','1,000,000.00','1 000 000.00','1\'000\'000.00','1.000,00','1 000,00','1\'000,00','1.000.000,00','1 000 000,00','1\'000\'000,00','01000','08','09','2.2250738585072011e-308',',./;\'[]\\-=','<>?:"{}|_+','!@#$%^&*()`~','\\u0001\\u0002\\u0003\\u0004\\u0005\\u0006\\u0007\b\\u000e\\u000f\\u0010\\u0011\\u0012\\u0013\\u0014\\u0015\\u0016\\u0017\\u0018\\u0019\\u001a\\u001b\\u001c\\u001d\\u001e\\u001f','','\t\\u000b\f              ​    　','­؀؁؂؃؄؅؜۝܏᠎​‌‍‎‏‪‫‬‭‮⁠⁡⁢⁣⁤⁦⁧⁨⁩⁪⁫⁬⁭⁮⁯﻿￹￺￻𑂽𛲠𛲡𛲢𛲣𝅳𝅴𝅵𝅶𝅷𝅸𝅹𝅺󠀁󠀠󠀡󠀢󠀣󠀤󠀥󠀦󠀧󠀨󠀩󠀪󠀫󠀬󠀭󠀮󠀯󠀰󠀱󠀲󠀳󠀴󠀵󠀶󠀷󠀸󠀹󠀺󠀻󠀼󠀽󠀾󠀿󠁀󠁁󠁂󠁃󠁄󠁅󠁆󠁇󠁈󠁉󠁊󠁋󠁌󠁍󠁎󠁏󠁐󠁑󠁒󠁓󠁔󠁕󠁖󠁗󠁘󠁙󠁚󠁛󠁜󠁝󠁞󠁟󠁠󠁡󠁢󠁣󠁤󠁥󠁦󠁧󠁨󠁩󠁪󠁫󠁬󠁭󠁮󠁯󠁰󠁱󠁲󠁳󠁴󠁵󠁶󠁷󠁸󠁹󠁺󠁻󠁼󠁽󠁾󠁿','﻿','￾','Ω≈ç√∫˜µ≤≥÷','åß∂ƒ©˙∆˚¬…æ','œ∑´®†¥¨ˆøπ“‘','¡™£¢∞§¶•ªº–≠','¸˛Ç◊ı˜Â¯˘¿','ÅÍÎÏ˝ÓÔÒÚÆ☃','Œ„´‰ˇÁ¨ˆØ∏”’','`⁄€‹›ﬁﬂ‡°·‚—±','⅛⅜⅝⅞','ЁЂЃЄЅІЇЈЉЊЋЌЍЎЏАБВГДЕЖЗИЙКЛМНОПРСТУФХЦЧШЩЪЫЬЭЮЯабвгдежзийклмнопрстуфхцчшщъыьэюя','٠١٢٣٤٥٦٧٨٩','⁰⁴⁵','₀₁₂','⁰⁴⁵₀₁₂','ด้้้้้็็็็็้้้้้็็็็็้้้้้้้้็็็็็้้้้้็็็็็้้้้้้้้็็็็็้้้้้็็็็็้้้้้้้้็็็็็้้้้้็็็็ ด้้้้้็็็็็้้้้้็็็็็้้้้้้้้็็็็็้้้้้็็็็็้้้้้้้้็็็็็้้้้้็็็็็้้้้้้้้็็็็็้้้้้็็็็ ด้้้้้็็็็็้้้้้็็็็็้้้้้้้้็็็็็้้้้้็็็็็้้้้้้้้็็็็็้้้้้็็็็็้้้้้้้้็็็็็้้้้้็็็็','\'','"','\'\'','""','\'"\'','"\'\'\'\'"\'"','"\'"\'"\'\'\'\'"','<foo val=“bar” />','<foo val=”bar“ />','<foo val=`bar\' />','田中さんにあげて下さい','パーティーへ行かないか','和製漢語','部落格','사회과학원 어학연구소','찦차를 타고 온 펲시맨과 쑛다리 똠방각하','社會科學院語學研究所','울란바토르','𠜎𠜱𠝹𠱓𠱸𠲖𠳏','𐐜 𐐔𐐇𐐝𐐀𐐡𐐇𐐓 𐐙𐐊𐐡𐐝𐐓/𐐝𐐇𐐗𐐊𐐤𐐔 𐐒𐐋𐐗 𐐒𐐌 𐐜 𐐡𐐀𐐖𐐇𐐤𐐓𐐝 𐐱𐑂 𐑄 𐐔𐐇𐐝𐐀𐐡𐐇𐐓 𐐏𐐆𐐅𐐤𐐆𐐚𐐊𐐡𐐝𐐆𐐓𐐆','表ポあA鷗ŒéＢ逍Üßªąñ丂㐀𠀀','Ⱥ','Ⱦ','ヽ༼ຈل͜ຈ༽ﾉ ヽ༼ຈل͜ຈ༽ﾉ','(｡◕ ∀ ◕｡)','｀ｨ(´∀｀∩','__ﾛ(,_,*)','・(￣∀￣)・:*:','ﾟ･✿ヾ╲(｡◕‿◕｡)╱✿･ﾟ',',。・:*:・゜’( ☻ ω ☻ )。・:*:・゜’','(╯°□°）╯︵ ┻━┻)','(ﾉಥ益ಥ）ﾉ﻿ ┻━┻','┬─┬ノ( º _ ºノ)','( ͡° ͜ʖ ͡°)','¯\\_(ツ)_/¯','😍','👩🏽','👨‍🦰 👨🏿‍🦰 👨‍🦱 👨🏿‍🦱 🦹🏿‍♂️','👾 🙇 💁 🙅 🙆 🙋 🙎 🙍','🐵 🙈 🙉 🙊','❤️ 💔 💌 💕 💞 💓 💗 💖 💘 💝 💟 💜 💛 💚 💙','✋🏿 💪🏿 👐🏿 🙌🏿 👏🏿 🙏🏿','👨‍👩‍👦 👨‍👩‍👧‍👦 👨‍👨‍👦 👩‍👩‍👧 👨‍👦 👨‍👧‍👦 👩‍👦 👩‍👧‍👦','🚾 🆒 🆓 🆕 🆖 🆗 🆙 🏧','0️⃣ 1️⃣ 2️⃣ 3️⃣ 4️⃣ 5️⃣ 6️⃣ 7️⃣ 8️⃣ 9️⃣ 🔟','🇺🇸🇷🇺🇸 🇦🇫🇦🇲🇸','🇺🇸🇷🇺🇸🇦🇫🇦🇲','🇺🇸🇷🇺🇸🇦','１２３','١٢٣','ثم نفس سقطت وبالتحديد،, جزيرتي باستخدام أن دنو. إذ هنا؟ الستار وتنصيب كان. أهّل ايطاليا، بريطانيا-فرنسا قد أخذ. سليمان، إتفاقية بين ما , يذكر الحدود أي بعد, معاملة بولندا، الإطلاق عل إيو.','בְּרֵאשִׁית, בָּרָא אֱלֹהִים, אֵת הַשָּׁמַיִם, וְאֵת הָאָרֶץ','הָיְתָהtestالصفحات التّحول','﷽','ﷺ','مُنَاقَشَةُ سُبُلِ اِسْتِخْدَامِ اللُّغَةِ فِي النُّظُمِ الْقَائِمَةِ وَفِيم يَخُصَّ التَّطْبِيقَاتُ الْحاسُوبِيَّةُ، ','᚛ᚄᚓᚐᚋᚒᚄ ᚑᚄᚂᚑᚏᚅ᚜‪‪‪','‪‪᚛                 ᚜‪','‪‪test‪','‫test‫',' test ','test⁠test‫','⁦test⁧','Ṱ̺̺̕o͞ ̷i̲̬͇̪͙n̝̗͕v̟̜̘̦͟o̶̙̰̠kè͚̮̺̪̹̱̤ ̖t̝͕̳̣̻̪͞h̼͓̲̦̳̘̲e͇̣̰̦̬͎ ̢̼̻̱̘h͚͎͙̜̣̲ͅi̦̲̣̰̤v̻͍e̺̭̳̪̰-m̢iͅn̖̺̞̲̯̰d̵̼̟͙̩̼̘̳ ̞̥̱̳̭r̛̗̘e͙p͠r̼̞̻̭̗e̺̠̣͟s̘͇̳͍̝͉e͉̥̯̞̲͚̬͜ǹ̬͎͎̟̖͇̤t͍̬̤͓̼̭͘ͅi̪̱n͠g̴͉ ͏͉ͅc̬̟h͡a̫̻̯͘o̫̟̖͍̙̝͉s̗̦̲.̨̹͈̣','̡͓̞ͅI̗̘̦͝n͇͇͙v̮̫ok̲̫̙͈i̖͙̭̹̠̞n̡̻̮̣̺g̲͈͙̭͙̬͎ ̰t͔̦h̞̲e̢̤ ͍̬̲͖f̴̘͕̣è͖ẹ̥̩l͖͔͚i͓͚̦͠n͖͍̗͓̳̮g͍ ̨o͚̪͡f̘̣̬ ̖̘͖̟͙̮c҉͔̫͖͓͇͖ͅh̵̤̣͚͔á̗̼͕ͅo̼̣̥s̱͈̺̖̦̻͢.̛̖̞̠̫̰','̗̺͖̹̯͓Ṯ̤͍̥͇͈h̲́e͏͓̼̗̙̼̣͔ ͇̜̱̠͓͍ͅN͕͠e̗̱z̘̝̜̺͙p̤̺̹͍̯͚e̠̻̠͜r̨̤͍̺̖͔̖̖d̠̟̭̬̝͟i̦͖̩͓͔̤a̠̗̬͉̙n͚͜ ̻̞̰͚ͅh̵͉i̳̞v̢͇ḙ͎͟-҉̭̩̼͔m̤̭̫i͕͇̝̦n̗͙ḍ̟ ̯̲͕͞ǫ̟̯̰̲͙̻̝f ̪̰̰̗̖̭̘͘c̦͍̲̞͍̩̙ḥ͚a̮͎̟̙͜ơ̩̹͎s̤.̝̝ ҉Z̡̖̜͖̰̣͉̜a͖̰͙̬͡l̲̫̳͍̩g̡̟̼̱͚̞̬ͅo̗͜.̟','̦H̬̤̗̤͝e͜ ̜̥̝̻͍̟́w̕h̖̯͓o̝͙̖͎̱̮ ҉̺̙̞̟͈W̷̼̭a̺̪͍į͈͕̭͙̯̜t̶̼̮s̘͙͖̕ ̠̫̠B̻͍͙͉̳ͅe̵h̵̬͇̫͙i̹͓̳̳̮͎̫̕n͟d̴̪̜̖ ̰͉̩͇͙̲͞ͅT͖̼͓̪͢h͏͓̮̻e̬̝̟ͅ ̤̹̝W͙̞̝͔͇͝ͅa͏͓͔̹̼̣l̴͔̰̤̟͔ḽ̫.͕','Z̮̞̠͙͔ͅḀ̗̞͈̻̗Ḷ͙͎̯̹̞͓G̻O̭̗̮','˙ɐnbᴉlɐ ɐuƃɐɯ ǝɹolop ʇǝ ǝɹoqɐl ʇn ʇunpᴉpᴉɔuᴉ ɹodɯǝʇ poɯsnᴉǝ op pǝs \'ʇᴉlǝ ƃuᴉɔsᴉdᴉpɐ ɹnʇǝʇɔǝsuoɔ \'ʇǝɯɐ ʇᴉs ɹolop ɯnsdᴉ ɯǝɹo˥','00˙Ɩ$-','Ｔｈｅ ｑｕｉｃｋ ｂｒｏｗｎ ｆｏｘ ｊｕｍｐｓ ｏｖｅｒ ｔｈｅ ｌａｚｙ ｄｏｇ','𝐓𝐡𝐞 𝐪𝐮𝐢𝐜𝐤 𝐛𝐫𝐨𝐰𝐧 𝐟𝐨𝐱 𝐣𝐮𝐦𝐩𝐬 𝐨𝐯𝐞𝐫 𝐭𝐡𝐞 𝐥𝐚𝐳𝐲 𝐝𝐨𝐠','𝕿𝖍𝖊 𝖖𝖚𝖎𝖈𝖐 𝖇𝖗𝖔𝖜𝖓 𝖋𝖔𝖝 𝖏𝖚𝖒𝖕𝖘 𝖔𝖛𝖊𝖗 𝖙𝖍𝖊 𝖑𝖆𝖟𝖞 𝖉𝖔𝖌','𝑻𝒉𝒆 𝒒𝒖𝒊𝒄𝒌 𝒃𝒓𝒐𝒘𝒏 𝒇𝒐𝒙 𝒋𝒖𝒎𝒑𝒔 𝒐𝒗𝒆𝒓 𝒕𝒉𝒆 𝒍𝒂𝒛𝒚 𝒅𝒐𝒈','𝓣𝓱𝓮 𝓺𝓾𝓲𝓬𝓴 𝓫𝓻𝓸𝔀𝓷 𝓯𝓸𝔁 𝓳𝓾𝓶𝓹𝓼 𝓸𝓿𝓮𝓻 𝓽𝓱𝓮 𝓵𝓪𝔃𝔂 𝓭𝓸𝓰','𝕋𝕙𝕖 𝕢𝕦𝕚𝕔𝕜 𝕓𝕣𝕠𝕨𝕟 𝕗𝕠𝕩 𝕛𝕦𝕞𝕡𝕤 𝕠𝕧𝕖𝕣 𝕥𝕙𝕖 𝕝𝕒𝕫𝕪 𝕕𝕠𝕘','𝚃𝚑𝚎 𝚚𝚞𝚒𝚌𝚔 𝚋𝚛𝚘𝚠𝚗 𝚏𝚘𝚡 𝚓𝚞𝚖𝚙𝚜 𝚘𝚟𝚎𝚛 𝚝𝚑𝚎 𝚕𝚊𝚣𝚢 𝚍𝚘𝚐','⒯⒣⒠ ⒬⒰⒤⒞⒦ ⒝⒭⒪⒲⒩ ⒡⒪⒳ ⒥⒰⒨⒫⒮ ⒪⒱⒠⒭ ⒯⒣⒠ ⒧⒜⒵⒴ ⒟⒪⒢','<script>alert(123)</script>','&lt;script&gt;alert(&#39;123&#39;);&lt;/script&gt;','<img src=x onerror=alert(123) />','<svg><script>123<1>alert(123)</script>','"><script>alert(123)</script>','\'><script>alert(123)</script>','><script>alert(123)</script>','</script><script>alert(123)</script>','< / script >< script >alert(123)< / script >',' onfocus=JaVaSCript:alert(123) autofocus','" onfocus=JaVaSCript:alert(123) autofocus','\' onfocus=JaVaSCript:alert(123) autofocus','＜script＞alert(123)＜/script＞','<sc<script>ript>alert(123)</sc</script>ript>','--><script>alert(123)</script>','";alert(123);t="','\';alert(123);t=\'','JavaSCript:alert(123)',';alert(123);','src=JaVaSCript:prompt(132)','"><script>alert(123);</script x="','\'><script>alert(123);</script x=\'','><script>alert(123);</script x=','" autofocus onkeyup="javascript:alert(123)','\' autofocus onkeyup=\'javascript:alert(123)','<script\\x20type="text/javascript">javascript:alert(1);</script>','<script\\x3Etype="text/javascript">javascript:alert(1);</script>','<script\\x0Dtype="text/javascript">javascript:alert(1);</script>','<script\\x09type="text/javascript">javascript:alert(1);</script>','<script\\x0Ctype="text/javascript">javascript:alert(1);</script>','<script\\x2Ftype="text/javascript">javascript:alert(1);</script>','<script\\x0Atype="text/javascript">javascript:alert(1);</script>','\'`"><\\x3Cscript>javascript:alert(1)</script>','\'`"><\\x00script>javascript:alert(1)</script>','ABC<div style="x\\x3Aexpression(javascript:alert(1)">DEF','ABC<div style="x:expression\\x5C(javascript:alert(1)">DEF','ABC<div style="x:expression\\x00(javascript:alert(1)">DEF','ABC<div style="x:exp\\x00ression(javascript:alert(1)">DEF','ABC<div style="x:exp\\x5Cression(javascript:alert(1)">DEF','ABC<div style="x:\\x0Aexpression(javascript:alert(1)">DEF','ABC<div style="x:\\x09expression(javascript:alert(1)">DEF','ABC<div style="x:\\xE3\\x80\\x80expression(javascript:alert(1)">DEF','ABC<div style="x:\\xE2\\x80\\x84expression(javascript:alert(1)">DEF','ABC<div style="x:\\xC2\\xA0expression(javascript:alert(1)">DEF','ABC<div style="x:\\xE2\\x80\\x80expression(javascript:alert(1)">DEF','ABC<div style="x:\\xE2\\x80\\x8Aexpression(javascript:alert(1)">DEF','ABC<div style="x:\\x0Dexpression(javascript:alert(1)">DEF','ABC<div style="x:\\x0Cexpression(javascript:alert(1)">DEF','ABC<div style="x:\\xE2\\x80\\x87expression(javascript:alert(1)">DEF','ABC<div style="x:\\xEF\\xBB\\xBFexpression(javascript:alert(1)">DEF','ABC<div style="x:\\x20expression(javascript:alert(1)">DEF','ABC<div style="x:\\xE2\\x80\\x88expression(javascript:alert(1)">DEF','ABC<div style="x:\\x00expression(javascript:alert(1)">DEF','ABC<div style="x:\\xE2\\x80\\x8Bexpression(javascript:alert(1)">DEF','ABC<div style="x:\\xE2\\x80\\x86expression(javascript:alert(1)">DEF','ABC<div style="x:\\xE2\\x80\\x85expression(javascript:alert(1)">DEF','ABC<div style="x:\\xE2\\x80\\x82expression(javascript:alert(1)">DEF','ABC<div style="x:\\x0Bexpression(javascript:alert(1)">DEF','ABC<div style="x:\\xE2\\x80\\x81expression(javascript:alert(1)">DEF','ABC<div style="x:\\xE2\\x80\\x83expression(javascript:alert(1)">DEF','ABC<div style="x:\\xE2\\x80\\x89expression(javascript:alert(1)">DEF','<a href="\\x0Bjavascript:javascript:alert(1)" id="fuzzelement1">test</a>','<a href="\\x0Fjavascript:javascript:alert(1)" id="fuzzelement1">test</a>','<a href="\\xC2\\xA0javascript:javascript:alert(1)" id="fuzzelement1">test</a>','<a href="\\x05javascript:javascript:alert(1)" id="fuzzelement1">test</a>','<a href="\\xE1\\xA0\\x8Ejavascript:javascript:alert(1)" id="fuzzelement1">test</a>','<a href="\\x18javascript:javascript:alert(1)" id="fuzzelement1">test</a>','<a href="\\x11javascript:javascript:alert(1)" id="fuzzelement1">test</a>','<a href="\\xE2\\x80\\x88javascript:javascript:alert(1)" id="fuzzelement1">test</a>','<a href="\\xE2\\x80\\x89javascript:javascript:alert(1)" id="fuzzelement1">test</a>','<a href="\\xE2\\x80\\x80javascript:javascript:alert(1)" id="fuzzelement1">test</a>','<a href="\\x17javascript:javascript:alert(1)" id="fuzzelement1">test</a>','<a href="\\x03javascript:javascript:alert(1)" id="fuzzelement1">test</a>','<a href="\\x0Ejavascript:javascript:alert(1)" id="fuzzelement1">test</a>','<a href="\\x1Ajavascript:javascript:alert(1)" id="fuzzelement1">test</a>','<a href="\\x00javascript:javascript:alert(1)" id="fuzzelement1">test</a>','<a href="\\x10javascript:javascript:alert(1)" id="fuzzelement1">test</a>','<a href="\\xE2\\x80\\x82javascript:javascript:alert(1)" id="fuzzelement1">test</a>','<a href="\\x20javascript:javascript:alert(1)" id="fuzzelement1">test</a>','<a href="\\x13javascript:javascript:alert(1)" id="fuzzelement1">test</a>','<a href="\\x09javascript:javascript:alert(1)" id="fuzzelement1">test</a>','<a href="\\xE2\\x80\\x8Ajavascript:javascript:alert(1)" id="fuzzelement1">test</a>','<a href="\\x14javascript:javascript:alert(1)" id="fuzzelement1">test</a>','<a href="\\x19javascript:javascript:alert(1)" id="fuzzelement1">test</a>','<a href="\\xE2\\x80\\xAFjavascript:javascript:alert(1)" id="fuzzelement1">test</a>','<a href="\\x1Fjavascript:javascript:alert(1)" id="fuzzelement1">test</a>','<a href="\\xE2\\x80\\x81javascript:javascript:alert(1)" id="fuzzelement1">test</a>','<a href="\\x1Djavascript:javascript:alert(1)" id="fuzzelement1">test</a>','<a href="\\xE2\\x80\\x87javascript:javascript:alert(1)" id="fuzzelement1">test</a>','<a href="\\x07javascript:javascript:alert(1)" id="fuzzelement1">test</a>','<a href="\\xE1\\x9A\\x80javascript:javascript:alert(1)" id="fuzzelement1">test</a>','<a href="\\xE2\\x80\\x83javascript:javascript:alert(1)" id="fuzzelement1">test</a>','<a href="\\x04javascript:javascript:alert(1)" id="fuzzelement1">test</a>','<a href="\\x01javascript:javascript:alert(1)" id="fuzzelement1">test</a>','<a href="\\x08javascript:javascript:alert(1)" id="fuzzelement1">test</a>','<a href="\\xE2\\x80\\x84javascript:javascript:alert(1)" id="fuzzelement1">test</a>','<a href="\\xE2\\x80\\x86javascript:javascript:alert(1)" id="fuzzelement1">test</a>','<a href="\\xE3\\x80\\x80javascript:javascript:alert(1)" id="fuzzelement1">test</a>','<a href="\\x12javascript:javascript:alert(1)" id="fuzzelement1">test</a>','<a href="\\x0Djavascript:javascript:alert(1)" id="fuzzelement1">test</a>','<a href="\\x0Ajavascript:javascript:alert(1)" id="fuzzelement1">test</a>','<a href="\\x0Cjavascript:javascript:alert(1)" id="fuzzelement1">test</a>','<a href="\\x15javascript:javascript:alert(1)" id="fuzzelement1">test</a>','<a href="\\xE2\\x80\\xA8javascript:javascript:alert(1)" id="fuzzelement1">test</a>','<a href="\\x16javascript:javascript:alert(1)" id="fuzzelement1">test</a>','<a href="\\x02javascript:javascript:alert(1)" id="fuzzelement1">test</a>','<a href="\\x1Bjavascript:javascript:alert(1)" id="fuzzelement1">test</a>','<a href="\\x06javascript:javascript:alert(1)" id="fuzzelement1">test</a>','<a href="\\xE2\\x80\\xA9javascript:javascript:alert(1)" id="fuzzelement1">test</a>','<a href="\\xE2\\x80\\x85javascript:javascript:alert(1)" id="fuzzelement1">test</a>','<a href="\\x1Ejavascript:javascript:alert(1)" id="fuzzelement1">test</a>','<a href="\\xE2\\x81\\x9Fjavascript:javascript:alert(1)" id="fuzzelement1">test</a>','<a href="\\x1Cjavascript:javascript:alert(1)" id="fuzzelement1">test</a>','<a href="javascript\\x00:javascript:alert(1)" id="fuzzelement1">test</a>','<a href="javascript\\x3A:javascript:alert(1)" id="fuzzelement1">test</a>','<a href="javascript\\x09:javascript:alert(1)" id="fuzzelement1">test</a>','<a href="javascript\\x0D:javascript:alert(1)" id="fuzzelement1">test</a>','<a href="javascript\\x0A:javascript:alert(1)" id="fuzzelement1">test</a>','`"\'><img src=xxx:x \\x0Aonerror=javascript:alert(1)>','`"\'><img src=xxx:x \\x22onerror=javascript:alert(1)>','`"\'><img src=xxx:x \\x0Bonerror=javascript:alert(1)>','`"\'><img src=xxx:x \\x0Donerror=javascript:alert(1)>','`"\'><img src=xxx:x \\x2Fonerror=javascript:alert(1)>','`"\'><img src=xxx:x \\x09onerror=javascript:alert(1)>','`"\'><img src=xxx:x \\x0Conerror=javascript:alert(1)>','`"\'><img src=xxx:x \\x00onerror=javascript:alert(1)>','`"\'><img src=xxx:x \\x27onerror=javascript:alert(1)>','`"\'><img src=xxx:x \\x20onerror=javascript:alert(1)>','"`\'><script>\\x3Bjavascript:alert(1)</script>','"`\'><script>\\x0Djavascript:alert(1)</script>','"`\'><script>\\xEF\\xBB\\xBFjavascript:alert(1)</script>','"`\'><script>\\xE2\\x80\\x81javascript:alert(1)</script>','"`\'><script>\\xE2\\x80\\x84javascript:alert(1)</script>','"`\'><script>\\xE3\\x80\\x80javascript:alert(1)</script>','"`\'><script>\\x09javascript:alert(1)</script>','"`\'><script>\\xE2\\x80\\x89javascript:alert(1)</script>','"`\'><script>\\xE2\\x80\\x85javascript:alert(1)</script>','"`\'><script>\\xE2\\x80\\x88javascript:alert(1)</script>','"`\'><script>\\x00javascript:alert(1)</script>','"`\'><script>\\xE2\\x80\\xA8javascript:alert(1)</script>','"`\'><script>\\xE2\\x80\\x8Ajavascript:alert(1)</script>','"`\'><script>\\xE1\\x9A\\x80javascript:alert(1)</script>','"`\'><script>\\x0Cjavascript:alert(1)</script>','"`\'><script>\\x2Bjavascript:alert(1)</script>','"`\'><script>\\xF0\\x90\\x96\\x9Ajavascript:alert(1)</script>','"`\'><script>-javascript:alert(1)</script>','"`\'><script>\\x0Ajavascript:alert(1)</script>','"`\'><script>\\xE2\\x80\\xAFjavascript:alert(1)</script>','"`\'><script>\\x7Ejavascript:alert(1)</script>','"`\'><script>\\xE2\\x80\\x87javascript:alert(1)</script>','"`\'><script>\\xE2\\x81\\x9Fjavascript:alert(1)</script>','"`\'><script>\\xE2\\x80\\xA9javascript:alert(1)</script>','"`\'><script>\\xC2\\x85javascript:alert(1)</script>','"`\'><script>\\xEF\\xBF\\xAEjavascript:alert(1)</script>','"`\'><script>\\xE2\\x80\\x83javascript:alert(1)</script>','"`\'><script>\\xE2\\x80\\x8Bjavascript:alert(1)</script>','"`\'><script>\\xEF\\xBF\\xBEjavascript:alert(1)</script>','"`\'><script>\\xE2\\x80\\x80javascript:alert(1)</script>','"`\'><script>\\x21javascript:alert(1)</script>','"`\'><script>\\xE2\\x80\\x82javascript:alert(1)</script>','"`\'><script>\\xE2\\x80\\x86javascript:alert(1)</script>','"`\'><script>\\xE1\\xA0\\x8Ejavascript:alert(1)</script>','"`\'><script>\\x0Bjavascript:alert(1)</script>','"`\'><script>\\x20javascript:alert(1)</script>','"`\'><script>\\xC2\\xA0javascript:alert(1)</script>','<img \\x00src=x onerror="alert(1)">','<img \\x47src=x onerror="javascript:alert(1)">','<img \\x11src=x onerror="javascript:alert(1)">','<img \\x12src=x onerror="javascript:alert(1)">','<img\\x47src=x onerror="javascript:alert(1)">','<img\\x10src=x onerror="javascript:alert(1)">','<img\\x13src=x onerror="javascript:alert(1)">','<img\\x32src=x onerror="javascript:alert(1)">','<img\\x11src=x onerror="javascript:alert(1)">','<img \\x34src=x onerror="javascript:alert(1)">','<img \\x39src=x onerror="javascript:alert(1)">','<img \\x00src=x onerror="javascript:alert(1)">','<img src\\x09=x onerror="javascript:alert(1)">','<img src\\x10=x onerror="javascript:alert(1)">','<img src\\x13=x onerror="javascript:alert(1)">','<img src\\x32=x onerror="javascript:alert(1)">','<img src\\x12=x onerror="javascript:alert(1)">','<img src\\x11=x onerror="javascript:alert(1)">','<img src\\x00=x onerror="javascript:alert(1)">','<img src\\x47=x onerror="javascript:alert(1)">','<img src=x\\x09onerror="javascript:alert(1)">','<img src=x\\x10onerror="javascript:alert(1)">','<img src=x\\x11onerror="javascript:alert(1)">','<img src=x\\x12onerror="javascript:alert(1)">','<img src=x\\x13onerror="javascript:alert(1)">','<img[a][b][c]src[d]=x[e]onerror=[f]"alert(1)">','<img src=x onerror=\\x09"javascript:alert(1)">','<img src=x onerror=\\x10"javascript:alert(1)">','<img src=x onerror=\\x11"javascript:alert(1)">','<img src=x onerror=\\x12"javascript:alert(1)">','<img src=x onerror=\\x32"javascript:alert(1)">','<img src=x onerror=\\x00"javascript:alert(1)">','<a href=java&#1&#2&#3&#4&#5&#6&#7&#8&#11&#12script:javascript:alert(1)>XXX</a>','<img src="x` `<script>javascript:alert(1)</script>"` `>','<img src onerror /" \'"= alt=javascript:alert(1)//">','<title onpropertychange=javascript:alert(1)></title><title title=>','<a href=http://foo.bar/#x=`y></a><img alt="`><img src=x:x onerror=javascript:alert(1)></a>">','<!--[if]><script>javascript:alert(1)</script -->','<!--[if<img src=x onerror=javascript:alert(1)//]> -->','<script src="/\\%(jscript)s"></script>','<script src="\\\\%(jscript)s"></script>','<IMG """><SCRIPT>alert("XSS")</SCRIPT>">','<IMG SRC=javascript:alert(String.fromCharCode(88,83,83))>','<IMG SRC=# onmouseover="alert(\'xxs\')">','<IMG SRC= onmouseover="alert(\'xxs\')">','<IMG onmouseover="alert(\'xxs\')">','<IMG SRC=&#106;&#97;&#118;&#97;&#115;&#99;&#114;&#105;&#112;&#116;&#58;&#97;&#108;&#101;&#114;&#116;&#40;&#39;&#88;&#83;&#83;&#39;&#41;>','<IMG SRC=&#0000106&#0000097&#0000118&#0000097&#0000115&#0000099&#0000114&#0000105&#0000112&#0000116&#0000058&#0000097&#0000108&#0000101&#0000114&#0000116&#0000040&#0000039&#0000088&#0000083&#0000083&#0000039&#0000041>','<IMG SRC=&#x6A&#x61&#x76&#x61&#x73&#x63&#x72&#x69&#x70&#x74&#x3A&#x61&#x6C&#x65&#x72&#x74&#x28&#x27&#x58&#x53&#x53&#x27&#x29>','<IMG SRC="jav   ascript:alert(\'XSS\');">','<IMG SRC="jav&#x09;ascript:alert(\'XSS\');">','<IMG SRC="jav&#x0A;ascript:alert(\'XSS\');">','<IMG SRC="jav&#x0D;ascript:alert(\'XSS\');">','perl -e \'print "<IMG SRC=java\\0script:alert(\\"XSS\\")>";\' > out','<IMG SRC=" &#14;  javascript:alert(\'XSS\');">','<SCRIPT/XSS SRC="http://ha.ckers.org/xss.js"></SCRIPT>','<BODY onload!#$%&()*~+-_.,:;?@[/|\\]^`=alert("XSS")>','<SCRIPT/SRC="http://ha.ckers.org/xss.js"></SCRIPT>','<<SCRIPT>alert("XSS");//<</SCRIPT>','<SCRIPT SRC=http://ha.ckers.org/xss.js?< B >','<SCRIPT SRC=//ha.ckers.org/.j>','<IMG SRC="javascript:alert(\'XSS\')"','<iframe src=http://ha.ckers.org/scriptlet.html <','\\";alert(\'XSS\');//','<u oncopy=alert()> Copy me</u>','<i onwheel=alert(1)> Scroll over me </i>','<plaintext>','http://a/%%30%30','</textarea><script>alert(123)</script>','1;DROP TABLE users','1\'; DROP TABLE users-- 1','\' OR 1=1 -- 1','\' OR \'1\'=\'1','\'; EXEC sp_MSForEachTable \'DROP TABLE ?\'; --',' ','%','_','--','--version','--help','$USER','/dev/null; touch /tmp/blns.fail ; echo','`touch /tmp/blns.fail`','$(touch /tmp/blns.fail)','@{[system "touch /tmp/blns.fail"]}','eval("puts \'hello world\'")','System("ls -al /")','`ls -al /`','Kernel.exec("ls -al /")','Kernel.exit(1)','%x(\'ls -al /\')','<?xml version="1.0" encoding="ISO-8859-1"?><!DOCTYPE foo [ <!ELEMENT foo ANY ><!ENTITY xxe SYSTEM "file:///etc/passwd" >]><foo>&xxe;</foo>','$HOME','$ENV{\'HOME\'}','%d','%s%s%s%s%s','{0}','%*.*s','%@','%n','File:///','../../../../../../../../../../../etc/passwd%00','../../../../../../../../../../../etc/hosts','() { 0; }; touch /tmp/blns.shellshock1.fail;','() { _; } >_[$($())] { touch /tmp/blns.shellshock2.fail; }','<<< %s(un=\'%s\') = %u','+++ATH0','CON','PRN','AUX','CLOCK$','NUL','A:','ZZ:','COM1','LPT1','LPT2','LPT3','COM2','COM3','COM4','DCC SEND STARTKEYLOGGER 0 0 0','Scunthorpe General Hospital','Penistone Community Church','Lightwater Country Park','Jimmy Clitheroe','Horniman Museum','shitake mushrooms','RomansInSussex.co.uk','http://www.cum.qc.ca/','Craig Cockburn, Software Specialist','Linda Callahan','Dr. Herman I. Libshitz','magna cum laude','Super Bowl XXX','medieval erection of parapets','evaluate','mocha','expression','Arsenal canal','classic','Tyson Gay','Dick Van Dyke','basement','If you\'re reading this, you\'ve been in a coma for almost 20 years now. We\'re trying a new technique. We don\'t know where this message will end up in your dream, but we hope it works. Please wake up, we miss you.','Roses are \\u001b[0;31mred\\u001b[0m, violets are \\u001b[0;34mblue. Hope you enjoy terminal hue','But now...\\u001b[20Cfor my greatest trick...\\u001b[8m','The quic\b\b\b\b\b\bk brown fo\\u0007\\u0007\\u0007\\u0007\\u0007\\u0007\\u0007\\u0007\\u0007\\u0007\\u0007x... [Beeeep]','Powerلُلُصّبُلُلصّبُررً ॣ ॣh ॣ ॣ冗','🏳0🌈️','జ్ఞ‌ా','گچپژ','{% print \'x\' * 64 * 1024**3 %}','{{ "".__class__.__mro__[2].__subclasses__()[40]("/etc/passwd").read() }}' FORMAT PrettyCompactNoEscapes;

SELECT JSONExtract(
    '{"x": [\n  "", \n  "undefined", \n  "undef", \n  "null", \n  "NULL", \n  "(null)", \n  "nil", \n  "NIL", \n  "true", \n  "false", \n  "True", \n  "False", \n  "TRUE", \n  "FALSE", \n  "None", \n  "hasOwnProperty", \n  "then", \n  "\\\\", \n  "\\\\\\\\", \n  "0", \n  "1", \n  "1.00", \n  "$1.00", \n  "1/2", \n  "1E2", \n  "1E02", \n  "1E+02", \n  "-1", \n  "-1.00", \n  "-$1.00", \n  "-1/2", \n  "-1E2", \n  "-1E02", \n  "-1E+02", \n  "1/0", \n  "0/0", \n  "-2147483648/-1", \n  "-9223372036854775808/-1", \n  "-0", \n  "-0.0", \n  "+0", \n  "+0.0", \n  "0.00", \n  "0..0", \n  ".", \n  "0.0.0", \n  "0,00", \n  "0,,0", \n  ",", \n  "0,0,0", \n  "0.0/0", \n  "1.0/0.0", \n  "0.0/0.0", \n  "1,0/0,0", \n  "0,0/0,0", \n  "--1", \n  "-", \n  "-.", \n  "-,", \n  "999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999", \n  "NaN", \n  "Infinity", \n  "-Infinity", \n  "INF", \n  "1#INF", \n  "-1#IND", \n  "1#QNAN", \n  "1#SNAN", \n  "1#IND", \n  "0x0", \n  "0xffffffff", \n  "0xffffffffffffffff", \n  "0xabad1dea", \n  "123456789012345678901234567890123456789", \n  "1,000.00", \n  "1 000.00", \n  "1\'000.00", \n  "1,000,000.00", \n  "1 000 000.00", \n  "1\'000\'000.00", \n  "1.000,00", \n  "1 000,00", \n  "1\'000,00", \n  "1.000.000,00", \n  "1 000 000,00", \n  "1\'000\'000,00", \n  "01000", \n  "08", \n  "09", \n  "2.2250738585072011e-308", \n  ",./;\'[]\\\\-=", \n  "<>?:\\"{}|_+", \n  "!@#$%^&*()`~", \n  "\\u0001\\u0002\\u0003\\u0004\\u0005\\u0006\\u0007\\b\\u000e\\u000f\\u0010\\u0011\\u0012\\u0013\\u0014\\u0015\\u0016\\u0017\\u0018\\u0019\\u001a\\u001b\\u001c\\u001d\\u001e\\u001f", \n  "", \n  "\\t\\u000b\\f              ​    　", \n  "­؀؁؂؃؄؅؜۝܏᠎​‌‍‎‏‪‫‬‭‮⁠⁡⁢⁣⁤⁦⁧⁨⁩⁪⁫⁬⁭⁮⁯﻿￹￺￻𑂽𛲠𛲡𛲢𛲣𝅳𝅴𝅵𝅶𝅷𝅸𝅹𝅺󠀁󠀠󠀡󠀢󠀣󠀤󠀥󠀦󠀧󠀨󠀩󠀪󠀫󠀬󠀭󠀮󠀯󠀰󠀱󠀲󠀳󠀴󠀵󠀶󠀷󠀸󠀹󠀺󠀻󠀼󠀽󠀾󠀿󠁀󠁁󠁂󠁃󠁄󠁅󠁆󠁇󠁈󠁉󠁊󠁋󠁌󠁍󠁎󠁏󠁐󠁑󠁒󠁓󠁔󠁕󠁖󠁗󠁘󠁙󠁚󠁛󠁜󠁝󠁞󠁟󠁠󠁡󠁢󠁣󠁤󠁥󠁦󠁧󠁨󠁩󠁪󠁫󠁬󠁭󠁮󠁯󠁰󠁱󠁲󠁳󠁴󠁵󠁶󠁷󠁸󠁹󠁺󠁻󠁼󠁽󠁾󠁿", \n  "﻿", \n  "￾", \n  "Ω≈ç√∫˜µ≤≥÷", \n  "åß∂ƒ©˙∆˚¬…æ", \n  "œ∑´®†¥¨ˆøπ“‘", \n  "¡™£¢∞§¶•ªº–≠", \n  "¸˛Ç◊ı˜Â¯˘¿", \n  "ÅÍÎÏ˝ÓÔÒÚÆ☃", \n  "Œ„´‰ˇÁ¨ˆØ∏”’", \n  "`⁄€‹›ﬁﬂ‡°·‚—±", \n  "⅛⅜⅝⅞", \n  "ЁЂЃЄЅІЇЈЉЊЋЌЍЎЏАБВГДЕЖЗИЙКЛМНОПРСТУФХЦЧШЩЪЫЬЭЮЯабвгдежзийклмнопрстуфхцчшщъыьэюя", \n  "٠١٢٣٤٥٦٧٨٩", \n  "⁰⁴⁵", \n  "₀₁₂", \n  "⁰⁴⁵₀₁₂", \n  "ด้้้้้็็็็็้้้้้็็็็็้้้้้้้้็็็็็้้้้้็็็็็้้้้้้้้็็็็็้้้้้็็็็็้้้้้้้้็็็็็้้้้้็็็็ ด้้้้้็็็็็้้้้้็็็็็้้้้้้้้็็็็็้้้้้็็็็็้้้้้้้้็็็็็้้้้้็็็็็้้้้้้้้็็็็็้้้้้็็็็ ด้้้้้็็็็็้้้้้็็็็็้้้้้้้้็็็็็้้้้้็็็็็้้้้้้้้็็็็็้้้้้็็็็็้้้้้้้้็็็็็้้้้้็็็็", \n  "\'", \n  "\\"", \n  "\'\'", \n  "\\"\\"", \n  "\'\\"\'", \n  "\\"\'\'\'\'\\"\'\\"", \n  "\\"\'\\"\'\\"\'\'\'\'\\"", \n  "<foo val=“bar” />", \n  "<foo val=“bar” />", \n  "<foo val=”bar“ />", \n  "<foo val=`bar\' />", \n  "田中さんにあげて下さい", \n  "パーティーへ行かないか", \n  "和製漢語", \n  "部落格", \n  "사회과학원 어학연구소", \n  "찦차를 타고 온 펲시맨과 쑛다리 똠방각하", \n  "社會科學院語學研究所", \n  "울란바토르", \n  "𠜎𠜱𠝹𠱓𠱸𠲖𠳏", \n  "𐐜 𐐔𐐇𐐝𐐀𐐡𐐇𐐓 𐐙𐐊𐐡𐐝𐐓/𐐝𐐇𐐗𐐊𐐤𐐔 𐐒𐐋𐐗 𐐒𐐌 𐐜 𐐡𐐀𐐖𐐇𐐤𐐓𐐝 𐐱𐑂 𐑄 𐐔𐐇𐐝𐐀𐐡𐐇𐐓 𐐏𐐆𐐅𐐤𐐆𐐚𐐊𐐡𐐝𐐆𐐓𐐆",\n  "表ポあA鷗ŒéＢ逍Üßªąñ丂㐀𠀀", \n  "Ⱥ", \n  "Ⱦ", \n  "ヽ༼ຈل͜ຈ༽ﾉ ヽ༼ຈل͜ຈ༽ﾉ", \n  "(｡◕ ∀ ◕｡)", \n  "｀ｨ(´∀｀∩", \n  "__ﾛ(,_,*)", \n  "・(￣∀￣)・:*:", \n  "ﾟ･✿ヾ╲(｡◕‿◕｡)╱✿･ﾟ", \n  ",。・:*:・゜’( ☻ ω ☻ )。・:*:・゜’", \n  "(╯°□°）╯︵ ┻━┻)", \n  "(ﾉಥ益ಥ）ﾉ﻿ ┻━┻", \n  "┬─┬ノ( º _ ºノ)", \n  "( ͡° ͜ʖ ͡°)", \n  "¯\\\\_(ツ)_/¯", \n  "😍", \n  "👩🏽", \n  "👨‍🦰 👨🏿‍🦰 👨‍🦱 👨🏿‍🦱 🦹🏿‍♂️", \n  "👾 🙇 💁 🙅 🙆 🙋 🙎 🙍", \n  "🐵 🙈 🙉 🙊", \n  "❤️ 💔 💌 💕 💞 💓 💗 💖 💘 💝 💟 💜 💛 💚 💙", \n  "✋🏿 💪🏿 👐🏿 🙌🏿 👏🏿 🙏🏿", \n  "👨‍👩‍👦 👨‍👩‍👧‍👦 👨‍👨‍👦 👩‍👩‍👧 👨‍👦 👨‍👧‍👦 👩‍👦 👩‍👧‍👦", \n  "🚾 🆒 🆓 🆕 🆖 🆗 🆙 🏧", \n  "0️⃣ 1️⃣ 2️⃣ 3️⃣ 4️⃣ 5️⃣ 6️⃣ 7️⃣ 8️⃣ 9️⃣ 🔟", \n  "🇺🇸🇷🇺🇸 🇦🇫🇦🇲🇸", \n  "🇺🇸🇷🇺🇸🇦🇫🇦🇲", \n  "🇺🇸🇷🇺🇸🇦", \n  "１２３", \n  "١٢٣", \n  "ثم نفس سقطت وبالتحديد،, جزيرتي باستخدام أن دنو. إذ هنا؟ الستار وتنصيب كان. أهّل ايطاليا، بريطانيا-فرنسا قد أخذ. سليمان، إتفاقية بين ما, يذكر الحدود أي بعد, معاملة بولندا، الإطلاق عل إيو.", \n  "בְּרֵאשִׁית, בָּרָא אֱלֹהִים, אֵת הַשָּׁמַיִם, וְאֵת הָאָרֶץ", \n  "הָיְתָהtestالصفحات التّحول", \n  "﷽", \n  "ﷺ",\n  "مُنَاقَشَةُ سُبُلِ اِسْتِخْدَامِ اللُّغَةِ فِي النُّظُمِ الْقَائِمَةِ وَفِيم يَخُصَّ التَّطْبِيقَاتُ الْحاسُوبِيَّةُ، ", \n  "᚛ᚄᚓᚐᚋᚒᚄ ᚑᚄᚂᚑᚏᚅ᚜‪‪‪", \n  "‪‪᚛                 ᚜‪",\n  "‪‪test‪", \n  "‫test‫", \n  " test ", \n  "test⁠test‫", \n  "⁦test⁧", \n  "Ṱ̺̺̕o͞ ̷i̲̬͇̪͙n̝̗͕v̟̜̘̦͟o̶̙̰̠kè͚̮̺̪̹̱̤ ̖t̝͕̳̣̻̪͞h̼͓̲̦̳̘̲e͇̣̰̦̬͎ ̢̼̻̱̘h͚͎͙̜̣̲ͅi̦̲̣̰̤v̻͍e̺̭̳̪̰-m̢iͅn̖̺̞̲̯̰d̵̼̟͙̩̼̘̳ ̞̥̱̳̭r̛̗̘e͙p͠r̼̞̻̭̗e̺̠̣͟s̘͇̳͍̝͉e͉̥̯̞̲͚̬͜ǹ̬͎͎̟̖͇̤t͍̬̤͓̼̭͘ͅi̪̱n͠g̴͉ ͏͉ͅc̬̟h͡a̫̻̯͘o̫̟̖͍̙̝͉s̗̦̲.̨̹͈̣", \n  "̡͓̞ͅI̗̘̦͝n͇͇͙v̮̫ok̲̫̙͈i̖͙̭̹̠̞n̡̻̮̣̺g̲͈͙̭͙̬͎ ̰t͔̦h̞̲e̢̤ ͍̬̲͖f̴̘͕̣è͖ẹ̥̩l͖͔͚i͓͚̦͠n͖͍̗͓̳̮g͍ ̨o͚̪͡f̘̣̬ ̖̘͖̟͙̮c҉͔̫͖͓͇͖ͅh̵̤̣͚͔á̗̼͕ͅo̼̣̥s̱͈̺̖̦̻͢.̛̖̞̠̫̰", \n  "̗̺͖̹̯͓Ṯ̤͍̥͇͈h̲́e͏͓̼̗̙̼̣͔ ͇̜̱̠͓͍ͅN͕͠e̗̱z̘̝̜̺͙p̤̺̹͍̯͚e̠̻̠͜r̨̤͍̺̖͔̖̖d̠̟̭̬̝͟i̦͖̩͓͔̤a̠̗̬͉̙n͚͜ ̻̞̰͚ͅh̵͉i̳̞v̢͇ḙ͎͟-҉̭̩̼͔m̤̭̫i͕͇̝̦n̗͙ḍ̟ ̯̲͕͞ǫ̟̯̰̲͙̻̝f ̪̰̰̗̖̭̘͘c̦͍̲̞͍̩̙ḥ͚a̮͎̟̙͜ơ̩̹͎s̤.̝̝ ҉Z̡̖̜͖̰̣͉̜a͖̰͙̬͡l̲̫̳͍̩g̡̟̼̱͚̞̬ͅo̗͜.̟", \n  "̦H̬̤̗̤͝e͜ ̜̥̝̻͍̟́w̕h̖̯͓o̝͙̖͎̱̮ ҉̺̙̞̟͈W̷̼̭a̺̪͍į͈͕̭͙̯̜t̶̼̮s̘͙͖̕ ̠̫̠B̻͍͙͉̳ͅe̵h̵̬͇̫͙i̹͓̳̳̮͎̫̕n͟d̴̪̜̖ ̰͉̩͇͙̲͞ͅT͖̼͓̪͢h͏͓̮̻e̬̝̟ͅ ̤̹̝W͙̞̝͔͇͝ͅa͏͓͔̹̼̣l̴͔̰̤̟͔ḽ̫.͕", \n  "Z̮̞̠͙͔ͅḀ̗̞͈̻̗Ḷ͙͎̯̹̞͓G̻O̭̗̮", \n  "˙ɐnbᴉlɐ ɐuƃɐɯ ǝɹolop ʇǝ ǝɹoqɐl ʇn ʇunpᴉpᴉɔuᴉ ɹodɯǝʇ poɯsnᴉǝ op pǝs \'ʇᴉlǝ ƃuᴉɔsᴉdᴉpɐ ɹnʇǝʇɔǝsuoɔ \'ʇǝɯɐ ʇᴉs ɹolop ɯnsdᴉ ɯǝɹo˥", \n  "00˙Ɩ$-", \n  "Ｔｈｅ ｑｕｉｃｋ ｂｒｏｗｎ ｆｏｘ ｊｕｍｐｓ ｏｖｅｒ ｔｈｅ ｌａｚｙ ｄｏｇ", \n  "𝐓𝐡𝐞 𝐪𝐮𝐢𝐜𝐤 𝐛𝐫𝐨𝐰𝐧 𝐟𝐨𝐱 𝐣𝐮𝐦𝐩𝐬 𝐨𝐯𝐞𝐫 𝐭𝐡𝐞 𝐥𝐚𝐳𝐲 𝐝𝐨𝐠", \n  "𝕿𝖍𝖊 𝖖𝖚𝖎𝖈𝖐 𝖇𝖗𝖔𝖜𝖓 𝖋𝖔𝖝 𝖏𝖚𝖒𝖕𝖘 𝖔𝖛𝖊𝖗 𝖙𝖍𝖊 𝖑𝖆𝖟𝖞 𝖉𝖔𝖌", \n  "𝑻𝒉𝒆 𝒒𝒖𝒊𝒄𝒌 𝒃𝒓𝒐𝒘𝒏 𝒇𝒐𝒙 𝒋𝒖𝒎𝒑𝒔 𝒐𝒗𝒆𝒓 𝒕𝒉𝒆 𝒍𝒂𝒛𝒚 𝒅𝒐𝒈", \n  "𝓣𝓱𝓮 𝓺𝓾𝓲𝓬𝓴 𝓫𝓻𝓸𝔀𝓷 𝓯𝓸𝔁 𝓳𝓾𝓶𝓹𝓼 𝓸𝓿𝓮𝓻 𝓽𝓱𝓮 𝓵𝓪𝔃𝔂 𝓭𝓸𝓰", \n  "𝕋𝕙𝕖 𝕢𝕦𝕚𝕔𝕜 𝕓𝕣𝕠𝕨𝕟 𝕗𝕠𝕩 𝕛𝕦𝕞𝕡𝕤 𝕠𝕧𝕖𝕣 𝕥𝕙𝕖 𝕝𝕒𝕫𝕪 𝕕𝕠𝕘", \n  "𝚃𝚑𝚎 𝚚𝚞𝚒𝚌𝚔 𝚋𝚛𝚘𝚠𝚗 𝚏𝚘𝚡 𝚓𝚞𝚖𝚙𝚜 𝚘𝚟𝚎𝚛 𝚝𝚑𝚎 𝚕𝚊𝚣𝚢 𝚍𝚘𝚐", \n  "⒯⒣⒠ ⒬⒰⒤⒞⒦ ⒝⒭⒪⒲⒩ ⒡⒪⒳ ⒥⒰⒨⒫⒮ ⒪⒱⒠⒭ ⒯⒣⒠ ⒧⒜⒵⒴ ⒟⒪⒢", \n  "<script>alert(123)</script>", \n  "&lt;script&gt;alert(&#39;123&#39;);&lt;/script&gt;", \n  "<img src=x onerror=alert(123) />", \n  "<svg><script>123<1>alert(123)</script>", \n  "\\"><script>alert(123)</script>", \n  "\'><script>alert(123)</script>", \n  "><script>alert(123)</script>", \n  "</script><script>alert(123)</script>", \n  "< / script >< script >alert(123)< / script >", \n  " onfocus=JaVaSCript:alert(123) autofocus", \n  "\\" onfocus=JaVaSCript:alert(123) autofocus", \n  "\' onfocus=JaVaSCript:alert(123) autofocus", \n  "＜script＞alert(123)＜/script＞", \n  "<sc<script>ript>alert(123)</sc</script>ript>", \n  "--><script>alert(123)</script>", \n  "\\";alert(123);t=\\"", \n  "\';alert(123);t=\'", \n  "JavaSCript:alert(123)", \n  ";alert(123);", \n  "src=JaVaSCript:prompt(132)", \n  "\\"><script>alert(123);</script x=\\"", \n  "\'><script>alert(123);</script x=\'", \n  "><script>alert(123);</script x=", \n  "\\" autofocus onkeyup=\\"javascript:alert(123)", \n  "\' autofocus onkeyup=\'javascript:alert(123)", \n  "<script\\\\x20type=\\"text/javascript\\">javascript:alert(1);</script>", \n  "<script\\\\x3Etype=\\"text/javascript\\">javascript:alert(1);</script>", \n  "<script\\\\x0Dtype=\\"text/javascript\\">javascript:alert(1);</script>", \n  "<script\\\\x09type=\\"text/javascript\\">javascript:alert(1);</script>", \n  "<script\\\\x0Ctype=\\"text/javascript\\">javascript:alert(1);</script>", \n  "<script\\\\x2Ftype=\\"text/javascript\\">javascript:alert(1);</script>", \n  "<script\\\\x0Atype=\\"text/javascript\\">javascript:alert(1);</script>", \n  "\'`\\"><\\\\x3Cscript>javascript:alert(1)</script>", \n  "\'`\\"><\\\\x00script>javascript:alert(1)</script>", \n  "ABC<div style=\\"x\\\\x3Aexpression(javascript:alert(1)\\">DEF", \n  "ABC<div style=\\"x:expression\\\\x5C(javascript:alert(1)\\">DEF", \n  "ABC<div style=\\"x:expression\\\\x00(javascript:alert(1)\\">DEF", \n  "ABC<div style=\\"x:exp\\\\x00ression(javascript:alert(1)\\">DEF", \n  "ABC<div style=\\"x:exp\\\\x5Cression(javascript:alert(1)\\">DEF", \n  "ABC<div style=\\"x:\\\\x0Aexpression(javascript:alert(1)\\">DEF", \n  "ABC<div style=\\"x:\\\\x09expression(javascript:alert(1)\\">DEF", \n  "ABC<div style=\\"x:\\\\xE3\\\\x80\\\\x80expression(javascript:alert(1)\\">DEF", \n  "ABC<div style=\\"x:\\\\xE2\\\\x80\\\\x84expression(javascript:alert(1)\\">DEF", \n  "ABC<div style=\\"x:\\\\xC2\\\\xA0expression(javascript:alert(1)\\">DEF", \n  "ABC<div style=\\"x:\\\\xE2\\\\x80\\\\x80expression(javascript:alert(1)\\">DEF", \n  "ABC<div style=\\"x:\\\\xE2\\\\x80\\\\x8Aexpression(javascript:alert(1)\\">DEF", \n  "ABC<div style=\\"x:\\\\x0Dexpression(javascript:alert(1)\\">DEF", \n  "ABC<div style=\\"x:\\\\x0Cexpression(javascript:alert(1)\\">DEF", \n  "ABC<div style=\\"x:\\\\xE2\\\\x80\\\\x87expression(javascript:alert(1)\\">DEF", \n  "ABC<div style=\\"x:\\\\xEF\\\\xBB\\\\xBFexpression(javascript:alert(1)\\">DEF", \n  "ABC<div style=\\"x:\\\\x20expression(javascript:alert(1)\\">DEF", \n  "ABC<div style=\\"x:\\\\xE2\\\\x80\\\\x88expression(javascript:alert(1)\\">DEF", \n  "ABC<div style=\\"x:\\\\x00expression(javascript:alert(1)\\">DEF", \n  "ABC<div style=\\"x:\\\\xE2\\\\x80\\\\x8Bexpression(javascript:alert(1)\\">DEF", \n  "ABC<div style=\\"x:\\\\xE2\\\\x80\\\\x86expression(javascript:alert(1)\\">DEF", \n  "ABC<div style=\\"x:\\\\xE2\\\\x80\\\\x85expression(javascript:alert(1)\\">DEF", \n  "ABC<div style=\\"x:\\\\xE2\\\\x80\\\\x82expression(javascript:alert(1)\\">DEF", \n  "ABC<div style=\\"x:\\\\x0Bexpression(javascript:alert(1)\\">DEF", \n  "ABC<div style=\\"x:\\\\xE2\\\\x80\\\\x81expression(javascript:alert(1)\\">DEF", \n  "ABC<div style=\\"x:\\\\xE2\\\\x80\\\\x83expression(javascript:alert(1)\\">DEF", \n  "ABC<div style=\\"x:\\\\xE2\\\\x80\\\\x89expression(javascript:alert(1)\\">DEF", \n  "<a href=\\"\\\\x0Bjavascript:javascript:alert(1)\\" id=\\"fuzzelement1\\">test</a>", \n  "<a href=\\"\\\\x0Fjavascript:javascript:alert(1)\\" id=\\"fuzzelement1\\">test</a>", \n  "<a href=\\"\\\\xC2\\\\xA0javascript:javascript:alert(1)\\" id=\\"fuzzelement1\\">test</a>", \n  "<a href=\\"\\\\x05javascript:javascript:alert(1)\\" id=\\"fuzzelement1\\">test</a>", \n  "<a href=\\"\\\\xE1\\\\xA0\\\\x8Ejavascript:javascript:alert(1)\\" id=\\"fuzzelement1\\">test</a>", \n  "<a href=\\"\\\\x18javascript:javascript:alert(1)\\" id=\\"fuzzelement1\\">test</a>", \n  "<a href=\\"\\\\x11javascript:javascript:alert(1)\\" id=\\"fuzzelement1\\">test</a>", \n  "<a href=\\"\\\\xE2\\\\x80\\\\x88javascript:javascript:alert(1)\\" id=\\"fuzzelement1\\">test</a>", \n  "<a href=\\"\\\\xE2\\\\x80\\\\x89javascript:javascript:alert(1)\\" id=\\"fuzzelement1\\">test</a>", \n  "<a href=\\"\\\\xE2\\\\x80\\\\x80javascript:javascript:alert(1)\\" id=\\"fuzzelement1\\">test</a>", \n  "<a href=\\"\\\\x17javascript:javascript:alert(1)\\" id=\\"fuzzelement1\\">test</a>", \n  "<a href=\\"\\\\x03javascript:javascript:alert(1)\\" id=\\"fuzzelement1\\">test</a>", \n  "<a href=\\"\\\\x0Ejavascript:javascript:alert(1)\\" id=\\"fuzzelement1\\">test</a>", \n  "<a href=\\"\\\\x1Ajavascript:javascript:alert(1)\\" id=\\"fuzzelement1\\">test</a>", \n  "<a href=\\"\\\\x00javascript:javascript:alert(1)\\" id=\\"fuzzelement1\\">test</a>", \n  "<a href=\\"\\\\x10javascript:javascript:alert(1)\\" id=\\"fuzzelement1\\">test</a>", \n  "<a href=\\"\\\\xE2\\\\x80\\\\x82javascript:javascript:alert(1)\\" id=\\"fuzzelement1\\">test</a>", \n  "<a href=\\"\\\\x20javascript:javascript:alert(1)\\" id=\\"fuzzelement1\\">test</a>", \n  "<a href=\\"\\\\x13javascript:javascript:alert(1)\\" id=\\"fuzzelement1\\">test</a>", \n  "<a href=\\"\\\\x09javascript:javascript:alert(1)\\" id=\\"fuzzelement1\\">test</a>", \n  "<a href=\\"\\\\xE2\\\\x80\\\\x8Ajavascript:javascript:alert(1)\\" id=\\"fuzzelement1\\">test</a>", \n  "<a href=\\"\\\\x14javascript:javascript:alert(1)\\" id=\\"fuzzelement1\\">test</a>", \n  "<a href=\\"\\\\x19javascript:javascript:alert(1)\\" id=\\"fuzzelement1\\">test</a>", \n  "<a href=\\"\\\\xE2\\\\x80\\\\xAFjavascript:javascript:alert(1)\\" id=\\"fuzzelement1\\">test</a>", \n  "<a href=\\"\\\\x1Fjavascript:javascript:alert(1)\\" id=\\"fuzzelement1\\">test</a>", \n  "<a href=\\"\\\\xE2\\\\x80\\\\x81javascript:javascript:alert(1)\\" id=\\"fuzzelement1\\">test</a>", \n  "<a href=\\"\\\\x1Djavascript:javascript:alert(1)\\" id=\\"fuzzelement1\\">test</a>", \n  "<a href=\\"\\\\xE2\\\\x80\\\\x87javascript:javascript:alert(1)\\" id=\\"fuzzelement1\\">test</a>", \n  "<a href=\\"\\\\x07javascript:javascript:alert(1)\\" id=\\"fuzzelement1\\">test</a>", \n  "<a href=\\"\\\\xE1\\\\x9A\\\\x80javascript:javascript:alert(1)\\" id=\\"fuzzelement1\\">test</a>", \n  "<a href=\\"\\\\xE2\\\\x80\\\\x83javascript:javascript:alert(1)\\" id=\\"fuzzelement1\\">test</a>", \n  "<a href=\\"\\\\x04javascript:javascript:alert(1)\\" id=\\"fuzzelement1\\">test</a>", \n  "<a href=\\"\\\\x01javascript:javascript:alert(1)\\" id=\\"fuzzelement1\\">test</a>", \n  "<a href=\\"\\\\x08javascript:javascript:alert(1)\\" id=\\"fuzzelement1\\">test</a>", \n  "<a href=\\"\\\\xE2\\\\x80\\\\x84javascript:javascript:alert(1)\\" id=\\"fuzzelement1\\">test</a>", \n  "<a href=\\"\\\\xE2\\\\x80\\\\x86javascript:javascript:alert(1)\\" id=\\"fuzzelement1\\">test</a>", \n  "<a href=\\"\\\\xE3\\\\x80\\\\x80javascript:javascript:alert(1)\\" id=\\"fuzzelement1\\">test</a>", \n  "<a href=\\"\\\\x12javascript:javascript:alert(1)\\" id=\\"fuzzelement1\\">test</a>", \n  "<a href=\\"\\\\x0Djavascript:javascript:alert(1)\\" id=\\"fuzzelement1\\">test</a>", \n  "<a href=\\"\\\\x0Ajavascript:javascript:alert(1)\\" id=\\"fuzzelement1\\">test</a>", \n  "<a href=\\"\\\\x0Cjavascript:javascript:alert(1)\\" id=\\"fuzzelement1\\">test</a>", \n  "<a href=\\"\\\\x15javascript:javascript:alert(1)\\" id=\\"fuzzelement1\\">test</a>", \n  "<a href=\\"\\\\xE2\\\\x80\\\\xA8javascript:javascript:alert(1)\\" id=\\"fuzzelement1\\">test</a>", \n  "<a href=\\"\\\\x16javascript:javascript:alert(1)\\" id=\\"fuzzelement1\\">test</a>", \n  "<a href=\\"\\\\x02javascript:javascript:alert(1)\\" id=\\"fuzzelement1\\">test</a>", \n  "<a href=\\"\\\\x1Bjavascript:javascript:alert(1)\\" id=\\"fuzzelement1\\">test</a>", \n  "<a href=\\"\\\\x06javascript:javascript:alert(1)\\" id=\\"fuzzelement1\\">test</a>", \n  "<a href=\\"\\\\xE2\\\\x80\\\\xA9javascript:javascript:alert(1)\\" id=\\"fuzzelement1\\">test</a>", \n  "<a href=\\"\\\\xE2\\\\x80\\\\x85javascript:javascript:alert(1)\\" id=\\"fuzzelement1\\">test</a>", \n  "<a href=\\"\\\\x1Ejavascript:javascript:alert(1)\\" id=\\"fuzzelement1\\">test</a>", \n  "<a href=\\"\\\\xE2\\\\x81\\\\x9Fjavascript:javascript:alert(1)\\" id=\\"fuzzelement1\\">test</a>", \n  "<a href=\\"\\\\x1Cjavascript:javascript:alert(1)\\" id=\\"fuzzelement1\\">test</a>", \n  "<a href=\\"javascript\\\\x00:javascript:alert(1)\\" id=\\"fuzzelement1\\">test</a>", \n  "<a href=\\"javascript\\\\x3A:javascript:alert(1)\\" id=\\"fuzzelement1\\">test</a>", \n  "<a href=\\"javascript\\\\x09:javascript:alert(1)\\" id=\\"fuzzelement1\\">test</a>", \n  "<a href=\\"javascript\\\\x0D:javascript:alert(1)\\" id=\\"fuzzelement1\\">test</a>", \n  "<a href=\\"javascript\\\\x0A:javascript:alert(1)\\" id=\\"fuzzelement1\\">test</a>", \n  "`\\"\'><img src=xxx:x \\\\x0Aonerror=javascript:alert(1)>", \n  "`\\"\'><img src=xxx:x \\\\x22onerror=javascript:alert(1)>", \n  "`\\"\'><img src=xxx:x \\\\x0Bonerror=javascript:alert(1)>", \n  "`\\"\'><img src=xxx:x \\\\x0Donerror=javascript:alert(1)>", \n  "`\\"\'><img src=xxx:x \\\\x2Fonerror=javascript:alert(1)>", \n  "`\\"\'><img src=xxx:x \\\\x09onerror=javascript:alert(1)>", \n  "`\\"\'><img src=xxx:x \\\\x0Conerror=javascript:alert(1)>", \n  "`\\"\'><img src=xxx:x \\\\x00onerror=javascript:alert(1)>", \n  "`\\"\'><img src=xxx:x \\\\x27onerror=javascript:alert(1)>", \n  "`\\"\'><img src=xxx:x \\\\x20onerror=javascript:alert(1)>", \n  "\\"`\'><script>\\\\x3Bjavascript:alert(1)</script>", \n  "\\"`\'><script>\\\\x0Djavascript:alert(1)</script>", \n  "\\"`\'><script>\\\\xEF\\\\xBB\\\\xBFjavascript:alert(1)</script>", \n  "\\"`\'><script>\\\\xE2\\\\x80\\\\x81javascript:alert(1)</script>", \n  "\\"`\'><script>\\\\xE2\\\\x80\\\\x84javascript:alert(1)</script>", \n  "\\"`\'><script>\\\\xE3\\\\x80\\\\x80javascript:alert(1)</script>", \n  "\\"`\'><script>\\\\x09javascript:alert(1)</script>", \n  "\\"`\'><script>\\\\xE2\\\\x80\\\\x89javascript:alert(1)</script>", \n  "\\"`\'><script>\\\\xE2\\\\x80\\\\x85javascript:alert(1)</script>", \n  "\\"`\'><script>\\\\xE2\\\\x80\\\\x88javascript:alert(1)</script>", \n  "\\"`\'><script>\\\\x00javascript:alert(1)</script>", \n  "\\"`\'><script>\\\\xE2\\\\x80\\\\xA8javascript:alert(1)</script>", \n  "\\"`\'><script>\\\\xE2\\\\x80\\\\x8Ajavascript:alert(1)</script>", \n  "\\"`\'><script>\\\\xE1\\\\x9A\\\\x80javascript:alert(1)</script>", \n  "\\"`\'><script>\\\\x0Cjavascript:alert(1)</script>", \n  "\\"`\'><script>\\\\x2Bjavascript:alert(1)</script>", \n  "\\"`\'><script>\\\\xF0\\\\x90\\\\x96\\\\x9Ajavascript:alert(1)</script>", \n  "\\"`\'><script>-javascript:alert(1)</script>", \n  "\\"`\'><script>\\\\x0Ajavascript:alert(1)</script>", \n  "\\"`\'><script>\\\\xE2\\\\x80\\\\xAFjavascript:alert(1)</script>", \n  "\\"`\'><script>\\\\x7Ejavascript:alert(1)</script>", \n  "\\"`\'><script>\\\\xE2\\\\x80\\\\x87javascript:alert(1)</script>", \n  "\\"`\'><script>\\\\xE2\\\\x81\\\\x9Fjavascript:alert(1)</script>", \n  "\\"`\'><script>\\\\xE2\\\\x80\\\\xA9javascript:alert(1)</script>", \n  "\\"`\'><script>\\\\xC2\\\\x85javascript:alert(1)</script>", \n  "\\"`\'><script>\\\\xEF\\\\xBF\\\\xAEjavascript:alert(1)</script>", \n  "\\"`\'><script>\\\\xE2\\\\x80\\\\x83javascript:alert(1)</script>", \n  "\\"`\'><script>\\\\xE2\\\\x80\\\\x8Bjavascript:alert(1)</script>", \n  "\\"`\'><script>\\\\xEF\\\\xBF\\\\xBEjavascript:alert(1)</script>", \n  "\\"`\'><script>\\\\xE2\\\\x80\\\\x80javascript:alert(1)</script>", \n  "\\"`\'><script>\\\\x21javascript:alert(1)</script>", \n  "\\"`\'><script>\\\\xE2\\\\x80\\\\x82javascript:alert(1)</script>", \n  "\\"`\'><script>\\\\xE2\\\\x80\\\\x86javascript:alert(1)</script>", \n  "\\"`\'><script>\\\\xE1\\\\xA0\\\\x8Ejavascript:alert(1)</script>", \n  "\\"`\'><script>\\\\x0Bjavascript:alert(1)</script>", \n  "\\"`\'><script>\\\\x20javascript:alert(1)</script>", \n  "\\"`\'><script>\\\\xC2\\\\xA0javascript:alert(1)</script>", \n  "<img \\\\x00src=x onerror=\\"alert(1)\\">", \n  "<img \\\\x47src=x onerror=\\"javascript:alert(1)\\">", \n  "<img \\\\x11src=x onerror=\\"javascript:alert(1)\\">", \n  "<img \\\\x12src=x onerror=\\"javascript:alert(1)\\">", \n  "<img\\\\x47src=x onerror=\\"javascript:alert(1)\\">", \n  "<img\\\\x10src=x onerror=\\"javascript:alert(1)\\">", \n  "<img\\\\x13src=x onerror=\\"javascript:alert(1)\\">", \n  "<img\\\\x32src=x onerror=\\"javascript:alert(1)\\">", \n  "<img\\\\x47src=x onerror=\\"javascript:alert(1)\\">", \n  "<img\\\\x11src=x onerror=\\"javascript:alert(1)\\">", \n  "<img \\\\x47src=x onerror=\\"javascript:alert(1)\\">", \n  "<img \\\\x34src=x onerror=\\"javascript:alert(1)\\">", \n  "<img \\\\x39src=x onerror=\\"javascript:alert(1)\\">", \n  "<img \\\\x00src=x onerror=\\"javascript:alert(1)\\">", \n  "<img src\\\\x09=x onerror=\\"javascript:alert(1)\\">", \n  "<img src\\\\x10=x onerror=\\"javascript:alert(1)\\">", \n  "<img src\\\\x13=x onerror=\\"javascript:alert(1)\\">", \n  "<img src\\\\x32=x onerror=\\"javascript:alert(1)\\">", \n  "<img src\\\\x12=x onerror=\\"javascript:alert(1)\\">", \n  "<img src\\\\x11=x onerror=\\"javascript:alert(1)\\">", \n  "<img src\\\\x00=x onerror=\\"javascript:alert(1)\\">", \n  "<img src\\\\x47=x onerror=\\"javascript:alert(1)\\">", \n  "<img src=x\\\\x09onerror=\\"javascript:alert(1)\\">", \n  "<img src=x\\\\x10onerror=\\"javascript:alert(1)\\">", \n  "<img src=x\\\\x11onerror=\\"javascript:alert(1)\\">", \n  "<img src=x\\\\x12onerror=\\"javascript:alert(1)\\">", \n  "<img src=x\\\\x13onerror=\\"javascript:alert(1)\\">", \n  "<img[a][b][c]src[d]=x[e]onerror=[f]\\"alert(1)\\">", \n  "<img src=x onerror=\\\\x09\\"javascript:alert(1)\\">", \n  "<img src=x onerror=\\\\x10\\"javascript:alert(1)\\">", \n  "<img src=x onerror=\\\\x11\\"javascript:alert(1)\\">", \n  "<img src=x onerror=\\\\x12\\"javascript:alert(1)\\">", \n  "<img src=x onerror=\\\\x32\\"javascript:alert(1)\\">", \n  "<img src=x onerror=\\\\x00\\"javascript:alert(1)\\">", \n  "<a href=java&#1&#2&#3&#4&#5&#6&#7&#8&#11&#12script:javascript:alert(1)>XXX</a>", \n  "<img src=\\"x` `<script>javascript:alert(1)</script>\\"` `>", \n  "<img src onerror /\\" \'\\"= alt=javascript:alert(1)//\\">", \n  "<title onpropertychange=javascript:alert(1)></title><title title=>", \n  "<a href=http://foo.bar/#x=`y></a><img alt=\\"`><img src=x:x onerror=javascript:alert(1)></a>\\">", \n  "<!--[if]><script>javascript:alert(1)</script -->", \n  "<!--[if<img src=x onerror=javascript:alert(1)//]> -->", \n  "<script src=\\"/\\\\%(jscript)s\\"></script>", \n  "<script src=\\"\\\\\\\\%(jscript)s\\"></script>", \n  "<IMG \\"\\"\\"><SCRIPT>alert(\\"XSS\\")</SCRIPT>\\">", \n  "<IMG SRC=javascript:alert(String.fromCharCode(88,83,83))>", \n  "<IMG SRC=# onmouseover=\\"alert(\'xxs\')\\">", \n  "<IMG SRC= onmouseover=\\"alert(\'xxs\')\\">", \n  "<IMG onmouseover=\\"alert(\'xxs\')\\">", \n  "<IMG SRC=&#106;&#97;&#118;&#97;&#115;&#99;&#114;&#105;&#112;&#116;&#58;&#97;&#108;&#101;&#114;&#116;&#40;&#39;&#88;&#83;&#83;&#39;&#41;>", \n  "<IMG SRC=&#0000106&#0000097&#0000118&#0000097&#0000115&#0000099&#0000114&#0000105&#0000112&#0000116&#0000058&#0000097&#0000108&#0000101&#0000114&#0000116&#0000040&#0000039&#0000088&#0000083&#0000083&#0000039&#0000041>", \n  "<IMG SRC=&#x6A&#x61&#x76&#x61&#x73&#x63&#x72&#x69&#x70&#x74&#x3A&#x61&#x6C&#x65&#x72&#x74&#x28&#x27&#x58&#x53&#x53&#x27&#x29>", \n  "<IMG SRC=\\"jav   ascript:alert(\'XSS\');\\">", \n  "<IMG SRC=\\"jav&#x09;ascript:alert(\'XSS\');\\">", \n  "<IMG SRC=\\"jav&#x0A;ascript:alert(\'XSS\');\\">", \n  "<IMG SRC=\\"jav&#x0D;ascript:alert(\'XSS\');\\">", \n  "perl -e \'print \\"<IMG SRC=java\\\\0script:alert(\\\\\\"XSS\\\\\\")>\\";\' > out", \n  "<IMG SRC=\\" &#14;  javascript:alert(\'XSS\');\\">", \n  "<SCRIPT/XSS SRC=\\"http://ha.ckers.org/xss.js\\"></SCRIPT>", \n  "<BODY onload!#$%&()*~+-_.,:;?@[/|\\\\]^`=alert(\\"XSS\\")>", \n  "<SCRIPT/SRC=\\"http://ha.ckers.org/xss.js\\"></SCRIPT>", \n  "<<SCRIPT>alert(\\"XSS\\");//<</SCRIPT>", \n  "<SCRIPT SRC=http://ha.ckers.org/xss.js?< B >", \n  "<SCRIPT SRC=//ha.ckers.org/.j>", \n  "<IMG SRC=\\"javascript:alert(\'XSS\')\\"", \n  "<iframe src=http://ha.ckers.org/scriptlet.html <", \n  "\\\\\\";alert(\'XSS\');//", \n  "<u oncopy=alert()> Copy me</u>", \n  "<i onwheel=alert(1)> Scroll over me </i>", \n  "<plaintext>", \n  "http://a/%%30%30", \n  "</textarea><script>alert(123)</script>", \n  "1;DROP TABLE users", \n  "1\'; DROP TABLE users-- 1", \n  "\' OR 1=1 -- 1", \n  "\' OR \'1\'=\'1", \n  "\'; EXEC sp_MSForEachTable \'DROP TABLE ?\'; --",\n  " ", \n  "%", \n  "_", \n  "-", \n  "--", \n  "--version", \n  "--help", \n  "$USER", \n  "/dev/null; touch /tmp/blns.fail ; echo", \n  "`touch /tmp/blns.fail`", \n  "$(touch /tmp/blns.fail)", \n  "@{[system \\"touch /tmp/blns.fail\\"]}", \n  "eval(\\"puts \'hello world\'\\")", \n  "System(\\"ls -al /\\")", \n  "`ls -al /`", \n  "Kernel.exec(\\"ls -al /\\")", \n  "Kernel.exit(1)", \n  "%x(\'ls -al /\')", \n  "<?xml version=\\"1.0\\" encoding=\\"ISO-8859-1\\"?><!DOCTYPE foo [ <!ELEMENT foo ANY ><!ENTITY xxe SYSTEM \\"file:///etc/passwd\\" >]><foo>&xxe;</foo>", \n  "$HOME", \n  "$ENV{\'HOME\'}", \n  "%d", \n  "%s%s%s%s%s", \n  "{0}", \n  "%*.*s", \n  "%@", \n  "%n", \n  "File:///", \n  "../../../../../../../../../../../etc/passwd%00", \n  "../../../../../../../../../../../etc/hosts", \n  "() { 0; }; touch /tmp/blns.shellshock1.fail;", \n  "() { _; } >_[$($())] { touch /tmp/blns.shellshock2.fail; }", \n  "<<< %s(un=\'%s\') = %u", \n  "+++ATH0", \n  "CON", \n  "PRN", \n  "AUX", \n  "CLOCK$", \n  "NUL", \n  "A:", \n  "ZZ:", \n  "COM1", \n  "LPT1", \n  "LPT2", \n  "LPT3", \n  "COM2", \n  "COM3", \n  "COM4", \n  "DCC SEND STARTKEYLOGGER 0 0 0", \n  "Scunthorpe General Hospital", \n  "Penistone Community Church", \n  "Lightwater Country Park", \n  "Jimmy Clitheroe", \n  "Horniman Museum", \n  "shitake mushrooms", \n  "RomansInSussex.co.uk", \n  "http://www.cum.qc.ca/", \n  "Craig Cockburn, Software Specialist", \n  "Linda Callahan", \n  "Dr. Herman I. Libshitz", \n  "magna cum laude", \n  "Super Bowl XXX", \n  "medieval erection of parapets", \n  "evaluate", \n  "mocha", \n  "expression", \n  "Arsenal canal", \n  "classic", \n  "Tyson Gay", \n  "Dick Van Dyke", \n  "basement", \n  "If you\'re reading this, you\'ve been in a coma for almost 20 years now. We\'re trying a new technique. We don\'t know where this message will end up in your dream, but we hope it works. Please wake up, we miss you.", \n  "Roses are \\u001b[0;31mred\\u001b[0m, violets are \\u001b[0;34mblue. Hope you enjoy terminal hue", \n  "But now...\\u001b[20Cfor my greatest trick...\\u001b[8m", \n  "The quic\\b\\b\\b\\b\\b\\bk brown fo\\u0007\\u0007\\u0007\\u0007\\u0007\\u0007\\u0007\\u0007\\u0007\\u0007\\u0007x... [Beeeep]", \n  "Powerلُلُصّبُلُلصّبُررً ॣ ॣh ॣ ॣ冗", \n  "🏳0🌈️",\n  "జ్ఞ‌ా",\n  "گچپژ",\n  "{% print \'x\' * 64 * 1024**3 %}",\n  "{{ \\"\\".__class__.__mro__[2].__subclasses__()[40](\\"/etc/passwd\\").read() }}"\n]\n}',
    'x',
    'Array(String)') FORMAT Values;

SELECT '','undefined','undef','null','NULL','(null)','nil','NIL','true','false','True','False','TRUE','FALSE','None','hasOwnProperty','then','\\','\\\\','0','1','1.00','$1.00','1/2','1E2','1E02','1E+02','-1','-1.00','-$1.00','-1/2','-1E2','-1E02','-1E+02','1/0','0/0','-2147483648/-1','-9223372036854775808/-1','-0','-0.0','+0','+0.0','0.00','0..0','.','0.0.0','0,00','0,,0',',','0,0,0','0.0/0','1.0/0.0','0.0/0.0','1,0/0,0','0,0/0,0','--1','-','-.','-,','999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999','NaN','Infinity','-Infinity','INF','1#INF','-1#IND','1#QNAN','1#SNAN','1#IND','0x0','0xffffffff','0xffffffffffffffff','0xabad1dea','123456789012345678901234567890123456789','1,000.00','1 000.00','1\'000.00','1,000,000.00','1 000 000.00','1\'000\'000.00','1.000,00','1 000,00','1\'000,00','1.000.000,00','1 000 000,00','1\'000\'000,00','01000','08','09','2.2250738585072011e-308',',./;\'[]\\-=','<>?:"{}|_+','!@#$%^&*()`~','\b','','\t\f              ​    　','­؀؁؂؃؄؅؜۝܏᠎​‌‍‎‏‪‫‬‭‮⁠⁡⁢⁣⁤⁦⁧⁨⁩⁪⁫⁬⁭⁮⁯﻿￹￺￻𑂽𛲠𛲡𛲢𛲣𝅳𝅴𝅵𝅶𝅷𝅸𝅹𝅺󠀁󠀠󠀡󠀢󠀣󠀤󠀥󠀦󠀧󠀨󠀩󠀪󠀫󠀬󠀭󠀮󠀯󠀰󠀱󠀲󠀳󠀴󠀵󠀶󠀷󠀸󠀹󠀺󠀻󠀼󠀽󠀾󠀿󠁀󠁁󠁂󠁃󠁄󠁅󠁆󠁇󠁈󠁉󠁊󠁋󠁌󠁍󠁎󠁏󠁐󠁑󠁒󠁓󠁔󠁕󠁖󠁗󠁘󠁙󠁚󠁛󠁜󠁝󠁞󠁟󠁠󠁡󠁢󠁣󠁤󠁥󠁦󠁧󠁨󠁩󠁪󠁫󠁬󠁭󠁮󠁯󠁰󠁱󠁲󠁳󠁴󠁵󠁶󠁷󠁸󠁹󠁺󠁻󠁼󠁽󠁾󠁿','﻿','￾','Ω≈ç√∫˜µ≤≥÷','åß∂ƒ©˙∆˚¬…æ','œ∑´®†¥¨ˆøπ“‘','¡™£¢∞§¶•ªº–≠','¸˛Ç◊ı˜Â¯˘¿','ÅÍÎÏ˝ÓÔÒÚÆ☃','Œ„´‰ˇÁ¨ˆØ∏”’','`⁄€‹›ﬁﬂ‡°·‚—±','⅛⅜⅝⅞','ЁЂЃЄЅІЇЈЉЊЋЌЍЎЏАБВГДЕЖЗИЙКЛМНОПРСТУФХЦЧШЩЪЫЬЭЮЯабвгдежзийклмнопрстуфхцчшщъыьэюя','٠١٢٣٤٥٦٧٨٩','⁰⁴⁵','₀₁₂','⁰⁴⁵₀₁₂','ด้้้้้็็็็็้้้้้็็็็็้้้้้้้้็็็็็้้้้้็็็็็้้้้้้้้็็็็็้้้้้็็็็็้้้้้้้้็็็็็้้้้้็็็็ ด้้้้้็็็็็้้้้้็็็็็้้้้้้้้็็็็็้้้้้็็็็็้้้้้้้้็็็็็้้้้้็็็็็้้้้้้้้็็็็็้้้้้็็็็ ด้้้้้็็็็็้้้้้็็็็็้้้้้้้้็็็็็้้้้้็็็็็้้้้้้้้็็็็็้้้้้็็็็็้้้้้้้้็็็็็้้้้้็็็็','\'','"','\'\'','""','\'"\'','"\'\'\'\'"\'"','"\'"\'"\'\'\'\'"','<foo val=“bar” />','<foo val=“bar” />','<foo val=”bar“ />','<foo val=`bar\' />','田中さんにあげて下さい','パーティーへ行かないか','和製漢語','部落格','사회과학원 어학연구소','찦차를 타고 온 펲시맨과 쑛다리 똠방각하','社會科學院語學研究所','울란바토르','𠜎𠜱𠝹𠱓𠱸𠲖𠳏','𐐜 𐐔𐐇𐐝𐐀𐐡𐐇𐐓 𐐙𐐊𐐡𐐝𐐓/𐐝𐐇𐐗𐐊𐐤𐐔 𐐒𐐋𐐗 𐐒𐐌 𐐜 𐐡𐐀𐐖𐐇𐐤𐐓𐐝 𐐱𐑂 𐑄 𐐔𐐇𐐝𐐀𐐡𐐇𐐓 𐐏𐐆𐐅𐐤𐐆𐐚𐐊𐐡𐐝𐐆𐐓𐐆','表ポあA鷗ŒéＢ逍Üßªąñ丂㐀𠀀','Ⱥ','Ⱦ','ヽ༼ຈل͜ຈ༽ﾉ ヽ༼ຈل͜ຈ༽ﾉ','(｡◕ ∀ ◕｡)','｀ｨ(´∀｀∩','__ﾛ(,_,*)','・(￣∀￣)・:*:','ﾟ･✿ヾ╲(｡◕‿◕｡)╱✿･ﾟ',',。・:*:・゜’( ☻ ω ☻ )。・:*:・゜’','(╯°□°）╯︵ ┻━┻)','(ﾉಥ益ಥ）ﾉ﻿ ┻━┻','┬─┬ノ( º _ ºノ)','( ͡° ͜ʖ ͡°)','¯\\_(ツ)_/¯','😍','👩🏽','👨‍🦰 👨🏿‍🦰 👨‍🦱 👨🏿‍🦱 🦹🏿‍♂️','👾 🙇 💁 🙅 🙆 🙋 🙎 🙍','🐵 🙈 🙉 🙊','❤️ 💔 💌 💕 💞 💓 💗 💖 💘 💝 💟 💜 💛 💚 💙','✋🏿 💪🏿 👐🏿 🙌🏿 👏🏿 🙏🏿','👨‍👩‍👦 👨‍👩‍👧‍👦 👨‍👨‍👦 👩‍👩‍👧 👨‍👦 👨‍👧‍👦 👩‍👦 👩‍👧‍👦','🚾 🆒 🆓 🆕 🆖 🆗 🆙 🏧','0️⃣ 1️⃣ 2️⃣ 3️⃣ 4️⃣ 5️⃣ 6️⃣ 7️⃣ 8️⃣ 9️⃣ 🔟','🇺🇸🇷🇺🇸 🇦🇫🇦🇲🇸','🇺🇸🇷🇺🇸🇦🇫🇦🇲','🇺🇸🇷🇺🇸🇦','１２３','١٢٣','ثم نفس سقطت وبالتحديد،, جزيرتي باستخدام أن دنو. إذ هنا؟ الستار وتنصيب كان. أهّل ايطاليا، بريطانيا-فرنسا قد أخذ. سليمان، إتفاقية بين ما, يذكر الحدود أي بعد, معاملة بولندا، الإطلاق عل إيو.','בְּרֵאשִׁית, בָּרָא אֱלֹהִים, אֵת הַשָּׁמַיִם, וְאֵת הָאָרֶץ','הָיְתָהtestالصفحات التّحول','﷽','ﷺ','مُنَاقَشَةُ سُبُلِ اِسْتِخْدَامِ اللُّغَةِ فِي النُّظُمِ الْقَائِمَةِ وَفِيم يَخُصَّ التَّطْبِيقَاتُ الْحاسُوبِيَّةُ، ','᚛ᚄᚓᚐᚋᚒᚄ ᚑᚄᚂᚑᚏᚅ᚜‪‪‪','‪‪᚛                 ᚜‪','‪‪test‪','‫test‫',' test ','test⁠test‫','⁦test⁧','Ṱ̺̺̕o͞ ̷i̲̬͇̪͙n̝̗͕v̟̜̘̦͟o̶̙̰̠kè͚̮̺̪̹̱̤ ̖t̝͕̳̣̻̪͞h̼͓̲̦̳̘̲e͇̣̰̦̬͎ ̢̼̻̱̘h͚͎͙̜̣̲ͅi̦̲̣̰̤v̻͍e̺̭̳̪̰-m̢iͅn̖̺̞̲̯̰d̵̼̟͙̩̼̘̳ ̞̥̱̳̭r̛̗̘e͙p͠r̼̞̻̭̗e̺̠̣͟s̘͇̳͍̝͉e͉̥̯̞̲͚̬͜ǹ̬͎͎̟̖͇̤t͍̬̤͓̼̭͘ͅi̪̱n͠g̴͉ ͏͉ͅc̬̟h͡a̫̻̯͘o̫̟̖͍̙̝͉s̗̦̲.̨̹͈̣','̡͓̞ͅI̗̘̦͝n͇͇͙v̮̫ok̲̫̙͈i̖͙̭̹̠̞n̡̻̮̣̺g̲͈͙̭͙̬͎ ̰t͔̦h̞̲e̢̤ ͍̬̲͖f̴̘͕̣è͖ẹ̥̩l͖͔͚i͓͚̦͠n͖͍̗͓̳̮g͍ ̨o͚̪͡f̘̣̬ ̖̘͖̟͙̮c҉͔̫͖͓͇͖ͅh̵̤̣͚͔á̗̼͕ͅo̼̣̥s̱͈̺̖̦̻͢.̛̖̞̠̫̰','̗̺͖̹̯͓Ṯ̤͍̥͇͈h̲́e͏͓̼̗̙̼̣͔ ͇̜̱̠͓͍ͅN͕͠e̗̱z̘̝̜̺͙p̤̺̹͍̯͚e̠̻̠͜r̨̤͍̺̖͔̖̖d̠̟̭̬̝͟i̦͖̩͓͔̤a̠̗̬͉̙n͚͜ ̻̞̰͚ͅh̵͉i̳̞v̢͇ḙ͎͟-҉̭̩̼͔m̤̭̫i͕͇̝̦n̗͙ḍ̟ ̯̲͕͞ǫ̟̯̰̲͙̻̝f ̪̰̰̗̖̭̘͘c̦͍̲̞͍̩̙ḥ͚a̮͎̟̙͜ơ̩̹͎s̤.̝̝ ҉Z̡̖̜͖̰̣͉̜a͖̰͙̬͡l̲̫̳͍̩g̡̟̼̱͚̞̬ͅo̗͜.̟','̦H̬̤̗̤͝e͜ ̜̥̝̻͍̟́w̕h̖̯͓o̝͙̖͎̱̮ ҉̺̙̞̟͈W̷̼̭a̺̪͍į͈͕̭͙̯̜t̶̼̮s̘͙͖̕ ̠̫̠B̻͍͙͉̳ͅe̵h̵̬͇̫͙i̹͓̳̳̮͎̫̕n͟d̴̪̜̖ ̰͉̩͇͙̲͞ͅT͖̼͓̪͢h͏͓̮̻e̬̝̟ͅ ̤̹̝W͙̞̝͔͇͝ͅa͏͓͔̹̼̣l̴͔̰̤̟͔ḽ̫.͕','Z̮̞̠͙͔ͅḀ̗̞͈̻̗Ḷ͙͎̯̹̞͓G̻O̭̗̮','˙ɐnbᴉlɐ ɐuƃɐɯ ǝɹolop ʇǝ ǝɹoqɐl ʇn ʇunpᴉpᴉɔuᴉ ɹodɯǝʇ poɯsnᴉǝ op pǝs \'ʇᴉlǝ ƃuᴉɔsᴉdᴉpɐ ɹnʇǝʇɔǝsuoɔ \'ʇǝɯɐ ʇᴉs ɹolop ɯnsdᴉ ɯǝɹo˥','00˙Ɩ$-','Ｔｈｅ ｑｕｉｃｋ ｂｒｏｗｎ ｆｏｘ ｊｕｍｐｓ ｏｖｅｒ ｔｈｅ ｌａｚｙ ｄｏｇ','𝐓𝐡𝐞 𝐪𝐮𝐢𝐜𝐤 𝐛𝐫𝐨𝐰𝐧 𝐟𝐨𝐱 𝐣𝐮𝐦𝐩𝐬 𝐨𝐯𝐞𝐫 𝐭𝐡𝐞 𝐥𝐚𝐳𝐲 𝐝𝐨𝐠','𝕿𝖍𝖊 𝖖𝖚𝖎𝖈𝖐 𝖇𝖗𝖔𝖜𝖓 𝖋𝖔𝖝 𝖏𝖚𝖒𝖕𝖘 𝖔𝖛𝖊𝖗 𝖙𝖍𝖊 𝖑𝖆𝖟𝖞 𝖉𝖔𝖌','𝑻𝒉𝒆 𝒒𝒖𝒊𝒄𝒌 𝒃𝒓𝒐𝒘𝒏 𝒇𝒐𝒙 𝒋𝒖𝒎𝒑𝒔 𝒐𝒗𝒆𝒓 𝒕𝒉𝒆 𝒍𝒂𝒛𝒚 𝒅𝒐𝒈','𝓣𝓱𝓮 𝓺𝓾𝓲𝓬𝓴 𝓫𝓻𝓸𝔀𝓷 𝓯𝓸𝔁 𝓳𝓾𝓶𝓹𝓼 𝓸𝓿𝓮𝓻 𝓽𝓱𝓮 𝓵𝓪𝔃𝔂 𝓭𝓸𝓰','𝕋𝕙𝕖 𝕢𝕦𝕚𝕔𝕜 𝕓𝕣𝕠𝕨𝕟 𝕗𝕠𝕩 𝕛𝕦𝕞𝕡𝕤 𝕠𝕧𝕖𝕣 𝕥𝕙𝕖 𝕝𝕒𝕫𝕪 𝕕𝕠𝕘','𝚃𝚑𝚎 𝚚𝚞𝚒𝚌𝚔 𝚋𝚛𝚘𝚠𝚗 𝚏𝚘𝚡 𝚓𝚞𝚖𝚙𝚜 𝚘𝚟𝚎𝚛 𝚝𝚑𝚎 𝚕𝚊𝚣𝚢 𝚍𝚘𝚐','⒯⒣⒠ ⒬⒰⒤⒞⒦ ⒝⒭⒪⒲⒩ ⒡⒪⒳ ⒥⒰⒨⒫⒮ ⒪⒱⒠⒭ ⒯⒣⒠ ⒧⒜⒵⒴ ⒟⒪⒢','<script>alert(123)</script>','&lt;script&gt;alert(&#39;123&#39;);&lt;/script&gt;','<img src=x onerror=alert(123) />','<svg><script>123<1>alert(123)</script>','"><script>alert(123)</script>','\'><script>alert(123)</script>','><script>alert(123)</script>','</script><script>alert(123)</script>','< / script >< script >alert(123)< / script >',' onfocus=JaVaSCript:alert(123) autofocus','" onfocus=JaVaSCript:alert(123) autofocus','\' onfocus=JaVaSCript:alert(123) autofocus','＜script＞alert(123)＜/script＞','<sc<script>ript>alert(123)</sc</script>ript>','--><script>alert(123)</script>','";alert(123);t="','\';alert(123);t=\'','JavaSCript:alert(123)',';alert(123);','src=JaVaSCript:prompt(132)','"><script>alert(123);</script x="','\'><script>alert(123);</script x=\'','><script>alert(123);</script x=','" autofocus onkeyup="javascript:alert(123)','\' autofocus onkeyup=\'javascript:alert(123)','<script\\x20type="text/javascript">javascript:alert(1);</script>','<script\\x3Etype="text/javascript">javascript:alert(1);</script>','<script\\x0Dtype="text/javascript">javascript:alert(1);</script>','<script\\x09type="text/javascript">javascript:alert(1);</script>','<script\\x0Ctype="text/javascript">javascript:alert(1);</script>','<script\\x2Ftype="text/javascript">javascript:alert(1);</script>','<script\\x0Atype="text/javascript">javascript:alert(1);</script>','\'`"><\\x3Cscript>javascript:alert(1)</script>','\'`"><\\x00script>javascript:alert(1)</script>','ABC<div style="x\\x3Aexpression(javascript:alert(1)">DEF','ABC<div style="x:expression\\x5C(javascript:alert(1)">DEF','ABC<div style="x:expression\\x00(javascript:alert(1)">DEF','ABC<div style="x:exp\\x00ression(javascript:alert(1)">DEF','ABC<div style="x:exp\\x5Cression(javascript:alert(1)">DEF','ABC<div style="x:\\x0Aexpression(javascript:alert(1)">DEF','ABC<div style="x:\\x09expression(javascript:alert(1)">DEF','ABC<div style="x:\\xE3\\x80\\x80expression(javascript:alert(1)">DEF','ABC<div style="x:\\xE2\\x80\\x84expression(javascript:alert(1)">DEF','ABC<div style="x:\\xC2\\xA0expression(javascript:alert(1)">DEF','ABC<div style="x:\\xE2\\x80\\x80expression(javascript:alert(1)">DEF','ABC<div style="x:\\xE2\\x80\\x8Aexpression(javascript:alert(1)">DEF','ABC<div style="x:\\x0Dexpression(javascript:alert(1)">DEF','ABC<div style="x:\\x0Cexpression(javascript:alert(1)">DEF','ABC<div style="x:\\xE2\\x80\\x87expression(javascript:alert(1)">DEF','ABC<div style="x:\\xEF\\xBB\\xBFexpression(javascript:alert(1)">DEF','ABC<div style="x:\\x20expression(javascript:alert(1)">DEF','ABC<div style="x:\\xE2\\x80\\x88expression(javascript:alert(1)">DEF','ABC<div style="x:\\x00expression(javascript:alert(1)">DEF','ABC<div style="x:\\xE2\\x80\\x8Bexpression(javascript:alert(1)">DEF','ABC<div style="x:\\xE2\\x80\\x86expression(javascript:alert(1)">DEF','ABC<div style="x:\\xE2\\x80\\x85expression(javascript:alert(1)">DEF','ABC<div style="x:\\xE2\\x80\\x82expression(javascript:alert(1)">DEF','ABC<div style="x:\\x0Bexpression(javascript:alert(1)">DEF','ABC<div style="x:\\xE2\\x80\\x81expression(javascript:alert(1)">DEF','ABC<div style="x:\\xE2\\x80\\x83expression(javascript:alert(1)">DEF','ABC<div style="x:\\xE2\\x80\\x89expression(javascript:alert(1)">DEF','<a href="\\x0Bjavascript:javascript:alert(1)" id="fuzzelement1">test</a>','<a href="\\x0Fjavascript:javascript:alert(1)" id="fuzzelement1">test</a>','<a href="\\xC2\\xA0javascript:javascript:alert(1)" id="fuzzelement1">test</a>','<a href="\\x05javascript:javascript:alert(1)" id="fuzzelement1">test</a>','<a href="\\xE1\\xA0\\x8Ejavascript:javascript:alert(1)" id="fuzzelement1">test</a>','<a href="\\x18javascript:javascript:alert(1)" id="fuzzelement1">test</a>','<a href="\\x11javascript:javascript:alert(1)" id="fuzzelement1">test</a>','<a href="\\xE2\\x80\\x88javascript:javascript:alert(1)" id="fuzzelement1">test</a>','<a href="\\xE2\\x80\\x89javascript:javascript:alert(1)" id="fuzzelement1">test</a>','<a href="\\xE2\\x80\\x80javascript:javascript:alert(1)" id="fuzzelement1">test</a>','<a href="\\x17javascript:javascript:alert(1)" id="fuzzelement1">test</a>','<a href="\\x03javascript:javascript:alert(1)" id="fuzzelement1">test</a>','<a href="\\x0Ejavascript:javascript:alert(1)" id="fuzzelement1">test</a>','<a href="\\x1Ajavascript:javascript:alert(1)" id="fuzzelement1">test</a>','<a href="\\x00javascript:javascript:alert(1)" id="fuzzelement1">test</a>','<a href="\\x10javascript:javascript:alert(1)" id="fuzzelement1">test</a>','<a href="\\xE2\\x80\\x82javascript:javascript:alert(1)" id="fuzzelement1">test</a>','<a href="\\x20javascript:javascript:alert(1)" id="fuzzelement1">test</a>','<a href="\\x13javascript:javascript:alert(1)" id="fuzzelement1">test</a>','<a href="\\x09javascript:javascript:alert(1)" id="fuzzelement1">test</a>','<a href="\\xE2\\x80\\x8Ajavascript:javascript:alert(1)" id="fuzzelement1">test</a>','<a href="\\x14javascript:javascript:alert(1)" id="fuzzelement1">test</a>','<a href="\\x19javascript:javascript:alert(1)" id="fuzzelement1">test</a>','<a href="\\xE2\\x80\\xAFjavascript:javascript:alert(1)" id="fuzzelement1">test</a>','<a href="\\x1Fjavascript:javascript:alert(1)" id="fuzzelement1">test</a>','<a href="\\xE2\\x80\\x81javascript:javascript:alert(1)" id="fuzzelement1">test</a>','<a href="\\x1Djavascript:javascript:alert(1)" id="fuzzelement1">test</a>','<a href="\\xE2\\x80\\x87javascript:javascript:alert(1)" id="fuzzelement1">test</a>','<a href="\\x07javascript:javascript:alert(1)" id="fuzzelement1">test</a>','<a href="\\xE1\\x9A\\x80javascript:javascript:alert(1)" id="fuzzelement1">test</a>','<a href="\\xE2\\x80\\x83javascript:javascript:alert(1)" id="fuzzelement1">test</a>','<a href="\\x04javascript:javascript:alert(1)" id="fuzzelement1">test</a>','<a href="\\x01javascript:javascript:alert(1)" id="fuzzelement1">test</a>','<a href="\\x08javascript:javascript:alert(1)" id="fuzzelement1">test</a>','<a href="\\xE2\\x80\\x84javascript:javascript:alert(1)" id="fuzzelement1">test</a>','<a href="\\xE2\\x80\\x86javascript:javascript:alert(1)" id="fuzzelement1">test</a>','<a href="\\xE3\\x80\\x80javascript:javascript:alert(1)" id="fuzzelement1">test</a>','<a href="\\x12javascript:javascript:alert(1)" id="fuzzelement1">test</a>','<a href="\\x0Djavascript:javascript:alert(1)" id="fuzzelement1">test</a>','<a href="\\x0Ajavascript:javascript:alert(1)" id="fuzzelement1">test</a>','<a href="\\x0Cjavascript:javascript:alert(1)" id="fuzzelement1">test</a>','<a href="\\x15javascript:javascript:alert(1)" id="fuzzelement1">test</a>','<a href="\\xE2\\x80\\xA8javascript:javascript:alert(1)" id="fuzzelement1">test</a>','<a href="\\x16javascript:javascript:alert(1)" id="fuzzelement1">test</a>','<a href="\\x02javascript:javascript:alert(1)" id="fuzzelement1">test</a>','<a href="\\x1Bjavascript:javascript:alert(1)" id="fuzzelement1">test</a>','<a href="\\x06javascript:javascript:alert(1)" id="fuzzelement1">test</a>','<a href="\\xE2\\x80\\xA9javascript:javascript:alert(1)" id="fuzzelement1">test</a>','<a href="\\xE2\\x80\\x85javascript:javascript:alert(1)" id="fuzzelement1">test</a>','<a href="\\x1Ejavascript:javascript:alert(1)" id="fuzzelement1">test</a>','<a href="\\xE2\\x81\\x9Fjavascript:javascript:alert(1)" id="fuzzelement1">test</a>','<a href="\\x1Cjavascript:javascript:alert(1)" id="fuzzelement1">test</a>','<a href="javascript\\x00:javascript:alert(1)" id="fuzzelement1">test</a>','<a href="javascript\\x3A:javascript:alert(1)" id="fuzzelement1">test</a>','<a href="javascript\\x09:javascript:alert(1)" id="fuzzelement1">test</a>','<a href="javascript\\x0D:javascript:alert(1)" id="fuzzelement1">test</a>','<a href="javascript\\x0A:javascript:alert(1)" id="fuzzelement1">test</a>','`"\'><img src=xxx:x \\x0Aonerror=javascript:alert(1)>','`"\'><img src=xxx:x \\x22onerror=javascript:alert(1)>','`"\'><img src=xxx:x \\x0Bonerror=javascript:alert(1)>','`"\'><img src=xxx:x \\x0Donerror=javascript:alert(1)>','`"\'><img src=xxx:x \\x2Fonerror=javascript:alert(1)>','`"\'><img src=xxx:x \\x09onerror=javascript:alert(1)>','`"\'><img src=xxx:x \\x0Conerror=javascript:alert(1)>','`"\'><img src=xxx:x \\x00onerror=javascript:alert(1)>','`"\'><img src=xxx:x \\x27onerror=javascript:alert(1)>','`"\'><img src=xxx:x \\x20onerror=javascript:alert(1)>','"`\'><script>\\x3Bjavascript:alert(1)</script>','"`\'><script>\\x0Djavascript:alert(1)</script>','"`\'><script>\\xEF\\xBB\\xBFjavascript:alert(1)</script>','"`\'><script>\\xE2\\x80\\x81javascript:alert(1)</script>','"`\'><script>\\xE2\\x80\\x84javascript:alert(1)</script>','"`\'><script>\\xE3\\x80\\x80javascript:alert(1)</script>','"`\'><script>\\x09javascript:alert(1)</script>','"`\'><script>\\xE2\\x80\\x89javascript:alert(1)</script>','"`\'><script>\\xE2\\x80\\x85javascript:alert(1)</script>','"`\'><script>\\xE2\\x80\\x88javascript:alert(1)</script>','"`\'><script>\\x00javascript:alert(1)</script>','"`\'><script>\\xE2\\x80\\xA8javascript:alert(1)</script>','"`\'><script>\\xE2\\x80\\x8Ajavascript:alert(1)</script>','"`\'><script>\\xE1\\x9A\\x80javascript:alert(1)</script>','"`\'><script>\\x0Cjavascript:alert(1)</script>','"`\'><script>\\x2Bjavascript:alert(1)</script>','"`\'><script>\\xF0\\x90\\x96\\x9Ajavascript:alert(1)</script>','"`\'><script>-javascript:alert(1)</script>','"`\'><script>\\x0Ajavascript:alert(1)</script>','"`\'><script>\\xE2\\x80\\xAFjavascript:alert(1)</script>','"`\'><script>\\x7Ejavascript:alert(1)</script>','"`\'><script>\\xE2\\x80\\x87javascript:alert(1)</script>','"`\'><script>\\xE2\\x81\\x9Fjavascript:alert(1)</script>','"`\'><script>\\xE2\\x80\\xA9javascript:alert(1)</script>','"`\'><script>\\xC2\\x85javascript:alert(1)</script>','"`\'><script>\\xEF\\xBF\\xAEjavascript:alert(1)</script>','"`\'><script>\\xE2\\x80\\x83javascript:alert(1)</script>','"`\'><script>\\xE2\\x80\\x8Bjavascript:alert(1)</script>','"`\'><script>\\xEF\\xBF\\xBEjavascript:alert(1)</script>','"`\'><script>\\xE2\\x80\\x80javascript:alert(1)</script>','"`\'><script>\\x21javascript:alert(1)</script>','"`\'><script>\\xE2\\x80\\x82javascript:alert(1)</script>','"`\'><script>\\xE2\\x80\\x86javascript:alert(1)</script>','"`\'><script>\\xE1\\xA0\\x8Ejavascript:alert(1)</script>','"`\'><script>\\x0Bjavascript:alert(1)</script>','"`\'><script>\\x20javascript:alert(1)</script>','"`\'><script>\\xC2\\xA0javascript:alert(1)</script>','<img \\x00src=x onerror="alert(1)">','<img \\x47src=x onerror="javascript:alert(1)">','<img \\x11src=x onerror="javascript:alert(1)">','<img \\x12src=x onerror="javascript:alert(1)">','<img\\x47src=x onerror="javascript:alert(1)">','<img\\x10src=x onerror="javascript:alert(1)">','<img\\x13src=x onerror="javascript:alert(1)">','<img\\x32src=x onerror="javascript:alert(1)">','<img\\x47src=x onerror="javascript:alert(1)">','<img\\x11src=x onerror="javascript:alert(1)">','<img \\x47src=x onerror="javascript:alert(1)">','<img \\x34src=x onerror="javascript:alert(1)">','<img \\x39src=x onerror="javascript:alert(1)">','<img \\x00src=x onerror="javascript:alert(1)">','<img src\\x09=x onerror="javascript:alert(1)">','<img src\\x10=x onerror="javascript:alert(1)">','<img src\\x13=x onerror="javascript:alert(1)">','<img src\\x32=x onerror="javascript:alert(1)">','<img src\\x12=x onerror="javascript:alert(1)">','<img src\\x11=x onerror="javascript:alert(1)">','<img src\\x00=x onerror="javascript:alert(1)">','<img src\\x47=x onerror="javascript:alert(1)">','<img src=x\\x09onerror="javascript:alert(1)">','<img src=x\\x10onerror="javascript:alert(1)">','<img src=x\\x11onerror="javascript:alert(1)">','<img src=x\\x12onerror="javascript:alert(1)">','<img src=x\\x13onerror="javascript:alert(1)">','<img[a][b][c]src[d]=x[e]onerror=[f]"alert(1)">','<img src=x onerror=\\x09"javascript:alert(1)">','<img src=x onerror=\\x10"javascript:alert(1)">','<img src=x onerror=\\x11"javascript:alert(1)">','<img src=x onerror=\\x12"javascript:alert(1)">','<img src=x onerror=\\x32"javascript:alert(1)">','<img src=x onerror=\\x00"javascript:alert(1)">','<a href=java&#1&#2&#3&#4&#5&#6&#7&#8&#11&#12script:javascript:alert(1)>XXX</a>','<img src="x` `<script>javascript:alert(1)</script>"` `>','<img src onerror /" \'"= alt=javascript:alert(1)//">','<title onpropertychange=javascript:alert(1)></title><title title=>','<a href=http://foo.bar/#x=`y></a><img alt="`><img src=x:x onerror=javascript:alert(1)></a>">','<!--[if]><script>javascript:alert(1)</script -->','<!--[if<img src=x onerror=javascript:alert(1)//]> -->','<script src="/\\%(jscript)s"></script>','<script src="\\\\%(jscript)s"></script>','<IMG """><SCRIPT>alert("XSS")</SCRIPT>">','<IMG SRC=javascript:alert(String.fromCharCode(88,83,83))>','<IMG SRC=# onmouseover="alert(\'xxs\')">','<IMG SRC= onmouseover="alert(\'xxs\')">','<IMG onmouseover="alert(\'xxs\')">','<IMG SRC=&#106;&#97;&#118;&#97;&#115;&#99;&#114;&#105;&#112;&#116;&#58;&#97;&#108;&#101;&#114;&#116;&#40;&#39;&#88;&#83;&#83;&#39;&#41;>','<IMG SRC=&#0000106&#0000097&#0000118&#0000097&#0000115&#0000099&#0000114&#0000105&#0000112&#0000116&#0000058&#0000097&#0000108&#0000101&#0000114&#0000116&#0000040&#0000039&#0000088&#0000083&#0000083&#0000039&#0000041>','<IMG SRC=&#x6A&#x61&#x76&#x61&#x73&#x63&#x72&#x69&#x70&#x74&#x3A&#x61&#x6C&#x65&#x72&#x74&#x28&#x27&#x58&#x53&#x53&#x27&#x29>','<IMG SRC="jav   ascript:alert(\'XSS\');">','<IMG SRC="jav&#x09;ascript:alert(\'XSS\');">','<IMG SRC="jav&#x0A;ascript:alert(\'XSS\');">','<IMG SRC="jav&#x0D;ascript:alert(\'XSS\');">','perl -e \'print "<IMG SRC=java\\0script:alert(\\"XSS\\")>";\' > out','<IMG SRC=" &#14;  javascript:alert(\'XSS\');">','<SCRIPT/XSS SRC="http://ha.ckers.org/xss.js"></SCRIPT>','<BODY onload!#$%&()*~+-_.,:;?@[/|\\]^`=alert("XSS")>','<SCRIPT/SRC="http://ha.ckers.org/xss.js"></SCRIPT>','<<SCRIPT>alert("XSS");//<</SCRIPT>','<SCRIPT SRC=http://ha.ckers.org/xss.js?< B >','<SCRIPT SRC=//ha.ckers.org/.j>','<IMG SRC="javascript:alert(\'XSS\')"','<iframe src=http://ha.ckers.org/scriptlet.html <','\\";alert(\'XSS\');//','<u oncopy=alert()> Copy me</u>','<i onwheel=alert(1)> Scroll over me </i>','<plaintext>','http://a/%%30%30','</textarea><script>alert(123)</script>','1;DROP TABLE users','1\'; DROP TABLE users-- 1','\' OR 1=1 -- 1','\' OR \'1\'=\'1','\'; EXEC sp_MSForEachTable \'DROP TABLE ?\'; --',' ','%','_','-','--','--version','--help','$USER','/dev/null; touch /tmp/blns.fail ; echo','`touch /tmp/blns.fail`','$(touch /tmp/blns.fail)','@{[system "touch /tmp/blns.fail"]}','eval("puts \'hello world\'")','System("ls -al /")','`ls -al /`','Kernel.exec("ls -al /")','Kernel.exit(1)','%x(\'ls -al /\')','<?xml version="1.0" encoding="ISO-8859-1"?><!DOCTYPE foo [ <!ELEMENT foo ANY ><!ENTITY xxe SYSTEM "file:///etc/passwd" >]><foo>&xxe;</foo>','$HOME','$ENV{\'HOME\'}','%d','%s%s%s%s%s','{0}','%*.*s','%@','%n','File:///','../../../../../../../../../../../etc/passwd%00','../../../../../../../../../../../etc/hosts','() { 0; }; touch /tmp/blns.shellshock1.fail;','() { _; } >_[$($())] { touch /tmp/blns.shellshock2.fail; }','<<< %s(un=\'%s\') = %u','+++ATH0','CON','PRN','AUX','CLOCK$','NUL','A:','ZZ:','COM1','LPT1','LPT2','LPT3','COM2','COM3','COM4','DCC SEND STARTKEYLOGGER 0 0 0','Scunthorpe General Hospital','Penistone Community Church','Lightwater Country Park','Jimmy Clitheroe','Horniman Museum','shitake mushrooms','RomansInSussex.co.uk','http://www.cum.qc.ca/','Craig Cockburn, Software Specialist','Linda Callahan','Dr. Herman I. Libshitz','magna cum laude','Super Bowl XXX','medieval erection of parapets','evaluate','mocha','expression','Arsenal canal','classic','Tyson Gay','Dick Van Dyke','basement','If you\'re reading this, you\'ve been in a coma for almost 20 years now. We\'re trying a new technique. We don\'t know where this message will end up in your dream, but we hope it works. Please wake up, we miss you.','Roses are [0;31mred[0m, violets are [0;34mblue. Hope you enjoy terminal hue','But now...[20Cfor my greatest trick...[8m','The quic\b\b\b\b\b\bk brown fox... [Beeeep]','Powerلُلُصّبُلُلصّبُررً ॣ ॣh ॣ ॣ冗','🏳0🌈️','జ్ఞ‌ా','گچپژ','{% print \'x\' * 64 * 1024**3 %}','{{ "".__class__.__mro__[2].__subclasses__()[40]("/etc/passwd").read() }}';
