#pragma once

#include <Storages/System/IStorageSystemOneBlock.h>
#include <base/shared_ptr_helper.h>


namespace DB
{
class Context;


/** System table "contributors" with list of clickhouse contributors
  */
class StorageSystemContributors final : public shared_ptr_helper<StorageSystemContributors>,
                                  public IStorageSystemOneBlock<StorageSystemContributors>
{
    friend struct shared_ptr_helper<StorageSystemContributors>;
protected:
    void fillData(MutableColumns & res_columns, ContextPtr context, const SelectQueryInfo & query_info) const override;

    using IStorageSystemOneBlock::IStorageSystemOneBlock;

public:
    std::string getName() const override
    {
        return "SystemContributors";
    }

    static NamesAndTypesList getNamesAndTypes();
};
}
