#include <vector>
#include <string>
#include <exception>
#include <string_view>
#include <base/JSON.h>

#include <boost/range/irange.hpp>
#include <gtest/gtest.h>


enum class ResultType
{
    Return,
    Throw
};

struct GetStringTestRecord
{
    std::string_view input;
    ResultType result_type;
    std::string_view result;
};

TEST(JSONSuite, SimpleTest)
{
    using namespace std::literals;

    std::vector<GetStringTestRecord> test_data =
    {
        { R"("name")"sv, ResultType::Return, "name"sv },
        { R"("Вафельница Vitek WX-1102 FL")"sv, ResultType::Return, "Вафельница Vitek WX-1102 FL"sv },
        { R"("brand")"sv, ResultType::Return, "brand"sv },
        { R"("184509")"sv, ResultType::Return, "184509"sv },
        { R"("category")"sv, ResultType::Return, "category"sv },
        { R"("Все для детей/Детская техника/Vitek")"sv, ResultType::Return, "Все для детей/Детская техника/Vitek"sv },
        { R"("variant")"sv, ResultType::Return, "variant"sv },
        { R"("В наличии")"sv, ResultType::Return, "В наличии"sv },
        { R"("price")"sv, ResultType::Return, "price"sv },
        { R"("2390.00")"sv, ResultType::Return, "2390.00"sv },
        { R"("list")"sv, ResultType::Return, "list"sv },
        { R"("Карточка")"sv, ResultType::Return, "Карточка"sv },
        { R"("position")"sv, ResultType::Return, "position"sv },
        { R"("detail")"sv, ResultType::Return, "detail"sv },
        { R"("actionField")"sv, ResultType::Return, "actionField"sv },
        { R"("list")"sv, ResultType::Return, "list"sv },
        { R"("http://www.techport.ru/q/?t=вафельница&sort=price&sdim=asc")"sv, ResultType::Return, "http://www.techport.ru/q/?t=вафельница&sort=price&sdim=asc"sv },
        { R"("action")"sv, ResultType::Return, "action"sv },
        { R"("detail")"sv, ResultType::Return, "detail"sv },
        { R"("products")"sv, ResultType::Return, "products"sv },
        { R"("name")"sv, ResultType::Return, "name"sv },
        { R"("Вафельница Vitek WX-1102 FL")"sv, ResultType::Return, "Вафельница Vitek WX-1102 FL"sv },
        { R"("id")"sv, ResultType::Return, "id"sv },
        { R"("184509")"sv, ResultType::Return, "184509"sv },
        { R"("price")"sv, ResultType::Return, "price"sv },
        { R"("2390.00")"sv, ResultType::Return, "2390.00"sv },
        { R"("brand")"sv, ResultType::Return, "brand"sv },
        { R"("Vitek")"sv, ResultType::Return, "Vitek"sv },
        { R"("category")"sv, ResultType::Return, "category"sv },
        { R"("Все для детей/Детская техника/Vitek")"sv, ResultType::Return, "Все для детей/Детская техника/Vitek"sv },
        { R"("variant")"sv, ResultType::Return, "variant"sv },
        { R"("В наличии")"sv, ResultType::Return, "В наличии"sv },
        { R"("ru")"sv, ResultType::Return, "ru"sv },
        { R"("experiments")"sv, ResultType::Return, "experiments"sv },
        { R"("lang")"sv, ResultType::Return, "lang"sv },
        { R"("ru")"sv, ResultType::Return, "ru"sv },
        { R"("los_portal")"sv, ResultType::Return, "los_portal"sv },
        { R"("los_level")"sv, ResultType::Return, "los_level"sv },
        { R"("none")"sv, ResultType::Return, "none"sv },
        { R"("isAuthorized")"sv, ResultType::Return, "isAuthorized"sv },
        { R"("isSubscriber")"sv, ResultType::Return, "isSubscriber"sv },
        { R"("postType")"sv, ResultType::Return, "postType"sv },
        { R"("Новости")"sv, ResultType::Return, "Новости"sv },
        { R"("experiments")"sv, ResultType::Return, "experiments"sv },
        { R"("lang")"sv, ResultType::Return, "lang"sv },
        { R"("ru")"sv, ResultType::Return, "ru"sv },
        { R"("los_portal")"sv, ResultType::Return, "los_portal"sv },
        { R"("los_level")"sv, ResultType::Return, "los_level"sv },
        { R"("none")"sv, ResultType::Return, "none"sv },
        { R"("lang")"sv, ResultType::Return, "lang"sv },
        { R"("ru")"sv, ResultType::Return, "ru"sv },
        { R"("Электроплита GEFEST Брест ЭПНД 5140-01 0001")"sv, ResultType::Return, "Электроплита GEFEST Брест ЭПНД 5140-01 0001"sv },
        { R"("price")"sv, ResultType::Return, "price"sv },
        { R"("currencyCode")"sv, ResultType::Return, "currencyCode"sv },
        { R"("RUB")"sv, ResultType::Return, "RUB"sv },
        { R"("lang")"sv, ResultType::Return, "lang"sv },
        { R"("ru")"sv, ResultType::Return, "ru"sv },
        { R"("experiments")"sv, ResultType::Return, "experiments"sv },
        { R"("lang")"sv, ResultType::Return, "lang"sv },
        { R"("ru")"sv, ResultType::Return, "ru"sv },
        { R"("los_portal")"sv, ResultType::Return, "los_portal"sv },
        { R"("los_level")"sv, ResultType::Return, "los_level"sv },
        { R"("none")"sv, ResultType::Return, "none"sv },
        { R"("trash_login")"sv, ResultType::Return, "trash_login"sv },
        { R"("novikoff")"sv, ResultType::Return, "novikoff"sv },
        { R"("trash_cat_link")"sv, ResultType::Return, "trash_cat_link"sv },
        { R"("progs")"sv, ResultType::Return, "progs"sv },
        { R"("trash_parent_link")"sv, ResultType::Return, "trash_parent_link"sv },
        { R"("content")"sv, ResultType::Return, "content"sv },
        { R"("trash_posted_parent")"sv, ResultType::Return, "trash_posted_parent"sv },
        { R"("content.01.2016")"sv, ResultType::Return, "content.01.2016"sv },
        { R"("trash_posted_cat")"sv, ResultType::Return, "trash_posted_cat"sv },
        { R"("progs.01.2016")"sv, ResultType::Return, "progs.01.2016"sv },
        { R"("trash_virus_count")"sv, ResultType::Return, "trash_virus_count"sv },
        { R"("trash_is_android")"sv, ResultType::Return, "trash_is_android"sv },
        { R"("trash_is_wp8")"sv, ResultType::Return, "trash_is_wp8"sv },
        { R"("trash_is_ios")"sv, ResultType::Return, "trash_is_ios"sv },
        { R"("trash_posted")"sv, ResultType::Return, "trash_posted"sv },
        { R"("01.2016")"sv, ResultType::Return, "01.2016"sv },
        { R"("experiments")"sv, ResultType::Return, "experiments"sv },
        { R"("lang")"sv, ResultType::Return, "lang"sv },
        { R"("ru")"sv, ResultType::Return, "ru"sv },
        { R"("los_portal")"sv, ResultType::Return, "los_portal"sv },
        { R"("los_level")"sv, ResultType::Return, "los_level"sv },
        { R"("none")"sv, ResultType::Return, "none"sv },
        { R"("merchantId")"sv, ResultType::Return, "merchantId"sv },
        { R"("13694_49246")"sv, ResultType::Return, "13694_49246"sv },
        { R"("cps-source")"sv, ResultType::Return, "cps-source"sv },
        { R"("wargaming")"sv, ResultType::Return, "wargaming"sv },
        { R"("cps_provider")"sv, ResultType::Return, "cps_provider"sv },
        { R"("default")"sv, ResultType::Return, "default"sv },
        { R"("errorReason")"sv, ResultType::Return, "errorReason"sv },
        { R"("no errors")"sv, ResultType::Return, "no errors"sv },
        { R"("scid")"sv, ResultType::Return, "scid"sv },
        { R"("isAuthPayment")"sv, ResultType::Return, "isAuthPayment"sv },
        { R"("lang")"sv, ResultType::Return, "lang"sv },
        { R"("ru")"sv, ResultType::Return, "ru"sv },
        { R"("rubric")"sv, ResultType::Return, "rubric"sv },
        { R"("")"sv, ResultType::Return, ""sv },
        { R"("rubric")"sv, ResultType::Return, "rubric"sv },
        { R"("Мир")"sv, ResultType::Return, "Мир"sv },
        { R"("lang")"sv, ResultType::Return, "lang"sv },
        { R"("ru")"sv, ResultType::Return, "ru"sv },
        { R"("experiments")"sv, ResultType::Return, "experiments"sv },
        { R"("lang")"sv, ResultType::Return, "lang"sv },
        { R"("ru")"sv, ResultType::Return, "ru"sv },
        { R"("los_portal")"sv, ResultType::Return, "los_portal"sv },
        { R"("los_level")"sv, ResultType::Return, "los_level"sv },
        { R"("none")"sv, ResultType::Return, "none"sv },
        { R"("lang")"sv, ResultType::Return, "lang"sv },
        { R"("ru")"sv, ResultType::Return, "ru"sv },
        { R"("__ym")"sv, ResultType::Return, "__ym"sv },
        { R"("ecommerce")"sv, ResultType::Return, "ecommerce"sv },
        { R"("impressions")"sv, ResultType::Return, "impressions"sv },
        { R"("id")"sv, ResultType::Return, "id"sv },
        { R"("863813")"sv, ResultType::Return, "863813"sv },
        { R"("name")"sv, ResultType::Return, "name"sv },
        { R"("Футболка детская 3D Happy, возраст 1-2 года, трикотаж")"sv, ResultType::Return, "Футболка детская 3D Happy, возраст 1-2 года, трикотаж"sv },
        { R"("category")"sv, ResultType::Return, "category"sv },
        { R"("/Летние товары/Летний текстиль/")"sv, ResultType::Return, "/Летние товары/Летний текстиль/"sv },
        { R"("variant")"sv, ResultType::Return, "variant"sv },
        { R"("")"sv, ResultType::Return, ""sv },
        { R"("price")"sv, ResultType::Return, "price"sv },
        { R"("390.00")"sv, ResultType::Return, "390.00"sv },
        { R"("list")"sv, ResultType::Return, "list"sv },
        { R"("/retailrocket/")"sv, ResultType::Return, "/retailrocket/"sv },
        { R"("position")"sv, ResultType::Return, "position"sv },
        { R"("brand")"sv, ResultType::Return, "brand"sv },
        { R"("/911488/futbolka-detskaya-3d-dolphin-vozrast-1-2-goda-trikotazh/")"sv, ResultType::Return, "/911488/futbolka-detskaya-3d-dolphin-vozrast-1-2-goda-trikotazh/"sv },
        { R"("id")"sv, ResultType::Return, "id"sv },
        { R"("863839")"sv, ResultType::Return, "863839"sv },
        { R"("name")"sv, ResultType::Return, "name"sv },
        { R"("Футболка детская 3D Pretty kitten, возраст 1-2 года, трикотаж")"sv, ResultType::Return, "Футболка детская 3D Pretty kitten, возраст 1-2 года, трикотаж"sv },
        { R"("category")"sv, ResultType::Return, "category"sv },
        { R"("/Летние товары/Летний текстиль/")"sv, ResultType::Return, "/Летние товары/Летний текстиль/"sv },
        { R"("variant")"sv, ResultType::Return, "variant"sv },
        { R"("")"sv, ResultType::Return, ""sv },
        { R"("price")"sv, ResultType::Return, "price"sv },
        { R"("390.00")"sv, ResultType::Return, "390.00"sv },
        { R"("list")"sv, ResultType::Return, "list"sv },
        { R"("/retailrocket/")"sv, ResultType::Return, "/retailrocket/"sv },
        { R"("position")"sv, ResultType::Return, "position"sv },
        { R"("brand")"sv, ResultType::Return, "brand"sv },
        { R"("/911488/futbolka-detskaya-3d-dolphin-vozrast-1-2-goda-trikotazh/")"sv, ResultType::Return, "/911488/futbolka-detskaya-3d-dolphin-vozrast-1-2-goda-trikotazh/"sv },
        { R"("id")"sv, ResultType::Return, "id"sv },
        { R"("863847")"sv, ResultType::Return, "863847"sv },
        { R"("name")"sv, ResultType::Return, "name"sv },
        { R"("Футболка детская 3D Little tiger, возраст 1-2 года, трикотаж")"sv, ResultType::Return, "Футболка детская 3D Little tiger, возраст 1-2 года, трикотаж"sv },
        { R"("category")"sv, ResultType::Return, "category"sv },
        { R"("/Летние товары/Летний текстиль/")"sv, ResultType::Return, "/Летние товары/Летний текстиль/"sv },
        { R"("variant")"sv, ResultType::Return, "variant"sv },
        { R"("")"sv, ResultType::Return, ""sv },
        { R"("price")"sv, ResultType::Return, "price"sv },
        { R"("390.00")"sv, ResultType::Return, "390.00"sv },
        { R"("list")"sv, ResultType::Return, "list"sv },
        { R"("/retailrocket/")"sv, ResultType::Return, "/retailrocket/"sv },
        { R"("position")"sv, ResultType::Return, "position"sv },
        { R"("brand")"sv, ResultType::Return, "brand"sv },
        { R"("/911488/futbolka-detskaya-3d-dolphin-vozrast-1-2-goda-trikotazh/")"sv, ResultType::Return, "/911488/futbolka-detskaya-3d-dolphin-vozrast-1-2-goda-trikotazh/"sv },
        { R"("id")"sv, ResultType::Return, "id"sv },
        { R"("911480")"sv, ResultType::Return, "911480"sv },
        { R"("name")"sv, ResultType::Return, "name"sv },
        { R"("Футболка детская 3D Puppy, возраст 1-2 года, трикотаж")"sv, ResultType::Return, "Футболка детская 3D Puppy, возраст 1-2 года, трикотаж"sv },
        { R"("category")"sv, ResultType::Return, "category"sv },
        { R"("/Летние товары/Летний текстиль/")"sv, ResultType::Return, "/Летние товары/Летний текстиль/"sv },
        { R"("variant")"sv, ResultType::Return, "variant"sv },
        { R"("")"sv, ResultType::Return, ""sv },
        { R"("price")"sv, ResultType::Return, "price"sv },
        { R"("390.00")"sv, ResultType::Return, "390.00"sv },
        { R"("list")"sv, ResultType::Return, "list"sv },
        { R"("/retailrocket/")"sv, ResultType::Return, "/retailrocket/"sv },
        { R"("position")"sv, ResultType::Return, "position"sv },
        { R"("brand")"sv, ResultType::Return, "brand"sv },
        { R"("/911488/futbolka-detskaya-3d-dolphin-vozrast-1-2-goda-trikotazh/")"sv, ResultType::Return, "/911488/futbolka-detskaya-3d-dolphin-vozrast-1-2-goda-trikotazh/"sv },
        { R"("id")"sv, ResultType::Return, "id"sv },
        { R"("911484")"sv, ResultType::Return, "911484"sv },
        { R"("name")"sv, ResultType::Return, "name"sv },
        { R"("Футболка детская 3D Little bears, возраст 1-2 года, трикотаж")"sv, ResultType::Return, "Футболка детская 3D Little bears, возраст 1-2 года, трикотаж"sv },
        { R"("category")"sv, ResultType::Return, "category"sv },
        { R"("/Летние товары/Летний текстиль/")"sv, ResultType::Return, "/Летние товары/Летний текстиль/"sv },
        { R"("variant")"sv, ResultType::Return, "variant"sv },
        { R"("")"sv, ResultType::Return, ""sv },
        { R"("price")"sv, ResultType::Return, "price"sv },
        { R"("390.00")"sv, ResultType::Return, "390.00"sv },
        { R"("list")"sv, ResultType::Return, "list"sv },
        { R"("/retailrocket/")"sv, ResultType::Return, "/retailrocket/"sv },
        { R"("position")"sv, ResultType::Return, "position"sv },
        { R"("brand")"sv, ResultType::Return, "brand"sv },
        { R"("/911488/futbolka-detskaya-3d-dolphin-vozrast-1-2-goda-trikotazh/")"sv, ResultType::Return, "/911488/futbolka-detskaya-3d-dolphin-vozrast-1-2-goda-trikotazh/"sv },
        { R"("id")"sv, ResultType::Return, "id"sv },
        { R"("911489")"sv, ResultType::Return, "911489"sv },
        { R"("name")"sv, ResultType::Return, "name"sv },
        { R"("Футболка детская 3D Dolphin, возраст 2-4 года, трикотаж")"sv, ResultType::Return, "Футболка детская 3D Dolphin, возраст 2-4 года, трикотаж"sv },
        { R"("category")"sv, ResultType::Return, "category"sv },
        { R"("/Летние товары/Летний текстиль/")"sv, ResultType::Return, "/Летние товары/Летний текстиль/"sv },
        { R"("variant")"sv, ResultType::Return, "variant"sv },
        { R"("")"sv, ResultType::Return, ""sv },
        { R"("price")"sv, ResultType::Return, "price"sv },
        { R"("390.00")"sv, ResultType::Return, "390.00"sv },
        { R"("list")"sv, ResultType::Return, "list"sv },
        { R"("/retailrocket/")"sv, ResultType::Return, "/retailrocket/"sv },
        { R"("position")"sv, ResultType::Return, "position"sv },
        { R"("brand")"sv, ResultType::Return, "brand"sv },
        { R"("/911488/futbolka-detskaya-3d-dolphin-vozrast-1-2-goda-trikotazh/")"sv, ResultType::Return, "/911488/futbolka-detskaya-3d-dolphin-vozrast-1-2-goda-trikotazh/"sv },
        { R"("id")"sv, ResultType::Return, "id"sv },
        { R"("911496")"sv, ResultType::Return, "911496"sv },
        { R"("name")"sv, ResultType::Return, "name"sv },
        { R"("Футболка детская 3D Pretty, возраст 1-2 года, трикотаж")"sv, ResultType::Return, "Футболка детская 3D Pretty, возраст 1-2 года, трикотаж"sv },
        { R"("category")"sv, ResultType::Return, "category"sv },
        { R"("/Летние товары/Летний текстиль/")"sv, ResultType::Return, "/Летние товары/Летний текстиль/"sv },
        { R"("variant")"sv, ResultType::Return, "variant"sv },
        { R"("")"sv, ResultType::Return, ""sv },
        { R"("price")"sv, ResultType::Return, "price"sv },
        { R"("390.00")"sv, ResultType::Return, "390.00"sv },
        { R"("list")"sv, ResultType::Return, "list"sv },
        { R"("/retailrocket/")"sv, ResultType::Return, "/retailrocket/"sv },
        { R"("position")"sv, ResultType::Return, "position"sv },
        { R"("brand")"sv, ResultType::Return, "brand"sv },
        { R"("/911488/futbolka-detskaya-3d-dolphin-vozrast-1-2-goda-trikotazh/")"sv, ResultType::Return, "/911488/futbolka-detskaya-3d-dolphin-vozrast-1-2-goda-trikotazh/"sv },
        { R"("id")"sv, ResultType::Return, "id"sv },
        { R"("911504")"sv, ResultType::Return, "911504"sv },
        { R"("name")"sv, ResultType::Return, "name"sv },
        { R"("Футболка детская 3D Fairytale, возраст 1-2 года, трикотаж")"sv, ResultType::Return, "Футболка детская 3D Fairytale, возраст 1-2 года, трикотаж"sv },
        { R"("category")"sv, ResultType::Return, "category"sv },
        { R"("/Летние товары/Летний текстиль/")"sv, ResultType::Return, "/Летние товары/Летний текстиль/"sv },
        { R"("variant")"sv, ResultType::Return, "variant"sv },
        { R"("")"sv, ResultType::Return, ""sv },
        { R"("price")"sv, ResultType::Return, "price"sv },
        { R"("390.00")"sv, ResultType::Return, "390.00"sv },
        { R"("list")"sv, ResultType::Return, "list"sv },
        { R"("/retailrocket/")"sv, ResultType::Return, "/retailrocket/"sv },
        { R"("position")"sv, ResultType::Return, "position"sv },
        { R"("brand")"sv, ResultType::Return, "brand"sv },
        { R"("/911488/futbolka-detskaya-3d-dolphin-vozrast-1-2-goda-trikotazh/")"sv, ResultType::Return, "/911488/futbolka-detskaya-3d-dolphin-vozrast-1-2-goda-trikotazh/"sv },
        { R"("id")"sv, ResultType::Return, "id"sv },
        { R"("911508")"sv, ResultType::Return, "911508"sv },
        { R"("name")"sv, ResultType::Return, "name"sv },
        { R"("Футболка детская 3D Kittens, возраст 1-2 года, трикотаж")"sv, ResultType::Return, "Футболка детская 3D Kittens, возраст 1-2 года, трикотаж"sv },
        { R"("category")"sv, ResultType::Return, "category"sv },
        { R"("/Летние товары/Летний текстиль/")"sv, ResultType::Return, "/Летние товары/Летний текстиль/"sv },
        { R"("variant")"sv, ResultType::Return, "variant"sv },
        { R"("")"sv, ResultType::Return, ""sv },
        { R"("price")"sv, ResultType::Return, "price"sv },
        { R"("390.00")"sv, ResultType::Return, "390.00"sv },
        { R"("list")"sv, ResultType::Return, "list"sv },
        { R"("/retailrocket/")"sv, ResultType::Return, "/retailrocket/"sv },
        { R"("position")"sv, ResultType::Return, "position"sv },
        { R"("brand")"sv, ResultType::Return, "brand"sv },
        { R"("/911488/futbolka-detskaya-3d-dolphin-vozrast-1-2-goda-trikotazh/")"sv, ResultType::Return, "/911488/futbolka-detskaya-3d-dolphin-vozrast-1-2-goda-trikotazh/"sv },
        { R"("id")"sv, ResultType::Return, "id"sv },
        { R"("911512")"sv, ResultType::Return, "911512"sv },
        { R"("name")"sv, ResultType::Return, "name"sv },
        { R"("Футболка детская 3D Sunshine, возраст 1-2 года, трикотаж")"sv, ResultType::Return, "Футболка детская 3D Sunshine, возраст 1-2 года, трикотаж"sv },
        { R"("category")"sv, ResultType::Return, "category"sv },
        { R"("/Летние товары/Летний текстиль/")"sv, ResultType::Return, "/Летние товары/Летний текстиль/"sv },
        { R"("variant")"sv, ResultType::Return, "variant"sv },
        { R"("")"sv, ResultType::Return, ""sv },
        { R"("price")"sv, ResultType::Return, "price"sv },
        { R"("390.00")"sv, ResultType::Return, "390.00"sv },
        { R"("list")"sv, ResultType::Return, "list"sv },
        { R"("/retailrocket/")"sv, ResultType::Return, "/retailrocket/"sv },
        { R"("position")"sv, ResultType::Return, "position"sv },
        { R"("brand")"sv, ResultType::Return, "brand"sv },
        { R"("/911488/futbolka-detskaya-3d-dolphin-vozrast-1-2-goda-trikotazh/")"sv, ResultType::Return, "/911488/futbolka-detskaya-3d-dolphin-vozrast-1-2-goda-trikotazh/"sv },
        { R"("id")"sv, ResultType::Return, "id"sv },
        { R"("911516")"sv, ResultType::Return, "911516"sv },
        { R"("name")"sv, ResultType::Return, "name"sv },
        { R"("Футболка детская 3D Dog in bag, возраст 1-2 года, трикотаж")"sv, ResultType::Return, "Футболка детская 3D Dog in bag, возраст 1-2 года, трикотаж"sv },
        { R"("category")"sv, ResultType::Return, "category"sv },
        { R"("/Летние товары/Летний текстиль/")"sv, ResultType::Return, "/Летние товары/Летний текстиль/"sv },
        { R"("variant")"sv, ResultType::Return, "variant"sv },
        { R"("")"sv, ResultType::Return, ""sv },
        { R"("price")"sv, ResultType::Return, "price"sv },
        { R"("390.00")"sv, ResultType::Return, "390.00"sv },
        { R"("list")"sv, ResultType::Return, "list"sv },
        { R"("/retailrocket/")"sv, ResultType::Return, "/retailrocket/"sv },
        { R"("position")"sv, ResultType::Return, "position"sv },
        { R"("brand")"sv, ResultType::Return, "brand"sv },
        { R"("/911488/futbolka-detskaya-3d-dolphin-vozrast-1-2-goda-trikotazh/")"sv, ResultType::Return, "/911488/futbolka-detskaya-3d-dolphin-vozrast-1-2-goda-trikotazh/"sv },
        { R"("id")"sv, ResultType::Return, "id"sv },
        { R"("911520")"sv, ResultType::Return, "911520"sv },
        { R"("name")"sv, ResultType::Return, "name"sv },
        { R"("Футболка детская 3D Cute puppy, возраст 1-2 года, трикотаж")"sv, ResultType::Return, "Футболка детская 3D Cute puppy, возраст 1-2 года, трикотаж"sv },
        { R"("category")"sv, ResultType::Return, "category"sv },
        { R"("/Летние товары/Летний текстиль/")"sv, ResultType::Return, "/Летние товары/Летний текстиль/"sv },
        { R"("variant")"sv, ResultType::Return, "variant"sv },
        { R"("")"sv, ResultType::Return, ""sv },
        { R"("price")"sv, ResultType::Return, "price"sv },
        { R"("390.00")"sv, ResultType::Return, "390.00"sv },
        { R"("list")"sv, ResultType::Return, "list"sv },
        { R"("/retailrocket/")"sv, ResultType::Return, "/retailrocket/"sv },
        { R"("position")"sv, ResultType::Return, "position"sv },
        { R"("brand")"sv, ResultType::Return, "brand"sv },
        { R"("/911488/futbolka-detskaya-3d-dolphin-vozrast-1-2-goda-trikotazh/")"sv, ResultType::Return, "/911488/futbolka-detskaya-3d-dolphin-vozrast-1-2-goda-trikotazh/"sv },
        { R"("id")"sv, ResultType::Return, "id"sv },
        { R"("911524")"sv, ResultType::Return, "911524"sv },
        { R"("name")"sv, ResultType::Return, "name"sv },
        { R"("Футболка детская 3D Rabbit, возраст 1-2 года, трикотаж")"sv, ResultType::Return, "Футболка детская 3D Rabbit, возраст 1-2 года, трикотаж"sv },
        { R"("category")"sv, ResultType::Return, "category"sv },
        { R"("/Летние товары/Летний текстиль/")"sv, ResultType::Return, "/Летние товары/Летний текстиль/"sv },
        { R"("variant")"sv, ResultType::Return, "variant"sv },
        { R"("")"sv, ResultType::Return, ""sv },
        { R"("price")"sv, ResultType::Return, "price"sv },
        { R"("390.00")"sv, ResultType::Return, "390.00"sv },
        { R"("list")"sv, ResultType::Return, "list"sv },
        { R"("/retailrocket/")"sv, ResultType::Return, "/retailrocket/"sv },
        { R"("position")"sv, ResultType::Return, "position"sv },
        { R"("brand")"sv, ResultType::Return, "brand"sv },
        { R"("/911488/futbolka-detskaya-3d-dolphin-vozrast-1-2-goda-trikotazh/")"sv, ResultType::Return, "/911488/futbolka-detskaya-3d-dolphin-vozrast-1-2-goda-trikotazh/"sv },
        { R"("id")"sv, ResultType::Return, "id"sv },
        { R"("911528")"sv, ResultType::Return, "911528"sv },
        { R"("name")"sv, ResultType::Return, "name"sv },
        { R"("Футболка детская 3D Turtle, возраст 1-2 года, трикотаж")"sv, ResultType::Return, "Футболка детская 3D Turtle, возраст 1-2 года, трикотаж"sv },
        { R"("category")"sv, ResultType::Return, "category"sv },
        { R"("/Летние товары/Летний текстиль/")"sv, ResultType::Return, "/Летние товары/Летний текстиль/"sv },
        { R"("variant")"sv, ResultType::Return, "variant"sv },
        { R"("")"sv, ResultType::Return, ""sv },
        { R"("price")"sv, ResultType::Return, "price"sv },
        { R"("390.00")"sv, ResultType::Return, "390.00"sv },
        { R"("list")"sv, ResultType::Return, "list"sv },
        { R"("/retailrocket/")"sv, ResultType::Return, "/retailrocket/"sv },
        { R"("position")"sv, ResultType::Return, "position"sv },
        { R"("brand")"sv, ResultType::Return, "brand"sv },
        { R"("/911488/futbolka-detskaya-3d-dolphin-vozrast-1-2-goda-trikotazh/")"sv, ResultType::Return, "/911488/futbolka-detskaya-3d-dolphin-vozrast-1-2-goda-trikotazh/"sv },
        { R"("id")"sv, ResultType::Return, "id"sv },
        { R"("888616")"sv, ResultType::Return, "888616"sv },
        { R"("name")"sv, ResultType::Return, "name"sv },
        { "\"3Д Футболка мужская \\\"Collorista\\\" Светлое завтра р-р XL(52-54), 100% хлопок, трикотаж\""sv, ResultType::Return, "3Д Футболка мужская \"Collorista\" Светлое завтра р-р XL(52-54), 100% хлопок, трикотаж"sv },
        { R"("category")"sv, ResultType::Return, "category"sv },
        { R"("/Одежда и обувь/Мужская одежда/Футболки/")"sv, ResultType::Return, "/Одежда и обувь/Мужская одежда/Футболки/"sv },
        { R"("variant")"sv, ResultType::Return, "variant"sv },
        { R"("")"sv, ResultType::Return, ""sv },
        { R"("price")"sv, ResultType::Return, "price"sv },
        { R"("406.60")"sv, ResultType::Return, "406.60"sv },
        { R"("list")"sv, ResultType::Return, "list"sv },
        { R"("/retailrocket/")"sv, ResultType::Return, "/retailrocket/"sv },
        { R"("position")"sv, ResultType::Return, "position"sv },
        { R"("brand")"sv, ResultType::Return, "brand"sv },
        { R"("/911488/futbolka-detskaya-3d-dolphin-vozrast-1-2-goda-trikotazh/")"sv, ResultType::Return, "/911488/futbolka-detskaya-3d-dolphin-vozrast-1-2-goda-trikotazh/"sv },
        { R"("id")"sv, ResultType::Return, "id"sv },
        { R"("913361")"sv, ResultType::Return, "913361"sv },
        { R"("name")"sv, ResultType::Return, "name"sv },
        { R"("3Д Футболка детская World р-р 8-10, 100% хлопок, трикотаж")"sv, ResultType::Return, "3Д Футболка детская World р-р 8-10, 100% хлопок, трикотаж"sv },
        { R"("category")"sv, ResultType::Return, "category"sv },
        { R"("/Летние товары/Летний текстиль/")"sv, ResultType::Return, "/Летние товары/Летний текстиль/"sv },
        { R"("variant")"sv, ResultType::Return, "variant"sv },
        { R"("")"sv, ResultType::Return, ""sv },
        { R"("price")"sv, ResultType::Return, "price"sv },
        { R"("470.00")"sv, ResultType::Return, "470.00"sv },
        { R"("list")"sv, ResultType::Return, "list"sv },
        { R"("/retailrocket/")"sv, ResultType::Return, "/retailrocket/"sv },
        { R"("position")"sv, ResultType::Return, "position"sv },
        { R"("brand")"sv, ResultType::Return, "brand"sv },
        { R"("/911488/futbolka-detskaya-3d-dolphin-vozrast-1-2-goda-trikotazh/")"sv, ResultType::Return, "/911488/futbolka-detskaya-3d-dolphin-vozrast-1-2-goda-trikotazh/"sv },
        { R"("id")"sv, ResultType::Return, "id"sv },
        { R"("913364")"sv, ResultType::Return, "913364"sv },
        { R"("name")"sv, ResultType::Return, "name"sv },
        { R"("3Д Футболка детская Force р-р 8-10, 100% хлопок, трикотаж")"sv, ResultType::Return, "3Д Футболка детская Force р-р 8-10, 100% хлопок, трикотаж"sv },
        { R"("category")"sv, ResultType::Return, "category"sv },
        { R"("/Летние товары/Летний текстиль/")"sv, ResultType::Return, "/Летние товары/Летний текстиль/"sv },
        { R"("variant")"sv, ResultType::Return, "variant"sv },
        { R"("")"sv, ResultType::Return, ""sv },
        { R"("price")"sv, ResultType::Return, "price"sv },
        { R"("470.00")"sv, ResultType::Return, "470.00"sv },
        { R"("list")"sv, ResultType::Return, "list"sv },
        { R"("/retailrocket/")"sv, ResultType::Return, "/retailrocket/"sv },
        { R"("position")"sv, ResultType::Return, "position"sv },
        { R"("brand")"sv, ResultType::Return, "brand"sv },
        { R"("/911488/futbolka-detskaya-3d-dolphin-vozrast-1-2-goda-trikotazh/")"sv, ResultType::Return, "/911488/futbolka-detskaya-3d-dolphin-vozrast-1-2-goda-trikotazh/"sv },
        { R"("id")"sv, ResultType::Return, "id"sv },
        { R"("913367")"sv, ResultType::Return, "913367"sv },
        { R"("name")"sv, ResultType::Return, "name"sv },
        { R"("3Д Футболка детская Winter tale р-р 8-10, 100% хлопок, трикотаж")"sv, ResultType::Return, "3Д Футболка детская Winter tale р-р 8-10, 100% хлопок, трикотаж"sv },
        { R"("category")"sv, ResultType::Return, "category"sv },
        { R"("/Летние товары/Летний текстиль/")"sv, ResultType::Return, "/Летние товары/Летний текстиль/"sv },
        { R"("variant")"sv, ResultType::Return, "variant"sv },
        { R"("")"sv, ResultType::Return, ""sv },
        { R"("price")"sv, ResultType::Return, "price"sv },
        { R"("470.00")"sv, ResultType::Return, "470.00"sv },
        { R"("list")"sv, ResultType::Return, "list"sv },
        { R"("/retailrocket/")"sv, ResultType::Return, "/retailrocket/"sv },
        { R"("position")"sv, ResultType::Return, "position"sv },
        { R"("brand")"sv, ResultType::Return, "brand"sv },
        { R"("/911488/futbolka-detskaya-3d-dolphin-vozrast-1-2-goda-trikotazh/")"sv, ResultType::Return, "/911488/futbolka-detskaya-3d-dolphin-vozrast-1-2-goda-trikotazh/"sv },
        { R"("id")"sv, ResultType::Return, "id"sv },
        { R"("913385")"sv, ResultType::Return, "913385"sv },
        { R"("name")"sv, ResultType::Return, "name"sv },
        { R"("3Д Футболка детская Moonshine р-р 8-10, 100% хлопок, трикотаж")"sv, ResultType::Return, "3Д Футболка детская Moonshine р-р 8-10, 100% хлопок, трикотаж"sv },
        { R"("category")"sv, ResultType::Return, "category"sv },
        { R"("/Летние товары/Летний текстиль/")"sv, ResultType::Return, "/Летние товары/Летний текстиль/"sv },
        { R"("variant")"sv, ResultType::Return, "variant"sv },
        { R"("")"sv, ResultType::Return, ""sv },
        { R"("price")"sv, ResultType::Return, "price"sv },
        { R"("470.00")"sv, ResultType::Return, "470.00"sv },
        { R"("list")"sv, ResultType::Return, "list"sv },
        { R"("/retailrocket/")"sv, ResultType::Return, "/retailrocket/"sv },
        { R"("position")"sv, ResultType::Return, "position"sv },
        { R"("brand")"sv, ResultType::Return, "brand"sv },
        { R"("/911488/futbolka-detskaya-3d-dolphin-vozrast-1-2-goda-trikotazh/")"sv, ResultType::Return, "/911488/futbolka-detskaya-3d-dolphin-vozrast-1-2-goda-trikotazh/"sv },
        { R"("id")"sv, ResultType::Return, "id"sv },
        { R"("913391")"sv, ResultType::Return, "913391"sv },
        { R"("name")"sv, ResultType::Return, "name"sv },
        { R"("3Д Футболка детская Shaman р-р 8-10, 100% хлопок, трикотаж")"sv, ResultType::Return, "3Д Футболка детская Shaman р-р 8-10, 100% хлопок, трикотаж"sv },
        { R"("category")"sv, ResultType::Return, "category"sv },
        { R"("/Летние товары/Летний текстиль/")"sv, ResultType::Return, "/Летние товары/Летний текстиль/"sv },
        { R"("variant")"sv, ResultType::Return, "variant"sv },
        { R"("")"sv, ResultType::Return, ""sv },
        { R"("price")"sv, ResultType::Return, "price"sv },
        { R"("470.00")"sv, ResultType::Return, "470.00"sv },
        { R"("list")"sv, ResultType::Return, "list"sv },
        { R"("/retailrocket/")"sv, ResultType::Return, "/retailrocket/"sv },
        { R"("position")"sv, ResultType::Return, "position"sv },
        { R"("brand")"sv, ResultType::Return, "brand"sv },
        { R"("/911488/futbolka-detskaya-3d-dolphin-vozrast-1-2-goda-trikotazh/")"sv, ResultType::Return, "/911488/futbolka-detskaya-3d-dolphin-vozrast-1-2-goda-trikotazh/"sv },
        { R"("usertype")"sv, ResultType::Return, "usertype"sv },
        { R"("visitor")"sv, ResultType::Return, "visitor"sv },
        { R"("lang")"sv, ResultType::Return, "lang"sv },
        { R"("ru")"sv, ResultType::Return, "ru"sv },
        { R"("__ym")"sv, ResultType::Return, "__ym"sv },
        { R"("ecommerce")"sv, ResultType::Return, "ecommerce"sv },
        { R"("impressions")"sv, ResultType::Return, "impressions"sv },
        { R"("experiments")"sv, ResultType::Return, "experiments"sv },
        { R"("lang")"sv, ResultType::Return, "lang"sv },
        { R"("ru")"sv, ResultType::Return, "ru"sv },
        { R"("los_portal")"sv, ResultType::Return, "los_portal"sv },
        { R"("los_level")"sv, ResultType::Return, "los_level"sv },
        { R"("none")"sv, ResultType::Return, "none"sv },
        { R"("experiments")"sv, ResultType::Return, "experiments"sv },
        { R"("lang")"sv, ResultType::Return, "lang"sv },
        { R"("ru")"sv, ResultType::Return, "ru"sv },
        { R"("los_portal")"sv, ResultType::Return, "los_portal"sv },
        { R"("los_level")"sv, ResultType::Return, "los_level"sv },
        { R"("none")"sv, ResultType::Return, "none"sv },
        { R"("experiments")"sv, ResultType::Return, "experiments"sv },
        { R"("lang")"sv, ResultType::Return, "lang"sv },
        { R"("ru")"sv, ResultType::Return, "ru"sv },
        { R"("los_portal")"sv, ResultType::Return, "los_portal"sv },
        { R"("los_level")"sv, ResultType::Return, "los_level"sv },
        { R"("none")"sv, ResultType::Return, "none"sv },
        { R"("experiments")"sv, ResultType::Return, "experiments"sv },
        { R"("lang")"sv, ResultType::Return, "lang"sv },
        { R"("ru")"sv, ResultType::Return, "ru"sv },
        { R"("los_portal")"sv, ResultType::Return, "los_portal"sv },
        { R"("los_level")"sv, ResultType::Return, "los_level"sv },
        { R"("none")"sv, ResultType::Return, "none"sv },
        { R"("experiments")"sv, ResultType::Return, "experiments"sv },
        { R"("lang")"sv, ResultType::Return, "lang"sv },
        { R"("ru")"sv, ResultType::Return, "ru"sv },
        { R"("los_portal")"sv, ResultType::Return, "los_portal"sv },
        { R"("los_level")"sv, ResultType::Return, "los_level"sv },
        { R"("none")"sv, ResultType::Return, "none"sv },
        { R"("__ym")"sv, ResultType::Return, "__ym"sv },
        { R"("ecommerce")"sv, ResultType::Return, "ecommerce"sv },
        { R"("currencyCode")"sv, ResultType::Return, "currencyCode"sv },
        { R"("RUR")"sv, ResultType::Return, "RUR"sv },
        { R"("impressions")"sv, ResultType::Return, "impressions"sv },
        { R"("name")"sv, ResultType::Return, "name"sv },
        { R"("Чайник электрический Mystery MEK-1627, белый")"sv, ResultType::Return, "Чайник электрический Mystery MEK-1627, белый"sv },
        { R"("brand")"sv, ResultType::Return, "brand"sv },
        { R"("Mystery")"sv, ResultType::Return, "Mystery"sv },
        { R"("id")"sv, ResultType::Return, "id"sv },
        { R"("187180")"sv, ResultType::Return, "187180"sv },
        { R"("category")"sv, ResultType::Return, "category"sv },
        { R"("Мелкая бытовая техника/Мелкие кухонные приборы/Чайники электрические/Mystery")"sv, ResultType::Return, "Мелкая бытовая техника/Мелкие кухонные приборы/Чайники электрические/Mystery"sv },
        { R"("variant")"sv, ResultType::Return, "variant"sv },
        { R"("В наличии")"sv, ResultType::Return, "В наличии"sv },
        { R"("price")"sv, ResultType::Return, "price"sv },
        { R"("1630.00")"sv, ResultType::Return, "1630.00"sv },
        { R"("list")"sv, ResultType::Return, "list"sv },
        { R"("Карточка")"sv, ResultType::Return, "Карточка"sv },
        { R"("position")"sv, ResultType::Return, "position"sv },
        { R"("detail")"sv, ResultType::Return, "detail"sv },
        { R"("actionField")"sv, ResultType::Return, "actionField"sv },
        { R"("list")"sv, ResultType::Return, "list"sv },
        { "\0\""sv, ResultType::Throw, "JSON: expected \", got \0"sv },
        { "\"/igrushki/konstruktory\0"sv, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."sv },
        { "\"/1290414/komplekt-zhenskiy-dzhemper-plusbryuki-m-254-09-malina-plustemno-siniy-\0a"sv, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."sv },
        { "\"/Творчество/Рисование/Инструменты и кра\0a"sv, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."sv },
        { "\"Строительство и ремонт/Силовая техника/Зарядные устройства для автомобильных аккумуляторов/Пуско-зарядные устр\xD0\0a"sv, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."sv },
        { "\"Строительство и ремонт/Силовая техника/Зарядные устройств\xD0\0t"sv, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."sv },
        { "\"Строительство и ремонт/Силовая техника/Зарядные устройства для автомобиль\0k"sv, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."sv },
        { "\0t"sv, ResultType::Throw, "JSON: expected \", got \0"sv },
        { "\"/Хозтовары/Хранение вещей и организа\xD1\0t"sv, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."sv },
        { "\"/Хозтовары/Товары для стир\0a"sv, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."sv },
        { "\"li\0a"sv, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."sv },
        { "\"/734859/samolet-radioupravlyaemyy-istrebitel-rabotaet-o\0k"sv, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."sv },
        { "\"/kosmetika-i-parfyum/parfyumeriya/mu\0t"sv, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."sv },
        { "\"/ko\0\x04"sv, ResultType::Throw, "JSON: begin >= end."sv },
        { ""sv, ResultType::Throw, "JSON: expected \", got \0"sv },
        { "\"/stroitelstvo-i-remont/stroit\0t"sv, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."sv },
        { "\"/stroitelstvo-i-remont/stroitelnyy-instrument/av\0k"sv, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."sv },
        { "\"/s\0a"sv, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."sv },
        { "\"/Строительство и ремонт/Строительный инструмент/Изм\0e"sv, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."sv },
        { "\"/avto/soputstvuy\0l"sv, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."sv },
        { "\"/str\0\xD0"sv, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."sv },
        { "\"Отвертка 2 в 1 \\\"TUNDRA basic\\\" 5х75 мм (+,-) \0\xFF"sv, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."sv },
        { "\"/stroitelstvo-i-remont/stroitelnyy-instrument/avtoinstrumen\0\0"sv, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."sv },
        { "\"Мелкая бытовая техника/Мелки\xD0\0\0"sv, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."sv },
        { "\"Пряжа \\\"Бамбук стрейч\\0\0\0"sv, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."sv },
        { "\"Карандаш чёрнографитны\xD0\0\xD0"sv, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."sv },
        { "\"/Творчество/Рукоделие, аппликации/Пряжа и шерсть для \xD0\0l"sv, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."sv },
        { "\"/1071547/karandash-chernografitnyy-volshebstvo-nv-kruglyy-d-7-2mm-dl-176mm-plast-tuba/\0e"sv, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."sv },
        { "\"ca\0e"sv, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."sv },
        { "\"ca\0e"sv, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."sv },
        { "\"/1165424/chipbord-vyrubnoy-dlya-skrapbukinga-malyshi-mikki-maus-disney-bebi\0t"sv, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."sv },
        { "\"/posuda/kuhonnye-prinadlezhnosti-i-i\0d"sv, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."sv },
        { "\"/Канцтовары/Ежедневники и блокн\xD0\0\0"sv, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."sv },
        { "\"/kanctovary/ezhednevniki-i-blok\0a"sv, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."sv },
        { "\"Стакан \xD0\0a"sv, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."sv },
        { "\"Набор бумаги для скрапбукинга \\\"Мои первый годик\\\": Микки Маус, Дисней бэби, 12 листов 29.5 х 29.5 см, 160\0\x80"sv, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."sv },
        { "\"c\0\0"sv, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."sv },
        { "\"Органайзер для хранения аксессуаров, \0\0"sv, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."sv },
        { "\"quantity\00"sv, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."sv },
        { "\"Сменный блок для тетрадей на кольцах А5, 160 листов клетка, офсет \xE2\x84\0="sv, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."sv },
        { "\"/Сувениры/Ф\xD0\0 "sv, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."sv },
        { "\"\0\""sv, ResultType::Return, "\0"sv },
        { "\"\0\x04"sv, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."sv },
        { "\"va\0\0"sv, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."sv },
        { "\"ca\0\0"sv, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."sv },
        { "\"В \0\x04"sv, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."sv },
        { "\"/letnie-tovary/z\0\x04"sv, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."sv },
        { "\"Посудомоечная машина Ha\0="sv, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."sv },
        { "\"Крупная бытов\0\0"sv, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."sv },
        { "\"Полочная акустическая система Magnat Needl\0\0"sv, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."sv },
        { "\"brand\00"sv, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."sv },
        { "\"\0d"sv, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."sv },
        { "\"pos\0 "sv, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."sv },
        { "\"c\0o"sv, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."sv },
        { "\"var\0\0"sv, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."sv },
        { "\"Телевизоры и видеотехника/Всё для домашних кинотеатр\0="sv, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."sv },
        { "\"Флеш-диск Transcend JetFlash 620 8GB (TS8GJF62\0\0"sv, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."sv },
        { "\"Табурет Мег\0\xD0"sv, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."sv },
        { "\"variant\0\x04"sv, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."sv },
        { "\"Катал\xD0\0\""sv, ResultType::Return, "Катал\xD0\0"sv },
        { "\"К\0\0"sv, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."sv },
        { "\"Полочная акустическая система Magnat Needl\0\0"sv, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."sv },
        { "\"brand\00"sv, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."sv },
        { "\"\0d"sv, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."sv },
        { "\"pos\0 "sv, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."sv },
        { "\"c\0o"sv, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."sv },
        { "\"17\0o"sv, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."sv },
        { "\"/igrushki/razvivayusc\0 "sv, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."sv },
        { "\"Ключница \\\"\0 "sv, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."sv },
        { "\"/Игр\xD1\0 "sv, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."sv },
        { "\"/Игрушки/Игрушки для девочек/Игровые модули дл\xD1\0o"sv, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."sv },
        { "\"Крупная бытовая техника/Стиральные машины/С фронт\xD0\0o"sv, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."sv },
        { "\0 "sv, ResultType::Throw, "JSON: expected \", got \0"sv },
        { "\"Светодиодная лента SMD3528, 5 м. IP33, 60LED, зеленый, 4,8W/мет\xD1\0 "sv, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."sv },
        { "\"Сантехника/Мебель для ванных комнат/Стол\0o"sv, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."sv },
        { "\0o"sv, ResultType::Throw, "JSON: expected \", got \0"sv },
        { "\"/igrushki/konstruktory\0 "sv, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."sv },
        { "\"/posuda/kuhonnye-prinadlezhnosti-i-instrumenty/kuhonnye-pr\0 "sv, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."sv },
        { "\"/1290414/komplekt-zhenskiy-dzhemper-plusbryuki-m-254-09-malina-plustemno-siniy-\0o"sv, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."sv },
        { "\"/Творчество/Рисование/Инструменты и кра\0o"sv, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."sv },
        { "\"Строительство и ремонт/Силовая техника/Зарядные устройства для автомобильных аккумуляторов/Пуско-зарядные устр\xD0\0o"sv, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."sv },
        { "\"Строительство и ремонт/Силовая техника/Зарядные устройств\xD0\0 "sv, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."sv },
        { "\"Строительство и ремонт/Силовая техника/Зарядные устройства для автомобиль\0d"sv, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."sv },
        { "\0 "sv, ResultType::Throw, "JSON: expected \", got \0"sv },
        { "\"/Хозтовары/Хранение вещей и организа\xD1\0 "sv, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."sv },
        { "\"/Хозтовары/Товары для стир\0o"sv, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."sv },
        { "\"li\0o"sv, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."sv },
        { "\"/igrushki/igrus\0d"sv, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."sv },
        { "\"/734859/samolet-radioupravlyaemyy-istrebitel-rabotaet-o\0 "sv, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."sv },
        { "\"/kosmetika-i-parfyum/parfyumeriya/mu\00"sv, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."sv },
        { "\"/ko\0\0"sv, ResultType::Throw, "JSON: begin >= end."sv },
        { "\"/avto/avtomobilnyy\0\0"sv, ResultType::Throw, "JSON: begin >= end."sv },
        { "\"/stroitelstvo-i-remont/stroit\00"sv, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."sv },
        { "\"/stroitelstvo-i-remont/stroitelnyy-instrument/av\0 "sv, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."sv },
        { "\"/s\0d"sv, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."sv },
        { "\"/Строительство и ремонт/Строительный инструмент/Изм\0o"sv, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."sv },
        { "\"/avto/soputstvuy\0\""sv, ResultType::Return, "/avto/soputstvuy\0"sv },
        { "\"/str\0k"sv, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."sv },
        { "\"Отвертка 2 в 1 \\\"TUNDRA basic\\\" 5х75 мм (+,-) \0\xD0"sv, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."sv },
        { "\"/stroitelstvo-i-remont/stroitelnyy-instrument/avtoinstrumen\0="sv, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."sv },
        { "\"Чайник электрический Vitesse\0="sv, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."sv },
        { "\"Мелкая бытовая техника/Мелки\xD0\0\xD0"sv, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."sv },
        { "\"Пряжа \\\"Бамбук стрейч\\0о"sv, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."sv },
        { "\"Карандаш чёрнографитны\xD0\0k"sv, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."sv },
        { "\"/Творчество/Рукоделие, аппликации/Пряжа и шерсть для \xD0\0\""sv, ResultType::Return, "/Творчество/Рукоделие, аппликации/Пряжа и шерсть для \xD0\0"sv },
        { "\"/1071547/karandash-chernografitnyy-volshebstvo-nv-kruglyy-d-7-2mm-dl-176mm-plast-tuba/\0o"sv, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."sv },
        { "\"ca\0o"sv, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."sv },
        { "\"/Подаро\0o"sv, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."sv },
        { "\"Средство для прочис\xD1\0o"sv, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."sv },
        { "\"i\0o"sv, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."sv },
        { "\"/p\0\""sv, ResultType::Return, "/p\0"sv },
        { "\"/Сувениры/Магниты, н\xD0\0k"sv, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."sv },
        { "\"Дерев\xD0\0="sv, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."sv },
        { "\"/prazdniki/svadba/svadebnaya-c\0\xD0"sv, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."sv },
        { "\"/Канцт\0d"sv, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."sv },
        { "\"/Праздники/То\xD0\0 "sv, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."sv },
        { "\"v\0 "sv, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."sv },
        { "\"/Косметика \xD0\0d"sv, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."sv },
        { "\"/Спорт и отдых/Настольные игры/Покер, руле\xD1\0\xD0"sv, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."sv },
        { "\"categ\0="sv, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."sv },
        { "\"/retailr\0k"sv, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."sv },
        { "\"/retailrocket\0k"sv, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."sv },
        { "\"Ежедневник недат А5 140л кл,ляссе,обл пв\0="sv, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."sv },
        { "\"/432809/ezhednevnik-organayzer-sredniy-s-remeshkom-na-knopke-v-oblozhke-kalkulyator-kalendar-do-\0\xD0"sv, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."sv },
        { "\"/1165424/chipbord-vyrubnoy-dlya-skrapbukinga-malyshi-mikki-maus-disney-bebi\0d"sv, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."sv },
        { "\"/posuda/kuhonnye-prinadlezhnosti-i-i\0 "sv, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."sv },
        { "\"/Канцтовары/Ежедневники и блокн\xD0\0o"sv, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."sv },
        { "\"/kanctovary/ezhednevniki-i-blok\00"sv, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."sv },
        { "\"Стакан \xD0\0\0"sv, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."sv },
        { "\"Набор бумаги для скрапбукинга \\\"Мои первый годик\\\": Микки Маус, Дисней бэби, 12 листов 29.5 х 29.5 см, 160\0\0"sv, ResultType::Throw, "JSON: incorrect syntax (expected end of string, found end of JSON)."sv },
        { "\"c\0\""sv, ResultType::Return, "c\0"sv },
    };

    for (auto i : boost::irange(0, 1/*00000*/))
    {
        static_cast<void>(i);

        for (auto & r : test_data)
        {
            try
            {
                JSON j(r.input.data(), r.input.data() + r.input.size());

                ASSERT_EQ(j.getString(), r.result);
                ASSERT_EQ(r.result_type, ResultType::Return);
            }
            catch (const JSONException &)
            {
                ASSERT_EQ(r.result_type, ResultType::Throw);
            }
        }
    }
}
