### ClickHouse 版本 20.12

### ClickHouse 版本 v20.12.5.14-stable, 2020-12-28

#### Bug 修复

* 在合并期间禁用 AIO 写入, 因为它会导致合并期间主键列的数据损坏极为罕见. [#18481](https://github.com/ClickHouse/ClickHouse/pull/18481) ([alesapin](https://github.com/alesapin)).
* 修复了在使用类型为 `Nullable(String)` 的参数执行 `toType(...)` 函数 (`toDate`、`toUInt32` 等)时出现的 `value is too short` 错误. 现在这些函数在解析错误时返回 `NULL` 而不是抛出异常. 修复 [#18445](https://github.com/ClickHouse/ClickHouse/pull/18445) ([tavplubix](https://github.com/tavplubix)).
* 限制从宽部分合并到紧凑部分. 在垂直合并的情况下, 它会导致结果部分损坏. [#18381](https://github.com/ClickHouse/ClickHouse/pull/18381) ([Anton Popov](https://github.com/CurtizJ)).
* 修复填充表 `system.settings_profile_elements`. 此 PR 修复了 [#18231](https://github.com/ClickHouse/ClickHouse/issues/18231). [#18379](https://github.com/ClickHouse/ClickHouse/pull/18379) ([Vitaly Baranov](https://github.com/vitlibar)).
* 使用组合子 `Distinct` 修复聚合函数中可能的崩溃, 同时使用两级聚合. 修复 [#17682](https://github.com/ClickHouse/ClickHouse/issues/17682). [#18365](https://github.com/ClickHouse/ClickHouse/pull/18365) ([Anton Popov](https://github.com/CurtizJ)).
* 修复查询 `MODIFY COLUMN ... REMOVE TTL` 并没有真正删除列 TTL 时的错误. [#18130](https://github.com/ClickHouse/ClickHouse/pull/18130) ([alesapin](https://github.com/alesapin)).

#### 构建/测试/打包改进

* 将时区信息更新为 2020e. [#18531](https://github.com/ClickHouse/ClickHouse/pull/18531) ([alesapin](https://github.com/alesapin)).


### ClickHouse 版本 v20.12.4.5-stable, 2020-12-24

#### Bug 修复

* 修复了在具有双 IPv4/IPv6 堆栈的机器上服务器无法访问 `clickhouse-odbc-bridge` 进程的问题; - 修复了使用格式错误的查询执行 ODBC 字典更新和/或导致崩溃的问题; 可能关闭 [#14489](https://github.com/ClickHouse/ClickHouse/issues/14489). [#18278](https://github.com/ClickHouse/ClickHouse/pull/18278) ([Denis Glazachev](https://github.com/traceon)).
* 修复了 Enum 和 Int 类型之间的键比较. 这修复了 [#17989](https://github.com/ClickHouse/ClickHouse/issues/17989). [#18214](https://github.com/ClickHouse/ClickHouse/pull/18214) ([Amos Bird](https://github.com/amosbird)).
* 修复了 `MaterializeMySQL` 数据库引擎中唯一键转换崩溃的问题. 这修复了 [#18186](https://github.com/ClickHouse/ClickHouse/issues/18186) 并修复了 [#16372](https://github.com/ClickHouse/ClickHouse/issues/16372) [#18211](https://github.com/ClickHouse/ClickHouse/pull/18211) ([Winter Zhang](https://github.com/zhang2014)).
* 修复了 S3 URL 解析中的 `std::out_of_range: basic_string`. [#18059](https://github.com/ClickHouse/ClickHouse/pull/18059) ([Vladimir Chebotarev](https://github.com/excitoon)).
* 修复了由于 MaterializeMySQL 不支持转换 MySQL 前缀索引而导致某些表无法从 MySQL 同步到 ClickHouse 的问题. 这修复了 [#15187](https://github.com/ClickHouse/ClickHouse/issues/15187) 并修复了 [#17912](https://github.com/ClickHouse/ClickHouse/issues/17912) [#17944](https://github.com/ClickHouse/ClickHouse/pull/17944) ([Winter Zhang](https://github.com/zhang2014)).
* 修复了查询包含 `ARRAY JOIN` 时查询优化产生错误结果的问题. [#17887](https://github.com/ClickHouse/ClickHouse/pull/17887) ([sundyli](https://github.com/sundy-li)).
* 修复了 `topK` 聚合函数中可能出现的段错误. 这将关闭 [#17404](https://github.com/ClickHouse/ClickHouse/issues/17404). [#17845](https://github.com/ClickHouse/ClickHouse/pull/17845) ([Maksim Kita](https://github.com/kitaisreal)).
* 修复了服务器在守护进程模式下运行时空的 `system.stack_trace` 表. [#17630](https://github.com/ClickHouse/ClickHouse/pull/17630) ([Amos Bird](https://github.com/amosbird)).


### ClickHouse 版本 v20.12.3.3-stable, 2020-12-13

#### 向后不兼容变更

* 默认启用`use_compact_format_in_distributed_parts_names` (参考文档). [#16728](https://github.com/ClickHouse/ClickHouse/pull/16728) ([Azat Khuzhin](https://github.com/azat)).
* 创建使用 `File` 引擎的表时, 在 `SETTINGS` 子句中接受与文件格式 (例如 `format_csv_delimiter` ) 相关的用户设置, 并在所有 `INSERT` 和 `SELECT` 中使用这些设置. 当前用户会话中或 DML 查询本身的 `SETTINGS` 子句中更改的文件格式设置不再影响查询. [#16591](https://github.com/ClickHouse/ClickHouse/pull/16591) ([Alexander Kuzmenkov](https://github.com/akuzm)).

#### 新特征

* 添加 `*.xz` 压缩/解压支持。它允许在 `file()` 函数中使用 `*.xz`. 这将关闭 [#8828](https://github.com/ClickHouse/ClickHouse/issues/8828). [#16578](https://github.com/ClickHouse/ClickHouse/pull/16578) ([Abi Palagashvili](https://github.com/fibersel)).
* 引入查询`ALTER TABLE ... DROP|DETACH PART 'part_name'`. [#15511](https://github.com/ClickHouse/ClickHouse/pull/15511) ([nvartolomei](https://github.com/nvartolomei)).
* 添加了新的 ALTER UPDATE/DELETE IN PARTITION 语法. [#13403](https://github.com/ClickHouse/ClickHouse/pull/13403) ([Vladimir Chebotarev](https://github.com/excitoon)).
* 允许在使用 JSON 输入/输出格式时将命名元组格式化为 JSON 对象, 由 `output_format_json_named_tuples_as_objects` 设置控制, 默认禁用. [#17175](https://github.com/ClickHouse/ClickHouse/pull/17175) ([Alexander Kuzmenkov](https://github.com/akuzm)).
* 在TSV和CSV格式默认情况下添加一种可能的输入枚举值作为它的id. [#16834](https://github.com/ClickHouse/ClickHouse/pull/16834) ([Kruglov Pavel](https://github.com/Avogar)).
* 添加对 Nullable、LowCardinality、Array 和 Tuple 的 COLLATE 支持，其中嵌套类型为 String. 同时重构ColumnString.cpp中与collations相关的代码. [#16273](https://github.com/ClickHouse/ClickHouse/pull/16273) ([Kruglov Pavel](https://github.com/Avogar)).
* 新的 `tcpPort` 函数返回此服务器监听的 TCP 端口. [#17134](https://github.com/ClickHouse/ClickHouse/pull/17134) ([Ivan](https://github.com/abyss7)).
* 添加新的数学函数：`acosh`、`asinh`、`atan2`、`atanh`、`cosh`、`hypot`、`log1p`、`sinh`. [#16636](https://github.com/ClickHouse/ClickHouse/pull/16636) ([Konstantin Malanchev](https://github.com/hombit)).
* 在不同副本之间分配合并的可能性. 引入 `execute_merges_on_single_replica_time_threshold` 合并树设置. [#16424](https://github.com/ClickHouse/ClickHouse/pull/16424) ([filimonov](https://github.com/filimonov)).
* 添加设置 `aggregate_functions_null_for_empty` 以实现 SQL 标准兼容性. 此选项将重写查询中的所有聚合函数, 并向它们添加 -OrNull 后缀. 实现 [10273](https://github.com/ClickHouse/ClickHouse/issues/10273). [#16123](https://github.com/ClickHouse/ClickHouse/pull/16123) ([flynn](https://github.com/ucasFL)).
* 更新了 DateTime、DateTime64 解析以接受字符串日期文字格式. [#16040](https://github.com/ClickHouse/ClickHouse/pull/16040) ([Maksim Kita](https://github.com/kitaisreal)).
* 可以使用 `--history_file` 参数在 `clickhouse-client` 中更改历史文件的路径. [#15960](https://github.com/ClickHouse/ClickHouse/pull/15960) ([Maksim Kita](https://github.com/kitaisreal)).

#### Bug 修复

* 修复在极少数情况下服务器可以停止接受连接的问题. [#17542](https://github.com/ClickHouse/ClickHouse/pull/17542) ([Amos Bird](https://github.com/amosbird)).
* 修复了在 Linux 的 Windows 子系统上运行的 ClickHouse 在 `Atomic` 数据库中执行 `RENAME` 查询时出现的 `Function not implementation` 错误. 修复 [#17661](https://github.com/ClickHouse/ClickHouse/issues/17661). [#17664](https://github.com/ClickHouse/ClickHouse/pull/17664) ([tavplubix](https://github.com/tavplubix)).
* 如果禁用了`in_memory_parts_enable_wal`, 则不要从 WAL 恢复部件. [#17802](https://github.com/ClickHouse/ClickHouse/pull/17802) ([detailyang](https://github.com/detailyang)).
* 使用 `min_compress_block_size` 修复 MergeTreeWriterSettings 的 `max_compress_block_size` 的错误初始化. [#17833](https://github.com/ClickHouse/ClickHouse/pull/17833) ([flynn](https://github.com/ucasFL)).
* 有关要删除的最大表大小的异常消息显示不正确. [#17764](https://github.com/ClickHouse/ClickHouse/pull/17764) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 修复了插入 `Distributed` 表时空间不足时可能出现的段错误. [#17737](https://github.com/ClickHouse/ClickHouse/pull/17737) ([tavplubix](https://github.com/tavplubix)).
* 修复了 ClickHouse 无法恢复与 MySQL 服务器的连接时的问题. [#17681](https://github.com/ClickHouse/ClickHouse/pull/17681) ([Alexander Kazakov](https://github.com/Akazz)).
* 当 `pool_size` > 1 时, 由于竞争条件, 在执行 `ON CLUSTER` 查询时, 可能会错误地确定集群是否为循环 (交叉) 复制. 已修复. [#17640](https://github.com/ClickHouse/ClickHouse/pull/17640) ([tavplubix](https://github.com/tavplubix)).
* 异常 `fmt::v7::format_error` 可以记录在 MergeTree 表的后台. 这修复了 [#17613](https://github.com/ClickHouse/ClickHouse/issues/17613). [#17615](https://github.com/ClickHouse/ClickHouse/pull/17615) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 当 clickhouse-client 在交互模式下与多行查询一起使用时, 单行注释被错误地扩展到查询结束. 这修复了 [#13654](https://github.com/ClickHouse/ClickHouse/issues/13654). [#17565](https://github.com/ClickHouse/ClickHouse/pull/17565) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 当相应的突变在不同的副本上被杀死时, 修复更改查询挂起. 修复 [#16953](https://github.com/ClickHouse/ClickHouse/issues/16953). [#17499](https://github.com/ClickHouse/ClickHouse/pull/17499) ([alesapin](https://github.com/alesapin)).
* 修复了 clickhouse 低估了标记缓存大小的问题. 当有很多带有标记的小文件时可能会发生. [#17496](https://github.com/ClickHouse/ClickHouse/pull/17496) ([alesapin](https://github.com/alesapin)).
* 启用设置 `optimize_redundant_functions_in_order_by` 来修复 `ORDER BY`. [#17471](https://github.com/ClickHouse/ClickHouse/pull/17471) ([Anton Popov](https://github.com/CurtizJ)).
* 修复 `DISTINCT` 之后由于不正确优化而可能出现的重复项. 修复 [#17294](https://github.com/ClickHouse/ClickHouse/issues/17294). [#17296](https://github.com/ClickHouse/ClickHouse/pull/17296) ([li chengxiang](https://github.com/chengxianglibra)). [#17439](https://github.com/ClickHouse/ClickHouse/pull/17439) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* 修复从具有 `LowCardinality` 类型的 `JOIN` 表读取时崩溃的问题. 修复 [#17228](https://github.com/ClickHouse/ClickHouse/issues/17228). [#17397](https://github.com/ClickHouse/ClickHouse/pull/17397) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* 修复 `toInt256(inf)` 堆栈溢出. Int256 是一项实验性功能. 已关闭 [#17235](https://github.com/ClickHouse/ClickHouse/issues/17235). [#17257](https://github.com/ClickHouse/ClickHouse/pull/17257) ([flynn](https://github.com/ucasFL)).
* 使用 `LIMIT` 修复分布式查询中可能记录的 `Unexpected packet Data received from client` 错误. [#17254](https://github.com/ClickHouse/ClickHouse/pull/17254) ([Azat Khuzhin](https://github.com/azat)).
* 修复子查询中存在 const 列时设置索引失效的问题. 这修复了 [#17246](https://github.com/ClickHouse/ClickHouse/issues/17246). [#17249](https://github.com/ClickHouse/ClickHouse/pull/17249) ([Amos Bird](https://github.com/amosbird)).
* 修复索引比较类型不同时可能出现的错误索引分析. 这修复了 [#17122](https://github.com/ClickHouse/ClickHouse/issues/17122). [#17145](https://github.com/ClickHouse/ClickHouse/pull/17145) ([Amos Bird](https://github.com/amosbird)).
* 修复 ColumnConst 比较导致崩溃. 这个修复了 [#17088](https://github.com/ClickHouse/ClickHouse/issues/17088). [#17135](https://github.com/ClickHouse/ClickHouse/pull/17135) ([Amos Bird](https://github.com/amosbird)).
* MaterializeMySQL (实验功能) 的多个修复. 修复 [#16923](https://github.com/ClickHouse/ClickHouse/issues/16923) 修复 [#15883](https://github.com/ClickHouse/ClickHouse/issues/15883) 修复 MaterializeMySQL 同步失败时修改 MySQL binlog_checksum. [#17091](https://github.com/ClickHouse/ClickHouse/pull/17091) ([Winter Zhang](https://github.com/zhang2014)).
* 修复非领导者 ReplicatedMergeTree 表的 `ON CLUSTER` 查询可能永远挂起的错误. [#17089](https://github.com/ClickHouse/ClickHouse/pull/17089) ([alesapin](https://github.com/alesapin)).
* 修复了在创建 `some_table` 时 `CREATE TABLE ... AS some_table` 查询崩溃 `AS table_function()` 修复. [#17072](https://github.com/ClickHouse/ClickHouse/pull/17072) ([tavplubix](https://github.com/tavplubix)).
* 功能模糊位的错误未完成的实现, 相关问题: [#16980](https://github.com/ClickHouse/ClickHouse/issues/16980). [#17051](https://github.com/ClickHouse/ClickHouse/pull/17051) ([hexiaoting](https://github.com/hexiaoting)).
* 在 CFA 寄存器为 RAX 的情况下修复 LLVM 的 libunwind. 这是 [LLVM's libunwind](https://github.com/llvm/llvm-project/tree/master/libunwind) 中的 [bug](https://bugs.llvm.org/show_bug.cgi?id=48186) ). 我们已经有针对此错误的解决方法. [#17046](https://github.com/ClickHouse/ClickHouse/pull/17046) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 避免远程查询的不必要的网络错误, 这些错误在执行时可能会被取消, 例如使用 `LIMIT` 的查询. [#17006](https://github.com/ClickHouse/ClickHouse/pull/17006) ([Azat Khuzhin](https://github.com/azat)).
* 修复 `optimize_distributed_group_by_sharding_key` 设置 (默认情况下禁用) 以仅使用 OFFSET 进行查询. [#16996](https://github.com/ClickHouse/ClickHouse/pull/16996) ([Azat Khuzhin](https://github.com/azat)).
* 修复了使用 JOIN 在分布式表上合并表的问题. [#16993](https://github.com/ClickHouse/ClickHouse/pull/16993) ([Azat Khuzhin](https://github.com/azat)).
* 修复了从 double 转换时大整数 (128、256 位) 的错误结果。 大整数支持是实验性的. [#16986](https://github.com/ClickHouse/ClickHouse/pull/16986) ([Mike](https://github.com/myrrc)).
* 修复在 `ALTER TABLE ... MODIFY COLUMN ... NewType` 之后可能发生的服务器崩溃, 当 `SELECT` 在更改列上具有 `WHERE` 表达式并且更改尚未完成时. [#16968](https://github.com/ClickHouse/ClickHouse/pull/16968) ([Amos Bird](https://github.com/amosbird)).
* `clickhouse-git-import` 中没有正确计算批判信息. [#16959](https://github.com/ClickHouse/ClickHouse/pull/16959) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 通过使用单调函数进行优化来修复顺序. 修复 [#16107](https://github.com/ClickHouse/ClickHouse/issues/16107). [#16956](https://github.com/ClickHouse/ClickHouse/pull/16956) ([Anton Popov](https://github.com/CurtizJ)).
* 通过启用 `optimize_aggregators_of_group_by_keys` 和 join 设置来修复组的优化. 修复 [#12604](https://github.com/ClickHouse/ClickHouse/issues/12604). [#16951](https://github.com/ClickHouse/ClickHouse/pull/16951) ([Anton Popov](https://github.com/CurtizJ)).
* 修复使用 `ORDER BY` 的查询可能出现的错误 `Illegal type of argument` . 修复 [#16580](https://github.com/ClickHouse/ClickHouse/issues/16580). [#16928](https://github.com/ClickHouse/ClickHouse/pull/16928) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* 修复 InterpreterShowAccessQuery 中的奇怪代码. [#16866](https://github.com/ClickHouse/ClickHouse/pull/16866) ([tavplubix](https://github.com/tavplubix)).
* 使用函数 `timeSeriesGroupSum` 时防止clickhouse 服务器崩溃. 该功能已从较新的 ClickHouse 版本中删除. [#16865](https://github.com/ClickHouse/ClickHouse/pull/16865) ([filimonov](https://github.com/filimonov)).
* 当查询分析器打开并且 ClickHouse 安装在操作系统上时, 修复罕见的无声崩溃, glibc 版本已经 (据说) 损坏了某些功能的异步展开表. 这修复了 [#15301](https://github.com/ClickHouse/ClickHouse/issues/15301). This fixes [#13098](https://github.com/ClickHouse/ClickHouse/issues/13098). [#16846](https://github.com/ClickHouse/ClickHouse/pull/16846) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 修复在不带任何参数的情况下使用 `any` 时的崩溃。 这是针对 [#16803](https://github.com/ClickHouse/ClickHouse/issues/16803)的 . cc @azat. [#16826](https://github.com/ClickHouse/ClickHouse/pull/16826) ([Amos Bird](https://github.com/amosbird)).
* 如果在磁盘上写入表元数据时无法分配内存, 则可以写入损坏的元数据文件. [#16772](https://github.com/ClickHouse/ClickHouse/pull/16772) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 使用分区谓词修复琐碎的查询优化. [#16767](https://github.com/ClickHouse/ClickHouse/pull/16767) ([Azat Khuzhin](https://github.com/azat)).
* 在启用了 `transform_null_in` 设置的情况下修复多列和元组上的 `IN` 运算符. 修复 [#15310](https://github.com/ClickHouse/ClickHouse/issues/15310). [#16722](https://github.com/ClickHouse/ClickHouse/pull/16722) ([Anton Popov](https://github.com/CurtizJ)).
* 通过 MySQL 协议返回 INSERT 查询的受影响行数. 以前 ClickHouse 过去总是返回 0, 现在已修复. 修复 [#16605](https://github.com/ClickHouse/ClickHouse/issues/16605). [#16715](https://github.com/ClickHouse/ClickHouse/pull/16715) ([Winter Zhang](https://github.com/zhang2014)).
* 修复使用 `if` 后缀聚合函数时远程查询失败的问题. 修复 [#16574](https://github.com/ClickHouse/ClickHouse/issues/16574) Fixes [#16231](https://github.com/ClickHouse/ClickHouse/issues/16231) [#16610](https://github.com/ClickHouse/ClickHouse/pull/16610) ([Winter Zhang](https://github.com/zhang2014)).
* 修复由 `select_sequential_consistency` 引起的不一致行为, 用于优化的琐碎计数查询和 system.tables. [#16309](https://github.com/ClickHouse/ClickHouse/pull/16309) ([Hao Chen](https://github.com/haoch)).

#### 改进

* 删除被 TTL、变异或折叠合并算法修剪后的空部分. [#16895](https://github.com/ClickHouse/ClickHouse/pull/16895) ([Anton Popov](https://github.com/CurtizJ)).
* 为分布式表中的异步发送启用紧凑格式的目录: `use_compact_format_in_distributed_parts_names` 默认设置为 1. [#16788](https://github.com/ClickHouse/ClickHouse/pull/16788) ([Azat Khuzhin](https://github.com/azat)).
* 如果没有数据写入 S3, 则中止分段上传. [#16840](https://github.com/ClickHouse/ClickHouse/pull/16840) ([Pavel Kovalenko](https://github.com/Jokser)).
* 重新解析 `format_avro_schema_registry_url` 的IP. [#16985](https://github.com/ClickHouse/ClickHouse/pull/16985) ([filimonov](https://github.com/filimonov)).
* 在 system.distribution_queue 中的 data_path 中屏蔽密码. [#16727](https://github.com/ClickHouse/ClickHouse/pull/16727) ([Azat Khuzhin](https://github.com/azat)).
* 使用列转换器替换不存在的列时抛出错误. [#16183](https://github.com/ClickHouse/ClickHouse/pull/16183) ([hexiaoting](https://github.com/hexiaoting)).
* 当没有足够的内存供所有线程同时工作时关闭并行解析. 当有人试图插入非常大的行 (> min_chunk_bytes_for_parallel_parsing) 时, 也可能有 `Memory limit exceeded` 之类的例外, 因为要解析的每个部分都必须是独立的一组字符串 (一个或多个). [#16721](https://github.com/ClickHouse/ClickHouse/pull/16721) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* 安装脚本应始终在 config 文件夹中创建子目录. 这仅与使用自定义配置的 Docker 构建相关. [#16936](https://github.com/ClickHouse/ClickHouse/pull/16936) ([filimonov](https://github.com/filimonov)).
* 纠正 JSONEachRow、JSONCompactEachRow 和 RegexpRow 输入格式的错误消息中的语法. [#17205](https://github.com/ClickHouse/ClickHouse/pull/17205) ([nico piderman](https://github.com/sneako)).
* 将 `SOURCE(CLICKHOUSE(...))` 的默认 `host` 和 `port` 参数设置为当前实例，并将默认的 `user` 值设置为 `default`. [#16997](https://github.com/ClickHouse/ClickHouse/pull/16997) ([vdimir](https://github.com/vdimir)).
* 执行`ATTACH/DETACH TABLE <DICTIONARY>` 时抛出信息性错误消息. 在此 PR 之前, `detach table <dict>` 可以工作, 但会导致内存中元数据格式错误. [#16885](https://github.com/ClickHouse/ClickHouse/pull/16885) ([Amos Bird](https://github.com/amosbird)).
* 添加 cutToFirstSignificantSubdomainWithWWW(). [#16845](https://github.com/ClickHouse/ClickHouse/pull/16845) ([Azat Khuzhin](https://github.com/azat)).
* 如果给出错误的配置, 服务器拒绝启动并显示异常消息 (缺少`metric_log`.`collect_interval_milliseconds`). [#16815](https://github.com/ClickHouse/ClickHouse/pull/16815) ([Ivan](https://github.com/abyss7)).
* 不存在分布式 DDL 配置时更好的异常消息. 这修复了 [#5075](https://github.com/ClickHouse/ClickHouse/issues/5075). [#16769](https://github.com/ClickHouse/ClickHouse/pull/16769) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* 可用性改进：当 `CODEC` 表达式在 `CREATE TABLE` 查询中错位时, 在语法错误消息中提供更好的建议. 这修复了 [#12493](https://github.com/ClickHouse/ClickHouse/issues/12493). [#16768](https://github.com/ClickHouse/ClickHouse/pull/16768) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 在分布式引擎启动时删除异步插入的空目录. [#16729](https://github.com/ClickHouse/ClickHouse/pull/16729) ([Azat Khuzhin](https://github.com/azat)).
* 将 S3 与 nginx 服务器一起用作代理的解决方法. Nginx 当前不接受像 `http://domain.com?delete` 这样的空路径 url, 但是 vanilla aws-sdk-cpp 会产生这种 url. 此提交使用修补过的 aws-sdk-cpp 版本, 在这种情况下, 它使 url 以 "/" 作为路径, 例如 `http://domain.com/?delete`. [#16709](https://github.com/ClickHouse/ClickHouse/pull/16709) ([ianton-ru](https://github.com/ianton-ru)).
* 允许 `reinterpretAs*` 函数处理相同大小的整数和浮点数. 实现 [16640](https://github.com/ClickHouse/ClickHouse/issues/16640). [#16657](https://github.com/ClickHouse/ClickHouse/pull/16657) ([flynn](https://github.com/ucasFL)).
* 现在，`<auxiliary_zookeepers>` 配置可以在 `config.xml` 中更改并在不启动服务器的情况下重新加载. [#16627](https://github.com/ClickHouse/ClickHouse/pull/16627) ([Amos Bird](https://github.com/amosbird)).
* 在到远程资源的 https 连接中支持 SNI. 这将允许连接到需要 SNI 的 Cloudflare 服务器. 这修复了 [#10055](https://github.com/ClickHouse/ClickHouse/issues/10055). [#16252](https://github.com/ClickHouse/ClickHouse/pull/16252) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 可以连接到需要 SNI 的 `clickhouse-server` 安全端点. 当 `clickhouse-server` 托管在 TLS 代理之后是可能的. [#16938](https://github.com/ClickHouse/ClickHouse/pull/16938) ([filimonov](https://github.com/filimonov)).
* 如果创建了物化视图循环, 则修复可能的堆栈溢出. 这将关闭 [#15732](https://github.com/ClickHouse/ClickHouse/issues/15732). [#16048](https://github.com/ClickHouse/ClickHouse/pull/16048) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 简化 MergeTree 表引擎系列的后台任务处理的实现. 用户应该没有明显的变化. [#15983](https://github.com/ClickHouse/ClickHouse/pull/15983) ([alesapin](https://github.com/alesapin)).
* MaterializeMySQL (实验功能) 的改进. 当 MySQL 同步用户有错误权限时抛出关于正确同步权限的异常. [#15977](https://github.com/ClickHouse/ClickHouse/pull/15977) ([TCeason](https://github.com/TCeason)).
* 使用 BloomFilter 生成 `indexOf()` . [#14977](https://github.com/ClickHouse/ClickHouse/pull/14977) ([achimbab](https://github.com/achimbab)).

#### 性能改进

* 使用 Floyd-Rivest 算法, 它是 ClickHouse 部分排序用例的最佳选择. 基准在 https://github.com/danlark1/miniselect 和 [here](https://drive.google.com/drive/folders/1DHEaeXgZuX6AJ9eByeZ8iQVQv0ueP8XM). [#16825](https://github.com/ClickHouse/ClickHouse/pull/16825) ([Danila Kutenin](https://github.com/danlark1)).
* 现在, `ReplicatedMergeTree` 树引擎系列使用单独的线程池进行复制提取. 通过设置“background_fetches_pool_size”限制池的大小, 可以通过服务器重启进行调整. 设置的默认值是 3, 这意味着最大并行提取量等于 3 (允许使用 10G 网络) . 修复 #520. [#16390](https://github.com/ClickHouse/ClickHouse/pull/16390) ([alesapin](https://github.com/alesapin)).
* 修复了 `quantileTDigest` 状态的不受控制的增长. [#16680](https://github.com/ClickHouse/ClickHouse/pull/16680) ([hrissan](https://github.com/hrissan)).
* 将 `VIEW` 子查询描述添加到 `EXPLAIN`. 限制`VIEW`的下推优化. 将 `Distributed` 的本地副本添加到查询计划中. [#14936](https://github.com/ClickHouse/ClickHouse/pull/14936) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* 使用 max_threads > 0 和 ORDER BY 中的表达式修复 optimize_read_in_order/optimize_aggregation_in_order. [#16637](https://github.com/ClickHouse/ClickHouse/pull/16637) ([Azat Khuzhin](https://github.com/azat)).
* 修复从 `Merge` 表读取大量 `MergeTree` 表的性能. 修复 [#7748](https://github.com/ClickHouse/ClickHouse/issues/7748). [#16988](https://github.com/ClickHouse/ClickHouse/pull/16988) ([Anton Popov](https://github.com/CurtizJ)).
* 现在我们可以安全地修剪具有精确匹配的分区. 有用的案例: 假设表由 `intHash64(x) % 100` 分区, 并且查询的条件是逐字的, 而不是 x. [#16253](https://github.com/ClickHouse/ClickHouse/pull/16253) ([Amos Bird](https://github.com/amosbird)).

#### 实验功能

* 添加 `Embedded RocksDB` 表引擎 (可用于字典). [#15073](https://github.com/ClickHouse/ClickHouse/pull/15073) ([sundyli](https://github.com/sundy-li)).

#### 构建/测试/打包改进

* 测试覆盖率构建图像的改进. [#17233](https://github.com/ClickHouse/ClickHouse/pull/17233) ([alesapin](https://github.com/alesapin)).
* 将嵌入的时区数据更新到 2020d 版 (同时将 cctz 更新到最新的 master). [#17204](https://github.com/ClickHouse/ClickHouse/pull/17204) ([filimonov](https://github.com/filimonov)).
* 修复 Poco 中的 UBSan 报告. 这将关闭 [#12719](https://github.com/ClickHouse/ClickHouse/issues/12719). [#16765](https://github.com/ClickHouse/ClickHouse/pull/16765) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 不要使用 UBSan 检测第三方库. [#16764](https://github.com/ClickHouse/ClickHouse/pull/16764) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 修复缓存字典中的 UBSan 报告. 这将关闭 [#12641](https://github.com/ClickHouse/ClickHouse/issues/12641). [#16763](https://github.com/ClickHouse/ClickHouse/pull/16763) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 在尝试将无限浮点数转换为整数时修复 UBSan 报告. 这将关闭 [#14190](https://github.com/ClickHouse/ClickHouse/issues/14190). [#16677](https://github.com/ClickHouse/ClickHouse/pull/16677) ([alexey-milovidov](https://github.com/alexey-milovidov)).


## ClickHouse 版本 20.11

### ClickHouse 版本 v20.11.7.16-stable, 2021-03-02

#### 改进

* 将 clickhouse 用户和组的 uid / gid 显式设置为 clickhouse-server 图像中的固定值 (101). [#19096](https://github.com/ClickHouse/ClickHouse/pull/19096) ([filimonov](https://github.com/filimonov)).

#### Bug 修复

* BloomFilter 索引崩溃修复. 修复 [#19757](https://github.com/ClickHouse/ClickHouse/issues/19757). [#19884](https://github.com/ClickHouse/ClickHouse/pull/19884) ([Maksim Kita](https://github.com/kitaisreal)).
* 如果启用了 system.text_log, 则可能出现死锁. 这修复了 [#19874](https://github.com/ClickHouse/ClickHouse/issues/19874). [#19875](https://github.com/ClickHouse/ClickHouse/pull/19875) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 在以前的版本中, 函数 arrayEnumerateUniq 的异常参数可能会导致崩溃或无限循环. 这关闭 [#19787](https://github.com/ClickHouse/ClickHouse/issues/19787). [#19788](https://github.com/ClickHouse/ClickHouse/pull/19788) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 修复了使用算术类型与字符串类型的准确比较时的堆栈溢出. [#19773](https://github.com/ClickHouse/ClickHouse/pull/19773) ([tavplubix](https://github.com/tavplubix)).
* 修复 `bitmapAndnot` 函数中的分段错误. 修复 [#19668](https://github.com/ClickHouse/ClickHouse/issues/19668). [#19713](https://github.com/ClickHouse/ClickHouse/pull/19713) ([Maksim Kita](https://github.com/kitaisreal)).
* 一些具有大整数的函数可能会导致段错误. 大整数是实验性功能. 这关闭 [#19667](https://github.com/ClickHouse/ClickHouse/issues/19667). [#19672](https://github.com/ClickHouse/ClickHouse/pull/19672) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 修复 `LowCardinality` 参数的 `neighbor` 函数的错误结果. 修复 [#10333](https://github.com/ClickHouse/ClickHouse/issues/10333). [#19617](https://github.com/ClickHouse/ClickHouse/pull/19617) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* 修复断开连接后连接中 CompressedWriteBuffer 的 use-after-free. [#19599](https://github.com/ClickHouse/ClickHouse/pull/19599) ([Azat Khuzhin](https://github.com/azat)).
* `DROP/DETACH TABLE table ON CLUSTER cluster SYNC` 查询可能会挂起, 已修复. 修复 [#19568](https://github.com/ClickHouse/ClickHouse/issues/19568). [#19572](https://github.com/ClickHouse/ClickHouse/pull/19572) ([tavplubix](https://github.com/tavplubix)).
* 查询 CREATE DICTIONARY id 表达式修复. [#19571](https://github.com/ClickHouse/ClickHouse/pull/19571) ([Maksim Kita](https://github.com/kitaisreal)).
* 使用 merge_tree_min_rows_for_concurrent_read/merge_tree_min_bytes_for_concurrent_read=0/UINT64_MAX 修复 SIGSEGV. [#19528](https://github.com/ClickHouse/ClickHouse/pull/19528) ([Azat Khuzhin](https://github.com/azat)).
* 如果使用专门设计的参数调用 `addMonth` 函数, 则可能会发生缓冲区溢出 (在内存读取时). 这修复了 [#19441](https://github.com/ClickHouse/ClickHouse/issues/19441). This fixes [#19413](https://github.com/ClickHouse/ClickHouse/issues/19413). [#19472](https://github.com/ClickHouse/ClickHouse/pull/19472) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 如果文件之一中有空数据块，则将分布式批处理标记为已损坏. [#19449](https://github.com/ClickHouse/ClickHouse/pull/19449) ([Azat Khuzhin](https://github.com/azat)).
* 修复 Uber H3 库中可能的缓冲区溢出. 请参阅 https://github.com/uber/h3/issues/392. 这将关闭 [#19219](https://github.com/ClickHouse/ClickHouse/issues/19219). [#19383](https://github.com/ClickHouse/ClickHouse/pull/19383) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 修复 system.parts _state 列 (查询此列时出现 LOGICAL_ERROR，由于顺序不正确). [#19346](https://github.com/ClickHouse/ClickHouse/pull/19346) ([Azat Khuzhin](https://github.com/azat)).
* 修复错误 `Cannot convert column now64() because it is constant but values of constants are different in source and result` . 续 [#7156](https://github.com/ClickHouse/ClickHouse/issues/7156). [#19316](https://github.com/ClickHouse/ClickHouse/pull/19316) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* 修复在处理 ReplicatedMergeTree 表时并发 `ALTER` 和 `DROP` 查询可能挂起的错误. [#19237](https://github.com/ClickHouse/ClickHouse/pull/19237) ([alesapin](https://github.com/alesapin)).
* 修复了从 `ORC` 格式的文件中无限读取的问题 (在 [#10580](https://github.com/ClickHouse/ClickHouse/issues/10580) 中引入). 修复 [#19095](https://github.com/ClickHouse/ClickHouse/issues/19095). [#19134](https://github.com/ClickHouse/ClickHouse/pull/19134) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* 修复 clickhouse 无法从 `LowCardinality(Nullable(...))` 读取压缩编解码器并抛出异常 `Attempt to read after EOF` 时的启动错误. 修复 [#18340](https://github.com/ClickHouse/ClickHouse/issues/18340). [#19101](https://github.com/ClickHouse/ClickHouse/pull/19101) ([alesapin](https://github.com/alesapin)).
* 修复了使用 `Template` 或 `CustomSeparated` 格式通过 http 接口插入数据时出现的 `There no checkpoint` 错误. 修复 [#19021](https://github.com/ClickHouse/ClickHouse/issues/19021). [#19072](https://github.com/ClickHouse/ClickHouse/pull/19072) ([tavplubix](https://github.com/tavplubix)).
* 限制对以旧语法创建的 `MergeTree` 表的 `MODIFY TTL` 查询. 之前查询成功了, 但实际上没有效果. [#19064](https://github.com/ClickHouse/ClickHouse/pull/19064) ([Anton Popov](https://github.com/CurtizJ)).
* 确保 `groupUniqArray` 为 Enum 类型的参数返回正确的类型. 这将关闭 [#17875](https://github.com/ClickHouse/ClickHouse/issues/17875). [#19019](https://github.com/ClickHouse/ClickHouse/pull/19019) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 如果将函数 `ignore` 与 `LowCardinality` 参数一起使用, 则修复可能的错误 `Expected single dictionary argument for function` . 修复 [#14275](https://github.com/ClickHouse/ClickHouse/issues/14275). [#19016](https://github.com/ClickHouse/ClickHouse/pull/19016) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* 使用 `TinyLog` 引擎修复将 `LowCardinality` 列插入到表中的问题. 修复 [#18629](https://github.com/ClickHouse/ClickHouse/issues/18629). [#19010](https://github.com/ClickHouse/ClickHouse/pull/19010) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* 禁用 `optimize_move_functions_out_of_any` 因为优化并不总是正确的. 这将关闭 [#18051](https://github.com/ClickHouse/ClickHouse/issues/18051). 这将关闭 [#18973](https://github.com/ClickHouse/ClickHouse/issues/18973). [#18981](https://github.com/ClickHouse/ClickHouse/pull/18981) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 修复了非常罕见的关机死锁. [#18977](https://github.com/ClickHouse/ClickHouse/pull/18977) ([tavplubix](https://github.com/tavplubix)).
* 修复某些转义文本突变时的错误 (例如 `ALTER ... UPDATE e = CAST('foo', 'Enum8(\'foo\' = 1')` 序列化不正确). 修复 [#18878](https://github.com/ClickHouse/ClickHouse/issues/18878). [#18944](https://github.com/ClickHouse/ClickHouse/pull/18944) ([alesapin](https://github.com/alesapin)).
* 附加分区应该重置突变. [#18804](https://github.com/ClickHouse/ClickHouse/issues/18804). [#18935](https://github.com/ClickHouse/ClickHouse/pull/18935) ([fastio](https://github.com/fastio)).
* 修复 clickhouse-local 关机时可能挂起的问题. 这修复了 [#18891](https://github.com/ClickHouse/ClickHouse/issues/18891). [#18893](https://github.com/ClickHouse/ClickHouse/pull/18893) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 修复 *If 具有一元函数和 Nullable 类型的组合器. [#18806](https://github.com/ClickHouse/ClickHouse/pull/18806) ([Azat Khuzhin](https://github.com/azat)).
* 如果设置`network_compression_method`全局设置为非默认值，则服务器可以拒绝异步分布式插入. 这修复了 [#18741](https://github.com/ClickHouse/ClickHouse/issues/18741). [#18776](https://github.com/ClickHouse/ClickHouse/pull/18776) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 修复了在尝试将 `CAST` `NULL` 从 `Nullable(String)` 转换为 `Nullable(Decimal(P, S))` 时的 `Attempt to read after eof` 错误. 现在函数`CAST` 在它不能从可为空的字符串解析十进制时返回`NULL`. 修复 [#7690](https://github.com/ClickHouse/ClickHouse/issues/7690). [#18718](https://github.com/ClickHouse/ClickHouse/pull/18718) ([Winter Zhang](https://github.com/zhang2014)).
* 使用不匹配的 arg 大小修复 Logger. [#18717](https://github.com/ClickHouse/ClickHouse/pull/18717) ([sundyli](https://github.com/sundy-li)).
* 添加 FixedString 数据类型支持. 将数据从 MySQL 复制到 ClickHouse 时, 我会收到此异常 `Code: 50, e.displayText() = DB::Exception: Unsupported type FixedString(1)` . 此补丁修复了错误 [#18450](https://github.com/ClickHouse/ClickHouse/issues/18450) 还修复了 [#6556](https://github.com/ClickHouse/ClickHouse/issues/6556). [#18553](https://github.com/ClickHouse/ClickHouse/pull/18553) ([awesomeleo](https://github.com/awesomeleo)).
* 在使用 `RIGHT` 或  FULL` 连接进行子查询后使用 `ORDER BY` 时修复可能的 `Pipeline stuck` 错误. [#18550](https://github.com/ClickHouse/ClickHouse/pull/18550) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* 修复在相应的突变杀死后可能导致 `ALTER` 查询挂起的错误. 由线程模糊器发现. [#18518](https://github.com/ClickHouse/ClickHouse/pull/18518) ([alesapin](https://github.com/alesapin)).
* 在合并期间禁用AIO写, 因为这可能导致合并期间主键列的数据损坏. [#18481](https://github.com/ClickHouse/ClickHouse/pull/18481) ([alesapin](https://github.com/alesapin)).
* 当无法计算结果时, 在分析阶段禁用子查询的常量折叠. [#18446](https://github.com/ClickHouse/ClickHouse/pull/18446) ([Azat Khuzhin](https://github.com/azat)).
* 修复了在使用类型为 Nullable(String) 的参数执行 `toType(...)` 函数 (`toDate`、`toUInt32` 等) 时出现的 `value is too short` 错误. 现在这些函数在解析错误时返回 `NULL` 而不是抛出异常. 修复 [#7673](https://github.com/ClickHouse/ClickHouse/issues/7673). [#18445](https://github.com/ClickHouse/ClickHouse/pull/18445) ([tavplubix](https://github.com/tavplubix)).
* 限制从宽部分合并到紧凑部分. 在垂直合并的情况下, 它会导致结果部分损坏. [#18381](https://github.com/ClickHouse/ClickHouse/pull/18381) ([Anton Popov](https://github.com/CurtizJ)).
* 修复填充表 `system.settings_profile_elements` . 这个 PR 修复了 [#18231](https://github.com/ClickHouse/ClickHouse/issues/18231). [#18379](https://github.com/ClickHouse/ClickHouse/pull/18379) ([Vitaly Baranov](https://github.com/vitlibar)).
* 修复带有常量参数的二元函数的索引分析, 导致错误的查询结果. 这修复了 [#18364](https://github.com/ClickHouse/ClickHouse/issues/18364). [#18373](https://github.com/ClickHouse/ClickHouse/pull/18373) ([Amos Bird](https://github.com/amosbird)).
* 使用组合子 `Distinct` 修复聚合函数中可能的崩溃，同时使用两级聚合. 修复 [#17682](https://github.com/ClickHouse/ClickHouse/issues/17682). [#18365](https://github.com/ClickHouse/ClickHouse/pull/18365) ([Anton Popov](https://github.com/CurtizJ)).
* 如果只能从 `table` 中选择任意一列, 现在可以执行 `SELECT count() FROM table` . 此 PR 修复 [#10639](https://github.com/ClickHouse/ClickHouse/issues/10639). [#18233](https://github.com/ClickHouse/ClickHouse/pull/18233) ([Vitaly Baranov](https://github.com/vitlibar)).
* `SELECT JOIN` 现在需要对每个连接表的 `SELECT` 权限. 此 PR 修复 [#17654](https://github.com/ClickHouse/ClickHouse/issues/17654). [#18232](https://github.com/ClickHouse/ClickHouse/pull/18232) ([Vitaly Baranov](https://github.com/vitlibar)).
* 修复在读取退避的情况下从 `MergeTree*` 读取时可能不完整的查询结果 (消息`<Debug> MergeTreeReadPool: Will lower number of threads in logs). 在 [#16423](https://github.com/ClickHouse/ClickHouse/issues/16423) 中引入. 修复 [#18137](https://github.com/ClickHouse/ClickHouse/issues/18137). [#18216](https://github.com/ClickHouse/ClickHouse/pull/18216) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* 修复查询 `MODIFY COLUMN ... REMOVE TTL` 并没有真正删除列 TTL 时的错误. [#18130](https://github.com/ClickHouse/ClickHouse/pull/18130) ([alesapin](https://github.com/alesapin)).
* 使用谓词优化器修复不确定函数. 这修复了 [#17244](https://github.com/ClickHouse/ClickHouse/issues/17244). [#17273](https://github.com/ClickHouse/ClickHouse/pull/17273) ([Winter Zhang](https://github.com/zhang2014)).
* Mutation 可能会在 `MOVE` 或 `REPLACE PARTITION` 之后等待一些不存在的部分, 或者在极少数情况下, 在 `DETACH` 或 `DROP PARTITION` 之后挂起. 是固定的. [#15537](https://github.com/ClickHouse/ClickHouse/pull/15537) ([tavplubix](https://github.com/tavplubix)).

#### 构建/测试/打包改进

* 将时区信息更新为 2020e. [#18531](https://github.com/ClickHouse/ClickHouse/pull/18531) ([alesapin](https://github.com/alesapin)).


### ClickHouse 版本 v20.11.6.6-stable, 2020-12-24

#### Bug 修复

* 修复了在具有双 `IPv4/IPv6 stack` 的机器上的服务器无法访问 `clickhouse-odbc-bridge` 进程时的问题, 并修复了使用格式错误的查询执行 ODBC 字典更新和/或导致崩溃时的问题. 这可能会关闭 [#14489](https://github.com/ClickHouse/ClickHouse/issues/14489). [#18278](https://github.com/ClickHouse/ClickHouse/pull/18278) ([Denis Glazachev](https://github.com/traceon)).
* 修复了 Enum 和 Int 类型之间的键比较. 这修复了 [#17989](https://github.com/ClickHouse/ClickHouse/issues/17989). [#18214](https://github.com/ClickHouse/ClickHouse/pull/18214) ([Amos Bird](https://github.com/amosbird)).
* 修复了 `MaterializeMySQL` 数据库引擎中唯一键转换崩溃的问题. 这修复了 [#18186](https://github.com/ClickHouse/ClickHouse/issues/18186) 并修复了 [#16372](https://github.com/ClickHouse/ClickHouse/issues/16372) [#18211](https://github.com/ClickHouse/ClickHouse/pull/18211) ([Winter Zhang](https://github.com/zhang2014)).
* 修复了 S3 URL 解析中的 `std::out_of_range: basic_string`. [#18059](https://github.com/ClickHouse/ClickHouse/pull/18059) ([Vladimir Chebotarev](https://github.com/excitoon)).
* 修复了由于 MaterializeMySQL 不支持转换 MySQL 前缀索引而导致某些表无法从 MySQL 同步到 ClickHouse 的问题. 这修复了 [#15187](https://github.com/ClickHouse/ClickHouse/issues/15187) 并修复了 [#17912](https://github.com/ClickHouse/ClickHouse/issues/17912) [#17944](https://github.com/ClickHouse/ClickHouse/pull/17944) ([Winter Zhang](https://github.com/zhang2014)).
* 修复了查询包含`ARRAY JOIN`时查询优化产生错误结果的问题. [#17887](https://github.com/ClickHouse/ClickHouse/pull/17887) ([sundyli](https://github.com/sundy-li)).
* 修复 `topK` 聚合函数中可能出现的段错误. 这将关闭 [#17404](https://github.com/ClickHouse/ClickHouse/issues/17404). [#17845](https://github.com/ClickHouse/ClickHouse/pull/17845) ([Maksim Kita](https://github.com/kitaisreal)).
* 如果禁用了`in_memory_parts_enable_wal`, 则不要从 WAL 恢复部件. [#17802](https://github.com/ClickHouse/ClickHouse/pull/17802) ([detailyang](https://github.com/detailyang)).
* 修复了 ClickHouse 无法恢复与 MySQL 服务器的连接时的问题. [#17681](https://github.com/ClickHouse/ClickHouse/pull/17681) ([Alexander Kazakov](https://github.com/Akazz)).
* 修复了 `optimize_trivial_count_query` 与分区谓词不一致的行为. [#17644](https://github.com/ClickHouse/ClickHouse/pull/17644) ([Azat Khuzhin](https://github.com/azat)).
* 修复了服务器在守护进程模式下运行时空的 `system.stack_trace` 表. [#17630](https://github.com/ClickHouse/ClickHouse/pull/17630) ([Amos Bird](https://github.com/amosbird)).
* 修复了当 xxception `fmt::v7::format_error` 可以登录到 MergeTree 表的后台时的行为. 这修复了 [#17613](https://github.com/ClickHouse/ClickHouse/issues/17613). [#17615](https://github.com/ClickHouse/ClickHouse/pull/17615) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 修复了 clickhouse-client 在交互模式下使用多行查询和单行注释错误地扩展到查询结束时的行为. 这修复了 [#13654](https://github.com/ClickHouse/ClickHouse/issues/13654). [#17565](https://github.com/ClickHouse/ClickHouse/pull/17565) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 修复了服务器在极少数情况下停止接受连接的问题. [#17542](https://github.com/ClickHouse/ClickHouse/pull/17542) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 修复了在不同副本上杀死相应突变时更改查询挂起的问题. 这修复了 [#16953](https://github.com/ClickHouse/ClickHouse/issues/16953). [#17499](https://github.com/ClickHouse/ClickHouse/pull/17499) ([alesapin](https://github.com/alesapin)).
* 修复了 clickhouse 低估标记缓存大小时的错误. 当有很多带有标记的小文件时可能会发生. [#17496](https://github.com/ClickHouse/ClickHouse/pull/17496) ([alesapin](https://github.com/alesapin)).
* 修复了启用设置 `optimize_redundant_functions_in_order_by` 的 `ORDER BY`. [#17471](https://github.com/ClickHouse/ClickHouse/pull/17471) ([Anton Popov](https://github.com/CurtizJ)).
* 修复了 `DISTINCT` 之后由于不正确优化而可能出现的重复项. 这修复了 [#17294](https://github.com/ClickHouse/ClickHouse/issues/17294). [#17296](https://github.com/ClickHouse/ClickHouse/pull/17296) ([li chengxiang](https://github.com/chengxianglibra)). [#17439](https://github.com/ClickHouse/ClickHouse/pull/17439) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* 修复了从具有 `LowCardinality` 类型的 `JOIN` 表读取时崩溃的问题. 这修复了 [#17228](https://github.com/ClickHouse/ClickHouse/issues/17228). [#17397](https://github.com/ClickHouse/ClickHouse/pull/17397) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* 修复了子查询中有 const 列时设置索引失效的问题. 这修复了 [#17246](https://github.com/ClickHouse/ClickHouse/issues/17246). [#17249](https://github.com/ClickHouse/ClickHouse/pull/17249) ([Amos Bird](https://github.com/amosbird)).
* 修复索引比较类型不同时可能出现的错误索引分析. 这修复了 [#17122](https://github.com/ClickHouse/ClickHouse/issues/17122). [#17145](https://github.com/ClickHouse/ClickHouse/pull/17145) ([Amos Bird](https://github.com/amosbird)).
* 修复了 `ColumnConst` 比较导致崩溃. 这修复了 [#17088](https://github.com/ClickHouse/ClickHouse/issues/17088) . [#17135](https://github.com/ClickHouse/ClickHouse/pull/17135) ([Amos Bird](https://github.com/amosbird)).
* 修复了非领导者 `ReplicatedMergeTreeTables` 的 `ON CLUSTER` 查询可能永远挂起的错误. [#17089](https://github.com/ClickHouse/ClickHouse/pull/17089) ([alesapin](https://github.com/alesapin)).
* 修复了函数 `fuzz Bits` 中模糊器发现的错误. 这修复了 [#16980](https://github.com/ClickHouse/ClickHouse/issues/16980). [#17051](https://github.com/ClickHouse/ClickHouse/pull/17051) ([hexiaoting](https://github.com/hexiaoting)).
* 避免远程查询的不必要的网络错误, 这些错误在执行时可能会被取消, 例如使用 `LIMIT` 的查询. [#17006](https://github.com/ClickHouse/ClickHouse/pull/17006) ([Azat Khuzhin](https://github.com/azat)).
* 修复了从 double 转换时大整数 (128、256 位) 的错误结果. [#16986](https://github.com/ClickHouse/ClickHouse/pull/16986) ([Mike](https://github.com/myrrc)).
* 出现错误时解析 `format_avro_schema_registry_url` 的IP. [#16985](https://github.com/ClickHouse/ClickHouse/pull/16985) ([filimonov](https://github.com/filimonov)).
* 修复了在 `ALTER TABLE ... MODIFY COLUMN ... NewType` 之后, 当 `SELECT` 在更改列上具有 `WHERE` 表达式并且更改尚未完成时可能出现的服务器崩溃. [#16968](https://github.com/ClickHouse/ClickHouse/pull/16968) ([Amos Bird](https://github.com/amosbird)).
* `clickhouse-git-import` 中没有正确计算批判信息. [#16959](https://github.com/ClickHouse/ClickHouse/pull/16959) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 通过单调函数优化来固定顺序. 修复 [#16107](https://github.com/ClickHouse/ClickHouse/issues/16107). [#16956](https://github.com/ClickHouse/ClickHouse/pull/16956) ([Anton Popov](https://github.com/CurtizJ)).
* 修复了启用设置 `optimize_aggregators_of_group_by_keys` 和 joins 的 group by 优化. 这修复了 [#12604](https://github.com/ClickHouse/ClickHouse/issues/12604). [#16951](https://github.com/ClickHouse/ClickHouse/pull/16951) ([Anton Popov](https://github.com/CurtizJ)).
* 安装脚本应始终在 config 文件夹中创建子目录. 这仅与使用自定义配置的 Docker 构建相关. [#16936](https://github.com/ClickHouse/ClickHouse/pull/16936) ([filimonov](https://github.com/filimonov)).
* 修复了使用 `ORDER BY` 的查询可能出现的错误 `Illegal type of argument` . 这修复了 [#16580](https://github.com/ClickHouse/ClickHouse/issues/16580). [#16928](https://github.com/ClickHouse/ClickHouse/pull/16928) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* 如果没有数据写入 WriteBufferFromS3, 则中止分段上传. [#16840](https://github.com/ClickHouse/ClickHouse/pull/16840) ([Pavel Kovalenko](https://github.com/Jokser)).
* 修复了在不带任何参数的情况下使用 `any` 时崩溃的问题. 这修复了 [#16803](https://github.com/ClickHouse/ClickHouse/issues/16803). [#16826](https://github.com/ClickHouse/ClickHouse/pull/16826) ([Amos Bird](https://github.com/amosbird)).
* 修复了 ClickHouse 过去总是返回 0 而不是通过 MySQL 协议进行 `INSERT` 查询的受影响行数时的行为. 这修复了 [#16605](https://github.com/ClickHouse/ClickHouse/issues/16605). [#16715](https://github.com/ClickHouse/ClickHouse/pull/16715) ([Winter Zhang](https://github.com/zhang2014)).
* 修复了 TDigest 不受控制的增长. [#16680](https://github.com/ClickHouse/ClickHouse/pull/16680) ([hrissan](https://github.com/hrissan)).
* 修复了在 Aggregate 函数中使用后缀 `if` 时远程查询失败的问题. 这修复了 [#16574](https://github.com/ClickHouse/ClickHouse/issues/16574) fixes [#16231](https://github.com/ClickHouse/ClickHouse/issues/16231) [#16610](https://github.com/ClickHouse/ClickHouse/pull/16610) ([Winter Zhang](https://github.com/zhang2014)).
* 修复了由 `select_sequential_consistency` 导致优化的琐碎计数查询和 system.tables 的不一致行为. [#16309](https://github.com/ClickHouse/ClickHouse/pull/16309) ([Hao Chen](https://github.com/haoch)).
* 使用 ColumnTransformer 替换不存在的列时抛出错误. [#16183](https://github.com/ClickHouse/ClickHouse/pull/16183) ([hexiaoting](https://github.com/hexiaoting)).


### ClickHouse 版本 v20.11.3.3-stable, 2020-11-13

#### Bug 修复

* 当查询分析器打开并且 ClickHouse 安装在操作系统上时, 修复罕见的无声崩溃, glibc 版本已经 (据说) 损坏了某些功能的异步展开表. 这修复了 [#15301](https://github.com/ClickHouse/ClickHouse/issues/15301). This fixes [#13098](https://github.com/ClickHouse/ClickHouse/issues/13098). [#16846](https://github.com/ClickHouse/ClickHouse/pull/16846) ([alexey-milovidov](https://github.com/alexey-milovidov)).


### ClickHouse 版本 v20.11.2.1, 2020-11-11

#### 向后不兼容变更

* 如果在 `distributed_ddl` 配置部分指定了一些 `profile`, 那么这个配置文件可以在服务器启动时覆盖 `default` 配置文件的设置. 已修复, 现在分布式 DDL 查询的设置不应影响全局服务器设置. [#16635](https://github.com/ClickHouse/ClickHouse/pull/16635) ([tavplubix](https://github.com/tavplubix)).
* 限制在键 (排序键、主键、分区键等) 中使用不可比较的数据类型 (如 `AggregateFunction`). [#16601](https://github.com/ClickHouse/ClickHouse/pull/16601) ([alesapin](https://github.com/alesapin)).
* 删除 `ANALYZE` 和 `AST` 查询，并使设置 `enable_debug_queries` 过时, 因为它现在是全功能 `EXPLAIN` 查询的一部分. [#16536](https://github.com/ClickHouse/ClickHouse/pull/16536) ([Ivan](https://github.com/abyss7)).
* 聚合函数 `boundingRatio`、`rankCorr`、`retention`、`timeSeriesGroupSum`、`timeSeriesGroupRateSum`、`windowFunnel` 被错误地设为不区分大小写. 现在他们的名字按照设计区分大小写.  只有在 SQL 标准中指定的函数或为了与其他 DBMS 兼容而制作的函数或与这些函数类似的函数才应不区分大小写. [#16407](https://github.com/ClickHouse/ClickHouse/pull/16407) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 使 `rankCorr` 函数在数据不足时返回 nan [#16124](https://github.com/ClickHouse/ClickHouse/issues/16124). [#16135](https://github.com/ClickHouse/ClickHouse/pull/16135) ([hexiaoting](https://github.com/hexiaoting)).
* 从20.5以上的版本升级时, 如果进行滚动更新, 集群同时包含20.5以上和20.5以下的版本, 如果旧版本的ClickHouse节点重启, 旧版本在新版本存在的情况下启动, 可能会导致 到 `Part ... intersects previous part` 错误. 为防止出现此错误, 首先在所有集群节点上安装更新的 clickhouse-server 软件包, 然后重新启动 (因此，当 clickhouse-server 重新启动时, 它将以新版本启动).

#### 新特征

* 添加了对 LDAP 作为本地不存在用户的用户目录的支持. [#12736](https://github.com/ClickHouse/ClickHouse/pull/12736) ([Denis Glazachev](https://github.com/traceon)).
* 添加 `system.replicated_fetches` 表, 显示当前正在运行的后台提取. [#16428](https://github.com/ClickHouse/ClickHouse/pull/16428) ([alesapin](https://github.com/alesapin)).
* 添加设置`date_time_output_format`. [#15845](https://github.com/ClickHouse/ClickHouse/pull/15845) ([Maksim Kita](https://github.com/kitaisreal)).
* 为 ClickHouse 添加了最小的 Web UI. [#16158](https://github.com/ClickHouse/ClickHouse/pull/16158) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 允许一次读/写单个 protobuf 消息 (无长度分隔符). [#15199](https://github.com/ClickHouse/ClickHouse/pull/15199) ([filimonov](https://github.com/filimonov)).
* 添加了初始 OpenTelemetry 支持. ClickHouse 现在通过 Native 和 HTTP 协议接受 OpenTelemetry traceparent 标头, 并在某些情况下向下游传递它们. 执行查询的跟踪跨度保存到 `system.opentelemetry_span_log` 表中. [#14195](https://github.com/ClickHouse/ClickHouse/pull/14195) ([Alexander Kuzmenkov](https://github.com/akuzm)).
* 允许在 `CREATE TABLE` 查询的列列表中指定主键. 这是与其他 SQL 方言兼容所必需的. [#15823](https://github.com/ClickHouse/ClickHouse/pull/15823) ([Maksim Kita](https://github.com/kitaisreal)).
* 实现 `OFFSET offset_row_count {ROW | ROWS} FETCH {FIRST | NEXT} fetch_row_count {ROW | ROWS} {ONLY | WITH TIES}` 在带有 ORDER BY 的 SELECT 查询中. 这是指定 `LIMIT` 的SQL标准方式. [#15855](https://github.com/ClickHouse/ClickHouse/pull/15855) ([hexiaoting](https://github.com/hexiaoting)).
* `errorCodeToName` 函数 - 返回错误的变量名称 (用于分析 query_log 和类似的). `system.errors` 表 - 显示错误发生的次数 (包括 `system_events_show_zero_values`). [#16438](https://github.com/ClickHouse/ClickHouse/pull/16438) ([Azat Khuzhin](https://github.com/azat)).
* 添加了函数 `untuple`, 这是一个特殊的函数, 它可以通过扩展命名元组将新列引入到 SELECT 列表中. [#16242](https://github.com/ClickHouse/ClickHouse/pull/16242) ([Nikolai Kochetov](https://github.com/KochetovNicolai), [Amos Bird](https://github.com/amosbird)).
* 现在我们可以通过查询参数提供标识符. 并且这些参数可以用作表对象或列. [#16594](https://github.com/ClickHouse/ClickHouse/pull/16594) ([Amos Bird](https://github.com/amosbird)).
* 为 MergeTree BloomFilter 索引添加了大整数 (UInt256、Int128、Int256)和 UUID 数据类型支持. 大整数是一项实验性功能. [#16642](https://github.com/ClickHouse/ClickHouse/pull/16642) ([Maksim Kita](https://github.com/kitaisreal)).
* 添加 `farmFingerprint64` 函数 (非加密字符串散列). [#16570](https://github.com/ClickHouse/ClickHouse/pull/16570) ([Jacob Hayes](https://github.com/JacobHayes)).
* 添加 `log_queries_min_query_duration_ms`, 只有比这个设置的值慢的查询才会转到 `query_log`/`query_thread_log` (例如mysql中的 `slow_query_log` ). [#16529](https://github.com/ClickHouse/ClickHouse/pull/16529) ([Azat Khuzhin](https://github.com/azat)).
* 能够在 `Alpine` 的顶部创建一个 docker 图像. 使用来自 ubuntu 20.04 的预编译二进制和 glibc 组件. [#16479](https://github.com/ClickHouse/ClickHouse/pull/16479) ([filimonov](https://github.com/filimonov)).
* 添加了 `toUUIDOrNull`、`toUUIDOrZero` 转换函数. [#16337](https://github.com/ClickHouse/ClickHouse/pull/16337) ([Maksim Kita](https://github.com/kitaisreal)).
* 添加 `max_concurrent_queries_for_all_users` 设置, 用例见 [#6636](https://github.com/ClickHouse/ClickHouse/issues/6636). [#16154](https://github.com/ClickHouse/ClickHouse/pull/16154) ([nvartolomei](https://github.com/nvartolomei)).
* 向 clickhouse-client 添加一个新选项 `print_query_id`. 它有助于使用客户端生成的当前查询 ID 生成任意字符串. 默认情况下还会在 clickhouse-client 中打印查询 ID. [#15809](https://github.com/ClickHouse/ClickHouse/pull/15809) ([Amos Bird](https://github.com/amosbird)).
* 添加 `tid` 和 `logTrace` 函数. 这将关闭 [#9434](https://github.com/ClickHouse/ClickHouse/issues/9434). [#15803](https://github.com/ClickHouse/ClickHouse/pull/15803) ([flynn](https://github.com/ucasFL)).
* 添加函数 `formatReadableTimeDelta`, 将时间增量格式化为人类可读的字符串... [#15497](https://github.com/ClickHouse/ClickHouse/pull/15497) ([Filipe Caixeta](https://github.com/filipecaixeta)).
* 在多磁盘配置中为卷添加了 `disable_merges` 选项. [#13956](https://github.com/ClickHouse/ClickHouse/pull/13956) ([Vladimir Chebotarev](https://github.com/excitoon)).

#### 实验功能

* 新函数 `encrypt`、`aes_encrypt_mysql`、`decrypt`、`aes_decrypt_mysql`. 这些功能运行缓慢, 因此我们将其视为实验性功能. [#11844](https://github.com/ClickHouse/ClickHouse/pull/11844) ([Vasily Nemkov](https://github.com/Enmk)).

#### Bug 修复

* 在 `system.distribution_queue` 中的data_path中屏蔽密码. [#16727](https://github.com/ClickHouse/ClickHouse/pull/16727) ([Azat Khuzhin](https://github.com/azat)).
* 在启用了 `transform_null_in` 设置的情况下修复多个列和元组上的 `IN` 运算符. 修复 [#15310](https://github.com/ClickHouse/ClickHouse/issues/15310). [#16722](https://github.com/ClickHouse/ClickHouse/pull/16722) ([Anton Popov](https://github.com/CurtizJ)).
* 如果查询的表没有采样, 设置 `max_parallel_replicas` 将无法正常工作. 这修复了 [#5733](https://github.com/ClickHouse/ClickHouse/issues/5733). [#16675](https://github.com/ClickHouse/ClickHouse/pull/16675) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 使用 max_threads > 0 和 ORDER BY 中的表达式修复 optimize_read_in_order/optimize_aggregation_in_order. [#16637](https://github.com/ClickHouse/ClickHouse/pull/16637) ([Azat Khuzhin](https://github.com/azat)).
* `DEFAULT` 表达式的计算涉及可能的名称冲突 (这是不太可能遇到的). 这修复了 [#9359](https://github.com/ClickHouse/ClickHouse/issues/9359). [#16612](https://github.com/ClickHouse/ClickHouse/pull/16612) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 修复 `query_thread_log.query_duration_ms` 单元. [#16563](https://github.com/ClickHouse/ClickHouse/pull/16563) ([Azat Khuzhin](https://github.com/azat)).
* 修复使用 MySQL Master -> MySQL Slave -> ClickHouse MaterializeMySQL Engine 时的错误. `MaterializeMySQL` 是一个实验性功能. [#16504](https://github.com/ClickHouse/ClickHouse/pull/16504) ([TCeason](https://github.com/TCeason)).
* 带有 `Decimal` 的 `round` 函数的特别设计参数导致整数除以零. 这修复了 [#13338](https://github.com/ClickHouse/ClickHouse/issues/13338). [#16451](https://github.com/ClickHouse/ClickHouse/pull/16451) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 修复分布式的 DROP TABLE (使用 INSERT). [#16409](https://github.com/ClickHouse/ClickHouse/pull/16409) ([Azat Khuzhin](https://github.com/azat)).
* 修复复制队列中非常大的条目的处理. 如果表结构非常大 (接近 1 MB), 则非常大的条目可能会出现在 ALTER 查询中. 这修复了 [#16307](https://github.com/ClickHouse/ClickHouse/issues/16307). [#16332](https://github.com/ClickHouse/ClickHouse/pull/16332) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 修复了由于未创建过滤集而可能删除部分返回数据时的不一致行为. [#16308](https://github.com/ClickHouse/ClickHouse/pull/16308) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* 修复 sharding_key 中的 dictGet (以及类似的地方, 即当函数上下文被永久存储时). [#16205](https://github.com/ClickHouse/ClickHouse/pull/16205) ([Azat Khuzhin](https://github.com/azat)).
* 修复尝试执行 `OPTIMIZE` 命令时在 `clickhouse-local` 中抛出的异常. 修复 [#16076](https://github.com/ClickHouse/ClickHouse/issues/16076). [#16192](https://github.com/ClickHouse/ClickHouse/pull/16192) ([filimonov](https://github.com/filimonov)).
* 修复 [#15780](https://github.com/ClickHouse/ClickHouse/issues/15780) 回归, 例如 `indexOf([1, 2, 3], toLowCardinality(1))` 现在被禁止, 但不应该. [#16038](https://github.com/ClickHouse/ClickHouse/pull/16038) ([Mike](https://github.com/myrrc)).
* 修复 MySQL 数据库的错误. 当用作数据库引擎的 MySQL 服务器关闭时, 某些查询会引发异常, 因为它们试图从禁用的服务器获取表, 而这是不必要的. 例如, 查询 `SELECT ... FROM system.parts` 应该只适用于 MergeTree 表并且根本不要接触 MySQL 数据库. [#16032](https://github.com/ClickHouse/ClickHouse/pull/16032) ([Kruglov Pavel](https://github.com/Avogar)).
* 现在, 当 `ALTER MODIFY COLUMN ... DEFAULT ...` 与列类型的默认值不兼容时, 将抛出异常. 修复 [#15854](https://github.com/ClickHouse/ClickHouse/issues/15854). [#15858](https://github.com/ClickHouse/ClickHouse/pull/15858) ([alesapin](https://github.com/alesapin)).
* 修复了 IPv4CIDRToRange/IPv6CIDRToRange 函数以接受常量 IP 列值. [#15856](https://github.com/ClickHouse/ClickHouse/pull/15856) ([vladimir-golovchenko](https://github.com/vladimir-golovchenko)).

#### 改进

* 将 `INTERVAL '1 hours'` 视为等同于 `INTERVAL 1 HOUR`, 以与 Postgres 和类似的兼容. 这修复了 [#15637](https://github.com/ClickHouse/ClickHouse/issues/15637). [#15978](https://github.com/ClickHouse/ClickHouse/pull/15978) ([flynn](https://github.com/ucasFL)).
* 启用通过 CSV、TSV 和 JSON 输入格式的数字 ID 解析枚举值. [#15685](https://github.com/ClickHouse/ClickHouse/pull/15685) ([vivarum](https://github.com/vivarum)).
* 更好地为 JBOD 架构和 `MergeTree` 存储安排读取任务. 新设置 `read_backoff_min_concurrency` 作为读取线程数的下限. [#16423](https://github.com/ClickHouse/ClickHouse/pull/16423) ([Amos Bird](https://github.com/amosbird)).
* 在 `Avro` 格式中添加对 `LowCardinality` 的缺失支持. [#16521](https://github.com/ClickHouse/ClickHouse/pull/16521) ([Mike](https://github.com/myrrc)).
* 将 `S3` 与 nginx 服务器一起用作代理的解决方法. Nginx 当前不接受像 `http://domain.com?delete` 这样的空路径 url, 但是 vanilla aws-sdk-cpp 会产生这种 url. 此提交使用修补过的 aws-sdk-cpp 版本, 在这种情况下, 它使 url 以"/"作为路径, 例如 `http://domain.com/?delete`. [#16814](https://github.com/ClickHouse/ClickHouse/pull/16814) ([ianton-ru](https://github.com/ianton-ru)).
* 更好地诊断输入数据中的解析错误. 在 `Cannot read all data` 错误上提供行号. [#16644](https://github.com/ClickHouse/ClickHouse/pull/16644) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 使 `mind Map` 和`maxMap` 的行为更加可取. 它不会在结果中跳过零值. 修复 [#16087](https://github.com/ClickHouse/ClickHouse/issues/16087). [#16631](https://github.com/ClickHouse/ClickHouse/pull/16631) ([Ildus Kurbangaliev](https://github.com/ildus)).
* 在运行时更好地更新 ZooKeeper 配置. [#16630](https://github.com/ClickHouse/ClickHouse/pull/16630) ([sundyli](https://github.com/sundy-li)).
* 尽早应用 SETTINGS 子句. 它允许修改查询中的更多设置. 这将关闭 [#3178](https://github.com/ClickHouse/ClickHouse/issues/3178). [#16619](https://github.com/ClickHouse/ClickHouse/pull/16619) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 现在 `event_time_microseconds` 字段存储在 Decimal64 中, 而不是 UInt64. [#16617](https://github.com/ClickHouse/ClickHouse/pull/16617) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* 现在可以在`APPLY`列转换器中使用参数化函数. [#16589](https://github.com/ClickHouse/ClickHouse/pull/16589) ([Amos Bird](https://github.com/amosbird)).
* 改进后台任务的调度, 该任务删除 `Atomic` 数据库中已删除表的数据. 如果表实际上没有数据目录, `Atomic` 数据库不会创建到表数据目录的损坏符号链接. [#16584](https://github.com/ClickHouse/ClickHouse/pull/16584) ([tavplubix](https://github.com/tavplubix)).
* `WITH` 部分 (CTE) 中的子查询可以通过名称引用 `WITH` 部分中先前的子查询. [#16575](https://github.com/ClickHouse/ClickHouse/pull/16575) ([Amos Bird](https://github.com/amosbird)).
* 将 current_database 添加到 `system.query_thread_log`. [#16558](https://github.com/ClickHouse/ClickHouse/pull/16558) ([Azat Khuzhin](https://github.com/azat)).
* 允许将当前实例中已经提交或过时的部分提取到分离目录中. 当从另一个集群迁移表并具有 N 到 1 个分片映射时, 它很有用. 它也与当前的 fetchPartition 实现一致. [#16538](https://github.com/ClickHouse/ClickHouse/pull/16538) ([Amos Bird](https://github.com/amosbird)).
* `RabbitMQ` 的多项改进: 修复了 [#16263](https://github.com/ClickHouse/ClickHouse/issues/16263) 的错误. 还最小化了事件循环生命周期. 添加了更高效的队列设置. [#16426](https://github.com/ClickHouse/ClickHouse/pull/16426) ([Kseniia Sumarokova](https://github.com/kssenii)).
* 修复 `quantileDeterministic` 函数中的调试断言. 在以前的版本中, 它还可以通过网络传输多达两倍的数据. 虽然不存在错误. 这修复了 [#15683](https://github.com/ClickHouse/ClickHouse/issues/15683). [#16410](https://github.com/ClickHouse/ClickHouse/pull/16410) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 添加 `TablesToDropQueueSize` 指标. 它等于正在等待后台数据删除的已删除表的数量. [#16364](https://github.com/ClickHouse/ClickHouse/pull/16364) ([tavplubix](https://github.com/tavplubix)).
* 当客户端断开连接时更好的诊断. 在以前的版本中, 服务器中记录了 `Attempt to read after EOF` 和 `Broken pipe` 异常. 在新版本中, 它的信息消息 `Client has dropped the connection, cancel the query.`. [#16329](https://github.com/ClickHouse/ClickHouse/pull/16329) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 为 Set/Join 表引擎添加 total_rows/total_bytes (来自 system.tables) 支持. [#16306](https://github.com/ClickHouse/ClickHouse/pull/16306) ([Azat Khuzhin](https://github.com/azat)).
* 现在可以为 MergeTree 表引擎系列指定没有 `ORDER BY` 的 `PRIMARY KEY`. 关闭 [#15591](https://github.com/ClickHouse/ClickHouse/issues/15591). [#16284](https://github.com/ClickHouse/ClickHouse/pull/16284) ([alesapin](https://github.com/alesapin)).
* 如果系统中没有 tmp 文件夹 (chroot、错误配置等) `clickhouse-local` 将在当前目录中创建临时子文件夹. [#16280](https://github.com/ClickHouse/ClickHouse/pull/16280) ([filimonov](https://github.com/filimonov)).
* 添加对嵌套数据类型 (如命名元组) 作为子类型的支持. 修复 [#15587](https://github.com/ClickHouse/ClickHouse/issues/15587). [#16262](https://github.com/ClickHouse/ClickHouse/pull/16262) ([Ivan](https://github.com/abyss7)).
* 支持`database_atomic_wait_for_drop_and_detach_synchronously`/`NO DELAY`/`SYNC` for `DROP DATABASE`. [#16127](https://github.com/ClickHouse/ClickHouse/pull/16127) ([Azat Khuzhin](https://github.com/azat)).
* 添加 `allow_nondeterministic_optimize_skip_unused_shards` (允许在分片键中使用非确定性，如 `rand()` 或 `dictGet()`). [#16105](https://github.com/ClickHouse/ClickHouse/pull/16105) ([Azat Khuzhin](https://github.com/azat)).
* 修复 `memory_profiler_step`/`max_untracked_memory` 以通过 HTTP 进行查询 (包括测试). 修复在 xml 配置中全局调整此值也无济于事的问题, 因为这些设置无论如何都不会应用, 只有默认 (4MB) 值是 [used](https://github.com/ClickHouse/ClickHouse/blob/17731245336d8c84f75e4c0894c5797ed7732190 /src/Common/ThreadStatus.h#L104). 修复 http 查询最根 ThreadStatus 的 `query_id` (通过在读取 query_id 后初始化 QueryScope). [#16101](https://github.com/ClickHouse/ClickHouse/pull/16101) ([Azat Khuzhin](https://github.com/azat)).
* 现在, 无论集群配置中的 `<internal_replication>` 设置如何，都可以执行 `ALTER ... ON CLUSTER` 查询. [#16075](https://github.com/ClickHouse/ClickHouse/pull/16075) ([alesapin](https://github.com/alesapin)).
* 修复了 `clickhouse-client` 可能因加载建议而在退出时中止的罕见问题. 这修复了 [#16035](https://github.com/ClickHouse/ClickHouse/issues/16035). [#16047](https://github.com/ClickHouse/ClickHouse/pull/16047) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 为具有复杂键的 `Redis` 字典添加 `cache` 布局支持. [#15985](https://github.com/ClickHouse/ClickHouse/pull/15985) ([Anton Popov](https://github.com/CurtizJ)).
* 在配置错误的情况下修复查询挂起 (无限循环) (`connections_with_failover_max_tries` 设置为 0). [#15876](https://github.com/ClickHouse/ClickHouse/pull/15876) ([Azat Khuzhin](https://github.com/azat)).
* 将某些日志消息的级别从信息更改为调试, 因此不会为每个查询显示信息消息. 这将关闭 [#5293](https://github.com/ClickHouse/ClickHouse/issues/5293). [#15816](https://github.com/ClickHouse/ClickHouse/pull/15816) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 删除 `MemoryTrackingInBackground*` 指标以避免潜在的误导性结果. 这修复了 [#15684](https://github.com/ClickHouse/ClickHouse/issues/15684). [#15813](https://github.com/ClickHouse/ClickHouse/pull/15813) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 添加重新连接到 `zookeeper-dump-tree` 工具. [#15711](https://github.com/ClickHouse/ClickHouse/pull/15711) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 允许在 `CREATE TABLE table AS table_function(...)` 查询中明确指定列列表. 修复 [#9249](https://github.com/ClickHouse/ClickHouse/issues/9249) 修复 [#14214](https://github.com/ClickHouse/ClickHouse/issues/14214). [#14295](https://github.com/ClickHouse/ClickHouse/pull/14295) ([tavplubix](https://github.com/tavplubix)).

#### 性能改进

* 不要在 SELECT FINAL 中跨分区合并部分. [#15938](https://github.com/ClickHouse/ClickHouse/pull/15938) ([Kruglov Pavel](https://github.com/Avogar)).
* 提高 `-OrNull` 和 `-OrDefault` 聚合函数的性能. [#16661](https://github.com/ClickHouse/ClickHouse/pull/16661) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 提高 `quantileMerge` 的性能. 在以前的版本中, 它非常慢. 这将关闭 [#1463](https://github.com/ClickHouse/ClickHouse/issues/1463). [#16643](https://github.com/ClickHouse/ClickHouse/pull/16643) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 稍微提高逻辑函数的性能. [#16347](https://github.com/ClickHouse/ClickHouse/pull/16347) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 改进了 MergeTree 表引擎中合并分配的性能. 不应该对用户可见. [#16191](https://github.com/ClickHouse/ClickHouse/pull/16191) ([alesapin](https://github.com/alesapin)).
* 通过预分配哈希表加速哈希/sparse_hashed 字典加载. [#15454](https://github.com/ClickHouse/ClickHouse/pull/15454) ([Azat Khuzhin](https://github.com/azat)).
* 现在, 琐碎的计数优化变得有点不琐碎了.包含精确分区expr的谓词也可以被优化. 这也修复了[#11092](https://github.com/ClickHouse/ClickHouse/issues/11092)当 `max_parallel_replicas > 1` 时返回错误计数的问题. [#15074](https://github.com/ClickHouse/ClickHouse/pull/15074) ([Amos Bird](https://github.com/amosbird)).

#### 构建/测试/打包改进

* 为无状态测试添加薄片检查. 在功能测试被合并之前, 它将提前检测出可能不可靠的功能测试. [#16238](https://github.com/ClickHouse/ClickHouse/pull/16238) ([alesapin](https://github.com/alesapin)).
* 使用适当的版本进行 `croaring` 而不是合并. [#16285](https://github.com/ClickHouse/ClickHouse/pull/16285) ([sundyli](https://github.com/sundy-li)).
* 改进为 `ya.make` 构建系统生成构建文件 (Arcadia). [#16700](https://github.com/ClickHouse/ClickHouse/pull/16700) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 为 `MaterializeMySQL` 数据库引擎添加MySQL BinLog文件检查工具. `MaterializeMySQL` 是一个实验性功能. [#16223](https://github.com/ClickHouse/ClickHouse/pull/16223) ([Winter Zhang](https://github.com/zhang2014)).
* 检查非可执行文件上的可执行位. 人们经常不小心从 Windows 提交可执行文件. [#15843](https://github.com/ClickHouse/ClickHouse/pull/15843) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 检查标题中的 `#pragma once` . [#15818](https://github.com/ClickHouse/ClickHouse/pull/15818) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 修复 libhdfs3 中非法代码样式 `&vector[idx]`. 这修复了 libcxx 调试版本。 另见 https://github.com/ClickHouse-Extras/libhdfs3/pull/8 . [#15815](https://github.com/ClickHouse/ClickHouse/pull/15815) ([Amos Bird](https://github.com/amosbird)).
* 在 Mac OS 上修复一个杂项示例工具的构建. 请注意, 我们不在我们的 CI 中在 Mac OS 上构建示例 (我们仅构建 ClickHouse 二进制文件), 因此它不会再次中断的可能性为零. 这修复了 [#15804](https://github.com/ClickHouse/ClickHouse/issues/15804). [#15808](https://github.com/ClickHouse/ClickHouse/pull/15808) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 简化 Sys/V 初始化脚本. [#14135](https://github.com/ClickHouse/ClickHouse/pull/14135) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 将 `boost::program_options` 添加到 `db_generator` 以提高其可用性. 这将关闭 [#15940](https://github.com/ClickHouse/ClickHouse/issues/15940). [#15973](https://github.com/ClickHouse/ClickHouse/pull/15973) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).


## ClickHouse 版本 20.10

### ClickHouse 版本 v20.10.7.4-stable, 2020-12-24

#### Bug 修复

* 修复了 `clickhouse-odbc-bridge` 进程无法被具有双 `IPv4/IPv6` 堆栈的机器上的服务器访问的问题, 并修复了使用格式错误的查询执行 ODBC 字典更新和/或导致崩溃时的问题. 这可能会关闭 [#14489](https://github.com/ClickHouse/ClickHouse/issues/14489). [#18278](https://github.com/ClickHouse/ClickHouse/pull/18278) ([Denis Glazachev](https://github.com/traceon)).
* 修复 Enum 和 Int 类型之间的键比较. 这修复了 [#17989](https://github.com/ClickHouse/ClickHouse/issues/17989). [#18214](https://github.com/ClickHouse/ClickHouse/pull/18214) ([Amos Bird](https://github.com/amosbird)).
* 修复了 `MaterializeMySQL` 数据库引擎中唯一键转换崩溃的问题. 这修复了 [#18186](https://github.com/ClickHouse/ClickHouse/issues/18186) 并修复了 [#16372](https://github.com/ClickHouse/ClickHouse/issues/16372) [#18211](https://github.com/ClickHouse/ClickHouse/pull/18211) ([Winter Zhang](https://github.com/zhang2014)).
* 修复了 S3 URL 解析中的 `std::out_of_range: basic_string`. [#18059](https://github.com/ClickHouse/ClickHouse/pull/18059) ([Vladimir Chebotarev](https://github.com/excitoon)).
* 修复了由于 MaterializeMySQL 不支持转换 MySQL 前缀索引而导致某些表无法从 MySQL 同步到 ClickHouse 的问题. 这修复了 [#15187](https://github.com/ClickHouse/ClickHouse/issues/15187) 并修复了 [#17912](https://github.com/ClickHouse/ClickHouse/issues/17912) [#17944](https://github.com/ClickHouse/ClickHouse/pull/17944) ([Winter Zhang](https://github.com/zhang2014)).
* 修复 `topK` 聚合函数中可能出现的段错误. 这将关闭 [#17404](https://github.com/ClickHouse/ClickHouse/issues/17404). [#17845](https://github.com/ClickHouse/ClickHouse/pull/17845) ([Maksim Kita](https://github.com/kitaisreal)).
* 如果禁用了`in_memory_parts_enable_wal`, 则不要从 `WAL` 恢复部件. [#17802](https://github.com/ClickHouse/ClickHouse/pull/17802) ([detailyang](https://github.com/detailyang)).
* 修复了 ClickHouse 无法恢复与 MySQL 服务器的连接时的问题. [#17681](https://github.com/ClickHouse/ClickHouse/pull/17681) ([Alexander Kazakov](https://github.com/Akazz)).
* 修复了服务器在守护进程模式下运行时空的 `system.stack_trace` 表. [#17630](https://github.com/ClickHouse/ClickHouse/pull/17630) ([Amos Bird](https://github.com/amosbird)).
* 修复了在多行查询的交互模式下使用 `clickhouse-client` 时的行为, 并且单行注释被错误地扩展到查询结束. 这修复了 [#13654](https://github.com/ClickHouse/ClickHouse/issues/13654). [#17565](https://github.com/ClickHouse/ClickHouse/pull/17565) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 修复了服务器在极少数情况下停止接受连接的问题. [#17542](https://github.com/ClickHouse/ClickHouse/pull/17542) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 修复了在不同副本上杀死相应突变时的 `ALTER` 查询挂起. 这修复了 [#16953](https://github.com/ClickHouse/ClickHouse/issues/16953). [#17499](https://github.com/ClickHouse/ClickHouse/pull/17499) ([alesapin](https://github.com/alesapin)).
* 修复了 clickhouse 低估标记缓存大小时的错误. 当有很多带有标记的小文件时可能会发生. [#17496](https://github.com/ClickHouse/ClickHouse/pull/17496) ([alesapin](https://github.com/alesapin)).
* 修复了启用设置 `optimize_redundant_functions_in_order_by` 的 `ORDER BY` . [#17471](https://github.com/ClickHouse/ClickHouse/pull/17471) ([Anton Popov](https://github.com/CurtizJ)).
* 修复了 `DISTINCT` 之后由于不正确优化而可能出现的重复项. 修复 [#17294](https://github.com/ClickHouse/ClickHouse/issues/17294). [#17296](https://github.com/ClickHouse/ClickHouse/pull/17296) ([li chengxiang](https://github.com/chengxianglibra)). [#17439](https://github.com/ClickHouse/ClickHouse/pull/17439) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* 修复了从具有 `LowCardinality` 类型的 `JOIN` 表读取时崩溃的问题. 这修复了 [#17228](https://github.com/ClickHouse/ClickHouse/issues/17228). [#17397](https://github.com/ClickHouse/ClickHouse/pull/17397) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* 修复了子查询中存在 const 列时设置索引失效的问题. 这修复了 [#17246](https://github.com/ClickHouse/ClickHouse/issues/17246). [#17249](https://github.com/ClickHouse/ClickHouse/pull/17249) ([Amos Bird](https://github.com/amosbird)).
* 修复了导致崩溃的 `ColumnConst` 比较. 这个修复了 [#17088](https://github.com/ClickHouse/ClickHouse/issues/17088). [#17135](https://github.com/ClickHouse/ClickHouse/pull/17135) ([Amos Bird](https://github.com/amosbird)).
* 修复了非领导者 `ReplicatedMergeTreeTables` 的 `ON CLUSTER` 查询可能永远挂起的错误. [#17089](https://github.com/ClickHouse/ClickHouse/pull/17089) ([alesapin](https://github.com/alesapin)).
* 修复了函数 `fuzzBits` 中的模糊器发现错误. 这修复了. [#17051](https://github.com/ClickHouse/ClickHouse/pull/17051) ([hexiaoting](https://github.com/hexiaoting)).
* 避免远程查询的不必要的网络错误, 这些错误在执行时可能会被取消, 例如使用 `LIMIT` 的查询. [#17006](https://github.com/ClickHouse/ClickHouse/pull/17006) ([Azat Khuzhin](https://github.com/azat)).
* 修复了从 double 转换时大整数 (128、256 位) 的错误结果. [#16986](https://github.com/ClickHouse/ClickHouse/pull/16986) ([Mike](https://github.com/myrrc)).
* 出现错误时解析 `format_avro_schema_registry_url` 的IP. [#16985](https://github.com/ClickHouse/ClickHouse/pull/16985) ([filimonov](https://github.com/filimonov)).
* 修复了在 `ALTER TABLE ... MODIFY COLUMN ... NewType` 之后, 当“SELECT”在更改列上具有 `WHERE` 表达式并且更改尚未完成时可能出现的服务器崩溃. [#16968](https://github.com/ClickHouse/ClickHouse/pull/16968) ([Amos Bird](https://github.com/amosbird)).
* `clickhouse-git-import` 中没有正确计算批判信息. [#16959](https://github.com/ClickHouse/ClickHouse/pull/16959) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 通过单调函数优化来固定顺序. 这修复了 [#16107](https://github.com/ClickHouse/ClickHouse/issues/16107). [#16956](https://github.com/ClickHouse/ClickHouse/pull/16956) ([Anton Popov](https://github.com/CurtizJ)).
* Fixrf 通过启用设置 `optimize_aggregators_of_group_by_keys` 和连接来优化组. 这修复了 [#12604](https://github.com/ClickHouse/ClickHouse/issues/12604). [#16951](https://github.com/ClickHouse/ClickHouse/pull/16951) ([Anton Popov](https://github.com/CurtizJ)).
* 安装脚本应始终在 config 文件夹中创建子目录. 这仅与使用自定义配置的 Docker 构建相关. [#16936](https://github.com/ClickHouse/ClickHouse/pull/16936) ([filimonov](https://github.com/filimonov)).
* 使用 `ORDER BY` 的查询修复可能的错误 `Illegal type of argument` . 这修复了 [#16580](https://github.com/ClickHouse/ClickHouse/issues/16580). [#16928](https://github.com/ClickHouse/ClickHouse/pull/16928) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* 如果没有数据写入`WriteBufferFromS3`, 则中止分段上传. [#16840](https://github.com/ClickHouse/ClickHouse/pull/16840) ([Pavel Kovalenko](https://github.com/Jokser)).
* 修复了在不带任何参数的情况下使用 `any` 时的崩溃问题. 这修复了 [#16803](https://github.com/ClickHouse/ClickHouse/issues/16803). [#16826](https://github.com/ClickHouse/ClickHouse/pull/16826) ([Amos Bird](https://github.com/amosbird)).
* 修复了 ClickHouse 过去总是通过 MySQL 协议为 `INSERT` 查询返回许多受影响行的 0 插入的行为. 这修复了 [#16605](https://github.com/ClickHouse/ClickHouse/issues/16605). [#16715](https://github.com/ClickHouse/ClickHouse/pull/16715) ([Winter Zhang](https://github.com/zhang2014)).
* 修复了 `TDigest` 不受控制的增长. [#16680](https://github.com/ClickHouse/ClickHouse/pull/16680) ([hrissan](https://github.com/hrissan)).
* 修复了在 Aggregate 函数中使用后缀 `if` 时远程查询失败的问题. 这修复了 [#16574](https://github.com/ClickHouse/ClickHouse/issues/16574) fixes [#16231](https://github.com/ClickHouse/ClickHouse/issues/16231) [#16610](https://github.com/ClickHouse/ClickHouse/pull/16610) ([Winter Zhang](https://github.com/zhang2014)).


### ClickHouse 版本 v20.10.4.1-stable, 2020-11-13

#### Bug 修复

* 当查询分析器打开并且 ClickHouse 安装在操作系统上时, 修复罕见的无声崩溃, glibc 版本已经 (据说) 损坏了某些功能的异步展开表. 这修复了 [#15301](https://github.com/ClickHouse/ClickHouse/issues/15301)。 这修复了 [#13098](https://github.com/ClickHouse/ClickHouse/issues/13098). [#16846](https://github.com/ClickHouse/ClickHouse/pull/16846) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 在启用了 `transform_null_in` 设置的情况下修复多个列和元组上的 `IN` 运算符. 修复 [#15310](https://github.com/ClickHouse/ClickHouse/issues/15310). [#16722](https://github.com/ClickHouse/ClickHouse/pull/16722) ([Anton Popov](https://github.com/CurtizJ)).
* 这将修复 optimize_read_in_order/optimize_aggregation_in_order 与 max_threads>0 和 ORDER BY 中的表达式. [#16637](https://github.com/ClickHouse/ClickHouse/pull/16637) ([Azat Khuzhin](https://github.com/azat)).
* 现在, 当从输入解析 AVRO 时, LowCardinality 从类型中删除. 修复 [#16188](https://github.com/ClickHouse/ClickHouse/issues/16188). [#16521](https://github.com/ClickHouse/ClickHouse/pull/16521) ([Mike](https://github.com/myrrc)).
* 通过适当缩小 GTID 集, 修复使用 MySQL Master -> MySQL Slave -> ClickHouse MaterializeMySQL Engine 和 MySQL Slave 上启用的 `slave_parallel_worker` 时元数据的快速增长. 这修复了 [#15951](https://github.com/ClickHouse/ClickHouse/issues/15951). [#16504](https://github.com/ClickHouse/ClickHouse/pull/16504) ([TCeason](https://github.com/TCeason)).
* 修复分布式的 DROP TABLE (使用 INSERT). [#16409](https://github.com/ClickHouse/ClickHouse/pull/16409) ([Azat Khuzhin](https://github.com/azat)).
* 修复复制队列中非常大的条目的处理. 如果表结构非常大 (接近 1 MB), 则非常大的条目可能会出现在 ALTER 查询中. 这修复了 [#16307](https://github.com/ClickHouse/ClickHouse/issues/16307). [#16332](https://github.com/ClickHouse/ClickHouse/pull/16332) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 修复 MySQL 数据库的错误. 当用作数据库引擎的 MySQL 服务器关闭时, 某些查询会引发异常, 因为它们试图从禁用的服务器获取表, 而这是不必要的. 例如, 查询 `SELECT ... FROM system.parts` 应该只适用于 MergeTree 表并且根本不要接触 MySQL 数据库. [#16032](https://github.com/ClickHouse/ClickHouse/pull/16032) ([Kruglov Pavel](https://github.com/Avogar)).

#### 改进

* 将 S3 与 nginx 服务器一起用作代理的解决方法。 Nginx 当前不接受像 http://domain.com?delete 这样的空路径 url，但是 vanilla aws-sdk-cpp 会生成这种 url。 此提交使用修补过的 aws-sdk-cpp 版本，在这种情况下，它使 url 以“/”作为路径，例如 http://domain.com/?delete. [#16813](https://github.com/ClickHouse/ClickHouse/pull/16813) ([ianton-ru](https://github.com/ianton-ru)).


### ClickHouse 版本 v20.10.3.30, 2020-10-28

#### 向后不兼容变更

* 使 `multiple_joins_rewriter_version` 过时. 删除连接重写器的第一个版本. [#15472](https://github.com/ClickHouse/ClickHouse/pull/15472) ([Artem Zuikov](https://github.com/4ertus2)).
* 将 `format_regexp_escaping_rule` 设置的默认值 (它与 `Regexp` 格式相关) 更改为 `Raw` (这意味着 - 将整个子模式作为一个值读取), 使行为更符合用户的期望. [#15426](https://github.com/ClickHouse/ClickHouse/pull/15426) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 在 SQL 中添加对嵌套多行注释 `/* 注释 /* 注释 */ */` 的支持. 这符合SQL标准. [#14655](https://github.com/ClickHouse/ClickHouse/pull/14655) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 添加了 MergeTree 设置 (`max_replicated_merges_with_ttl_in_queue` 和 `max_number_of_merges_with_ttl_in_pool`) 来控制后台池和复制队列中与 TTL 合并的数量. 仅当您使用删除 TTL 时, 此更改才会破坏与旧版本的兼容性. 否则, 复制将保持兼容. 如果您一次更新所有分片副本或执行 `SYSTEM STOP TTL MERGES` 直到完成所有副本的更新, 您可以避免不兼容问题. 如果你在复制队列中得到一个不兼容的条目, 首先, 执行 `SYSTEM STOP TTL MERGES` , 然后在 `ALTER TABLE ... DETACH PARTITION ...` 分配不兼容的TTL合并的分区. 将其重新连接到单个副本上. [#14490](https://github.com/ClickHouse/ClickHouse/pull/14490) ([alesapin](https://github.com/alesapin)).
* 从20.5以上的版本升级时, 如果进行滚动更新, 集群同时包含20.5以上和20.5以下的版本, 如果旧版本的ClickHouse节点重启, 旧版本在新版本存在的情况下启动, 可能会导致 `Part ... intersects previous part` 错误. 为防止出现此错误, 首先在所有集群节点上安装更新的 clickhouse-server 软件包, 然后重新启动 (因此, 当 clickhouse-server 重新启动时, 它将以新版本启动).

#### 新特征

* 后台数据再压缩. 添加为 MergeTree 表引擎系列指定 `TTL ... RECOMPRESS codec_name` 的能力. [#14494](https://github.com/ClickHouse/ClickHouse/pull/14494) ([alesapin](https://github.com/alesapin)).
* 添加并行仲裁插入. 这将关闭 [#15601](https://github.com/ClickHouse/ClickHouse/issues/15601). [#15601](https://github.com/ClickHouse/ClickHouse/pull/15601) ([Latysheva Alexandra](https://github.com/alexelex)).
* 用于额外强制执行数据持久性的设置. 对非复制设置有用. [#11948](https://github.com/ClickHouse/ClickHouse/pull/11948) ([Anton Popov](https://github.com/CurtizJ)).
* 当复制块写入本地不存在的副本时 (尚未从副本中提取), 不要忽略它并在本地写入, 以达到与复制成功相同的效果. [#11684](https://github.com/ClickHouse/ClickHouse/pull/11684) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 现在我们支持 `WITH <identifier> AS (subquery) ... ` 在查询上下文中引入命名子查询. 这将关闭 [#2416](https://github.com/ClickHouse/ClickHouse/issues/2416). 这将关闭 [#4967](https://github.com/ClickHouse/ClickHouse/issues/4967). [#14771](https://github.com/ClickHouse/ClickHouse/pull/14771) ([Amos Bird](https://github.com/amosbird)).
* 引入 `enable_global_with_statement` 设置, 它将第一个 select 的 `WITH` 语句传播到同一级别的其他选择查询, 并使 `WITH` 语句中的别名对子查询可见. [#15451](https://github.com/ClickHouse/ClickHouse/pull/15451) ([Amos Bird](https://github.com/amosbird)).
* 安全的集群间查询执行 (initial_user 作为当前查询用户). [#13156](https://github.com/ClickHouse/ClickHouse/pull/13156) ([Azat Khuzhin](https://github.com/azat)). [#15551](https://github.com/ClickHouse/ClickHouse/pull/15551) ([Azat Khuzhin](https://github.com/azat)).
* 添加删除列属性和表 TTL 的功能. 引入了查询 `ALTER TABLE MODIFY COLUMN col_name REMOVE what_to_remove`和`ALTER TABLE REMOVE TTL`. 这两个操作都是轻量级的, 并且在元数据级别执行. [#14742](https://github.com/ClickHouse/ClickHouse/pull/14742) ([alesapin](https://github.com/alesapin)).
* 添加格式 `RawBLOB` . 它用于输入或输出没有任何转义和分隔符的单个值. 这将关闭 [#15349](https://github.com/ClickHouse/ClickHouse/issues/15349). [#15364](https://github.com/ClickHouse/ClickHouse/pull/15364) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 添加 `reinterpretAsUUID` 函数, 允许将大端字节字符串转换为 UUID. [#15480](https://github.com/ClickHouse/ClickHouse/pull/15480) ([Alexander Kuzmenkov](https://github.com/akuzm)).
* 实现 `force_data_skiping_indices` 设置. [#15642](https://github.com/ClickHouse/ClickHouse/pull/15642) ([Azat Khuzhin](https://github.com/azat)).
* 添加一个设置 `output_format_pretty_row_numbers` 以计算出漂亮格式的结果. 这将关闭 [#15350](https://github.com/ClickHouse/ClickHouse/issues/15350). [#15443](https://github.com/ClickHouse/ClickHouse/pull/15443) ([flynn](https://github.com/ucasFL)).
* 添加了查询混淆工具. 它允许共享更多查询以进行更好的测试. 这将关闭 [#15268](https://github.com/ClickHouse/ClickHouse/issues/15268). [#15321](https://github.com/ClickHouse/ClickHouse/pull/15321) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 添加表函数 `null('structure')` . [#14797](https://github.com/ClickHouse/ClickHouse/pull/14797) ([vxider](https://github.com/Vxider)).
* 添加了 `formatReadableQuantity` 函数. 它对于人类读取大数字很有用. [#14725](https://github.com/ClickHouse/ClickHouse/pull/14725) ([Artem Hnilov](https://github.com/BooBSD)).
* 添加格式 `LineAsString` 接受由换行符分隔的一系列行, 每一行都作为一个整体解析为单个 String 字段. [#14703](https://github.com/ClickHouse/ClickHouse/pull/14703) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)), [#13846](https://github.com/ClickHouse/ClickHouse/pull/13846) ([hexiaoting](https://github.com/hexiaoting)).
* 添加以字符串数组形式输出数据的 `JSONStrings` 格式. [#14333](https://github.com/ClickHouse/ClickHouse/pull/14333) ([hcz](https://github.com/hczhcz)).
* 为`Regexp` 格式添加对 `Raw` 列格式的支持。 它允许简单地将子模式作为一个整体提取，而无需任何转义规则. [#15363](https://github.com/ClickHouse/ClickHouse/pull/15363) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 允许 `TSV` 输出格式的可配置 `NULL` 表示. 它由设置 `output_format_tsv_null_representation` 控制, 默认情况下为 `\N`. 这将关闭 [#9375](https://github.com/ClickHouse/ClickHouse/issues/9375). 请注意, 该设置仅控制输出格式, 并且 `\N` 是 `TSV` 输入格式唯一支持的 `NULL` 表示. [#14586](https://github.com/ClickHouse/ClickHouse/pull/14586) ([Kruglov Pavel](https://github.com/Avogar)).
* 支持 `MaterializeMySQL` 的十进制数据类型。 `MaterializeMySQL` 是一个实验性功能. [#14535](https://github.com/ClickHouse/ClickHouse/pull/14535) ([Winter Zhang](https://github.com/zhang2014)).
* 添加新功能: `SHOW DATABASES LIKE 'xxx'`. [#14521](https://github.com/ClickHouse/ClickHouse/pull/14521) ([hexiaoting](https://github.com/hexiaoting)).
* 添加了将 (任意) git 存储库作为示例数据集导入到 ClickHouse 的脚本. [#14471](https://github.com/ClickHouse/ClickHouse/pull/14471) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 现在插入语句可以在列列表中带有带有列转换器的星号 (或变体). [#14453](https://github.com/ClickHouse/ClickHouse/pull/14453) ([Amos Bird](https://github.com/amosbird)).
* 用于分布式查询的新查询复杂度限制设置 `max_rows_to_read_leaf`、`max_bytes_to_read_leaf`, 以限制在叶节点上读取的最大行数/字节数. 限制仅适用于本地读取, *排除*根节点上的最终合并阶段. [#14221](https://github.com/ClickHouse/ClickHouse/pull/14221) ([Roman Khavronenko](https://github.com/hagen1778)).
* 允许用户在配置文件的 `<replicated_merge_tree>` 部分为 `ReplicatedMergeTree*` 存储指定设置. 它的工作原理类似于 `<merge_tree>` 部分. 对于 `ReplicatedMergeTree*` 存储, `<merge_tree>` 和 `<replicated_merge_tree>` 中的设置被一起应用, 但来自 `<replicated_merge_tree>` 的设置具有更高的优先级. 添加了`system.replicated_merge_tree_settings`表. [#13573](https://github.com/ClickHouse/ClickHouse/pull/13573) ([Amos Bird](https://github.com/amosbird)).
* 添加 `mapPopulateSeries` 函数. [#13166](https://github.com/ClickHouse/ClickHouse/pull/13166) ([Ildus Kurbangaliev](https://github.com/ildus)).
* 支持 MySQL 类型：`decimal` (作为 ClickHouse`Decimal`) 和具有亚秒级精度的 `datetime` (作为 `DateTime64`). [#11512](https://github.com/ClickHouse/ClickHouse/pull/11512) ([Vasily Nemkov](https://github.com/Enmk)).
* 将 `event_time_microseconds` 字段引入 `system.text_log`、`system.trace_log`、`system.query_log` 和 `system.query_thread_log` 表. [#14760](https://github.com/ClickHouse/ClickHouse/pull/14760) ([Bharat Nallan](https://github.com/bharatnc)).
* 将 `event_time_microseconds` 添加到 `system.asynchronous_metric_log` 和 `system.metric_log` 表. [#14514](https://github.com/ClickHouse/ClickHouse/pull/14514) ([Bharat Nallan](https://github.com/bharatnc)).
* 将 `query_start_time_microseconds` 字段添加到 `system.query_log` 和 `system.query_thread_log` 表. [#14252](https://github.com/ClickHouse/ClickHouse/pull/14252) ([Bharat Nallan](https://github.com/bharatnc)).

#### Bug 修复

* 修复无论限制如何都可以过度分配内存的情况. 这将关闭 [#14560](https://github.com/ClickHouse/ClickHouse/issues/14560). [#16206](https://github.com/ClickHouse/ClickHouse/pull/16206) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 修复 `executable` 字典源挂起. 在以前的版本中, 当使用某些格式 (例如`JSONEachRow`) 时, 数据在至少输出一些东西之前不会提供给子进程. 这将关闭 [#1697](https://github.com/ClickHouse/ClickHouse/issues/1697). 这将关闭 [#2455](https://github.com/ClickHouse/ClickHouse/issues/2455). [#14525](https://github.com/ClickHouse/ClickHouse/pull/14525) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 在函数 `dictGet` 出现异常时修复double free. 如果字典加载错误, 可能会发生这种情况. [#16429](https://github.com/ClickHouse/ClickHouse/pull/16429) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* 使用总数/汇总/多维数据集修饰符和最小/最大功能按键修复分组. 修复 [#16393](https://github.com/ClickHouse/ClickHouse/issues/16393). [#16397](https://github.com/ClickHouse/ClickHouse/pull/16397) ([Anton Popov](https://github.com/CurtizJ)).
* 使用 `prefer_localhost_replica=0` 和 `internal_replication` 修复异步分布式插入. [#16358](https://github.com/ClickHouse/ClickHouse/pull/16358) ([Azat Khuzhin](https://github.com/azat)).
* 修复 TwoLevelStringHashTable 实现中一个很错误的代码，可能导致内存泄漏. [#16264](https://github.com/ClickHouse/ClickHouse/pull/16264) ([Amos Bird](https://github.com/amosbird)).
* 修复了在lambda中某些错误聚合情况下的段错误. [#16082](https://github.com/ClickHouse/ClickHouse/pull/16082) ([Anton Popov](https://github.com/CurtizJ)).
* 修复 `ReplicatedVersionedCollapsingMergeTree` 的 `ALTER MODIFY ... ORDER BY` 查询挂起。 这修复了 [#15980](https://github.com/ClickHouse/ClickHouse/issues/15980). [#16011](https://github.com/ClickHouse/ClickHouse/pull/16011) ([alesapin](https://github.com/alesapin)).
* `MaterializeMySQL` (实验功能): 修复整理名称和字符集名称解析器并支持字符串类型的 `length = 0`. [#16008](https://github.com/ClickHouse/ClickHouse/pull/16008) ([Winter Zhang](https://github.com/zhang2014)).
* 允许对具有复杂键的字典使用 `direct` 布局. [#16007](https://github.com/ClickHouse/ClickHouse/pull/16007) ([Anton Popov](https://github.com/CurtizJ)).
* 在一段时间不活动后发生复制错误时，防止副本挂起 5-10 分钟. [#15987](https://github.com/ClickHouse/ClickHouse/pull/15987) ([filimonov](https://github.com/filimonov)).
* 在插入或从 MaterializedView 中选择并同时删除目标表时修复罕见的段错误 (适用于原子数据库引擎). [#15984](https://github.com/ClickHouse/ClickHouse/pull/15984) ([tavplubix](https://github.com/tavplubix)).
* 修复解析设置配置文件时的歧义: `CREATE USER ... SETTINGS profile readonly` 现在被视为使用名为 `readonly` 的配置文件, 而不是名为 `profile` 的具有只读约束的设置. 这修复了 [#15628](https://github.com/ClickHouse/ClickHouse/issues/15628). [#15982](https://github.com/ClickHouse/ClickHouse/pull/15982) ([Vitaly Baranov](https://github.com/vitlibar)).
* `MaterializeMySQL` (实验功能): 修复创建数据库失败时的崩溃. [#15954](https://github.com/ClickHouse/ClickHouse/pull/15954) ([Winter Zhang](https://github.com/zhang2014)).
* 修复了当表被并发重命名 (对于原子数据库引擎) 时, `DROP TABLE IF EXISTS` 失败并带有 `Table ... does not exist` 错误的问题. 修复了并发执行具有多个表的某些 DDL 查询 (如`DROP DATABASE` 和 `RENAME TABLE` ) 时罕见的死锁 - 修复了并发执行 `DROP/DETACH` 时 `Table ... does not exist` 的 `DROP/DETACH DATABASE` 失败表`. [#15934](https://github.com/ClickHouse/ClickHouse/pull/15934) ([tavplubix](https://github.com/tavplubix)).
* 如果查询具有 `WHERE`、`PREWHERE` 和`GLOBAL IN`, 则修复来自`Distributed` 表的查询的错误空结果. 修复[#15792](https://github.com/ClickHouse/ClickHouse/issues/15792). [#15933](https://github.com/ClickHouse/ClickHouse/pull/15933) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* 修复 [#12513](https://github.com/ClickHouse/ClickHouse/issues/12513): 重新分析查询时具有相同别名的差异表达式. [#15886](https://github.com/ClickHouse/ClickHouse/pull/15886) ([Winter Zhang](https://github.com/zhang2014)).
* 修复 RBAC 实现中可能非常罕见的死锁. [#15875](https://github.com/ClickHouse/ClickHouse/pull/15875) ([Vitaly Baranov](https://github.com/vitlibar)).
* 修复在 `ALTER MODIFY COLUMN` 查询之后执行的 `SELECT ... ORDER BY DESC` 查询中的异常 `Block structure mismatch` . 修复 [#15800](https://github.com/ClickHouse/ClickHouse/issues/15800). [#15852](https://github.com/ClickHouse/ClickHouse/pull/15852) ([alesapin](https://github.com/alesapin)).
* `MaterializeMySQL` (实验功能): 修复 `select count()` 不准确. [#15767](https://github.com/ClickHouse/ClickHouse/pull/15767) ([tavplubix](https://github.com/tavplubix)).
* 修复某些查询情况, 其中仅选择虚拟列. 以前可能会抛出 `Not found column _nothing in block` 异常. 修复 [#12298](https://github.com/ClickHouse/ClickHouse/issues/12298). [#15756](https://github.com/ClickHouse/ClickHouse/pull/15756) ([Anton Popov](https://github.com/CurtizJ)).
* 修复原子数据库中具有内表的物化视图的删除 (由于工作线程挂起, 由于 MV 内表的递归 DROP TABLE, 因此挂起所有后续 DROP TABLE). [#15743](https://github.com/ClickHouse/ClickHouse/pull/15743) ([Azat Khuzhin](https://github.com/azat)).
* 如果第一次尝试失败, 可以将部分移动到另一个磁盘/卷. [#15723](https://github.com/ClickHouse/ClickHouse/pull/15723) ([Pavel Kovalenko](https://github.com/Jokser)).
* 修复错误 `Cannot find column`, 如果对 `MV` 的查询包含 `ARRAY JOIN` , 则在插入 `MATERIALIZED VIEW` 时可能会发生该错误. [#15717](https://github.com/ClickHouse/ClickHouse/pull/15717) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* 修复了 `max_replicated_logs_to_keep` 设置的默认值过低, 这可能导致副本过于频繁地丢失. 通过选择要克隆的最新副本来改进丢失的副本恢复过程. 也不要从丢失的复制品中取出旧零件, 而是将它们拆下. [#15701](https://github.com/ClickHouse/ClickHouse/pull/15701) ([tavplubix](https://github.com/tavplubix)).
* 修复 MySQL 字典和表中罕见的竞争条件. [#15686](https://github.com/ClickHouse/ClickHouse/pull/15686) ([alesapin](https://github.com/alesapin)).
* 修复 AMQP-CPP 中的 (良性) 竞争条件. [#15667](https://github.com/ClickHouse/ClickHouse/pull/15667) ([alesapin](https://github.com/alesapin)).
* 修复错误 `Cannot add simple transform to empty Pipe` , 该错误在从与目标表结构不同的 `Buffer` 表中读取时发生. 如果目标表返回空的查询结果是可能的. 修复 [#15529](https://github.com/ClickHouse/ClickHouse/issues/15529). [#15662](https://github.com/ClickHouse/ClickHouse/pull/15662) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* 在使用 S3 插入 MergeTree 期间正确处理错误. S3 上的 MergeTree 是一项实验性功能. [#15657](https://github.com/ClickHouse/ClickHouse/pull/15657) ([Pavel Kovalenko](https://github.com/Jokser)).
* 修复了 S3 表功能的错误: 来自 URL 的区域未应用于 S3 客户端配置. [#15646](https://github.com/ClickHouse/ClickHouse/pull/15646) ([Vladimir Chebotarev](https://github.com/excitoon)).
* 修复查询计划的 ReadFromStorage 步骤中资源的销毁顺序. 在极少数情况下, 它可能会导致崩溃. 可能与[#15610](https://github.com/ClickHouse/ClickHouse/issues/15610)有关. [#15645](https://github.com/ClickHouse/ClickHouse/pull/15645) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* 分离只读表时减去`ReadonlyReplica` 指标. [#15592](https://github.com/ClickHouse/ClickHouse/pull/15592) ([sundyli](https://github.com/sundy-li)).
* 修复了使用 `JSON*` 函数时会导致 `VALUES`、`LIMIT` 或 `IN` 运算符右侧的 `Element ... is not a constant expression` 错误. [#15589](https://github.com/ClickHouse/ClickHouse/pull/15589) ([tavplubix](https://github.com/tavplubix)).
* 如果出现异常, 查询将更快完成. 如果发生异常, 取消对远程副本的执行. [#15578](https://github.com/ClickHouse/ClickHouse/pull/15578) ([Azat Khuzhin](https://github.com/azat)).
* 防止出现错误消息 `Could not calculate available disk space (statvfs), errno: 4, strerror: Interrupted system call` 的可能性. 这修复了 [#15541](https://github.com/ClickHouse/ClickHouse/issues/15541). [#15557](https://github.com/ClickHouse/ClickHouse/pull/15557) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 修复 `Database <db> does not exist.` 在启动器上没有数据库时使用 IN 和分布式表的查询. [#15538](https://github.com/ClickHouse/ClickHouse/pull/15538) ([Artem Zuikov](https://github.com/4ertus2)).
* Mutation 可能会在 `MOVE` 或 `REPLACE PARTITION` 之后等待一些不存在的部分, 或者在极少数情况下, 在 `DETACH` 或 `DROP PARTITION` 之后挂起. 已修复. [#15537](https://github.com/ClickHouse/ClickHouse/pull/15537) ([tavplubix](https://github.com/tavplubix)).
* 修复如果执行具有相同模式的 `LIKE` , 则 `LIKE` 运算符不再区分大小写的错误. [#15536](https://github.com/ClickHouse/ClickHouse/pull/15536) ([alesapin](https://github.com/alesapin)).
* 修复了当选择数据中没有的列，但依赖于数据中也没有的其他列时的 `Missing columns` 错误. 修复 [#15530](https://github.com/ClickHouse/ClickHouse/issues/15530). [#15532](https://github.com/ClickHouse/ClickHouse/pull/15532) ([alesapin](https://github.com/alesapin)).
* 将单个参数传递给 ReplicatedMergeTree 而不是忽略它时抛出错误. [#15516](https://github.com/ClickHouse/ClickHouse/pull/15516) ([nvartolomei](https://github.com/nvartolomei)).
* 修复了 DDLWorker 中事件订阅的错误, 该错误很少会导致查询在 `ON CLUSTER` 中挂起. 引入 [#13450](https://github.com/ClickHouse/ClickHouse/issues/13450). [#15477](https://github.com/ClickHouse/ClickHouse/pull/15477) ([alesapin](https://github.com/alesapin)).
* 当 `boundingRatio` 聚合函数的第二个参数类型错误时报告正确的错误. [#15407](https://github.com/ClickHouse/ClickHouse/pull/15407) ([detailyang](https://github.com/detailyang)).
* 修复 [#15365](https://github.com/ClickHouse/ClickHouse/issues/15365): 附加带有 MySQL 引擎的数据库抛出异常 (无查询上下文) . [#15384](https://github.com/ClickHouse/ClickHouse/pull/15384) ([Winter Zhang](https://github.com/zhang2014)).
* 修复 select 查询中多次出现列转换器的情况. [#15378](https://github.com/ClickHouse/ClickHouse/pull/15378) ([Amos Bird](https://github.com/amosbird)).
* 修复了 `S3` 存储中的压缩. [#15376](https://github.com/ClickHouse/ClickHouse/pull/15376) ([Vladimir Chebotarev](https://github.com/excitoon)).
* 修复诸如 `SELECT toStartOfDay(today())` 之类的查询失败抱怨空 time_zone 参数的错误. [#15319](https://github.com/ClickHouse/ClickHouse/pull/15319) ([Bharat Nallan](https://github.com/bharatnc)).
* 修复合并树表重命名和背景清理过程中的竞争条件. [#15304](https://github.com/ClickHouse/ClickHouse/pull/15304) ([alesapin](https://github.com/alesapin)).
* 修复启用系统日志时服务器启动时罕见的竞争条件. [#15300](https://github.com/ClickHouse/ClickHouse/pull/15300) ([alesapin](https://github.com/alesapin)).
* 修复带有大量子查询的查询挂起到 `MySQL` 引擎的同一个表. 以前, 如果查询中对同一个 `MySQL` 表的子查询超过 16 个, 它将永远挂起. [#15299](https://github.com/ClickHouse/ClickHouse/pull/15299) ([Anton Popov](https://github.com/CurtizJ)).
* 修复 QueryLog 中的 MSan 报告. 未初始化的内存可用于字段 `memory_usage`. [#15258](https://github.com/ClickHouse/ClickHouse/pull/15258) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 当查询在 Merge 表上有 JOIN 时，修复 GROUP BY 中的 `Unknown identifier` . [#15242](https://github.com/ClickHouse/ClickHouse/pull/15242) ([Artem Zuikov](https://github.com/4ertus2)).
* 修复了将 `joinGet` 与 `LowCardinality` 类型结合使用时的实例崩溃问题. 这修复了 [#15214](https://github.com/ClickHouse/ClickHouse/issues/15214). [#15220](https://github.com/ClickHouse/ClickHouse/pull/15220) ([Amos Bird](https://github.com/amosbird)).
* 修复表引擎 `Buffer` 中的错误, 该错误不允许在 `ALTER` 查询后将新结构的数据插入到 `Buffer` 中. 修复 [#15117](https://github.com/ClickHouse/ClickHouse/issues/15117). [#15192](https://github.com/ClickHouse/ClickHouse/pull/15192) ([alesapin](https://github.com/alesapin)).
* 调整 MySQL 列定义包中的 Decimal 字段大小. [#15152](https://github.com/ClickHouse/ClickHouse/pull/15152) ([maqroll](https://github.com/maqroll)).
* 修复了 `join_algorithm='auto'` 中的`用不同方法压缩的数据`. 在 `join_algorithm='partial_merge'` 中保持 LowCardinality 作为左表连接键的类型. [#15088](https://github.com/ClickHouse/ClickHouse/pull/15088) ([Artem Zuikov](https://github.com/4ertus2)).
* 更新 `jemalloc` 以修复带有亲和掩码的 `percpu_arena`. [#15035](https://github.com/ClickHouse/ClickHouse/pull/15035) ([Azat Khuzhin](https://github.com/azat)). [#14957](https://github.com/ClickHouse/ClickHouse/pull/14957) ([Azat Khuzhin](https://github.com/azat)).
* 我们已经在 String 和 FixedString 之间使用了填充比较 (https://github.com/ClickHouse/ClickHouse/blob/master/src/Functions/FunctionsComparison.h#L333) . 此 PR 将相同的逻辑应用于字段比较, 以更正 FixedString 作为主键的使用. 这修复了 [#14908](https://github.com/ClickHouse/ClickHouse/issues/14908). [#15033](https://github.com/ClickHouse/ClickHouse/pull/15033) ([Amos Bird](https://github.com/amosbird)).
* 如果使用专门设计的参数调用函数 `bar`, 则可能会发生缓冲区溢出. 这将关闭 [#13926](https://github.com/ClickHouse/ClickHouse/issues/13926). [#15028](https://github.com/ClickHouse/ClickHouse/pull/15028) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 修复了在 Mac OS 上的 Docker 中运行 clickhouse-server 时, 在原子数据库中执行 DDL 查询时出现的 `Cannot rename ... errno: 22, strerror: Invalid argument` 错误. [#15024](https://github.com/ClickHouse/ClickHouse/pull/15024) ([tavplubix](https://github.com/tavplubix)).
* 当超过内存限制时, 使用 join_algorith='auto' 修复 RIGHT 或 FULL JOIN 中的崩溃, 我们应该使用 MergeJoin 更改 HashJoin. [#15002](https://github.com/ClickHouse/ClickHouse/pull/15002) ([Artem Zuikov](https://github.com/4ertus2)).
* 现在设置 `number_of_free_entries_in_pool_to_execute_mutation` 和 `number_of_free_entries_in_pool_to_lower_max_size_of_merge` 可以等于 `background_pool_size`. [#14975](https://github.com/ClickHouse/ClickHouse/pull/14975) ([alesapin](https://github.com/alesapin)).
* 当子查询包含`finalizeAggregation` 函数时, 修复使谓词下推工作. 修复 [#14847](https://github.com/ClickHouse/ClickHouse/issues/14847). [#14937](https://github.com/ClickHouse/ClickHouse/pull/14937) ([filimonov](https://github.com/filimonov)).
* 在 `system.asynchronous_metrics` 中发布每个逻辑核心的 CPU 频率. 这修复了 [#14923](https://github.com/ClickHouse/ClickHouse/issues/14923). [#14924](https://github.com/ClickHouse/ClickHouse/pull/14924) ([Alexander Kuzmenkov](https://github.com/akuzm)).
* `MaterializeMySQL` (实验功能): 修复了 `.metadata.tmp File exists` 错误. [#14898](https://github.com/ClickHouse/ClickHouse/pull/14898) ([Winter Zhang](https://github.com/zhang2014)).
* 修复部分调用 `extractAllGroups` 函数可能触发 `Memory limit exceeded` 错误的问题. 这修复了 [#13383](https://github.com/ClickHouse/ClickHouse/issues/13383). [#14889](https://github.com/ClickHouse/ClickHouse/pull/14889) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 修复 SIGSEGV 以尝试使用文件描述符插入 StorageFile. [#14887](https://github.com/ClickHouse/ClickHouse/pull/14887) ([Azat Khuzhin](https://github.com/azat)).
* 修复了 `cache` 字典中的段错误 [#14837](https://github.com/ClickHouse/ClickHouse/issues/14837). [#14879](https://github.com/ClickHouse/ClickHouse/pull/14879) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* `MaterializeMySQL` (实验功能): 修复了解析 MySQL 二进制日志事件的错误，该错误导致 `MaterializeMySQL` 数据库引擎中的 `Attempt to read after eof` 和 `Packet payload is not fully read`. [#14852](https://github.com/ClickHouse/ClickHouse/pull/14852) ([Winter Zhang](https://github.com/zhang2014)).
* 当被查询的列具有 `DEFAULT` 表达式时, 修复 `SELECT` 查询中的罕见错误, 该表达式依赖于另一列, 该列也具有 `DEFAULT` 并且不存在于选择查询中且不存在于磁盘上. 部分修复 [#14531](https://github.com/ClickHouse/ClickHouse/issues/14531). [#14845](https://github.com/ClickHouse/ClickHouse/pull/14845) ([alesapin](https://github.com/alesapin)).
* 如果必须从 ZK 获取配置文件 (使用 `from_zk` 包含选项) , 则修复服务器在与 ZooKeeper 交谈时可能会在启动时卡住的问题. 这修复了 [#14814](https://github.com/ClickHouse/ClickHouse/issues/14814). [#14843](https://github.com/ClickHouse/ClickHouse/pull/14843) ([Alexander Kuzmenkov](https://github.com/akuzm)).
* 修复了收缩的`Int -> Int` 签名类型转换的错误单调性检测. 可能会导致查询结果不正确. 此错误在 [#14513](https://github.com/ClickHouse/ClickHouse/issues/14513) 中公布. [#14783](https://github.com/ClickHouse/ClickHouse/pull/14783) ([Amos Bird](https://github.com/amosbird)).
* `Replace` 列转换器应该用克隆的 AST 替换标识符. 这修复了 [#14695](https://github.com/ClickHouse/ClickHouse/issues/14695). [#14734](https://github.com/ClickHouse/ClickHouse/pull/14734) ([Amos Bird](https://github.com/amosbird)).
* 修复了执行 `ALTER ... MODIFY QUERY` 时物化视图元数据中丢失的默认数据库名称. [#14664](https://github.com/ClickHouse/ClickHouse/pull/14664) ([tavplubix](https://github.com/tavplubix)).
* 修复了当赋值表达式和常量值 (如 `UPDATE x = 42` ) 中带有 `Nullable` 列的 `ALTER UPDATE` 突变导致列或段错误中的值不正确时的错误. 修复 [#13634](https://github.com/ClickHouse/ClickHouse/issues/13634), [#14045](https://github.com/ClickHouse/ClickHouse/issues/14045). [#14646](https://github.com/ClickHouse/ClickHouse/pull/14646) ([alesapin](https://github.com/alesapin)).
* 修复错误的十进制乘法结果导致结果列小数位数错误. [#14603](https://github.com/ClickHouse/ClickHouse/pull/14603) ([Artem Zuikov](https://github.com/4ertus2)).
* 修复函数 `has` 与 `LowCardinality` 的 `Nullable` . [#14591](https://github.com/ClickHouse/ClickHouse/pull/14591) ([Mike](https://github.com/myrrc)).
* 在为 StorageReplicatedMergeTree 引擎创建查询期间 Zookeeper 异常后清理数据目录. [#14563](https://github.com/ClickHouse/ClickHouse/pull/14563) ([Bharat Nallan](https://github.com/bharatnc)).
* 修复带有组合子 `-Resample` 的函数中罕见的段错误, 这可能会出现在参数非常大的溢出结果中. [#14562](https://github.com/ClickHouse/ClickHouse/pull/14562) ([Anton Popov](https://github.com/CurtizJ)).
* 修复了将 `Nullable(String)` 转换为 Enum 时的错误. 由 [#12745](https://github.com/ClickHouse/ClickHouse/pull/12745) 介绍. 这修复了 [#14435](https://github.com/ClickHouse/ClickHouse/issues/14435). [#14530](https://github.com/ClickHouse/ClickHouse/pull/14530) ([Amos Bird](https://github.com/amosbird)).
* 修复了 `Nullable` 列不正确的排序顺序. 这修复了 [#14344](https://github.com/ClickHouse/ClickHouse/issues/14344). [#14495](https://github.com/ClickHouse/ClickHouse/pull/14495) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* 修复 `currentDatabase()` 函数不能在 `ON CLUSTER` ddl 查询中使用. [#14211](https://github.com/ClickHouse/ClickHouse/pull/14211) ([Winter Zhang](https://github.com/zhang2014)).
* `MaterializeMySQL` (实验功能): 修复了 `MaterializeMySQL` 数据库引擎中的 `Packet payload is not full read` 错误. [#14696](https://github.com/ClickHouse/ClickHouse/pull/14696) ([BohuTANG](https://github.com/BohuTANG)).

#### 改进

* 默认情况下为新创建的数据库启用 `Atomic` 数据库引擎. [#15003](https://github.com/ClickHouse/ClickHouse/pull/15003) ([tavplubix](https://github.com/tavplubix)).
* 添加为具有子类型的列指定专用编解码器的功能, 如 `Delta`、`T64` 等. 实现 [#12551](https://github.com/ClickHouse/ClickHouse/issues/12551), 修复 [#11397](https://github.com/ClickHouse/ClickHouse/issues/11397), 修复 [#4609](https://github.com/ClickHouse/ClickHouse/issues/4609). [#15089](https://github.com/ClickHouse/ClickHouse/pull/15089) ([alesapin](https://github.com/alesapin)).
* 动态重新加载zookeeper配置. [#14678](https://github.com/ClickHouse/ClickHouse/pull/14678) ([sundyli](https://github.com/sundy-li)).
* 现在， 无论集群配置中的 `<internal_replication>` 设置如何, 都可以执行 `ALTER ... ON CLUSTER` 查询. [#16075](https://github.com/ClickHouse/ClickHouse/pull/16075) ([alesapin](https://github.com/alesapin)).
* 现在 `joinGet` 支持多键查找。 续. [#13015](https://github.com/ClickHouse/ClickHouse/pull/13015) ([Amos Bird](https://github.com/amosbird)).
* 如果为 `Atomic` 数据库指定了 `NO DELAY` 或 `SYNC`, 则等待 `DROP/DETACH TABLE` 实际完成. [#15448](https://github.com/ClickHouse/ClickHouse/pull/15448) ([tavplubix](https://github.com/tavplubix)).
* 现在可以使用 `ALTER` 查询更改 `VersionedCollapsingMergeTree` 的版本列的类型. [#15442](https://github.com/ClickHouse/ClickHouse/pull/15442) ([alesapin](https://github.com/alesapin)).
* 在复制表创建时展开 `zookeeper_path` 中的 `{database}`、`{table}` 和 `{uuid}` 宏. 如果在服务器重启后可能会破坏 `zookeeper_path`, 不要允许 `RENAME TABLE`. 修复 [#6917](https://github.com/ClickHouse/ClickHouse/issues/6917). [#15348](https://github.com/ClickHouse/ClickHouse/pull/15348) ([tavplubix](https://github.com/tavplubix)).
* 函数 `now` 允许使用时区参数. 这关闭 [15264](https://github.com/ClickHouse/ClickHouse/issues/15264). [#15285](https://github.com/ClickHouse/ClickHouse/pull/15285) ([flynn](https://github.com/ucasFL)).
* 在执行 `/docker-entrypoint-initdb.d/` 中的所有脚本之前. 不允许连接到 ClickHouse 服务器. [#15244](https://github.com/ClickHouse/ClickHouse/pull/15244) ([Aleksei Kozharin](https://github.com/alekseik1)).
* 向 `EXPLAIN PLAN` 查询添加了 `optimize` 设置. 如果启用, 则应用查询计划级别优化. 默认启用. [#15201](https://github.com/ClickHouse/ClickHouse/pull/15201) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* CAST 参数数量错误的正确异常消息. 这将关闭 [#13992](https://github.com/ClickHouse/ClickHouse/issues/13992). [#15029](https://github.com/ClickHouse/ClickHouse/pull/15029) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 添加选项以在数据部分插入时禁用 TTL 移动. [#15000](https://github.com/ClickHouse/ClickHouse/pull/15000) ([Pavel Kovalenko](https://github.com/Jokser)).
* 进行突变时忽略关键约束. 没有这个拉取请求, 当 `force_index_by_date = 1` 或 `force_primary_key = 1` 时不可能进行突变. [#14973](https://github.com/ClickHouse/ClickHouse/pull/14973) ([Amos Bird](https://github.com/amosbird)).
* 如果之前的删除尝试由于 ZooKeeper 会话过期而失败, 则允许删除复制表. 这修复了 [#11891](https://github.com/ClickHouse/ClickHouse/issues/11891). [#14926](https://github.com/ClickHouse/ClickHouse/pull/14926) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 修复了从分布式表中使用 SETTINGS 运行 SELECT 时过多的设置约束冲突. [#14876](https://github.com/ClickHouse/ClickHouse/pull/14876) ([Amos Bird](https://github.com/amosbird)).
* 提供一个 `load_balancing_first_offset` 查询设置来明确说明第一个副本是什么. 它与“FIRST_OR_RANDOM”负载均衡策略一起使用, 允许控制副本工作负载. [#14867](https://github.com/ClickHouse/ClickHouse/pull/14867) ([Amos Bird](https://github.com/amosbird)).
* 在 `EXPLAIN` 结果中显示 `SET` 和 `JOIN` 的子查询. [#14856](https://github.com/ClickHouse/ClickHouse/pull/14856) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* 允许在存储 `Distributed` 中使用多卷存储配置. [#14839](https://github.com/ClickHouse/ClickHouse/pull/14839) ([Pavel Kovalenko](https://github.com/Jokser)).
* 从相同的 timespec 构造 `query_start_time` 和 `query_start_time_microseconds`. [#14831](https://github.com/ClickHouse/ClickHouse/pull/14831) ([Bharat Nallan](https://github.com/bharatnc)).
* 支持禁用 `StorageJoin` 和 `StorageSet` 的持久化, 这个特性是通过设置`disable_set_and_join_persistency`来控制的. 这个 PR 解决了问题 [#6318](https://github.com/ClickHouse/ClickHouse/issues/6318). [#14776](https://github.com/ClickHouse/ClickHouse/pull/14776) ([vxider](https://github.com/Vxider)).
* 现在 `COLUMNS` 可用于包装列列表并在之后应用列转换器. [#14775](https://github.com/ClickHouse/ClickHouse/pull/14775) ([Amos Bird](https://github.com/amosbird)).
* 将 `merge_algorithm` 添加到 `system.merges` 表以改进合并检查. [#14705](https://github.com/ClickHouse/ClickHouse/pull/14705) ([Amos Bird](https://github.com/amosbird)).
* 修复 zookeeper 存在 watch 导致的潜在内存泄漏. [#14693](https://github.com/ClickHouse/ClickHouse/pull/14693) ([hustnn](https://github.com/hustnn)).
* 允许并行执行分布式 DDL. [#14684](https://github.com/ClickHouse/ClickHouse/pull/14684) ([Azat Khuzhin](https://github.com/azat)).
* 添加 `QueryMemoryLimitExceeded` 事件计数器. 这将关闭 [#14589](https://github.com/ClickHouse/ClickHouse/issues/14589). [#14647](https://github.com/ClickHouse/ClickHouse/pull/14647) ([fastio](https://github.com/fastio)).
* 修复查询格式中的一些尾随空格. [#14595](https://github.com/ClickHouse/ClickHouse/pull/14595) ([Azat Khuzhin](https://github.com/azat)).
* ClickHouse 对分区 expr 和键 expr 的处理方式不同. 分区 expr 用于构造包含相关列的 minmax 索引, 而主键 expr 存储为 expr. 有时用户可能会在更粗略的级别对表进行分区, 例如 `partition by i / 1000`. 然而, 二元运算符不是单调的, 这个 PR 试图解决这个问题. 它也可能有益于其他用例. [#14513](https://github.com/ClickHouse/ClickHouse/pull/14513) ([Amos Bird](https://github.com/amosbird)).
* 添加一个选项以跳过对 `DiskS3` 的访问检查. `s3` 磁盘是一项实验性功能. [#14497](https://github.com/ClickHouse/ClickHouse/pull/14497) ([Pavel Kovalenko](https://github.com/Jokser)).
* 如果有正在进行的 S3 请求, 则加快服务器关闭过程. [#14496](https://github.com/ClickHouse/ClickHouse/pull/14496) ([Pavel Kovalenko](https://github.com/Jokser)).
* 如果重新加载失败并继续使用以前的 users.xml, `SYSTEM RELOAD CONFIG` 现在会抛出异常. 如果重新加载失败, 后台定期重新加载也会继续使用以前的 users.xml. [#14492](https://github.com/ClickHouse/ClickHouse/pull/14492) ([Vitaly Baranov](https://github.com/vitlibar)).
* 对于 `clickhouse-client` 的脚本模式下带有 VALUES 格式的内联数据的 INSERT, 除了换行外, 还支持分号作为数据终止符. 关闭 [#12288](https://github.com/ClickHouse/ClickHouse/issues/12288). [#13192](https://github.com/ClickHouse/ClickHouse/pull/13192) ([Alexander Kuzmenkov](https://github.com/akuzm)).
* 支持紧凑部分的自定义编解码器. [#12183](https://github.com/ClickHouse/ClickHouse/pull/12183) ([Anton Popov](https://github.com/CurtizJ)).

#### 性能改进

* 默认情况下为小零件启用紧凑零件. 这将允许稍微更有效地处理频繁插入 (4..100 次). [#11913](https://github.com/ClickHouse/ClickHouse/pull/11913) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 提高 `quantileTDigest` 性能. 这修复了 [#2668](https://github.com/ClickHouse/ClickHouse/issues/2668). [#15542](https://github.com/ClickHouse/ClickHouse/pull/15542) ([Kruglov Pavel](https://github.com/Avogar)).
* 显著减少 AggregatingInOrderTransform/optimize_aggregation_in_order 中的内存使用. [#15543](https://github.com/ClickHouse/ClickHouse/pull/15543) ([Azat Khuzhin](https://github.com/azat)).
* 更快的 256 位乘法. [#15418](https://github.com/ClickHouse/ClickHouse/pull/15418) ([Artem Zuikov](https://github.com/4ertus2)).
* 使用 (u)int64_t 作为宽整数的基本类型提高 256 位类型的性能. 原始宽整数使用 8 位类型作为基数. [#14859](https://github.com/ClickHouse/ClickHouse/pull/14859) ([Artem Zuikov](https://github.com/4ertus2)).
* 显式使用临时磁盘存储垂直合并临时数据. [#15639](https://github.com/ClickHouse/ClickHouse/pull/15639) ([Grigory Pervakov](https://github.com/GrigoryPervakov)).
* 在循环中使用一个 S3 DeleteObjects 请求而不是多个 DeleteObject. 没有任何功能更改, 因此由现有测试 (如集成/test_log_family_s3) 覆盖. [#15238](https://github.com/ClickHouse/ClickHouse/pull/15238) ([ianton-ru](https://github.com/ianton-ru)).
* 修复 `DateTime <op> DateTime` 错误地选择了缓慢的通用实现. 这修复了 [#15153](https://github.com/ClickHouse/ClickHouse/issues/15153). [#15178](https://github.com/ClickHouse/ClickHouse/pull/15178) ([Amos Bird](https://github.com/amosbird)).
* 提高 `FixedString` 类型的 GROUP BY 键的性能. [#15034](https://github.com/ClickHouse/ClickHouse/pull/15034) ([Amos Bird](https://github.com/amosbird)).
* 启动 clickhouse-server 时只有 `mlock` 代码段. 在以前的版本中, 所有映射区域都被锁定在内存中, 包括调试信息. 调试信息通常被拆分为一个单独的文件, 但如果不是, 则会导致 +2..3 GiB 内存使用. [#14929](https://github.com/ClickHouse/ClickHouse/pull/14929) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 由于链接时间优化, ClickHouse 二进制文件变得更小.

#### 构建/测试/打包改进

* 现在我们使用 clang-11 进行生产 ClickHouse 构建. [#15239](https://github.com/ClickHouse/ClickHouse/pull/15239) ([alesapin](https://github.com/alesapin)).
* 现在我们使用 clang-11 在 CI 中构建 ClickHouse. [#14846](https://github.com/ClickHouse/ClickHouse/pull/14846) ([alesapin](https://github.com/alesapin)).
* 将二进制构建 (Linux、Darwin、AArch64、FreeDSD) 切换到 clang-11. [#15622](https://github.com/ClickHouse/ClickHouse/pull/15622) ([Ilya Yatsishin](https://github.com/qoega)).
* 现在所有测试图像都使用 `llvm-symbolizer-11`. [#15069](https://github.com/ClickHouse/ClickHouse/pull/15069) ([alesapin](https://github.com/alesapin)).
* 允许使用 llvm-11 构建. [#15366](https://github.com/ClickHouse/ClickHouse/pull/15366) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 从 `clang-tidy-10` 切换到 `clang-tidy-11` . [#14922](https://github.com/ClickHouse/ClickHouse/pull/14922) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 默认使用 LLVM 的实验通行证管理器. [#15608](https://github.com/ClickHouse/ClickHouse/pull/15608) ([Danila Kutenin](https://github.com/danlark1)).
* 不允许任何 C++ 翻译单元构建超过 10 分钟或使用超过 10 GB 或内存. 这修复了 [#14925](https://github.com/ClickHouse/ClickHouse/issues/14925). [#15060](https://github.com/ClickHouse/ClickHouse/pull/15060) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 通过拆分测试运行和配置文件运行, 使性能测试更加稳定和具有代表性. [#15027](https://github.com/ClickHouse/ClickHouse/pull/15027) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 尝试使性能测试更可靠. 它是通过使用 `madvise` 动态重新映射进程的可执行内存以使用透明大页面来完成的 - 它可以降低 iTLB 未命中的数量, 这是性能测试中不稳定的主要来源. [#14685](https://github.com/ClickHouse/ClickHouse/pull/14685) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 转换为python3. 这将关闭 [#14886](https://github.com/ClickHouse/ClickHouse/issues/14886). [#15007](https://github.com/ClickHouse/ClickHouse/pull/15007) ([Azat Khuzhin](https://github.com/azat)).
* 如果服务器未能响应, 则在功能测试中尽早失败. 这将关闭 [#15262](https://github.com/ClickHouse/ClickHouse/issues/15262). [#15267](https://github.com/ClickHouse/ClickHouse/pull/15267) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 允许在没有配置的情况下运行 AArch64 版本的 clickhouse-server. 这有利于 [#15174](https://github.com/ClickHouse/ClickHouse/issues/15174). [#15266](https://github.com/ClickHouse/ClickHouse/pull/15266) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* CI docker 镜像的改进: 摆脱 ZooKeeper 和用于测试配置安装的单个脚本. [#15215](https://github.com/ClickHouse/ClickHouse/pull/15215) ([alesapin](https://github.com/alesapin)).
* 在快速测试脚本中修复 CMake 选项转发. 修复了 [#14711](https://github.com/ClickHouse/ClickHouse/issues/14711) 中的错误. [#15155](https://github.com/ClickHouse/ClickHouse/pull/15155) ([alesapin](https://github.com/alesapin)).
* 添加了一个脚本以在单个命令中执行硬件基准测试. [#15115](https://github.com/ClickHouse/ClickHouse/pull/15115) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 将巨大的测试 `test_dictionaries_all_layouts_and_sources` 拆分成较小的测试. [#15110](https://github.com/ClickHouse/ClickHouse/pull/15110) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* 也许修复 base64 中的 MSan 报告 (在带有 AVX-512 的服务器上). 这修复了. [#15030](https://github.com/ClickHouse/ClickHouse/pull/15030) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 重新格式化和清理所有集成测试 *.py 文件中的代码. [#14864](https://github.com/ClickHouse/ClickHouse/pull/14864) ([Bharat Nallan](https://github.com/bharatnc)).
* 修复在 CI 中发现的 MaterializeMySQL 空事务不稳定测试用例. [#14854](https://github.com/ClickHouse/ClickHouse/pull/14854) ([Winter Zhang](https://github.com/zhang2014)).
* 尝试加快构建速度. [#14808](https://github.com/ClickHouse/ClickHouse/pull/14808) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 通过删除未使用的标头来加快构建速度. [#14714](https://github.com/ClickHouse/ClickHouse/pull/14714) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 修复 OSX 中的构建失败. [#14761](https://github.com/ClickHouse/ClickHouse/pull/14761) ([Winter Zhang](https://github.com/zhang2014)).
* 如果在操作系统中找到 ccache, 则默认在 cmake 中启用. [#14575](https://github.com/ClickHouse/ClickHouse/pull/14575) ([alesapin](https://github.com/alesapin)).
* Control CI 从 ClickHouse 存储库构建配置. [#14547](https://github.com/ClickHouse/ClickHouse/pull/14547) ([alesapin](https://github.com/alesapin)).
* 在 CMake 文件中: - 将一些选项的描述部分移动到上面的注释中. - 替换 0 -> `OFF`, 1 -> `option` 的默认值中的 `ON`. - 在选项中添加了一些说明和文档链接. - 替换了 `FUZZER` 选项 (还有另一个选项 `ENABLE_FUZZING` 也可以启用相同的功能). - 删除了 `ENABLE_GTEST_LIBRARY` 选项, 因为有 `ENABLE_TESTS`. 请参阅 PR 中的完整说明: [#14711](https://github.com/ClickHouse/ClickHouse/pull/14711) ([Mike](https://github.com/myrrc)).
* 使二进制文件更小 (调试版本约为 50 Mb). [#14555](https://github.com/ClickHouse/ClickHouse/pull/14555) ([Artem Zuikov](https://github.com/4ertus2)).
* 在 ConfigProcessor 中使用 std::filesystem::path 连接文件路径. [#14558](https://github.com/ClickHouse/ClickHouse/pull/14558) ([Bharat Nallan](https://github.com/bharatnc)).
* 使用负大整数调用时修复 `bitShiftLeft()` 中的调试断言. [#14697](https://github.com/ClickHouse/ClickHouse/pull/14697) ([Artem Zuikov](https://github.com/4ertus2)).


## ClickHouse 版本 20.9

### ClickHouse 版本 v20.9.7.11-stable, 2020-12-07

#### 性能改进

* 修复从 `Merge` 表读取大量 `MergeTree` 表的性能. 修复 [#7748](https://github.com/ClickHouse/ClickHouse/issues/7748). [#16988](https://github.com/ClickHouse/ClickHouse/pull/16988) ([Anton Popov](https://github.com/CurtizJ)).

#### Bug 修复

* 如果禁用了`in_memory_parts_enable_wal`, 则不要从 WAL 恢复部件. [#17802](https://github.com/ClickHouse/ClickHouse/pull/17802) ([detailyang](https://github.com/detailyang)).
* 修复了插入 `Distributed` 表时空间不足时的段错误. [#17737](https://github.com/ClickHouse/ClickHouse/pull/17737) ([tavplubix](https://github.com/tavplubix)).
* 修复了 ClickHouse 无法恢复与 MySQL 服务器的连接时的问题. [#17681](https://github.com/ClickHouse/ClickHouse/pull/17681) ([Alexander Kazakov](https://github.com/Akazz)).
* 修复了在 Linux 的 Windows 子系统上运行的 ClickHouse 在 `Atomic` 数据库中执行 `RENAME` 查询时出现的 `Function not implementation` 错误. 修复 [#17661](https://github.com/ClickHouse/ClickHouse/issues/17661). [#17664](https://github.com/ClickHouse/ClickHouse/pull/17664) ([tavplubix](https://github.com/tavplubix)).
* 当 clickhouse-client 用于多行查询的交互模式时, 单行注释被错误地扩展到查询结束. 这修复了 [#13654](https://github.com/ClickHouse/ClickHouse/issues/13654). [#17565](https://github.com/ClickHouse/ClickHouse/pull/17565) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 修复在极少数情况下服务器可以停止接受连接的问题. [#17542](https://github.com/ClickHouse/ClickHouse/pull/17542) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 修复了当不同副本上的相应突变被杀死时 alter 查询挂起的问题. 修复 [#16953](https://github.com/ClickHouse/ClickHouse/issues/16953). [#17499](https://github.com/ClickHouse/ClickHouse/pull/17499) ([alesapin](https://github.com/alesapin)).
* 修复 clickhouse 低估标记缓存大小时的错误. 当有很多带有标记的小文件时可能会发生. [#17496](https://github.com/ClickHouse/ClickHouse/pull/17496) ([alesapin](https://github.com/alesapin)).
* 修复了启用 `optimize_redundant_functions_in_order_by` 设置的 `ORDER BY` . [#17471](https://github.com/ClickHouse/ClickHouse/pull/17471) ([Anton Popov](https://github.com/CurtizJ)).
* 修复 `DISTINCT` 之后由于不正确优化而可能出现的重复项. 修复 [#17294](https://github.com/ClickHouse/ClickHouse/issues/17294). [#17296](https://github.com/ClickHouse/ClickHouse/pull/17296) ([li chengxiang](https://github.com/chengxianglibra)). [#17439](https://github.com/ClickHouse/ClickHouse/pull/17439) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* 修复了从具有 `LowCardinality` 类型的 `JOIN` 表读取时崩溃的问题. 修复 [#17228](https://github.com/ClickHouse/ClickHouse/issues/17228). [#17397](https://github.com/ClickHouse/ClickHouse/pull/17397) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* 修复子查询中存在 const 列时设置索引失效的问题. 这修复了 [#17246](https://github.com/ClickHouse/ClickHouse/issues/17246). [#17249](https://github.com/ClickHouse/ClickHouse/pull/17249) ([Amos Bird](https://github.com/amosbird)).
* 修复 ColumnConst 比较导致崩溃. 这个修复了 [#17088](https://github.com/ClickHouse/ClickHouse/issues/17088). [#17135](https://github.com/ClickHouse/ClickHouse/pull/17135) ([Amos Bird](https://github.com/amosbird)).
* 修复了在创建 `some_table` 时 `CREATE TABLE ... AS some_table` 查询崩溃 `AS table_function()` 修复 [#16944](https://github.com/ClickHouse/ClickHouse/issues/16944). [#17072](https://github.com/ClickHouse/ClickHouse/pull/17072) ([tavplubix](https://github.com/tavplubix)).
* 功能 fuzzBits 的 Bug 修复, 相关问题: [#16980](https://github.com/ClickHouse/ClickHouse/issues/16980). [#17051](https://github.com/ClickHouse/ClickHouse/pull/17051) ([hexiaoting](https://github.com/hexiaoting)).
* 避免远程查询的不必要的网络错误, 这些错误在执行时可能会被取消, 例如使用 `LIMIT` 的查询. [#17006](https://github.com/ClickHouse/ClickHouse/pull/17006) ([Azat Khuzhin](https://github.com/azat)).
* 备忘录. [#16866](https://github.com/ClickHouse/ClickHouse/pull/16866) ([tavplubix](https://github.com/tavplubix)).
* 通过 MySQL 协议返回 INSERT 查询的受影响行数. 以前 ClickHouse 过去总是返回 0, 它是固定的. 修复 [#16605](https://github.com/ClickHouse/ClickHouse/issues/16605). [#16715](https://github.com/ClickHouse/ClickHouse/pull/16715) ([Winter Zhang](https://github.com/zhang2014)).

#### 构建/测试/打包改进

* 将嵌入的时区数据更新到 2020d 版 (同时将 cctz 更新到最新的 master). [#17204](https://github.com/ClickHouse/ClickHouse/pull/17204) ([filimonov](https://github.com/filimonov)).


### ClickHouse 版本 v20.9.6.14-stable, 2020-11-20

#### 改进

* 可以连接到需要 SNI 的 `clickhouse-server` 安全端点. 当 `clickhouse-server` 托管在 TLS 代理之后是可能的. [#16938](https://github.com/ClickHouse/ClickHouse/pull/16938) ([filimonov](https://github.com/filimonov)).
* 条件聚合函数 (例如：`avgIf`、`sumIf`、`maxIf`) 在缺少行并使用可为空参数时应返回 `NULL` . [#13964](https://github.com/ClickHouse/ClickHouse/pull/13964) ([Winter Zhang](https://github.com/zhang2014)).

#### Bug 修复

* 修复非领导者 ReplicatedMergeTree 表的 `ON CLUSTER` 查询可能永远挂起的错误. [#17089](https://github.com/ClickHouse/ClickHouse/pull/17089) ([alesapin](https://github.com/alesapin)).
* 出现错误时解析 `format_avro_schema_registry_url` 的IP. [#16985](https://github.com/ClickHouse/ClickHouse/pull/16985) ([filimonov](https://github.com/filimonov)).
* 修复在 `ALTER TABLE ... MODIFY COLUMN ... NewType` 之后可能发生的服务器崩溃, 当 `SELECT` 在更改列上具有 `WHERE` 表达式并且更改尚未完成时. [#16968](https://github.com/ClickHouse/ClickHouse/pull/16968) ([Amos Bird](https://github.com/amosbird)).
* 安装脚本应始终在 config 文件夹中创建子目录. 这仅与使用自定义配置的 Docker 构建相关. [#16936](https://github.com/ClickHouse/ClickHouse/pull/16936) ([filimonov](https://github.com/filimonov)).
* 修复使用 `ORDER BY` 的查询可能出现的错误 `Illegal type of argument` . 修复 [#16580](https://github.com/ClickHouse/ClickHouse/issues/16580). [#16928](https://github.com/ClickHouse/ClickHouse/pull/16928) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* 如果没有数据写入 WriteBufferFromS3，则中止分段上传. [#16840](https://github.com/ClickHouse/ClickHouse/pull/16840) ([Pavel Kovalenko](https://github.com/Jokser)).
* 修复在不带任何参数的情况下使用 `any` 时的崩溃. 这是针对 [#16803](https://github.com/ClickHouse/ClickHouse/issues/16803) 的 . cc @azat. [#16826](https://github.com/ClickHouse/ClickHouse/pull/16826) ([Amos Bird](https://github.com/amosbird)).
* 在启用了 `transform_null_in` 设置的情况下修复多个列和元组上的 `IN` 运算符. 修复 [#15310](https://github.com/ClickHouse/ClickHouse/issues/15310). [#16722](https://github.com/ClickHouse/ClickHouse/pull/16722) ([Anton Popov](https://github.com/CurtizJ)).
* 这将修复 optimize_read_in_order/optimize_aggregation_in_order 与 max_threads>0 和 ORDER BY 中的表达式. [#16637](https://github.com/ClickHouse/ClickHouse/pull/16637) ([Azat Khuzhin](https://github.com/azat)).
* 修复 [#16574](https://github.com/ClickHouse/ClickHouse/issues/16574), 修复 [#16231](https://github.com/ClickHouse/ClickHouse/issues/16231), 修复使用时远程查询失败'if'后缀聚合函数. [#16610](https://github.com/ClickHouse/ClickHouse/pull/16610) ([Winter Zhang](https://github.com/zhang2014)).
* 在异常的情况下查询完成得更快. 如果发生异常, 取消对远程副本的执行. [#15578](https://github.com/ClickHouse/ClickHouse/pull/15578) ([Azat Khuzhin](https://github.com/azat)).


### ClickHouse 版本 v20.9.5.5-stable, 2020-11-13

#### Bug 修复

* 当查询分析器打开并且 ClickHouse 安装在操作系统上时, 修复罕见的无声崩溃, glibc 版本已经 (据说) 损坏了某些功能的异步展开表. 这修复了 [#15301](https://github.com/ClickHouse/ClickHouse/issues/15301). 这修复了 [#13098](https://github.com/ClickHouse/ClickHouse/issues/13098). [#16846](https://github.com/ClickHouse/ClickHouse/pull/16846) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 现在, 当从输入解析 AVRO 时, LowCardinality 将从类型中删除. 修复 [#16188](https://github.com/ClickHouse/ClickHouse/issues/16188). [#16521](https://github.com/ClickHouse/ClickHouse/pull/16521) ([Mike](https://github.com/myrrc)).
* 通过适当缩小 GTID 集，修复使用 MySQL Master -> MySQL Slave -> ClickHouse MaterializeMySQL Engine 和 MySQL Slave 上启用的 `slave_parallel_worker` 时元数据的快速增长. 这修复了 [#15951](https://github.com/ClickHouse/ClickHouse/issues/15951). [#16504](https://github.com/ClickHouse/ClickHouse/pull/16504) ([TCeason](https://github.com/TCeason)).
* 修复分布式的 DROP TABLE (使用 INSERT). [#16409](https://github.com/ClickHouse/ClickHouse/pull/16409) ([Azat Khuzhin](https://github.com/azat)).
* 复复制队列中非常大的条目的处理. 如果表结构非常大 (接近 1 MB), 则非常大的条目可能会出现在 ALTER 查询中. 这修复了 [#16307](https://github.com/ClickHouse/ClickHouse/issues/16307). [#16332](https://github.com/ClickHouse/ClickHouse/pull/16332) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 修复了由于未创建过滤集而可能删除部分返回数据时的不一致行为. [#16308](https://github.com/ClickHouse/ClickHouse/pull/16308) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* 修复 MySQL 数据库的错误. 当用作数据库引擎的 MySQL 服务器关闭时, 某些查询会引发异常, 因为它们试图从禁用的服务器获取表, 而这是不必要的. 例如, 查询 `SELECT ... FROM system.parts` 应该只适用于 MergeTree 表并且根本不要接触 MySQL 数据库. [#16032](https://github.com/ClickHouse/ClickHouse/pull/16032) ([Kruglov Pavel](https://github.com/Avogar)).


### ClickHouse 版本 v20.9.4.76-stable (2020-10-29)

#### Bug 修复

* 在函数 `dictGet` 出现异常时修复double free. 如果字典加载错误, 可能会发生这种情况. [#16429](https://github.com/ClickHouse/ClickHouse/pull/16429) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* 修复由总数/汇总/多维数据集修饰符和最小/最大功能按键分组. 修复 [#16393](https://github.com/ClickHouse/ClickHouse/issues/16393). [#16397](https://github.com/ClickHouse/ClickHouse/pull/16397) ([Anton Popov](https://github.com/CurtizJ)).
* 修复异步分布式插入 w/prefer_localhost_replica=0 和 internal_replication. [#16358](https://github.com/ClickHouse/ClickHouse/pull/16358) ([Azat Khuzhin](https://github.com/azat)).
* 修复 TwoLevelStringHashTable 实现中的一个非常错误的代码, 这可能会导致内存泄漏. 我很惊讶这个 bug 怎么能潜伏这么久.... [#16264](https://github.com/ClickHouse/ClickHouse/pull/16264) ([Amos Bird](https://github.com/amosbird)).
* 修复无论限制如何都可以过度分配内存的情况. 这将关闭 [#14560](https://github.com/ClickHouse/ClickHouse/issues/14560). [#16206](https://github.com/ClickHouse/ClickHouse/pull/16206) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 修复 `ReplicatedVersionedCollapsingMergeTree` 的 `ALTER MODIFY ... ORDER BY` 查询挂起. 这修复了 [#15980](https://github.com/ClickHouse/ClickHouse/issues/15980). [#16011](https://github.com/ClickHouse/ClickHouse/pull/16011) ([alesapin](https://github.com/alesapin)).
* 修复整理名称和字符集名称解析器并支持字符串类型的 `length = 0`. [#16008](https://github.com/ClickHouse/ClickHouse/pull/16008) ([Winter Zhang](https://github.com/zhang2014)).
* 允许对具有复杂键的字典使用直接布局. [#16007](https://github.com/ClickHouse/ClickHouse/pull/16007) ([Anton Popov](https://github.com/CurtizJ)).
* 在一段时间不活动后发生复制错误时, 防止副本挂起 5-10 分钟. [#15987](https://github.com/ClickHouse/ClickHouse/pull/15987) ([filimonov](https://github.com/filimonov)).
* 在插入或从 MaterializedView 中选择并同时删除目标表时修复罕见的段错误 (适用于原子数据库引擎). [#15984](https://github.com/ClickHouse/ClickHouse/pull/15984) ([tavplubix](https://github.com/tavplubix)).
* 修复解析设置配置文件时的歧义: `CREATE USER ... SETTINGS profile readonly` 现在被视为使用名为 `readonly` 的配置文件, 而不是名为 `profile` 的具有只读约束的设置. 这修复了 [#15628](https://github.com/ClickHouse/ClickHouse/issues/15628). [#15982](https://github.com/ClickHouse/ClickHouse/pull/15982) ([Vitaly Baranov](https://github.com/vitlibar)).
* 修复数据库创建失败时的崩溃. [#15954](https://github.com/ClickHouse/ClickHouse/pull/15954) ([Winter Zhang](https://github.com/zhang2014)).
* 修复了当表被并发重命名 (对于原子数据库引擎) 时, `DROP TABLE IF EXISTS` 失败并带有 `Table ... does not exist` 错误的问题. 修复了并发执行具有多个表的某些 DDL 查询 (如 `DROP DATABASE”和“RENAME TABLE` )时罕见的死锁 修复了并发执行 `DROP/DETACH TABLE` 时 `Table ... does not exist` 的 `DROP/DETACH DATABASE` 失败 `. [#15934](https://github.com/ClickHouse/ClickHouse/pull/15934) ([tavplubix](https://github.com/tavplubix)).
* 如果查询具有 `WHERE`、`PREWHERE` 和 `GLOBAL IN`, 则修复来自 `Distributed` 表的查询的错误空结果. 修复 [#15792](https://github.com/ClickHouse/ClickHouse/issues/15792). [#15933](https://github.com/ClickHouse/ClickHouse/pull/15933) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* 修复 RBAC 中可能的死锁. [#15875](https://github.com/ClickHouse/ClickHouse/pull/15875) ([Vitaly Baranov](https://github.com/vitlibar)).
* 修复在 `ALTER MODIFY COLUMN` 查询之后执行的 `SELECT ... ORDER BY DESC` 查询中的异常 `Block structure mismatch` . 修复 [#15800](https://github.com/ClickHouse/ClickHouse/issues/15800). [#15852](https://github.com/ClickHouse/ClickHouse/pull/15852) ([alesapin](https://github.com/alesapin)).
* 修复 MaterializeMySQL 的 `select count()` 不准确. [#15767](https://github.com/ClickHouse/ClickHouse/pull/15767) ([tavplubix](https://github.com/tavplubix)).
* 修复某些查询情况, 其中仅选择虚拟列. 以前可能会抛出 `Not found column _nothing in block` 异常. 修复 [#12298](https://github.com/ClickHouse/ClickHouse/issues/12298). [#15756](https://github.com/ClickHouse/ClickHouse/pull/15756) ([Anton Popov](https://github.com/CurtizJ)).
* 修复了 `max_replicated_logs_to_keep` 设置的默认值过低, 这可能导致副本过于频繁地丢失. 通过选择要克隆的最新副本来改进丢失的副本恢复过程. 也不要从丢失的复制品中取出旧零件, 而是将它们拆下. [#15701](https://github.com/ClickHouse/ClickHouse/pull/15701) ([tavplubix](https://github.com/tavplubix)).
* 修复错误 `Cannot add simple transform to empty Pipe` ，该错误在从与目标表结构不同的 `Buffer` 表中读取时发生. 如果目标表返回空的查询结果是可能的. 修复 [#15529](https://github.com/ClickHouse/ClickHouse/issues/15529). [#15662](https://github.com/ClickHouse/ClickHouse/pull/15662) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* 修复了 S3 表函数中的 globs 错误，URL 中的区域未应用于 S3 客户端配置. [#15646](https://github.com/ClickHouse/ClickHouse/pull/15646) ([Vladimir Chebotarev](https://github.com/excitoon)).
* 分离只读表时递减 `ReadonlyReplica` 指标. 这修复了 [#15598](https://github.com/ClickHouse/ClickHouse/issues/15598). [#15592](https://github.com/ClickHouse/ClickHouse/pull/15592) ([sundyli](https://github.com/sundy-li)).
* 将单个参数传递给 ReplicatedMergeTree 而不是忽略它时抛出错误. [#15516](https://github.com/ClickHouse/ClickHouse/pull/15516) ([nvartolomei](https://github.com/nvartolomei)).

#### 改进

* 现在, 无论集群配置中的 `<internal_replication>` 设置如何，都可以执行 `ALTER ... ON CLUSTER` 查询. [#16075](https://github.com/ClickHouse/ClickHouse/pull/16075) ([alesapin](https://github.com/alesapin)).
* 在创建表时在 `ReplicatedMergeTree` 参数中展开 `{database}`、`{table}` 和 `{uuid}` 宏. [#16160](https://github.com/ClickHouse/ClickHouse/pull/16160) ([tavplubix](https://github.com/tavplubix)).


### ClickHouse 版本 v20.9.3.45-stable (2020-10-09)

#### Bug 修复

* 修复错误 `Cannot find column` , 如果对 `MV` 的查询包含 `ARRAY JOIN` , 则在插入` MATERIALIZED VIEW` 时可能会发生该错误. [#15717](https://github.com/ClickHouse/ClickHouse/pull/15717) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* 修复 AMQP-CPP 中的竞争条件. [#15667](https://github.com/ClickHouse/ClickHouse/pull/15667) ([alesapin](https://github.com/alesapin)).
* 修复查询计划的 ReadFromStorage 步骤中资源的销毁顺序. 在极少数情况下, 它可能会导致崩溃. 可能与[#15610](https://github.com/ClickHouse/ClickHouse/issues/15610)有关. [#15645](https://github.com/ClickHouse/ClickHouse/pull/15645) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* 修复了使用 `JSON*` 函数时会导致 `VALUES`、`LIMIT`或 `IN` 运算符右侧的 `Element ... is not a constant expression` 错误. [#15589](https://github.com/ClickHouse/ClickHouse/pull/15589) ([tavplubix](https://github.com/tavplubix)).
* 防止出现错误消息 `Could not calculate available disk space (statvfs), errno: 4, strerror: Interrupted system call` 的可能性. 这修复了 [#15541](https://github.com/ClickHouse/ClickHouse/issues/15541). [#15557](https://github.com/ClickHouse/ClickHouse/pull/15557) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 显著减少 AggregatingInOrderTransform/optimize_aggregation_in_order 中的内存使用. [#15543](https://github.com/ClickHouse/ClickHouse/pull/15543) ([Azat Khuzhin](https://github.com/azat)).
* Mutation 可能会在 `MOVE` 或 `REPLACE PARTITION` 之后等待一些不存在的部分, 或者在极少数情况下, 在 `DETACH` 或 `DROP PARTITION` 之后挂起. 已修复. [#15537](https://github.com/ClickHouse/ClickHouse/pull/15537) ([tavplubix](https://github.com/tavplubix)).
* 修复如果执行具有相同模式的 `LIKE` , 则 `LIKE` 运算符不再区分大小写的错误. [#15536](https://github.com/ClickHouse/ClickHouse/pull/15536) ([alesapin](https://github.com/alesapin)).
* 在选择数据中不存在但依赖于数据中也不存在的其他列时修复 `Missing columns` 错误. 修复 [#15530](https://github.com/ClickHouse/ClickHouse/issues/15530). [#15532](https://github.com/ClickHouse/ClickHouse/pull/15532) ([alesapin](https://github.com/alesapin)).
* 修复了 DDLWorker 中事件订阅的错误, 该错误很少会导致查询在 `ON CLUSTER` 中挂起. 引入 [#13450](https://github.com/ClickHouse/ClickHouse/issues/13450). [#15477](https://github.com/ClickHouse/ClickHouse/pull/15477) ([alesapin](https://github.com/alesapin)).
* 当 `boundingRatio` 聚合函数的第二个参数类型错误时报告正确的错误. [#15407](https://github.com/ClickHouse/ClickHouse/pull/15407) ([detailyang](https://github.com/detailyang)).
* 修复诸如 `SELECT toStartOfDay(today())` 之类的查询失败抱怨空 time_zone 参数的错误. [#15319](https://github.com/ClickHouse/ClickHouse/pull/15319) ([Bharat Nallan](https://github.com/bharatnc)).
* 修复合并树表重命名和背景清理过程中的竞争条件. [#15304](https://github.com/ClickHouse/ClickHouse/pull/15304) ([alesapin](https://github.com/alesapin)).
* 修复启用 system.logs 时服务器启动时罕见的竞争条件. [#15300](https://github.com/ClickHouse/ClickHouse/pull/15300) ([alesapin](https://github.com/alesapin)).
* 修复 QueryLog 中的 MSan 报告. 未初始化的内存可用于 `memory_usage` 字段. [#15258](https://github.com/ClickHouse/ClickHouse/pull/15258) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 修复将 joinGet 与 LowCardinality 类型一起使用时的实例崩溃. 这修复了 [#15214](https://github.com/ClickHouse/ClickHouse/issues/15214). [#15220](https://github.com/ClickHouse/ClickHouse/pull/15220) ([Amos Bird](https://github.com/amosbird)).
* 修复表引擎 `Buffer` 中的错误, 该错误不允许在 `ALTER` 查询后将新结构的数据插入到 `Buffer` 中. 修复 [#15117](https://github.com/ClickHouse/ClickHouse/issues/15117). [#15192](https://github.com/ClickHouse/ClickHouse/pull/15192) ([alesapin](https://github.com/alesapin)).
* 调整mysql列定义包中的decimals字段大小. [#15152](https://github.com/ClickHouse/ClickHouse/pull/15152) ([maqroll](https://github.com/maqroll)).
* 修复了在 Mac OS 上的 docker 中运行 clickhouse-server 时, 在原子数据库中执行 DDL 查询时出现的 `Cannot rename ... errno: 22, strerror: Invalid argument` 错误. [#15024](https://github.com/ClickHouse/ClickHouse/pull/15024) ([tavplubix](https://github.com/tavplubix)).
* 修复了当子查询包含 finalizeAggregation 函数时使谓词下推工作的问题.修复 [#14847](https://github.com/ClickHouse/ClickHouse/issues/14847). [#14937](https://github.com/ClickHouse/ClickHouse/pull/14937) ([filimonov](https://github.com/filimonov)).
* 如果必须从 ZK 获取配置文件 (使用 `from_zk` 包含选项), 则修复服务器在与 ZooKeeper 交谈时可能会在启动时卡住的问题. 这修复了 [#14814](https://github.com/ClickHouse/ClickHouse/issues/14814). [#14843](https://github.com/ClickHouse/ClickHouse/pull/14843) ([Alexander Kuzmenkov](https://github.com/akuzm)).

#### 改进

* 现在可以使用 `ALTER` 查询更改 `VersionedCollapsingMergeTree` 的版本列的类型. [#15442](https://github.com/ClickHouse/ClickHouse/pull/15442) ([alesapin](https://github.com/alesapin)).


### ClickHouse 版本 v20.9.2.20, 2020-09-22

#### 向后不兼容变更

* 从20.5以上的版本升级时, 如果进行滚动更新, 集群同时包含20.5以上和20.5以下的版本, 如果旧版本的ClickHouse节点重启, 旧版本在新版本存在的情况下启动, 可能会导致 到 `Part ... intersects previous part` 错误. 为防止出现此错误, 首先在所有集群节点上安装更新的 clickhouse-server 软件包, 然后重新启动 (因此, 当 clickhouse-server 重新启动时, 它将以新版本启动).

#### 新特征

* 添加了列转换器`EXCEPT`、`REPLACE`、`APPLY`, 可以应用于所选列的列表 (在`*` 或`COLUMNS(...)` 之后). 例如, 您可以编写 `SELECT * EXCEPT(URL) REPLACE(number + 1 AS number)`. 另一个例子: `select * apply(length) apply(max) from wide_string_table` 找出所有字符串列的最大长度. [#14233](https://github.com/ClickHouse/ClickHouse/pull/14233) ([Amos Bird](https://github.com/amosbird)).
* 添加了一个聚合函数 `rankCorr`, 用于计算秩相关系数. [#11769](https://github.com/ClickHouse/ClickHouse/pull/11769) ([antikvist](https://github.com/antikvist)) [#14411](https://github.com/ClickHouse/ClickHouse/pull/14411) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* 添加了表函数 `view`, 它将子查询转换为表对象. 这有助于传递查询. 例如, 它可以用于远程/集群表功能. [#12567](https://github.com/ClickHouse/ClickHouse/pull/12567) ([Amos Bird](https://github.com/amosbird)).

#### Bug 修复

* 修复了在赋值表达式和常量值 (如 `UPDATE x = 42` )中使用 Nullable 列的 `ALTER UPDATE` 突变导致列或段错误中的值不正确时的错误. 修复[#13634](https://github.com/ClickHouse/ClickHouse/issues/13634), [#14045](https://github.com/ClickHouse/ClickHouse/issues/14045). [#14646](https://github.com/ClickHouse/ClickHouse/pull/14646) ([alesapin](https://github.com/alesapin)).
* 修复了错误的十进制乘法结果导致结果列小数位数错误. [#14603](https://github.com/ClickHouse/ClickHouse/pull/14603) ([Artem Zuikov](https://github.com/4ertus2)).
* 修复了 `Nullable` 列不正确的排序顺序. 这修复了 [#14344](https://github.com/ClickHouse/ClickHouse/issues/14344). [#14495](https://github.com/ClickHouse/ClickHouse/pull/14495) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* 修复了索引分析中与类型为 `FixedString` 的主键的比较不一致的问题, 如果它们与较小的字符串进行比较. 这修复了 [#14908](https://github.com/ClickHouse/ClickHouse/issues/14908). [#15033](https://github.com/ClickHouse/ClickHouse/pull/15033) ([Amos Bird](https://github.com/amosbird)).
* 修复了如果表具有单个部分的分区会导致错误的合并分配的错误. [#14444](https://github.com/ClickHouse/ClickHouse/pull/14444) ([alesapin](https://github.com/alesapin)).
* 如果使用专门设计的参数调用函数 `bar`, 则可能会发生缓冲区溢出. 这将关闭 [#13926](https://github.com/ClickHouse/ClickHouse/issues/13926). [#15028](https://github.com/ClickHouse/ClickHouse/pull/15028) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 在 `system.asynchronous_metrics` 中发布每个逻辑核心的 CPU 频率. 这修复了 [#14923](https://github.com/ClickHouse/ClickHouse/issues/14923). [#14924](https://github.com/ClickHouse/ClickHouse/pull/14924) ([Alexander Kuzmenkov](https://github.com/akuzm)).
* 修复了使用 `MaterializeMySQL` 数据库引擎时 `.metadata.tmp File exists` 的错误. [#14898](https://github.com/ClickHouse/ClickHouse/pull/14898) ([Winter Zhang](https://github.com/zhang2014)).
* 修复部分调用 `extractAllGroups` 函数可能触发 `Memory limit exceeded` 错误的问题. 这修复了 [#13383](https://github.com/ClickHouse/ClickHouse/issues/13383). [#14889](https://github.com/ClickHouse/ClickHouse/pull/14889) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 修复 SIGSEGV 以尝试插入 StorageFile(fd). [#14887](https://github.com/ClickHouse/ClickHouse/pull/14887) ([Azat Khuzhin](https://github.com/azat)).
* 当被查询的列具有 `DEFAULT` 表达式时, 修复 `SELECT` 查询中的罕见错误, 该表达式依赖于另一列, 该列也具有 `DEFAULT` 并且不存在于选择查询中且不存在于磁盘上. 部分修复 [#14531](https://github.com/ClickHouse/ClickHouse/issues/14531). [#14845](https://github.com/ClickHouse/ClickHouse/pull/14845) ([alesapin](https://github.com/alesapin)).
* 修复了收缩的`Int -> Int` 签名类型转换的错误单调性检测. 可能会导致查询结果不正确. 此错误在 [#14513](https://github.com/ClickHouse/ClickHouse/issues/14513) 中公布. [#14783](https://github.com/ClickHouse/ClickHouse/pull/14783) ([Amos Bird](https://github.com/amosbird)).
* 修复了执行 `ALTER ... MODIFY QUERY` 时物化视图元数据中丢失的默认数据库名称. [#14664](https://github.com/ClickHouse/ClickHouse/pull/14664) ([tavplubix](https://github.com/tavplubix)).
* 修复当涉及 LowCardinality 和 Nullable 类型时函数 `has` 可能不正确的结果. [#14591](https://github.com/ClickHouse/ClickHouse/pull/14591) ([Mike](https://github.com/myrrc)).
* 在使用 ReplicatedMergeTree Engine 对表进行 CREATE 查询期间, 在 Zookeeper 异常后清理数据目录. [#14563](https://github.com/ClickHouse/ClickHouse/pull/14563) ([Bharat Nallan](https://github.com/bharatnc)).
* 修复带有组合子 `-Resample` 的函数中罕见的段错误, 这可能会出现在参数非常大的溢出结果中. [#14562](https://github.com/ClickHouse/ClickHouse/pull/14562) ([Anton Popov](https://github.com/CurtizJ)).
* 检查 `topK` 聚合函数中的数组大小溢出. 如果没有此检查, 用户可能会发送带有精心设计的参数的查询, 这将导致服务器崩溃. 这将关闭 [#14452](https://github.com/ClickHouse/ClickHouse/issues/14452). [#14467](https://github.com/ClickHouse/ClickHouse/pull/14467) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 代理重启/启动/停止/重新加载 SysVinit 到 systemd (如果使用). [#14460](https://github.com/ClickHouse/ClickHouse/pull/14460) ([Azat Khuzhin](https://github.com/azat)).
* 如果 PipelineExecutor 本身发生异常, 则停止查询执行. 这可以防止罕见的查询挂起. [#14334](https://github.com/ClickHouse/ClickHouse/pull/14334) [#14402](https://github.com/ClickHouse/ClickHouse/pull/14402) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* 修复在创建为 `AS table_function` 的表的 `ALTER` 查询期间崩溃. 修复 [#14212](https://github.com/ClickHouse/ClickHouse/issues/14212). [#14326](https://github.com/ClickHouse/ClickHouse/pull/14326) ([alesapin](https://github.com/alesapin)).
* 使用 REFRESH 命令修复 ALTER LIVE VIEW 查询期间的异常. LIVE VIEW 是一项实验性功能. [#14320](https://github.com/ClickHouse/ClickHouse/pull/14320) ([Bharat Nallan](https://github.com/bharatnc)).
* 修复带有嵌套解释器的查询的 QueryPlan 生命周期 (对于 EXPLAIN PIPELINE graph=1). [#14315](https://github.com/ClickHouse/ClickHouse/pull/14315) ([Azat Khuzhin](https://github.com/azat)).
* 更好地检查 SSD 缓存复杂键外部字典中的元组大小. 这修复了 [#13981](https://github.com/ClickHouse/ClickHouse/issues/13981). [#14313](https://github.com/ClickHouse/ClickHouse/pull/14313) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 在 `ALIAS` 列类型上不允许使用 `CODEC` . 修复[#13911](https://github.com/ClickHouse/ClickHouse/issues/13911). [#14263](https://github.com/ClickHouse/ClickHouse/pull/14263) ([Bharat Nallan](https://github.com/bharatnc)).
* 在非全局级别执行时修复 GRANT ALL 语句. [#13987](https://github.com/ClickHouse/ClickHouse/pull/13987) ([Vitaly Baranov](https://github.com/vitlibar)).
* 修复 lambda 中的 arrayJoin() 捕获 (抛出逻辑错误消息的异常). [#13792](https://github.com/ClickHouse/ClickHouse/pull/13792) ([Azat Khuzhin](https://github.com/azat)).

#### 实验功能

* 通过给定的 SELECT 查询添加了用于随机数据库生成的 `db-generator` 工具. 当用户只有不完整的错误报告时, 它可能有助于重现问题. [#14442](https://github.com/ClickHouse/ClickHouse/pull/14442) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)) [#10973](https://github.com/ClickHouse/ClickHouse/issues/10973) ([ZeDRoman](https://github.com/ZeDRoman)).

#### 改进

* 允许在分布式存储中使用多卷存储配置. [#14839](https://github.com/ClickHouse/ClickHouse/pull/14839) ([Pavel Kovalenko](https://github.com/Jokser)).
* 禁止在 `toStartOf*` 类型的函数中使用空的 time_zone 参数. [#14509](https://github.com/ClickHouse/ClickHouse/pull/14509) ([Bharat Nallan](https://github.com/bharatnc)).
* MySQL 处理程序为诸如 `SET @@var = value` 之类的查询返回 `OK`. 此类声明被忽略. 这是必需的, 因为某些 MySQL 驱动程序会在握手后发送 `SET @@` 查询以进行设置 https://github.com/ClickHouse/ClickHouse/issues/9336#issuecomment-686222422 . [#14469](https://github.com/ClickHouse/ClickHouse/pull/14469) ([BohuTANG](https://github.com/BohuTANG)).
* 现在, 如果之前没有实现 TTL, 将在合并期间应用它们. [#14438](https://github.com/ClickHouse/ClickHouse/pull/14438) ([alesapin](https://github.com/alesapin)).
* 现在 `clickhouse-obfuscator` 支持 [#13163](https://github.com/ClickHouse/ClickHouse/issues/13163) 中提出的 UUID 类型. [#14409](https://github.com/ClickHouse/ClickHouse/pull/14409) ([dimarub2000](https://github.com/dimarub2000)).
* 添加了 [#11384](https://github.com/ClickHouse/ClickHouse/issues/11384) 中提出的新设置 `system_events_show_zero_values`. [#14404](https://github.com/ClickHouse/ClickHouse/pull/14404) ([dimarub2000](https://github.com/dimarub2000)).
* 在 `MaterializeMySQL` 中将主键隐式转换为非空 (与 `MySQL` 相同). 修复 [#14114](https://github.com/ClickHouse/ClickHouse/issues/14114). [#14397](https://github.com/ClickHouse/ClickHouse/pull/14397) ([Winter Zhang](https://github.com/zhang2014)).
* 用 https://github.com/cerevra/int 的实现替换 boost multiprecision 中的宽整数 (256 位). 256 位整数是实验性的. [#14229](https://github.com/ClickHouse/ClickHouse/pull/14229) ([Artem Zuikov](https://github.com/4ertus2)).
* 为 `system.part_log` 中的部分添加默认压缩编解码器, 名称为 `default_compression_codec`. [#14116](https://github.com/ClickHouse/ClickHouse/pull/14116) ([alesapin](https://github.com/alesapin)).
* 为`DateTime` 类型添加精度参数. 它允许使用 `DateTime` 名称代替 `DateTime64`. [#13761](https://github.com/ClickHouse/ClickHouse/pull/13761) ([Winter Zhang](https://github.com/zhang2014)).
* 为 Redis 外部字典添加了 requirepass 授权. [#13688](https://github.com/ClickHouse/ClickHouse/pull/13688) ([Ivan Torgashov](https://github.com/it1804)).
* RabbitMQ 引擎的改进: 添加了连接和通道故障处理、正确提交、插入故障处理、更好的交换、队列持久性和队列恢复机会、新的队列设置. 固定测试. [#12761](https://github.com/ClickHouse/ClickHouse/pull/12761) ([Kseniia Sumarokova](https://github.com/kssenii)).
* 支持紧凑部分的自定义编解码器. [#12183](https://github.com/ClickHouse/ClickHouse/pull/12183) ([Anton Popov](https://github.com/CurtizJ)).

#### 性能改进

* 使用 LIMIT/LIMIT BY/ORDER BY 优化查询以使用 GROUP BY sharding_key (在 `optimize_skip_unused_shards` 和 `optimize_distributed_group_by_sharding_key` 下). [#10373](https://github.com/ClickHouse/ClickHouse/pull/10373) ([Azat Khuzhin](https://github.com/azat)).
* 为多个 `JOIN` 和 `IN` 并行创建集合. 它可能会稍微提高具有几种不同 `IN subquery` 表达式的查询的性能. [#14412](https://github.com/ClickHouse/ClickHouse/pull/14412) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* 通过为每个消费者提供独立线程来提高 Kafka 引擎性能. 流引擎的单独线程池 (如 Kafka). [#13939](https://github.com/ClickHouse/ClickHouse/pull/13939) ([fastio](https://github.com/fastio)).

#### 构建/测试/打包改进

* 通过从 `Functions` 中删除调试信息来降低调试构建中的二进制大小. 只有 Yandex 中使用非常旧的链接器的一个内部项目才需要这样做. [#14549](https://github.com/ClickHouse/ClickHouse/pull/14549) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 准备使用 clang 11 进行构建. [#14455](https://github.com/ClickHouse/ClickHouse/pull/14455) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 修复反向移植脚本中的逻辑. 在以前的版本中, 任何 100% 红色的标签都会触发它. 这很奇怪. [#14433](https://github.com/ClickHouse/ClickHouse/pull/14433) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 集成测试使用默认的基本配置. 所有配置更改都是显式的, 例如 main_configs、user_configs 和字典参数. [#13647](https://github.com/ClickHouse/ClickHouse/pull/13647) ([Ilya Yatsishin](https://github.com/qoega)).



## ClickHouse 版本 20.8

### ClickHouse 版本 v20.8.12.2-lts, 2021-01-16

#### Bug 修复

* 修复 *If 具有一元函数和 Nullable 类型的组合器. [#18806](https://github.com/ClickHouse/ClickHouse/pull/18806) ([Azat Khuzhin](https://github.com/azat)).
* 限制从宽部分合并到紧凑部分. 在垂直合并的情况下, 它会导致结果部分损坏. [#18381](https://github.com/ClickHouse/ClickHouse/pull/18381) ([Anton Popov](https://github.com/CurtizJ)).


### ClickHouse 版本 v20.8.11.17-lts, 2020-12-25

#### Bug 修复

* 在合并期间禁用 AIO 写入, 因为它会导致合并期间主键列的数据损坏极为罕见. [#18481](https://github.com/ClickHouse/ClickHouse/pull/18481) ([alesapin](https://github.com/alesapin)).
* 修复了在使用类型为 Nullable(String) 的参数执行 `toType(...)` 函数 (`toDate`、`toUInt32` 等) 时出现的 `value is too short` 错误. 现在这些函数在解析错误时返回 `NULL` 而不是抛出异常. 修复 [#7673](https://github.com/ClickHouse/ClickHouse/issues/7673). [#18445](https://github.com/ClickHouse/ClickHouse/pull/18445) ([tavplubix](https://github.com/tavplubix)).
* 使用组合子 `Distinct` 修复聚合函数中可能的崩溃, 同时使用两级聚合. 修复 [#17682](https://github.com/ClickHouse/ClickHouse/issues/17682). [#18365](https://github.com/ClickHouse/ClickHouse/pull/18365) ([Anton Popov](https://github.com/CurtizJ)).


### ClickHouse 版本 v20.8.10.13-lts, 2020-12-24

#### Bug 修复

* 当使用 `logger.size` 参数配置服务器日志轮换并且数值大于 2^32 时, 日志没有正确轮换. [#17905](https://github.com/ClickHouse/ClickHouse/pull/17905) ([Alexander Kuzmenkov](https://github.com/akuzm)).
* 使用 `min_compress_block_size` 修复了 MergeTreeWriterSettings 中 `max_compress_block_size` 的错误初始化. [#17833](https://github.com/ClickHouse/ClickHouse/pull/17833) ([flynn](https://github.com/ucasFL)).
* 修复了 ClickHouse 无法恢复与 MySQL 服务器的连接时的问题. [#17681](https://github.com/ClickHouse/ClickHouse/pull/17681) ([Alexander Kazakov](https://github.com/Akazz)).
* 修复了在不同副本上杀死相应突变时的“ALTER”查询挂起. 这修复了 [#16953](https://github.com/ClickHouse/ClickHouse/issues/16953). [#17499](https://github.com/ClickHouse/ClickHouse/pull/17499) ([alesapin](https://github.com/alesapin)).
* 修复了 ClickHouse 低估标记缓存大小时的错误. 当有很多带有标记的小文件时可能会发生. [#17496](https://github.com/ClickHouse/ClickHouse/pull/17496) ([alesapin](https://github.com/alesapin)).
* 修复了启用设置 `optimize_redundant_functions_in_order_by` 的 `ORDER BY` . [#17471](https://github.com/ClickHouse/ClickHouse/pull/17471) ([Anton Popov](https://github.com/CurtizJ)).
* 修复了导致崩溃的 `ColumnConst` 比较. 这个修复了 [#17088](https://github.com/ClickHouse/ClickHouse/issues/17088). [#17135](https://github.com/ClickHouse/ClickHouse/pull/17135) ([Amos Bird](https://github.com/amosbird)).
* 修复了非领导者 ReplicatedMergeTreeTables 的`ON CLUSTER` 查询可能永远挂起的错误. [#17089](https://github.com/ClickHouse/ClickHouse/pull/17089) ([alesapin](https://github.com/alesapin)).
* 避免远程查询的不必要的网络错误, 这些错误在执行时可能会被取消, 例如使用 `LIMIT` 的查询. [#17006](https://github.com/ClickHouse/ClickHouse/pull/17006) ([Azat Khuzhin](https://github.com/azat)).
* 出现错误时解析 `format_avro_schema_registry_url` 的IP. [#16985](https://github.com/ClickHouse/ClickHouse/pull/16985) ([filimonov](https://github.com/filimonov)).
* 修复了在 `ALTER TABLE ... MODIFY COLUMN ... NewType` 之后, 当 `SELECT` 在更改列上具有 `WHERE` 表达式并且更改尚未完成时可能出现的服务器崩溃. [#16968](https://github.com/ClickHouse/ClickHouse/pull/16968) ([Amos Bird](https://github.com/amosbird)).
* 安装脚本应始终在 config 文件夹中创建子目录. 这仅与使用自定义配置的 Docker 构建相关. [#16936](https://github.com/ClickHouse/ClickHouse/pull/16936) ([filimonov](https://github.com/filimonov)).
* 修复了使用 `ORDER BY` 的查询可能出现的错误 `Illegal type of argument` 。 修复 [#16580](https://github.com/ClickHouse/ClickHouse/issues/16580). [#16928](https://github.com/ClickHouse/ClickHouse/pull/16928) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* 如果没有数据写入 WriteBufferFromS3，则中止分段上传. [#16840](https://github.com/ClickHouse/ClickHouse/pull/16840) ([Pavel Kovalenko](https://github.com/Jokser)).
* 修复了在不带任何参数的情况下使用 `any` 时的崩溃问题. 这修复了 [#16803](https://github.com/ClickHouse/ClickHouse/issues/16803). [#16826](https://github.com/ClickHouse/ClickHouse/pull/16826) ([Amos Bird](https://github.com/amosbird)).
* 修复了多个列和元组上的 `IN` 运算符, 启用了 `transform_null_in` 设置. 修复 [#15310](https://github.com/ClickHouse/ClickHouse/issues/15310). [#16722](https://github.com/ClickHouse/ClickHouse/pull/16722) ([Anton Popov](https://github.com/CurtizJ)).
* 修复了 `optimize_read_in_order/optimize_aggregation_in_order` 的不一致行为, max_threads > 0 和 ORDER BY 中的表达式. [#16637](https://github.com/ClickHouse/ClickHouse/pull/16637) ([Azat Khuzhin](https://github.com/azat)).
* 修复了查询包含`ARRAY JOIN`时查询优化产生错误结果的问题. [#17887](https://github.com/ClickHouse/ClickHouse/pull/17887) ([sundyli](https://github.com/sundy-li)).
* 在异常的情况下查询完成得更快. 如果发生异常, 取消对远程副本的执行. [#15578](https://github.com/ClickHouse/ClickHouse/pull/15578) ([Azat Khuzhin](https://github.com/azat)).


### ClickHouse 版本 v20.8.6.6-lts, 2020-11-13

#### Bug 修复

* 当查询分析器打开并且 ClickHouse 安装在操作系统上时, 修复罕见的无声崩溃, glibc 版本已经 (据说) 损坏了某些功能的异步展开表. 这修复了 [#15301](https://github.com/ClickHouse/ClickHouse/issues/15301). 这修复了 [#13098](https://github.com/ClickHouse/ClickHouse/issues/13098). [#16846](https://github.com/ClickHouse/ClickHouse/pull/16846) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 现在, 当从输入解析 AVRO 时, LowCardinality 将从类型中删除. 修复 [#16188](https://github.com/ClickHouse/ClickHouse/issues/16188). [#16521](https://github.com/ClickHouse/ClickHouse/pull/16521) ([Mike](https://github.com/myrrc)).
* 通过适当缩小 GTID 集，修复使用 MySQL Master -> MySQL Slave -> ClickHouse MaterializeMySQL Engine 和 MySQL Slave 上启用的 `slave_parallel_worker` 时元数据的快速增长. 这修复了 [#15951](https://github.com/ClickHouse/ClickHouse/issues/15951). [#16504](https://github.com/ClickHouse/ClickHouse/pull/16504) ([TCeason](https://github.com/TCeason)).
* 修复分布式的 DROP TABLE (使用 INSERT). [#16409](https://github.com/ClickHouse/ClickHouse/pull/16409) ([Azat Khuzhin](https://github.com/azat)).
* 修复了复制队列中非常大的条目的处理. 如果表结构非常大 (接近 1 MB), 则非常大的条目可能会出现在 ALTER 查询中. 这修复了 [#16307](https://github.com/ClickHouse/ClickHouse/issues/16307). [#16332](https://github.com/ClickHouse/ClickHouse/pull/16332) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 修复了由于未创建过滤集而可能删除部分返回数据时的不一致行为. [#16308](https://github.com/ClickHouse/ClickHouse/pull/16308) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* 修复 MySQL 数据库的错误. 当用作数据库引擎的 MySQL 服务器关闭时, 某些查询会引发异常, 因为它们试图从禁用的服务器获取表, 而这是不必要的. 例如, 查询 `SELECT ... FROM system.parts` 应该只适用于 MergeTree 表并且根本不要接触 MySQL 数据库. [#16032](https://github.com/ClickHouse/ClickHouse/pull/16032) ([Kruglov Pavel](https://github.com/Avogar)).


### ClickHouse 版本 v20.8.5.45-lts, 2020-10-29

#### Bug 修复

* 在函数 `dictGet` 出现异常时修复double free. 如果字典加载错误, 可能会发生这种情况. [#16429](https://github.com/ClickHouse/ClickHouse/pull/16429) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* 修复由总数/汇总/多维数据集修饰符和最小/最大功能按键分组. 修复 [#16393](https://github.com/ClickHouse/ClickHouse/issues/16393). [#16397](https://github.com/ClickHouse/ClickHouse/pull/16397) ([Anton Popov](https://github.com/CurtizJ)).
* 修复异步分布式插入 w/prefer_localhost_replica=0 和 internal_replication. [#16358](https://github.com/ClickHouse/ClickHouse/pull/16358) ([Azat Khuzhin](https://github.com/azat)).
* 修复了在使用字符串键的 `GROUP BY` 期间可能出现的内存泄漏, 这是由 `TwoLevelStringHashTable` 实现中的错误引起的. [#16264](https://github.com/ClickHouse/ClickHouse/pull/16264) ([Amos Bird](https://github.com/amosbird)).
* 修复无论限制如何都可以过度分配内存的情况. 这将关闭 [#14560](https://github.com/ClickHouse/ClickHouse/issues/14560). [#16206](https://github.com/ClickHouse/ClickHouse/pull/16206) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 修复` ReplicatedVersionedCollapsingMergeTree` 的 `ALTER MODIFY ... ORDER BY` 查询挂起。 这修复了 [#15980](https://github.com/ClickHouse/ClickHouse/issues/15980). [#16011](https://github.com/ClickHouse/ClickHouse/pull/16011) ([alesapin](https://github.com/alesapin)).
* 修复整理名称和字符集名称解析器并支持字符串类型的 `length = 0` . [#16008](https://github.com/ClickHouse/ClickHouse/pull/16008) ([Winter Zhang](https://github.com/zhang2014)).
* 允许对具有复杂键的字典使用直接布局. [#16007](https://github.com/ClickHouse/ClickHouse/pull/16007) ([Anton Popov](https://github.com/CurtizJ)).
* 在一段时间不活动后发生复制错误时, 防止副本挂起 5-10 分钟. [#15987](https://github.com/ClickHouse/ClickHouse/pull/15987) ([filimonov](https://github.com/filimonov)).
* 在插入或从 MaterializedView 中选择并同时删除目标表时修复罕见的段错误 (适用于原子数据库引擎). [#15984](https://github.com/ClickHouse/ClickHouse/pull/15984) ([tavplubix](https://github.com/tavplubix)).
* 修复解析设置配置文件时的歧义: `CREATE USER ... SETTINGS profile readonly` 现在被视为使用名为 `readonly` 的配置文件, 而不是名为 `profile` 的具有只读约束的设置. 这修复了 [#15628](https://github.com/ClickHouse/ClickHouse/issues/15628). [#15982](https://github.com/ClickHouse/ClickHouse/pull/15982) ([Vitaly Baranov](https://github.com/vitlibar)).
* 修复数据库创建失败时的崩溃. [#15954](https://github.com/ClickHouse/ClickHouse/pull/15954) ([Winter Zhang](https://github.com/zhang2014)).
* 修复了当表被并发重命名 (对于原子数据库引擎) 时, `DROP TABLE IF EXISTS` 失败并带有 `Table ... does not exist` 错误的问题. 修复了并发执行具有多个表的某些 DDL 查询 (如 `DROP DATABASE` 和 `RENAME TABLE` ) 时罕见的死锁, 修复了并发执行 `DROP/DETACH TABLE` 时 `Table ... does not exist` 的 `DROP/DETACH DATABASE` 失败 `. [#15934](https://github.com/ClickHouse/ClickHouse/pull/15934) ([tavplubix](https://github.com/tavplubix)).
* 如果查询具有`WHERE`、`PREWHERE` 和`GLOBAL IN`, 则修复来自`Distributed` 表的查询的错误空结果. 修复 [#15792](https://github.com/ClickHouse/ClickHouse/issues/15792). [#15933](https://github.com/ClickHouse/ClickHouse/pull/15933) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* 修复 RBAC 中可能的死锁. [#15875](https://github.com/ClickHouse/ClickHouse/pull/15875) ([Vitaly Baranov](https://github.com/vitlibar)).
* 修复在 `ALTER MODIFY COLUMN` 查询之后执行的 `SELECT ... ORDER BY DESC` 查询中的异常 `Block structure mismatch`. 修复 [#15800](https://github.com/ClickHouse/ClickHouse/issues/15800). [#15852](https://github.com/ClickHouse/ClickHouse/pull/15852) ([alesapin](https://github.com/alesapin)).
* 修复某些查询情况, 其中仅选择虚拟列. 以前可能会抛出 `Not found column _nothing in block` 异常. 修复 [#12298](https://github.com/ClickHouse/ClickHouse/issues/12298). [#15756](https://github.com/ClickHouse/ClickHouse/pull/15756) ([Anton Popov](https://github.com/CurtizJ)).
* 修复错误 `Cannot find column` , 如果对 `MV` 的查询包含 `ARRAY JOIN` , 则在插入 `MATERIALIZED VIEW` 时可能会发生该错误. [#15717](https://github.com/ClickHouse/ClickHouse/pull/15717) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* 修复了 `max_replicated_logs_to_keep` 设置的默认值过低, 这可能导致副本过于频繁地丢失. 通过选择要克隆的最新副本来改进丢失的副本恢复过程. 也不要从丢失的复制品中取出旧零件, 而是将它们拆下. [#15701](https://github.com/ClickHouse/ClickHouse/pull/15701) ([tavplubix](https://github.com/tavplubix)).
* 修复错误 `Cannot add simple transform to empty Pipe`, 该错误在从与目标表结构不同的 `Buffer` 表中读取时发生. 如果目标表返回空的查询结果是可能的. 修复 [#15529](https://github.com/ClickHouse/ClickHouse/issues/15529). [#15662](https://github.com/ClickHouse/ClickHouse/pull/15662) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* 修复了 S3 表函数中的 globs 错误, URL 中的区域未应用于 S3 客户端配置. [#15646](https://github.com/ClickHouse/ClickHouse/pull/15646) ([Vladimir Chebotarev](https://github.com/excitoon)).
* 分离只读表时递减 `ReadonlyReplica` 指标. 这修复了 [#15598](https://github.com/ClickHouse/ClickHouse/issues/15598). [#15592](https://github.com/ClickHouse/ClickHouse/pull/15592) ([sundyli](https://github.com/sundy-li)).
* 将单个参数传递给 ReplicatedMergeTree 而不是忽略它时抛出错误. [#15516](https://github.com/ClickHouse/ClickHouse/pull/15516) ([nvartolomei](https://github.com/nvartolomei)).

#### 改进

* 现在, 无论集群配置中的 `<internal_replication>` 设置如何, 都可以执行 `ALTER ... ON CLUSTER` 查询. [#16075](https://github.com/ClickHouse/ClickHouse/pull/16075) ([alesapin](https://github.com/alesapin)).
* 在创建表时在 `ReplicatedMergeTree` 参数中展开 `{database}`、`{table}` 和 `{uuid}` 宏. [#16159](https://github.com/ClickHouse/ClickHouse/pull/16159) ([tavplubix](https://github.com/tavplubix)).


### ClickHouse 版本 v20.8.4.11-lts, 2020-10-09

#### Bug 修复

* 修复查询计划的 `ReadFromStorage` 步骤中资源的销毁顺序. 在极少数情况下, 它可能会导致崩溃. 可能与[#15610](https://github.com/ClickHouse/ClickHouse/issues/15610)有关. [#15645](https://github.com/ClickHouse/ClickHouse/pull/15645) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* 修复了使用 `JSON*` 函数时会导致 `VALUES`、 `LIMIT` 或 `IN` 运算符右侧的 `Element ... is not a constant expression` 错误. [#15589](https://github.com/ClickHouse/ClickHouse/pull/15589) ([tavplubix](https://github.com/tavplubix)).
* 防止出现错误消息 `Could not calculate available disk space (statvfs), errno: 4, strerror: Interrupted system call` 的可能性. 这修复了 [#15541](https://github.com/ClickHouse/ClickHouse/issues/15541). [#15557](https://github.com/ClickHouse/ClickHouse/pull/15557) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 显著减少 AggregatingInOrderTransform/optimize_aggregation_in_order 中的内存使用. [#15543](https://github.com/ClickHouse/ClickHouse/pull/15543) ([Azat Khuzhin](https://github.com/azat)).
* Mutation 可能会在 `MOVE` 或 `REPLACE PARTITION` 之后等待一些不存在的部分, 或者在极少数情况下, 在 `DETACH` 或 `DROP PARTITION` 之后挂起. 已修复. [#15537](https://github.com/ClickHouse/ClickHouse/pull/15537) ([tavplubix](https://github.com/tavplubix)).
* 修复如果执行具有相同模式的 `ILIKE`, 则 `ILIKE` 运算符不再区分大小写的错误. [#15536](https://github.com/ClickHouse/ClickHouse/pull/15536) ([alesapin](https://github.com/alesapin)).
* 在选择数据中不存在但依赖于数据中也不存在的其他列时修复 `Missing columns` 错误. 修复 [#15530](https://github.com/ClickHouse/ClickHouse/issues/15530). [#15532](https://github.com/ClickHouse/ClickHouse/pull/15532) ([alesapin](https://github.com/alesapin)).
* 修复了 DDLWorker 中事件订阅的错误, 该错误很少会导致查询在“ON CLUSTER”中挂起. 引入 [#13450](https://github.com/ClickHouse/ClickHouse/issues/13450). [#15477](https://github.com/ClickHouse/ClickHouse/pull/15477) ([alesapin](https://github.com/alesapin)).
* 当 `boundingRatio` 聚合函数的第二个参数类型错误时报告正确的错误. [#15407](https://github.com/ClickHouse/ClickHouse/pull/15407) ([detailyang](https://github.com/detailyang)).
* 修复合并树表重命名和背景清理过程中的竞争条件. [#15304](https://github.com/ClickHouse/ClickHouse/pull/15304) ([alesapin](https://github.com/alesapin)).
* 修复启用 system.logs 时服务器启动时罕见的竞争条件. [#15300](https://github.com/ClickHouse/ClickHouse/pull/15300) ([alesapin](https://github.com/alesapin)).
* 修复 QueryLog 中的 MSan 报告. 未初始化的内存可用于字段 `memory_usage` . [#15258](https://github.com/ClickHouse/ClickHouse/pull/15258) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 修复将 joinGet 与 LowCardinality 类型一起使用时的实例崩溃. 这修复了 [#15214](https://github.com/ClickHouse/ClickHouse/issues/15214). [#15220](https://github.com/ClickHouse/ClickHouse/pull/15220) ([Amos Bird](https://github.com/amosbird)).
* 修复表引擎 `Buffer` 中的错误, 该错误不允许在 `ALTER` 查询后将新结构的数据插入到 `Buffer` 中. 修复 [#15117](https://github.com/ClickHouse/ClickHouse/issues/15117). [#15192](https://github.com/ClickHouse/ClickHouse/pull/15192) ([alesapin](https://github.com/alesapin)).
* 调整mysql列定义包中的decimals字段大小. [#15152](https://github.com/ClickHouse/ClickHouse/pull/15152) ([maqroll](https://github.com/maqroll)).
* 我们已经在 String 和 FixedString 之间使用了填充比较  (https://github.com/ClickHouse/ClickHouse/blob/master/src/Functions/FunctionsComparison.h#L333) . 此 PR 将相同的逻辑应用于字段比较, 以更正 FixedString 作为主键的使用. 这修复了 [#14908](https://github.com/ClickHouse/ClickHouse/issues/14908). [#15033](https://github.com/ClickHouse/ClickHouse/pull/15033) ([Amos Bird](https://github.com/amosbird)).
* 如果使用专门设计的参数调用函数 `bar`, 则可能会发生缓冲区溢出. 这将关闭 [#13926](https://github.com/ClickHouse/ClickHouse/issues/13926). [#15028](https://github.com/ClickHouse/ClickHouse/pull/15028) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 修复了在 Mac OS 上的 docker 中运行 clickhouse-server 时, 在原子数据库中执行 DDL 查询时出现的 `Cannot rename ... errno: 22, strerror: Invalid argument` 错误. [#15024](https://github.com/ClickHouse/ClickHouse/pull/15024) ([tavplubix](https://github.com/tavplubix)).
* 现在设置 `number_of_free_entries_in_pool_to_execute_mutation` 和 `number_of_free_entries_in_pool_to_lower_max_size_of_merge` 可以等于 `background_pool_size`. [#14975](https://github.com/ClickHouse/ClickHouse/pull/14975) ([alesapin](https://github.com/alesapin)).
* 当子查询包含 finalizeAggregation 函数时, 修复使谓词下推工作. 修复 [#14847](https://github.com/ClickHouse/ClickHouse/issues/14847). [#14937](https://github.com/ClickHouse/ClickHouse/pull/14937) ([filimonov](https://github.com/filimonov)).
* 在 `system.asynchronous_metrics` 中发布每个逻辑核心的 CPU 频率. 这修复了 [#14923](https://github.com/ClickHouse/ClickHouse/issues/14923). [#14924](https://github.com/ClickHouse/ClickHouse/pull/14924) ([Alexander Kuzmenkov](https://github.com/akuzm)).
* 修复了使用 `MaterializeMySQL` 数据库引擎时 `.metadata.tmp File exists` 的错误. [#14898](https://github.com/ClickHouse/ClickHouse/pull/14898) ([Winter Zhang](https://github.com/zhang2014)).
* Fix a problem where the server may get stuck on startup while talking to ZooKeeper, if the configuration files have to be fetched from ZK (using the `from_zk` include option). This fixes [#14814](https://github.com/ClickHouse/ClickHouse/issues/14814). [#14843](https://github.com/ClickHouse/ClickHouse/pull/14843) ([Alexander Kuzmenkov](https://github.com/akuzm)).
* 修复了收缩的 `Int -> Int` 签名类型转换的错误单调性检测. 可能会导致查询结果不正确. 此错误在 [#14513](https://github.com/ClickHouse/ClickHouse/issues/14513) 中公布. [#14783](https://github.com/ClickHouse/ClickHouse/pull/14783) ([Amos Bird](https://github.com/amosbird)).
* 修复了 `Nullable` 列不正确的排序顺序. 这修复了 [#14344](https://github.com/ClickHouse/ClickHouse/issues/14344). [#14495](https://github.com/ClickHouse/ClickHouse/pull/14495) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).

#### 改进

* 现在可以使用 `ALTER` 查询更改 `VersionedCollapsingMergeTree` 的版本列的类型. [#15442](https://github.com/ClickHouse/ClickHouse/pull/15442) ([alesapin](https://github.com/alesapin)).


### ClickHouse 版本 v20.8.3.18-stable, 2020-09-18

#### Bug 修复

* 修复部分调用 `extractAllGroups` 函数可能触发“超出内存限制”错误的问题. 这修复了 [#13383](https://github.com/ClickHouse/ClickHouse/issues/13383). [#14889](https://github.com/ClickHouse/ClickHouse/pull/14889) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 修复 SIGSEGV 以尝试插入 StorageFile(fd). [#14887](https://github.com/ClickHouse/ClickHouse/pull/14887) ([Azat Khuzhin](https://github.com/azat)).
* 当被查询的列具有 `DEFAULT` 表达式时, 修复 `SELECT` 查询中的罕见错误, 该表达式依赖于另一列, 该列也具有“DEFAULT”并且不存在于选择查询中且不存在于磁盘上. 部分修复 [#14531](https://github.com/ClickHouse/ClickHouse/issues/14531). [#14845](https://github.com/ClickHouse/ClickHouse/pull/14845) ([alesapin](https://github.com/alesapin)).
* 修复了执行 `ALTER ... MODIFY QUERY` 时物化视图元数据中丢失的默认数据库名称. [#14664](https://github.com/ClickHouse/ClickHouse/pull/14664) ([tavplubix](https://github.com/tavplubix)).
* 修复了在赋值表达式和常量值 (如 `UPDATE x = 42`) 中使用 Nullable 列的 `ALTER UPDATE` 突变导致列或段错误中的值不正确时的错误. 修复 [#13634](https://github.com/ClickHouse/ClickHouse/issues/13634), [#14045](https://github.com/ClickHouse/ClickHouse/issues/14045). [#14646](https://github.com/ClickHouse/ClickHouse/pull/14646) ([alesapin](https://github.com/alesapin)).
* 修复错误的十进制乘法结果导致结果列小数位数错误. [#14603](https://github.com/ClickHouse/ClickHouse/pull/14603) ([Artem Zuikov](https://github.com/4ertus2)).
* 添加了检查器, 因为既不调用 `lc->isNullable()` 也不调用 `ls->getDictionaryPtr()->isNullable()` 将返回正确的结果. [#14591](https://github.com/ClickHouse/ClickHouse/pull/14591) ([myrrc](https://github.com/myrrc)).
* 在为 StorageReplicatedMergeTree 引擎创建查询期间 Zookeeper 异常后清理数据目录. [#14563](https://github.com/ClickHouse/ClickHouse/pull/14563) ([Bharat Nallan](https://github.com/bharatnc)).
* 使用组合器 -Resample 修复函数中罕见的段错误, 这可能会出现在参数非常大的溢出结果中. [#14562](https://github.com/ClickHouse/ClickHouse/pull/14562) ([Anton Popov](https://github.com/CurtizJ)).

#### 改进

* 如果有正在进行的 S3 请求, 则加快服务器关闭过程. [#14858](https://github.com/ClickHouse/ClickHouse/pull/14858) ([Pavel Kovalenko](https://github.com/Jokser)).
* 允许在分布式存储中使用多卷存储配置. [#14839](https://github.com/ClickHouse/ClickHouse/pull/14839) ([Pavel Kovalenko](https://github.com/Jokser)).
* 如果有正在进行的 S3 请求, 则加快服务器关闭过程. [#14496](https://github.com/ClickHouse/ClickHouse/pull/14496) ([Pavel Kovalenko](https://github.com/Jokser)).
* 支持紧凑部分的自定义编解码器. [#12183](https://github.com/ClickHouse/ClickHouse/pull/12183) ([Anton Popov](https://github.com/CurtizJ)).


### ClickHouse 版本 v20.8.2.3-stable, 2020-09-08

#### 向后不兼容变更

* 现在 `OPTIMIZE FINAL` 查询不会重新计算在创建 TTL 之前添加的部件的 TTL. 使用 `ALTER TABLE ... MATERIALIZE TTL` 一次来计算它们, 之后 `OPTIMIZE FINAL` 将正确评估TTL. 此行为从未适用于复制表. [#14220](https://github.com/ClickHouse/ClickHouse/pull/14220) ([alesapin](https://github.com/alesapin)).
* 扩展 `parallel_distributed_insert_select` 设置, 添加一个选项以将 `INSERT` 运行到本地表中. 该设置将类型从 `Bool` 更改为 `UInt64`, 因此不再支持值 `false` 和 `true`. 如果服务器配置中有这些值, 服务器将不会启动. 请将它们分别替换为 `0` 和 `1`. [#14060](https://github.com/ClickHouse/ClickHouse/pull/14060) ([Azat Khuzhin](https://github.com/azat)).
* 移除对 `ODBCDriver` 输入/输出格式的支持. 这是曾经用于与 ClickHouse ODBC 驱动程序通信的弃用格式, 现在早已被 `ODBCDriver2` 格式取代. 解决 [#13629](https://github.com/ClickHouse/ClickHouse/issues/13629). [#13847](https://github.com/ClickHouse/ClickHouse/pull/13847) ([hexiaoting](https://github.com/hexiaoting)).
* 从20.5以上的版本升级时, 如果进行滚动更新, 集群同时包含20.5以上和20.5以下的版本, 如果旧版本的ClickHouse节点重启, 旧版本在新版本存在的情况下启动, 可能会导致 `Part ... intersects previous part` 错误. 为防止出现此错误, 首先在所有集群节点上安装更新的 clickhouse-server 软件包, 然后重新启动 (因此，当 clickhouse-server 重新启动时, 它将以新版本启动).

#### 新特征

* 添加为与 `config.xml` 中指定的设置相对应的列指定 `Default` 压缩编解码器的功能. 实现: [#9074](https://github.com/ClickHouse/ClickHouse/issues/9074). [#14049](https://github.com/ClickHouse/ClickHouse/pull/14049) ([alesapin](https://github.com/alesapin)).
* 支持 Kafka 中的 Kerberos 身份验证，使用 `krb5` 和 `cyrus-sasl` 库. [#12771](https://github.com/ClickHouse/ClickHouse/pull/12771) ([Ilya Golshtein](https://github.com/ilejn)).
* 添加函数`normalizeQuery`, 用占位符替换文字、文字序列和复杂别名. 添加函数 `normalizedQueryHash` , 为类似的查询返回相同的 64 位哈希值. 它有助于分析查询日志. 这将关闭 [#11271](https://github.com/ClickHouse/ClickHouse/issues/11271). [#13816](https://github.com/ClickHouse/ClickHouse/pull/13816) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 添加 `time_zones` 表. [#13880](https://github.com/ClickHouse/ClickHouse/pull/13880) ([Bharat Nallan](https://github.com/bharatnc)).
* 添加函数 `defaultValueOfTypeName`, 返回给定类型的默认值. [#13877](https://github.com/ClickHouse/ClickHouse/pull/13877) ([hcz](https://github.com/hczhcz)).
* 添加 `countDigits(x)` 函数, 用于计算整数或小数列中的小数位数. 添加 `isDecimalOverflow(d, [p])` 函数, 用于检查 Decimal 列中的值是否超出其 (或指定的) 精度. [#14151](https://github.com/ClickHouse/ClickHouse/pull/14151) ([Artem Zuikov](https://github.com/4ertus2)).
* 添加 `quantileExactLow` 和 `quantileExactHigh` 实现, 并分别具有 `medianExactLow` 和 `medianExactHigh` 的别名. [#13818](https://github.com/ClickHouse/ClickHouse/pull/13818) ([Bharat Nallan](https://github.com/bharatnc)).
* 添加了将日期/时间值截断为指定日期/时间部分的 `date_trunc` 函数. [#13888](https://github.com/ClickHouse/ClickHouse/pull/13888) ([Vladimir Golovchenko](https://github.com/vladimir-golovchenko)).
* 将新的可选部分 `<user_directories>` 添加到主配置. [#13425](https://github.com/ClickHouse/ClickHouse/pull/13425) ([Vitaly Baranov](https://github.com/vitlibar)).
* 添加允许更改表示例子句的 `ALTER SAMPLE BY` 语句. [#13280](https://github.com/ClickHouse/ClickHouse/pull/13280) ([Amos Bird](https://github.com/amosbird)).
* 函数 `position` 现在支持可选的 `start_pos` 参数. [#13237](https://github.com/ClickHouse/ClickHouse/pull/13237) ([vdimir](https://github.com/vdimir)).

#### Bug 修复

* 修复客户端交互模式下进度条可见数据乱码问题. 这修复了 [#12562](https://github.com/ClickHouse/ClickHouse/issues/12562) 和 [#13369](https://github.com/ClickHouse/ClickHouse/issues/13369) 和 [#13584](https://github.com/ClickHouse/ClickHouse/issues/13584) 并修复了 [#12964](https://github.com/ClickHouse/ClickHouse/issues/12964). [#13691](https://github.com/ClickHouse/ClickHouse/pull/13691) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 修复了按多列排序时如果 `LowCardinality` 列不正确的排序顺序. 这修复了 [#13958](https://github.com/ClickHouse/ClickHouse/issues/13958). [#14223](https://github.com/ClickHouse/ClickHouse/pull/14223) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* 检查 `topK` 聚合函数中的数组大小溢出. 如果没有此检查, 用户可能会发送带有精心设计的参数的查询, 这将导致服务器崩溃. 这将关闭 [#14452](https://github.com/ClickHouse/ClickHouse/issues/14452). [#14467](https://github.com/ClickHouse/ClickHouse/pull/14467) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 修复了如果表具有单个部分的分区可能导致错误合并分配的错误. [#14444](https://github.com/ClickHouse/ClickHouse/pull/14444) ([alesapin](https://github.com/alesapin)).
* 如果 PipelineExecutor 本身发生异常, 则停止查询执行. 这可以防止罕见的查询挂起. 续 [#14334](https://github.com/ClickHouse/ClickHouse/issues/14334). [#14402](https://github.com/ClickHouse/ClickHouse/pull/14402) [#14334](https://github.com/ClickHouse/ClickHouse/pull/14334) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* 修复在创建为 `AS table_function` 的表的 `ALTER` 查询期间崩溃. 修复 [#14212](https://github.com/ClickHouse/ClickHouse/issues/14212). [#14326](https://github.com/ClickHouse/ClickHouse/pull/14326) ([alesapin](https://github.com/alesapin)).
* 使用 REFRESH 命令修复 ALTER LIVE VIEW 查询期间的异常. 实时取景是一项实验性功能. [#14320](https://github.com/ClickHouse/ClickHouse/pull/14320) ([Bharat Nallan](https://github.com/bharatnc)).
* 修复带有嵌套解释器的查询的 QueryPlan 生命周期 (对于 EXPLAIN PIPELINE graph=1). [#14315](https://github.com/ClickHouse/ClickHouse/pull/14315) ([Azat Khuzhin](https://github.com/azat)).
* 在从某些外部来源获取架构期间修复 `lickhouse-odbc-bridge` 的段错误. PR 修复了. [#14267](https://github.com/ClickHouse/ClickHouse/pull/14267) ([Vitaly Baranov](https://github.com/vitlibar)).
* 修复 [#12277](https://github.com/ClickHouse/ClickHouse/pull/12277) 中引入的标记包含搜索崩溃. [#14225](https://github.com/ClickHouse/ClickHouse/pull/14225) ([Amos Bird](https://github.com/amosbird)).
* 使用命名元组修复表的创建. 这修复了 [#13027](https://github.com/ClickHouse/ClickHouse/issues/13027). [#14143](https://github.com/ClickHouse/ClickHouse/pull/14143) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 修复最小负十进制数的格式. 这修复了 [#14111](https://github.com/ClickHouse/ClickHouse/issues/14111). [#14119](https://github.com/ClickHouse/ClickHouse/pull/14119) ([Alexander Kuzmenkov](https://github.com/akuzm)).
* 修复 `DistributedFilesToInsert` 指标 (不应该归零). [#14095](https://github.com/ClickHouse/ClickHouse/pull/14095) ([Azat Khuzhin](https://github.com/azat)).
* 使用 const 2d 数组将 `pointInPolygon` 修复为多边形. [#14079](https://github.com/ClickHouse/ClickHouse/pull/14079) ([Alexey Ilyukhov](https://github.com/livace)).
* 修复了 `Poco::Exception: no space left on device` 额外信息中错误的挂载点. [#14050](https://github.com/ClickHouse/ClickHouse/pull/14050) ([tavplubix](https://github.com/tavplubix)).
* 在非全局级别执行时修复 GRANT ALL 语句. [#13987](https://github.com/ClickHouse/ClickHouse/pull/13987) ([Vitaly Baranov](https://github.com/vitlibar)).
* 修复解析器以拒绝使用引擎创建表作为表函数. [#13940](https://github.com/ClickHouse/ClickHouse/pull/13940) ([hcz](https://github.com/hczhcz)).
* 如果启用了 `optimize_duplicate_order_by_and_distinct` 设置, 则使用 `DISTINCT` 关键字修复选择查询和使用 UNION ALL 的子查询中的错误结果. [#13925](https://github.com/ClickHouse/ClickHouse/pull/13925) ([Artem Zuikov](https://github.com/4ertus2)).
* 修复了重命名 `Distributed` 表时潜在的死锁. [#13922](https://github.com/ClickHouse/ClickHouse/pull/13922) ([tavplubix](https://github.com/tavplubix)).
* 修复按多列排序时 `FixedString` 列的不正确排序. 修复 [#13182](https://github.com/ClickHouse/ClickHouse/issues/13182). [#13887](https://github.com/ClickHouse/ClickHouse/pull/13887) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* 修复 `topK`/`topKWeighted` 合并的潜在不精确结果 (使用非默认参数). [#13817](https://github.com/ClickHouse/ClickHouse/pull/13817) ([Azat Khuzhin](https://github.com/azat)).
* 修复与 NULL 比较时, 从 MergeTree 表中读取 INDEX 类型为 SET 失败的问题. 这修复了[#13686](https://github.com/ClickHouse/ClickHouse/issues/13686). [#13793](https://github.com/ClickHouse/ClickHouse/pull/13793) ([Amos Bird](https://github.com/amosbird)).
* 修复 lambda 中的 `arrayJoin` 捕获 (LOGICAL_ERROR). [#13792](https://github.com/ClickHouse/ClickHouse/pull/13792) ([Azat Khuzhin](https://github.com/azat)).
* 在函数 `range` 中添加步骤溢出检查. [#13790](https://github.com/ClickHouse/ClickHouse/pull/13790) ([Azat Khuzhin](https://github.com/azat)).
* 修复了并发执行 `DROP DATABASE` 和 `CREATE TABLE` 时的 `Directory not empty` 错误. [#13756](https://github.com/ClickHouse/ClickHouse/pull/13756) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 为 `h3KRing` 函数添加范围检查. 这修复了[#13633](https://github.com/ClickHouse/ClickHouse/issues/13633). [#13752](https://github.com/ClickHouse/ClickHouse/pull/13752) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 修复 DETACH 和后台合并之间的竞争条件. 零件在分离后可能会复活. 这是 [#8602](https://github.com/ClickHouse/ClickHouse/issues/8602) 的延续, 它没有解决问题, 但引入了一个在极少数情况下开始失败的测试, 证明了这个问题. [#13746](https://github.com/ClickHouse/ClickHouse/pull/13746) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 当 log_queries_min_type > QUERY_START 时修复日志记录 Settings.Names/Values. [#13737](https://github.com/ClickHouse/ClickHouse/pull/13737) ([Azat Khuzhin](https://github.com/azat)).
* 当verbose=1时修复 `/replicas_status` 端点响应状态代码. [#13722](https://github.com/ClickHouse/ClickHouse/pull/13722) ([javi santana](https://github.com/javisantana)).
* 在检查用户和组时修复 `clickhouse-server.init` 中的错误消息. [#13711](https://github.com/ClickHouse/ClickHouse/pull/13711) ([ylchou](https://github.com/ylchou)).
* 不要在 `optimize_move_functions_out_of_any` 设置下优化 any(arrayJoin()) -> arrayJoin(). [#13681](https://github.com/ClickHouse/ClickHouse/pull/13681) ([Azat Khuzhin](https://github.com/azat)).
* 使用 StorageMerge 和 `set enable_optimize_predicate_expression=1` 修复 JOIN 中的崩溃. [#13679](https://github.com/ClickHouse/ClickHouse/pull/13679) ([Artem Zuikov](https://github.com/4ertus2)).
* 修复关于 `number_of_free_entries_in_pool_to_lower_max_size_of_merge` 设置的值的错误消息中的错字. [#13678](https://github.com/ClickHouse/ClickHouse/pull/13678) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 并发 `ALTER ... REPLACE/MOVE PARTITION ...` 查询可能会导致死锁. 已修复. [#13626](https://github.com/ClickHouse/ClickHouse/pull/13626) ([tavplubix](https://github.com/tavplubix)).
* 修复了有时缓存字典从源返回默认值而不是当前值时的行为. [#13624](https://github.com/ClickHouse/ClickHouse/pull/13624) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* 修复紧凑部分中的二级索引损坏. 紧凑的部件是实验功能. [#13538](https://github.com/ClickHouse/ClickHouse/pull/13538) ([Anton Popov](https://github.com/CurtizJ)).
* 修复必须在单个副本上执行的查询的过早 `ON CLUSTER` 超时. 修复 [#6704](https://github.com/ClickHouse/ClickHouse/issues/6704), [#7228](https://github.com/ClickHouse/ClickHouse/issues/7228), [#13361](https://github.com/ClickHouse/ClickHouse/issues/13361), [#11884](https://github.com/ClickHouse/ClickHouse/issues/11884). [#13450](https://github.com/ClickHouse/ClickHouse/pull/13450) ([alesapin](https://github.com/alesapin)).
* 修复函数 `netloc` 中的错误代码. 这修复了[#13335](https://github.com/ClickHouse/ClickHouse/issues/13335). [#13446](https://github.com/ClickHouse/ClickHouse/pull/13446) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 修复 `StorageMemory` 中可能出现的竞争. [#13416](https://github.com/ClickHouse/ClickHouse/pull/13416) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* 修复 HTTP 协议中 `TSV/CSVWithNames` 格式中缺失或过多的标头. 这修复了 [#12504](https://github.com/ClickHouse/ClickHouse/issues/12504). [#13343](https://github.com/ClickHouse/ClickHouse/pull/13343) ([Azat Khuzhin](https://github.com/azat)).
* 当数据库或表的名称包含点时, 修复从 users.xml 解析行策略. 这修复了[#5779](https://github.com/ClickHouse/ClickHouse/issues/5779), [#12527](https://github.com/ClickHouse/ClickHouse/issues/12527). [#13199](https://github.com/ClickHouse/ClickHouse/pull/13199) ([Vitaly Baranov](https://github.com/vitlibar)).
* 在连接断开一次后修复对 `redis` 字典的访问. `cache` 和 `direct` 字典布局可能会发生这种情况. [#13082](https://github.com/ClickHouse/ClickHouse/pull/13082) ([Anton Popov](https://github.com/CurtizJ)).
* 删除了使用 ClickHouseDictionarySource 查询远程表时错误的身份验证访问检查. [#12756](https://github.com/ClickHouse/ClickHouse/pull/12756) ([sundyli](https://github.com/sundy-li)).
* 正确区分某些情况下的子查询, 用于公共子表达式的消除. [#8333](https://github.com/ClickHouse/ClickHouse/issues/8333). [#8367](https://github.com/ClickHouse/ClickHouse/pull/8367) ([Amos Bird](https://github.com/amosbird)).

#### 改进

* 在 `ALIAS` 列类型上不允许使用 `CODEC`. 修复 [#13911](https://github.com/ClickHouse/ClickHouse/issues/13911). [#14263](https://github.com/ClickHouse/ClickHouse/pull/14263) ([Bharat Nallan](https://github.com/bharatnc)).
* 等待字典更新完成时, 使用由 `query_wait_timeout_milliseconds` 设置指定的超时而不是硬编码值. [#14105](https://github.com/ClickHouse/ClickHouse/pull/14105) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* 添加设置 `min_index_granularity_bytes` 以防止意外创建具有非常低的 `index_granularity_bytes` 设置的表. [#14139](https://github.com/ClickHouse/ClickHouse/pull/14139) ([Bharat Nallan](https://github.com/bharatnc)).
* 现在可以从使用不同 ZooKeeper 的集群中获取分区: `ALTER TABLE table_name FETCH PARTITION partition_expr FROM 'zk-name:/path-in-zookeeper'`. 这对于将数据传送到新集群很有用. [#14155](https://github.com/ClickHouse/ClickHouse/pull/14155) ([Amos Bird](https://github.com/amosbird)).
* 如果 Memory 表是由大量非常小的块构建的, 那么它的性能会稍好一些 (这不太可能). 这个想法的作者: [Mark Papadakis](https://github.com/markpapadakis). 关闭 [#14043](https://github.com/ClickHouse/ClickHouse/issues/14043). [#14056](https://github.com/ClickHouse/ClickHouse/pull/14056) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 条件聚合函数 (例如: `avgIf`、`sumIf`、`maxIf`) 在缺少行并使用可为空参数时应返回 `NULL` . [#13964](https://github.com/ClickHouse/ClickHouse/pull/13964) ([Winter Zhang](https://github.com/zhang2014)).
* 将 -Resample 组合器中的限制增加到 1M. [#13947](https://github.com/ClickHouse/ClickHouse/pull/13947) ([Mikhail f. Shiryaev](https://github.com/Felixoid)).
* 更正了 AvroConfluent 格式的错误, 该错误导致 Kafka 表引擎在收到异常小的、格式错误的消息时停止处理消息. [#13941](https://github.com/ClickHouse/ClickHouse/pull/13941) ([Gervasio Varela](https://github.com/gervarela)).
* 修复长查询的错误错误. 为了正确查询, 可能会出现除 `Max query size exceeded` 之外的语法错误. [#13928](https://github.com/ClickHouse/ClickHouse/pull/13928) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* `TabSeparated` 格式的空值的更好的错误消息. [#13906](https://github.com/ClickHouse/ClickHouse/pull/13906) ([jiang tao](https://github.com/tomjiang1987)).
* 如果数组元素的类型是 Float32/Float64, 函数 `arrayCompact` 将按位比较 NaN. 在以前的版本中, 如果数组元素的类型是 Float32/Float64，NaN 总是不相等, 如果类型更复杂, 例如 Nullable(Float64), NaN 总是相等. 这将关闭 [#13857](https://github.com/ClickHouse/ClickHouse/issues/13857). [#13868](https://github.com/ClickHouse/ClickHouse/pull/13868) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 修复 `lgamma` 函数中的数据竞争. 这场比赛只在 `tsan` 中被抓到, 没有真正发生过副作用. [#13842](https://github.com/ClickHouse/ClickHouse/pull/13842) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* 当数组作为字段操作时, 避免太慢的查询. 改为抛出异常. [#13753](https://github.com/ClickHouse/ClickHouse/pull/13753) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 新增Redis requirepass授权 (针对redis字典源码). [#13688](https://github.com/ClickHouse/ClickHouse/pull/13688) ([Ivan Torgashov](https://github.com/it1804)).
* 添加 MergeTree Write-Ahead-Log (WAL) 转储工具. WAL 是一个实验性功能. [#13640](https://github.com/ClickHouse/ClickHouse/pull/13640) ([BohuTANG](https://github.com/BohuTANG)).
* 在以前的版本中, 如果使用专门设计的参数调用, `lcm` 函数可能会在调试构建中产生断言冲突. 这修复了 [#13368](https://github.com/ClickHouse/ClickHouse/issues/13368). [#13510](https://github.com/ClickHouse/ClickHouse/pull/13510) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 在更多情况下为 `toDate/toDateTime` 函数提供单调性. 单调性信息用于索引分析 (更复杂的查询将能够使用索引). 现在输入参数更自然地饱和并提供更好的单调性. [#13497](https://github.com/ClickHouse/ClickHouse/pull/13497) ([Amos Bird](https://github.com/amosbird)).
* 支持自定义设置的复合标识符. 自定义设置是 ClickHouse 代码库与其他代码库的集成点 (对 ClickHouse 本身没有好处) [#13496](https://github.com/ClickHouse/ClickHouse/pull/13496) ([Vitaly Baranov](https://github.com/vitlibar)).
* 将部分从 DiskLocal 并行移动到 DiskS3. `DiskS3` 是一个实验性功能. [#13459](https://github.com/ClickHouse/ClickHouse/pull/13459) ([Pavel Kovalenko](https://github.com/Jokser)).
* 默认启用混合粒度部分. [#13449](https://github.com/ClickHouse/ClickHouse/pull/13449) ([alesapin](https://github.com/alesapin)).
* S3 重定向中正确的远程主机检查 (与安全相关的事情). [#13404](https://github.com/ClickHouse/ClickHouse/pull/13404) ([Vladimir Chebotarev](https://github.com/excitoon)).
* 将 `QueryTimeMicroseconds`、`SelectQueryTimeMicroseconds` 和 `InsertQueryTimeMicroseconds` 添加到 system.events. [#13336](https://github.com/ClickHouse/ClickHouse/pull/13336) ([ianton-ru](https://github.com/ianton-ru)).
* 修复 Decimal 具有太大负指数时的调试断言. 修复 [#13188](https://github.com/ClickHouse/ClickHouse/issues/13188). [#13228](https://github.com/ClickHouse/ClickHouse/pull/13228) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 为 DiskS3 添加了缓存层 (缓存到本地磁盘标记和索引文件). `DiskS3` 是一个实验性功能. [#13076](https://github.com/ClickHouse/ClickHouse/pull/13076) ([Pavel Kovalenko](https://github.com/Jokser)).
* 修复 readline 以便现在将历史记录转储到文件中. [#13600](https://github.com/ClickHouse/ClickHouse/pull/13600) ([Amos Bird](https://github.com/amosbird)).
* 默认使用 `Atomic` 引擎创建 `system` 数据库 (准备在任何地方默认启用 `Atomic` 数据库引擎). [#13680](https://github.com/ClickHouse/ClickHouse/pull/13680) ([tavplubix](https://github.com/tavplubix)).

#### 性能改进

* 使用 `LowCardinality` 稍微优化非常短的查询. [#14129](https://github.com/ClickHouse/ClickHouse/pull/14129) ([Anton Popov](https://github.com/CurtizJ)).
* 当设置 `max_insert_threads` 时, 为表引擎 `Null`、`Memory`、`Distributed` 和 `Buffer` 启用并行插入. [#14120](https://github.com/ClickHouse/ClickHouse/pull/14120) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 如果在部件扫描时超过 `max_rows_to_read` 限制, 则快速失败. 此更改背后的动机是, 如果明显已超过 `max_rows_to_read`, 则跳过所有选定部分的范围扫描. 对于大量零件的查询, 这种变化非常明显. [#13677](https://github.com/ClickHouse/ClickHouse/pull/13677) ([Roman Khavronenko](https://github.com/hagen1778)).
* 通过 UInt8/UInt16 键略微提高聚合性能. [#13099](https://github.com/ClickHouse/ClickHouse/pull/13099) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 优化`has()`、`indexOf()`和 `countEqual()` 函数, 用于 `Array(LowCardinality(T))` 和常量右参数. [#12550](https://github.com/ClickHouse/ClickHouse/pull/12550) ([myrrc](https://github.com/myrrc)).
* 在执行简单的 `INSERT SELECT` 查询时, 自动将 `max_threads` 设置为1 或 `max_insert_threads`, 并将 `max_block_size` 设置为 `min_insert_block_size_rows`. 相关 [#5907](https://github.com/ClickHouse/ClickHouse/issues/5907). [#12195](https://github.com/ClickHouse/ClickHouse/pull/12195) ([flynn](https://github.com/ucasFL)).

#### 实验功能

* ClickHouse 可以用作 MySQL 副本 - 它由 `MaterializeMySQL` 数据库引擎实现. 实现 [#4006](https://github.com/ClickHouse/ClickHouse/issues/4006). [#10851](https://github.com/ClickHouse/ClickHouse/pull/10851) ([Winter Zhang](https://github.com/zhang2014)).
* 为它们添加类型 `Int128`、`Int256`、`UInt256` 和相关函数. 使用 Decimal256 扩展小数 (精度高达 76 位). 新类型在设置 `allow_experimental_bigint_types` 下. 它的工作非常缓慢和糟糕. 实施不完整. 请不要使用此功能. [#13097](https://github.com/ClickHouse/ClickHouse/pull/13097) ([Artem Zuikov](https://github.com/4ertus2)).

#### 构建/测试/打包改进

* 添加了 `clickhouse install` 脚本, 如果你只有一个二进制文件, 这很有用. [#13528](https://github.com/ClickHouse/ClickHouse/pull/13528) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 允许在没有配置的情况下运行 `clickhouse` 二进制文件. [#13515](https://github.com/ClickHouse/ClickHouse/pull/13515) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 使用 `codespell` 启用检查代码中的拼写错误. [#13513](https://github.com/ClickHouse/ClickHouse/pull/13513) [#13511](https://github.com/ClickHouse/ClickHouse/pull/13511) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 在 CI 中启用 Shellcheck 作为 .sh 测试的 linter. 这将关闭 [#13168](https://github.com/ClickHouse/ClickHouse/issues/13168). [#13530](https://github.com/ClickHouse/ClickHouse/pull/13530) [#13529](https://github.com/ClickHouse/ClickHouse/pull/13529) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 添加 CMake 选项以失败配置而不是自动重新配置, 默认启用. [#13687](https://github.com/ClickHouse/ClickHouse/pull/13687) ([Konstantin](https://github.com/podshumok)).
* 通过 system.build_options 中的 TZDATA_VERSION 公开嵌入式 tzdata 的版本. [#13648](https://github.com/ClickHouse/ClickHouse/pull/13648) ([filimonov](https://github.com/filimonov)).
* 在构建期间改进 system.time_zones 表的生成. 关闭 [#14209](https://github.com/ClickHouse/ClickHouse/issues/14209). [#14215](https://github.com/ClickHouse/ClickHouse/pull/14215) ([filimonov](https://github.com/filimonov)).
* 使用来自包存储库的最新 tzdata 构建 ClickHouse. [#13623](https://github.com/ClickHouse/ClickHouse/pull/13623) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 在skip_list.json中添加编写js样式注释的能力. [#14159](https://github.com/ClickHouse/ClickHouse/pull/14159) ([alesapin](https://github.com/alesapin)).
* 确保没有复制粘贴的 GPL 代码. [#13514](https://github.com/ClickHouse/ClickHouse/pull/13514) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 切换测试 docker 图像以使用基于测试的父级. [#14167](https://github.com/ClickHouse/ClickHouse/pull/14167) ([Ilya Yatsishin](https://github.com/qoega)).
* 启动docker-compose集群时添加重试逻辑; 增加 COMPOSE_HTTP_TIMEOUT. [#14112](https://github.com/ClickHouse/ClickHouse/pull/14112) ([vzakaznikov](https://github.com/vzakaznikov)).
* 在压力测试中启用 `system.text_log` 以发现更多错误. [#13855](https://github.com/ClickHouse/ClickHouse/pull/13855) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* Testflows LDAP 模块: 为 openldap4 添加缺少的证书和 dhparam.pem. [#13780](https://github.com/ClickHouse/ClickHouse/pull/13780) ([vzakaznikov](https://github.com/vzakaznikov)).
* ZooKeeper 在 CI 基础设施的单元测试中无法可靠地工作. 使用单元测试进行 ZooKeeper 与真正的 ZooKeeper 交互从一开始就是个坏主意 (单元测试不应该验证复杂的分布式系统). 我们已经为此目的使用集成测试, 它们更适合. [#13745](https://github.com/ClickHouse/ClickHouse/pull/13745) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 添加了用于样式检查的 docker 图像. 添加样式检查所有 docker 和 docker compose 文件都位于 docker 目录中. [#13724](https://github.com/ClickHouse/ClickHouse/pull/13724) ([Ilya Yatsishin](https://github.com/qoega)).
* 修复 Mac OS 上的 cassandra 构建. [#13708](https://github.com/ClickHouse/ClickHouse/pull/13708) ([Ilya Yatsishin](https://github.com/qoega)).
* 修复共享构建中的链接错误. [#13700](https://github.com/ClickHouse/ClickHouse/pull/13700) ([Amos Bird](https://github.com/amosbird)).
* 更新 LDAP 用户身份验证套件以检查它是否适用于 RBAC. [#13656](https://github.com/ClickHouse/ClickHouse/pull/13656) ([vzakaznikov](https://github.com/vzakaznikov)).
* 删除了 `contrib/aws` 的 `-DENABLE_CURL_CLIENT`. [#13628](https://github.com/ClickHouse/ClickHouse/pull/13628) ([Vladimir Chebotarev](https://github.com/excitoon)).
* 增加 ClickHouse 节点的运行状况检查超时, 并在发现不健康的容器时添加对转储 docker-compose 日志的支持. [#13612](https://github.com/ClickHouse/ClickHouse/pull/13612) ([vzakaznikov](https://github.com/vzakaznikov)).
* 确保 [#10977](https://github.com/ClickHouse/ClickHouse/issues/10977) 无效. [#13539](https://github.com/ClickHouse/ClickHouse/pull/13539) ([Amos Bird](https://github.com/amosbird)).
* 从robot-clickhouse 跳过PR. [#13489](https://github.com/ClickHouse/ClickHouse/pull/13489) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* 将 Dockerfiles 从集成测试移动到 `docker/test` 目录. docker_compose 文件在 `runner` docker 容器中可用. Docker 镜像是在 CI 中构建的, 而不是在集成测试中. [#13448](https://github.com/ClickHouse/ClickHouse/pull/13448) ([Ilya Yatsishin](https://github.com/qoega)).


## ClickHouse 版本 20.7

### ClickHouse 版本 v20.7.2.30-stable, 2020-08-31

#### 向后不兼容变更

* 以至少一个浮点数作为参数的函数 `modulo` (运算符 `%` )将直接计算浮点数的除法余数, 而不将两个参数都转换为整数. 它使行为与大多数 DBMS 兼容. 这也适用于 Date 和 DateTime 数据类型. 添加别名 `mod` . 这将关闭 [#7323](https://github.com/ClickHouse/ClickHouse/issues/7323). [#12585](https://github.com/ClickHouse/ClickHouse/pull/12585) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 弃用零日期/日期时间值的特殊打印为 `0000-00-00` 和`0000-00-00 00:00:00`. [#12442](https://github.com/ClickHouse/ClickHouse/pull/12442) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 函数 `groupArrayMoving*` 不适用于分布式查询. 它的结果是在不正确的数据类型中计算的 (没有升级到最大的类型). `groupArrayMovingAvg` 函数返回的整数与 `avg` 函数不一致. 这修复了[#12568](https://github.com/ClickHouse/ClickHouse/issues/12568). [#12622](https://github.com/ClickHouse/ClickHouse/pull/12622) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 为 MergeTree 设置添加健全性检查. 如果设置不正确，服务器将拒绝启动或创建表, 并向用户打印详细说明. [#13153](https://github.com/ClickHouse/ClickHouse/pull/13153) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 防止用户可能将 `background_pool_size` 设置为低于 `number_of_free_entries_in_pool_to_execute_mutation` 或 `number_of_free_entries_in_pool_to_lower_max_size_of_merge` 的值. 在这些情况下, ALTER 将不起作用或合并的最大大小将太有限. 它将抛出异常解释要做什么. 这将关闭 [#10897](https://github.com/ClickHouse/ClickHouse/issues/10897). [#12728](https://github.com/ClickHouse/ClickHouse/pull/12728) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 从20.5以上的版本升级时, 如果进行滚动更新, 集群同时包含20.5以上和20.5以下的版本, 如果旧版本的ClickHouse节点重启, 旧版本在新版本存在的情况下启动, 可能会导致 `Part ... intersects previous part` 错误. 为防止出现此错误, 首先在所有集群节点上安装更新的 clickhouse-server 软件包, 然后重新启动 (因此, 当 clickhouse-server 重新启动时, 它将以新版本启动).

#### 新特征

* 提供高效 `reverse geocoding` 查找的多边形字典类型 - 在许多多边形的字典 (世界地图) 中通过坐标查找区域. 它使用精心优化的算法和递归网格来保持较低的 CPU 和内存使用率. [#9278](https://github.com/ClickHouse/ClickHouse/pull/9278) ([achulkov2](https://github.com/achulkov2)).
* 添加了对预配置用户的 LDAP 身份验证支持 ( `Simple Bind` 方法). [#11234](https://github.com/ClickHouse/ClickHouse/pull/11234) ([Denis Glazachev](https://github.com/traceon)).
* 引入设置 `alter_partition_verbose_result`, 它为某些类型的 `ALTER TABLE ... PARTITION ...` 查询 (当前是`ATTACH` 和`FREEZE`)输出有关触摸部分的信息. 关闭 [#8076](https://github.com/ClickHouse/ClickHouse/issues/8076). [#13017](https://github.com/ClickHouse/ClickHouse/pull/13017) ([alesapin](https://github.com/alesapin)).
* 为 bayesian-ab-testing 添加 `bayesAB` 函数. [#12327](https://github.com/ClickHouse/ClickHouse/pull/12327) ([achimbab](https://github.com/achimbab)).
* 添加了 `system.crash_log` 表, 用于收集致命错误的堆栈跟踪. 这个表应该是空的. [#12316](https://github.com/ClickHouse/ClickHouse/pull/12316) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 添加了 http 标头 `X-ClickHouse-Database` 和 `X-ClickHouse-Format`, 可用于设置默认数据库和输出格式. [#12981](https://github.com/ClickHouse/ClickHouse/pull/12981) ([hcz](https://github.com/hczhcz)).
* 将 `minMap` 和 `maxMap` 函数支持添加到 `SimpleAggregateFunction`. [#12662](https://github.com/ClickHouse/ClickHouse/pull/12662) ([Ildus Kurbangaliev](https://github.com/ildus)).
* 添加设置 `allow_non_metadata_alters`, 它限制执行修改磁盘上数据的 `ALTER` 查询. 默认禁用. 关闭 [#11547](https://github.com/ClickHouse/ClickHouse/issues/11547). [#12635](https://github.com/ClickHouse/ClickHouse/pull/12635) ([alesapin](https://github.com/alesapin)).
* 添加了一个函数 `formatRow` 以支持通过给定格式将任意表达式转换为字符串. 它对于操作 SQL 输出很有用, 并且与 `columns` 函数结合使用非常通用. [#12574](https://github.com/ClickHouse/ClickHouse/pull/12574) ([Amos Bird](https://github.com/amosbird)).
* 添加 `FROM_UNIXTIME` 函数以兼容 MySQL, 与 [12149](https://github.com/ClickHouse/ClickHouse/issues/12149) 相关. [#12484](https://github.com/ClickHouse/ClickHouse/pull/12484) ([flynn](https://github.com/ucasFL)).
* 如果启用了 `allow_nullable_key` 表设置, 则允许 Nullable 类型作为 MergeTree 表中的键. 关闭 [#5319](https://github.com/ClickHouse/ClickHouse/issues/5319). [#12433](https://github.com/ClickHouse/ClickHouse/pull/12433) ([Amos Bird](https://github.com/amosbird)).
* 与 [COS](https://intl.cloud.tencent.com/product/cos) 集成. [#12386](https://github.com/ClickHouse/ClickHouse/pull/12386) ([fastio](https://github.com/fastio)).
* 添加 `mapAdd` 和 `mapSubtract` 函数以添加/减去键映射值. [#11735](https://github.com/ClickHouse/ClickHouse/pull/11735) ([Ildus Kurbangaliev](https://github.com/ildus)).

#### Bug 修复

* 修复必须在单个副本上执行的查询的过早 `ON CLUSTER` 超时. 修复 [#6704](https://github.com/ClickHouse/ClickHouse/issues/6704), [#7228](https://github.com/ClickHouse/ClickHouse/issues/7228), [#13361](https://github.com/ClickHouse/ClickHouse/issues/13361), [#11884](https://github.com/ClickHouse/ClickHouse/issues/11884). [#13450](https://github.com/ClickHouse/ClickHouse/pull/13450) ([alesapin](https://github.com/alesapin)).
* 修复 [#12277](https://github.com/ClickHouse/ClickHouse/pull/12277) 中引入的标记包含搜索崩溃. [#14225](https://github.com/ClickHouse/ClickHouse/pull/14225) ([Amos Bird](https://github.com/amosbird)).
* 使用缓存布局修复外部字典中的竞争条件, 这可能导致服务器崩溃. [#12566](https://github.com/ClickHouse/ClickHouse/pull/12566) ([alesapin](https://github.com/alesapin)).
* 修复客户端交互模式下进度条可见数据乱码问题. 这修复了 [#12562](https://github.com/ClickHouse/ClickHouse/issues/12562) 和 [#13369](https://github.com/ClickHouse/ClickHouse/issues/13369) 和 [#13584] (https://github.com/ClickHouse/ClickHouse/issues/13584) 并修复了 [#12964](https://github.com/ClickHouse/ClickHouse/issues/12964). [#13691](https://github.com/ClickHouse/ClickHouse/pull/13691) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 修复了当使用 ORDER BY 多列时 `LowCardinality` 列的不正确排序顺序. 这修复了 [#13958](https://github.com/ClickHouse/ClickHouse/issues/13958). [#14223](https://github.com/ClickHouse/ClickHouse/pull/14223) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* 删除了硬编码超时, 它错误地否决了缓存字典的 `query_wait_timeout_milliseconds` 设置. [#14105](https://github.com/ClickHouse/ClickHouse/pull/14105) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* 修复了 `Poco::Exception: no space left on device` 额外信息中错误的挂载点. [#14050](https://github.com/ClickHouse/ClickHouse/pull/14050) ([tavplubix](https://github.com/tavplubix)).
* 在启用了 `optimize_duplicate_order_by_and_distinct` 设置的情况下, 当子查询也具有 `DISTINCT` 时, 使用 `DISTINCT` 关键字修复选择查询的错误查询优化. [#13925](https://github.com/ClickHouse/ClickHouse/pull/13925) ([Artem Zuikov](https://github.com/4ertus2)).
* 修复了重命名 `Distributed` 表时潜在的死锁. [#13922](https://github.com/ClickHouse/ClickHouse/pull/13922) ([tavplubix](https://github.com/tavplubix)).
* 修复使用 ORDER BY 多列时 `FixedString` 列的不正确排序。 修复 [#13182](https://github.com/ClickHouse/ClickHouse/issues/13182). [#13887](https://github.com/ClickHouse/ClickHouse/pull/13887) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* 修复 `topK`/`topKWeighted` 聚合的潜在较低精度 (使用非默认参数). [#13817](https://github.com/ClickHouse/ClickHouse/pull/13817) ([Azat Khuzhin](https://github.com/azat)).
* 修复从 MergeTree 表中读取 INDEX 类型为 SET 时与 NULL 相比失败的问题. 这修复了 [#13686](https://github.com/ClickHouse/ClickHouse/issues/13686). [#13793](https://github.com/ClickHouse/ClickHouse/pull/13793) ([Amos Bird](https://github.com/amosbird)).
* 修复函数`range()`中的步骤溢出. [#13790](https://github.com/ClickHouse/ClickHouse/pull/13790) ([Azat Khuzhin](https://github.com/azat)).
* 修复了并发执行 `DROP DATABASE` 和 `CREATE TABLE` 时的 `Directory not empty` 错误. [#13756](https://github.com/ClickHouse/ClickHouse/pull/13756) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 为 `h3KRing` 函数添加范围检查. 这修复了 [#13633](https://github.com/ClickHouse/ClickHouse/issues/13633). [#13752](https://github.com/ClickHouse/ClickHouse/pull/13752) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 修复 DETACH 和后台合并之间的竞争条件. 零件在分离后可能会复活. 这是 [#8602](https://github.com/ClickHouse/ClickHouse/issues/8602) 的延续, 它没有解决问题, 但引入了一个在极少数情况下开始失败的测试, 证明了这个问题. [#13746](https://github.com/ClickHouse/ClickHouse/pull/13746) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 当 `log_queries_min_type` 大于 `QUERY_START` 时修复日志 Settings.Names/Values . [#13737](https://github.com/ClickHouse/ClickHouse/pull/13737) ([Azat Khuzhin](https://github.com/azat)).
* 在检查用户和组时修复 `clickhouse-server.init` 中的错误消息. [#13711](https://github.com/ClickHouse/ClickHouse/pull/13711) ([ylchou](https://github.com/ylchou)).
* 不要在 `optimize_move_functions_out_of_any` 下将 `any(arrayJoin())` 优化为 `arrayJoin()` . [#13681](https://github.com/ClickHouse/ClickHouse/pull/13681) ([Azat Khuzhin](https://github.com/azat)).
* 修复了并发 `ALTER ... REPLACE/MOVE PARTITION ...` 查询中可能出现的死锁. [#13626](https://github.com/ClickHouse/ClickHouse/pull/13626) ([tavplubix](https://github.com/tavplubix)).
* 修复了有时缓存字典从源返回默认值而不是当前值时的行为. [#13624](https://github.com/ClickHouse/ClickHouse/pull/13624) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* 修复紧凑部分中的二级索引损坏 (紧凑部分是一个实验性功能). [#13538](https://github.com/ClickHouse/ClickHouse/pull/13538) ([Anton Popov](https://github.com/CurtizJ)).
* 修复函数 `netloc` 中的错误代码. 这修复了 [#13335](https://github.com/ClickHouse/ClickHouse/issues/13335). [#13446](https://github.com/ClickHouse/ClickHouse/pull/13446) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 当 unix 时间戳作为参数传递时, 修复 `parseDateTimeBestEffort` 函数中的错误. 这修复了 [#13362](https://github.com/ClickHouse/ClickHouse/issues/13362). [#13441](https://github.com/ClickHouse/ClickHouse/pull/13441) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 修复无效的返回类型, 用于将元组与 `NULL` 元素进行比较. 修复 [#12461](https://github.com/ClickHouse/ClickHouse/issues/12461). [#13420](https://github.com/ClickHouse/ClickHouse/pull/13420) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* 修复错误优化导致 `aggregate function any(x) is found inside another aggregate function in query` 错误 `SET optimize_move_functions_out_of_any = 1` 和 `any()` 内的别名. [#13419](https://github.com/ClickHouse/ClickHouse/pull/13419) ([Artem Zuikov](https://github.com/4ertus2)).
* 修复 `storagmemory` 中可能存在的竞争问题. [#13416](https://github.com/ClickHouse/ClickHouse/pull/13416) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* 如果查询返回零行, 修复`Arrow` 和`Parquet` 格式的空输出. 这样做是因为空输出对于这种格式无效. [#13399](https://github.com/ClickHouse/ClickHouse/pull/13399) ([hcz](https://github.com/hczhcz)).
* 在 `ORDER BY` 子句中使用常量列和主键前缀修复选择查询. [#13396](https://github.com/ClickHouse/ClickHouse/pull/13396) ([Anton Popov](https://github.com/CurtizJ)).
* 修复 clickhouse-local 的 `PrettyCompactMonoBlock`. 使用 `PrettyCompactMonoBlock` 修复极端/总数. 修复 [#7746](https://github.com/ClickHouse/ClickHouse/issues/7746). [#13394](https://github.com/ClickHouse/ClickHouse/pull/13394) ([Azat Khuzhin](https://github.com/azat)).
* 修复了 system.text_log 中的死锁. [#12452](https://github.com/ClickHouse/ClickHouse/pull/12452) ([alexey-milovidov](https://github.com/alexey-milovidov)). 它是 [#12339](https://github.com/ClickHouse/ClickHouse/issues/12339) 的一部分. 这修复了 [#12325]. [#13386](https://github.com/ClickHouse/ClickHouse/pull/13386) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* 修复了`File(TSVWithNames*)` (标题被多次写入), 修复了 `clickhouse-local --format CSVWithNames*` (缺少标题, 在[#12197](https://github.com/ClickHouse/ClickHouse/ 问题/12197)), 修复了零行 (缺少标题) 的 `clickhouse-local --format CSVWithNames*`. [#13343](https://github.com/ClickHouse/ClickHouse/pull/13343) ([Azat Khuzhin](https://github.com/azat)).
* 当函数 `groupArrayMovingSum` 反序列化空状态时, 修复段错误. 修复 [#13339](https://github.com/ClickHouse/ClickHouse/issues/13339). [#13341](https://github.com/ClickHouse/ClickHouse/pull/13341) ([alesapin](https://github.com/alesapin)).
* 在 `JOIN ON` 部分中的 `arrayJoin()` 函数上抛出错误. [#13330](https://github.com/ClickHouse/ClickHouse/pull/13330) ([Artem Zuikov](https://github.com/4ertus2)).
* 使用 `join_use_nulls=1` 修复 `LEFT ASOF JOIN` 中的崩溃. [#13291](https://github.com/ClickHouse/ClickHouse/pull/13291) ([Artem Zuikov](https://github.com/4ertus2)).
* 在从延迟副本查询的情况下, 修复可能的错误 `Totals having transform was already added to pipeline` . [#13290](https://github.com/ClickHouse/ClickHouse/pull/13290) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* 如果用户将特制的参数传递给函数 `h3ToChildren`, 服务器可能会崩溃. 这修复了 [#13275](https://github.com/ClickHouse/ClickHouse/issues/13275). [#13277](https://github.com/ClickHouse/ClickHouse/pull/13277) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 修复了在具有 NaN 值的 Float 类型上调用的 `uniqExact`、`topK`、`sumDistinct` 和类似聚合函数的潜在低性能和稍微不正确的结果. 它还在调试版本中触发断言. 这修复了 [#12491](https://github.com/ClickHouse/ClickHouse/issues/12491). [#13254](https://github.com/ClickHouse/ClickHouse/pull/13254) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 当主键包含具有单调函数的表达式并且查询包含与类型不同的常量的比较时, 修复 KeyCondition 中的断言. 这修复了[#12465](https://github.com/ClickHouse/ClickHouse/issues/12465). [#13251](https://github.com/ClickHouse/ClickHouse/pull/13251) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 返回在函数 roundUpToPowerOfTwoOrZero() 中设置了 MSB 的数字的传递数字. 它可以防止数组大小溢出时的潜在错误. [#13234](https://github.com/ClickHouse/ClickHouse/pull/13234) ([Azat Khuzhin](https://github.com/azat)).
* 如果使用可为空的 constexpr 作为不是文字 NULL 的 cond, 则修复函数. 修复 [#12463](https://github.com/ClickHouse/ClickHouse/issues/12463). [#13226](https://github.com/ClickHouse/ClickHouse/pull/13226) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 在数组元素为 Nullable 且数组下标也可为 Null 的情况下, 修复 `arrayElement` 函数中的断言. 这修复了 [#12172](https://github.com/ClickHouse/ClickHouse/issues/12172). [#13224](https://github.com/ClickHouse/ClickHouse/pull/13224) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 使用常量参数修复 DateTime64 转换函数. [#13205](https://github.com/ClickHouse/ClickHouse/pull/13205) ([Azat Khuzhin](https://github.com/azat)).
* 当数据库或表的名称包含点时, 修复从 users.xml 解析行策略. 这修复了 [#5779](https://github.com/ClickHouse/ClickHouse/issues/5779), [#12527](https://github.com/ClickHouse/ClickHouse/issues/12527). [#13199](https://github.com/ClickHouse/ClickHouse/pull/13199) ([Vitaly Baranov](https://github.com/vitlibar)).
* 在连接断开一次后修复对 `redis` 字典的访问. `cache` 和 `direct` 字典布局可能会发生这种情况. [#13082](https://github.com/ClickHouse/ClickHouse/pull/13082) ([Anton Popov](https://github.com/CurtizJ)).
* 使用函数修复错误的索引分析. 从 `MergeTree` 表中读取时, 可能会导致跳过某些数据部分. 修复 [#13060](https://github.com/ClickHouse/ClickHouse/issues/13060). Fixes [#12406](https://github.com/ClickHouse/ClickHouse/issues/12406). [#13081](https://github.com/ClickHouse/ClickHouse/pull/13081) ([Anton Popov](https://github.com/CurtizJ)).
* 修复错误 `Cannot convert column because it is constant but values of constants are different in source and result` , 远程查询在查询范围内使用确定性函数, 但查询之间不具有确定性, 例如`now()`、`now64()`、`randConstant()`. 修复 [#11327](https://github.com/ClickHouse/ClickHouse/issues/11327). [#13075](https://github.com/ClickHouse/ClickHouse/pull/13075) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* 修复了使用 `ORDER BY` 元组和小 `LIMIT` 查询时可能发生的崩溃. 修复 [#12623](https://github.com/ClickHouse/ClickHouse/issues/12623). [#13009](https://github.com/ClickHouse/ClickHouse/pull/13009) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* 修复带有 `UNION` 和 `JOIN` 的查询的 `Block structure mismatch` 错误. 修复 [#12602](https://github.com/ClickHouse/ClickHouse/issues/12602). [#12989](https://github.com/ClickHouse/ClickHouse/pull/12989) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* 更正了 `merge_with_ttl_timeout` 逻辑, 当过期影响一个时间间隔内的多个分区时, 该逻辑无法正常工作. (作者 @excitoon). [#12982](https://github.com/ClickHouse/ClickHouse/pull/12982) ([Alexander Kazakov](https://github.com/Akazz)).
* 修复从 DDL 查询创建的范围哈希字典的列重复. 这修复了[#10605](https://github.com/ClickHouse/ClickHouse/issues/10605). [#12857](https://github.com/ClickHouse/ClickHouse/pull/12857) ([alesapin](https://github.com/alesapin)).
* 修复对从本地副本中选择的线程数的不必要限制. [#12840](https://github.com/ClickHouse/ClickHouse/pull/12840) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* 修复了当 `ALTER DELETE` 和 `ALTER MODIFY COLUMN` 查询作为单个突变同时执行时的罕见错误. 错误导致 `count.txt` 中的行数不正确，从而导致部分数据不正确. 此外, 修复了同时使用 `ALTER RENAME COLUMN` 和 `ALTER ADD COLUMN` 的小错误. [#12760](https://github.com/ClickHouse/ClickHouse/pull/12760) ([alesapin](https://github.com/alesapin)).
* 使用 `clickhouse` 字典源查询远程表时使用了错误的凭据. [#12756](https://github.com/ClickHouse/ClickHouse/pull/12756) ([sundyli](https://github.com/sundy-li)).
* 修复 `CAST(Nullable(String), Enum())`. [#12745](https://github.com/ClickHouse/ClickHouse/pull/12745) ([Azat Khuzhin](https://github.com/azat)).
* 修复大元组的性能，这些元组在`IN` 部分被解释为函数. 当用户出于某种晦涩的原因编写 `WHERE x IN tuple(1, 2, ...)` 而不是 `WHERE x IN (1, 2, ...)` 的情况. [#12700](https://github.com/ClickHouse/ClickHouse/pull/12700) ([Anton Popov](https://github.com/CurtizJ)).
* 修复 input_format_parallel_parsing 的内存跟踪 (通过将线程附加到组). [#12672](https://github.com/ClickHouse/ClickHouse/pull/12672) ([Azat Khuzhin](https://github.com/azat)).
* 在 `any(func(<lambda>))` 的情况下修复错误的优化 `optimize_move_functions_out_of_any=1`. [#12664](https://github.com/ClickHouse/ClickHouse/pull/12664) ([Artem Zuikov](https://github.com/4ertus2)).
* 修复了 [#10572](https://github.com/ClickHouse/ClickHouse/issues/10572) 使用 const 表达式修复布隆过滤器索引. [#12659](https://github.com/ClickHouse/ClickHouse/pull/12659) ([Winter Zhang](https://github.com/zhang2014)).
* 当代理不可用时 (不仅如此) 修复 StorageKafka 中的 SIGSEGV. [#12658](https://github.com/ClickHouse/ClickHouse/pull/12658) ([Azat Khuzhin](https://github.com/azat)).
* 添加对带有 `Array(UUID)` 参数的函数 `if` 的支持. 这修复了 [#11066](https://github.com/ClickHouse/ClickHouse/issues/11066). [#12648](https://github.com/ClickHouse/ClickHouse/pull/12648) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 如果用户存在, CREATE USER IF NOT EXISTS 现在不会抛出异常. 这修复了[#12507](https://github.com/ClickHouse/ClickHouse/issues/12507). [#12646](https://github.com/ClickHouse/ClickHouse/pull/12646) ([Vitaly Baranov](https://github.com/vitlibar)).
* 在意外情况下 (例如从 UInt64 列中减去时),在 `ALTER ... UPDATE` 期间可以抛出异常 `There is no supertype...`. 这修复了 [#7306](https://github.com/ClickHouse/ClickHouse/issues/7306). This fixes [#4165](https://github.com/ClickHouse/ClickHouse/issues/4165). [#12633](https://github.com/ClickHouse/ClickHouse/pull/12633) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 修复使用外部排序的查询可能出现的 `Pipeline stuck` 错误. 修复 [#12617](https://github.com/ClickHouse/ClickHouse/issues/12617). [#12618](https://github.com/ClickHouse/ClickHouse/pull/12618) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* 修复 `OPTIMIZE DEDUPLICATE` 的错误 `Output of TreeExecutor is not sorted` . 修复 [#11572](https://github.com/ClickHouse/ClickHouse/issues/11572). [#12613](https://github.com/ClickHouse/ClickHouse/pull/12613) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* 修复查询优化过程中函数 `any` 结果的别名可能丢失的问题. [#12593](https://github.com/ClickHouse/ClickHouse/pull/12593) ([Anton Popov](https://github.com/CurtizJ)).
* 在 DROP TABLE 上删除分布式表 (来自异步插入的块) 的数据. [#12556](https://github.com/ClickHouse/ClickHouse/pull/12556) ([Azat Khuzhin](https://github.com/azat)).
现在 ClickHouse 将在文件 `checksums.txt` 不存在时重新计算部件的校验和. 自 [#9827](https://github.com/ClickHouse/ClickHouse/issues/9827) 以来已损坏. [#12545](https://github.com/ClickHouse/ClickHouse/pull/12545) ([alesapin](https://github.com/alesapin)).
* 修复当 `enable_mixed_granularity_parts=1` 时, 在 `ALTER DELETE` 查询后导致旧部件损坏的错误. 修复 [#12536](https://github.com/ClickHouse/ClickHouse/issues/12536). [#12543](https://github.com/ClickHouse/ClickHouse/pull/12543) ([alesapin](https://github.com/alesapin)).
* 修复实时视图表中可能导致数据重复的竞争条件. LIVE VIEW 是一项实验性功能. [#12519](https://github.com/ClickHouse/ClickHouse/pull/12519) ([vzakaznikov](https://github.com/vzakaznikov)).
* 修复 `AggregateFunction(avg, ...)`值二进制格式的向后兼容性. 这修复了 [#12342](https://github.com/ClickHouse/ClickHouse/issues/12342). [#12486](https://github.com/ClickHouse/ClickHouse/pull/12486) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 当我们加入字典键的表达时, 修复 JOIN 与字典中的崩溃: `t JOIN dict ON expr(dict.id) = t.id`. 在这种情况下禁用字典连接优化. [#12458](https://github.com/ClickHouse/ClickHouse/pull/12458) ([Artem Zuikov](https://github.com/4ertus2)).
* 当指定非常大的 LIMIT 或 OFFSET 时修复溢出. 这修复了 [#10470](https://github.com/ClickHouse/ClickHouse/issues/10470). 这修复了 [#11372](https://github.com/ClickHouse/ClickHouse/issues/11372). [#12427](https://github.com/ClickHouse/ClickHouse/pull/12427) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* kafka: 修复 SIGSEGV 如果在批处理中间有错误消息. [#12302](https://github.com/ClickHouse/ClickHouse/pull/12302) ([Azat Khuzhin](https://github.com/azat)).

#### 改进

* 在 ZooKeeper 中保留少量日志. 当有许多服务器/表/插入时, 避免在离线副本的情况下过度增长 ZooKeeper 节点. [#13100](https://github.com/ClickHouse/ClickHouse/pull/13100) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 现在, 如果在 ALTER 或突变期间发生错误, 则异常会转发给客户端. 关闭 [#11329](https://github.com/ClickHouse/ClickHouse/issues/11329). [#12666](https://github.com/ClickHouse/ClickHouse/pull/12666) ([alesapin](https://github.com/alesapin)).
* 将 `QueryTimeMicroseconds`、`SelectQueryTimeMicroseconds` 和 `InsertQueryTimeMicroseconds` 添加到 `system.events`, 以及 system.metrics、processes、query_log 等. [#13028](https://github.com/ClickHouse/ClickHouse/pull/13028) ([ianton-ru](https://github.com/ianton-ru)).
* 将 `SelectedRows` 和 `SelectedBytes` 添加到 `system.events`, 以及 system.metrics、processes、query_log 等. [#12638](https://github.com/ClickHouse/ClickHouse/pull/12638) ([ianton-ru](https://github.com/ianton-ru)).
* 将 `current_database` 信息添加到 `system.query_log`. [#12652](https://github.com/ClickHouse/ClickHouse/pull/12652) ([Amos Bird](https://github.com/amosbird)).
* 允许 `TabSeparatedRaw` 作为输入格式. [#12009](https://github.com/ClickHouse/ClickHouse/pull/12009) ([hcz](https://github.com/hczhcz)).
* 现在 `joinGet` 支持多键查找. [#12418](https://github.com/ClickHouse/ClickHouse/pull/12418) ([Amos Bird](https://github.com/amosbird)).
* 允许 `*Map` 聚合函数处理带有 NULL 的数组. 修复 [#13157](https://github.com/ClickHouse/ClickHouse/issues/13157). [#13225](https://github.com/ClickHouse/ClickHouse/pull/13225) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 避免解析 DateTime 值时溢出, 这将导致其时区中的 unix 时间戳为负 (例如, 莫斯科的 `1970-01-01 00:00:00` ). 相反, 饱和为零. 这修复了 [#3470](https://github.com/ClickHouse/ClickHouse/issues/3470). This fixes [#4172](https://github.com/ClickHouse/ClickHouse/issues/4172). [#12443](https://github.com/ClickHouse/ClickHouse/pull/12443) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* AvroConfluent: 跳过 Kafka 墓碑记录 - 支持跳过损坏的记录 [#13203](https://github.com/ClickHouse/ClickHouse/pull/13203) ([Andrew Onyshchuk](https://github.com/oandrew)).
* 修复长查询的错误错误. 为了正确查询, 可能会出现除 `Max query size exceeded` 之外的语法错误. [#13928](https://github.com/ClickHouse/ClickHouse/pull/13928) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* 修复 `lgamma` 函数中的数据竞争. 这场比赛只在 `tsan` 中被抓到，真的没有副作用. [#13842](https://github.com/ClickHouse/ClickHouse/pull/13842) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* 修复 ATTACH/ALTER/CREATE QUOTA 语句的 `Week` 间隔格式. [#13417](https://github.com/ClickHouse/ClickHouse/pull/13417) ([vladimir-golovchenko](https://github.com/vladimir-golovchenko)).
* 现在, 在紧凑零件加工中遇到损坏零件时也会报告. 紧凑型零件是一项实验性功能. [#13282](https://github.com/ClickHouse/ClickHouse/pull/13282) ([Amos Bird](https://github.com/amosbird)).
* 修复 `geohashesInBox` 中的断言. 这修复了 [#12554](https://github.com/ClickHouse/ClickHouse/issues/12554). [#13229](https://github.com/ClickHouse/ClickHouse/pull/13229) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 修复 `parseDateTimeBestEffort` 中的断言. 这修复了 [#12649](https://github.com/ClickHouse/ClickHouse/issues/12649). [#13227](https://github.com/ClickHouse/ClickHouse/pull/13227) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* Processors/PipelineExecutor 中的小优化: 跳出循环, 因为这样做很有意义. [#13058](https://github.com/ClickHouse/ClickHouse/pull/13058) ([Mark Papadakis](https://github.com/markpapadakis)).
* 支持不带 TABLE 关键字的 TRUNCATE 表. [#12653](https://github.com/ClickHouse/ClickHouse/pull/12653) ([Winter Zhang](https://github.com/zhang2014)).
* 修复默认情况下解释查询格式覆盖. 这修复了 [#12541](https://github.com/ClickHouse/ClickHouse/issues/12432). [#12541](https://github.com/ClickHouse/ClickHouse/pull/12541) ([BohuTANG](https://github.com/BohuTANG)).
* 允许以更标准的方式设置 JOIN 种类和类型: `LEFT SEMI JOIN` 而不是 `SEMI LEFT JOIN`. 目前两者都是正确的. [#12520](https://github.com/ClickHouse/ClickHouse/pull/12520) ([Artem Zuikov](https://github.com/4ertus2)).
* 将 `multiple_joins_rewriter_version` 的默认值更改为 2. 它启用知道列名的新的多连接重写器. [#12469](https://github.com/ClickHouse/ClickHouse/pull/12469) ([Artem Zuikov](https://github.com/4ertus2)).
* 为对 S3 存储的请求添加多个指标. [#12464](https://github.com/ClickHouse/ClickHouse/pull/12464) ([ianton-ru](https://github.com/ianton-ru)).
* 使用 `--secure` 参数为clickhouse-benchmark使用正确的默认安全端口. 这修复了 [#11044](https://github.com/ClickHouse/ClickHouse/issues/11044). [#12440](https://github.com/ClickHouse/ClickHouse/pull/12440) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* `Log`、`TinyLog`、`StripeLog` 引擎中的回滚插入错误. 在以前的版本中, 插入错误会导致表状态不一致 (这按照文档工作，对于这些表引擎来说是正常的). 这修复了 [#12402](https://github.com/ClickHouse/ClickHouse/issues/12402). [#12426](https://github.com/ClickHouse/ClickHouse/pull/12426) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 为`Atomic` 数据库引擎实现`RENAME DATABASE` 和`RENAME DICTIONARY` - 添加隐式`{uuid}` 宏, 可在`ReplicatedMergeTree` 的ZooKeeper 路径中使用. 它适用于 `CREATE ... ON CLUSTER ...` 查询. 将 `show_table_uuid_in_table_create_query_if_not_nil` 设置为 `true` 以使用它. - 将 `ReplicatedMergeTree` 引擎参数设为可选, 默认使用 `/clickhouse/tables/{uuid}/{shard}/` 和 `{replica}`. 关闭 [#12135](https://github.com/ClickHouse/ClickHouse/issues/12135). - 小修正. - 这些更改破坏了 `Atomic` 数据库引擎的向后兼容性. 以前创建的“原子”数据库必须手动转换为新格式. 原子数据库是一个实验性功能. [#12343](https://github.com/ClickHouse/ClickHouse/pull/12343) ([tavplubix](https://github.com/tavplubix)).
* 将 `AWSAuthV4Signer` 分离到不同的记录器中, 从日志消息中删除过多的 `AWSClient: AWSClient`. [#12320](https://github.com/ClickHouse/ClickHouse/pull/12320) ([Vladimir Chebotarev](https://github.com/excitoon)).
* 磁盘访问存储中更好的异常消息. [#12625](https://github.com/ClickHouse/ClickHouse/pull/12625) ([alesapin](https://github.com/alesapin)).
* 参数数目无效的函数 `in` 的更好例外. [#12529](https://github.com/ClickHouse/ClickHouse/pull/12529) ([Anton Popov](https://github.com/CurtizJ)).
* 修复有关自适应粒度的错误消息. [#12624](https://github.com/ClickHouse/ClickHouse/pull/12624) ([alesapin](https://github.com/alesapin)).
* 修复格式化后的设置解析. [#12480](https://github.com/ClickHouse/ClickHouse/pull/12480) ([Azat Khuzhin](https://github.com/azat)).
* 如果 MergeTree 表不包含 ORDER BY 或 PARTITION BY, 则可能会请求 ALTER 清除所有列, 而 ALTER 将卡住. 已修复 [#7941](https://github.com/ClickHouse/ClickHouse/issues/7941). [#12382](https://github.com/ClickHouse/ClickHouse/pull/12382) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 避免在每次查询后从历史文件重新加载完成 (以避免历史与其他客户端会话重叠). [#13086](https://github.com/ClickHouse/ClickHouse/pull/13086) ([Azat Khuzhin](https://github.com/azat)).

#### 性能改进

* 某些操作的内存使用量降低高达 2 倍. [#12424](https://github.com/ClickHouse/ClickHouse/pull/12424) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 针对匹配精确 PK 范围的查询优化 PK 查找. [#12277](https://github.com/ClickHouse/ClickHouse/pull/12277) ([Ivan Babrou](https://github.com/bobrik)).
* 使用 `LowCardinality` 稍微优化非常短的查询. [#14129](https://github.com/ClickHouse/ClickHouse/pull/14129) ([Anton Popov](https://github.com/CurtizJ)).
* 通过 UInt8/UInt16 键略微提高聚合性能. [#13091](https://github.com/ClickHouse/ClickHouse/pull/13091) and [#13055](https://github.com/ClickHouse/ClickHouse/pull/13055) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 下推`LIMIT`步骤查询计划 (在子查询内). [#13016](https://github.com/ClickHouse/ClickHouse/pull/13016) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* 并行主键查找和跳过部分的索引阶段, 如 [#11564](https://github.com/ClickHouse/ClickHouse/issues/11564) 中所述. [#12589](https://github.com/ClickHouse/ClickHouse/pull/12589) ([Ivan Babrou](https://github.com/bobrik)).
* 如果 `set optimize_if_transform_strings_to_enum = 1`, 则将函数 `if` 和 `transform` 的字符串类型参数转换为枚举. [#12515](https://github.com/ClickHouse/ClickHouse/pull/12515) ([Artem Zuikov](https://github.com/4ertus2)).
* 如果 `set optimize_monotonous_functions_in_order_by=1`, 则用 `ORDER BY` 中的参数替换单调函数. [#12467](https://github.com/ClickHouse/ClickHouse/pull/12467) ([Artem Zuikov](https://github.com/4ertus2)).
* 通过优化添加顺序, 如果 `set optimize_redundant_functions_in_order_by = 1`, 则用 `ORDER by x` 重写 `ORDER BY x, f(x)` . [#12404](https://github.com/ClickHouse/ClickHouse/pull/12404) ([Artem Zuikov](https://github.com/4ertus2)).
* 当子查询包含`WITH` 子句时允许下推谓词. 这修复了 [#12293](https://github.com/ClickHouse/ClickHouse/issues/12293) [#12663](https://github.com/ClickHouse/ClickHouse/pull/12663) ([Winter Zhang](https://github.com/zhang2014)).
* 提高读取紧凑部件的性能. 紧凑型零件是一项实验性功能. [#12492](https://github.com/ClickHouse/ClickHouse/pull/12492) ([Anton Popov](https://github.com/CurtizJ)).
* 尝试在 `DiskS3` 中实现流优化. DiskS3 是一项实验性功能. [#12434](https://github.com/ClickHouse/ClickHouse/pull/12434) ([Vladimir Chebotarev](https://github.com/excitoon)).

#### 构建/测试/打包改进

* 使用 `shellcheck` 进行 sh 测试 linting. [#13200](https://github.com/ClickHouse/ClickHouse/pull/13200) [#13207](https://github.com/ClickHouse/ClickHouse/pull/13207) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 在 GitHub 挂钩中添加为拉取请求设置标签的脚本. [#13183](https://github.com/ClickHouse/ClickHouse/pull/13183) ([alesapin](https://github.com/alesapin)).
* 删除一些递归子模块. 见 [#13378](https://github.com/ClickHouse/ClickHouse/issues/13378). [#13379](https://github.com/ClickHouse/ClickHouse/pull/13379) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 确保所有子模块都来自正确的 URL. Continuation of [#13379](https://github.com/ClickHouse/ClickHouse/issues/13379). This fixes [#13378](https://github.com/ClickHouse/ClickHouse/issues/13378). [#13397](https://github.com/ClickHouse/ClickHouse/pull/13397) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 添加了对用户声明的设置的支持, 可以从内部查询访问. 当 ClickHouse 引擎用作另一个系统的组件时需要这样做. [#13013](https://github.com/ClickHouse/ClickHouse/pull/13013) ([Vitaly Baranov](https://github.com/vitlibar)).
* 在 TestFlows 中添加了对 INSERT 权限的 RBAC 功能的测试. 正在测试 SELECT 的扩展表. 添加了匹配新表引擎测试的要求. [#13340](https://github.com/ClickHouse/ClickHouse/pull/13340) ([MyroTk](https://github.com/MyroTk)).
* 修复压力测试中服务器重启时超时错误. [#13321](https://github.com/ClickHouse/ClickHouse/pull/13321) ([alesapin](https://github.com/alesapin)).
* 现在快速测试将等待服务器重试. [#13284](https://github.com/ClickHouse/ClickHouse/pull/13284) ([alesapin](https://github.com/alesapin)).
* 函数`materialize()` (用于 ClickHouse 测试的函数) 将按预期为 NULL 工作 - 通过将其转换为非常量列. [#13212](https://github.com/ClickHouse/ClickHouse/pull/13212) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 修复 AArch64 中的 libunwind 构建. 这修复了 [#13204](https://github.com/ClickHouse/ClickHouse/issues/13204). [#13208](https://github.com/ClickHouse/ClickHouse/pull/13208) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 在 zkutil gtest 中进行更多重试以防止测试不稳定. [#13165](https://github.com/ClickHouse/ClickHouse/pull/13165) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 对 RBAC 测试流的小修正. [#13152](https://github.com/ClickHouse/ClickHouse/pull/13152) ([vzakaznikov](https://github.com/vzakaznikov)).
* 修复 `00960_live_view_watch_events_live.py` 测试. [#13108](https://github.com/ClickHouse/ClickHouse/pull/13108) ([vzakaznikov](https://github.com/vzakaznikov)).
* 改进文档部署脚本中的缓存清除. [#13107](https://github.com/ClickHouse/ClickHouse/pull/13107) ([alesapin](https://github.com/alesapin)).
* 重写了一些孤立的测试到gtest. 从测试中移除无用的内容. [#13073](https://github.com/ClickHouse/ClickHouse/pull/13073) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* 在 TestFlows 中添加了对 `SELECT` 权限的 RBAC 功能的测试. [#13061](https://github.com/ClickHouse/ClickHouse/pull/13061) ([Ritaank Tiwari](https://github.com/ritaank)).
* 在快速测试检查中重新运行一些测试. [#12992](https://github.com/ClickHouse/ClickHouse/pull/12992) ([alesapin](https://github.com/alesapin)).
* 修复 `rdkafka` 库中的 MSan 错误. 这将关闭 [#12990](https://github.com/ClickHouse/ClickHouse/issues/12990). 将 `rdkafka` 更新到 1.5 版 (主). [#12991](https://github.com/ClickHouse/ClickHouse/pull/12991) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 如果在带有 AVX-512 的服务器上运行测试, 则修复 base64 中的 UBSan 报告. 这修复了 [#12318](https://github.com/ClickHouse/ClickHouse/issues/12318). 作者: @qoega. [#12441](https://github.com/ClickHouse/ClickHouse/pull/12441) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 修复 HDFS 库中的 UBSan 报告. 这将关闭 [#12330](https://github.com/ClickHouse/ClickHouse/issues/12330). [#12453](https://github.com/ClickHouse/ClickHouse/pull/12453) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 检查我们能够将备份从旧版本恢复到新版本的能力. 这将关闭 [#8979](https://github.com/ClickHouse/ClickHouse/issues/8979). [#12959](https://github.com/ClickHouse/ClickHouse/pull/12959) ([alesapin](https://github.com/alesapin)).
* 不要在集成测试中构建 helper_container 图像. 在 CI 中构建 docker 容器并在集成测试中使用预构建的 helper_container. [#12953](https://github.com/ClickHouse/ClickHouse/pull/12953) ([Ilya Yatsishin](https://github.com/qoega)).
* 为主键列添加对 `ALTER TABLE CLEAR COLUMN` 查询的测试. [#12951](https://github.com/ClickHouse/ClickHouse/pull/12951) ([alesapin](https://github.com/alesapin)).
* 测试流测试中的超时时间增加. [#12949](https://github.com/ClickHouse/ClickHouse/pull/12949) ([vzakaznikov](https://github.com/vzakaznikov)).
* 修复 Mac OS X 下的测试构建. 这将关闭 [#12767](https://github.com/ClickHouse/ClickHouse/issues/12767). [#12772](https://github.com/ClickHouse/ClickHouse/pull/12772) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 连接器-ODBC 更新为 mysql-connector-odbc-8.0.21. [#12739](https://github.com/ClickHouse/ClickHouse/pull/12739) ([Ilya Yatsishin](https://github.com/qoega)).
* 在 TestFlows 中添加 RBAC 语法测试. [#12642](https://github.com/ClickHouse/ClickHouse/pull/12642) ([vzakaznikov](https://github.com/vzakaznikov)).
* 提高 TestKeeper 的性能. 这将加速大量使用复制表的测试. [#12505](https://github.com/ClickHouse/ClickHouse/pull/12505) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 现在我们检查服务器是否能够在压力测试运行后启动. 这修复了 [#12473](https://github.com/ClickHouse/ClickHouse/issues/12473). [#12496](https://github.com/ClickHouse/ClickHouse/pull/12496) ([alesapin](https://github.com/alesapin)).
* 将 fmtlib 更新到 master (7.0.1). [#12446](https://github.com/ClickHouse/ClickHouse/pull/12446) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 添加 docker 镜像以进行快速测试. [#12294](https://github.com/ClickHouse/ClickHouse/pull/12294) ([alesapin](https://github.com/alesapin)).
* 集成测试的返工配置路径. [#12285](https://github.com/ClickHouse/ClickHouse/pull/12285) ([Ilya Yatsishin](https://github.com/qoega)).
* 添加编译器选项以控制堆栈帧不会太大. 这将有助于在具有小堆栈大小的纤程中运行代码. [#11524](https://github.com/ClickHouse/ClickHouse/pull/11524) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 更新 gitignore 文件. [#13447](https://github.com/ClickHouse/ClickHouse/pull/13447) ([vladimir-golovchenko](https://github.com/vladimir-golovchenko)).


## ClickHouse 版本 20.6

### ClickHouse 版本 v20.6.3.28-stable

#### 向后不兼容变更

* 从20.5以上的版本升级时, 如果进行滚动更新, 集群同时包含20.5以上和20.5以下的版本, 如果旧版本的ClickHouse节点重启, 旧版本在新版本存在的情况下启动，可能会导致 到 `Part ... intersects previous part` 错误. 为防止出现此错误，首先在所有集群节点上安装更新的 clickhouse-server 软件包，然后重新启动 (因此, 当 clickhouse-server 重新启动时, 它将以新版本启动).

#### 新特征

* 添加了 `EXPLAIN` 查询的初始实现. 语法: `EXPLAIN SELECT ...`. 这修复了 [#1118](https://github.com/ClickHouse/ClickHouse/issues/1118). [#11873](https://github.com/ClickHouse/ClickHouse/pull/11873) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* 添加了存储 `RabbitMQ` . [#11069](https://github.com/ClickHouse/ClickHouse/pull/11069) ([Kseniia Sumarokova](https://github.com/kssenii)).
* 为 [#11710](https://github.com/ClickHouse/ClickHouse/issues/11710) 实现了类似 PostgreSQL 的 `ILIKE` 操作符. [#12125](https://github.com/ClickHouse/ClickHouse/pull/12125) ([Mike](https://github.com/myrrc)).
* 支持 RIGHT 和 FULL JOIN 与 `SET join_algorithm = 'partial_merge'`. 只允许 ALL 严格 (ANY、SEMI、ANTI、ASOF 不是). [#12118](https://github.com/ClickHouse/ClickHouse/pull/12118) ([Artem Zuikov](https://github.com/4ertus2)).
* 添加了一个函数 `initializeAggregation` 以初始化基于单个值的聚合. [#12109](https://github.com/ClickHouse/ClickHouse/pull/12109) ([Guillaume Tassery](https://github.com/YiuRULE)).
* 支持 `ALTER TABLE ... [ADD|MODIFY] COLUMN ... FIRST` [#4006](https://github.com/ClickHouse/ClickHouse/issues/4006). [#12073](https://github.com/ClickHouse/ClickHouse/pull/12073) ([Winter Zhang](https://github.com/zhang2014)).
* 添加了函数 `parseDateTimeBestEffortUS` . [#12028](https://github.com/ClickHouse/ClickHouse/pull/12028) ([flynn](https://github.com/ucasFL)).
* 支持输出格式 `ORC` (仅支持输入). [#11662](https://github.com/ClickHouse/ClickHouse/pull/11662) ([Kruglov Pavel](https://github.com/Avogar)).

#### Bug 修复

* 修复了 `aggregate function any(x) is found inside another aggregate function in query` 错误, 其中包含 `SET optimize_move_functions_out_of_any = 1` 和 `any()` 中的别名. [#13419](https://github.com/ClickHouse/ClickHouse/pull/13419) ([Artem Zuikov](https://github.com/4ertus2)).
* 修复了 clickhouse-local 的 `PrettyCompactMonoBlock` . 使用 `PrettyCompactMonoBlock` 修复了极端/总数. 这修复了 [#7746](https://github.com/ClickHouse/ClickHouse/issues/7746). [#13394](https://github.com/ClickHouse/ClickHouse/pull/13394) ([Azat Khuzhin](https://github.com/azat)).
* 修复了在从延迟副本查询的情况下可能出现的错误 `Totals having transform was already added to pipeline` . [#13290](https://github.com/ClickHouse/ClickHouse/pull/13290) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* 如果用户将特制的参数传递给函数 `h3ToChildren`, 服务器可能会崩溃. 这修复了 [#13275](https://github.com/ClickHouse/ClickHouse/issues/13275). [#13277](https://github.com/ClickHouse/ClickHouse/pull/13277) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 修复了在具有 NaN 值的 Float 类型上调用的 `uniqExact`、`topK`、`sumDistinct` 和类似聚合函数的潜在低性能和稍微不正确的结果. 它还在调试版本中触发断言. 这修复了 [#12491](https://github.com/ClickHouse/ClickHouse/issues/12491). [#13254](https://github.com/ClickHouse/ClickHouse/pull/13254) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 修复了如果以nullable constexpr为cond, 则不是字面量 NULL 问题. 修复 [#12463](https://github.com/ClickHouse/ClickHouse/issues/12463). [#13226](https://github.com/ClickHouse/ClickHouse/pull/13226) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 在数组元素为 Nullable 且数组下标也可为 Null 的情况下, 修复了 `arrayElement` 函数中的断言. 这修复了 [#12172](https://github.com/ClickHouse/ClickHouse/issues/12172). [#13224](https://github.com/ClickHouse/ClickHouse/pull/13224) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 修复了带有常量参数的 `DateTime64` 转换函数. [#13205](https://github.com/ClickHouse/ClickHouse/pull/13205) ([Azat Khuzhin](https://github.com/azat)).
* 用函数修正了错误的索引分析. 在从 `MergeTree` 表中读取时, 它可能会导致修剪错误的部分. 修复 [#13060](https://github.com/ClickHouse/ClickHouse/issues/13060). Fixes [#12406](https://github.com/ClickHouse/ClickHouse/issues/12406). [#13081](https://github.com/ClickHouse/ClickHouse/pull/13081) ([Anton Popov](https://github.com/CurtizJ)).
* 修复了错误 `Cannot convert column because it is constant but values of constants are different in source and result`, 远程查询在查询范围内使用确定性函数, 但查询之间不具有确定性, 例如 `now()`、`now64()`、`randConstant()`. 修复 [#11327](https://github.com/ClickHouse/ClickHouse/issues/11327). [#13075](https://github.com/ClickHouse/ClickHouse/pull/13075) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* 修复了对从本地副本进行选择的线程数的不必要限制. [#12840](https://github.com/ClickHouse/ClickHouse/pull/12840) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* 修复了当 `ALTER DELETE` 和 `ALTER MODIFY COLUMN` 查询作为单个突变同时执行时的罕见错误. 错误导致 `count.txt` 中的行数不正确, 从而导致部分数据不正确. 另外, 修复了一个同时使用`ALTER RENAME COLUMN`和`ALTER ADD COLUMN` 的小错误. [#12760](https://github.com/ClickHouse/ClickHouse/pull/12760) ([alesapin](https://github.com/alesapin)).
* 修复了 `CAST(Nullable(String), Enum())`. [#12745](https://github.com/ClickHouse/ClickHouse/pull/12745) ([Azat Khuzhin](https://github.com/azat)).
* 修复了大元组的性能, 这些元组在 `IN` 部分被解释为函数. 当用户出于某种晦涩的原因编写 `WHERE x IN tuple(1, 2, ...)` 而不是 `WHERE x IN (1, 2, ...)` 的情况. [#12700](https://github.com/ClickHouse/ClickHouse/pull/12700) ([Anton Popov](https://github.com/CurtizJ)).
* 修复了 `input_format_parallel_parsing` 的内存跟踪 (通过将线程附加到组). [#12672](https://github.com/ClickHouse/ClickHouse/pull/12672) ([Azat Khuzhin](https://github.com/azat)).
* 使用 const 表达式修复了布隆过滤器索引. 这修复了 [#10572](https://github.com/ClickHouse/ClickHouse/issues/10572). [#12659](https://github.com/ClickHouse/ClickHouse/pull/12659) ([Winter Zhang](https://github.com/zhang2014)).
* 修复了当 Broker 不可用时 (不仅如此) 在 `StorageKafka` 中的 `SIGSEGV`. [#12658](https://github.com/ClickHouse/ClickHouse/pull/12658) ([Azat Khuzhin](https://github.com/azat)).
* 添加了对带有 `Array(UUID)` 参数的函数 `if` 的支持. 这修复了 [#11066](https://github.com/ClickHouse/ClickHouse/issues/11066). [#12648](https://github.com/ClickHouse/ClickHouse/pull/12648) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 如果用户存在, `CREATE USER IF NOT EXISTS` 现在不会抛出异常. 这修复了 [#12507](https://github.com/ClickHouse/ClickHouse/issues/12507). [#12646](https://github.com/ClickHouse/ClickHouse/pull/12646) ([Vitaly Baranov](https://github.com/vitlibar)).
* 磁盘访问存储中更好的异常消息. [#12625](https://github.com/ClickHouse/ClickHouse/pull/12625) ([alesapin](https://github.com/alesapin)).
* 函数 `groupArrayMoving*` 不适用于分布式查询. 它的结果是在不正确的数据类型中计算的 (没有升级到最大的类型). `groupArrayMovingAvg` 函数返回的整数与 `avg` 函数不一致. 这修复了 [#12568](https://github.com/ClickHouse/ClickHouse/issues/12568). [#12622](https://github.com/ClickHouse/ClickHouse/pull/12622) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 修复了函数 `any` 缺少别名的问题. [#12593](https://github.com/ClickHouse/ClickHouse/pull/12593) ([Anton Popov](https://github.com/CurtizJ)).
* 修复了带有缓存布局的外部字典中的竞争条件, 这可能导致服务器崩溃. [#12566](https://github.com/ClickHouse/ClickHouse/pull/12566) ([alesapin](https://github.com/alesapin)).
* 在 DROP TABLE 上删除分布式表 (来自异步插入的块) 的数据. [#12556](https://github.com/ClickHouse/ClickHouse/pull/12556) ([Azat Khuzhin](https://github.com/azat)).
* 修复了当 `enable_mixed_granularity_parts=1` 时, 在 `ALTER DELETE` 查询后导致旧部件损坏的错误. 修复 [#12536](https://github.com/ClickHouse/ClickHouse/issues/12536). [#12543](https://github.com/ClickHouse/ClickHouse/pull/12543) ([alesapin](https://github.com/alesapin)).
* 参数数目无效的函数 `in` 的更好例外. [#12529](https://github.com/ClickHouse/ClickHouse/pull/12529) ([Anton Popov](https://github.com/CurtizJ)).
* 修复实时视图表中可能导致数据重复的竞争条件. [#12519](https://github.com/ClickHouse/ClickHouse/pull/12519) ([vzakaznikov](https://github.com/vzakaznikov)).
* 修正了从合并部分读取时的性能问题. [#12492](https://github.com/ClickHouse/ClickHouse/pull/12492) ([Anton Popov](https://github.com/CurtizJ)).
* 修复了 `AggregateFunction(avg, ...)` 值的二进制格式的向后兼容性. 这修复了 [#12342](https://github.com/ClickHouse/ClickHouse/issues/12342). [#12486](https://github.com/ClickHouse/ClickHouse/pull/12486) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 固定设置解析格式后. [#12480](https://github.com/ClickHouse/ClickHouse/pull/12480) ([Azat Khuzhin](https://github.com/azat)).
* 修复了启用 `text_log` 时的死锁. [#12452](https://github.com/ClickHouse/ClickHouse/pull/12452) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 修复了指定非常大的 `LIMIT` 或 `OFFSET` 时的溢出. 这修复了 [#10470](https://github.com/ClickHouse/ClickHouse/issues/10470). This fixes [#11372](https://github.com/ClickHouse/ClickHouse/issues/11372). [#12427](https://github.com/ClickHouse/ClickHouse/pull/12427) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 如果 `StorageMerge` , 则修复了可能的段错误. 这修复了 [#12054](https://github.com/ClickHouse/ClickHouse/issues/12054). [#12401](https://github.com/ClickHouse/ClickHouse/pull/12401) ([tavplubix](https://github.com/tavplubix)).
* 恢复在 [#11079](https://github.com/ClickHouse/ClickHouse/issues/11079) 中引入的更改以解决 [#12098](https://github.com/ClickHouse/ClickHouse/issues/12098). [#12397](https://github.com/ClickHouse/ClickHouse/pull/12397) ([Mike](https://github.com/myrrc)).
* 额外检查布隆过滤器索引的参数. 这修复了 [#11408](https://github.com/ClickHouse/ClickHouse/issues/11408). [#12388](https://github.com/ClickHouse/ClickHouse/pull/12388) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 在索引表的 WHERE 条件中使用负数或浮点常量时避免异常. 这修复了 [#11905](https://github.com/ClickHouse/ClickHouse/issues/11905). [#12384](https://github.com/ClickHouse/ClickHouse/pull/12384) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 在索引表的 WHERE 条件中使用负数或浮点常量时避免异常. 这修复了 [#12333](https://github.com/ClickHouse/ClickHouse/issues/12333). [#12378](https://github.com/ClickHouse/ClickHouse/pull/12378) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 修复带有 `-State` 和 `Nullable` 参数的聚合函数的 `TOTALS/ROLLUP/CUBE`. 这修复了 [#12163](https://github.com/ClickHouse/ClickHouse/issues/12163). [#12376](https://github.com/ClickHouse/ClickHouse/pull/12376) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 修复了在不允许使用 `RENAME` 时, `ALTER RENAME COLUMN` 查询的错误消息和退出代码. 修复 [#12301](https://github.com/ClickHouse/ClickHouse/issues/12301) 和 [#12303](https://github.com/ClickHouse/ClickHouse/issues/12303). [#12335](https://github.com/ClickHouse/ClickHouse/pull/12335) ([alesapin](https://github.com/alesapin)).
* 修复了 `ReplicatedMergeTree Queue` 中非常罕见的竞争条件. [#12315](https://github.com/ClickHouse/ClickHouse/pull/12315) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 当使用具有非固定宽度类型的编解码器 `Delta` 或 `DoubleDelta` 时, 返回代码为 `LOGICAL_ERROR` 的异常而不是代码为 `BAD_ARGUMENTS` 的异常 (我们确保代码逻辑错误的异常永远不会发生). 这修复了 [#12110](https://github.com/ClickHouse/ClickHouse/issues/12110). [#12308](https://github.com/ClickHouse/ClickHouse/pull/12308) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 修复了 `WITH FILL` 修饰符中列的顺序. 以前不遵守 `ORDER BY` 语句的列顺序. [#12306](https://github.com/ClickHouse/ClickHouse/pull/12306) ([Anton Popov](https://github.com/CurtizJ)).
* 当存在按虚拟列 (如 `Merge` 表中的 `_table`) 或系统表中的 "index" 列过滤数据 (例如从 `system.tables` 查询时按数据库名称过滤) 时, 避免 `bad cast`  异常 `, 并且这个表达式返回 `Nullable` 类型. 这修复了 [#12166](https://github.com/ClickHouse/ClickHouse/issues/12166). [#12305](https://github.com/ClickHouse/ClickHouse/pull/12305) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 修复了重命名列后的 `TTL`, 它依赖于 TTL 表达式. [#12304](https://github.com/ClickHouse/ClickHouse/pull/12304) ([Anton Popov](https://github.com/CurtizJ)).
* 修复了 SIGSEGV 如果在 `Kafka` 引擎中批处理中间有错误消息. [#12302](https://github.com/ClickHouse/ClickHouse/pull/12302) ([Azat Khuzhin](https://github.com/azat)).
* 修复了 `DNS` 缓存更新过程中某些线程可能会随机挂起几秒钟的情况. [#12296](https://github.com/ClickHouse/ClickHouse/pull/12296) ([tavplubix](https://github.com/tavplubix)).
* 修复了设置名称中的错字. [#12292](https://github.com/ClickHouse/ClickHouse/pull/12292) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* `TrieDictionary` 加载失败后显示错误. [#12290](https://github.com/ClickHouse/ClickHouse/pull/12290) ([Vitaly Baranov](https://github.com/vitlibar)).
* 对于可能导致崩溃的空数组, 函数 `arrayFill` 工作不正确. 这修复了 [#12263](https://github.com/ClickHouse/ClickHouse/issues/12263). [#12279](https://github.com/ClickHouse/ClickHouse/pull/12279) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 实现到 `LowCardinality` 类型的公共类型的转换. 这允许对具有 LowCardinality 列和其他列的表执行 UNION ALL. 这修复了 [#8212](https://github.com/ClickHouse/ClickHouse/issues/8212). 这修复了 [#4342](https://github.com/ClickHouse/ClickHouse/issues/4342). [#12275](https://github.com/ClickHouse/ClickHouse/pull/12275) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 修复了在对 `S3` 存储的请求中达到重定向限制的行为. [#12256](https://github.com/ClickHouse/ClickHouse/pull/12256) ([ianton-ru](https://github.com/ianton-ru)).
* 修复了在某些特殊类型的 `StorageFile` 标头中多次连续插入期间多次写入时的行为. 这个修复了 [#6155](https://github.com/ClickHouse/ClickHouse/issues/6155). [#12197](https://github.com/ClickHouse/ClickHouse/pull/12197) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* 修复了 UInt8 值不等于 0 或 1 时的逻辑函数. [#12196](https://github.com/ClickHouse/ClickHouse/pull/12196) ([Alexander Kazakov](https://github.com/Akazz)).
* 上限 max_memory_usage* 限制为进程驻留内存. [#12182](https://github.com/ClickHouse/ClickHouse/pull/12182) ([Azat Khuzhin](https://github.com/azat)).
* 在 `GROUP BY` 内射函数消除期间修复 dictGet 参数检查. [#12179](https://github.com/ClickHouse/ClickHouse/pull/12179) ([Azat Khuzhin](https://github.com/azat)).
* 修复了当 `SummingMergeTree` 引擎从分区键中汇总列时的行为. 在列的显式定义与分区键列相交的情况下添加了一个例外. 这修复了 [#7867](https://github.com/ClickHouse/ClickHouse/issues/7867). [#12173](https://github.com/ClickHouse/ClickHouse/pull/12173) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* 如果 ODBC 连接不支持架构, 则不要将字典源的表名拆分为架构和表名本身. [#12165](https://github.com/ClickHouse/ClickHouse/pull/12165) ([Vitaly Baranov](https://github.com/vitlibar)).
* 修复了 `ALTER DELETE` 中的错误逻辑, 当条件评估为 NULL 时会导致删除记录. 这修复了 [#9088](https://github.com/ClickHouse/ClickHouse/issues/9088). This closes [#12106](https://github.com/ClickHouse/ClickHouse/issues/12106). [#12153](https://github.com/ClickHouse/ClickHouse/pull/12153) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 修复了在存在别名的情况下发送到外部 DBMS (例如 MySQL、ODBC) 的查询转换. 这修复了[#12032](https://github.com/ClickHouse/ClickHouse/issues/12032). [#12151](https://github.com/ClickHouse/ClickHouse/pull/12151) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 修复了冗余 ORDER BY 优化中的错误代码. 该错误是在 [#10067](https://github.com/ClickHouse/ClickHouse/issues/10067) 中引入的. [#12148](https://github.com/ClickHouse/ClickHouse/pull/12148) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 修复了整数除法中的潜在溢出. 这修复了 [#12119](https://github.com/ClickHouse/ClickHouse/issues/12119). [#12140](https://github.com/ClickHouse/ClickHouse/pull/12140) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 修复了 `greatCircleDistance`、`geoDistance` 中潜在的无限循环. 这修复了 [#12117](https://github.com/ClickHouse/ClickHouse/issues/12117). [#12137](https://github.com/ClickHouse/ClickHouse/pull/12137) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 规范化 `pid` 文件处理. 在以前的版本中, 如果服务器在没有正确关闭的情况下被杀死, 并且有另一个进程与以前运行的服务器具有相同的 pid, 则服务器可能会拒绝启动. 即使有另一台服务器正在运行, pid 文件也可能在服务器启动失败时被删除. 这修复了 [#3501](https://github.com/ClickHouse/ClickHouse/issues/3501). [#12133](https://github.com/ClickHouse/ClickHouse/pull/12133) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 修复了导致 ZooKeepeer 中 ReplicatedVersionedCollapsingMergeTree 表的表元数据不正确的错误. 修复 [#12093](https://github.com/ClickHouse/ClickHouse/issues/12093). [#12121](https://github.com/ClickHouse/ClickHouse/pull/12121) ([alesapin](https://github.com/alesapin)).
* 对于具有连接或附加到系统日志 (system.query_log、metric_log 等) 或 engine=Buffer 基础表的子查询的物化视图, 避免 `There is no query` 异常. [#12120](https://github.com/ClickHouse/ClickHouse/pull/12120) ([filimonov](https://github.com/filimonov)).
* 修复了对字典的 ENGINE=Dictionary 表的处理依赖性. 这修复了 [#10994](https://github.com/ClickHouse/ClickHouse/issues/10994). 这修复了 [#10397](https://github.com/ClickHouse/ClickHouse/issues/10397). [#12116](https://github.com/ClickHouse/ClickHouse/pull/12116) ([Vitaly Baranov](https://github.com/vitlibar)).
* 格式 `Parquet` 现在可以正确地与 `LowCardinality` 和 `LowCardinality(Nullable)` 类型一起使用. 修复 [#12086](https://github.com/ClickHouse/ClickHouse/issues/12086), [#8406](https://github.com/ClickHouse/ClickHouse/issues/8406). [#12108](https://github.com/ClickHouse/ClickHouse/pull/12108) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* 修复了由于线程总数限制错误导致的带有 `UNION` 的选择的性能. 修复 [#12030](https://github.com/ClickHouse/ClickHouse/issues/12030). [#12103](https://github.com/ClickHouse/ClickHouse/pull/12103) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* 使用 `-StateResample` 组合器修复了段错误. [#12092](https://github.com/ClickHouse/ClickHouse/pull/12092) ([Anton Popov](https://github.com/CurtizJ)).
* 修复了 `system.quey_log` 中选择的空 `result_rows` 和 `result_bytes` 指标. 修复 [#11595](https://github.com/ClickHouse/ClickHouse/issues/11595). [#12089](https://github.com/ClickHouse/ClickHouse/pull/12089) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* 修复了不必要的限制从 `VIEW` 中选择的线程数. 修复 [#11937](https://github.com/ClickHouse/ClickHouse/issues/11937). [#12085](https://github.com/ClickHouse/ClickHouse/pull/12085) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* 修复了 DROP TABLE 上 StorageKafka 中的 SIGSEGV. [#12075](https://github.com/ClickHouse/ClickHouse/pull/12075) ([Azat Khuzhin](https://github.com/azat)).
* 修复了对 `PREWHERE` 使用错误类型时可能发生的崩溃。 修复 [#12053](https://github.com/ClickHouse/ClickHouse/issues/12053), [#12060](https://github.com/ClickHouse/ClickHouse/issues/12060). [#12060](https://github.com/ClickHouse/ClickHouse/pull/12060) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* 修复了带有 `Tuple(LowCardinality)` 参数的高阶函数的错误 `Cannot capture column`. 修复 [#9766](https://github.com/ClickHouse/ClickHouse/issues/9766). [#12055](https://github.com/ClickHouse/ClickHouse/pull/12055) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* 固定约束检查约束是否为常量表达式. 这修复了 [#11360](https://github.com/ClickHouse/ClickHouse/issues/11360). [#12042](https://github.com/ClickHouse/ClickHouse/pull/12042) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 修复了在调用具有不同大小的 `FixedString` 类型参数的函数 `if` 时出现错误结果和潜在崩溃的问题. 这修复了 [#11362](https://github.com/ClickHouse/ClickHouse/issues/11362). [#12021](https://github.com/ClickHouse/ClickHouse/pull/12021) ([alexey-milovidov](https://github.com/alexey-milovidov)).

#### 改进

* 允许以更标准的方式设置 `JOIN` 种类和类型: `LEFT SEMI JOIN`而不是`SEMI LEFT JOIN`. 目前两者都是正确的. [#12520](https://github.com/ClickHouse/ClickHouse/pull/12520) ([Artem Zuikov](https://github.com/4ertus2)).
* 缓冲区引擎的lifetime_rows/lifetime_bytes. [#12421](https://github.com/ClickHouse/ClickHouse/pull/12421) ([Azat Khuzhin](https://github.com/azat)).
* 将详细异常消息写入客户端而不是 `MySQL server has gone away` . [#12383](https://github.com/ClickHouse/ClickHouse/pull/12383) ([BohuTANG](https://github.com/BohuTANG)).
* 允许更改用于打印网格边框的字符集. 可用的字符集如下: UTF-8、ASCII. 设置 `output_format_pretty_grid_charset` 启用此功能. [#12372](https://github.com/ClickHouse/ClickHouse/pull/12372) ([Sabyanin Maxim](https://github.com/s-mx)).
* 1.支持 MySQL 'SELECT DATABASE()' [#9336](https://github.com/ClickHouse/ClickHouse/issues/9336). 2. 添加 MySQL 替换查询集成测试. [#12314](https://github.com/ClickHouse/ClickHouse/pull/12314) ([BohuTANG](https://github.com/BohuTANG)).
* 为 MySQL 客户端/驱动程序添加 `KILL QUERY [connection_id]` 以取消长查询, 问题 [#12038](https://github.com/ClickHouse/ClickHouse/issues/12038). [#12152](https://github.com/ClickHouse/ClickHouse/pull/12152) ([BohuTANG](https://github.com/BohuTANG)).
* 在 `formatDateTime` 函数中添加了对 `%g` (两位 ISO 年份) 和 `%G` (四位 ISO 年份) 替换的支持. [#12136](https://github.com/ClickHouse/ClickHouse/pull/12136) ([vivarum](https://github.com/vivarum)).
* 在 system.disks 中添加了 `type` 列. [#12115](https://github.com/ClickHouse/ClickHouse/pull/12115) ([ianton-ru](https://github.com/ianton-ru)).
* 改进的`REVOKE` 命令: 现在它只需要授予/管理选项才能被撤销. 例如, 现在要执行 `REVOKE ALL ON *.* FROM user1`, 不需要通过授予选项授予完全访问权限. 添加命令 `REVOKE ALL FROM user1` - 它从 `user1` 撤销所有授予的角色. [#12083](https://github.com/ClickHouse/ClickHouse/pull/12083) ([Vitaly Baranov](https://github.com/vitlibar)).
* 为 load_balancing 添加了副本优先级 (用于手动确定负载平衡的优先级). [#11995](https://github.com/ClickHouse/ClickHouse/pull/11995) ([Azat Khuzhin](https://github.com/azat)).
* 将 S3 元数据中的路径切换为相对路径, 以便更轻松地处理 S3 blob. [#11892](https://github.com/ClickHouse/ClickHouse/pull/11892) ([Vladimir Chebotarev](https://github.com/excitoon)).

#### 性能改进

* 通过排序键的前缀改进了 `ORDER BY` 和 `GROUP BY` 的性能 (使用 `optimize_aggregation_in_order` 设置启用, 默认禁用). [#11696](https://github.com/ClickHouse/ClickHouse/pull/11696) ([Anton Popov](https://github.com/CurtizJ)).
* 如果 `set optimize_injective_functions_inside_uniq=1`, 则删除 `uniq*()` 内的单射函数. [#12337](https://github.com/ClickHouse/ClickHouse/pull/12337) ([Ruslan Kamalov](https://github.com/kamalov-ruslan)).
* 索引不用于带文字的 IN 运算符, 在 v19.3 前后引入了性能回归. 这修复了[#10574](https://github.com/ClickHouse/ClickHouse/issues/10574). [#12062](https://github.com/ClickHouse/ClickHouse/pull/12062) ([nvartolomei](https://github.com/nvartolomei)).
* 为 DiskS3 (实验功能) 实现单部分上传. [#12026](https://github.com/ClickHouse/ClickHouse/pull/12026) ([Vladimir Chebotarev](https://github.com/excitoon)).

#### 实验功能
* 在 `MergeTree` -family 表中添加了新的部件内存格式, 将数据存储在内存中. 第一次合并时将部分写入磁盘. 如果零件的行或字节大小低于阈值 `min_rows_for_compact_part` 和 `min_bytes_for_compact_part`, 将以内存格式创建. 还提供了对 Write-Ahead-Log 的可选支持, 默认情况下启用并通过设置 `in_memory_parts_enable_wal` 来控制. [#10697](https://github.com/ClickHouse/ClickHouse/pull/10697) ([Anton Popov](https://github.com/CurtizJ)).

#### 构建/测试/打包改进

* 为 clickhouse-client 实现基于 AST 的查询模糊测试模式. 请参阅 [this label](https://github.com/ClickHouse/ClickHouse/issues?q=label%3Afuzz+is%3Aissue) 了解我们最近通过模糊测试发现的问题列表. 其中大部分是由这个工具发现的, 还有一些是由 SQLancer 和 `00746_sql_fuzzy.pl` 发现的. [#12111](https://github.com/ClickHouse/ClickHouse/pull/12111) ([Alexander Kuzmenkov](https://github.com/akuzm)).
* 添加基于 Testflows 框架的新型测试. [#12090](https://github.com/ClickHouse/ClickHouse/pull/12090) ([vzakaznikov](https://github.com/vzakaznikov)).
* 添加了 S3 HTTPS 集成测试. [#12412](https://github.com/ClickHouse/ClickHouse/pull/12412) ([Pavel Kovalenko](https://github.com/Jokser)).
* 从单独的线程记录清除陷阱消息. 这将防止线程消毒剂下可能出现的死锁. [#12313](https://github.com/ClickHouse/ClickHouse/pull/12313) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 现在功能和压力测试将能够使用旧版本的 `clickhouse-test` 脚本运行. [#12287](https://github.com/ClickHouse/ClickHouse/pull/12287) ([alesapin](https://github.com/alesapin)).
* 在 `orc` 构建期间删除奇怪的文件创建. [#12258](https://github.com/ClickHouse/ClickHouse/pull/12258) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* 将常见的 docker compose 文件放置到集成 docker 容器中. [#12168](https://github.com/ClickHouse/ClickHouse/pull/12168) ([Ilya Yatsishin](https://github.com/qoega)).
* 修复来自 CodeQL 的警告. `CodeQL` 是另一个静态分析器, 我们将与我们已经使用的 `clang-tidy` 和 `PVS-Studio` 一起使用. [#12138](https://github.com/ClickHouse/ClickHouse/pull/12138) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* UNBUNDLED 构建的小 CMake 修复. [#12131](https://github.com/ClickHouse/ClickHouse/pull/12131) ([Matwey V. Kornilov](https://github.com/matwey)).
* 添加了一个不使用任何 Linux 发行版的最小 Docker 镜像的展示. [#12126](https://github.com/ClickHouse/ClickHouse/pull/12126) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 在 `clickhouse-server` docker 镜像中执行系统包的升级. [#12124](https://github.com/ClickHouse/ClickHouse/pull/12124) ([Ivan Blinkov](https://github.com/blinkov)).
* 将 `UNBUNDLED` 标志添加到 `system.build_options` 表. 将 `clickhouse-test` 的跳过列表移动到 clickhouse repo. [#12107](https://github.com/ClickHouse/ClickHouse/pull/12107) ([alesapin](https://github.com/alesapin)).
* 通过 [Anchore Container Analysis](https://docs.anchore.com) 安全分析工具定期检查, 该工具会在 `clickhouse-server` Docker 镜像中查找 [CVE](https://cve.mitre.org/). 还确认`Dockerfile` 是可构建的. 每天在 `master` 和 `Dockerfile` 的拉取请求上运行. [#12102](https://github.com/ClickHouse/ClickHouse/pull/12102) ([Ivan Blinkov](https://github.com/blinkov)).
* 每日检查 [GitHub CodeQL](https://securitylab.github.com/tools/codeql) 安全分析工具, 寻找 [CWE](https://cwe.mitre.org/). [#12101](https://github.com/ClickHouse/ClickHouse/pull/12101) ([Ivan Blinkov](https://github.com/blinkov)).
* 在 Dockerfile 中的第一个 `apt-get update` 之前安装 `ca-certificates`. [#12095](https://github.com/ClickHouse/ClickHouse/pull/12095) ([Ivan Blinkov](https://github.com/blinkov)).

## ClickHouse 版本 20.5

### ClickHouse 版本 v20.5.4.40-stable 2020-08-10

#### Bug 修复

* 用函数修正了错误的索引分析. 在从 `MergeTree` 表中读取时, 它可能会导致修剪错误的部分. 修复 [#13060](https://github.com/ClickHouse/ClickHouse/issues/13060). Fixes [#12406](https://github.com/ClickHouse/ClickHouse/issues/12406). [#13081](https://github.com/ClickHouse/ClickHouse/pull/13081) ([Anton Popov](https://github.com/CurtizJ)).
* 修复了对从本地副本进行选择的线程数的不必要限制. [#12840](https://github.com/ClickHouse/ClickHouse/pull/12840) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* 修复了大元组的性能, 这些元组在 `IN` 部分被解释为函数. 当用户出于某种晦涩的原因编写 `WHERE x IN tuple(1, 2, ...)` 而不是 `WHERE x IN (1, 2, ...)` 的情况. [#12700](https://github.com/ClickHouse/ClickHouse/pull/12700) ([Anton Popov](https://github.com/CurtizJ)).
* 修复了 input_format_parallel_parsing 的内存跟踪 (通过将线程附加到组). [#12672](https://github.com/ClickHouse/ClickHouse/pull/12672) ([Azat Khuzhin](https://github.com/azat)).
* 使用 const 表达式修复了布隆过滤器索引. 这修复了 [#10572](https://github.com/ClickHouse/ClickHouse/issues/10572). [#12659](https://github.com/ClickHouse/ClickHouse/pull/12659) ([Winter Zhang](https://github.com/zhang2014)).
* 修复了当 Broker 不可用时 (不仅如此) 在 `StorageKafka` 中的 `SIGSEGV`. [#12658](https://github.com/ClickHouse/ClickHouse/pull/12658) ([Azat Khuzhin](https://github.com/azat)).
* 添加了对带有 `Array(UUID)` 参数的函数 `if` 的支持. 这修复了 [#11066](https://github.com/ClickHouse/ClickHouse/issues/11066). [#12648](https://github.com/ClickHouse/ClickHouse/pull/12648) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 修复了函数 `any` 缺少别名的问题. [#12593](https://github.com/ClickHouse/ClickHouse/pull/12593) ([Anton Popov](https://github.com/CurtizJ)).
* 修复了带有缓存布局的外部字典中的竞争条件, 这可能导致服务器崩溃. [#12566](https://github.com/ClickHouse/ClickHouse/pull/12566) ([alesapin](https://github.com/alesapin)).
* 在 DROP TABLE 上删除分布式表 (来自异步插入的块) 的数据. [#12556](https://github.com/ClickHouse/ClickHouse/pull/12556) ([Azat Khuzhin](https://github.com/azat)).
* 修复了当 `enable_mixed_granularity_parts=1` 时, 在 `ALTER DELETE` 查询后导致旧部件损坏的错误. 修复 [#12536](https://github.com/ClickHouse/ClickHouse/issues/12536). [#12543](https://github.com/ClickHouse/ClickHouse/pull/12543) ([alesapin](https://github.com/alesapin)).
* 参数数目无效的函数 `in` 的更好例外. [#12529](https://github.com/ClickHouse/ClickHouse/pull/12529) ([Anton Popov](https://github.com/CurtizJ)).
* 修复了实时视图表中可能导致数据重复的竞争条件. [#12519](https://github.com/ClickHouse/ClickHouse/pull/12519) ([vzakaznikov](https://github.com/vzakaznikov)).
* 修正了从合并部分读取时的性能问题. [#12492](https://github.com/ClickHouse/ClickHouse/pull/12492) ([Anton Popov](https://github.com/CurtizJ)).
* 修复了 `AggregateFunction(avg, ...)` 值的二进制格式的向后兼容性. 这修复了 [#12342](https://github.com/ClickHouse/ClickHouse/issues/12342). [#12486](https://github.com/ClickHouse/ClickHouse/pull/12486) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 修复了启用 `text_log` 时的死锁. [#12452](https://github.com/ClickHouse/ClickHouse/pull/12452) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 修复了当指定非常大的限制或偏移量时的溢出问题. 这修复了 [#10470](https://github.com/ClickHouse/ClickHouse/issues/10470). This fixes [#11372](https://github.com/ClickHouse/ClickHouse/issues/11372). [#12427](https://github.com/ClickHouse/ClickHouse/pull/12427) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 修复了 StorageMerge 时可能出现的段错误. 关闭 [#12054](https://github.com/ClickHouse/ClickHouse/issues/12054). [#12401](https://github.com/ClickHouse/ClickHouse/pull/12401) ([tavplubix](https://github.com/tavplubix)).
* 还原 [#11079](https://github.com/ClickHouse/ClickHouse/issues/11079) 中引入的更改以解决 [#12098](https://github.com/ClickHouse/ClickHouse/issues/12098). [#12397](https://github.com/ClickHouse/ClickHouse/pull/12397) ([Mike](https://github.com/myrrc)).
* 在索引表的 WHERE 条件中使用负数或浮点常量时避免异常. 这修复了 [#11905](https://github.com/ClickHouse/ClickHouse/issues/11905). [#12384](https://github.com/ClickHouse/ClickHouse/pull/12384) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 即使存在依赖的 DEFAULT 表达式，也允许 CLEAR 列. 这修复了 [#12333](https://github.com/ClickHouse/ClickHouse/issues/12333). [#12378](https://github.com/ClickHouse/ClickHouse/pull/12378) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 修复了带有 `-State` 和 `Nullable` 参数的聚合函数的 TOTALS/ROLLUP/CUBE. 这修复了 [#12163](https://github.com/ClickHouse/ClickHouse/issues/12163). [#12376](https://github.com/ClickHouse/ClickHouse/pull/12376) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 修复了 SIGSEGV 如果在 `Kafka` 引擎中批处理中间有错误消息. [#12302](https://github.com/ClickHouse/ClickHouse/pull/12302) ([Azat Khuzhin](https://github.com/azat)).
* 修复了当 `SummingMergeTree` 引擎从分区键中汇总列时的行为. 在列的显式定义与分区键列相交的情况下添加了一个例外. 这修复了 [#7867](https://github.com/ClickHouse/ClickHouse/issues/7867). [#12173](https://github.com/ClickHouse/ClickHouse/pull/12173) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* 修复了在存在别名的情况下发送到外部 DBMS (例如 MySQL、ODBC) 的查询转换. 这修复了 [#12032](https://github.com/ClickHouse/ClickHouse/issues/12032). [#12151](https://github.com/ClickHouse/ClickHouse/pull/12151) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 修复了导致 ZooKeepeer 中 ReplicatedVersionedCollapsingMergeTree 表的表元数据不正确的错误. 修复 [#12093](https://github.com/ClickHouse/ClickHouse/issues/12093). [#12121](https://github.com/ClickHouse/ClickHouse/pull/12121) ([alesapin](https://github.com/alesapin)).
* 修复了从 `VIEW` 中选择的不必要的线程数限制. 修复 [#11937](https://github.com/ClickHouse/ClickHouse/issues/11937). [#12085](https://github.com/ClickHouse/ClickHouse/pull/12085) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* 使用 `join_algorithm=partial_merge` 修复了具有 LowCardinality 类型的 JOIN 崩溃. [#12035](https://github.com/ClickHouse/ClickHouse/pull/12035) ([Artem Zuikov](https://github.com/4ertus2)).
* 修复了条件为 NULL 的 `if()` 的错误结果. [#11807](https://github.com/ClickHouse/ClickHouse/pull/11807) ([Artem Zuikov](https://github.com/4ertus2)).

#### 性能改进

* 索引不用于带文字的 IN 运算符, 在 v19.3 前后引入了性能回归. 这修复了 [#10574](https://github.com/ClickHouse/ClickHouse/issues/10574). [#12062](https://github.com/ClickHouse/ClickHouse/pull/12062) ([nvartolomei](https://github.com/nvartolomei)).

#### 构建/测试/打包改进

* 在 Dockerfile 中的第一个 `apt-get update` 之前安装 `ca-certificates`. [#12095](https://github.com/ClickHouse/ClickHouse/pull/12095) ([Ivan Blinkov](https://github.com/blinkov)).


### ClickHouse 版本 v20.5.2.7-stable 2020-07-02

#### 向后不兼容变更

* 从 COUNT(DISTINCT) 和 `uniq` 聚合函数系列返回不可为空的结果. 如果所有传递的值都是 NULL, 则返回零. 这提高了 SQL 兼容性. [#11661](https://github.com/ClickHouse/ClickHouse/pull/11661) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 添加了对在错误位置指定用户级设置的情况的检查. 用户级设置应该在 `<profile>` 部分内的 `users.xml` 中为特定用户配置文件指定 (或在 `<default>` 中指定默认设置). 服务器不会以日志中的异常消息启动. 这修复了 [#9051](https://github.com/ClickHouse/ClickHouse/issues/9051). 如果您想跳过检查, 您可以将设置移动到适当的位置或将 `<skip_check_for_incorrect_settings>1</skip_check_for_incorrect_settings>` 添加到 config.xml. [#11449](https://github.com/ClickHouse/ClickHouse/pull/11449) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 默认情况下启用设置 `input_format_with_names_use_header`. 它会影响对输入格式 `-WithNames` 和 `-WithNamesAndTypes` 的解析. [#10937](https://github.com/ClickHouse/ClickHouse/pull/10937) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 删除 `experimental_use_processors` 设置. 它默认启用. [#10924](https://github.com/ClickHouse/ClickHouse/pull/10924) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* 将 `zstd` 更新到 1.4.4. 它在性能和压缩比方面有一些小的改进. 如果您使用不同版本的 ClickHouse 运行副本, 您可能会看到合理的错误消息 `Data after merge is not byte-identical to data on another replicas.`  并附有说明. 这些消息没问题, 您不必担心. 此更改向后兼容, 但我们将其列在更改日志中, 以防您对这些消息感到疑惑. [#10663](https://github.com/ClickHouse/ClickHouse/pull/10663) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 添加了对无意义编解码器的检查和设置 `allow_suspicious_codecs` 来控制此检查. 这将关闭 [#4966](https://github.com/ClickHouse/ClickHouse/issues/4966). [#10645](https://github.com/ClickHouse/ClickHouse/pull/10645) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 一些 Kafka 设置更改了它们的默认值. 见 [#11388](https://github.com/ClickHouse/ClickHouse/pull/11388).
* 从20.5以上的版本升级时, 如果进行滚动更新, 集群同时包含20.5以上和20.5以下的版本, 如果旧版本的ClickHouse节点重新启动, 旧版本在新版本存在的情况下启动, 可能会导致 `Part ... intersects previous part` 错误. 为防止出现此错误, 首先在所有集群节点上安装更新的 clickhouse-server 软件包, 然后重新启动 (因此, 当 clickhouse-server 重新启动时, 它将以新版本启动).

#### 新特征

* `TTL DELETE WHERE` 和 `TTL GROUP BY` 用于表中的自动数据粗化和汇总. [#10537](https://github.com/ClickHouse/ClickHouse/pull/10537) ([expl0si0nn](https://github.com/expl0si0nn)).
* PostgreSQL 有线协议的实现. [#10242](https://github.com/ClickHouse/ClickHouse/pull/10242) ([Movses](https://github.com/MovElb)).
* 为 users, roles, grants, settings profiles, quotas, row policies 添加了系统表; 添加了命令 SHOW USER, SHOW [CURRENT|ENABLED] ROLES, SHOW SETTINGS PROFILES. [#10387](https://github.com/ClickHouse/ClickHouse/pull/10387) ([Vitaly Baranov](https://github.com/vitlibar)).
* 支持写入 ODBC 表函数 [#10554](https://github.com/ClickHouse/ClickHouse/pull/10554) ([ageraab](https://github.com/ageraab)). [#10901](https://github.com/ClickHouse/ClickHouse/pull/10901) ([tavplubix](https://github.com/tavplubix)).
* 添加基于 Linux `perf_events` 的查询性能指标 (这些指标是使用硬件 CPU 计数器和 OS 计数器计算的). 它是可选的, 需要在 clickhouse 二进制文件上设置 `CAP_SYS_ADMIN`. [#9545](https://github.com/ClickHouse/ClickHouse/pull/9545) [Andrey Skobtsov](https://github.com/And42). [#11226](https://github.com/ClickHouse/ClickHouse/pull/11226) ([Alexander Kuzmenkov](https://github.com/akuzm)).
* 现在支持 `CREATE` 查询中数据类型的 `NULL` 和 `NOT NULL` 修饰符. [#11057](https://github.com/ClickHouse/ClickHouse/pull/11057) ([Павел Потемкин](https://github.com/Potya)).
* 添加 `ArrowStream` 输入输出格式. [#11088](https://github.com/ClickHouse/ClickHouse/pull/11088) ([hcz](https://github.com/hczhcz)).
* 支持 Cassandra 作为外部字典源. [#4978](https://github.com/ClickHouse/ClickHouse/pull/4978) ([favstovol](https://github.com/favstovol)).
* 添加了一个新的布局 `direct`, 它直接从每个查询的源加载所有数据, 而不存储或缓存数据. [#10622](https://github.com/ClickHouse/ClickHouse/pull/10622) ([Artem Streltsov](https://github.com/kekekekule)).
* 向字典添加了新的 `complex_key_direct` 布局, 在查询执行期间不会在本地存储任何内容. [#10850](https://github.com/ClickHouse/ClickHouse/pull/10850) ([Artem Streltsov](https://github.com/kekekekule)).
* 添加了对 MySQL 样式全局变量语法 (存根) 的支持. 这是 MySQL 协议兼容性所必需的. [#11832](https://github.com/ClickHouse/ClickHouse/pull/11832) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 使用 `repl` 为 `clickhouse-client` 添加了语法高亮. [#11422](https://github.com/ClickHouse/ClickHouse/pull/11422) ([Tagir Kuskarov](https://github.com/kuskarov)).
* 添加了 `mind Map` 和 `maxMap` 函数. [#11603](https://github.com/ClickHouse/ClickHouse/pull/11603) ([Ildus Kurbangaliev](https://github.com/ildus)).
* 添加记录来自 `system.asynchronous_metrics` 的历史指标的 `system.asynchronous_metric_log` 表. [#11588](https://github.com/ClickHouse/ClickHouse/pull/11588) ([Alexander Kuzmenkov](https://github.com/akuzm)).
* 添加函数 `extractAllGroupsHorizontal(haystack, re)` 和 `extractAllGroupsVertical(haystack, re)`. [#11554](https://github.com/ClickHouse/ClickHouse/pull/11554) ([Vasily Nemkov](https://github.com/Enmk)).
* 添加 SHOW CLUSTER(S) 查询. [#11467](https://github.com/ClickHouse/ClickHouse/pull/11467) ([hexiaoting](https://github.com/hexiaoting)).
* 添加`netloc`函数用于提取网络位置, 类似于python中的`urlparse(url)`、`netloc`. [#11356](https://github.com/ClickHouse/ClickHouse/pull/11356) ([Guillaume Tassery](https://github.com/YiuRULE)).
* 为 engine=Kafka 添加 2 个虚拟列以访问消息头. [#11283](https://github.com/ClickHouse/ClickHouse/pull/11283) ([filimonov](https://github.com/filimonov)).
* 为 Kafka 引擎添加 `_timestamp_ms` 虚拟列 (类型为 `Nullable(DateTime64(3))`) . [#11260](https://github.com/ClickHouse/ClickHouse/pull/11260) ([filimonov](https://github.com/filimonov)).
* 添加函数 `randomFixedString`. [#10866](https://github.com/ClickHouse/ClickHouse/pull/10866) ([Andrei Nekrashevich](https://github.com/xolm)).
* 添加函数 `fuzzBits`, 以给定的概率随机翻转字符串中的位. [#11237](https://github.com/ClickHouse/ClickHouse/pull/11237) ([Andrei Nekrashevich](https://github.com/xolm)).
* 允许在比较运算符、IN 和 VALUES 部分中将数字与常量字符串进行比较. [#11647](https://github.com/ClickHouse/ClickHouse/pull/11647) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 添加 `round_robin` 负载平衡模式. [#11645](https://github.com/ClickHouse/ClickHouse/pull/11645) ([Azat Khuzhin](https://github.com/azat)).
* 添加 `cast_keep_nullable` 设置. 如果设置 `CAST(something_nullable AS Type)` 返回 `Nullable(Type)` . [#11733](https://github.com/ClickHouse/ClickHouse/pull/11733) ([Artem Zuikov](https://github.com/4ertus2)).
* 将列 `position` 添加到 `system.columns` 表, 将 `column_position` 添加到 `system.parts_columns` 表. 它包含从 1 开始的表中列的顺序位置.这将关闭 [#7744](https://github.com/ClickHouse/ClickHouse/issues/7744). [#11655](https://github.com/ClickHouse/ClickHouse/pull/11655) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* ON CLUSTER 支持系统 {FLUSH DISTRIBUTED,STOP/START DISTRIBUTED SEND}. [#11415](https://github.com/ClickHouse/ClickHouse/pull/11415) ([Azat Khuzhin](https://github.com/azat)).
* 添加 system.distribution_queue 表. [#11394](https://github.com/ClickHouse/ClickHouse/pull/11394) ([Azat Khuzhin](https://github.com/azat)).
* 支持Kafka中的所有格式设置, 在表级别公开一些设置, 调整默认值以获得更好的性能. [#11388](https://github.com/ClickHouse/ClickHouse/pull/11388) ([filimonov](https://github.com/filimonov)).
* 添加 `port` 函数 (从 URL 中提取端口). [#11120](https://github.com/ClickHouse/ClickHouse/pull/11120) ([Azat Khuzhin](https://github.com/azat)).
* 现在 `dictGet*` 函数接受表名. [#11050](https://github.com/ClickHouse/ClickHouse/pull/11050) ([Vitaly Baranov](https://github.com/vitlibar)).
* 当使用 `-n` 参数时, `clickhouse-format` 工具现在能够格式化多个查询. [#10852](https://github.com/ClickHouse/ClickHouse/pull/10852) ([Darío](https://github.com/dgrr)).
* 可以为 DiskS3 配置代理解析器. [#10744](https://github.com/ClickHouse/ClickHouse/pull/10744) ([Pavel Kovalenko](https://github.com/Jokser)).
* 使 `pointInPolygon` 与非常量多边形一起工作. PointInPolygon 现在可以将 Array(Array(Tuple(..., ...))) 作为第二个参数, 多边形和孔的数组. [#10623](https://github.com/ClickHouse/ClickHouse/pull/10623) ([Alexey Ilyukhov](https://github.com/livace)) [#11421](https://github.com/ClickHouse/ClickHouse/pull/11421) ([Alexey Ilyukhov](https://github.com/livace)).
* 将 `move_ttl_info` 添加到 `system.parts` 以提供对移动 TTL 功能的内省. [#10591](https://github.com/ClickHouse/ClickHouse/pull/10591) ([Vladimir Chebotarev](https://github.com/excitoon)).
* 可以通过代理使用 S3. [#10576](https://github.com/ClickHouse/ClickHouse/pull/10576) ([Pavel Kovalenko](https://github.com/Jokser)).
* 为数据类型添加 `NCHAR` 和 `NVARCHAR` 同义词. [#11025](https://github.com/ClickHouse/ClickHouse/pull/11025) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 已解决 [#7224](https://github.com/ClickHouse/ClickHouse/issues/7224): 将 `FailedQuery`、`FailedSelectQuery` 和 `FailedInsertQuery` 指标添加到 `system.events` 表. [#11151](https://github.com/ClickHouse/ClickHouse/pull/11151) ([Nikita Orlov](https://github.com/naorlov)).
* 向 `system.asynchronous_metrics` 添加更多 `jemalloc` 统计信息, 并确保我们看到它们的最新值. [#11748](https://github.com/ClickHouse/ClickHouse/pull/11748) ([Alexander Kuzmenkov](https://github.com/akuzm)).
* 允许指定默认 S3 凭据和自定义身份验证标头. [#11134](https://github.com/ClickHouse/ClickHouse/pull/11134) ([Grigory Pervakov](https://github.com/GrigoryPervakov)).
* 添加了以各种精度将 DateTime64 导入/导出为 Int64 的新函数: `to-/fromUnixTimestamp64Milli/-Micro/-Nano`. [#10923](https://github.com/ClickHouse/ClickHouse/pull/10923) ([Vasily Nemkov](https://github.com/Enmk)).
* 允许为 MongoDB 字典指定 `mongodb://` URI. [#10915](https://github.com/ClickHouse/ClickHouse/pull/10915) ([Alexander Kuzmenkov](https://github.com/akuzm)).
* 现在可以在没有附属 LIMIT 子句的情况下使用 OFFSET 关键字. [#10802](https://github.com/ClickHouse/ClickHouse/pull/10802) ([Guillaume Tassery](https://github.com/YiuRULE)).
* 添加了 `system.licenses` 表. 此表包含位于 `contrib` 目录中的第三方库的许可证. 这将关闭 [#2890](https://github.com/ClickHouse/ClickHouse/issues/2890). [#10795](https://github.com/ClickHouse/ClickHouse/pull/10795) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 新函数 toStartOfSecond(DateTime64) -> DateTime64 使 DateTime64 值的亚秒部分无效. [#10722](https://github.com/ClickHouse/ClickHouse/pull/10722) ([Vasily Nemkov](https://github.com/Enmk)).
* 添加新的输入格式 `JSONAsString` , 它接受由换行符、空格和/或逗号分隔的一系列 JSON 对象. [#10607](https://github.com/ClickHouse/ClickHouse/pull/10607) ([Kruglov Pavel](https://github.com/Avogar)).
* 允许以比 4 MiB 更细的粒度步长分析内存. 添加了采样内存分析器以捕获随机分配/解除分配. [#10598](https://github.com/ClickHouse/ClickHouse/pull/10598) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* `SimpleAggregateFunction` 现在也支持 `sumMap`. [#10000](https://github.com/ClickHouse/ClickHouse/pull/10000) ([Ildus Kurbangaliev](https://github.com/ildus)).
* 分布式表引擎支持 `ALTER RENAME COLUMN` . 继续 [#10727](https://github.com/ClickHouse/ClickHouse/issues/10727). 修复 [#10747](https://github.com/ClickHouse/ClickHouse/issues/10747). [#10887](https://github.com/ClickHouse/ClickHouse/pull/10887) ([alesapin](https://github.com/alesapin)).

#### Bug 修复

* 修复十进制解析中的 UBSan 报告. 这修复了 [#7540](https://github.com/ClickHouse/ClickHouse/issues/7540). [#10512](https://github.com/ClickHouse/ClickHouse/pull/10512) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 解析 DateTime64 时修复潜在的浮点异常. 这修复了 [#11374](https://github.com/ClickHouse/ClickHouse/issues/11374). [#11875](https://github.com/ClickHouse/ClickHouse/pull/11875) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 修复在 prewhere 条件下使用 `Nullable` 列导致的罕见崩溃. [#11895](https://github.com/ClickHouse/ClickHouse/pull/11895) [#11608](https://github.com/ClickHouse/ClickHouse/issues/11608) [#11869](https://github.com/ClickHouse/ClickHouse/pull/11869) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* 不允许在高阶函数中使用 arrayJoin. 它导致协议同步中断. 这将关闭 [#3933](https://github.com/ClickHouse/ClickHouse/issues/3933). [#11846](https://github.com/ClickHouse/ClickHouse/pull/11846) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 修复 FixedString 与常量 String 比较的错误结果. 这修复了 [#11393](https://github.com/ClickHouse/ClickHouse/issues/11393). 这个bug出现在20.4版本. [#11828](https://github.com/ClickHouse/ClickHouse/pull/11828) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 修复条件为 NULL 的 `if` 的错误结果. [#11807](https://github.com/ClickHouse/ClickHouse/pull/11807) ([Artem Zuikov](https://github.com/4ertus2)).
* 修复使用过多线程进行查询. [#11788](https://github.com/ClickHouse/ClickHouse/pull/11788) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* 修复了在 `SELECT ... FROM merge_tree_table ...` 中使用 `WITH <scalar subquery> ...` 时的 `Scalar does not exist` 异常 [#11621](https://github.com/ClickHouse/ClickHouse/issues/11621). [#11767](https://github.com/ClickHouse/ClickHouse/pull/11767) ([Amos Bird](https://github.com/amosbird)).
* 修复像 `SELECT *, xyz.*` 这样的查询的意外行为, 这些查询在预期错误时成功. [#11753](https://github.com/ClickHouse/ClickHouse/pull/11753) ([hexiaoting](https://github.com/hexiaoting)).
* 现在, 在修改元数据期间, 复制的取数据将被取消. [#11744](https://github.com/ClickHouse/ClickHouse/pull/11744) ([alesapin](https://github.com/alesapin)).
* 在检查相等性之前解析存储在 zookeeper 中的元数据. [#11739](https://github.com/ClickHouse/ClickHouse/pull/11739) ([Azat Khuzhin](https://github.com/azat)).
* 修复了由 Values 输入格式中复杂文字的错误类型推导导致的 LOGICAL_ERROR. [#11732](https://github.com/ClickHouse/ClickHouse/pull/11732) ([tavplubix](https://github.com/tavplubix)).
* 修复 `ORDER BY ... WITH FILL` 在 const 列上. [#11697](https://github.com/ClickHouse/ClickHouse/pull/11697) ([Anton Popov](https://github.com/CurtizJ)).
* 复 SYSTEM SYNC REPLICA 中非常罕见的竞争条件. 如果创建了复制表, 同时另一个客户端从单独的连接中对该表发出 `SYSTEM SYNC REPLICA` 命令 (这不太可能, 因为另一个客户端应该知道该表已创建), 则有可能获得 nullptr 取消引用. [#11691](https://github.com/ClickHouse/ClickHouse/pull/11691) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 与 XDBC 桥通信时传递适当的超时. 最近在检查桥接活性和接收元信息时没有遵守超时. [#11690](https://github.com/ClickHouse/ClickHouse/pull/11690) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 将 `LIMIT n WITH TIES` 与包含别名的 `ORDER BY` 语句一起使用. [#11689](https://github.com/ClickHouse/ClickHouse/pull/11689) ([Anton Popov](https://github.com/CurtizJ)).
* 修复带有并行 `FINAL` 的选择的可能的 `Pipeline stuck` . 修复 [#11636](https://github.com/ClickHouse/ClickHouse/issues/11636). [#11682](https://github.com/ClickHouse/ClickHouse/pull/11682) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* 修复导致 `system.mutations` 状态不正确的错误. 它可能表明整个突变已经完成, 但服务器在复制队列中仍有 `MUTATE_PART` 任务并尝试执行它们. 这修复了 [#11611](https://github.com/ClickHouse/ClickHouse/issues/11611). [#11681](https://github.com/ClickHouse/ClickHouse/pull/11681) ([alesapin](https://github.com/alesapin)).
* 修复 CREATE USER 查询中的语法 hilite. [#11664](https://github.com/ClickHouse/ClickHouse/pull/11664) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 添加对带有不区分大小写标志的正则表达式的支持. This fixes [#11101](https://github.com/ClickHouse/ClickHouse/issues/11101) 并修复 [#11506](https://github.com/ClickHouse/ClickHouse/issues/11506). [#11649](https://github.com/ClickHouse/ClickHouse/pull/11649) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 如果设置了行级安全性, 则删除琐碎的计数查询优化. 在以前的版本中, 用户获取表中记录的总数而不是过滤。 这修复了 [#11352](https://github.com/ClickHouse/ClickHouse/issues/11352). [#11644](https://github.com/ClickHouse/ClickHouse/pull/11644) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 修复字符串的布隆过滤器 (数据跳过索引). [#11638](https://github.com/ClickHouse/ClickHouse/pull/11638) ([Azat Khuzhin](https://github.com/azat)).
* 如果没有 `-q` 选项, 数据库不会在启动时创建. [#11604](https://github.com/ClickHouse/ClickHouse/pull/11604) ([giordyb](https://github.com/giordyb)).
* 修复错误 `Block structure mismatch`, 用于从“缓冲区”表中采样读取的查询. [#11602](https://github.com/ClickHouse/ClickHouse/pull/11602) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* 修复 clickhouse-client 错误的退出代码, 当 `exception.code() % 256 == 0`. [#11601](https://github.com/ClickHouse/ClickHouse/pull/11601) ([filimonov](https://github.com/filimonov)).
* 修复 ReplicatedMergeTree 的不同副本的 CREATE/DROP 中的竞争条件. 如果表未从 ZooKeeper 中完全删除或未成功创建, 则继续工作. 这修复了 [#11432](https://github.com/ClickHouse/ClickHouse/issues/11432). [#11592](https://github.com/ClickHouse/ClickHouse/pull/11592) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 修复服务器启动时有关 `Mark cache size was lowered` 的日志消息中的小错误. 这将关闭 [#11399](https://github.com/ClickHouse/ClickHouse/issues/11399). [#11589](https://github.com/ClickHouse/ClickHouse/pull/11589) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 修复错误 `Size of offsets does not match size of column` , 用于查询中的 `PREWHERE column in (subquery)` 和 `ARRAY JOIN` . [#11580](https://github.com/ClickHouse/ClickHouse/pull/11580) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* 修复了 `SHOW CREATE TABLE` 中罕见的段错误. 修复 [#11490](https://github.com/ClickHouse/ClickHouse/issues/11490). [#11579](https://github.com/ClickHouse/ClickHouse/pull/11579) ([tavplubix](https://github.com/tavplubix)).
* HTTP 会话中的所有查询都具有相同的 query_id. 它是固定的. [#11578](https://github.com/ClickHouse/ClickHouse/pull/11578) ([tavplubix](https://github.com/tavplubix)).
* 现在 clickhouse-server docker 容器将更喜欢 IPv6 检查服务器活动性. [#11550](https://github.com/ClickHouse/ClickHouse/pull/11550) ([Ivan Starkov](https://github.com/istarkov)).
* 修复了在启用 `min_bytes_to_use_direct_io` 且 PREWHERE 处于活动状态并使用 SAMPLE 或大量线程时可能发生的 `Data compressed with different methods` 错误. 这修复了 [#11539](https://github.com/ClickHouse/ClickHouse/issues/11539). [#11540](https://github.com/ClickHouse/ClickHouse/pull/11540) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 修复 `<node>` 的 shard_num/replica_num (破坏 use_compact_format_in_distributed_parts_names). [#11528](https://github.com/ClickHouse/ClickHouse/pull/11528) ([Azat Khuzhin](https://github.com/azat)).
* 将异步 INSERT 修复到分布式中, 以用于 prefer_localhost_replica=0 和 w/o internal_replication. [#11527](https://github.com/ClickHouse/ClickHouse/pull/11527) ([Azat Khuzhin](https://github.com/azat)).
* 使用 `-State` 函数在聚合过程中抛出异常时修复内存泄漏. 这修复了 [#8995](https://github.com/ClickHouse/ClickHouse/issues/8995). [#11496](https://github.com/ClickHouse/ClickHouse/pull/11496) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 修复 `INSERT SELECT FINAL` 的 `Pipeline stuck` 异常, 其中 `SELECT` (`max_threads`> 1)有多个流, 而` INSERT` 只有一个 (`max_insert_threads`==0). [#11455](https://github.com/ClickHouse/ClickHouse/pull/11455) ([Azat Khuzhin](https://github.com/azat)).
* 修复查询中的错误结果, 例如 `select count() from t, u`. [#11454](https://github.com/ClickHouse/ClickHouse/pull/11454) ([Artem Zuikov](https://github.com/4ertus2)).
* 修复编解码器的返回压缩大小. [#11448](https://github.com/ClickHouse/ClickHouse/pull/11448) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* 当列具有带有非文字参数的压缩编解码器时修复服务器崩溃. 修复 [#11365](https://github.com/ClickHouse/ClickHouse/issues/11365). [#11431](https://github.com/ClickHouse/ClickHouse/pull/11431) ([alesapin](https://github.com/alesapin)).
* 修复了当表没有成功创建时, 在合并树关闭时可能出现的未初始化内存读取问题. [#11420](https://github.com/ClickHouse/ClickHouse/pull/11420) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 修复 JOIN 在 `LowCarinality(T)` 和 `Nullable(T)` 上的崩溃. [#11380](https://github.com/ClickHouse/ClickHouse/issues/11380). [#11414](https://github.com/ClickHouse/ClickHouse/pull/11414) ([Artem Zuikov](https://github.com/4ertus2)).
* 修复错误 `USING` 键的错误代码. [#11373](https://github.com/ClickHouse/ClickHouse/issues/11373). [#11404](https://github.com/ClickHouse/ClickHouse/pull/11404) ([Artem Zuikov](https://github.com/4ertus2)).
* 修复了参数超出纬度/经度范围的 `geohashesInBox`. [#11403](https://github.com/ClickHouse/ClickHouse/pull/11403) ([Vasily Nemkov](https://github.com/Enmk)).
* `joinGet()` 函数更好的错误. [#11389](https://github.com/ClickHouse/ClickHouse/pull/11389) ([Artem Zuikov](https://github.com/4ertus2)).
* 修复具有外部排序和限制的查询可能出现的 `Pipeline stuck` 错误. 修复 [#11359](https://github.com/ClickHouse/ClickHouse/issues/11359). [#11366](https://github.com/ClickHouse/ClickHouse/pull/11366) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* 在 ReplicatedMergeTree 中发送零件期间删除冗余锁. [#11354](https://github.com/ClickHouse/ClickHouse/pull/11354) ([alesapin](https://github.com/alesapin)).
* 修复了多行模式下 clickhouse-client 对 `\G`（垂直输出）的支持. 这将关闭 [#9933](https://github.com/ClickHouse/ClickHouse/issues/9933). [#11350](https://github.com/ClickHouse/ClickHouse/pull/11350) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 修复使用 `Lazy` 数据库时潜在的段错误. [#11348](https://github.com/ClickHouse/ClickHouse/pull/11348) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 修复从 `Join` 表引擎 (没有 JOIN) 直接选择的崩溃和错误的可空性. [#11340](https://github.com/ClickHouse/ClickHouse/pull/11340) ([Artem Zuikov](https://github.com/4ertus2)).
* 修复 `quantilesExactWeightedArray` 中的崩溃问题. [#11337](https://github.com/ClickHouse/ClickHouse/pull/11337) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* 现在合并在 `ALTER` 查询中更改元数据之前停止. [#11335](https://github.com/ClickHouse/ClickHouse/pull/11335) ([alesapin](https://github.com/alesapin)).
* Make writing to `MATERIALIZED VIEW` with setting `parallel_view_processing = 1` parallel again. Fixes [#10241](https://github.com/ClickHouse/ClickHouse/issues/10241). [#11330](https://github.com/ClickHouse/ClickHouse/pull/11330) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* 当提取的 JSON 具有不平衡的 { 或 [ 字符串时，修复 `visitParamExtractRaw`. [#11318](https://github.com/ClickHouse/ClickHouse/pull/11318) ([Ewout](https://github.com/devwout)).
* 修复 ThreadPool 中非常罕见的竞争条件. [#11314](https://github.com/ClickHouse/ClickHouse/pull/11314) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 修复 `clickhouse-copier` 中无关紧要的数据竞争. 通过集成测试发现. [#11313](https://github.com/ClickHouse/ClickHouse/pull/11313) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 修复转换中潜在的未初始化内存. 示例: `SELECT toIntervalSecond(now64())`. [#11311](https://github.com/ClickHouse/ClickHouse/pull/11311) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 修复了如果表的主键中有 Array 列并且查询正在使用 `empty` 或 `notEmpty` 函数按此列过滤时索引分析无法工作的问题. 这修复了 [#11286](https://github.com/ClickHouse/ClickHouse/issues/11286). [#11303](https://github.com/ClickHouse/ClickHouse/pull/11303) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 修复当查询速度估计可能不正确时的错误, 并且如果查询受到 `max_network_bandwidth`、`max_execution_speed` 或 `priority` 设置的限制, `min_execution_speed` 的限制可能无法工作或无法正常工作。 将 `timeout_before_checking_execution_speed` 的默认值更改为非零值, 否则设置 `min_execution_speed` 和 `max_execution_speed` 无效/ 这修复了 [#11297](https://github.com/ClickHouse/ClickHouse/issues/11297). 这修复了 [#5732](https://github.com/ClickHouse/ClickHouse/issues/5732). 这修复了 [#6228](https://github.com/ClickHouse/ClickHouse/issues/6228). 可用性改进: 避免在 `clickhouse-client` 中将异常消息与进度条串联. [#11296](https://github.com/ClickHouse/ClickHouse/pull/11296) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 修复了使用错误参数调用 `SET DEFAULT ROLE` 时的崩溃. 这修复了 [#10586](https://github.com/ClickHouse/ClickHouse/issues/10586). [#11278](https://github.com/ClickHouse/ClickHouse/pull/11278) ([Vitaly Baranov](https://github.com/vitlibar)).
* 修复在以 `Protobuf` 格式读取格式错误的数据时崩溃的问题. 这修复了 [#5957](https://github.com/ClickHouse/ClickHouse/issues/5957), fixes [#11203](https://github.com/ClickHouse/ClickHouse/issues/11203). [#11258](https://github.com/ClickHouse/ClickHouse/pull/11258) ([Vitaly Baranov](https://github.com/vitlibar)).
* 修复了 `cache` 字典可以返回默认值而不是正常值 (只有过期键时) 的错误. 这仅影响字符串字段. [#11233](https://github.com/ClickHouse/ClickHouse/pull/11233) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* 修复错误 `Block structure mismatch in QueryPipeline` , 同时从内部查询中的常量读取 `VIEW`. 修复 [#11181](https://github.com/ClickHouse/ClickHouse/issues/11181). [#11205](https://github.com/ClickHouse/ClickHouse/pull/11205) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* 修复可能的异常 `Invalid status for associated output` . [#11200](https://github.com/ClickHouse/ClickHouse/pull/11200) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* 现在将检查 `primary.idx` 是否在 `CREATE` 查询中定义. [#11199](https://github.com/ClickHouse/ClickHouse/pull/11199) ([alesapin](https://github.com/alesapin)).
* 使用 `Array(Array(LowCardinality))` 捕获参数修复高阶函数的可能错误 `Cannot capture column` . [#11185](https://github.com/ClickHouse/ClickHouse/pull/11185) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* 修复了在超过 1000 个键和一些后端的情况下可能会失败的 `S3` 通配符. [#11179](https://github.com/ClickHouse/ClickHouse/pull/11179) ([Vladimir Chebotarev](https://github.com/excitoon)).
* 如果数据跳过索引依赖于将在后台合并期间修改的列 (对于 SummingMergeTree、AggregatingMergeTree 以及 TTL GROUP BY), 则计算错误. 此问题已通过合并后移动索引计算得到修复, 因此索引是在合并数据上计算的. [#11162](https://github.com/ClickHouse/ClickHouse/pull/11162) ([Azat Khuzhin](https://github.com/azat)).
* 修复了在表引擎 = Kafka 的 DROP 期间 (或在服务器重新启动期间) 有时发生的挂起. [#11145](https://github.com/ClickHouse/ClickHouse/pull/11145) ([filimonov](https://github.com/filimonov)).
* 修复简单查询过多的线程预留 (优化减少线程数量, 在管道更改后部分中断). [#11114](https://github.com/ClickHouse/ClickHouse/pull/11114) ([Azat Khuzhin](https://github.com/azat)).
* 如果没有最终确定, 则从突变终止任务中删除日志记录. [#11109](https://github.com/ClickHouse/ClickHouse/pull/11109) ([alesapin](https://github.com/alesapin)).
* 修复了更新后服务器启动过程中的死锁, 系统日志表的结构发生了变化. [#11106](https://github.com/ClickHouse/ClickHouse/pull/11106) ([alesapin](https://github.com/alesapin)).
* 修复了 registerDiskS3 中的内存泄漏. [#11074](https://github.com/ClickHouse/ClickHouse/pull/11074) ([Pavel Kovalenko](https://github.com/Jokser)).
* 当 JOIN 出现在 PREWHERE 或 `optimize_move_to_prewhere` 使 PREWHERE from WHERE 出现时, 修复错误 `No such name in Block::erase()`. [#11051](https://github.com/ClickHouse/ClickHouse/pull/11051) ([Artem Zuikov](https://github.com/4ertus2)).
* 修复 Kafka 引擎表终止期间可能丢失的数据. [#11048](https://github.com/ClickHouse/ClickHouse/pull/11048) ([filimonov](https://github.com/filimonov)).
* 修复了 parseDateTime64BestEffort 参数解析错误. [#10925](https://github.com/ClickHouse/ClickHouse/issues/10925). [#11038](https://github.com/ClickHouse/ClickHouse/pull/11038) ([Vasily Nemkov](https://github.com/Enmk)).
* 现在可以在单个 `ALTER` 查询中对同一列进行 `ADD/DROP` 和 `RENAME`. 同时 `MODIFY` 和 `RENAME` 的异常信息变得更加清晰. 部分修复 [#10669](https://github.com/ClickHouse/ClickHouse/issues/10669). [#11037](https://github.com/ClickHouse/ClickHouse/pull/11037) ([alesapin](https://github.com/alesapin)).
* 修复了 S3 URL 的解析. [#11036](https://github.com/ClickHouse/ClickHouse/pull/11036) ([Vladimir Chebotarev](https://github.com/excitoon)).
* 修复存在 `LIMIT` 时两级 `GROUP BY` 的内存跟踪. [#11022](https://github.com/ClickHouse/ClickHouse/pull/11022) ([Azat Khuzhin](https://github.com/azat)).
* 如果表未成功创建，则修复 MergeTree 中非常罕见的潜在释放后使用错误. [#10986](https://github.com/ClickHouse/ClickHouse/pull/10986) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 修复原子数据库的元数据 (重命名的相对路径) 和数据 (符号链接的相对路径) 处理. [#10980](https://github.com/ClickHouse/ClickHouse/pull/10980) ([Azat Khuzhin](https://github.com/azat)).
* 使用 `Atomic` 数据库引擎修复并发 `ALTER` 和 `DROP DATABASE` 查询时的服务器崩溃. [#10968](https://github.com/ClickHouse/ClickHouse/pull/10968) ([tavplubix](https://github.com/tavplubix)).
* 修复方法 getRawData() 中不正确的原始数据大小. [#10964](https://github.com/ClickHouse/ClickHouse/pull/10964) ([Igr](https://github.com/ObjatieGroba)).
* 修复了 20.1 及更早版本之间两级聚合的不兼容性. 当在发起节点和远程节点上使用不同版本的 ClickHouse 并且 GROUP BY 结果的大小很大并且由单个 String 字段执行聚合时, 就会发生这种不兼容.  结果导致单个键的多个未合并的行. [#10952](https://github.com/ClickHouse/ClickHouse/pull/10952) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 避免通过 DistributedBlockOutputStream 发送部分写入的文件. [#10940](https://github.com/ClickHouse/ClickHouse/pull/10940) ([Azat Khuzhin](https://github.com/azat)).
* 复 `SELECT count(notNullIn(NULL, []))` 中的崩溃. [#10920](https://github.com/ClickHouse/ClickHouse/pull/10920) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* 修复了在表引擎 = Kafka 的 DROP 期间 (或在服务器重新启动期间) 有时发生的挂起. [#10910](https://github.com/ClickHouse/ClickHouse/pull/10910) ([filimonov](https://github.com/filimonov)).
* 现在可以像 `a TO b, c TO a` 那样执行多个 `ALTER RENAME`. [#10895](https://github.com/ClickHouse/ClickHouse/pull/10895) ([alesapin](https://github.com/alesapin)).
* 修复当您从同一列的多个线程的聚合函数状态获得结果时可能发生的竞争. 唯一可能发生的方法 (我发现) 是当您使用 `finalizeAggregation` 函数同时使用 `Memory` 引擎从表中读取时, 该引擎为 `quanite*` 函数存储 `AggregateFunction` 状态. [#10890](https://github.com/ClickHouse/ClickHouse/pull/10890) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* 修复与分布式表中元组的向后兼容性. [#10889](https://github.com/ClickHouse/ClickHouse/pull/10889) ([Anton Popov](https://github.com/CurtizJ)).
* 修复 StringHashTable 中的 SIGSEGV (如果这样的键不存在). [#10870](https://github.com/ClickHouse/ClickHouse/pull/10870) ([Azat Khuzhin](https://github.com/azat)).
* 修复了在使用 `Atomic` 引擎从数据库中删除 `LiveView` 表后, `WATCH` 挂起的问题. [#10859](https://github.com/ClickHouse/ClickHouse/pull/10859) ([tavplubix](https://github.com/tavplubix)).
* 修复了 `ReplicatedMergeTree` 中的错误, 该错误可能导致 `OPTIMIZE` 查询上的某些 `ALTER` 在它变为非活动状态后挂起等待某些副本. [#10849](https://github.com/ClickHouse/ClickHouse/pull/10849) ([tavplubix](https://github.com/tavplubix)).
* 现在，如果参与 `CONSTRAINT` 表达式的列被重命名, 则约束会更新. 修复 [#10844](https://github.com/ClickHouse/ClickHouse/issues/10844). [#10847](https://github.com/ClickHouse/ClickHouse/pull/10847) ([alesapin](https://github.com/alesapin)).
* 修复缓存字典中未初始化内存的潜在读取. [#10834](https://github.com/ClickHouse/ClickHouse/pull/10834) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 在 Block::sortColumns() 之后修复列顺序 (还添加了一个测试, 表明它会影响一些实际用例 - 缓冲区引擎). [#10826](https://github.com/ClickHouse/ClickHouse/pull/10826) ([Azat Khuzhin](https://github.com/azat)).
* 修复 ODBC 桥在不要求引用标识符时的问题. 这修复了 [#7984](https://github.com/ClickHouse/ClickHouse/issues/7984). [#10821](https://github.com/ClickHouse/ClickHouse/pull/10821) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 修复 DateLUT 中的 UBSan 和 MSan 报告. [#10798](https://github.com/ClickHouse/ClickHouse/pull/10798) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 在关键条件下使用 `src_type` 进行正确的类型转换. 修复 [#6287](https://github.com/ClickHouse/ClickHouse/issues/6287). [#10791](https://github.com/ClickHouse/ClickHouse/pull/10791) ([Andrew Onyshchuk](https://github.com/oandrew)).
* 摆脱旧的 libunwind 补丁. https://github.com/ClickHouse-Extras/libunwind/commit/500aa227911bd185a94bfc071d68f4d3b03cb3b1#r39048012 这允许在 `clang` 中禁用 `-fno-omit-frame-pointer` 至少 1% 的平均构建性能. [#10761](https://github.com/ClickHouse/ClickHouse/pull/10761) ([Amos Bird](https://github.com/amosbird)).
* 修复了在多个分片上使用浮点权重时的avgWeighted问题. [#10758](https://github.com/ClickHouse/ClickHouse/pull/10758) ([Baudouin Giard](https://github.com/bgiard)).
* 修复 `parallel_view_processing` 行为. 现在, 如果发生异常, 所有对 `MATERIALIZED VIEW` 的插入都应该无一例外地完成. 修复 [#10241](https://github.com/ClickHouse/ClickHouse/issues/10241). [#10757](https://github.com/ClickHouse/ClickHouse/pull/10757) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* 与 -State 结合时修复组合器 -OrNull 和 -OrDefault. [#10741](https://github.com/ClickHouse/ClickHouse/pull/10741) ([hcz](https://github.com/hczhcz)).
* 使用嵌套类型修复 `generateRandom` 中的崩溃. 修复 [#10583](https://github.com/ClickHouse/ClickHouse/issues/10583). [#10734](https://github.com/ClickHouse/ClickHouse/pull/10734) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* 修复合并后可能发生的 `SummingMergeTree` 中 `LowCardinality(FixedString)` 键列的数据损坏. 修复 [#10489](https://github.com/ClickHouse/ClickHouse/issues/10489). [#10721](https://github.com/ClickHouse/ClickHouse/pull/10721) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* 修复使用 `FINAL` 修饰符和 `ORDER BY` 优化包装成函数的主键的使用. [#10715](https://github.com/ClickHouse/ClickHouse/pull/10715) ([Anton Popov](https://github.com/CurtizJ)).
* 修复函数 `h3EdgeAngle` 中可能的缓冲区溢出. [#10711](https://github.com/ClickHouse/ClickHouse/pull/10711) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 修复消失的总数. 如果查询具有带有外部 where 条件的连接或子查询, 则总计可能已被过滤. 修复 [#10674](https://github.com/ClickHouse/ClickHouse/issues/10674). [#10698](https://github.com/ClickHouse/ClickHouse/pull/10698) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* 修复 HTTP 插入的原子性. 这修复了 [#9666](https://github.com/ClickHouse/ClickHouse/issues/9666). [#10687](https://github.com/ClickHouse/ClickHouse/pull/10687) ([Andrew Onyshchuk](https://github.com/oandrew)).
* 在一个查询中使用相同的集合修复 `IN` 运算符的多次使用. [#10686](https://github.com/ClickHouse/ClickHouse/pull/10686) ([Anton Popov](https://github.com/CurtizJ)).
* 修复了当 `readonly=2` 和 `cancel_http_readonly_queries_on_client_close=1` 时导致 http 请求卡在客户端关闭的错误. 修复 [#7939](https://github.com/ClickHouse/ClickHouse/issues/7939), [#7019](https://github.com/ClickHouse/ClickHouse/issues/7019), [#7736](https://github.com/ClickHouse/ClickHouse/issues/7736), [#7091](https://github.com/ClickHouse/ClickHouse/issues/7091). [#10684](https://github.com/ClickHouse/ClickHouse/pull/10684) ([tavplubix](https://github.com/tavplubix)).
* 修复 AggregateTransform 构造函数中参数的顺序. [#10667](https://github.com/ClickHouse/ClickHouse/pull/10667) ([palasonic1](https://github.com/palasonic1)).
* 修复启用了 `distributed_aggregation_memory_efficient` 的远程查询缺乏并行执行的问题。 修复 [#10655](https://github.com/ClickHouse/ClickHouse/issues/10655). [#10664](https://github.com/ClickHouse/ClickHouse/pull/10664) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* 使用 `LIMIT` 修复查询的可能不正确的行数. 修复[#10566](https://github.com/ClickHouse/ClickHouse/issues/10566), [#10709](https://github.com/ClickHouse/ClickHouse/issues/10709). [#10660](https://github.com/ClickHouse/ClickHouse/pull/10660) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* 修复当表有很多部分时锁定并发更改的错误. [#10659](https://github.com/ClickHouse/ClickHouse/pull/10659) ([alesapin](https://github.com/alesapin)).
* 如果服务器在表启动之前关闭，则修复 StorageBuffer 中的 nullptr 取消引用. [#10641](https://github.com/ClickHouse/ClickHouse/pull/10641) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 修复分布式查询的谓词优化 (`enable_optimize_predicate_expression=1`) 对于带有 `HAVING` 部分的查询 (即需要在服务器启动器上进行过滤时), 通过保留表达式的顺序 (这足以修复), 并且还强制 聚合器在索引上使用列名. 修复: [#10613](https://github.com/ClickHouse/ClickHouse/issues/10613), [#11413](https://github.com/ClickHouse/ClickHouse/issues/11413). [#10621](https://github.com/ClickHouse/ClickHouse/pull/10621) ([Azat Khuzhin](https://github.com/azat)).
* 使用 LowCardinality 修复 optimize_skip_unused_shards. [#10611](https://github.com/ClickHouse/ClickHouse/pull/10611) ([Azat Khuzhin](https://github.com/azat)).
* 修复服务器启动异常时 StorageBuffer 中的段错误. 修复 [#10550](https://github.com/ClickHouse/ClickHouse/issues/10550). [#10609](https://github.com/ClickHouse/ClickHouse/pull/10609) ([tavplubix](https://github.com/tavplubix)).
* 在 `SYSTEM DROP DNS CACHE` 查询中还会删除缓存, 用于检查是否允许用户从某些 IP 地址进行连接. [#10608](https://github.com/ClickHouse/ClickHouse/pull/10608) ([tavplubix](https://github.com/tavplubix)).
* 修复了 `MATERIALIZED VIEW` 内部查询中不正确的标量结果, 以防该查询包含相关表. [#10603](https://github.com/ClickHouse/ClickHouse/pull/10603) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* 修复了同步突变的处理条件变量. 在某些情况下, 该条件变量的信号可能会丢失. [#10588](https://github.com/ClickHouse/ClickHouse/pull/10588) ([Vladimir Chebotarev](https://github.com/excitoon)).
* 修复了在 `loadStoredObject()` 完成之前调用 `createDictionary()` 可能导致的崩溃. [#10587](https://github.com/ClickHouse/ClickHouse/pull/10587) ([Vitaly Baranov](https://github.com/vitlibar)).
* 修复错误 `the BloomFilter false positive must be a double number between 0 and 1`  [#10551](https://github.com/ClickHouse/ClickHouse/issues/10551). [#10569](https://github.com/ClickHouse/ClickHouse/pull/10569) ([Winter Zhang](https://github.com/zhang2014)).
* 修复 SELECT 列 ALIAS 的默认表达式类型与列类型不同. [#10563](https://github.com/ClickHouse/ClickHouse/pull/10563) ([Azat Khuzhin](https://github.com/azat)).
* 实现了 DateTime64 和 String 值之间的比较 (就像 DateTime 一样). [#10560](https://github.com/ClickHouse/ClickHouse/pull/10560) ([Vasily Nemkov](https://github.com/Enmk)).
* 修复索引损坏，在某些情况下将合并部分合并到另一个合并部分后可能会发生. [#10531](https://github.com/ClickHouse/ClickHouse/pull/10531) ([Anton Popov](https://github.com/CurtizJ)).
* 默认禁用GROUP BY sharding_key优化 (`optimize_distributed_group_by_sharding_key` 已被引入并默认关闭, 由于sharding_key分析的技巧, 简单的例子是分片键中的 `if` ) 并修复 WITH ROLLUP/CUBE/TOTALS. [#10516](https://github.com/ClickHouse/ClickHouse/pull/10516) ([Azat Khuzhin](https://github.com/azat)).
* 修复: [#10263](https://github.com/ClickHouse/ClickHouse/issues/10263) (之后通过 INSERT 发送的 PR dist 在每个 INSERT 上被推迟) 修复: [#8756](https://github.com/ClickHouse/ClickHouse/issues/8756) (that PR breaks distributed sends with all of the following conditions met (unlikely setup for now I guess): `internal_replication == false`, multiple local shards (activates the hardlinking code) and `distributed_storage_policy` (makes `link(2)` fails on `EXDEV`)). [#10486](https://github.com/ClickHouse/ClickHouse/pull/10486) ([Azat Khuzhin](https://github.com/azat)).
* 修复了 `max_rows_to_sort` 限制的错误. [#10268](https://github.com/ClickHouse/ClickHouse/pull/10268) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 每次调用读取外部字典的任何函数时, 仅获取一次字典并检查访问权限. [#10928](https://github.com/ClickHouse/ClickHouse/pull/10928) ([Vitaly Baranov](https://github.com/vitlibar)).

#### 改进

* 在 `ALTER MODIFY TTL` 查询之后, 对旧数据应用 `TTL` . 这个行为是通过设置 `materialize_ttl_after_modify` 来控制的, 默认是启用的. [#11042](https://github.com/ClickHouse/ClickHouse/pull/11042) ([Anton Popov](https://github.com/CurtizJ)).
* 在解析字符串文字、VALUES 和各种文本格式中的 C 样式反斜杠转义时 (这是对 ClickHouse 和 MySQL 特有的 SQL 标准的扩展), 如果发现未知的转义序列 (例如`\%` 或 `\ w`), 这将使 `LIKE` 和`match` 正则表达式的使用更加方便 (写` name LIKE 'used\_cars'` 而不是 `name LIKE 'used\\_cars'` 就足够了) 同时更兼容. 这修复了 [#10922](https://github.com/ClickHouse/ClickHouse/issues/10922). [#11208](https://github.com/ClickHouse/ClickHouse/pull/11208) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 读取 Decimal 值时, 在点后切掉多余的数字. 此行为与 MySQL 和 PostgreSQL 更兼容. 这修复了 [#10202](https://github.com/ClickHouse/ClickHouse/issues/10202). [#11831](https://github.com/ClickHouse/ClickHouse/pull/11831) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 如果 ZooKeeper 中的元数据已经被删除并且不存在, 则允许 DROP 复制表 (这也是使用 TestKeeper 进行测试并重新启动服务器时的情况). 即使与 ZooKeeper 通信出现错误, 也允许重命名复制表. 这修复了 [#10720](https://github.com/ClickHouse/ClickHouse/issues/10720). [#11652](https://github.com/ClickHouse/ClickHouse/pull/11652) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 稍微改进从字符串中读取十进制的诊断. 这将关闭 [#10202](https://github.com/ClickHouse/ClickHouse/issues/10202). [#11829](https://github.com/ClickHouse/ClickHouse/pull/11829) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 修复信号处理程序中的睡眠调用. 它的睡眠时间比预期的要少. [#11825](https://github.com/ClickHouse/ClickHouse/pull/11825) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* (仅限 Linux) 操作系统相关的性能指标 (针对 CPU 和 I/O) 即使没有 `CAP_NET_ADMIN` 功能也能正常工作. [#10544](https://github.com/ClickHouse/ClickHouse/pull/10544) ([Alexander Kazakov](https://github.com/Akazz)).
* 添加了 `hostname` 作为函数 `hostName` 的别名. 此功能由 Yandex.Metrica 的 Victor Tarnavskiy 提出. [#11821](https://github.com/ClickHouse/ClickHouse/pull/11821) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 添加了对跨复制集群上分布式 `DDL` (更新/删除/删除分区) 的支持. [#11703](https://github.com/ClickHouse/ClickHouse/pull/11703) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* 如果我们无法侦听侦听地址之一 (例如，在 Docker 中 IPv6 不可用), 则在启动时在服务器日志中发出警告而不是错误. 请注意，如果服务器未能侦听所有列出的地址, 它将像以前一样拒绝启动. 这修复了 [#4406](https://github.com/ClickHouse/ClickHouse/issues/4406). [#11687](https://github.com/ClickHouse/ClickHouse/pull/11687) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 在 docker 映像启动时创建默认用户和数据库. [#10637](https://github.com/ClickHouse/ClickHouse/pull/10637) ([Paramtamtam](https://github.com/tarampampam)).
* 当多行查询打印到服务器日志时, 这些行被连接起来. 使其在多行字符串文字、标识符和单行注释的情况下正常工作. 这修复了 [#3853](https://github.com/ClickHouse/ClickHouse/issues/3853). [#11686](https://github.com/ClickHouse/ClickHouse/pull/11686) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 现在允许在命令中使用多个名称: CREATE USER、CREATE ROLE、ALTER USER、SHOW CREATE USER、SHOW GRANTS 等. [#11670](https://github.com/ClickHouse/ClickHouse/pull/11670) ([Vitaly Baranov](https://github.com/vitlibar)).
* 在跨复制集群上添加对分布式 DDL (`UPDATE/DELETE/DROP PARTITION`) 的支持. [#11508](https://github.com/ClickHouse/ClickHouse/pull/11508) ([frank lee](https://github.com/etah000)).
* 如果用户已使用显式值指定密码, 则从命令行中的 `clickhouse-client` 和 `clickhouse-benchmark` 清除密码. 这可以防止 `ps` 和类似工具暴露密码. [#11665](https://github.com/ClickHouse/ClickHouse/pull/11665) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 如果 ELF 文件与正在运行的二进制文件不对应, 请不要使用调试信息. 需要避免在堆栈跟踪中打印错误的函数名称和源位置. 这修复了 [#7514](https://github.com/ClickHouse/ClickHouse/issues/7514). [#11657](https://github.com/ClickHouse/ClickHouse/pull/11657) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 当在 parseDateTimeBestEffortOrNull/Zero 函数中没有完全解析值时, 返回 NULL/零. 这修复了 [#7876](https://github.com/ClickHouse/ClickHouse/issues/7876). [#11653](https://github.com/ClickHouse/ClickHouse/pull/11653) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 跳过请求的 URL 中的空参数. 当你写 `http://localhost:8123/?&a=b` 或 `http://localhost:8123/?a=b&&c=d` 时, 它们可能会出现. 这将关闭 [#10749](https://github.com/ClickHouse/ClickHouse/issues/10749). [#11651](https://github.com/ClickHouse/ClickHouse/pull/11651) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 允许使用 `groupArrayArray` 和 `groupUniqArrayArray` 作为 `SimpleAggregateFunction`. [#11650](https://github.com/ClickHouse/ClickHouse/pull/11650) ([Volodymyr Kuznetsov](https://github.com/ksvladimir)).
* 在分析其他类型的索引条件时, 允许通过隐式转换与常量字符串进行比较. 这可能会关闭 [#11630](https://github.com/ClickHouse/ClickHouse/issues/11630). [#11648](https://github.com/ClickHouse/ClickHouse/pull/11648) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* https://github.com/ClickHouse/ClickHouse/pull/7572#issuecomment-642815377 支持配置默认 HTTPHandlers. [#11628](https://github.com/ClickHouse/ClickHouse/pull/11628) ([Winter Zhang](https://github.com/zhang2014)).
* 制作更多输入格式以与 Kafka 引擎配合使用. 解决过早冲洗的问题. 修复 `kafka_num_consumers` 大于主题分区数时的性能问题. [#11599](https://github.com/ClickHouse/ClickHouse/pull/11599) ([filimonov](https://github.com/filimonov)).
* 改进 `multiple_joins_rewriter_version=2` 逻辑. 修复 lambda 别名的未知列错误. [#11587](https://github.com/ClickHouse/ClickHouse/pull/11587) ([Artem Zuikov](https://github.com/4ertus2)).
* 无法解析列声明列表时更好的异常消息. 这将关闭 [#10403](https://github.com/ClickHouse/ClickHouse/issues/10403). [#11537](https://github.com/ClickHouse/ClickHouse/pull/11537) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 改进 VIEW 的 `enable_optimize_predicate_expression=1` 逻辑. [#11513](https://github.com/ClickHouse/ClickHouse/pull/11513) ([Artem Zuikov](https://github.com/4ertus2)).
* 在实时视图表中添加对 PREWHERE 的支持. [#11495](https://github.com/ClickHouse/ClickHouse/pull/11495) ([vzakaznikov](https://github.com/vzakaznikov)).
* 自动更新 DNS 缓存, 用于检查是否允许用户从某个地址连接. [#11487](https://github.com/ClickHouse/ClickHouse/pull/11487) ([tavplubix](https://github.com/tavplubix)).
* 即使执行并发合并, OPTIMIZE FINAL 也会强制合并. 这将关闭 [#11309](https://github.com/ClickHouse/ClickHouse/issues/11309) 并关闭 [#11322](https://github.com/ClickHouse/ClickHouse/issues/11322). [#11346](https://github.com/ClickHouse/ClickHouse/pull/11346) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 抑制 clickhouse-client 中取消查询的输出. 在以前的版本中, 即使按 Ctrl+C 取消查询, 结果也可能会继续在终端中打印. 这将关闭 [#9473](https://github.com/ClickHouse/ClickHouse/issues/9473). [#11342](https://github.com/ClickHouse/ClickHouse/pull/11342) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 现在历史文件会在每次查询后更新, 如果多个客户端使用一个历史文件, 则不会出现竞争条件. 这修复了 [#9897](https://github.com/ClickHouse/ClickHouse/issues/9897). [#11453](https://github.com/ClickHouse/ClickHouse/pull/11453) ([Tagir Kuskarov](https://github.com/kuskarov)).
* 重新加载配置时更好地记录消息. [#11341](https://github.com/ClickHouse/ClickHouse/pull/11341) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 在某些情况下，从 `clickhouse-client` 或 `clickhouse-format` 中的格式化查询中删除尾随空格. [#11325](https://github.com/ClickHouse/ClickHouse/pull/11325) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 添加设置 `output_format_pretty_max_value_width` . 如果 value 较长, 则将其剪切以避免在终端中输出过大的 value. 这将关闭. [#11324](https://github.com/ClickHouse/ClickHouse/pull/11324) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 在内存映射不足的情况下更好的异常消息. 这将关闭 [#11027](https://github.com/ClickHouse/ClickHouse/issues/11027). [#11316](https://github.com/ClickHouse/ClickHouse/pull/11316) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 支持 (U)Int8、(U)Int16、ASOF JOIN 中的日期. [#11301](https://github.com/ClickHouse/ClickHouse/pull/11301) ([Artem Zuikov](https://github.com/4ertus2)).
* 支持 Kafka 表的 kafka_client_id 参数. 它还将 ClickHouse 在与 Kafka 通信时使用的默认 `client.id` 更改为更加详细和可用. [#11252](https://github.com/ClickHouse/ClickHouse/pull/11252) ([filimonov](https://github.com/filimonov)).
* 将 `DistributedFilesToInsert` 指标的值保留在异常上. 在以前的版本中, 该值是在我们要发送一些文件时设置的, 但如果出现异常并且一些文件仍处于待处理状态, 则该值为零. 现在它对应于文件系统中待处理文件的数量. [#11220](https://github.com/ClickHouse/ClickHouse/pull/11220) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 添加对多字数据类型名称的支持 (例如 `DOUBLE PRECISION` and `CHAR VARYING` ) 以获得更好的 SQL 兼容性. [#11214](https://github.com/ClickHouse/ClickHouse/pull/11214) ([Павел Потемкин](https://github.com/Potya)).
* 为某些数据类型提供同义词. [#10856](https://github.com/ClickHouse/ClickHouse/pull/10856) ([Павел Потемкин](https://github.com/Potya)).
* 现在默认启用查询日志. [#11184](https://github.com/ClickHouse/ClickHouse/pull/11184) ([Ivan Blinkov](https://github.com/blinkov)).
* 在表 system.users 和执行 SHOW CREATE USER 查询时显示身份验证类型. [#11080](https://github.com/ClickHouse/ClickHouse/pull/11080) ([Vitaly Baranov](https://github.com/vitlibar)).
* 删除 `Memory` 数据库引擎的显式 `DROP DATABASE` 上的数据. 修复 [#10557](https://github.com/ClickHouse/ClickHouse/issues/10557). [#11021](https://github.com/ClickHouse/ClickHouse/pull/11021) ([tavplubix](https://github.com/tavplubix)).
* 为 rdkafka 库的内部线程设置线程名称. 使来自 rdkafka 的日志在服务器日志中可用. [#10983](https://github.com/ClickHouse/ClickHouse/pull/10983) ([Azat Khuzhin](https://github.com/azat)).
* 支持查询中的 unicode 空格. 这有助于从 Word 或网页复制粘贴查询. 这修复了 [#10896](https://github.com/ClickHouse/ClickHouse/issues/10896). [#10903](https://github.com/ClickHouse/ClickHouse/pull/10903) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 允许大型 UInt 类型作为函数 `tupleElement` 中的索引. [#10874](https://github.com/ClickHouse/ClickHouse/pull/10874) ([hcz](https://github.com/hczhcz)).
* 尊重在 INSERT 到分布式上的prefer_localhost_replica/load_balancing. [#10867](https://github.com/ClickHouse/ClickHouse/pull/10867) ([Azat Khuzhin](https://github.com/azat)).
* 介绍 `min_insert_block_size_rows_for_materialized_views`、`min_insert_block_size_bytes_for_materialized_views` 设置. 此设置类似于 `min_insert_block_size_rows` 和 `min_insert_block_size_bytes`, 但仅适用于插入到 `MATERIALIZED VIEW` 中的块. 它有助于在推送到 MV 时控制块挤压并避免过多的内存使用. [#10858](https://github.com/ClickHouse/ClickHouse/pull/10858) ([Azat Khuzhin](https://github.com/azat)).
* 在服务器关闭期间摆脱复制队列中的异常. 修复 [#10819](https://github.com/ClickHouse/ClickHouse/issues/10819). [#10841](https://github.com/ClickHouse/ClickHouse/pull/10841) ([alesapin](https://github.com/alesapin)).
* 确保 `varSamp`、`varPop` 不能因数值错误返回负结果, 并且不能从负方差计算 `stddevSamp`、`stddevPop`. 这修复了 [#10532](https://github.com/ClickHouse/ClickHouse/issues/10532). [#10829](https://github.com/ClickHouse/ClickHouse/pull/10829) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 更好的 DNS 异常消息. 这修复了 [#10813](https://github.com/ClickHouse/ClickHouse/issues/10813). [#10828](https://github.com/ClickHouse/ClickHouse/pull/10828) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 将某些解析错误的 HTTP 响应代码更改为 400 Bad Request. 这个修复 [#10636](https://github.com/ClickHouse/ClickHouse/issues/10636). [#10640](https://github.com/ClickHouse/ClickHouse/pull/10640) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 如果 clickhouse-client 比 clickhouse-server 新, 则打印一条消息. [#10627](https://github.com/ClickHouse/ClickHouse/pull/10627) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 添加对 `INSERT INTO [db.]table WATCH` 查询的支持. [#10498](https://github.com/ClickHouse/ClickHouse/pull/10498) ([vzakaznikov](https://github.com/vzakaznikov)).
* 允许在 clickhouse-client 中传递 quota_key. 这将关闭 [#10227](https://github.com/ClickHouse/ClickHouse/issues/10227). [#10270](https://github.com/ClickHouse/ClickHouse/pull/10270) ([alexey-milovidov](https://github.com/alexey-milovidov)).

#### 性能改进

* 允许多个副本同时分配合并、突变、分区删除、移动和替换. 这将关闭 [#10367](https://github.com/ClickHouse/ClickHouse/issues/10367). [#11639](https://github.com/ClickHouse/ClickHouse/pull/11639) ([alexey-milovidov](https://github.com/alexey-milovidov)) [#11795](https://github.com/ClickHouse/ClickHouse/pull/11795) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 关于表排序键的 GROUP BY 优化, 通过 `optimize_aggregation_in_order` 设置启用. [#9113](https://github.com/ClickHouse/ClickHouse/pull/9113) ([dimarub2000](https://github.com/dimarub2000)).
* 带有 final 的选择是并行执行的. 添加设置 `max_final_threads` 以限制使用的线程数. [#10463](https://github.com/ClickHouse/ClickHouse/pull/10463) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* 当生成小块时, 通过 `INSERT SELECT` 或 INSERT with clickhouse-client 提高 INSERT 查询的性能 (并行解析的典型情况). 这修复了 [#11275](https://github.com/ClickHouse/ClickHouse/issues/11275). 修复 CONSTRAINT 不适用于 DEFAULT 字段的问题. 这修复了 [#11273](https://github.com/ClickHouse/ClickHouse/issues/11273). 修复 TEMPORARY 表忽略 CONSTRAINTS 的问题. 这修复了 [#11274](https://github.com/ClickHouse/ClickHouse/issues/11274). [#11276](https://github.com/ClickHouse/ClickHouse/pull/11276) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 消除 SELECT 部分中 GROUP BY 键的最小/最大/任何聚合器的优化, 通过 `optimize_aggregators_of_group_by_keys` 设置启用. [#11667](https://github.com/ClickHouse/ClickHouse/pull/11667) ([xPoSx](https://github.com/xPoSx)). [#11806](https://github.com/ClickHouse/ClickHouse/pull/11806) ([Azat Khuzhin](https://github.com/azat)).
* 使用 `optimize_move_functions_out_of_any` 启用的新优化, 可从 `any` 函数中删除所有操作 [#11529](https://github.com/ClickHouse/ClickHouse/pull/11529) ([Ruslan](https://github.com/kamalov-ruslan)).
* 当使用 Pretty 格式时, 提高交互模式下 `clickhouse-client` 的性能. 在以前的版本中, 计算 UTF-8 字符串的可见宽度可能会花费大量时间. 这将关闭 [#11323](https://github.com/ClickHouse/ClickHouse/issues/11323). [#11323](https://github.com/ClickHouse/ClickHouse/pull/11323) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 使用 `ORDER BY` 和小的 `LIMIT` 提高查询的性能 (小于, 然后是 `max_block_size`). [#11171](https://github.com/ClickHouse/ClickHouse/pull/11171) ([Albert Kidrachev](https://github.com/Provet)).
* 添加运行时 CPU 检测以选择和调度最佳功能实现. 添加对多个目标的代码生成的支持. 这将关闭 [#1017](https://github.com/ClickHouse/ClickHouse/issues/1017). [#10058](https://github.com/ClickHouse/ClickHouse/pull/10058) ([DimasKovas](https://github.com/DimasKovas)).
* 默认启用 clickhouse 二进制文件的 `mlock`. 它将防止 clickhouse 可执行文件在高 IO 负载下被分页. [#11139](https://github.com/ClickHouse/ClickHouse/pull/11139) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 使用 `sum` 聚合函数进行查询而不使用 GROUP BY 键以更快地运行多次. [#10992](https://github.com/ClickHouse/ClickHouse/pull/10992) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 通过删除一些冗余数据移动来改进基数排序 (在带有简单键的 `ORDER BY` 中使用). [#10981](https://github.com/ClickHouse/ClickHouse/pull/10981) ([Arslan Gumerov](https://github.com/g-arslan)).
* 在 MergeJoin 中对左表的较大部分进行排序. 缓冲内存中的剩余块. 添加 `partial_merge_join_left_table_buffer_bytes` 设置来管理左侧块缓冲区大小. [#10601](https://github.com/ClickHouse/ClickHouse/pull/10601) ([Artem Zuikov](https://github.com/4ertus2)).
* 从子查询中删除重复的 ORDER BY 和 DISTINCT, 此优化通过 `optimize_duplicate_order_by_and_distinct` 启用 [#10067](https://github.com/ClickHouse/ClickHouse/pull/10067) ([Mikhail Malafeev](https://github.com/demo-99)).
* 此功能消除了 GROUP BY 部分中其他键的功能, 通过 `optimize_group_by_function_keys` 启用 [#10051](https://github.com/ClickHouse/ClickHouse/pull/10051) ([xPoSx](https://github.com/xPoSx)).
* 使用 `optimize_arithmetic_operations_in_aggregate_functions` 启用从聚合函数中提取算术运算的新优化 [#10047](https://github.com/ClickHouse/ClickHouse/pull/10047) ([Ruslan](https://github.com/kamalov-ruslan)).
* 使用基于 Poco 而不是 curl 的 S3 的 HTTP 客户端. 这将提高性能并降低 s3 存储和表函数的内存使用量. [#11230](https://github.com/ClickHouse/ClickHouse/pull/11230) ([Pavel Kovalenko](https://github.com/Jokser)).
* 修复与基于限制重新安排相关的 Kafka 性能问题, 这些限制总是被应用. [#11149](https://github.com/ClickHouse/ClickHouse/pull/11149) ([filimonov](https://github.com/filimonov)).
* 为 jemalloc 启用 percpu_arena:percpu (这将减少由于线程池造成的内存碎片). [#11084](https://github.com/ClickHouse/ClickHouse/pull/11084) ([Azat Khuzhin](https://github.com/azat)).
* 从 S3 HTTP 客户端读取响应时优化内存使用. [#11561](https://github.com/ClickHouse/ClickHouse/pull/11561) ([Pavel Kovalenko](https://github.com/Jokser)).
* 调整默认的 Kafka 设置以获得更好的性能. [#11388](https://github.com/ClickHouse/ClickHouse/pull/11388) ([filimonov](https://github.com/filimonov)).

#### 实验功能

* 添加数据类型 `Point` (Tuple(Float64, Float64)) 和 `Polygon` (Array(Array(Tuple(Float64, Float64))). [#10678](https://github.com/ClickHouse/ClickHouse/pull/10678) ([Alexey Ilyukhov](https://github.com/livace)).
* 添加一个 `hasSubstr` 函数, 允许在数组中查找子序列. 注: 此功能可能会更名, 恕不另行通知. [#11071](https://github.com/ClickHouse/ClickHouse/pull/11071) ([Ryad Zenine](https://github.com/r-zenine)).
* 添加了 OpenCL 支持和双音排序算法, 可用于对单列中的整数类型数据进行排序. 需要使用标志 `-DENABLE_OPENCL=1` 构建. 要使用双音排序算法而不是其他算法, 您需要为设置选项 `special_sort` 设置 `bitonic_sort`, 并确保 OpenCL 可用. 此功能不会提高性能或其他任何东西, 仅作为示例和演示目的提供. 如果在这个方向上没有进一步的发展, 它可能会在不久的将来被移除. [#10232](https://github.com/ClickHouse/ClickHouse/pull/10232) ([Ri](https://github.com/margaritiko)).

#### 构建/测试/打包改进

* 为程序和实用程序启用 clang-tidy. [#10991](https://github.com/ClickHouse/ClickHouse/pull/10991) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 删除对 `tzdata` 的依赖: 如果 `/usr/share/zoneinfo` 目录不存在, 则不会失败. 请注意, 即使系统中没有安装 tzdata，所有时区都可以在 ClickHouse 中使用. [#11827](https://github.com/ClickHouse/ClickHouse/pull/11827) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 添加了 MSan 和 UBSan 压力测试. 请注意, 我们已经有了用于功能测试的 MSan、UBSan, 而 "stress" 测试是另一种测试. [#10871](https://github.com/ClickHouse/ClickHouse/pull/10871) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 在崩溃消息中打印编译器构建 ID. 这将使我们更加确定哪个二进制文件崩溃了. 添加了新函数 `buildId`. [#11824](https://github.com/ClickHouse/ClickHouse/pull/11824) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 添加了一个测试以确保在 FREEZE 查询后突变继续工作. [#11820](https://github.com/ClickHouse/ClickHouse/pull/11820) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 不允许在名称中包含 "fail" 子字符串的测试, 因为当您键入 Ctrl+F 并搜索 "fail" 时, 这会使在浏览器中查看测试结果变得不那么方便. [#11817](https://github.com/ClickHouse/ClickHouse/pull/11817) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 从 HTTPHandlerFactory 中删除未使用的导入. [#11660](https://github.com/ClickHouse/ClickHouse/pull/11660) ([Bharat Nallan](https://github.com/bharatnc)).
* 添加了对执行复制程序的实例的随机抽样. 需要避免 `Too many simultaneous queries` 错误. 还增加了超时时间并降低了故障概率. [#11573](https://github.com/ClickHouse/ClickHouse/pull/11573) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* 修复遗漏的 include. [#11525](https://github.com/ClickHouse/ClickHouse/pull/11525) ([Matwey V. Kornilov](https://github.com/matwey)).
* 通过删除旧的示例程序来加速构建。 还发现了一些孤儿功能测试. [#11486](https://github.com/ClickHouse/ClickHouse/pull/11486) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 增加 CI 中构建的 ccache 大小. [#11450](https://github.com/ClickHouse/ClickHouse/pull/11450) ([alesapin](https://github.com/alesapin)).
* 在 deb 构建中只保留 unit_tests_dbms. [#11429](https://github.com/ClickHouse/ClickHouse/pull/11429) ([Ilya Yatsishin](https://github.com/qoega)).
* 将 librdkafka 更新到版本 [1.4.2](https://github.com/edenhill/librdkafka/releases/tag/v1.4.2). [#11256](https://github.com/ClickHouse/ClickHouse/pull/11256) ([filimonov](https://github.com/filimonov)).
* 重构 CMake 构建文件. [#11390](https://github.com/ClickHouse/ClickHouse/pull/11390) ([Ivan](https://github.com/abyss7)).
* 修复几个不稳定的集成测试. [#11355](https://github.com/ClickHouse/ClickHouse/pull/11355) ([alesapin](https://github.com/alesapin)).
* 添加对使用 UBSan 运行的单元测试的支持. [#11345](https://github.com/ClickHouse/ClickHouse/pull/11345) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 从集成测试 `test_insertion_sync_fails_with_timeout` 中删除冗余超时. [#11343](https://github.com/ClickHouse/ClickHouse/pull/11343) ([alesapin](https://github.com/alesapin)).
* 更好地检查 clickhouse-test 中的挂起查询. [#11321](https://github.com/ClickHouse/ClickHouse/pull/11321) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 如果服务器是在调试中构建或使用消毒剂构建的, 则发出警告. [#11304](https://github.com/ClickHouse/ClickHouse/pull/11304) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 现在 clickhouse-test 在测试运行之前检查服务器的活动性. [#11285](https://github.com/ClickHouse/ClickHouse/pull/11285) ([alesapin](https://github.com/alesapin)).
* 修复可能不稳定的测试 `00731_long_merge_tree_select_opened_files.sh`. 它不会经常失败, 但我们在试验 ThreadFuzzer 时发现了这个测试中潜在的竞争条件: [#9814](https://github.com/ClickHouse/ClickHouse/issues/9814) 见 [link](https://clickhouse-test-reports.s3.yandex.net/9814/40e3023e215df22985d275bf85f4d2290897b76b/functional_stateless_tests_(unbundled).html#fail1) for the example. [#11270](https://github.com/ClickHouse/ClickHouse/pull/11270) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 如果 `curl` 调用超时, 则在 CI 中重复测试. 由于系统挂断超过 10 秒, 这在我们的 CI 基础设施中很常见. 这修复了 [#11267](https://github.com/ClickHouse/ClickHouse/issues/11267). [#11268](https://github.com/ClickHouse/ClickHouse/pull/11268) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 从@donmikel 添加对连接表引擎的测试. 这将关闭 [#9158](https://github.com/ClickHouse/ClickHouse/issues/9158). [#11265](https://github.com/ClickHouse/ClickHouse/pull/11265) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 修复单元测试中的几个非重大错误. [#11262](https://github.com/ClickHouse/ClickHouse/pull/11262) ([alesapin](https://github.com/alesapin)).
* 现在, `cctz` 库的部分链接器命令将不会与其他库混在一起. [#11213](https://github.com/ClickHouse/ClickHouse/pull/11213) ([alesapin](https://github.com/alesapin)).
* 将 /programs/server 拆分为实际的程序和库. [#11186](https://github.com/ClickHouse/ClickHouse/pull/11186) ([Ivan](https://github.com/abyss7)).
* 改进 protobuf 和 gRPC 的构建脚本. [#11172](https://github.com/ClickHouse/ClickHouse/pull/11172) ([Vitaly Baranov](https://github.com/vitlibar)).
* 启用不起作用的性能测试. [#11158](https://github.com/ClickHouse/ClickHouse/pull/11158) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 在启动任何 CH 实例之前为测试创建根 S3 存储桶. [#11142](https://github.com/ClickHouse/ClickHouse/pull/11142) ([Pavel Kovalenko](https://github.com/Jokser)).
* 添加非恒定多边形的性能测试. [#11141](https://github.com/ClickHouse/ClickHouse/pull/11141) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 修复 `00979_live_view_watch_continuous_aggregates` 测试. [#11024](https://github.com/ClickHouse/ClickHouse/pull/11024) ([vzakaznikov](https://github.com/vzakaznikov)).
* 添加在 tmpfs 上的集成测试中运行 zookeeper 的功能. [#11002](https://github.com/ClickHouse/ClickHouse/pull/11002) ([alesapin](https://github.com/alesapin)).
* 等待具有指数退避的 odbc-bridge. 在我们的 CI 环境中, 之前 200 毫秒的等待时间是不够的. [#10990](https://github.com/ClickHouse/ClickHouse/pull/10990) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 修复非确定性测试. [#10989](https://github.com/ClickHouse/ClickHouse/pull/10989) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 添加了对空外部数据的测试. [#10926](https://github.com/ClickHouse/ClickHouse/pull/10926) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 每次测试都会重新创建数据库. 这改进了测试的分离. [#10902](https://github.com/ClickHouse/ClickHouse/pull/10902) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 在列代码中添加了更多断言. [#10833](https://github.com/ClickHouse/ClickHouse/pull/10833) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 与清除系统更好的合作. 在清除失败的消息中打印有关 query_id 的信息. [#10832](https://github.com/ClickHouse/ClickHouse/pull/10832) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 在 "Split build smoke test" 检查中修复明显的竞争条件. [#10820](https://github.com/ClickHouse/ClickHouse/pull/10820) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 在 MergeTreeIndexFullText 中修复 (false) MSan 报告. 该问题首次出现在 [#9968](https://github.com/ClickHouse/ClickHouse/issues/9968) 中. [#10801](https://github.com/ClickHouse/ClickHouse/pull/10801) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 为 MariaDB 客户端库添加 MSan 抑制. [#10800](https://github.com/ClickHouse/ClickHouse/pull/10800) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* GRPC make 找不到 protobuf 文件, 通过添加正确的链接来更改 make 文件. [#10794](https://github.com/ClickHouse/ClickHouse/pull/10794) ([mnkonkova](https://github.com/mnkonkova)).
* 为 base、utils、programs 启用额外警告 (`-Weverything`). 请注意, 我们已经为大部分代码提供了它. [#10779](https://github.com/ClickHouse/ClickHouse/pull/10779) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 在 [#10396](https://github.com/ClickHouse/ClickHouse/issues/10396) 中, 对图书馆警告的抑制被错误地声明为公开. [#10776](https://github.com/ClickHouse/ClickHouse/pull/10776) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 恢复在 [#10396](https://github.com/ClickHouse/ClickHouse/issues/10396) 中意外删除的补丁. [#10774](https://github.com/ClickHouse/ClickHouse/pull/10774) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 修复性能测试错误, 第 2 部分. [#10773](https://github.com/ClickHouse/ClickHouse/pull/10773) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 修复性能测试错误. [#10766](https://github.com/ClickHouse/ClickHouse/pull/10766) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 更新交叉构建以使用 clang-10 编译器. [#10724](https://github.com/ClickHouse/ClickHouse/pull/10724) ([Ivan](https://github.com/abyss7)).
* 更新安装 RPM 包的说明. 这是由 Denis (TG login @ldviolet) 建议并由 Arkady Shejn 实施的. [#10707](https://github.com/ClickHouse/ClickHouse/pull/10707) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 试图修复 `tests/queries/0_stateless/01246_insert_into_watch_live_view.py` 测试. [#10670](https://github.com/ClickHouse/ClickHouse/pull/10670) ([vzakaznikov](https://github.com/vzakaznikov)).
* 修复和重新启用 00979_live_view_watch_continuous_aggregates.py 测试. [#10658](https://github.com/ClickHouse/ClickHouse/pull/10658) ([vzakaznikov](https://github.com/vzakaznikov)).
* 修复 ASan 压力测试中的 OOM. [#10646](https://github.com/ClickHouse/ClickHouse/pull/10646) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 修复迁移到 clang-10 后出现的 HashTable 中的 UBSan 报告 (向 nullptr 添加零). [#10638](https://github.com/ClickHouse/ClickHouse/pull/10638) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 在编译时的 tzdata 处理期间删除对 `ld` (bfd) 链接器的外部调用. [#10634](https://github.com/ClickHouse/ClickHouse/pull/10634) ([alesapin](https://github.com/alesapin)).
* 允许使用 `lld` 来链接 blob (资源). [#10632](https://github.com/ClickHouse/ClickHouse/pull/10632) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 修复 `LZ4` 库中的UBSan报告. [#10631](https://github.com/ClickHouse/ClickHouse/pull/10631) ([alexey-milovidov](https://github.com/alexey-milovidov)). See also [https://github.com/lz4/lz4/issues/857](https://github.com/lz4/lz4/issues/857)
* 将 LZ4 更新到最新的 dev 分支. [#10630](https://github.com/ClickHouse/ClickHouse/pull/10630) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 添加了自动生成的机器可读文件与稳定版本的列表. [#10628](https://github.com/ClickHouse/ClickHouse/pull/10628) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 修复 `capnp::UnalignedFlatArrayMessageReader` 的 `capnproto` 版本检查. [#10618](https://github.com/ClickHouse/ClickHouse/pull/10618) ([Matwey V. Kornilov](https://github.com/matwey)).
* 测试中的内存使用率较低. [#10617](https://github.com/ClickHouse/ClickHouse/pull/10617) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 在新的实时视图测试中修复硬编码超时. [#10604](https://github.com/ClickHouse/ClickHouse/pull/10604) ([vzakaznikov](https://github.com/vzakaznikov)).
* 在 tests/queries/0_stateless/helpers/client.py 中打开客户端时增加超时. [#10599](https://github.com/ClickHouse/ClickHouse/pull/10599) ([vzakaznikov](https://github.com/vzakaznikov)).
* 为 clang 构建启用 ThinLTO, 继续 [#10435](https://github.com/ClickHouse/ClickHouse/pull/10435). [#10585](https://github.com/ClickHouse/ClickHouse/pull/10585) ([Amos Bird](https://github.com/amosbird)).
* 添加模糊器并准备 oss-fuzz 集成. [#10546](https://github.com/ClickHouse/ClickHouse/pull/10546) ([kyprizel](https://github.com/kyprizel)).
* 修复 FreeBSD 构建. [#10150](https://github.com/ClickHouse/ClickHouse/pull/10150) ([Ivan](https://github.com/abyss7)).
* 使用 pytest 框架为查询测试添加新版本. [#10039](https://github.com/ClickHouse/ClickHouse/pull/10039) ([Ivan](https://github.com/abyss7)).


## ClickHouse 版本 v20.4

### ClickHouse 版本 v20.4.8.99-stable 2020-08-10

#### Bug 修复

* 修复了当 unix 时间戳作为参数传递时 `parseDateTimeBestEffort` 函数中的错误. 这修复了 [#13362](https://github.com/ClickHouse/ClickHouse/issues/13362). [#13441](https://github.com/ClickHouse/ClickHouse/pull/13441) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 修复了在具有 NaN 值的 Float 类型上调用的 `uniqExact`、`topK`、`sumDistinct` 和类似聚合函数的潜在低性能和稍微不正确的结果. 它还在调试版本中触发断言. 这修复了 [#12491](https://github.com/ClickHouse/ClickHouse/issues/12491). [#13254](https://github.com/ClickHouse/ClickHouse/pull/13254) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 如果将可空 constexpr 作为不是文字 NULL 的 cond 的固定函数. 修复 [#12463](https://github.com/ClickHouse/ClickHouse/issues/12463). [#13226](https://github.com/ClickHouse/ClickHouse/pull/13226) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 在数组元素为 Nullable 且数组下标也可为 Null 的情况下, 修复了 `arrayElement` 函数中的断言. 这修复了 [#12172](https://github.com/ClickHouse/ClickHouse/issues/12172). [#13224](https://github.com/ClickHouse/ClickHouse/pull/13224) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 用函数修正了错误的索引分析. 在从 `MergeTree` 表中读取时, 它可能会导致修剪错误的部分. 修复 [#13060](https://github.com/ClickHouse/ClickHouse/issues/13060). Fixes [#12406](https://github.com/ClickHouse/ClickHouse/issues/12406). [#13081](https://github.com/ClickHouse/ClickHouse/pull/13081) ([Anton Popov](https://github.com/CurtizJ)).
* 修复了对从本地副本进行选择的线程数的不必要限制. [#12840](https://github.com/ClickHouse/ClickHouse/pull/12840) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* 修复了查询 `WITH TOTALS` 时可能出现的数据中可能出现的额外溢出行. [#12747](https://github.com/ClickHouse/ClickHouse/pull/12747) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* 修复了大元组的性能, 这些元组在 `IN` 部分被解释为函数. 当用户出于某种晦涩的原因编写 `WHERE x IN tuple(1, 2, ...)` 而不是 `WHERE x IN (1, 2, ...)` 时的情况. [#12700](https://github.com/ClickHouse/ClickHouse/pull/12700) ([Anton Popov](https://github.com/CurtizJ)).
* 修复了`input_format_parallel_parsing` 的内存跟踪（通过将线程附加到组). [#12672](https://github.com/ClickHouse/ClickHouse/pull/12672) ([Azat Khuzhin](https://github.com/azat)).
* 修复了 [#12293](https://github.com/ClickHouse/ClickHouse/issues/12293) 当子查询包含 with 子句时允许推送谓词. [#12663](https://github.com/ClickHouse/ClickHouse/pull/12663) ([Winter Zhang](https://github.com/zhang2014)).
* 修复了 [#10572](https://github.com/ClickHouse/ClickHouse/issues/10572) 使用 const 表达式修复布隆过滤器索引. [#12659](https://github.com/ClickHouse/ClickHouse/pull/12659) ([Winter Zhang](https://github.com/zhang2014)).
* 修复了当 Broker 不可用时 (不仅如此) 在 `StorageKafka` 中的 `SIGSEGV`. [#12658](https://github.com/ClickHouse/ClickHouse/pull/12658) ([Azat Khuzhin](https://github.com/azat)).
* 添加了对带有 `Array(UUID)` 参数的函数 `if` 的支持. 这修复了 [#11066](https://github.com/ClickHouse/ClickHouse/issues/11066). [#12648](https://github.com/ClickHouse/ClickHouse/pull/12648) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 修复了带有缓存布局的外部字典中的竞争条件, 这可能导致服务器崩溃. [#12566](https://github.com/ClickHouse/ClickHouse/pull/12566) ([alesapin](https://github.com/alesapin)).
* 删除了 DROP TABLE 上分布式表 (来自异步插入的块) 的数据. [#12556](https://github.com/ClickHouse/ClickHouse/pull/12556) ([Azat Khuzhin](https://github.com/azat)).
* 修复了当 `enable_mixed_granularity_parts=1` 时, 在 `ALTER DELETE` 查询后导致旧部件损坏的错误。 修复 [#12536](https://github.com/ClickHouse/ClickHouse/issues/12536). [#12543](https://github.com/ClickHouse/ClickHouse/pull/12543) ([alesapin](https://github.com/alesapin)).
* 参数数目无效的函数 `in` 的更好例外. [#12529](https://github.com/ClickHouse/ClickHouse/pull/12529) ([Anton Popov](https://github.com/CurtizJ)).
* 修复了性能问题, 同时读取紧凑部件. [#12492](https://github.com/ClickHouse/ClickHouse/pull/12492) ([Anton Popov](https://github.com/CurtizJ)).
* 修复了当我们通过字典键的表达式加入时, JOIN 与字典中的崩溃: `t JOIN dict ON expr(dict.id) = t.id`. 在这种情况下禁用字典连接优化. [#12458](https://github.com/ClickHouse/ClickHouse/pull/12458) ([Artem Zuikov](https://github.com/4ertus2)).
* 修复了 StorageMerge 时可能出现的段错误. 关闭 [#12054](https://github.com/ClickHouse/ClickHouse/issues/12054). [#12401](https://github.com/ClickHouse/ClickHouse/pull/12401) ([tavplubix](https://github.com/tavplubix)).
* 修复了 `WITH FILL` 修饰符中列的顺序. 以前不遵守 `ORDER BY` 语句的列顺序. [#12306](https://github.com/ClickHouse/ClickHouse/pull/12306) ([Anton Popov](https://github.com/CurtizJ)).
* 当存在按虚拟列 (如 `Merge` 表中的`_table`) 或系统表中的 "index" 列过滤数据 (例如从 `system.tables` 查询时按数据库名称过滤) 时, 避免 "bad cast" 异常, 并且这个表达式返回 `Nullable` 类型. 这修复了 [#12166](https://github.com/ClickHouse/ClickHouse/issues/12166). [#12305](https://github.com/ClickHouse/ClickHouse/pull/12305) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* TrieDictionary 加载失败后显示错误. [#12290](https://github.com/ClickHouse/ClickHouse/pull/12290) ([Vitaly Baranov](https://github.com/vitlibar)).
* 对于可能导致崩溃的空数组, 函数 `arrayFill` 工作不正确. 这修复了 [#12263](https://github.com/ClickHouse/ClickHouse/issues/12263). [#12279](https://github.com/ClickHouse/ClickHouse/pull/12279) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 实现了到 `LowCardinality` 类型的通用类型的转换. 这允许对具有 LowCardinality 列和其他列的表执行 UNION ALL. 这修复了[#8212](https://github.com/ClickHouse/ClickHouse/issues/8212). 这修复了 [#4342](https://github.com/ClickHouse/ClickHouse/issues/4342). [#12275](https://github.com/ClickHouse/ClickHouse/pull/12275) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 修复了在某些特殊类型的 `StorageFile` 标头中多次连续插入期间多次写入时的行为. 这个修复了 [#6155](https://github.com/ClickHouse/ClickHouse/issues/6155). [#12197](https://github.com/ClickHouse/ClickHouse/pull/12197) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* 修复了 UInt8 值不等于 0 或 1 时的逻辑函数. [#12196](https://github.com/ClickHouse/ClickHouse/pull/12196) ([Alexander Kazakov](https://github.com/Akazz)).
* 上限 max_memory_usage* 对进程驻留内存的限制. [#12182](https://github.com/ClickHouse/ClickHouse/pull/12182) ([Azat Khuzhin](https://github.com/azat)).
* 在 GROUP BY 内射函数消除期间修复了 `dictGet` 参数检查. [#12179](https://github.com/ClickHouse/ClickHouse/pull/12179) ([Azat Khuzhin](https://github.com/azat)).
* 如果 ODBC 连接不支持架构，则不要将字典源的表名拆分为架构和表名本身. [#12165](https://github.com/ClickHouse/ClickHouse/pull/12165) ([Vitaly Baranov](https://github.com/vitlibar)).
* 修复了 `ALTER DELETE` 中的错误逻辑, 当条件评估为 NULL 时会导致删除记录. 这修复了 [#9088](https://github.com/ClickHouse/ClickHouse/issues/9088). This closes [#12106](https://github.com/ClickHouse/ClickHouse/issues/12106). [#12153](https://github.com/ClickHouse/ClickHouse/pull/12153) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 修复了在存在别名的情况下发送到外部 DBMS (例如 MySQL、ODBC) 的查询转换. 这修复了[#12032](https://github.com/ClickHouse/ClickHouse/issues/12032). [#12151](https://github.com/ClickHouse/ClickHouse/pull/12151) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 修复了整数除法中的潜在溢出. 这修复了 [#12119](https://github.com/ClickHouse/ClickHouse/issues/12119). [#12140](https://github.com/ClickHouse/ClickHouse/pull/12140) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 修复了 `greatCircleDistance`、`geoDistance` 中潜在的无限循环. 这修复了 [#12117](https://github.com/ClickHouse/ClickHouse/issues/12117). [#12137](https://github.com/ClickHouse/ClickHouse/pull/12137) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 规范化 `pid` 文件处理. 在以前的版本中, 如果服务器在没有正确关闭的情况下被杀死, 并且有另一个进程与以前运行的服务器具有相同的 pid, 则服务器可能会拒绝启动. 即使有另一台服务器正在运行, pid 文件也可能在服务器启动失败时被删除. 这修复了 [#3501](https://github.com/ClickHouse/ClickHouse/issues/3501). [#12133](https://github.com/ClickHouse/ClickHouse/pull/12133) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 修复了对字典的 ENGINE=Dictionary 表的处理依赖性. 这修复了[#10994](https://github.com/ClickHouse/ClickHouse/issues/10994). This fixes [#10397](https://github.com/ClickHouse/ClickHouse/issues/10397). [#12116](https://github.com/ClickHouse/ClickHouse/pull/12116) ([Vitaly Baranov](https://github.com/vitlibar)).
* 修复了由于线程总数限制错误导致的带有 `UNION` 的选择的性能. 修复 [#12030](https://github.com/ClickHouse/ClickHouse/issues/12030). [#12103](https://github.com/ClickHouse/ClickHouse/pull/12103) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* 使用 `-StateResample` 组合器修复了段错误. [#12092](https://github.com/ClickHouse/ClickHouse/pull/12092) ([Anton Popov](https://github.com/CurtizJ)).
* 修复了 `system.quey_log` 中选择的空 `result_rows` 和 `result_bytes` 指标. 修复 [#11595](https://github.com/ClickHouse/ClickHouse/issues/11595). [#12089](https://github.com/ClickHouse/ClickHouse/pull/12089) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* 修复了从 `VIEW` 中选择的不必要的线程数限制. 修复 [#11937](https://github.com/ClickHouse/ClickHouse/issues/11937). [#12085](https://github.com/ClickHouse/ClickHouse/pull/12085) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* 修复了使用错误类型 `PREWHERE` 时可能发生的崩溃. 修复 [#12053](https://github.com/ClickHouse/ClickHouse/issues/12053), [#12060](https://github.com/ClickHouse/ClickHouse/issues/12060). [#12060](https://github.com/ClickHouse/ClickHouse/pull/12060) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* 修复了具有 `LowCardinality` 类型的函数 `defaultValueOfArgumentType` 的 `Expected single dictionary argument for function` 错误. 修复 [#11808](https://github.com/ClickHouse/ClickHouse/issues/11808). [#12056](https://github.com/ClickHouse/ClickHouse/pull/12056) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* 修复了带有 `Tuple(LowCardinality)` 参数的高阶函数的错误 `Cannot capture column`. 修复 [#9766](https://github.com/ClickHouse/ClickHouse/issues/9766). [#12055](https://github.com/ClickHouse/ClickHouse/pull/12055) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* 加载数据库时并行解析表元数据. 这修复了有大量表时服务器启动缓慢的问题. [#12045](https://github.com/ClickHouse/ClickHouse/pull/12045) ([tavplubix](https://github.com/tavplubix)).
* 使 `topK` 聚合函数为 Enum 类型返回 Enum. 这修复了 [#3740](https://github.com/ClickHouse/ClickHouse/issues/3740). [#12043](https://github.com/ClickHouse/ClickHouse/pull/12043) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 修复了是否为常量表达式的约束检查. 这修复了 [#11360](https://github.com/ClickHouse/ClickHouse/issues/11360). [#12042](https://github.com/ClickHouse/ClickHouse/pull/12042) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 修复了元组与 `Nullable` 列的不正确比较. 修复 [#11985](https://github.com/ClickHouse/ClickHouse/issues/11985). [#12039](https://github.com/ClickHouse/ClickHouse/pull/12039) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* 修复了 allow_introspection_functions=0 时访问权限的计算. [#12031](https://github.com/ClickHouse/ClickHouse/pull/12031) ([Vitaly Baranov](https://github.com/vitlibar)).
* 修复了在调用具有不同大小的 `FixedString` 类型参数的函数 `if` 时出现错误结果和潜在崩溃的问题. 这修复了 [#11362](https://github.com/ClickHouse/ClickHouse/issues/11362). [#12021](https://github.com/ClickHouse/ClickHouse/pull/12021) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 如果使用偏移量 `-9223372036854775808` 调用函数, 则以函数 `neighbor` 作为唯一返回表达式的查询可能会返回空结果. 这修复了 [#11367](https://github.com/ClickHouse/ClickHouse/issues/11367). [#12019](https://github.com/ClickHouse/ClickHouse/pull/12019) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 修复了 allow_ddl=0 时访问权限的计算. [#12015](https://github.com/ClickHouse/ClickHouse/pull/12015) ([Vitaly Baranov](https://github.com/vitlibar)).
* 修复了 generateRandom 中可能导致崩溃的潜在数组大小溢出. 这修复了 [#11371](https://github.com/ClickHouse/ClickHouse/issues/11371). [#12013](https://github.com/ClickHouse/ClickHouse/pull/12013) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 修复了潜在的浮点异常. 这将关闭 [#11378](https://github.com/ClickHouse/ClickHouse/issues/11378). [#12005](https://github.com/ClickHouse/ClickHouse/pull/12005) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 修复了服务器启动时日志消息中错误的设置名称. [#11997](https://github.com/ClickHouse/ClickHouse/pull/11997) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 修复了 `Values` 格式中的 `Query parameter was not set` 问题. 修复 [#11918](https://github.com/ClickHouse/ClickHouse/issues/11918). [#11936](https://github.com/ClickHouse/ClickHouse/pull/11936) ([tavplubix](https://github.com/tavplubix)).
* 在查询 (参数化查询) 中保留替换的别名. 这修复了 [#11914](https://github.com/ClickHouse/ClickHouse/issues/11914). [#11916](https://github.com/ClickHouse/ClickHouse/pull/11916) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 修复了从默认存储策略更改存储策略时没有移动的错误. [#11893](https://github.com/ClickHouse/ClickHouse/pull/11893) ([Vladimir Chebotarev](https://github.com/excitoon)).
* 修复了解析 `DateTime64` 时潜在的浮点异常. 这修复了 [#11374](https://github.com/ClickHouse/ClickHouse/issues/11374). [#11875](https://github.com/ClickHouse/ClickHouse/pull/11875) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 通过 HTTP 接口固定内存记帐 (使用 `wait_end_of_query=1` 可能很重要). [#11840](https://github.com/ClickHouse/ClickHouse/pull/11840) ([Azat Khuzhin](https://github.com/azat)).
* 在检查相等性之前解析存储在 zookeeper 中的元数据. [#11739](https://github.com/ClickHouse/ClickHouse/pull/11739) ([Azat Khuzhin](https://github.com/azat)).

#### 性能改进

* 索引不用于带文字的 IN 运算符, 在 v19.3 前后引入了性能回归. 这修复了 [#10574](https://github.com/ClickHouse/ClickHouse/issues/10574). [#12062](https://github.com/ClickHouse/ClickHouse/pull/12062) ([nvartolomei](https://github.com/nvartolomei)).

#### 构建/测试/打包改进

* 在 Dockerfile 中的第一个 `apt-get update` 之前安装 `ca-certificates`. [#12095](https://github.com/ClickHouse/ClickHouse/pull/12095) ([Ivan Blinkov](https://github.com/blinkov)).


### ClickHouse 版本 v20.4.6.53-stable 2020-06-25

#### Bug 修复

* 修复在 prewhere 条件下使用 `Nullable` 列导致的罕见崩溃. 续 [#11608](https://github.com/ClickHouse/ClickHouse/issues/11608). [#11869](https://github.com/ClickHouse/ClickHouse/pull/11869) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* 不允许在高阶函数中使用 arrayJoin. 它导致协议同步中断. 这将关闭 [#3933](https://github.com/ClickHouse/ClickHouse/issues/3933). [#11846](https://github.com/ClickHouse/ClickHouse/pull/11846) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 修复 FixedString 与常量 String 比较的错误结果. 这修复了. [#11828](https://github.com/ClickHouse/ClickHouse/pull/11828) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 修复条件为 NULL 的 `if()` 的错误结果. [#11807](https://github.com/ClickHouse/ClickHouse/pull/11807) ([Artem Zuikov](https://github.com/4ertus2)).
* 修复使用过多线程进行查询. [#11788](https://github.com/ClickHouse/ClickHouse/pull/11788) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* 修复像 `SELECT *, xyz.*` 这样的查询的意外行为, 这些查询在预期错误时成功. [#11753](https://github.com/ClickHouse/ClickHouse/pull/11753) ([hexiaoting](https://github.com/hexiaoting)).
* 现在复制的提取将在元数据更改期间取消. [#11744](https://github.com/ClickHouse/ClickHouse/pull/11744) ([alesapin](https://github.com/alesapin)).
* 修复了由 Values 输入格式中复杂文字的错误类型推导导致的 LOGICAL_ERROR. [#11732](https://github.com/ClickHouse/ClickHouse/pull/11732) ([tavplubix](https://github.com/tavplubix)).
* 修复 在 const 列上的 `ORDER BY ... WITH FILL` . [#11697](https://github.com/ClickHouse/ClickHouse/pull/11697) ([Anton Popov](https://github.com/CurtizJ)).
* 与 XDBC 桥通信时传递适当的超时. 最近在检查桥接活性和接收元信息时没有遵守超时. [#11690](https://github.com/ClickHouse/ClickHouse/pull/11690) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 将 `LIMIT n WITH TIES` 与包含别名的 `ORDER BY` 语句一起使用. [#11689](https://github.com/ClickHouse/ClickHouse/pull/11689) ([Anton Popov](https://github.com/CurtizJ)).
* 修复导致 `system.mutations` 状态不正确的错误. 它可能表明整个突变已经完成, 但服务器在复制队列中仍有 `MUTATE_PART` 任务并尝试执行它们. 这修复了 [#11611](https://github.com/ClickHouse/ClickHouse/issues/11611). [#11681](https://github.com/ClickHouse/ClickHouse/pull/11681) ([alesapin](https://github.com/alesapin)).
* 添加对带有不区分大小写标志的正则表达式的支持. 这修复了 [#11101](https://github.com/ClickHouse/ClickHouse/issues/11101) and fixes [#11506](https://github.com/ClickHouse/ClickHouse/issues/11506). [#11649](https://github.com/ClickHouse/ClickHouse/pull/11649) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 如果设置了行级安全性, 则删除琐碎的计数查询优化. 在以前的版本中, 用户获取表中记录的总数而不是过滤. 这修复了[#11352](https://github.com/ClickHouse/ClickHouse/issues/11352). [#11644](https://github.com/ClickHouse/ClickHouse/pull/11644) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 修复字符串的布隆过滤器 (数据跳过索引). [#11638](https://github.com/ClickHouse/ClickHouse/pull/11638) ([Azat Khuzhin](https://github.com/azat)).
* 修复在 prewhere 条件下使用 `Nullable` 列导致的罕见崩溃. (可能它以某种方式与 [#11572](https://github.com/ClickHouse/ClickHouse/issues/11572) 相关联). [#11608](https://github.com/ClickHouse/ClickHouse/pull/11608) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* 修复错误 `Block structure mismatch` , 用于从 `Buffer` 表中采样读取的查询. [#11602](https://github.com/ClickHouse/ClickHouse/pull/11602) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* 修复 clickhouse-client 的错误退出代码, 当 exception.code() % 256 = 0 时. [#11601](https://github.com/ClickHouse/ClickHouse/pull/11601) ([filimonov](https://github.com/filimonov)).
* 修复服务器启动时有关 `Mark cache size was lowered` 的日志消息中的小错误. 这将关闭 [#11399](https://github.com/ClickHouse/ClickHouse/issues/11399). [#11589](https://github.com/ClickHouse/ClickHouse/pull/11589) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 修复错误 `Size of offsets does not match size of column` , 用于查询中的 `PREWHERE column in (subquery)` 和 `ARRAY JOIN` . [#11580](https://github.com/ClickHouse/ClickHouse/pull/11580) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* 修复了 `SHOW CREATE TABLE` 中罕见的段错误. 修复 [#11490](https://github.com/ClickHouse/ClickHouse/issues/11490). [#11579](https://github.com/ClickHouse/ClickHouse/pull/11579) ([tavplubix](https://github.com/tavplubix)).
* HTTP 会话中的所有查询都具有相同的 query_id. 它是固定的. [#11578](https://github.com/ClickHouse/ClickHouse/pull/11578) ([tavplubix](https://github.com/tavplubix)).
* 现在 clickhouse-server docker 容器将更喜欢 IPv6 检查服务器活动性. [#11550](https://github.com/ClickHouse/ClickHouse/pull/11550) ([Ivan Starkov](https://github.com/istarkov)).
* 修复 `<node>` 的 shard_num/replica_num (破坏 use_compact_format_in_distributed_parts_names). [#11528](https://github.com/ClickHouse/ClickHouse/pull/11528) ([Azat Khuzhin](https://github.com/azat)).
* 修复可能导致表删除期间异常的竞争条件. 这有点棘手, 一点也不危险. 如果你想要解释, 请在电报中通知我. [#11523](https://github.com/ClickHouse/ClickHouse/pull/11523) ([alesapin](https://github.com/alesapin)).
* 使用 -State 函数在聚合过程中抛出异常时修复内存泄漏. 这修复了 [#8995](https://github.com/ClickHouse/ClickHouse/issues/8995). [#11496](https://github.com/ClickHouse/ClickHouse/pull/11496) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 如果数据跳过索引依赖于将在后台合并期间修改的列 (对于 SummingMergeTree、AggregatingMergeTree 以及 TTL GROUP BY) , 则计算错误. 此问题已通过合并后移动索引计算得到修复, 因此索引是在合并数据上计算的. [#11162](https://github.com/ClickHouse/ClickHouse/pull/11162) ([Azat Khuzhin](https://github.com/azat)).
* 摆脱旧的 libunwind 补丁. https://github.com/ClickHouse-Extras/libunwind/commit/500aa227911bd185a94bfc071d68f4d3b03cb3b1#r39048012 这允许在 `clang` 中禁用 `-fno-omit-frame-pointer` 至少 1% 的平均构建性能. [#10761](https://github.com/ClickHouse/ClickHouse/pull/10761) ([Amos Bird](https://github.com/amosbird)).
* 使用 `FINAL` 修饰符和 `ORDER BY` 优化来修复包装到函数中的主键的使用. [#10715](https://github.com/ClickHouse/ClickHouse/pull/10715) ([Anton Popov](https://github.com/CurtizJ)).

#### 构建/测试/打包改进

* 修复单元测试中的几个非重大错误. [#11262](https://github.com/ClickHouse/ClickHouse/pull/11262) ([alesapin](https://github.com/alesapin)).
* 在 MergeTreeIndexFullText 中修复 (false) MSan 报告. 该问题首先出现在 [#9968](https://github.com/ClickHouse/ClickHouse/issues/9968). [#10801](https://github.com/ClickHouse/ClickHouse/pull/10801) ([alexey-milovidov](https://github.com/alexey-milovidov)).


### ClickHouse 版本 v20.4.5.36-stable 2020-06-10

#### Bug 修复

* 修复了在启用 `min_bytes_to_use_direct_io` 且 PREWHERE 处于活动状态并使用 SAMPLE 或大量线程时可能发生的 `Data compressed with different methods` 错误. 这修复了 [#11539](https://github.com/ClickHouse/ClickHouse/issues/11539). [#11540](https://github.com/ClickHouse/ClickHouse/pull/11540) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 修复编解码器的返回压缩大小. [#11448](https://github.com/ClickHouse/ClickHouse/pull/11448) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* 当列具有带有非文字参数的压缩编解码器时修复服务器崩溃. 修复 [#11365](https://github.com/ClickHouse/ClickHouse/issues/11365). [#11431](https://github.com/ClickHouse/ClickHouse/pull/11431) ([alesapin](https://github.com/alesapin)).
* 以 nan 为点修复 pointInPolygon. 修复 [#11375](https://github.com/ClickHouse/ClickHouse/issues/11375). [#11421](https://github.com/ClickHouse/ClickHouse/pull/11421) ([Alexey Ilyukhov](https://github.com/livace)).
* 如果表未成功创建, 则修复 MergeTree 关闭时潜在的未初始化内存读取. [#11420](https://github.com/ClickHouse/ClickHouse/pull/11420) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 修复了带有纬度/经度范围之外的参数的 geohashesInBox. [#11403](https://github.com/ClickHouse/ClickHouse/pull/11403) ([Vasily Nemkov](https://github.com/Enmk)).
* 修复具有外部排序和限制的查询可能出现的 `Pipeline stuck` 错误. 修复 [#11359](https://github.com/ClickHouse/ClickHouse/issues/11359). [#11366](https://github.com/ClickHouse/ClickHouse/pull/11366) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* 在 ReplicatedMergeTree 中发送零件期间删除冗余锁. [#11354](https://github.com/ClickHouse/ClickHouse/pull/11354) ([alesapin](https://github.com/alesapin)).
* 修复了多行模式下 clickhouse-client 对 `\G`（垂直输出）的支持. 这将关闭 [#9933](https://github.com/ClickHouse/ClickHouse/issues/9933). [#11350](https://github.com/ClickHouse/ClickHouse/pull/11350) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 修复使用 `Lazy` 数据库时潜在的段错误. [#11348](https://github.com/ClickHouse/ClickHouse/pull/11348) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 修复 `quantilesExactWeightedArray` 中的崩溃问题. [#11337](https://github.com/ClickHouse/ClickHouse/pull/11337) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* 现在合并在 `ALTER` 查询中更改元数据之前停止. [#11335](https://github.com/ClickHouse/ClickHouse/pull/11335) ([alesapin](https://github.com/alesapin)).
* 通过再次设置 `parallel_view_processing = 1` 并行写入 `MATERIALIZED VIEW` . 修复 [#10241](https://github.com/ClickHouse/ClickHouse/issues/10241). [#11330](https://github.com/ClickHouse/ClickHouse/pull/11330) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* 当提取的 JSON 具有不平衡的 { 或 [ 字符串时, 修复visitParamExtractRaw. [#11318](https://github.com/ClickHouse/ClickHouse/pull/11318) ([Ewout](https://github.com/devwout)).
* 修复 ThreadPool 中非常罕见的竞争条件. [#11314](https://github.com/ClickHouse/ClickHouse/pull/11314) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 修复 clickhouse-copier 中无关紧要的数据竞争. 通过集成测试发现. [#11313](https://github.com/ClickHouse/ClickHouse/pull/11313) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 修复转换中潜在的未初始化内存. 示例: `SELECT toIntervalSecond(now64())`. [#11311](https://github.com/ClickHouse/ClickHouse/pull/11311) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 修复了如果表的主键中有 Array 列并且查询正在使用 `empty` 或 `notEmpty` 函数按此列过滤时索引分析无法工作的问题. 这修复了 [#11286](https://github.com/ClickHouse/ClickHouse/issues/11286). [#11303](https://github.com/ClickHouse/ClickHouse/pull/11303) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 修复当查询速度估计可能不正确时的错误, 并且如果查询受到 `max_network_bandwidth`、`max_execution_speed` 或 `priority` 设置的限制, `min_execution_speed` 的限制可能无法工作或无法正常工作. 将 `timeout_before_checking_execution_speed` 的默认值更改为非零值, 否则设置 `min_execution_speed` 和 `max_execution_speed` 无效. 这修复了 [#11297](https://github.com/ClickHouse/ClickHouse/issues/11297). 这修复了 [#5732](https://github.com/ClickHouse/ClickHouse/issues/5732)。 这修复了 [#6228](https://github.com/ClickHouse/ClickHouse/issues/6228). 可用性改进：避免在“clickhouse-client”中将异常消息与进度条串联. [#11296](https://github.com/ClickHouse/ClickHouse/pull/11296) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 修复使用错误参数调用 SET DEFAULT ROLE 时的崩溃. 这修复了[#10586](https://github.com/ClickHouse/ClickHouse/issues/10586). [#11278](https://github.com/ClickHouse/ClickHouse/pull/11278) ([Vitaly Baranov](https://github.com/vitlibar)).
* 修复读取 Protobuf 格式错误数据时崩溃的问题. 这修复了 [#5957](https://github.com/ClickHouse/ClickHouse/issues/5957), fixes [#11203](https://github.com/ClickHouse/ClickHouse/issues/11203). [#11258](https://github.com/ClickHouse/ClickHouse/pull/11258) ([Vitaly Baranov](https://github.com/vitlibar)).
* 修复了缓存字典可以返回默认值而不是正常值 (只有过期键时) 的错误. 这仅影响字符串字段. [#11233](https://github.com/ClickHouse/ClickHouse/pull/11233) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* 修复错误 `Block structure mismatch in QueryPipeline`, 同时从内部查询中的常量读取 `VIEW` . 修复 [#11181](https://github.com/ClickHouse/ClickHouse/issues/11181). [#11205](https://github.com/ClickHouse/ClickHouse/pull/11205) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* 修复可能的异常 `Invalid status for associated output`. [#11200](https://github.com/ClickHouse/ClickHouse/pull/11200) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* 使用 `Array(Array(LowCardinality))` 捕获参数修复高阶函数的可能错误 `Cannot capture column` . [#11185](https://github.com/ClickHouse/ClickHouse/pull/11185) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* 修复了 S3 globbing 在超过 1000 个密钥和一些后端的情况下可能会失败的问题. [#11179](https://github.com/ClickHouse/ClickHouse/pull/11179) ([Vladimir Chebotarev](https://github.com/excitoon)).
* 如果数据跳过索引依赖于将在后台合并期间修改的列 (对于 SummingMergeTree、AggregatingMergeTree 以及 TTL GROUP BY), 则计算错误. 此问题已通过合并后移动索引计算得到修复, 因此索引是在合并数据上计算的. [#11162](https://github.com/ClickHouse/ClickHouse/pull/11162) ([Azat Khuzhin](https://github.com/azat)).
* 修复与基于限制重新安排相关的 Kafka 性能问题, 这些限制总是被应用. [#11149](https://github.com/ClickHouse/ClickHouse/pull/11149) ([filimonov](https://github.com/filimonov)).
* 修复了在表引擎 = Kafka 的 DROP 期间 (或在服务器重新启动期间) 有时发生的挂起. [#11145](https://github.com/ClickHouse/ClickHouse/pull/11145) ([filimonov](https://github.com/filimonov)).
* 修复简单查询过多的线程预留 (优化减少线程数量, 在管道更改后部分中断). [#11114](https://github.com/ClickHouse/ClickHouse/pull/11114) ([Azat Khuzhin](https://github.com/azat)).
* 修复分布式查询的谓词优化 (`enable_optimize_predicate_expression=1`) 对于带有 `HAVING` 部分的查询 (即需要在服务器启动器上进行过滤时), 通过保留表达式的顺序 (这足以修复), 并且还强制 聚合器在索引上使用列名. 修复: [#10613](https://github.com/ClickHouse/ClickHouse/issues/10613), [#11413](https://github.com/ClickHouse/ClickHouse/issues/11413). [#10621](https://github.com/ClickHouse/ClickHouse/pull/10621) ([Azat Khuzhin](https://github.com/azat)).

#### 构建/测试/打包改进

* 修复几个不稳定的集成测试. [#11355](https://github.com/ClickHouse/ClickHouse/pull/11355) ([alesapin](https://github.com/alesapin)).

### ClickHouse 版本 v20.4.4.18-stable 2020-05-26

与 v20.4.3.16 稳定版相比没有变化.

### ClickHouse 版本 v20.4.3.16-stable 2020-05-23

#### Bug 修复

* 如果没有最终确定, 则从突变终止任务中删除日志记录. [#11109](https://github.com/ClickHouse/ClickHouse/pull/11109) ([alesapin](https://github.com/alesapin)).
* 修复了 registerDiskS3 中的内存泄漏. [#11074](https://github.com/ClickHouse/ClickHouse/pull/11074) ([Pavel Kovalenko](https://github.com/Jokser)).
* 修复 Kafka 引擎表终止时可能丢失的数据. [#11048](https://github.com/ClickHouse/ClickHouse/pull/11048) ([filimonov](https://github.com/filimonov)).
* 复了 `parseDateTime64BestEffort` 参数解析错误. [#11038](https://github.com/ClickHouse/ClickHouse/pull/11038) ([Vasily Nemkov](https://github.com/Enmk)).
* 如果表未成功创建, 则修复了 `MergeTree` 中非常罕见的潜在释放后使用错误. [#10986](https://github.com/ClickHouse/ClickHouse/pull/10986), [#10970](https://github.com/ClickHouse/ClickHouse/pull/10970) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 修复了原子数据库的元数据 (重命名的相对路径) 和数据 (符号链接的相对路径) 处理. [#10980](https://github.com/ClickHouse/ClickHouse/pull/10980) ([Azat Khuzhin](https://github.com/azat)).
* 修复了使用 `Atomic` 数据库引擎并发 `ALTER` 和 `DROP DATABASE` 查询时服务器崩溃的问题. [#10968](https://github.com/ClickHouse/ClickHouse/pull/10968) ([tavplubix](https://github.com/tavplubix)).
* 修复了 `getRawData()` 方法中不正确的原始数据大小. [#10964](https://github.com/ClickHouse/ClickHouse/pull/10964) ([Igr](https://github.com/ObjatieGroba)).
* 修复了 20.1 及更早版本之间两级聚合的不兼容问题. 当在发起节点和远程节点上使用不同版本的 ClickHouse 并且 GROUP BY 结果的大小很大并且由单个 String 字段执行聚合时, 就会发生这种不兼容. 结果导致单个键的多个未合并的行. [#10952](https://github.com/ClickHouse/ClickHouse/pull/10952) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 修复了通过 `DistributedBlockOutputStream` 发送部分写入的文件. [#10940](https://github.com/ClickHouse/ClickHouse/pull/10940) ([Azat Khuzhin](https://github.com/azat)).
* 修复了 `SELECT count(notNullIn(NULL, []))` 中的崩溃. [#10920](https://github.com/ClickHouse/ClickHouse/pull/10920) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* 修复了在 `Kafka` 表引擎的 `DROP` 期间有时发生的挂起. (或在服务器重新启动期间). [#10910](https://github.com/ClickHouse/ClickHouse/pull/10910) ([filimonov](https://github.com/filimonov)).
* 修复了无法像 `a TO b, c TO a` 那样执行多个 `ALTER RENAME` 的问题. [#10895](https://github.com/ClickHouse/ClickHouse/pull/10895) ([alesapin](https://github.com/alesapin)).
* 修复了当您从同一列的多个线程的聚合函数状态获得结果时可能发生的竞争. 它可能发生的唯一方法是当您使用 `finalizeAggregation` 函数同时使用 `Memory` 引擎从表中读取时, 该引擎为 `quantile*` 函数存储 `AggregateFunction` 状态. [#10890](https://github.com/ClickHouse/ClickHouse/pull/10890) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* 修复了与分布式表中元组的向后兼容性. [#10889](https://github.com/ClickHouse/ClickHouse/pull/10889) ([Anton Popov](https://github.com/CurtizJ)).
* 如果这样的键不存在, 则修复了 `StringHashTable` 中的 `SIGSEGV`. [#10870](https://github.com/ClickHouse/ClickHouse/pull/10870) ([Azat Khuzhin](https://github.com/azat)).
* 修复了在使用 `Atomic` 引擎从数据库中删除 `LiveView` 表后, `WATCH` 挂起的问题. [#10859](https://github.com/ClickHouse/ClickHouse/pull/10859) ([tavplubix](https://github.com/tavplubix)).
* 修复了 `ReplicatedMergeTree` 中的错误, 该错误可能导致 `OPTIMIZE` 查询上的某些 `ALTER` 在它变为非活动状态后挂起等待某些副本. [#10849](https://github.com/ClickHouse/ClickHouse/pull/10849) ([tavplubix](https://github.com/tavplubix)).
* 现在, 如果参与 `CONSTRAINT` 表达式的列被重命名, 则约束会更新. 修复 [#10844](https://github.com/ClickHouse/ClickHouse/issues/10844). [#10847](https://github.com/ClickHouse/ClickHouse/pull/10847) ([alesapin](https://github.com/alesapin)).
* 修复了缓存字典中未初始化内存的潜在读取. [#10834](https://github.com/ClickHouse/ClickHouse/pull/10834) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 修复 `Block::sortColumns()` 之后的列顺序. [#10826](https://github.com/ClickHouse/ClickHouse/pull/10826) ([Azat Khuzhin](https://github.com/azat)).
* 修复了当不要求引用标识符时 `ODBC` 桥的问题. 修复 [#7984](https://github.com/ClickHouse/ClickHouse/issues/7984). [#10821](https://github.com/ClickHouse/ClickHouse/pull/10821) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 修复了 `DateLUT` 中的 `UBSan` 和 `MSan` 报告. [#10798](https://github.com/ClickHouse/ClickHouse/pull/10798) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 修复了关键条件下错误的类型转换. 修复 [#6287](https://github.com/ClickHouse/ClickHouse/issues/6287). [#10791](https://github.com/ClickHouse/ClickHouse/pull/10791) ([Andrew Onyshchuk](https://github.com/oandrew)).
* 修复了 `parallel_view_processing` 行为. 现在, 如果发生异常, 所有对 `MATERIALIZED VIEW` 的插入都应该无一例外地完成. 修复 [#10241](https://github.com/ClickHouse/ClickHouse/issues/10241). [#10757](https://github.com/ClickHouse/ClickHouse/pull/10757) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* 固定组合器 `-OrNull` 和 `-OrDefault` 与 `-State` 结合使用. [#10741](https://github.com/ClickHouse/ClickHouse/pull/10741) ([hcz](https://github.com/hczhcz)).
* 修复了函数 `h3EdgeAngle` 中可能出现的缓冲区溢出. [#10711](https://github.com/ClickHouse/ClickHouse/pull/10711) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 修复了当表有很多部分时锁定并发更改的错误. [#10659](https://github.com/ClickHouse/ClickHouse/pull/10659) ([alesapin](https://github.com/alesapin)).
* 如果服务器在表启动前关闭, 则修复了 `StorageBuffer` 中的 `nullptr` 取消引用. [#10641](https://github.com/ClickHouse/ClickHouse/pull/10641) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 使用 `LowCardinality` 修复了 `optimize_skip_unused_shards` . [#10611](https://github.com/ClickHouse/ClickHouse/pull/10611) ([Azat Khuzhin](https://github.com/azat)).
* 修复了同步突变的处理条件变量. 在某些情况下, 该条件变量的信号可能会丢失. [#10588](https://github.com/ClickHouse/ClickHouse/pull/10588) ([Vladimir Chebotarev](https://github.com/excitoon)).
* 修复了在 `loadStoredObject()` 完成之前调用 `createDictionary()` 时可能发生的崩溃. [#10587](https://github.com/ClickHouse/ClickHouse/pull/10587) ([Vitaly Baranov](https://github.com/vitlibar)).
* 修复了列 `ALIAS` 的 `SELECT`, 它的默认表达式类型与列类型不同. [#10563](https://github.com/ClickHouse/ClickHouse/pull/10563) ([Azat Khuzhin](https://github.com/azat)).
* 实现了 DateTime64 和 String 值之间的比较. [#10560](https://github.com/ClickHouse/ClickHouse/pull/10560) ([Vasily Nemkov](https://github.com/Enmk)).
* 默认禁用 `GROUP BY` sharding_key优化 ( `optimize_distributed_group_by_sharding_key` 已经被引入并默认关闭, 由于 sharding_key 分析的技巧, 简单的例子是 sharding key 中的 `if`) 并修复它为 `WITH ROLLUP/CUBE/TOTALS`. [#10516](https://github.com/ClickHouse/ClickHouse/pull/10516) ([Azat Khuzhin](https://github.com/azat)).
* 已修复 [#10263](https://github.com/ClickHouse/ClickHouse/issues/10263). [#10486](https://github.com/ClickHouse/ClickHouse/pull/10486) ([Azat Khuzhin](https://github.com/azat)).
* 添加了关于 `max_rows_to_sort` 设置的测试. [#10268](https://github.com/ClickHouse/ClickHouse/pull/10268) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 添加了创建布隆过滤器索引的向后兼容性. [#10551](https://github.com/ClickHouse/ClickHouse/issues/10551). [#10569](https://github.com/ClickHouse/ClickHouse/pull/10569) ([Winter Zhang](https://github.com/zhang2014)).

### ClickHouse 版本 v20.4.2.9, 2020-05-12

#### 向后不兼容变更
* 系统表 (例如 system.query_log、system.trace_log、system.metric_log) 对小于 10 MiB 的部分使用合并数据部分格式. 自 20.3 版起支持压缩数据部分格式. 如果你打算降级到20.3以下的版本, 你应该手动删除 `/var/lib/clickhouse/data/system/` 中系统日志的表数据.
* 当字符串比较涉及 FixedString 并且比较的参数大小不同时, 将较小的字符串填充到较大的字符串的长度进行比较. 如果我们想象 FixedString 数据类型对应于 SQL CHAR，这是为了 SQL 兼容性. 这将关闭 [#9272](https://github.com/ClickHouse/ClickHouse/issues/9272). [#10363](https://github.com/ClickHouse/ClickHouse/pull/10363) ([alexey-milovidov](https://github.com/alexey-milovidov))
* 使 SHOW CREATE TABLE 多行. 现在它更具可读性, 更像 MySQL. [#10049](https://github.com/ClickHouse/ClickHouse/pull/10049) ([Azat Khuzhin](https://github.com/azat))
* 添加了在 `pointInPolygon` 函数中使用并默认启用的设置 `validate_polygons`. [#9857](https://github.com/ClickHouse/ClickHouse/pull/9857) ([alexey-milovidov](https://github.com/alexey-milovidov))

#### 新特征
* 添加对从 ClickHouse 到 Zookeeper 的安全连接的支持 [#10184](https://github.com/ClickHouse/ClickHouse/pull/10184) ([Konstantin Lebedev](https://github.com/xzkostyan))
* 支持自定义 HTTP 处理程序。 参见 [#5436](https://github.com/ClickHouse/ClickHouse/issues/5436) 的描述. [#7572](https://github.com/ClickHouse/ClickHouse/pull/7572) ([Winter Zhang](https://github.com/zhang2014))
* 添加 MessagePack 输入/输出格式. [#9889](https://github.com/ClickHouse/ClickHouse/pull/9889) ([Kruglov Pavel](https://github.com/Avogar))
* 添加正则表达式输入格式. [#9196](https://github.com/ClickHouse/ClickHouse/pull/9196) ([Kruglov Pavel](https://github.com/Avogar))
* 添加了输出格式 `Markdown`, 用于在 Markdown 文档中嵌入表格. [#10317](https://github.com/ClickHouse/ClickHouse/pull/10317) ([Kruglov Pavel](https://github.com/Avogar))
* 添加了对字典中自定义设置部分的支持. 还修复了问题 [#2829](https://github.com/ClickHouse/ClickHouse/issues/2829). [#10137](https://github.com/ClickHouse/ClickHouse/pull/10137) ([Artem Streltsov](https://github.com/kekekekule))
* 在 DDL 查询中为 `CREATE DICTIONARY` 添加了自定义设置支持. [#10465](https://github.com/ClickHouse/ClickHouse/pull/10465) ([Artem Streltsov](https://github.com/kekekekule))
* 添加简单的服务器范围内存分析器, 当服务器内存使用率高于下一个分配阈值时, 它将收集分配上下文. [#10444](https://github.com/ClickHouse/ClickHouse/pull/10444) ([alexey-milovidov](https://github.com/alexey-milovidov))
* 添加设置 `always_fetch_merged_part` 限制副本自己合并部分, 并且总是喜欢从其他副本下载. [#10379](https://github.com/ClickHouse/ClickHouse/pull/10379) ([alesapin](https://github.com/alesapin))
* 添加函数 `JSONExtractKeysAndValuesRaw`, 它从JSON对象中提取原始数据. [#10378](https://github.com/ClickHouse/ClickHouse/pull/10378) ([hcz](https://github.com/hczhcz))
* 将操作系统的内存使用添加到 `system.asynchronous_metrics`. [#10361](https://github.com/ClickHouse/ClickHouse/pull/10361) ([alexey-milovidov](https://github.com/alexey-milovidov))
* 添加了函数 `least` 和 `greatest` 的通用变体. 现在它们可以处理任意数量的任意类型的参数. 这修复了 [#4767](https://github.com/ClickHouse/ClickHouse/issues/4767) [#10318](https://github.com/ClickHouse/ClickHouse/pull/10318) ([alexey-milovidov](https://github.com/alexey-milovidov))
* 现在, ClickHouse 在其一侧控制字典源的超时. 缓存字典配置中添加了两个新设置: `strict_max_lifetime_seconds`，默认为 `max_lifetime`，以及 `query_wait_timeout_milliseconds`, 默认为一分钟. 第一个设置对于 `allow_read_expired_keys` 设置也很有用 (禁止读取非常过期的键). [#10337](https://github.com/ClickHouse/ClickHouse/pull/10337) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov))
* 添加 log_queries_min_type 以过滤哪些条目将写入 query_log. [#10053](https://github.com/ClickHouse/ClickHouse/pull/10053) ([Azat Khuzhin](https://github.com/azat))
* 添加函数 `isConstant`. 此函数检查其参数是否为常量表达式并返回 1 或 0. 用于开发、调试和演示目的. [#10198](https://github.com/ClickHouse/ClickHouse/pull/10198) ([alexey-milovidov](https://github.com/alexey-milovidov))
* 添加 joinGetOrNull 以在 key 丢失时返回 NULL 而不是返回默认值. [#10094](https://github.com/ClickHouse/ClickHouse/pull/10094) ([Amos Bird](https://github.com/amosbird))
* 如果设置了选项 `transform_null_in`, 则认为 `NULL` 等于 `IN` 运算符中的 `NULL`. [#10085](https://github.com/ClickHouse/ClickHouse/pull/10085) ([achimbab](https://github.com/achimbab))
* 为 MergeTree 表引擎系列添加 `ALTER TABLE ... RENAME COLUMN`. [#9948](https://github.com/ClickHouse/ClickHouse/pull/9948) ([alesapin](https://github.com/alesapin))
* 支持并行分布式 INSERT SELECT. [#9759](https://github.com/ClickHouse/ClickHouse/pull/9759) ([vxider](https://github.com/Vxider))
* 添加在分布式上查询分布式的能力 (不带 `distributed_group_by_no_merge`) ... [#9923](https://github.com/ClickHouse/ClickHouse/pull/9923) ([Azat Khuzhin](https://github.com/azat))
* 添加函数 `arrayReduceInRanges` , 它聚合给定范围内的数组元素. [#9598](https://github.com/ClickHouse/ClickHouse/pull/9598) ([hcz](https://github.com/hczhcz))
* 在 prometheus 导出器上添加字典状态. [#9622](https://github.com/ClickHouse/ClickHouse/pull/9622) ([Guillaume Tassery](https://github.com/YiuRULE))
* 添加函数 `arrayAUC`. [#8698](https://github.com/ClickHouse/ClickHouse/pull/8698) ([taiyang-li](https://github.com/taiyang-li))
* 支持 `DROP VIEW` 语句以获得更好的TPC-H兼容性. [#9831](https://github.com/ClickHouse/ClickHouse/pull/9831) ([Amos Bird](https://github.com/amosbird))
* 将 `strict_order` 选项添加到 windowFunnel(). [#9773](https://github.com/ClickHouse/ClickHouse/pull/9773) ([achimbab](https://github.com/achimbab))
* 支持 `DATE` 和 `TIMESTAMP` SQL 操作符, 例如 `选择日期'2001-01-01'`. [#9691](https://github.com/ClickHouse/ClickHouse/pull/9691) ([Artem Zuikov](https://github.com/4ertus2))

#### 实验功能
* 添加了实验性数据库引擎 Atomic. 它支持非阻塞 `DROP` 和 `RENAME TABLE` 查询以及原子 `EXCHANGE TABLES t1 AND t2` 查询. [#7512](https://github.com/ClickHouse/ClickHouse/pull/7512) ([tavplubix](https://github.com/tavplubix))
* 对 S3 上的 ReplicatedMergeTree 的初始支持 (它以次优方式工作). [#10126](https://github.com/ClickHouse/ClickHouse/pull/10126) ([Pavel Kovalenko](https://github.com/Jokser))

#### Bug 修复
* 修复了 `MATERIALIZED VIEW` 内部查询中不正确的标量结果, 以防该查询包含相关表. [#10603](https://github.com/ClickHouse/ClickHouse/pull/10603) ([Nikolai Kochetov](https://github.com/KochetovNicolai))
* 修复了当 `readonly=2` 和 `cancel_http_readonly_queries_on_client_close=1` 时导致 HTTP 请求卡在客户端关闭连接上的错误. [#10684](https://github.com/ClickHouse/ClickHouse/pull/10684) ([tavplubix](https://github.com/tavplubix))
* 在服务器启动时抛出异常时修复 StorageBuffer 中的段错误. 修复 [#10550](https://github.com/ClickHouse/ClickHouse/issues/10550) [#10609](https://github.com/ClickHouse/ClickHouse/pull/10609) ([tavplubix](https://github.com/tavplubix))
* 查询 `SYSTEM DROP DNS CACHE` 现在还删除用于检查是否允许用户从某些 IP 地址连接的缓存. [#10608](https://github.com/ClickHouse/ClickHouse/pull/10608) ([tavplubix](https://github.com/tavplubix))
* 修复在一个查询中使用多个具有相同集合的 `IN` 运算符. 修复 [#10539](https://github.com/ClickHouse/ClickHouse/issues/10539) [#10686](https://github.com/ClickHouse/ClickHouse/pull/10686) ([Anton Popov](https://github.com/CurtizJ))
* 使用嵌套类型修复 `generateRandom` 中的崩溃. 修复 [#10583](https://github.com/ClickHouse/ClickHouse/issues/10583). [#10734](https://github.com/ClickHouse/ClickHouse/pull/10734) ([Nikolai Kochetov](https://github.com/KochetovNicolai))
* 修复合并后可能发生的 `SummingMergeTree` 中 `LowCardinality(FixedString)` 键列的数据损坏. 修复 [#10489](https://github.com/ClickHouse/ClickHouse/issues/10489). [#10721](https://github.com/ClickHouse/ClickHouse/pull/10721) ([Nikolai Kochetov](https://github.com/KochetovNicolai))
* 修复 aggregation_memory_efficient_merge_threads 设置的逻辑. [#10667](https://github.com/ClickHouse/ClickHouse/pull/10667) ([palasonic1](https://github.com/palasonic1))
* 修复消失的总数. 如果查询具有 `JOIN` 或带有外部 `WHERE` 条件的子查询, 则总计可能被过滤。 修复[#10674](https://github.com/ClickHouse/ClickHouse/issues/10674) [#10698](https://github.com/ClickHouse/ClickHouse/pull/10698) ([Nikolai Kochetov](https://github.com/KochetovNicolai))
* 修复启用了 `distributed_aggregation_memory_efficient` 的远程查询缺乏并行执行的问题. 修复 [#10655](https://github.com/ClickHouse/ClickHouse/issues/10655) [#10664](https://github.com/ClickHouse/ClickHouse/pull/10664) ([Nikolai Kochetov](https://github.com/KochetovNicolai))
* 使用 `LIMIT` 修复查询的可能不正确的行数. 修复 [#10566](https://github.com/ClickHouse/ClickHouse/issues/10566), [#10709](https://github.com/ClickHouse/ClickHouse/issues/10709) [#10660](https://github.com/ClickHouse/ClickHouse/pull/10660) ([Nikolai Kochetov](https://github.com/KochetovNicolai))
* 修复索引损坏, 在某些情况下将合并部分合并到另一个合并部分后可能会发生这种情况. [#10531](https://github.com/ClickHouse/ClickHouse/pull/10531) ([Anton Popov](https://github.com/CurtizJ))
* 修复当mutation完成所有部分, 但在 `is_done=0` 中挂掉的情况. [#10526](https://github.com/ClickHouse/ClickHouse/pull/10526) ([alesapin](https://github.com/alesapin))
* 修复 unix 纪元开始时与 UTC 有小数偏移的时区的溢出. 修复 [#9335](https://github.com/ClickHouse/ClickHouse/issues/9335). [#10513](https://github.com/ClickHouse/ClickHouse/pull/10513) ([alexey-milovidov](https://github.com/alexey-milovidov))
* 更好的输入格式诊断. 修复 [#10204](https://github.com/ClickHouse/ClickHouse/issues/10204) [#10418](https://github.com/ClickHouse/ClickHouse/pull/10418) ([tavplubix](https://github.com/tavplubix))
* 修复 `simpleLinearRegression()` 中大整数上的数字溢出. [#10474](https://github.com/ClickHouse/ClickHouse/pull/10474) ([hcz](https://github.com/hczhcz))
* 修复分布式关闭中的use-after-free, 避免等待发送所有批次 [#10491](https://github.com/ClickHouse/ClickHouse/pull/10491) ([Azat Khuzhin](https://github.com/azat))
* 将 CA 证书添加到 clickhouse-server docker 镜像. [#10476](https://github.com/ClickHouse/ClickHouse/pull/10476) ([filimonov](https://github.com/filimonov))
* 修复使用 `addressToLine` 函数或 AggregateFunctionState 列时可能发生的罕见无限循环. [#10466](https://github.com/ClickHouse/ClickHouse/pull/10466) ([Alexander Kuzmenkov](https://github.com/akuzm))
* 在分布式查询期间处理zookeeper `no node error`. [#10050](https://github.com/ClickHouse/ClickHouse/pull/10050) ([Daniel Chen](https://github.com/Phantomape))
* 修复更改列的默认值后服务器无法附加表的错误. [#10441](https://github.com/ClickHouse/ClickHouse/pull/10441) ([alesapin](https://github.com/alesapin))
* 将默认表达式类型隐式转换为 ALIAS 列的列类型. [#10563](https://github.com/ClickHouse/ClickHouse/pull/10563) ([Azat Khuzhin](https://github.com/azat))
* 如果 `ATTACH DATABASE` 失败, 不要删除元数据目录. [#10442](https://github.com/ClickHouse/ClickHouse/pull/10442) ([Winter Zhang](https://github.com/zhang2014))
* 避免依赖系统 tzdata. 修复了在 CentOS 8 上加载 `Africa/Casablanca` 时区的问题. [#10211](https://github.com/ClickHouse/ClickHouse/issues/10211) [#10425](https://github.com/ClickHouse/ClickHouse/pull/10425) ([alexey-milovidov](https://github.com/alexey-milovidov))
* 如果数据以仲裁插入然后被删除 (DROP PARTITION、TTL 等), 则修复一些问题. 它导致在 SELECT 中卡住 INSERT 或误报异常. 修复 [#9946](https://github.com/ClickHouse/ClickHouse/issues/9946) [#10188](https://github.com/ClickHouse/ClickHouse/pull/10188) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov))
* 创建 BloomFilter 索引时检查参数的数量和类型 [#9623](https://github.com/ClickHouse/ClickHouse/issues/9623) [#10431](https://github.com/ClickHouse/ClickHouse/pull/10431) ([Winter Zhang](https://github.com/zhang2014))
* 更喜欢 `fallback_to_stale_replicas` 而不是 `skip_unavailable_shards` , 否则当两个设置都指定并且没有最新的副本时, 查询将失败 (来自@alex-zaitsev的补丁 ). [#10422](https://github.com/ClickHouse/ClickHouse/pull/10422) ([Azat Khuzhin](https://github.com/azat))
* 修复带有 ARRAY JOIN、ORDER BY 和 LIMIT 的查询可能返回不完整结果的问题. 修复 [#10226](https://github.com/ClickHouse/ClickHouse/issues/10226). [#10427](https://github.com/ClickHouse/ClickHouse/pull/10427) ([Vadim Plakhtinskiy](https://github.com/VadimPlh))
* 在 DETACH/ATTACH 之后将数据库名称添加到字典名称. 修复 system.dictionaries 表和 `SYSTEM RELOAD` 查询. [#10415](https://github.com/ClickHouse/ClickHouse/pull/10415) ([Azat Khuzhin](https://github.com/azat))
* 修复处理器管道中极端情况可能导致的错误结果. [#10131](https://github.com/ClickHouse/ClickHouse/pull/10131) ([Nikolai Kochetov](https://github.com/KochetovNicolai))
* 修复启用设置 `distributed_group_by_no_merge` 时可能出现的段错误 (在 20.3.7.46 中由 [#10131](https://github.com/ClickHouse/ClickHouse/issues/10131) 引入). [#10399](https://github.com/ClickHouse/ClickHouse/pull/10399) ([Nikolai Kochetov](https://github.com/KochetovNicolai))
* 修复 `Array(Tuple(...))` 数据类型的错误扁平化. 修复 [#10259](https://github.com/ClickHouse/ClickHouse/issues/10259) [#10390](https://github.com/ClickHouse/ClickHouse/pull/10390) ([alexey-milovidov](https://github.com/alexey-milovidov))
* 修复 JOIN 内的常量列名可能与 JOIN 外的常量名冲突. [#9950](https://github.com/ClickHouse/ClickHouse/pull/9950) ([Alexander Kuzmenkov](https://github.com/akuzm))
* 在 Block::sortColumns() 之后修复列的顺序. [#10826](https://github.com/ClickHouse/ClickHouse/pull/10826) ([Azat Khuzhin](https://github.com/azat))
* 修复 `ConcatProcessor` 中可能发生的 `Pipeline stuck` 错误，该错误可能在远程查询中发生. [#10381](https://github.com/ClickHouse/ClickHouse/pull/10381) ([Nikolai Kochetov](https://github.com/KochetovNicolai))
* 不要为聚合预留磁盘. 修复 [#9241](https://github.com/ClickHouse/ClickHouse/issues/9241) [#10375](https://github.com/ClickHouse/ClickHouse/pull/10375) ([Azat Khuzhin](https://github.com/azat))
* 修复了时区的日期时间函数的错误行为, 这些时区在 UTC 的正负偏移量之间发生了变化 (例如 Pacific/Kiritimati). 修复 [#7202](https://github.com/ClickHouse/ClickHouse/issues/7202) [#10369](https://github.com/ClickHouse/ClickHouse/pull/10369) ([alexey-milovidov](https://github.com/alexey-milovidov))
* 避免在 `dictIsIn` 函数中出现无限循环. 修复 #515. [#10365](https://github.com/ClickHouse/ClickHouse/pull/10365) ([alexey-milovidov](https://github.com/alexey-milovidov))
* 默认禁用 GROUP BY sharding_key 优化并修复 WITH ROLLUP/CUBE/TOTALS. [#10516](https://github.com/ClickHouse/ClickHouse/pull/10516) ([Azat Khuzhin](https://github.com/azat))
* 检查零件时检查错误代码, 如果错误类似于 `not enough memory`, 请不要将零件标记为损坏. 修复 [#6269](https://github.com/ClickHouse/ClickHouse/issues/6269) [#10364](https://github.com/ClickHouse/ClickHouse/pull/10364) ([alexey-milovidov](https://github.com/alexey-milovidov))
* 在系统表中显示有关未加载词典的信息. [#10234](https://github.com/ClickHouse/ClickHouse/pull/10234) ([Vitaly Baranov](https://github.com/vitlibar))
* 如果服务器在表启动前关闭, 则修复 StorageBuffer 中的 nullptr 取消引用. [#10641](https://github.com/ClickHouse/ClickHouse/pull/10641) ([alexey-milovidov](https://github.com/alexey-milovidov))
* 修复了 `ReplicatedMergeTree` 中的 `DROP` 与 `OPTIMIZE` 竞赛. 如果存在并发的 OPTIMIZE 查询, 则 DROP 可能会在 ZooKeeper 的副本路径中留下一些垃圾. [#10312](https://github.com/ClickHouse/ClickHouse/pull/10312) ([tavplubix](https://github.com/tavplubix))
* 修复 `Logical error: CROSS JOIN has expressions` 错误, 用于使用逗号和名称连接混合的查询. 修复 [#9910](https://github.com/ClickHouse/ClickHouse/issues/9910) [#10311](https://github.com/ClickHouse/ClickHouse/pull/10311) ([Artem Zuikov](https://github.com/4ertus2))
* 使用 `max_bytes_before_external_group_by` 修复查询. [#10302](https://github.com/ClickHouse/ClickHouse/pull/10302) ([Artem Zuikov](https://github.com/4ertus2))
* 修复在某些情况下限制解析器中最大递归深度的问题. 此修复 [#10283](https://github.com/ClickHouse/ClickHouse/issues/10283) 此修复可能会引入轻微的不兼容性: 通过 clickhouse-client 进行长时间和深度查询可能会拒绝工作, 您应该调整设置 `max_query_size ` 和 `max_parser_depth` 相应. [#10295](https://github.com/ClickHouse/ClickHouse/pull/10295) ([alexey-milovidov](https://github.com/alexey-milovidov))
* 允许对多个 JOIN 使用 `count(*)`. 修复 [#9853](https://github.com/ClickHouse/ClickHouse/issues/9853) [#10291](https://github.com/ClickHouse/ClickHouse/pull/10291) ([Artem Zuikov](https://github.com/4ertus2))
* 使用 `max_rows_to_group_by` 和 `group_by_overflow_mode = 'break'` 修复错误 `Pipeline stuck`. [#10279](https://github.com/ClickHouse/ClickHouse/pull/10279) ([Nikolai Kochetov](https://github.com/KochetovNicolai))
* 修复使用 DDL 查询创建 `range_hashed` 字典时出现的 `Cannot add column` 错误. 修复 [#10093](https://github.com/ClickHouse/ClickHouse/issues/10093). [#10235](https://github.com/ClickHouse/ClickHouse/pull/10235) ([alesapin](https://github.com/alesapin))
* 修复罕见的可能异常 `Cannot drain connections: cancel first`. [#10239](https://github.com/ClickHouse/ClickHouse/pull/10239) ([Nikolai Kochetov](https://github.com/KochetovNicolai))
* 修复了 ClickHouse 会抛出 `Unknown function lambda` 的错误. 当用户尝试在 ENGINE = Replicated* 的表上运行 ALTER UPDATE/DELETE 时出现错误消息. 检查非确定性函数现在可以正确处理 lambda 表达式. [#10237](https://github.com/ClickHouse/ClickHouse/pull/10237) ([Alexander Kazakov](https://github.com/Akazz))
* 修复了当 SELECT ... FROM system.tables 在具有惰性引擎的数据库上运行时发生的 StorageSystemTables 中相当罕见的段错误. [#10209](https://github.com/ClickHouse/ClickHouse/pull/10209) ([Alexander Kazakov](https://github.com/Akazz))
* 当查询实际上应该在 LIMIT 停止时, 修复可能的无限查询执行, 同时从无限源 (如 `system.numbers` 或 `system.zeros` )读取. [#10206](https://github.com/ClickHouse/ClickHouse/pull/10206) ([Nikolai Kochetov](https://github.com/KochetovNicolai))
* 修复了 Date 类型的 `generateRandom` 函数. 这修复了 [#9973](https://github.com/ClickHouse/ClickHouse/issues/9973). 修复了将 2106 年的日期插入到使用旧式分区的 MergeTree 表但分区以 1970 年命名的边缘情况. [#10218](https://github.com/ClickHouse/ClickHouse/pull/10218) ([alexey-milovidov](https://github.com/alexey-milovidov))
* 如果 View 的表定义与 SELECT 查询不对应, 则转换类型. 这修复了 [#10180](https://github.com/ClickHouse/ClickHouse/issues/10180) and [#10022](https://github.com/ClickHouse/ClickHouse/issues/10022) [#10217](https://github.com/ClickHouse/ClickHouse/pull/10217) ([alexey-milovidov](https://github.com/alexey-milovidov))
* 修复 RFC-2822 中字符串的 `parseDateTimeBestEffort`, 当一周中的某一天是星期二或星期四时. 这修复了 [#10082](https://github.com/ClickHouse/ClickHouse/issues/10082) [#10214](https://github.com/ClickHouse/ClickHouse/pull/10214) ([alexey-milovidov](https://github.com/alexey-milovidov))
* 修复 JOIN 内的常量列名可能与 JOIN 外的常量名冲突. [#10207](https://github.com/ClickHouse/ClickHouse/pull/10207) ([alexey-milovidov](https://github.com/alexey-milovidov))
* 在存在数组连接函数的情况下修复移动到前置位置优化 (在某些情况下). 这修复了[#10092](https://github.com/ClickHouse/ClickHouse/issues/10092) [#10195](https://github.com/ClickHouse/ClickHouse/pull/10195) ([alexey-milovidov](https://github.com/alexey-milovidov))
* 修复本机 mysql-connector-java (JDBC) 的 SCRAMBLE 中出现分隔符的问题. [#10140](https://github.com/ClickHouse/ClickHouse/pull/10140) ([BohuTANG](https://github.com/BohuTANG))
* 修复未指定数据库时使用当前数据库进行访问检查的问题. [#10192](https://github.com/ClickHouse/ClickHouse/pull/10192) ([Vitaly Baranov](https://github.com/vitlibar))
* 用合并部分修复表的 ALTER. [#10130](https://github.com/ClickHouse/ClickHouse/pull/10130) ([Anton Popov](https://github.com/CurtizJ))
* 添加了通过 `allow_nondeterministic_mutations` 设置放宽对突变中非确定性函数使用限制的能力. [#10186](https://github.com/ClickHouse/ClickHouse/pull/10186) ([filimonov](https://github.com/filimonov))
* 修复字典调用 `DROP TABLE` 的问题. [#10165](https://github.com/ClickHouse/ClickHouse/pull/10165) ([Azat Khuzhin](https://github.com/azat))
* 如果在将 `INSERT` 插入分布式表时结构不匹配, 则转换块. [#10135](https://github.com/ClickHouse/ClickHouse/pull/10135) ([Azat Khuzhin](https://github.com/azat))
* 当插入的块被带有分区键的部分分割时，记录的行数不正确 (作为所有部分的总和). [#10138](https://github.com/ClickHouse/ClickHouse/pull/10138) ([alexey-milovidov](https://github.com/alexey-milovidov))
* 为 MySQL 数据库引擎添加一些参数检查和支持标识符参数. [#10077](https://github.com/ClickHouse/ClickHouse/pull/10077) ([Winter Zhang](https://github.com/zhang2014))
* 在创建新副本时修复不正确的 `index_granularity_bytes` 检查. 修复 [#10098](https://github.com/ClickHouse/ClickHouse/issues/10098). [#10121](https://github.com/ClickHouse/ClickHouse/pull/10121) ([alesapin](https://github.com/alesapin))
* 当表包含跳过索引时, 修复 `CHECK TABLE` 查询中的错误. [#10068](https://github.com/ClickHouse/ClickHouse/pull/10068) ([alesapin](https://github.com/alesapin))
* 修复嵌套表中只有一个分片的 Distributed-over-Distributed 问题. [#9997](https://github.com/ClickHouse/ClickHouse/pull/9997) ([Azat Khuzhin](https://github.com/azat))
* 使用 `JOIN` 和 `UNION ALL` 修复查询可能丢失的行. 修复 [#9826](https://github.com/ClickHouse/ClickHouse/issues/9826), [#10113](https://github.com/ClickHouse/ClickHouse/issues/10113). ... [#10099](https://github.com/ClickHouse/ClickHouse/pull/10099) ([Nikolai Kochetov](https://github.com/KochetovNicolai))
* 修复使用本地 clickhouse 服务器作为源时字典中的错误. 如果字典和源中的类型不兼容, 可能会导致内存损坏. [#10071](https://github.com/ClickHouse/ClickHouse/pull/10071) ([alesapin](https://github.com/alesapin))
* 修复了从不存在 `/table/replicas/replica_name/metadata` 节点的旧 ClickHouse 版本更新时复制表启动的问题. 修复 [#10037](https://github.com/ClickHouse/ClickHouse/issues/10037). [#10095](https://github.com/ClickHouse/ClickHouse/pull/10095) ([alesapin](https://github.com/alesapin))
* 修复错误 `Cannot clone block with columns because block has 0 columns ... While executing GroupingAggregatedTransform` . 当设置 `distributed_aggregation_memory_efficient` 被启用, 并且分布式查询从不同分片读取混合单级和二级聚合的聚合数据时发生这种情况.  [#10063](https://github.com/ClickHouse/ClickHouse/pull/10063) ([Nikolai Kochetov](https://github.com/KochetovNicolai))
* 修复具有实体化视图的数据库在启动时附加失败时的死锁. [#10054](https://github.com/ClickHouse/ClickHouse/pull/10054) ([Azat Khuzhin](https://github.com/azat))
* 修复 GROUP BY 中可能发生的分段错误，该错误是包含尾随零字节的字符串键 ([#8636](https://github.com/ClickHouse/ClickHouse/issues/8636), [#8925](https://github.com/ClickHouse/ClickHouse/issues/8925)). ... [#10025](https://github.com/ClickHouse/ClickHouse/pull/10025) ([Alexander Kuzmenkov](https://github.com/akuzm))
* 当别名可以覆盖限定的列名时, 修复分布式查询的错误结果. 修复 [#9672](https://github.com/ClickHouse/ClickHouse/issues/9672) [#9714](https://github.com/ClickHouse/ClickHouse/issues/9714) [#9972](https://github.com/ClickHouse/ClickHouse/pull/9972) ([Artem Zuikov](https://github.com/4ertus2))
* 修复 `SYSTEM RESTART REPLICAS` 中可能出现的死锁. [#9955](https://github.com/ClickHouse/ClickHouse/pull/9955) ([tavplubix](https://github.com/tavplubix))
* 修复用于远程查询执行的线程数 (性能回归, 自 20.3 起). 当来自 `Distributed` 表的查询在本地和远程分片上同时执行时, 就会发生这种情况. 修复 [#9965](https://github.com/ClickHouse/ClickHouse/issues/9965) [#9971](https://github.com/ClickHouse/ClickHouse/pull/9971) ([Nikolai Kochetov](https://github.com/KochetovNicolai))
* 修复了 `ATTACH PART` 中的 `DeleteOnDestroy` 逻辑, 这可能导致自动删除附加部分并添加了一些测试. [#9410](https://github.com/ClickHouse/ClickHouse/pull/9410) ([Vladimir Chebotarev](https://github.com/excitoon))
* 修复 `ON CLUSTER` DDL 查询在服务器启动时冻结的错误. [#9927](https://github.com/ClickHouse/ClickHouse/pull/9927) ([Gagan Arneja](https://github.com/garneja))
* 修复了在某些数据库查询的处理阶段之一未检索到必要表的错误. 修复 [#9699](https://github.com/ClickHouse/ClickHouse/issues/9699). [#9949](https://github.com/ClickHouse/ClickHouse/pull/9949) ([achulkov2](https://github.com/achulkov2))
* 修复 `JOIN` 与 `TOTALS` 一起出现时 Not found column in block 错误. 修复 [#9839](https://github.com/ClickHouse/ClickHouse/issues/9839) [#9939](https://github.com/ClickHouse/ClickHouse/pull/9939) ([Artem Zuikov](https://github.com/4ertus2))
* 修复解析 CREATE USER 命令中设置的多个主机. [#9924](https://github.com/ClickHouse/ClickHouse/pull/9924) ([Vitaly Baranov](https://github.com/vitlibar))
* 修复连接表引擎的 `TRUNCATE`. ([#9917](https://github.com/ClickHouse/ClickHouse/issues/9917)). [#9920](https://github.com/ClickHouse/ClickHouse/pull/9920) ([Amos Bird](https://github.com/amosbird))
* 修复 `ReplicatedMergeTree` 中删除和优化之间的竞争条件. [#9901](https://github.com/ClickHouse/ClickHouse/pull/9901) ([alesapin](https://github.com/alesapin))
* 当设置了 `optimize_skip_unused_shards` 时, 修复分布式的 `DISTINCT`. [#9808](https://github.com/ClickHouse/ClickHouse/pull/9808) ([Azat Khuzhin](https://github.com/azat))
* 修复 ALTER 中的 `scalar does not exist` 错误 ([#9878](https://github.com/ClickHouse/ClickHouse/issues/9878)). ... [#9904](https://github.com/ClickHouse/ClickHouse/pull/9904) ([Amos Bird](https://github.com/amosbird))
* 修复 `distributed_product_mode=\'local\'` 中的限定名称错误. 修复 [#4756](https://github.com/ClickHouse/ClickHouse/issues/4756) [#9891](https://github.com/ClickHouse/ClickHouse/pull/9891) ([Artem Zuikov](https://github.com/4ertus2))
* 对于 INSERT 查询, 分片现在确实将启动器的设置限制到它们的约束, 而不是抛出异常. 此修复允许将 INSERT 查询发送到具有其他约束的分片. 此更改改进了修复 [#9447](https://github.com/ClickHouse/ClickHouse/issues/9447). [#9852](https://github.com/ClickHouse/ClickHouse/pull/9852) ([Vitaly Baranov](https://github.com/vitlibar))
* 在向 Kafka 代理提交偏移量时添加一些重试, 因为如果在 `offsets.commit.timeout.ms` 期间没有足够的副本可用于 `__consumer_offsets` 主题, 它可以拒绝提交. [#9884](https://github.com/ClickHouse/ClickHouse/pull/9884) ([filimonov](https://github.com/filimonov))
* 修复在 `WHERE` 中使用基础表的虚拟列时的分布式引擎行为. [#9847](https://github.com/ClickHouse/ClickHouse/pull/9847) ([Azat Khuzhin](https://github.com/azat))
* 修复了函数参数的时区使用不正确的一些情况. [#9574](https://github.com/ClickHouse/ClickHouse/pull/9574) ([Vasily Nemkov](https://github.com/Enmk))
* 当查询在分布式表上具有 PREWHERE 和 WHERE 并且 `SET分布式产品模式 = 'local'` 时, 修复 `Different expressions with the same alias` 错误. [#9871](https://github.com/ClickHouse/ClickHouse/pull/9871) ([Artem Zuikov](https://github.com/4ertus2))
* 修复具有复合主键的表的突变过多的内存消耗. 这修复了 [#9850](https://github.com/ClickHouse/ClickHouse/issues/9850). [#9860](https://github.com/ClickHouse/ClickHouse/pull/9860) ([alesapin](https://github.com/alesapin))
* 修复了从设置 `allow_introspection_functions` 计算内省函数的授权. [#9840](https://github.com/ClickHouse/ClickHouse/pull/9840) ([Vitaly Baranov](https://github.com/vitlibar))
* 修复 max_distributed_connections (带和不带处理器) [#9673](https://github.com/ClickHouse/ClickHouse/pull/9673) ([Azat Khuzhin](https://github.com/azat))
* 修复客户端上可能出现的异常 `Got 0 in totals chunk, expected 1` . 如果右连接表有零行, 则使用 `JOIN` 进行查询时会发生这种情况. 示例: `select * from system.one t1 join system.one t2 on t1.dummy = t2.dummy limit 0 FORMAT TabSeparated;`. 修复 [#9777](https://github.com/ClickHouse/ClickHouse/issues/9777). ... [#9823](https://github.com/ClickHouse/ClickHouse/pull/9823) ([Nikolai Kochetov](https://github.com/KochetovNicolai))
* 修复 `COMMA to CROSS JOIN rewriter is not enabled or cannot rewrite query` 错误, 以防在表列表中使用 COMMA JOIN 进行子查询 (即在 WHERE 中). 修复 [#9782](https://github.com/ClickHouse/ClickHouse/issues/9782) [#9830](https://github.com/ClickHouse/ClickHouse/pull/9830) ([Artem Zuikov](https://github.com/4ertus2))
* 修复了设置 `optimize_skip_unused_shards` 时服务器崩溃并且键的表达式无法转换为其字段类型的问题. [#9804](https://github.com/ClickHouse/ClickHouse/pull/9804) ([Azat Khuzhin](https://github.com/azat))
* 修复 `splitByString` 中的空字符串处理. [#9767](https://github.com/ClickHouse/ClickHouse/pull/9767) ([hcz](https://github.com/hczhcz))
* 修复损坏的 `ALTER TABLE DELETE COLUMN` 查询合并部分. [#9779](https://github.com/ClickHouse/ClickHouse/pull/9779) ([alesapin](https://github.com/alesapin))
* 修复了通过 http (使用处理器管道) 查询时缺少的 `rows_before_limit_at_least`. 修复 [#9730](https://github.com/ClickHouse/ClickHouse/issues/9730) [#9757](https://github.com/ClickHouse/ClickHouse/pull/9757) ([Nikolai Kochetov](https://github.com/KochetovNicolai))
* 修复 `ALTER` 查询 (突变) 中的过多内存消耗. 这修复了 [#9533](https://github.com/ClickHouse/ClickHouse/issues/9533) and [#9670](https://github.com/ClickHouse/ClickHouse/issues/9670). [#9754](https://github.com/ClickHouse/ClickHouse/pull/9754) ([alesapin](https://github.com/alesapin))
* 修复可能的永久性 `Cannot schedule a task` 错误. [#9154](https://github.com/ClickHouse/ClickHouse/pull/9154) ([Azat Khuzhin](https://github.com/azat))
* 修复外部字典 DDL 中反引号的错误. 修复 [#9619](https://github.com/ClickHouse/ClickHouse/issues/9619). [#9734](https://github.com/ClickHouse/ClickHouse/pull/9734) ([alesapin](https://github.com/alesapin))
* 修复了 `text_log` 中的数据竞争. 它不对应任何真正的错误. [#9726](https://github.com/ClickHouse/ClickHouse/pull/9726) ([alexey-milovidov](https://github.com/alexey-milovidov))
* 修复复制中的错误, 如果用户在以前的版本上执行了更改, 则不允许复制工作. 这修复了 [#9645](https://github.com/ClickHouse/ClickHouse/issues/9645). [#9652](https://github.com/ClickHouse/ClickHouse/pull/9652) ([alesapin](https://github.com/alesapin))
* 修复了 `sumKahan` 和 `sumWithOverflow` 不正确的内部函数名称. 在远程查询中使用此函数时导致异常. [#9636](https://github.com/ClickHouse/ClickHouse/pull/9636) ([Azat Khuzhin](https://github.com/azat))
* 添加设置 `use_compact_format_in_distributed_parts_names`, 它允许将`INSERT` 查询的文件以更紧凑的格式写入 `Distributed` 表. 这修复了 [#9647](https://github.com/ClickHouse/ClickHouse/issues/9647). [#9653](https://github.com/ClickHouse/ClickHouse/pull/9653) ([alesapin](https://github.com/alesapin))
* 在 JOIN 键中使用低基数修复 RIGHT 和 FULL JOIN. [#9610](https://github.com/ClickHouse/ClickHouse/pull/9610) ([Artem Zuikov](https://github.com/4ertus2))
* 修复 `MergeTreeRangeReader` 中可能出现的异常 `Size of filter does not match size of column` and `Invalid number of rows in Chunk` 和 `Invalid number of rows in Chunk`. 在某些情况下, 它们可能会在执行 `PREWHERE` 时出现. [#9612](https://github.com/ClickHouse/ClickHouse/pull/9612) ([Anton Popov](https://github.com/CurtizJ))
* 允许具有内部复制的分布式表的 `ALTER ON CLUSTER`. 这修复了 [#3268](https://github.com/ClickHouse/ClickHouse/issues/3268) [#9617](https://github.com/ClickHouse/ClickHouse/pull/9617) ([shinoi2](https://github.com/shinoi2))
* 如果您编写像 `time + 1` 这样的简单算术表达式 (与像 `time + INTERVAL 1 SECOND` 这样的表达式相反), 则修复了未保留时区的问题. 这修复了 [#5743](https://github.com/ClickHouse/ClickHouse/issues/5743) [#9323](https://github.com/ClickHouse/ClickHouse/pull/9323) ([alexey-milovidov](https://github.com/alexey-milovidov))

#### 改进
* 将 DateTime 与字符串文字进行比较时使用时区. 这修复了 [#5206](https://github.com/ClickHouse/ClickHouse/issues/5206). [#10515](https://github.com/ClickHouse/ClickHouse/pull/10515) ([alexey-milovidov](https://github.com/alexey-milovidov))
* 如果无法从文本输入格式解析 Decimal 值, 则打印详细的诊断信息. [#10205](https://github.com/ClickHouse/ClickHouse/pull/10205) ([alexey-milovidov](https://github.com/alexey-milovidov))
* 为分布式/缓冲调度池添加任务/内存指标. [#10449](https://github.com/ClickHouse/ClickHouse/pull/10449) ([Azat Khuzhin](https://github.com/azat))
* 一旦准备好在 clickhouse-local 和 HTTP 接口中进行 SELECT DISTINCT 查询, 就立即显示结果. 这修复了 [#8951](https://github.com/ClickHouse/ClickHouse/issues/8951) [#9559](https://github.com/ClickHouse/ClickHouse/pull/9559) ([alexey-milovidov](https://github.com/alexey-milovidov))
* 允许使用 `SAMPLE OFFSET` 查询代替 `cityHash64(PRIMARY KEY) % N == n` 在 `clickhouse-copier` 中进行拆分. 要使用此功能, 请将 `--experimental-use-sample-offset 1` 作为命令行参数传递. [#10414](https://github.com/ClickHouse/ClickHouse/pull/10414) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov))
* 如果第一列的值中不能包含 BOM, 则允许在 TSV 中解析 BOM. 这修复了 [#10301](https://github.com/ClickHouse/ClickHouse/issues/10301) [#10424](https://github.com/ClickHouse/ClickHouse/pull/10424) ([alexey-milovidov](https://github.com/alexey-milovidov))
* 添加 Avro 嵌套字段插入支持. [#10354](https://github.com/ClickHouse/ClickHouse/pull/10354) ([Andrew Onyshchuk](https://github.com/oandrew))
* 指定相同类型时, 允许在非修改数据模式下更改列. [#10382](https://github.com/ClickHouse/ClickHouse/pull/10382) ([Vladimir Chebotarev](https://github.com/excitoon))
* 在 GROUP BY 分片键上自动 `distributed_group_by_no_merge` (如果设置了 `optimize_skip_unused_shards`). [#10341](https://github.com/ClickHouse/ClickHouse/pull/10341) ([Azat Khuzhin](https://github.com/azat))
* 使用 LIMIT/LIMIT BY/ORDER BY 优化查询以使用 GROUP BY sharding_key 进行分布式. [#10373](https://github.com/ClickHouse/ClickHouse/pull/10373) ([Azat Khuzhin](https://github.com/azat))
* 添加了设置 `max_server_memory_usage` 以限制服务器的总内存使用量. 现在计算指标 `MemoryTracking` 没有漂移. 设置 `max_memory_usage_for_all_queries` 现在已经过时并且什么都不做. 这将关闭 [#10293](https://github.com/ClickHouse/ClickHouse/issues/10293). [#10362](https://github.com/ClickHouse/ClickHouse/pull/10362) ([alexey-milovidov](https://github.com/alexey-milovidov))
* 添加配置选项 `system_tables_lazy_load`. 如果设置为 false, 则在服务器启动时加载带有日志的系统表. [Alexander Burmak](https://github.com/Alex-Burmak), [Svyatoslav Tkhon Il Pak](https://github.com/DeifyTheGod), [#9642](https://github.com/ClickHouse/ClickHouse/pull/9642) [#10359](https://github.com/ClickHouse/ClickHouse/pull/10359) ([alexey-milovidov](https://github.com/alexey-milovidov))
* 使用后台线程池 (background_schedule_pool_size) 进行分布式发送. [#10263](https://github.com/ClickHouse/ClickHouse/pull/10263) ([Azat Khuzhin](https://github.com/azat))
* 使用后台线程池进行后台缓冲区刷新. [#10315](https://github.com/ClickHouse/ClickHouse/pull/10315) ([Azat Khuzhin](https://github.com/azat))
* 支持删除不完整写入部分的一种特殊情况. 这修复了[#9940](https://github.com/ClickHouse/ClickHouse/issues/9940). [#10221](https://github.com/ClickHouse/ClickHouse/pull/10221) ([alexey-milovidov](https://github.com/alexey-milovidov))
* 使用 isInjective() 在此类函数的手动列表上进行 GROUP BY 优化. [#10342](https://github.com/ClickHouse/ClickHouse/pull/10342) ([Azat Khuzhin](https://github.com/azat))
* 如果客户端在连接时立即发送 RST 数据包, 请避免在日志中打印错误消息. 这是具有 keepalived 和 VRRP 的 IPVS 平衡器的典型行为. 这修复了 [#1851](https://github.com/ClickHouse/ClickHouse/issues/1851) [#10274](https://github.com/ClickHouse/ClickHouse/pull/10274) ([alexey-milovidov](https://github.com/alexey-milovidov))
* 允许为浮点类型解析 `+inf`. 这将关闭 [#1839](https://github.com/ClickHouse/ClickHouse/issues/1839) [#10272](https://github.com/ClickHouse/ClickHouse/pull/10272) ([alexey-milovidov](https://github.com/alexey-milovidov))
* 为嵌套类型实现了 `generateRandom` 表函数. 这将关闭 [#9903](https://github.com/ClickHouse/ClickHouse/issues/9903) [#10219](https://github.com/ClickHouse/ClickHouse/pull/10219) ([alexey-milovidov](https://github.com/alexey-milovidov))
* 在 MySQL 兼容接口中提供 `max_allowed_packed` 将帮助一些客户端通过 MySQL 协议与 ClickHouse 通信. [#10199](https://github.com/ClickHouse/ClickHouse/pull/10199) ([BohuTANG](https://github.com/BohuTANG))
* 允许 GLOBAL IN 的文字 (即`SELECT * FROM remote('localhost', system.one) WHERE dummy global in (0)`). [#10196](https://github.com/ClickHouse/ClickHouse/pull/10196) ([Azat Khuzhin](https://github.com/azat))
* 修复 clickhouse-client 交互模式下的各种小问题. [#10194](https://github.com/ClickHouse/ClickHouse/pull/10194) ([alexey-milovidov](https://github.com/alexey-milovidov))
* 避免多余的字典加载 (system.tables, DROP/SHOW CREATE TABLE). [#10164](https://github.com/ClickHouse/ClickHouse/pull/10164) ([Azat Khuzhin](https://github.com/azat))
* 更新到 RWLock：getLock() + 实现的超时参数重新设计为阶段公平. [#10073](https://github.com/ClickHouse/ClickHouse/pull/10073) ([Alexander Kazakov](https://github.com/Akazz))
* 增强与本机 mysql-connector-java(JDBC) 的兼容性. [#10021](https://github.com/ClickHouse/ClickHouse/pull/10021) ([BohuTANG](https://github.com/BohuTANG))
* `toString` 函数被认为是单调的, 即使在使用 String 或 LowCardinality(String) 参数的重言式情况下也可以用于索引分析. [#10110](https://github.com/ClickHouse/ClickHouse/pull/10110) ([Amos Bird](https://github.com/amosbird))
* 向命令 `{CREATE|DROP} USER/ROLE/ROW POLICY/SETTINGS PROFILE/QUOTA`、`GRANT` 添加 `ON CLUSTER` 子句支持. [#9811](https://github.com/ClickHouse/ClickHouse/pull/9811) ([Vitaly Baranov](https://github.com/vitlibar))
* 对 S3 URI 的虚拟托管式支持. [#9998](https://github.com/ClickHouse/ClickHouse/pull/9998) ([Pavel Kovalenko](https://github.com/Jokser))
* 现在可以在字典 DDL 查询中不用圆括号指定没有参数的字典的布局类型. 修复 [#10057](https://github.com/ClickHouse/ClickHouse/issues/10057). [#10064](https://github.com/ClickHouse/ClickHouse/pull/10064) ([alesapin](https://github.com/alesapin))
* 添加在文件路径中使用带前导零的数字范围的功能. [#9989](https://github.com/ClickHouse/ClickHouse/pull/9989) ([Olga Khvostikova](https://github.com/stavrolia))
* CROSS JOIN 中更好的内存使用. [#10029](https://github.com/ClickHouse/ClickHouse/pull/10029) ([Artem Zuikov](https://github.com/4ertus2))
* 获取远程表的结构并设置 skip_unavailable_shards 时尝试连接到集群中的所有分片. [#7278](https://github.com/ClickHouse/ClickHouse/pull/7278) ([nvartolomei](https://github.com/nvartolomei))
* 将 `total_rows`/`total_bytes` 添加到 `system.tables` 表中. [#9919](https://github.com/ClickHouse/ClickHouse/pull/9919) ([Azat Khuzhin](https://github.com/azat))
* 系统日志表现在默认使用多态部分. [#9905](https://github.com/ClickHouse/ClickHouse/pull/9905) ([Anton Popov](https://github.com/CurtizJ))
* 将类型列添加到 system.settings/merge_tree_settings. [#9909](https://github.com/ClickHouse/ClickHouse/pull/9909) ([Azat Khuzhin](https://github.com/azat))
* 尽早在服务器启动时检查可用的 CPU 指令. [#9888](https://github.com/ClickHouse/ClickHouse/pull/9888) ([alexey-milovidov](https://github.com/alexey-milovidov))
* 从突变中移除 `ORDER BY` 阶段, 因为我们从单个线程中的单个有序部分读取. 还添加检查突变中的行是否按排序键排序并且不违反此顺序. [#9886](https://github.com/ClickHouse/ClickHouse/pull/9886) ([alesapin](https://github.com/alesapin))
* 在左侧为 FixedString 实现运算符 LIKE. 这是更好地支持 TPC-DS 查询所必需的. [#9890](https://github.com/ClickHouse/ClickHouse/pull/9890) ([alexey-milovidov](https://github.com/alexey-milovidov))
* 添加 `force_optimize_skip_unused_shards_no_nested` 将禁用嵌套分布式表的 `force_optimize_skip_unused_shards`. [#9812](https://github.com/ClickHouse/ClickHouse/pull/9812) ([Azat Khuzhin](https://github.com/azat))
* 现在, 对于 MergeTree 数据部分, 列大小只计算一次. [#9827](https://github.com/ClickHouse/ClickHouse/pull/9827) ([alesapin](https://github.com/alesapin))
* 评估`optimize_skip_unused_shards` 的常量表达式 (即`SELECT * FROM foo_dist WHERE key=xxHash32(0)`).[#8846](https://github.com/ClickHouse/ClickHouse/pull/8846) ([Azat Khuzhin](https://github.com/azat))
* 删除了从 TTL 表达式中检查使用 `Date` 或 `DateTime` 列的方法. [#9967](https://github.com/ClickHouse/ClickHouse/pull/9967) ([Vladimir Chebotarev](https://github.com/excitoon))
* DiskS3硬链接优化实现. [#9760](https://github.com/ClickHouse/ClickHouse/pull/9760) ([Pavel Kovalenko](https://github.com/Jokser))
* 如果 `set multiple_joins_rewriter_version = 2` 启用多个 JOIN 重写的第二个版本, 以保持列名不冲突. 它支持多个带有 `USING` 的JOIN, 并允许 `select *` 用于带有子查询的JOIN. [#9739](https://github.com/ClickHouse/ClickHouse/pull/9739) ([Artem Zuikov](https://github.com/4ertus2))
* StorageMergeTree 的 `non-blocking` 更改的实现. [#9606](https://github.com/ClickHouse/ClickHouse/pull/9606) ([alesapin](https://github.com/alesapin))
* 添加 MergeTree 对 DiskS3 的全面支持. [#9646](https://github.com/ClickHouse/ClickHouse/pull/9646) ([Pavel Kovalenko](https://github.com/Jokser))
* 扩展 `splitByString` 以支持空字符串作为分隔符. [#9742](https://github.com/ClickHouse/ClickHouse/pull/9742) ([hcz](https://github.com/hczhcz))
* 将 `timestamp_ns` 列添加到 `system.trace_log` . 它包含跟踪事件的高清时间戳, 并允许构建线程配置文件的时间线 ("火焰图"). [#9696](https://github.com/ClickHouse/ClickHouse/pull/9696) ([Alexander Kuzmenkov](https://github.com/akuzm))
* 启用设置 `send_logs_level` 时, 避免日志消息和查询进度混淆. [#9634](https://github.com/ClickHouse/ClickHouse/pull/9634) ([Azat Khuzhin](https://github.com/azat))
* 添加了对`MATERIALIZE TTL IN PARTITION`的支持. [#9581](https://github.com/ClickHouse/ClickHouse/pull/9581) ([Vladimir Chebotarev](https://github.com/excitoon))
* 支持 Avro 嵌套字段内的复杂类型. [#10502](https://github.com/ClickHouse/ClickHouse/pull/10502) ([Andrew Onyshchuk](https://github.com/oandrew))

#### 性能改进
* 为 Partial MergeJoin 的右表提供更好的插入逻辑. [#10467](https://github.com/ClickHouse/ClickHouse/pull/10467) ([Artem Zuikov](https://github.com/4ertus2))
* 改进了面向行的格式的性能 (CSV 超过 10%，Avro 超过 35%, 在窄表的情况下). [#10503](https://github.com/ClickHouse/ClickHouse/pull/10503) ([Andrew Onyshchuk](https://github.com/oandrew))
* 使用 IN 运算符右侧显式定义的集合和左侧的元组提高查询的性能. [#10385](https://github.com/ClickHouse/ClickHouse/pull/10385) ([Anton Popov](https://github.com/CurtizJ))
* 在 HashJoin 中为哈希表使用更少的内存. [#10416](https://github.com/ClickHouse/ClickHouse/pull/10416) ([Artem Zuikov](https://github.com/4ertus2))
* StorageDictionary 上的特殊 HashJoin. 允许使用 JOIN 重写 `dictGet()` 函数. 它本身并不是向后不兼容的, 但可能会在某些安装中发现 [#8400](https://github.com/ClickHouse/ClickHouse/issues/8400). [#10133](https://github.com/ClickHouse/ClickHouse/pull/10133) ([Artem Zuikov](https://github.com/4ertus2))
* 当目标表支持时启用物化视图的并行插入. [#10052](https://github.com/ClickHouse/ClickHouse/pull/10052) ([vxider](https://github.com/Vxider))
* 使用单调函数改进指数分析的性能. [#9607](https://github.com/ClickHouse/ClickHouse/pull/9607)[#10026](https://github.com/ClickHouse/ClickHouse/pull/10026) ([Anton Popov](https://github.com/CurtizJ))
* 使用 SSE2 或 SSE4.2 SIMD 内在函数来加速布隆过滤器中的标记化. [#9968](https://github.com/ClickHouse/ClickHouse/pull/9968) ([Vasily Nemkov](https://github.com/Enmk))
* 在 `IN` 运算符的右侧使用显式定义的集合提高查询的性能. 这修复了 20.3 版中的性能回归. [#9740](https://github.com/ClickHouse/ClickHouse/pull/9740) ([Anton Popov](https://github.com/CurtizJ))
* 现在, clickhouse-copier 将每个分区分成几部分并独立复制. [#9075](https://github.com/ClickHouse/ClickHouse/pull/9075) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov))
* 添加更多聚合方法. 例如，TPC-H 查询 1 现在将选择 `FixedHashMap<UInt16, AggregateDataPtr>` 并获得 25% 的性能提升 [#9829](https://github.com/ClickHouse/ClickHouse/pull/9829) ([Amos Bird](https://github.com/amosbird))
* 在预限制转换中对多个流使用单行计数器. 这有助于避免在带有 `limit` 但没有 `order by` 的查询中联合管道流 (如 `select f(x) from (select x from t limit 1000000000)`) 并使用多个线程进行进一步处理. [#9602](https://github.com/ClickHouse/ClickHouse/pull/9602) ([Nikolai Kochetov](https://github.com/KochetovNicolai))

#### 构建/测试/打包改进
* 使用来自 ClickHouse-Extras 的 AWS SDK 库的分支. [#10527](https://github.com/ClickHouse/ClickHouse/pull/10527) ([Pavel Kovalenko](https://github.com/Jokser))
* 为新的 ALTER RENAME COLUMN 查询添加集成测试. [#10654](https://github.com/ClickHouse/ClickHouse/pull/10654) ([vzakaznikov](https://github.com/vzakaznikov))
* 在使用错误参数调用函数 `now64` 时修复可能的有符号整数溢出. 这修复了 [#8973](https://github.com/ClickHouse/ClickHouse/issues/8973) [#10511](https://github.com/ClickHouse/ClickHouse/pull/10511) ([alexey-milovidov](https://github.com/alexey-milovidov))
* 拆分 fuzzer 和 sanitizer 配置, 使构建配置与 Oss-fuzz 兼容. [#10494](https://github.com/ClickHouse/ClickHouse/pull/10494) ([kyprizel](https://github.com/kyprizel))
* 修复了 clang-10 上的 clang-tidy. [#10420](https://github.com/ClickHouse/ClickHouse/pull/10420) ([alexey-milovidov](https://github.com/alexey-milovidov))
* 在错误消息中显示绝对路径. 否则 KDevelop 无法导航到正确的文件, 而是打开一个新文件. [#10434](https://github.com/ClickHouse/ClickHouse/pull/10434) ([alexey-milovidov](https://github.com/alexey-milovidov))
* 添加了 `ASAN_OPTIONS` 环境变量以使用 Address sanitizer 调查 CI 压力测试中的错误. [#10440](https://github.com/ClickHouse/ClickHouse/pull/10440) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov))
* 为 clang 构建启用 ThinLTO (实验性). [#10435](https://github.com/ClickHouse/ClickHouse/pull/10435) ([alexey-milovidov](https://github.com/alexey-milovidov))
* 删除系统安装 Z3 求解器时可能引入的对 Z3 的意外依赖. [#10426](https://github.com/ClickHouse/ClickHouse/pull/10426) ([alexey-milovidov](https://github.com/alexey-milovidov))
* 将集成测试 docker 文件移动到 docker/ 目录. [#10335](https://github.com/ClickHouse/ClickHouse/pull/10335) ([Ilya Yatsishin](https://github.com/qoega))
* 允许在 CI 中使用 `clang-10`. 它确保 [#10238](https://github.com/ClickHouse/ClickHouse/issues/10238) 是已修复的. [#10384](https://github.com/ClickHouse/ClickHouse/pull/10384) ([alexey-milovidov](https://github.com/alexey-milovidov))
* 将 OpenSSL 更新为上游主服务器. 修复了 TLS 连接可能失败并显示消息 `OpenSSL SSL_read: error:14094438:SSLroutines:ssl3_read_bytes:tlsv1 alert internal error` 和 `SSL Exception: error:2400006E:random number generator::error retrieving entropy` 时的问题. 该问题存在于 20.1 版中. [#8956](https://github.com/ClickHouse/ClickHouse/pull/8956) ([alexey-milovidov](https://github.com/alexey-milovidov))
* 修复 clang-10 构建. [#10238](https://github.com/ClickHouse/ClickHouse/issues/10238) [#10370](https://github.com/ClickHouse/ClickHouse/pull/10370) ([Amos Bird](https://github.com/amosbird))
* 为[Parallel INSERT for materialized view] (https://github.com/ClickHouse/ClickHouse/pull/10052)添加性能测试. [#10345](https://github.com/ClickHouse/ClickHouse/pull/10345) ([vxider](https://github.com/Vxider))
* 修复片状测试 `test_settings_constraints_distributed.test_insert_clamps_settings`. [#10346](https://github.com/ClickHouse/ClickHouse/pull/10346) ([Vitaly Baranov](https://github.com/vitlibar))
* 添加 util 以在 CI ClickHouse 中上传测试结果. [#10330](https://github.com/ClickHouse/ClickHouse/pull/10330) ([Ilya Yatsishin](https://github.com/qoega))
* 在 junit_to_html 工具中将测试结果转换为 JSONEachRow 格式. [#10323](https://github.com/ClickHouse/ClickHouse/pull/10323) ([Ilya Yatsishin](https://github.com/qoega))
* 更新 cctz. [#10215](https://github.com/ClickHouse/ClickHouse/pull/10215) ([alexey-milovidov](https://github.com/alexey-milovidov))
* 允许从最纯粹的 JUnit XML 报告创建 HTML 报告. [#10247](https://github.com/ClickHouse/ClickHouse/pull/10247) ([Ilya Yatsishin](https://github.com/qoega))
* 更新对最小编译器版本的检查. 修复问题的根本原因 [#10250](https://github.com/ClickHouse/ClickHouse/issues/10250) [#10256](https://github.com/ClickHouse/ClickHouse/pull/10256) ([alexey-milovidov](https://github.com/alexey-milovidov))
* 对分布式实时视图表的初始支持. [#10179](https://github.com/ClickHouse/ClickHouse/pull/10179) ([vzakaznikov](https://github.com/vzakaznikov))
* 在 MergeTreeIndexFullText 中修复 (false) MSan 报告. 该问题首先出现在 [#9968](https://github.com/ClickHouse/ClickHouse/issues/9968). [#10801](https://github.com/ClickHouse/ClickHouse/pull/10801) ([alexey-milovidov](https://github.com/alexey-milovidov))
* clickhouse-docker-util. [#10151](https://github.com/ClickHouse/ClickHouse/pull/10151) ([filimonov](https://github.com/filimonov))
* 将 pdqsort 更新到最新版本. [#10171](https://github.com/ClickHouse/ClickHouse/pull/10171) ([Ivan](https://github.com/abyss7))
* 将 libdivide 更新至 v3.0. [#10169](https://github.com/ClickHouse/ClickHouse/pull/10169) ([Ivan](https://github.com/abyss7))
* 使用启用的多态部分添加检查. [#10086](https://github.com/ClickHouse/ClickHouse/pull/10086) ([Anton Popov](https://github.com/CurtizJ))
* 为 FreeBSD 添加交叉编译构建. 这修复了 [#9465](https://github.com/ClickHouse/ClickHouse/issues/9465) [#9643](https://github.com/ClickHouse/ClickHouse/pull/9643) ([Ivan](https://github.com/abyss7))
* 添加性能测试. [#6924](https://github.com/ClickHouse/ClickHouse/issues/6924) [#6980](https://github.com/ClickHouse/ClickHouse/pull/6980) ([filimonov](https://github.com/filimonov))
* 在 `File` 引擎中添加对 `/dev/null` 的支持以进行更好的性能测试. [#8455](https://github.com/ClickHouse/ClickHouse/pull/8455) ([Amos Bird](https://github.com/amosbird))
* 将 /dbms 中的所有文件夹向上移动一级. [#9974](https://github.com/ClickHouse/ClickHouse/pull/9974) ([Ivan](https://github.com/abyss7))
* 添加一个测试, 检查从 MergeTree 中读取的单线程是否按顺序执行. 添加到 [#9670](https://github.com/ClickHouse/ClickHouse/issues/9670) [#9762](https://github.com/ClickHouse/ClickHouse/pull/9762) ([alexey-milovidov](https://github.com/alexey-milovidov))
* 修复 `00964_live_view_watch_events_heartbeat.py` 测试以避免竞争条件. [#9944](https://github.com/ClickHouse/ClickHouse/pull/9944) ([vzakaznikov](https://github.com/vzakaznikov))
* 修复集成测试 `test_settings_constraints`. [#9962](https://github.com/ClickHouse/ClickHouse/pull/9962) ([Vitaly Baranov](https://github.com/vitlibar))
* 每个函数都在自己的文件中, 第 12 部分. [#9922](https://github.com/ClickHouse/ClickHouse/pull/9922) ([alexey-milovidov](https://github.com/alexey-milovidov))
* 增加了对元组数组分析速度极慢的情况的性能测试. [#9872](https://github.com/ClickHouse/ClickHouse/pull/9872) ([alexey-milovidov](https://github.com/alexey-milovidov))
* 将 zstd 更新到 1.4.4. 它在性能和压缩比方面有一些小的改进. 如果您使用不同版本的 ClickHouse 运行副本, 您可能会看到合理的错误消息 `Data after merge is not byte-identical to data on another replicas.` 并附有说明. 这些消息没问题, 您不必担心. [#10663](https://github.com/ClickHouse/ClickHouse/pull/10663) ([alexey-milovidov](https://github.com/alexey-milovidov))
* 修复 `system.stack_trace` 中的 TSan 报告. [#9832](https://github.com/ClickHouse/ClickHouse/pull/9832) ([alexey-milovidov](https://github.com/alexey-milovidov))
* 删除了对 `clock_getres` 的依赖. [#9833](https://github.com/ClickHouse/ClickHouse/pull/9833) ([alexey-milovidov](https://github.com/alexey-milovidov))
* 添加了使用 clang-tidy 的标识符名称检查. [#9799](https://github.com/ClickHouse/ClickHouse/pull/9799) ([alexey-milovidov](https://github.com/alexey-milovidov))
* 更新 `builder` docker 镜像. 此镜像未在 CI 中使用, 但对开发人员有用. [#9809](https://github.com/ClickHouse/ClickHouse/pull/9809) ([alexey-milovidov](https://github.com/alexey-milovidov))
* 删除 CI 中不再使用的旧的 `performance-test` 工具. `clickhouse-performance-test` 很棒, 但现在我们正在使用更高级的工具, 该工具通过复杂的统计公式进行比较测试, 无论环境如何变化, 都能获得可靠的结果. [#9796](https://github.com/ClickHouse/ClickHouse/pull/9796) ([alexey-milovidov](https://github.com/alexey-milovidov))
* 添加了大部分 clang-static-analyzer 检查. [#9765](https://github.com/ClickHouse/ClickHouse/pull/9765) ([alexey-milovidov](https://github.com/alexey-milovidov))
* 将 Poco 更新到 1.9.3, 为 MongoDB URI 支持做准备. [#6892](https://github.com/ClickHouse/ClickHouse/pull/6892) ([Alexander Kuzmenkov](https://github.com/akuzm))
* 使用 `-DUSE_STATIC_LIBRARIES=0 -DENABLE_JEMALLOC=0` 修复构建. [#9651](https://github.com/ClickHouse/ClickHouse/pull/9651) ([Artem Zuikov](https://github.com/4ertus2))
* 对于变更日志脚本, 如果合并提交被挑选到发布分支, 则从提交描述中获取 PR 名称. [#9708](https://github.com/ClickHouse/ClickHouse/pull/9708) ([Nikolai Kochetov](https://github.com/KochetovNicolai))
* 在 backport 脚本中支持 `vX.X-conflicts` 标签. [#9705](https://github.com/ClickHouse/ClickHouse/pull/9705) ([Nikolai Kochetov](https://github.com/KochetovNicolai))
* 修复用于向后移植脚本的 `auto-label` . [#9685](https://github.com/ClickHouse/ClickHouse/pull/9685) ([Nikolai Kochetov](https://github.com/KochetovNicolai))
* 在 Darwin 交叉构建中使用 libc++ 使其与原生构建一致. [#9665](https://github.com/ClickHouse/ClickHouse/pull/9665) ([Hui Wang](https://github.com/huiwang))
* 修复不稳定的测试 `01017_uniqCombined_memory_usage`. 续 [#7236](https://github.com/ClickHouse/ClickHouse/issues/7236). [#9667](https://github.com/ClickHouse/ClickHouse/pull/9667) ([alexey-milovidov](https://github.com/alexey-milovidov))
* 修复原生 MacOS Clang 编译器的构建. [#9649](https://github.com/ClickHouse/ClickHouse/pull/9649) ([Ivan](https://github.com/abyss7))
* 允许在 `pthread_mutex_lock`、`pthread_mutex_unlock` 函数周围添加各种故障. [#9635](https://github.com/ClickHouse/ClickHouse/pull/9635) ([alexey-milovidov](https://github.com/alexey-milovidov))
* 在 `packager` 脚本中添加对 `clang-tidy` 的支持. [#9625](https://github.com/ClickHouse/ClickHouse/pull/9625) ([alexey-milovidov](https://github.com/alexey-milovidov))
* 添加使用未捆绑的 msgpack 的能力. [#10168](https://github.com/ClickHouse/ClickHouse/pull/10168) ([Azat Khuzhin](https://github.com/azat))


## ClickHouse 版本 v20.3


### ClickHouse 版本 v20.3.21.2-lts, 2020-11-02

#### Bug 修复

* 修复 sharding_key 中的 dictGet (以及类似的地方, 即当函数上下文被永久存储时). [#16205](https://github.com/ClickHouse/ClickHouse/pull/16205) ([Azat Khuzhin](https://github.com/azat)).
* 如果查询具有`WHERE`、`PREWHERE` 和`GLOBAL IN`, 则修复来自`Distributed` 表的查询的错误空结果. 修复 [#15792](https://github.com/ClickHouse/ClickHouse/issues/15792). [#15933](https://github.com/ClickHouse/ClickHouse/pull/15933) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* 修复 `TSV/CSVWithNames` 格式中缺失或过多的标题. 这修复了 [#12504](https://github.com/ClickHouse/ClickHouse/issues/12504). [#13343](https://github.com/ClickHouse/ClickHouse/pull/13343) ([Azat Khuzhin](https://github.com/azat)).


### ClickHouse 版本 v20.3.20.6-lts, 2020-10-09

#### Bug 修复

* Mutation 可能会在 `MOVE` 或 `REPLACE PARTITION` 之后等待一些不存在的部分, 或者在极少数情况下, 在 `DETACH` 或 `DROP PARTITION` 之后挂起。 已修复. [#15724](https://github.com/ClickHouse/ClickHouse/pull/15724), [#15537](https://github.com/ClickHouse/ClickHouse/pull/15537) ([tavplubix](https://github.com/tavplubix)).
* 修复带有大量子查询的查询挂起到 `MySQL` 引擎的同一个表. 以前, 如果查询中有超过 16 个子查询到同一个 `MySQL` 表, 它会永远挂起. [#15299](https://github.com/ClickHouse/ClickHouse/pull/15299) ([Anton Popov](https://github.com/CurtizJ)).
* 当查询在 Merge 表上有 JOIN 时，修复 GROUP BY 中的 `Unknown identifier` . [#15242](https://github.com/ClickHouse/ClickHouse/pull/15242) ([Artem Zuikov](https://github.com/4ertus2)).
* 当子查询包含 finalizeAggregation 函数时, 修复使谓词下推工作. 修复 [#14847](https://github.com/ClickHouse/ClickHouse/issues/14847). [#14937](https://github.com/ClickHouse/ClickHouse/pull/14937) ([filimonov](https://github.com/filimonov)).
* 并发 `ALTER ... REPLACE/MOVE PARTITION ...` 查询可能会导致死锁. 已修复. [#13626](https://github.com/ClickHouse/ClickHouse/pull/13626) ([tavplubix](https://github.com/tavplubix)).


### ClickHouse 版本 v20.3.19.4-lts, 2020-09-18

#### Bug 修复

* 当被查询的列具有 `DEFAULT` 表达式时, 修复 `SELECT` 查询中的罕见错误, 该表达式依赖于另一列, 该列也具有 `DEFAULT` 并且不存在于选择查询中且不存在于磁盘上. 部分修复 [#14531](https://github.com/ClickHouse/ClickHouse/issues/14531). [#14845](https://github.com/ClickHouse/ClickHouse/pull/14845) ([alesapin](https://github.com/alesapin)).
* 修复了在赋值表达式和常量值 (如 `UPDATE x = 42`) 中使用 Nullable 列的 `ALTER UPDATE` 突变导致列或段错误中的值不正确时的错误. 修复 [#13634](https://github.com/ClickHouse/ClickHouse/issues/13634), [#14045](https://github.com/ClickHouse/ClickHouse/issues/14045). [#14646](https://github.com/ClickHouse/ClickHouse/pull/14646) ([alesapin](https://github.com/alesapin)).
* 修复错误的十进制乘法结果导致结果列小数位数错误. [#14603](https://github.com/ClickHouse/ClickHouse/pull/14603) ([Artem Zuikov](https://github.com/4ertus2)).

#### 改进

* 支持合并部分的自定义编解码器. [#12183](https://github.com/ClickHouse/ClickHouse/pull/12183) ([Anton Popov](https://github.com/CurtizJ)).


### ClickHouse 版本 v20.3.18.10-lts, 2020-09-08

#### Bug 修复

* 如果 `PipelineExecutor` 本身发生异常, 则停止查询执行. 这可以防止罕见的查询挂起. 续 [#14334](https://github.com/ClickHouse/ClickHouse/issues/14334). [#14402](https://github.com/ClickHouse/ClickHouse/pull/14402) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* 修复了有时缓存字典从源返回默认值而不是当前值时的行为. [#13624](https://github.com/ClickHouse/ClickHouse/pull/13624) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* 当数据库或表的名称包含点时, 修复从 users.xml 解析行策略. 这修复了[#5779](https://github.com/ClickHouse/ClickHouse/issues/5779), [#12527](https://github.com/ClickHouse/ClickHouse/issues/12527). [#13199](https://github.com/ClickHouse/ClickHouse/pull/13199) ([Vitaly Baranov](https://github.com/vitlibar)).
* 修复 CAST(Nullable(String), Enum()). [#12745](https://github.com/ClickHouse/ClickHouse/pull/12745) ([Azat Khuzhin](https://github.com/azat)).
* 修复了 `text_log` 中的数据竞争. 它不对应任何真正的错误. [#9726](https://github.com/ClickHouse/ClickHouse/pull/9726) ([alexey-milovidov](https://github.com/alexey-milovidov)).

#### 改进

* 修复长查询的错误错误. 为了正确查询, 可能会出现除 `Max query size exceeded` 之外的语法错误. [#13928](https://github.com/ClickHouse/ClickHouse/pull/13928) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* 当在 parseDateTimeBestEffortOrNull/Zero 函数中没有完全解析值时, 返回 NULL/零. 这修复了 [#7876](https://github.com/ClickHouse/ClickHouse/issues/7876). [#11653](https://github.com/ClickHouse/ClickHouse/pull/11653) ([alexey-milovidov](https://github.com/alexey-milovidov)).

#### 性能改进

* 使用 LowCardinality 稍微优化非常短的查询. [#14129](https://github.com/ClickHouse/ClickHouse/pull/14129) ([Anton Popov](https://github.com/CurtizJ)).

#### 构建/测试/打包改进

* 修复迁移到 clang-10 后出现的 HashTable 中的 UBSan 报告 (向 nullptr 添加零). [#10638](https://github.com/ClickHouse/ClickHouse/pull/10638) ([alexey-milovidov](https://github.com/alexey-milovidov)).


### ClickHouse 版本 v20.3.17.173-lts, 2020-08-15

#### Bug 修复

* 使用 StorageMerge 和 `set enable_optimize_predicate_expression=1` 修复 JOIN 中的崩溃. [#13679](https://github.com/ClickHouse/ClickHouse/pull/13679) ([Artem Zuikov](https://github.com/4ertus2)).
* 修复无效的返回类型, 用于将元组与 `NULL` 元素进行比较. 修复[#12461](https://github.com/ClickHouse/ClickHouse/issues/12461). [#13420](https://github.com/ClickHouse/ClickHouse/pull/13420) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* 使用常量列和主键的 `ORDER BY` 前缀修复查询. [#13396](https://github.com/ClickHouse/ClickHouse/pull/13396) ([Anton Popov](https://github.com/CurtizJ)).
* 返回在 roundUpToPowerOfTwoOrZero() 中设置 MSB 的数字的传递数字. [#13234](https://github.com/ClickHouse/ClickHouse/pull/13234) ([Azat Khuzhin](https://github.com/azat)).


### ClickHouse 版本 v20.3.16.165-lts 2020-08-10

#### Bug 修复

* 修复了当 unix 时间戳作为参数传递时 `parseDateTimeBestEffort` 函数中的错误. 这修复了 [#13362](https://github.com/ClickHouse/ClickHouse/issues/13362). [#13441](https://github.com/ClickHouse/ClickHouse/pull/13441) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 修复了在具有 NaN 值的 Float 类型上调用的 `uniqExact`、`topK`、`sumDistinct` 和类似聚合函数的潜在低性能和稍微不正确的结果. 它还在调试版本中触发断言. 这修复了 [#12491](https://github.com/ClickHouse/ClickHouse/issues/12491). [#13254](https://github.com/ClickHouse/ClickHouse/pull/13254) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 如果将可空 constexpr 作为不是文字 NULL 的 cond 的固定函数. 修复 [#12463](https://github.com/ClickHouse/ClickHouse/issues/12463). [#13226](https://github.com/ClickHouse/ClickHouse/pull/13226) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 在数组元素为 Nullable 且数组下标也可为 Null 的情况下, 修复了 `arrayElement` 函数中的断言. 这修复了 [#12172](https://github.com/ClickHouse/ClickHouse/issues/12172). [#13224](https://github.com/ClickHouse/ClickHouse/pull/13224) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 修复了对从本地副本进行选择的线程数的不必要限制. [#12840](https://github.com/ClickHouse/ClickHouse/pull/12840) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* 修复了查询 `WITH TOTALS` 时可能出现的数据中可能出现的额外溢出行. [#12747](https://github.com/ClickHouse/ClickHouse/pull/12747) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* 修复了大元组的性能, 这些元组在 `IN` 部分被解释为函数. 当用户出于某种晦涩的原因编写 `WHERE x IN tuple(1, 2, ...)` 而不是 `WHERE x IN (1, 2, ...)` 的情况. [#12700](https://github.com/ClickHouse/ClickHouse/pull/12700) ([Anton Popov](https://github.com/CurtizJ)).
* 修复了 input_format_parallel_parsing 的内存跟踪 (通过将线程附加到组). [#12672](https://github.com/ClickHouse/ClickHouse/pull/12672) ([Azat Khuzhin](https://github.com/azat)).
* 修复了 [#12293](https://github.com/ClickHouse/ClickHouse/issues/12293) 当子查询包含 with 子句时允许推送谓词. [#12663](https://github.com/ClickHouse/ClickHouse/pull/12663) ([Winter Zhang](https://github.com/zhang2014)).
* 修复了 [#10572](https://github.com/ClickHouse/ClickHouse/issues/10572) 使用 const 表达式修复布隆过滤器索引. [#12659](https://github.com/ClickHouse/ClickHouse/pull/12659) ([Winter Zhang](https://github.com/zhang2014)).
* 当代理不可用时 (不仅如此) 修复了 StorageKafka 中的 SIGSEGV. [#12658](https://github.com/ClickHouse/ClickHouse/pull/12658) ([Azat Khuzhin](https://github.com/azat)).
* 修复了带有缓存布局的外部字典中的竞争条件, 这可能导致服务器崩溃. [#12566](https://github.com/ClickHouse/ClickHouse/pull/12566) ([alesapin](https://github.com/alesapin)).
* 修复了当 `enable_mixed_granularity_parts=1` 时, 在 `ALTER DELETE` 查询后导致旧部件损坏的错误. 修复 [#12536](https://github.com/ClickHouse/ClickHouse/issues/12536). [#12543](https://github.com/ClickHouse/ClickHouse/pull/12543) ([alesapin](https://github.com/alesapin)).
* 对于参数数目无效的函数 `in` 更好的异常信息. [#12529](https://github.com/ClickHouse/ClickHouse/pull/12529) ([Anton Popov](https://github.com/CurtizJ)).
* 修复了性能问题，同时读取合并部分. [#12492](https://github.com/ClickHouse/ClickHouse/pull/12492) ([Anton Popov](https://github.com/CurtizJ)).
* 修复了启用 `text_log` 时的死锁. [#12452](https://github.com/ClickHouse/ClickHouse/pull/12452) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 修复了 StorageMerge 时可能出现的段错误. 关闭 [#12054](https://github.com/ClickHouse/ClickHouse/issues/12054). [#12401](https://github.com/ClickHouse/ClickHouse/pull/12401) ([tavplubix](https://github.com/tavplubix)).
* 修复了带有 `-State` 和 `Nullable` 参数的聚合函数的 `TOTALS/ROLLUP/CUBE`. 这修复了 [#12163](https://github.com/ClickHouse/ClickHouse/issues/12163). [#12376](https://github.com/ClickHouse/ClickHouse/pull/12376) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 修复了 `WITH FILL` 修饰符中列的顺序. 以前不遵守 `ORDER BY` 语句的列顺序. [#12306](https://github.com/ClickHouse/ClickHouse/pull/12306) ([Anton Popov](https://github.com/CurtizJ)).
* 当存在按虚拟列 (如 `Merge`表中的`_table`) 或系统表中的 `index` 列过滤数据 (例如从 `system.tables` 查询时按数据库名称过滤) 时, 避免 `bad cast` 异常, 并且这个表达式返回 `Nullable` 类型. 这修复了 [#12166](https://github.com/ClickHouse/ClickHouse/issues/12166). [#12305](https://github.com/ClickHouse/ClickHouse/pull/12305) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* `TrieDictionary` 加载失败后显示错误. [#12290](https://github.com/ClickHouse/ClickHouse/pull/12290) ([Vitaly Baranov](https://github.com/vitlibar)).
* 对于可能导致崩溃的空数组, 函数 `arrayFill` 工作不正确. 这修复了 [#12263](https://github.com/ClickHouse/ClickHouse/issues/12263). [#12279](https://github.com/ClickHouse/ClickHouse/pull/12279) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 实现到 `LowCardinality` 类型的通用类型的转换. 这允许对具有 LowCardinality 列和其他列的表执行 UNION ALL. 这修复了 [#8212](https://github.com/ClickHouse/ClickHouse/issues/8212). This fixes [#4342](https://github.com/ClickHouse/ClickHouse/issues/4342). [#12275](https://github.com/ClickHouse/ClickHouse/pull/12275) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 修复了在某些特殊类型的 `StorageFile` 标头中多次连续插入期间多次写入时的行为. 这已修复 [#6155](https://github.com/ClickHouse/ClickHouse/issues/6155). [#12197](https://github.com/ClickHouse/ClickHouse/pull/12197) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* 修复了 UInt8 值不等于 0 或 1 时的逻辑函数. [#12196](https://github.com/ClickHouse/ClickHouse/pull/12196) ([Alexander Kazakov](https://github.com/Akazz)).
* 在 GROUP BY 内射函数消除期间修复了 `dictGet` 参数检查. [#12179](https://github.com/ClickHouse/ClickHouse/pull/12179) ([Azat Khuzhin](https://github.com/azat)).
* 修复了 `ALTER DELETE` 中的错误逻辑, 当条件评估为 NULL 时会导致删除记录. 这修复了 [#9088](https://github.com/ClickHouse/ClickHouse/issues/9088). This closes [#12106](https://github.com/ClickHouse/ClickHouse/issues/12106). [#12153](https://github.com/ClickHouse/ClickHouse/pull/12153) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 修复了在存在别名的情况下发送到外部 DBMS (例如 MySQL、ODBC) 的查询转换. 这修复了 [#12032](https://github.com/ClickHouse/ClickHouse/issues/12032). [#12151](https://github.com/ClickHouse/ClickHouse/pull/12151) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 修复了整数除法中的潜在溢出. 这修复了 [#12119](https://github.com/ClickHouse/ClickHouse/issues/12119). [#12140](https://github.com/ClickHouse/ClickHouse/pull/12140) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 修复了 `greatCircleDistance`、`geoDistance` 中潜在的无限循环. 这修复了 [#12117](https://github.com/ClickHouse/ClickHouse/issues/12117). [#12137](https://github.com/ClickHouse/ClickHouse/pull/12137) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 对于带有连接或附加到系统日志 (ystem.query_log、metric_log 等) 或 engine=Buffer 基础表的子查询的物化视图, 避免 `There is no query` 异常. [#12120](https://github.com/ClickHouse/ClickHouse/pull/12120) ([filimonov](https://github.com/filimonov)).
* 修复了由于线程总数限制错误导致的带有 `UNION` 的选择的性能. 修复 [#12030](https://github.com/ClickHouse/ClickHouse/issues/12030). [#12103](https://github.com/ClickHouse/ClickHouse/pull/12103) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* 使用 `-StateResample` 组合器修复了段错误. [#12092](https://github.com/ClickHouse/ClickHouse/pull/12092) ([Anton Popov](https://github.com/CurtizJ)).
* 修复了不必要的限制从 `VIEW` 中选择的线程数. 修复 [#11937](https://github.com/ClickHouse/ClickHouse/issues/11937). [#12085](https://github.com/ClickHouse/ClickHouse/pull/12085) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* 修复了使用错误类型 `PREWHERE` 时可能发生的崩溃. 修复[#12053](https://github.com/ClickHouse/ClickHouse/issues/12053), [#12060](https://github.com/ClickHouse/ClickHouse/issues/12060). [#12060](https://github.com/ClickHouse/ClickHouse/pull/12060) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* 修复了具有 `LowCardinality` 类型的函数 `defaultValueOfArgumentType` 的 `Expected single dictionary argument for function` 错误. 修复 [#11808](https://github.com/ClickHouse/ClickHouse/issues/11808). [#12056](https://github.com/ClickHouse/ClickHouse/pull/12056) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* 修复了带有 `Tuple(LowCardinality)` 参数的高阶函数的错误 `Cannot capture column`. 修复 [#9766](https://github.com/ClickHouse/ClickHouse/issues/9766). [#12055](https://github.com/ClickHouse/ClickHouse/pull/12055) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* 加载数据库时并行解析表元数据. 这修复了有大量表时服务器启动缓慢的问题. [#12045](https://github.com/ClickHouse/ClickHouse/pull/12045) ([tavplubix](https://github.com/tavplubix)).
* 使 `topK` 聚合函数为 Enum 类型返回 Enum. 这修复了 [#3740](https://github.com/ClickHouse/ClickHouse/issues/3740). [#12043](https://github.com/ClickHouse/ClickHouse/pull/12043) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 修复了否为常量表达式的约束检查. 这修复了 [#11360](https://github.com/ClickHouse/ClickHouse/issues/11360). [#12042](https://github.com/ClickHouse/ClickHouse/pull/12042) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 修复了元组与 `Nullable` 列的不正确比较. 修复 [#11985](https://github.com/ClickHouse/ClickHouse/issues/11985). [#12039](https://github.com/ClickHouse/ClickHouse/pull/12039) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* 修复了在调用具有不同大小的 `FixedString` 类型参数的函数 `if` 时出现错误结果和潜在崩溃的问题. 这修复了[#11362](https://github.com/ClickHouse/ClickHouse/issues/11362). [#12021](https://github.com/ClickHouse/ClickHouse/pull/12021) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 如果使用偏移量 `-9223372036854775808` 调用函数, 则以函数 `neighbor` 作为唯一返回表达式的查询可能会返回空结果. 这修复了 [#11367](https://github.com/ClickHouse/ClickHouse/issues/11367). [#12019](https://github.com/ClickHouse/ClickHouse/pull/12019) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 修复了 generateRandom 中可能导致崩溃的潜在数组大小溢出. 这修复了 [#11371](https://github.com/ClickHouse/ClickHouse/issues/11371). [#12013](https://github.com/ClickHouse/ClickHouse/pull/12013) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 修复了潜在的浮点异常. 这将关闭 [#11378](https://github.com/ClickHouse/ClickHouse/issues/11378). [#12005](https://github.com/ClickHouse/ClickHouse/pull/12005) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 修复了服务器启动时日志消息中错误的设置名称. [#11997](https://github.com/ClickHouse/ClickHouse/pull/11997) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 修复了 `Values` 格式中的 `Query parameter was not set` 问题. 修复 [#11918](https://github.com/ClickHouse/ClickHouse/issues/11918). [#11936](https://github.com/ClickHouse/ClickHouse/pull/11936) ([tavplubix](https://github.com/tavplubix)).
* 在查询 (参数化查询) 中保留替换的别名. 这修复了 [#11914](https://github.com/ClickHouse/ClickHouse/issues/11914). [#11916](https://github.com/ClickHouse/ClickHouse/pull/11916) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 修复了解析 DateTime64 时潜在的浮点异常. 这修复了 [#11374](https://github.com/ClickHouse/ClickHouse/issues/11374). [#11875](https://github.com/ClickHouse/ClickHouse/pull/11875) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 通过 `HTTP` 接口修复内存记帐 (对于 `wait_end_of_query=1` 可能很重要). [#11840](https://github.com/ClickHouse/ClickHouse/pull/11840) ([Azat Khuzhin](https://github.com/azat)).
* 修复了条件为 NULL 的 `if()` 的错误结果. [#11807](https://github.com/ClickHouse/ClickHouse/pull/11807) ([Artem Zuikov](https://github.com/4ertus2)).
* 在检查相等性之前解析存储在 zookeeper 中的元数据. [#11739](https://github.com/ClickHouse/ClickHouse/pull/11739) ([Azat Khuzhin](https://github.com/azat)).
* 修复了 `LIMIT n WITH TIES` 与 `ORDER BY` 语句一起使用的问题, 该语句包含别名. [#11689](https://github.com/ClickHouse/ClickHouse/pull/11689) ([Anton Popov](https://github.com/CurtizJ)).
* 修复缓存字典中未初始化内存的潜在读取. [#10834](https://github.com/ClickHouse/ClickHouse/pull/10834) ([alexey-milovidov](https://github.com/alexey-milovidov)).

#### 性能改进

* 索引不用于带文字的 IN 运算符, 在 v19.3 前后引入了性能回归. 这修复了 [#10574](https://github.com/ClickHouse/ClickHouse/issues/10574). [#12062](https://github.com/ClickHouse/ClickHouse/pull/12062) ([nvartolomei](https://github.com/nvartolomei)).


### ClickHouse 版本 v20.3.12.112-lts 2020-06-25

#### Bug 修复

* 修复在 prewhere 条件下使用 `Nullable` 列导致的罕见崩溃. 续 [#11608](https://github.com/ClickHouse/ClickHouse/issues/11608). [#11869](https://github.com/ClickHouse/ClickHouse/pull/11869) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* 不允许在高阶函数中使用 arrayJoin. 它导致协议同步中断. 这关闭了 [#3933](https://github.com/ClickHouse/ClickHouse/issues/3933). [#11846](https://github.com/ClickHouse/ClickHouse/pull/11846) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 修复使用过多线程进行查询. [#11788](https://github.com/ClickHouse/ClickHouse/pull/11788) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* 修复像 `SELECT *, xyz.*` 这样的查询的意外行为, 这些查询在预期错误时成功. [#11753](https://github.com/ClickHouse/ClickHouse/pull/11753) ([hexiaoting](https://github.com/hexiaoting)).
* 现在复制的提取将在元数据更改期间取消. [#11744](https://github.com/ClickHouse/ClickHouse/pull/11744) ([alesapin](https://github.com/alesapin)).
* 修复了由 Values 输入格式中复杂文字的错误类型推导导致的 LOGICAL_ERROR. [#11732](https://github.com/ClickHouse/ClickHouse/pull/11732) ([tavplubix](https://github.com/tavplubix)).
* 修复 `ORDER BY ... WITH FILL` 在 const 列上. [#11697](https://github.com/ClickHouse/ClickHouse/pull/11697) ([Anton Popov](https://github.com/CurtizJ)).
* 与 XDBC 桥通信时传递适当的超时. 最近在检查桥接活性和接收元信息时没有遵守超时. [#11690](https://github.com/ClickHouse/ClickHouse/pull/11690) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 修复导致 `system.mutations` 状态不正确的错误. 它可能表明整个突变已经完成, 但服务器在复制队列中仍有 `MUTATE_PART` 任务并尝试执行它们. 这修复了 [#11611](https://github.com/ClickHouse/ClickHouse/issues/11611). [#11681](https://github.com/ClickHouse/ClickHouse/pull/11681) ([alesapin](https://github.com/alesapin)).
* 添加对带有不区分大小写标志的正则表达式的支持. 这修复了 [#11101](https://github.com/ClickHouse/ClickHouse/issues/11101) and fixes [#11506](https://github.com/ClickHouse/ClickHouse/issues/11506). [#11649](https://github.com/ClickHouse/ClickHouse/pull/11649) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 如果设置了行级安全性，则删除琐碎的计数查询优化. 在以前的版本中, 用户获取表中记录的总数而不是过滤. 这修复了[#11352](https://github.com/ClickHouse/ClickHouse/issues/11352). [#11644](https://github.com/ClickHouse/ClickHouse/pull/11644) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 修复字符串的布隆过滤器 (数据跳过索引). [#11638](https://github.com/ClickHouse/ClickHouse/pull/11638) ([Azat Khuzhin](https://github.com/azat)).
* 修复在 prewhere 条件下使用 `Nullable` 列导致的罕见崩溃. (可能它以某种方式与 [#11572](https://github.com/ClickHouse/ClickHouse/issues/11572) somehow). [#11608](https://github.com/ClickHouse/ClickHouse/pull/11608) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* 修复错误 `Block structure mismatch` , 用于从 `Buffer` 表中采样读取的查询. [#11602](https://github.com/ClickHouse/ClickHouse/pull/11602) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* 修复 clickhouse-client 的错误退出代码, 当 exception.code() % 256 = 0 时. [#11601](https://github.com/ClickHouse/ClickHouse/pull/11601) ([filimonov](https://github.com/filimonov)).
* 修复服务器启动时有关 `Mark cache size was lowered` 的日志消息中的小错误. 这将关闭 [#11399](https://github.com/ClickHouse/ClickHouse/issues/11399). [#11589](https://github.com/ClickHouse/ClickHouse/pull/11589) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 修复错误 `Size of offsets does not match size of column` , 用于查询中的 `PREWHERE column in (subquery)` 和 `ARRAY JOIN` . [#11580](https://github.com/ClickHouse/ClickHouse/pull/11580) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* HTTP 会话中的所有查询都具有相同的 query_id. 已修复. [#11578](https://github.com/ClickHouse/ClickHouse/pull/11578) ([tavplubix](https://github.com/tavplubix)).
* 现在 clickhouse-server docker 容器将更喜欢 IPv6 检查服务器活动性. [#11550](https://github.com/ClickHouse/ClickHouse/pull/11550) ([Ivan Starkov](https://github.com/istarkov)).
* 修复 `<node>` 的 shard_num/replica_num (破坏 use_compact_format_in_distributed_parts_names). [#11528](https://github.com/ClickHouse/ClickHouse/pull/11528) ([Azat Khuzhin](https://github.com/azat)).
* 使用 -State 函数在聚合过程中抛出异常时修复内存泄漏. 这修复了 [#8995](https://github.com/ClickHouse/ClickHouse/issues/8995). [#11496](https://github.com/ClickHouse/ClickHouse/pull/11496) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 当别名可以覆盖限定的列名, 修复分布式查询的错误结果. 修复 [#9672](https://github.com/ClickHouse/ClickHouse/issues/9672) [#9714](https://github.com/ClickHouse/ClickHouse/issues/9714). [#9972](https://github.com/ClickHouse/ClickHouse/pull/9972) ([Artem Zuikov](https://github.com/4ertus2)).


### ClickHouse 版本 v20.3.11.97-lts 2020-06-10

#### 新特征

* 现在, ClickHouse 在其一侧控制字典源的超时. 缓存字典配置中添加了两个新设置: `strict_max_lifetime_seconds`, 默认为 `max_lifetime` 和 `query_wait_timeout_milliseconds`, 默认为一分钟. 第一个设置对于 `allow_read_expired_keys` 设置也很有用 (禁止读取非常过期的键). [#10337](https://github.com/ClickHouse/ClickHouse/pull/10337) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).

#### Bug 修复

* 修复了在启用 `min_bytes_to_use_direct_io` 且 PREWHERE 处于活动状态并使用 SAMPLE 或大量线程时可能发生的 `Data compressed with different methods` 错误. 这修复了 [#11539](https://github.com/ClickHouse/ClickHouse/issues/11539). [#11540](https://github.com/ClickHouse/ClickHouse/pull/11540) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 修复编解码器的返回压缩大小. [#11448](https://github.com/ClickHouse/ClickHouse/pull/11448) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* 当列具有带有非文字参数的压缩编解码器时修复服务器崩溃. 修复 [#11365](https://github.com/ClickHouse/ClickHouse/issues/11365). [#11431](https://github.com/ClickHouse/ClickHouse/pull/11431) ([alesapin](https://github.com/alesapin)).
* 以 nan 为点修复 pointInPolygon. 修复 [#11375](https://github.com/ClickHouse/ClickHouse/issues/11375). [#11421](https://github.com/ClickHouse/ClickHouse/pull/11421) ([Alexey Ilyukhov](https://github.com/livace)).
* 修复 JOIN 在 LowCarinality(T) 和 Nullable(T) 上的崩溃. [#11380](https://github.com/ClickHouse/ClickHouse/issues/11380). [#11414](https://github.com/ClickHouse/ClickHouse/pull/11414) ([Artem Zuikov](https://github.com/4ertus2)).
* 修复错误 `USING` 键的错误代码. [#11373](https://github.com/ClickHouse/ClickHouse/issues/11373). [#11404](https://github.com/ClickHouse/ClickHouse/pull/11404) ([Artem Zuikov](https://github.com/4ertus2)).
* 修复了带有纬度/经度范围之外的参数的 geohashesInBox. [#11403](https://github.com/ClickHouse/ClickHouse/pull/11403) ([Vasily Nemkov](https://github.com/Enmk)).
* `joinGet()` 函数更好的错误. [#11389](https://github.com/ClickHouse/ClickHouse/pull/11389) ([Artem Zuikov](https://github.com/4ertus2)).
* 修复具有外部排序和限制的查询可能出现的 `Pipeline stuck` 错误. 修复 [#11359](https://github.com/ClickHouse/ClickHouse/issues/11359). [#11366](https://github.com/ClickHouse/ClickHouse/pull/11366) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* 在 ReplicatedMergeTree 中发送零件期间删除冗余锁. [#11354](https://github.com/ClickHouse/ClickHouse/pull/11354) ([alesapin](https://github.com/alesapin)).
* 修复了多行模式下 clickhouse-client 对 `\G`（垂直输出）的支持. 这将关闭 [#9933](https://github.com/ClickHouse/ClickHouse/issues/9933). [#11350](https://github.com/ClickHouse/ClickHouse/pull/11350) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 修复直接从 StorageJoin 选择 (没有 JOIN) 时的崩溃和错误的可空性. [#11340](https://github.com/ClickHouse/ClickHouse/pull/11340) ([Artem Zuikov](https://github.com/4ertus2)).
* 修复 `quantilesExactWeightedArray` 中的崩溃问题. [#11337](https://github.com/ClickHouse/ClickHouse/pull/11337) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* 现在合并在 `ALTER` 查询中更改元数据之前停止. [#11335](https://github.com/ClickHouse/ClickHouse/pull/11335) ([alesapin](https://github.com/alesapin)).
* 通过再次设置 `parallel_view_processing = 1` 并行写入 `MATERIALIZED VIEW` . 修复 [#10241](https://github.com/ClickHouse/ClickHouse/issues/10241). [#11330](https://github.com/ClickHouse/ClickHouse/pull/11330) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* 当提取的 JSON 具有不平衡的 { 或 [ 字符串时, 修复visitParamExtractRaw. [#11318](https://github.com/ClickHouse/ClickHouse/pull/11318) ([Ewout](https://github.com/devwout)).
* 修复 ThreadPool 中非常罕见的竞争条件. [#11314](https://github.com/ClickHouse/ClickHouse/pull/11314) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 修复转换中潜在的未初始化内存. 示例: `SELECT toIntervalSecond(now64())`. [#11311](https://github.com/ClickHouse/ClickHouse/pull/11311) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 修复了如果表的主键中有 Array 列并且查询正在使用 `empty` 或 `notEmpty` 函数按此列过滤时索引分析无法工作的问题. 这修复了 [#11286](https://github.com/ClickHouse/ClickHouse/issues/11286). [#11303](https://github.com/ClickHouse/ClickHouse/pull/11303) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 修复当查询速度估计可能不正确时的错误, 并且如果查询受到 `max_network_bandwidth`、`max_execution_speed` 或 `priority` 设置的限制, `min_execution_speed` 的限制可能无法工作或无法正常工作. 将 `timeout_before_checking_execution_speed` 的默认值更改为非零值, 否则设置 `min_execution_speed` 和 `max_execution_speed` 无效. 这修复了 [#11297](https://github.com/ClickHouse/ClickHouse/issues/11297). 这修复了 [#5732](https://github.com/ClickHouse/ClickHouse/issues/5732). 这修复了 [#6228](https://github.com/ClickHouse/ClickHouse/issues/6228). 可用性改进：避免在 `clickhouse-client` 中将异常消息与进度条串联. [#11296](https://github.com/ClickHouse/ClickHouse/pull/11296) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 修复读取 Protobuf 格式错误数据时崩溃的问题. 这修复了 [#5957](https://github.com/ClickHouse/ClickHouse/issues/5957), fixes [#11203](https://github.com/ClickHouse/ClickHouse/issues/11203). [#11258](https://github.com/ClickHouse/ClickHouse/pull/11258) ([Vitaly Baranov](https://github.com/vitlibar)).
* 修复了缓存字典可以返回默认值而不是正常值 (只有过期键时) 的错误. 这仅影响字符串字段. [#11233](https://github.com/ClickHouse/ClickHouse/pull/11233) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* 修复错误 `Block structure mismatch in QueryPipeline` , 同时从内部查询中的常量读取 `VIEW` . 修复 [#11181](https://github.com/ClickHouse/ClickHouse/issues/11181). [#11205](https://github.com/ClickHouse/ClickHouse/pull/11205) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* 修复可能的异常 `Invalid status for associated output`. [#11200](https://github.com/ClickHouse/ClickHouse/pull/11200) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* 使用 `Array(Array(LowCardinality))` 捕获参数修复高阶函数的可能错误 `Cannot capture column` . [#11185](https://github.com/ClickHouse/ClickHouse/pull/11185) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* 修复了 S3 globbing 在超过 1000 个密钥和一些后端的情况下可能会失败的问题. [#11179](https://github.com/ClickHouse/ClickHouse/pull/11179) ([Vladimir Chebotarev](https://github.com/excitoon)).
* 如果数据跳过索引依赖于将在后台合并期间修改的列 (对于 SummingMergeTree、AggregatingMergeTree 以及 TTL GROUP BY), 则计算错误. 此问题已通过合并后移动索引计算得到修复, 因此索引是在合并数据上计算的. [#11162](https://github.com/ClickHouse/ClickHouse/pull/11162) ([Azat Khuzhin](https://github.com/azat)).
* 修复简单查询过多的线程预留 (优化减少线程数量, 在管道更改后部分中断). [#11114](https://github.com/ClickHouse/ClickHouse/pull/11114) ([Azat Khuzhin](https://github.com/azat)).
* 修复分布式查询的谓词优化 (`enable_optimize_predicate_expression=1`) 对于带有 `HAVING` 部分的查询 (即需要在服务器启动器上进行过滤时), 通过保留表达式的顺序 (这足以修复), 并且还强制 聚合器在索引上使用列名. 修复: [#10613](https://github.com/ClickHouse/ClickHouse/issues/10613), [#11413](https://github.com/ClickHouse/ClickHouse/issues/11413). [#10621](https://github.com/ClickHouse/ClickHouse/pull/10621) ([Azat Khuzhin](https://github.com/azat)).
* 引入提交重试逻辑, 以减少在极少数情况下, 偏移提交失败时从 Kafka 获取重复项的可能性. [#9884](https://github.com/ClickHouse/ClickHouse/pull/9884) ([filimonov](https://github.com/filimonov)).

#### 性能改进

* 每次调用读取外部字典的任何函数时, 仅获取一次字典并检查访问权限. [#10928](https://github.com/ClickHouse/ClickHouse/pull/10928) ([Vitaly Baranov](https://github.com/vitlibar)).

#### 构建/测试/打包改进

* 修复几个不稳定的集成测试. [#11355](https://github.com/ClickHouse/ClickHouse/pull/11355) ([alesapin](https://github.com/alesapin)).

### ClickHouse 版本 v20.3.10.75-lts 2020-05-23

#### Bug 修复

* 如果没有最终确定, 则从突变终止任务中删除日志记录. [#11109](https://github.com/ClickHouse/ClickHouse/pull/11109) ([alesapin](https://github.com/alesapin)).
* 修复了 `parseDateTime64BestEffort` 参数解析错误. [#11038](https://github.com/ClickHouse/ClickHouse/pull/11038) ([Vasily Nemkov](https://github.com/Enmk)).
* 修复了方法 `getRawData()` 中不正确的原始数据大小. [#10964](https://github.com/ClickHouse/ClickHouse/pull/10964) ([Igr](https://github.com/ObjatieGroba)).
* 修复了 20.1 及更早版本之间两级聚合的不兼容问题. 当在启动器节点和远程节点上使用不同版本的 ClickHouse 并且 `GROUP BY` 结果的大小很大并且聚合由单个 `String` 字段执行时, 就会发生这种不兼容性. 结果导致单个键的多个未合并的行. [#10952](https://github.com/ClickHouse/ClickHouse/pull/10952) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 修复了与 `Distributed` 表中元组的向后兼容性. [#10889](https://github.com/ClickHouse/ClickHouse/pull/10889) ([Anton Popov](https://github.com/CurtizJ)).
* 如果这样的键不存在, 则修复了 `StringHashTable` 中的 `SIGSEGV`. [#10870](https://github.com/ClickHouse/ClickHouse/pull/10870) ([Azat Khuzhin](https://github.com/azat)).
* 修复了 `ReplicatedMergeTree` 中的错误, 该错误可能导致 `OPTIMIZE` 查询上的某些 `ALTER` 在它变为非活动状态后挂起等待某些副本. [#10849](https://github.com/ClickHouse/ClickHouse/pull/10849) ([tavplubix](https://github.com/tavplubix)).
* 修复 `Block::sortColumns()` 之后的列顺序. [#10826](https://github.com/ClickHouse/ClickHouse/pull/10826) ([Azat Khuzhin](https://github.com/azat)).
* 修复了当不要求引用标识符时 `ODBC` 桥的问题. 修复 [#7984](https://github.com/ClickHouse/ClickHouse/issues/7984). [#10821](https://github.com/ClickHouse/ClickHouse/pull/10821) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 修复了 `DateLUT` 中的 `UBSan` 和 `MSan` 报告. [#10798](https://github.com/ClickHouse/ClickHouse/pull/10798) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 修复了关键条件下错误的类型转换. 修复[#6287](https://github.com/ClickHouse/ClickHouse/issues/6287). [#10791](https://github.com/ClickHouse/ClickHouse/pull/10791) ([Andrew Onyshchuk](https://github.com/oandrew))
* 修复了 `parallel_view_processing` 行为. 现在, 如果发生异常, 所有对 `MATERIALIZED VIEW` 的插入都应该无一例外地完成. 修复 [#10241](https://github.com/ClickHouse/ClickHouse/issues/10241). [#10757](https://github.com/ClickHouse/ClickHouse/pull/10757) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* 修复了组合符 `-OrNull` 和 `-OrDefault` 与 `-State` 组合时的问题. [#10741](https://github.com/ClickHouse/ClickHouse/pull/10741) ([hcz](https://github.com/hczhcz)).
* 修复了带有嵌套类型的 `generateRandom` 中的崩溃. 修复 [#10583](https://github.com/ClickHouse/ClickHouse/issues/10583). [#10734](https://github.com/ClickHouse/ClickHouse/pull/10734) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* 修复了合并后可能发生的 `SummingMergeTree` 中 `LowCardinality(FixedString)` 键列的数据损坏. 修复 [#10489](https://github.com/ClickHouse/ClickHouse/issues/10489). [#10721](https://github.com/ClickHouse/ClickHouse/pull/10721) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* 修复了函数 `h3EdgeAngle` 中可能出现的缓冲区溢出. [#10711](https://github.com/ClickHouse/ClickHouse/pull/10711) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 修复了消失的总数. 如果查询具有连接或具有外部 where 条件的子查询, 则总计可能已被过滤. 修复 [#10674](https://github.com/ClickHouse/ClickHouse/issues/10674). [#10698](https://github.com/ClickHouse/ClickHouse/pull/10698) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* 修复了在一个查询中具有相同集合的 `IN` 运算符的多次使用. [#10686](https://github.com/ClickHouse/ClickHouse/pull/10686) ([Anton Popov](https://github.com/CurtizJ)).
* 修复了当 `readonly=2` 和 `cancel_http_readonly_queries_on_client_close=1` 时导致 http 请求卡在客户端关闭的错误. 修复 [#7939](https://github.com/ClickHouse/ClickHouse/issues/7939), [#7019](https://github.com/ClickHouse/ClickHouse/issues/7019), [#7736](https://github.com/ClickHouse/ClickHouse/issues/7736), [#7091](https://github.com/ClickHouse/ClickHouse/issues/7091). [#10684](https://github.com/ClickHouse/ClickHouse/pull/10684) ([tavplubix](https://github.com/tavplubix)).
* 修复了 `AggregateTransform` 构造函数中参数的顺序. [#10667](https://github.com/ClickHouse/ClickHouse/pull/10667) ([palasonic1](https://github.com/palasonic1)).
* 修复了启用 `distributed_aggregation_memory_efficient` 时远程查询缺乏并行执行的问题. 修复[#10655](https://github.com/ClickHouse/ClickHouse/issues/10655). [#10664](https://github.com/ClickHouse/ClickHouse/pull/10664) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* 修复了使用 `LIMIT` 的查询可能不正确的行数. 修复 [#10566](https://github.com/ClickHouse/ClickHouse/issues/10566), [#10709](https://github.com/ClickHouse/ClickHouse/issues/10709). [#10660](https://github.com/ClickHouse/ClickHouse/pull/10660) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* 修复了当表有很多部分时锁定并发更改的错误. [#10659](https://github.com/ClickHouse/ClickHouse/pull/10659) ([alesapin](https://github.com/alesapin)).
* 修复了在 `SYSTEM DROP DNS CACHE` 查询也删除缓存时的错误, 用于检查是否允许用户从某些 IP 地址连接. [#10608](https://github.com/ClickHouse/ClickHouse/pull/10608) ([tavplubix](https://github.com/tavplubix)).
* 修复了 `MATERIALIZED VIEW` 内部查询中不正确的标量结果, 以防该查询包含相关表. [#10603](https://github.com/ClickHouse/ClickHouse/pull/10603) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* 修复了列 `ALIAS` 的 `SELECT`, 它的默认表达式类型与列类型不同. [#10563](https://github.com/ClickHouse/ClickHouse/pull/10563) ([Azat Khuzhin](https://github.com/azat)).
* 实现了 DateTime64 和 String 值之间的比较. [#10560](https://github.com/ClickHouse/ClickHouse/pull/10560) ([Vasily Nemkov](https://github.com/Enmk)).
* 修复索引损坏, 在某些情况下将紧凑部分合并到另一个紧凑部分后可能会发生. [#10531](https://github.com/ClickHouse/ClickHouse/pull/10531) ([Anton Popov](https://github.com/CurtizJ)).
* 修复了所有部分mutation完成后, 在 `is_done=0` 中挂掉的情况. [#10526](https://github.com/ClickHouse/ClickHouse/pull/10526) ([alesapin](https://github.com/alesapin)).
* 修复了 unix 纪元开始时与 `UTC` 有小数偏移的时区溢出. 这修复了 [#9335](https://github.com/ClickHouse/ClickHouse/issues/9335). [#10513](https://github.com/ClickHouse/ClickHouse/pull/10513) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 修复了 `Distributed` 存储的不当关闭. [#10491](https://github.com/ClickHouse/ClickHouse/pull/10491) ([Azat Khuzhin](https://github.com/azat)).
* 修复了 `simpleLinearRegression` 中大整数上的数字溢出. [#10474](https://github.com/ClickHouse/ClickHouse/pull/10474) ([hcz](https://github.com/hczhcz)).


#### 构建/测试/打包改进

* 修复 LZ4 库中的 UBSan 报告. [#10631](https://github.com/ClickHouse/ClickHouse/pull/10631) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 修复 clang-10 构建. [#10238](https://github.com/ClickHouse/ClickHouse/issues/10238). [#10370](https://github.com/ClickHouse/ClickHouse/pull/10370) ([Amos Bird](https://github.com/amosbird)).
* 添加了关于 `max_rows_to_sort` 设置的失败测试. [#10268](https://github.com/ClickHouse/ClickHouse/pull/10268) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 添加了在输入格式中打印诊断信息的一些改进. 修复 [#10204](https://github.com/ClickHouse/ClickHouse/issues/10204). [#10418](https://github.com/ClickHouse/ClickHouse/pull/10418) ([tavplubix](https://github.com/tavplubix)).
* 将 CA 证书添加到 clickhouse-server docker 镜像. [#10476](https://github.com/ClickHouse/ClickHouse/pull/10476) ([filimonov](https://github.com/filimonov)).

#### Bug 修复

* 修复错误 `the BloomFilter false positive must be a double number between 0 and 1` [#10551](https://github.com/ClickHouse/ClickHouse/issues/10551). [#10569](https://github.com/ClickHouse/ClickHouse/pull/10569) ([Winter Zhang](https://github.com/zhang2014)).


### ClickHouse 版本 v20.3.8.53, 2020-04-23

#### Bug 修复
* 修复了时区的日期时间函数的错误行为, 这些时区在 UTC 的正负偏移量之间发生了变化 (例如 Pacific/Kiritimati). 这修复了[#7202](https://github.com/ClickHouse/ClickHouse/issues/7202) [#10369](https://github.com/ClickHouse/ClickHouse/pull/10369) ([alexey-milovidov](https://github.com/alexey-milovidov))
* 修复启用 `distributed_group_by_no_merge` 时可能出现的段错误 (在 20.3.7.46 中由 [#10131](https://github.com/ClickHouse/ClickHouse/issues/10131) 引入). [#10399](https://github.com/ClickHouse/ClickHouse/pull/10399) ([Nikolai Kochetov](https://github.com/KochetovNicolai))
* 修复 `Array(Tuple(...))` 数据类型的错误扁平化. 这修复了 [#10259](https://github.com/ClickHouse/ClickHouse/issues/10259) [#10390](https://github.com/ClickHouse/ClickHouse/pull/10390) ([alexey-milovidov](https://github.com/alexey-milovidov))
* 在聚合器中删除磁盘预留. 这修复了磁盘空间预留的错误, 该错误可能导致大型外部聚合即使成功完成也可能失败. [#10375](https://github.com/ClickHouse/ClickHouse/pull/10375) ([Azat Khuzhin](https://github.com/azat))
* 修复了 `ReplicatedMergeTree` 中的 `DROP` 与 `OPTIMIZE` 竞赛. 如果存在并发的 OPTIMIZE 查询, 则 DROP 可能会在 ZooKeeper 的副本路径中留下一些垃圾. [#10312](https://github.com/ClickHouse/ClickHouse/pull/10312) ([tavplubix](https://github.com/tavplubix))
* 修复更改列默认值后服务器无法附加表的错误. [#10441](https://github.com/ClickHouse/ClickHouse/pull/10441) ([alesapin](https://github.com/alesapin))
* 在加载表之前附加数据库失败时不要删除元数据目录.  [#10442](https://github.com/ClickHouse/ClickHouse/pull/10442) ([Winter Zhang](https://github.com/zhang2014))
* 修复了一些错误, 当某些数据以法定人数插入, 然后以某种方式删除 (DROP PARTITION, TTL) 时, 这会导致插入卡住或 SELECT 中的误报异常. 这修复了 [#9946](https://github.com/ClickHouse/ClickHouse/issues/9946) [#10188](https://github.com/ClickHouse/ClickHouse/pull/10188) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov))
* 修复 `ConcatProcessor` 中可能发生的 `Pipeline stuck` 错误，该错误可能发生在远程查询中. [#10381](https://github.com/ClickHouse/ClickHouse/pull/10381) ([Nikolai Kochetov](https://github.com/KochetovNicolai))
* 修复了 HashTable 中尝试从缓冲区读取 HashMap 时导致编译错误的错误行为. [#10386](https://github.com/ClickHouse/ClickHouse/pull/10386) ([palasonic1](https://github.com/palasonic1))
* 允许对多个 JOIN 使用 `count(*)`. 修复 [#9853](https://github.com/ClickHouse/ClickHouse/issues/9853) [#10291](https://github.com/ClickHouse/ClickHouse/pull/10291) ([Artem Zuikov](https://github.com/4ertus2))
* 更喜欢 `fallback_to_stale_replicas` 而不是 `skip_unavailable_shards`, 否则当两个设置都指定并且没有最新的副本时, 查询将失败 (来自@alex-zaitsev的补丁). 修复: [#2564](https://github.com/ClickHouse/ClickHouse/issues/2564). [#10422](https://github.com/ClickHouse/ClickHouse/pull/10422) ([Azat Khuzhin](https://github.com/azat))
* 修复带有 ARRAY JOIN、ORDER BY 和 LIMIT 的查询可能返回不完整结果的问题. 这修复了 [#10226](https://github.com/ClickHouse/ClickHouse/issues/10226). 作者: [Vadim Plakhtinskiy](https://github.com/VadimPlh). [#10427](https://github.com/ClickHouse/ClickHouse/pull/10427) ([alexey-milovidov](https://github.com/alexey-milovidov))
* 创建 BloomFilter 索引时检查参数的数量和类型. [#9623](https://github.com/ClickHouse/ClickHouse/issues/9623) [#10431](https://github.com/ClickHouse/ClickHouse/pull/10431) ([Winter Zhang](https://github.com/zhang2014))

#### 性能改进
* 在 `IN` 运算符的右侧显式定义的集合和左侧的元组提高了查询的性能. 这修复了 20.3 版中的性能回归. [#9740](https://github.com/ClickHouse/ClickHouse/pull/9740), [#10385](https://github.com/ClickHouse/ClickHouse/pull/10385) ([Anton Popov](https://github.com/CurtizJ))

### ClickHouse 版本 v20.3.7.46, 2020-04-17

#### Bug 修复

* 修复 `Logical error: CROSS JOIN has expressions` 错误, 用于使用逗号和名称连接混合的查询. [#10311](https://github.com/ClickHouse/ClickHouse/pull/10311) ([Artem Zuikov](https://github.com/4ertus2)).
* 使用 `max_bytes_before_external_group_by` 修复查询. [#10302](https://github.com/ClickHouse/ClickHouse/pull/10302) ([Artem Zuikov](https://github.com/4ertus2)).
* 在存在数组连接函数的情况下修复移动到前置位置优化 (在某些情况下). 这修复了[#10092](https://github.com/ClickHouse/ClickHouse/issues/10092). [#10195](https://github.com/ClickHouse/ClickHouse/pull/10195) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 添加放宽对使用 `allow_nondeterministic_mutations` 设置的突变中非确定性函数使用限制的能力. [#10186](https://github.com/ClickHouse/ClickHouse/pull/10186) ([filimonov](https://github.com/filimonov)).

### ClickHouse 版本 v20.3.6.40, 2020-04-16

#### 新特征

* 添加函数 `isConstant`. 此函数检查其参数是否为常量表达式并返回 1 或 0. 用于开发、调试和演示目的. [#10198](https://github.com/ClickHouse/ClickHouse/pull/10198) ([alexey-milovidov](https://github.com/alexey-milovidov)).

#### Bug 修复

* 使用 `max_rows_to_group_by` 和 `group_by_overflow_mode = 'break'` 修复错误 `Pipeline stuck`. [#10279](https://github.com/ClickHouse/ClickHouse/pull/10279) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* 修复罕见的可能异常 `Cannot drain connections: cancel first`. [#10239](https://github.com/ClickHouse/ClickHouse/pull/10239) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* 修复了 ClickHouse 会抛出 `Unknown function lambda.` 的错误. 当用户尝试在 ENGINE = Replicated* 的表上运行 ALTER UPDATE/DELETE 时出现错误消息. 检查非确定性函数现在可以正确处理 lambda 表达式. [#10237](https://github.com/ClickHouse/ClickHouse/pull/10237) ([Alexander Kazakov](https://github.com/Akazz)).
* 修复了 Date 类型的 `generateRandom` 函数. 这修复了 [#9973](https://github.com/ClickHouse/ClickHouse/issues/9973). 修复了将 2106 年的日期插入到使用旧式分区的 MergeTree 表但分区以 1970 年命名的边缘情况. [#10218](https://github.com/ClickHouse/ClickHouse/pull/10218) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 如果 View 的表定义与 SELECT 查询不对应，则转换类型. 这修复了 [#10180](https://github.com/ClickHouse/ClickHouse/issues/10180) and [#10022](https://github.com/ClickHouse/ClickHouse/issues/10022). [#10217](https://github.com/ClickHouse/ClickHouse/pull/10217) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 修复 RFC-2822 中字符串的 `parseDateTimeBestEffort`, 当一周中的某一天是星期二或星期四时. 这修复了[#10082](https://github.com/ClickHouse/ClickHouse/issues/10082). [#10214](https://github.com/ClickHouse/ClickHouse/pull/10214) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 修复 JOIN 内的常量列名可能与 JOIN 外的常量名冲突. [#10207](https://github.com/ClickHouse/ClickHouse/pull/10207) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 当查询实际上应该在 LIMIT 停止时, 修复可能的无限查询执行, 同时从无限源 (如 `system.numbers` 或 `system.zeros` ) 读取. [#10206](https://github.com/ClickHouse/ClickHouse/pull/10206) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* 修复未指定数据库时使用当前数据库进行访问检查的问题. [#10192](https://github.com/ClickHouse/ClickHouse/pull/10192) ([Vitaly Baranov](https://github.com/vitlibar)).
* 如果结构在 INSERT 中不匹配, 则将块转换为 Distributed(). [#10135](https://github.com/ClickHouse/ClickHouse/pull/10135) ([Azat Khuzhin](https://github.com/azat)).
* 修复处理器管道中极端情况可能导致的错误结果. [#10131](https://github.com/ClickHouse/ClickHouse/pull/10131) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* 用合并部分修复某些类型的改动. [#10130](https://github.com/ClickHouse/ClickHouse/pull/10130) ([Anton Popov](https://github.com/CurtizJ)).
* 在创建新副本时修复不正确的 `index_granularity_bytes` 检查. 修复 [#10098](https://github.com/ClickHouse/ClickHouse/issues/10098). [#10121](https://github.com/ClickHouse/ClickHouse/pull/10121) ([alesapin](https://github.com/alesapin)).
* 当其结构与基础表不同时, 修复 INSERT 上的 SIGSEGV 到分布式表中. [#10105](https://github.com/ClickHouse/ClickHouse/pull/10105) ([Azat Khuzhin](https://github.com/azat)).
* 使用 `JOIN` 和 `UNION ALL` 修复查询可能丢失的行. 修复 [#9826](https://github.com/ClickHouse/ClickHouse/issues/9826), [#10113](https://github.com/ClickHouse/ClickHouse/issues/10113). [#10099](https://github.com/ClickHouse/ClickHouse/pull/10099) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* 修复了从不存在 `/table/replicas/replica_name/metadata` 节点的旧 ClickHouse 版本更新时复制表启动的问题. 修复 [#10037](https://github.com/ClickHouse/ClickHouse/issues/10037). [#10095](https://github.com/ClickHouse/ClickHouse/pull/10095) ([alesapin](https://github.com/alesapin)).
* 为 MySQL 数据库引擎添加一些参数检查和支持标识符参数. [#10077](https://github.com/ClickHouse/ClickHouse/pull/10077) ([Winter Zhang](https://github.com/zhang2014)).
* 修复来自 localhost clickhouse 服务器的 clickhouse 字典源中的错误. 如果字典和源中的类型不兼容, 该错误可能会导致内存损坏. [#10071](https://github.com/ClickHouse/ClickHouse/pull/10071) ([alesapin](https://github.com/alesapin)).
* 当表包含跳过索引时, 修复`CHECK TABLE`查询中的错误. [#10068](https://github.com/ClickHouse/ClickHouse/pull/10068) ([alesapin](https://github.com/alesapin)).
* 修复错误 `Cannot clone block with columns because block has 0 columns ... While executing GroupingAggregatedTransform`. 当设置 `distributed_aggregation_memory_efficient` 被启用, 并且分布式查询从不同分片读取不同级别的聚合数据时发生这种情况 (混合单级和二级聚合). [#10063](https://github.com/ClickHouse/ClickHouse/pull/10063) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* 修复 GROUP BY 中可能发生的分段错误, 该错误是包含尾随零字节的字符串键 ([#8636](https://github.com/ClickHouse/ClickHouse/issues/8636), [#8925](https://github.com/ClickHouse/ClickHouse/issues/8925)). [#10025](https://github.com/ClickHouse/ClickHouse/pull/10025) ([Alexander Kuzmenkov](https://github.com/akuzm)).
* 修复用于远程查询执行的线程数 (性能回归, 自 20.3 起). 当来自 `Distributed` 表的查询在本地和远程分片上同时执行时, 就会发生这种情况. 修复 [#9965](https://github.com/ClickHouse/ClickHouse/issues/9965). [#9971](https://github.com/ClickHouse/ClickHouse/pull/9971) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* 修复了在某些数据库查询的处理阶段之一未检索到必要表的错误. 修复 [#9699](https://github.com/ClickHouse/ClickHouse/issues/9699). [#9949](https://github.com/ClickHouse/ClickHouse/pull/9949) ([achulkov2](https://github.com/achulkov2)).
* 修复 `JOIN` 与 `TOTALS` 一起出现时 `Not found column in block` 错误. 修复 [#9839](https://github.com/ClickHouse/ClickHouse/issues/9839). [#9939](https://github.com/ClickHouse/ClickHouse/pull/9939) ([Artem Zuikov](https://github.com/4ertus2)).
* 修复 `ON CLUSTER` DDL 查询在服务器启动时冻结的错误 [#9927](https://github.com/ClickHouse/ClickHouse/pull/9927) ([Gagan Arneja](https://github.com/garneja)).
* 修复解析 CREATE USER 命令中设置的多个主机, 例如 `CREATE USER user6 HOST NAME REGEXP 'lo.?*host', NAME REGEXP 'lo*host'`. [#9924](https://github.com/ClickHouse/ClickHouse/pull/9924) ([Vitaly Baranov](https://github.com/vitlibar)).
* 修复连接表引擎的 `TRUNCATE` ([#9917](https://github.com/ClickHouse/ClickHouse/issues/9917)). [#9920](https://github.com/ClickHouse/ClickHouse/pull/9920) ([Amos Bird](https://github.com/amosbird)).
* 修复 ALTER 中的 `scalar does not exist` 错误 ([#9878](https://github.com/ClickHouse/ClickHouse/issues/9878)). [#9904](https://github.com/ClickHouse/ClickHouse/pull/9904) ([Amos Bird](https://github.com/amosbird)).
* 修复 `ReplicatedMergeTree` 中删除和优化之间的竞争条件. [#9901](https://github.com/ClickHouse/ClickHouse/pull/9901) ([alesapin](https://github.com/alesapin)).
* 修复 `distributed_product_mode='local'` 中的限定名称错误. 修复 [#4756](https://github.com/ClickHouse/ClickHouse/issues/4756). [#9891](https://github.com/ClickHouse/ClickHouse/pull/9891) ([Artem Zuikov](https://github.com/4ertus2)).
* 修复了设置 `allow_introspection_functions` 中内省函数的计算授权. [#9840](https://github.com/ClickHouse/ClickHouse/pull/9840) ([Vitaly Baranov](https://github.com/vitlibar)).

#### 构建/测试/打包改进

* 修复集成测试`test_settings_constraints`. [#9962](https://github.com/ClickHouse/ClickHouse/pull/9962) ([Vitaly Baranov](https://github.com/vitlibar)).
* 删除了对 `clock_getres` 的依赖. [#9833](https://github.com/ClickHouse/ClickHouse/pull/9833) ([alexey-milovidov](https://github.com/alexey-milovidov)).


### ClickHouse 版本 v20.3.5.21, 2020-03-27

#### Bug 修复

* 当查询在分布式表上具有 PREWHERE 和 WHERE 并且 `SET distributed_product_mode = 'local'` 时, 修复 `Different expressions with the same alias` 错误. [#9871](https://github.com/ClickHouse/ClickHouse/pull/9871) ([Artem Zuikov](https://github.com/4ertus2)).
* 修复具有复合主键的表的突变过多的内存消耗. 这修复了[#9850](https://github.com/ClickHouse/ClickHouse/issues/9850). [#9860](https://github.com/ClickHouse/ClickHouse/pull/9860) ([alesapin](https://github.com/alesapin)).
* 对于 INSERT 查询, 分片现在将从发起者获得的设置限制在分片的约束中, 而不是抛出异常. 此修复允许将 INSERT 查询发送到具有其他约束的分片. 此更改改进了修复 [#9447](https://github.com/ClickHouse/ClickHouse/issues/9447). [#9852](https://github.com/ClickHouse/ClickHouse/pull/9852) ([Vitaly Baranov](https://github.com/vitlibar)).
* 修复 `COMMA to CROSS JOIN rewriter is not enabled or cannot rewrite query` 错误, 以防在表列表中使用 COMMA JOIN 进行子查询 (即在 WHERE 中). 修复[#9782](https://github.com/ClickHouse/ClickHouse/issues/9782). [#9830](https://github.com/ClickHouse/ClickHouse/pull/9830) ([Artem Zuikov](https://github.com/4ertus2)).
* 修复客户端上可能出现的异常 `Got 0 in totals chunk, expected 1` on client. 如果右连接表有零行, 则使用“JOIN”进行查询时会发生这种情况. 示例: `select * from system.one t1 join system.one t2 on t1.dummy = t2.dummy limit 0 FORMAT TabSeparated;`. 修复 [#9777](https://github.com/ClickHouse/ClickHouse/issues/9777). [#9823](https://github.com/ClickHouse/ClickHouse/pull/9823) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* 无法转换类型时使用 optimize_skip_unused_shards 修复 SIGSEGV. [#9804](https://github.com/ClickHouse/ClickHouse/pull/9804) ([Azat Khuzhin](https://github.com/azat)).
* 修复损坏的 `ALTER TABLE DELETE COLUMN` 查询合并部分. [#9779](https://github.com/ClickHouse/ClickHouse/pull/9779) ([alesapin](https://github.com/alesapin)).
* 修复 max_distributed_connections (带和不带处理器). [#9673](https://github.com/ClickHouse/ClickHouse/pull/9673) ([Azat Khuzhin](https://github.com/azat)).
* 修复了函数参数的时区使用不正确的一些情况. [#9574](https://github.com/ClickHouse/ClickHouse/pull/9574) ([Vasily Nemkov](https://github.com/Enmk)).

#### 改进

* 由于我们从单个线程中的单个有序部分读取, 因此逐阶段从突变中删除顺序. 还添加检查突变中的行顺序是否按排序键顺序排序并且不违反此顺序. [#9886](https://github.com/ClickHouse/ClickHouse/pull/9886) ([alesapin](https://github.com/alesapin)).


### ClickHouse 版本 v20.3.4.10, 2020-03-20

#### Bug 修复
* 此版本还包含 20.1.8.41 的所有错误修复.
* 修复丢失的 `rows_before_limit_at_least` 用于通过 http (使用处理器管道) 的查询. 这修复了 [#9730](https://github.com/ClickHouse/ClickHouse/issues/9730). [#9757](https://github.com/ClickHouse/ClickHouse/pull/9757) ([Nikolai Kochetov](https://github.com/KochetovNicolai))


### ClickHouse 版本 v20.3.3.6, 2020-03-17

#### Bug 修复
* 此版本还包含 20.1.7.38 的所有错误修复.
* 修复复制中的错误, 如果用户在以前的版本上执行了更改, 则不允许复制工作. 这修复了 [#9645](https://github.com/ClickHouse/ClickHouse/issues/9645). [#9652](https://github.com/ClickHouse/ClickHouse/pull/9652) ([alesapin](https://github.com/alesapin)). It makes version 20.3 backward compatible again.
* 添加设置 `use_compact_format_in_distributed_parts_names` , 它允许将 `INSERT` 查询的文件以更紧凑的格式写入 `Distributed` 表. 这修复了 [#9647](https://github.com/ClickHouse/ClickHouse/issues/9647). [#9653](https://github.com/ClickHouse/ClickHouse/pull/9653) ([alesapin](https://github.com/alesapin)). 它使 20.3 版再次向后兼容.

### ClickHouse 版本 v20.3.2.1, 2020-03-12

#### 向后不兼容变更

* 修复了为大量副本的 `Distributed` 表发送数据时 `file name too long` 的问题. 修复了副本凭据在服务器日志中暴露的问题. 磁盘目录名格式改为 `[shard{shard_index}[_replica{replica_index}]]`. [#8911](https://github.com/ClickHouse/ClickHouse/pull/8911) ([Mikhail Korotov](https://github.com/millb)) 升级到新版本后, 您将不会无需人工干预即可降级, 因为旧服务器版本无法识别新目录格式. 如果要降级, 则必须手动将相应目录重命名为旧格式. 仅当您对 `Distributed` 表使用异步 `INSERT` 时, 此更改才相关. 在 20.3.3 版本中, 我们将引入一个设置, 允许您逐步启用新格式.
* 更改了突变命令的复制日志条目的格式. 在安装新版本之前, 您必须等待旧的突变处理.
* 实现简单的内存分析器, 在超过软分配限制 [#8765](https://github.com/ClickHouse/ClickHouse/pull/8765) ([Ivan](https:// github.com/abyss7)) [#9472](https://github.com/ClickHouse/ClickHouse/pull/9472) ([alexey-milovidov](https://github.com/alexey-milovidov)) 专栏 `system.trace_log` 的内容从 `timer_type` 重命名为 `trace_type`. 这将需要更改第三方性能分析和火焰图处理工具.
* 在任何地方使用 OS 线程 id 而不是内部线程号. 这修复了 [#7477](https://github.com/ClickHouse/ClickHouse/issues/7477) 当启用设置 `send_logs_level` 时, 旧的 `clickhouse-client` 无法接收从服务器发送的日志, 因为名称和结构化日志消息的类型已更改. 另一方面, 不同的服务器版本可以相互发送不同类型的日志. 当你不使用 `send_logs_level` 设置时, 你应该不在乎. [#8954](https://github.com/ClickHouse/ClickHouse/pull/8954) ([alexey-milovidov](https://github.com/alexey-milovidov))
* 移除 `indexHint` 函数. [#9542](https://github.com/ClickHouse/ClickHouse/pull/9542) ([alexey-milovidov](https://github.com/alexey-milovidov))
* 移除 `findClusterIndex`、`findClusterValue` 函数. 这修复了 [#8641](https://github.com/ClickHouse/ClickHouse/issues/8641). 如果您正在使用这些功能, 请发送电子邮件至 `clickhouse-feedback@yandex-team.com`. [#9543](https://github.com/ClickHouse/ClickHouse/pull/9543) ([alexey-milovidov](https://github.com/alexey-milovidov))
* 现在不允许使用 `SELECT` 子查询作为默认表达式创建列或添加列. [#9481](https://github.com/ClickHouse/ClickHouse/pull/9481) ([alesapin](https://github.com/alesapin))
* JOIN 中的子查询需要别名. [#9274](https://github.com/ClickHouse/ClickHouse/pull/9274) ([Artem Zuikov](https://github.com/4ertus2))
* 改进了 `ALTER MODIFY/ADD` 查询逻辑. 现在你不能在没有类型的情况下 `ADD` 列, `MODIFY` 默认表达式不会改变列的类型, `MODIFY` 类型不会丢失默认表达式值. 修复 [#8669](https://github.com/ClickHouse/ClickHouse/issues/8669). [#9227](https://github.com/ClickHouse/ClickHouse/pull/9227) ([alesapin](https://github.com/alesapin))
* 需要重新启动服务器以应用日志配置中的更改. 这是一个临时解决方法, 以避免服务器记录到已删除的日志文件的错误 (请参阅 [#8696](https://github.com/ClickHouse/ClickHouse/issues/8696)). [#8707](https://github.com/ClickHouse/ClickHouse/pull/8707) ([Alexander Kuzmenkov](https://github.com/akuzm))
* 默认情况下启用设置 `experimental_use_processors`. 此设置启用新查询管道的使用. 这是内部重构, 我们预计不会有明显的变化. 如果您会看到任何问题, 请将其设置为零. [#8768](https://github.com/ClickHouse/ClickHouse/pull/8768) ([alexey-milovidov](https://github.com/alexey-milovidov))

#### 新特征
* 添加 `Avro` 和 `AvroConfluent` 输入/输出格式. [#8571](https://github.com/ClickHouse/ClickHouse/pull/8571) ([Andrew Onyshchuk](https://github.com/oandrew)) [#8957](https://github.com/ClickHouse/ClickHouse/pull/8957) ([Andrew Onyshchuk](https://github.com/oandrew)) [#8717](https://github.com/ClickHouse/ClickHouse/pull/8717) ([alexey-milovidov](https://github.com/alexey-milovidov))
* `cache` 字典中过期键的多线程和非阻塞更新 (具有读取旧键的可选权限). [#8303](https://github.com/ClickHouse/ClickHouse/pull/8303) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov))
* 添加查询 `ALTER ... MATERIALIZE TTL`. 它运行突变, 强制通过 TTL 删除过期数据并重新计算有关 TTL 的所有部分的元信息. [#8775](https://github.com/ClickHouse/ClickHouse/pull/8775) ([Anton Popov](https://github.com/CurtizJ))
* 如果需要, 从 HashJoin 切换到 MergeJoin (在磁盘上). [#9082](https://github.com/ClickHouse/ClickHouse/pull/9082) ([Artem Zuikov](https://github.com/4ertus2))
* 为 `ALTER TABLE` 添加了 `MOVE PARTITION` 命令. [#4729](https://github.com/ClickHouse/ClickHouse/issues/4729) [#6168](https://github.com/ClickHouse/ClickHouse/pull/6168) ([Guillaume Tassery](https://github.com/YiuRULE))
* 即时从配置文件重新加载存储配置. [#8594](https://github.com/ClickHouse/ClickHouse/pull/8594) ([Vladimir Chebotarev](https://github.com/excitoon))
* 允许将 `storage_policy` 更改为不那么丰富的一个. [#8107](https://github.com/ClickHouse/ClickHouse/pull/8107) ([Vladimir Chebotarev](https://github.com/excitoon))
* 添加了对 S3 存储和表功能的通配符/通配符的支持. [#8851](https://github.com/ClickHouse/ClickHouse/pull/8851) ([Vladimir Chebotarev](https://github.com/excitoon))
* 为 `FixedString(N)` 数据类型实现 `bitAnd`、`bitOr`、`bitXor`、`bitNot`. [#9091](https://github.com/ClickHouse/ClickHouse/pull/9091) ([Guillaume Tassery](https://github.com/YiuRULE))
* 添加函数 `bitCount` . 这修复了 [#8702](https://github.com/ClickHouse/ClickHouse/issues/8702). [#8708](https://github.com/ClickHouse/ClickHouse/pull/8708) ([alexey-milovidov](https://github.com/alexey-milovidov)) [#8749](https://github.com/ClickHouse/ClickHouse/pull/8749) ([ikopylov](https://github.com/ikopylov))
* 添加 `generateRandom` 表函数以生成具有给定模式的随机行. 允许用数据填充任意测试表. [#8994](https://github.com/ClickHouse/ClickHouse/pull/8994) ([Ilya Yatsishin](https://github.com/qoega))
* `JSONEachRowFormat`: 当对象包含在顶级数组中时支持特殊情况. [#8860](https://github.com/ClickHouse/ClickHouse/pull/8860) ([Kruglov Pavel](https://github.com/Avogar))
* 现在可以使用 `DEFAULT` 表达式创建一个列, 该列依赖于具有默认 `ALIAS` 表达式的列. [#9489](https://github.com/ClickHouse/ClickHouse/pull/9489) ([alesapin](https://github.com/alesapin))
* 允许在 `clickhouse-obfuscator` 中指定大于源数据大小的 `--limit`. 数据将用不同的随机种子重复. [#9155](https://github.com/ClickHouse/ClickHouse/pull/9155) ([alexey-milovidov](https://github.com/alexey-milovidov))
* 添加了带有储层采样算法的 `groupArraySample` 函数 (类似于 `group Array` ). [#8286](https://github.com/ClickHouse/ClickHouse/pull/8286) ([Amos Bird](https://github.com/amosbird))
* 现在您可以通过系统指标监控 `cache`/`complex_key_cache` 字典中更新队列的大小. [#9413](https://github.com/ClickHouse/ClickHouse/pull/9413) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov))
* 允许使用 CRLF 作为 CSV 输出格式的行分隔符, 并将 `output_format_csv_crlf_end_of_line` 设置为 1 [#8934](https://github.com/ClickHouse/ClickHouse/pull/8934) [#8935](https://github.com/ClickHouse/ClickHouse/pull/8935) [#8963](https://github.com/ClickHouse/ClickHouse/pull/8963) ([Mikhail Korotov](https://github.com/millb))
* 实现[H3](https://github.com/uber/h3) API的更多功能: `h3GetBaseCell`、`h3HexAreaM2`、`h3IndexesAreNeighbors`、`h3ToChildren`、`h3ToString`和`stringToH3`. [#8938](https://github.com/ClickHouse/ClickHouse/pull/8938) ([Nico Mandery](https://github.com/nmandery))
* 引入了新设置: `max_parser_depth` 以控制最大堆栈大小并允许大型复杂查询. 这修复了 [#6681](https://github.com/ClickHouse/ClickHouse/issues/6681) 和 [#7668](https://github.com/ClickHouse/ClickHouse/issues/7668). [#8647](https://github.com/ClickHouse/ClickHouse/pull/8647) ([Maxim Smirnov](https://github.com/qMBQx8GH))
* 如果无法跳过未使用的分片, 则添加设置 `force_optimize_skip_unused_shards` 设置以抛出. [#8805](https://github.com/ClickHouse/ClickHouse/pull/8805) ([Azat Khuzhin](https://github.com/azat))
* 允许配置多个磁盘/卷来存储数据以在 `Distributed` 引擎中发送. [#8756](https://github.com/ClickHouse/ClickHouse/pull/8756) ([Azat Khuzhin](https://github.com/azat))
* 支持存储临时数据的存储策略 (`<tmp_policy>`). [#8750](https://github.com/ClickHouse/ClickHouse/pull/8750) ([Azat Khuzhin](https://github.com/azat))
* 添加了 `X-ClickHouse-Exception-Code` HTTP 标头, 如果在发送数据之前抛出异常, 则会设置该标头. 这实现了 [#4971](https://github.com/ClickHouse/ClickHouse/issues/4971). [#8786](https://github.com/ClickHouse/ClickHouse/pull/8786) ([Mikhail Korotov](https://github.com/millb))
* 添加函数 `ifNotFinite`. 它只是一个语法糖: `ifNotFinite(x, y) = isFinite(x) ? x : y`. [#8710](https://github.com/ClickHouse/ClickHouse/pull/8710) ([alexey-milovidov](https://github.com/alexey-milovidov))
* 在 `system.dictionaries` 表中添加了 `last_successful_update_time` 列. [#9394](https://github.com/ClickHouse/ClickHouse/pull/9394) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov))
* 添加 `blockSerializedSize` 函数 (未压缩的磁盘大小). [#8952](https://github.com/ClickHouse/ClickHouse/pull/8952) ([Azat Khuzhin](https://github.com/azat))
* 添加函数 `moduloOrZero`. [#9358](https://github.com/ClickHouse/ClickHouse/pull/9358) ([hcz](https://github.com/hczhcz))
* 添加了系统表`system.zeros` 和`system.zeros_mt` 以及故事函数`zeros()` 和`zeros_mt()`. 表 (和表函数) 包含名称为 `zero` 且类型为 `UInt8` 的单列. 此列包含零. 出于测试目的需要它作为生成多行的最快方法. 这修复了 [#6604](https://github.com/ClickHouse/ClickHouse/issues/6604) [#9593](https://github.com/ClickHouse/ClickHouse/pull/9593) ([Nikolai Kochetov](https://github.com/KochetovNicolai))

#### 实验功能
* 在`MergeTree`-family 表中添加新的零件紧凑格式, 其中所有列都存储在一个文件中. 它有助于提高小而频繁的插入的性能. 旧格式 (每列一个文件) 现在称为宽格式. 数据存储格式由设置 `min_bytes_for_wide_part` 和 `min_rows_for_wide_part` 控制. [#8290](https://github.com/ClickHouse/ClickHouse/pull/8290) ([Anton Popov](https://github.com/CurtizJ))
* 支持对 `Log`、`TinyLog` 和`StripeLog` 表的S3 存储. [#8862](https://github.com/ClickHouse/ClickHouse/pull/8862) ([Pavel Kovalenko](https://github.com/Jokser))

#### Bug 修复
* 修复了日志消息中不一致的空格. [#9322](https://github.com/ClickHouse/ClickHouse/pull/9322) ([alexey-milovidov](https://github.com/alexey-milovidov))
* 修复未命名元组数组在表创建时被展平为嵌套结构的错误. [#8866](https://github.com/ClickHouse/ClickHouse/pull/8866) ([achulkov2](https://github.com/achulkov2))
* 修复了 `File` 表或 `file` 表函数中匹配 glob 模式的文件过多时, 可能会出现 `Too many open files` 错误的问题. 现在文件被懒惰地打开. 这修复了 [#8857](https://github.com/ClickHouse/ClickHouse/issues/8857) [#8861](https://github.com/ClickHouse/ClickHouse/pull/8861) ([alexey-milovidov](https://github.com/alexey-milovidov))
* DROP TEMPORARY TABLE 现在只删除临时表. [#8907](https://github.com/ClickHouse/ClickHouse/pull/8907) ([Vitaly Baranov](https://github.com/vitlibar))
* 当我们关闭服务器或 DETACH/ATTACH 表时删除过时的分区. [#8602](https://github.com/ClickHouse/ClickHouse/pull/8602) ([Guillaume Tassery](https://github.com/YiuRULE))
* 关于默认磁盘如何计算 `data` 子目录中的可用空间. 修复了如果将 `data` 目录安装到单独的设备 (罕见情况), 则无法正确计算可用空间量的问题. 这修复了 [#7441](https://github.com/ClickHouse/ClickHouse/issues/7441) [#9257](https://github.com/ClickHouse/ClickHouse/pull/9257) ([Mikhail Korotov](https://github.com/millb))
* 允许逗号 (交叉) 与 IN() 内连接. [#9251](https://github.com/ClickHouse/ClickHouse/pull/9251) ([Artem Zuikov](https://github.com/4ertus2))
* 如果 WHERE 部分中有 [NOT] LIKE 运算符, 则允许将 CROSS 重写为 INNER JOIN. [#9229](https://github.com/ClickHouse/ClickHouse/pull/9229) ([Artem Zuikov](https://github.com/4ertus2))
* 在启用设置 `distributed_aggregation_memory_efficient` 的情况下修复` GROUP BY` 后可能出现的错误结果. 修复 [#9134](https://github.com/ClickHouse/ClickHouse/issues/9134). [#9289](https://github.com/ClickHouse/ClickHouse/pull/9289) ([Nikolai Kochetov](https://github.com/KochetovNicolai))
* 找到的键在缓存字典的度量中被计为遗漏. [#9411](https://github.com/ClickHouse/ClickHouse/pull/9411) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov))
* 修复 [#8598](https://github.com/ClickHouse/ClickHouse/issues/8598) 中引入的复制协议不兼容性. [#9412](https://github.com/ClickHouse/ClickHouse/pull/9412) ([alesapin](https://github.com/alesapin))
* 修复了 `ReplicatedMergeTree` 表启动时 `queue_task_handle` 上的竞争条件. [#9552](https://github.com/ClickHouse/ClickHouse/pull/9552) ([alexey-milovidov](https://github.com/alexey-milovidov))
* 令牌 `NOT` 在 `SHOW TABLES NOT LIKE` 查询中不起作用. [#8727](https://github.com/ClickHouse/ClickHouse/issues/8727) [#8940](https://github.com/ClickHouse/ClickHouse/pull/8940) ([alexey-milovidov](https://github.com/alexey-milovidov))
* 添加范围检查功能 `h3EdgeLengthM`. 如果没有这个检查, 缓冲区溢出是可能的. [#8945](https://github.com/ClickHouse/ClickHouse/pull/8945) ([alexey-milovidov](https://github.com/alexey-milovidov))
* 修复了多个参数 (超过 10 个) 的三元逻辑 OP 的批量计算中的错误. [#8718](https://github.com/ClickHouse/ClickHouse/pull/8718) ([Alexander Kazakov](https://github.com/Akazz))
* 修复 PREWHERE 优化错误，可能导致段错误或 `Inconsistent number of columns got from MergeTreeRangeReader` 异常. [#9024](https://github.com/ClickHouse/ClickHouse/pull/9024) ([Anton Popov](https://github.com/CurtizJ))
* 修复意外的 `Timeout exceeded while reading from socket` 异常, 该异常在实际超过超时之前和启用查询分析器时在安全连接上随机发生. 同时添加 `connect_timeout_with_failover_secure_ms`设置 (默认100ms), 与 `connect_timeout_with_failover_ms` 类似, 但用于安全连接 (因为SSL握手比普通TCP连接慢). [#9026](https://github.com/ClickHouse/ClickHouse/pull/9026) ([tavplubix](https://github.com/tavplubix))
* 修复突变终止的错误, 当突变可能挂在 `parts_to_do=0` 和 `is_done=0` 状态时. [#9022](https://github.com/ClickHouse/ClickHouse/pull/9022) ([alesapin](https://github.com/alesapin))
* 使用带有 `partial_merge_join` 设置的新 ANY JOIN 逻辑. 现在可以使用 `partial_merge_join=1` 进行 `ANY|ALL|SEMI LEFT` 和 `ALL INNER` 连接. [#8932](https://github.com/ClickHouse/ClickHouse/pull/8932) ([Artem Zuikov](https://github.com/4ertus2))
* 分片现在将从发起者获得的设置限制到分片的约束, 而不是抛出异常. 此修复允许将查询发送到具有其他约束的分片. [#9447](https://github.com/ClickHouse/ClickHouse/pull/9447) ([Vitaly Baranov](https://github.com/vitlibar))
* 修复了 `MergeTreeReadPool` 中的内存管理问题. [#8791](https://github.com/ClickHouse/ClickHouse/pull/8791) ([Vladimir Chebotarev](https://github.com/excitoon))
* 使用字符串 `e` 调用时修复 `toDecimal*OrNull()` 函数族. 修复[#8312](https://github.com/ClickHouse/ClickHouse/issues/8312) [#8764](https://github.com/ClickHouse/ClickHouse/pull/8764) ([Artem Zuikov](https://github.com/4ertus2))
* 确保 `FORMAT Null` 没有向客户端发送数据. [#8767](https://github.com/ClickHouse/ClickHouse/pull/8767) ([Alexander Kuzmenkov](https://github.com/akuzm))
* 修复 `LiveViewBlockInputStream` 中的时间戳不会更新的错误. `LIVE VIEW` 是一项实验性功能. [#8644](https://github.com/ClickHouse/ClickHouse/pull/8644) ([vxider](https://github.com/Vxider)) [#8625](https://github.com/ClickHouse/ClickHouse/pull/8625) ([vxider](https://github.com/Vxider))
* 修复了不允许删除旧 TTL 表达式的 `ALTER MODIFY TTL` 错误行为. [#8422](https://github.com/ClickHouse/ClickHouse/pull/8422) ([Vladimir Chebotarev](https://github.com/excitoon))
* 修复了 MergeTreeIndexSet 中的 UBSan 报告. 这修复了 [#9250](https://github.com/ClickHouse/ClickHouse/issues/9250) [#9365](https://github.com/ClickHouse/ClickHouse/pull/9365) ([alexey-milovidov](https://github.com/alexey-milovidov))
* 修复了当 haystack 有零字节时 `match` 和 `extract` 函数的行为. 当 haystack 不变时, 行为是错误的. 这修复了 [#9160](https://github.com/ClickHouse/ClickHouse/issues/9160) [#9163](https://github.com/ClickHouse/ClickHouse/pull/9163) ([alexey-milovidov](https://github.com/alexey-milovidov)) [#9345](https://github.com/ClickHouse/ClickHouse/pull/9345) ([alexey-milovidov](https://github.com/alexey-milovidov))
* 避免从 Apache Avro 3rd 方库中的析构函数抛出. [#9066](https://github.com/ClickHouse/ClickHouse/pull/9066) ([Andrew Onyshchuk](https://github.com/oandrew))
* 不要提交部分从 `Kafka` 轮询的批处理, 因为它可能导致数据漏洞. [#8876](https://github.com/ClickHouse/ClickHouse/pull/8876) ([filimonov](https://github.com/filimonov))
* 使用可为空的返回类型修复 `joinGet`. [#8919](https://github.com/ClickHouse/ClickHouse/issues/8919) [#9014](https://github.com/ClickHouse/ClickHouse/pull/9014) ([Amos Bird](https://github.com/amosbird))
* 修复使用 `T64`编解码器压缩时数据不兼容的问题. [#9016](https://github.com/ClickHouse/ClickHouse/pull/9016) ([Artem Zuikov](https://github.com/4ertus2)) 修复`T64`压缩编解码器中导致的数据类型ID 在受影响的版本中错误 (解) 压缩 [#9033](https://github.com/ClickHouse/ClickHouse/pull/9033) ([Artem Zuikov](https://github.com/4ertus2))
* 添加设置 `enable_early_constant_folding` 并在某些导致错误的情况下禁用它. [#9010](https://github.com/ClickHouse/ClickHouse/pull/9010) ([Artem Zuikov](https://github.com/4ertus2))
* 使用 VIEW 修复下推谓词优化器并启用测试. [#9011](https://github.com/ClickHouse/ClickHouse/pull/9011) ([Winter Zhang](https://github.com/zhang2014))
* 修复 `Merge` 表中的段错误, 这在从 `File` 存储读取时可能发生. [#9387](https://github.com/ClickHouse/ClickHouse/pull/9387) ([tavplubix](https://github.com/tavplubix))
* 在 `ATTACH PARTITION FROM`、`REPLACE PARTITION`、`MOVE TO TABLE`中添加了对存储策略的检查. 否则会导致重启后部分数据无法访问, 导致ClickHouse无法启动. [#9383](https://github.com/ClickHouse/ClickHouse/pull/9383) ([Vladimir Chebotarev](https://github.com/excitoon))
* 如果为表设置了 TTL, 则修复更改. [#8800](https://github.com/ClickHouse/ClickHouse/pull/8800) ([Anton Popov](https://github.com/CurtizJ))
* 修复在修改/添加/删除某些字典时执行 `SYSTEM RELOAD ALL DICTIONARIES` 时可能发生的竞争条件. [#8801](https://github.com/ClickHouse/ClickHouse/pull/8801) ([Vitaly Baranov](https://github.com/vitlibar))
* 在以前的版本 `Memory` 数据库引擎使用空数据路径, 所以表在 `path `目录 (例如 `/var/lib/clickhouse/`) 中创建, 而不是在数据库的数据目录中 (例如. `/var/lib/clickhouse/db_name`). [#8753](https://github.com/ClickHouse/ClickHouse/pull/8753) ([tavplubix](https://github.com/tavplubix))
* 修复了有关缺少默认磁盘或策略的错误日志消息. [#9530](https://github.com/ClickHouse/ClickHouse/pull/9530) ([Vladimir Chebotarev](https://github.com/excitoon))
* 修复 not(has()) 数组类型的bloom_filter索引. [#9407](https://github.com/ClickHouse/ClickHouse/pull/9407) ([achimbab](https://github.com/achimbab))
* 允许带有 `Log` 引擎的表中的第一列作为别名 [#9231](https://github.com/ClickHouse/ClickHouse/pull/9231) ([Ivan](https://github.com/abyss7))
* 在一个线程中从 `MergeTree` 表读取时修复范围的顺序. 它可能导致 `MergeTreeRangeReader` 的异常或错误的查询结果. [#9050](https://github.com/ClickHouse/ClickHouse/pull/9050) ([Anton Popov](https://github.com/CurtizJ))
* 使 `reinterpretAsFixedString` 返回 `FixedString` 而不是 `String`. [#9052](https://github.com/ClickHouse/ClickHouse/pull/9052) ([Andrew Onyshchuk](https://github.com/oandrew))
* 避免极少数情况下用户可能会收到错误的错误消息 (`Success`而不是详细的错误描述). [#9457](https://github.com/ClickHouse/ClickHouse/pull/9457) ([alexey-milovidov](https://github.com/alexey-milovidov))
* 使用带有空行模板的 `Template` 格式时不会崩溃. [#8785](https://github.com/ClickHouse/ClickHouse/pull/8785) ([Alexander Kuzmenkov](https://github.com/akuzm))
* 系统表的元数据文件可能创建在错误的位置 [#8653](https://github.com/ClickHouse/ClickHouse/pull/8653) ([tavplubix](https://github.com/tavplubix)) Fixes [#8581](https://github.com/ClickHouse/ClickHouse/issues/8581).
* 修复缓存字典中 exception_ptr 的数据竞争 [#8303](https://github.com/ClickHouse/ClickHouse/issues/8303). [#9379](https://github.com/ClickHouse/ClickHouse/pull/9379) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov))
* 不要为查询 `ATTACH TABLE IF NOT EXISTS` 抛出异常. 以前, 如果表已经存在, 则抛出它, 尽管有 `IF NOT EXISTS` 子句. [#8967](https://github.com/ClickHouse/ClickHouse/pull/8967) ([Anton Popov](https://github.com/CurtizJ))
* 修复了异常消息中缺少关闭括号的问题. [#8811](https://github.com/ClickHouse/ClickHouse/pull/8811) ([alexey-milovidov](https://github.com/alexey-milovidov))
* 在交互模式下启动 clickhouse-client 时避免消息 `Possible deadlock avoid` . [#9455](https://github.com/ClickHouse/ClickHouse/pull/9455) ([alexey-milovidov](https://github.com/alexey-milovidov))
* 修复了 base64 编码值末尾填充可能格式错误的问题. 更新 base64 库. 这修复了 [#9491](https://github.com/ClickHouse/ClickHouse/issues/9491), closes [#9492](https://github.com/ClickHouse/ClickHouse/issues/9492) [#9500](https://github.com/ClickHouse/ClickHouse/pull/9500) ([alexey-milovidov](https://github.com/alexey-milovidov))
* 在读取后缀之后但提交之前发生异常时, 在极少数情况下防止在 `Kafka` 中丢失数据. 修复 [#9378](https://github.com/ClickHouse/ClickHouse/issues/9378) [#9507](https://github.com/ClickHouse/ClickHouse/pull/9507) ([filimonov](https://github.com/filimonov))
* 修复了`DROP TABLE IF EXISTS` 中的异常. [#8663](https://github.com/ClickHouse/ClickHouse/pull/8663) ([Nikita Vasilev](https://github.com/nikvas0))
* 修复当用户尝试为旧格式的 `MergeTree` 表引擎系列 `ALTER MODIFY SETTING` 时崩溃. [#9435](https://github.com/ClickHouse/ClickHouse/pull/9435) ([alesapin](https://github.com/alesapin))
* 支持 JSON 相关函数中不适合 Int64 的 UInt64 数字. 将 SIMDJSON 更新为 master. 这修复了[#9209](https://github.com/ClickHouse/ClickHouse/issues/9209) [#9344](https://github.com/ClickHouse/ClickHouse/pull/9344) ([alexey-milovidov](https://github.com/alexey-milovidov))
* 修复了使用非严格单调函数索引时反向谓词的执行. [#9223](https://github.com/ClickHouse/ClickHouse/pull/9223) ([Alexander Kazakov](https://github.com/Akazz))
* 不要尝试在 `GROUP BY` 中折叠 `IN` 常量. [#8868](https://github.com/ClickHouse/ClickHouse/pull/8868) ([Amos Bird](https://github.com/amosbird))
* 修复 `ALTER DELETE` 突变中导致索引损坏的错误. 这修复了 [#9019](https://github.com/ClickHouse/ClickHouse/issues/9019) and [#8982](https://github.com/ClickHouse/ClickHouse/issues/8982). Additionally fix extremely rare race conditions in `ReplicatedMergeTree` `ALTER` queries. [#9048](https://github.com/ClickHouse/ClickHouse/pull/9048) ([alesapin](https://github.com/alesapin))
* 当设置 `compile_expressions` 启用时，当我们使用 `Nullable` 类型时，你会在 `LLVMExecutableFunction` 中得到 `unexpected column`. [#8910](https://github.com/ClickHouse/ClickHouse/pull/8910) ([Guillaume Tassery](https://github.com/YiuRULE))
* `Kafka` 引擎的多项修复: 1) 修复在消费者组重新平衡期间出现的重复项. 2) 修复了当数据从多个分区轮询一次轮询并部分提交时出现的罕见 `holes` (现在我们总是处理/提交整个轮询的消息块). 3) 按块大小修复刷新 (在此之前, 只有超时刷新才能正常工作). 4) 更好的订阅程序 (带有分配反馈). 5) 使测试工作更快 (使用默认间隔和超时). 由于数据之前没有按块大小刷新 (根据文档应该如此), 该 PR 可能会导致默认设置的性能下降 (由于更频繁和更小的刷新不是最佳的). 如果您在更改后遇到性能问题 - 请将表中的 `kafka_max_block_size` 增加到更大的值 (例如 `CREATE TABLE ...Engine=Kafka ... SETTINGS ... kafka_max_block_size=524288`). 修复 [#7259](https://github.com/ClickHouse/ClickHouse/issues/7259) [#8917](https://github.com/ClickHouse/ClickHouse/pull/8917) ([filimonov](https://github.com/filimonov))
* 修复 PREWHERE 优化后某些查询中的 `Parameter out of bound` 异常. [#8914](https://github.com/ClickHouse/ClickHouse/pull/8914) ([Baudouin Giard](https://github.com/bgiard))
* 修复了函数 `arrayZip` 的参数混合常量的情况. [#8705](https://github.com/ClickHouse/ClickHouse/pull/8705) ([alexey-milovidov](https://github.com/alexey-milovidov))
* 执行 `CREATE` 查询时，在存储引擎参数中折叠常量表达式. 用当前数据库替换空数据库名称. 修复 [#6508](https://github.com/ClickHouse/ClickHouse/issues/6508), [#3492](https://github.com/ClickHouse/ClickHouse/issues/3492) [#9262](https://github.com/ClickHouse/ClickHouse/pull/9262) ([tavplubix](https://github.com/tavplubix))
* 现在无法创建或添加具有简单循环别名的列, 例如 `a DEFAULT b, b DEFAULT a`. [#9603](https://github.com/ClickHouse/ClickHouse/pull/9603) ([alesapin](https://github.com/alesapin))
* 修复了可能会损坏原始部分的双重移动错误。 如果您使用 `ALTER TABLE MOVE`, 这是相关的. [#8680](https://github.com/ClickHouse/ClickHouse/pull/8680) ([Vladimir Chebotarev](https://github.com/excitoon))
* 允许 `interval` 标识符正确解析而无需反引号. 修复了即使 `interval` 标识符包含在反引号或双引号中也无法执行查询的问题. 这修复了 [#9124](https://github.com/ClickHouse/ClickHouse/issues/9124). [#9142](https://github.com/ClickHouse/ClickHouse/pull/9142) ([alexey-milovidov](https://github.com/alexey-milovidov))
* 修复了 `bitTestAll`/`bitTestAny` 函数的模糊测试和错误行为. [#9143](https://github.com/ClickHouse/ClickHouse/pull/9143) ([alexey-milovidov](https://github.com/alexey-milovidov))
* 当有很多行等于第 n 行时, 修复 `LIMIT n WITH TIES` 中可能的崩溃/错误的行数. [#9464](https://github.com/ClickHouse/ClickHouse/pull/9464) ([tavplubix](https://github.com/tavplubix))
* 修复使用启用的 `insert_quorum` 编写的部分的突变. [#9463](https://github.com/ClickHouse/ClickHouse/pull/9463) ([alesapin](https://github.com/alesapin))
* 修复 `Poco::HTTPServer` 破坏时的数据竞争. 当服务器启动并立即关闭时可能会发生这种情况 [#9468](https://github.com/ClickHouse/ClickHouse/pull/9468) ([Anton Popov](https://github.com/CurtizJ))
* 修复运行 `SHOW CREATE TABLE a_table_that_does_not_exist` 时显示误导性错误消息的错误. [#8899](https://github.com/ClickHouse/ClickHouse/pull/8899) ([achulkov2](https://github.com/achulkov2))
* 当我们有一个 ORDER BY 和一个 LIMIT 子句时, 当我们在 SELECT 子句中有一个常量时, 在一些罕见的情况下修复了 `Parameters is out of bound` 异常. [#8892](https://github.com/ClickHouse/ClickHouse/pull/8892) ([Guillaume Tassery](https://github.com/YiuRULE))
* 修复突变完成, 当已经完成突变时, 可以有状态`is_done=0`. [#9217](https://github.com/ClickHouse/ClickHouse/pull/9217) ([alesapin](https://github.com/alesapin))
* 防止使用旧语法对 MergeTree 表执行 `ALTER ADD INDEX` , 因为它不起作用. [#8822](https://github.com/ClickHouse/ClickHouse/pull/8822) ([Mikhail Korotov](https://github.com/millb))
* 在服务器启动期间不要访问 `LIVE VIEW` 所依赖的表, 因此服务器将能够启动. 分离 `LIVE VIEW` 时也要删除 `LIVE VIEW` 依赖项. `LIVE VIEW` 是一项实验性功能. [#8824](https://github.com/ClickHouse/ClickHouse/pull/8824) ([tavplubix](https://github.com/tavplubix))
* 修复了在执行 PREWHERE 时在 MergeTreeRangeReader 中可能出现的段错误. [#9106](https://github.com/ClickHouse/ClickHouse/pull/9106) ([Anton Popov](https://github.com/CurtizJ))
* 使用列 TTL 修复可能不匹配的校验和. [#9451](https://github.com/ClickHouse/ClickHouse/pull/9451) ([Anton Popov](https://github.com/CurtizJ))
* 修复了在只有一个卷的情况下部件不会通过 TTL 规则在后台移动的错误. [#8672](https://github.com/ClickHouse/ClickHouse/pull/8672) ([Vladimir Chebotarev](https://github.com/excitoon))
* 修复了 `Method createColumn() is not implemented for data type Set` 实现的问题. 这修复了 [#7799](https://github.com/ClickHouse/ClickHouse/issues/7799). [#8674](https://github.com/ClickHouse/ClickHouse/pull/8674) ([alexey-milovidov](https://github.com/alexey-milovidov))
* 现在我们将尝试更频繁地完成突变. [#9427](https://github.com/ClickHouse/ClickHouse/pull/9427) ([alesapin](https://github.com/alesapin))
* 通过减去一个常量来修复 `intDiv`. [#9351](https://github.com/ClickHouse/ClickHouse/pull/9351) ([hcz](https://github.com/hczhcz))
* 修复 `BlockIO` 中可能的竞争条件. [#9356](https://github.com/ClickHouse/ClickHouse/pull/9356) ([Nikolai Kochetov](https://github.com/KochetovNicolai))
* 修复在尝试使用/删除使用错误参数创建的 `Kafka` 表时导致服务器终止的错误. [#9513](https://github.com/ClickHouse/ClickHouse/pull/9513) ([filimonov](https://github.com/filimonov))
* 如果 OS 为 `timer_create` 函数返回错误结果, 则添加了解决方法. [#8837](https://github.com/ClickHouse/ClickHouse/pull/8837) ([alexey-milovidov](https://github.com/alexey-milovidov))
* 修复了使用 `min_marks_for_seek` 参数时的错误. 修复了分布式表中没有分片键并且我们尝试跳过未使用的分片时的错误消息. [#8908](https://github.com/ClickHouse/ClickHouse/pull/8908) ([Azat Khuzhin](https://github.com/azat))

#### 改进
* 在 `ReplicatedMergeTree*` 引擎系列的突变之上实施 `ALTER MODIFY/DROP` 查询. 现在 ALTERS 仅在元数据更新阶段阻塞, 之后不再阻塞. [#8701](https://github.com/ClickHouse/ClickHouse/pull/8701) ([alesapin](https://github.com/alesapin))
* 添加使用包含不合格名称的 `WHERE` 部分重写 CROSS 到 INNER JOIN 的能力. [#9512](https://github.com/ClickHouse/ClickHouse/pull/9512) ([Artem Zuikov](https://github.com/4ertus2))
* 使 `SHOW TABLES` 和 `SHOW DATABASES` 查询支持 `WHERE` 表达式和`FROM`/`IN`. [#9076](https://github.com/ClickHouse/ClickHouse/pull/9076) ([sundyli](https://github.com/sundy-li))
* 添加了一个设置 `deduplicate_blocks_in_dependent_materialized_views`. [#9070](https://github.com/ClickHouse/ClickHouse/pull/9070) ([urykhy](https://github.com/urykhy))
* 在最近的更改之后, MySQL 客户端开始以十六进制打印二进制字符串, 从而使它们不可读 ([#9032](https://github.com/ClickHouse/ClickHouse/issues/9032)). ClickHouse 中的解决方法是将字符串列标记为 UTF-8, 这并非总是如此, 但通常如此. [#9079](https://github.com/ClickHouse/ClickHouse/pull/9079) ([Yuriy Baranov](https://github.com/yurriy))
* 添加对 `sumMap` 的 String 和 FixedString 键的支持. [#8903](https://github.com/ClickHouse/ClickHouse/pull/8903) ([Baudouin Giard](https://github.com/bgiard))
* 支持 SummingMergeTree 映射中的字符串键. [#8933](https://github.com/ClickHouse/ClickHouse/pull/8933) ([Baudouin Giard](https://github.com/bgiard))
* 即使线程抛出异常, 也会向线程池发出线程终止信号. [#8736](https://github.com/ClickHouse/ClickHouse/pull/8736) ([Ding Xiang Fei](https://github.com/dingxiangfei2009))
* 允许在 `clickhouse-benchmark` 中设置 `query_id`. [#9416](https://github.com/ClickHouse/ClickHouse/pull/9416) ([Anton Popov](https://github.com/CurtizJ))
* 不允许在 `ALTER TABLE ... PARTITION partition` 查询中出现奇怪的表达式. 这个地址 [#7192](https://github.com/ClickHouse/ClickHouse/issues/7192) [#8835](https://github.com/ClickHouse/ClickHouse/pull/8835) ([alexey-milovidov](https://github.com/alexey-milovidov))
* 表 `system.table_engines` 现在提供有关功能支持的信息 (例如 `supports_ttl` 或 `supports_sort_order`). [#8830](https://github.com/ClickHouse/ClickHouse/pull/8830) ([Max Akhmedov](https://github.com/zlobober))
* 默认启用 `system.metric_log`. 它将包含具有 ProfileEvents 值的行, CurrentMetrics 以 `collect_interval_milliseconds` 间隔 (默认为一秒) 收集. 表很小 (通常以兆字节为单位), 默认收集这些数据是合理的. [#9225](https://github.com/ClickHouse/ClickHouse/pull/9225) ([alexey-milovidov](https://github.com/alexey-milovidov))
* Initialize query profiler for all threads in a group, e.g. it allows to fully profile insert-queries. Fixes [#6964](https://github.com/ClickHouse/ClickHouse/issues/6964) [#8874](https://github.com/ClickHouse/ClickHouse/pull/8874) ([Ivan](https://github.com/abyss7))
* 现在临时的 `LIVE VIEW` 是由 `CREATE LIVE VIEW name WITH TIMEOUT [42] ...` 创建的, 而不是 `CREATE TEMPORARY LIVE VIEW ...`, 因为之前的语法与 `CREATE TEMPORARY TABLE ...` 不一致. [#9131](https://github.com/ClickHouse/ClickHouse/pull/9131) ([tavplubix](https://github.com/tavplubix))
* 添加 text_log.level 配置参数以限制进入 `system.text_log` 表的条目. [#8809](https://github.com/ClickHouse/ClickHouse/pull/8809) ([Azat Khuzhin](https://github.com/azat))
* 允许根据 TTL 规则将下载的部分放入磁盘/卷. [#8598](https://github.com/ClickHouse/ClickHouse/pull/8598) ([Vladimir Chebotarev](https://github.com/excitoon))
* 对于外部 MySQL 字典, 允许相互化 MySQL 连接池以在字典之间 `share` 它们. 此选项显着减少了与 MySQL 服务器的连接数. [#9409](https://github.com/ClickHouse/ClickHouse/pull/9409) ([Clément Rodriguez](https://github.com/clemrodriguez))
* 在 `clickhouse-benchmark` 输出中显示分位数的最近查询执行时间, 而不是内插值. 最好显示与某些查询的执行时间相对应的值. [#8712](https://github.com/ClickHouse/ClickHouse/pull/8712) ([alexey-milovidov](https://github.com/alexey-milovidov))
* 将数据插入 Kafka 时，可以为消息添加密钥和时间戳. 修复 [#7198](https://github.com/ClickHouse/ClickHouse/issues/7198) [#8969](https://github.com/ClickHouse/ClickHouse/pull/8969) ([filimonov](https://github.com/filimonov))
* 如果服务器从终端运行, 则按颜色突出显示线程编号、查询 ID 和日志优先级. 这是为了提高开发人员对相关日志消息的可读性. [#8961](https://github.com/ClickHouse/ClickHouse/pull/8961) ([alexey-milovidov](https://github.com/alexey-milovidov))
* 加载 `Ordinary` 数据库表时更好的异常消息. [#9527](https://github.com/ClickHouse/ClickHouse/pull/9527) ([alexey-milovidov](https://github.com/alexey-milovidov))
* 为具有聚合函数状态的数组实现 `arraySlice`. 这修复了 [#9388](https://github.com/ClickHouse/ClickHouse/issues/9388) [#9391](https://github.com/ClickHouse/ClickHouse/pull/9391) ([alexey-milovidov](https://github.com/alexey-milovidov))
* 允许在 IN 运算符的右侧使用常量函数和常量数组. [#8813](https://github.com/ClickHouse/ClickHouse/pull/8813) ([Anton Popov](https://github.com/CurtizJ))
* 如果在为 system.replicas 获取数据时发生 zookeeper 异常, 则将其显示在单独的列中. 这实现了 [#9137](https://github.com/ClickHouse/ClickHouse/issues/9137) [#9138](https://github.com/ClickHouse/ClickHouse/pull/9138) ([alexey-milovidov](https://github.com/alexey-milovidov))
* 在销毁时原子地删除 MergeTree 数据部分. [#8402](https://github.com/ClickHouse/ClickHouse/pull/8402) ([Vladimir Chebotarev](https://github.com/excitoon))
* 支持分布式表的行级安全. [#8926](https://github.com/ClickHouse/ClickHouse/pull/8926) ([Ivan](https://github.com/abyss7))
* 现在我们在设置值中识别后缀 (如 KB、KiB...). [#8072](https://github.com/ClickHouse/ClickHouse/pull/8072) ([Mikhail Korotov](https://github.com/millb))
* 在构建大型 JOIN 的结果时防止内存不足. [#8637](https://github.com/ClickHouse/ClickHouse/pull/8637) ([Artem Zuikov](https://github.com/4ertus2))
* 在 `clickhouse-client` 中以交互模式向建议添加集群名称. [#8709](https://github.com/ClickHouse/ClickHouse/pull/8709) ([alexey-milovidov](https://github.com/alexey-milovidov))
* 为组中的所有线程初始化查询分析器, 例如它允许完全分析插入查询. [#8820](https://github.com/ClickHouse/ClickHouse/pull/8820) ([Ivan](https://github.com/abyss7))
* 在 `system.query_log` 表中添加了列 `exception_code`. [#8770](https://github.com/ClickHouse/ClickHouse/pull/8770) ([Mikhail Korotov](https://github.com/millb))
* 在默认服务器配置文件中的端口 `9004` 上启用 MySQL 兼容性服务器. 配置示例中的固定密码生成命令. [#8771](https://github.com/ClickHouse/ClickHouse/pull/8771) ([Yuriy Baranov](https://github.com/yurriy))
* 如果文件系统是只读的，则防止在关机时中止. 这修复了 [#9094](https://github.com/ClickHouse/ClickHouse/issues/9094) [#9100](https://github.com/ClickHouse/ClickHouse/pull/9100) ([alexey-milovidov](https://github.com/alexey-milovidov))
* 在 HTTP POST 查询中需要长度时更好的异常消息. [#9453](https://github.com/ClickHouse/ClickHouse/pull/9453) ([alexey-milovidov](https://github.com/alexey-milovidov))
* 将 `_path` 和 `_file` 虚拟列添加到 `HDFS` 和 `File` 引擎以及 `hdfs` 和 `file` 表函数. [#8489](https://github.com/ClickHouse/ClickHouse/pull/8489) ([Olga Khvostikova](https://github.com/stavrolia))
* 如果将新列添加到视图的内部表中，则在插入到 `MATERIALIZED VIEW` 时修复错误 `Cannot find column` . [#8766](https://github.com/ClickHouse/ClickHouse/pull/8766) [#8788](https://github.com/ClickHouse/ClickHouse/pull/8788) ([vzakaznikov](https://github.com/vzakaznikov)) [#8788](https://github.com/ClickHouse/ClickHouse/issues/8788) [#8806](https://github.com/ClickHouse/ClickHouse/pull/8806) ([Nikolai Kochetov](https://github.com/KochetovNicolai)) [#8803](https://github.com/ClickHouse/ClickHouse/pull/8803) ([Nikolai Kochetov](https://github.com/KochetovNicolai))
* 通过在最终更新 (如日志) 后发送进度来修复本地客户端 - 服务器协议的进度. 这可能仅与某些使用本机协议的第三方工具相关. [#9495](https://github.com/ClickHouse/ClickHouse/pull/9495) ([Azat Khuzhin](https://github.com/azat))
* 添加使用 MySQL 协议跟踪客户端连接数的系统指标. ([#9013](https://github.com/ClickHouse/ClickHouse/issues/9013)). [#9015](https://github.com/ClickHouse/ClickHouse/pull/9015) ([Eugene Klimov](https://github.com/Slach))
* 从现在开始, HTTP 响应将把 `X-ClickHouse-Timezone` 标头设置为 `SELECT timezone()` 将报告的相同时区值. [#9493](https://github.com/ClickHouse/ClickHouse/pull/9493) ([Denis Glazachev](https://github.com/traceon))

#### 性能改进
* 提高使用 IN 分析索引的性能. [#9261](https://github.com/ClickHouse/ClickHouse/pull/9261) ([Anton Popov](https://github.com/CurtizJ))
* 逻辑函数 + 代码清理中更简单、更高效的代码. [#8718](https://github.com/ClickHouse/ClickHouse/issues/8718) [#8728](https://github.com/ClickHouse/ClickHouse/pull/8728) ([Alexander Kazakov](https://github.com/Akazz))
* 通过使用 C++20 功能确保更严格的别名, 整体性能改进 (受影响查询的范围为 5%..200%). [#9304](https://github.com/ClickHouse/ClickHouse/pull/9304) ([Amos Bird](https://github.com/amosbird))
* 比较函数的内部循环更严格的别名. [#9327](https://github.com/ClickHouse/ClickHouse/pull/9327) ([alexey-milovidov](https://github.com/alexey-milovidov))
* 算术函数的内部循环更严格的别名. [#9325](https://github.com/ClickHouse/ClickHouse/pull/9325) ([alexey-milovidov](https://github.com/alexey-milovidov))
* ColumnVector::replicate() 的实现速度提高了约 3 倍, 通过它实现了 ColumnConst::convertToFullColumn(). 在实现常量的测试中也很有用. [#9293](https://github.com/ClickHouse/ClickHouse/pull/9293) ([Alexander Kazakov](https://github.com/Akazz))
* `ColumnVector::replicate()` 的另一个小性能改进 (这加速了 `materialize` 函数和高阶函数) . 进一步改进了 [#9293](https://github.com/ClickHouse/ClickHouse/issues/9293) [#9442](https://github.com/ClickHouse/ClickHouse/pull/9442) ([Alexander Kazakov](https://github.com/Akazz))
* 改进了 `stochasticLinearRegression` 聚合函数的性能. 此补丁由英特尔提供. [#8652](https://github.com/ClickHouse/ClickHouse/pull/8652) ([alexey-milovidov](https://github.com/alexey-milovidov))
* 提高 `reinterpretAsFixedString` 函数的性能. [#9342](https://github.com/ClickHouse/ClickHouse/pull/9342) ([alexey-milovidov](https://github.com/alexey-milovidov))
* Do not send blocks to client for `Null` format in processors pipeline. [#8797](https://github.com/ClickHouse/ClickHouse/pull/8797) ([Nikolai Kochetov](https://github.com/KochetovNicolai)) [#8767](https://github.com/ClickHouse/ClickHouse/pull/8767) ([Alexander Kuzmenkov](https://github.com/akuzm))

#### 构建/测试/打包改进
* 异常处理现在可以在适用于 Linux 的 Windows 子系统上正常工作. 参见 https://github.com/ClickHouse-Extras/libunwind/pull/3 . 这修复了 [#6480](https://github.com/ClickHouse/ClickHouse/issues/6480) [#9564](https://github.com/ClickHouse/ClickHouse/pull/9564) ([sobolevsv](https://github.com/sobolevsv))
* 将 `readline` 替换为 `replxx` 以在 `clickhouse-client` 中进行交互式行编辑. [#8416](https://github.com/ClickHouse/ClickHouse/pull/8416) ([Ivan](https://github.com/abyss7))
* FunctionsComparison 中更好的构建时间和更少的模板实例化. [#9324](https://github.com/ClickHouse/ClickHouse/pull/9324) ([alexey-milovidov](https://github.com/alexey-milovidov))
* 在 CI 中添加了与 `clang-tidy` 的集成. 另见 [#6044](https://github.com/ClickHouse/ClickHouse/issues/6044) [#9566](https://github.com/ClickHouse/ClickHouse/pull/9566) ([alexey-milovidov](https://github.com/alexey-milovidov))
* 现在我们在 CI 中使用 `lld` 链接 ClickHouse, 即使对于 `gcc`. [#9049](https://github.com/ClickHouse/ClickHouse/pull/9049) ([alesapin](https://github.com/alesapin))
* 允许在设置 `THREAD_FUZZER_*` 环境变量时随机化线程调度并插入故障. 这有助于测试. [#9459](https://github.com/ClickHouse/ClickHouse/pull/9459) ([alexey-milovidov](https://github.com/alexey-milovidov))
* 在无状态测试中启用安全套接字. [#9288](https://github.com/ClickHouse/ClickHouse/pull/9288) ([tavplubix](https://github.com/tavplubix))
* 使 SPLIT_SHARED_LIBRARIES=OFF 更健壮. [#9156](https://github.com/ClickHouse/ClickHouse/pull/9156) ([Azat Khuzhin](https://github.com/azat))
* 使 `performance_introspection_and_logging` 测试对随机服务器卡住是可靠的. 这可能发生在 CI 环境中. 另见 [#9515](https://github.com/ClickHouse/ClickHouse/issues/9515) [#9528](https://github.com/ClickHouse/ClickHouse/pull/9528) ([alexey-milovidov](https://github.com/alexey-milovidov))
* 在样式检查中验证 XML. [#9550](https://github.com/ClickHouse/ClickHouse/pull/9550) ([alexey-milovidov](https://github.com/alexey-milovidov))
* 修复了测试 `00738_lock_for_inner_table` 中的竞争条件. 这个测试依赖于睡眠. [#9555](https://github.com/ClickHouse/ClickHouse/pull/9555) ([alexey-milovidov](https://github.com/alexey-milovidov))
* 删除类型为 `once` 的性能测试. 这是在统计比较模式下运行所有性能测试所必需的 (更可靠). [#9557](https://github.com/ClickHouse/ClickHouse/pull/9557) ([alexey-milovidov](https://github.com/alexey-milovidov))
* 添加了算术函数的性能测试. [#9326](https://github.com/ClickHouse/ClickHouse/pull/9326) ([alexey-milovidov](https://github.com/alexey-milovidov))
* 增加了 `sumMap` 和 `summapwithverflow` 聚合函数的性能测试. 后续的 [#8933](https://github.com/ClickHouse/ClickHouse/issues/8933) [#8947](https://github.com/ClickHouse/ClickHouse/pull/8947) ([alexey-milovidov](https://github.com/alexey-milovidov))
* 通过样式检查确保错误代码的样式. [#9370](https://github.com/ClickHouse/ClickHouse/pull/9370) ([alexey-milovidov](https://github.com/alexey-milovidov))
* 为测试历史添加脚本. [#8796](https://github.com/ClickHouse/ClickHouse/pull/8796) ([alesapin](https://github.com/alesapin))
* 添加 GCC 警告 `-Wsuggest-override` 以定位和修复所有必须使用 `override` 关键字的地方. [#8760](https://github.com/ClickHouse/ClickHouse/pull/8760) ([kreuzerkrieg](https://github.com/kreuzerkrieg))
* 忽略 Mac OS X 下的弱符号，因为它必须被定义. [#9538](https://github.com/ClickHouse/ClickHouse/pull/9538) ([Deleted user](https://github.com/ghost))
* 在性能测试中规范一些查询的运行时间. 这样做是为了准备在比较模式下运行所有性能测试. [#9565](https://github.com/ClickHouse/ClickHouse/pull/9565) ([alexey-milovidov](https://github.com/alexey-milovidov))
* 修复一些测试以支持 pytest 与查询测试. [#9062](https://github.com/ClickHouse/ClickHouse/pull/9062) ([Ivan](https://github.com/abyss7))
* 使用 MSan 在构建中启用 SSL, 因此在运行无状态测试时服务器不会在启动时失败. [#9531](https://github.com/ClickHouse/ClickHouse/pull/9531) ([tavplubix](https://github.com/tavplubix))
* 修复测试结果中的数据库替换. [#9384](https://github.com/ClickHouse/ClickHouse/pull/9384) ([Ilya Yatsishin](https://github.com/qoega))
* 为其他平台构建修复. [#9381](https://github.com/ClickHouse/ClickHouse/pull/9381) ([proller](https://github.com/proller)) [#8755](https://github.com/ClickHouse/ClickHouse/pull/8755) ([proller](https://github.com/proller)) [#8631](https://github.com/ClickHouse/ClickHouse/pull/8631) ([proller](https://github.com/proller))
* 将磁盘部分添加到 stateless-with-coverage 测试 docker 映像. [#9213](https://github.com/ClickHouse/ClickHouse/pull/9213) ([Pavel Kovalenko](https://github.com/Jokser))
* 使用 GRPC 构建时摆脱源代码树文件. [#9588](https://github.com/ClickHouse/ClickHouse/pull/9588) ([Amos Bird](https://github.com/amosbird))
* 通过从上下文中删除 SessionCleaner, 可以稍微加快构建时间. 让SessionCleaner的代码更简单. [#9232](https://github.com/ClickHouse/ClickHouse/pull/9232) ([alexey-milovidov](https://github.com/alexey-milovidov))
* 更新了对 clickhouse-test 脚本中挂起查询的检查. [#8858](https://github.com/ClickHouse/ClickHouse/pull/8858) ([Alexander Kazakov](https://github.com/Akazz))
* 从存储库中删除了一些无用的文件. [#8843](https://github.com/ClickHouse/ClickHouse/pull/8843) ([alexey-milovidov](https://github.com/alexey-milovidov))
* 将数学性能测试的类型从 `once` 更改为 `loop` . [#8783](https://github.com/ClickHouse/ClickHouse/pull/8783) ([Nikolai Kochetov](https://github.com/KochetovNicolai))
* 添加 docker 图像，它允许为我们的代码库构建交互式代码浏览器 HTML 报告. [#8781](https://github.com/ClickHouse/ClickHouse/pull/8781) ([alesapin](https://github.com/alesapin)) See [Woboq Code Browser](https://clickhouse-test-reports.s3.yandex.net/codebrowser/html_report///ClickHouse/dbms/index.html)
* 抑制 MSan 下的一些测试失败. [#8780](https://github.com/ClickHouse/ClickHouse/pull/8780) ([Alexander Kuzmenkov](https://github.com/akuzm))
* 加速 `exception while insert` 测试. 此测试经常在 debug-with-coverage 构建中超时. [#8711](https://github.com/ClickHouse/ClickHouse/pull/8711) ([alexey-milovidov](https://github.com/alexey-milovidov))
* 将 `libcxx` 和 `libcxxabi` 更新为 master. 准备 [#9304](https://github.com/ClickHouse/ClickHouse/issues/9304) [#9308](https://github.com/ClickHouse/ClickHouse/pull/9308) ([alexey-milovidov](https://github.com/alexey-milovidov))
* 修复不稳定的测试 `00910_zookeeper_test_alter_compression_codecs`. [#9525](https://github.com/ClickHouse/ClickHouse/pull/9525) ([alexey-milovidov](https://github.com/alexey-milovidov))
* 清理重复的链接器标志. 确保链接器不会查找意外的符号. [#9433](https://github.com/ClickHouse/ClickHouse/pull/9433) ([Amos Bird](https://github.com/amosbird))
* 将 `clickhouse-odbc` 驱动程序添加到测试图像中. 这允许通过其自己的 ODBC 驱动程序测试 ClickHouse 与 ClickHouse 的交互. [#9348](https://github.com/ClickHouse/ClickHouse/pull/9348) ([filimonov](https://github.com/filimonov))
* 修复单元测试中的几个错误. [#9047](https://github.com/ClickHouse/ClickHouse/pull/9047) ([alesapin](https://github.com/alesapin))
* 启用 `-Wmissing-include-dirs` GCC 警告以消除所有不存在的包含 - 主要是由于 CMake 脚本错误. [#8704](https://github.com/ClickHouse/ClickHouse/pull/8704) ([kreuzerkrieg](https://github.com/kreuzerkrieg))
* 如果查询分析器无法工作, 请描述原因. 这适用于 [#9049](https://github.com/ClickHouse/ClickHouse/issues/9049) [#9144](https://github.com/ClickHouse/ClickHouse/pull/9144) ([alexey-milovidov](https://github.com/alexey-milovidov))
* 将 OpenSSL 更新为上游主服务器. 修复了 TLS 连接可能失败并显示消息 `OpenSSL SSL_read: error:14094438:SSLroutines:ssl3_read_bytes:tlsv1 alert internal error` 和 `SSL Exception: error:2400006E:random number generator::error retrieving entropy` 的问题. 该问题存在于 20.1 版中. [#8956](https://github.com/ClickHouse/ClickHouse/pull/8956) ([alexey-milovidov](https://github.com/alexey-milovidov))
* 更新服务器的 Dockerfile. [#8893](https://github.com/ClickHouse/ClickHouse/pull/8893) ([Ilya Mazaev](https://github.com/ne-ray))
* build-gcc-from-sources 脚本中的小修复. [#8774](https://github.com/ClickHouse/ClickHouse/pull/8774) ([Michael Nacharov](https://github.com/mnach))
* 在不使用 `number` 列的性能测试中, 将 `numbers` 替换为 `zeros`. 这将导致更干净的测试结果. [#9600](https://github.com/ClickHouse/ClickHouse/pull/9600) ([Nikolai Kochetov](https://github.com/KochetovNicolai))
* 修复在 Column 构造函数中使用 initializer_list 时的堆栈溢出问题. [#9367](https://github.com/ClickHouse/ClickHouse/pull/9367) ([Deleted user](https://github.com/ghost))
* 将 librdkafka 升级到 v1.3.0。 在 Mac OS X 上启用捆绑的 `rdkafka` 和 `gsasl` 库. [#9000](https://github.com/ClickHouse/ClickHouse/pull/9000) ([Andrew Onyshchuk](https://github.com/oandrew))
* 在 GCC 9.2.0 上构建修复. [#9306](https://github.com/ClickHouse/ClickHouse/pull/9306) ([vxider](https://github.com/Vxider))


## ClickHouse 版本 v20.1

### ClickHouse 版本 v20.1.16.120-stable 2020-60-26

#### Bug 修复

* 修复在 prewhere 条件下使用 `Nullable` 列导致的罕见崩溃. 续 [#11608](https://github.com/ClickHouse/ClickHouse/issues/11608). [#11869](https://github.com/ClickHouse/ClickHouse/pull/11869) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* 不允许在高阶函数中使用 arrayJoin. 它导致协议同步中断. 这关闭了 [#3933](https://github.com/ClickHouse/ClickHouse/issues/3933). [#11846](https://github.com/ClickHouse/ClickHouse/pull/11846) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 修复像 `SELECT *, xyz.*` 这样的查询的意外行为, 这些查询在预期错误时成功. [#11753](https://github.com/ClickHouse/ClickHouse/pull/11753) ([hexiaoting](https://github.com/hexiaoting)).
* 修复了由 Values 输入格式中复杂文字的错误类型推导导致的 LOGICAL_ERROR. [#11732](https://github.com/ClickHouse/ClickHouse/pull/11732) ([tavplubix](https://github.com/tavplubix)).
* 修复 `ORDER BY ... WITH FILL` 在 const 列上. [#11697](https://github.com/ClickHouse/ClickHouse/pull/11697) ([Anton Popov](https://github.com/CurtizJ)).
* 与 XDBC 桥通信时传递适当的超时. 最近在检查桥接活性和接收元信息时没有遵守超时. [#11690](https://github.com/ClickHouse/ClickHouse/pull/11690) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 添加对带有不区分大小写标志的正则表达式的支持. 这修复了 [#11101](https://github.com/ClickHouse/ClickHouse/issues/11101) and fixes [#11506](https://github.com/ClickHouse/ClickHouse/issues/11506). [#11649](https://github.com/ClickHouse/ClickHouse/pull/11649) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 修复字符串的布隆过滤器 (数据跳过索引). [#11638](https://github.com/ClickHouse/ClickHouse/pull/11638) ([Azat Khuzhin](https://github.com/azat)).
* 修复在 prewhere 条件下使用 `Nullable` 列导致的罕见崩溃. (可能它以某种方式与 [#11572](https://github.com/ClickHouse/ClickHouse/issues/11572) 相关联). [#11608](https://github.com/ClickHouse/ClickHouse/pull/11608) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* 修复 clickhouse-client 的错误退出代码, 当 exception.code() % 256 = 0 时. [#11601](https://github.com/ClickHouse/ClickHouse/pull/11601) ([filimonov](https://github.com/filimonov)).
* 修复服务器启动时有关 `Mark cache size was lowered` 的日志消息中的小错误. 这将关闭 [#11399](https://github.com/ClickHouse/ClickHouse/issues/11399). [#11589](https://github.com/ClickHouse/ClickHouse/pull/11589) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 现在 clickhouse-server docker 容器将更喜欢 IPv6 检查服务器活动性. [#11550](https://github.com/ClickHouse/ClickHouse/pull/11550) ([Ivan Starkov](https://github.com/istarkov)).
* 使用 -State 函数在聚合过程中抛出异常时修复内存泄漏. 这修复了 [#8995](https://github.com/ClickHouse/ClickHouse/issues/8995). [#11496](https://github.com/ClickHouse/ClickHouse/pull/11496) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 修复了使用 `FINAL` 修饰符和 `ORDER BY` 优化包装到函数中的主键的使用. [#10715](https://github.com/ClickHouse/ClickHouse/pull/10715) ([Anton Popov](https://github.com/CurtizJ)).


### ClickHouse 版本 v20.1.15.109-stable 2020-06-19

#### Bug 修复

* 在更改期间修复结构的多余锁定. [#11790](https://github.com/ClickHouse/ClickHouse/pull/11790) ([alesapin](https://github.com/alesapin)).


### ClickHouse 版本 v20.1.14.107-stable 2020-06-11

#### Bug 修复

* 修复错误 `Size of offsets does not match size of column` , 用于查询中的 `PREWHERE column in (subquery)` 和 `ARRAY JOIN` . [#11580](https://github.com/ClickHouse/ClickHouse/pull/11580) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).


### ClickHouse 版本 v20.1.13.105-stable 2020-06-10

#### Bug 修复

* 修复了在启用 `min_bytes_to_use_direct_io` 且 PREWHERE 处于活动状态并使用 SAMPLE 或大量线程时可能发生的 `Data compressed with different methods` 错误. 这修复了 [#11539](https://github.com/ClickHouse/ClickHouse/issues/11539). [#11540](https://github.com/ClickHouse/ClickHouse/pull/11540) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 修复编解码器的返回压缩大小. [#11448](https://github.com/ClickHouse/ClickHouse/pull/11448) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* 修复了当列具有非文字参数的压缩编解码器时服务器崩溃的问题.修复 [#11365](https://github.com/ClickHouse/ClickHouse/issues/11365). [#11431](https://github.com/ClickHouse/ClickHouse/pull/11431) ([alesapin](https://github.com/alesapin)).
* 以 nan 为点修复 pointInPolygon. 修复 [#11375](https://github.com/ClickHouse/ClickHouse/issues/11375). [#11421](https://github.com/ClickHouse/ClickHouse/pull/11421) ([Alexey Ilyukhov](https://github.com/livace)).
* 修复了带有纬度/经度范围之外的参数的 geohashesInBox. [#11403](https://github.com/ClickHouse/ClickHouse/pull/11403) ([Vasily Nemkov](https://github.com/Enmk)).
* 修复具有外部排序和限制的查询可能出现的 `Pipeline stuck` 错误. 修复 [#11359](https://github.com/ClickHouse/ClickHouse/issues/11359). [#11366](https://github.com/ClickHouse/ClickHouse/pull/11366) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* 修复 `quantilesExactWeightedArray` 中的崩溃问题. [#11337](https://github.com/ClickHouse/ClickHouse/pull/11337) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* 通过再次设置 `parallel_view_processing = 1` 并行写入 `MATERIALIZED VIEW` . 修复 [#10241](https://github.com/ClickHouse/ClickHouse/issues/10241). [#11330](https://github.com/ClickHouse/ClickHouse/pull/11330) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* 当提取的 JSON 具有不平衡的 { 或 [ 字符串时, 修复visitParamExtractRaw. [#11318](https://github.com/ClickHouse/ClickHouse/pull/11318) ([Ewout](https://github.com/devwout)).
* 修复 ThreadPool 中非常罕见的竞争条件. [#11314](https://github.com/ClickHouse/ClickHouse/pull/11314) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 修复转换中潜在的未初始化内存. 示例: `SELECT toIntervalSecond(now64())`. [#11311](https://github.com/ClickHouse/ClickHouse/pull/11311) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 修复了如果表的主键中有 Array 列并且查询正在使用 `empty` 或 `notEmpty` 函数按此列过滤时索引分析无法工作的问题. 这修复了 [#11286](https://github.com/ClickHouse/ClickHouse/issues/11286). [#11303](https://github.com/ClickHouse/ClickHouse/pull/11303) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 修复当查询速度估计可能不正确时的错误, 并且如果查询受到 `max_network_bandwidth`、`max_execution_speed` 或 `priority` 设置的限制，`min_execution_speed` 的限制可能无法工作或无法正常工作. 将 `timeout_before_checking_execution_speed` 的默认值更改为非零值, 否则设置 `min_execution_speed` 和 `max_execution_speed` 无效. 这修复了 [#11297](https://github.com/ClickHouse/ClickHouse/issues/11297). 这修复了 [#5732](https://github.com/ClickHouse/ClickHouse/issues/5732). 这修复了 [#6228](https://github.com/ClickHouse/ClickHouse/issues/6228). 可用性改进: 避免在 `clickhouse-client` 中将异常消息与进度条串联. [#11296](https://github.com/ClickHouse/ClickHouse/pull/11296) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 修复读取 Protobuf 格式错误数据时崩溃的问题. 这修复了 [#5957](https://github.com/ClickHouse/ClickHouse/issues/5957), 修复了 [#11203](https://github.com/ClickHouse/ClickHouse/issues/11203). [#11258](https://github.com/ClickHouse/ClickHouse/pull/11258) ([Vitaly Baranov](https://github.com/vitlibar)).
* 使用 `Array(Array(LowCardinality))` 捕获参数修复高阶函数的可能错误 `Cannot capture column` . [#11185](https://github.com/ClickHouse/ClickHouse/pull/11185) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* 如果数据跳过索引依赖于将在后台合并期间修改的列 (对于 SummingMergeTree、AggregatingMergeTree 以及 TTL GROUP BY), 则计算错误. 此问题已通过合并后移动索引计算得到修复, 因此索引是在合并数据上计算的. [#11162](https://github.com/ClickHouse/ClickHouse/pull/11162) ([Azat Khuzhin](https://github.com/azat)).
* 如果没有最终确定，则从突变终止任务中删除日志记录. [#11109](https://github.com/ClickHouse/ClickHouse/pull/11109) ([alesapin](https://github.com/alesapin)).
* 修复了 parseDateTime64BestEffort 参数解析错误. [#10925](https://github.com/ClickHouse/ClickHouse/issues/10925). [#11038](https://github.com/ClickHouse/ClickHouse/pull/11038) ([Vasily Nemkov](https://github.com/Enmk)).
* 修复方法 getRawData() 中不正确的原始数据大小. [#10964](https://github.com/ClickHouse/ClickHouse/pull/10964) ([Igr](https://github.com/ObjatieGroba)).
* 修复与分布式表中元组的向后兼容性. [#10889](https://github.com/ClickHouse/ClickHouse/pull/10889) ([Anton Popov](https://github.com/CurtizJ)).
* 修复 StringHashTable 中的 SIGSEGV (如果这样的键不存在). [#10870](https://github.com/ClickHouse/ClickHouse/pull/10870) ([Azat Khuzhin](https://github.com/azat)).
* 修复了 `ReplicatedMergeTree` 中的错误, 该错误可能导致 `OPTIMIZE` 查询上的某些 `ALTER` 在它变为非活动状态后挂起等待某些副本. [#10849](https://github.com/ClickHouse/ClickHouse/pull/10849) ([tavplubix](https://github.com/tavplubix)).
* 在 Block::sortColumns() 之后修复列顺序 (还添加了一个测试，表明它会影响一些实际用例 - 缓冲区引擎). [#10826](https://github.com/ClickHouse/ClickHouse/pull/10826) ([Azat Khuzhin](https://github.com/azat)).
* 修复 ODBC 桥在不要求引用标识符时的问题. 这修复了[#7984](https://github.com/ClickHouse/ClickHouse/issues/7984). [#10821](https://github.com/ClickHouse/ClickHouse/pull/10821) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 修复 DateLUT 中的 UBSan 和 MSan 报告. [#10798](https://github.com/ClickHouse/ClickHouse/pull/10798) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* - 在关键条件下使用 `src_type` 进行正确的类型转换. 修复[#6287](https://github.com/ClickHouse/ClickHouse/issues/6287). [#10791](https://github.com/ClickHouse/ClickHouse/pull/10791) ([Andrew Onyshchuk](https://github.com/oandrew)).
* 修复 `parallel_view_processing` 行为. 现在, 如果发生异常, 所有对 `MATERIALIZED VIEW` 的插入都应该无一例外地完成. 修复 [#10241](https://github.com/ClickHouse/ClickHouse/issues/10241). [#10757](https://github.com/ClickHouse/ClickHouse/pull/10757) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* 与 -State 结合时修复组合器 -OrNull 和 -OrDefault. [#10741](https://github.com/ClickHouse/ClickHouse/pull/10741) ([hcz](https://github.com/hczhcz)).
* 修复消失的总数. 如果查询具有连接或具有外部 where 条件的子查询, 则总计可能已被过滤. 修复 [#10674](https://github.com/ClickHouse/ClickHouse/issues/10674). [#10698](https://github.com/ClickHouse/ClickHouse/pull/10698) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* 在一个查询中使用相同的集合修复 `IN` 运算符的多次使用. [#10686](https://github.com/ClickHouse/ClickHouse/pull/10686) ([Anton Popov](https://github.com/CurtizJ)).
* 修复 AggregateTransform 构造函数中参数的顺序. [#10667](https://github.com/ClickHouse/ClickHouse/pull/10667) ([palasonic1](https://github.com/palasonic1)).
* 修复启用了 `distributed_aggregation_memory_efficient` 的远程查询缺乏并行执行的问题. 修复[#10655](https://github.com/ClickHouse/ClickHouse/issues/10655). [#10664](https://github.com/ClickHouse/ClickHouse/pull/10664) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* 修复分布式查询的谓词优化 (`enable_optimize_predicate_expression=1`) 对于带有 `HAVING` 部分的查询 (即需要在服务器启动器上进行过滤时), 通过保留表达式的顺序 (这足以修复), 并且还强制 聚合器在索引上使用列名. 修复: [#10613](https://github.com/ClickHouse/ClickHouse/issues/10613), [#11413](https://github.com/ClickHouse/ClickHouse/issues/11413). [#10621](https://github.com/ClickHouse/ClickHouse/pull/10621) ([Azat Khuzhin](https://github.com/azat)).
* 修复错误 `the BloomFilter false positive must be a double number between 0 and 1`. [#10551](https://github.com/ClickHouse/ClickHouse/issues/10551). [#10569](https://github.com/ClickHouse/ClickHouse/pull/10569) ([Winter Zhang](https://github.com/zhang2014)).
* 修复 SELECT 列 ALIAS 的默认表达式类型与列类型不同. [#10563](https://github.com/ClickHouse/ClickHouse/pull/10563) ([Azat Khuzhin](https://github.com/azat)).
* 实现了 DateTime64 和 String 值之间的比较 (就像 DateTime 一样). [#10560](https://github.com/ClickHouse/ClickHouse/pull/10560) ([Vasily Nemkov](https://github.com/Enmk)).


### ClickHouse 版本 v20.1.12.86, 2020-05-26

#### Bug 修复

* 修复了 20.1 及更早版本之间两级聚合的不兼容问题. 当在发起节点和远程节点上使用不同版本的 ClickHouse 并且 GROUP BY 结果的大小很大并且由单个 String 字段执行聚合时, 就会发生这种不兼容. 结果导致单个键的多个未合并的行. [#10952](https://github.com/ClickHouse/ClickHouse/pull/10952) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 修复了合并后可能发生的 `SummingMergeTree` 中 `LowCardinality(FixedString)` 键列的数据损坏. 修复[#10489](https://github.com/ClickHouse/ClickHouse/issues/10489). [#10721](https://github.com/ClickHouse/ClickHouse/pull/10721) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* 修复了当 `readonly=2` 和 `cancel_http_readonly_queries_on_client_close=1` 时导致 http 请求卡在客户端关闭的错误. 修复 [#7939](https://github.com/ClickHouse/ClickHouse/issues/7939), [#7019](https://github.com/ClickHouse/ClickHouse/issues/7019), [#7736](https://github.com/ClickHouse/ClickHouse/issues/7736), [#7091](https://github.com/ClickHouse/ClickHouse/issues/7091). [#10684](https://github.com/ClickHouse/ClickHouse/pull/10684) ([tavplubix](https://github.com/tavplubix)).
* 修复了在 `SYSTEM DROP DNS CACHE` 查询也删除缓存时的错误, 用于检查是否允许用户从某些 IP 地址连接. [#10608](https://github.com/ClickHouse/ClickHouse/pull/10608) ([tavplubix](https://github.com/tavplubix)).
* 修复了 `MATERIALIZED VIEW` 内部查询中不正确的标量结果, 以防该查询包含相关表. [#10603](https://github.com/ClickHouse/ClickHouse/pull/10603) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* 修复所有部分 mutation 完成, 但是在 `is_done=0` 中挂掉的情况. [#10526](https://github.com/ClickHouse/ClickHouse/pull/10526) ([alesapin](https://github.com/alesapin)).
* 修复了 unix 纪元开始时与 UTC 有小数偏移的时区的溢出. 这修复了 [#9335](https://github.com/ClickHouse/ClickHouse/issues/9335). [#10513](https://github.com/ClickHouse/ClickHouse/pull/10513) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 修复了分布式存储的不当关闭. [#10491](https://github.com/ClickHouse/ClickHouse/pull/10491) ([Azat Khuzhin](https://github.com/azat)).
* 修复了 `simpleLinearRegression` 中大整数上的数字溢出. [#10474](https://github.com/ClickHouse/ClickHouse/pull/10474) ([hcz](https://github.com/hczhcz)).
* 修复了附加数据库失败时删除元数据目录的问题. [#10442](https://github.com/ClickHouse/ClickHouse/pull/10442) ([Winter Zhang](https://github.com/zhang2014)).
* 在创建 `BloomFilter` 索引时添加了对参数数量和类型的检查 [#9623](https://github.com/ClickHouse/ClickHouse/issues/9623). [#10431](https://github.com/ClickHouse/ClickHouse/pull/10431) ([Winter Zhang](https://github.com/zhang2014)).
* 修复了使用 `ARRAY JOIN`、`ORDER BY` 和 `LIMIT` 的查询可能返回不完整结果的问题. 这修复了 [#10226](https://github.com/ClickHouse/ClickHouse/issues/10226). [#10427](https://github.com/ClickHouse/ClickHouse/pull/10427) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 更喜欢 `fallback_to_stale_replicas` 而不是 `skip_unavailable_shards`. [#10422](https://github.com/ClickHouse/ClickHouse/pull/10422) ([Azat Khuzhin](https://github.com/azat)).
* 修复了 `Array(Tuple(...))` 数据类型的错误扁平化. 这修复了[#10259](https://github.com/ClickHouse/ClickHouse/issues/10259). [#10390](https://github.com/ClickHouse/ClickHouse/pull/10390) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 修复了在尝试从缓冲区读取 HashMap 时导致编译错误的 `HashTable` 中的错误行为. [#10386](https://github.com/ClickHouse/ClickHouse/pull/10386) ([palasonic1](https://github.com/palasonic1)).
* 修复了 `ConcatProcessor` 中可能发生的 `Pipeline stuck` 错误, 该错误可能发生在远程查询中. [#10381](https://github.com/ClickHouse/ClickHouse/pull/10381) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* 使用 `max_rows_to_group_by` 和 `group_by_overflow_mode = 'break'` 修复了错误 `Pipeline stuck`. [#10279](https://github.com/ClickHouse/ClickHouse/pull/10279) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* 修复了一些错误, 当某些数据以法定人数插入, 然后以某种方式删除 (DROP PARTITION, TTL) 时, 这会导致插入卡住或 SELECT 中的误报异常. 这修复了 [#9946](https://github.com/ClickHouse/ClickHouse/issues/9946). [#10188](https://github.com/ClickHouse/ClickHouse/pull/10188) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* 修复了在远程服务器上使用 18.12.17 之前的版本而在启动服务器上使用较新版本时不兼容的问题, 以及 GROUP BY 固定和非固定键, 以及激活两级分组方法时. [#3254](https://github.com/ClickHouse/ClickHouse/pull/3254) ([alexey-milovidov](https://github.com/alexey-milovidov)).

#### 构建/测试/打包改进

* 将 CA 证书添加到 clickhouse-server docker 镜像. [#10476](https://github.com/ClickHouse/ClickHouse/pull/10476) ([filimonov](https://github.com/filimonov)).


### ClickHouse 版本 v20.1.10.70, 2020-04-17

#### Bug 修复

* 修复罕见的可能异常 `Cannot drain connections: cancel first`. [#10239](https://github.com/ClickHouse/ClickHouse/pull/10239) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* 修复了当用户尝试在带有 `ENGINE = Replicated*` 的表上运行 `ALTER UPDATE/DELETE` 时, ClickHouse 会抛出 `Unknown function lambda.` 错误消息的错误. 检查非确定性函数现在可以正确处理 lambda 表达式. [#10237](https://github.com/ClickHouse/ClickHouse/pull/10237) ([Alexander Kazakov](https://github.com/Akazz)).
* 修复 RFC-2822 中字符串的 `parseDateTimeBestEffort`, 当一周中的某一天是星期二或星期四时. 这修复了 [#10082](https://github.com/ClickHouse/ClickHouse/issues/10082). [#10214](https://github.com/ClickHouse/ClickHouse/pull/10214) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 修复 `JOIN` 内的常量列名可能与 `JOIN` 外的常量名冲突. [#10207](https://github.com/ClickHouse/ClickHouse/pull/10207) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 修复了可能的无限查询执行, 当查询实际上应该在LIMIT上停止, 而从无限源读取, 如 `system.numbers` 或 `system.zeros`. [#10206](https://github.com/ClickHouse/ClickHouse/pull/10206) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* 在存在`array Join`函数的情况下修复移动到prewhere优化 (在某些情况下). 这修复了[#10092](https://github.com/ClickHouse/ClickHouse/issues/10092). [#10195](https://github.com/ClickHouse/ClickHouse/pull/10195) ([alexey-milovidov](https://github.com/alexey-milovidov)).
* 添加放宽对使用 `allow_nondeterministic_mutations` 设置的突变中非确定性函数使用限制的能力. [#10186](https://github.com/ClickHouse/ClickHouse/pull/10186) ([filimonov](https://github.com/filimonov)).
* 如果结构在 `INSERT` 上不匹配，则将块转换为带有 `Distributed` 引擎的表. [#10135](https://github.com/ClickHouse/ClickHouse/pull/10135) ([Azat Khuzhin](https://github.com/azat)).
* 当其结构与底层表不同时, 将 `INSERT` 上的 `SIGSEGV` 修复到 `Distributed` 表中. [#10105](https://github.com/ClickHouse/ClickHouse/pull/10105) ([Azat Khuzhin](https://github.com/azat)).
* 使用 `JOIN` 和 `UNION ALL` 修复查询可能丢失的行. 修复 [#9826](https://github.com/ClickHouse/ClickHouse/issues/9826), [#10113](https://github.com/ClickHouse/ClickHouse/issues/10113). [#10099](https://github.com/ClickHouse/ClickHouse/pull/10099) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* 为 MySQL 数据库引擎添加参数检查和支持标识符参数. [#10077](https://github.com/ClickHouse/ClickHouse/pull/10077) ([Winter Zhang](https://github.com/zhang2014)).
* 修复来自 localhost clickhouse 服务器的 clickhouse 字典源中的错误. 如果字典和源中的类型不兼容, 该错误可能会导致内存损坏. [#10071](https://github.com/ClickHouse/ClickHouse/pull/10071) ([alesapin](https://github.com/alesapin)).
* 修复错误 `Cannot clone block with columns because block has 0 columns ... While executing GroupingAggregatedTransform`. 当设置 `distributed_aggregation_memory_efficient` 被启用, 并且分布式查询从不同分片读取不同级别的聚合数据时发生这种情况 (混合单级和二级聚合). [#10063](https://github.com/ClickHouse/ClickHouse/pull/10063) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* 修复在包含尾随零字节的字符串键上的 `GROUP BY` 中可能发生的分段错误 ([#8636](https://github.com/ClickHouse/ClickHouse/issues/8636), [#8925](https://github.com/ClickHouse/ClickHouse/issues/8925)). [#10025](https://github.com/ClickHouse/ClickHouse/pull/10025) ([Alexander Kuzmenkov](https://github.com/akuzm)).
* 修复了在某些数据库查询的处理阶段之一未检索到必要表的错误. 修复 [#9699](https://github.com/ClickHouse/ClickHouse/issues/9699). [#9949](https://github.com/ClickHouse/ClickHouse/pull/9949) ([achulkov2](https://github.com/achulkov2)).
* 修复 `JOIN` 与 `TOTALS` 一起出现时的 `Not found column in block` 错误. 修复 [#9839](https://github.com/ClickHouse/ClickHouse/issues/9839). [#9939](https://github.com/ClickHouse/ClickHouse/pull/9939) ([Artem Zuikov](https://github.com/4ertus2)).
* 修复 `ON CLUSTER` DDL 查询在服务器启动时冻结的错误. [#9927](https://github.com/ClickHouse/ClickHouse/pull/9927) ([Gagan Arneja](https://github.com/garneja)).
* 修复连接表引擎的 `TRUNCATE` ([#9917](https://github.com/ClickHouse/ClickHouse/issues/9917)). [#9920](https://github.com/ClickHouse/ClickHouse/pull/9920) ([Amos Bird](https://github.com/amosbird)).
* 修复 ALTER 查询中的 `scalar does not exist` 错误 ([#9878](https://github.com/ClickHouse/ClickHouse/issues/9878)). [#9904](https://github.com/ClickHouse/ClickHouse/pull/9904) ([Amos Bird](https://github.com/amosbird)).
* 修复 `ReplicatedMergeTree` 中删除和优化之间的竞争条件. [#9901](https://github.com/ClickHouse/ClickHouse/pull/9901) ([alesapin](https://github.com/alesapin)).
* 修复了 `ATTACH PART` 中的 `DeleteOnDestroy` 逻辑, 这可能导致自动删除附加部分并添加了一些测试. [#9410](https://github.com/ClickHouse/ClickHouse/pull/9410) ([Vladimir Chebotarev](https://github.com/excitoon)).

#### 构建/测试/打包改进

* 修复单元测试 `collapsing_sorted_stream`. [#9367](https://github.com/ClickHouse/ClickHouse/pull/9367) ([Deleted user](https://github.com/ghost)).

### ClickHouse 版本 v20.1.9.54, 2020-03-28

#### Bug 修复

* 修正了在分布式表上有 `PREWHERE` 和 `WHERE` 以及 `SET distributed_product_mode = 'local'` 时出现的 `Different expressions with the same alias` 错误. [#9871](https://github.com/ClickHouse/ClickHouse/pull/9871) ([Artem Zuikov](https://github.com/4ertus2)).
* 修复具有复合主键的表的突变过多的内存消耗. 这修复了 [#9850](https://github.com/ClickHouse/ClickHouse/issues/9850). [#9860](https://github.com/ClickHouse/ClickHouse/pull/9860) ([alesapin](https://github.com/alesapin)).
* 对于 INSERT 查询, 分片现在将从发起者获得的设置限制在分片的约束中, 而不是抛出异常. 此修复允许将 `INSERT` 查询发送到具有另一个约束的分片. 此更改改进了修复 [#9447](https://github.com/ClickHouse/ClickHouse/issues/9447). [#9852](https://github.com/ClickHouse/ClickHouse/pull/9852) ([Vitaly Baranov](https://github.com/vitlibar)).
* 修复客户端上可能出现的异常 `Got 0 in totals chunk, expected 1` on client. 如果右连接表有零行, 则使用“JOIN”进行查询时会发生这种情况. 示例: `select * from system.one t1 join system.one t2 on t1.dummy = t2.dummy limit 0 FORMAT TabSeparated;`. 修复 [#9777](https://github.com/ClickHouse/ClickHouse/issues/9777). [#9823](https://github.com/ClickHouse/ClickHouse/pull/9823) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* 当类型无法转换时, 使用 `optimize_skip_unused_shards` 修复 `SIGSEGV`. [#9804](https://github.com/ClickHouse/ClickHouse/pull/9804) ([Azat Khuzhin](https://github.com/azat)).
* 修复了函数参数的时区使用不正确的一些情况. [#9574](https://github.com/ClickHouse/ClickHouse/pull/9574) ([Vasily Nemkov](https://github.com/Enmk)).

#### 改进

* 从突变中移除 `ORDER BY` 阶段, 因为我们从单个线程中的单个有序部分读取. 还添加检查突变中的行顺序是否按排序键顺序排序并且不违反此顺序. [#9886](https://github.com/ClickHouse/ClickHouse/pull/9886) ([alesapin](https://github.com/alesapin)).

#### 构建/测试/打包改进

* 清理重复的链接器标志. 确保链接器不会查找意外的符号. [#9433](https://github.com/ClickHouse/ClickHouse/pull/9433) ([Amos Bird](https://github.com/amosbird)).

### ClickHouse 版本 v20.1.8.41, 2020-03-20

#### Bug 修复
* 修复可能的永久性 `Cannot schedule a task` 错误 (由于 `ParallelAggregatingBlockInputStream::Handler::onFinish/onFinishThread` 中的未处理异常). 这修复了 [#6833](https://github.com/ClickHouse/ClickHouse/issues/6833). [#9154](https://github.com/ClickHouse/ClickHouse/pull/9154) ([Azat Khuzhin](https://github.com/azat))
* 修复 `ALTER` 查询 (突变) 中的过多内存消耗. 这修复了 [#9533](https://github.com/ClickHouse/ClickHouse/issues/9533) and [#9670](https://github.com/ClickHouse/ClickHouse/issues/9670). [#9754](https://github.com/ClickHouse/ClickHouse/pull/9754) ([alesapin](https://github.com/alesapin))
* 修复外部字典 DDL 中反引号的错误. 这修复了 [#9619](https://github.com/ClickHouse/ClickHouse/issues/9619). [#9734](https://github.com/ClickHouse/ClickHouse/pull/9734) ([alesapin](https://github.com/alesapin))

### ClickHouse 版本 v20.1.7.38, 2020-03-18

#### Bug 修复
* 修复了 `sumKahan` 和 `sumWithOverflow` 不正确的内部函数名称. 在远程查询中使用此函数时导致异常. [#9636](https://github.com/ClickHouse/ClickHouse/pull/9636) ([Azat Khuzhin](https://github.com/azat)). This issue was in all ClickHouse releases.
* 允许具有内部复制的 `Distributed` 表的 `ALTER ON CLUSTER` . 这修复了[#3268](https://github.com/ClickHouse/ClickHouse/issues/3268). [#9617](https://github.com/ClickHouse/ClickHouse/pull/9617) ([shinoi2](https://github.com/shinoi2)). This issue was in all ClickHouse releases.
* 修复 `MergeTreeRangeReader` 中可能出现的异常 `Size of filter does not match size of column` 和 `Invalid number of rows in Chunk` . 在某些情况下, 它们可能会在执行 `PREWHERE` 时出现. 修复 [#9132](https://github.com/ClickHouse/ClickHouse/issues/9132). [#9612](https://github.com/ClickHouse/ClickHouse/pull/9612) ([Anton Popov](https://github.com/CurtizJ))
* 修正了这个问题: 如果你写一个简单的算术表达式, 比如 `time + 1` (与像 `time + INTERVAL 1 SECOND` 这样的表达式相反), 时区不会被保留. 这修复了 [#5743](https://github.com/ClickHouse/ClickHouse/issues/5743). [#9323](https://github.com/ClickHouse/ClickHouse/pull/9323) ([alexey-milovidov](https://github.com/alexey-milovidov))。 此问题存在于所有 ClickHouse 版本中.
* 现在无法创建或添加具有简单循环别名的列, 例如 `a DEFAULT b, b DEFAULT a`. [#9603](https://github.com/ClickHouse/ClickHouse/pull/9603) ([alesapin](https://github.com/alesapin))
* 修复了 base64 编码值末尾填充可能格式错误的问题. 更新 base64 库. 这修复了 [#9491](https://github.com/ClickHouse/ClickHouse/issues/9491), closes [#9492](https://github.com/ClickHouse/ClickHouse/issues/9492) [#9500](https://github.com/ClickHouse/ClickHouse/pull/9500) ([alexey-milovidov](https://github.com/alexey-milovidov))
* 修复 `Poco::HTTPServer` 破坏时的数据竞争. 服务器启动并立即关闭时可能会发生这种情况. [#9468](https://github.com/ClickHouse/ClickHouse/pull/9468) ([Anton Popov](https://github.com/CurtizJ))
* 当有很多行等于第 n 行时, 修复 `LIMIT n WITH TIES` 中可能的崩溃/错误的行数. [#9464](https://github.com/ClickHouse/ClickHouse/pull/9464) ([tavplubix](https://github.com/tavplubix))
* 使用列 TTL 修复可能不匹配的校验和. [#9451](https://github.com/ClickHouse/ClickHouse/pull/9451) ([Anton Popov](https://github.com/CurtizJ))
* 修复当用户尝试为旧格式的 `MergeTree` 表引擎系列 `ALTER MODIFY SETTING` 时崩溃. [#9435](https://github.com/ClickHouse/ClickHouse/pull/9435) ([alesapin](https://github.com/alesapin))
* 现在我们将尝试更频繁地完成突变. [#9427](https://github.com/ClickHouse/ClickHouse/pull/9427) ([alesapin](https://github.com/alesapin))
* 修复 [#8598](https://github.com/ClickHouse/ClickHouse/issues/8598) 中引入的复制协议不兼容问题. [#9412](https://github.com/ClickHouse/ClickHouse/pull/9412) ([alesapin](https://github.com/alesapin))
* 修复 not(has()) 数组类型的bloom_filter索引. [#9407](https://github.com/ClickHouse/ClickHouse/pull/9407) ([achimbab](https://github.com/achimbab))
* 修复了当 haystack 有零字节时`match` 和`extract` 函数的行为. 当 haystack 不变时, 行为是错误的. 这修复了 [#9160](https://github.com/ClickHouse/ClickHouse/issues/9160) [#9163](https://github.com/ClickHouse/ClickHouse/pull/9163) ([alexey-milovidov](https://github.com/alexey-milovidov)) [#9345](https://github.com/ClickHouse/ClickHouse/pull/9345) ([alexey-milovidov](https://github.com/alexey-milovidov))

#### 构建/测试/打包改进

* 异常处理现在可以在适用于 Linux 的 Windows 子系统上正常工作. 参见 https://github.com/ClickHouse-Extras/libunwind/pull/3 这修复了 [#6480](https://github.com/ClickHouse/ClickHouse/issues/6480) [#9564](https://github.com/ClickHouse/ClickHouse/pull/9564) ([sobolevsv](https://github.com/sobolevsv))


### ClickHouse 版本 v20.1.6.30, 2020-03-05

#### Bug 修复

* 修复使用 `T64` 编解码器压缩时数据不兼容的问题.
[#9039](https://github.com/ClickHouse/ClickHouse/pull/9039) [(abyss7)](https://github.com/abyss7)
* 在一个线程中从 MergeTree 表读取时修复范围的顺序. 修复 [#8964](https://github.com/ClickHouse/ClickHouse/issues/8964).
[#9050](https://github.com/ClickHouse/ClickHouse/pull/9050) [(CurtizJ)](https://github.com/CurtizJ)
* 修复在执行 `PREWHERE` 时在 `MergeTreeRangeReader` 中可能出现的段错误. 修复[#9064](https://github.com/ClickHouse/ClickHouse/issues/9064).
[#9106](https://github.com/ClickHouse/ClickHouse/pull/9106) [(CurtizJ)](https://github.com/CurtizJ)
* 修复 `reinterpretAsFixedString` 以返回 `FixedString` 而不是 `String`.
[#9052](https://github.com/ClickHouse/ClickHouse/pull/9052) [(oandrew)](https://github.com/oandrew)
* 使用可为空的返回类型修复 `joinGet`. 修复 [#8919](https://github.com/ClickHouse/ClickHouse/issues/8919)
[#9014](https://github.com/ClickHouse/ClickHouse/pull/9014) [(amosbird)](https://github.com/amosbird)
* 修复模糊测试和 bitTestAll/bitTestAny 函数的错误行为.
[#9143](https://github.com/ClickHouse/ClickHouse/pull/9143) [(alexey-milovidov)](https://github.com/alexey-milovidov)
* 修复 haystack 为零字节时匹配和提取函数的行为. 当 haystack 不变时, 行为是错误的. 修复 [#9160](https://github.com/ClickHouse/ClickHouse/issues/9160)
[#9163](https://github.com/ClickHouse/ClickHouse/pull/9163) [(alexey-milovidov)](https://github.com/alexey-milovidov)
* 修复了使用非严格单调函数索引时反向谓词的执行. 修复 [#9034](https://github.com/ClickHouse/ClickHouse/issues/9034)
[#9223](https://github.com/ClickHouse/ClickHouse/pull/9223) [(Akazz)](https://github.com/Akazz)
* 如果 `WHERE` 部分中有 `[NOT] LIKE` 运算符, 则允许将 `CROSS` 重写为 `INNER JOIN`. 修复 [#9191](https://github.com/ClickHouse/ClickHouse/issues/9191)
[#9229](https://github.com/ClickHouse/ClickHouse/pull/9229) [(4ertus2)](https://github.com/4ertus2)
* 允许带有日志引擎的表中的第一列作为别名.
[#9231](https://github.com/ClickHouse/ClickHouse/pull/9231) [(abyss7)](https://github.com/abyss7)
* 允许在内部使用逗号连接 `IN()`. 修复 [#7314](https://github.com/ClickHouse/ClickHouse/issues/7314).
[#9251](https://github.com/ClickHouse/ClickHouse/pull/9251) [(4ertus2)](https://github.com/4ertus2)
* 改进`ALTER MODIFY/ADD`查询逻辑. 现在你不能在没有类型的情况下 `ADD` 列, `MODIFY` 默认表达式不会改变列的类型, `MODIFY` 类型不会丢失默认表达式值. 修复 [#8669](https://github.com/ClickHouse/ClickHouse/issues/8669).
[#9227](https://github.com/ClickHouse/ClickHouse/pull/9227)  [(alesapin)](https://github.com/alesapin)
* 修复突变完成, 当已经完成突变时, 状态可以为 is_done=0.
[#9217](https://github.com/ClickHouse/ClickHouse/pull/9217) [(alesapin)](https://github.com/alesapin)
* 支持 system.numbers 和 system.numbers_mt 的 `Processors` 管道. 这也修复了不遵守 `max_execution_time` 时的错误.
[#7796](https://github.com/ClickHouse/ClickHouse/pull/7796)  [(KochetovNicolai)](https://github.com/KochetovNicolai)
* 修复 `DictCacheKeysRequestedFound` 指标的错误计数.
[#9411](https://github.com/ClickHouse/ClickHouse/pull/9411) [(nikitamikhaylov)](https://github.com/nikitamikhaylov)
* 在`ATTACH PARTITION FROM`、`REPLACE PARTITION`、`MOVE TO TABLE` 中添加了对存储策略的检查, 否则可能会使重启后部分数据无法访问并阻止ClickHouse启动.
[#9383](https://github.com/ClickHouse/ClickHouse/pull/9383) [(excitoon)](https://github.com/excitoon)
* 修复了 `MergeTreeIndexSet` 中的 UBSan 报告. 这修复了 [#9250](https://github.com/ClickHouse/ClickHouse/issues/9250)
[#9365](https://github.com/ClickHouse/ClickHouse/pull/9365) [(alexey-milovidov)](https://github.com/alexey-milovidov)
* 修复 BlockIO 中可能的数据竞争.
[#9356](https://github.com/ClickHouse/ClickHouse/pull/9356) [(KochetovNicolai)](https://github.com/KochetovNicolai)
* 支持在 JSON 相关函数中不适合 Int64 的 `UInt64` 数字. 将 `SIMDJSON` 更新为 master. 这修复了 [#9209](https://github.com/ClickHouse/ClickHouse/issues/9209)
[#9344](https://github.com/ClickHouse/ClickHouse/pull/9344) [(alexey-milovidov)](https://github.com/alexey-milovidov)
* 修复了如果数据目录安装到单独的设备时无法正确计算可用空间量的问题. 对于默认磁盘, 从数据子目录计算可用空间. 这修复了 [#7441](https://github.com/ClickHouse/ClickHouse/issues/7441)
[#9257](https://github.com/ClickHouse/ClickHouse/pull/9257) [(millb)](https://github.com/millb)
* 修复 TLS 连接可能失败并显示消息 `OpenSSL SSL_read: error:14094438:SSL routines:ssl3_read_bytes:tlsv1 alert internal error and SSL Exception: error:2400006E:random number generator::error retrieving entropy.` . 更新 OpenSSL 到上游掌握.
[#8956](https://github.com/ClickHouse/ClickHouse/pull/8956) [(alexey-milovidov)](https://github.com/alexey-milovidov)
* 执行 `CREATE` 查询时, 在存储引擎参数中折叠常量表达式. 用当前数据库替换空数据库名称. 修复 [#6508](https://github.com/ClickHouse/ClickHouse/issues/6508)、[#3492](https://github.com/ClickHouse/ClickHouse/issues/3492). 还修复了 ClickHouseDictionarySource 中本地地址的检查.
[#9262](https://github.com/ClickHouse/ClickHouse/pull/9262) [(tabplubix)](https://github.com/tavplubix)
* 修复 `StorageMerge` 中的段错误, 这在从 StorageFile 读取时可能发生
[#9387](https://github.com/ClickHouse/ClickHouse/pull/9387) [(tabplubix)](https://github.com/tavplubix)
* 在读取后缀之后但提交之前发生异常时, 在极少数情况下防止在 `Kafka` 中丢失数据. 修复[#9378](https://github.com/ClickHouse/ClickHouse/issues/9378). Related: [#7175](https://github.com/ClickHouse/ClickHouse/issues/7175)
[#9507](https://github.com/ClickHouse/ClickHouse/pull/9507) [(filimonov)](https://github.com/filimonov)
* 修复在尝试使用/删除使用错误参数创建的 `Kafka` 表时导致服务器终止的错误. 修复 [#9494](https://github.com/ClickHouse/ClickHouse/issues/9494). Incorporates [#9507](https://github.com/ClickHouse/ClickHouse/issues/9507).
[#9513](https://github.com/ClickHouse/ClickHouse/pull/9513) [(filimonov)](https://github.com/filimonov)

#### 新特征
* 添加 `deduplicate_blocks_in_dependent_materialized_views` 选项以控制幂等插入到具有物化视图的表中的行为. 应 Altinity 的特殊要求, 此新功能已添加到错误修复版本中.
[#9070](https://github.com/ClickHouse/ClickHouse/pull/9070) [(urykhy)](https://github.com/urykhy)

### ClickHouse 版本 v20.1.2.4, 2020-01-22

#### 向后不兼容变更
* 使设置 `merge_tree_uniform_read_distribution` 过时. 服务器仍然可以识别此设置, 但没有效果. [#8308](https://github.com/ClickHouse/ClickHouse/pull/8308) ([alexey-milovidov](https://github.com/alexey-milovidov))
* 将函数 `greatCircleDistance` 的返回类型更改为 `Float32` , 因为现在计算的结果是 `Float32` . [#7993](https://github.com/ClickHouse/ClickHouse/pull/7993) ([alexey-milovidov](https://github.com/alexey-milovidov))
* 现在预计查询参数以 `escaped` 格式表示. 例如, 要传递字符串 `a<tab>b` , 您必须在URL 中分别写入 `a\tb` 或 `a\<tab>b` 以及 `a%5Ctb` 或 `a%5C%09b`. 这需要添加将 NULL 作为 `\N` 传递的可能性. 这修复了 [#7488](https://github.com/ClickHouse/ClickHouse/issues/7488). [#8517](https://github.com/ClickHouse/ClickHouse/pull/8517) ([alexey-milovidov](https://github.com/alexey-milovidov))
* 默认情况下为 `ReplicatedMergeTree` 启用 `use_minimalistic_part_header_in_zookeeper` 设置. 这将显着减少存储在 ZooKeeper 中的数据量. 从 19.1 版开始支持此设置, 我们已经在多个服务的生产中使用它半年多没有任何问题. 如果您有机会降级到 19.1 之前的版本, 请禁用此设置. [#6850](https://github.com/ClickHouse/ClickHouse/pull/6850) ([alexey-milovidov](https://github.com/alexey-milovidov))
* 数据跳过索引已准备好生产并默认启用. 设置 `allow_experimental_data_skipping_indices`、`allow_experimental_cross_to_join_conversion` 和 `allow_experimental_multiple_joins_emulation` 现在已经过时并且什么都不做. [#7974](https://github.com/ClickHouse/ClickHouse/pull/7974) ([alexey-milovidov](https://github.com/alexey-milovidov))
* 为与 `JOIN` 操作一致的 `StorageJoin` 添加新的 `ANY JOIN` 逻辑. 要在不改变行为的情况下进行升级, 您需要将 `SETTINGS any_join_distinct_right_table_keys = 1` 添加到引擎连接表元数据或在升级后重新创建这些表. [#8400](https://github.com/ClickHouse/ClickHouse/pull/8400) ([Artem Zuikov](https://github.com/4ertus2))
* 需要重新启动服务器以应用日志配置中的更改. 这是一个临时解决方法, 以避免服务器记录到已删除的日志文件的错误 (请参阅 [#8696](https://github.com/ClickHouse/ClickHouse/issues/8696)). [#8707](https://github.com/ClickHouse/ClickHouse/pull/8707) ([Alexander Kuzmenkov](https://github.com/akuzm))

#### 新特征
* 向 `system.merges` 添加了有关部件路径的信息. [#8043](https://github.com/ClickHouse/ClickHouse/pull/8043) ([Vladimir Chebotarev](https://github.com/excitoon))
* 添加在 `ON CLUSTER` 模式下执行 `SYSTEM RELOAD DICTIONARY` 查询的能力. [#8288](https://github.com/ClickHouse/ClickHouse/pull/8288) ([Guillaume Tassery](https://github.com/YiuRULE))
* 添加在 `ON CLUSTER` 模式下执行 `CREATE DICTIONARY` 查询的能力. [#8163](https://github.com/ClickHouse/ClickHouse/pull/8163) ([alesapin](https://github.com/alesapin))
* 现在用户在 `users.xml` 中的配置文件可以继承多个配置文件. [#8343](https://github.com/ClickHouse/ClickHouse/pull/8343) ([Mikhail f. Shiryaev](https://github.com/Felixoid))
* 添加了 `system.stack_trace` 表, 允许查看所有服务器线程的堆栈跟踪. 这对于开发人员自省服务器状态很有用. 这修复了[#7576](https://github.com/ClickHouse/ClickHouse/issues/7576). [#8344](https://github.com/ClickHouse/ClickHouse/pull/8344) ([alexey-milovidov](https://github.com/alexey-milovidov))
* 添加具有可配置亚秒级精度的 `DateTime64` 数据类型. [#7170](https://github.com/ClickHouse/ClickHouse/pull/7170) ([Vasily Nemkov](https://github.com/Enmk))
* 添加表函数 `clusterAllReplicas`, 允许查询集群中的所有节点. [#8493](https://github.com/ClickHouse/ClickHouse/pull/8493) ([kiran sunkari](https://github.com/kiransunkari))
* 添加聚合函数 `categoricalInformationValue`, 用于计算离散特征的信息值. [#8117](https://github.com/ClickHouse/ClickHouse/pull/8117) ([hcz](https://github.com/hczhcz))
* 通过并行执行来加速对 `CSV`、`TSV` 和 `JSONEachRow` 格式的数据文件的解析. [#7780](https://github.com/ClickHouse/ClickHouse/pull/7780) ([Alexander Kuzmenkov](https://github.com/akuzm))
* 添加执行银行家舍入的函数`bankerRound`. [#8112](https://github.com/ClickHouse/ClickHouse/pull/8112) ([hcz](https://github.com/hczhcz))
* 在区域名称的嵌入式字典中支持更多语言: 'ru', 'en', 'ua', 'uk', 'by', 'kz', 'tr', 'de', 'uz', 'lv', 'lt', 'et', 'pt', 'he', 'vi'. [#8189](https://github.com/ClickHouse/ClickHouse/pull/8189) ([alexey-milovidov](https://github.com/alexey-milovidov))
* 改进了 `ANY JOIN` 逻辑的一致性. 现在 `t1 ANY LEFT JOIN t2` 等于 `t2 ANY RIGHT JOIN t1`. [#7665](https://github.com/ClickHouse/ClickHouse/pull/7665) ([Artem Zuikov](https://github.com/4ertus2))
* 添加设置 `any_join_distinct_right_table_keys` 以启用 `ANY INNER JOIN` 的旧行为. [#7665](https://github.com/ClickHouse/ClickHouse/pull/7665) ([Artem Zuikov](https://github.com/4ertus2))
* 添加新的 `SEMI` 和 `ANTI JOIN`. 旧的 `ANY INNER JOIN` 行为现在可用作 `SEMI LEFT JOIN` . [#7665](https://github.com/ClickHouse/ClickHouse/pull/7665) ([Artem Zuikov](https://github.com/4ertus2))
* 为 `File` 引擎和 `file` 表功能添加了 `Distributed` 格式, 允许从异步插入到 `Distributed `表中生成的 `.bin` 文件中读取. [#8535](https://github.com/ClickHouse/ClickHouse/pull/8535) ([Nikolai Kochetov](https://github.com/KochetovNicolai))
* 为 `runningAccumulate` 添加可选的重置列参数, 允许重置每个新键值的聚合结果. [#8326](https://github.com/ClickHouse/ClickHouse/pull/8326) ([Sergey Kononenko](https://github.com/kononencheg))
* 添加使用 ClickHouse 作为 Prometheus 端点的功能. [#7900](https://github.com/ClickHouse/ClickHouse/pull/7900) ([vdimir](https://github.com/Vdimir))
* 在 `config.xml` 中添加 `<remote_url_allow_hosts>` 部分, 限制远程表引擎和表函数 `URL`、`S3`、`HDFS`的允许主机. [#7154](https://github.com/ClickHouse/ClickHouse/pull/7154) ([Mikhail Korotov](https://github.com/millb))
* 添加了函数 `greatCircleAngle`, 以度数计算球体上的距离. [#8105](https://github.com/ClickHouse/ClickHouse/pull/8105) ([alexey-milovidov](https://github.com/alexey-milovidov))
* 更改地球半径与 H3 库一致. [#8105](https://github.com/ClickHouse/ClickHouse/pull/8105) ([alexey-milovidov](https://github.com/alexey-milovidov))
* 为输入和输出添加了 `JSONCompactEachRow` 和 `JSONCompactEachRowWithNamesAndTypes` 格式. [#7841](https://github.com/ClickHouse/ClickHouse/pull/7841) ([Mikhail Korotov](https://github.com/millb))
* 添加了与文件相关的表引擎和表函数 (`File`、`S3`、`URL`、`HDFS`) 的功能, 允许根据附加引擎参数或文件扩展名读写 `gzip` 文件. [#7840](https://github.com/ClickHouse/ClickHouse/pull/7840) ([Andrey Bodrov](https://github.com/apbodrov))
* 添加了 `randomASCII(length)` 函数, 生成一个带有随机 [ASCII](https://en.wikipedia.org/wiki/ASCII#Printable_characters) 可打印字符集的字符串. [#8401](https://github.com/ClickHouse/ClickHouse/pull/8401) ([BayoNet](https://github.com/BayoNet))
* 添加了函数 `JSONExtractArrayRaw`, 它从 `JSON` 字符串返回未解析的 json 数组元素的数组. [#8081](https://github.com/ClickHouse/ClickHouse/pull/8081) ([Oleg Matrokhin](https://github.com/errx))
* 添加 `arrayZip` 函数, 该函数允许将多个长度相等的数组组合成一个元组数组. [#8149](https://github.com/ClickHouse/ClickHouse/pull/8149) ([Winter Zhang](https://github.com/zhang2014))
* 添加根据为 `*MergeTree` 表引擎系列配置的 `TTL` 表达式在磁盘之间移动数据的能力. [#8140](https://github.com/ClickHouse/ClickHouse/pull/8140) ([Vladimir Chebotarev](https://github.com/excitoon))
* 添加了新的聚合函数 `avgWeighted`, 它允许计算加权平均值. [#7898](https://github.com/ClickHouse/ClickHouse/pull/7898) ([Andrey Bodrov](https://github.com/apbodrov))
* 现在默认为 `TSV`、`TSKV`、`CSV` 和 `JSONEachRow` 格式启用并行解析. [#7894](https://github.com/ClickHouse/ClickHouse/pull/7894) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov))
* 从`H3` 库添加几个地理函数: `h3GetResolution`、`h3EdgeAngle`、`h3EdgeLength`、`h3IsValid` 和 `h3kRing`. [#8034](https://github.com/ClickHouse/ClickHouse/pull/8034) ([Konstantin Malanchev](https://github.com/hombit))
* 在文件相关的存储和表函数中添加了对 brotli (`br`) 压缩的支持. 这修复了 [#8156](https://github.com/ClickHouse/ClickHouse/issues/8156). [#8526](https://github.com/ClickHouse/ClickHouse/pull/8526) ([alexey-milovidov](https://github.com/alexey-milovidov))
* 为 `SimpleAggregationFunction` 类型添加 `groupBit*` 函数. [#8485](https://github.com/ClickHouse/ClickHouse/pull/8485) ([Guillaume Tassery](https://github.com/YiuRULE))

#### Bug 修复
* 使用 `Distributed` 引擎修复表的重命名. 修复问题 [#7868](https://github.com/ClickHouse/ClickHouse/issues/7868). [#8306](https://github.com/ClickHouse/ClickHouse/pull/8306) ([tavplubix](https://github.com/tavplubix))
* 现在字典支持非 ClickHouse SQL 方言中任意字符串中的属性的 `EXPRESSION`. [#8098](https://github.com/ClickHouse/ClickHouse/pull/8098) ([alesapin](https://github.com/alesapin))
* 修复损坏的 `INSERT SELECT FROM mysql(...)` 查询. 这修复了 [#8070](https://github.com/ClickHouse/ClickHouse/issues/8070) 和 [#7960](https://github.com/ClickHouse/ClickHouse/issues/7960). [#8234](https://github.com/ClickHouse/ClickHouse/pull/8234) ([tavplubix](https://github.com/tavplubix))
* 修复从 `JSONEachRow` 插入默认 `Tuple` 时出现的错误 `Mismatch column sizes`. 这修复了[#5653](https://github.com/ClickHouse/ClickHouse/issues/5653). [#8606](https://github.com/ClickHouse/ClickHouse/pull/8606) ([tavplubix](https://github.com/tavplubix))
* 现在，如果将 `WITH TIES` 与 `LIMIT BY` 一起使用, 则会引发异常. 还添加了将 `TOP` 与 `LIMIT BY` 一起使用的功能. 这修复了 [#7472](https://github.com/ClickHouse/ClickHouse/issues/7472). [#7637](https://github.com/ClickHouse/ClickHouse/pull/7637) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov))
* 在 `clickhouse-odbc-bridge` 二进制文件中修复来自新 glibc 版本的意外依赖. [#8046](https://github.com/ClickHouse/ClickHouse/pull/8046) ([Amos Bird](https://github.com/amosbird))
* 修复 `*MergeTree` 引擎家族的检查功能错误. 现在, 如果我们在最后一个颗粒和最后一个标记 (非最终) 中有相同数量的行, 它不会失败. [#8047](https://github.com/ClickHouse/ClickHouse/pull/8047) ([alesapin](https://github.com/alesapin))
* 当基础数字类型等于表指定类型时, 修复在 `ALTER` 查询后插入 `Enum*` 列. 这修复了 [#7836](https://github.com/ClickHouse/ClickHouse/issues/7836). [#7908](https://github.com/ClickHouse/ClickHouse/pull/7908) ([Anton Popov](https://github.com/CurtizJ))
* 允许函数 `substring` 的非常量负 `size` 参数. 这是不允许的. 这修复了 [#4832](https://github.com/ClickHouse/ClickHouse/issues/4832). [#7703](https://github.com/ClickHouse/ClickHouse/pull/7703) ([alexey-milovidov](https://github.com/alexey-milovidov))
* 修复传递给 `(O|J)DBC` 表引擎的参数数量错误时的解析错误. [#7709](https://github.com/ClickHouse/ClickHouse/pull/7709) ([alesapin](https://github.com/alesapin))
* 将日志发送到 syslog 时使用正在运行的 clickhouse 进程的命令名称. 在以前的版本中, 使用空字符串代替命令名称. [#8460](https://github.com/ClickHouse/ClickHouse/pull/8460) ([Michael Nacharov](https://github.com/mnach))
* 修复对 `localhost` 允许主机的检查. 此 PR 修复了 [#8241](https://github.com/ClickHouse/ClickHouse/pull/8241) 中提供的解决方案. [#8342](https://github.com/ClickHouse/ClickHouse/pull/8342) ([Vitaly Baranov](https://github.com/vitlibar))
* 修复在 `argMin` 和 `argMax` 函数中, 当结果用于 `runningAccumulate` 函数时, 长字符串参数的罕见崩溃. 这修复了 [#8325](https://github.com/ClickHouse/ClickHouse/issues/8325) [#8341](https://github.com/ClickHouse/ClickHouse/pull/8341) ([dinosaur](https://github.com/769344359))
* 使用 `Buffer` 引擎修复表的内存过量使用. [#8345](https://github.com/ClickHouse/ClickHouse/pull/8345) ([Azat Khuzhin](https://github.com/azat))
* 修复了函数中可以将 `NULL` 作为参数之一并返回非 NULL 的潜在错误. [#8196](https://github.com/ClickHouse/ClickHouse/pull/8196) ([alexey-milovidov](https://github.com/alexey-milovidov))
* 线程池中更好的度量计算, 用于 `MergeTree` 表引擎的后台进程. [#8194](https://github.com/ClickHouse/ClickHouse/pull/8194) ([Vladimir Chebotarev](https://github.com/excitoon))
* 当存在行级表过滤器时, 在 `WHERE` 语句中修复函数 `IN`. 修复 [#6687](https://github.com/ClickHouse/ClickHouse/issues/6687) [#8357](https://github.com/ClickHouse/ClickHouse/pull/8357) ([Ivan](https://github.com/abyss7))
* 现在, 如果未完全解析设置值的整数值, 则会引发异常. [#7678](https://github.com/ClickHouse/ClickHouse/pull/7678) ([Mikhail Korotov](https://github.com/millb))
* 修复使用聚合函数查询具有两个以上本地分片的分布式表时的异常. [#8164](https://github.com/ClickHouse/ClickHouse/pull/8164) ([小路](https://github.com/nicelulu))
* 现在布隆过滤器可以处理零长度数组并且不执行冗余计算. [#8242](https://github.com/ClickHouse/ClickHouse/pull/8242) ([achimbab](https://github.com/achimbab))
* 修复了通过将客户端主机与 `users.xml` 中指定的 `host_regexp` 匹配来检查是否允许客户端主机. [#8241](https://github.com/ClickHouse/ClickHouse/pull/8241) ([Vitaly Baranov](https://github.com/vitlibar))
* 放宽不明确的列检查, 导致多个 `JOIN ON` 部分出现误报. [#8385](https://github.com/ClickHouse/ClickHouse/pull/8385) ([Artem Zuikov](https://github.com/4ertus2))
* 修复了当服务器无法以 `JSON` 或 `XML` 格式发送或写入数据为 `String` 数据类型 (需要 `UTF-8` 验证) 或压缩时可能出现的服务器崩溃 (`std::terminate`)  Brotli 算法或其他一些罕见情况下的结果数据. 这修复了 [#7603](https://github.com/ClickHouse/ClickHouse/issues/7603) [#8384](https://github.com/ClickHouse/ClickHouse/pull/8384) ([alexey-milovidov](https://github.com/alexey-milovidov))
* 修复 CI 发现的 `StorageDistributedDirectoryMonitor` 中的竞争条件. 这修复了 [#8364](https://github.com/ClickHouse/ClickHouse/issues/8364). [#8383](https://github.com/ClickHouse/ClickHouse/pull/8383) ([Nikolai Kochetov](https://github.com/KochetovNicolai))
* 现在 `*MergeTree` 表引擎族中的后台合并更准确地保留存储策略卷顺序. [#8549](https://github.com/ClickHouse/ClickHouse/pull/8549) ([Vladimir Chebotarev](https://github.com/excitoon))
* 现在表引擎 `Kafka` 可以正常使用 `Native` 格式. 这修复了[#6731](https://github.com/ClickHouse/ClickHouse/issues/6731) [#7337](https://github.com/ClickHouse/ClickHouse/issues/7337) [#8003](https://github.com/ClickHouse/ClickHouse/issues/8003). [#8016](https://github.com/ClickHouse/ClickHouse/pull/8016) ([filimonov](https://github.com/filimonov))
* 修复了带有标题的格式 (如 `CSVWithNames`), 这些格式会为表引擎 `Kafka` 抛出有关 EOF 的异常. [#8016](https://github.com/ClickHouse/ClickHouse/pull/8016) ([filimonov](https://github.com/filimonov))
* 修复了从 `IN` 部分右侧的子查询进行设置的错误. 这修复了[#5767](https://github.com/ClickHouse/ClickHouse/issues/5767) and [#2542](https://github.com/ClickHouse/ClickHouse/issues/2542). [#7755](https://github.com/ClickHouse/ClickHouse/pull/7755) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov))
* 修复从存储 `File` 读取时可能发生的崩溃. [#7756](https://github.com/ClickHouse/ClickHouse/pull/7756) ([Nikolai Kochetov](https://github.com/KochetovNicolai))
* 固定读取包含类型为 `list` 的列的 `arquet` 格式的文件. [#8334](https://github.com/ClickHouse/ClickHouse/pull/8334) ([maxulan](https://github.com/maxulan))
* 如果`max_parallel_replicas > 1`, 则使用依赖于采样键的 `PREWHERE` 条件修复分布式查询的错误 `Not found column` . [#7913](https://github.com/ClickHouse/ClickHouse/pull/7913) ([Nikolai Kochetov](https://github.com/KochetovNicolai))
* 如果查询使用依赖于表别名的 `PREWHERE`, 并且由于主键条件导致结果集为空, 则修复错误 `Not found column`. [#7911](https://github.com/ClickHouse/ClickHouse/pull/7911) ([Nikolai Kochetov](https://github.com/KochetovNicolai))
* 修复了函数 `rand` 和 `randConstant` 在 `Nullable` 参数的情况下的返回类型. 现在函数总是返回 `UInt32` 而不是 `Nullable(UInt32)`. [#8204](https://github.com/ClickHouse/ClickHouse/pull/8204) ([Nikolai Kochetov](https://github.com/KochetovNicolai))
* 禁用了`WITH FILL` 表达式的谓词下推. 这修复了[#7784](https://github.com/ClickHouse/ClickHouse/issues/7784). [#7789](https://github.com/ClickHouse/ClickHouse/pull/7789) ([Winter Zhang](https://github.com/zhang2014))
* 修复了使用 `FINAL` 部分时 `SummingMergeTree` 的错误 `count()` 结果. [#3280](https://github.com/ClickHouse/ClickHouse/issues/3280) [#7786](https://github.com/ClickHouse/ClickHouse/pull/7786) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov))
* 修复来自远程服务器的常量函数可能的错误结果. 它发生在具有诸如 `version()`、`uptime()` 等函数的查询中, 这些函数为不同的服务器返回不同的常量值. 这修复了 [#7666](https://github.com/ClickHouse/ClickHouse/issues/7666). [#7689](https://github.com/ClickHouse/ClickHouse/pull/7689) ([Nikolai Kochetov](https://github.com/KochetovNicolai))
* 修复下推谓词优化中导致错误结果的复杂错误. 这修复了很多关于下推谓词优化的问题. [#8503](https://github.com/ClickHouse/ClickHouse/pull/8503) ([Winter Zhang](https://github.com/zhang2014))
* 修复 `CREATE TABLE .. AS dictionary` 查询中的崩溃. [#8508](https://github.com/ClickHouse/ClickHouse/pull/8508) ([Azat Khuzhin](https://github.com/azat))
* `.g4` 文件中的多项改进 ClickHouse 语法. [#8294](https://github.com/ClickHouse/ClickHouse/pull/8294) ([taiyang-li](https://github.com/taiyang-li))
* 修复导致带有引擎 `Join` 的表在 `JOIN` 中崩溃的错误. 这修复了 [#7556](https://github.com/ClickHouse/ClickHouse/issues/7556) [#8254](https://github.com/ClickHouse/ClickHouse/issues/8254) [#7915](https://github.com/ClickHouse/ClickHouse/issues/7915) [#8100](https://github.com/ClickHouse/ClickHouse/issues/8100). [#8298](https://github.com/ClickHouse/ClickHouse/pull/8298) ([Artem Zuikov](https://github.com/4ertus2))
* 修复冗余字典重新加载到 `CREATE DATABASE` . [#7916](https://github.com/ClickHouse/ClickHouse/pull/7916) ([Azat Khuzhin](https://github.com/azat))
* 限制从 `StorageFile` 和 `StorageHDFS` 读取的最大流数。 修复 [#7650](https://github.com/ClickHouse/ClickHouse/issues/7650). [#7981](https://github.com/ClickHouse/ClickHouse/pull/7981) ([alesapin](https://github.com/alesapin))
* 当用户同时指定默认表达式和编解码器时, 修复 `ALTER ... MODIFY ... CODEC` 查询中的错误. 修复 [8593](https://github.com/ClickHouse/ClickHouse/issues/8593). [#8614](https://github.com/ClickHouse/ClickHouse/pull/8614) ([alesapin](https://github.com/alesapin))
* 修复具有 `SimpleAggregateFunction(LowCardinality)` 类型的列的后台合并错误 [#8613](https://github.com/ClickHouse/ClickHouse/pull/8613) ([Nikolai Kochetov](https://github.com/KochetovNicolai))
* 固定类型检查函数 `toDateTime64`. [#8375](https://github.com/ClickHouse/ClickHouse/pull/8375) ([Vasily Nemkov](https://github.com/Enmk))
* 现在服务器不会在 `LEFT` 或 `FULL JOIN` 和Join 引擎和不支持的 `join_use_nulls` 设置上崩溃. [#8479](https://github.com/ClickHouse/ClickHouse/pull/8479) ([Artem Zuikov](https://github.com/4ertus2))
* 现在, 如果 `db` 不存在, `DROP DICTIONARY IF EXISTS db.dict` 查询不会抛出异常. [#8185](https://github.com/ClickHouse/ClickHouse/pull/8185) ([Vitaly Baranov](https://github.com/vitlibar))
* 修复由于使用对已删除的 `IStorage` 对象的引用而导致的表函数 (`file`、`mysql`、`remote`)中可能的崩溃. 修复插入表函数时指定的列的错误解析. [#7762](https://github.com/ClickHouse/ClickHouse/pull/7762) ([tavplubix](https://github.com/tavplubix))
* 在启动 `clickhouse-server` 之前确保网络已启动. 这修复了 [#7507](https://github.com/ClickHouse/ClickHouse/issues/7507). [#8570](https://github.com/ClickHouse/ClickHouse/pull/8570) ([Zhichang Yu](https://github.com/yuzhichang))
* 修复安全连接的超时处理, 因此查询不会无限期挂起. 这修复了[#8126](https://github.com/ClickHouse/ClickHouse/issues/8126). [#8128](https://github.com/ClickHouse/ClickHouse/pull/8128) ([alexey-milovidov](https://github.com/alexey-milovidov))
* 修复并发工作者之间的 `clickhouse-copier` 冗余争用. [#7816](https://github.com/ClickHouse/ClickHouse/pull/7816) ([Ding Xiang Fei](https://github.com/dingxiangfei2009))
* 现在突变不会跳过附加的部分, 即使它们的突变版本大于当前的突变版本. [#7812](https://github.com/ClickHouse/ClickHouse/pull/7812) ([Zhichang Yu](https://github.com/yuzhichang)) [#8250](https://github.com/ClickHouse/ClickHouse/pull/8250) ([alesapin](https://github.com/alesapin))
* 移动到另一个磁盘和服务器重启后, 忽略 `*MergeTree` 数据部分的冗余副本. [#7810](https://github.com/ClickHouse/ClickHouse/pull/7810) ([Vladimir Chebotarev](https://github.com/excitoon))
* 使用 `JOIN` 键中的 `Low Cardinality` 修复 `FULL JOIN` 中的崩溃. [#8252](https://github.com/ClickHouse/ClickHouse/pull/8252) ([Artem Zuikov](https://github.com/4ertus2))
* 禁止在插入查询中多次使用列名, 例如 `INSERT INTO tbl (x, y, x)`. 这修复了[#5465](https://github.com/ClickHouse/ClickHouse/issues/5465), [#7681](https://github.com/ClickHouse/ClickHouse/issues/7681). [#7685](https://github.com/ClickHouse/ClickHouse/pull/7685) ([alesapin](https://github.com/alesapin))
* 添加回退以检测未知 CPU 的物理 CPU 内核数 (使用逻辑 CPU 内核数) . 这修复了 [#5239](https://github.com/ClickHouse/ClickHouse/issues/5239). [#7726](https://github.com/ClickHouse/ClickHouse/pull/7726) ([alexey-milovidov](https://github.com/alexey-milovidov))
* 修复物化列和别名列的 `There's no column` 错误. [#8210](https://github.com/ClickHouse/ClickHouse/pull/8210) ([Artem Zuikov](https://github.com/4ertus2))
* 修复了在没有 `TABLE` 或 `DICTIONARY` 限定符的情况下使用 `EXISTS` 查询时服务器崩溃的问题. 就像 `EXISTS t`。 这修复了 [#8172](https://github.com/ClickHouse/ClickHouse/issues/8172). 这个错误是在 19.17 版本中引入的. [#8213](https://github.com/ClickHouse/ClickHouse/pull/8213) ([alexey-milovidov](https://github.com/alexey-milovidov))
* 修复了使用 `SimpleAggregateFunction` 列时可能出现的带有错误 `"Sizes of columns not match"` 的罕见错误. [#7790](https://github.com/ClickHouse/ClickHouse/pull/7790) ([Boris Granveaud](https://github.com/bgranvea))
* 修复具有空 `allow_databases` 的用户可以访问所有数据库的错误 (对于 `allow_dictionaries` 也是如此). [#7793](https://github.com/ClickHouse/ClickHouse/pull/7793) ([DeifyTheGod](https://github.com/DeifyTheGod))
* 当服务器已经与客户端断开连接时修复客户端崩溃. [#8071](https://github.com/ClickHouse/ClickHouse/pull/8071) ([Azat Khuzhin](https://github.com/azat))
* 在按主键前缀和非主键后缀排序的情况下修复 `ORDER BY` 行为. [#7759](https://github.com/ClickHouse/ClickHouse/pull/7759) ([Anton Popov](https://github.com/CurtizJ))
* 检查表中是否存在合格的列. 这修复了 [#6836](https://github.com/ClickHouse/ClickHouse/issues/6836). [#7758](https://github.com/ClickHouse/ClickHouse/pull/7758) ([Artem Zuikov](https://github.com/4ertus2))
* 修复了在合并完成移动指定的超部分后立即运行的 `ALTER MOVE` 行为. 修复 [#8103](https://github.com/ClickHouse/ClickHouse/issues/8103). [#8104](https://github.com/ClickHouse/ClickHouse/pull/8104) ([Vladimir Chebotarev](https://github.com/excitoon))
* 修复使用具有不同列数的 `UNION` 时可能出现的服务器崩溃. 修复 [#7279](https://github.com/ClickHouse/ClickHouse/issues/7279). [#7929](https://github.com/ClickHouse/ClickHouse/pull/7929) ([Nikolai Kochetov](https://github.com/KochetovNicolai))
* 修复具有负大小的函数 `substr` 的结果子字符串的大小. [#8589](https://github.com/ClickHouse/ClickHouse/pull/8589) ([Nikolai Kochetov](https://github.com/KochetovNicolai))
* 现在，如果后台池中没有足够的空闲线程, 服务器不会在 `MergeTree` 中执行部分突变.  [#8588](https://github.com/ClickHouse/ClickHouse/pull/8588) ([tavplubix](https://github.com/tavplubix))
* 修复格式化`UNION ALL` AST 时的一个小错误. [#7999](https://github.com/ClickHouse/ClickHouse/pull/7999) ([litao91](https://github.com/litao91))
* 修复了负数的错误布隆过滤器结果. 这修复了 [#8317](https://github.com/ClickHouse/ClickHouse/issues/8317). [#8566](https://github.com/ClickHouse/ClickHouse/pull/8566) ([Winter Zhang](https://github.com/zhang2014))
* 修复了解压缩中潜在的缓冲区溢出. 恶意用户可以传递伪造的压缩数据, 这将导致缓冲区后读取. 这个问题是由 Yandex 信息安全团队的 Eldar Zaitov 发现的. [#8404](https://github.com/ClickHouse/ClickHouse/pull/8404) ([alexey-milovidov](https://github.com/alexey-milovidov))
* 修复由于 `arrayIntersect` 中整数溢出而导致的错误结果. [#7777](https://github.com/ClickHouse/ClickHouse/pull/7777) ([Nikolai Kochetov](https://github.com/KochetovNicolai))
* 现在 `OPTIMIZE TABLE` 查询不会等待离线副本执行操作. [#8314](https://github.com/ClickHouse/ClickHouse/pull/8314) ([javi santana](https://github.com/javisantana))
* 修复了 `Replicated*MergeTree` 表的 `ALTER TTL` 解析器. [#8318](https://github.com/ClickHouse/ClickHouse/pull/8318) ([Vladimir Chebotarev](https://github.com/excitoon))
* 修复服务器和客户端之间的通信, 以便服务器在查询失败后读取临时表信息. [#8084](https://github.com/ClickHouse/ClickHouse/pull/8084) ([Azat Khuzhin](https://github.com/azat))
* 修复聚合位图和标量位图相交时的 `bitmapAnd` 函数错误. [#8082](https://github.com/ClickHouse/ClickHouse/pull/8082) ([Yue Huang](https://github.com/moon03432))
* 根据修复了 `clickhouse-cluster-copier` 中的错误的 ZooKeeper 程序员指南细化 `ZXid` 的定义. [#8088](https://github.com/ClickHouse/ClickHouse/pull/8088) ([Ding Xiang Fei](https://github.com/dingxiangfei2009))
* `odbc` 表函数现在尊重 `external_table_functions_use_nulls` 设置. [#7506](https://github.com/ClickHouse/ClickHouse/pull/7506) ([Vasily Nemkov](https://github.com/Enmk))
* 修复了导致罕见数据竞争的错误. [#8143](https://github.com/ClickHouse/ClickHouse/pull/8143) ([Alexander Kazakov](https://github.com/Akazz))
* 现在`SYSTEM RELOAD DICTIONARY` 完全重新加载字典, 忽略`update_field`. 这修复了 [#7440](https://github.com/ClickHouse/ClickHouse/issues/7440). [#8037](https://github.com/ClickHouse/ClickHouse/pull/8037) ([Vitaly Baranov](https://github.com/vitlibar))
* 添加检查创建查询中是否存在字典的功能. [#8032](https://github.com/ClickHouse/ClickHouse/pull/8032) ([alesapin](https://github.com/alesapin))
* 以 `Values` 格式修复 `Float*` 解析. 这修复了 [#7817](https://github.com/ClickHouse/ClickHouse/issues/7817). [#7870](https://github.com/ClickHouse/ClickHouse/pull/7870) ([tavplubix](https://github.com/tavplubix))
* 修复当我们无法在 `*MergeTree` 表引擎系列的某些后台操作中保留空间时崩溃. [#7873](https://github.com/ClickHouse/ClickHouse/pull/7873) ([Vladimir Chebotarev](https://github.com/excitoon))
* 修复当表包含 `SimpleAggregateFunction(LowCardinality)` 列时合并操作的崩溃. 这修复了 [#8515](https://github.com/ClickHouse/ClickHouse/issues/8515). [#8522](https://github.com/ClickHouse/ClickHouse/pull/8522) ([Azat Khuzhin](https://github.com/azat))
* 恢复对所有 ICU 语言环境的支持, 并添加对常量表达式应用排序规则的功能. 还将语言名称添加到 `system.collations` 表. [#8051](https://github.com/ClickHouse/ClickHouse/pull/8051) ([alesapin](https://github.com/alesapin))
* 修复了最小生命周期为零 (`LIFETIME(MIN 0 MAX N)`, `LIFETIME(N)`) 的外部字典不在后台更新时的错误. [#7983](https://github.com/ClickHouse/ClickHouse/pull/7983) ([alesapin](https://github.com/alesapin))
* 修复带有 ClickHouse 源的外部字典在查询中有子查询时崩溃. [#8351](https://github.com/ClickHouse/ClickHouse/pull/8351) ([Nikolai Kochetov](https://github.com/KochetovNicolai))
* 使用引擎 `URL` 修复表中文件扩展名的错误解析. 这修复了 [#8157](https://github.com/ClickHouse/ClickHouse/issues/8157). [#8419](https://github.com/ClickHouse/ClickHouse/pull/8419) ([Andrey Bodrov](https://github.com/apbodrov))
* 修复没有键的 `*MergeTree` 表的 `CHECK TABLE` 查询. 修复[#7543](https://github.com/ClickHouse/ClickHouse/issues/7543). [#7979](https://github.com/ClickHouse/ClickHouse/pull/7979) ([alesapin](https://github.com/alesapin))
* 修复了 `Float64` 到 MySQL 类型的转换. [#8079](https://github.com/ClickHouse/ClickHouse/pull/8079) ([Yuriy Baranov](https://github.com/yurriy))
* 现在如果表因为服务器崩溃而没有完全删除, 服务器将尝试恢复并加载它. [#8176](https://github.com/ClickHouse/ClickHouse/pull/8176) ([tavplubix](https://github.com/tavplubix))
* 修复了表函数 `file` 在插入不存在的文件时崩溃的问题. 现在在这种情况下将创建文件, 然后将处理插入. [#8177](https://github.com/ClickHouse/ClickHouse/pull/8177) ([Olga Khvostikova](https://github.com/stavrolia))
* 修复启用 `trace_log` 时可能发生的罕见死锁. [#7838](https://github.com/ClickHouse/ClickHouse/pull/7838) ([filimonov](https://github.com/filimonov))
* 在从 DDL 查询创建的 `RangeHashed` 外部字典中添加除 `Date` 之外的不同类型的处理能力. 修复 [7899](https://github.com/ClickHouse/ClickHouse/issues/7899). [#8275](https://github.com/ClickHouse/ClickHouse/pull/8275) ([alesapin](https://github.com/alesapin))
* 修复了当使用另一个函数的结果调用 `now64()` 时崩溃的问题. [#8270](https://github.com/ClickHouse/ClickHouse/pull/8270) ([Vasily Nemkov](https://github.com/Enmk))
* 修复了通过 mysql 线路协议检测连接的客户端 IP 的错误. [#7743](https://github.com/ClickHouse/ClickHouse/pull/7743) ([Dmitry Muzyka](https://github.com/dmitriy-myz))
* 修复 `arraySplit` 函数中的空数组处理. 这修复了 [#7708](https://github.com/ClickHouse/ClickHouse/issues/7708). [#7747](https://github.com/ClickHouse/ClickHouse/pull/7747) ([hcz](https://github.com/hczhcz))
* 修复了另一个正在运行的 `clickhouse-server` 的 `pid-file` 可能会被删除的问题. [#8487](https://github.com/ClickHouse/ClickHouse/pull/8487) ([Weiqing Xu](https://github.com/weiqxu))
* 修复字典重新加载, 如果它有 `invalidate_query`，它会停止更新, 并且在之前的更新尝试中出现一些异常. [#8029](https://github.com/ClickHouse/ClickHouse/pull/8029) ([alesapin](https://github.com/alesapin))
* 修复了函数 `arrayReduce` 中可能导致 `double free` 的错误和聚合函数组合器 `Resample` 中可能导致内存泄漏的错误. 添加了聚合函数 `aggThrow`. 此功能可用于测试目的. [#8446](https://github.com/ClickHouse/ClickHouse/pull/8446) ([alexey-milovidov](https://github.com/alexey-milovidov))

#### 改进
* 使用 `S3` 表引擎时改进了日志记录. [#8251](https://github.com/ClickHouse/ClickHouse/pull/8251) ([Grigory Pervakov](https://github.com/GrigoryPervakov))
* 调用 `clickhouse-local` 时没有传递参数时打印帮助消息. 这修复了 [#5335](https://github.com/ClickHouse/ClickHouse/issues/5335). [#8230](https://github.com/ClickHouse/ClickHouse/pull/8230) ([Andrey Nagorny](https://github.com/Melancholic))
* 添加设置 `mutations_sync` 允许同步等待 `ALTER UPDATE/DELETE` 查询. [#8237](https://github.com/ClickHouse/ClickHouse/pull/8237) ([alesapin](https://github.com/alesapin))
* 允许在 `config.xml` 中设置相关的 `user_files_path` (类似于 `format_schema_path` ). [#7632](https://github.com/ClickHouse/ClickHouse/pull/7632) ([hcz](https://github.com/hczhcz))
* 为带有 `-OrZero` 后缀的转换函数添加非法类型的例外. [#7880](https://github.com/ClickHouse/ClickHouse/pull/7880) ([Andrey Konyaev](https://github.com/akonyaev90))
* 简化分布式查询中发送到分片的数据头格式. [#8044](https://github.com/ClickHouse/ClickHouse/pull/8044) ([Vitaly Baranov](https://github.com/vitlibar))
* `Live View` 表引擎重构. [#8519](https://github.com/ClickHouse/ClickHouse/pull/8519) ([vzakaznikov](https://github.com/vzakaznikov))
* 为从 DDL 查询创建的外部词典添加额外检查. [#8127](https://github.com/ClickHouse/ClickHouse/pull/8127) ([alesapin](https://github.com/alesapin))
* 修复错误 `Column ... already exists` , 同时使用 `FINAL` 和 `SAMPLE`, 例如 `select count() from table final sample 1/2`. 修复 [#5186](https://github.com/ClickHouse/ClickHouse/issues/5186). [#7907](https://github.com/ClickHouse/ClickHouse/pull/7907) ([Nikolai Kochetov](https://github.com/KochetovNicolai))
* 现在表 `joinGet` 函数的第一个参数可以是表标识符. [#7707](https://github.com/ClickHouse/ClickHouse/pull/7707) ([Amos Bird](https://github.com/amosbird))
* 允许将 `MaterializedView` 与 `Kafka` 表上方的子查询一起使用. [#8197](https://github.com/ClickHouse/ClickHouse/pull/8197) ([filimonov](https://github.com/filimonov))
* 现在磁盘之间的后台移动在单独的线程池中运行它. [#7670](https://github.com/ClickHouse/ClickHouse/pull/7670) ([Vladimir Chebotarev](https://github.com/excitoon))
* `SYSTEM RELOAD DICTIONARY` 现在同步执行. [#8240](https://github.com/ClickHouse/ClickHouse/pull/8240) ([Vitaly Baranov](https://github.com/vitlibar))
* 堆栈跟踪现在显示物理地址 (目标文件中的偏移量) 而不是虚拟内存地址 (加载目标文件的位置). 当二进制文件与位置无关且 ASLR 处于活动状态时, 这允许使用 `addr2line`. 这修复了[#8360](https://github.com/ClickHouse/ClickHouse/issues/8360). [#8387](https://github.com/ClickHouse/ClickHouse/pull/8387) ([alexey-milovidov](https://github.com/alexey-milovidov))
* 支持行级安全过滤器的新语法: `<table name='table_name'>...</table>`. 修复 [#5779](https://github.com/ClickHouse/ClickHouse/issues/5779). [#8381](https://github.com/ClickHouse/ClickHouse/pull/8381) ([Ivan](https://github.com/abyss7))
* 现在 `cityHash` 函数可以处理 `Decimal` 和 `UUID` 类型. 修复 [#5184](https://github.com/ClickHouse/ClickHouse/issues/5184). [#7693](https://github.com/ClickHouse/ClickHouse/pull/7693) ([Mikhail Korotov](https://github.com/millb))
* 从系统日志中删除了固定索引粒度 (它是 1024), 因为它在实现自适应粒度后已过时. [#7698](https://github.com/ClickHouse/ClickHouse/pull/7698) ([alexey-milovidov](https://github.com/alexey-milovidov))
* 在不使用 SSL 的情况下编译 ClickHouse 时启用 MySQL 兼容性服务器. [#7852](https://github.com/ClickHouse/ClickHouse/pull/7852) ([Yuriy Baranov](https://github.com/yurriy))
* 现在服务器校验和分布式批处理, 这会在批处理损坏的数据的情况下提供更详细的错误. [#7914](https://github.com/ClickHouse/ClickHouse/pull/7914) ([Azat Khuzhin](https://github.com/azat))
* 支持 `DROP DATABASE`、`DETACH TABLE`、`DROP TABLE`和 `ATTACH TABLE` 用于 `MySQL` 数据库引擎. [#8202](https://github.com/ClickHouse/ClickHouse/pull/8202) ([Winter Zhang](https://github.com/zhang2014))
* 在 S3 表函数和表引擎中添加身份验证. [#7623](https://github.com/ClickHouse/ClickHouse/pull/7623) ([Vladimir Chebotarev](https://github.com/excitoon))
* 添加了对不同磁盘上 `MergeTree` 额外部分的检查, 以免遗漏未定义磁盘上的数据部分. [#8118](https://github.com/ClickHouse/ClickHouse/pull/8118) ([Vladimir Chebotarev](https://github.com/excitoon))
* 为 Mac 客户端和服务器启用 SSL 支持. [#8297](https://github.com/ClickHouse/ClickHouse/pull/8297) ([Ivan](https://github.com/abyss7))
* 现在 ClickHouse 可以用作 MySQL 联合服务器 (请参阅 https://dev.mysql.com/doc/refman/5.7/en/federated-create-server.html). [#7717](https://github.com/ClickHouse/ClickHouse/pull/7717) ([Maxim Fedotov](https://github.com/MaxFedotov))
* `clickhouse-client` 现在仅在开启多查询且关闭多行时启用 `bracketed-paste` . 这修复了 [#7757](https://github.com/ClickHouse/ClickHouse/issues/7757). [#7761](https://github.com/ClickHouse/ClickHouse/pull/7761) ([Amos Bird](https://github.com/amosbird))
* 在 `if` 函数中支持 `Array(Decimal)`. [#7721](https://github.com/ClickHouse/ClickHouse/pull/7721) ([Artem Zuikov](https://github.com/4ertus2))
* 在 `arrayDifference`、`arrayCumSum` 和 `arrayCumSumNegative` 函数中支持小数. [#7724](https://github.com/ClickHouse/ClickHouse/pull/7724) ([Artem Zuikov](https://github.com/4ertus2))
* 向 `system.dictionaries` 表添加了 `lifetime` 列. [#6820](https://github.com/ClickHouse/ClickHouse/issues/6820) [#7727](https://github.com/ClickHouse/ClickHouse/pull/7727) ([kekekekule](https://github.com/kekekekule))
* 改进了对 `*MergeTree` 表引擎不同磁盘上现有部分的检查. 地址 [#7660](https://github.com/ClickHouse/ClickHouse/issues/7660). [#8440](https://github.com/ClickHouse/ClickHouse/pull/8440) ([Vladimir Chebotarev](https://github.com/excitoon))
* 与用于 `S3` 交互的 `AWS SDK` 集成, 允许开箱即用地使用所有 S3 功能. [#8011](https://github.com/ClickHouse/ClickHouse/pull/8011) ([Pavel Kovalenko](https://github.com/Jokser))
* 添加了对 `Live View` 表中子查询的支持. [#7792](https://github.com/ClickHouse/ClickHouse/pull/7792) ([vzakaznikov](https://github.com/vzakaznikov))
* 删除了从 `TTL` 表达式中检查使用 `Date` 或 `DateTime` 列的情况. [#7920](https://github.com/ClickHouse/ClickHouse/pull/7920) ([Vladimir Chebotarev](https://github.com/excitoon))
* 有关磁盘的信息已添加到 `system.detached_parts` 表. [#7833](https://github.com/ClickHouse/ClickHouse/pull/7833) ([Vladimir Chebotarev](https://github.com/excitoon))
* 现在可以在不重启的情况下更改设置 `max_(table|partition)_size_to_drop`. [#7779](https://github.com/ClickHouse/ClickHouse/pull/7779) ([Grigory Pervakov](https://github.com/GrigoryPervakov))
* 错误消息的可用性略好. 要求用户不要删除 `Stack trace:` 下面的行. [#7897](https://github.com/ClickHouse/ClickHouse/pull/7897) ([alexey-milovidov](https://github.com/alexey-milovidov))
* 在 [#7935](https://github.com/ClickHouse/ClickHouse/issues/7935) 之后，更好地读取来自 `Kafka` 引擎的各种格式的消息. [#8035](https://github.com/ClickHouse/ClickHouse/pull/8035) ([Ivan](https://github.com/abyss7))
* 更好地兼容不支持 `sha2_password` 认证插件的 MySQL 客户端. [#8036](https://github.com/ClickHouse/ClickHouse/pull/8036) ([Yuriy Baranov](https://github.com/yurriy))
* 在 MySQL 兼容服务器中支持更多的列类型. [#7975](https://github.com/ClickHouse/ClickHouse/pull/7975) ([Yuriy Baranov](https://github.com/yurriy))
* 为带有底层 `MergeTree` 表的 `Merge`、`Buffer` 和 `Materialized View` 存储实现 `ORDER BY` 优化. [#8130](https://github.com/ClickHouse/ClickHouse/pull/8130) ([Anton Popov](https://github.com/CurtizJ))
* 现在我们总是使用 `getrandom` 的POSIX实现来更好地兼容旧内核 (< 3.17). [#7940](https://github.com/ClickHouse/ClickHouse/pull/7940) ([Amos Bird](https://github.com/amosbird))
* 更好地检查移动 TTL 规则中的有效目的地. [#8410](https://github.com/ClickHouse/ClickHouse/pull/8410) ([Vladimir Chebotarev](https://github.com/excitoon))
* 更好地检查 `Distributed` 表引擎的损坏插入批次. [#7933](https://github.com/ClickHouse/ClickHouse/pull/7933) ([Azat Khuzhin](https://github.com/azat))
* 将带有突变必须在未来处理的部分名称数组的列添加到 `system.mutations` 表. [#8179](https://github.com/ClickHouse/ClickHouse/pull/8179) ([alesapin](https://github.com/alesapin))
* 处理器的并行归并排序优化. [#8552](https://github.com/ClickHouse/ClickHouse/pull/8552) ([Nikolai Kochetov](https://github.com/KochetovNicolai))
* 设置 `mark_cache_min_lifetime` 现在已经过时并且什么都不做. 在以前的版本中, 标记缓存可以在大于 `mark_cache_size` 的内存中增长, 以在 `mark_cache_min_lifetime` 秒内容纳数据. 这导致混乱和比预期更高的内存使用量, 这在内存受限的系统上尤其糟糕. 如果您在安装此版本后发现性能下降, 您应该增加 `mark_cache_size`. [#8484](https://github.com/ClickHouse/ClickHouse/pull/8484) ([alexey-milovidov](https://github.com/alexey-milovidov))
* 准备在任何地方使用 `tid`. 这是 [#7477](https://github.com/ClickHouse/ClickHouse/issues/7477) 所必需的. [#8276](https://github.com/ClickHouse/ClickHouse/pull/8276) ([alexey-milovidov](https://github.com/alexey-milovidov))

#### 性能改进
* 处理器管道中的性能优化. [#7988](https://github.com/ClickHouse/ClickHouse/pull/7988) ([Nikolai Kochetov](https://github.com/KochetovNicolai))
* 缓存字典中过期键的非阻塞更新 (具有读取旧键的权限). [#8303](https://github.com/ClickHouse/ClickHouse/pull/8303) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov))
* 全局编译不带 `-fno-omit-frame-pointer` 的 ClickHouse 以节省一个寄存器. [#8097](https://github.com/ClickHouse/ClickHouse/pull/8097) ([Amos Bird](https://github.com/amosbird))
* 加速 `greatCircleDistance` 函数并为其添加性能测试. [#7307](https://github.com/ClickHouse/ClickHouse/pull/7307) ([Olga Khvostikova](https://github.com/stavrolia))
* 改进功能 `roundDown` 的性能. [#8465](https://github.com/ClickHouse/ClickHouse/pull/8465) ([alexey-milovidov](https://github.com/alexey-milovidov))
* 改进了 `DateTime64` 数据类型的 `max`、`min`、`argMin`、`argMax`的性能. [#8199](https://github.com/ClickHouse/ClickHouse/pull/8199) ([Vasily Nemkov](https://github.com/Enmk))
* 改进了无限制或大限制和外部排序的排序性能. [#8545](https://github.com/ClickHouse/ClickHouse/pull/8545) ([alexey-milovidov](https://github.com/alexey-milovidov))
* 格式化浮点数的性能提高了 6 倍. [#8542](https://github.com/ClickHouse/ClickHouse/pull/8542) ([alexey-milovidov](https://github.com/alexey-milovidov))
* 改进了 `modulo` 函数的性能. [#7750](https://github.com/ClickHouse/ClickHouse/pull/7750) ([Amos Bird](https://github.com/amosbird))
* 优化了`ORDER BY` 并与单列键合并. [#8335](https://github.com/ClickHouse/ClickHouse/pull/8335) ([alexey-milovidov](https://github.com/alexey-milovidov))
* 更好地实现 `arrayReduce`、`-Array` 和 `-State` 组合器.  [#7710](https://github.com/ClickHouse/ClickHouse/pull/7710) ([Amos Bird](https://github.com/amosbird))
* 现在 `PREWHERE` 应该被优化为至少和 `WHERE` 一样有效. [#7769](https://github.com/ClickHouse/ClickHouse/pull/7769) ([Amos Bird](https://github.com/amosbird))
* 改进 `round` 和 `roundBankers` 处理负数的方式. [#8229](https://github.com/ClickHouse/ClickHouse/pull/8229) ([hcz](https://github.com/hczhcz))
* 将 `DoubleDelta` 和 `Gorilla` 编解码器的解码性能提高了大约 30-40%. 这修复了 [#7082](https://github.com/ClickHouse/ClickHouse/issues/7082). [#8019](https://github.com/ClickHouse/ClickHouse/pull/8019) ([Vasily Nemkov](https://github.com/Enmk))
* 改进了 `base64` 相关功能的性能. [#8444](https://github.com/ClickHouse/ClickHouse/pull/8444) ([alexey-milovidov](https://github.com/alexey-milovidov))
* 添加了一个功能`geoDistance`. 它类似于 `greatCircleDistance`, 但使用对 WGS-84 椭球模型的近似. 两种功能的性能几乎相同. [#8086](https://github.com/ClickHouse/ClickHouse/pull/8086) ([alexey-milovidov](https://github.com/alexey-milovidov))
* `Decimal` 数据类型的更快的 `min` 和 `max` 聚合函数. [#8144](https://github.com/ClickHouse/ClickHouse/pull/8144) ([Artem Zuikov](https://github.com/4ertus2))
* 向量化处理`arrayReduce`. [#7608](https://github.com/ClickHouse/ClickHouse/pull/7608) ([Amos Bird](https://github.com/amosbird))
* `if` 链现在优化为 `multiIf`. [#8355](https://github.com/ClickHouse/ClickHouse/pull/8355) ([kamalov-ruslan](https://github.com/kamalov-ruslan))
* 修复了 19.15 中引入的 `Kafka` 表引擎的性能回归. 这修复了 [#7261](https://github.com/ClickHouse/ClickHouse/issues/7261). [#7935](https://github.com/ClickHouse/ClickHouse/pull/7935) ([filimonov](https://github.com/filimonov))
* 删除了 Debian 软件包中的 `gcc` 偶尔会在默认情况下带来的 'pie' 代码生成. [#8483](https://github.com/ClickHouse/ClickHouse/pull/8483) ([alexey-milovidov](https://github.com/alexey-milovidov))
* 并行解析数据格式. [#6553](https://github.com/ClickHouse/ClickHouse/pull/6553) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov))
* 默认情况下启用带有表达式的“值”的优化解析器 (`input_format_values_deduce_templates_of_expressions=1`). [#8231](https://github.com/ClickHouse/ClickHouse/pull/8231) ([tavplubix](https://github.com/tavplubix))

#### 构建/测试/打包改进
* 为 `ARM` 和最小模式构建修复. [#8304](https://github.com/ClickHouse/ClickHouse/pull/8304) ([proller](https://github.com/proller))
* 未调用 std::atexit 时为 `clickhouse-server` 添加覆盖文件刷新. 还略微改进了具有覆盖率的无状态测试的日志记录. [#8267](https://github.com/ClickHouse/ClickHouse/pull/8267) ([alesapin](https://github.com/alesapin))
* 在 contrib 中更新 LLVM 库. 避免使用 OS 包中的 LLVM. [#8258](https://github.com/ClickHouse/ClickHouse/pull/8258) ([alexey-milovidov](https://github.com/alexey-milovidov))
* 使捆绑的 `curl` 构建完全安静. [#8232](https://github.com/ClickHouse/ClickHouse/pull/8232) [#8203](https://github.com/ClickHouse/ClickHouse/pull/8203) ([Pavel Kovalenko](https://github.com/Jokser))
* 修复一些 `MemorySanitizer` 警告. [#8235](https://github.com/ClickHouse/ClickHouse/pull/8235) ([Alexander Kuzmenkov](https://github.com/akuzm))
* 在 `CMakeLists.txt` 中使用 `add_warning` 和 `no_warning` 宏. [#8604](https://github.com/ClickHouse/ClickHouse/pull/8604) ([Ivan](https://github.com/abyss7))
* 添加对 Minio S3 兼容对象 (https://min.io/) 的支持以进行更好的集成测试. [#7863](https://github.com/ClickHouse/ClickHouse/pull/7863) [#7875](https://github.com/ClickHouse/ClickHouse/pull/7875) ([Pavel Kovalenko](https://github.com/Jokser))
* 将 `libc` 头文件导入到 contrib. 它允许在各种系统之间使构建更加一致 (仅适用于 `x86_64-linux-gnu`). [#5773](https://github.com/ClickHouse/ClickHouse/pull/5773) ([alexey-milovidov](https://github.com/alexey-milovidov))
* 从某些库中删除 `-fPIC`. [#8464](https://github.com/ClickHouse/ClickHouse/pull/8464) ([alexey-milovidov](https://github.com/alexey-milovidov))
* 为 curl 清理 `CMakeLists.txt`. 见 https://github.com/ClickHouse/ClickHouse/pull/8011#issuecomment-569478910 [#8459](https://github.com/ClickHouse/ClickHouse/pull/8459) ([alexey-milovidov](https://github.com/alexey-milovidov))
* `CapNProto` 库中的静默警告. [#8220](https://github.com/ClickHouse/ClickHouse/pull/8220) ([alexey-milovidov](https://github.com/alexey-milovidov))
* 为短字符串优化哈希表添加性能测试. [#7679](https://github.com/ClickHouse/ClickHouse/pull/7679) ([Amos Bird](https://github.com/amosbird))
* 现在, 即使 `MADV_FREE` 不可用, ClickHouse 也将构建在 `AArch64` 上. 这修复了 [#8027](https://github.com/ClickHouse/ClickHouse/issues/8027). [#8243](https://github.com/ClickHouse/ClickHouse/pull/8243) ([Amos Bird](https://github.com/amosbird))
* 更新 `zlib-ng` 以修复内存清理器问题. [#7182](https://github.com/ClickHouse/ClickHouse/pull/7182) [#8206](https://github.com/ClickHouse/ClickHouse/pull/8206) ([Alexander Kuzmenkov](https://github.com/akuzm))
* 在非 Linux 系统上启用内部 MySQL 库, 因为 OS 包的使用非常脆弱, 通常根本不起作用. 这修复了 [#5765](https://github.com/ClickHouse/ClickHouse/issues/5765). [#8426](https://github.com/ClickHouse/ClickHouse/pull/8426) ([alexey-milovidov](https://github.com/alexey-milovidov))
* 修复了启用 `libc++` 后在某些系统上的构建. 这取代了 [#8374](https://github.com/ClickHouse/ClickHouse/issues/8374). [#8380](https://github.com/ClickHouse/ClickHouse/pull/8380) ([alexey-milovidov](https://github.com/alexey-milovidov))
* 使 `Field` 方法更加类型安全以查找更多错误. [#7386](https://github.com/ClickHouse/ClickHouse/pull/7386) [#8209](https://github.com/ClickHouse/ClickHouse/pull/8209) ([Alexander Kuzmenkov](https://github.com/akuzm))
* 将缺失的文件添加到 `libc-headers` 子模块. [#8507](https://github.com/ClickHouse/ClickHouse/pull/8507) ([alexey-milovidov](https://github.com/alexey-milovidov))
* 修复性能测试输出中错误的 `JSON` 引用. [#8497](https://github.com/ClickHouse/ClickHouse/pull/8497) ([Nikolai Kochetov](https://github.com/KochetovNicolai))
* 现在为 `std::exception` 和 `Poco::Exception` 显示堆栈跟踪. 在以前的版本中, 它仅适用于`DB::Exception`. 这改进了诊断. [#8501](https://github.com/ClickHouse/ClickHouse/pull/8501) ([alexey-milovidov](https://github.com/alexey-milovidov))
* 为新的 glibc 版本移植 `clock_gettime` 和 `clock_nanosleep`. [#8054](https://github.com/ClickHouse/ClickHouse/pull/8054) ([Amos Bird](https://github.com/amosbird))
* 在示例配置中为开发人员启用`part_log`. [#8609](https://github.com/ClickHouse/ClickHouse/pull/8609) ([alexey-milovidov](https://github.com/alexey-milovidov))
* 修复 `01036_no_superfluous_dict_reload_on_create_database*` 中重新加载的异步性质. [#8111](https://github.com/ClickHouse/ClickHouse/pull/8111) ([Azat Khuzhin](https://github.com/azat))
* 修复编解码器性能测试. [#8615](https://github.com/ClickHouse/ClickHouse/pull/8615) ([Vasily Nemkov](https://github.com/Enmk))
* 为 `.tgz` 构建和文档添加安装脚本. [#8612](https://github.com/ClickHouse/ClickHouse/pull/8612) [#8591](https://github.com/ClickHouse/ClickHouse/pull/8591) ([alesapin](https://github.com/alesapin))
* 删除了旧的 `ZSTD` 测试 (它是在 2016 年创建的, 用于重现 ZSTD 1.0 版之前的错误). 这修复了 [#8618](https://github.com/ClickHouse/ClickHouse/issues/8618). [#8619](https://github.com/ClickHouse/ClickHouse/pull/8619) ([alexey-milovidov](https://github.com/alexey-milovidov))
* 修复了 Mac OS Catalina 上的构建. [#8600](https://github.com/ClickHouse/ClickHouse/pull/8600) ([meo](https://github.com/meob))
* 增加编解码器性能测试中的行数, 使结果更显着. [#8574](https://github.com/ClickHouse/ClickHouse/pull/8574) ([Vasily Nemkov](https://github.com/Enmk))
* 在调试版本中, 将 `LOGICAL_ERROR` 异常视为断言失败, 以便它们更容易被注意到. [#8475](https://github.com/ClickHouse/ClickHouse/pull/8475) ([Alexander Kuzmenkov](https://github.com/akuzm))
* 使与格式相关的性能测试更具确定性. [#8477](https://github.com/ClickHouse/ClickHouse/pull/8477) ([alexey-milovidov](https://github.com/alexey-milovidov))
* 更新 `lz4` 以修复 MemorySanitizer 故障. [#8181](https://github.com/ClickHouse/ClickHouse/pull/8181) ([Alexander Kuzmenkov](https://github.com/akuzm))
* 在异常处理中抑制已知的 MemorySanitizer 误报. [#8182](https://github.com/ClickHouse/ClickHouse/pull/8182) ([Alexander Kuzmenkov](https://github.com/akuzm))
* 将 `gcc` 和 `g++` 更新到 `build/docker/build.sh` 中的版本 9. [#7766](https://github.com/ClickHouse/ClickHouse/pull/7766) ([TLightSky](https://github.com/tlightsky))
* 添加性能测试用例来测试 `PREWHERE` 比 `WHERE` 差.  [#7768](https://github.com/ClickHouse/ClickHouse/pull/7768) ([Amos Bird](https://github.com/amosbird))
* 修复一个不稳定的测试的进展. [#8621](https://github.com/ClickHouse/ClickHouse/pull/8621) ([alexey-milovidov](https://github.com/alexey-milovidov))
* 避免对来自`libunwind` 的数据进行 MemorySanitizer 报告. [#8539](https://github.com/ClickHouse/ClickHouse/pull/8539) ([alexey-milovidov](https://github.com/alexey-milovidov))
* 将 `libc++` 更新到最新版本. [#8324](https://github.com/ClickHouse/ClickHouse/pull/8324) ([alexey-milovidov](https://github.com/alexey-milovidov))
* 从源代码构建 ICU 库. 这修复了 [#6460](https://github.com/ClickHouse/ClickHouse/issues/6460). [#8219](https://github.com/ClickHouse/ClickHouse/pull/8219) ([alexey-milovidov](https://github.com/alexey-milovidov))
* 从 `libressl` 切换到 `openssl`. 在此更改后，ClickHouse 应支持 TLS 1.3 和 SNI. 这修复了[#8171](https://github.com/ClickHouse/ClickHouse/issues/8171). [#8218](https://github.com/ClickHouse/ClickHouse/pull/8218) ([alexey-milovidov](https://github.com/alexey-milovidov))
* 修复了从 SSL 使用 `chacha20_poly1305` 时的 UBSan 报告 (发生在连接到 https://yandex.ru/ 时). [#8214](https://github.com/ClickHouse/ClickHouse/pull/8214) ([alexey-milovidov](https://github.com/alexey-milovidov))
* 修复`.deb` linux 发行版的默认密码文件模式. [#8075](https://github.com/ClickHouse/ClickHouse/pull/8075) ([proller](https://github.com/proller))
* 改进了在 `clickhouse-test` 中获取 `clickhouse-server` PID 的表达式. [#8063](https://github.com/ClickHouse/ClickHouse/pull/8063) ([Alexander Kazakov](https://github.com/Akazz))
* 将 contrib/googletest 更新到 v1.10.0. [#8587](https://github.com/ClickHouse/ClickHouse/pull/8587) ([Alexander Burmak](https://github.com/Alex-Burmak))
* 修复了 `base64` 库中的 ThreadSaninitizer 报告. 也把这个库更新到了最新版本, 不过没关系. 这修复了 [#8397](https://github.com/ClickHouse/ClickHouse/issues/8397). [#8403](https://github.com/ClickHouse/ClickHouse/pull/8403) ([alexey-milovidov](https://github.com/alexey-milovidov))
* 修复处理器的 `00600_replace_running_query` . [#8272](https://github.com/ClickHouse/ClickHouse/pull/8272) ([Nikolai Kochetov](https://github.com/KochetovNicolai))
* 删除对 `tcmalloc` 的支持, 使 `CMakeLists.txt` 更简单. [#8310](https://github.com/ClickHouse/ClickHouse/pull/8310) ([alexey-milovidov](https://github.com/alexey-milovidov))
* 发布 gcc 构建现在使用 `libc++` 而不是 `libstdc++`. 最近 `libc++` 只与clang 一起使用. 这将提高构建配置和可移植性的一致性. [#8311](https://github.com/ClickHouse/ClickHouse/pull/8311) ([alexey-milovidov](https://github.com/alexey-milovidov))
* 启用 ICU 库以使用 MemorySanitizer 进行构建. [#8222](https://github.com/ClickHouse/ClickHouse/pull/8222) ([alexey-milovidov](https://github.com/alexey-milovidov))
* 抑制来自 `CapNProto` 库的警告. [#8224](https://github.com/ClickHouse/ClickHouse/pull/8224) ([alexey-milovidov](https://github.com/alexey-milovidov))
* 删除了 `tcmalloc` 代码的特殊情况, 因为它不再受支持. [#8225](https://github.com/ClickHouse/ClickHouse/pull/8225) ([alexey-milovidov](https://github.com/alexey-milovidov))
* 在 CI 覆盖任务中, 优雅地杀死服务器以允许它保存覆盖报告. 这修复了我们最近看到的不完整的覆盖报告. [#8142](https://github.com/ClickHouse/ClickHouse/pull/8142) ([alesapin](https://github.com/alesapin))
* 针对 `Float64` 和 `UInt64` 值对所有编解码器进行性能测试. [#8349](https://github.com/ClickHouse/ClickHouse/pull/8349) ([Vasily Nemkov](https://github.com/Enmk))
* `termcap` 非常不推荐使用并导致各种问题 (例如, 缺少“up”cap 和回显 `^J` 而不是多行). 支持`terminfo` 或捆绑 `ncurses`. [#7737](https://github.com/ClickHouse/ClickHouse/pull/7737) ([Amos Bird](https://github.com/amosbird))
* 修复 `test_storage_s3` 集成测试. [#7734](https://github.com/ClickHouse/ClickHouse/pull/7734) ([Nikolai Kochetov](https://github.com/KochetovNicolai))
* 支持 `StorageFile(<format>, null)` 将块插入给定的格式文件而不实际写入磁盘. 这是性能测试所必需的. [#8455](https://github.com/ClickHouse/ClickHouse/pull/8455) ([Amos Bird](https://github.com/amosbird))
* 向功能测试添加了参数 `--print-time`, 用于打印每个测试的执行时间. [#8001](https://github.com/ClickHouse/ClickHouse/pull/8001) ([Nikolai Kochetov](https://github.com/KochetovNicolai))
* 在评估 RPN 时向 `KeyCondition` 添加断言. 这将修复来自 gcc-9 的警告. [#8279](https://github.com/ClickHouse/ClickHouse/pull/8279) ([alexey-milovidov](https://github.com/alexey-milovidov))
* 在 CI 构建中转储 cmake 选项. [#8273](https://github.com/ClickHouse/ClickHouse/pull/8273) ([Alexander Kuzmenkov](https://github.com/akuzm))
* 不要为某些胖库生成调试信息. [#8271](https://github.com/ClickHouse/ClickHouse/pull/8271) ([alexey-milovidov](https://github.com/alexey-milovidov))
* 使 `log_to_console.xml` 始终登录到 stderr, 无论它是否交互. [#8395](https://github.com/ClickHouse/ClickHouse/pull/8395) ([Alexander Kuzmenkov](https://github.com/akuzm))
* 从 `clickhouse-performance-test` 工具中删除了一些未使用的功能. [#8555](https://github.com/ClickHouse/ClickHouse/pull/8555) ([alexey-milovidov](https://github.com/alexey-milovidov))
* 现在我们还将搜索带有相应 `clang-X` 版本的 `lld-X`. [#8092](https://github.com/ClickHouse/ClickHouse/pull/8092) ([alesapin](https://github.com/alesapin))
* Parquet 构建改进. [#8421](https://github.com/ClickHouse/ClickHouse/pull/8421) ([maxulan](https://github.com/maxulan))
* 更多 GCC 警告. [#8221](https://github.com/ClickHouse/ClickHouse/pull/8221) ([kreuzerkrieg](https://github.com/kreuzerkrieg))
* Arch Linux 软件包现在允许运行 ClickHouse 服务器, 而不仅仅是客户端. [#8534](https://github.com/ClickHouse/ClickHouse/pull/8534) ([Vladimir Chebotarev](https://github.com/excitoon))
* 使用处理器修复测试. 微小的性能修复. [#7672](https://github.com/ClickHouse/ClickHouse/pull/7672) ([Nikolai Kochetov](https://github.com/KochetovNicolai))
* 更新 contrib/protobuf. [#8256](https://github.com/ClickHouse/ClickHouse/pull/8256) ([Matwey V. Kornilov](https://github.com/matwey))
* 准备切换到 c++20 作为新年庆祝活动. "May the C++ force be with ClickHouse". [#8447](https://github.com/ClickHouse/ClickHouse/pull/8447) ([Amos Bird](https://github.com/amosbird))

#### 实验功能
* 添加了实验设置 `min_bytes_to_use_mmap_io`. 它允许读取大文件而无需将数据从内核复制到用户空间. 默认情况下禁用该设置. 推荐的阈值大约是 64 MB, 因为 mmap/munmap 很慢. [#8520](https://github.com/ClickHouse/ClickHouse/pull/8520) ([alexey-milovidov](https://github.com/alexey-milovidov))
* 重新设计配额作为访问控制系统的一部分. 添加了新表 `system.quotas`、新函数 `currentQuota`、`currentQuotaKey`、新SQL语法 `CREATE QUOTA`、`ALTER QUOTA`、`DROP QUOTA`、`SHOW QUOTA`. [#7257](https://github.com/ClickHouse/ClickHouse/pull/7257) ([Vitaly Baranov](https://github.com/vitlibar))
* 允许跳过带有警告的未知设置而不是抛出异常. [#7653](https://github.com/ClickHouse/ClickHouse/pull/7653) ([Vitaly Baranov](https://github.com/vitlibar))
* 重新设计行策略作为访问控制系统的一部分. 添加新表`system.row_policies`、新函数 `currentRowPolicies()`、新SQL语法 `CREATE POLICY`、`ALTER POLICY`、`DROP POLICY`、`SHOW CREATE POLICY`、`SHOW POLICIES`. [#7808](https://github.com/ClickHouse/ClickHouse/pull/7808) ([Vitaly Baranov](https://github.com/vitlibar))

#### Security Fix
* 修复了使用 `File` 表引擎读取表中目录结构的可能性. 这修复了 [#8536](https://github.com/ClickHouse/ClickHouse/issues/8536). [#8537](https://github.com/ClickHouse/ClickHouse/pull/8537) ([alexey-milovidov](https://github.com/alexey-milovidov))

## [Changelog for 2019](https://github.com/ClickHouse/ClickHouse/blob/master/docs/en/whats-new/changelog/2019.md)
