## ClickHouse 版本 19.17 {#clickhouse-release-v19-17}

### ClickHouse 版本 19.17.6.36, 2019-12-27 {#clickhouse-release-v19-17-6-36-2019-12-27}

#### Bug 修复 {#bug-fix}

-   修复了解压缩中潜在的缓冲区溢出. 恶意用户可以传递可能导致缓冲区读取的伪造压缩数据. 这个问题是由 Yandex 信息安全团队的 Eldar Zaitov 发现的. [#8404](https://github.com/ClickHouse/ClickHouse/pull/8404) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   修复了当服务器无法使用字符串数据类型的值 (需要 UTF-8 验证) 以 JSON 或 XML 格式发送或写入数据或使用 Brotli 算法或某些方式压缩结果数据时可能出现的服务器崩溃 ( `std::terminate` ) 其他罕见情况. [#8384](https://github.com/ClickHouse/ClickHouse/pull/8384) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   修复了来自 clickhouse `VIEW` 源的词典, 现在阅读此类词典不会导致错误 `There is no query`. [#8351](https://github.com/ClickHouse/ClickHouse/pull/8351) ([Nikolai Kochetov](https://github.com/KochetovNicolai))
-   修复了检查 users.xml 中指定的 host_regexp 是否允许客户端主机的问题. [#8241](https://github.com/ClickHouse/ClickHouse/pull/8241), [#8342](https://github.com/ClickHouse/ClickHouse/pull/8342) ([Vitaly Baranov](https://github.com/vitlibar))
-   分布式表的 `RENAME TABLE` 现在会在发送到分片之前重命名包含插入数据的文件夹. 这解决了连续重命名 `tableA->tableB`、`tableC->tableA` 的问题. [#8306](https://github.com/ClickHouse/ClickHouse/pull/8306) ([tavplubix](https://github.com/tavplubix))
-   由 DDL 查询创建的 `range_hashed` 外部字典现在允许任意数字类型的范围. [#8275](https://github.com/ClickHouse/ClickHouse/pull/8275) ([alesapin](https://github.com/alesapin))
-   修复了 `INSERT INTO table SELECT ... FROM mysql(...)` 表函数. [#8234](https://github.com/ClickHouse/ClickHouse/pull/8234) ([tavplubix](https://github.com/tavplubix))
-   复了插入不存在的文件时在 `INSERT INTO TABLE FUNCTION file()` 中的段错误. 现在在这种情况下将创建文件, 然后将处理插入. [#8177](https://github.com/ClickHouse/ClickHouse/pull/8177) ([Olga Khvostikova](https://github.com/stavrolia))
-   修复了聚合位图和标量位图相交时的位图和错误. [#8082](https://github.com/ClickHouse/ClickHouse/pull/8082) ([Yue Huang](https://github.com/moon03432))
-   修复了在没有 `TABLE` 或 `DICTIONARY` 限定符的情况下使用 `EXISTS` 查询时的段错误，就像 `EXISTS`. [#8213](https://github.com/ClickHouse/ClickHouse/pull/8213) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   修复了函数 `rand` 和 `randConstant` 在参数可为空的情况下的返回类型. 现在函数总是返回 `UInt32` 而不是 `Nullable(UInt32)`. [#8204](https://github.com/ClickHouse/ClickHouse/pull/8204) ([Nikolai Kochetov](https://github.com/KochetovNicolai))
-   修复了 `DROP DICTIONARY IF EXISTS db.dict`, 现在如果 `db` 不存在则不会抛出异常. [#8185](https://github.com/ClickHouse/ClickHouse/pull/8185) ([Vitaly Baranov](https://github.com/vitlibar))
-   如果由于服务器崩溃而没有完全删除表, 服务器将尝试恢复并加载它. [#8176](https://github.com/ClickHouse/ClickHouse/pull/8176) ([tavplubix](https://github.com/tavplubix))
-   如果有两个以上的分片本地表，则修复了分布式表的简单计数查询. [#8164](https://github.com/ClickHouse/ClickHouse/pull/8164) ([小路](https://github.com/nicelulu))
-   修复了导致 DB::BlockStreamProfileInfo::calculateRowsBeforeLimit() 中数据竞争的错误. [#8143](https://github.com/ClickHouse/ClickHouse/pull/8143) ([Alexander Kazakov](https://github.com/Akazz))
-   修复了在合并指定部分后立即执行的 `ALTER table MOVE part`, 这可能导致移动指定部分合并到的部分. 现在它正确地移动了指定的部分. [#8104](https://github.com/ClickHouse/ClickHouse/pull/8104) ([Vladimir Chebotarev](https://github.com/excitoon))
-   现在可以将字典的表达式指定为字符串. 这对于从非 ClickHouse 源中提取数据时计算属性很有用, 因为它允许对这些表达式使用非 ClickHouse 语法. [#8098](https://github.com/ClickHouse/ClickHouse/pull/8098) ([alesapin](https://github.com/alesapin))
-   修复了 `clickhouse-copier` 中由于 ZXid 溢出而导致的非常罕见的竞争. [#8088](https://github.com/ClickHouse/ClickHouse/pull/8088) ([Ding Xiang Fei](https://github.com/dingxiangfei2009))
-   修复了查询失败后 (例如由于"Too many simultaneous queries") 不会读取外部表信息的错误, 并且下一个请求会将此信息解释为下一个查询的开始, 从而导致 `Unknown packet from client`. [#8084](https://github.com/ClickHouse/ClickHouse/pull/8084) ([Azat Khuzhin](https://github.com/azat))
-   避免在"Unknown packet X from server"之后取消引用. [#8071](https://github.com/ClickHouse/ClickHouse/pull/8071) ([Azat Khuzhin](https://github.com/azat))
-   恢复对所有 ICU 语言环境的支持, 添加为常量表达式应用排序规则的功能, 并将语言名称添加到 system.collations 表. [#8051](https://github.com/ClickHouse/ClickHouse/pull/8051) ([alesapin](https://github.com/alesapin))
-   从 `StorageFile` 和 `StorageHDFS` 读取的流数量现在受到限制, 以避免超过内存限制. [#7981](https://github.com/ClickHouse/ClickHouse/pull/7981) ([alesapin](https://github.com/alesapin))
-   修复了没有键的 `*MergeTree` 表的 `CHECK TABLE` 查询. [#7979](https://github.com/ClickHouse/ClickHouse/pull/7979) ([alesapin](https://github.com/alesapin))
-   如果没有突变, 则从零件名称中删除了突变编号. 此删除改进了与旧版本的兼容性. [#8250](https://github.com/ClickHouse/ClickHouse/pull/8250) ([alesapin](https://github.com/alesapin))
-   修复部分附属部分由于 data_version 大于表突变版本而跳过突变的 bug. [#7812](https://github.com/ClickHouse/ClickHouse/pull/7812) ([Zhichang Yu](https://github.com/yuzhichang))
-   允许在将零件移动到另一台设备后使用零件的冗余副本启动服务器. [#7810](https://github.com/ClickHouse/ClickHouse/pull/7810) ([Vladimir Chebotarev](https://github.com/excitoon))
-   修复使用聚合函数列时可能出现的 `Sizes of columns does not match` 错误. [#7790](https://github.com/ClickHouse/ClickHouse/pull/7790) ([Boris Granveaud](https://github.com/bgranvea))
-   现在, 如果将 WITH TIES 与 LIMIT BY 一起使用, 则会抛出异常. 现在可以将 TOP 与 LIMIT BY 一起使用. [#7637](https://github.com/ClickHouse/ClickHouse/pull/7637) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov))
-   修复字典重新加载, 如果它有 `invalidate_query`, 它会停止更新并且在之前的更新尝试中出现一些异常. [#8029](https://github.com/ClickHouse/ClickHouse/pull/8029) ([alesapin](https://github.com/alesapin))

### ClickHouse 版本 19.17.4.11, 2019-11-22 {#clickhouse-release-v19-17-4-11-2019-11-22}

#### 向后不兼容的更新 {#backward-incompatible-change}

-   使用列而不是 AST 来存储标量子查询结果以获得更好的性能. 设置 `enable_scalar_subquery_optimization` 是在 19.17 中添加的, 默认情况下启用. 在从以前的版本升级到 19.17.2 或 19.17.3 期间, 它会导致类似 [this](https://github.com/ClickHouse/ClickHouse/issues/7851) 的错误. 此设置在 19.17.4 中默认禁用, 以便从 19.16 和更旧版本升级而不会出错. [#7392](https://github.com/ClickHouse/ClickHouse/pull/7392) ([Amos Bird](https://github.com/amosbird))

#### 新特征 {#new-feature}

-   添加使用 DDL 查询创建字典的功能. [#7360](https://github.com/ClickHouse/ClickHouse/pull/7360) ([alesapin](https://github.com/alesapin))
-   使 `bloom_filter` 类型的索引支持 `LowCardinality` 和 `Nullable`. [#7363](https://github.com/ClickHouse/ClickHouse/issues/7363) [#7561](https://github.com/ClickHouse/ClickHouse/pull/7561) ([Nikolai Kochetov](https://github.com/KochetovNicolai))
-   添加函数 `isValidJSON` 以检查传递的字符串是否是有效的 json. [#5910](https://github.com/ClickHouse/ClickHouse/issues/5910) [#7293](https://github.com/ClickHouse/ClickHouse/pull/7293) ([Vdimir](https://github.com/Vdimir))
-   实现 `arrayCompact` 函数. [#7328](https://github.com/ClickHouse/ClickHouse/pull/7328) ([Memo](https://github.com/Joeywzr))
-   为十进制数创建函数 `hex` . 它的工作原理类似于 `hex(reinterpretAsString())`, 但不会删除最后的零字节. [#7355](https://github.com/ClickHouse/ClickHouse/pull/7355) ([Mikhail Korotov](https://github.com/millb))
-   添加 `arrayFill` 和 `arrayReverseFill` 函数, 将元素替换为数组前/后的其他元素. [#7380](https://github.com/ClickHouse/ClickHouse/pull/7380) ([hcz](https://github.com/hczhcz))
-   添加 `CRC32IEEE()` / `CRC64()` 支持. [#7480](https://github.com/ClickHouse/ClickHouse/pull/7480) ([Azat Khuzhin](https://github.com/azat))
-   实现类似于 in 的 `char` 函数. [mysql](https://dev.mysql.com/doc/refman/8.0/en/string-functions.html#function_char) [#7486](https://github.com/ClickHouse/ClickHouse/pull/7486) ([sundyli](https://github.com/sundy-li))
-   添加 `bitmapTransform` 函数. 它将位图中的一组值转换为另一个值数组, 结果是一个新的位图. [#7598](https://github.com/ClickHouse/ClickHouse/pull/7598) ([Zhichang Yu](https://github.com/yuzhichang))
-   实现了`javaHashUTF16LE()`函数. [#7651](https://github.com/ClickHouse/ClickHouse/pull/7651) ([achimbab](https://github.com/achimbab))
-   为分布式引擎添加 `_shard_num` 虚拟列. [#7624](https://github.com/ClickHouse/ClickHouse/pull/7624) ([Azat Khuzhin](https://github.com/azat))

#### 实验功能 {#experimental-feature}

-   支持 `MergeTree` 中的处理器 (新的查询执行管道). [#7181](https://github.com/ClickHouse/ClickHouse/pull/7181) ([Nikolai Kochetov](https://github.com/KochetovNicolai))

#### Bug 修复 {#bug-fix-1}

-   修复 `Values` 中不正确的浮点解析. [#7817](https://github.com/ClickHouse/ClickHouse/issues/7817) [#7870](https://github.com/ClickHouse/ClickHouse/pull/7870) ([tavplubix](https://github.com/tavplubix))
-   修复启用 trace_log 时可能发生的罕见死锁. [#7838](https://github.com/ClickHouse/ClickHouse/pull/7838) ([filimonov](https://github.com/filimonov))
-   生成 Kafka 表时防止消息重复, 其中有任何 MV 从中选择. [#7265](https://github.com/ClickHouse/ClickHouse/pull/7265) ([Ivan](https://github.com/abyss7))
-   支持 `IN` 中的 `Array(LowCardinality(Nullable(String)))`. 解决 [#7364](https://github.com/ClickHouse/ClickHouse/issues/7364) [#7366](https://github.com/ClickHouse/ClickHouse/pull/7366) ([achimbab](https://github.com/achimbab))
-   在 `SQL BIGINT` 中添加对 `SQL TINYINT` 的处理, 并在 ODBC Bridge 中修复对 `SQL_FLOAT` 数据源类型的处理. [#7491](https://github.com/ClickHouse/ClickHouse/pull/7491) ([Denis Glazachev](https://github.com/traceon))
-   修复空十进制列上的聚合( `avg` 和分位数). [#7431](https://github.com/ClickHouse/ClickHouse/pull/7431) ([Andrey Konyaev](https://github.com/akonyaev90))
-   将 `INSERT` 修复为 Distributed with `MATERIALIZED` 列. [#7377](https://github.com/ClickHouse/ClickHouse/pull/7377) ([Azat Khuzhin](https://github.com/azat))
-   如果分区的某些部分已经在目标磁盘或卷上, 则使 `MOVE PARTITION` 工作. [#7434](https://github.com/ClickHouse/ClickHouse/pull/7434) ([Vladimir Chebotarev](https://github.com/excitoon))
-   修复了在多磁盘配置中 `ReplicatedMergeTree` 中的突变期间无法创建硬链接的错误. [#7558](https://github.com/ClickHouse/ClickHouse/pull/7558) ([Vladimir Chebotarev](https://github.com/excitoon))
-   修复了当整个部分保持不变并且在另一个磁盘上找到最佳空间时 MergeTree 上发生突变的错误. [#7602](https://github.com/ClickHouse/ClickHouse/pull/7602) ([Vladimir Chebotarev](https://github.com/excitoon))
-   修复了未从磁盘配置中读取 `keep_free_space_ratio` 的错误. [#7645](https://github.com/ClickHouse/ClickHouse/pull/7645) ([Vladimir Chebotarev](https://github.com/excitoon))
-   修复表中仅包含 `Tuple` 列或具有复杂路径的列的错误. 修复 [7541](https://github.com/ClickHouse/ClickHouse/issues/7541). [#7545](https://github.com/ClickHouse/ClickHouse/pull/7545) ([alesapin](https://github.com/alesapin))
-   在 max_memory_usage 限制中不考虑 Buffer 引擎的内存. [#7552](https://github.com/ClickHouse/ClickHouse/pull/7552) ([Azat Khuzhin](https://github.com/azat))
-   修复由 `tuple()` 排序的 `MergeTree` 表中的最终标记使用. 在极少数情况下, 它可能会在选择时导致 `Can't adjust last granule` 错误. [#7639](https://github.com/ClickHouse/ClickHouse/pull/7639) ([Anton Popov](https://github.com/CurtizJ))
-   修复具有需要上下文的操作 (例如 json 的函数) 的谓词的突变中的错误, 这可能导致崩溃或奇怪的异常. [#7664](https://github.com/ClickHouse/ClickHouse/pull/7664) ([alesapin](https://github.com/alesapin))
-   修复在 `data/` 和 `shadow/` 目录中转义的数据库和表名的不匹配. [#7575](https://github.com/ClickHouse/ClickHouse/pull/7575) ([Alexander Burmak](https://github.com/Alex-Burmak))
-   支持 RIGHT\|FULL JOIN 中的重复键, 例如 `ON t.x = u.x AND t.x = u.y`. 在这种情况下修复崩溃. [#7586](https://github.com/ClickHouse/ClickHouse/pull/7586) ([Artem Zuikov](https://github.com/4ertus2))
-   使用 RIGHT 或 FULL JOIN 连接表达式时, 修复 `Not found column <expression> in block` . [#7641](https://github.com/ClickHouse/ClickHouse/pull/7641) ([Artem Zuikov](https://github.com/4ertus2))
-   再次尝试以 `PrettySpace` format 格式修复无限循环. [#7591](https://github.com/ClickHouse/ClickHouse/pull/7591) ([Olga Khvostikova](https://github.com/stavrolia))
-   当所有参数都是相同大小的 `FixedString` 时, 修复 `concat` 函数中的错误. [#7635](https://github.com/ClickHouse/ClickHouse/pull/7635) ([alesapin](https://github.com/alesapin))
-   修复了在定义 S3、URL 和 HDFS 存储时使用 1 个参数的异常. [#7618](https://github.com/ClickHouse/ClickHouse/pull/7618) ([Vladimir Chebotarev](https://github.com/excitoon))
-   修复带有查询的视图的 InterpreterSelectQuery 的范围. [#7601](https://github.com/ClickHouse/ClickHouse/pull/7601) ([Azat Khuzhin](https://github.com/azat))

#### 改进 {#improvement}

-   `Nullable` 列识别和 NULL 值由 ODBC 桥正确处理. [#7402](https://github.com/ClickHouse/ClickHouse/pull/7402) ([Vasily Nemkov](https://github.com/Enmk))
-   以原子方式写入分布式发送的当前批次. [#7600](https://github.com/ClickHouse/ClickHouse/pull/7600) ([Azat Khuzhin](https://github.com/azat))
-   如果我们无法在查询中检测到列名的表, 则抛出异常. [#7358](https://github.com/ClickHouse/ClickHouse/pull/7358) ([Artem Zuikov](https://github.com/4ertus2))
-   将 `merge_max_block_size` 设置添加到 `MergeTreeSettings`. [#7412](https://github.com/ClickHouse/ClickHouse/pull/7412) ([Artem Zuikov](https://github.com/4ertus2))
-   带有 `HAVING` 和不带 `GROUP BY` 的查询假定按常量分组. 所以, `SELECT 1 HAVING 1` 现在返回一个结果. [#7496](https://github.com/ClickHouse/ClickHouse/pull/7496) ([Amos Bird](https://github.com/amosbird))
-   支持将 `(X,)` 解析为类似于python的元组. [#7501](https://github.com/ClickHouse/ClickHouse/pull/7501), [#7562](https://github.com/ClickHouse/ClickHouse/pull/7562) ([Amos Bird](https://github.com/amosbird))
-   使 `range` 函数行为几乎像 Pythonic 一样. [#7518](https://github.com/ClickHouse/ClickHouse/pull/7518) ([sundyli](https://github.com/sundy-li))
-   将 `constraints` 列添加到表 `system.settings`. [#7553](https://github.com/ClickHouse/ClickHouse/pull/7553) ([Vitaly Baranov](https://github.com/vitlibar))
-   更好的 tcp 处理程序的 Null 格式，以便可以通过 clickhouse-client 使用 `select ignore(<expression>) from table format Null` 进行性能测量. [#7606](https://github.com/ClickHouse/ClickHouse/pull/7606) ([Amos Bird](https://github.com/amosbird))
-   像 `CREATE TABLE ... AS (SELECT (1, 2))` 这样的查询被正确解析. [#7542](https://github.com/ClickHouse/ClickHouse/pull/7542) ([hcz](https://github.com/hczhcz))

#### 性能改进 {#performance-improvement}

-   改进了对短字符串键的聚合性能. [#6243](https://github.com/ClickHouse/ClickHouse/pull/6243) ([Alexander Kuzmenkov](https://github.com/akuzm), [Amos Bird](https://github.com/amosbird))
-   在折叠常量谓词后运行另一遍语法/表达式分析以获得潜在的优化. [#7497](https://github.com/ClickHouse/ClickHouse/pull/7497) ([Amos Bird](https://github.com/amosbird))
-   使用存储元信息来评估琐碎的 `SELECT count() FROM table;`. [#7510](https://github.com/ClickHouse/ClickHouse/pull/7510) ([Amos Bird](https://github.com/amosbird), [alexey-milovidov](https://github.com/alexey-milovidov))
-   矢量化处理 `arrayReduce` 类似于聚合器 `addBatch`. [#7608](https://github.com/ClickHouse/ClickHouse/pull/7608) ([Amos Bird](https://github.com/amosbird))
-   `Kafka` 消费性能的小幅改进. [#7475](https://github.com/ClickHouse/ClickHouse/pull/7475) ([Ivan](https://github.com/abyss7))

#### 构建/测试/打包改进 {#buildtestingpackaging-improvement}

-   添加对 CPU 架构 AARCH64 的交叉编译支持. 重构打包脚本. [#7370](https://github.com/ClickHouse/ClickHouse/pull/7370) [#7539](https://github.com/ClickHouse/ClickHouse/pull/7539) ([Ivan](https://github.com/abyss7))
-   构建软件包时, 将 darwin-x86_64 和 linux-aarch64 工具链解压到已安装的 Docker 卷中. [#7534](https://github.com/ClickHouse/ClickHouse/pull/7534) ([Ivan](https://github.com/abyss7))
-   更新二进制打包器的 Docker 镜像. [#7474](https://github.com/ClickHouse/ClickHouse/pull/7474) ([Ivan](https://github.com/abyss7))
-   修复了 MacOS Catalina 上的编译错误. [#7585](https://github.com/ClickHouse/ClickHouse/pull/7585) ([Ernest Poletaev](https://github.com/ernestp))
-   查询分析逻辑中的一些重构: 将复杂的类拆分成几个简单的类. [#7454](https://github.com/ClickHouse/ClickHouse/pull/7454) ([Artem Zuikov](https://github.com/4ertus2))
-   修复没有子模块的构建. [#7295](https://github.com/ClickHouse/ClickHouse/pull/7295) ([proller](https://github.com/proller))
-   CMake 文件中更好的 `add_globs`. [#7418](https://github.com/ClickHouse/ClickHouse/pull/7418) ([Amos Bird](https://github.com/amosbird))
-   删除 `unwind` 目标中的硬编码路径. [#7460](https://github.com/ClickHouse/ClickHouse/pull/7460) ([Konstantin Podshumok](https://github.com/podshumok))
-   允许使用没有 ssl 的 mysql 格式. [#7524](https://github.com/ClickHouse/ClickHouse/pull/7524) ([proller](https://github.com/proller))

#### 其他 {#other}

-   为 ClickHouse SQL 方言添加了 ANTLR4 语法. [#7595](https://github.com/ClickHouse/ClickHouse/issues/7595) [#7596](https://github.com/ClickHouse/ClickHouse/pull/7596) ([alexey-milovidov](https://github.com/alexey-milovidov))

## ClickHouse 版本 19.16 {#clickhouse-release-v19-16}

#### ClickHouse 版本 19.16.14.65, 2020-03-25 {#clickhouse-release-v19-16-14-65-2020-03-25}

-   修复了多个参数 (超过 10 个) 的三元逻辑 OP 的批量计算中的错误. [#8718](https://github.com/ClickHouse/ClickHouse/pull/8718) ([Alexander Kazakov](https://github.com/Akazz)) This bugfix was backported to version 19.16 by a special request from Altinity.

#### ClickHouse 版本 19.16.14.65, 2020-03-05 {#clickhouse-release-v19-16-14-65-2020-03-05}

-   修复分布式子查询与旧 CH 版本不兼容的问题. 修复 [#7851](https://github.com/ClickHouse/ClickHouse/issues/7851) [(tabplubix)](https://github.com/tavplubix)
-   执行 `CREATE` 查询时, 在存储引擎参数中折叠常量表达式. 用当前数据库替换空数据库名称. 修复 [#6508](https://github.com/ClickHouse/ClickHouse/issues/6508), [#3492](https://github.com/ClickHouse/ClickHouse/issues/3492). 还修复了 `ClickHouseDictionarySource` 中本地地址的检查. [#9262](https://github.com/ClickHouse/ClickHouse/pull/9262) [(tabplubix)](https://github.com/tavplubix)
-   现在 `*MergeTree` 表引擎族中的后台合并更准确地保留存储策略卷顺序. [#8549](https://github.com/ClickHouse/ClickHouse/pull/8549) ([Vladimir Chebotarev](https://github.com/excitoon))
-   在读取后缀之后但提交之前发生异常时, 在极少数情况下防止在 `Kafka` 中丢失数据. 修复 [#9378](https://github.com/ClickHouse/ClickHouse/issues/9378). 相关的: [#7175](https://github.com/ClickHouse/ClickHouse/issues/7175) [#9507](https://github.com/ClickHouse/ClickHouse/pull/9507) [(filimonov)](https://github.com/filimonov)
-   修复在尝试使用/删除使用错误参数创建的 `Kafka` 表时导致服务器终止的错误. 修复 [#9494](https://github.com/ClickHouse/ClickHouse/issues/9494). Incorporates [#9507](https://github.com/ClickHouse/ClickHouse/issues/9507). [#9513](https://github.com/ClickHouse/ClickHouse/pull/9513) [(filimonov)](https://github.com/filimonov)
-   允许将 `MaterializedView` 与 `Kafka` 表上方的子查询一起使用. [#8197](https://github.com/ClickHouse/ClickHouse/pull/8197) ([filimonov](https://github.com/filimonov))

#### 新特征 {#new-feature-1}

-   添加 `deduplicate_blocks_in_dependent_materialized_views` 选项以控制幂等插入到具有物化视图的表中的行为. 应 Altinity 的特殊要求, 此新功能已添加到错误修复版本中. [#9070](https://github.com/ClickHouse/ClickHouse/pull/9070) [(urykhy)](https://github.com/urykhy)

### ClickHouse 版本 19.16.2.2, 2019-10-30 {#clickhouse-release-v19-16-2-2-2019-10-30}

#### 向后不兼容的更新 {#backward-incompatible-change-1}

-   为 count/countIf 添加缺失的 arity 验证. [#7095](https://github.com/ClickHouse/ClickHouse/issues/7095), [#7298](https://github.com/ClickHouse/ClickHouse/pull/7298) ([Vdimir](https://github.com/Vdimir))
-   删除旧的 `asterisk_left_columns_only` 设置 (默认情况下禁用). [#7335](https://github.com/ClickHouse/ClickHouse/pull/7335) ([Artem Zuikov](https://github.com/4ertus2))
-   模板数据格式的格式字符串现在在文件中指定. [#7118](https://github.com/ClickHouse/ClickHouse/pull/7118) ([tavplubix](https://github.com/tavplubix))

#### 新特征 {#new-feature-2}

-   引入 uniqCombined64() 计算大于 UINT_MAX 的基数. [#7213](https://github.com/ClickHouse/ClickHouse/pull/7213), [#7222](https://github.com/ClickHouse/ClickHouse/pull/7222) ([Azat Khuzhin](https://github.com/azat))
-   支持数组列上的布隆过滤器索引. [#6984](https://github.com/ClickHouse/ClickHouse/pull/6984) ([achimbab](https://github.com/achimbab))
-   添加一个函数 `getMacro(name)`, 它从服务器配置中返回带有相应 `<macros>` 值的字符串. [#7240](https://github.com/ClickHouse/ClickHouse/pull/7240)
    ([alexey-milovidov](https://github.com/alexey-milovidov))
-   为基于 HTTP 源的字典设置两个配置选项: `credentials` 和 `http-headers`. [#7092](https://github.com/ClickHouse/ClickHouse/pull/7092) ([Guillaume Tassery](https://github.com/YiuRULE))
-   添加一个新的 ProfileEvent `Merge` 来计算启动的后台合并的数量. [#7093](https://github.com/ClickHouse/ClickHouse/pull/7093) ([Mikhail Korotov](https://github.com/millb))
-   添加返回完全限定域名的 fullHostName 函数. [#7263](https://github.com/ClickHouse/ClickHouse/issues/7263) [#7291](https://github.com/ClickHouse/ClickHouse/pull/7291) ([sundyli](https://github.com/sundy-li))
-   添加函数 `arraySplit` 和 `arrayReverseSplit`, 它们通过 `cut off` 条件拆分数组. 它们在时间序列处理中很有用. [#7294](https://github.com/ClickHouse/ClickHouse/pull/7294) ([hcz](https://github.com/hczhcz))
-   添加返回 multiMatch 系列函数中所有匹配索引数组的新函数. [#7299](https://github.com/ClickHouse/ClickHouse/pull/7299) ([Danila Kutenin](https://github.com/danlark1))
-   添加一个新的数据库引擎 `Lazy`, 该引擎针对存储大量小型 -Log 表进行了优化. [#7171](https://github.com/ClickHouse/ClickHouse/pull/7171) ([Nikita Vasilev](https://github.com/nikvas0))
-   为位图列添加聚合函数 groupBitmapAnd、-Or、-Xor. [#7109](https://github.com/ClickHouse/ClickHouse/pull/7109) ([Zhichang Yu](https://github.com/yuzhichang))
-   添加聚合函数组合子 -OrNull 和 -OrDefault，当没有聚合时返回空值或默认值. [#7331](https://github.com/ClickHouse/ClickHouse/pull/7331) ([hcz](https://github.com/hczhcz))
-   引入支持自定义转义和分隔符规则的 CustomSeparated 数据格式. [#7118](https://github.com/ClickHouse/ClickHouse/pull/7118) ([tavplubix](https://github.com/tavplubix))
-   支持Redis作为外部字典的来源. [#4361](https://github.com/ClickHouse/ClickHouse/pull/4361) [#6962](https://github.com/ClickHouse/ClickHouse/pull/6962) ([comunodi](https://github.com/comunodi), [Anton Popov](https://github.com/CurtizJ))

#### Bug 修复 {#bug-fix-2}

-   修复错误的查询结果, 如果它有 `WHERE IN (SELECT ...)` 部分并且使用了 `optimize_read_in_order`. [#7371](https://github.com/ClickHouse/ClickHouse/pull/7371) ([Anton
    Popov](https://github.com/CurtizJ))
-   禁用 MariaDB 身份验证插件, 该插件依赖于项目外的文件. [#7140](https://github.com/ClickHouse/ClickHouse/pull/7140) ([Yuriy Baranov](https://github.com/yurriy))
-   修复异常 `Cannot convert column ... because it is constant but values of constants are different in source and result` , 这在函数  `now()`、`today()`、`yesterday()`、 `randConstant()` 时, 这种情况很少发生. [#7156](https://github.com/ClickHouse/ClickHouse/pull/7156) ([Nikolai Kochetov](https://github.com/KochetovNicolai))
-   修复了使用 HTTP 保持活动超时而不是 TCP 保持活动超时的问题. [#7351](https://github.com/ClickHouse/ClickHouse/pull/7351) ([Vasily Nemkov](https://github.com/Enmk))
-   修复了 groupBitmapOr 中的分段错误. (issue [#7109](https://github.com/ClickHouse/ClickHouse/issues/7109)). [#7289](https://github.com/ClickHouse/ClickHouse/pull/7289) ([Zhichang Yu](https://github.com/yuzhichang))
-   对于物化视图，在写入所有数据后调用 Kafka 的提交. [#7175](https://github.com/ClickHouse/ClickHouse/pull/7175) ([Ivan](https://github.com/abyss7))
-   修复了 `system.part_log` 表中错误的 `duration_ms` 值. 差了十倍. [#7172](https://github.com/ClickHouse/ClickHouse/pull/7172) ([Vladimir Chebotarev](https://github.com/excitoon))
-   解决 LIVE VIEW 表崩溃并重新启用所有 LIVE VIEW 测试的快速修复. [#7201](https://github.com/ClickHouse/ClickHouse/pull/7201) ([vzakaznikov](https://github.com/vzakaznikov))
-   在 MergeTree 部分的最小/最大索引中正确序列化 NULL 值. [#7234](https://github.com/ClickHouse/ClickHouse/pull/7234) ([Alexander Kuzmenkov](https://github.com/akuzm))
-   当表创建为 `CREATE TABLE AS` 时, 不要将虚拟列放入 .sql 元数据. [#7183](https://github.com/ClickHouse/ClickHouse/pull/7183) ([Ivan](https://github.com/abyss7))
-   修复 `ATTACH PART` 查询中的分段错误. [#7185](https://github.com/ClickHouse/ClickHouse/pull/7185) ([alesapin](https://github.com/alesapin))
-   修复空 IN 子查询和空 INNER/RIGHT JOIN 优化给出的某些查询的错误结果. [#7284](https://github.com/ClickHouse/ClickHouse/pull/7284) ([Nikolai Kochetov](https://github.com/KochetovNicolai))
-   修复 LIVE VIEW getHeader() 方法中的 AddressSanitizer 错误. [#7271](https://github.com/ClickHouse/ClickHouse/pull/7271) ([vzakaznikov](https://github.com/vzakaznikov))

#### 改进 {#improvement-1}

-   在 queue_wait_max_ms 等待发生的情况下添加一条消息. [#7390](https://github.com/ClickHouse/ClickHouse/pull/7390) ([Azat Khuzhin](https://github.com/azat))
-   在表级设置 `s3_min_upload_part_size` . [#7059](https://github.com/ClickHouse/ClickHouse/pull/7059) ([Vladimir Chebotarev](https://github.com/excitoon))
-   在 StorageFactory 中检查 TTL. [#7304](https://github.com/ClickHouse/ClickHouse/pull/7304) ([sundyli](https://github.com/sundy-li))
-   在部分合并连接中挤压左侧块 (优化). [#7122](https://github.com/ClickHouse/ClickHouse/pull/7122) ([Artem Zuikov](https://github.com/4ertus2))
-   不允许在复制表引擎的突变中使用非确定性函数, 因为这会导致副本之间的不一致. [#7247](https://github.com/ClickHouse/ClickHouse/pull/7247) ([Alexander Kazakov](https://github.com/Akazz))
-   在将异常堆栈跟踪转换为字符串时禁用内存跟踪器. 可以防止服务器上的 `Memory limit exceeded` 类型的错误信息丢失, 导致客户端 `Attempt to read after eof` 异常. [#7264](https://github.com/ClickHouse/ClickHouse/pull/7264) ([Nikolai Kochetov](https://github.com/KochetovNicolai))
-   各种格式改进. 解决 [#6033](https://github.com/ClickHouse/ClickHouse/issues/6033), [#2633](https://github.com/ClickHouse/ClickHouse/issues/2633), [#6611](https://github.com/ClickHouse/ClickHouse/issues/6611), [#6742](https://github.com/ClickHouse/ClickHouse/issues/6742) [#7215](https://github.com/ClickHouse/ClickHouse/pull/7215) ([tavplubix](https://github.com/tavplubix))
-   ClickHouse 会忽略 IN 运算符右侧无法转换为左侧类型的值. 使其适用于复合类型——数组和元组. [#7283](https://github.com/ClickHouse/ClickHouse/pull/7283) ([Alexander Kuzmenkov](https://github.com/akuzm))
-   支持 ASOF JOIN 缺失的不等式. 可以在 ON 语法中为 ASOF 列加入 less-or-equal 变体和严格的更大和更少变体. [#7282](https://github.com/ClickHouse/ClickHouse/pull/7282) ([Artem Zuikov](https://github.com/4ertus2))
-   优化部分合并连接. [#7070](https://github.com/ClickHouse/ClickHouse/pull/7070) ([Artem Zuikov](https://github.com/4ertus2))
-   不要在 uniqCombined 函数中使用超过 98K 的内存. [#7236](https://github.com/ClickHouse/ClickHouse/pull/7236), [#7270](https://github.com/ClickHouse/ClickHouse/pull/7270) ([Azat Khuzhin](https://github.com/azat))
-   在 PartialMergeJoin 中刷新磁盘上右侧连接表的部分 (如果没有足够的内存). 需要时加载数据. [#7186](https://github.com/ClickHouse/ClickHouse/pull/7186) ([Artem Zuikov](https://github.com/4ertus2))

#### 性能改进 {#performance-improvement-1}

-   通过避免数据重复来加速使用 const 参数的 joinGet. [#7359](https://github.com/ClickHouse/ClickHouse/pull/7359) ([Amos Bird](https://github.com/amosbird))
-   如果子查询为空, 则提前返回. [#7007](https://github.com/ClickHouse/ClickHouse/pull/7007) ([小路](https://github.com/nicelulu))
-   优化 Values 中 SQL 表达式的解析. [#6781](https://github.com/ClickHouse/ClickHouse/pull/6781) ([tavplubix](https://github.com/tavplubix))

#### 构建/测试/打包改进 {#buildtestingpackaging-improvement-1}

-   禁用一些用于交叉编译到 Mac OS 的贡献. [#7101](https://github.com/ClickHouse/ClickHouse/pull/7101) ([Ivan](https://github.com/abyss7))
-   为 clickhouse_common_io 添加缺少的 PocoXML 链接. [#7200](https://github.com/ClickHouse/ClickHouse/pull/7200) ([Azat Khuzhin](https://github.com/azat))
-   在 clickhouse-test 中接受多个测试过滤器参数. [#7226](https://github.com/ClickHouse/ClickHouse/pull/7226) ([Alexander Kuzmenkov](https://github.com/akuzm))
-   为 ARM 启用 musl 和 jemalloc. [#7300](https://github.com/ClickHouse/ClickHouse/pull/7300) ([Amos Bird](https://github.com/amosbird))
-   将 `--client-option` 参数添加到 `clickhouse-test` 以将附加参数传递给客户端. [#7277](https://github.com/ClickHouse/ClickHouse/pull/7277) ([Nikolai Kochetov](https://github.com/KochetovNicolai))
-   在 rpm 包升级时保留现有配置. [#7103](https://github.com/ClickHouse/ClickHouse/pull/7103) ([filimonov](https://github.com/filimonov))
-   修复 PVS 检测到的错误. [#7153](https://github.com/ClickHouse/ClickHouse/pull/7153) ([Artem Zuikov](https://github.com/4ertus2))
-   修复 Darwin 的构建. [#7149](https://github.com/ClickHouse/ClickHouse/pull/7149) ([Ivan](https://github.com/abyss7))
-   glibc 2.29 兼容性. [#7142](https://github.com/ClickHouse/ClickHouse/pull/7142) ([Amos Bird](https://github.com/amosbird))
-   确保 dh_clean 不接触潜在的源文件. [#7205](https://github.com/ClickHouse/ClickHouse/pull/7205) ([Amos Bird](https://github.com/amosbird))
-   从 altinity rpm 更新时尝试避免冲突 - 它在 clickhouse-server-common 中单独打包了配置文件. [#7073](https://github.com/ClickHouse/ClickHouse/pull/7073) ([filimonov](https://github.com/filimonov))
-   优化一些头文件以加快重建速度. [#7212](https://github.com/ClickHouse/ClickHouse/pull/7212), [#7231](https://github.com/ClickHouse/ClickHouse/pull/7231) ([Alexander
    Kuzmenkov](https://github.com/akuzm))
-   添加日期和日期时间的性能测试. [#7332](https://github.com/ClickHouse/ClickHouse/pull/7332) ([Vasily Nemkov](https://github.com/Enmk))
-   修复一些包含非确定性突变的测试. [#7132](https://github.com/ClickHouse/ClickHouse/pull/7132) ([Alexander Kazakov](https://github.com/Akazz))
-   将带有 MemorySanitizer 的构建添加到 CI. [#7066](https://github.com/ClickHouse/ClickHouse/pull/7066) ([Alexander Kuzmenkov](https://github.com/akuzm))
-   避免在 MetricsTransmitter 中使用未初始化的值. [#7158](https://github.com/ClickHouse/ClickHouse/pull/7158) ([Azat Khuzhin](https://github.com/azat))
-   修复 MemorySanitizer 发现的 Fields 中的一些问题. [#7135](https://github.com/ClickHouse/ClickHouse/pull/7135), [#7179](https://github.com/ClickHouse/ClickHouse/pull/7179) ([Alexander Kuzmenkov](https://github.com/akuzm)), [#7376](https://github.com/ClickHouse/ClickHouse/pull/7376) ([Amos Bird](https://github.com/amosbird))
-   修复 murmurhash32 中未定义的行为. [#7388](https://github.com/ClickHouse/ClickHouse/pull/7388) ([Amos Bird](https://github.com/amosbird))
-   修复 StoragesInfoStream 中未定义的行为. [#7384](https://github.com/ClickHouse/ClickHouse/pull/7384) ([tavplubix](https://github.com/tavplubix))
-   修复了外部数据库引擎 (MySQL、ODBC、JDBC) 的常量表达式折叠. 在以前的版本中, 它不适用于多个常量表达式, 也不适用于 Date、DateTime 和 UUID. 这修复了 [#7245](https://github.com/ClickHouse/ClickHouse/issues/7245) [#7252](https://github.com/ClickHouse/ClickHouse/pull/7252) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   在访问 no_users_thread 变量时修复实时视图中的 ThreadSanitizer 数据竞争错误. [#7353](https://github.com/ClickHouse/ClickHouse/pull/7353) ([vzakaznikov](https://github.com/vzakaznikov))
-   摆脱 libcommon 中的 malloc 符号. [#7134](https://github.com/ClickHouse/ClickHouse/pull/7134), [#7065](https://github.com/ClickHouse/ClickHouse/pull/7065) ([Amos
    Bird](https://github.com/amosbird))
-   添加全局标志 ENABLE_LIBRARIES 以禁用所有库. [#7063](https://github.com/ClickHouse/ClickHouse/pull/7063) ([proller](https://github.com/proller))

#### 代码清理 {#code-cleanup}

-   通用化配置存储库以准备 DDL for Dictionaries. [#7155](https://github.com/ClickHouse/ClickHouse/pull/7155) ([alesapin](https://github.com/alesapin))
-   没有任何语义的字典 DDL 解析器. [#7209](https://github.com/ClickHouse/ClickHouse/pull/7209) ([alesapin](https://github.com/alesapin))
-   将 ParserCreateQuery 拆分为不同的较小解析器. [#7253](https://github.com/ClickHouse/ClickHouse/pull/7253) ([alesapin](https://github.com/alesapin))
-   外部字典附近的小重构和重命名. [#7111](https://github.com/ClickHouse/ClickHouse/pull/7111) ([alesapin](https://github.com/alesapin))
-   重构一些代码, 为基于角色的访问控制做准备. [#7235](https://github.com/ClickHouse/ClickHouse/pull/7235) ([Vitaly Baranov](https://github.com/vitlibar))
-   DatabaseOrdinary 代码的一些改进. [#7086](https://github.com/ClickHouse/ClickHouse/pull/7086) ([Nikita Vasilev](https://github.com/nikvas0))
-   不要在哈希表的 find() 和 emplace() 方法中使用迭代器. [#7026](https://github.com/ClickHouse/ClickHouse/pull/7026) ([Alexander Kuzmenkov](https://github.com/akuzm))
-   修复 getMultipleValuesFromConfig 以防参数 root 不为空. [#7374](https://github.com/ClickHouse/ClickHouse/pull/7374) ([Mikhail Korotov](https://github.com/millb))
-   删除一些复制粘贴 (TemporaryFile 和 TemporaryFileStream). [#7166](https://github.com/ClickHouse/ClickHouse/pull/7166) ([Artem Zuikov](https://github.com/4ertus2))
-   提高了一点代码可读性 (`MergeTreeData::getActiveContainingPart`). [#7361](https://github.com/ClickHouse/ClickHouse/pull/7361) ([Vladimir Chebotarev](https://github.com/excitoon))
-   如果 `ThreadPool::schedule(...)` 抛出异常, 则等待所有使用本地对象的计划作业. 将 `ThreadPool::schedule(...)` 重命名为 `ThreadPool::scheduleOrThrowOnError(...)` 并修复注释以明确它可能会抛出. [#7350](https://github.com/ClickHouse/ClickHouse/pull/7350) ([tavplubix](https://github.com/tavplubix))

## ClickHouse 版本 19.15 {#clickhouse-release-19-15}

### ClickHouse 版本 19.15.4.10, 2019-10-31 {#clickhouse-release-19-15-4-10-2019-10-31}

#### Bug 修复 {#bug-fix-3}

-   添加了 SQL BIGINT 中 SQL TINYINT 的处理, 并修复了 ODBC Bridge 中 SQL_FLOAT 数据源类型的处理. [#7491](https://github.com/ClickHouse/ClickHouse/pull/7491) ([Denis Glazachev](https://github.com/traceon))
-   允许在 MOVE PARTITION 中的目标磁盘或卷上有一些部分. [#7434](https://github.com/ClickHouse/ClickHouse/pull/7434) ([Vladimir Chebotarev](https://github.com/excitoon))
-   通过 ODBC 桥修复可空列中的 NULL 值. [#7402](https://github.com/ClickHouse/ClickHouse/pull/7402) ([Vasily Nemkov](https://github.com/Enmk))
-   修复了 INSERT 到具有 MATERIALIZED 列的分布式非本地节点. [#7377](https://github.com/ClickHouse/ClickHouse/pull/7377) ([Azat Khuzhin](https://github.com/azat))
-   固定函数 getMultipleValuesFromConfig. [#7374](https://github.com/ClickHouse/ClickHouse/pull/7374) ([Mikhail Korotov](https://github.com/millb))
-   修复了使用 HTTP 保持活动超时而不是 TCP 保持活动超时的问题. [#7351](https://github.com/ClickHouse/ClickHouse/pull/7351) ([Vasily Nemkov](https://github.com/Enmk))
-   等待所有作业在异常情况下完成 (修复罕见的段错误). [#7350](https://github.com/ClickHouse/ClickHouse/pull/7350) ([tavplubix](https://github.com/tavplubix))
-   插入 Kafka 表时不要推送到 MV. [#7265](https://github.com/ClickHouse/ClickHouse/pull/7265) ([Ivan](https://github.com/abyss7))
-   禁用异常堆栈的内存跟踪器. [#7264](https://github.com/ClickHouse/ClickHouse/pull/7264) ([Nikolai Kochetov](https://github.com/KochetovNicolai))
-   修复了转换外部数据库查询中的错误代码. [#7252](https://github.com/ClickHouse/ClickHouse/pull/7252) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   避免在 MetricsTransmitter 中使用未初始化的值. [#7158](https://github.com/ClickHouse/ClickHouse/pull/7158) ([Azat Khuzhin](https://github.com/azat))
-   添加了带有用于测试的宏的示例配置. ([alexey-milovidov](https://github.com/alexey-milovidov))

### ClickHouse 版本 19.15.3.6, 2019-10-09 {#clickhouse-release-19-15-3-6-2019-10-09}

#### Bug 修复 {#bug-fix-4}

-   修复了散列字典中的 bad_variant. ([alesapin](https://github.com/alesapin))
-   修复了 ATTACH PART 查询中分段错误的错误. ([alesapin](https://github.com/alesapin))
-   修复了`MergeTreeData` 中的时间计算. ([Vladimir Chebotarev](https://github.com/excitoon))
-   在编写完成后显式提交给Kafka. [#7175](https://github.com/ClickHouse/ClickHouse/pull/7175) ([Ivan](https://github.com/abyss7))
-   在 MergeTree 部分的最小/最大索引中正确序列化 NULL 值. [#7234](https://github.com/ClickHouse/ClickHouse/pull/7234) ([Alexander Kuzmenkov](https://github.com/akuzm))

### ClickHouse 版本 19.15.2.2, 2019-10-01 {#clickhouse-release-19-15-2-2-2019-10-01}

#### 新特征 {#new-feature-3}

-   分层存储: 支持使用 MergeTree 引擎为表使用多个存储卷. 可以在 SSD 上存储新数据并自动将旧数据移动到 HDD. ([example](https://clickhouse.github.io/clickhouse-presentations/meetup30/new_features/#12)). [#4918](https://github.com/ClickHouse/ClickHouse/pull/4918) ([Igr](https://github.com/ObjatieGroba)) [#6489](https://github.com/ClickHouse/ClickHouse/pull/6489) ([alesapin](https://github.com/alesapin))
-   添加表函数 `input`, 用于在 `INSERT SELECT` 查询中读取传入数据. [#5450](https://github.com/ClickHouse/ClickHouse/pull/5450) ([palasonic1](https://github.com/palasonic1)) [#6832](https://github.com/ClickHouse/ClickHouse/pull/6832) ([Anton Popov](https://github.com/CurtizJ))
-   添加一个 `sparse_hashed` 字典布局, 它在功能上等同于 `hashed` 布局, 但内存效率更高. 它以较慢的值检索为代价使用大约两倍的内存. [#6894](https://github.com/ClickHouse/ClickHouse/pull/6894) ([Azat Khuzhin](https://github.com/azat))
-   实现定义用户列表以访问字典的能力. 仅使用当前连接的数据库. [#6907](https://github.com/ClickHouse/ClickHouse/pull/6907) ([Guillaume Tassery](https://github.com/YiuRULE))
-   向`SHOW`查询添加`LIMIT`选项. [#6944](https://github.com/ClickHouse/ClickHouse/pull/6944) ([Philipp Malkovsky](https://github.com/malkfilipp))
-   添加 `bitmapSubsetLimit(bitmap, range_start, limit)` 函数, 返回集合中不小于 `range_start` 的最小 `limit` 值的子集. [#6957](https://github.com/ClickHouse/ClickHouse/pull/6957) ([Zhichang Yu](https://github.com/yuzhichang))
-   添加 `bitmapMin` 和 `bitmapMax` 函数. [#6970](https://github.com/ClickHouse/ClickHouse/pull/6970) ([Zhichang Yu](https://github.com/yuzhichang))
-   添加与 [issue-6648](https://github.com/ClickHouse/ClickHouse/issues/6648) [#6999](https://github.com/ClickHouse/ClickHouse/pull/6999) 相关的函数 `repeat`.([flynn](https://github.com/ucasFL))

#### 实验功能 {#experimental-feature-1}

-   实现 (在内存中) 不改变当前管道的 Merge Join 变体. 结果按合并键部分排序. 设置 `partial_merge_join = 1` 以使用此功能. Merge Join 仍在开发中. [#6940](https://github.com/ClickHouse/ClickHouse/pull/6940) ([Artem Zuikov](https://github.com/4ertus2))
-   添加 `S3` 引擎和表格功能。. 它仍在开发中 (尚无身份验证支持). [#5596](https://github.com/ClickHouse/ClickHouse/pull/5596) ([Vladimir Chebotarev](https://github.com/excitoon))

#### 改进 {#improvement-2}

-   从 Kafka 读取的每条消息都是以原子方式插入的. 这解决了 Kafka 引擎的几乎所有已知问题. [#6950](https://github.com/ClickHouse/ClickHouse/pull/6950) ([Ivan](https://github.com/abyss7))
-   分布式查询故障转移的改进. 缩短恢复时间, 现在它也是可配置的, 可以在 `system.clusters` 中看到. [#6399](https://github.com/ClickHouse/ClickHouse/pull/6399) ([Vasily Nemkov](https://github.com/Enmk))
-   直接在 `IN` 部分支持枚举的数值. #6766 [#6941](https://github.com/ClickHouse/ClickHouse/pull/6941) ([dimarub2000](https://github.com/dimarub2000))
-   支持 (可选, 默认禁用) 重定向 URL 存储. [#6914](https://github.com/ClickHouse/ClickHouse/pull/6914) ([maqroll](https://github.com/maqroll))
-   添加旧版本客户端连接到服务器时的信息消息. [#6893](https://github.com/ClickHouse/ClickHouse/pull/6893) ([Philipp Malkovsky](https://github.com/malkfilipp))
-   删除分布式表中发送数据的最大退避睡眠时间限制. [#6895](https://github.com/ClickHouse/ClickHouse/pull/6895) ([Azat Khuzhin](https://github.com/azat))
-   添加将带有累积值的配置文件事件 (计数器) 发送到石墨的功能. 它可以在服务器 `config.xml` 中的 `<events_cumulative>` 下启用. [#6969](https://github.com/ClickHouse/ClickHouse/pull/6969) ([Azat Khuzhin](https://github.com/azat))
-   在通过 HTTP 以本机格式将数据插入类型为 `LowCardinality(T)` 的列中时, 自动将类型 `T` 添加到 `LowCardinality(T)` . [#6891](https://github.com/ClickHouse/ClickHouse/pull/6891) ([Nikolai Kochetov](https://github.com/KochetovNicolai))
-   添加使用函数 `hex` 而不使用 `reinterpretAsString` 为 `Float32` 和 `Float64` 的能力. [#7024](https://github.com/ClickHouse/ClickHouse/pull/7024) ([Mikhail Korotov](https://github.com/millb))

#### 构建/测试/打包改进 {#buildtestingpackaging-improvement-2}

-   将 gdb-index 添加到带有调试信息的 clickhouse 二进制文件中. 它将加快 `gdb` 的启动时间. [#6947](https://github.com/ClickHouse/ClickHouse/pull/6947) ([alesapin](https://github.com/alesapin))
-   使用使用 `pigz` 的补丁dpkg-deb加速deb打包. [#6960](https://github.com/ClickHouse/ClickHouse/pull/6960) ([alesapin](https://github.com/alesapin))
-   设置 `enable_fuzzing = 1` 以启用所有项目代码的 libfuzzer 检测. [#7042](https://github.com/ClickHouse/ClickHouse/pull/7042) ([kyprizel](https://github.com/kyprizel))
-   在 CI 中添加 split build 冒烟测试. [#7061](https://github.com/ClickHouse/ClickHouse/pull/7061) ([alesapin](https://github.com/alesapin))
-   将带有 MemorySanitizer 的构建添加到 CI. [#7066](https://github.com/ClickHouse/ClickHouse/pull/7066) ([Alexander Kuzmenkov](https://github.com/akuzm))
-   用 `sparsehash-c11` 替换 `libsparsehash`. [#6965](https://github.com/ClickHouse/ClickHouse/pull/6965) ([Azat Khuzhin](https://github.com/azat))

#### Bug 修复 {#bug-fix-5}

-   修复了大型表上复杂键的索引分析性能下降. 这修复了 #6924. [#7075](https://github.com/ClickHouse/ClickHouse/pull/7075) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   修复从 Kafka 空主题中选择时导致段错误的逻辑错误. [#6909](https://github.com/ClickHouse/ClickHouse/pull/6909) ([Ivan](https://github.com/abyss7))
-   修复 `MySQLBlockInputStream.cpp` 中过早关闭 MySQL 连接. [#6882](https://github.com/ClickHouse/ClickHouse/pull/6882) ([Clément Rodriguez](https://github.com/clemrodriguez))
-   返回对非常旧的 Linux 内核的支持 (修复 [#6841](https://github.com/ClickHouse/ClickHouse/issues/6841)) [#6853](https://github.com/ClickHouse/ClickHouse/pull/6853) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   在输入流中出现空块的情况下，修复 `insert select` 查询中可能丢失的数据. #6834 #6862 [#6911](https://github.com/ClickHouse/ClickHouse/pull/6911) ([Nikolai Kochetov](https://github.com/KochetovNicolai))
-   修复参数中带有空数组的函数 `АrrayEnumerateUniqRanked`. [#6928](https://github.com/ClickHouse/ClickHouse/pull/6928) ([proller](https://github.com/proller))
-   使用数组连接和全局子查询修复复杂查询. [#6934](https://github.com/ClickHouse/ClickHouse/pull/6934) ([Ivan](https://github.com/abyss7))
-   使用多个 JOIN 修复 ORDER BY 和 GROUP BY 中的 `Unknown identifier` 错误. [#7022](https://github.com/ClickHouse/ClickHouse/pull/7022) ([Artem Zuikov](https://github.com/4ertus2))
-   修复了在执行带有 `LowCardinality` 参数的函数时发出的 `MSan` 警告. [#7062](https://github.com/ClickHouse/ClickHouse/pull/7062) ([Nikolai Kochetov](https://github.com/KochetovNicolai))

#### 向后不兼容的更新 {#backward-incompatible-change-2}

-   更改了位图\* 聚合函数状态的序列化格式以提高性能. 无法读取之前版本中位图\* 的序列化状态. [#6908](https://github.com/ClickHouse/ClickHouse/pull/6908) ([Zhichang Yu](https://github.com/yuzhichang))

## ClickHouse 版本 19.14 {#clickhouse-release-19-14}

### ClickHouse 版本 19.14.7.15, 2019-10-02 {#clickhouse-release-19-14-7-15-2019-10-02}

#### Bug 修复 {#bug-fix-6}

-   此版本还包含 19.11.12.69 的所有错误修复.
-   修复了 19.14 和更早版本之间分布式查询的兼容性. 这修复了 [#7068](https://github.com/ClickHouse/ClickHouse/issues/7068). [#7069](https://github.com/ClickHouse/ClickHouse/pull/7069) ([alexey-milovidov](https://github.com/alexey-milovidov))

### ClickHouse 版本 19.14.6.12, 2019-09-19 {#clickhouse-release-19-14-6-12-2019-09-19}

#### Bug 修复 {#bug-fix-7}

-   修复函数 `АrrayEnumerateUniqRanked` 在参数中带有空数组. [#6928](https://github.com/ClickHouse/ClickHouse/pull/6928) ([proller](https://github.com/proller))
-   使用带有别名的 `ARRAY JOIN` 和 `GLOBAL IN subquery` 修复了查询中的子查询名称. 如果指定了外部表名, 则使用子查询别名. [#6934](https://github.com/ClickHouse/ClickHouse/pull/6934) ([Ivan](https://github.com/abyss7))

#### 构建/测试/打包改进 {#buildtestingpackaging-improvement-3}

-   修复 [flapping](https://clickhouse-test-reports.s3.yandex.net/6944/aab95fd5175a513413c7395a73a82044bdafb906/functional_stateless_tests_(debug).html) 测试 `00715_fetch_merged_or_mutated_part_zookeeper` 00715_mut_fetch_merged 的脚本需要重新写入 shellpart_或重新写入它的 shell 脚本申请. [#6977](https://github.com/ClickHouse/ClickHouse/pull/6977) ([Alexander Kazakov](https://github.com/Akazz))
-   修复了函数 `groupUniqArray` 中的 UBSan 和 MemSan 失败，并带有 emtpy 数组参数. 这是由于没有调用零单元格值的构造函数, 将空的 `PaddPODArray` 放入哈希表零单元格中引起的. [#6937](https://github.com/ClickHouse/ClickHouse/pull/6937) ([Amos Bird](https://github.com/amosbird))

### ClickHouse 版本 19.14.3.3, 2019-09-10 {#clickhouse-release-19-14-3-3-2019-09-10}

#### 新特征 {#new-feature-4}

-   `ORDER BY` 的 `WITH FILL` 修饰符. (continuation of [#5069](https://github.com/ClickHouse/ClickHouse/issues/5069)) [#6610](https://github.com/ClickHouse/ClickHouse/pull/6610) ([Anton Popov](https://github.com/CurtizJ))
-   `LIMIT` 的 `WITH TIES` 修饰符. (continuation of [#5069](https://github.com/ClickHouse/ClickHouse/issues/5069)) [#6610](https://github.com/ClickHouse/ClickHouse/pull/6610) ([Anton Popov](https://github.com/CurtizJ))
-   将未加引号的 `NULL` 文字解析为 NULL (如果设置 `format_csv_unquoted_null_literal_as_null=1`). 如果此字段的数据类型不可为空, 则使用默认值初始化空字段 (如果设置 `input_format_null_as_default=1`). [#5990](https://github.com/ClickHouse/ClickHouse/issues/5990) [#6055](https://github.com/ClickHouse/ClickHouse/pull/6055) ([tavplubix](https://github.com/tavplubix))
-   支持在表函数 `file` 和 `hdfs` 的路径中使用通配符. 如果路径包含通配符, 则该表将是只读的. 用法示例: `select * from hdfs('hdfs://hdfs1:9000/some_dir/another_dir/*/file{0..9}{0..9}')` 和 `select * from file('some_dir /{some_file,another_file,yet_another}.tsv', 'TSV', 'value UInt32')`. [#6092](https://github.com/ClickHouse/ClickHouse/pull/6092) ([Olga Khvostikova](https://github.com/stavrolia))
-   新的 `system.metric_log` 表, 它存储具有指定时间间隔的 `system.events` 和 `system.metrics` 的值. [#6363](https://github.com/ClickHouse/ClickHouse/issues/6363) [#6467](https://github.com/ClickHouse/ClickHouse/pull/6467) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)) [#6530](https://github.com/ClickHouse/ClickHouse/pull/6530) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   允许将 ClickHouse 文本日志写入 `system.text_log` 表. [#6037](https://github.com/ClickHouse/ClickHouse/issues/6037) [#6103](https://github.com/ClickHouse/ClickHouse/pull/6103) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)) [#6164](https://github.com/ClickHouse/ClickHouse/pull/6164) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   在堆栈跟踪中显示私有符号 (这是通过解析 ELF 文件的符号表完成的). 如果存在调试信息, 则在堆栈跟踪中添加有关文件和行号的信息. 使用程序中存在的索引符号加速符号名称查找. 添加了用于自省的新 SQL 函数: `demangle` 和 `addressToLine`. 将函数 `symbolizeAddress` 重命名为 `addressToSymbol` 以保持一致性. 出于性能原因, 函数`addressToSymbol` 将返回损坏的名称, 您必须应用`demangle`. 添加了默认关闭的设置 `allow_introspection_functions`. [#6201](https://github.com/ClickHouse/ClickHouse/pull/6201) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   表函数 `values` (名称不区分大小写). 它允许从 [#5984](https://github.com/ClickHouse/ClickHouse/issues/5984) 中提出的 `VALUES` 列表中读取. 示例: `SELECT * FROM VALUES('a UInt64, s String', (1, 'one'), (2, 'two'), (3, 'three'))`. [#6217](https://github.com/ClickHouse/ClickHouse/issues/6217). [#6209](https://github.com/ClickHouse/ClickHouse/pull/6209) ([dimarub2000](https://github.com/dimarub2000))
-   添加了更改存储设置的功能. 语法: `ALTER TABLE <table> MODIFY SETTING <setting> = <value>`. [#6366](https://github.com/ClickHouse/ClickHouse/pull/6366) [#6669](https://github.com/ClickHouse/ClickHouse/pull/6669) [#6685](https://github.com/ClickHouse/ClickHouse/pull/6685) ([alesapin](https://github.com/alesapin))
-   支持拆卸分离部件. 语法: `ALTER TABLE <table_name> DROP DETACHED PART '<part_id>'`. [#6158](https://github.com/ClickHouse/ClickHouse/pull/6158) ([tavplubix](https://github.com/tavplubix))
-   表约束. 允许向表定义添加约束, 这将在插入时检查. [#5273](https://github.com/ClickHouse/ClickHouse/pull/5273) ([Gleb Novikov](https://github.com/NanoBjorn)) [#6652](https://github.com/ClickHouse/ClickHouse/pull/6652) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   支持级联物化视图. [#6324](https://github.com/ClickHouse/ClickHouse/pull/6324) ([Amos Bird](https://github.com/amosbird))
-   默认情况下打开查询分析器以每秒对每个查询执行线程进行一次采样. [#6283](https://github.com/ClickHouse/ClickHouse/pull/6283) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   输入格式 `ORC`. [#6454](https://github.com/ClickHouse/ClickHouse/pull/6454) [#6703](https://github.com/ClickHouse/ClickHouse/pull/6703) ([akonyaev90](https://github.com/akonyaev90))
-   添加了两个新函数: `sigmoid` 和 `tanh` (对机器学习应用程序很有用). [#6254](https://github.com/ClickHouse/ClickHouse/pull/6254) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   函数 `hasToken(haystack, token)`, `hasTokenCaseInsensitive(haystack, token)` 来检查给定的令牌是否在 haystack 中. 令牌是两个非字母数字 ASCII 字符 (或 haystack 的边界) 之间的最大长度子串. 令牌必须是一个常量字符串. 由 tokenbf_v1 索引专业化支持. [#6596](https://github.com/ClickHouse/ClickHouse/pull/6596), [#6662](https://github.com/ClickHouse/ClickHouse/pull/6662) ([Vasily Nemkov](https://github.com/Enmk))
-   新函数 `neighbor(value, offset[, default_value])`. 允许在数据块中的列中达到上一个/下一个值. [#5925](https://github.com/ClickHouse/ClickHouse/pull/5925) ([Alex Krash](https://github.com/alex-krash)) [6685365ab8c5b74f9650492c88a012596eb1b0c6](https://github.com/ClickHouse/ClickHouse/commit/6685365ab8c5b74f9650492c88a012596eb1b0c6) [341e2e4587a18065c2da1ca888c73389f48ce36c](https://github.com/ClickHouse/ClickHouse/commit/341e2e4587a18065c2da1ca888c73389f48ce36c) [Alexey Milovidov](https://github.com/alexey-milovidov)
-   创建了一个函数 `currentUser()`, 返回授权用户的登录信息. 添加别名 `user()` 以兼容 MySQL. [#6470](https://github.com/ClickHouse/ClickHouse/pull/6470) ([Alex Krash](https://github.com/alex-krash))
-   [#5885](https://github.com/ClickHouse/ClickHouse/issues/5885) 中提出的新聚合函数 `quantilesExactInclusive` 和`quantilesExactExclusive`. [#6477](https://github.com/ClickHouse/ClickHouse/pull/6477) ([dimarub2000](https://github.com/dimarub2000))
-   函数 `bitmapRange(bitmap, range_begin, range_end)` 返回具有指定范围的新集合 (不包括`range_end`). [#6314](https://github.com/ClickHouse/ClickHouse/pull/6314) ([Zhichang Yu](https://github.com/yuzhichang))
-   函数 `geohashesInBox(longitude_min, latitude_min, longitude_max, latitude_max, precision)` 它创建覆盖提供区域的 geohash-boxes 的精确长字符串数组. [#6127](https://github.com/ClickHouse/ClickHouse/pull/6127) ([Vasily Nemkov](https://github.com/Enmk))
-   使用 `Kafka` 表实现对 INSERT 查询的支持. [#6012](https://github.com/ClickHouse/ClickHouse/pull/6012) ([Ivan](https://github.com/abyss7))
-   向 Kafka 引擎添加了对 `_partition` 和 `_timestamp` 虚拟列的支持. [#6400](https://github.com/ClickHouse/ClickHouse/pull/6400) ([Ivan](https://github.com/abyss7))
-   可以从`query_log`、服务器日志、使用基于正则表达式的规则的进程列表中删除敏感数据. [#5710](https://github.com/ClickHouse/ClickHouse/pull/5710) ([filimonov](https://github.com/filimonov))

#### 实验功能 {#experimental-feature-2}

-   输入和输出数据格式 `Template` . 它允许为输入和输出指定自定义格式字符串. [#4354](https://github.com/ClickHouse/ClickHouse/issues/4354) [#6727](https://github.com/ClickHouse/ClickHouse/pull/6727) ([tavplubix](https://github.com/tavplubix))
-   最初在 [#2898](https://github.com/ClickHouse/ClickHouse/pull/2898) 中提出的 `LIVE VIEW` 表的实现, 在 [#3925](https://github.com/ClickHouse) 中准备 /ClickHouse/issues/3925)，然后在 [#5541](https://github.com/ClickHouse/ClickHouse/issues/5541) 中更新. 详细说明见[#5541](https://github.com/ClickHouse/ClickHouse/issues/5541). [#5541](https://github.com/ClickHouse/ClickHouse/issues/5541) ([vzakaznikov](https://github.com/vzakaznikov)) [#6425](https://github.com/ ClickHouse/ClickHouse/pull/6425) ([Nikolai Kochetov](https://github.com/KochetovNicolai)) [#6656](https://github.com/ClickHouse/ClickHouse/pull/6656) ([vzakaznikov] (https://github.com/vzakaznikov)) 请注意，下一个版本可能会删除 `LIVE VIEW` 功能.

#### Bug 修复 {#bug-fix-8}

-   此版本还包含 19.13 和 19.11 的所有错误修复.
-   修复表有跳过索引和垂直合并时的分段错误. [#6723](https://github.com/ClickHouse/ClickHouse/pull/6723) ([alesapin](https://github.com/alesapin))
-   使用非平凡的列默认值修复每列 TTL. 以前在强制 TTL 合并与 `OPTIMIZE ... FINAL` 查询的情况下, 过期值被替换为类型默认值而不是用户指定的列默认值. [#6796](https://github.com/ClickHouse/ClickHouse/pull/6796) ([Anton Popov](https://github.com/CurtizJ))
-   修复正常服务器重启时Kafka消息重复问题. [#6597](https://github.com/ClickHouse/ClickHouse/pull/6597) ([Ivan](https://github.com/abyss7))
-   修复了读取 Kafka 消息时的无限循环. 根本不要暂停/恢复消费者订阅 - 否则在某些情况下它可能会无限期暂停. [#6354](https://github.com/ClickHouse/ClickHouse/pull/6354) ([Ivan](https://github.com/abyss7))
-   修复 `bitmapContains` 函数中 `Key expression contains comparison between inconvertible types` 异常. [#6136](https://github.com/ClickHouse/ClickHouse/issues/6136) [#6146](https://github.com/ClickHouse/ClickHouse/issues/6146) [#6156](https://github.com/ClickHouse/ClickHouse/pull/6156) ([dimarub2000](https://github.com/dimarub2000))
-   使用启用的 `optimize_skip_unused_shards` 和丢失的分片键修复段错误. [#6384](https://github.com/ClickHouse/ClickHouse/pull/6384) ([Anton Popov](https://github.com/CurtizJ))
-   修复了可能导致内存损坏的突变中的错误代码. 修复了由于从 `system.parts` 或 `system.parts_columns` 并发 `DROP TABLE` 和 `SELECT` 而可能发生的读取地址 `0x14c0` 的段错误. 修复了准备突变查询时的竞争条件. 修复复制表的 `OPTIMIZE` 和 ALTER 等并发修改操作导致的死锁. [#6514](https://github.com/ClickHouse/ClickHouse/pull/6514) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   在 MySQL 界面中删除了额外的详细日志记录. [#6389](https://github.com/ClickHouse/ClickHouse/pull/6389) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   返回从配置文件中的 `true` 和 `false` 解析布尔设置的能力. [#6278](https://github.com/ClickHouse/ClickHouse/pull/6278) ([alesapin](https://github.com/alesapin))
-   修复了 `Nullable(Decimal128)` 上 `quantile` 和 `median` 函数中的崩溃. [#6378](https://github.com/ClickHouse/ClickHouse/pull/6378) ([Artem Zuikov](https://github.com/4ertus2))
-   修复了主键上包含转换为 Float 类型的带有 `WHERE` 条件的 `SELECT` 查询可能返回的不完整结果. 它是由 `toFloat` 函数中的单调性检查不正确引起的. [#6248](https://github.com/ClickHouse/ClickHouse/issues/6248) [#6374](https://github.com/ClickHouse/ClickHouse/pull/6374) ([dimarub2000](https://github.com/dimarub2000))
-   检查 `max_expanded_ast_elements` 设置是否有突变. 在 `TRUNCATE TABLE` 之后清除突变. [#6205](https://github.com/ClickHouse/ClickHouse/pull/6205) ([Winter Zhang](https://github.com/zhang2014))
-   与`join_use_nulls` 一起使用时，修复键列的JOIN 结果. 附加空值而不是列默认值. [#6249](https://github.com/ClickHouse/ClickHouse/pull/6249) ([Artem Zuikov](https://github.com/4ertus2))
-   修复具有垂直合并和更改的跳过索引. 修复 `Bad size of marks file` 异常. [#6594](https://github.com/ClickHouse/ClickHouse/issues/6594) [#6713](https://github.com/ClickHouse/ClickHouse/pull/6713) ([alesapin](https://github.com/alesapin))
-   当合并/更改的部分之一为空(0 行)时, 修复 `ALTER MODIFY COLUMN` 和垂直合并中的罕见崩溃. [#6746](https://github.com/ClickHouse/ClickHouse/issues/6746) [#6780](https://github.com/ClickHouse/ClickHouse/pull/6780) ([alesapin](https://github.com/alesapin))
-   修复了在 `AggregateFunctionFactory` 中转换 `LowCardinality` 类型的错误. 这修复了 [#6257](https://github.com/ClickHouse/ClickHouse/issues/6257). [#6281](https://github.com/ClickHouse/ClickHouse/pull/6281) ([Nikolai Kochetov](https://github.com/KochetovNicolai))
-   修复 `topK` 和 `topK Weighted` 聚合函数中的错误行为和可能的段错误. [#6404](https://github.com/ClickHouse/ClickHouse/pull/6404) ([Anton Popov](https://github.com/CurtizJ))
-   修复了围绕 `getIdentifier` 函数的不安全代码. [#6401](https://github.com/ClickHouse/ClickHouse/issues/6401) [#6409](https://github.com/ClickHouse/ClickHouse/pull/6409) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   修复了 MySQL 有线协议中的错误(在连接到 ClickHouse 表单 MySQL 客户端时使用). 由 `PacketPayloadWriteBuffer` 中的堆缓冲区溢出引起. [#6212](https://github.com/ClickHouse/ClickHouse/pull/6212) ([Yuriy Baranov](https://github.com/yurriy))
-   修复了 `bitmapSubsetInRange` 函数中的内存泄漏. [#6819](https://github.com/ClickHouse/ClickHouse/pull/6819) ([Zhichang Yu](https://github.com/yuzhichang))
-   修复粒度更改后执行变异时的罕见错误. [#6816](https://github.com/ClickHouse/ClickHouse/pull/6816) ([alesapin](https://github.com/alesapin))
-   默认允许所有字段的 protobuf 消息. [#6132](https://github.com/ClickHouse/ClickHouse/pull/6132) ([Vitaly Baranov](https://github.com/vitlibar))
-   当我们在第二个参数上发送一个 `NULL` 参数时，解决了一个带有 `nullIf` 函数的错误. [#6446](https://github.com/ClickHouse/ClickHouse/pull/6446) ([Guillaume Tassery](https://github.com/YiuRULE))
-   修复带有字符串字段的复杂键缓存字典中内存分配/释放错误的罕见错误, 这会导致无限内存消耗(看起来像内存泄漏). 当字符串大小是从 8 开始的 2 的幂(8、16、32 等)时会重现错误. [#6447](https://github.com/ClickHouse/ClickHouse/pull/6447) ([alesapin](https://github.com/alesapin))
-   修复了小序列上的 Gorilla 编码导致异常 `Cannot write after end of buffer`. [#6398](https://github.com/ClickHouse/ClickHouse/issues/6398) [#6444](https://github.com/ClickHouse/ClickHouse/pull/6444) ([Vasily Nemkov](https://github.com/Enmk))
-   允许在启用了 `join_use_nulls` 的 JOIN 中使用不可为空的类型. [#6705](https://github.com/ClickHouse/ClickHouse/pull/6705) ([Artem Zuikov](https://github.com/4ertus2))
-   在 `clickhouse-client` 中禁用查询中的 `Poco::AbstractConfiguration` 替换. [#6706](https://github.com/ClickHouse/ClickHouse/pull/6706) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   避免 `REPLACE PARTITION` 中的死锁. [#6677](https://github.com/ClickHouse/ClickHouse/pull/6677) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   对常量参数使用 `arrayReduce` 可能会导致段错误. [#6242](https://github.com/ClickHouse/ClickHouse/issues/6242) [#6326](https://github.com/ClickHouse/ClickHouse/pull/6326) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   修复在 `DROP PARTITION` 之后恢复副本时可能出现的不一致部分. [#6522](https://github.com/ClickHouse/ClickHouse/issues/6522) [#6523](https://github.com/ClickHouse/ClickHouse/pull/6523) ([tavplubix](https://github.com/tavplubix))
-   修复了 `JSONExtractRaw` 函数挂起的问题. [#6195](https://github.com/ClickHouse/ClickHouse/issues/6195) [#6198](https://github.com/ClickHouse/ClickHouse/pull/6198) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   使用自适应粒度修复不正确的跳过索引序列化和聚合的错误. [#6594](https://github.com/ClickHouse/ClickHouse/issues/6594). [#6748](https://github.com/ClickHouse/ClickHouse/pull/6748) ([alesapin](https://github.com/alesapin))
-   使用两级聚合修复 `GROUP BY` 的 `WITH ROLLUP` 和 `WITH CUBE` 修饰符. [#6225](https://github.com/ClickHouse/ClickHouse/pull/6225) ([Anton Popov](https://github.com/CurtizJ))
-   修复以自适应粒度写入二级索引标记的错误. [#6126](https://github.com/ClickHouse/ClickHouse/pull/6126) ([alesapin](https://github.com/alesapin))
-   修复服务器启动时的初始化顺序. 由于 `StorageMergeTree::background_task_handle` 是在 `startup()` 中初始化的, 所以 `MergeTreeBlockOutputStream::write()` 可能会在初始化之前尝试使用它. 只需检查它是否已初始化. [#6080](https://github.com/ClickHouse/ClickHouse/pull/6080) ([Ivan](https://github.com/abyss7))
-   清除上一个因错误而完成的读操作的数据缓冲区. [#6026](https://github.com/ClickHouse/ClickHouse/pull/6026) ([Nikolay](https://github.com/bopohaa))
-   修复为 Replicated\*MergeTree 表创建新副本时启用自适应粒度的错误. [#6394](https://github.com/ClickHouse/ClickHouse/issues/6394) [#6452](https://github.com/ClickHouse/ClickHouse/pull/6452) ([alesapin](https://github.com/alesapin))
-   修复了在访问未初始化的 `ThreadStatus` 结构时出现异常时在 `libunwind` 中发生异常的情况下服务器启动期间可能发生的崩溃. [#6456](https://github.com/ClickHouse/ClickHouse/pull/6456) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov))
-   修复 `yandexConsistentHash` 函数中的崩溃. 通过模糊测试发现. [#6304](https://github.com/ClickHouse/ClickHouse/issues/6304) [#6305](https://github.com/ClickHouse/ClickHouse/pull/6305) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   修复了服务器过载和全局线程池接近满时挂起查询的可能性. 这在具有大量分片(数百个)的集群上发生的可能性更高, 因为分布式查询为每个连接分配一个线程到每个分片. 例如, 如果 330 个分片的集群正在处理 30 个并发分布式查询, 则此问题可能会重现. 此问题影响从 19.2 开始的所有版本. [#6301](https://github.com/ClickHouse/ClickHouse/pull/6301) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   修复了`arrayEnumerateUniqRanked` 函数的逻辑. [#6423](https://github.com/ClickHouse/ClickHouse/pull/6423) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   修正解码符号表时的段错误. [#6603](https://github.com/ClickHouse/ClickHouse/pull/6603) ([Amos Bird](https://github.com/amosbird))
-   修复了将 `LowCardinality(Nullable)` 转换为 not-Nullable 列中的不相关异常, 以防它不包含 Nulls (例如, 在像 `SELECT CAST(CAST('Hello' AS LowCardinality(Nullable(String)))] AS String 这样的查询中 )`. [#6094](https://github.com/ClickHouse/ClickHouse/issues/6094) [#6119](https://github.com/ClickHouse/ClickHouse/pull/6119) ([Nikolai Kochetov](https://github.com/KochetovNicolai))
-   删除了 `system.settings` 表中额外的描述引用. [#6696](https://github.com/ClickHouse/ClickHouse/issues/6696) [#6699](https://github.com/ClickHouse/ClickHouse/pull/6699) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   避免在复制表的 `TRUNCATE` 中可能出现死锁. [#6695](https://github.com/ClickHouse/ClickHouse/pull/6695) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   修正了按键排序的顺序读取. [#6189](https://github.com/ClickHouse/ClickHouse/pull/6189) ([Anton Popov](https://github.com/CurtizJ))
-   修复带有 `enable_mixed_granularity_parts=1` 的表的 `ALTER TABLE ... UPDATE` 查询. [#6543](https://github.com/ClickHouse/ClickHouse/pull/6543) ([alesapin](https://github.com/alesapin))
-   修复 [#4405](https://github.com/ClickHouse/ClickHouse/pull/4405) 打开的错误 (自 19.4.0 起). 当我们不查询任何列 (`SELECT 1`) 时, 通过 MergeTree 表在对分布式表的查询中重现. [#6236](https://github.com/ClickHouse/ClickHouse/pull/6236) ([alesapin](https://github.com/alesapin))
-   修复了有符号类型到无符号类型的整数除法中的溢出. 该行为与 C 或 C++ 语言 (整数提升规则) 中的行为完全相同, 这可能令人惊讶. 请注意, 将大有符号数除以大无符号数或反之亦然时仍然可能发生溢出 (但这种情况不太常见). 所有服务器版本都存在该问题. [#6214](https://github.com/ClickHouse/ClickHouse/issues/6214) [#6233](https://github.com/ClickHouse/ClickHouse/pull/6233) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   当设置了 `max_execution_speed` 或 `max_execution_speed_bytes` 时, 限制用于节流的最大休眠时间. 修复了 `Estimated query execution time (inf seconds) is too long` 等错误错误. [#5547](https://github.com/ClickHouse/ClickHouse/issues/5547) [#6232](https://github.com/ClickHouse/ClickHouse/pull/6232) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   修复了在`MaterializedView`中使用`MATERIALIZED`列和别名的问题. [#448](https://github.com/ClickHouse/ClickHouse/issues/448) [#3484](https://github.com/ClickHouse/ClickHouse/issues/3484) [#3450](https://github.com/ClickHouse/ClickHouse/issues/3450) [#2878](https://github.com/ClickHouse/ClickHouse/issues/2878) [#2285](https://github.com/ClickHouse/ClickHouse/issues/2285) [#3796](https://github.com/ClickHouse/ClickHouse/pull/3796) ([Amos Bird](https://github.com/amosbird)) [#6316](https://github.com/ClickHouse/ClickHouse/pull/6316) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   修复未实现为处理器的输入流的 `FormatFactory` 行为. [#6495](https://github.com/ClickHouse/ClickHouse/pull/6495) ([Nikolai Kochetov](https://github.com/KochetovNicolai))
-   修正了错字. [#6631](https://github.com/ClickHouse/ClickHouse/pull/6631) ([Alex Ryndin](https://github.com/alexryndin))
-   错误消息中的错字 ( is -\> are ). [#6839](https://github.com/ClickHouse/ClickHouse/pull/6839) ([Denis Zhuravlev](https://github.com/den-crane))
-   如果类型包含逗号, 则从字符串解析列列表时已修复错误 (此问题与 `File`、`URL`、`HDFS` 存储相关) [#6217](https://github.com/ClickHouse/ClickHouse/issues/6217). [#6209](https://github.com/ClickHouse/ClickHouse/pull/6209) ([dimarub2000](https://github.com/dimarub2000))

#### 安全修复 {#security-fix}

-   此版本还包含 19.13 和 19.11 的所有错误安全修复.
-   修复了由于 SQL 解析器中的堆栈溢出, 伪造查询导致服务器崩溃的可能性. 修复了合并和分布式表、物化视图和涉及子查询的行级安全条件中堆栈溢出的可能性. [#6433](https://github.com/ClickHouse/ClickHouse/pull/6433) ([alexey-milovidov](https://github.com/alexey-milovidov))

#### 改进 {#improvement-3}

-   正确实现 `AND/OR` 的三元逻辑. [#6048](https://github.com/ClickHouse/ClickHouse/pull/6048) ([Alexander Kazakov](https://github.com/Akazz))
-   现在, 在从没有 TTL 信息或过时的 TTL 信息的旧部分进行 `OPTIMIZE ... FINAL` 查询后, 将删除具有过期 TTL 的值和行, 例如, 在 `ALTER ... MODIFY TTL` 查询之后. 添加了查询 `SYSTEM STOP/START TTL MERGES` 以禁止/允许使用 TTL 分配合并并过滤所有合并中的过期值. [#6274](https://github.com/ClickHouse/ClickHouse/pull/6274) ([Anton Popov](https://github.com/CurtizJ))
-   可以使用 `CLICKHOUSE_HISTORY_FILE` env 为客户端更改 ClickHouse 历史文件的位置. [#6840](https://github.com/ClickHouse/ClickHouse/pull/6840) ([filimonov](https://github.com/filimonov))
-   从 `InterpreterSelectQuery` 中删除 `dry_run` 标志. … [#6375](https://github.com/ClickHouse/ClickHouse/pull/6375) ([Nikolai Kochetov](https://github.com/KochetovNicolai))
-   支持带有 `ON` 部分的 `ASOF JOIN`. [#6211](https://github.com/ClickHouse/ClickHouse/pull/6211) ([Artem Zuikov](https://github.com/4ertus2))
-   更好地支持用于突变和复制的跳过索引. 支持 `MATERIALIZE/CLEAR INDEX ... IN PARTITION` 查询. `UPDATE x = x` 重新计算所有使用列 `x` 的索引. [#5053](https://github.com/ClickHouse/ClickHouse/pull/5053) ([Nikita Vasilev](https://github.com/nikvas0))
-  无论 `allow_experimental_live_view` 设置如何, 都允许使用 `ATTACH` 实时视图 (例如，在服务器启动时). [#6754](https://github.com/ClickHouse/ClickHouse/pull/6754) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   对于查询分析器收集的堆栈跟踪, 不包括查询分析器本身生成的堆栈帧. [#6250](https://github.com/ClickHouse/ClickHouse/pull/6250) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   现在表函数`values`、`file`、`url`、`hdfs` 支持ALIAS 列. [#6255](https://github.com/ClickHouse/ClickHouse/pull/6255) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   如果 `config.d` 文件没有对应的根元素作为配置文件, 则抛出异常. [#6123](https://github.com/ClickHouse/ClickHouse/pull/6123) ([dimarub2000](https://github.com/dimarub2000))
-   在 `no space left on device` 的异常消息中打印额外信息. [#6182](https://github.com/ClickHouse/ClickHouse/issues/6182), [#6252](https://github.com/ClickHouse/ClickHouse/issues/6252) [#6352](https://github.com/ClickHouse/ClickHouse/pull/6352) ([tavplubix](https://github.com/tavplubix))
-   在确定读取查询要覆盖的 `Distributed` 表的分片时 (对于 `optimize_skip_unused_shards` =1), ClickHouse 现在检查来自 select 语句的 `prewhere` 和 `where` 子句的条件. [#6521](https://github.com/ClickHouse/ClickHouse/pull/6521) ([Alexander Kazakov](https://github.com/Akazz))
-   为没有 AVX2 但有 SSE 4.2 和 PCLMUL 指令集的机器启用`SIMDJSON`. [#6285](https://github.com/ClickHouse/ClickHouse/issues/6285) [#6320](https://github.com/ClickHouse/ClickHouse/pull/6320) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   ClickHouse 可以在没有 `O_DIRECT` 支持的文件系统上工作（例如 ZFS 和 BtrFS），无需额外调整. [#4449](https://github.com/ClickHouse/ClickHouse/issues/4449) [#6730](https://github.com/ClickHouse/ClickHouse/pull/6730) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   支持最终子查询的下推谓词. [#6120](https://github.com/ClickHouse/ClickHouse/pull/6120) ([TCeason](https://github.com/TCeason)) [#6162](https://github.com/ClickHouse/ClickHouse/pull/6162) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   更好的`JOIN ON`键提取. [#6131](https://github.com/ClickHouse/ClickHouse/pull/6131) ([Artem Zuikov](https://github.com/4ertus2))
-   更新了 `SIMDJSON`. [#6285](https://github.com/ClickHouse/ClickHouse/issues/6285). [#6306](https://github.com/ClickHouse/ClickHouse/pull/6306) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   优化 `SELECT count()` 查询最小列的选择. [#6344](https://github.com/ClickHouse/ClickHouse/pull/6344) ([Amos Bird](https://github.com/amosbird))
-   在 `windowFunnel()` 中添加了 `strict` 参数. 当设置了 `strict` 时, `windowFunnel()` 只对唯一值应用条件. [#6548](https://github.com/ClickHouse/ClickHouse/pull/6548) ([achimbab](https://github.com/achimbab))
-   `mysqlxx::Pool` 更安全的接口. [#6150](https://github.com/ClickHouse/ClickHouse/pull/6150) ([avasiliev](https://github.com/avasiliev))
-   使用 `--help` 选项执行时的选项行大小现在对应于终端大小. [#6590](https://github.com/ClickHouse/ClickHouse/pull/6590) ([dimarub2000](https://github.com/dimarub2000))
-   禁用无键聚合的 `read in order` 优化. [#6599](https://github.com/ClickHouse/ClickHouse/pull/6599) ([Anton Popov](https://github.com/CurtizJ))
-   `INCORRECT_DATA` 和 `TYPE_MISMATCH` 错误代码的 HTTP 状态代码从默认的 `500 Internal Server Error` 更改为 `400 Bad Request`. [#6271](https://github.com/ClickHouse/ClickHouse/pull/6271) ([Alexander Rodin](https://github.com/a-rodin))
-   将 Join 对象从 `ExpressionAction` 移动到 `AnalyzedJoin`. `ExpressionAnalyzer` 和 `ExpressionAction` 不再了解 `Join` 类. 它的逻辑被`AnalyzedJoin` iface隐藏了. [#6801](https://github.com/ClickHouse/ClickHouse/pull/6801) ([Artem Zuikov](https://github.com/4ertus2))
-   修复了当分片之一是本地主机但查询是通过网络连接发送时分布式查询可能出现的死锁. [#6759](https://github.com/ClickHouse/ClickHouse/pull/6759) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   更改了多个表 `RENAME` 的语义以避免可能的死锁. [#6757](https://github.com/ClickHouse/ClickHouse/issues/6757). [#6756](https://github.com/ClickHouse/ClickHouse/pull/6756) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   重写 MySQL 兼容性服务器以防止在内存中加载完整的数据包负载. 每个连接的内存消耗减少到大约 `2 * DBMS_DEFAULT_BUFFER_SIZE` (读/写缓冲区). [#5811](https://github.com/ClickHouse/ClickHouse/pull/5811) ([Yuriy Baranov](https://github.com/yurriy))
-   将 AST 别名解释逻辑移出不必了解查询语义的解析器. [#6108](https://github.com/ClickHouse/ClickHouse/pull/6108) ([Artem Zuikov](https://github.com/4ertus2))
-   NamesAndTypesList` 稍微更安全的解析. [#6408](https://github.com/ClickHouse/ClickHouse/issues/6408). [#6410](https://github.com/ClickHouse/ClickHouse/pull/6410) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   `clickhouse-copier`: 允许在查询中使用带有 `partition_key` 别名的配置中的 `where_condition` 来检查分区是否存在 (之前它仅用于读取数据查询). [#6577](https://github.com/ClickHouse/ClickHouse/pull/6577) ([proller](https://github.com/proller))
-   在 `throwIf` 中添加了可选的消息参数. ([#5772](https://github.com/ClickHouse/ClickHouse/issues/5772)) [#6329](https://github.com/ClickHouse/ClickHouse/pull/6329) ([Vdimir](https://github.com/Vdimir))
-   发送插入数据时出现的服务器异常现在也在客户端处理. [#5891](https://github.com/ClickHouse/ClickHouse/issues/5891) [#6711](https://github.com/ClickHouse/ClickHouse/pull/6711) ([dimarub2000](https://github.com/dimarub2000))
-  添加了一个指标 `DistributedFilesToInsert` , 显示文件系统中被分布式表选择发送到远程服务器的文件总数. 该数字是所有分片的总和. [#6600](https://github.com/ClickHouse/ClickHouse/pull/6600) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   将大部分 JOIN 准备逻辑从 `ExpressionAction/ExpressionAnalyzer` 移动到 `AnalyzedJoin`. [#6785](https://github.com/ClickHouse/ClickHouse/pull/6785) ([Artem Zuikov](https://github.com/4ertus2))
-   修复 TSan [warning](https://clickhouse-test-reports.s3.yandex.net/6399/c1c1d1daa98e199e620766f1bd06a5921050a00d/functional_stateful_tests_(thread).html) `lock-order-inversion`. [#6740](https://github.com/ClickHouse/ClickHouse/pull/6740) ([Vasily Nemkov](https://github.com/Enmk))
-   关于缺乏 Linux 功能的更好的信息消息. 使用 `fatal` 级别记录致命错误, 这将使其更容易在 `system.text_log` 中找到. [#6441](https://github.com/ClickHouse/ClickHouse/pull/6441) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   当启用将临时数据转储到磁盘以限制 `GROUP BY`、`ORDER BY`期间的内存使用时, 它没有检查可用磁盘空间. 修复添加一个新的设置 `min_free_disk_space`, 当可用磁盘空间小于阈值时, 查询将停止并抛出 `ErrorCodes::NOT_ENOUGH_SPACE`. [#6678](https://github.com/ClickHouse/ClickHouse/pull/6678) ([Weiqing Xu](https://github.com/weiqxu)) [#6691](https://github.com/ClickHouse/ClickHouse/pull/6691) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   通过线程删除递归 rwlock. 这是没有意义的，因为线程在查询之间被重用. `SELECT` 查询可能会在一个线程中获取锁, 从另一个线程持有锁并从第一个线程退出. 同时, 第一个线程可以被 `DROP` 查询重用。 这将导致错误的 `Attempt to acquire exclusive lock recursively` 消息. [#6771](https://github.com/ClickHouse/ClickHouse/pull/6771) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   拆分 `Expression Analyzer.appendLine()`. 在 `ExpressionAnalyzer` 中为 `Merge Join` 准备一个位置. [#6524](https://github.com/ClickHouse/ClickHouse/pull/6524) ([Artem Zuikov](https://github.com/4ertus2))
-   向 MySQL 兼容服务器添加了 `mysql_native_password` 身份验证插件. [#6194](https://github.com/ClickHouse/ClickHouse/pull/6194) ([Yuriy Baranov](https://github.com/yurriy))
-   更少的 `clock_gettime` 调用; 修复了 `Allocator` 中调试/发布之间的 ABI 兼容性 (无关紧要的问题). [#6197](https://github.com/ClickHouse/ClickHouse/pull/6197) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   将 `collectUsedColumns` 从 `ExpressionAnalyzer` 移至 `Syntax Analyzer`. `Syntax Analyzer` 现在生成 `required_source_columns`. [#6416](https://github.com/ClickHouse/ClickHouse/pull/6416) ([Artem Zuikov](https://github.com/4ertus2))
-   添加设置 `joined_subquery_requires_alias` 以要求 `FROM` 中存在多个表的子选择和表函数的别名 (比如使用JOIN的查询). [#6733](https://github.com/ClickHouse/ClickHouse/pull/6733) ([Artem Zuikov](https://github.com/4ertus2))
-   从 `ExpressionAnalyzer` 中提取 `GetAggregatesVisitor` 类. [#6458](https://github.com/ClickHouse/ClickHouse/pull/6458) ([Artem Zuikov](https://github.com/4ertus2))
-   `system.query_log`: 将 `type` 列的数据类型更改为 `Enum`. [#6265](https://github.com/ClickHouse/ClickHouse/pull/6265) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov))
-   `sha256_password` 认证插件的静态链接. [#6512](https://github.com/ClickHouse/ClickHouse/pull/6512) ([Yuriy Baranov](https://github.com/yurriy))
-   避免设置 `compile` 工作的额外依赖. 在以前的版本中, 用户可能会收到诸如 `cannot open crti.o`、`unable to find library -lc` 等错误. [#6309](https://github.com/ClickHouse/ClickHouse/pull/6309) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   对可能来自恶意副本的输入进行更多验证. [#6303](https://github.com/ClickHouse/ClickHouse/pull/6303) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   现在 `clickhouse-obfuscator` 文件在 `clickhouse-client` 包中可用. 在以前的版本中, 它可用作 `clickhouse obfuscator` (带空格). [#5816](https://github.com/ClickHouse/ClickHouse/issues/5816) [#6609](https://github.com/ClickHouse/ClickHouse/pull/6609) ([dimarub2000](https://github.com/dimarub2000))
-   当我们有至少两个以不同顺序读取至少两个表的查询和另一个对其中一个表执行 DDL 操作的查询时, 修复了死锁. 修复了另一个非常罕见的僵局. [#6764](https://github.com/ClickHouse/ClickHouse/pull/6764) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   向 `system.processes` 和 `system.query_log` 添加了 `os_thread_ids` 列以获得更好的调试可能性. [#6763](https://github.com/ClickHouse/ClickHouse/pull/6763) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   当 `sha256_password` 用作默认身份验证插件时发生的PHP mysqlnd扩展错误的解决方法 (在[#6031](https://github.com/ClickHouse/ClickHouse/issues/6031)中描述). [#6113](https://github.com/ClickHouse/ClickHouse/pull/6113) ([Yuriy Baranov](https://github.com/yurriy))
-   使用已更改的可空性列删除不需要的位置. [#6693](https://github.com/ClickHouse/ClickHouse/pull/6693) ([Artem Zuikov](https://github.com/4ertus2))
-   将 `queue_max_wait_ms` 的默认值设置为零， 因为当前值(五秒) 没有意义. 在极少数情况下, 此设置有任何用处. 添加了设置 `replace_running_query_max_wait_ms`、`kafka_max_wait_ms` 和 `connection_pool_max_wait_ms` 以消除歧义. [#6692](https://github.com/ClickHouse/ClickHouse/pull/6692) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   从 `ExpressionAnalyzer` 中提取 `SelectQueryExpressionAnalyzer`. 保留最后一个用于非选择查询. [#6499](https://github.com/ClickHouse/ClickHouse/pull/6499) ([Artem Zuikov](https://github.com/4ertus2))
-   删除了重复的输入和输出格式. [#6239](https://github.com/ClickHouse/ClickHouse/pull/6239) ([Nikolai Kochetov](https://github.com/KochetovNicolai))
-   允许用户在连接时覆盖 `poll_interval` 和 `idle_connection_timeout` 设置. [#6230](https://github.com/ClickHouse/ClickHouse/pull/6230) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   `MergeTree` 现在有一个附加选项 `ttl_only_drop_parts` (默认情况下禁用) 以避免部分修剪部分, 以便在部分中的所有行都过期时完全删除. [#6191](https://github.com/ClickHouse/ClickHouse/pull/6191) ([Sergi Vladykin](https://github.com/svladykin))
-   类型检查集合索引函数. 如果函数类型错误, 则抛出异常. 这修复了 UBSan 的模糊测试. [#6511](https://github.com/ClickHouse/ClickHouse/pull/6511) ([Nikita Vasilev](https://github.com/nikvas0))

#### 性能改进 {#performance-improvement-2}

-   使用 `ORDER BY expressions` 子句优化查询, 其中 `expressions` 具有与 `MergeTree` 表中的排序键重合的前缀. 此优化由 `optimize_read_in_order` 设置控制. [#6054](https://github.com/ClickHouse/ClickHouse/pull/6054) [#6629](https://github.com/ClickHouse/ClickHouse/pull/6629) ([Anton Popov](https://github.com/CurtizJ))
-   允许在零件装载和拆卸期间使用多个螺纹. [#6372](https://github.com/ClickHouse/ClickHouse/issues/6372) [#6074](https://github.com/ClickHouse/ClickHouse/issues/6074) [#6438](https://github.com/ClickHouse/ClickHouse/pull/6438) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   实现了更新聚合函数状态的批处理变体. 它可能会带来性能优势. [#6435](https://github.com/ClickHouse/ClickHouse/pull/6435) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   对函数 `exp`、`log`、`sigmoid`、`tanh`使用 `FastOps` 库. FastOps 是 Michael Parakhin(Yandex CTO)的一个快速向量数学库. `exp` 和 `log` 函数的性能提高了 6 倍以上. `Float32` 参数中的函数 `exp` 和 `log` 将返回 `Float32`(在以前的版本中，它们总是返回 `Float64`). 现在 `exp(nan)` 可能返回 `inf`. `exp` 和 `log` 函数的结果可能不是最接近真实答案的机器可表示数字. [#6254](https://github.com/ClickHouse/ClickHouse/pull/6254) ([alexey-milovidov](https://github.com/alexey-milovidov)) 使用 Danila Kutenin 变体使 fastops 工作 [ #6317](https://github.com/ClickHouse/ClickHouse/pull/6317) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   禁用 `UInt8/16` 的连续键优化. [#6298](https://github.com/ClickHouse/ClickHouse/pull/6298) [#6701](https://github.com/ClickHouse/ClickHouse/pull/6701) ([akuzm](https://github.com/akuzm))
-   通过摆脱 `ParsedJson::Iterator` 中的动态分配, 提高了 `simdjson` 库的性能. [#6479](https://github.com/ClickHouse/ClickHouse/pull/6479) ([Vitaly Baranov](https://github.com/vitlibar))
-   使用 `mmap()` 分配内存时的故障前页面. [#6667](https://github.com/ClickHouse/ClickHouse/pull/6667) ([akuzm](https://github.com/akuzm))
-   修复 `Decimal` 比较中的性能错误. [#6380](https://github.com/ClickHouse/ClickHouse/pull/6380) ([Artem Zuikov](https://github.com/4ertus2))

#### 构建/测试/打包改进 {#buildtestingpackaging-improvement-4}

-   删除编译器 (运行时模板实例化), 因为我们已经赢得了它的性能. [#6646](https://github.com/ClickHouse/ClickHouse/pull/6646) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   添加了性能测试, 以更孤立的方式显示 gcc-9 中的性能下降. [#6302](https://github.com/ClickHouse/ClickHouse/pull/6302) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   添加了表函数`numbers_mt`, 它是`numbers`的多线程版本. 使用哈希函数更新性能测试. [#6554](https://github.com/ClickHouse/ClickHouse/pull/6554) ([Nikolai Kochetov](https://github.com/KochetovNicolai))
-   `clickhouse-benchmark` 中的比较模式. [#6220](https://github.com/ClickHouse/ClickHouse/issues/6220) [#6343](https://github.com/ClickHouse/ClickHouse/pull/6343) ([dimarub2000](https://github.com/dimarub2000))
-   尽最大努力打印堆栈跟踪. 还添加了 `SIGPROF` 作为调试信号以打印正在运行的线程的堆栈跟踪. [#6529](https://github.com/ClickHouse/ClickHouse/pull/6529) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   每个函数都在自己的文件中, 第 10 部分. [#6321](https://github.com/ClickHouse/ClickHouse/pull/6321) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   删除加倍的 const `TABLE_IS_READ_ONLY`. [#6566](https://github.com/ClickHouse/ClickHouse/pull/6566) ([filimonov](https://github.com/filimonov))
-   `StringHashMap` PR [#5417](https://github.com/ClickHouse/ClickHouse/issues/5417) 的格式更改. [#6700](https://github.com/ClickHouse/ClickHouse/pull/6700) ([akuzm](https://github.com/akuzm))
-   在`ExpressionAnalyzer` 中创建连接的更好子查询. [#6824](https://github.com/ClickHouse/ClickHouse/pull/6824) ([Artem Zuikov](https://github.com/4ertus2))
-   删除冗余条件 (由 PVS Studio 发现). [#6775](https://github.com/ClickHouse/ClickHouse/pull/6775) ([akuzm](https://github.com/akuzm))
-   分离`ReverseIndex`的哈希表接口. [#6672](https://github.com/ClickHouse/ClickHouse/pull/6672) ([akuzm](https://github.com/akuzm))
-   重构设置. [#6689](https://github.com/ClickHouse/ClickHouse/pull/6689) ([alesapin](https://github.com/alesapin))
-   为 `set` 索引函数添加注释. [#6319](https://github.com/ClickHouse/ClickHouse/pull/6319) ([Nikita Vasilev](https://github.com/nikvas0))
-   在 Linux 上的调试版本中提高 OOM 分数. [#6152](https://github.com/ClickHouse/ClickHouse/pull/6152) ([akuzm](https://github.com/akuzm))
-   HDFS HA 现在可用于调试版本. [#6650](https://github.com/ClickHouse/ClickHouse/pull/6650) ([Weiqing Xu](https://github.com/weiqxu))
-   向 `transform_query_for_external_database` 添加了一个测试. [#6388](https://github.com/ClickHouse/ClickHouse/pull/6388) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   为 Kafka 表添加多个物化视图的测试. [#6509](https://github.com/ClickHouse/ClickHouse/pull/6509) ([Ivan](https://github.com/abyss7))
-   制定更好的构建方案. [#6500](https://github.com/ClickHouse/ClickHouse/pull/6500) ([Ivan](https://github.com/abyss7))
-   修复了 `test_external_dictionaries` 集成, 以防它在非 root 用户下执行. [#6507](https://github.com/ClickHouse/ClickHouse/pull/6507) ([Nikolai Kochetov](https://github.com/KochetovNicolai))
-   当写入数据包的总大小超过`DBMS_DEFAULT_BUFFER_SIZE`时, 该错误会重现. [#6204](https://github.com/ClickHouse/ClickHouse/pull/6204) ([Yuriy Baranov](https://github.com/yurriy))
-   添加了对 `RENAME` 表竞争条件的测试. [#6752](https://github.com/ClickHouse/ClickHouse/pull/6752) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   避免 `KILL QUERY` 中设置的数据竞争. [#6753](https://github.com/ClickHouse/ClickHouse/pull/6753) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   添加集成测试以通过缓存字典处理错误. [#6755](https://github.com/ClickHouse/ClickHouse/pull/6755) ([Vitaly Baranov](https://github.com/vitlibar))
-   在 Mac OS 上禁用解析 ELF 对象文件, 因为它没有意义. [#6578](https://github.com/ClickHouse/ClickHouse/pull/6578) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   尝试使变更日志生成器更好. [#6327](https://github.com/ClickHouse/ClickHouse/pull/6327) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   将 `-Wshadow` 开关添加到 GCC. [#6325](https://github.com/ClickHouse/ClickHouse/pull/6325) ([kreuzerkrieg](https://github.com/kreuzerkrieg))
-   删除了对 `mimalloc` 支持的过时代码. [#6715](https://github.com/ClickHouse/ClickHouse/pull/6715) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   `zlib-ng` 确定 x86 功能并将此信息保存到全局变量. 这是在 defalteInit 调用中完成的, 它可以由不同的线程同时进行. 为避免多线程写入, 请在库启动时执行. [#6141](https://github.com/ClickHouse/ClickHouse/pull/6141) ([akuzm](https://github.com/akuzm))
-   对在 [#5192](https://github.com/ClickHouse/ClickHouse/issues/5192) 中修复的连接中的错误进行回归测试. [#6147](https://github.com/ClickHouse/ClickHouse/pull/6147) ([Bakhtiyor Ruziev](https://github.com/theruziev))
-   修复了 MSan 报告. [#6144](https://github.com/ClickHouse/ClickHouse/pull/6144) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   修复抖动 TTL 测试. [#6782](https://github.com/ClickHouse/ClickHouse/pull/6782) ([Anton Popov](https://github.com/CurtizJ))
-   修复了 `MergeTreeDataPart::is_frozen` 字段中的错误数据竞争. [#6583](https://github.com/ClickHouse/ClickHouse/pull/6583) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   修复了模糊测试中的超时. 在以前的版本中, 它设法在查询 `SELECT * FROM numbers_mt(gccMurmurHash(''))` 中找到错误挂断. [#6582](https://github.com/ClickHouse/ClickHouse/pull/6582) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   向列的 `static_cast` 添加调试检查. [#6581](https://github.com/ClickHouse/ClickHouse/pull/6581) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   在官方 RPM 包中支持 Oracle Linux. [#6356](https://github.com/ClickHouse/ClickHouse/issues/6356) [#6585](https://github.com/ClickHouse/ClickHouse/pull/6585) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   将 json perftests 从 `once` 更改为 `loop` 类型. [#6536](https://github.com/ClickHouse/ClickHouse/pull/6536) ([Nikolai Kochetov](https://github.com/KochetovNicolai))
-   `odbc-bridge.cpp` 定义了 `main()`, 因此它不应包含在 `clickhouse-lib` 中. [#6538](https://github.com/ClickHouse/ClickHouse/pull/6538) ([Orivej Desh](https://github.com/orivej))
-   测试 `FULL|RIGHT JOIN` 中的崩溃, 右表的键为空. [#6362](https://github.com/ClickHouse/ClickHouse/pull/6362) ([Artem Zuikov](https://github.com/4ertus2))
-   添加了对别名扩展限制的测试以防万一. [#6442](https://github.com/ClickHouse/ClickHouse/pull/6442) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   在适当的地方从 `boost::filesystem` 切换到 `std::filesystem`. [#6253](https://github.com/ClickHouse/ClickHouse/pull/6253) [#6385](https://github.com/ClickHouse/ClickHouse/pull/6385) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   向网站添加了 RPM 包. [#6251](https://github.com/ClickHouse/ClickHouse/pull/6251) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   在 `IN` 部分添加修复 `Unknown identifier` 异常的测试. [#6708](https://github.com/ClickHouse/ClickHouse/pull/6708) ([Artem Zuikov](https://github.com/4ertus2))
-   简化`shared_ptr_helper`, 因为人们难以理解它. [#6675](https://github.com/ClickHouse/ClickHouse/pull/6675) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   添加了针对固定 Gorilla 和 DoubleDelta 编解码器的性能测试. [#6179](https://github.com/ClickHouse/ClickHouse/pull/6179) ([Vasily Nemkov](https://github.com/Enmk))
-   将集成测试 `test_dictionaries` 拆分为 4 个单独的测试. [#6776](https://github.com/ClickHouse/ClickHouse/pull/6776) ([Vitaly Baranov](https://github.com/vitlibar))
-   修复 `PipelineExecutor` 中的 PVS-Studio 警告. [#6777](https://github.com/ClickHouse/ClickHouse/pull/6777) ([Nikolai Kochetov](https://github.com/KochetovNicolai))
-   允许在 ASan 中使用 `library` 字典源. [#6482](https://github.com/ClickHouse/ClickHouse/pull/6482) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   添加了从 PR 列表生成变更日志的选项. [#6350](https://github.com/ClickHouse/ClickHouse/pull/6350) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   读取时锁定`TinyLog`存储. [#6226](https://github.com/ClickHouse/ClickHouse/pull/6226) ([akuzm](https://github.com/akuzm))
-   检查 CI 中损坏的符号链接. [#6634](https://github.com/ClickHouse/ClickHouse/pull/6634) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   增加 `stack overflow` 测试的超时时间，因为在调试构建中可能需要很长时间. [#6637](https://github.com/ClickHouse/ClickHouse/pull/6637) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   添加了对双空格的检查. [#6643](https://github.com/ClickHouse/ClickHouse/pull/6643) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   修复使用消毒剂构建时的 `new/delete` 内存跟踪. 跟踪不清楚. 它只防止测试中的内存限制异常. [#6450](https://github.com/ClickHouse/ClickHouse/pull/6450) ([Artem Zuikov](https://github.com/4ertus2))
-   在链接时启用对未定义符号的检查. [#6453](https://github.com/ClickHouse/ClickHouse/pull/6453) ([Ivan](https://github.com/abyss7))
-   避免每天重建 `hyperscan` . [#6307](https://github.com/ClickHouse/ClickHouse/pull/6307) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   修复了 `ProtobufWriter` 中的 UBSan 报告. [#6163](https://github.com/ClickHouse/ClickHouse/pull/6163) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   不允许将查询分析器与消毒剂一起使用, 因为它不兼容. [#6769](https://github.com/ClickHouse/ClickHouse/pull/6769) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   添加测试以在计时器失败后重新加载字典. [#6114](https://github.com/ClickHouse/ClickHouse/pull/6114) ([Vitaly Baranov](https://github.com/vitlibar))
-   修复 `PipelineExecutor::prepareProcessor` 参数类型的不一致. [#6494](https://github.com/ClickHouse/ClickHouse/pull/6494) ([Nikolai Kochetov](https://github.com/KochetovNicolai))
-   添加了对错误 URI 的测试. [#6493](https://github.com/ClickHouse/ClickHouse/pull/6493) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   向 `CAST` 函数添加了更多检查. 这应该在模糊测试中获得有关分段错误的更多信息. [#6346](https://github.com/ClickHouse/ClickHouse/pull/6346) ([Nikolai Kochetov](https://github.com/KochetovNicolai))
-   为在本地构建镜像的 `docker/builder` 容器添加了 `gcc-9` 支持. [#6333](https://github.com/ClickHouse/ClickHouse/pull/6333) ([Gleb Novikov](https://github.com/NanoBjorn))
-   使用 `Low Cardinality(String)` 测试主键. [#5044](https://github.com/ClickHouse/ClickHouse/issues/5044) [#6219](https://github.com/ClickHouse/ClickHouse/pull/6219) ([dimarub2000](https://github.com/dimarub2000))
-   修复了受缓慢堆栈跟踪打印影响的测试. [#6315](https://github.com/ClickHouse/ClickHouse/pull/6315) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   在 [#6029](https://github.com/ClickHouse/ClickHouse/pull/6029) 中修复的`groupUniqArray` 中添加崩溃测试用例. [#4402](https://github.com/ClickHouse/ClickHouse/issues/4402) [#6129](https://github.com/ClickHouse/ClickHouse/pull/6129) ([akuzm](https://github.com/akuzm))
-   修复指数变异测试. [#6645](https://github.com/ClickHouse/ClickHouse/pull/6645) ([Nikita Vasilev](https://github.com/nikvas0))
-   在性能测试中, 不要读取我们没有运行的查询的查询日志. [#6427](https://github.com/ClickHouse/ClickHouse/pull/6427) ([akuzm](https://github.com/akuzm))
-   现在可以使用任何低基数类型创建物化视图, 而不管有关可疑低基数类型的设置. [#6428](https://github.com/ClickHouse/ClickHouse/pull/6428) ([Olga Khvostikova](https://github.com/stavrolia))
-   更新了 `send_logs_level` 设置的测试. [#6207](https://github.com/ClickHouse/ClickHouse/pull/6207) ([Nikolai Kochetov](https://github.com/KochetovNicolai))
-   修复 gcc-8.2 下的构建. [#6196](https://github.com/ClickHouse/ClickHouse/pull/6196) ([Max Akhmedov](https://github.com/zlobober))
-   使用内部 libc++ 修复构建. [#6724](https://github.com/ClickHouse/ClickHouse/pull/6724) ([Ivan](https://github.com/abyss7))
-   使用 `rdkafka` 库修复共享构建. [#6101](https://github.com/ClickHouse/ClickHouse/pull/6101) ([Ivan](https://github.com/abyss7))
-   Mac OS 版本的修复 (不完整). [#6390](https://github.com/ClickHouse/ClickHouse/pull/6390) ([alexey-milovidov](https://github.com/alexey-milovidov)) [#6429](https://github.com/ClickHouse/ClickHouse/pull/6429) ([alex-zaitsev](https://github.com/alex-zaitsev))
-   修复 `splitted` 构建. [#6618](https://github.com/ClickHouse/ClickHouse/pull/6618) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   其他构建修复: [#6186](https://github.com/ClickHouse/ClickHouse/pull/6186) ([Amos Bird](https://github.com/amosbird)) [#6486](https://github.com/ClickHouse/ClickHouse/pull/6486) [#6348](https://github.com/ClickHouse/ClickHouse/pull/6348) ([vxider](https://github.com/Vxider)) [#6744](https://github.com/ClickHouse/ClickHouse/pull/6744) ([Ivan](https://github.com/abyss7)) [#6016](https://github.com/ClickHouse/ClickHouse/pull/6016) [#6421](https://github.com/ClickHouse/ClickHouse/pull/6421) [#6491](https://github.com/ClickHouse/ClickHouse/pull/6491) ([proller](https://github.com/proller))

#### 向后不兼容的更新 {#backward-incompatible-change-3}

-   删除了很少使用的表函数 `catBoostPool` 和存储 `CatBoostPool`. 如果您使用过此表格功能, 请写邮件至 `clickhouse-feedback@yandex-team.com`. 请注意, CatBoost 集成仍然存在并将得到支持. [#6279](https://github.com/ClickHouse/ClickHouse/pull/6279) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   默认情况下禁用 `ANY RIGHT JOIN` 和 `ANY FULL JOIN`. 设置 `any_join_distinct_right_table_keys` 设置以启用它们. [#5126](https://github.com/ClickHouse/ClickHouse/issues/5126) [#6351](https://github.com/ClickHouse/ClickHouse/pull/6351) ([Artem Zuikov](https://github.com/4ertus2))

## ClickHouse 版本 19.13 {#clickhouse-release-19-13}

### ClickHouse 版本 19.13.6.51, 2019-10-02 {#clickhouse-release-19-13-6-51-2019-10-02}

#### Bug 修复 {#bug-fix-9}

-   此版本还包含 19.11.12.69 的所有错误修复.

### ClickHouse 版本 19.13.5.44, 2019-09-20 {#clickhouse-release-19-13-5-44-2019-09-20}

#### Bug 修复 {#bug-fix-10}

-   此版本还包含 19.14.6.12 的所有错误修复.
-   修复了在 Zookeeper 不可访问时对复制表执行 `DROP` 查询时可能出现的表不一致状态. [#6045](https://github.com/ClickHouse/ClickHouse/issues/6045) [#6413](https://github.com/ClickHouse/ClickHouse/pull/6413) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov))
-   修复 StorageMerge 中的数据竞争. [#6717](https://github.com/ClickHouse/ClickHouse/pull/6717) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   修复查询分析器中引入的错误, 该错误导致来自套接字的无休止的接收. [#6386](https://github.com/ClickHouse/ClickHouse/pull/6386) ([alesapin](https://github.com/alesapin))
-   修复在布尔值上执行 `JSONExtractRaw` 函数时 CPU 使用率过高的问题. [#6208](https://github.com/ClickHouse/ClickHouse/pull/6208) ([Vitaly Baranov](https://github.com/vitlibar))
-   修复了推送到物化视图时的回归. [#6415](https://github.com/ClickHouse/ClickHouse/pull/6415) ([Ivan](https://github.com/abyss7))
-   表函数 `url` 存在允许攻击者在请求中注入任意 HTTP 头的漏洞. 此问题由 [Nikita Tikhomirov](https://github.com/NSTikhomirov) 发现. [#6466](https://github.com/ClickHouse/ClickHouse/pull/6466) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   修复 Set index 中无用的 `AST` 检查. [#6510](https://github.com/ClickHouse/ClickHouse/issues/6510) [#6651](https://github.com/ClickHouse/ClickHouse/pull/6651) ([Nikita Vasilev](https://github.com/nikvas0))
-   修复了对嵌入在查询中的 `AggregateFunction` 值的解析. [#6575](https://github.com/ClickHouse/ClickHouse/issues/6575) [#6773](https://github.com/ClickHouse/ClickHouse/pull/6773) ([Zhichang Yu](https://github.com/yuzhichang))
-   修复了`trim` 函数族的错误行为. [#6647](https://github.com/ClickHouse/ClickHouse/pull/6647) ([alexey-milovidov](https://github.com/alexey-milovidov))

### ClickHouse 版本 19.13.4.32, 2019-09-10 {#clickhouse-release-19-13-4-32-2019-09-10}

#### Bug 修复 {#bug-fix-11}

-   此版本还包含 19.11.9.52 和 19.11.10.54 的所有错误安全修复.
-   修复了 `system.parts` 表和 `ALTER` 查询中的数据争用. [#6245](https://github.com/ClickHouse/ClickHouse/issues/6245) [#6513](https://github.com/ClickHouse/ClickHouse/pull/6513) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   修复了在从带有样本和 prewhere 的空分布式表中读取时发生的流中不匹配的标头. [#6167](https://github.com/ClickHouse/ClickHouse/issues/6167) ([Lixiang Qian](https://github.com/fancyqlx)) [#6823](https://github.com/ClickHouse/ClickHouse/pull/6823) ([Nikolai Kochetov](https://github.com/KochetovNicolai))
-   修复了在带有元组的子查询中使用 `IN` 子句时崩溃的问题. [#6125](https://github.com/ClickHouse/ClickHouse/issues/6125) [#6550](https://github.com/ClickHouse/ClickHouse/pull/6550) ([tavplubix](https://github.com/tavplubix))
-   修复 `GLOBAL JOIN ON` 部分中列名相同的情况. [#6181](https://github.com/ClickHouse/ClickHouse/pull/6181) ([Artem Zuikov](https://github.com/4ertus2))
-   修复将类型转换为不支持它的 `Decimal` 时的崩溃。 改为抛出异常. [#6297](https://github.com/ClickHouse/ClickHouse/pull/6297) ([Artem Zuikov](https://github.com/4ertus2))
-   修复了 `extractAll()` 函数中的崩溃问题. [#6644](https://github.com/ClickHouse/ClickHouse/pull/6644) ([Artem Zuikov](https://github.com/4ertus2))
-   `MySQL`、`ODBC`、`JDBC` 表函数的查询转换现在可以正常用于带有多个 `AND` 表达式的 `SELECT WHERE` 查询. [#6381](https://github.com/ClickHouse/ClickHouse/issues/6381) [#6676](https://github.com/ClickHouse/ClickHouse/pull/6676) ([dimarub2000](https://github.com/dimarub2000))
-   为 MySQL 8 集成添加了先前的声明检查. [#6569](https://github.com/ClickHouse/ClickHouse/pull/6569) ([Rafael David Tinoco](https://github.com/rafaeldtinoco))

#### 安全修复 {#security-fix-1}

-   修复解压阶段编解码器的两个漏洞 (恶意用户可以编造压缩数据导致解压缓冲区溢出). [#6670](https://github.com/ClickHouse/ClickHouse/pull/6670) ([Artem Zuikov](https://github.com/4ertus2))

### ClickHouse 版本 19.13.3.26, 2019-08-22 {#clickhouse-release-19-13-3-26-2019-08-22}

#### Bug 修复 {#bug-fix-12}

-   修复带有 `enable_mixed_granularity_parts=1` 的表的 `ALTER TABLE ... UPDATE` 查询. [#6543](https://github.com/ClickHouse/ClickHouse/pull/6543) ([alesapin](https://github.com/alesapin))
-   用带有元组的子查询的 IN 子句时修复 NPE. [#6125](https://github.com/ClickHouse/ClickHouse/issues/6125) [#6550](https://github.com/ClickHouse/ClickHouse/pull/6550) ([tavplubix](https://github.com/tavplubix))
-   修复了一个问题, 如果一个陈旧的副本变得活跃, 它可能仍然有被 DROP PARTITION 删除的数据部分. [#6522](https://github.com/ClickHouse/ClickHouse/issues/6522) [#6523](https://github.com/ClickHouse/ClickHouse/pull/6523) ([tavplubix](https://github.com/tavplubix))
-   解决了解析 CSV 的问题. [#6426](https://github.com/ClickHouse/ClickHouse/issues/6426) [#6559](https://github.com/ClickHouse/ClickHouse/pull/6559) ([tavplubix](https://github.com/tavplubix))
-   修复了 system.parts 表和 ALTER 查询中的数据竞争. 这修复了 [#6245](https://github.com/ClickHouse/ClickHouse/issues/6245). [#6513](https://github.com/ClickHouse/ClickHouse/pull/6513) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   修复了可能导致内存损坏的突变中的错误代码. 修复了由于从 `system.parts` 或 `system.parts_columns` 并发 `DROP TABLE` 和 `SELECT` 而可能发生的读取地址 `0x14c0` 的段错误. 修复了准备突变查询时的竞争条件. 修复复制表的 `OPTIMIZE` 和 ALTER 等并发修改操作导致的死锁. [#6514](https://github.com/ClickHouse/ClickHouse/pull/6514) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   修复了在跳过索引的表上进行`ALTER DELETE`查询后可能丢失的数据. [#6224](https://github.com/ClickHouse/ClickHouse/issues/6224) [#6282](https://github.com/ClickHouse/ClickHouse/pull/6282) ([Nikita Vasilev](https://github.com/nikvas0))

#### 安全修复 {#security-fix-2}

-   如果攻击者拥有对 ZooKeeper 的写访问权限, 并且能够从运行 ClickHouse 的网络中运行可用的自定义服务器, 则它可以创建自定义构建的恶意服务器, 该服务器将充当 ClickHouse 副本并将其注册到 ZooKeeper 中. 当另一个副本从恶意副本中获取数据部分时, 它可以强制 clickhouse-server 写入文件系统上的任意路径. 由 Yandex 信息安全团队 Eldar Zaitov 发现. [#6247](https://github.com/ClickHouse/ClickHouse/pull/6247) ([alexey-milovidov](https://github.com/alexey-milovidov))

### ClickHouse 版本 19.13.2.19, 2019-08-14 {#clickhouse-release-19-13-2-19-2019-08-14}

#### 新特征 {#new-feature-5}

-   查询级别的采样分析器. [Example](https://gist.github.com/alexey-milovidov/92758583dd41c24c360fdb8d6a4da194). [#4247](https://github.com/ClickHouse/ClickHouse/issues/4247) ([laplab](https://github.com/laplab)) [#6124](https://github.com/ClickHouse/ClickHouse/pull/6124) ([alexey-milovidov](https://github.com/alexey-milovidov)) [#6250](https://github.com/ClickHouse/ClickHouse/pull/6250) [#6283](https://github.com/ClickHouse/ClickHouse/pull/6283) [#6386](https://github.com/ClickHouse/ClickHouse/pull/6386)
-   允许使用 `COLUMNS('regexp')` 表达式指定一个列列表, 它的工作方式类似于更复杂的 `*` 星号变体. [#5951](https://github.com/ClickHouse/ClickHouse/pull/5951) ([mfridental](https://github.com/mfridental)), ([alexey-milovidov](https://github.com/alexey-milovidov))
-   `CREATE TABLE AS table_function()` 现在可以了. [#6057](https://github.com/ClickHouse/ClickHouse/pull/6057) ([dimarub2000](https://github.com/dimarub2000))
-   于随机梯度下降的 Adam 优化器默认用于 `stochasticLinearRegression()` 和 `stochasticLogisticRegression()` 聚合函数, 因为它在几乎没有任何调整的情况下显示出良好的质量. [#6000](https://github.com/ClickHouse/ClickHouse/pull/6000) ([Quid37](https://github.com/Quid37))
-   添加了使用自定义周数的功能. [#5212](https://github.com/ClickHouse/ClickHouse/pull/5212) ([Andy Yang](https://github.com/andyyzh))
-   RENAME` 查询现在适用于所有存储. [#5953](https://github.com/ClickHouse/ClickHouse/pull/5953) ([Ivan](https://github.com/abyss7))
-   现在, 无论服务器设置中指定的日志级别如何, 客户端都可以通过设置 `send_logs_level` 从服务器接收任何所需级别的日志. [#5964](https://github.com/ClickHouse/ClickHouse/pull/5964) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov))

#### 向后不兼容的更新 {#backward-incompatible-change-4}

-   默认情况下启用设置 `input_format_defaults_for_omited_fields`。 分布式表中的插入需要此设置在集群上相同 (您需要在滚动更新之前设置它). 它可以为 `JSONEachRow` 和 `CSV*` 格式的省略字段计算复杂的默认表达式. 它应该是预期的行为, 但可能导致可以忽略不计的性能差异. [#6043](https://github.com/ClickHouse/ClickHouse/pull/6043) ([Artem Zuikov](https://github.com/4ertus2)), [#5625](https://github.com/ClickHouse/ClickHouse/pull/5625) ([akuzm](https://github.com/akuzm))

#### 实验功能 {#experimental-features}

-   新的查询处理管道. 使用 `experimental_use_processors=1` 选项来启用它. 用于自己的麻烦. [#4914](https://github.com/ClickHouse/ClickHouse/pull/4914) ([Nikolai Kochetov](https://github.com/KochetovNicolai))

#### Bug 修复 {#bug-fix-13}

-   Kafka 集成已在此版本中修复.
-   修复了大 `DoubleDelta` 值的 `Int64` 的 `DoubleDelta` 编码, 改进了 `Int32` 随机数据的 `DoubleDelta` 编码. [#5998](https://github.com/ClickHouse/ClickHouse/pull/5998) ([Vasily Nemkov](https://github.com/Enmk))
-   如果设置 `merge_tree_uniform_read_distribution` 设置为 0, 则修复了对 `max_rows_to_read` 的高估. [#6019](https://github.com/ClickHouse/ClickHouse/pull/6019) ([alexey-milovidov](https://github.com/alexey-milovidov))

#### 改进 {#improvement-4}

-   如果 `config.d` 文件没有对应的根元素作为配置文件, 则抛出异常. [#6123](https://github.com/ClickHouse/ClickHouse/pull/6123) ([dimarub2000](https://github.com/dimarub2000))

#### 性能改进 {#performance-improvement-3}

-   优化 `count()`. 现在它使用最小的列 (如果可能). [#6028](https://github.com/ClickHouse/ClickHouse/pull/6028) ([Amos Bird](https://github.com/amosbird))

#### 构建/测试/打包改进 {#buildtestingpackaging-improvement-5}

-   报告性能测试中的内存使用情况. [#5899](https://github.com/ClickHouse/ClickHouse/pull/5899) ([akuzm](https://github.com/akuzm))
-   使用外部 `libcxx` 修复构建. [#6010](https://github.com/ClickHouse/ClickHouse/pull/6010) ([Ivan](https://github.com/abyss7))
-   使用 `rdkafka` 库修复共享构建. [#6101](https://github.com/ClickHouse/ClickHouse/pull/6101) ([Ivan](https://github.com/abyss7))

## ClickHouse 版本 19.11 {#clickhouse-release-19-11}

### ClickHouse 版本 19.11.13.74, 2019-11-01 {#clickhouse-release-19-11-13-74-2019-11-01}

#### Bug 修复 {#bug-fix-14}

-   修复了 `ALTER MODIFY COLUMN` 和垂直合并中的罕见崩溃，当合并/更改的部分之一为空时 (0 行). [#6780](https://github.com/ClickHouse/ClickHouse/pull/6780) ([alesapin](https://github.com/alesapin))
-   手动更新`SIMDJSON`. 这修复了使用虚假 json 诊断消息可能导致 stderr 文件泛滥的问题. [#7548](https://github.com/ClickHouse/ClickHouse/pull/7548) ([Alexander Kazakov](https://github.com/Akazz))
-   修复了用于突变的 `mrk` 文件扩展名的错误. ([alesapin](https://github.com/alesapin))

### ClickHouse 版本 19.11.12.69, 2019-10-02 {#clickhouse-release-19-11-12-69-2019-10-02}

#### Bug 修复 {#bug-fix-15}

-   修复了大型表上复杂键的索引分析性能下降. 这修复了 [#6924](https://github.com/ClickHouse/ClickHouse/issues/6924). [#7075](https://github.com/ClickHouse/ClickHouse/pull/7075) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   使用分布式引擎在表中发送数据时避免罕见的 SIGSEGV (`Failed to send batch: file with index XXXXX is absent`). [#7032](https://github.com/ClickHouse/ClickHouse/pull/7032) ([Azat Khuzhin](https://github.com/azat))
-   使用多个连接修复 `Unknown identifier` . 这修复了 [#5254](https://github.com/ClickHouse/ClickHouse/issues/5254). [#7022](https://github.com/ClickHouse/ClickHouse/pull/7022) ([Artem Zuikov](https://github.com/4ertus2))

### ClickHouse 版本 19.11.11.57, 2019-09-13 {#clickhouse-release-19-11-11-57-2019-09-13}

-   修复从 Kafka 空主题中选择时导致段错误的逻辑错误. [#6902](https://github.com/ClickHouse/ClickHouse/issues/6902) [#6909](https://github.com/ClickHouse/ClickHouse/pull/6909) ([Ivan](https://github.com/abyss7))
-   修复函数 `АrrayEnumerateUniqRanked` 在参数中带有空数组. [#6928](https://github.com/ClickHouse/ClickHouse/pull/6928) ([proller](https://github.com/proller))

### ClickHouse 版本 19.11.10.54, 2019-09-10 {#clickhouse-release-19-11-10-54-2019-09-10}

#### Bug 修复 {#bug-fix-16}

-   手动为 Kafka 消息存储偏移量，以便能够一次为所有分区提交所有偏移量。 修复了 `one consumer - many partitions` 场景中的潜在重复. [#6872](https://github.com/ClickHouse/ClickHouse/pull/6872) ([Ivan](https://github.com/abyss7))

### ClickHouse 版本 19.11.9.52, 2019-09-6 {#clickhouse-release-19-11-9-52-2019-09-6}

-   改进缓存字典中的错误处理. [#6737](https://github.com/ClickHouse/ClickHouse/pull/6737) ([Vitaly Baranov](https://github.com/vitlibar))
-   修复了函数 `arrayEnumerateUniqRanked` 中的错误. [#6779](https://github.com/ClickHouse/ClickHouse/pull/6779) ([proller](https://github.com/proller))
-   在从 JSON 中提取 `Tuple` 时修复 `JSONExtract` 函数. [#6718](https://github.com/ClickHouse/ClickHouse/pull/6718) ([Vitaly Baranov](https://github.com/vitlibar))
-   修复了在跳过索引的表上进行`ALTER DELETE`查询后可能丢失的数据. [#6224](https://github.com/ClickHouse/ClickHouse/issues/6224) [#6282](https://github.com/ClickHouse/ClickHouse/pull/6282) ([Nikita Vasilev](https://github.com/nikvas0))
-   修复了性能测试. [#6392](https://github.com/ClickHouse/ClickHouse/pull/6392) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   Parquet: 修复读取布尔列. [#6579](https://github.com/ClickHouse/ClickHouse/pull/6579) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   修复了常量参数的 `nullIf` 函数的错误行为. [#6518](https://github.com/ClickHouse/ClickHouse/pull/6518) ([Guillaume Tassery](https://github.com/YiuRULE)) [#6580](https://github.com/ClickHouse/ClickHouse/pull/6580) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   修复正常服务器重启时Kafka消息重复问题. [#6597](https://github.com/ClickHouse/ClickHouse/pull/6597) ([Ivan](https://github.com/abyss7))
-   修复了长时间 `ALTER UPDATE` 或 `ALTER DELETE` 可能会阻止常规合并运行的问题. 如果没有足够的可用线程, 则防止执行突变. [#6502](https://github.com/ClickHouse/ClickHouse/issues/6502) [#6617](https://github.com/ClickHouse/ClickHouse/pull/6617) ([tavplubix](https://github.com/tavplubix))
-   修复了在服务器配置文件中处理 `timezone` 的错误. [#6709](https://github.com/ClickHouse/ClickHouse/pull/6709) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   修复 kafka 测试. [#6805](https://github.com/ClickHouse/ClickHouse/pull/6805) ([Ivan](https://github.com/abyss7))

#### 安全修复 {#security-fix-3}

-   果攻击者拥有对 ZooKeeper 的写访问权限, 并且能够从运行 ClickHouse 的网络中运行可用的自定义服务器, 则它可以创建自定义构建的恶意服务器, 该服务器将充当 ClickHouse 副本并将其注册到 ZooKeeper 中. 当另一个副本从恶意副本中获取数据部分时, 它可以强制 clickhouse-server 写入文件系统上的任意路径. 由 Yandex 信息安全团队 Eldar Zaitov 发现. [#6247](https://github.com/ClickHouse/ClickHouse/pull/6247) ([alexey-milovidov](https://github.com/alexey-milovidov))

### ClickHouse 版本 19.11.8.46, 2019-08-22 {#clickhouse-release-19-11-8-46-2019-08-22}

#### Bug 修复 {#bug-fix-17}

-   修复带有 `enable_mixed_granularity_parts=1` 的表的 `ALTER TABLE ... UPDATE` 查询. [#6543](https://github.com/ClickHouse/ClickHouse/pull/6543) ([alesapin](https://github.com/alesapin))
-   用带有元组的子查询的 IN 子句时修复 NPE. [#6125](https://github.com/ClickHouse/ClickHouse/issues/6125) [#6550](https://github.com/ClickHouse/ClickHouse/pull/6550) ([tavplubix](https://github.com/tavplubix))
-   修复了一个问题, 如果一个陈旧的副本变得活跃, 它可能仍然有被 DROP PARTITION 删除的数据部分. [#6522](https://github.com/ClickHouse/ClickHouse/issues/6522) [#6523](https://github.com/ClickHouse/ClickHouse/pull/6523) ([tavplubix](https://github.com/tavplubix))
-   修复了解析 CSV 的问题 [#6426](https://github.com/ClickHouse/ClickHouse/issues/6426) [#6559](https://github.com/ClickHouse/ClickHouse/pull/6559) ([tavplubix](https://github.com/tavplubix))
-   修复了 system.parts 表和 ALTER 查询中的数据竞争. 这修复了 [#6245](https://github.com/ClickHouse/ClickHouse/issues/6245). [#6513](https://github.com/ClickHouse/ClickHouse/pull/6513) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   修复了可能导致内存损坏的突变中的错误代码. 修复了由于从 `system.parts` 或 `system.parts_columns` 并发 `DROP TABLE` 和 `SELECT` 而可能发生的读取地址 `0x14c0` 的段错误. 修复了准备突变查询时的竞争条件. 修复复制表的 `OPTIMIZE` 和 ALTER 等并发修改操作导致的死锁. [#6514](https://github.com/ClickHouse/ClickHouse/pull/6514) ([alexey-milovidov](https://github.com/alexey-milovidov))

### ClickHouse 版本 19.11.7.40, 2019-08-14 {#clickhouse-release-19-11-7-40-2019-08-14}

#### Bug 修复 {#bug-fix-18}

-   Kafka 集成已在此版本中修复.
-   修复了当使用 `arrayReduce` 作为常量参数时的段错误. [#6326](https://github.com/ClickHouse/ClickHouse/pull/6326) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   修复了 `toFloat()` 单调性. [#6374](https://github.com/ClickHouse/ClickHouse/pull/6374) ([dimarub2000](https://github.com/dimarub2000))
-   修复了启用的 `optimize_skip_unused_shards` 和丢失的分片键修复段错误. [#6384](https://github.com/ClickHouse/ClickHouse/pull/6384) ([CurtizJ](https://github.com/CurtizJ))
-   修复了`arrayEnumerateUniqRanked` 函数的逻辑. [#6423](https://github.com/ClickHouse/ClickHouse/pull/6423) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   从 MySQL 处理程序中删除了额外的详细日志记录. [#6389](https://github.com/ClickHouse/ClickHouse/pull/6389) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   修复 `topK` 和 `topK Weighted` 聚合函数中的错误行为和可能的段错误. [#6404](https://github.com/ClickHouse/ClickHouse/pull/6404) ([CurtizJ](https://github.com/CurtizJ))
-   不要在 `system.columns` 表中暴露虚拟列. 这是向后兼容所必需的. [#6406](https://github.com/ClickHouse/ClickHouse/pull/6406) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   修复复杂键缓存字典中字符串字段的内存分配错误. [#6447](https://github.com/ClickHouse/ClickHouse/pull/6447) ([alesapin](https://github.com/alesapin))
-   修复在为 `Replicated*MergeTree` 表创建新副本时启用自适应粒度的错误. [#6452](https://github.com/ClickHouse/ClickHouse/pull/6452) ([alesapin](https://github.com/alesapin))
-   修复读取 Kafka 消息时的无限循环. [#6354](https://github.com/ClickHouse/ClickHouse/pull/6354) ([abyss7](https://github.com/abyss7))
-   修复了由于 SQL 解析器中的堆栈溢出以及 `Merge` 和 `Distributed` 表中的堆栈溢出的可能性, 伪造查询导致服务器崩溃的可能性 [#6433](https://github.com/ClickHouse/ClickHouse/pull/6433) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   修复了小序列上的 Gorilla 编码错误. [#6444](https://github.com/ClickHouse/ClickHouse/pull/6444) ([Enmk](https://github.com/Enmk))

#### 改进 {#improvement-5}

-   允许用户在连接时覆盖 `poll_interval` 和 `idle_connection_timeout` 设置. [#6230](https://github.com/ClickHouse/ClickHouse/pull/6230) ([alexey-milovidov](https://github.com/alexey-milovidov))

### ClickHouse 版本 19.11.5.28, 2019-08-05 {#clickhouse-release-19-11-5-28-2019-08-05}

#### Bug 修复 {#bug-fix-19}

-   修复了服务器过载时挂起查询的可能性. [#6301](https://github.com/ClickHouse/ClickHouse/pull/6301) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   修复 yandexConsistentHash 函数中的 FPE. 这修复了 [#6304](https://github.com/ClickHouse/ClickHouse/issues/6304). [#6126](https://github.com/ClickHouse/ClickHouse/pull/6126) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   修复了在 `AggregateFunctionFactory` 中转换 `LowCardinality` 类型的错误. 这修复了 [#6257](https://github.com/ClickHouse/ClickHouse/issues/6257). [#6281](https://github.com/ClickHouse/ClickHouse/pull/6281) ([Nikolai Kochetov](https://github.com/KochetovNicolai))
-   修复从配置文件中的 `true` 和 `false` 字符串解析 `bool` 设置. [#6278](https://github.com/ClickHouse/ClickHouse/pull/6278) ([alesapin](https://github.com/alesapin))
-   当 `WHERE` 的一部分移动到 `PREWHERE` 时, 修复了在对 `MergeTree` 表上的 `Distributed` 表的查询中流标头不兼容的罕见错误. [#6236](https://github.com/ClickHouse/ClickHouse/pull/6236) ([alesapin](https://github.com/alesapin))
-   修复了有符号类型到无符号类型的整数除法中的溢出. 这修复了 [#6214](https://github.com/ClickHouse/ClickHouse/issues/6214). [#6233](https://github.com/ClickHouse/ClickHouse/pull/6233) ([alexey-milovidov](https://github.com/alexey-milovidov))

#### 向后不兼容的更新 {#backward-incompatible-change-5}

-   `Kafka` 仍然损坏.

### ClickHouse 版本 19.11.4.24, 2019-08-01 {#clickhouse-release-19-11-4-24-2019-08-01}

#### Bug 修复 {#bug-fix-20}

-   修复以自适应粒度写入二级索引标记的错误. [#6126](https://github.com/ClickHouse/ClickHouse/pull/6126) ([alesapin](https://github.com/alesapin))
-   修复了带有两级聚合的 `GROUP BY` 的 `WITH ROLLUP` 和 `WITH CUBE` 修饰符. [#6225](https://github.com/ClickHouse/ClickHouse/pull/6225) ([Anton Popov](https://github.com/CurtizJ))
-   修复了 `JSONExtractRaw` 函数中的挂起问题. 已修复 [#6195](https://github.com/ClickHouse/ClickHouse/issues/6195) [#6198](https://github.com/ClickHouse/ClickHouse/pull/6198) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   修复 ExternalLoader::reloadOutdated() 中的段错误. [#6082](https://github.com/ClickHouse/ClickHouse/pull/6082) ([Vitaly Baranov](https://github.com/vitlibar))
-   修复了服务器可能会关闭侦听套接字但不会关闭并继续服务剩余查询的情况. 您最终可能会运行两个 clickhouse-server 进程. 有时, 服务器可能会为剩余的查询返回错误 `bad_function_call`. [#6231](https://github.com/ClickHouse/ClickHouse/pull/6231) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   修复了通过 ODBC、MySQL、ClickHouse 和 HTTP 初始加载外部词典时更新字段上无用和不正确的条件. 这修复了 [#6069](https://github.com/ClickHouse/ClickHouse/issues/6069) [#6083](https://github.com/ClickHouse/ClickHouse/pull/6083) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   修复了将 `LowCardinality(Nullable)` 转换为 not-Nullable 列中的不相关异常，以防它不包含 Nulls（例如, 像在 `SELECT CAST(CAST('Hello' AS LowCardinality(Nullable(String))) AS String` 这样的查询中). [#6094](https://github.com/ClickHouse/ClickHouse/issues/6094) [#6119](https://github.com/ClickHouse/ClickHouse/pull/6119) ([Nikolai Kochetov](https://github.com/KochetovNicolai))
-   在极少数情况下修复 `uniq` 聚合函数的非确定性结果. 该错误存在于所有 ClickHouse 版本中. [#6058](https://github.com/ClickHouse/ClickHouse/pull/6058) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   当我们在函数 `IPv6CIDRToRange` 上设置太高的 CIDR 时出现段错误. [#6068](https://github.com/ClickHouse/ClickHouse/pull/6068) ([Guillaume Tassery](https://github.com/YiuRULE))
-   修复了服务器从许多不同的上下文中抛出许多异常时的小内存泄漏. [#6144](https://github.com/ClickHouse/ClickHouse/pull/6144) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   修复消费者订阅前暂停, 订阅后未恢复的情况. [#6075](https://github.com/ClickHouse/ClickHouse/pull/6075) ([Ivan](https://github.com/abyss7)) Note that Kafka is broken in this version.
-   清除之前已完成但出现错误的读取操作中的 Kafka 数据缓冲区 [#6026](https://github.com/ClickHouse/ClickHouse/pull/6026) ([Nikolay](https://github.com/ bopohaa)) 请注意, 此版本中 Kafka 已损坏.
-   由于 `StorageMergeTree::background_task_handle` 是在`startup()` 中初始化的, 所以 `MergeTreeBlockOutputStream::write()` 可能会在初始化之前尝试使用它. 只需检查它是否已初始化. [#6080](https://github.com/ClickHouse/ClickHouse/pull/6080) ([Ivan](https://github.com/abyss7))

#### 构建/测试/打包改进 {#buildtestingpackaging-improvement-6}

-   添加官方`rpm`包. [#5740](https://github.com/ClickHouse/ClickHouse/pull/5740) ([proller](https://github.com/proller)) ([alesapin](https://github.com/alesapin))
-   添加使用`packager`脚本构建`.rpm`和`.tgz`包的能力. [#5769](https://github.com/ClickHouse/ClickHouse/pull/5769) ([alesapin](https://github.com/alesapin))
-   修复“Arcadia”构建系统. [#6223](https://github.com/ClickHouse/ClickHouse/pull/6223) ([proller](https://github.com/proller))

#### 向后不兼容的更新 {#backward-incompatible-change-6}

-   `Kafka` 在这个版本中仍然被损坏.

### ClickHouse 版本 19.11.3.11, 2019-07-18 {#clickhouse-release-19-11-3-11-2019-07-18}

#### 新特征 {#new-feature-6}

-   添加了对准备好的语句的支持. [#5331](https://github.com/ClickHouse/ClickHouse/pull/5331/) ([Alexander](https://github.com/sanych73)) [#5630](https://github.com/ClickHouse/ClickHouse/pull/5630) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   `DoubleDelta` 和 `Gorilla` 列编解码器. [#5600](https://github.com/ClickHouse/ClickHouse/pull/5600) ([Vasily Nemkov](https://github.com/Enmk))
-   添加了 `os_thread_priority` 设置, 允许控制操作系统使用的查询处理线程的 `nice` 值来调整动态调度优先级. 它需要 `CAP_SYS_NICE` 功能才能工作. 这实现 [#5858](https://github.com/ClickHouse/ClickHouse/issues/5858) [#5909](https://github.com/ClickHouse/ClickHouse/pull/5909) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   为 Kafka 引擎实现 `_topic`、`_offset`、`_key` 列 [#5382](https://github.com/ClickHouse/ClickHouse/pull/5382) ([Ivan](https://github.com/ abyss7)) 请注意, 这个版本中 Kafka 已损坏.
-   添加聚合函数组合器 `-Resample`. [#5590](https://github.com/ClickHouse/ClickHouse/pull/5590) ([hcz](https://github.com/hczhcz))
-   聚合函数`groupArrayMovingSum(win_size)(x)` 和`groupArrayMovingAvg(win_size)(x)`, 计算有或没有窗口大小限制的移动总和/平均. [#5595](https://github.com/ClickHouse/ClickHouse/pull/5595) ([inv2004](https://github.com/inv2004))
-   添加同义词 `arrayFlatten` \<-\> `flatten`. [#5764](https://github.com/ClickHouse/ClickHouse/pull/5764) ([hcz](https://github.com/hczhcz))
-   将优步的H3功能 `geoToH3` 集成在一起. [#4724](https://github.com/ClickHouse/ClickHouse/pull/4724) ([Remen Ivan](https://github.com/BHYCHIK)) [#5805](https://github.com/ClickHouse/ClickHouse/pull/5805) ([alexey-milovidov](https://github.com/alexey-milovidov))

#### Bug 修复 {#bug-fix-21}

-   使用异步更新实现 DNS 缓存. 单独的线程解析所有主机并使用周期更新 DNS 缓存 (设置 `dns_cache_update_period`). 当主机的 ip 频繁更改时. 它应该会有所帮助. [#5857](https://github.com/ClickHouse/ClickHouse/pull/5857) ([Anton Popov](https://github.com/CurtizJ))
-   修复 `Delta` 编解码器中的段错误, 该错误会影响值小于 32 位大小的列. 该错误导致随机内存损坏. [#5786](https://github.com/ClickHouse/ClickHouse/pull/5786) ([alesapin](https://github.com/alesapin))
-   修复 TTL 合并中的段错误与块中的非物理列. [#5819](https://github.com/ClickHouse/ClickHouse/pull/5819) ([Anton Popov](https://github.com/CurtizJ))
-   修复了检查带有 `LowCardinality` 列的部分的罕见错误. 以前, `checkDataPart` 对于带有 `LowCardinality` 列的部分总是失败. [#5832](https://github.com/ClickHouse/ClickHouse/pull/5832) ([alesapin](https://github.com/alesapin))
-   避免在服务器线程池已满时挂起连接. 当连接超时很长时, 对于从 `remote` 表函数的连接或到没有副本的分片的连接很重要. 这修复了 [#5878](https://github.com/ClickHouse/ClickHouse/issues/5878) [#5881](https://github.com/ClickHouse/ClickHouse/pull/5881) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   支持 `evalMLModel` 函数的常量参数. 这修复了 [#5817](https://github.com/ClickHouse/ClickHouse/issues/5817) [#5820](https://github.com/ClickHouse/ClickHouse/pull/5820) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   修复了 ClickHouse 将默认时区确定为 `UCT` 而不是 `UTC` 时的问题. 这修复了 [#5804](https://github.com/ClickHouse/ClickHouse/issues/5804). [#5828](https://github.com/ClickHouse/ClickHouse/pull/5828) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   修复了 `visitParamExtractRaw` 中的缓冲区下溢. 这修复了 [#5901](https://github.com/ClickHouse/ClickHouse/issues/5901) [#5902](https://github.com/ClickHouse/ClickHouse/pull/5902) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   现在分布式的`DROP/ALTER/TRUNCATE/OPTIMIZE ON CLUSTER`查询将直接在leader副本上执行. [#5757](https://github.com/ClickHouse/ClickHouse/pull/5757) ([alesapin](https://github.com/alesapin))
-   使用 `ColumnNullable` + 相关更改修复 `ColumnConst` 的 `coalesce`. [#5755](https://github.com/ClickHouse/ClickHouse/pull/5755) ([Artem Zuikov](https://github.com/4ertus2))
-   修复 `ReadBufferFromKafkaConsumer` 以便它在 `commit()` 之后继续读取新消息，即使它之前被停止. [#5852](https://github.com/ClickHouse/ClickHouse/pull/5852) ([Ivan](https://github.com/abyss7))
-   在右表中的 `Nullable` 键上连接时修复 `FULL` 和 `RIGHT` 连接结果. [#5859](https://github.com/ClickHouse/ClickHouse/pull/5859) ([Artem Zuikov](https://github.com/4ertus2))
-   低优先级查询无限休眠的可能修复. [#5842](https://github.com/ClickHouse/ClickHouse/pull/5842) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   修复竞争条件, 导致某些查询在 `SYSTEM FLUSH LOGS` 查询后可能不会出现在 query_log 中. [#5456](https://github.com/ClickHouse/ClickHouse/issues/5456) [#5685](https://github.com/ClickHouse/ClickHouse/pull/5685) ([Anton Popov](https://github.com/CurtizJ))
-   修复了 ClusterCopier 中的 `heap-use-after-free` ASan 警告，由 watch 导致尝试使用已删除的复制器对象. [#5871](https://github.com/ClickHouse/ClickHouse/pull/5871) ([Nikolai Kochetov](https://github.com/KochetovNicolai))
-   修复了由 `IColumn::deserializeAndInsertFromArena` 的某些实现返回的错误 `StringRef` 指针. 此错误仅影响单元测试. [#5973](https://github.com/ClickHouse/ClickHouse/pull/5973) ([Nikolai Kochetov](https://github.com/KochetovNicolai))
-   防止屏蔽同名列的源和中间数组连接列. [#5941](https://github.com/ClickHouse/ClickHouse/pull/5941) ([Artem Zuikov](https://github.com/4ertus2))
-   使用 MySQL 样式标识符引用修复对 MySQL 引擎的插入和选择查询. [#5704](https://github.com/ClickHouse/ClickHouse/pull/5704) ([Winter Zhang](https://github.com/zhang2014))
-   现在 `CHECK TABLE` 查询可以与 MergeTree 引擎系列一起使用. 如果每个部分 (或在更简单的引擎情况下的文件) 有任何检查状态和消息, 它会返回检查状态和消息. 此外, 修复了获取损坏部分的错误. [#5865](https://github.com/ClickHouse/ClickHouse/pull/5865) ([alesapin](https://github.com/alesapin))
-   修复 SPLIT_SHARED_LIBRARIES 运行时. [#5793](https://github.com/ClickHouse/ClickHouse/pull/5793) ([Danila Kutenin](https://github.com/danlark1))
-   当 `/etc/localtime` 是一个像 `../usr/share/zoneinfo/Europe/Moscow` 这样的相对符号链接时, 修复了时区初始化 [#5922](https://github.com/ClickHouse/ClickHouse/pull/5922) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   clickhouse-copier: 修复关机后免费使用. [#5752](https://github.com/ClickHouse/ClickHouse/pull/5752) ([proller](https://github.com/proller))
-   更新了 `simdjson` . 修复部分无效的零字节JSON解析成功的问题. [#5938](https://github.com/ClickHouse/ClickHouse/pull/5938) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   修复关闭系统日志 [#5802](https://github.com/ClickHouse/ClickHouse/pull/5802) ([Anton Popov](https://github.com/CurtizJ))
-   修复 invalidate_query 中的条件依赖于字典时挂起. [#6011](https://github.com/ClickHouse/ClickHouse/pull/6011) ([Vitaly Baranov](https://github.com/vitlibar))

#### 改进 {#improvement-6}

-   在集群配置中允许无法解析的地址. 它们将被视为不可用并在每次连接尝试时尝试解决. 这对 Kubernetes 尤其有用. 这修复了 [#5714](https://github.com/ClickHouse/ClickHouse/issues/5714) [#5924](https://github.com/ClickHouse/ClickHouse/pull/5924) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   关闭空闲的 TCP 连接 (默认超时一小时). 这对于在每台服务器上有多个分布式表的大型集群尤其重要, 因为每台服务器都可能保持与其他所有服务器的连接池, 并且在查询并发峰值之后, 连接将停止. 这修复了 [#5879](https://github.com/ClickHouse/ClickHouse/issues/5879) [#5880](https://github.com/ClickHouse/ClickHouse/pull/5880) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   `topK` 函数的质量更好. 如果新元素具有更大的权重, 则更改 SavingSpace 设置行为以删除最后一个元素. [#5833](https://github.com/ClickHouse/ClickHouse/issues/5833) [#5850](https://github.com/ClickHouse/ClickHouse/pull/5850) ([Guillaume Tassery](https://github.com/YiuRULE))
-   用于域的 URL 函数现在可以用于没有方案的不完整 URL. [#5725](https://github.com/ClickHouse/ClickHouse/pull/5725) ([alesapin](https://github.com/alesapin))
-   将校验和添加到 `system.parts_columns` 表. [#5874](https://github.com/ClickHouse/ClickHouse/pull/5874) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov))
-   添加了 `Enum` 数据类型作为 `Enum` 或 `Enum 16` 的同义词. [#5886](https://github.com/ClickHouse/ClickHouse/pull/5886) ([dimarub2000](https://github.com/dimarub2000))
-   `T64` 编解码器的全位转置变体. 可以使用 `zstd` 实现更好的压缩. [#5742](https://github.com/ClickHouse/ClickHouse/pull/5742) ([Artem Zuikov](https://github.com/4ertus2))
-   `startsWith` 函数的条件现在可以使用主键. 这修复了 [#5310](https://github.com/ClickHouse/ClickHouse/issues/5310) and [#5882](https://github.com/ClickHouse/ClickHouse/issues/5882) [#5919](https://github.com/ClickHouse/ClickHouse/pull/5919) ([dimarub2000](https://github.com/dimarub2000))
-   通过允许空数据库名称, 允许将 `clickhouse-copier` 与交叉复制集群拓扑一起使用. [#5745](https://github.com/ClickHouse/ClickHouse/pull/5745) ([nvartolomei](https://github.com/nvartolomei))
-   在没有 `tzdata` 的系统 (例如裸 Docker 容器) 上使用 `UTC` 作为默认时区. 在此补丁之前，打印错误消息 `Could not determine local time zone` 并且服务器或客户端拒绝启动. [#5827](https://github.com/ClickHouse/ClickHouse/pull/5827) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   返回对函数 `quantileTiming` 中浮点参数的支持, 以实现向后兼容. [#5911](https://github.com/ClickHouse/ClickHouse/pull/5911) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   在错误消息中显示哪个表缺少列. [#5768](https://github.com/ClickHouse/ClickHouse/pull/5768) ([Ivan](https://github.com/abyss7))
-   禁止不同用户使用相同的 query_id 运行查询. [#5430](https://github.com/ClickHouse/ClickHouse/pull/5430) ([proller](https://github.com/proller))
-   用于将指标发送到 Graphite 的更强大的代码。 即使在长时间的 `RENAME TABLE` 操作期间它也能工作. [#5875](https://github.com/ClickHouse/ClickHouse/pull/5875) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   当 ThreadPool 无法安排要执行的任务时, 将显示更多信息性错误消息. 这修复了 [#5305](https://github.com/ClickHouse/ClickHouse/issues/5305) [#5801](https://github.com/ClickHouse/ClickHouse/pull/5801) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   倒置ngramSearch更直观. [#5807](https://github.com/ClickHouse/ClickHouse/pull/5807) ([Danila Kutenin](https://github.com/danlark1))
-   在 HDFS 引擎构建器中添加用户解析. [#5946](https://github.com/ClickHouse/ClickHouse/pull/5946) ([akonyaev90](https://github.com/akonyaev90))
-   更新 `max_ast_elements parameter` 的默认值. [#5933](https://github.com/ClickHouse/ClickHouse/pull/5933) ([Artem Konovalov](https://github.com/izebit))
-   添加了过时设置的概念. 可以使用过时的设置 `allow_experimental_low_cardinality_type` 没有效果. [0f15c01c6802f7ce1a1494c12c846be8c98944cd](https://github.com/ClickHouse/ClickHouse/commit/0f15c01c6802f7ce1a1494c12c846be8c98944cd) [Alexey Milovidov](https://github.com/alexey-milovidov)

#### 性能改进 {#performance-improvement-4}

-   增加从合并表中选择的流数量, 以实现更均匀的线程分布. 添加了设置 `max_streams_multiplier_for_merge_tables`. 这修复了 [#5797](https://github.com/ClickHouse/ClickHouse/issues/5797) [#5915](https://github.com/ClickHouse/ClickHouse/pull/5915) ([alexey-milovidov](https://github.com/alexey-milovidov))

#### 构建/测试/打包改进 {#buildtestingpackaging-improvement-7}

-   为客户端-服务器与不同版本的clickhouse交互添加向后兼容性测试. [#5868](https://github.com/ClickHouse/ClickHouse/pull/5868) ([alesapin](https://github.com/alesapin))
-   在每个提交和拉取请求中测试覆盖率信息. [#5896](https://github.com/ClickHouse/ClickHouse/pull/5896) ([alesapin](https://github.com/alesapin))
-   与 address sanitizer 合作以支持我们的自定义分配器 (`Arena` 和 `ArenaWithFreeLists`), 以便更好地调试 `use-after-free` 错误. [#5728](https://github.com/ClickHouse/ClickHouse/pull/5728) ([akuzm](https://github.com/akuzm))
-   切换到 [LLVM libunwind implementation](https://github.com/llvm-mirror/libunwind) 以进行 C++ 异常处理和堆栈跟踪打印. [#4828](https://github.com/ClickHouse/ClickHouse/pull/4828) ([Nikita Lapkov](https://github.com/laplab))
-   添加来自 -Weverything 的另外两个警告. [#5923](https://github.com/ClickHouse/ClickHouse/pull/5923) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   允许使用 Memory Sanitizer 构建 ClickHouse. [#3949](https://github.com/ClickHouse/ClickHouse/pull/3949) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   修复了关于模糊测试中 `bitTest` 函数的 ubsan 报告. [#5943](https://github.com/ClickHouse/ClickHouse/pull/5943) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   Docker: 增加了初始化需要身份验证的 ClickHouse 实例的可能性. [#5727](https://github.com/ClickHouse/ClickHouse/pull/5727) ([Korviakov Andrey](https://github.com/shurshun))
-   将 librdkafka 更新至 1.1.0 版. [#5872](https://github.com/ClickHouse/ClickHouse/pull/5872) ([Ivan](https://github.com/abyss7))
-   为集成测试添加全局超时并在测试代码中禁用其中的一些. [#5741](https://github.com/ClickHouse/ClickHouse/pull/5741) ([alesapin](https://github.com/alesapin))
-   修复一些 ThreadSanitizer 故障. [#5854](https://github.com/ClickHouse/ClickHouse/pull/5854) ([akuzm](https://github.com/akuzm))
-   `--no-undefined` 选项强制链接器在链接时检查所有外部名称是否存在. 在拆分构建模式下跟踪库之间的真实依赖关系非常有用. [#5855](https://github.com/ClickHouse/ClickHouse/pull/5855) ([Ivan](https://github.com/abyss7))
-   添加了 [#5797](https://github.com/ClickHouse/ClickHouse/issues/5797) [#5914](https://github.com/ClickHouse/ClickHouse/pull/5914) ([alexey-milovidov](https://github.com/alexey-milovidov)) 的性能测试.
-   修复了与 gcc-7 的兼容性. [#5840](https://github.com/ClickHouse/ClickHouse/pull/5840) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   添加了对 gcc-9 的支持. 这修复了 [#5717](https://github.com/ClickHouse/ClickHouse/issues/5717) [#5774](https://github.com/ClickHouse/ClickHouse/pull/5774) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   修复了 libunwind 可以错误链接时的错误. [#5948](https://github.com/ClickHouse/ClickHouse/pull/5948) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   修复了 PVS-Studio 发现的一些警告. [#5921](https://github.com/ClickHouse/ClickHouse/pull/5921) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   添加了对 `clang-tidy` 静态分析器的初始支持. [#5806](https://github.com/ClickHouse/ClickHouse/pull/5806) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   将 BSD/Linux 字节序宏 (`be64toh` 和 `htobe64`) 转换为 Mac OS X 等价物. [#5785](https://github.com/ClickHouse/ClickHouse/pull/5785) ([Fu Chen](https://github.com/fredchenbj))
-   改进的集成测试指南. [#5796](https://github.com/ClickHouse/ClickHouse/pull/5796) ([Vladimir Chebotarev](https://github.com/excitoon))
-   修复在macosx + gcc9的构建. [#5822](https://github.com/ClickHouse/ClickHouse/pull/5822) ([filimonov](https://github.com/filimonov))
-   修复一个难以发现的拼写错误: aggreGate -\>aggregate. [#5753](https://github.com/ClickHouse/ClickHouse/pull/5753) ([akuzm](https://github.com/akuzm))
-   修复 freebsd 构建. [#5760](https://github.com/ClickHouse/ClickHouse/pull/5760) ([proller](https://github.com/proller))
-   将实验性 YouTube 频道的链接添加到网站 [#5845](https://github.com/ClickHouse/ClickHouse/pull/5845) ([Ivan Blinkov](https://github.com/blinkov))
-   CMake: 添加覆盖标志选项: WITH_COVERAGE [#5776](https://github.com/ClickHouse/ClickHouse/pull/5776) ([proller](https://github.com/proller))
-   修复一些内联 PODArray 的初始大小. [#5787](https://github.com/ClickHouse/ClickHouse/pull/5787) ([akuzm](https://github.com/akuzm))
-   clickhouse-server.postinst: 修复 centos 6 的操作系统检测. [#5788](https://github.com/ClickHouse/ClickHouse/pull/5788) ([proller](https://github.com/proller))
-   添加了 Arch linux 包生成. [#5719](https://github.com/ClickHouse/ClickHouse/pull/5719) ([Vladimir Chebotarev](https://github.com/excitoon))
-   通过 libs (dbms) 拆分 Common/config.h. [#5715](https://github.com/ClickHouse/ClickHouse/pull/5715) ([proller](https://github.com/proller))
-   修复 `Arcadia` 构建平台 [#5795](https://github.com/ClickHouse/ClickHouse/pull/5795) ([proller](https://github.com/proller))
-   修复非常规构建 (gcc9, 无子模块). [#5792](https://github.com/ClickHouse/ClickHouse/pull/5792) ([proller](https://github.com/proller))
-   在 unalignedStore 中需要显式类型, 因为它被证明容易出错. [#5791](https://github.com/ClickHouse/ClickHouse/pull/5791) ([akuzm](https://github.com/akuzm))
-   修复 MacOS 构建. [#5830](https://github.com/ClickHouse/ClickHouse/pull/5830) ([filimonov](https://github.com/filimonov))
-   根据此处的要求, 关于具有更大数据集的新 JIT 功能的性能测试 [#5263](https://github.com/ClickHouse/ClickHouse/issues/5263) [#5887](https://github.com/ClickHouse/ClickHouse/pull/5887) ([Guillaume Tassery](https://github.com/YiuRULE))
-   在压力测试中运行状态测试 [12693e568722f11e19859742f56428455501fd2a](https://github.com/ClickHouse/ClickHouse/commit/12693e568722f11e19859742f56428455501fd2a) ([alesapin](https://github.com/alesapin))

#### 向后不兼容变更 {#backward-incompatible-change-7}

-   `Kafka` 在这个版本中被损坏.
-   默认情况下为新的 `MergeTree` 表启用 `adaptive_index_granularity` = 10MB. 如果您在 19.11+ 版本上创建了新的 MergeTree 表, 则无法降级到 19.6 之前的版本. [#5628](https://github.com/ClickHouse/ClickHouse/pull/5628) ([alesapin](https://github.com/alesapin))
-   删除了 Yandex.Metrica 使用的过时的未记录的嵌入式词典. `OSIn`、`SEIn`、`OSToRoot`、`SEToRoot`、`OSHierarchy`、`SEHierarchy` 函数不再可用. 如果您正在使用这些功能, 请发送电子邮件至 clickhouse-feedback@yandex-team.com. 注意: 最后一刻我们决定暂时保留这些功能. [#5780](https://github.com/ClickHouse/ClickHouse/pull/5780) ([alexey-milovidov](https://github.com/alexey-milovidov))

## ClickHouse 版本 19.10 {#clickhouse-release-19-10}

### ClickHouse 版本 19.10.1.5, 2019-07-12 {#clickhouse-release-19-10-1-5-2019-07-12}

#### 新特征 {#new-feature-7}

-   添加新的列编解码器：`T64`. 适用于 (U)IntX/EnumX/Data(Time)/DecimalX 列. 它应该适用于具有恒定值或小范围值的列. 编解码器本身允许放大或缩小数据类型而无需重新压缩. [#5557](https://github.com/ClickHouse/ClickHouse/pull/5557) ([Artem Zuikov](https://github.com/4ertus2))
-   添加数据库引擎`MySQL`, 允许查看远程MySQL服务器中的所有表. [#5599](https://github.com/ClickHouse/ClickHouse/pull/5599) ([Winter Zhang](https://github.com/zhang2014))
-   `bitmapContains` 实现. 如果第二个位图包含一个元素, 它比 `bitmapHasAny` 快 2 倍. [#5535](https://github.com/ClickHouse/ClickHouse/pull/5535) ([Zhichang Yu](https://github.com/yuzhichang))
-   支持 `crc32` 函数 (行为与 MySQL 或 PHP 完全相同). 如果您需要哈希函数, 请不要使用它. [#5661](https://github.com/ClickHouse/ClickHouse/pull/5661) ([Remen Ivan](https://github.com/BHYCHIK))
-   实现了 `SYSTEM START/STOP DISTRIBUTED SENDS` 查询以控制对 `Distributed` 表的异步插入. [#4935](https://github.com/ClickHouse/ClickHouse/pull/4935) ([Winter Zhang](https://github.com/zhang2014))

#### Bug 修复 {#bug-fix-22}

-   执行突变时忽略查询执行限制和合并限制的最大部分大小. [#5659](https://github.com/ClickHouse/ClickHouse/pull/5659) ([Anton Popov](https://github.com/CurtizJ))
-   修复可能导致正常块重复数据删除 (极其罕见) 和插入重复块 (更常见) 的错误. [#5549](https://github.com/ClickHouse/ClickHouse/pull/5549) ([alesapin](https://github.com/alesapin))
-   修复函数 `arrayEnumerateUniqRanked` 的空数组参数. [#5559](https://github.com/ClickHouse/ClickHouse/pull/5559) ([proller](https://github.com/proller))
-   不要在无意轮询任何消息的情况下订阅 Kafka 主题. [#5698](https://github.com/ClickHouse/ClickHouse/pull/5698) ([Ivan](https://github.com/abyss7))
-   使设置 `join_use_nulls` 对不能在 Nullable 内的类型无效. [#5700](https://github.com/ClickHouse/ClickHouse/pull/5700) ([Olga Khvostikova](https://github.com/stavrolia))
-   修复了 `Incorrect size of index granularity` 错误. [#5720](https://github.com/ClickHouse/ClickHouse/pull/5720) ([coraxster](https://github.com/coraxster))
-   修复 Float 到 Decimal 转换溢出. [#5607](https://github.com/ClickHouse/ClickHouse/pull/5607) ([coraxster](https://github.com/coraxster))
-   当 `WriteBufferFromHDFS` 的析构函数被调用时刷新缓冲区. 这修复了写入`HDFS`. [#5684](https://github.com/ClickHouse/ClickHouse/pull/5684) ([Xindong Peng](https://github.com/eejoin))

#### 改进 {#improvement-7}

-   启用设置 `input_format_defaults_for_omited_fields` 时，将 `CSV` 中的空单元格视为默认值. [#5625](https://github.com/ClickHouse/ClickHouse/pull/5625) ([akuzm](https://github.com/akuzm))
-   非阻塞加载外部字典. [#5567](https://github.com/ClickHouse/ClickHouse/pull/5567) ([Vitaly Baranov](https://github.com/vitlibar))
-   可以根据设置为已建立的连接动态更改网络超时. [#4558](https://github.com/ClickHouse/ClickHouse/pull/4558) ([Konstantin Podshumok](https://github.com/podshumok))
-   使用 `public_suffix_list` 作为函数 `firstSignificantSubdomain`、`cutToFirstSignificantSubdomain`. 它使用由`gperf` 生成的完美哈希表和从文件生成的列表: https://publicsuffix.org/list/public_suffix_list.dat. (例如, 现在我们认为域 `ac.uk` 不重要). [#5030](https://github.com/ClickHouse/ClickHouse/pull/5030) ([Guillaume Tassery](https://github.com/YiuRULE))
-   在系统表中采用了 `IPv6` 数据类型; `system.processes` 和 `system.query_log` 中的统一客户端信息列. [#5640](https://github.com/ClickHouse/ClickHouse/pull/5640) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   使用会话与 MySQL 兼容协议进行连接. #5476 [#5646](https://github.com/ClickHouse/ClickHouse/pull/5646) ([Yuriy Baranov](https://github.com/yurriy))
-   支持更多 `ALTER` 查询 `ON CLUSTER`. [#5593](https://github.com/ClickHouse/ClickHouse/pull/5593) [#5613](https://github.com/ClickHouse/ClickHouse/pull/5613) ([sundyli](https://github.com/sundy-li))
-   支持 `clickhouse-local` 配置文件中的 `<logger>` 部分. [#5540](https://github.com/ClickHouse/ClickHouse/pull/5540) ([proller](https://github.com/proller))
-   允许在 `clickhouse-local` 中使用 `remote` 表函数运行查询. [#5627](https://github.com/ClickHouse/ClickHouse/pull/5627) ([proller](https://github.com/proller))

#### 性能改进 {#performance-improvement-5}

-   添加在 MergeTree 列末尾写入最终标记的可能性. 它允许避免对超出表数据范围的键进行无用的读取. 仅在使用自适应索引粒度时才启用. [#5624](https://github.com/ClickHouse/ClickHouse/pull/5624) ([alesapin](https://github.com/alesapin))
-   通过减少 `stat` 系统调用的数量, 改进了 MergeTree 表在非常慢的文件系统上的性能. [#5648](https://github.com/ClickHouse/ClickHouse/pull/5648) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   修复了从版本 19.6 中引入的 MergeTree 表读取时的性能下降. 修复 #5631. [#5633](https://github.com/ClickHouse/ClickHouse/pull/5633) ([alexey-milovidov](https://github.com/alexey-milovidov))

#### 构建/测试/打包改进 {#buildtestingpackaging-improvement-8}

-   实现了 `TestKeeper` 作为用于测试的 ZooKeeper 接口的实现. [#5643](https://github.com/ClickHouse/ClickHouse/pull/5643) ([alexey-milovidov](https://github.com/alexey-milovidov)) ([levushkin aleksej](https://github.com/alexey-milovidov))
-   现在开始, `.sql` 测试可以由服务器独立运行, 与随机数据库并行运行. 它允许更快地运行它们, 使用自定义服务器配置添加新测试, 并确保不同的测试不会相互影响. [#5554](https://github.com/ClickHouse/ClickHouse/pull/5554) ([Ivan](https://github.com/abyss7))
-   从性能测试中删除 `<name>` 和 `<metrics>`. [#5672](https://github.com/ClickHouse/ClickHouse/pull/5672) ([Olga Khvostikova](https://github.com/stavrolia))
-   修复了 `Pretty` 格式的 `select_format` 性能测试. [#5642](https://github.com/ClickHouse/ClickHouse/pull/5642) ([alexey-milovidov](https://github.com/alexey-milovidov))

## ClickHouse 版本 19.9 {#clickhouse-release-19-9}

### ClickHouse 版本 19.9.3.31, 2019-07-05 {#clickhouse-release-19-9-3-31-2019-07-05}

#### Bug 修复 {#bug-fix-23}

-   修复 Delta 编解码器中的段错误, 该错误会影响值小于 32 位大小的列. 该错误导致随机内存损坏. [#5786](https://github.com/ClickHouse/ClickHouse/pull/5786) ([alesapin](https://github.com/alesapin))
-   修复使用低基数列检查零件时的罕见错误. [#5832](https://github.com/ClickHouse/ClickHouse/pull/5832) ([alesapin](https://github.com/alesapin))
-   修复 TTL 合并中的段错误与块中的非物理列. [#5819](https://github.com/ClickHouse/ClickHouse/pull/5819) ([Anton Popov](https://github.com/CurtizJ))
-   修复低优先级查询的潜在无限睡眠. [#5842](https://github.com/ClickHouse/ClickHouse/pull/5842) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   修复 ClickHouse 如何将默认时区确定为 UCT 而不是 UTC. [#5828](https://github.com/ClickHouse/ClickHouse/pull/5828) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   修复关于在领导者副本之前在跟随者副本上执行分布式 DROP/ALTER/TRUNCATE/OPTIMIZE ON CLUSTER 查询的错误. 现在它们将直接在领导者副本上执行. [#5757](https://github.com/ClickHouse/ClickHouse/pull/5757) ([alesapin](https://github.com/alesapin))
-   修复竞争条件, 导致某些查询在 SYSTEM FLUSH LOGS 查询后可能不会立即出现在 query_log 中. [#5685](https://github.com/ClickHouse/ClickHouse/pull/5685) ([Anton Popov](https://github.com/CurtizJ))
-   为 `evalMLModel` 函数添加了对常量参数的缺失支持. [#5820](https://github.com/ClickHouse/ClickHouse/pull/5820) ([alexey-milovidov](https://github.com/alexey-milovidov))

### ClickHouse 版本 19.9.2.4, 2019-06-24 {#clickhouse-release-19-9-2-4-2019-06-24}

#### 新特征 {#new-feature-8}

-   在 `system.parts` 表中打印有关冻结部件的信息. [#5471](https://github.com/ClickHouse/ClickHouse/pull/5471) ([proller](https://github.com/proller))
-   如果未在参数中设置, 则在 tty 上启动 clickhouse-client 时询问客户端密码. [#5092](https://github.com/ClickHouse/ClickHouse/pull/5092) ([proller](https://github.com/proller))
-   为 Decimal 类型实现 `dictGet` 和 `dictGetOrDefault` 函数. [#5394](https://github.com/ClickHouse/ClickHouse/pull/5394) ([Artem Zuikov](https://github.com/4ertus2))

#### 改进 {#improvement-8}

-   Debian init: 添加服务停止超时. [#5522](https://github.com/ClickHouse/ClickHouse/pull/5522) ([proller](https://github.com/proller))
-   添加默认禁止设置为 LowCardinality 创建具有可疑类型的表. [#5448](https://github.com/ClickHouse/ClickHouse/pull/5448) ([Olga Khvostikova](https://github.com/stavrolia))
-   回归函数在不用作函数 `evalMLMethod` 中的状态时返回模型权重. [#5411](https://github.com/ClickHouse/ClickHouse/pull/5411) ([Quid37](https://github.com/Quid37))
-   重命名和改进回归方法. [#5492](https://github.com/ClickHouse/ClickHouse/pull/5492) ([Quid37](https://github.com/Quid37))
-   字符串搜索器的界面更清晰. [#5586](https://github.com/ClickHouse/ClickHouse/pull/5586) ([Danila Kutenin](https://github.com/danlark1))

#### Bug 修复 {#bug-fix-24}

-   修复 Kafka 中潜在的数据丢失问题. [#5445](https://github.com/ClickHouse/ClickHouse/pull/5445) ([Ivan](https://github.com/abyss7))
-   使用零列调用时以 `PrettySpace` 格式修复潜在的无限循环. [#5560](https://github.com/ClickHouse/ClickHouse/pull/5560) ([Olga Khvostikova](https://github.com/stavrolia))
-   修复了线性模型中的 UInt32 溢出错误. 允许 eval ML 模型用于非常量模型参数. [#5516](https://github.com/ClickHouse/ClickHouse/pull/5516) ([Nikolai Kochetov](https://github.com/KochetovNicolai))
-   `ALTER TABLE ... DROP INDEX IF EXISTS ...` 如果提供的索引不存在，则不应引发异常. [#5524](https://github.com/ClickHouse/ClickHouse/pull/5524) ([Gleb Novikov](https://github.com/NanoBjorn))
-   在标量子查询中使用 `bitmapHasAny` 修复段错误. [#5528](https://github.com/ClickHouse/ClickHouse/pull/5528) ([Zhichang Yu](https://github.com/yuzhichang))
-   修复了复制连接池不重试解析主机时的错误, 即使 DNS 缓存已删除. [#5534](https://github.com/ClickHouse/ClickHouse/pull/5534) ([alesapin](https://github.com/alesapin))
-   修复了 ReplicatedMergeTree 上的 `ALTER ... MODIFY TTL` . [#5539](https://github.com/ClickHouse/ClickHouse/pull/5539) ([Anton Popov](https://github.com/CurtizJ))
-   使用 MATERIALIZED 列将 INSERT 修复到分布式表中. [#5429](https://github.com/ClickHouse/ClickHouse/pull/5429) ([Azat Khuzhin](https://github.com/azat))
-   在截断 Join 存储时修复错误分配 [#5437](https://github.com/ClickHouse/ClickHouse/pull/5437) ([TCeason](https://github.com/TCeason))
-   在包 tzdata 的最新版本中, 一些文件现在是符号链接. 当前检测默认时区的机制被破坏, 并为某些时区提供了错误的名称. 现在至少我们将时区名称强制为 TZ 的内容 (如果提供). [#5443](https://github.com/ClickHouse/ClickHouse/pull/5443) ([Ivan](https://github.com/abyss7))
-   使用 MultiVolnitsky 搜索器修复一些非常罕见的情况, 当总针数总和至少为 16KB 时. 该算法遗漏或覆盖了之前的结果, 这可能导致 `multiSearchAny` 的结果不正确. [#5588](https://github.com/ClickHouse/ClickHouse/pull/5588) ([Danila Kutenin](https://github.com/danlark1))
-   修复 ExternalData 请求的设置无法使用 ClickHouse 设置时的问题. 此外, 目前无法使用设置 `date_time_input_format` 和 `low_cardinality_allow_in_native_format`, 因为名称不明确 (在外部数据中它可以解释为表格式, 在查询中它可以是一个设置). [#5455](https://github.com/ClickHouse/ClickHouse/pull/5455) ([Danila Kutenin](https://github.com/danlark1))
-   修复了仅从 FS 中删除部件而不将它们从 Zookeeper 中删除的错误. [#5520](https://github.com/ClickHouse/ClickHouse/pull/5520) ([alesapin](https://github.com/alesapin))
-   从 MySQL 协议中删除调试日志记录. [#5478](https://github.com/ClickHouse/ClickHouse/pull/5478) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   在 DDL 查询处理过程中跳过 ZNONODE. [#5489](https://github.com/ClickHouse/ClickHouse/pull/5489) ([Azat Khuzhin](https://github.com/azat))
-   修复混合 `UNION ALL` 结果列类型. 存在数据和结果列的列类型不一致的情况. [#5503](https://github.com/ClickHouse/ClickHouse/pull/5503) ([Artem Zuikov](https://github.com/4ertus2))
-   在 dictGetT 函数中对错误的整数抛出异常而不是崩溃. [#5446](https://github.com/ClickHouse/ClickHouse/pull/5446) ([Artem Zuikov](https://github.com/4ertus2))
-   修复 `system.dictionaries` 表中散列字典的错误 element_count 和 load_factor. [#5440](https://github.com/ClickHouse/ClickHouse/pull/5440) ([Azat Khuzhin](https://github.com/azat))

#### 构建/测试/打包改进 {#buildtestingpackaging-improvement-9}

-   修复了没有 `Brotli` HTTP 压缩支持的构建 (`ENABLE_BROTLI=OFF` cmake 变量). [#5521](https://github.com/ClickHouse/ClickHouse/pull/5521) ([Anton Yuzhaninov](https://github.com/citrin))
-   包含 roaring.h 作为 roaring/roaring.h. [#5523](https://github.com/ClickHouse/ClickHouse/pull/5523) ([Orivej Desh](https://github.com/orivej))
-   修复 hyperscan 中的 gcc9 警告 (#line directive is evil!). [#5546](https://github.com/ClickHouse/ClickHouse/pull/5546) ([Danila Kutenin](https://github.com/danlark1))
-   修复使用 gcc-9 编译时的所有警告. 修复一些贡献问题. 修复 gcc9 ICE 并提交给 bugzilla. [#5498](https://github.com/ClickHouse/ClickHouse/pull/5498) ([Danila Kutenin](https://github.com/danlark1))
-   修复了与 lld 的链接. [#5477](https://github.com/ClickHouse/ClickHouse/pull/5477) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   删除字典中未使用的专业化. [#5452](https://github.com/ClickHouse/ClickHouse/pull/5452) ([Artem Zuikov](https://github.com/4ertus2))
-   针对不同类型文件的格式化和解析表的改进性能测试. [#5497](https://github.com/ClickHouse/ClickHouse/pull/5497) ([Olga Khvostikova](https://github.com/stavrolia))
-   修复并行测试运行. [#5506](https://github.com/ClickHouse/ClickHouse/pull/5506) ([proller](https://github.com/proller))
-   Docker: 使用 clickhouse-test 中的配置. [#5531](https://github.com/ClickHouse/ClickHouse/pull/5531) ([proller](https://github.com/proller))
-   修复 FreeBSD 编译. [#5447](https://github.com/ClickHouse/ClickHouse/pull/5447) ([proller](https://github.com/proller))
-   升级 boost 到 1.70. [#5570](https://github.com/ClickHouse/ClickHouse/pull/5570) ([proller](https://github.com/proller))
-   修复构建clickhouse作为子模块的问题. [#5574](https://github.com/ClickHouse/ClickHouse/pull/5574) ([proller](https://github.com/proller))
-   改进 JSONExtract 性能测试. [#5444](https://github.com/ClickHouse/ClickHouse/pull/5444) ([Vitaly Baranov](https://github.com/vitlibar))

## ClickHouse 版本 19.8 {#clickhouse-release-19-8}

### ClickHouse 版本 19.8.3.8, 2019-06-11 {#clickhouse-release-19-8-3-8-2019-06-11}

#### 新特征 {#new-features}

-   添加了使用 JSON 的函数. [#4686](https://github.com/ClickHouse/ClickHouse/pull/4686) ([hcz](https://github.com/hczhcz)) [#5124](https://github.com/ClickHouse/ClickHouse/pull/5124). ([Vitaly Baranov](https://github.com/vitlibar))
-   添加一个函数 basename, 其行为类似于 basename 函数, 该函数存在于很多语言中 (python 中的 `os.path.basename`，PHP 中的 `basename` 等......). 使用类 UNIX 路径或 Windows 路径. [#5136](https://github.com/ClickHouse/ClickHouse/pull/5136) ([Guillaume Tassery](https://github.com/YiuRULE))
-   添加了 `LIMIT n, m BY` 或 `LIMIT m OFFSET n BY` 语法来为LIMIT BY 子句设置n 的偏移量. [#5138](https://github.com/ClickHouse/ClickHouse/pull/5138) ([Anton Popov](https://github.com/CurtizJ))
-   添加了新的数据类型 `SimpleAggregateFunction`, 它允许在 `AggregatingMergeTree` 中具有轻聚合的列. 这只能与简单的函数一起使用, 如 `any`、`anyLast`、`sum`、`min`、`max`. [#4629](https://github.com/ClickHouse/ClickHouse/pull/4629) ([Boris Granveaud](https://github.com/bgranvea))
-   在函数 `ngramDistance` 中添加了对非常量参数的支持. [#5198](https://github.com/ClickHouse/ClickHouse/pull/5198) ([Danila Kutenin](https://github.com/danlark1))
-   添加函数 `skewPop`、`skewSamp`、`kurtPop` 和 `kurtSamp` 分别计算序列偏度、样本偏度、峰度和样本峰度. [#5200](https://github.com/ClickHouse/ClickHouse/pull/5200) ([hcz](https://github.com/hczhcz))
-   支持 `MaterializeView` 存储的重命名操作. [#5209](https://github.com/ClickHouse/ClickHouse/pull/5209) ([Guillaume Tassery](https://github.com/YiuRULE))
-   添加了允许使用 MySQL 客户端连接到 ClickHouse 的服务器. [#4715](https://github.com/ClickHouse/ClickHouse/pull/4715) ([Yuriy Baranov](https://github.com/yurriy))
-   添加 `toDecimal*OrZero` 和 `toDecimal*OrNull` 函数. [#5291](https://github.com/ClickHouse/ClickHouse/pull/5291) ([Artem Zuikov](https://github.com/4ertus2))
-   支持函数中的十进制类型: `quantile`、`quantiles`、`median`、`quantileExactWeighted`、`quantilesExactWeighted`、`medianExactWeighted`. [#5304](https://github.com/ClickHouse/ClickHouse/pull/5304) ([Artem Zuikov](https://github.com/4ertus2))
-   添加了 `toValidUTF8` 函数，用替换字符 � (U+FFFD) 替换所有无效的 UTF-8 字符. [#5322](https://github.com/ClickHouse/ClickHouse/pull/5322) ([Danila Kutenin](https://github.com/danlark1))
-   添加了 `format` 功能. 使用参数中列出的字符串格式化常量模式 (简化的 Python 格式模式). [#5330](https://github.com/ClickHouse/ClickHouse/pull/5330) ([Danila Kutenin](https://github.com/danlark1))
-   添加了 `system.detached_parts` 表, 其中包含有关 `MergeTree` 表的分离部分的信息. [#5353](https://github.com/ClickHouse/ClickHouse/pull/5353) ([akuzm](https://github.com/akuzm))
-   添加了 `ngramSearch` 函数来计算needle和haystack之间的非对称差异. [#5418](https://github.com/ClickHouse/ClickHouse/pull/5418)[#5422](https://github.com/ClickHouse/ClickHouse/pull/5422) ([Danila Kutenin](https://github.com/danlark1))
-   使用聚合函数接口实现基本机器学习方法 (随机线性回归和逻辑回归). 有不同的更新模型权重的策略 (简单梯度下降、动量方法、Nesterov 方法). 还支持自定义尺寸的小批量. [#4943](https://github.com/ClickHouse/ClickHouse/pull/4943) ([Quid37](https://github.com/Quid37))
-   `geohashEncode` 和 `geohashDecode` 函数的实现. [#5003](https://github.com/ClickHouse/ClickHouse/pull/5003) ([Vasily Nemkov](https://github.com/Enmk))
-   添加聚合函数`timeSeriesGroupSum`, 可以聚合采样时间戳不对齐的不同时间序列. 它将在两个样本时间戳之间使用线性插值, 然后将时间序列相加. 添加聚合函数 `timeSeriesGroupRateSum` , 它计算时间序列的速率, 然后将速率相加. [#4542](https://github.com/ClickHouse/ClickHouse/pull/4542) ([Yangkuan Liu](https://github.com/LiuYangkuan))
-   添加了函数 `IPv4CIDRtoIPv4Range` 和 `IPv6CIDRtoIPv6Range` 以使用 CIDR 计算子网中 IP 的下限和上限. [#5095](https://github.com/ClickHouse/ClickHouse/pull/5095) ([Guillaume Tassery](https://github.com/YiuRULE))
-   当我们使用启用设置 `send_progress_in_http_headers` 的 HTTP 发送查询时, 添加 X-ClickHouse-Summary 标头. 返回 X-ClickHouse-Progress 的常用信息, 附加信息, 如查询中插入了多少行和字节数. [#5116](https://github.com/ClickHouse/ClickHouse/pull/5116) ([Guillaume Tassery](https://github.com/YiuRULE))

#### 改进 {#improvements}

-   为 MergeTree 系列表(默认值: 100 000) 添加了 `max_parts_in_total` 设置, 以防止不安全的分区键规范 #5166. [#5171](https://github.com/ClickHouse/ClickHouse/pull/5171) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   `clickhouse-obfuscator`: 通过将初始种子与列名而不是列位置相结合来为各个列派生种子. 这旨在转换具有多个相关表的数据集, 以便转换后表保持可连接. [#5178](https://github.com/ClickHouse/ClickHouse/pull/5178) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   添加了函数`JSONExtractRaw`、`JSONExtractKeyAndValues`. 将函数 `jsonExtract<type>` 重命名为 `JSONExtract<type>`. 当出现问题时, 这些函数返回相应的值, 而不是 `NULL` . 修改了函数`JSONExtract`, 现在它从它的最后一个参数中获取返回类型并且不注入可空值. 在 AVX2 指令不可用的情况下, 实现了对 RapidJSON 的回退. Simdjson 库更新到新版本. [#5235](https://github.com/ClickHouse/ClickHouse/pull/5235) ([Vitaly Baranov](https://github.com/vitlibar))
-   现在 `if` 和 `multiIf` 函数不依赖于条件的 `Nullable` , 而是依赖于分支的sql兼容性. [#5238](https://github.com/ClickHouse/ClickHouse/pull/5238) ([Jian Wu](https://github.com/janplus))
-   `In` 谓词现在从 `Null` 输入生成 `Null` 结果, 就像 `Equal` 函数一样. [#5152](https://github.com/ClickHouse/ClickHouse/pull/5152) ([Jian Wu](https://github.com/janplus))
-   查来自 Kafka 的每 (flush_interval / poll_timeout) 行数的时间限制. 这允许更频繁地中断 Kafka 消费者的读取并检查顶级流的时间限制. [#5249](https://github.com/ClickHouse/ClickHouse/pull/5249) ([Ivan](https://github.com/abyss7))
-   将 rdkafka 与捆绑的 SASL 联系起来. 它应该允许使用 SASL SCRAM 身份验证. [#5253](https://github.com/ClickHouse/ClickHouse/pull/5253) ([Ivan](https://github.com/abyss7))
-   用于 ALL JOINS 的 RowRefList 的批处理版本. [#5267](https://github.com/ClickHouse/ClickHouse/pull/5267) ([Artem Zuikov](https://github.com/4ertus2))
-   clickhouse-server: 提供更多信息的侦听错误消息. [#5268](https://github.com/ClickHouse/ClickHouse/pull/5268) ([proller](https://github.com/proller))
-   支持 clickhouse-copier 中的字典用于 `<sharding_key>` 中的函数. [#5270](https://github.com/ClickHouse/ClickHouse/pull/5270) ([proller](https://github.com/proller))
-   添加新设置 `kafka_commit_every_batch` 以规范 Kafka 提交策略.
    它允许设置提交模式: 在处理每批消息之后, 或在整个块写入存储之后. 这是在某些极端情况下丢失某些消息或读取它们两次之间的权衡. [#5308](https://github.com/ClickHouse/ClickHouse/pull/5308) ([Ivan](https://github.com/abyss7))
-   使 `windowFunnel` 支持其他无符号整数类型. [#5320](https://github.com/ClickHouse/ClickHouse/pull/5320) ([sundyli](https://github.com/sundy-li))
-   允许在 Merge 引擎中隐藏虚拟列 `_table`. [#5325](https://github.com/ClickHouse/ClickHouse/pull/5325) ([Ivan](https://github.com/abyss7))
-   使 `sequenceMatch` 聚合函数支持其他无符号整数类型. [#5339](https://github.com/ClickHouse/ClickHouse/pull/5339) ([sundyli](https://github.com/sundy-li))
-   如果校验和不匹配最有可能是由硬件故障引起的, 则会提供更好的错误消息. [#5355](https://github.com/ClickHouse/ClickHouse/pull/5355) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   检查底层表是否支持对 `StorageMerge` 的采样 [#5366](https://github.com/ClickHouse/ClickHouse/pull/5366) ([Ivan](https://github.com/abyss7))
-   在外部字典中使用后关闭 MySQL 连接. 它与问题 #893 有关. [#5395](https://github.com/ClickHouse/ClickHouse/pull/5395) ([Clément Rodriguez](https://github.com/clemrodriguez))
-   MySQL Wire 协议的改进. 将格式名称更改为 MySQLWire. 使用 RAII 调用 RSA_free. 如果无法创建上下文, 则禁用 SSL. [#5419](https://github.com/ClickHouse/ClickHouse/pull/5419) ([Yuriy Baranov](https://github.com/yurriy))
-   允许使用不可访问的历史文件运行 (只读，没有磁盘空间，文件是目录，...). [#5431](https://github.com/ClickHouse/ClickHouse/pull/5431) ([proller](https://github.com/proller))
-   尊重异步 INSERT 中的查询设置到分布式表. [#4936](https://github.com/ClickHouse/ClickHouse/pull/4936) ([TCeason](https://github.com/TCeason))
-   将函数 `leastSqr` 重命名为 `simpleLinearRegression`，将 `LinearRegression` 重命名为 `linearRegression`，将 `LogisticRegression` 重命名为 `logisticRegression`. [#5391](https://github.com/ClickHouse/ClickHouse/pull/5391) ([Nikolai Kochetov](https://github.com/KochetovNicolai))

#### 性能改进 {#performance-improvements}

-   在 ALTER MODIFY 查询中并行处理部分非复制 MergeTree 表. [#4639](https://github.com/ClickHouse/ClickHouse/pull/4639) ([Ivan Kush](https://github.com/IvanKush))
-   正则表达式提取优化. [#5193](https://github.com/ClickHouse/ClickHouse/pull/5193) [#5191](https://github.com/ClickHouse/ClickHouse/pull/5191) ([Danila Kutenin](https://github.com/danlark1))
-   如果仅在连接部分中使用, 请勿添加右连接键列以连接结果. [#5260](https://github.com/ClickHouse/ClickHouse/pull/5260) ([Artem Zuikov](https://github.com/4ertus2))
-   在第一个空响应后冻结 Kafka 缓冲区. 它避免了多次调用 `ReadBuffer::next()` 以获得一些行解析流中的空结果. [#5283](https://github.com/ClickHouse/ClickHouse/pull/5283) ([Ivan](https://github.com/abyss7))
-   多参数的 `concat` 函数优化. [#5357](https://github.com/ClickHouse/ClickHouse/pull/5357) ([Danila Kutenin](https://github.com/danlark1))
-   查询优化. 允许在将逗号/交叉连接重写为内部语句时下推 IN 语句. [#5396](https://github.com/ClickHouse/ClickHouse/pull/5396) ([Artem Zuikov](https://github.com/4ertus2))
-   用参考文件1升级您的LZ4实现以获得更快的解压. [#5070](https://github.com/ClickHouse/ClickHouse/pull/5070) ([Danila Kutenin](https://github.com/danlark1))
-   实现了 MSD 基数排序 (基于 kxsort) 和部分排序. [#5129](https://github.com/ClickHouse/ClickHouse/pull/5129) ([Evgenii Pravda](https://github.com/kvinty))

#### Bug 修复 {#bug-fixes}

-   修复推送需要加入的列. [#5192](https://github.com/ClickHouse/ClickHouse/pull/5192) ([Winter Zhang](https://github.com/zhang2014))
-   修复了当 ClickHouse 由 systemd 运行时, 命令 `sudo service clickhouse-server forcerestart` 没有按预期工作的问题. [#5204](https://github.com/ClickHouse/ClickHouse/pull/5204) ([proller](https://github.com/proller))
-   复 DataPartsExchange 中的 http 错误代码 (9009 端口上的服务器间 http 服务器始终返回代码 200, 即使出现错误). [#5216](https://github.com/ClickHouse/ClickHouse/pull/5216) ([proller](https://github.com/proller))
-   修复长度超过 MAX_SMALL_STRING_SIZE 的字符串的 SimpleAggregateFunction [#5311](https://github.com/ClickHouse/ClickHouse/pull/5311) ([Azat Khuzhin](https://github.com/azat))
-   修复 IN 中 `Decimal` 到 `Nullable(Decimal)` 的转换错误. 支持其他十进制到十进制的转换 (包括不同的尺度). [#5350](https://github.com/ClickHouse/ClickHouse/pull/5350) ([Artem Zuikov](https://github.com/4ertus2))
-   修复了 simdjson 库中的 FPU 破坏导致 `uniqHLL` 和 `uniqCombined` 聚合函数和数学函数 (如 `log`) 计算错误的问题. [#5354](https://github.com/ClickHouse/ClickHouse/pull/5354) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   修复了 JSON 函数中混合常量/非常量情况的处理. [#5435](https://github.com/ClickHouse/ClickHouse/pull/5435) ([Vitaly Baranov](https://github.com/vitlibar))
-   修复 `retention` 功能. 现在在一行数据中满足的所有条件都添加到数据状态中. [#5119](https://github.com/ClickHouse/ClickHouse/pull/5119) ([小路](https://github.com/nicelulu))
-   用小数修复 `quantileExact` 的结果类型. [#5304](https://github.com/ClickHouse/ClickHouse/pull/5304) ([Artem Zuikov](https://github.com/4ertus2))

#### 文档 {#documentation}

-   将 `CollapsingMergeTree` 的文档翻译成中文. [#5168](https://github.com/ClickHouse/ClickHouse/pull/5168) ([张风啸](https://github.com/AlexZFX))
-   将一些关于表引擎的文档翻译成中文. [#5134](https://github.com/ClickHouse/ClickHouse/pull/5134) [#5328](https://github.com/ClickHouse/ClickHouse/pull/5328) ([never lee](https://github.com/neverlee))

#### 构建/测试/打包改进 {#buildtestingpackaging-improvements}

-   复一些显示可能在免费后使用的清除报告. [#5139](https://github.com/ClickHouse/ClickHouse/pull/5139) [#5143](https://github.com/ClickHouse/ClickHouse/pull/5143) [#5393](https://github.com/ClickHouse/ClickHouse/pull/5393) ([Ivan](https://github.com/abyss7))
-   为方便起见, 将性能测试移出单独的目录. [#5158](https://github.com/ClickHouse/ClickHouse/pull/5158) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   修复不正确的性能测试. [#5255](https://github.com/ClickHouse/ClickHouse/pull/5255) ([alesapin](https://github.com/alesapin))
-   增加了一个工具来计算由位转换引起的校验和来调试硬件问题. [#5334](https://github.com/ClickHouse/ClickHouse/pull/5334) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   使运行脚本更有用. [#5340](https://github.com/ClickHouse/ClickHouse/pull/5340)[#5360](https://github.com/ClickHouse/ClickHouse/pull/5360) ([filimonov](https://github.com/filimonov))
-   添加如何编写性能测试的小说明. [#5408](https://github.com/ClickHouse/ClickHouse/pull/5408) ([alesapin](https://github.com/alesapin))
-   添加在性能测试中的创建、填充和删除查询中进行替换的能力. [#5367](https://github.com/ClickHouse/ClickHouse/pull/5367) ([Olga Khvostikova](https://github.com/stavrolia))

## ClickHouse 版本 19.7 {#clickhouse-release-19-7}

### ClickHouse 版本 19.7.5.29, 2019-07-05 {#clickhouse-release-19-7-5-29-2019-07-05}

#### Bug 修复 {#bug-fix-25}

-   使用 JOIN 修复某些查询中的性能回归. [#5192](https://github.com/ClickHouse/ClickHouse/pull/5192) ([Winter Zhang](https://github.com/zhang2014))

### ClickHouse 版本 19.7.5.27, 2019-06-09 {#clickhouse-release-19-7-5-27-2019-06-09}

#### 新特征 {#new-features-1}

-   添加位图相关函数 `bitmapHasAny` 和 `bitmapHasAll` 类似于数组的 `hasAny` 和 `hasAll` 函数. [#5279](https://github.com/ClickHouse/ClickHouse/pull/5279) ([Sergi Vladykin](https://github.com/svladykin))

#### Bug 修复 {#bug-fixes-1}

-   使用 Null 值修复 `minmax` INDEX 上的段错误. [#5246](https://github.com/ClickHouse/ClickHouse/pull/5246) ([Nikita Vasilev](https://github.com/nikvas0))
-   将 LIMIT BY 中的所有输入列标记为所需输出。 它修复了某些分布式查询中的 `Not found column` 错误. [#5407](https://github.com/ClickHouse/ClickHouse/pull/5407) ([Constantin S. Pan](https://github.com/kvap))
-   在带有 DEFAULT 的列上修复 `SELECT .. PREWHERE` 中的 `Column '0' already exists` 错误. [#5397](https://github.com/ClickHouse/ClickHouse/pull/5397) ([proller](https://github.com/proller))
-   修复 `ReplicatedMergeTree` 上的 `ALTER MODIFY TTL` 查询. [#5539](https://github.com/ClickHouse/ClickHouse/pull/5539/commits) ([Anton Popov](https://github.com/CurtizJ))
-   当 Kafka 消费者启动失败时不要让服务器崩溃. [#5285](https://github.com/ClickHouse/ClickHouse/pull/5285) ([Ivan](https://github.com/abyss7))
-   修复位图函数产生错误结果. [#5359](https://github.com/ClickHouse/ClickHouse/pull/5359) ([Andy Yang](https://github.com/andyyzh))
-   修复哈希字典的 element_count (不包括重复项). [#5440](https://github.com/ClickHouse/ClickHouse/pull/5440) ([Azat Khuzhin](https://github.com/azat))
-   使用环境变量 TZ 的内容作为时区的名称. 在某些情况下有助于正确检测默认时区. [#5443](https://github.com/ClickHouse/ClickHouse/pull/5443) ([Ivan](https://github.com/abyss7))
-   不要尝试在 `dictGetT` 函数中转换整数, 因为它不能正常工作. 改为抛出异常. [#5446](https://github.com/ClickHouse/ClickHouse/pull/5446) ([Artem Zuikov](https://github.com/4ertus2))
-   修复 ExternalData HTTP 请求中的设置. [#5455](https://github.com/ClickHouse/ClickHouse/pull/5455) ([Danila
    Kutenin](https://github.com/danlark1))
-   修复了仅从 FS 中删除部件而不将它们从 Zookeeper 中删除的错误. [#5520](https://github.com/ClickHouse/ClickHouse/pull/5520) ([alesapin](https://github.com/alesapin))
-   修复了 `bitmapHasAny` 函数中的分段错误. [#5528](https://github.com/ClickHouse/ClickHouse/pull/5528) ([Zhichang Yu](https://github.com/yuzhichang))
-   修复了复制连接池不重试解析主机时的错误, 即使 DNS 缓存已删除. [#5534](https://github.com/ClickHouse/ClickHouse/pull/5534) ([alesapin](https://github.com/alesapin))
-   修复了 `DROP INDEX IF EXISTS` 查询. 现在 `ALTER TABLE ... DROP INDEX IF EXISTS ...` 如果提供的索引不存在, 查询不会引发异常. [#5524](https://github.com/ClickHouse/ClickHouse/pull/5524) ([Gleb Novikov](https://github.com/NanoBjorn))
-   修复联合所有超类型列. 存在数据和结果列的列类型不一致的情况. [#5503](https://github.com/ClickHouse/ClickHouse/pull/5503) ([Artem Zuikov](https://github.com/4ertus2))
-   在 DDL 查询处理期间跳过 ZNONODE. 在另一个节点删除任务队列中的 znode 之前, 没有处理它但已经获得孩子列表的节点将终止 DDLWorker 线程. [#5489](https://github.com/ClickHouse/ClickHouse/pull/5489) ([Azat Khuzhin](https://github.com/azat))
-   使用 MATERIALIZED 列将 INSERT 修复到 Distributed() 表中. [#5429](https://github.com/ClickHouse/ClickHouse/pull/5429) ([Azat Khuzhin](https://github.com/azat))

### ClickHouse 版本 19.7.3.9, 2019-05-30 {#clickhouse-release-19-7-3-9-2019-05-30}

#### 新特征 {#new-features-2}

-   允许限制用户可以指定的设置范围. 这些约束可以在用户设置配置文件中设置. [#4931](https://github.com/ClickHouse/ClickHouse/pull/4931) ([Vitaly Baranov](https://github.com/vitlibar))
-   添加函数 `groupUniqArray` 的第二个版本, 并带有一个可选的 `max_size` 参数, 用于限制结果数组的大小, 这种行为类似于 `groupArray(max_size)(x)` 函数. [#5026](https://github.com/ClickHouse/ClickHouse/pull/5026) ([Guillaume Tassery](https://github.com/YiuRULE))
-   对于 TSVWithNames/CSVWithNames 输入文件格式, 现在可以根据文件标题确定列顺序. 这由 `input_format_with_names_use_header` 参数控制.
    [#5081](https://github.com/ClickHouse/ClickHouse/pull/5081) ([Alexander](https://github.com/Akazz))

#### Bug 修复 {#bug-fixes-2}

-   uncompressed_cache + JOIN在合并期间崩溃. (#5197)[#5133](https://github.com/ClickHouse/ClickHouse/pull/5133) ([Danila Kutenin](https://github.com/danlark1))
-   clickhouse 客户端查询系统表时出现分段错误. #5066. [#5127](https://github.com/ClickHouse/ClickHouse/pull/5127) ([Ivan](https://github.com/abyss7))
-   通过 KafkaEngine 重载数据丢失. (#4736) [#5080](https://github.com/ClickHouse/ClickHouse/pull/5080) ([Ivan](https://github.com/abyss7))
-   修复了在使用 UNION ALL 执行涉及至少两个来自 system.columns、system.tables、system.parts、system.parts_tables 或 Merge 系列表的查询并执行相关列的 ALTER 时可能发生的非常罕见的数据竞争条件并发表. [#5189](https://github.com/ClickHouse/ClickHouse/pull/5189) ([alexey-milovidov](https://github.com/alexey-milovidov))

#### 性能改进 {#performance-improvements-1}

-   使用基数排序按 `ORDER BY` 中的单个数字列进行排序, 而无需 `LIMIT`. [#5106](https://github.com/ClickHouse/ClickHouse/pull/5106), [#4439](https://github.com/ClickHouse/ClickHouse/pull/4439) ([Evgenii Pravda](https://github.com/kvinty), [alexey-milovidov](https://github.com/alexey-milovidov))

#### 文档 {#documentation-1}

-   将一些表引擎的文档翻译成中文. [#5107](https://github.com/ClickHouse/ClickHouse/pull/5107), [#5094](https://github.com/ClickHouse/ClickHouse/pull/5094), [#5087](https://github.com/ClickHouse/ClickHouse/pull/5087) ([张风啸](https://github.com/AlexZFX)), [#5068](https://github.com/ClickHouse/ClickHouse/pull/5068) ([never lee](https://github.com/neverlee))

#### 构建/测试/打包改进 {#buildtestingpackaging-improvements-1}

-   在 `clickhouse-test` 中正确打印 UTF-8 字符. [#5084](https://github.com/ClickHouse/ClickHouse/pull/5084) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   为 clickhouse-client 添加命令行参数以始终加载建议数据. [#5102](https://github.com/ClickHouse/ClickHouse/pull/5102) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   解决部分 PVS-Studio 警告. [#5082](https://github.com/ClickHouse/ClickHouse/pull/5082) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   更新 LZ4. [#5040](https://github.com/ClickHouse/ClickHouse/pull/5040) ([Danila Kutenin](https://github.com/danlark1))
-   添加 gperf 以构建即将到来的拉取请求的需求 #5030. [#5110](https://github.com/ClickHouse/ClickHouse/pull/5110) ([proller](https://github.com/proller))

## ClickHouse 版本 19.6 {#clickhouse-release-19-6}

### ClickHouse 版本 19.6.3.18, 2019-06-13 {#clickhouse-release-19-6-3-18-2019-06-13}

#### Bug 修复 {#bug-fixes-3}

-   修复了来自表函数 `mysql` 和 `odbc` 以及相应表引擎的查询的 IN 条件下推. 这修复了 #3540 和 #2384. [#5313](https://github.com/ClickHouse/ClickHouse/pull/5313) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   修复 Zookeeper 中的死锁. [#5297](https://github.com/ClickHouse/ClickHouse/pull/5297) ([github1youlc](https://github.com/github1youlc))
-   允许在 CSV 中引用小数. [#5284](https://github.com/ClickHouse/ClickHouse/pull/5284) ([Artem Zuikov](https://github.com/4ertus2)
-   禁止从浮点 Inf/NaN 转换为小数 (抛出异常). [#5282](https://github.com/ClickHouse/ClickHouse/pull/5282) ([Artem Zuikov](https://github.com/4ertus2))
-   修复重命名查询中的数据竞争. [#5247](https://github.com/ClickHouse/ClickHouse/pull/5247) ([Winter Zhang](https://github.com/zhang2014))
-   暂时禁用 LFAlloc. 使用 LFAlloc 可能会导致在分配 UncompressedCache 时出现大量 MAP_FAILED 并导致高负载服务器上的查询崩溃. [cfdba93](https://github.com/ClickHouse/ClickHouse/commit/cfdba938ce22f16efeec504f7f90206a515b1280)([Danila Kutenin](https://github.com/danlark1))

### ClickHouse 版本 19.6.2.11, 2019-05-13 {#clickhouse-release-19-6-2-11-2019-05-13}

#### 新特征 {#new-features-3}

-   列和表的 TTL 表达式. [#4212](https://github.com/ClickHouse/ClickHouse/pull/4212) ([Anton Popov](https://github.com/CurtizJ))
-   添加了对 HTTP 响应的 `brotli` 压缩的支持 (接受编码：br). [#4388](https://github.com/ClickHouse/ClickHouse/pull/4388) ([Mikhail](https://github.com/fandyushin))
-   添加了新函数 `isValidUTF8` 用于检查一组字节是否正确 utf-8 编码. [#4934](https://github.com/ClickHouse/ClickHouse/pull/4934) ([Danila Kutenin](https://github.com/danlark1))
-   添加新的负载平衡策略 `first_or_random` , 它将查询发送到第一个指定的主机, 如果无法访问, 则将查询发送到分片的随机主机. 对交叉复制拓扑设置有用. [#5012](https://github.com/ClickHouse/ClickHouse/pull/5012) ([nvartolomei](https://github.com/nvartolomei))

#### 实验功能 {#experimental-features-1}

-   为 MergeTree\* 表族添加设置 `index_granularity_bytes` (自适应索引粒度). [#4826](https://github.com/ClickHouse/ClickHouse/pull/4826) ([alesapin](https://github.com/alesapin))

#### 改进 {#improvements-1}

-   添加了对函数 `substringUTF8` 的非常量和负大小和长度参数的支持. [#4989](https://github.com/ClickHouse/ClickHouse/pull/4989) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   在左连接中禁用右表下推, 右连接中禁用左表, 以及完全连接中的两个表. 这在某些情况下修复了错误的 JOIN 结果. [#4846](https://github.com/ClickHouse/ClickHouse/pull/4846) ([Ivan](https://github.com/abyss7))
-   `clickhouse-copier`: 从`--task-file`选项自动上传任务配置. [#4876](https://github.com/ClickHouse/ClickHouse/pull/4876) ([proller](https://github.com/proller))
-   为存储工厂和表函数工厂添加了错别字处理程序. [#4891](https://github.com/ClickHouse/ClickHouse/pull/4891) ([Danila Kutenin](https://github.com/danlark1))
-   支持无子查询的多个连接的星号和合格星号. [#4898](https://github.com/ClickHouse/ClickHouse/pull/4898) ([Artem Zuikov](https://github.com/4ertus2))
-   使缺失列错误消息更加用户友好. [#4915](https://github.com/ClickHouse/ClickHouse/pull/4915) ([Artem Zuikov](https://github.com/4ertus2))

#### 性能改进 {#performance-improvements-2}

-   ASOF JOIN 的显着加速. [#4924](https://github.com/ClickHouse/ClickHouse/pull/4924) ([Martijn Bakker](https://github.com/Gladdy))

#### 向后不兼容更改 {#backward-incompatible-changes}

-   HTTP 标头 `Query-Id` 重命名为 `X-ClickHouse-Query-Id` 以保持一致性. [#4972](https://github.com/ClickHouse/ClickHouse/pull/4972) ([Mikhail](https://github.com/fandyushin))

#### Bug 修复 {#bug-fixes-4}

-   修复了 `clickhouse-copier` 中潜在的空指针取消引用. [#4900](https://github.com/ClickHouse/ClickHouse/pull/4900) ([proller](https://github.com/proller))
-   修复了 JOIN + ARRAY JOIN 查询错误. [#4938](https://github.com/ClickHouse/ClickHouse/pull/4938) ([Artem Zuikov](https://github.com/4ertus2))
-   修复了当字典通过带有 engine=Dictionary 的数据库依赖另一个字典时服务器启动时挂起的问题. [#4962](https://github.com/ClickHouse/ClickHouse/pull/4962) ([Vitaly Baranov](https://github.com/vitlibar))
-   部分修复了 `distributed_product_mode = local` . 可以通过表别名允许本地表的列在 `where/have/order by/...` 中. 如果表没有别名, 则抛出异常. 目前还无法访问没有表别名的列. [#4986](https://github.com/ClickHouse/ClickHouse/pull/4986) ([Artem Zuikov](https://github.com/4ertus2))
-   使用 `JOIN` 修复 `SELECT DISTINCT` 的潜在错误结果. [#5001](https://github.com/ClickHouse/ClickHouse/pull/5001) ([Artem Zuikov](https://github.com/4ertus2))
-   修复了在使用 UNION ALL 执行涉及至少两个来自 system.columns、system.tables、system.parts、system.parts_tables 或 Merge 系列表的查询并执行相关列的 ALTER 时可能发生的非常罕见的数据竞争条件并发表. [#5189](https://github.com/ClickHouse/ClickHouse/pull/5189) ([alexey-milovidov](https://github.com/alexey-milovidov))

#### 构建/测试/打包改进 {#buildtestingpackaging-improvements-2}

-   修复了在不同主机上运行 clickhouse-server 时的测试失败. [#4713](https://github.com/ClickHouse/ClickHouse/pull/4713) ([Vasily Nemkov](https://github.com/Enmk))
-   clickhouse-test: 在非 tty 环境中禁用颜色控制序列. [#4937](https://github.com/ClickHouse/ClickHouse/pull/4937) ([alesapin](https://github.com/alesapin))
-   clickhouse-test: 允许使用任何测试数据库 (尽可能删除 `test.` 限定) [#5008](https://github.com/ClickHouse/ClickHouse/pull/5008) ([proller](https://github.com/proller))
-   修复 ubsan 错误. [#5037](https://github.com/ClickHouse/ClickHouse/pull/5037) ([Vitaly Baranov](https://github.com/vitlibar))
-   在 ClickHouse 中添加了 Yandex LFAlloc 以不同方式分配 MarkCache 和 UncompressedCache 数据以更可靠地捕获段错误. [#4995](https://github.com/ClickHouse/ClickHouse/pull/4995) ([Danila Kutenin](https://github.com/danlark1))
-   Python util 可帮助进行向后移植和更改日志. [#4949](https://github.com/ClickHouse/ClickHouse/pull/4949) ([Ivan](https://github.com/abyss7))

## ClickHouse 版本 19.5 {#clickhouse-release-19-5}

### ClickHouse 版本 19.5.4.22, 2019-05-13 {#clickhouse-release-19-5-4-22-2019-05-13}

#### Bug 修复 {#bug-fixes-5}

-   修复了位图\* 函数中可能发生的崩溃. [#5220](https://github.com/ClickHouse/ClickHouse/pull/5220) [#5228](https://github.com/ClickHouse/ClickHouse/pull/5228) ([Andy Yang](https://github.com/andyyzh))
-   修复了在使用 UNION ALL 执行涉及至少两个来自 system.columns、system.tables、system.parts、system.parts_tables 或 Merge 系列表的查询并执行相关列的 ALTER 时可能发生的非常罕见的数据竞争条件并发表. [#5189](https://github.com/ClickHouse/ClickHouse/pull/5189) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   修复了 `Set for IN is not created yet in case of using single LowCardinality column in the left part of IN`. 如果 LowCardinality 列是主键的一部分，则会发生此错误. #5031 [#5154](https://github.com/ClickHouse/ClickHouse/pull/5154) ([Nikolai Kochetov](https://github.com/KochetovNicolai))
-   保留函数修改: 如果一行同时满足第一个和第NTH个条件, 则只将第一个满足的条件添加到数据状态中. 现在在一行数据中满足的所有条件都添加到数据状态中. [#5119](https://github.com/ClickHouse/ClickHouse/pull/5119) ([小路](https://github.com/nicelulu))

### ClickHouse 版本 19.5.3.8, 2019-04-18 {#clickhouse-release-19-5-3-8-2019-04-18}

#### Bug 修复 {#bug-fixes-6}

-   固定类型的设置 `max_partitions_per_insert_block` 从布尔值到 UInt64. [#5028](https://github.com/ClickHouse/ClickHouse/pull/5028) ([Mohammad Hossein Sekhavat](https://github.com/mhsekhavat))

### ClickHouse 版本 19.5.2.6, 2019-04-15 {#clickhouse-release-19-5-2-6-2019-04-15}

#### 新特征 {#new-features-4}

-   [Hyperscan](https://github.com/intel/hyperscan) 添加了多个正则表达式匹配 (函数`multiMatchAny`、`multiMatchAnyIndex`、`multiFuzzyMatchAny`、`multiFuzzyMatchAnyIndex`). [#4780](https://github.com/ClickHouse/ClickHouse/pull/4780), [#4841](https://github.com/ClickHouse/ClickHouse/pull/4841) ([Danila Kutenin](https://github.com/danlark1))
-   添加了 `multiSearchFirstPosition` 功能. [#4780](https://github.com/ClickHouse/ClickHouse/pull/4780) ([Danila Kutenin](https://github.com/danlark1))
-   表实现每行预定义的表达式过滤器. [#4792](https://github.com/ClickHouse/ClickHouse/pull/4792) ([Ivan](https://github.com/abyss7))
-   一种基于布隆过滤器的新型数据跳过索引 (可用于`equal`、`in`和`like`函数). [#4499](https://github.com/ClickHouse/ClickHouse/pull/4499) ([Nikita Vasilev](https://github.com/nikvas0))
-   添加了`ASOF JOIN`, 它允许运行连接到已知最新值的查询. [#4774](https://github.com/ClickHouse/ClickHouse/pull/4774) [#4867](https://github.com/ClickHouse/ClickHouse/pull/4867) [#4863](https://github.com/ClickHouse/ClickHouse/pull/4863) [#4875](https://github.com/ClickHouse/ClickHouse/pull/4875) ([Martijn Bakker](https://github.com/Gladdy), [Artem Zuikov](https://github.com/4ertus2))
-   将多个 `COMMA JOIN` 重写为 `CROSS JOIN`. 如果可能, 然后将它们重写为 `INNER JOIN` . [#4661](https://github.com/ClickHouse/ClickHouse/pull/4661) ([Artem Zuikov](https://github.com/4ertus2))

#### 改进 {#improvement-9}

-   `topK` 和 `topK Weighted` 现在支持自定义 `load Factor`. (fixes issue [#4252](https://github.com/ClickHouse/ClickHouse/issues/4252)). [#4634](https://github.com/ClickHouse/ClickHouse/pull/4634) ([Kirill Danshin](https://github.com/kirillDanshin))
-   即使对于没有采样的表, 也允许使用 `parallel_replicas_count > 1` (该设置被简单地忽略). 在以前的版本中, 它导致异常. [#4637](https://github.com/ClickHouse/ClickHouse/pull/4637) ([Alexey Elymanov](https://github.com/digitalist))
-   支持 `CREATE OR REPLACE VIEW`. 允许在单个语句中创建视图或设置新定义. [#4654](https://github.com/ClickHouse/ClickHouse/pull/4654) ([Boris Granveaud](https://github.com/bgranvea))
-   `Buffer` 表引擎现在支持 `PREWHERE`. [#4671](https://github.com/ClickHouse/ClickHouse/pull/4671) ([Yangkuan Liu](https://github.com/LiuYangkuan))
-   添加在 `readonly` 模式下在zookeeper中启动没有元数据的复制表的能力. [#4691](https://github.com/ClickHouse/ClickHouse/pull/4691) ([alesapin](https://github.com/alesapin))
-   修复了 clickhouse-client 中进度条的闪烁. 将 `FORMAT Null` 与流查询一起使用时, 该问题最为明显. [#4811](https://github.com/ClickHouse/ClickHouse/pull/4811) ([alexey-milovidov](https://github.com/alexey-milovidov))
-  允许在每个用户的基础上禁用带有 `hyperscan` 库的功能, 以限制可能过度和不受控制的资源使用. [#4816](https://github.com/ClickHouse/ClickHouse/pull/4816) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   添加版本号记录所有错误. [#4824](https://github.com/ClickHouse/ClickHouse/pull/4824) ([proller](https://github.com/proller))
-   向 `multiMatch` 函数添加了限制, 该限制要求字符串大小适合 `unsigned int`。 还为 `multiSearch` 函数添加了参数数量限制. [#4834](https://github.com/ClickHouse/ClickHouse/pull/4834) ([Danila Kutenin](https://github.com/danlark1))
-   改进了 Hyperscan 中暂存空间的使用和错误处理. [#4866](https://github.com/ClickHouse/ClickHouse/pull/4866) ([Danila Kutenin](https://github.com/danlark1))
-   从 `*GraphiteMergeTree` 引擎表的表配置中填充 `system.graphite_detentions`. [#4584](https://github.com/ClickHouse/ClickHouse/pull/4584) ([Mikhail f. Shiryaev](https://github.com/Felixoid))
-   将 `trigramDistance` 函数重命名为 `ngramDistance` 并添加更多带有 `CaseInsensitive` 和 `UTF` 的函数. [#4602](https://github.com/ClickHouse/ClickHouse/pull/4602) ([Danila Kutenin](https://github.com/danlark1))
-   改进的数据跳跃指数计算. [#4640](https://github.com/ClickHouse/ClickHouse/pull/4640) ([Nikita Vasilev](https://github.com/nikvas0))
-   将普通、`DEFAULT`、`MATERIALIZED` 和`ALIAS` 列保留在一个列表中 (修复问题 [#2867](https://github.com/ClickHouse/ClickHouse/issues/2867)). [#4707](https://github.com/ClickHouse/ClickHouse/pull/4707) ([Alex Zatelepin](https://github.com/ztlpn))

#### Bug 修复 {#bug-fix-26}

-   在内存分配失败的情况下避免使用 `std::terminate`. 现在按预期抛出 `std::bad_alloc` 异常. [#4665](https://github.com/ClickHouse/ClickHouse/pull/4665) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   修复了从缓冲区读取 capnproto 的问题. 有时文件未通过 HTTP 成功加载. [#4674](https://github.com/ClickHouse/ClickHouse/pull/4674) ([Vladislav](https://github.com/smirnov-vs))
-   在 `OPTIMIZE TABLE FINAL` 查询后修复错误 `Unknown log entry type: 0` . [#4683](https://github.com/ClickHouse/ClickHouse/pull/4683) ([Amos Bird](https://github.com/amosbird))
-   `hasAny` 或 `hasAll` 函数的错误参数可能会导致段错误. [#4698](https://github.com/ClickHouse/ClickHouse/pull/4698) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   执行 `DROP DATABASE dictionary` 查询时可能发生死锁. [#4701](https://github.com/ClickHouse/ClickHouse/pull/4701) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   修复 `median` 和 `quantile` 函数中未定义的行为. [#4702](https://github.com/ClickHouse/ClickHouse/pull/4702) ([hcz](https://github.com/hczhcz))
-   修复 `network_compression_method` 为小写时的压缩级别检测. 在 v19.1 中损坏. [#4706](https://github.com/ClickHouse/ClickHouse/pull/4706) ([proller](https://github.com/proller))
-   修复了对 `<timezone>UTC</timezone>` 设置的无知 (修复了问题 [#4658](https://github.com/ClickHouse/ClickHouse/issues/4658). [#4718](https://github.com/ClickHouse/ClickHouse/pull/4718) ([proller](https://github.com/proller))
-   使用 `Distributed` 表修复 `histogram` 函数行为. [#4741](https://github.com/ClickHouse/ClickHouse/pull/4741) ([olegkv](https://github.com/olegkv))
-   修复了 tsan 报告 `destroy of a locked mutex` 的问题. [#4742](https://github.com/ClickHouse/ClickHouse/pull/4742) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   修复了由于系统日志使用中的竞争条件而导致关闭的 TSan 报告。 修复了启用 part_log 时关闭时潜在的释放后使用问题. [#4758](https://github.com/ClickHouse/ClickHouse/pull/4758) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   修复 `ReplicatedMergeTreeAlterThread` 中的重新检查部分以防出错. [#4772](https://github.com/ClickHouse/ClickHouse/pull/4772) ([Nikolai Kochetov](https://github.com/KochetovNicolai))
-   中间聚合函数状态的算术运算不适用于常量参数 (例如子查询结果). [#4776](https://github.com/ClickHouse/ClickHouse/pull/4776) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   始终在元数据中反引用列名称. 否则不可能创建一个名为`index`的列的表 (由于元数据中的`ATTACH`查询格式错误, 服务器不会重启). [#4782](https://github.com/ClickHouse/ClickHouse/pull/4782) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   修复 `Distributed` 表上的 `ALTER ... MODIFY ORDER BY` 崩溃. [#4790](https://github.com/ClickHouse/ClickHouse/pull/4790) ([TCeason](https://github.com/TCeason))
-   使用启用的 `enable_optimize_predicate_expression` 修复 `JOIN ON` 中的段错误. [#4794](https://github.com/ClickHouse/ClickHouse/pull/4794) ([Winter Zhang](https://github.com/zhang2014))
-   使用来自 Kafka 的 protobuf 消息后通过添加无关行来修复错误. [#4808](https://github.com/ClickHouse/ClickHouse/pull/4808) ([Vitaly Baranov](https://github.com/vitlibar))
-   修复 `JOIN` 在不可为空与可为空列上的崩溃. 修复 `ANY JOIN` + `join_use_nulls` 中右键中的 `NULLs`. [#4815](https://github.com/ClickHouse/ClickHouse/pull/4815) ([Artem Zuikov](https://github.com/4ertus2))
-   修复 `clickhouse-copier` 中的分段错误. [#4835](https://github.com/ClickHouse/ClickHouse/pull/4835) ([proller](https://github.com/proller))
-   如果表被重命名或同时更改, 则修复了来自 `system.tables` 的 `SELECT` 中的竞争条件. [#4836](https://github.com/ClickHouse/ClickHouse/pull/4836) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   在获取已经过时的数据部分时修复了数据竞争. [#4839](https://github.com/ClickHouse/ClickHouse/pull/4839) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   修复了 MergeTree 系列的 `RENAME` 表中可能发生的罕见数据竞争. [#4844](https://github.com/ClickHouse/ClickHouse/pull/4844) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   修复了函数 `arrayIntersect` 中的分段错误. 如果使用混合常量和普通参数调用函数, 可能会发生分段错误. [#4847](https://github.com/ClickHouse/ClickHouse/pull/4847) ([Lixiang Qian](https://github.com/fancyqlx))
-   当列包含一长串空数组时, 修复了在极少数情况下从 `Array(LowCardinality)` 列读取的问题. [#4850](https://github.com/ClickHouse/ClickHouse/pull/4850) ([Nikolai Kochetov](https://github.com/KochetovNicolai))
-   当我们加入可空与不可空时，, 修复 `FULL/RIGHT JOIN` 中的崩溃. [#4855](https://github.com/ClickHouse/ClickHouse/pull/4855) ([Artem Zuikov](https://github.com/4ertus2))
-   在副本之间获取部分时修复 `No message received` 异常. [#4856](https://github.com/ClickHouse/ClickHouse/pull/4856) ([alesapin](https://github.com/alesapin))
-   修复了在单个数组中有多个重复值的情况下`arrayIntersect`函数错误结果. [#4871](https://github.com/ClickHouse/ClickHouse/pull/4871) ([Nikolai Kochetov](https://github.com/KochetovNicolai))
-   修复并发 `ALTER COLUMN` 查询期间可能导致服务器崩溃的竞争条件 (修复问题 [#3421](https://github.com/ClickHouse/ClickHouse/issues/3421)). [#4592](https://github.com/ClickHouse/ClickHouse/pull/4592) ([Alex Zatelepin](https://github.com/ztlpn))
-   使用 const 列修复 `FULL/RIGHT JOIN` 中的错误结果. [#4723](https://github.com/ClickHouse/ClickHouse/pull/4723) ([Artem Zuikov](https://github.com/4ertus2))
-   用星号修复 `GLOBAL JOIN` 中的重复项. [#4705](https://github.com/ClickHouse/ClickHouse/pull/4705) ([Artem Zuikov](https://github.com/4ertus2))
-   修复未指定列类型时列 `CODEC` 的 `ALTER MODIFY` 中的参数推导. [#4883](https://github.com/ClickHouse/ClickHouse/pull/4883) ([alesapin](https://github.com/alesapin))
-   函数 `cutQueryStringAndFragment()` 和 `queryStringAndFragment()` 现在可以在 `URL` 包含片段且没有查询时正常工作. [#4894](https://github.com/ClickHouse/ClickHouse/pull/4894) ([Vitaly Baranov](https://github.com/vitlibar))
-   修复了设置 `min_bytes_to_use_direct_io` 大于零时的罕见错误，当线程必须在列文件中向后寻找时会发生这种情况. [#4897](https://github.com/ClickHouse/ClickHouse/pull/4897) ([alesapin](https://github.com/alesapin))
-   用 `LowCardinality` 参数修复聚合函数的错误参数类型 (修复问题 [#4919](https://github.com/ClickHouse/ClickHouse/issues/4919)). [#4922](https://github.com/ClickHouse/ClickHouse/pull/4922) ([Nikolai Kochetov](https://github.com/KochetovNicolai))
-   修复`GLOBAL JOIN`中的错误名称限定. [#4969](https://github.com/ClickHouse/ClickHouse/pull/4969) ([Artem Zuikov](https://github.com/4ertus2))
-   修正函数 `toISOWeek` 结果为1970年. [#4988](https://github.com/ClickHouse/ClickHouse/pull/4988) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   修复 `DROP`、`TRUNCATE` 和 `OPTIMIZE` 查询重复, 当在 `ON CLUSTER` 上为 `ReplicatedMergeTree*` 表族执行时. [#4991](https://github.com/ClickHouse/ClickHouse/pull/4991) ([alesapin](https://github.com/alesapin))

#### 向后不兼容更新 {#backward-incompatible-change-8}

-   将设置 `insert_sample_with_metadata` 重命名为设置 `input_format_defaults_for_omited_fields`. [#4771](https://github.com/ClickHouse/ClickHouse/pull/4771) ([Artem Zuikov](https://github.com/4ertus2))
-   添加了设置 `max_partitions_per_insert_block` (默认值为 100). 如果插入的块包含更多的分区, 则抛出异常. 如果要取消限制, 请将其设置为 0 (不推荐). [#4845](https://github.com/ClickHouse/ClickHouse/pull/4845) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   多重搜索功能被重命名 (`multiPosition` 到 `multiSearchAllPositions`, `multiSearch` 到 `multiSearchAny`, `firstMatch` 到 `multiSearchFirstIndex`). [#4780](https://github.com/ClickHouse/ClickHouse/pull/4780) ([Danila Kutenin](https://github.com/danlark1))

#### 性能改进 {#performance-improvement-6}

-   通过内联优化 Volnitsky 搜索器, 为具有许多针或许多相似二元组的查询提供大约 5-10% 的搜索改进. [#4862](https://github.com/ClickHouse/ClickHouse/pull/4862) ([Danila Kutenin](https://github.com/danlark1))
-   修复了当设置 `use_uncompressed_cache` 大于零时的性能问题, 当所有读取包含在缓存中的数据时出现 [#4913](https://github.com/ClickHouse/ClickHouse/pull/4913) ([alesapin](https://github.com/alesapin))

#### 构建/测试/打包改进 {#buildtestingpackaging-improvement-10}

-   强化调试构建: 更细粒度的内存映射和 ASLR; 为标记缓存和索引添加内存保护. 这允许在 ASan 和 MSan 无法执行的情况下找到更多内存踩踏错误. [#4632](https://github.com/ClickHouse/ClickHouse/pull/4632) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   添加对 cmake 变量 `ENABLE_PROTOBUF`、`ENABLE_PARQUET` 和`ENABLE_BROTLI` 的支持, 允许启用/禁用上述功能 (与我们对 librdkafka、mysql 等所做的一样). [#4669](https://github.com/ClickHouse/ClickHouse/pull/4669) ([Silviu Caragea](https://github.com/silviucpp))
-   如果在测试运行后挂起某些查询, 则添加打印所有线程的进程列表和堆栈跟踪的功能. [#4675](https://github.com/ClickHouse/ClickHouse/pull/4675) ([alesapin](https://github.com/alesapin))
-   在 `clickhouse-test` 中添加对 `Connection loss` 错误的重试. [#4682](https://github.com/ClickHouse/ClickHouse/pull/4682) ([alesapin](https://github.com/alesapin))
-   使用 vagrant 添加 freebsd 构建并使用线程清理器构建打包脚本. [#4712](https://github.com/ClickHouse/ClickHouse/pull/4712) [#4748](https://github.com/ClickHouse/ClickHouse/pull/4748) ([alesapin](https://github.com/alesapin))
-   现在用户在安装过程中要求用户 `default` 的密码. [#4725](https://github.com/ClickHouse/ClickHouse/pull/4725) ([proller](https://github.com/proller))
-   抑制 `rdkafka` 库中的警告. [#4740](https://github.com/ClickHouse/ClickHouse/pull/4740) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   允许在没有 ssl 的情况下构建. [#4750](https://github.com/ClickHouse/ClickHouse/pull/4750) ([proller](https://github.com/proller))
-   添加一种从自定义用户启动 clickhouse-server 图像的方法. [#4753](https://github.com/ClickHouse/ClickHouse/pull/4753) ([Mikhail f. Shiryaev](https://github.com/Felixoid))
-   将 contrib 升级到 1.69. [#4793](https://github.com/ClickHouse/ClickHouse/pull/4793) ([proller](https://github.com/proller))
-   使用 Thread Sanitizer 编译时禁用 `mremap`. 令人惊讶的是, TSan 没有拦截导致误报的 `mremap` (尽管它确实拦截了 `mmap`、`munmap`). 修复了状态测试中的 TSan 报告. [#4859](https://github.com/ClickHouse/ClickHouse/pull/4859) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   通过 HTTP 接口使用格式模式添加测试检查. [#4864](https://github.com/ClickHouse/ClickHouse/pull/4864) ([Vitaly Baranov](https://github.com/vitlibar))

## ClickHouse 版本 19.4 {#clickhouse-release-19-4}

### ClickHouse 版本 19.4.4.33, 2019-04-17 {#clickhouse-release-19-4-4-33-2019-04-17}

#### Bug 修复 {#bug-fixes-7}

-   在内存分配失败的情况下避免使用 `std::terminate`。 现在按预期抛出 `std::bad_alloc` 异常. [#4665](https://github.com/ClickHouse/ClickHouse/pull/4665) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   修复了从缓冲区读取 capnproto 的问题. 有时文件未通过 HTTP 成功加载. [#4674](https://github.com/ClickHouse/ClickHouse/pull/4674) ([Vladislav](https://github.com/smirnov-vs))
-   在 `OPTIMIZE TABLE FINAL` 查询后修复错误 `Unknown log entry type: 0` . [#4683](https://github.com/ClickHouse/ClickHouse/pull/4683) ([Amos Bird](https://github.com/amosbird))
-   `hasAny` 或 `hasAll` 函数的错误参数可能会导致段错误. [#4698](https://github.com/ClickHouse/ClickHouse/pull/4698) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   执行 `DROP DATABASE dictionary` 查询时可能发生死锁. [#4701](https://github.com/ClickHouse/ClickHouse/pull/4701) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   修复 `median` 和 `quantile` 函数中未定义的行为. [#4702](https://github.com/ClickHouse/ClickHouse/pull/4702) ([hcz](https://github.com/hczhcz))
-   修复 `network_compression_method` 为小写时的压缩级别检测. 在 v19.1 中损坏. [#4706](https://github.com/ClickHouse/ClickHouse/pull/4706) ([proller](https://github.com/proller))
-   修复了对 `<timezone>UTC</timezone>` 设置的无知 (修复了问题 [#4658](https://github.com/ClickHouse/ClickHouse/issues/4658)). [#4718](https://github.com/ClickHouse/ClickHouse/pull/4718) ([proller](https://github.com/proller))
-   使用 `Distributed` 表修复 `histogram` 函数行为. [#4741](https://github.com/ClickHouse/ClickHouse/pull/4741) ([olegkv](https://github.com/olegkv))
-   修复了 tsan 报告 `destroy of a locked mutex` 的问题. [#4742](https://github.com/ClickHouse/ClickHouse/pull/4742) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   修复了由于系统日志使用中的竞争条件而导致关闭的 TSan 报告. 修复了启用 part_log 时关闭时潜在的释放后使用问题. [#4758](https://github.com/ClickHouse/ClickHouse/pull/4758) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   修复 `ReplicatedMergeTreeAlterThread` 中的重新检查部分以防出错. [#4772](https://github.com/ClickHouse/ClickHouse/pull/4772) ([Nikolai Kochetov](https://github.com/KochetovNicolai))
-   中间聚合函数状态的算术运算不适用于常量参数 (例如子查询结果). [#4776](https://github.com/ClickHouse/ClickHouse/pull/4776) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   始终在元数据中反引用列名称. 否则不可能创建一个名为 `index` 的列的表 (由于元数据中的`ATTACH`查询格式错误, 服务器不会重启). [#4782](https://github.com/ClickHouse/ClickHouse/pull/4782) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   修复 `Distributed` 表上的 `ALTER ... MODIFY ORDER BY` 崩溃. [#4790](https://github.com/ClickHouse/ClickHouse/pull/4790) ([TCeason](https://github.com/TCeason))
-   修复了启用 `enable_optimize_predicate_expression` 的 `JOIN ON` 中段错误. [#4794](https://github.com/ClickHouse/ClickHouse/pull/4794) ([Winter Zhang](https://github.com/zhang2014))
-   使用来自 Kafka 的 protobuf 消息后通过添加无关行来修复错误. [#4808](https://github.com/ClickHouse/ClickHouse/pull/4808) ([Vitaly Baranov](https://github.com/vitlibar))
-   修复 `clickhouse-copier` 中的分段错误. [#4835](https://github.com/ClickHouse/ClickHouse/pull/4835) ([proller](https://github.com/proller))
-   如果表被重命名或同时更改, 则修复了来自 `system.tables` 的 `SELECT` 中的竞争条件. [#4836](https://github.com/ClickHouse/ClickHouse/pull/4836) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   在获取已经过时的数据部分时修复了数据竞争. [#4839](https://github.com/ClickHouse/ClickHouse/pull/4839) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   修复了 MergeTree 系列的 `RENAME` 表中可能发生的罕见数据竞争. [#4844](https://github.com/ClickHouse/ClickHouse/pull/4844) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   修复了函数 `arrayIntersect` 中的分段错误. Segmentation fault could happen if function was called with mixed constant and ordinary arguments. [#4847](https://github.com/ClickHouse/ClickHouse/pull/4847) ([Lixiang Qian](https://github.com/fancyqlx))
-   当列包含一长串空数组时, 修复了在极少数情况下从 `Array(LowCardinality)` 列读取的问题. [#4850](https://github.com/ClickHouse/ClickHouse/pull/4850) ([Nikolai Kochetov](https://github.com/KochetovNicolai))
-   在副本之间获取部分时修复 `No message received` 异常. [#4856](https://github.com/ClickHouse/ClickHouse/pull/4856) ([alesapin](https://github.com/alesapin))
-   修复了在单个数组中有多个重复值的情况下`arrayIntersect`函数错误结果. [#4871](https://github.com/ClickHouse/ClickHouse/pull/4871) ([Nikolai Kochetov](https://github.com/KochetovNicolai))
-   修复并发 `ALTER COLUMN` 查询期间可能导致服务器崩溃的竞争条件 (修复问题 [#3421](https://github.com/ClickHouse/ClickHouse/issues/3421)). [#4592](https://github.com/ClickHouse/ClickHouse/pull/4592) ([Alex Zatelepin](https://github.com/ztlpn))
-   修复未指定列类型时列 `CODEC` 的 `ALTER MODIFY` 中的参数推导. [#4883](https://github.com/ClickHouse/ClickHouse/pull/4883) ([alesapin](https://github.com/alesapin))
-   函数 `cutQueryStringAndFragment()` 和 `queryStringAndFragment()` 现在可以在 `URL` 包含片段且没有查询时正常工作. [#4894](https://github.com/ClickHouse/ClickHouse/pull/4894) ([Vitaly Baranov](https://github.com/vitlibar))
-   修复了设置 `min_bytes_to_use_direct_io` 大于零时的罕见错误，当线程必须在列文件中向后寻找时会发生这种情况. [#4897](https://github.com/ClickHouse/ClickHouse/pull/4897) ([alesapin](https://github.com/alesapin))
-   使用 `LowCardinality` 参数修复聚合函数的错误参数类型 (修复问题 [#4919](https://github.com/ClickHouse/ClickHouse/issues/4919)). [#4922](https://github.com/ClickHouse/ClickHouse/pull/4922) ([Nikolai Kochetov](https://github.com/KochetovNicolai))
-   修正函数 `toISOWeek` 结果为1970年. [#4988](https://github.com/ClickHouse/ClickHouse/pull/4988) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   修复 `DROP`、`TRUNCATE` 和 `OPTIMIZE` 查询重复，当在 `ON CLUSTER` 上为 `ReplicatedMergeTree*` 表族执行时. [#4991](https://github.com/ClickHouse/ClickHouse/pull/4991) ([alesapin](https://github.com/alesapin))

#### 改进 {#improvements-2}

-   将普通、`DEFAULT`、`MATERIALIZED` 和`ALIAS` 列保留在一个列表中 (修复问题 [#2867](https://github.com/ClickHouse/ClickHouse/issues/2867)). [#4707](https://github.com/ClickHouse/ClickHouse/pull/4707) ([Alex Zatelepin](https://github.com/ztlpn))

### ClickHouse 版本 19.4.3.11, 2019-04-02 {#clickhouse-release-19-4-3-11-2019-04-02}

#### Bug 修复 {#bug-fixes-8}

-   当我们加入可空与不可空时, 修复 `FULL/RIGHT JOIN` 中的崩溃. [#4855](https://github.com/ClickHouse/ClickHouse/pull/4855) ([Artem Zuikov](https://github.com/4ertus2))
-   修复 `clickhouse-copier` 中的分段错误. [#4835](https://github.com/ClickHouse/ClickHouse/pull/4835) ([proller](https://github.com/proller))

#### 构建/测试/打包改进 {#buildtestingpackaging-improvement-11}

-   Add a way to launch clickhouse-server image from a custom user. [#4753](https://github.com/ClickHouse/ClickHouse/pull/4753) ([Mikhail f. Shiryaev](https://github.com/Felixoid))

### ClickHouse 版本 19.4.2.7, 2019-03-30 {#clickhouse-release-19-4-2-7-2019-03-30}

#### Bug 修复 {#bug-fixes-9}

-   当列包含一长串空数组时, 修复了在极少数情况下从 `Array(LowCardinality)` 列读取的问题. [#4850](https://github.com/ClickHouse/ClickHouse/pull/4850) ([Nikolai Kochetov](https://github.com/KochetovNicolai))

### ClickHouse 版本 19.4.1.3, 2019-03-19 {#clickhouse-release-19-4-1-3-2019-03-19}

#### Bug 修复 {#bug-fixes-10}

-   修复了同时包含`LIMIT BY` 和`LIMIT` 的远程查询. 以前, 如果使用 `LIMIT BY` 和 `LIMIT` 进行远程查询, `LIMIT`可能发生在`LIMIT BY`之前, 导致过滤结果过分. [#4708](https://github.com/ClickHouse/ClickHouse/pull/4708) ([Constantin S. Pan](https://github.com/kvap))

### ClickHouse 版本 19.4.0.49, 2019-03-09 {#clickhouse-release-19-4-0-49-2019-03-09}

#### 新特征 {#new-features-5}

-   添加了对 `Protobuf` 格式的完全支持 (输入和输出, 嵌套数据结构). [#4174](https://github.com/ClickHouse/ClickHouse/pull/4174) [#4493](https://github.com/ClickHouse/ClickHouse/pull/4493) ([Vitaly Baranov](https://github.com/vitlibar))
-   使用 Roaring Bitmaps 添加位图功能. [#4207](https://github.com/ClickHouse/ClickHouse/pull/4207) ([Andy Yang](https://github.com/andyyzh)) [#4568](https://github.com/ClickHouse/ClickHouse/pull/4568) ([Vitaly Baranov](https://github.com/vitlibar))
-   Parquet 格式支持. [#4448](https://github.com/ClickHouse/ClickHouse/pull/4448) ([proller](https://github.com/proller))
-   添加了 N-gram 距离以进行模糊字符串比较. 它类似于 R 语言中的 q-gram 度量. [#4466](https://github.com/ClickHouse/ClickHouse/pull/4466) ([Danila Kutenin](https://github.com/danlark1))
-   从专用的聚合和保留模式中组合石墨聚合规则. [#4426](https://github.com/ClickHouse/ClickHouse/pull/4426) ([Mikhail f. Shiryaev](https://github.com/Felixoid))
-   添加了 `max_execution_speed` 和 `max_execution_speed_bytes` 以限制资源使用. 添加了`min_execution_speed_bytes`设置以补充`min_execution_speed`. [#4430](https://github.com/ClickHouse/ClickHouse/pull/4430) ([Winter Zhang](https://github.com/zhang2014))
-   实现的函数`flatten`. [#4555](https://github.com/ClickHouse/ClickHouse/pull/4555) [#4409](https://github.com/ClickHouse/ClickHouse/pull/4409) ([alexey-milovidov](https://github.com/alexey-milovidov), [kzon](https://github.com/kzon))
-   添加了函数 `arrayEnumerateDenseRanked` 和 `arrayEnumerateUniqRanked` (类似于 `arrayEnumerateUniq`, 但允许微调数组深度以查看多维数组内部). [#4475](https://github.com/ClickHouse/ClickHouse/pull/4475) ([proller](https://github.com/proller)) [#4601](https://github.com/ClickHouse/ClickHouse/pull/4601) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   有一些限制的多个 JOINS: 没有星号, 在 ON/WHERE/GROUP BY/... 中没有复杂的别名. [#4462](https://github.com/ClickHouse/ClickHouse/pull/4462) ([Artem Zuikov](https://github.com/4ertus2))

#### Bug 修复 {#bug-fixes-11}

-   此版本还包含 19.3 和 19.1 的所有错误修复.
-   修复了数据跳过索引中的错误: INSERT 后的颗粒顺序不正确. [#4407](https://github.com/ClickHouse/ClickHouse/pull/4407) ([Nikita Vasilev](https://github.com/nikvas0))
-   修复了 `Nullable` 和 `LowCardinality` 列的 `set` 索引. 在此之前, 带有 `Nullable` 或 `LowCardinality` 列的 `set` 索引在选择时导致错误 `Data type must be deserialized with multiple streams` . [#4594](https://github.com/ClickHouse/ClickHouse/pull/4594) ([Nikolai Kochetov](https://github.com/KochetovNicolai))
-   在完整的 `executable` 字典更新时正确设置 update_time. [#4551](https://github.com/ClickHouse/ClickHouse/pull/4551) ([Tema Novikov](https://github.com/temoon))
-   修复 19.3 中损坏的进度条. [#4627](https://github.com/ClickHouse/ClickHouse/pull/4627) ([filimonov](https://github.com/filimonov))
-   修复了在某些情况下内存区域缩小时 MemoryTracker 不一致的值. [#4619](https://github.com/ClickHouse/ClickHouse/pull/4619) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   修复了 ThreadPool 中未定义的行为. [#4612](https://github.com/ClickHouse/ClickHouse/pull/4612) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   修复了一个非常罕见的崩溃, 消息 `mutex lock failed: Invalid argument` 可能发生在 MergeTree 表与 SELECT 同时删除时. [#4608](https://github.com/ClickHouse/ClickHouse/pull/4608) ([Alex Zatelepin](https://github.com/ztlpn))
-   ODBC 驱动程序与 `LowCardinality` 数据类型兼容. [#4381](https://github.com/ClickHouse/ClickHouse/pull/4381) ([proller](https://github.com/proller))
-   FreeBSD: `AIOcontextPool: Found io_event with unknown id 0` 错误的修复. [#4438](https://github.com/ClickHouse/ClickHouse/pull/4438) ([urgordeadbeef](https://github.com/urgordeadbeef))
-   `system.part_log` 表的创建与配置无关. [#4483](https://github.com/ClickHouse/ClickHouse/pull/4483) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   复缓存字典的 `dictIsIn` 函数中未定义的行为. [#4515](https://github.com/ClickHouse/ClickHouse/pull/4515) ([alesapin](https://github.com/alesapin))
-   修复了当 SELECT 查询多次锁定同一个表 (例如来自不同线程或执行多个子查询时) 并且存在并发 DDL 查询时的死锁. [#4535](https://github.com/ClickHouse/ClickHouse/pull/4535) ([Alex Zatelepin](https://github.com/ztlpn))
-   默认情况下禁用 compile_expressions 直到我们获得自己的 `llvm` contrib 并且可以使用 `clang` 和 `asan` 对其进行测试. [#4579](https://github.com/ClickHouse/ClickHouse/pull/4579) ([alesapin](https://github.com/alesapin))
-   `clickhouse` 外部字典源的 `invalidate_query` 返回错误的结果集 (空或多于一行或多于一列) 时, 防止 `std::terminate`. 修复了每五秒执行一次 `invalidate_query` 的问题, 而不管 `lifetime`. [#4583](https://github.com/ClickHouse/ClickHouse/pull/4583) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   当具有 `clickhouse` 源的字典的 `invalidate_query` 涉及 `system.dictionaries` 表或 `Dictionaries` 数据库时, 避免死锁 (罕见情况). [#4599](https://github.com/ClickHouse/ClickHouse/pull/4599) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   修复了 WHERE 为空的 CROSS JOIN. [#4598](https://github.com/ClickHouse/ClickHouse/pull/4598) ([Artem Zuikov](https://github.com/4ertus2))
-   修复了传递常量参数时函数 `replicate` 中的段错误. [#4603](https://github.com/ClickHouse/ClickHouse/pull/4603) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   使用谓词优化器修复 lambda 函数. [#4408](https://github.com/ClickHouse/ClickHouse/pull/4408) ([Winter Zhang](https://github.com/zhang2014))
-   多个连接多个修复. [#4595](https://github.com/ClickHouse/ClickHouse/pull/4595) ([Artem Zuikov](https://github.com/4ertus2))

#### 改进 {#improvements-3}

-   支持右表列的 JOIN ON 部分中的别名. [#4412](https://github.com/ClickHouse/ClickHouse/pull/4412) ([Artem Zuikov](https://github.com/4ertus2))
-   多个 JOIN 的结果需要在子选择中使用正确的结果名称. 在结果中用源名称替换平面别名. [#4474](https://github.com/ClickHouse/ClickHouse/pull/4474) ([Artem Zuikov](https://github.com/4ertus2))
-   改进连接语句的下推逻辑. [#4387](https://github.com/ClickHouse/ClickHouse/pull/4387) ([Ivan](https://github.com/abyss7))

#### 性能改进 {#performance-improvements-3}

-   改进了 `move to PREWHERE` 优化的启发式方法. [#4405](https://github.com/ClickHouse/ClickHouse/pull/4405) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   使用适当的查找表, 使用 HashTable 的 API 获取 8 位和 16 位密钥. [#4536](https://github.com/ClickHouse/ClickHouse/pull/4536) ([Amos Bird](https://github.com/amosbird))
-   改进了字符串比较的性能. [#4564](https://github.com/ClickHouse/ClickHouse/pull/4564) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   在单独的线程中清理分布式 DDL 队列, 使其不会减慢处理分布式 DDL 任务的主循环. [#4502](https://github.com/ClickHouse/ClickHouse/pull/4502) ([Alex Zatelepin](https://github.com/ztlpn))
-   当 `min_bytes_to_use_direct_io` 设置为 1 时, 并不是每个文件都以 O_DIRECT 模式打开, 因为读取的数据大小有时会被一个压缩块的大小低估. [#4526](https://github.com/ClickHouse/ClickHouse/pull/4526) ([alexey-milovidov](https://github.com/alexey-milovidov))

#### 构建/测试/打包改进 {#buildtestingpackaging-improvement-12}

-   添加了对 clang-9 的支持. [#4604](https://github.com/ClickHouse/ClickHouse/pull/4604) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   修复错误的 `__asm__` 指令 (再次). [#4621](https://github.com/ClickHouse/ClickHouse/pull/4621) ([Konstantin Podshumok](https://github.com/podshumok))
-   添加从命令行指定 `clickhouse-performance-test` 设置的功能. [#4437](https://github.com/ClickHouse/ClickHouse/pull/4437) ([alesapin](https://github.com/alesapin))
-   将字典测试添加到集成测试. [#4477](https://github.com/ClickHouse/ClickHouse/pull/4477) ([alesapin](https://github.com/alesapin))
-   将来自网站基准测试的查询添加到自动化性能测试中. [#4496](https://github.com/ClickHouse/ClickHouse/pull/4496) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   `xxhash.h` 在外部 lz4 中不存在, 因为它是一个实现细节, 它的符号使用 `XXH_NAMESPACE` 宏命名. 当 lz4 是外部的时, xxHash 也必须是外部的, 并且依赖项必须链接到它. [#4495](https://github.com/ClickHouse/ClickHouse/pull/4495) ([Orivej Desh](https://github.com/orivej))
-   修复了可以使用负数或浮点参数调用 `quantileTiming` 聚合函数的情况 (这修复了使用未定义行为清理器的模糊测试). [#4506](https://github.com/ClickHouse/ClickHouse/pull/4506) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   拼写错误更正. [#4531](https://github.com/ClickHouse/ClickHouse/pull/4531) ([sdk2](https://github.com/sdk2))
-   修复 Mac 上的编译. [#4371](https://github.com/ClickHouse/ClickHouse/pull/4371) ([Vitaly Baranov](https://github.com/vitlibar))
-   为 FreeBSD 和各种不寻常的构建配置构建修复. [#4444](https://github.com/ClickHouse/ClickHouse/pull/4444) ([proller](https://github.com/proller))

## ClickHouse 版本 19.3 {#clickhouse-release-19-3}

### ClickHouse 版本 19.3.9.1, 2019-04-02 {#clickhouse-release-19-3-9-1-2019-04-02}

#### Bug 修复 {#bug-fixes-12}

-   当我们加入可空与不可空时, 修复 `FULL/RIGHT JOIN` 中的崩溃. [#4855](https://github.com/ClickHouse/ClickHouse/pull/4855) ([Artem Zuikov](https://github.com/4ertus2))
-   修复 `clickhouse-copier` 中的分段错误. [#4835](https://github.com/ClickHouse/ClickHouse/pull/4835) ([proller](https://github.com/proller))
-   当列包含一长串空数组时, 修复了在极少数情况下从 `Array(LowCardinality)` 列读取的问题. [#4850](https://github.com/ClickHouse/ClickHouse/pull/4850) ([Nikolai Kochetov](https://github.com/KochetovNicolai))

#### 构建/测试/打包改进 {#buildtestingpackaging-improvement-13}

-   添加一种从自定义用户启动 clickhouse-server 图像的方法. [#4753](https://github.com/ClickHouse/ClickHouse/pull/4753) ([Mikhail f. Shiryaev](https://github.com/Felixoid))

### ClickHouse 版本 19.3.7, 2019-03-12 {#clickhouse-release-19-3-7-2019-03-12}

#### Bug 修复 {#bug-fixes-13}

-   修复了 #3920 中的错误。 此错误表现为随机缓存损坏 (消息 `Unknown codec family code`, `Cannot seek through file` ) 和段错误. 此错误首先出现在 19.1 版本中, 并存在于 19.1.10 和 19.3.6 之前的版本中. [#4623](https://github.com/ClickHouse/ClickHouse/pull/4623) ([alexey-milovidov](https://github.com/alexey-milovidov))

### ClickHouse 版本 19.3.6, 2019-03-02 {#clickhouse-release-19-3-6-2019-03-02}

#### Bug 修复 {#bug-fixes-14}

-   当线程池中的线程超过1000个时, 线程退出可能会发生`std::terminate`. [Azat Khuzhin](https://github.com/azat) [#4485](https://github.com/ClickHouse/ClickHouse/pull/4485) [#4505](https://github.com/ClickHouse/ClickHouse/pull/4505) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   现在可以创建带有注释的 `ReplicatedMergeTree*` 表，没有默认值的列和带有没有注释和默认值的列编解码器的表. 还修复了编解码器的比较. [#4523](https://github.com/ClickHouse/ClickHouse/pull/4523) ([alesapin](https://github.com/alesapin))
-   修复了使用数组或元组 JOIN 时的崩溃. [#4552](https://github.com/ClickHouse/ClickHouse/pull/4552) ([Artem Zuikov](https://github.com/4ertus2))
-   修复了 clickhouse-copier 崩溃并显示消息 `ThreadStatus not created` . [#4540](https://github.com/ClickHouse/ClickHouse/pull/4540) ([Artem Zuikov](https://github.com/4ertus2))
-   修复了使用分布式ddl时服务器关闭时的挂起问题. [#4472](https://github.com/ClickHouse/ClickHouse/pull/4472) ([Alex Zatelepin](https://github.com/ztlpn))
-   错误消息中打印了不正确的列号, 该错误消息是对编号大于 10 的列进行文本格式解析. [#4484](https://github.com/ClickHouse/ClickHouse/pull/4484) ([alexey-milovidov](https://github.com/alexey-milovidov))

#### 构建/测试/打包改进 {#buildtestingpackaging-improvements-3}

-   修复了启用 AVX 的构建. [#4527](https://github.com/ClickHouse/ClickHouse/pull/4527) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   用基于已知版本而不是编译它的内核的扩展记帐和 IO 记帐. [#4541](https://github.com/ClickHouse/ClickHouse/pull/4541) ([nvartolomei](https://github.com/nvartolomei))
-   用基于已知版本而不是合成它的知识的扩展记录帐和 IO. [#4473](https://github.com/ClickHouse/ClickHouse/pull/4473) ([proller](https://github.com/proller))
-   删除了 `Field.cpp` 中 `void readBinary(...)` 的 `inline` 标签. 还合并了冗余的 `namespace DB` 块. [#4530](https://github.com/ClickHouse/ClickHouse/pull/4530) ([hcz](https://github.com/hczhcz))

### ClickHouse 版本 19.3.5, 2019-02-21 {#clickhouse-release-19-3-5-2019-02-21}

#### Bug 修复 {#bug-fixes-15}

-   修复了大型 http 插入查询处理的错误. [#4454](https://github.com/ClickHouse/ClickHouse/pull/4454) ([alesapin](https://github.com/alesapin))
-   修复了由于 `send_logs_level` 设置的错误实现而导致的与旧版本的向后不兼容. [#4445](https://github.com/ClickHouse/ClickHouse/pull/4445) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   修复了使用列注释引入的表函数`remote` 向后不兼容的问题. [#4446](https://github.com/ClickHouse/ClickHouse/pull/4446) ([alexey-milovidov](https://github.com/alexey-milovidov))

### ClickHouse 版本 19.3.4, 2019-02-16 {#clickhouse-release-19-3-4-2019-02-16}

#### 改进 {#improvements-4}

-   当执行 `ATTACH Table` 查询时, 表索引大小不考虑内存限制. 避免了表被分离后无法被附加的可能性. [#4396](https://github.com/ClickHouse/ClickHouse/pull/4396) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   稍微提高了从 ZooKeeper 接收的最大字符串和数组大小的限制. 它允许继续使用 ZooKeeper 上增加的 `CLIENT_JVMFLAGS=-Djute.maxbuffer=...` 大小. [#4398](https://github.com/ClickHouse/ClickHouse/pull/4398) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   允许修复废弃的副本, 即使它的队列中已经有大量节点. [#4399](https://github.com/ClickHouse/ClickHouse/pull/4399) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   向`SET`索引添加一个必需参数 (最大存储行数). [#4386](https://github.com/ClickHouse/ClickHouse/pull/4386) ([Nikita Vasilev](https://github.com/nikvas0))

#### Bug 修复 {#bug-fixes-16}

-   修复了按单个 `LowCardinality` 键分组的 `WITH ROLLUP` 结果. [#4384](https://github.com/ClickHouse/ClickHouse/pull/4384) ([Nikolai Kochetov](https://github.com/KochetovNicolai))
-   修复了集合索引中的错误 (如果包含超过 `max_rows` 行，则删除一个粒度). [#4386](https://github.com/ClickHouse/ClickHouse/pull/4386) ([Nikita Vasilev](https://github.com/nikvas0))
-   许多 FreeBSD 构建修复. [#4397](https://github.com/ClickHouse/ClickHouse/pull/4397) ([proller](https://github.com/proller))
-   使用包含相同别名的子查询修复了查询中的别名替换 (问题 [#4110](https://github.com/ClickHouse/ClickHouse/issues/4110)). [#4351](https://github.com/ClickHouse/ClickHouse/pull/4351) ([Artem Zuikov](https://github.com/4ertus2))

#### 构建/测试/打包改进 {#buildtestingpackaging-improvements-4}

-   添加在 docker 镜像中运行 `clickhouse-server` 以进行无状态测试的能力. [#4347](https://github.com/ClickHouse/ClickHouse/pull/4347) ([Vasily Nemkov](https://github.com/Enmk))

### ClickHouse 版本 19.3.3, 2019-02-13 {#clickhouse-release-19-3-3-2019-02-13}

#### 新特征 {#new-features-6}

-   添加了 `KILL MUTATION` 语句，允许删除由于某些原因卡住的突变。 将 `latest_failed_part`、`latest_fail_time`、`latest_fail_reason` 字段添加到 `system.mutations` 表中，以便于故障排除. [#4287](https://github.com/ClickHouse/ClickHouse/pull/4287) ([Alex Zatelepin](https://github.com/ztlpn))
-   添加了计算信息熵的聚合函数 `entropy` . [#4238](https://github.com/ClickHouse/ClickHouse/pull/4238) ([Quid37](https://github.com/Quid37))
-   添加了向服务器发送查询 `INSERT INTO tbl VALUES (....)` 的功能, 而无需拆分 `query` 和 `data` 部分. [#4301](https://github.com/ClickHouse/ClickHouse/pull/4301) ([alesapin](https://github.com/alesapin))
-   添加了 `arrayWithConstant` 函数的通用实现. [#4322](https://github.com/ClickHouse/ClickHouse/pull/4322) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   实现了`NOT BETWEEN`比较运算符. [#4228](https://github.com/ClickHouse/ClickHouse/pull/4228) ([Dmitry Naumov](https://github.com/nezed))
-   实现 `sumMapFiltered` 以便能够限制 `sumMap` 对其值求和的键的数量. [#4129](https://github.com/ClickHouse/ClickHouse/pull/4129) ([Léo Ercolanelli](https://github.com/ercolanelli-leo))
-   在 `mysql` 表函数中添加了对 `Nullable` 类型的支持. [#4198](https://github.com/ClickHouse/ClickHouse/pull/4198) ([Emmanuel Donin de Rosière](https://github.com/edonin))
-   支持 `LIMIT` 子句中的任意常量表达式. [#4246](https://github.com/ClickHouse/ClickHouse/pull/4246) ([k3box](https://github.com/k3box))
-   添加了 `topKWeighted` 聚合函数, 该函数采用带 (无符号整数) 权重的附加参数. [#4245](https://github.com/ClickHouse/ClickHouse/pull/4245) ([Andrew Golman](https://github.com/andrewgolman))
-   `StorageJoin` 现在支持 `join_any_take_last_row` 设置, 允许覆盖相同键的现有值. [#3973](https://github.com/ClickHouse/ClickHouse/pull/3973) ([Amos Bird](https://github.com/amosbird)
-   添加函数 `toStartOfInterval` . [#4304](https://github.com/ClickHouse/ClickHouse/pull/4304) ([Vitaly Baranov](https://github.com/vitlibar))
-   添加了 `RowBinaryWithNamesAndTypes` 格式. [#4200](https://github.com/ClickHouse/ClickHouse/pull/4200) ([Oleg V. Kozlyuk](https://github.com/DarkWanderer))
-   添加了 `IPv4` 和 `IPv6` 数据类型. 更有效地实现 `IPv*` 功能. [#3669](https://github.com/ClickHouse/ClickHouse/pull/3669) ([Vasily Nemkov](https://github.com/Enmk))
-   添加函数 `toStartOfTenMinutes()`. [#4298](https://github.com/ClickHouse/ClickHouse/pull/4298) ([Vitaly Baranov](https://github.com/vitlibar))
-   添加了 `Protobuf` 输出格式. [#4005](https://github.com/ClickHouse/ClickHouse/pull/4005) [#4158](https://github.com/ClickHouse/ClickHouse/pull/4158) ([Vitaly Baranov](https://github.com/vitlibar))
-   为数据导入的 HTTP 接口添加了 brotli 支持 (插入). [#4235](https://github.com/ClickHouse/ClickHouse/pull/4235) ([Mikhail](https://github.com/fandyushin))
-   添加了用户在函数名称中输入拼写错误或在命令行客户端中输入时的提示. [#4239](https://github.com/ClickHouse/ClickHouse/pull/4239) ([Danila Kutenin](https://github.com/danlark1))
-   将 `Query-Id` 添加到服务器的 HTTP 响应标头. [#4231](https://github.com/ClickHouse/ClickHouse/pull/4231) ([Mikhail](https://github.com/fandyushin))

#### 实验功能 {#experimental-features-2}

-   为 MergeTree 表引擎系列添加了 `minmax` 和 `set` 数据跳过索引. [#4143](https://github.com/ClickHouse/ClickHouse/pull/4143) ([Nikita Vasilev](https://github.com/nikvas0))
-   如果可能, 添加了 `CROSS JOIN` 到 `INNER JOIN` 的转换. [#4221](https://github.com/ClickHouse/ClickHouse/pull/4221) [#4266](https://github.com/ClickHouse/ClickHouse/pull/4266) ([Artem Zuikov](https://github.com/4ertus2))

#### Bug 修复 {#bug-fixes-17}

-   修复了 `JOIN ON` 部分中重复列的 `Not found column` . [#4279](https://github.com/ClickHouse/ClickHouse/pull/4279) ([Artem Zuikov](https://github.com/4ertus2))
-   使 `START REPLICATED SENDS` 命令开始复制发送. [#4229](https://github.com/ClickHouse/ClickHouse/pull/4229) ([nvartolomei](https://github.com/nvartolomei))
-   使用 `Array(LowCardinality)` 参数修复了聚合函数的执行. [#4055](https://github.com/ClickHouse/ClickHouse/pull/4055) ([KochetovNicolai](https://github.com/KochetovNicolai))
-   修复了在执行 `INSERT ... SELECT ... FROM file(...)` 查询和文件具有 `CSVWithNames` 或 `TSVWIthNames` 格式并且缺少第一个数据行时的错误行为. [#4297](https://github.com/ClickHouse/ClickHouse/pull/4297) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   修复了字典不可用时重新加载字典时崩溃的问题. 这个bug出现在19.1.6. [#4188](https://github.com/ClickHouse/ClickHouse/pull/4188) ([proller](https://github.com/proller))
-   修复了右表中有重复项的 `ALL JOIN` . [#4184](https://github.com/ClickHouse/ClickHouse/pull/4184) ([Artem Zuikov](https://github.com/4ertus2))
-   修复了 `use_uncompressed_cache=1` 的分段错误和错误未压缩大小的异常. 这个bug出现在19.1.6. [#4186](https://github.com/ClickHouse/ClickHouse/pull/4186) ([alesapin](https://github.com/alesapin))
-   修复了 `compile_expressions` 与大 (超过 int16) 日期比较的错误. [#4341](https://github.com/ClickHouse/ClickHouse/pull/4341) ([alesapin](https://github.com/alesapin))
-   从表函数 `numbers(0)` 中选择时修复了无限循环. [#4280](https://github.com/ClickHouse/ClickHouse/pull/4280) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   暂时禁用 `ORDER BY` 的谓词优化. [#3890](https://github.com/ClickHouse/ClickHouse/pull/3890) ([Winter Zhang](https://github.com/zhang2014))
-   修复了在旧 CPU 上使用 base64 函数时的 `Illegal instruction` 错误. 仅在使用 gcc-8 编译 ClickHouse 时才重现此错误. [#4275](https://github.com/ClickHouse/ClickHouse/pull/4275) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   修复了通过 TLS 连接与 PostgreSQL ODBC 驱动程序交互时的 `No message received` 错误. 还修复了使用 MySQL ODBC 驱动程序时的段错误. [#4170](https://github.com/ClickHouse/ClickHouse/pull/4170) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   修复了在条件运算符 (函数 `if`) 的分支中使用 `Date` 和 `DateTime` 参数时不正确的结果. 为函数 `if` 添加了通用情况. [#4243](https://github.com/ClickHouse/ClickHouse/pull/4243) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   ClickHouse 词典现在在 `clickhouse` 进程中加载. [#4166](https://github.com/ClickHouse/ClickHouse/pull/4166) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   修复了在 `No such file or directory` 错误后重试带有 `File` 引擎的表中的 `SELECT` 时的死锁. [#4161](https://github.com/ClickHouse/ClickHouse/pull/4161) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   修复了从 `system.tables` 中选择时的竞争条件可能会出现 `table does not exist` 错误. [#4313](https://github.com/ClickHouse/ClickHouse/pull/4313) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   如果以交互模式运行, `clickhouse-client` 可以在退出时加载命令行建议数据时出现段错误. [#4317](https://github.com/ClickHouse/ClickHouse/pull/4317) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   修复了执行包含 `IN` 运算符的突变时产生错误结果的错误. [#4099](https://github.com/ClickHouse/ClickHouse/pull/4099) ([Alex Zatelepin](https://github.com/ztlpn))
-   修复错误: 如果有一个带有 `Dictionary` 引擎的数据库, 所有词典都在服务器启动时强制加载, 如果有来自localhost的带有ClickHouse源的词典, 则该词典无法加载. [#4255](https://github.com/ClickHouse/ClickHouse/pull/4255) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   修复了在服务器关闭时尝试再次创建系统日志时的错误. [#4254](https://github.com/ClickHouse/ClickHouse/pull/4254) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   正确返回正确的类型并正确处理 `joinGet` 函数中的锁. [#4153](https://github.com/ClickHouse/ClickHouse/pull/4153) ([Amos Bird](https://github.com/amosbird))
-   添加了 `sumMapWithOverflow` 函数. [#4151](https://github.com/ClickHouse/ClickHouse/pull/4151) ([Léo Ercolanelli](https://github.com/ercolanelli-leo))
-   使用 `allow_experimental_multiple_joins_emulation` 修复段错误. [52de2c](https://github.com/ClickHouse/ClickHouse/commit/52de2cd927f7b5257dd67e175f0a5560a48840d0) ([Artem Zuikov](https://github.com/4ertus2))
-   修复了错误的 `Date` 和`DateTime` 比较错误. [#4237](https://github.com/ClickHouse/ClickHouse/pull/4237) ([valexey](https://github.com/valexey))
-   修复了未定义行为消毒剂下的模糊测试: 添加了对 `quantile*Weighted` 系列函数的参数类型检查. [#4145](https://github.com/ClickHouse/ClickHouse/pull/4145) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   修复了删除旧数据部分可能会因 `File not found`  错误而失败时的罕见竞争条件. [#4378](https://github.com/ClickHouse/ClickHouse/pull/4378) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   修复缺少 /etc/clickhouse-server/config.xml 的安装包. [#4343](https://github.com/ClickHouse/ClickHouse/pull/4343) ([proller](https://github.com/proller))

#### 构建/测试/打包改进 {#buildtestingpackaging-improvements-5}

-   Debian 软件包: 根据配置更正 /etc/clickhouse-server/preprocessed 链接. [#4205](https://github.com/ClickHouse/ClickHouse/pull/4205) ([proller](https://github.com/proller))
-   FreeBSD 的各种构建修复. [#4225](https://github.com/ClickHouse/ClickHouse/pull/4225) ([proller](https://github.com/proller))
-   添加了在 perftest 中创建、填充和删除表格的功能. [#4220](https://github.com/ClickHouse/ClickHouse/pull/4220) ([alesapin](https://github.com/alesapin))
-   添加了一个脚本来检查重复的包含. [#4326](https://github.com/ClickHouse/ClickHouse/pull/4326) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   添加了在性能测试中按索引运行查询的功能. [#4264](https://github.com/ClickHouse/ClickHouse/pull/4264) ([alesapin](https://github.com/alesapin))
-   建议安装带有调试符号的包. [#4274](https://github.com/ClickHouse/ClickHouse/pull/4274) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   重构性能测试. 更好的日志记录和信号处理. [#4171](https://github.com/ClickHouse/ClickHouse/pull/4171) ([alesapin](https://github.com/alesapin))
-   向匿名化的 Yandex.Metrika 数据集添加了文档. [#4164](https://github.com/ClickHouse/ClickHouse/pull/4164) ([alesapin](https://github.com/alesapin))
-   Аdded 工具, 用于将旧的月份分区部分转换为自定义分区格式. [#4195](https://github.com/ClickHouse/ClickHouse/pull/4195) ([Alex Zatelepin](https://github.com/ztlpn))
-   在 s3 中添加了关于两个数据集的文档. [#4144](https://github.com/ClickHouse/ClickHouse/pull/4144) ([alesapin](https://github.com/alesapin))
-   添加了从拉取请求描述创建变更日志的脚本. [#4169](https://github.com/ClickHouse/ClickHouse/pull/4169) [#4173](https://github.com/ClickHouse/ClickHouse/pull/4173) ([KochetovNicolai](https://github.com/KochetovNicolai)) ([KochetovNicolai](https://github.com/KochetovNicolai))
-   为 ClickHouse 添加了 puppet 模块. [#4182](https://github.com/ClickHouse/ClickHouse/pull/4182) ([Maxim Fedotov](https://github.com/MaxFedotov))
-   添加了一组未记录功能的文档. [#4168](https://github.com/ClickHouse/ClickHouse/pull/4168) ([Winter Zhang](https://github.com/zhang2014))
-   ARM 构建修复. [#4210](https://github.com/ClickHouse/ClickHouse/pull/4210)[#4306](https://github.com/ClickHouse/ClickHouse/pull/4306) [#4291](https://github.com/ClickHouse/ClickHouse/pull/4291) ([proller](https://github.com/proller)) ([proller](https://github.com/proller))
-   字典测试现在可以从 `ctest` 运行. [#4189](https://github.com/ClickHouse/ClickHouse/pull/4189) ([proller](https://github.com/proller))
-   现在 `/etc/ssl` 被用作 SSL 证书的默认目录. [#4167](https://github.com/ClickHouse/ClickHouse/pull/4167) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   在开始时添加了检查 SSE 和 AVX 指令. [#4234](https://github.com/ClickHouse/ClickHouse/pull/4234) ([Igr](https://github.com/igron99))
-   初始化脚本将等待服务器直到启动. [#4281](https://github.com/ClickHouse/ClickHouse/pull/4281) ([proller](https://github.com/proller))

#### 向后不兼容更改 {#backward-incompatible-changes-1}

-   删除了 `allow_experimental_low_cardinality_type` 设置. `LowCardinality` 数据类型是生产就绪的. [#4323](https://github.com/ClickHouse/ClickHouse/pull/4323) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   根据可用内存量减少标记缓存大小和未压缩缓存大小. [#4240](https://github.com/ClickHouse/ClickHouse/pull/4240) ([Lopatin Konstantin](https://github.com/k-lopatin)
-   在 `CREATE TABLE` 查询中添加了关键字 `INDEX` . 名称为 `index` 的列必须用反引号或双引号引用: `` `index` ``. [#4143](https://github.com/ClickHouse/ClickHouse/pull/4143) ([Nikita Vasilev](https://github.com/nikvas0))
-   `sumMap` 现在提升结果类型而不是溢出. 旧的 `sumMap` 行为可以通过使用 `sumMapWithOverflow` 函数获得. [#4151](https://github.com/ClickHouse/ClickHouse/pull/4151) ([Léo Ercolanelli](https://github.com/ercolanelli-leo))

#### 性能改进 {#performance-improvements-4}

-   `std::sort` 替换为 `pdqsort` 用于没有 `LIMIT` 的查询. [#4236](https://github.com/ClickHouse/ClickHouse/pull/4236) ([Evgenii Pravda](https://github.com/kvinty))
-   现在服务器重用来自全局线程池的线程. 这会影响某些极端情况下的性能. [#4150](https://github.com/ClickHouse/ClickHouse/pull/4150) ([alexey-milovidov](https://github.com/alexey-milovidov))

#### 改进 {#improvements-5}

-   为 FreeBSD 实现 AIO 支持. [#4305](https://github.com/ClickHouse/ClickHouse/pull/4305) ([urgordeadbeef](https://github.com/urgordeadbeef))
-   `SELECT * FROM a JOIN b USING a, b` 现在只从左表返回 `a` 和 `b` 列. [#4141](https://github.com/ClickHouse/ClickHouse/pull/4141) ([Artem Zuikov](https://github.com/4ertus2))
-   允许客户端的`-C` 选项作为`-c` 选项工作. [#4232](https://github.com/ClickHouse/ClickHouse/pull/4232) ([syominsergey](https://github.com/syominsergey))
-   现在不带值使用的选项 `--password` 需要来自 stdin 的密码. [#4230](https://github.com/ClickHouse/ClickHouse/pull/4230) ([BSD_Conqueror](https://github.com/bsd-conqueror))
-   在包含 `LIKE` 表达式或正则表达式的字符串文字中添加了未转义元字符的突出显示. [#4327](https://github.com/ClickHouse/ClickHouse/pull/4327) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   如果客户端套接字消失, 则添加取消 HTTP 只读查询. [#4213](https://github.com/ClickHouse/ClickHouse/pull/4213) ([nvartolomei](https://github.com/nvartolomei))
-   现在服务器报告进度以保持客户端连接有效. [#4215](https://github.com/ClickHouse/ClickHouse/pull/4215) ([Ivan](https://github.com/abyss7))
-   启用了 `optimize_throw_if_noop` 设置的 OPTIMIZE 查询原因稍微好一点的消息. [#4294](https://github.com/ClickHouse/ClickHouse/pull/4294) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   为 clickhouse 服务器添加了对 `--version` 选项的支持. [#4251](https://github.com/ClickHouse/ClickHouse/pull/4251) ([Lopatin Konstantin](https://github.com/k-lopatin))
-   为 `clickhouse-server` 添加了 `--help/-h` 选项. [#4233](https://github.com/ClickHouse/ClickHouse/pull/4233) ([Yuriy Baranov](https://github.com/yurriy))
-   添加了对具有聚合函数状态结果的标量子查询的支持. [#4348](https://github.com/ClickHouse/ClickHouse/pull/4348) ([Nikolai Kochetov](https://github.com/KochetovNicolai))
-   改进了服务器关闭时间和 ALTERs 等待时间. [#4372](https://github.com/ClickHouse/ClickHouse/pull/4372) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   向 system.replicas 添加了关于 replicad_can_become_leader 设置的信息, 如果副本不会尝试成为领导者，则添加日志记录. [#4379](https://github.com/ClickHouse/ClickHouse/pull/4379) ([Alex Zatelepin](https://github.com/ztlpn))

## ClickHouse 版本 19.1 {#clickhouse-release-19-1}

### ClickHouse 版本 19.1.14, 2019-03-14 {#clickhouse-release-19-1-14-2019-03-14}

-   修复了在将 `GLOBAL JOIN` 与 `SELECT *` (罕见情况) 一起使用的情况下, 如果设置 `asterisk_left_columns_only` 设置为 1 时可能发生的错误 `Column ... queried more than once`. 该问题在 19.3 及更新版本中不存在. [6bac7d8d](https://github.com/ClickHouse/ClickHouse/pull/4692/commits/6bac7d8d11a9b0d6de0b32b53c47eb2f6f8e7062) ([Artem Zuikov](https://github.com/4ertus2))

### ClickHouse 版本 19.1.13, 2019-03-12 {#clickhouse-release-19-1-13-2019-03-12}

此版本包含与 19.3.7 完全相同的补丁集.

### ClickHouse 版本 19.1.10, 2019-03-03 {#clickhouse-release-19-1-10-2019-03-03}

此版本包含与 19.3.6 完全相同的补丁集

## ClickHouse 版本 19.1 {#clickhouse-release-19-1-1}

### ClickHouse 版本 19.1.9, 2019-02-21 {#clickhouse-release-19-1-9-2019-02-21}

#### Bug 修复 {#bug-fixes-18}

-   修复了由于 `send_logs_level` 设置的错误实现而导致的与旧版本的向后不兼容. [#4445](https://github.com/ClickHouse/ClickHouse/pull/4445) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   修复了使用列注释引入的表函数 `remote` 向后不兼容的问题. [#4446](https://github.com/ClickHouse/ClickHouse/pull/4446) ([alexey-milovidov](https://github.com/alexey-milovidov))

### ClickHouse 版本 19.1.8, 2019-02-16 {#clickhouse-release-19-1-8-2019-02-16}

#### Bug 修复 {#bug-fixes-19}

-   修复缺少 /etc/clickhouse-server/config.xml 的安装包. [#4343](https://github.com/ClickHouse/ClickHouse/pull/4343) ([proller](https://github.com/proller))

## ClickHouse 版本 19.1 {#clickhouse-release-19-1-2}

### ClickHouse 版本 19.1.7, 2019-02-15 {#clickhouse-release-19-1-7-2019-02-15}

#### Bug 修复 {#bug-fixes-20}

-   正确返回正确的类型并正确处理`joinGet`函数中的锁. [#4153](https://github.com/ClickHouse/ClickHouse/pull/4153) ([Amos Bird](https://github.com/amosbird))
-   修复了在服务器关闭时尝试再次创建系统日志时的错误. [#4254](https://github.com/ClickHouse/ClickHouse/pull/4254) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   修复错误: 如果有一个带有 `Dictionary` 引擎的数据库, 所有词典都在服务器启动时强制加载, 如果有来自localhost的带有ClickHouse源的词典, 则该词典无法加载. [#4255](https://github.com/ClickHouse/ClickHouse/pull/4255) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   修复了执行包含 `IN` 运算符的突变时产生错误结果的错误. [#4099](https://github.com/ClickHouse/ClickHouse/pull/4099) ([Alex Zatelepin](https://github.com/ztlpn))
-   如果以交互模式运行, `clickhouse-client` 可以在退出时加载命令行建议数据时出现段错误. [#4317](https://github.com/ClickHouse/ClickHouse/pull/4317) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   从 `system.tables` 中选择时固定的竞争条件可能会给出“表不存在”错误. [#4313](https://github.com/ClickHouse/ClickHouse/pull/4313) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   修复了在 `No such file or directory` 错误后重试带有 `File` 引擎的表中的 `SELECT` 时的死锁. [#4161](https://github.com/ClickHouse/ClickHouse/pull/4161) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   修复了一个问题: 本地 ClickHouse 词典通过 TCP 加载, 但应在进程内加载. [#4166](https://github.com/ClickHouse/ClickHouse/pull/4166) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   修复了通过 TLS 连接与 PostgreSQL ODBC 驱动程序交互时的 `No message received` 错误. 还修复了使用 MySQL ODBC 驱动程序时的段错误. [#4170](https://github.com/ClickHouse/ClickHouse/pull/4170) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   暂时禁用`ORDER BY` 的谓词优化. [#3890](https://github.com/ClickHouse/ClickHouse/pull/3890) ([Winter Zhang](https://github.com/zhang2014))
-   从表函数 `numbers(0)` 中选择时修复了无限循环. [#4280](https://github.com/ClickHouse/ClickHouse/pull/4280) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   修复了 `compile_expressions` 与大 (超过 int16) 日期比较的错误. [#4341](https://github.com/ClickHouse/ClickHouse/pull/4341) ([alesapin](https://github.com/alesapin))
-   修复了 `uncompressed_cache=1` 的分段错误和错误的未压缩大小的异常. [#4186](https://github.com/ClickHouse/ClickHouse/pull/4186) ([alesapin](https://github.com/alesapin))
-   修复了右表中有重复项的 `ALL JOIN`. [#4184](https://github.com/ClickHouse/ClickHouse/pull/4184) ([Artem Zuikov](https://github.com/4ertus2))
-   修复了在执行 `INSERT ... SELECT ... FROM file(...)` 查询和文件具有 `CSVWithNames` 或 `TSVWIthNames` 格式并且缺少第一个数据行时的错误行为. [#4297](https://github.com/ClickHouse/ClickHouse/pull/4297) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   使用 `Array(LowCardinality)` 参数修复了聚合函数的执行. [#4055](https://github.com/ClickHouse/ClickHouse/pull/4055) ([KochetovNicolai](https://github.com/KochetovNicolai))
-   Debian 软件包: 根据配置更正 /etc/clickhouse-server/preprocessed 链接. [#4205](https://github.com/ClickHouse/ClickHouse/pull/4205) ([proller](https://github.com/proller))
-   修复了未定义行为消毒剂下的模糊测试: 添加了对 `quantile*Weighted` 系列函数的参数类型检查. [#4145](https://github.com/ClickHouse/ClickHouse/pull/4145) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   使 `START REPLICATED SENDS` 命令开始复制发送. [#4229](https://github.com/ClickHouse/ClickHouse/pull/4229) ([nvartolomei](https://github.com/nvartolomei))
-   修复了 JOIN ON 部分中重复列的 `Not found column`. [#4279](https://github.com/ClickHouse/ClickHouse/pull/4279) ([Artem Zuikov](https://github.com/4ertus2))
-   现在 `/etc/ssl` 被用作 SSL 证书的默认目录. [#4167](https://github.com/ClickHouse/ClickHouse/pull/4167) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   修复了字典不可用时重新加载字典时崩溃的问题. [#4188](https://github.com/ClickHouse/ClickHouse/pull/4188) ([proller](https://github.com/proller))
-   修复了错误的 `Date` 和`DateTime` 比较错误. [#4237](https://github.com/ClickHouse/ClickHouse/pull/4237) ([valexey](https://github.com/valexey))
-   修复了在条件运算符（函数 `if`) 的分支中使用 `Date` 和 `DateTime` 参数时不正确的结果. 为函数 `if` 添加了通用情况. [#4243](https://github.com/ClickHouse/ClickHouse/pull/4243) ([alexey-milovidov](https://github.com/alexey-milovidov))

### ClickHouse 版本 19.1.6, 2019-01-24 {#clickhouse-release-19-1-6-2019-01-24}

#### 新特征 {#new-features-7}

-  表的自定义每列压缩编解码器. [#3899](https://github.com/ClickHouse/ClickHouse/pull/3899) [#4111](https://github.com/ClickHouse/ClickHouse/pull/4111) ([alesapin](https://github.com/alesapin), [Winter Zhang](https://github.com/zhang2014), [Anatoly](https://github.com/Sindbag))
-   添加了压缩编解码器 `Delta`. [#4052](https://github.com/ClickHouse/ClickHouse/pull/4052) ([alesapin](https://github.com/alesapin))
-   允许`ALTER`压缩编解码器. [#4054](https://github.com/ClickHouse/ClickHouse/pull/4054) ([alesapin](https://github.com/alesapin))
-   添加函数`left`、`right`、`trim`、`ltrim`、`rtrim`、`timestampadd`、`timestampsub` 以实现SQL标准兼容性. [#3826](https://github.com/ClickHouse/ClickHouse/pull/3826) ([Ivan Blinkov](https://github.com/blinkov))
-   支持写入`HDFS`表和`hdfs`表功能. [#4084](https://github.com/ClickHouse/ClickHouse/pull/4084) ([alesapin](https://github.com/alesapin))
-   添加了从大型 haystack 中搜索多个常量字符串的函数: `multiPosition`、`multiSearch`、`firstMatch` 以及 `-UTF8`、`-CaseInsensitive` 和 `-CaseInsensitiveUTF8` 变体. [#4053](https://github.com/ClickHouse/ClickHouse/pull/4053) ([Danila Kutenin](https://github.com/danlark1))
-   如果`SELECT` 查询通过分片键进行过滤, 则修剪未使用的分片 (设置`optimize_skip_unused_shards`). [#3851](https://github.com/ClickHouse/ClickHouse/pull/3851) ([Gleb Kanterov](https://github.com/kanterov), [Ivan](https://github.com/abyss7))
-   允许 `Kafka` 引擎忽略每个块的一些解析错误. [#4094](https://github.com/ClickHouse/ClickHouse/pull/4094) ([Ivan](https://github.com/abyss7))
-   添加了对`CatBoost` 多类模型评估的支持。 函数`modelEvaluate` 返回带有多类模型的每类原始预测的元组。 `libcatboostmodel.so` 应该使用 [#607](https://github.com/catboost/catboost/pull/607) 构建. [#3959](https://github.com/ClickHouse/ClickHouse/pull/3959) ([KochetovNicolai](https://github.com/KochetovNicolai))
-   添加函数 `filesystemAvailable`、`filesystemFree`、`filesystemCapacity`. [#4097](https://github.com/ClickHouse/ClickHouse/pull/4097) ([Boris Granveaud](https://github.com/bgranvea))
-   添加了散列函数 `xxHash64` 和 `xxHash32`. [#3905](https://github.com/ClickHouse/ClickHouse/pull/3905) ([filimonov](https://github.com/filimonov))
-   添加了 `gccMurmurHash` 散列函数 (GCC 风味的 Murmur 散列), 它使用与 [gcc] (https://github.com/gcc-mirror/gcc/blob/41d6b10e96a1de98e90a7c0378437c3255814b16/libstdc%2B%2B-v3/include/bits/functional_hash.h#L191)相同的散列种子. [#4000](https://github.com/ClickHouse/ClickHouse/pull/4000) ([sundyli](https://github.com/sundy-li))
-   添加了散列函数 `javaHash`、`hiveHash`. [#3811](https://github.com/ClickHouse/ClickHouse/pull/3811) ([shangshujie365](https://github.com/shangshujie365))
-   添加了表功能`remoteSecure`. 功能作为 `remote` 工作，但使用安全连接. [#4088](https://github.com/ClickHouse/ClickHouse/pull/4088) ([proller](https://github.com/proller))

#### 实验功能 {#experimental-features-3}

-   添加了多个 JOIN 仿真 (`allow_experimental_multiple_joins_emulation` 设置). [#3946](https://github.com/ClickHouse/ClickHouse/pull/3946) ([Artem Zuikov](https://github.com/4ertus2))

#### Bug 修复 {#bug-fixes-21}

-   将 `compiled_expression_cache_size` 设置限制为默认以降低内存消耗. [#4041](https://github.com/ClickHouse/ClickHouse/pull/4041) ([alesapin](https://github.com/alesapin))
-   修复导致执行复制表 ALTER 的线程和从 ZooKeeper 更新配置的线程挂起的错误. [#2947](https://github.com/ClickHouse/ClickHouse/issues/2947) [#3891](https://github.com/ClickHouse/ClickHouse/issues/3891) [#3934](https://github.com/ClickHouse/ClickHouse/pull/3934) ([Alex Zatelepin](https://github.com/ztlpn))
-   修复了执行分布式 ALTER 任务时的竞争条件. 竞争条件导致多个副本尝试执行任务, 所有副本除了一个因 ZooKeeper 错误而失败. [#3904](https://github.com/ClickHouse/ClickHouse/pull/3904) ([Alex Zatelepin](https://github.com/ztlpn))
-   修复了在对 ZooKeeper 的请求超时后不刷新 `from_zk` 配置元素的错误. [#2947](https://github.com/ClickHouse/ClickHouse/issues/2947) [#3947](https://github.com/ClickHouse/ClickHouse/pull/3947) ([Alex Zatelepin](https://github.com/ztlpn))
-   修复错误前缀的错误 IPv4 子网掩码. [#3945](https://github.com/ClickHouse/ClickHouse/pull/3945) ([alesapin](https://github.com/alesapin))
-   修复了由于资源耗尽而无法创建新线程的极少数情况下的崩溃 (`std::terminate`). [#3956](https://github.com/ClickHouse/ClickHouse/pull/3956) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   修复在 `getStructureOfRemoteTable` 中使用错误限制时在 `remote` 表函数执行中的错误. [#4009](https://github.com/ClickHouse/ClickHouse/pull/4009) ([alesapin](https://github.com/alesapin))
-   修复 netlink 套接字泄漏. 它们被放置在一个永远不会被删除的池中, 并且当所有当前套接字都在使用时, 在新线程开始时创建新套接字. [#4017](https://github.com/ClickHouse/ClickHouse/pull/4017) ([Alex Zatelepin](https://github.com/ztlpn))
-   修复在分支 `odbc-bridge` 子进程后, 在从 `/proc` 读取所有 fds 之前关闭 `/proc/self/fd` 目录的错误. [#4120](https://github.com/ClickHouse/ClickHouse/pull/4120) ([alesapin](https://github.com/alesapin))
-   在主键中使用字符串的情况下修复了字符串到 UInt 的单调转换. [#3870](https://github.com/ClickHouse/ClickHouse/pull/3870) ([Winter Zhang](https://github.com/zhang2014))
-   修复整数转换函数单调性计算错误. [#3921](https://github.com/ClickHouse/ClickHouse/pull/3921) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   修复了 `arrayEnumerateUniq`、`arrayEnumerateDense` 函数中某些无效参数的段错误. [#3909](https://github.com/ClickHouse/ClickHouse/pull/3909) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   修复 StorageMerge 中的 UB. [#3910](https://github.com/ClickHouse/ClickHouse/pull/3910) ([Amos Bird](https://github.com/amosbird))
-   修复了函数 `addDays`、`subtractDays` 中的段错误. [#3913](https://github.com/ClickHouse/ClickHouse/pull/3913) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   修复错误: 函数`round`、`floor`、`trunc`、`ceil` 在整数参数和大的负比例上执行时可能返回虚假结果. [#3914](https://github.com/ClickHouse/ClickHouse/pull/3914) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   修复了由 `kill query sync` 引起的导致核心转储的错误. [#3916](https://github.com/ClickHouse/ClickHouse/pull/3916) ([muVulDeePecker](https://github.com/fancyqlx))
-   修复空复制队列后长时间延迟的错误. [#3928](https://github.com/ClickHouse/ClickHouse/pull/3928) [#3932](https://github.com/ClickHouse/ClickHouse/pull/3932) ([alesapin](https://github.com/alesapin))
-   修复了使用 `LowCardinality` 主键插入表时过多的内存使用. [#3955](https://github.com/ClickHouse/ClickHouse/pull/3955) ([KochetovNicolai](https://github.com/KochetovNicolai))
-   在空数组的情况下修复了`Native`格式的`LowCardinality`序列化. [#3907](https://github.com/ClickHouse/ClickHouse/issues/3907) [#4011](https://github.com/ClickHouse/ClickHouse/pull/4011) ([KochetovNicolai](https://github.com/KochetovNicolai))
-   修复了使用单 LowCardinality 数字列不同时的错误结果. [#3895](https://github.com/ClickHouse/ClickHouse/issues/3895) [#4012](https://github.com/ClickHouse/ClickHouse/pull/4012) ([KochetovNicolai](https://github.com/KochetovNicolai))
-   使用 LowCardinality 键修复了专门的聚合 (如果启用了 `compile` 设置). [#3886](https://github.com/ClickHouse/ClickHouse/pull/3886) ([KochetovNicolai](https://github.com/KochetovNicolai))
-   修复复制表查询的用户和密码转发. [#3957](https://github.com/ClickHouse/ClickHouse/pull/3957) ([alesapin](https://github.com/alesapin)) ([小路](https://github.com/nicelulu))
-   修复了在重新加载字典时列出字典数据库中的表时可能发生的非常罕见的竞争条件. [#3970](https://github.com/ClickHouse/ClickHouse/pull/3970) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   修复了当 HAVING 与 ROLLUP 或 CUBE 一起使用时的错误结果. [#3756](https://github.com/ClickHouse/ClickHouse/issues/3756) [#3837](https://github.com/ClickHouse/ClickHouse/pull/3837) ([Sam Chou](https://github.com/reflection))
-   使用 `JOIN ON` 语法和分布式表进行查询的固定列别名. [#3980](https://github.com/ClickHouse/ClickHouse/pull/3980) ([Winter Zhang](https://github.com/zhang2014))
-   修复了 `quantileTDigest` (由 Artem Vakhrushev 发现) 的内部实现中的错误. 此错误从未发生在 ClickHouse 中, 仅与直接使用 ClickHouse 代码库作为库的人相关. [#3935](https://github.com/ClickHouse/ClickHouse/pull/3935) ([alexey-milovidov](https://github.com/alexey-milovidov))

#### 改进 {#improvements-6}

-   支持 `ALTER TABLE ADD COLUMN` 语句中的 `IF NOT EXISTS` 以及 `DROP/MODIFY/CLEAR/COMMENT COLUMN` 中的 `IF EXISTS`. [#3900](https://github.com/ClickHouse/ClickHouse/pull/3900) ([Boris Granveaud](https://github.com/bgranvea))
-   函数 `parseDateTimeBestEffort`: 支持`DD.MM.YYYY`、`DD.MM.YY`、`DD-MM-YYYY`、`DD-Mon-YYYY`、`DD/Month/YYYY`等格式. [#3922](https://github.com/ClickHouse/ClickHouse/pull/3922) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   `CapnProtoInputStream` 现在支持锯齿状结构. [#4063](https://github.com/ClickHouse/ClickHouse/pull/4063) ([Odin Hultgren Van Der Horst](https://github.com/Miniwoffer))
-   可用性改进: 添加了检查服务器进程是否从数据目录的所有者启动. 如果数据属于非 root 用户, 则不允许从 root 启动服务器. [#3785](https://github.com/ClickHouse/ClickHouse/pull/3785) ([sergey-v-galtsev](https://github.com/sergey-v-galtsev))
-   在使用 JOIN 分析查询期间检查所需列的更好逻辑. [#3930](https://github.com/ClickHouse/ClickHouse/pull/3930) ([Artem Zuikov](https://github.com/4ertus2))
-   在单个服务器中有大量分布式表的情况下减少连接数. [#3726](https://github.com/ClickHouse/ClickHouse/pull/3726) ([Winter Zhang](https://github.com/zhang2014))
-   支持 ODBC 驱动程序 `WITH TOTALS` 查询的总计行. [#3836](https://github.com/ClickHouse/ClickHouse/pull/3836) ([Maksim Koritckiy](https://github.com/nightweb))
-   允许在 if 函数中使用 `Enum` 作为整数. [#3875](https://github.com/ClickHouse/ClickHouse/pull/3875) ([Ivan](https://github.com/abyss7))
-   添加了 `low_cardinality_allow_in_native_format` 设置. 如果禁用, 请勿使用 `Native` 格式的 `LowCadrinality` 类型. [#3879](https://github.com/ClickHouse/ClickHouse/pull/3879) ([KochetovNicolai](https://github.com/KochetovNicolai))
-   从已编译的表达式缓存中删除了一些冗余对象以降低内存使用率. [#4042](https://github.com/ClickHouse/ClickHouse/pull/4042) ([alesapin](https://github.com/alesapin))
-   添加检查 `SET send_logs_level = 'value'` 查询接受适当的值. [#3873](https://github.com/ClickHouse/ClickHouse/pull/3873) ([Sabyanin Maxim](https://github.com/s-mx))
-   类型转换函数中的固定数据类型检查. [#3896](https://github.com/ClickHouse/ClickHouse/pull/3896) ([Winter Zhang](https://github.com/zhang2014))

#### 性能改进 {#performance-improvements-5}

-   添加 MergeTree 设置 `use_minimalistic_part_header_in_zookeeper`. 如果启用，复制表将在单个部分 znode 中存储压缩部分元数据. 这可以显着减少 ZooKeeper 快照大小 (特别是如果表有很多列). 请注意, 启用此设置后, 您将无法降级到不支持它的版本. [#3960](https://github.com/ClickHouse/ClickHouse/pull/3960) ([Alex Zatelepin](https://github.com/ztlpn))
-   为函数 `sequenceMatch` 和 `sequenceCount` 添加基于 DFA 的实现，以防模式不包含时间. [#4004](https://github.com/ClickHouse/ClickHouse/pull/4004) ([Léo Ercolanelli](https://github.com/ercolanelli-leo))
-   整数序列化的性能改进. [#3968](https://github.com/ClickHouse/ClickHouse/pull/3968) ([Amos Bird](https://github.com/amosbird))
-   零左填充 PODArray 以便 -1 元素始终有效并归零. 它用于偏移量的无分支计算. [#3920](https://github.com/ClickHouse/ClickHouse/pull/3920) ([Amos Bird](https://github.com/amosbird))
-   恢复了导致性能下降的 `jemalloc` 版本. [#4018](https://github.com/ClickHouse/ClickHouse/pull/4018) ([alexey-milovidov](https://github.com/alexey-milovidov))

#### 向后不兼容更改 {#backward-incompatible-changes-2}

-   删除了未记录的特性 `ALTER MODIFY PRIMARY KEY`, 因为它被 `ALTER MODIFY ORDER BY` 命令取代. [#3887](https://github.com/ClickHouse/ClickHouse/pull/3887) ([Alex Zatelepin](https://github.com/ztlpn))
-   删除了函数 `shardByHash`. [#3833](https://github.com/ClickHouse/ClickHouse/pull/3833) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   禁止使用类型为 `AggregateFunction` 的标量子查询. [#3865](https://github.com/ClickHouse/ClickHouse/pull/3865) ([Ivan](https://github.com/abyss7))

#### 构建/测试/打包改进 {#buildtestingpackaging-improvements-6}

-   添加了对 PowerPC (`ppc64le`) 构建的支持. [#4132](https://github.com/ClickHouse/ClickHouse/pull/4132) ([Danila Kutenin](https://github.com/danlark1))
-   在公共可用数据集上运行状态功能测试. [#3969](https://github.com/ClickHouse/ClickHouse/pull/3969) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   修复了当服务器无法以 Docker 或 systemd-nspawn 中的 `bash: /usr/bin/clickhouse-extract-from-config: Operation not allowed` 消息启动时的错误. [#4136](https://github.com/ClickHouse/ClickHouse/pull/4136) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   将 `rdkafka` 库更新到 v1.0.0-RC5. 使用 cppkafka 而不是原始 C 接口. [#4025](https://github.com/ClickHouse/ClickHouse/pull/4025) ([Ivan](https://github.com/abyss7))
-   更新了 `mariadb-client` 库. 修复了 UBSan 发现的问题之一. [#3924](https://github.com/ClickHouse/ClickHouse/pull/3924) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   UBSan 版本的一些修复. [#3926](https://github.com/ClickHouse/ClickHouse/pull/3926) [#3021](https://github.com/ClickHouse/ClickHouse/pull/3021) [#3948](https://github.com/ClickHouse/ClickHouse/pull/3948) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   使用 UBSan 构建添加了每次提交的测试运行.
-   添加了 PVS-Studio 静态分析器的每次提交运行.
-   修复了 PVS-Studio 发现的错误. [#4013](https://github.com/ClickHouse/ClickHouse/pull/4013) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   修复了 glibc 兼容性问题. [#4100](https://github.com/ClickHouse/ClickHouse/pull/4100) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   将 Docker 镜像移至 18.10 并添加 glibc \>= 2.28 的兼容性文件. [#3965](https://github.com/ClickHouse/ClickHouse/pull/3965) ([alesapin](https://github.com/alesapin))
-   如果用户不想在服务器 Docker 映像中 chown 目录，请添加 env 变量. [#3967](https://github.com/ClickHouse/ClickHouse/pull/3967) ([alesapin](https://github.com/alesapin))
-   在 clang 中启用了来自 `-Weverything` 的大部分警告. 启用 `-Wpedantic` . [#3986](https://github.com/ClickHouse/ClickHouse/pull/3986) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   添加了一些仅在 clang 8 中可用的警告. [#3993](https://github.com/ClickHouse/ClickHouse/pull/3993) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   使用共享链接时链接到 `libLLVM` 而不是单个 LLVM 库. [#3989](https://github.com/ClickHouse/ClickHouse/pull/3989) ([Orivej Desh](https://github.com/orivej))
-   测试图像添加了清除变量. [#4072](https://github.com/ClickHouse/ClickHouse/pull/4072) ([alesapin](https://github.com/alesapin))
-   `clickhouse-server` debian 包会推荐 `libcap2-bin` 包使用 `setcap` 工具设置功能. 这是可选的. [#4093](https://github.com/ClickHouse/ClickHouse/pull/4093) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   改进了编译时间, 修复了包含. [#3898](https://github.com/ClickHouse/ClickHouse/pull/3898) ([proller](https://github.com/proller))
-   添加了哈希函数的性能测试. [#3918](https://github.com/ClickHouse/ClickHouse/pull/3918) ([filimonov](https://github.com/filimonov))
-   修复了循环库依赖. [#3958](https://github.com/ClickHouse/ClickHouse/pull/3958) ([proller](https://github.com/proller))
-   改进了低可用内存的编译. [#4030](https://github.com/ClickHouse/ClickHouse/pull/4030) ([proller](https://github.com/proller))
-   添加了测试脚本以重现 `jemalloc` 中的性能下降. [#4036](https://github.com/ClickHouse/ClickHouse/pull/4036) ([alexey-milovidov](https://github.com/alexey-milovidov))
-   修复了 `dbms` 下注释和字符串中的拼写错误. [#4122](https://github.com/ClickHouse/ClickHouse/pull/4122) ([maiha](https://github.com/maiha))
-   修正了评论中的错别字. [#4089](https://github.com/ClickHouse/ClickHouse/pull/4089) ([Evgenii Pravda](https://github.com/kvinty))

## [Changelog for 2018](../../whats-new/changelog/2018.md#clickhouse-release-18-16) {#changelog-for-2018}
