## ClickHouse 版本 18.16 {#clickhouse-release-18-16}

### ClickHouse 版本 18.16.1, 2018-12-21 {#clickhouse-release-18-16-1-2018-12-21}

#### Bug 修复: {#bug-fixes}

-   修复了导致使用 ODBC 源更新字典出现问题的错误. [#3825](https://github.com/ClickHouse/ClickHouse/issues/3825), [#3829](https://github.com/ClickHouse/ClickHouse/issues/3829)
-   聚合函数的 JIT 编译现在适用于 LowCardinality 列. [#3838](https://github.com/ClickHouse/ClickHouse/issues/3838)

#### 改进: {#improvements}

-   添加了 `low_cardinality_allow_in_native_format` 设置 (默认启用). 禁用时, LowCardinality 列将转换为用于 SELECT 查询的普通列, 而用于 INSERT 查询的普通列将被转换. [#3879](https://github.com/ClickHouse/ClickHouse/pull/3879)

#### Build 改进: {#build-improvements}

-   修复了在 macOS 和 ARM 上的构建.

### ClickHouse 版本 18.16.0, 2018-12-14 {#clickhouse-release-18-16-0-2018-12-14}

#### 新特征: {#new-features}

-   以半结构化输入格式 (`JSONEachRow` 、 `TSKV` ) 加载数据时, 会评估 `DEFAULT` 表达式的缺失字段. 该功能通过 `insert_sample_with_metadata` 设置启用. [#3555](https://github.com/ClickHouse/ClickHouse/pull/3555)
-   `ALTER TABLE` 查询现在具有 `MODIFY ORDER BY` 操作, 用于在添加或删除表列时更改排序键. 这对于 `MergeTree` 系列中的表很有用, 这些表在基于此排序键合并时执行附加任务, 例如 `SummingMergeTree`、`AggregatingMergeTree` 等. [#3581](https://github.com/ClickHouse/ClickHouse/pull/3581) [#3755](https://github.com/ClickHouse/ClickHouse/pull/3755)
-   对于`MergeTree` 系列中的表, 现在您可以指定不同的排序键 (`ORDER BY`) 和索引 (`PRIMARY KEY`) . 排序键可以比索引长. [#3581](https://github.com/ClickHouse/ClickHouse/pull/3581)
-   添加了 `hdfs` 表功能和 `HDFS` 表引擎, 用于导入和导出数据到HDFS. [chenxing-xc](https://github.com/ClickHouse/ClickHouse/pull/3617)
-   添加了使用 base64 的函数: `base64Encode`, `base64Decode`, `tryBase64Decode`. [Alexander Krasheninnikov](https://github.com/ClickHouse/ClickHouse/pull/3350)
-   现在你可以使用一个参数来配置`uniqCombined`聚合函数的精度(选择HyperLogLog单元格的数量). [#3406](https://github.com/ClickHouse/ClickHouse/pull/3406)
-   添加了 `system.contributors` 表, 其中包含在 ClickHouse 中提交的每个人的姓名. [#3452](https://github.com/ClickHouse/ClickHouse/pull/3452)
-   添加了省略 `ALTER TABLE ... FREEZE` 查询的分区的功能，以便一次备份所有分区. [#3514](https://github.com/ClickHouse/ClickHouse/pull/3514)
-   添加了不需要指定返回值类型的 `dictGet` 和 `dictGetOrDefault` 函数. 类型是根据字典描述自动确定的. [Amos Bird](https://github.com/ClickHouse/ClickHouse/pull/3564)
-   现在您可以为表描述中的列指定注释并使用 `ALTER` 更改它. [#3377](https://github.com/ClickHouse/ClickHouse/pull/3377)
-   支持使用简单键读取 `Join` 类型的表. [Amos Bird](https://github.com/ClickHouse/ClickHouse/pull/3728)
-   现在您可以在创建 `Join` 类型表时指定选项 `join_use_nulls`、`max_rows_in_join`、`max_bytes_in_join` 和 `join_overflow_mode`. [Amos Bird](https://github.com/ClickHouse/ClickHouse/pull/3728)
-   加了 `joinGet` 函数, 允许您像使用字典一样使用 `Join` 类型的表. [Amos Bird](https://github.com/ClickHouse/ClickHouse/pull/3728)
-   将 `partition_key`、`sorting_key`、`primary_key` 和 `sampling_key` 列添加到 `system.tables` 表中, 以提供有关表键的信息. [#3609](https://github.com/ClickHouse/ClickHouse/pull/3609)
-   向 `system.columns` 表添加了 `is_in_partition_key`、`is_in_sorting_key` 、`is_in_primary_key` 和 `is_in_sampling_key` 列. [#3609](https://github.com/ClickHouse/ClickHouse/pull/3609)
-   将 `min_time` 和 `max_time` 列添加到 `system.parts` 表中. 当分区键是由 `DateTime`列组成的表达式时，将填充这些列. [Emmanuel Donin de Rosière](https://github.com/ClickHouse/ClickHouse/pull/3800)

#### Bug 修复: {#bug-fixes-1}

-   `LowCardinality` 数据类型的修复和性能改进. `GROUP BY` 使用 `LowCardinality(Nullable(...))`. 获取 `extremes` 的值. 处理高阶函数. `LEFT ARRAY JOIN`. 分布式 `GROUP BY`. 返回 `Array` 的函数. 执行 `ORDER BY`. 写入 `Distributed` 表(nicelulu). 向后兼容来自实现 `Native` 协议的旧客户端的 `INSERT` 查询. 支持 `JOIN` 的 `LowCardinality`. 在单个流中工作时提高了性能. [#3823](https://github.com/ClickHouse/ClickHouse/pull/3823) [#3803](https://github.com/ClickHouse/ClickHouse/pull/3803) [#3799](https://github.com/ClickHouse/ClickHouse/pull/3799) [#3769](https://github.com/ClickHouse/ClickHouse/pull/3769) [#3744](https://github.com/ClickHouse/ClickHouse/pull/3744) [#3681](https://github.com/ClickHouse/ClickHouse/pull/3681) [#3651](https://github.com/ClickHouse/ClickHouse/pull/3651) [#3649](https://github.com/ClickHouse/ClickHouse/pull/3649) [#3641](https://github.com/ClickHouse/ClickHouse/pull/3641) [#3632](https://github.com/ClickHouse/ClickHouse/pull/3632) [#3568](https://github.com/ClickHouse/ClickHouse/pull/3568) [#3523](https://github.com/ClickHouse/ClickHouse/pull/3523) [#3518](https://github.com/ClickHouse/ClickHouse/pull/3518)
-   修复了 `select_sequential_consistency` 选项的工作方式. 以前, 启用此设置后, 有时会在开始写入新分区后返回不完整的结果. [#2863](https://github.com/ClickHouse/ClickHouse/pull/2863)
-   执行 DDL `ON CLUSTER` 查询和 `ALTER UPDATE/DELETE` 时正确指定数据库. [#3772](https://github.com/ClickHouse/ClickHouse/pull/3772) [#3460](https://github.com/ClickHouse/ClickHouse/pull/3460)
-   为 VIEW 内的子查询正确指定了数据库. [#3521](https://github.com/ClickHouse/ClickHouse/pull/3521)
-   修复了 `PREWHERE` 中的 `FINAL` 错误, 用于 `VersionedCollapsingMergeTree` . [7167bfd7](https://github.com/ClickHouse/ClickHouse/commit/7167bfd7b365538f7a91c4307ad77e552ab4e8c1)
-   现在您可以使用 `KILL QUERY` 取消尚未启动的查询, 因为它们正在等待表被锁定. [#3517](https://github.com/ClickHouse/ClickHouse/pull/3517)
-   如果时钟在午夜后移, 则更正了日期和时间计算(这发生在伊朗, 1981 年至 1983 年发生在莫斯科). 以前, 这导致时间比必要的提前一天重置, 并且还导致文本格式的日期和时间格式不正确. [#3819](https://github.com/ClickHouse/ClickHouse/pull/3819)
-   修复了某些情况下 `VIEW` 和省略数据库的子查询的错误. [Winter Zhang](https://github.com/ClickHouse/ClickHouse/pull/3521)
-   修复了由于未锁定内部 `MATERIALIZED VIEW` 而同时从 `MATERIALIZED VIEW` 中读取并删除 `MATERIALIZED VIEW` 时的竞争条件. [#3404](https://github.com/ClickHouse/ClickHouse/pull/3404) [#3694](https://github.com/ClickHouse/ClickHouse/pull/3694)
-   修复了错误`Lock handler cannot be nullptr`. [#3689](https://github.com/ClickHouse/ClickHouse/pull/3689)
-   修复了启用 `compile_expressions` 选项时的查询处理(默认情况下启用). 不再展开像 `now` 函数这样的非确定性常量表达式. [#3457](https://github.com/ClickHouse/ClickHouse/pull/3457)
-   修复了在 `toDecimal32/64/128` 函数中指定非常量比例参数时崩溃的问题s.
-   修复了尝试将包含 `Values` 格式的 `NULL` 元素的数组插入没有 `Nullable` 的 `Array` 类型的列时的错误(如果 `input_format_values_interpret_expressions` = 1). [#3487](https://github.com/ClickHouse/ClickHouse/pull/3487) [#3503](https://github.com/ClickHouse/ClickHouse/pull/3503)
-   如果 ZooKeeper 不可用, 则修复了在 `DDLWorker` 中连续错误记录的问题. [8f50c620](https://github.com/ClickHouse/ClickHouse/commit/8f50c620334988b28018213ec0092fe6423847e2)
-   修复了来自 `Date` 和 `DateTime` 类型参数的 `quantile*` 函数的返回类型. [#3580](https://github.com/ClickHouse/ClickHouse/pull/3580)
-   修复了 `WITH` 子句 如果它指定一个没有表达式的简单别名. [#3570](https://github.com/ClickHouse/ClickHouse/pull/3570)
-   修复了启用 `enable_optimize_predicate_expression` 时使用命名子查询和限定列名的查询的处理. [Winter Zhang](https://github.com/ClickHouse/ClickHouse/pull/3588)
-   修复了使用物化视图时 `尝试附加到 nullptr 线程组` 的错误. [Marek Vavruša](https://github.com/ClickHouse/ClickHouse/pull/3623)
-   修复了将某些不正确的参数传递给 `arrayReverse` 函数时发生的崩溃. [73e3a7b6](https://github.com/ClickHouse/ClickHouse/commit/73e3a7b662161d6005e7727d8a711b930386b871)
-   修复了 `extractURLParameter` 函数中的缓冲区溢出问题. 改进性能. 添加了对包含零字节的字符串的正确处理. [141e9799](https://github.com/ClickHouse/ClickHouse/commit/141e9799e49201d84ea8e951d1bed4fb6d3dacb5)
-   修复了 `lowerUTF8` 和 `upperUTF8` 函数中的缓冲区溢出. 删除了通过 `FixedString` 类型参数执行这些函数的能力. [#3662](https://github.com/ClickHouse/ClickHouse/pull/3662)
-   修复了删除 `MergeTree` 表时罕见的竞争条件. [#3680](https://github.com/ClickHouse/ClickHouse/pull/3680)
-   修复了从 `Buffer` 表读取并同时在目标表上执行 `ALTER` 或 `DROP` 时的竞争条件. [#3719](https://github.com/ClickHouse/ClickHouse/pull/3719)
-   修复了超出 `max_temporary_non_const_columns` 限制时的段错误. [#3788](https://github.com/ClickHouse/ClickHouse/pull/3788)

#### 改进: {#improvements-1}

-   服务器不会将处理后的配置文件写入`/etc/clickhouse-server/`目录. 相反, 它将它们保存在 `path` 内的 `preprocessed_configs` 目录中. 这意味着 `/etc/clickhouse-server/` 目录对 `clickhouse` 用户没有写权限, 提高了安全性. [#2443](https://github.com/ClickHouse/ClickHouse/pull/2443)
-   `min_merge_bytes_to_use_direct_io` 选项默认设置为 10 GiB. 形成 MergeTree 系列中大部分表的合并将在 `O_DIRECT` 模式下执行，以防止过多的页面缓存逐出. [#3504](https://github.com/ClickHouse/ClickHouse/pull/3504)
-   当表数量非常多时，加速服务器启动. [#3398](https://github.com/ClickHouse/ClickHouse/pull/3398)
-   为副本之间的连接添加了连接池和 HTTP `Keep-Alive`. [#3594](https://github.com/ClickHouse/ClickHouse/pull/3594)
-   如果查询语法无效, `HTTP` 接口返回 `400 Bad Request` 代码(之前返回500). [31bc680a](https://github.com/ClickHouse/ClickHouse/commit/31bc680ac5f4bb1d0360a8ba4696fa84bb47d6ab)
-   `join_default_strictness` 选项默认设置为 `ALL` 以实现兼容性. [120e2cbe](https://github.com/ClickHouse/ClickHouse/commit/120e2cbe2ff4fbad626c28042d9b28781c805afe)
-   对于无效或复杂的正则表达式，从 `re2` 库中删除了对 `stderr` 的日志记录. [#3723](https://github.com/ClickHouse/ClickHouse/pull/3723)
-   为 `Kafka` 表引擎添加: 在开始从 Kafka 读取之前检查订阅; 表的 kafka_max_block_size 设置. [Marek Vavruša](https://github.com/ClickHouse/ClickHouse/pull/3396)
-   `cityHash64`、`farmHash64`、`metroHash64`、`sipHash64`、`halfMD5`、`murmurHash2_32`、`murmurHash2_64`、`murmurHash3_32` 和`murmurHash3_64` 函数现在可用于任意数量的参数和参数元组的形式. [#3451](https://github.com/ClickHouse/ClickHouse/pull/3451) [#3519](https://github.com/ClickHouse/ClickHouse/pull/3519)
-   `arrayReverse` 函数现在适用于任何类型的数组. [73e3a7b6](https://github.com/ClickHouse/ClickHouse/commit/73e3a7b662161d6005e7727d8a711b930386b871)
-   添加了一个可选参数：`timeSlots` 函数的插槽大小. [Kirill Shvakov](https://github.com/ClickHouse/ClickHouse/pull/3724)
-   对于 `FULL` 和 `RIGHT JOIN`，`max_block_size` 设置用于来自右表的非连接数据流. [Amos Bird](https://github.com/ClickHouse/ClickHouse/pull/3699)
-   在 `clickhouse-benchmark` 和 `clickhouse-performance-test` 中添加了 `--secure` 命令行参数以启用 TLS. [#3688](https://github.com/ClickHouse/ClickHouse/pull/3688) [#3690](https://github.com/ClickHouse/ClickHouse/pull/3690)
-   `Buffer` 类型表的结构与目标表的结构不匹配时的类型转换. [Vitaly Baranov](https://github.com/ClickHouse/ClickHouse/pull/3603)
-   添加了 `tcp_keep_alive_timeout` 选项以在指定时间间隔内不活动后启用保持活动数据包. [#3441](https://github.com/ClickHouse/ClickHouse/pull/3441)
-   如果`system.parts` 表包含单列, 则删除了不必要的对分区键值的引用. [#3652](https://github.com/ClickHouse/ClickHouse/pull/3652)
-   模函数适用于 `Date` 和 `DateTime` 数据类型. [#3385](https://github.com/ClickHouse/ClickHouse/pull/3385)
-   添加了`POWER`、`LN`、`LCASE`、`UCASE`、`REPLACE`、`LOCATE`、`SUBSTR` 和`MID` 函数的同义词. [#3774](https://github.com/ClickHouse/ClickHouse/pull/3774) [#3763](https://github.com/ClickHouse/ClickHouse/pull/3763) Some function names are case-insensitive for compatibility with the SQL standard. Added syntactic sugar `SUBSTRING(expr FROM start FOR length)` for compatibility with SQL. [#3804](https://github.com/ClickHouse/ClickHouse/pull/3804)
-   添加了对与 `clickhouse-server` 可执行代码对应的 `mlock` 内存页面的功能，以防止其被强制内存不足. 默认情况下禁用此功能. [#3553](https://github.com/ClickHouse/ClickHouse/pull/3553)
-   从`O_DIRECT` 读取时提高了性能(启用了`min_bytes_to_use_direct_io` 选项). [#3405](https://github.com/ClickHouse/ClickHouse/pull/3405)
-   改进了用于常量键参数和非常量默认参数的 `dictGet...OrDefault` 函数的性能. [Amos Bird](https://github.com/ClickHouse/ClickHouse/pull/3563)
-   `firstSignificantSubdomain` 函数现在可以处理域 `gov`、`mil` 和 `edu`. [Igor Hatarist](https://github.com/ClickHouse/ClickHouse/pull/3601) Improved performance. [#3628](https://github.com/ClickHouse/ClickHouse/pull/3628)
-   能够通过在 `/etc/default/clickhouse` 中定义 `CLICKHOUSE_PROGRAM_ENV` 使用 `SYS-V init.d` 脚本来指定用于启动 `clickhouse-server` 的自定义环境变量.
    [Pavlo Bashynskyi](https://github.com/ClickHouse/ClickHouse/pull/3612)
-   clickhouse-server 初始化脚本的正确返回码. [#3516](https://github.com/ClickHouse/ClickHouse/pull/3516)
-   `system.metrics` 表现在有 `VersionInteger` 指标, `system.build_options` 添加了行 `VERSION_INTEGER`, 其中包含 ClickHouse 版本的数字形式, 例如 `18016000`. [#3644](https://github.com/ClickHouse/ClickHouse/pull/3644)
-   删除了将 `Date` 类型与数字进行比较的功能，以避免诸如 `date = 2018-12-17` 之类的潜在错误, 其中错误地省略了日期周围的引号. [#3687](https://github.com/ClickHouse/ClickHouse/pull/3687)
-   修复了像 `rowNumberInAllBlocks` 这样的有状态函数的行为。 由于在查询分析期间启动，他们以前输出的结果大一个数字. [Amos Bird](https://github.com/ClickHouse/ClickHouse/pull/3729)
-   如果无法删除 `force_restore_data` 文件, 则会显示错误消息. [Amos Bird](https://github.com/ClickHouse/ClickHouse/pull/3794)

#### Build 改进: {#build-improvements-1}

-   更新了 `jemalloc` 库, 修复了潜在的内存泄漏. [Amos Bird](https://github.com/ClickHouse/ClickHouse/pull/3557)
-   默认情况下启用使用 `jemalloc` 进行分析以便调试构建. [2cc82f5c](https://github.com/ClickHouse/ClickHouse/commit/2cc82f5cbe266421cd4c1165286c2c47e5ffcb15)
-   添加了仅在系统上安装了 `Docker` 时运行集成测试的能力. [#3650](https://github.com/ClickHouse/ClickHouse/pull/3650)
-   在 SELECT 查询中添加了模糊表达式测试. [#3442](https://github.com/ClickHouse/ClickHouse/pull/3442)
-   添加了针对提交的压力测试, 它以并行和随机顺序执行功能测试以检测更多竞争条件. [#3438](https://github.com/ClickHouse/ClickHouse/pull/3438)
-   改进了在 Docker 镜像中启动 clickhouse-server 的方法. [Elghazal Ahmed](https://github.com/ClickHouse/ClickHouse/pull/3663)
-   对于 Docker 映像, 添加了对使用 `/docker-entrypoint-initdb.d` 目录中的文件初始化数据库的支持. [Konstantin Lebedev](https://github.com/ClickHouse/ClickHouse/pull/3695)
-   修复了 ARM 上的构建. [#3709](https://github.com/ClickHouse/ClickHouse/pull/3709)

#### 向后不兼容的更新: {#backward-incompatible-changes}

-   删除了将 `Date` 类型与数字进行比较的能力. 而不是 `toDate('2018-12-18') = 17883`, 你必须使用显式类型转换 `= toDate(17883)`. [#3687](https://github.com/ClickHouse/ClickHouse/pull/3687)

## ClickHouse 版本 18.14 {#clickhouse-release-18-14}

### ClickHouse 版本 18.14.19, 2018-12-19 {#clickhouse-release-18-14-19-2018-12-19}

#### Bug 修复: {#bug-fixes-2}

-   修复了导致使用 ODBC 源更新字典出现问题的错误. [#3825](https://github.com/ClickHouse/ClickHouse/issues/3825), [#3829](https://github.com/ClickHouse/ClickHouse/issues/3829)
-   执行 DDL `ON CLUSTER` 查询时正确指定数据库. [#3460](https://github.com/ClickHouse/ClickHouse/pull/3460)
-   修复了超出 `max_temporary_non_const_columns` 限制时的段错误. [#3788](https://github.com/ClickHouse/ClickHouse/pull/3788)

#### Build 改进: {#build-improvements-2}

-   修复了 ARM 上的构建.

### ClickHouse 版本 18.14.18, 2018-12-04 {#clickhouse-release-18-14-18-2018-12-04}

#### Bug 修复: {#bug-fixes-3}

-   修复了 `dictGet...` 函数对于 `range` 类型的字典的错误，如果其中一个参数是常量而另一个不是. [#3751](https://github.com/ClickHouse/ClickHouse/pull/3751)
-   修复了导致消息 `netlink: '...': attribute type 1 has an invalid length` 打印在 Linux 内核日志中的错误, 这种错误只发生在足够新的 Linux 内核版本上. [#3749](https://github.com/ClickHouse/ClickHouse/pull/3749)
-   修复了函数 `empty` 中 `FixedString` 类型参数的段错误. [Daniel, Dao Quang Minh](https://github.com/ClickHouse/ClickHouse/pull/3703)
-   修复了在使用大值 `max_query_size` 设置时过多的内存分配(一次性预分配了 `max_query_size` 字节的内存块). [#3720](https://github.com/ClickHouse/ClickHouse/pull/3720)

#### Build 更新: {#build-changes}

-   使用 OS 包中版本 7 的 LLVM/Clang 库修复构建 (这些库用于运行时查询编译). [#3582](https://github.com/ClickHouse/ClickHouse/pull/3582)

### ClickHouse 版本 18.14.17, 2018-11-30 {#clickhouse-release-18-14-17-2018-11-30}

#### Bug 修复: {#bug-fixes-4}

-   修复了 ODBC 桥进程未随主服务器进程终止的情况. [#3642](https://github.com/ClickHouse/ClickHouse/pull/3642)
-   修复了同步插入到`Distributed` 表中的问题, 其中的列列表与远程表的列列表不同. [#3673](https://github.com/ClickHouse/ClickHouse/pull/3673)
-   修复了在删除 MergeTree 表时可能导致崩溃的罕见竞争条件. [#3643](https://github.com/ClickHouse/ClickHouse/pull/3643)
-   修复了查询线程创建失败并出现 `资源暂时不可用` 错误时的查询死锁. [#3643](https://github.com/ClickHouse/ClickHouse/pull/3643)
-   修复了当使用 `CREATE AS table` 语法并且在 `AS table` 之前指定 `ENGINE` 子句时对 `ENGINE` 子句的解析 (错误导致忽略指定的引擎). [#3692](https://github.com/ClickHouse/ClickHouse/pull/3692)

### ClickHouse 版本 18.14.15, 2018-11-21 {#clickhouse-release-18-14-15-2018-11-21}

#### Bug 修复: {#bug-fixes-5}

-   反序列化 `Array(String)` 类型的列时高估了内存块的大小, 导致 `Memory limit exceeded` 错误. 该问题出现在版本 18.12.13. [#3589](https://github.com/ClickHouse/ClickHouse/issues/3589)

### ClickHouse 版本 18.14.14, 2018-11-20 {#clickhouse-release-18-14-14-2018-11-20}

#### Bug 修复: {#bug-fixes-6}

-   修复了集群配置为安全时的 `ON CLUSTER` 查询 (标志 `<secure>` ). [#3599](https://github.com/ClickHouse/ClickHouse/pull/3599)

#### Build Changes: {#build-changes-1}

-   修复的问题(来自系统的 llvm-7, macos). [#3582](https://github.com/ClickHouse/ClickHouse/pull/3582)

### ClickHouse 版本 18.14.13, 2018-11-08 {#clickhouse-release-18-14-13-2018-11-08}

#### Bug 修复: {#bug-fixes-7}

-   修复了 `MergingSorted 流中的块结构不匹配` 错误. [#3162](https://github.com/ClickHouse/ClickHouse/issues/3162)
-   修复了 `ON CLUSTER` 查询, 以防在集群配置中打开安全连接 (`<secure>` 标志). [#3465](https://github.com/ClickHouse/ClickHouse/pull/3465)
-   修复了使用 `SAMPLE`、`PREWHERE` 和 alias 列的查询中的错误. [#3543](https://github.com/ClickHouse/ClickHouse/pull/3543)
-   修复了启用 `min_bytes_to_use_direct_io` 设置时罕见的 `unknown compression method` 错误. [3544](https://github.com/ClickHouse/ClickHouse/pull/3544)

#### 性能改进: {#performance-improvements}

-   修复了在 AMD EPYC 处理器上执行时使用 UInt16 或 Date 类型列的 `GROUP BY` 查询的性能回归. [Igor Lapko](https://github.com/ClickHouse/ClickHouse/pull/3512)
-   修复了处理长字符串的查询的性能回归. [#3530](https://github.com/ClickHouse/ClickHouse/pull/3530)

#### Build 改进: {#build-improvements-3}

-   简化 Arcadia 构建的改进. [#3475](https://github.com/ClickHouse/ClickHouse/pull/3475), [#3535](https://github.com/ClickHouse/ClickHouse/pull/3535)

### ClickHouse 版本 18.14.12, 2018-11-02 {#clickhouse-release-18-14-12-2018-11-02}

#### Bug 修复: {#bug-fixes-8}

-   修复了加入两个未命名子查询时崩溃的问题. [#3505](https://github.com/ClickHouse/ClickHouse/pull/3505)
-   修复了在查询外部数据库时生成不正确的查询 (带有空的 `WHERE` 子句). [hotid](https://github.com/ClickHouse/ClickHouse/pull/3477)
-   修复了在 ODBC 字典中使用错误超时值的问题. [Marek Vavruša](https://github.com/ClickHouse/ClickHouse/pull/3511)

### ClickHouse 版本 18.14.11, 2018-10-29 {#clickhouse-release-18-14-11-2018-10-29}

#### Bug 修复: {#bug-fixes-9}

-   修复了错误 `Block structure mismatch in UNION stream: different number of columns`. [#2156](https://github.com/ClickHouse/ClickHouse/issues/2156)
-   修复了在包含嵌套结构内的数组的表中合并数据时出现的错误. [#3397](https://github.com/ClickHouse/ClickHouse/pull/3397)
-   修复了如果禁用 `merge_tree_uniform_read_distribution` 设置 (默认启用) 时查询结果不正确的问题. [#3429](https://github.com/ClickHouse/ClickHouse/pull/3429)
-   修复了以本机格式插入分布式表的错误. [#3411](https://github.com/ClickHouse/ClickHouse/issues/3411)

### ClickHouse 版本 18.14.10, 2018-10-23 {#clickhouse-release-18-14-10-2018-10-23}

-   `compile_expressions` 设置 (表达式的 JIT 编译) 默认是禁用的. [#3410](https://github.com/ClickHouse/ClickHouse/pull/3410)
-   `enable_optimize_predicate_expression` 设置默认是禁用的.

### ClickHouse 版本 18.14.9, 2018-10-16 {#clickhouse-release-18-14-9-2018-10-16}

#### 新特征: {#new-features-1}

-   `GROUP BY` 的 `WITH CUBE` 修饰符 (也可以使用替代语法 `GROUP BY CUBE(...)`). [#3172](https://github.com/ClickHouse/ClickHouse/pull/3172)
-   添加了 `formatDateTime` 函数. [Alexandr Krasheninnikov](https://github.com/ClickHouse/ClickHouse/pull/2770)
-   增加了`JDBC`表引擎和`jdbc`表功能 (需要安装clickhouse-jdbc-bridge) . [Alexandr Krasheninnikov](https://github.com/ClickHouse/ClickHouse/pull/3210)
-   添加了用于处理 ISO 周数的函数：`toISOWeek`、`toISOYear`、`toStartOfISOYear` 和 `toDayOfYear`. [#3146](https://github.com/ClickHouse/ClickHouse/pull/3146)
-   现在您可以为 `MySQL` 和 `ODBC` 表使用 `Nullable` 列. [#3362](https://github.com/ClickHouse/ClickHouse/pull/3362)
-   嵌套数据结构可以作为 `JSONEachRow` 格式的嵌套对象读取. 添加了 `input_format_import_nested_json` 设置. [Veloman Yunkan](https://github.com/ClickHouse/ClickHouse/pull/3144)
-   插入数据时，许多`MATERIALIZED VIEW` 都可以进行并行处理. 请参阅`parallel_view_processing` 设置. [Marek Vavruša](https://github.com/ClickHouse/ClickHouse/pull/3208)
-   添加了 `SYSTEM FLUSH LOGS` 查询 (强制日志刷新到系统表，例如 `query_log`) [#3321](https://github.com/ClickHouse/ClickHouse/pull/3321)
-   现在你可以在声明 `Replicated` 表时使用预定义的 `database` 和 `table` 宏. [#3251](https://github.com/ClickHouse/ClickHouse/pull/3251)
-   添加了以工程符号 (表示十的幂) 读取 `Decimal` 类型值的能力. [#3153](https://github.com/ClickHouse/ClickHouse/pull/3153)

#### 实验特征: {#experimental-features}

-   `LowCardinality` 数据类型的 GROUP BY 子句优化. [#3138](https://github.com/ClickHouse/ClickHouse/pull/3138)
-   `LowCardinality` 数据类型表达式的优化计算. [#3200](https://github.com/ClickHouse/ClickHouse/pull/3200)

#### 改进: {#improvements-2}

-   使用 `ORDER BY` 和 `LIMIT` 显着减少了查询的内存消耗. 查看 `max_bytes_before_remerge_sort` 设置. [#3205](https://github.com/ClickHouse/ClickHouse/pull/3205)
-   如果没有`JOIN` (`LEFT`，`INNER`，...), 则假定`INNER JOIN`. [#3147](https://github.com/ClickHouse/ClickHouse/pull/3147)
-   合格的星号在使用 `JOIN` 的查询中正常工作. [Winter Zhang](https://github.com/ClickHouse/ClickHouse/pull/3202)
-   `ODBC` 表引擎正确选择引用远程数据库的 SQL 方言中的标识符的方法. [Alexandr Krasheninnikov](https://github.com/ClickHouse/ClickHouse/pull/3210)
-   `compile_expressions` 设置 (表达式的 JIT 编译) 默认启用.
-   修复了同时 DROP DATABASE/TABLE IF EXISTS 和 CREATE DATABASE/TABLE IF NOT EXISTS 的行为. 以前, `CREATE DATABASE ... IF NOT EXISTS` 查询可能会返回错误消息"File ... already exists", 而`CREATE TABLE ... IF NOT EXISTS` 和 `DROP TABLE IF EXISTS` 查询可能会返回 `Table ...现在正在创建或附加`. [#3101](https://github.com/ClickHouse/ClickHouse/pull/3101)
-   当从 MySQL 或 ODBC 表查询时, 带有常量右半部分的 LIKE 和 IN 表达式被传递到远程服务器. [#3182](https://github.com/ClickHouse/ClickHouse/pull/3182)
-   从 MySQL 和 ODBC 表查询时, 与 WHERE 子句中的常量表达式的比较将传递到远程服务器. 以前，只通过与常量的比较. [#3182](https://github.com/ClickHouse/ClickHouse/pull/3182)
-   正确计算终端中 `Pretty` 格式的行宽，包括带有象形文字的字符串. [Amos Bird](https://github.com/ClickHouse/ClickHouse/pull/3257).
-   可以为 `ALTER UPDATE` 查询指定 `ON CLUSTER`.
-   提高了读取 `JSONEachRow` 格式数据的性能. [#3332](https://github.com/ClickHouse/ClickHouse/pull/3332)
-   为兼容性添加了`LENGTH` 和`CHARACTER_LENGTH` 函数的同义词. `CONCAT` 函数不再区分大小写. [#3306](https://github.com/ClickHouse/ClickHouse/pull/3306)
-   添加了`DateTime` 类型的`TIMESTAMP` 同义词. [#3390](https://github.com/ClickHouse/ClickHouse/pull/3390)
-   服务器日志中始终为 query_id 保留空间, 即使日志行与查询无关. 这使得使用第三方工具解析服务器文本日志变得更容易.
-   当查询超过整数 GB 的下一个级别时, 会记录查询的内存消耗. [#3205](https://github.com/ClickHouse/ClickHouse/pull/3205)
-   为使用 Native 协议的客户端库错误发送的列数少于服务器预期的 INSERT 查询的情况添加了兼容模式. 这种情况在使用 clickhouse-cpp 库时是可能的. 之前这种场景导致服务器崩溃. [#3171](https://github.com/ClickHouse/ClickHouse/pull/3171)
-   在`clickhouse-copier` 中用户定义的WHERE 表达式中, 您现在可以使用`partition_key` 别名(用于按源表分区进行额外过滤). 如果分区方案在复制过程中发生变化, 但只是轻微变化, 这将很有用. [#3166](https://github.com/ClickHouse/ClickHouse/pull/3166)
-   `Kafka` 引擎的工作流已移至后台线程池, 以便在高负载时自动降低数据读取速度. [Marek Vavruša](https://github.com/ClickHouse/ClickHouse/pull/3215).
-   支持以 `Cap'n'Proto format` 读取结构的 `Tuple` 和 `Nested` 值，例如 `struct`. [Marek Vavruša](https://github.com/ClickHouse/ClickHouse/pull/3216)
-   `firstSignificantSubdomain` 函数的顶级域列表现在包括域 `biz`. [decaseal](https://github.com/ClickHouse/ClickHouse/pull/3219)
-   在外部字典的配置中, `null_value` 被解释为默认数据类型的值. [#3330](https://github.com/ClickHouse/ClickHouse/pull/3330)
-   支持 `Decimal` 的 `intDiv` 和 `intDivOrZero` 函数. [b48402e8](https://github.com/ClickHouse/ClickHouse/commit/b48402e8712e2b9b151e0eef8193811d433a1264)
-   支持`Date`、`DateTime`、`UUID`和 `Decimal`类型作为`sumMap`聚合函数的键. [#3281](https://github.com/ClickHouse/ClickHouse/pull/3281)
-   支持外部字典中的 `Decimal` 数据类型. [#3324](https://github.com/ClickHouse/ClickHouse/pull/3324)
-   支持 `SummingMergeTree` 表中的 `Decimal` 数据类型. [#3348](https://github.com/ClickHouse/ClickHouse/pull/3348)
-   在 `if` 中添加了针对 `UUID` 的专业化. [#3366](https://github.com/ClickHouse/ClickHouse/pull/3366)
-   从 `MergeTree 表` 读取时减少了 `open` 和 `close` 系统调用的数量. [#3283](https://github.com/ClickHouse/ClickHouse/pull/3283)
-   `TRUNCATE TABLE` 查询可以在任何副本上执行 (查询被传递给领导副本). [Kirill Shvakov](https://github.com/ClickHouse/ClickHouse/pull/3375)

#### Bug 修复: {#bug-fixes-10}

-   修复了`range_hashed` 词典的`Dictionary` 表问题。 此错误发生在 18.12.17 版本中. [#1702](https://github.com/ClickHouse/ClickHouse/pull/1702)
-   修复了加载`range_hashed` 字典时的错误 (消息`Unsupported type Nullable (...)`). 此错误发生在 18.12.17 版本中. [#3362](https://github.com/ClickHouse/ClickHouse/pull/3362)
-   修复了`pointInPolygon`函数中由于大量顶点彼此靠近的多边形计算不准确而导致的错误. [#3331](https://github.com/ClickHouse/ClickHouse/pull/3331) [#3341](https://github.com/ClickHouse/ClickHouse/pull/3341)
-   如果合并数据部分后, 结果部分的校验和与另一个副本中相同合并的结果不同, 则删除合并的结果并从另一个副本下载数据部分(这是正确的行为). 但是下载数据部分后, 由于该部分已经存在的错误, 无法将其添加到工作集中(因为数据部分在合并后有一些延迟被删除). 这导致循环尝试下载相同的数据. [#3194](https://github.com/ClickHouse/ClickHouse/pull/3194)
-   修复了查询总内存消耗的错误计算 (由于计算错误，`max_memory_usage_for_all_queries` 设置工作不正确，`MemoryTracking` 指标的值不正确). 此错误发生在 18.12.13 版本中. [Marek Vavruša](https://github.com/ClickHouse/ClickHouse/pull/3344)
-   修复了 `CREATE TABLE ... ON CLUSTER ... AS SELECT ...` 的功能.此错误发生在 18.12.13 版本. [#3247](https://github.com/ClickHouse/ClickHouse/pull/3247)
-   修复了如果 `JOIN` 仅在远程服务器上执行, 则在启动查询的服务器上为 `JOIN` 准备不必要的数据结构. [#3340](https://github.com/ClickHouse/ClickHouse/pull/3340)
-   修复了 `Kafka` 引擎中的错误：开始读取数据时出现异常后死锁, 完成后锁定. [Marek Vavruša](https://github.com/ClickHouse/ClickHouse/pull/3215).
-   对于 `Kafka` 表, 未传递可选的 `schema` 参数 (`Cap'n'Proto` 格式的模式). [Vojtech Splichal](https://github.com/ClickHouse/ClickHouse/pull/3150)
-   如果 ZooKeeper 服务器的集合具有接受连接但随后立即关闭它而不是响应握手的服务器, 则 ClickHouse 选择连接另一台服务器. 以前, 这会产生错误 `无法读取所有数据. 读取的字节数：0.预期的字节数：4`. 并且服务器无法启动. [8218cf3a](https://github.com/ClickHouse/ClickHouse/commit/8218cf3a5f39a43401953769d6d12a0bb8d29da9)
-   如果 ZooKeeper 服务器的集合包含 DNS 查询返回错误的服务器, 这些服务器将被忽略. [17b8e209](https://github.com/ClickHouse/ClickHouse/commit/17b8e209221061325ad7ba0539f03c6e65f87f29)
-   `VALUES` 格式插入数据时, 修复了 `Date` 和 `DateTime` 之间的类型转换 (如果 `input_format_values_interpret_expressions = 1`). 之前在Unix Epoch时间的天数数值和Unix时间戳之间进行了转换, 导致了意想不到的结果. [#3229](https://github.com/ClickHouse/ClickHouse/pull/3229)
-   更正了 `Decimal` 和整数之间的类型转换. [#3211](https://github.com/ClickHouse/ClickHouse/pull/3211)
-   修复了 `enable_optimize_predicate_expression` 设置中的错误. [Winter Zhang](https://github.com/ClickHouse/ClickHouse/pull/3231)
-   修复了 CSV 格式的浮点数解析错误, 如果使用非默认的 CSV 分隔符, 例如 `;`. [#3155](https://github.com/ClickHouse/ClickHouse/pull/3155)
-   修复了 `arrayCumSumNonNegative` 函数 (如果累加器小于零，它不会累加负值). [Aleksey Studnev](https://github.com/ClickHouse/ClickHouse/pull/3163)
-   修复了使用 `PREWHERE` 时 `Merge` 表如何在 `Distributed` 表之上工作. [#3165](https://github.com/ClickHouse/ClickHouse/pull/3165)
-   ALTER UPDATE` 查询中的错误修复.
-   修复了 18.12 版本中出现的 `odbc` 表函数中的错误. [#3197](https://github.com/ClickHouse/ClickHouse/pull/3197)
-   修复了使用 `StateArray` 组合器的聚合函数的操作. [#3188](https://github.com/ClickHouse/ClickHouse/pull/3188)
-   修复了将 `Decimal` 值除以零时的崩溃. [69dd6609](https://github.com/ClickHouse/ClickHouse/commit/69dd6609193beb4e7acd3e6ad216eca0ccfb8179)
-   修复了使用 `Decimal` 和整数参数的操作类型的输出. [#3224](https://github.com/ClickHouse/ClickHouse/pull/3224)
-   修复了在 `Decimal128` 上的 `GROUP BY` 期间的段错误. [3359ba06](https://github.com/ClickHouse/ClickHouse/commit/3359ba06c39fcd05bfdb87d6c64154819621e13a)
-   `log_query_threads` 设置 (关于查询执行的每个线程的日志信息) 现在只有在 `log_queries` 选项 (关于查询的日志信息) 设置为 1 时才生效. 由于`log_query_threads` 选项默认启用, 即使查询日志被禁用, 有关线程的信息也会被记录. [#3241](https://github.com/ClickHouse/ClickHouse/pull/3241)
-   修复了分位数聚合函数分布式操作的错误 (错误信息`Not found column quantile...`). [292a8855](https://github.com/ClickHouse/ClickHouse/commit/292a885533b8e3b41ce8993867069d14cbd5a664)
-   修复了同时在 18.12.17 版本服务器和旧服务器的集群上工作时的兼容性问题. 对于具有固定长度和非固定长度的 GROUP BY 键的分布式查询, 如果有大量数据要聚合, 则返回的数据并不总是完全聚合 (两个不同的行包含相同的聚合键). [#3254](https://github.com/ClickHouse/ClickHouse/pull/3254)
-   如果查询仅包含测试中声明的部分替换，则修复了对  `clickhouse-performance-test` 中替换的处理. [#3263](https://github.com/ClickHouse/ClickHouse/pull/3263)
-   修复了将 `FINAL` 与 `PREWHERE` 结合使用时的错误. [#3298](https://github.com/ClickHouse/ClickHouse/pull/3298)
-   修复了在 `ALTER` 期间添加的列上使用 `PREWHERE` 时的错误. [#3298](https://github.com/ClickHouse/ClickHouse/pull/3298)
-   添加了对`DEFAULT` 和`MATERIALIZED` 表达式是否缺少`arrayJoin` 的检查. 以前, `arrayJoin` 在插入数据时会导致错误. [#3337](https://github.com/ClickHouse/ClickHouse/pull/3337)
-   在`PREWHERE` 子句中添加了对缺少`arrayJoin` 的检查. 以前, 这会导致在执行查询时出现诸如 `Size ...不匹配` 或 `未知压缩方法` 之类的消息. [#3357](https://github.com/ClickHouse/ClickHouse/pull/3357)
-   修复了在用相应的 IN 表达式替换来自相等评估的 AND 链的优化后在极少数情况下可能发生的段错误. [liuyimin-bytedance](https://github.com/ClickHouse/ClickHouse/pull/3339)
-   对`clickhouse-benchmark` 的小修正: 以前, 客户端信息没有发送到服务器; 现在在关闭和限制迭代次数时更准确地计算执行的查询数. [#3351](https://github.com/ClickHouse/ClickHouse/pull/3351) [#3352](https://github.com/ClickHouse/ClickHouse/pull/3352)

#### 向后不兼容的更新: {#backward-incompatible-changes-1}

-   删除了 `allow_experimental_decimal_type` 选项. `Decimal` 数据类型可用于默认使用. [#3329](https://github.com/ClickHouse/ClickHouse/pull/3329)

## ClickHouse 版本 18.12 {#clickhouse-release-18-12}

### ClickHouse 版本 18.12.17, 2018-09-16 {#clickhouse-release-18-12-17-2018-09-16}

#### 新特征: {#new-features-2}

-   为 `clickhouse` 源实现了 `invalidate_query` (指定查询以检查是否需要更新外部字典的能力). [#3126](https://github.com/ClickHouse/ClickHouse/pull/3126)
-   添加了使用`UInt*`、`Int*` 和`DateTime` 数据类型 (连同`Date` 类型) 作为定义范围边界的`range_hashed` 外部字典键的功能. 现在可以使用 `NULL` 来指定一个开放范围. [Vasily Nemkov](https://github.com/ClickHouse/ClickHouse/pull/3123)
-   `Decimal` 类型现在支持 `var*` 和 `stddev*` 聚合函数. [#3129](https://github.com/ClickHouse/ClickHouse/pull/3129)
-   `Decimal` 类型现在支持数学函数(`exp`、`sin` 等). [#3129](https://github.com/ClickHouse/ClickHouse/pull/3129)
-   `system.part_log` 表现在有 `partition_id` 列. [#3089](https://github.com/ClickHouse/ClickHouse/pull/3089)

#### Bug 修复: {#bug-fixes-11}

-   `Merge` 现在可以在 `Distributed` 表上正常工作. [Winter Zhang](https://github.com/ClickHouse/ClickHouse/pull/3159)
-   修复了导致无法在 `Ubuntu Precise` 和旧版本上运行 ClickHouse 的不兼容性 (对 `glibc` 版本的不必要依赖). 18.12.13 版本出现不兼容. [#3130](https://github.com/ClickHouse/ClickHouse/pull/3130)
-   修复了 `enable_optimize_predicate_expression` 设置中的错误. [Winter Zhang](https://github.com/ClickHouse/ClickHouse/pull/3107)
-   修复了在 18.12.13 之前的版本上使用副本集群并同时在具有较新版本的服务器上创建表的新副本时出现的向后兼容性小问题 (显示在消息 `无法克隆副本, 因为......更新为新的 ClickHouse 版本`, 这是合乎逻辑的, 但不应该发生). [#3122](https://github.com/ClickHouse/ClickHouse/pull/3122)

#### 向后不兼容的更新: {#backward-incompatible-changes-2}

-   `enable_optimize_predicate_expression` 选项默认启用 (相当乐观). 如果出现与搜索列名相关的查询分析错误, 请将 `enable_optimize_predicate_expression` 设置为0. [Winter Zhang](https://github.com/ClickHouse/ClickHouse/pull/3107)

### ClickHouse 版本 18.12.14, 2018-09-13 {#clickhouse-release-18-12-14-2018-09-13}

#### 新特征: {#new-features-3}

-   添加了对 `ALTER UPDATE` 查询的支持. [#3035](https://github.com/ClickHouse/ClickHouse/pull/3035)
-   添加了 `allow_ddl` 选项, 用于限制用户对 DDL 查询的访问. [#3104](https://github.com/ClickHouse/ClickHouse/pull/3104)
-   为`MergeTree`引擎添加了`min_merge_bytes_to_use_direct_io`选项，它允许您设置合并总大小的阈值（当超过阈值时，数据部分文件将使用O_DIRECT处理). [#3117](https://github.com/ClickHouse/ClickHouse/pull/3117)
-   `system.merges` 系统表现在包含 `partition_id` 列. [#3099](https://github.com/ClickHouse/ClickHouse/pull/3099)

#### 改进 {#improvements-3}

-   如果数据部分在变异期间保持不变，则副本不会下载它. [#3103](https://github.com/ClickHouse/ClickHouse/pull/3103)
-   使用 `clickhouse-client` 时，设置名称可自动完成. [#3106](https://github.com/ClickHouse/ClickHouse/pull/3106)

#### Bug 修复: {#bug-fixes-12}

-   添加了对插入时作为`Nested` 类型字段元素的数组大小的检查. [#3118](https://github.com/ClickHouse/ClickHouse/pull/3118)
-   修复了使用 `ODBC` 源和 `hashed` 存储更新外部词典的错误. 此错误发生在 18.12.13 版本中.
-   修复了从具有 `IN` 条件的查询创建临时表时崩溃的问题. [Winter Zhang](https://github.com/ClickHouse/ClickHouse/pull/3098)
-   修复了可以包含 `NULL` 元素的数组的聚合函数中的错误. [Winter Zhang](https://github.com/ClickHouse/ClickHouse/pull/3097)

### ClickHouse 版本 18.12.13, 2018-09-10 {#clickhouse-release-18-12-13-2018-09-10}

#### 新特征: {#new-features-4}

-   添加了`DECIMAL(digits, scale)`数据类型(`Decimal32(scale)`、`Decimal64(scale)`、`Decimal128(scale)`). 要启用它, 请使用设置 `allow_experimental_decimal_type`. [#2846](https://github.com/ClickHouse/ClickHouse/pull/2846) [#2970](https://github.com/ClickHouse/ClickHouse/pull/2970) [#3008](https://github.com/ClickHouse/ClickHouse/pull/3008) [#3047](https://github.com/ClickHouse/ClickHouse/pull/3047)
-   用于`GROUP BY` 的新`WITH ROLLUP` 修饰符 (替代语法：`GROUP BY ROLLUP(...)`). [#2948](https://github.com/ClickHouse/ClickHouse/pull/2948)
-   在使用 JOIN 的查询中，星号扩展为所有表中的列列表, 符合 SQL 标准.  您可以通过在用户配置级别将 `asterisk_left_columns_only` 设置为 1 来恢复旧行为. [Winter Zhang](https://github.com/ClickHouse/ClickHouse/pull/2787)
-   添加了对带有表函数的 JOIN 的支持. [Winter Zhang](https://github.com/ClickHouse/ClickHouse/pull/2907)
-   通过在 clickhouse-client 中按 Tab 自动完成. [Sergey Shcherbin](https://github.com/ClickHouse/ClickHouse/pull/2447)
-   clickhouse-client 中的 Ctrl+C 清除输入的查询. [#2877](https://github.com/ClickHouse/ClickHouse/pull/2877)
-   添加了`join_default_strictness` 设置 (值：`"`、`'any'`、`'all'`). 这允许您不为`JOIN` 指定`ANY` 或`ALL`. [#2982](https://github.com/ClickHouse/ClickHouse/pull/2982)
-   与查询处理相关的服务器日志的每一行都显示了查询 ID. [#2482](https://github.com/ClickHouse/ClickHouse/pull/2482)
-   现在您可以在 clickhouse-client 中获取查询执行日志 (使用 `send_logs_level` 设置). 通过分布式查询处理, 日志从所有服务器级联. [#2482](https://github.com/ClickHouse/ClickHouse/pull/2482)
-   `system.query_log` 和 `system.processes`(`SHOW PROCESSLIST`) 表现在包含有关运行查询时所有更改设置的信息(`Settings`数据的嵌套结构). 添加了`log_query_settings` 设置. [#2482](https://github.com/ClickHouse/ClickHouse/pull/2482)
-   `system.query_log` 和 `system.processes` 表现在显示有关参与查询执行的线程数的信息 (请参阅 `thread_numbers` 列). [#2482](https://github.com/ClickHouse/ClickHouse/pull/2482)
-   添加了 `ProfileEvents` 计数器, 用于测量网络读写和磁盘读写所花费的时间、网络错误次数以及网络带宽受限时所花费的等待时间. [#2482](https://github.com/ClickHouse/ClickHouse/pull/2482)
-   添加了包含来自 rusage 的系统指标的 `ProfileEvents` 计数器 (您可以使用它们来获取有关用户空间和内核中 CPU 使用率、页面错误和上下文切换的信息), 以及 taskstats 指标 (使用这些来获取有关 I /O 等待时间, CPU 等待时间, 以及读取和记录的数据量, 有无页缓存). [#2482](https://github.com/ClickHouse/ClickHouse/pull/2482)
-   `ProfileEvents` 计数器适用于全局和每个查询, 以及每个查询执行线程, 它允许您按查询详细分析资源消耗. [#2482](https://github.com/ClickHouse/ClickHouse/pull/2482)
-   添加了 `system.query_thread_log` 表, 其中包含有关每个查询执行线程的信息. 添加了`log_query_threads` 设置. [#2482](https://github.com/ClickHouse/ClickHouse/pull/2482)
-   `system.metrics` 和 `system.events` 表现在有内置文档. [#3016](https://github.com/ClickHouse/ClickHouse/pull/3016)
-   添加了`arrayEnumerateDense`函数. [Amos Bird](https://github.com/ClickHouse/ClickHouse/pull/2975)
-   添加了 `arrayCumSumNonNegative` 和 `arrayDifference` 函数. [Aleksey Studnev](https://github.com/ClickHouse/ClickHouse/pull/2942)
-   添加了`retention`聚合函数. [Sundy Li](https://github.com/ClickHouse/ClickHouse/pull/2887)
-   现在您可以使用加号运算符添加 (合并) 聚合函数的状态, 并将聚合函数的状态乘以非负常数. [#3062](https://github.com/ClickHouse/ClickHouse/pull/3062) [#3034](https://github.com/ClickHouse/ClickHouse/pull/3034)
-   MergeTree 系列中的表现在具有虚拟列 `_partition_id`. [#3089](https://github.com/ClickHouse/ClickHouse/pull/3089)

#### 实验功能: {#experimental-features-1}

-   添加了 `LowCardinality(T)` 数据类型. 此数据类型会自动创建值的本地字典, 并允许在不解压字典的情况下进行数据处理. [#2830](https://github.com/ClickHouse/ClickHouse/pull/2830)
-   添加了 JIT 编译函数的缓存和编译前使用次数的计数器. 要 JIT 编译表达式, 请启用 `compile_expressions` 设置. [#2990](https://github.com/ClickHouse/ClickHouse/pull/2990) [#3077](https://github.com/ClickHouse/ClickHouse/pull/3077)

#### 改进: {#improvements-4}

-   修复了有废弃副本时复制日志无限累积的问题. 为延迟较长的副本添加了有效的恢复模式.
-   当其中一个是字符串而其他是固定长度时，具有多个聚合字段的`GROUP BY` 的性能得到改善.
-   使用 `PREWHERE` 和在 `PREWHERE` 中隐式传输表达式时提高了性能.
-   改进了文本格式的解析性能 (`CSV`, `TSV`). [Amos Bird](https://github.com/ClickHouse/ClickHouse/pull/2977) [#2980](https://github.com/ClickHouse/ClickHouse/pull/2980)
-   改进了读取二进制格式的字符串和数组的性能. [Amos Bird](https://github.com/ClickHouse/ClickHouse/pull/2955)
-   当单个服务器上有大量表时，提高性能并减少对 `system.tables` 和 `system.columns` 的查询的内存消耗. [#2953](https://github.com/ClickHouse/ClickHouse/pull/2953)
-   修复了大量查询导致错误时的性能问题 (`_dl_addr`函数在`perf top`中可见，但服务器没有使用太多CPU). [#2938](https://github.com/ClickHouse/ClickHouse/pull/2938)
-   条件被投射到视图中 (当启用`enable_optimize_predicate_expression` 时). [Winter Zhang](https://github.com/ClickHouse/ClickHouse/pull/2907)
-   对 `UUID` 数据类型功能的改进. [#3074](https://github.com/ClickHouse/ClickHouse/pull/3074) [#2985](https://github.com/ClickHouse/ClickHouse/pull/2985)
-   The-Alchemist 词典支持 `UUID` 数据类型. [#2822](https://github.com/ClickHouse/ClickHouse/pull/2822)
-   `visitParamExtractRaw` 函数可以正确处理嵌套结构. [Winter Zhang](https://github.com/ClickHouse/ClickHouse/pull/2974)
-   启用 `input_format_skip_unknown_fields` 设置时, 会正确跳过 `JSONEachRow` 格式的对象字段. [BlahGeek](https://github.com/ClickHouse/ClickHouse/pull/2958)
-   对于带有条件的 `CASE` 表达式, 您现在可以省略 `ELSE`, 它等价于 `ELSE NULL`. [#2920](https://github.com/ClickHouse/ClickHouse/pull/2920)
-   现在可以在使用 ZooKeeper 时配置操作超时. [urykhy](https://github.com/ClickHouse/ClickHouse/pull/2971)
-   您可以将 `LIMIT n, m` 的偏移量指定为 `LIMIT n OFFSET m`. [#2840](https://github.com/ClickHouse/ClickHouse/pull/2840)
-   您可以使用 `SELECT TOP n` 语法作为 `LIMIT` 的替代. [#2840](https://github.com/ClickHouse/ClickHouse/pull/2840)
-   增加了写入系统表的队列大小, 因此不会经常发生`SystemLog parameter queue is full`错误.
-   `windowFunnel` 聚合函数现在支持满足多个条件的事件. [Amos Bird](https://github.com/ClickHouse/ClickHouse/pull/2801)
-   重复列可用于 `JOIN` 的 `USING` 子句中. [#3006](https://github.com/ClickHouse/ClickHouse/pull/3006)
-   Pretty` 格式现在对按宽度对齐的列有限制. 使用 `output_format_pretty_max_column_pad_width` 设置. 如果一个值更宽, 它仍然会完整显示, 但表格中的其他单元格不会太宽. [#3003](https://github.com/ClickHouse/ClickHouse/pull/3003)
-   `odbc` 表函数现在允许您指定数据库/模式名称. [Amos Bird](https://github.com/ClickHouse/ClickHouse/pull/2885)
-   添加了使用在 `clickhouse-client` 配置文件中指定的用户名的功能. [Vladimir Kozbin](https://github.com/ClickHouse/ClickHouse/pull/2909)
-   `ZooKeeperExceptions` 计数器被分成三个计数器：`ZooKeeperUserExceptions`、`ZooKeeperHardwareExceptions` 和 `ZooKeeperOtherExceptions`.
-   `ALTER DELETE` 查询适用于物化视图.
-   为 `ReplicatedMergeTree` 表定期运行清理线程时添加了随机化, 以避免在有大量 `ReplicatedMergeTree` 表时出现周期性负载峰值.
-   支持 `ATTACH TABLE ... ON CLUSTER` 查询. [#3025](https://github.com/ClickHouse/ClickHouse/pull/3025)

#### Bug 修复: {#bug-fixes-13}

-   修复了 `Dictionary` 表的问题 (抛出 `Size of offsets does not match size of column` 或 `Unknown compression method` 异常). 这个bug出现在18.10.3版本. [#2913](https://github.com/ClickHouse/ClickHouse/issues/2913)
-   修复了合并 `CollapsingMergeTree` 表时, 如果其中一个数据部分为空 (如果所有数据都被删除，这些部分是在合并或`ALTER DELETE`期间形成的), 并且使用 `vertical` 算法进行合并. [#3049](https://github.com/ClickHouse/ClickHouse/pull/3049)
-   修复了在 `DROP` 或 `TRUNCATE` 期间为 `Memory` 表同时执行 `SELECT` 的竞争条件, 这可能导致服务器崩溃. 这个bug出现在1.1.54388版本. [#3038](https://github.com/ClickHouse/ClickHouse/pull/3038)
-   修复了在返回 `Session is expired` 错误时插入 `Replicated` 表时数据丢失的可能性 (数据丢失可以通过 `ReplicatedDataLoss` 指标检测). 此错误发生在 1.1.54378 版本中. [#2939](https://github.com/ClickHouse/ClickHouse/pull/2939) [#2949](https://github.com/ClickHouse/ClickHouse/pull/2949) [#2964](https://github.com/ClickHouse/ClickHouse/pull/2964)
-   修复了`JOIN ... ON` 期间的段错误. [#3000](https://github.com/ClickHouse/ClickHouse/pull/3000)
-   修复了当`WHERE`表达式完全由一个限定的列名组成时搜索列名的错误，例如`WHERE table.column`. [#2994](https://github.com/ClickHouse/ClickHouse/pull/2994)
-   修复了如果从远程服务器请求包含带有子查询的 IN 表达式的单个列，则在执行分布式查询时发生的 `Not found column` 错误. [#3087](https://github.com/ClickHouse/ClickHouse/pull/3087)
-   修正了 `UNION流中的块结构不匹配: 列数不同` 错误, 如果一个分片是本地的, 而另一个不是, 分布式查询发生, 并优化移动到 `PREWHERE` 被触发. [#2226](https://github.com/ClickHouse/ClickHouse/pull/2226) [#3037](https://github.com/ClickHouse/ClickHouse/pull/3037) [#3055](https://github.com/ClickHouse/ClickHouse/pull/3055) [#3065](https://github.com/ClickHouse/ClickHouse/pull/3065) [#3073](https://github.com/ClickHouse/ClickHouse/pull/3073) [#3090](https://github.com/ClickHouse/ClickHouse/pull/3090) [#3093](https://github.com/ClickHouse/ClickHouse/pull/3093)
-   修复了某些非凸多边形情况下的 `pointInPolygon` 函数. [#2910](https://github.com/ClickHouse/ClickHouse/pull/2910)
-   修复了将 `nan` 与整数进行比较时的错误结果. [#3024](https://github.com/ClickHouse/ClickHouse/pull/3024)
-   修复了在极少数情况下可能导致段错误的 `zlib-ng` 库中的错误. [#2854](https://github.com/ClickHouse/ClickHouse/pull/2854)
-   修复了在插入到具有 `AggregateFunction` 列的表时, 如果聚合函数的状态不简单 (单独分配内存) , 并且如果单个插入请求导致多个小块时的内存泄漏. [#3084](https://github.com/ClickHouse/ClickHouse/pull/3084)
-   修复了同时创建和删除同一个 `Buffer` 或 `MergeTree` 表时的竞争条件.
-   修复了比较由某些非平凡类型 (例如元组) 组成的元组时出现段错误的可能性. [#2989](https://github.com/ClickHouse/ClickHouse/pull/2989)
-   修复了运行某些 `ON CLUSTER` 查询时出现段错误的可能性. [Winter Zhang](https://github.com/ClickHouse/ClickHouse/pull/2960)
-   修复了 `arrayDistinct` 函数中 `Nullable` 数组元素的错误. [#2845](https://github.com/ClickHouse/ClickHouse/pull/2845) [#2937](https://github.com/ClickHouse/ClickHouse/pull/2937)
-   `enable_optimize_predicate_expression` 选项现在可以正确支持带有 `SELECT *` 的情况. [Winter Zhang](https://github.com/ClickHouse/ClickHouse/pull/2929)
-   修复了重新初始化 ZooKeeper 会话时的段错误. [#2917](https://github.com/ClickHouse/ClickHouse/pull/2917)
-   修复了使用 ZooKeeper 时潜在的阻塞问题.
-   修复了在 `SummingMergeTree` 中添加嵌套数据结构的错误代码.
-   为聚合函数的状态分配内存时, 正确地考虑了对齐, 这使得在实现聚合函数的状态时使用需要对齐的操作成为可能. [chenxing-xc](https://github.com/ClickHouse/ClickHouse/pull/2808)

#### 安全修复: {#security-fix}

-   安全使用 ODBC 数据源. 与 ODBC 驱动程序的交互使用单独的 `clickhouse-odbc-bridge` 过程. 第三方 ODBC 驱动程序中的错误不再导致服务器稳定性或漏洞问题. [#2828](https://github.com/ClickHouse/ClickHouse/pull/2828) [#2879](https://github.com/ClickHouse/ClickHouse/pull/2879) [#2886](https://github.com/ClickHouse/ClickHouse/pull/2886) [#2893](https://github.com/ClickHouse/ClickHouse/pull/2893) [#2921](https://github.com/ClickHouse/ClickHouse/pull/2921)
-   修复了 `catBoostPool` 表函数中文件路径的错误验证. [#2894](https://github.com/ClickHouse/ClickHouse/pull/2894)
-   系统表的内容 (`tables`、`databases`、`parts`、`columns`、`parts_columns`、`merges`、`mutations`、`replicas` 和 `replication_queue`) 根据用户配置进行过滤访问数据库(`allow_databases`). [Winter Zhang](https://github.com/ClickHouse/ClickHouse/pull/2856)

#### 向后不兼容的更新: {#backward-incompatible-changes-3}

-   在使用 JOIN 的查询中, 星号扩展为所有表中的列列表, 符合 SQL 标准. 您可以通过在用户配置级别将 `asterisk_left_columns_only` 设置为 1 来恢复旧行为.

#### Build 更新: {#build-changes-2}

-   大多数集成测试现在可以通过提交运行.
-   代码样式检查也可以通过提交运行.
-   在 CentOS7/Fedora 上构建时正确选择了 `memcpy` 实现. [Etienne Champetier](https://github.com/ClickHouse/ClickHouse/pull/2912)
-   When using clang to build, some warnings from `-Weverything` have been added, in addition to the regular `-Wall-Wextra -Werror`. [#2957](https://github.com/ClickHouse/ClickHouse/pull/2957)
-   调试构建使用 `jemalloc` 调试选项.
-   与 ZooKeeper 交互的库的接口被声明为抽象的. [#2950](https://github.com/ClickHouse/ClickHouse/pull/2950)

## ClickHouse 版本 18.10 {#clickhouse-release-18-10}

### ClickHouse 版本 18.10.3, 2018-08-13 {#clickhouse-release-18-10-3-2018-08-13}

#### 新特征: {#new-features-5}

-   HTTPS 可用于复制. [#2760](https://github.com/ClickHouse/ClickHouse/pull/2760)
-   除了现有的 `murmurHash2_32` 之外, 还添加了函数 `murmurHash2_64`、`murmurHash3_32`、`murmurHash3_64` 和 `murmurHash3_128`. [#2791](https://github.com/ClickHouse/ClickHouse/pull/2791)
-   支持 ClickHouse ODBC 驱动程序中的 Nullable 类型 (`ODBCDriver2` 输出格式). [#2834](https://github.com/ClickHouse/ClickHouse/pull/2834)
-   支持键列中的 `UUID`.

#### 改进: {#improvements-5}

-   从配置文件中删除集群时，无需重新启动服务器即可删除集群. [#2777](https://github.com/ClickHouse/ClickHouse/pull/2777)
-   从配置文件中删除外部字典时，无需重新启动服务器即可删除它们. [#2779](https://github.com/ClickHouse/ClickHouse/pull/2779)
-   为 `Kafka` 表引擎添加了 `SETTINGS` 支持. [Alexander Marshalov](https://github.com/ClickHouse/ClickHouse/pull/2781)
-   `UUID` 数据类型的改进 (尚未完成). [#2618](https://github.com/ClickHouse/ClickHouse/pull/2618)
-   支持在 `SummingMergeTree`、`CollapsingMergeTree` 和 `VersionedCollapsingMergeTree` 引擎中合并后的空部分. [#2815](https://github.com/ClickHouse/ClickHouse/pull/2815)
-   已完成突变的旧记录被删除 (`ALTER DELETE`). [#2784](https://github.com/ClickHouse/ClickHouse/pull/2784)
-   添加了 `system.merge_tree_settings` 表. [Kirill Shvakov](https://github.com/ClickHouse/ClickHouse/pull/2841)
-   `system.tables` 表现在有依赖列: `dependencies_database` 和 `dependencies_table`. [Winter Zhang](https://github.com/ClickHouse/ClickHouse/pull/2851)
-   添加了 `max_partition_size_to_drop` 配置选项. [#2782](https://github.com/ClickHouse/ClickHouse/pull/2782)
-   添加了 `output_format_json_escape_forward_slashes` 选项. [Alexander Bocharov](https://github.com/ClickHouse/ClickHouse/pull/2812)
-   添加了 `max_fetch_partition_retries_count` 设置. [#2831](https://github.com/ClickHouse/ClickHouse/pull/2831)
-   添加了 `prefer_localhost_replica` 设置, 用于禁用本地副本的首选项并在没有进程间交互的情况下转到本地副本. [#2832](https://github.com/ClickHouse/ClickHouse/pull/2832)
-   在对空的 `Float32` 或 `Float64` 集合进行聚合的情况下, `quantileExact` 聚合函数返回 `nan` . [Sundy Li](https://github.com/ClickHouse/ClickHouse/pull/2855)

#### Bug 修复: {#bug-fixes-14}

-   删除了 ODBC 连接字符串参数的不必要转义, 这使得无法建立连接. 此错误发生在 18.6.0 版本中.
-   修复了处理复制队列中 `REPLACE PARTITION` 命令的逻辑. 如果同一个分区有两个 `REPLACE` 命令, 不正确的逻辑可能会导致其中一个留在复制队列中而不会被执行. [#2814](https://github.com/ClickHouse/ClickHouse/pull/2814)
-   修复了所有数据部分为空时的合并错误 (如果所有数据都被删除, 则由合并或 `ALTER DELETE` 形成的部分). 这个bug出现在18.1.0版本. [#2930](https://github.com/ClickHouse/ClickHouse/pull/2930)
-   修复了并发 `Set` 或 `Join` 的错误. [Amos Bird](https://github.com/ClickHouse/ClickHouse/pull/2823)
-   修正了 `UNION流中的块结构不匹配: 列数不同` 错误, 如果一个 `SELECT` 查询包含重复的列名, 在子查询 `UNION ALL` 查询中发生的错误. [Winter Zhang](https://github.com/ClickHouse/ClickHouse/pull/2094)
-   修复了连接 MySQL 服务器时发生异常时的内存泄漏.
-   修复了查询错误时不正确的 clickhouse-client 响应代码.
-   修复了包含 DISTINCT 的物化视图的错误行为. [#2795](https://github.com/ClickHouse/ClickHouse/issues/2795)

#### 向后不兼容的更新: {#backward-incompatible-changes-4}

-   删除了对分布式表的 CHECK TABLE 查询的支持.

#### Build 更新: {#build-changes-3}

-   分配器已被替换: 现在使用 `jemalloc` 代替 `tcmalloc`. 在某些情况下, 这将速度提高到 20%. 但是, 有些查询速度降低了 20%. 部分场景内存消耗降低约10%, 稳定性提升. 在竞争激烈的负载下, 用户空间和系统中的 CPU 使用率仅略有增加. [#2773](https://github.com/ClickHouse/ClickHouse/pull/2773)
-   使用子模块中的 libressl. [#1983](https://github.com/ClickHouse/ClickHouse/pull/1983) [#2807](https://github.com/ClickHouse/ClickHouse/pull/2807)
-   从子模块使用 unixodbc. [#2789](https://github.com/ClickHouse/ClickHouse/pull/2789)
-   使用子模块中的 mariadb-connector-c. [#2785](https://github.com/ClickHouse/ClickHouse/pull/2785)
-   将依赖于测试数据可用性的功能测试文件添加到存储库中 (暂时没有测试数据本身).

## ClickHouse 版本 18.6 {#clickhouse-release-18-6}

### ClickHouse 版本 18.6.0, 2018-08-02 {#clickhouse-release-18-6-0-2018-08-02}

#### 新特征: {#new-features-6}

-   添加了对 JOIN ON 语法的 ON 表达式的支持:
    `JOIN ON Expr([table.]column ...) = Expr([table.]column, ...) [AND Expr([table.]column, ...) = Expr([table.]column, ...) ...]`
    表达式必须是由 AND 运算符连接的等式链. 等式的每一边都可以是一个表的列上的任意表达式. 支持对右表使用完全限定的列名 (`table.name`、`database.table.name`、`table_alias.name`、`subquery_alias.name`). [#2742](https://github.com/ClickHouse/ClickHouse/pull/2742)
-   可以启用 HTTPS 进行复制. [#2760](https://github.com/ClickHouse/ClickHouse/pull/2760)

#### 改进: {#improvements-6}

-   服务器将其版本的补丁组件传递给客户端. 关于补丁版本组件的数据在 `system.processes` 和 `query_log` 中. [#2646](https://github.com/ClickHouse/ClickHouse/pull/2646)

## ClickHouse 版本 18.5 {#clickhouse-release-18-5}

### ClickHouse 版本 18.5.1, 2018-07-31 {#clickhouse-release-18-5-1-2018-07-31}

#### 新特征: {#new-features-7}

-   添加了哈希函数 `murmurHash2_32`. [#2756](https://github.com/ClickHouse/ClickHouse/pull/2756).

#### 改进: {#improvements-7}

-   现在您可以使用 `from_env` [#2741](https://github.com/ClickHouse/ClickHouse/pull/2741) 属性从环境变量设置配置文件中的值.
-   添加了不区分大小写的 `coalesce`、`ifNull` 和 `nullIf 函数` [#2752](https://github.com/ClickHouse/ClickHouse/pull/2752).

#### Bug 修复: {#bug-fixes-15}

-   修复了启动副本时可能出现的错误 [#2759](https://github.com/ClickHouse/ClickHouse/pull/2759).

## ClickHouse 版本 18.4 {#clickhouse-release-18-4}

### ClickHouse 版本 18.4.0, 2018-07-28 {#clickhouse-release-18-4-0-2018-07-28}

#### 新特征: {#new-features-8}

-   添加系统表: `formats`、`data_type_families`、`aggregate_function_combinators`、`table_functions`、`table_engines`、`collations` [#2721](https://github.com/ClickHouse/ClickHouse/pull/2721).
-   添加了使用表函数而不是表作为 `remote` 或`cluster table function` 的参数的功能 [#2708](https://github.com/ClickHouse/ClickHouse/pull/2708).
-   支持复制协议中的 `HTTP Basic` 身份验证 [#2727](https://github.com/ClickHouse/ClickHouse/pull/2727).
-   `has` 函数现在允许在 `Enum` 值数组中搜索数值 [Maxim Khrisanfov](https://github.com/ClickHouse/ClickHouse/pull/2699).
-   支持在从 `Kafka` 读取时添加任意消息分隔符 [Amos Bird](https://github.com/ClickHouse/ClickHouse/pull/2701).

#### 改进: {#improvements-8}

-   `ALTER TABLE t DELETE WHERE` 查询不会重写不受 WHERE 条件影响的数据部分 [#2694](https://github.com/ClickHouse/ClickHouse/pull/2694).
-   `ReplicatedMergeTree` 表的 `use_minimalistic_checksums_in_zookeeper` 选项默认启用. 此设置是在 1.1.54378, 2018-04-16 版本中添加的. 不能再安装早于 1.1.54378 的版本.
-   支持运行指定 `ON CLUSTER` 的 `KILL` 和 `OPTIMIZE` 查询 [Winter Zhang](https://github.com/ClickHouse/ClickHouse/pull/2689).

#### Bug 修复: {#bug-fixes-16}

-   修复了错误 `Column ... is not under a aggregate function and not in GROUP BY` 用于使用 IN 表达式进行聚合. 这个bug出现在18.1.0版本 ([bbdd780b](https://github.com/ClickHouse/ClickHouse/commit/bbdd780be0be06a0f336775941cdd536878dd2c2))
-   修复了 `windowFunnel aggregate function` 中的一个错误 [Winter Zhang](https://github.com/ClickHouse/ClickHouse/pull/2735).
-   修复了 `anyHeavy` 聚合函数中的错误 ([a2101df2](https://github.com/ClickHouse/ClickHouse/commit/a2101df25a6a0fba99aa71f8793d762af2b801ee))
-   修复了使用 `countArray()` 聚合函数时服务器崩溃的问题.

#### 向后不兼容的更新: {#backward-incompatible-changes-5}

-   `Kafka` 引擎的参数已从 `Kafka(kafka_broker_list, kafka_topic_list, kafka_group_name, kafka_format[, kafka_schema, kafka_num_consumers])` 更改为 `Kafka(kafka_broker_list, kafka_topic_list, kafka_topic_list, kafka_fka_name_schema_fka_format, kafka_fka_name_schema_group_format[, kafka_schema, kafka_num_consumers])` 如果您的表使用`kafka_schema` 或`kafka_num_consumers` 参数, 则必须手动编辑元数据文件`path/metadata/database/table.sql` 并添加具有`''` 值的`kafka_row_delimiter` 参数.

## ClickHouse 版本 18.1 {#clickhouse-release-18-1}

### ClickHouse 版本 18.1.0, 2018-07-23 {#clickhouse-release-18-1-0-2018-07-23}

#### 新特征: {#new-features-9}

-   支持对非复制 MergeTree 表的 `ALTER TABLE t DELETE WHERE` 查询 ([#2634](https://github.com/ClickHouse/ClickHouse/pull/2634)).
-   支持 `uniq*` 聚合函数系列的任意类型 ([#2010](https://github.com/ClickHouse/ClickHouse/issues/2010)).
-   支持比较运算符中的任意类型 ([#2026](https://github.com/ClickHouse/ClickHouse/issues/2026)).
-   `users.xml` 文件允许设置格式为 `10.0.0.1/255.255.255.0` 的子网掩码. 这对于在中间为 0 的 IPv6 网络使用掩码是必要的 ([#2637](https://github.com/ClickHouse/ClickHouse/pull/2637)).
-   添加了 `arrayDistinct` 函数 ([#2670](https://github.com/ClickHouse/ClickHouse/pull/2670)).
-   SummingMergeTree 引擎现在可以处理 AggregateFunction 类型的列 ([Constantin S. Pan](https://github.com/ClickHouse/ClickHouse/pull/2566)).

#### 改进: {#improvements-9}

-   更改了发布版本的编号方案. 现在第一部分包含发布年份 (莫斯科时区, 公元2000年), 第二部分包含主要更改的编号(大多数版本增加), 第三部分是补丁版本. 除非在变更日志中另有说明.否则版本仍然向后兼容.
-   更快地将浮点数转换为字符串. ([Amos Bird](https://github.com/ClickHouse/ClickHouse/pull/2664)).
-   如果在插入期间由于解析错误而跳过了某些行 (这在启用 `input_allow_errors_num` 和 `input_allow_errors_ratio` 设置的情况下是可能的), 跳过的行数现在会写入服务器日志([Leonardo Cecchi](https://github.com/ClickHouse/ClickHouse/pull/2669)).

#### Bug 修复: {#bug-fixes-17}

-   修复了临时表的 TRUNCATE 命令. ([Amos Bird](https://github.com/ClickHouse/ClickHouse/pull/2624)).
-   修复了 ZooKeeper 客户端库中读取响应时出现网络错误时发生的罕见死锁 ([c315200](https://github.com/ClickHouse/ClickHouse/commit/c315200e64b87e44bdf740707fc857d1fdf7e947)).
-   修复了 CAST 到 Nullable 类型期间的错误([#1322](https://github.com/ClickHouse/ClickHouse/issues/1322)).
-   修复了区间边界重合时 `maxIntersection()` 函数的错误结果 ([Michael Furmur](https://github.com/ClickHouse/ClickHouse/pull/2657)).
-   修复了函数参数中 OR 表达式链的错误转换 ([chenxing-xc](https://github.com/ClickHouse/ClickHouse/pull/2663)).
-   修复了在另一个子查询中包含 `IN(子查询)` 表达式的查询的性能下降 ([#2571](https://github.com/ClickHouse/ClickHouse/issues/2571)).
-   修复了使用非大写字母的 `CAST` 函数的分布式查询中不同版本服务器之间的不兼容问题 ([fe8c4d6](https://github.com/ClickHouse/ClickHouse/commit/fe8c4d64e434cacd4ceef34faa9005129f2190a5)).
-   添加了对外部 DBMS 的查询标识符的缺失引用 ([#2635](https://github.com/ClickHouse/ClickHouse/issues/2635)).

#### 向后不兼容的更新: {#backward-incompatible-changes-6}

-   将包含数字零的字符串转换为 DateTime 不起作用. 示例: `SELECT toDateTime('0')`. 这也是 `DateTime DEFAULT '0'` 在表中不起作用的原因, 以及在字典中 `<null_value>0</null_value>` 的原因. 解决方案: 用`0000-00-00 00:00:00`替换`0`.

## ClickHouse 版本 1.1 {#clickhouse-release-1-1}

### ClickHouse 版本 1.1.54394, 2018-07-12 {#clickhouse-release-1-1-54394-2018-07-12}

#### 新特征: {#new-features-10}

-   添加了 `histogram` 聚合函数 ([Mikhail Surin](https://github.com/ClickHouse/ClickHouse/pull/2521)).
-   现在可以使用 `OPTIMIZE TABLE ... FINAL` 而无需为 `ReplicatedMergeTree` 指定分区 ([Amos Bird](https://github.com/ClickHouse/ClickHouse/pull/2600)).

#### Bug 修复: {#bug-fixes-18}

-   修复了发送和下载复制数据时套接字读写超时 (一秒) 非常小的问题, 这使得如果网络或磁盘上有负载, 则无法下载较大的部分 (导致循环尝试 下载部分). 此错误发生在 1.1.54388 版本中.
-   修复了在表中插入重复数据块时在 ZooKeeper 中使用 chroot 时的问题.
-   `has` 函数现在可以正确处理具有 Nullable 元素的数组 ([#2115](https://github.com/ClickHouse/ClickHouse/issues/2115)).
-   `system.tables` 表在分布式查询中使用时可以正常工作. `metadata_modification_time` 和 `engine_full` 列现在是非虚拟的. 修复了仅从表中查询这些列时发生的错误.
-   修复了插入空数据块后空 `TinyLog` 表的工作方式 ([#2563](https://github.com/ClickHouse/ClickHouse/issues/2563)).
-   如果 ZooKeeper 中节点的值为 NULL, 则 `system.zookeeper` 表有效.

### ClickHouse 版本 1.1.54390, 2018-07-06 {#clickhouse-release-1-1-54390-2018-07-06}

#### 新特征: {#new-features-11}

-   查询可以以 `multipart/form-data` 格式发送(在 `query` 字段中), 如果外部数据也被发送用于查询处理 ([Olga Hvostikova](https://github.com/ClickHouse/ClickHouse/pull/2490)).
-   添加了在以 CSV 格式读取数据时启用或禁用处理单引号或双引号的功能. 您可以在 `format_csv_allow_single_quotes` 和 `format_csv_allow_double_quotes` 设置中进行配置 ([Amos Bird](https://github.com/ClickHouse/ClickHouse/pull/2574)).
-   现在可以使用 `OPTIMIZE TABLE ... FINAL` 而不指定 `MergeTree` 的非复制变体的分区 ([Amos Bird](https://github.com/ClickHouse/ClickHouse/pull/2599)).

#### 改进: {#improvements-10}

-   当可以使用表索引时，通过使用 IN 运算符提高性能、减少内存消耗和正确的内存消耗跟踪 ([#2584](https://github.com/ClickHouse/ClickHouse/pull/2584)).
-   添加数据部分时删除了校验和的冗余检查. 这在有大量副本时很重要, 因为在这些情况下, 检查总数等于 N^2.
-   为 `arrayEnumerateUniq` 函数添加了对 `Array(Tuple(...))` 参数的支持 ([#2573](https://github.com/ClickHouse/ClickHouse/pull/2573)).
-   为 `runningDifference` 函数添加了 `Nullable` 支持 ([#2594](https://github.com/ClickHouse/ClickHouse/pull/2594)).
-   提高了表达式数量非常多时的查询分析性能 ([#2572](https://github.com/ClickHouse/ClickHouse/pull/2572)).
-   更快地选择要合并到 `ReplicatedMergeTree` 表中的数据部分. ZooKeeper 会话的更快恢复 ([#2597](https://github.com/ClickHouse/ClickHouse/pull/2597)).
-   `MergeTree` 表的 `format_version.txt` 文件如果丢失则重新创建, 如果在复制没有文件的目录结构后启动 ClickHouse, 这是有意义的 ([Ciprian Hacman](https://github.com/ClickHouse/ClickHouse/pull/2593)).

#### Bug 修复: {#bug-fixes-19}

-   修复了使用 ZooKeeper 时无法在重新启动服务器之前恢复会话和表的只读状态的错误.
-   修复了使用 ZooKeeper 时可能导致会话中断时旧节点不会被删除的错误.
-   修复了 Float 参数的 `quantileTDigest` 函数中的错误 (这个错误是在 1.1.54388 版本中引入的) ([Mikhail Surin](https://github.com/ClickHouse/ClickHouse/pull/2553)).
-   如果主键列位于相同大小的有符号和无符号整数之间的类型转换函数内, 则修复了 MergeTree 表的索引中的错误 ([#2603](https://github.com/ClickHouse/ClickHouse/pull/2603)).
-   如果使用了宏但它们不在配置文件中, 则修复了段错误 ([#2570](https://github.com/ClickHouse/ClickHouse/pull/2570)).
-   修复重新连接客户端时切换到默认数据库的问题 ([#2583](https://github.com/ClickHouse/ClickHouse/pull/2583)).
-   修复了禁用 `use_index_for_in_with_subqueries` 设置时发生的错误.

#### 安全修复: {#security-fix-1}

-   连接到 MySQL 时不再可能发送文件 (`LOAD DATA LOCAL INFILE`).

### ClickHouse 版本 1.1.54388, 2018-06-28 {#clickhouse-release-1-1-54388-2018-06-28}

#### 新特征: {#new-features-12}

-   支持对复制表的 `ALTER TABLE t DELETE WHERE` 查询. 添加了 `system.mutations` 表以跟踪此类查询的进度.
-   支持对 \*MergeTree 表的 `ALTER TABLE t [REPLACE|ATTACH] PARTITION` 查询.
-   支持`TRUNCATE TABLE`查询 ([Winter Zhang](https://github.com/ClickHouse/ClickHouse/pull/2260)).
-   几个新的复制表的 `SYSTEM` 查询 (`RESTART REPLICAS`, `SYNC REPLICA`, `[STOP|START] [MERGES|FETCHES|SENDS REPLICATED|REPLICATION QUEUES]`).
-   增加了使用 MySQL 引擎写表的能力和对应的表函数 ([sundy-li](https://github.com/ClickHouse/ClickHouse/pull/2294)).
-   添加了 `url()` 表函数和 `URL` 表引擎 ([Alexander Sapin](https://github.com/ClickHouse/ClickHouse/pull/2501)).
-   添加了 `windowFunnel` 聚合函数 ([sundy-li](https://github.com/ClickHouse/ClickHouse/pull/2352)).
-   字符串的新 `startsWith` 和 `endsWith` 函数 ([Vadim Plakhtinsky](https://github.com/ClickHouse/ClickHouse/pull/2429)).
-   `numbers()` 表函数现在允许您指定偏移量 ([Winter Zhang](https://github.com/ClickHouse/ClickHouse/pull/2535)).
-   `clickhouse-client` 的密码可以交互输入.
-   服务器日志现在可以发送到系统日志 ([Alexander Krasheninnikov](https://github.com/ClickHouse/ClickHouse/pull/2459)).
-   支持使用共享库源登录词典 ([Alexander Sapin](https://github.com/ClickHouse/ClickHouse/pull/2472)).
-   支持自定义 CSV 分隔符 ([Ivan Zhukov](https://github.com/ClickHouse/ClickHouse/pull/2263)).
-   添加了 `date_time_input_format` 设置. 如果将此设置切换为 `best_effort`, 则会以多种格式读取 DateTime 值.
-   添加了用于数据混淆的 `clickhouse-obfuscator` 实用程序. 使用示例: 发布性能测试中使用的数据.

#### 实验功能: {#experimental-features-2}

-   添加了仅在需要的地方计算 `and` 参数的功能 ([Anastasia Tsarkova](https://github.com/ClickHouse/ClickHouse/pull/2272)).
-   一些表达式现在可以 JIT 编译为本机代码 ([pyos](https://github.com/ClickHouse/ClickHouse/pull/2277)).

#### Bug 修复: {#bug-fixes-20}

-   使用 `DISTINCT` 和 `ORDER BY` 查询不再出现重复.
-   使用`ARRAY JOIN` 和 `arrayFilter` 的查询不再返回不正确的结果.
-   修复了从嵌套结构中读取数组列时的错误 ([#2066](https://github.com/ClickHouse/ClickHouse/issues/2066)).
-   修复了使用 HAVING 子句 (如 `HAVING tuple IN (...)`) 分析查询时的错误.
-   修复了使用递归别名分析查询时的错误.
-   修复了从 ReplacingMergeTree 读取时的错误，在 PREWHERE 中使用过滤所有行的条件 ([#2525](https://github.com/ClickHouse/ClickHouse/issues/2525)).
-   在 HTTP 界面中使用会话时未应用用户配置文件设置.
-   修复了如何从 clickhouse-local 中的命令行参数应用设置.
-   ZooKeeper 客户端库现在使用从服务器收到的会话超时.
-   修复了 ZooKeeper 客户端库中客户端等待服务器响应时间超过超时时间的错误.
-   修复了分区键列条件查询的部分修剪 ([#2342](https://github.com/ClickHouse/ClickHouse/issues/2342)).
-   现在可以在 `CLEAR COLUMN IN PARTITION` 之后进行合并 ([#2315](https://github.com/ClickHouse/ClickHouse/issues/2315)).
-   修复了 ODBC 表函数中的类型映射 ([sundy-li](https://github.com/ClickHouse/ClickHouse/pull/2268)).
-   已修复带和不带时区的 `DateTime` 的类型比较 ([Alexander Bocharov](https://github.com/ClickHouse/ClickHouse/pull/2400)).
-   修复了 `CAST` 运算符的语法解析和格式设置.
-   固定插入到分布式表引擎的物化视图中 ([Babacar Diassé](https://github.com/ClickHouse/ClickHouse/pull/2411)).
-   修复了将数据从 `Kafka` 引擎写入物化视图时的竞争条件 ([Yangkuan Liu](https://github.com/ClickHouse/ClickHouse/pull/2448)).
-   修复了 remote() 表函数中的 SSRF.
-   修复了多行模式下 `clickhouse-client` 的退出行为 ([#2510](https://github.com/ClickHouse/ClickHouse/issues/2510)).

#### 改进: {#improvements-11}

-   复制表中的后台任务现在在线程池中执行，而不是在单独的线程中执行 ([Silviu Caragea](https://github.com/ClickHouse/ClickHouse/pull/1722)).
-   提高LZ4压缩性能.
-   对具有大量 JOIN 和子查询的查询进行更快的分析.
-   当网络错误过多时，DNS 缓存现在会自动更新.
-   如果由于其中一个物化视图有太多的部件而无法插入表，则不会再插入表.
-   更正了事件计数器 `Query`、`SelectQuery` 和 `InsertQuery` 中的差异.
-   如果元组类型匹配，则允许使用诸如 `tuple IN (SELECT tuple)` 之类的表达式.
-   即使您尚未配置 ZooKeeper，具有复制表的服务器也可以启动.
-   在计算可用 CPU 内核数时，现在考虑了 cgroup 的限制 ([Atri Sharma](https://github.com/ClickHouse/ClickHouse/pull/2325)).
-   在 systemd 配置文件中为配置目录添加了 chown ([Mikhail Shiryaev](https://github.com/ClickHouse/ClickHouse/pull/2421)).

#### Build 更新: {#build-changes-4}

-   gcc8 编译器可用于构建.
-   添加了从子模块构建 llvm 的功能.
-   ibrdkafka 库版本已更新至 v0.11.4.
-   添加了使用系统 libcpuid 库的功能. 库版本已更新至 0.4.0.
-   使用矢量类库修复了构建 ([Babacar Diassé](https://github.com/ClickHouse/ClickHouse/pull/2274)).
-   Cmake 现在默认为 ninja 生成文件 (就像使用 `-G Ninja` 时一样).
-   添加了使用 libtinfo 库代替 libtermcap 的功能 ([Georgy Kondratiev](https://github.com/ClickHouse/ClickHouse/pull/2519)).
-   修复了 Fedora Rawhide 中的头文件冲突 ([#2520](https://github.com/ClickHouse/ClickHouse/issues/2520)).

#### 向后不兼容的更新: {#backward-incompatible-changes-7}

-   删除了 `Vertical` 和 `Pretty*` 格式的转义并删除了 `VerticalRaw` 格式.
-   如果在分布式查询中同时使用版本 1.1.54388(或更高版本)和旧版本的服务器，并且查询具有不带 `AS` 关键字的 `cast(x, 'Type')` 表达式并且没有大写的 `cast` 一词, 将抛出异常, 并显示类似 `Not found column cast(0, 'UInt8') in block` 的消息. 解决方案: 更新整个集群上的服务器.

### ClickHouse 版本 1.1.54385, 2018-06-01 {#clickhouse-release-1-1-54385-2018-06-01}

#### Bug 修复: {#bug-fixes-21}

-   修复了某些情况下导致 ZooKeeper 操作阻塞的错误.

### ClickHouse 版本 1.1.54383, 2018-05-22 {#clickhouse-release-1-1-54383-2018-05-22}

#### Bug 修复: {#bug-fixes-22}

-   修复了一个表有很多副本时复制队列变慢的问题.

### ClickHouse Rel版本ease 1.1.54381, 2018-05-14 {#clickhouse-release-1-1-54381-2018-05-14}

#### Bug 修复: {#bug-fixes-23}

-   修复了当 ClickHouse 与 ZooKeeper 服务器失去连接时 ZooKeeper 中的节点泄漏.

### ClickHouse 版本 1.1.54380, 2018-04-21 {#clickhouse-release-1-1-54380-2018-04-21}

#### 新特征: {#new-features-13}

-   添加了表函数 `file(path, format, structure)`. 从 `/dev/urandom` 读取字节的示例: ``` ln -s /dev/urandom /var/lib/clickhouse/user_files/random``clickhouse-client -q "SELECT * FROM file('random', ' RowBinary', 'd UInt8') LIMIT 10" ```.

#### 改进: {#improvements-12}

-   子查询可以包含在 `()` 括号中以提高查询的可读性. 例如: `(SELECT 1) UNION ALL (SELECT 1)`.
-   来自 `system.processes` 表的简单 `SELECT` 查询不包括在 `max_concurrent_queries` 限制中.

#### Bug 修复: {#bug-fixes-24}

-   修复了从 `物质化视图` 中选择时 `IN` 运算符的错误行为.
-   修复了在 `partition_key_column IN (...)` 等表达式中按分区索引不正确的过滤.
-   修复了如果在表上执行了 `REANAME`，则无法在非领导副本上执行 `OPTIMIZE` 查询.
-   修复了在非领导副本上执行 `OPTIMIZE` 或 `ALTER` 查询时的授权错误.
-   修复了 `KILL QUERY` 的冻结问题.
-   修复了 ZooKeeper 客户端库中的一个错误，如果在 ZooKeeper 配置中使用非空的 `chroot` 前缀，该错误会导致监视丢失、分布式 DDL 队列冻结以及复制队列变慢.

#### 向后不兼容的更新: {#backward-incompatible-changes-8}

-   删除了对像 `(a, b) IN (SELECT (a, b))` 这样的表达式的支持 (你可以使用等价的表达式 `(a, b) IN (SELECT a, b)`). 在以前的版本中, 这些表达式会导致未确定的 `WHERE` 过滤或导致错误.

### ClickHouse 版本 1.1.54378, 2018-04-16 {#clickhouse-release-1-1-54378-2018-04-16}

#### 新特征: {#new-features-14}

-   无需重新启动服务器即可更改日志级别.
-   添加了 `SHOW CREATE DATABASE` 查询.
-   `query_id` 可以传递给 `clickhouse-client` (elBroom).
-   新设置：`max_network_bandwidth_for_all_users`.
-   为 `MATERIALIZED VIEW` 添加了对 `ALTER TABLE ... PARTITION ...` 的支持.
-   在系统表中添加了有关未压缩形式的数据部分大小的信息.
-   分布式表的服务器到服务器加密支持( `<remote_servers>` 中的副本配置中的 `<secure>1</secure>`).
-   `ReplicatedMergeTree` 系列的表级别配置以最小化 Zookeeper 中存储的数据量: `use_minimalistic_checksums_in_zookeeper = 1`
-   `clickhouse-client` 提示的配置. 默认情况下, 服务器名称现在会输出到提示中. 服务器的显示名称可以更改. 它还在 `X-ClickHouse-Display-Name` HTTP 标头中发送 (Kirill Shvakov).
-   可以为 `Kafka` 引擎指定多个逗号分隔的 `topics` (Tobias Adamson)
-   当查询被 `KILL QUERY` 或 `replace_running_query` 停止时，客户端会收到 `Query was cancelled` 异常而不是不完整的结果.

#### 改进: {#improvements-13}

-   `ALTER TABLE ... DROP/DETACH PARTITION` 查询在复制队列的前面运行.
-   `SELECT ... FINAL` 和 `OPTIMIZE ... FINAL` 可以在表只有一个数据部分时使用.
-   如果手动删除了 `query_log` 表，则会即时重新创建它 (Kirill Shvakov).
-   `lengthUTF8` 函数运行速度更快 (zhang2014).
-   当分片数量非常多时，提高了在 `分布式` 表 (`insert_distributed_sync = 1`) 中同步插入的性能.
-   服务器接受来自客户端的 `send_timeout` 和 `receive_timeout` 设置，并在连接到客户端时应用它们 (它们以相反的顺序应用：服务器套接字的 `send_timeout` 设置为从客户端接收到的 `receive_timeout` 值, 反之亦然).
-   用于异步插入 `Distributed` 表的更强大的崩溃恢复.
-   `countEqual` 函数的返回类型从 `UInt32` 更改为 `UInt64` (谢磊).

#### Bug 修复: {#bug-fixes-25}

-   修复了表达式左侧为 `Nullable` 时 `IN` 的错误.
-   当某些元组组件在表索引中时，现在使用带有 `IN` 的元组时会返回正确的结果.
-   `max_execution_time` 限制现在可以在分布式查询中正常工作.
-   修复了计算 `system.columns` 表中复合列大小时的错误.
-   修复了创建临时表 `CREATE TEMPORARY TABLE IF NOT EXISTS` 时的错误.
-   修复了 `StorageKafka` 中的错误 (##2075)
-   固定服务器因某些聚合函数的无效参数而崩溃.
-   修复了阻止`DETACH DATABASE` 查询停止 `ReplicatedMergeTree` 表的后台任务的错误.
-   插入聚合物化视图时，不太可能发生 `Too many parts` 状态 (##2084).
-   如果替换必须跟在同一级别的另一个替换之后，则更正了配置中替换的递归处理.
-   在创建使用带有 `UNION ALL` 的查询的 `VIEW` 时更正了元数据文件中的语法.
-   `SummingMergeTree` 现在可以正确地使用复合键对嵌套数据结构求和.
-   修复了在为 `ReplicatedMergeTree` 表选择领导者时出现竞争条件的可能性.

#### Build 更新: {#build-changes-5}

-   构建支持 `ninja` 而不是 `make`，并且默认使用 `ninja` 来构建版本.
-   重命名包：`clickhouse-common-static`中的`clickhouse-server-base`;  `clickhouse-server` 中的 `clickhouse-server-common`; `clickhouse-common-static-dbg` 中的 `clickhouse-common-dbg`. 要安装, 请使用 `clickhouse-server clickhouse-client` . 具有旧名称的包仍将加载到存储库中以实现向后兼容性.

#### 向后不兼容的更新: {#backward-incompatible-changes-9}

-   如果在左侧指定了数组, 则删除了 IN 表达式的特殊解释. 以前, 表达式 `arr IN (set)` 被解释为"at least one `arr` 元素属于 `set`". 要在新版本中获得相同的行为, 请编写 `arrayExists(x -> x IN (set), arr)`.
-   禁用套接字选项`SO_REUSEPORT` 的错误使用，该选项默认在 Poco 库中被错误启用. 请注意, 在 Linux 上，不再有任何理由同时指定地址 `::` 和 `0.0.0.0` 用于侦听 – 仅使用 `::`, 它允许侦听通过 IPv4 和 IPv6 的连接(默认情况下) 内核配置设置）. 您还可以通过在配置中指定 `<listen_reuse_port>1</listen_reuse_port>` 来恢复以前版本的行为.

### ClickHouse 版本 1.1.54370, 2018-03-16 {#clickhouse-release-1-1-54370-2018-03-16}

#### 新特征: {#new-features-15}

-   添加了 `system.macros` 表和更改配置文件时宏的自动更新.
-   添加了 `SYSTEM RELOAD CONFIG` 查询.
-   新增`maxIntersections(left_col, right_col)`聚合函数, 返回最大同时相交区间数`[left; 对]`. `maxIntersectionsPosition(left, right)` 函数返回 "maximum" 间隔的开始. ([Michael Furmur](https://github.com/ClickHouse/ClickHouse/pull/2012)).

#### 改进: {#improvements-14}

-   在 `Replicated` 表中插入数据时, 对 `ZooKeeper` 的请求较少(并且大多数用户级错误已从 `ZooKeeper` 日志中消失).
-   添加了为数据集创建别名的功能. 示例: `WITH (1, 2, 3) AS set SELECT number IN set FROM system.numbers LIMIT 10`.

#### Bug 修复: {#bug-fixes-26}

-   修复了从 `Distributed` 表的合并表读取时的 `Illegal PREWHERE` 错误.
-   添加了允许您在仅支持 IPv4 的 Docker 容器中启动 clickhouse-server 的修复程序.
-   修复了从系统 `system.parts_columns` 表读取时的竞争条件.
-   在同步插入到 `Distributed` 表期间删除了双缓冲，这可能会导致连接超时.
-   修复了在开始 `SELECT` 查询之前导致等待不可用副本过长的错误.
-   修复了 `system.parts` 表中不正确的日期.
-   修复了如果在 `ZooKeeper` 集群的配置中 `chroot` 不为空, 则无法在 `Replicated` 表中插入数据的错误.
-   修复了空 `ORDER BY` 表的垂直合并算法.
-   恢复了在对远程表的查询中使用字典的能力, 即使这些字典不存在于请求者服务器上. 此功能在 1.1.54362 版中丢失.
-   当 `IN` 的右侧应该使用远程 `default.table` 时, 恢复了诸如 `SELECT * FROM remote('server2', default.table) WHERE col IN (SELECT col2 FROM default.table)` 之类的查询行为而不是本地的. 此行为在 1.1.54358 版本中被破坏.
-   删除了 `Not found column ... in block` 的无关错误级日志记录.

### ClickHouse 版本 1.1.54362, 2018-03-11 {#clickhouse-release-1-1-54362-2018-03-11}

#### 新特征: {#new-features-16}

-   带 `GROUP BY` 的空集 (例如 `SELECT count(*) FROM table WHERE 0`) 的聚合现在返回一个结果, 其中一行带有聚合函数的空值, 符合 SQL 标准. 要恢复旧行为 (返回空结果), 请将 `empty_result_for_aggregation_by_empty_set` 设置为 1.
-   为 `UNION ALL` 添加了类型转换. `UNION ALL` 中的 `SELECT` 位置允许不同的别名, 符合SQL标准.
-   `LIMIT BY` 子句支持任意表达式. 以前, 只能使用由`SELECT`产生的列.
-   当将 `IN` 应用于主键列中的表达式元组时, 将使用 `MergeTree` 表的索引. 示例: `WHERE (UserID, EventDate) IN ((123, '2000-01-01'), ...)` (Anastasiya Tsarkova).
-   添加了用于在集群之间复制和重新分片数据的 `clickhouse-copier` 工具(测试版).
-   加了一致性哈希函数: `yandexConsistentHash`、`jumpConsistentHash`、`sumburConsistentHash`. 它们可以用作分片键, 以减少后续重新分片期间的网络流量.
-   添加函数: `arrayAny`, `arrayAll`, `hasAny`, `hasAll`, `arrayIntersect`, `arrayResize`.
-   添加了 `arrayCumSum` 函数 (Javi Santana).
-   添加了 `parseDateTimeBestEffort`、`parseDateTimeBestEffortOrZero` 和 `parseDateTimeBestEffortOrNull` 函数以从包含各种可能格式的文本的字符串中读取 DateTime.
-   更新期间可以从外部字典中部分重新加载数据 (仅加载指定字段的值大于先前下载的记录) (Arsen Hakobyan).
-   添加了 `cluster` 表功能. 示例: `cluster(cluster_name, db, table)`。 `remote` 表函数可以接受集群名称作为第一个参数, 如果它被指定为标识符.
-   `remote` 和 `cluster` 表函数可用于 `INSERT` 查询.
-   将 `create_table_query` 和 `engine_full` 虚拟列添加到 `system.tables`表. `metadata_modification_time` 列是虚拟的.
-   将 `data_path` 和 `metadata_path` 列添加到 `system.tables` 和 `system.databases` 表, 并将 `path` 列添加到 `system.parts` 和 `system.parts_columns` 表.
-   在 `system.part_log` 表中添加了有关合并的附加信息.
-   `system.query_log` 表可以使用任意分区键 (Kirill Shvakov).
-   `SHOW TABLES` 查询现在也显示临时表. 添加临时表和 `is_temporary` 列到 `system.tables` (zhang2014).
-   添加了`DROP TEMPORARY TABLE`和`EXISTS TEMPORARY TABLE`查询 (zhang2014).
-   支持临时表的 `SHOW CREATE TABLE`  (zhang2014).
-   为内部进程使用的设置添加了`system_profile`配置参数.
-   支持加载 `object_id` 作为 `MongoDB` 字典中的属性 (Pavel Litvinenko).
-   使用 `MongoDB` 源加载外部字典的数据时, 将 `null` 作为默认值读取 (Pavel Litvinenko).
-   从没有单引号的 Unix 时间戳中读取 `Values` 格式的 `DateTime` 值.
-   在某些副本缺少请求的表的情况下, `remote` 表函数支持故障转移.
-   当您运行 `clickhouse-server` 时，可以在命令行中覆盖配置设置. 示例: `clickhouse-server -- --logger.level=information`.
-   从 `FixedString` 参数实现了 `empty` 函数: 如果字符串完全由空字节组成, 该函数返回 1 (zhang2014).
-   添加了`listen_try`配置参数, 用于在不退出的情况下至少侦听一个侦听地址, 如果某些地址无法侦听 (对于禁用对 IPv4 或 IPv6 支持的系统很有用).
-   添加了 `VersionedCollapsingMergeTree` 表引擎.
-   支持`library` 字典源的行和任意数字类型.
-   `MergeTree` 表可以在没有主键的情况下使用 (你需要指定 `ORDER BY tuple()`).
-   如果参数不是 `NULL` , 则 `Nullable` 类型可以 `CAST` 到非 `Nullable` 类型.
-   可以为 `VIEW` 执行 `RENAME TABLE` .
-   添加了 `throwIf` 函数.
-   添加了 `odbc_default_field_size` 选项, 它允许您扩展从 ODBC 源加载的值的最大大小 (默认为 1024).
-   `system.processes` 表和 `SHOW PROCESSLIST` 现在有 `is_cancelled` 和 `peak_memory_usage` 列.

#### 改进: {#improvements-15}

-   结果的限制和配额不再应用于 `INSERT SELECT` 查询或 `SELECT` 子查询的中间数据.
-   在服务器启动时检查 `Replicated` 表的状态时, 更少的 `force_restore_data` 错误触发器.
-   添加了 `allow_distributed_ddl` 选项.
-   `MergeTree` 表键的表达式中不允许使用不确定性函数.
-   从 `config.d` 目录替换的文件按字母顺序加载.
-   在将空数组作为元素之一的常量多维数组的情况下, 改进了 `arrayElement` 函数的性能. 示例: `[[1], []][x]`.
-   当使用具有非常大的替换 (例如, 非常大的 IP 网络列表) 的配置文件时, 服务器现在启动速度更快.
-   运行查询时, 表值函数运行一次. 以前, `remote` 和 `mysql` 表值函数执行相同的查询两次以从远程服务器检索表结构.
-   使用了 `MkDocs` 文档生成器.
-   当您尝试删除其他列的 `DEFAULT` / `MATERIALIZED` 表达式所依赖的表列时, 抛出异常 (zhang2014).
-   添加了将文本格式中的空行解析为 `Float` 数据类型的数字 0 的功能. 此功能以前可用, 但在版本 1.1.54342 中丢失.
-   `Enum` 值可用于 `min`、`max`、`sum` 和其他一些函数. 在这些情况下, 它使用相应的数值. 此功能以前可用, 但在 1.1.54337 版本中丢失.
-   添加了 `max_expanded_ast_elements` 以限制递归扩展别名后 AST 的大小.

#### Bug 修复: {#bug-fixes-27}

-   修复了错误地从子查询中删除不必要的列, 或未从包含 `UNION ALL` 的子查询中删除的情况.
-   修复了 `ReplaceMergeTree` 表的合并错误.
-   修复了 `Distributed` 表中的同步插入 (`insert_distributed_sync = 1`).
-   修复了子查询中重复列的 `FULL` 和 `RIGHT JOIN` 的某些用途的段错误.
-   修复了`replace_running_query`和`KILL QUERY`的某些用途的段错误.
-   修复了 `system.dictionaries` 表中 `source` 和 `last_exception` 列的顺序.
-   修复了 `DROP DATABASE` 查询未删除带有元数据的文件时的错误.
-   修复了 `Dictionary` 数据库的 `DROP DATABASE` 查询.
-   修复了基数大于 1 亿项的 `uniqHLL12` 和 `uniqCombined` 函数的低精度问题 (Alex Bocharov).
-   修复了在需要同时计算 INSERT 查询中的默认显式表达式时隐式默认值的计算 (zhang2014).
-   修复了对 `MergeTree` 表的查询无法完成的罕见情况 (chenxing-xc).
-   修复了在所有分片都是本地的情况下对 `Distributed` 表运行 `CHECK` 查询时发生的崩溃 (chenxing.xc).
-   修复了使用正则表达式的函数的轻微性能回归.
-   修复了从复杂表达式创建多维数组时的性能回归.
-   修复了可能导致额外的 `FORMAT` 部分出现在带有元数据的 `.sql` 文件中的错误.
-   修复了一个错误，该错误导致在尝试删除查看明确指定的表的 `MATERIALIZED VIEW` 时应用 `max_table_size_to_drop` 限制.
-   修复了与旧客户端不兼容的问题 (旧客户端有时会使用 `DateTime('timezone')` 类型发送数据, 他们不理解).
-   修复了当这些列的条件移至 `PREWHERE` 时读取使用 `ALTER` 添加但对于旧分区为空的结构的 `Nested` 列元素时的错误.
-   修复了在查询到 `Merge` 表时通过虚拟 `_table` 列过滤表时的错误.
-   修复了在 `Distributed` 表中使用 `ALIAS` 列时的错误.
-   修复了一个错误, 该错误使动态编译无法用于带有来自 `quantile` 系列的聚合函数的查询.
-   修复了查询执行管道中的争用条件, 这种情况在使用具有大量表的 `Merge` 表以及使用 `GLOBAL` 子查询时在非常罕见的情况下发生.
-   修复了在使用来自多个参数的聚合函数时将不同大小的数组传递给 `arrayReduce` 函数时发生的崩溃.
-   禁止在 `MATERIALIZED VIEW` 中使用带有 `UNION ALL` 的查询.
-   修复了服务器启动时 `part_log` 系统表初始化过程中的错误 (默认情况下, `part_log`是禁用的).

#### 向后不兼容的更新: {#backward-incompatible-changes-10}

-   删除了 `distributed_ddl_allow_replicated_alter` 选项. 默认情况下启用此行为.
-   删除了 `strict_insert_defaults` 设置. 如果您正在使用此功能, 请写信至 `clickhouse-feedback@yandex-team.com`.
-   移除了 `UnsortedMergeTree` 引擎.

### ClickHouse 版本 1.1.54343, 2018-02-05 {#clickhouse-release-1-1-54343-2018-02-05}

-   添加了在分布式 DDL 查询和分布式表构造函数中定义集群名称的宏支持: `CREATE TABLE distr ON CLUSTER '{cluster}' (...) ENGINE = Distributed('{cluster}', 'db', 'table')`.
-   现在像 `SELECT ... FROM table WHERE expr IN (subquery)` 这样的查询是使用 `table` 索引处理的.
-   在插入到复制表时改进了重复处理, 因此它们不再减慢复制队列的执行速度.

### ClickHouse 版本 1.1.54342, 2018-01-22 {#clickhouse-release-1-1-54342-2018-01-22}

此版本包含先前版本 1.1.54337 的错误修复:

-   修复了 1.1.54337 中的回归: 如果默认用户具有只读访问权限, 则服务器拒绝启动并显示消息 `Cannot create database in readonly mode`.
-   修复了 1.1.54337 中的一个回归: 在具有 systemd 的系统上, 无论配置如何, 日志始终写入 syslog; 监视器脚本仍然使用 init.d.
-   修复了 1.1.54337 中的回归: Docker 镜像中的默认配置错误.
-   修复了 Graphite MergeTree 的非确定性行为 (您可以在日志消息中看到它 `合并后的数据与另一个副本上的数据不是字节相同` ).
-   修复了对复制表进行 OPTIMIZE 查询后可能导致合并不一致的错误 (您可能会在日志消息中看到它 `Part ... intersects the previous part` ).
-   当目标表中存在 MATERIALIZED 列时, 缓冲区表现在可以正常工作 (by zhang2014).
-   修复了 NULL 实现中的一个错误.

### ClickHouse 版本 1.1.54337, 2018-01-18 {#clickhouse-release-1-1-54337-2018-01-18}

#### 新特征: {#new-features-17}

-   添加了对表中多维数组和元组 (`Tuple` 数据类型) 的存储的支持.
-   支持用于 `DESCRIBE` 和 `INSERT` 查询的表函数. 在 `DESCRIBE` 中添加了对子查询的支持. 示例：`DESC TABLE remote('host', default.hits)`; `DESC 表（选择 1）`; `插入表功能远程（'host'，default.hits）`. 除了 `INSERT INTO` , 还支持 `INSERT INTO TABLE`.
-   改进了对时区的支持. `DateTime` 数据类型可以使用用于解析和格式化文本格式的时区进行注释. 示例: `DateTime('Europe/Moscow')`. 当在函数中为 DateTime 参数指定时区时, 返回类型将跟踪时区, 并且值将按预期显示.
-   添加了函数`toTimeZone`、`timeDiff`、`toQuarter`、`toRelativeQuarterNum`. `toRelativeHour`/`Minute`/`Second` 函数可以将 `Date` 类型的值作为参数. `now` 函数名区分大小写.
-   添加了 `toStartOfFifteenMinutes` 函数 (Kirill Shvakov).
-   添加了用于格式化查询的 `clickhouse format` 工具.
-   添加了 `format_schema_path` 配置参数 (Marek Vavruşa). 它用于以 `Cap'n Proto` 格式指定模式. 架构文件只能位于指定目录中.
-   添加了对配置替换 (`incl` 和 `conf.d`) 的支持, 用于配置外部词典和模型 (Pavel Yakunin).
-   添加了一个包含 `system.settings` 表文档的列 (Kirill Shvakov).
-   添加了 `system.parts_columns` 表, 其中包含有关 `MergeTree` 表的每个数据部分中的列大小的信息.
-   添加了 `system.models` 表, 其中包含有关已加载的 `CatBoost` 机器学习模型的信息.
-   增加了 `mysql` 和 `odbc` 表功能以及相应的 `MySQL` 和 `ODBC` 表引擎, 用于访问远程数据库. 此功能处于测试阶段.
-   添加了为 `groupArray` 聚合函数传递 `AggregateFunction` 类型参数的可能性 (这样你就可以创建一些聚合函数的状态数组).
-   删除了对聚合函数组合器的各种组合的限制. 例如, 您可以使用 `avgForEachIf` 和 `avgIfForEach` 聚合函数, 它们具有不同的行为.
-   `-ForEach` 聚合函数组合器针对多参数聚合函数的情况进行了扩展.
-   添加了对 `Nullable` 参数的聚合函数的支持, 即使在函数返回非 `Nullable` 结果的情况下 (由 Silviu Caragea 添加). 示例: `groupArray`、`groupUniqArray`、`topK`.
-   为 `clickhouse-client` 添加了 `max_client_network_bandwidth` (Kirill Shvakov).
-   允许具有 `readonly = 2` 设置的用户使用 TEMPORARY 表 (CREATE, DROP, INSERT…) (Kirill Shvakov).
-   添加了对 `Kafka` 引擎使用多个消费者的支持. `Kafka` 的扩展配置选项 (Marek Vavruša).
-   添加了 `intExp3` 和 `intExp4` 函数.
-   添加了 `sumKahan` 聚合函数.
-   添加到 \* Number\* OrNull 函数, 其中 \* Number\* 是数字类型.
-   添加了对 `INSERT SELECT` 查询的 `WITH` 子句的支持 (author: zhang2014).
-   添加设置: `http_connection_timeout`、`http_send_timeout`、`http_receive_timeout`. 特别是, 这些设置用于下载数据部分以进行复制. 如果网络过载, 更改这些设置可以实现更快的故障转移.
-   为类型为 `Null` 的表添加了对 `ALTER` 的支持 (Anastasiya Tsarkova).
-   `reinterpretAsString` 函数针对所有连续存储在内存中的数据类型进行了扩展.
-   为 `clickhouse-local` 工具添加了 `--silent` 选项. 它禁止在 stderr 中打印查询执行信息.
-   添加了对从文本中读取 `Date` 类型值的支持, 该格式使用一位数而不是两位数指定月份和/或月份中的某天 (Amos Bird).

#### 性能优化: {#performance-optimizations}

-   改进了来自字符串参数的聚合函数 `min`、`max`、`any`、`anyLast`、`anyHeavy`、`argMin`、`argMax` 的性能.
-   改进了函数 `isInfinite`、`isFinite`、`isNaN`、`roundToExp2` 的性能.
-   改进了以文本格式解析和格式化 `Date` 和 `DateTime` 类型值的性能.
-   提高解析浮点数的性能和精度.
-   在左右部分具有不包含在 `USING` 中的名称相同的列的情况下, 降低了 `JOIN` 的内存使用量.
-   通过降低计算稳定性, 改进了聚合函数 `varSamp`、`varPop`、`stddevSamp`、`stddevPop`、`covarSamp`、`covarPop`、`corr` 的性能. 旧函数可在名称 `varSampStable`、`varPopStable`、`stddevSampStable`、`stddevPopStable`、`covarSampStable`、`covarPopStable`、`corrStable` 下使用.

#### Bug 修复: {#bug-fixes-28}

-   在运行 `DROP` 或 `DETACH PARTITION` 查询后修复了重复数据删除. 在以前的版本中, 删除分区并再次插入相同的数据不起作用, 因为插入的块被认为是重复的.
-   修复了一个错误, 该错误可能导致对带有 `POPULATE` 的 `CREATE MATERIALIZED VIEW` 查询的 `WHERE` 子句的错误解释.
-   修复了在 `zookeeper_servers` 配置中使用 `root_path` 参数的错误.
-   修复了将 `Date` 参数传递给 `toStartOfDay` 的意外结果.
-   修复了 `addMonths` 和 `subtractMonths` 函数以及 `INTERVAL n MONTH` 在结果为上一年的情况下的算术.
-   为 `DISTINCT`、`JOIN` 和 `uniq` 聚合函数和外部词典 (Evgeniy Ivanov) 添加了对 `UUID` 数据类型的缺失支持. 对 `UUID` 的支持仍然不完整.
-   在行总和为零的情况下修复了 `SummingMergeTree` 行为.
-   对`Kafka` 引擎的各种修复 (Marek Vavruša).
-   修复了 `Join` 表引擎的错误行为 (Amos Bird).
-   修复了 FreeBSD 和 OS X 下不正确的分配器行为.
-   `extractAll` 函数现在支持空匹配.
-   修复了阻止使用 `libressl` 而不是 `openssl` 的错误.
-   修复了来自临时表的 `CREATE TABLE AS SELECT` 查询.
-   修复了更新复制队列的非原子性. 这可能会导致副本不同步, 直到服务器重新启动.
-   修复了 `gcd`、`lcm` 和 `modulo` (`%` 运算符) 中可能出现的溢出 (Maks Skorokhod).
-   `-preprocessed` 文件现在在更改 `umask` 后创建 (`umask` 可以在配置中更改).
-   修复了使用自定义分区键时部件背景检查 (`MergeTreePartChecker`) 的错误.
-   修复了文本格式元组 ( `Tuple` 数据类型的值) 的解析.
-   改进了有关传递给 `multiIf`、`array` 和一些其他函数的不兼容类型的错误消息.
-   重新设计了对 `Nullable` 类型的支持. 修复了可能导致服务器崩溃的错误. 修复了几乎所有与 `NULL` 支持相关的其他错误: INSERT SELECT 中的类型转换不正确、HAVING 和 PREWHERE 中对 Nullable 的支持不足、`join_use_nulls` 模式、可空类型作为 `OR` 运算符的参数等.
-   修复了与数据类型的内部语义相关的各种错误. 示例: 在 `SummingMergeTree` 中对 `Enum` 类型字段进行不必要的求和; `Pretty` 格式的 `Enum` 类型的对齐等.
-   更严格地检查允许的复合列组合.
-   修复了为 `FixedString` 数据类型指定一个非常大的参数时的溢出问题.
-   修复了一般情况下 `topK` 聚合函数中的错误.
-   使用 `-Array` 组合器在聚合函数的n元变体的参数中添加了对数组大小相等性的缺失检查.
-   修复了 `clickhouse-client` 的 `--pager` 中的错误 (author: ks1322).
-   修复了 `exp10` 函数的精度.
-   修复了`visitParamExtract` 函数的行为, 以便更好地遵守文档.
-   修复了指定错误数据类型时崩溃的问题.
-   修复了所有列都是常量的情况下 `DISTINCT` 的行为.
-   修复了在使用带有复杂常量表达式的 `tupleElement` 函数作为元组元素索引的情况下的查询格式.
-   修复了 `range_hashed` 字典的 `Dictionary` 表中的错误.
-   修复了导致 `FULL` 和 `RIGHT JOIN` 结果中行数过多的错误 (Amos Bird).
-   修复了在配置重新加载期间在 `config.d` 目录中创建和删除临时文件时服务器崩溃的问题.
-   修复了 `SYSTEM DROP DNS CACHE` 查询: 缓存已刷新但集群节点的地址未更新.
-   修复了对视图下的表执行 `DETACH TABLE` 后 `MATERIALIZED VIEW` 的行为 (Marek Vavruša).

#### Build 改进: {#build-improvements-4}

-   `pbuilder` 工具用于构建. 构建过程几乎完全独立于构建宿主环境.
-   单个构建用于不同的操作系统版本. 软件包和二进制文件已与各种 Linux 系统兼容.
-   添加了 `clickhouse-test` 包. 它可用于运行功能测试.
-   源 tarball 现在可以发布到存储库. 它可用于在不使用 GitHub 的情况下重现构建.
-   添加了与 Travis CI 的有限集成. 由于 Travis 中构建时间的限制, 仅测试调试构建并运行有限的测试子集.
-   在默认版本中添加了对 `Cap'n'Proto` 的支持.
-   将文档来源的格式从 `Restricted Text` 更改为 `Markdown`.
-   添加了对 `systemd` (Vladimir Smirnov) 的支持. 由于与某些操作系统映像不兼容, 它默认被禁用, 可以手动启用.
-   对于动态代码生成, `clang` 和 `lld` 被嵌入到 `clickhouse` 二进制文件中. 它们也可以作为 `clickhouse clang` 和 `clickhouse lld` 调用.
-   从代码中删除了 GNU 扩展的使用. 启用了`-Wextra` 选项。 当使用 `clang` 构建时, 默认是 `libc++` 而不是 `libstdc++`.
-   提取了 `clickhouse_parsers` 和 `clickhouse_common_io` 库以加速各种工具的构建.

#### 向后不兼容的更新: {#backward-incompatible-changes-11}

-   包含 `Nullable` 列的 `Log` 类型表中标记的格式以向后不兼容的方式进行了更改. 如果你有这些表, 你应该在启动新的服务器版本之前将它们转换为 `TinyLog` 类型. 为此, 请在 `metadata` 目录中相应的 `.sql` 文件中将 `ENGINE = Log` 替换为 `ENGINE = TinyLog`. 如果你的表没有 `Nullable` 列或者你的表的类型不是 `Log`, 那么你不需要做任何事情.
-   删除了 `experimental_allow_extended_storage_definition_syntax` 设置. 现在默认启用此功能.
-   `runningIncome` 函数被重命名为 `runningDifferenceStartingWithFirstvalue` 以避免混淆.
-   当在没有表的 FROM 之后直接指定 ARRAY JOIN 时, 删除了 `FROM ARRAY JOIN arr` 语法 (Amos Bird).
-   删除了仅用于演示目的的 `BlockTabSeparated` 格式.
-   更改了聚合函数 `varSamp`、`varPop`、`stddevSamp`、`stddevPop`、`covarSamp`、`covarPop`、`corr` 的状态格式. 如果您已将这些聚合函数的状态存储在表中 (使用 `AggregateFunction` 数据类型或具有相应状态的物化视图), 请写信至 clickhouse-feedback@yandex-team.com.
-   在以前的服务器版本中, 有一个未公开的功能: 如果聚合函数依赖于参数, 您仍然可以在 AggregateFunction 数据类型中不带参数地指定它. 示例: `AggregateFunction(quantiles, UInt64)` 而不是 `AggregateFunction(quantiles(0.5, 0.9), UInt64)` . 此功能已丢失. 虽然它没有记录, 但我们计划在未来的版本中再次支持它.
-   枚举数据类型不能用于最小/最大聚合函数. 此能力将在下一个版本中恢复.

#### 升级时请注意: {#please-note-when-upgrading}

-   在集群上进行滚动更新时, 当一些副本运行旧版本的 ClickHouse 和一些运行新版本时, 复制会暂时停止, 并且日志中出现消息 `unknown parameter 'shard'` . 更新集群的所有副本后, 复制将继续.
-   如果在集群服务器上运行不同版本的 ClickHouse, 使用以下函数的分布式查询可能会得到不正确的结果: `varSamp`、`varPop`、`stddevSamp`、`stddevPop`、`covarSamp`、`covarPop` , `corr`. 您应该更新所有集群节点.

## [Changelog for 2017](../../whats-new/changelog/2017.md#clickhouse-release-1-1-54327-2017-12-21) {#changelog-for-2017}
