### ClickHouse 版本 1.1.54327, 2017-12-21 {#clickhouse-release-1-1-54327-2017-12-21}

此版本包含先前版本 1.1.54318 的错误修复:

-   修复了可能导致数据丢失的复制中可能出现的竞争条件的错误. 此问题影响1.1.54310和1.1.54318版本. 如果将这些版本的任意一个与 Replicated 表一起使用，则强烈建议进行更新. 此问题显示在日志中的警告消息中，例如 `Part ... from own log does not exist.` 即使您没有在日志中看到这些消息，该问题也是相关的.

### ClickHouse 版本 1.1.54318, 2017-11-30 {#clickhouse-release-1-1-54318-2017-11-30}

此版本包含先前版本 1.1.54310 的错误修复:

- 修复了在 SummingMergeTree 引擎中合并期间不正确的行删除.
- 修复了未复制的 MergeTree 引擎中的内存泄漏.
- 修复了在 MergeTree 引擎中频繁插入导致性能下降的问题.
- 修复了导致复制队列停止运行的问题.
- 修复了服务器日志的轮换和归档.

### ClickHouse 版本 1.1.54310, 2017-11-01 {#clickhouse-release-1-1-54310-2017-11-01}

#### 新特征: {#new-features}

-   MergeTree 系列表引擎的自定义分区键.
-   [Kafka](https://clickhouse.com/docs/en/operations/table_engines/kafka/) 表引擎.
-   增加了对加载[CatBoost](https://catboost.yandex/)模型的支持, 并将它们应用到存储在ClickHouse中的数据.
-   添加了对 UTC 非整数偏移时区的支持
-   添加了对具有时间间隔的算术运算的支持.
-   Date 和 DateTime 类型的值范围扩展到 2105 年.
-   添加了 `CREATE MATERIALIZED VIEW x TO y` 查询(指定用于存储物化视图数据的现有表).
-   添加了不带参数的`ATTACH TABLE` 查询.
-   SummingMergeTree 表中名称以 -Map 结尾的嵌套列的处理逻辑被提取到 sumMap 聚合函数中. 您现在可以明确指定此类列.
-   IP 树字典的最大大小增加到 128M 条目.
-   添加了 getSizeOfEnumType 函数.
-   添加了 sumWithOverflow 聚合函数.
-   添加了对 Cap'n Proto 输入格式的支持.
-   您现在可以在使用 zstd 算法时自定义压缩级别.

#### 向后不兼容的变化: {#backward-incompatible-changes}

-   不允许使用内存以外的引擎创建临时表.
-   不允许使用 View 或 MaterializedView 引擎显式创建表.
-   在表创建期间，新的检查验证采样键表达式是否包含在主键中.

#### Bug 修复: {#bug-fixes}

-   修复了同步插入分布式表时的挂断问题.
-   修复了复制表中部件的非原子添加和删除.
-   插入物化视图的数据不会进行不必要的重复数据删除.
-   对本地副本滞后且远程副本不可用的分布式表执行查询不再导致错误.
-   用户不再需要访问 `default` 数据库的权限来创建临时表.
-   修复了指定不带参数的 Array 类型时崩溃的问题.
-   修复了包含服务器日志的磁盘卷已满时的挂断问题.
-   修复了 Unix 纪元第一周 toRelativeWeekNum 函数中的溢出问题.

#### Build 改进: {#build-improvements}

-   更新了多个第三方库(尤其是 Poco)并转换为 git 子模块.

### ClickHouse 版本 1.1.54304, 2017-10-19 {#clickhouse-release-1-1-54304-2017-10-19}

#### 新特征: {#new-features-1}

-   本机协议中的 TLS 支持(要启用，请在 `config.xml` 中设置 `tcp_ssl_port`).

#### Bug 修复: {#bug-fixes-1}

-   复制表的`ALTER` 现在尝试尽快开始运行.
-   修复了使用设置 `preferred_block_size_bytes=0.` 读取数据时崩溃的问题.
-   修复了按下 `Page Down` 时 `clickhouse-client` 崩溃的问题.
-   使用 `GLOBAL IN` 和 `UNION ALL` 正确解释某些复杂的查询.
-   `FREEZE PARTITION` 现在总是以原子方式工作.
-   空 POST 请求现在返回代码为 411 的响应.
-   修正了像 `CAST(1 AS Nullable(UInt8)).` 这样的表达式的解释错误.
-   修正了从 `MergeTree` 表中读取 `Array(Nullable(String))` 列时的错误.
-   修复了在解析诸如 `SELECT dummy AS dummy, dummy AS b` 之类的查询时崩溃的问题.
-   用户使用无效的 `users.xml` 正确更新.
-   可执行字典返回非零响应代码时的正确处理.

### ClickHouse 版本 1.1.54292, 2017-09-20 {#clickhouse-release-1-1-54292-2017-09-20}

#### 新特征: {#new-features-2}

-   添加了用于处理坐标平面上的坐标的 `pointInPolygon` 函数.
-   添加了用于计算数组总和的 `sumMap` 聚合函数, 类似于 `SummingMergeTree` .
-   添加了 `trunc` 功能. 改进了舍入函数(`round`、`floor`、`ceil`、`roundToExp2`)的性能并更正了它们工作方式的逻辑. 更改了分数和负数的 `roundToExp2` 函数的逻辑.
-   ClickHouse 可执行文件现在较少依赖于 libc 版本. 同一个 ClickHouse 可执行文件可以在各种 Linux 系统上运行. 使用编译查询时仍然存在依赖性(使用设置 `compile = 1` , 默认情况下不使用).
-   减少动态编译查询所需的时间.

#### Bug 修复: {#bug-fixes-2}

-   修复了有时会产生 `part ... intersects previous part` 消息和削弱副本一致性的错误.
-   修复了关闭期间 ZooKeeper 不可用导致服务器锁定的错误.
-   恢复副本时删除了过多的日志记录.
-   修复了 UNION ALL 实现中的错误.
-   修复了如果块中的第一列具有 Array 类型时在 concat 函数中发生的错误.
-   进度现在在 system.merges 表中可以正确显示.

### ClickHouse 版本 1.1.54289, 2017-09-13 {#clickhouse-release-1-1-54289-2017-09-13}

#### 新特征: {#new-features-3}

-   用于服务器管理的 `SYSTEM` 查询: `SYSTEM RELOAD DICTIONARY`, `SYSTEM RELOAD DICTIONARIES`, `SYSTEM DROP DNS CACHE`, `SYSTEM SHUTDOWN`, `SYSTEM KILL`.
-   添加了用于处理数组的函数: `concat`, `arraySlice`, `arrayPushBack`, `arrayPushFront`, `arrayPopBack`, `arrayPopFront`.
-   为 ZooKeeper 配置添加了 `root` 和 `identity` 参数. 这将允许您隔离同一 ZooKeeper 集群上的各个用户.
-   添加了聚合函数 `groupBitAnd` 、 `groupBitOr` 和 `groupBitXor` (为了兼容性，它们也可以在名称 `BIT_AND` 、`BIT_OR`和`BIT_XOR` 下使用).
-   可以通过在文件系统中指定套接字来从 MySQL 加载外部字典.
-   可以通过 SSL 从 MySQL 加载外部字典 (`ssl_cert`, `ssl_key`, `ssl_ca` 参数).
-   添加了 `max_network_bandwidth_for_user` 设置以限制每个用户查询的总体带宽使用.
-   支持临时表的 `DROP TABLE`.
-   支持从 `CSV` 和 `JSONEachRow` 格式读取 Unix 时间戳格式的 `DateTime` 值.
-   现在默认排除分布式查询中的滞后副本(默认阈值为 5 分钟).
-   在 ALTER 期间使用 FIFO 锁定：对于连续运行的查询，ALTER 查询不会无限期阻塞.
-   在配置文件中设置 `umask` 的选项.
-   使用 `DISTINCT` 提高查询的性能.

#### Bug 修复: {#bug-fixes-3}

-   改进了在 ZooKeeper 中删除旧节点的过程. 以前, 如果插入非常频繁, 旧节点有时不会被删除, 从而导致服务器关闭缓慢等.
-   修复了为 ZooKeeper 连接选择主机时的随机化问题.
-   如果副本是本地主机, 则修复了在分布式查询中排除滞后副本的问题.
-   修复了在 `嵌套` 结构中的元素上运行 `ALTER MODIFY` 后, `ReplicatedMergeTree` 表中的数据部分可能被破坏的错误.
-   修复了可能导致 SELECT 查询 `hang` 的错误.
-   分布式 DDL 查询的改进.
-   修复了查询 `CREATE TABLE ... AS <materialized view>`.
-   解决了对 Buffer 表的 `ALTER ... CLEAR COLUMN IN PARTITION` 查询中的死锁.
-   修复了使用 `JSONEachRow` 和 `TSKV` 格式时 `Enum` 的无效默认值 (0 而不是最小值).
-   解决了使用带有 `可执行` 源的字典时出现僵尸进程的问题.
-   修复了 HEAD 查询的段错误.

#### 改进了开发和组装ClickHouse的工作流: {#improved-workflow-for-developing-and-assembling-clickhouse}

-   您可以使用 `pbuilder` 来构建 ClickHouse.
-   你可以使用 `libc++` 代替 `libstdc++` 在 Linux 上构建.
-   添加了使用静态代码分析工具的说明: `Coverage`, `clang-tidy`, `cppcheck`.

#### 升级时请注意: {#please-note-when-upgrading}

-   现在有更高的 MergeTree 设置默认值 `max_bytes_to_merge_at_max_space_in_pool` (要合并的数据部分的最大总大小, 以字节为单位): 它已从 100 GiB 增加到 150 GiB. 这可能会导致在服务器升级后运行大型合并, 从而导致磁盘子系统负载增加. 如果服务器上的可用空间小于正在运行的合并总量的两倍, 这将导致所有其他合并停止运行, 包括小数据部分的合并. 因此, INSERT 查询将失败并显示消息"合并的处理速度明显慢于插入." , 使用 `SELECT * FROM system.merges` 查询来监控情况. 您还可以在 `system.metrics` 表或 Graphite 中检查 `DiskSpaceReservedForMerge` 指标. 您不需要做任何事情来解决这个问题, 因为一旦大型合并完成, 问题就会自行解决. 如果您发现这不可接受, 您可以恢复 `max_bytes_to_merge_at_max_space_in_pool` 设置的先前值. 为此, 请转到 config.xml 中的 `<merge_tree>` 部分, 设置 ``` <merge_tree>``<max_bytes_to_merge_at_max_space_in_pool>107374182400</max_bytes_to_merge_at_max_space_in_pool> ``` 并重新启动服务器.

### ClickHouse 版本 1.1.54284, 2017-08-29 {#clickhouse-release-1-1-54284-2017-08-29}

-   这是先前 1.1.54282 版本的错误修复版本. 它修复了 ZooKeeper 中部分目录中的泄漏.

### ClickHouse 版本 1.1.54282, 2017-08-23 {#clickhouse-release-1-1-54282-2017-08-23}

此版本包含先前版本 1.1.54276 的错误修复:

-   修复了插入分布式表时的 `DB::Exception: Assertion violation: !_path.empty()`.
-   如果输入数据以 ';' 开头, 则在以 RowBinary 格式插入时固定解析.
-   某些聚合函数 (例如 `groupArray()` ) 的运行时编译期间的错误.

### ClickHouse 版本 1.1.54276, 2017-08-16 {#clickhouse-release-1-1-54276-2017-08-16}

#### 新特征: {#new-features-4}

-   SELECT 查询添加了一个可选的 WITH 部分. 示例查询：`WITH 1+1 AS a SELECT a, a*a` .
-   NSERT 可以在分布式表中同步执行：只有在所有数据都保存在所有分片上后才返回 OK. 这是通过设置 `insert_distributed_sync=1` 激活的.
-   添加了用于处理 16 字节标识符的 UUID 数据类型.
-   添加了 CHAR、FLOAT 和其他类型的别名以与 Tableau 兼容.
-   新增 toYYYYMM, toYYYYMMDD, toYYYYMMDDhhmmss 时间转数字功能.
-   您可以使用 IP 地址 (与主机名一起) 来识别集群 DDL 查询的服务器.
-   在函数 `substring(str, pos, len)` 中添加了对非常量参数和负偏移量的支持.
-   为 `groupArray(max_size)(column)` 聚合函数增加了max_size参数, 并优化了其性能.

#### Main Changes: {#main-changes}

-   安全改进：所有服务器文件都使用 0640 权限创建(可以通过 `<umask>` 配置参数更改).
-   改进了语法无效查询的错误消息.
-   合并大段 MergeTree 数据时显着减少内存消耗并提高性能.
-   显着提高了 ReplacingMergeTree 引擎的数据合并性能.
-   通过组合多个源插入提高了从分布式表进行异步插入的性能. 要启用此功能, 请使用设置 `distributed_directory_monitor_batch_inserts=1` .

#### Backward Incompatible Changes: {#backward-incompatible-changes-1}

-   更改了数组 `groupArray(array_column)` 函数聚合状态的二进制格式.

#### Complete List of Changes: {#complete-list-of-changes}

-   添加了 `output_format_json_quote_denormals` 设置, 可以以 JSON 格式输出 nan 和 inf 值.
-   从分布式表读取时优化流分配.
-   如果值不变, 可以在只读模式下配置设置.
-   加了检索 MergeTree 引擎的非整数粒度的功能, 以满足对 `preferred_block_size_bytes` 设置中指定的块大小的限制. 目的是在处理来自大列的表的查询时减少RAM的消耗并增加缓存局部性.
-   有效地使用包含像 `toStartOfHour(x)` 这样的表达式的索引来处理像 `toStartOfHour(x) op сonstexpr` 这样的条件.
-   添加了 MergeTree 引擎的新设置(config.xml 中的 merge_tree 部分):
    -   `replicad_deduplication_window_seconds` 设置允许在复制表中删除重复插入的秒数.
    -   `cleanup_delay_period` 设置启动清理以删除过时数据的频率.
    -   `Replicationd_can_become_leader` 可以防止副本成为领导者(并分配合并).
-   加速清理以从 ZooKeeper 中删除过时的数据.
-   集群 DDL 查询的多项改进和修复. 特别有趣的是新设置 `distributed_ddl_task_timeout`, 它限制了等待集群中服务器响应的时间. 如果 ddl 请求没有在所有主机上执行，响应将包含超时错误并且请求将以异步模式执行.
-   改进了服务器日志中堆栈跟踪的显示.
-   为压缩方法添加了 "none" 值.
-   您可以在 config.xml 中使用多个dictionaries_config 部分.
-   可以通过文件系统中的套接字连接到 MySQL.
-   `system.parts` 表有一个新列, 其中包含有关标记大小的信息(以字节为单位).

#### Bug 修复: {#bug-fixes-4}

-   使用 Merge 表的分布式表现在可以正确用于带有 `_table` 字段条件的 SELECT 查询.
-   修复了检查数据部分时 ReplicatedMergeTree 中罕见的竞争条件.
-   修复了启动服务器时 `leader election` 可能会冻结的问题.
-   使用数据源的本地副本时，将忽略 `max_replica_delay_for_distributed_queries` 设置. 这已被修复.
-   修复了尝试清理不存在的列时 `ALTER TABLE CLEAR COLUMN IN PARTITION` 的错误行为.
-   修复了 multiIf 函数中使用空数组或字符串时的异常.
-   修复了反序列化本机格式时过多的内存分配.
-   修复了 Trie 词典的错误自动更新.
-   修复了在使用 SAMPLE 时从合并表中使用 GROUP BY 子句运行查询时的异常.
-   修复了 `distributed_aggregation_memory_efficient=1` 时 GROUP BY 的崩溃.
-   现在可以在 IN 和 JOIN 右侧指定 `database.table`.
-   太多线程用于并行聚合. 这已被修复.
-   修复了 `if` 函数如何与 FixedString 参数一起工作.
-   对于权重为 0 的分片, SELECT 在分布式表中工作不正确. 这已得到修复.
-   运行 `CREATE VIEW IF EXISTS 不再导致崩溃` .
-   修复了设置 `input_format_skip_unknown_fields=1` 且存在负数时的错误行为.
-   修复了如果字典中有一些无效数据, `dictGetHierarchy()` 函数中的无限循环.
-   修复了使用 IN 或 JOIN 子句和合并表中的子查询运行分布式查询时的 `Syntax error: unexpected (...)` 错误.
-   修复了对字典表中 SELECT 查询的错误解释.
-   修复了在超过 20 亿元素的 IN 和 JOIN 子句中使用数组时的 "Cannot mremap" 错误.
-   修复了以 MySQL 为源的字典的故障转移.

#### 改进了开发和组装ClickHouse的工作流: {#improved-workflow-for-developing-and-assembling-clickhouse-1}

-   可以在 Arcadia 中组装 Builds.
-   可以使用 gcc 7 编译 ClickHouse.
-   使用 ccache+distcc 的并行构建现在更快了.

### ClickHouse 版本 1.1.54245, 2017-07-04 {#clickhouse-release-1-1-54245-2017-07-04}

#### 新特征: {#new-features-5}

-   分布式 DDL(例如, `REATE TABLE ON CLUSTER`).
-   复制查询 `ALTER TABLE CLEAR COLUMN IN PARTITION.` .
-   字典表引擎 (以表的形式访问字典数据).
-   字典数据库引擎 (这种类型的数据库自动为所有连接的外部字典提供字典表).
-   您可以通过向源发送请求来检查字典的更新.
-   合格的列名.
-   使用双引号引用标识符.
-   HTTP 接口中的会话.
-   复制表的 OPTIMIZE 查询不仅可以在领导者上运行.

#### 向后不兼容的变化: {#backward-incompatible-changes-2}

-   删除了 SET GLOBAL.

#### 次要更改: {#minor-changes}

-   目前在触发警报后，日志会打印完整的堆栈跟踪.
-   放宽了启动时损坏/额外数据部分数量的验证(误报太多).

#### Bug 修复: {#bug-fixes-5}

-   修复了插入分布式表时的错误连接"卡住"问题.
-   GLOBAL IN 现在适用于来自查看分布式表的合并表的查询.
-   在 Google Compute Engine 虚拟机上检测到的内核数不正确. 这已被修复.
-   缓存外部字典的可执行源的工作方式发生了变化.
-   修正了包含空字符的字符串的比较.
-   修复了 Float32 主键字段与常量的比较.
-   以前，对字段大小的错误估计可能会导致分配过大.
-   修复了使用 ALTER 查询添加到表中的 Nullable 列时发生的崩溃.
-   修复了当行数小于 LIMIT 时按 Nullable 列排序时崩溃的问题.
-   修复了仅由常量值组成的 ORDER BY 子查询.
-   以前，复制表在 DROP TABLE 失败后可能保持无效状态.
-   结果为空的标量子查询的别名不再丢失.
-   现在，如果 .so 文件损坏，使用编译的查询不会因错误而失败.
