---
toc_folder_title: 函数
toc_priority: 32
toc_title: 简介
---

# 函数 {#han-shu}

ClickHouse中至少存在两种类型的函数 - 常规函数（它们称之为«函数»）和聚合函数。 常规函数的工作就像分别为每一行执行一次函数计算一样（对于每一行，函数的结果不依赖于其他行）。 聚合函数则从各行累积一组值（即函数的结果以来整个结果集）。

在本节中，我们将讨论常规函数。 有关聚合函数，请参阅«聚合函数»一节。

 \* - ’arrayJoin’函数与表函数均属于第三种类型的函数。 \*

## 强类型 {#qiang-lei-xing}

与标准SQL相比，ClickHouse具有强类型。 换句话说，它不会在类型之间进行隐式转换。 每个函数适用于特定的一组类型。 这意味着有时您需要使用类型转换函数。

## 常见的子表达式消除 {#chang-jian-de-zi-biao-da-shi-xiao-chu}

查询中具有相同AST（相同语句或语法分析结果相同）的所有表达式都被视为具有相同的值。 这样的表达式被连接并执行一次。 通过这种方式也可以消除相同的子查询。

## 结果类型 {#jie-guo-lei-xing}

所有函数都只能够返回一个返回值。 结果类型通常由参数的类型决定。 但tupleElement函数（a.N运算符）和toFixedString函数是例外的。

## 常量 {#chang-liang}

为了简单起见，某些函数的某些参数只能是常量。 例如，LIKE运算符的右参数必须是常量。
几乎所有函数都为常量参数返回常量。 除了用于生成随机数的函数。
’now’函数为在不同时间运行的查询返回不同的值，但结果被视为常量，因为常量在单个查询中很重要。
常量表达式也被视为常量（例如，LIKE运算符的右半部分可以由多个常量构造）。

对于常量和非常量参数，可以以不同方式实现函数（执行不同的代码）。 但是，对于包含相同数据的常量和非常量参数它们的结果应该是一致的。

## NULL值处理 {#nullzhi-chu-li}

函数具有以下行为：

-   如果函数的参数至少一个是«NULL»，则函数结果也是«NULL»。
-   在每个函数的描述中单独指定的特殊行为。在ClickHouse源代码中，这些函数具有«UseDefaultImplementationForNulls = false»。

## 不可变性 {#bu-ke-bian-xing}

函数不能更改其参数的值 - 任何更改都将作为结果返回。因此，计算单独函数的结果不依赖于在查询中写入函数的顺序。

## 错误处理 {#cuo-wu-chu-li}

如果数据无效，某些函数可能会抛出异常。在这种情况下，将取消查询并将错误信息返回给客户端。对于分布式处理，当其中一个服务器发生异常时，其他服务器也会尝试中止查询。

## 表达式参数的计算 {#biao-da-shi-can-shu-de-ji-suan}

在几乎所有编程语言中，某些函数可能无法预先计算其中一个参数。这通常是运算符`&&`，`||`和`? :`。
但是在ClickHouse中，函数（运算符）的参数总是被预先计算。这是因为一次评估列的整个部分，而不是分别计算每一行。

## 执行分布式查询处理的功能 {#zhi-xing-fen-bu-shi-cha-xun-chu-li-de-gong-neng}

对于分布式查询处理，在远程服务器上执行尽可能多的查询处理阶段，并且在请求者服务器上执行其余阶段（合并中间结果和之后的所有内容）。

这意味着可以在不同的服务器上执行功能。
例如，在查询`SELECT f（sum（g（x）））FROM distributed_table GROUP BY h（y）中，`

-   如果`distributed_table`至少有两个分片，则在远程服务器上执行函数’g’和’h’，并在请求服务器上执行函数’f’。
-   如果`distributed_table`只有一个分片，则在该分片的服务器上执行所有’f’，’g’和’h’功能。

函数的结果通常不依赖于它在哪个服务器上执行。但是，有时这很重要。
例如，使用字典的函数时将使用运行它们的服务器上存在的字典。
另一个例子是`hostName`函数，它返回运行它的服务器的名称，以便在`SELECT`查询中对服务器进行`GROUP BY`。

如果查询中的函数在请求服务器上执行，但您需要在远程服务器上执行它，则可以将其包装在«any»聚合函数中，或将其添加到«GROUP BY»中。

[来源文章](https://clickhouse.com/docs/en/query_language/functions/) <!--hide-->
