---
toc_priority: 40
toc_title: "ANSI\u517C\u5BB9\u6027"
---

# ClickHouse SQL方言 与ANSI SQL的兼容性{#ansi-sql-compatibility-of-clickhouse-sql-dialect}

!!! note "注"
    本文参考Annex G所著的[ISO/IEC CD 9075-2:2011](https://www.iso.org/obp/ui/#iso:std:iso-iec:9075:-2:ed-4:v1:en:sec:8)标准.

## 行为差异 {#differences-in-behaviour}

下表列出了ClickHouse能够使用，但与ANSI SQL规定有差异的查询特性。

| 功能ID  | 功能名称              | 差异                                                                                                                                                                                   |
| ------- | --------------------- | -------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| E011    | 数值型数据类型        | 带小数点的数字被视为近似值 (`Float64`）而不是精确值 (`Decimal`)                                                                                                                        |
| E051-05 | SELECT 的列可以重命名 | 字段重命名的作用范围不限于进行重命名的SELECT子查询（参考[表达式别名](https://clickhouse.com/docs/zh/sql-reference/syntax/#notes-on-usage)）                                            |
| E141-01 | NOT NULL（非空）约束          | ClickHouse表中每一列默认为`NOT NULL`                                                                                                                                                   |
| E011-04 | 算术运算符            | ClickHouse在运算时会进行溢出，而不是四舍五入。此外会根据自定义规则修改结果数据类型（参考[溢出检查](https://clickhouse.com/docs/zh/sql-reference/data-types/decimal/#yi-chu-jian-cha)） |

## 功能状态 {#feature-status}

| 功能ID   | 功能名称                                                                                 | 状态                    | 注释                                                                                                                                                                     |
| -------- | ---------------------------------------------------------------------------------------- | ----------------------- | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------ |
| **E011** | **数值型数据类型**                                                                       | **部分**{.text-warning} |                                                                                                                                                                          |
| E011-01  | INTEGER （整型）和SMALLINT （小整型）数据类型                                            | 是 {.text-success}      |                                                                                                                                                                          |
| E011-02  | REAL （实数）、DOUBLE PRECISION （双精度浮点数）和FLOAT（单精度浮点数）数据类型数据类型  | 是 {.text-success}      |                                                                                                                                                                          |
| E011-03  | DECIMAL （精确数字）和NUMERIC （精确数字）数据类型                                       | 是 {.text-success}      |                                                                                                                                                                          |
| E011-04  | 算术运算符                                                                               | 是 {.text-success}      |                                                                                                                                                                          |
| E011-05  | 数值比较                                                                                 | 是 {.text-success}      |                                                                                                                                                                          |
| E011-06  | 数值数据类型之间的隐式转换                                                               | 否 {.text-danger}       | ANSI SQL允许在数值类型之间进行任意隐式转换，而ClickHouse针对不同数据类型有对应的比较函数和类型转换函数                                                                   |
| **E021** | **字符串类型**                                                                           | **部分**{.text-warning} |                                                                                                                                                                          |
| E021-01  | CHARACTER （字符串）数据类型                                                             | 是 {.text-success}      |                                                                                                                                                                          |
| E021-02  | CHARACTER VARYING （可变字符串）数据类型                                                 | 是 {.text-success}      |                                                                                                                                                                          |
| E021-03  | 字符字面量                                                                               | 是 {.text-success}      |                                                                                                                                                                          |
| E021-04  | CHARACTER_LENGTH 函数                                                                    | 部分 {.text-warning}    | 不支持 `using` 从句                                                                                                                                                      |
| E021-05  | OCTET_LENGTH 函数                                                                        | 否 {.text-danger}       | 使用 `LENGTH` 函数代替                                                                                                                                                   |
| E021-06  | SUBSTRING                                                                                | 部分 {.text-warning}    | 不支持 `SIMILAR` 和 `ESCAPE` 从句，没有`SUBSTRING_REGEX` 函数                                                                                                            |
| E021-07  | 字符串拼接                                                                               | 部分 {.text-warning}    | 不支持 `COLLATE` 从句                                                                                                                                                    |
| E021-08  | 大小写转换                                                                               | 是 {.text-success}      |                                                                                                                                                                          |
| E021-09  | 裁剪字符串                                                                               | 是 {.text-success}      |                                                                                                                                                                          |
| E021-10  | 固定长度和可变长度字符串类型之间的隐式转换                                               | 部分 {.text-warning}    | ANSI SQL允许在数据类型之间进行任意隐式转换，而ClickHouse针对不同数据类型有对应的比较函数和类型转换函数                                                                   |
| E021-11  | POSITION 函数                                                                            | 部分 {.text-warning}    | 不支持 `IN` 和 `USING` 从句，不支持`POSITION_REGEX`函数                                                                                                                  |
| E021-12  | 字符串比较                                                                               | 是 {.text-success}      |                                                                                                                                                                          |
| **E031** | **标识符**                                                                               | **部分**{.text-warning} |                                                                                                                                                                          |
| E031-01  | 分隔标识符                                                                               | 部分 {.text-warning}    | Unicode文字支持有限                                                                                                                                                      |
| E031-02  | 小写标识符                                                                               | 是 {.text-success}      |                                                                                                                                                                          |
| E031-03  | 标识符最后加下划线                                                                       | 是 {.text-success}      |                                                                                                                                                                          |
| **E051** | **基本查询规范**                                                                         | **部分**{.text-warning} |                                                                                                                                                                          |
| E051-01  | SELECT DISTINCT                                                                          | 是 {.text-success}      |                                                                                                                                                                          |
| E051-02  | GROUP BY 从句                                                                            | 是 {.text-success}      |                                                                                                                                                                          |
| E051-04  | GROUP BY 从句中的列可以包含不在 `<select list>`中出现的列                                | 是 {.text-success}      |                                                                                                                                                                          |
| E051-05  | SELECT 的列可以重命名                                                                    | 是 {.text-success}      |                                                                                                                                                                          |
| E051-06  | HAVING 从句                                                                              | 是 {.text-success}      |                                                                                                                                                                          |
| E051-07  | SELECT 选择的列中允许出现\*                                                              | 是 {.text-success}      |                                                                                                                                                                          |
| E051-08  | FROM 从句中的关联名称                                                                    | 是 {.text-success}      |                                                                                                                                                                          |
| E051-09  | 重命名 FROM 从句中的列                                                                   | 否 {.text-danger}       |                                                                                                                                                                          |
| **E061** | **基本谓词和搜索条件**                                                                   | **部分**{.text-warning} |                                                                                                                                                                          |
| E061-01  | 比较谓词                                                                                 | 是 {.text-success}      |                                                                                                                                                                          |
| E061-02  | BETWEEN 谓词                                                                             | 部分 {.text-warning}    | 不支持 `SYMMETRIC` 和 `ASYMMETRIC` 从句                                                                                                                                  |
| E061-03  | IN 谓词后可接值列表                                                                      | 是 {.text-success}      |                                                                                                                                                                          |
| E061-04  | LIKE 谓词                                                                                | 是 {.text-success}      |                                                                                                                                                                          |
| E061-05  | LIKE 谓词后接 ESCAPE 从句                                                                | 否 {.text-danger}       |                                                                                                                                                                          |
| E061-06  | NULL 谓词                                                                                | 是 {.text-success}      |                                                                                                                                                                          |
| E061-07  | 量化比较谓词（ALL、SOME、ANY）                                                           | 否 {.text-danger}       |                                                                                                                                                                          |
| E061-08  | EXISTS 谓词                                                                              | 否 {.text-danger}       |                                                                                                                                                                          |
| E061-09  | 比较谓词中的子查询                                                                       | 是 {.text-success}      |                                                                                                                                                                          |
| E061-11  | IN 谓词中的子查询                                                                        | 是 {.text-success}      |                                                                                                                                                                          |
| E061-12  | 量化比较谓词（BETWEEN、IN、LIKE）中的子查询                                              | 否 {.text-danger}       |                                                                                                                                                                          |
| E061-13  | 相关子查询                                                                               | 否 {.text-danger}       |                                                                                                                                                                          |
| E061-14  | 搜索条件                                                                                 | 是 {.text-success}      |                                                                                                                                                                          |
| **E071** | **基本查询表达式**                                                                       | **部分**{.text-warning} |                                                                                                                                                                          |
| E071-01  | UNION DISTINCT 表运算符                                                                  | 是 {.text-success}      |                                                                                                                                                                          |
| E071-02  | UNION ALL 表运算符                                                                       | 是 {.text-success}      |                                                                                                                                                                          |
| E071-03  | EXCEPT DISTINCT 表运算符                                                                 | 否 {.text-danger}       |                                                                                                                                                                          |
| E071-05  | 通过表运算符组合的列不必具有完全相同的数据类型                                           | 是 {.text-success}      |                                                                                                                                                                          |
| E071-06  | 子查询中的表运算符                                                                       | 是 {.text-success}      |                                                                                                                                                                          |
| **E081** | **基本权限**                                                                             | **是**{.text-success}   |                                                                                                                                                                          |
| E081-01  | 表级别的SELECT（查询）权限                                                               | 是 {.text-success}      |                                                                                                                                                                          |
| E081-02  | DELETE（删除）权限                                                                       | 是 {.text-success}      |                                                                                                                                                                          |
| E081-03  | 表级别的INSERT（插入）权限                                                               | 是 {.text-success}      |                                                                                                                                                                          |
| E081-04  | 表级别的UPDATE（更新）权限                                                               | 是 {.text-success}      |                                                                                                                                                                          |
| E081-05  | 列级别的UPDATE（更新）权限                                                               | 是 {.text-success}      |                                                                                                                                                                          |
| E081-06  | 表级别的REFERENCES（引用）权限                                                           | 是 {.text-success}      |                                                                                                                                                                          |
| E081-07  | 列级别的REFERENCES（引用）权限                                                           | 是 {.text-success}      |                                                                                                                                                                          |
| E081-08  | WITH GRANT OPTION                                                                        | 是 {.text-success}      |                                                                                                                                                                          |
| E081-09  | USAGE（使用）权限                                                                        | 是 {.text-success}      |                                                                                                                                                                          |
| E081-10  | EXECUTE（执行）权限                                                                      | 是 {.text-success}      |                                                                                                                                                                          |
| **E091** | **集合函数**                                                                             | **是**{.text-success}   |                                                                                                                                                                          |
| E091-01  | AVG                                                                                      | 是 {.text-success}      |                                                                                                                                                                          |
| E091-02  | COUNT                                                                                    | 是 {.text-success}      |                                                                                                                                                                          |
| E091-03  | MAX                                                                                      | 是 {.text-success}      |                                                                                                                                                                          |
| E091-04  | MIN                                                                                      | 是 {.text-success}      |                                                                                                                                                                          |
| E091-05  | SUM                                                                                      | 是 {.text-success}      |                                                                                                                                                                          |
| E091-06  | ALL修饰词                                                                                | 否。 {.text-danger}     |                                                                                                                                                                          |
| E091-07  | DISTINCT修饰词                                                                           | 是 {.text-success}      | 并非所有聚合函数都支持该修饰词                                                                                                                                           |
| **E101** | **基本数据操作**                                                                         | **部分**{.text-warning} |                                                                                                                                                                          |
| E101-01  | INSERT（插入）语句                                                                       | 是 {.text-success}      | 注：ClickHouse中的主键并不隐含`UNIQUE` 约束                                                                                                                              |
| E101-03  | 可指定范围的UPDATE（更新）语句                                                           | 部分 {.text-warning}    | `ALTER UPDATE` 语句用来批量更新数据                                                                                                                                      |
| E101-04  | 可指定范围的DELETE（删除）语句                                                           | 部分 {.text-warning}    | `ALTER DELETE` 语句用来批量删除数据                                                                                                                                      |
| **E111** | **返回一行的SELECT语句**                                                                 | **否**{.text-danger}    |                                                                                                                                                                          |
| **E121** | **基本游标支持**                                                                         | **否**{.text-danger}    |                                                                                                                                                                          |
| E121-01  | DECLARE CURSOR                                                                           | 否 {.text-danger}       |                                                                                                                                                                          |
| E121-02  | ORDER BY 涉及的列不需要出现在SELECT的列中                                                | 是 {.text-success}      |                                                                                                                                                                          |
| E121-03  | ORDER BY 从句中的表达式                                                                  | 是 {.text-success}      |                                                                                                                                                                          |
| E121-04  | OPEN 语句                                                                                | 否 {.text-danger}       |                                                                                                                                                                          |
| E121-06  | 受游标位置控制的 UPDATE 语句                                                             | 否 {.text-danger}       |                                                                                                                                                                          |
| E121-07  | 受游标位置控制的 DELETE 语句                                                             | 否 {.text-danger}       |                                                                                                                                                                          |
| E121-08  | CLOSE 语句                                                                               | 否 {.text-danger}       |                                                                                                                                                                          |
| E121-10  | FETCH 语句中包含隐式NEXT                                                                 | 否 {.text-danger}       |                                                                                                                                                                          |
| E121-17  | WITH HOLD 游标                                                                           | 否 {.text-danger}       |                                                                                                                                                                          |
| **E131** | **空值支持**                                                                             | **是**{.text-success}   | 有部分限制                                                                                                                                                               |
| **E141** | **基本完整性约束**                                                                       | **部分**{.text-warning} |                                                                                                                                                                          |
| E141-01  | NOT NULL（非空）约束                                                                     | 是 {.text-success}      | 注: 默认情况下ClickHouse表中的列隐含`NOT NULL`约束                                                                                                                                 |
| E141-02  | NOT NULL（非空）列的UNIQUE（唯一）约束                                                   | 否 {.text-danger}       |                                                                                                                                                                          |
| E141-03  | 主键约束                                                                                 | 部分 {.text-warning}    |                                                                                                                                                                          |
| E141-04  | 对于引用删除和引用更新操作，基本的FOREIGN KEY（外键）约束默认不进行任何操作（NO ACTION） | 否 {.text-danger}       |                                                                                                                                                                          |
| E141-06  | CHECK（检查）约束                                                                        | 是 {.text-success}      |                                                                                                                                                                          |
| E141-07  | 列默认值                                                                                 | 是 {.text-success}      |                                                                                                                                                                          |
| E141-08  | 在主键上推断非空                                                                         | 是 {.text-success}      |                                                                                                                                                                          |
| E141-10  | 可以按任何顺序指定外键中的名称                                                           | 否 {.text-danger}       |                                                                                                                                                                          |
| **E151** | **事务支持**                                                                             | **否**{.text-danger}    |                                                                                                                                                                          |
| E151-01  | COMMIT（提交）语句                                                                       | 否 {.text-danger}       |                                                                                                                                                                          |
| E151-02  | ROLLBACK（回滚）语句                                                                     | 否 {.text-danger}       |                                                                                                                                                                          |
| **E152** | **基本的SET TRANSACTION（设置事务隔离级别）语句**                                        | **否**{.text-danger}    |                                                                                                                                                                          |
| E152-01  | SET TRANSACTION语句：ISOLATION LEVEL SERIALIZABLE（隔离级别为串行化）从句                | 否 {.text-danger}       |                                                                                                                                                                          |
| E152-02  | SET TRANSACTION语句：READ ONLY（只读）和READ WRITE（读写）从句                           | 否 {.text-danger}       |                                                                                                                                                                          |
| **E153** | **具有子查询的可更新查询**                                                               | **是**{.text-success}   |                                                                                                                                                                          |
| **E161** | **使用“--”符号作为SQL注释**                                                                  | **是**{.text-success}   |                                                                                                                                                                          |
| **E171** | **SQLSTATE支持**                                                                         | **否**{.text-danger}    |                                                                                                                                                                          |
| **E182** | **主机语言绑定**                                                                         | **否**{.text-danger}    |                                                                                                                                                                          |
| **F031** | **基本架构操作**                                                                         | **部分**{.text-warning} |                                                                                                                                                                          |
| F031-01  | 使用 CREATE TABLE 语句创建持久表                                                           | 部分 {.text-warning}    | 不支持 `SYSTEM VERSIONING`, `ON COMMIT`, `GLOBAL`, `LOCAL`, `PRESERVE`, `DELETE`, `REF IS`, `WITH OPTIONS`, `UNDER`, `LIKE`, `PERIOD FOR` 从句，不支持用户解析的数据类型 |
| F031-02  | CREATE VIEW（创建视图）语句                                                              | 部分 {.text-warning}    | 不支持 `RECURSIVE`, `CHECK`, `UNDER`, `WITH OPTIONS` 从句，不支持用户解析的数据类型                                                                                      |
| F031-03  | GRANT（授权）语句                                                                        | 是 {.text-success}      |                                                                                                                                                                          |
| F031-04  | ALTER TABLE语句：ADD COLUMN从句                                                          | 是 {.text-success}      | 不支持 `GENERATED` 从句和以系统时间做参数                                                                                                                                |
| F031-13  | DROP TABLE语句：RESTRICT从句                                                             | 否 {.text-danger}       |                                                                                                                                                                          |
| F031-16  | DROP VIEW语句：RESTRICT子句                                                              | 否 {.text-danger}       |                                                                                                                                                                          |
| F031-19  | REVOKE语句：RESTRICT子句                                                                 | 否 {.text-danger}       |                                                                                                                                                                          |
| **F041** | **基本连接关系**                                                                           | **部分**{.text-warning} |                                                                                                                                                                          |
| F041-01  | Inner join（但不一定是INNER关键字)                                                       | 是 {.text-success}      |                                                                                                                                                                          |
| F041-02  | INNER 关键字                                                                              | 是 {.text-success}      |                                                                                                                                                                          |
| F041-03  | LEFT OUTER JOIN                                                                          | 是 {.text-success}      |                                                                                                                                                                          |
| F041-04  | RIGHT OUTER JOIN                                                                         | 是 {.text-success}      |                                                                                                                                                                          |
| F041-05  | 外连接可嵌套                                                                             | 是 {.text-success}      |                                                                                                                                                                          |
| F041-07  | 左外部连接或右外连接中的内部表也可用于内部联接                                           | 是 {.text-success}      |                                                                                                                                                                          |
| F041-08  | 支持所有比较运算符（而不仅仅是=)                                                         | 否 {.text-danger}       |                                                                                                                                                                          |
| **F051** | **基本日期和时间**                                                                       | **部分**{.text-warning} |                                                                                                                                                                          |
| F051-01  | DATE（日期）数据类型（并支持用于表达日期的字面量)                                        | 是 {.text-success}      |                                                                                                                                                                          |
| F051-02  | TIME（时间）数据类型（并支持用于表达时间的字面量），小数秒精度至少为0                    | 否 {.text-danger}       |                                                                                                                                                                          |
| F051-03  | 时间戳数据类型（并支持用于表达时间戳的字面量），小数秒精度至少为0和6                     | 是 {.text-danger}       |                                                                                                                                                                          |
| F051-04  | 日期、时间和时间戳数据类型的比较谓词                                                     | 是 {.text-success}      |                                                                                                                                                                          |
| F051-05  | Datetime 类型和字符串形式表达的时间之间的显式转换                                         | 是 {.text-success}      |                                                                                                                                                                          |
| F051-06  | CURRENT_DATE                                                                             | 否 {.text-danger}       | 使用`today()`替代                                                                                                                                                        |
| F051-07  | LOCALTIME                                                                                | 否 {.text-danger}       | 使用`now()`替代                                                                                                                                                          |
| F051-08  | LOCALTIMESTAMP                                                                           | 否 {.text-danger}       |                                                                                                                                                                          |
| **F081** | **视图的UNION和EXCEPT操作**                                                              | **部分**{.text-warning} |                                                                                                                                                                          |
| **F131** | **分组操作**                                                                             | **部分**{.text-warning} |                                                                                                                                                                          |
| F131-01  | 在具有分组视图的查询中支持 WHERE、GROUP BY 和 HAVING 子句                                    | 是 {.text-success}      |                                                                                                                                                                          |
| F131-02  | 在分组视图中支持多张表                                                                   | 是 {.text-success}      |                                                                                                                                                                          |
| F131-03  | 分组视图的查询中支持集合函数                                                             | 是 {.text-success}      |                                                                                                                                                                          |
| F131-04  | 带有 `GROUP BY` 和 `HAVING` 从句，以及分组视图的子查询                                       | 是 {.text-success}      |                                                                                                                                                                          |
| F131-05  | 带有 `GROUP BY` 和 `HAVING` 从句，以及分组视图的仅返回1条记录的SELECT查询                    | 否 {.text-danger}       |                                                                                                                                                                          |
| **F181** | **多模块支持**                                                                           | **否**{.text-danger}    |                                                                                                                                                                          |
| **F201** | **CAST 函数**                                                                           | **是**{.text-success}   |                                                                                                                                                                          |
| **F221** | **显式默认值**                                                                           | **否**{.text-danger}    |                                                                                                                                                                          |
| **F261** | **CASE 表达式**                                                                         | **是**{.text-success}   |                                                                                                                                                                          |
| F261-01  | 简单 CASE 表达式                                                                         | 是 {.text-success}      |                                                                                                                                                                          |
| F261-02  | 搜索型 CASE 表达式                                                                       | 是 {.text-success}      |                                                                                                                                                                          |
| F261-03  | NULLIF                                                                                   | 是 {.text-success}      |                                                                                                                                                                          |
| F261-04  | COALESCE                                                                                 | 是 {.text-success}      |                                                                                                                                                                          |
| **F311** | **架构定义语句**                                                                         | **部分**{.text-warning} |                                                                                                                                                                          |
| F311-01  | CREATE SCHEMA                                                                            | 部分 {.text-warning}    | 见`CREATE DATABASE`                                                                                                                                                      |
| F311-02  | 用于创建持久表的 CREATE TABLE                                                             | 是 {.text-success}      |                                                                                                                                                                          |
| F311-03  | CREATE VIEW                                                                              | 是 {.text-success}      |                                                                                                                                                                          |
| F311-04  | CREATE VIEW: WITH CHECK OPTION                                                           | 否 {.text-danger}       |                                                                                                                                                                          |
| F311-05  | GRANT 语句                                                                                | 是 {.text-success}      |                                                                                                                                                                          |
| **F471** | **标量子查询**                                                                           | **是**{.text-success}   |                                                                                                                                                                          |
| **F481** | **扩展 NULL 谓词**                                                                         | **是**{.text-success}   |                                                                                                                                                                          |
| **F812** | **基本标志位**                                                                           | **否**{.text-danger}    |
| **S011** | **用于不重复数据的数据类型**                                                             | **否**{.text-danger}    |
| **T321** | **基本的SQL调用例程**                                                                    | **否**{.text-danger}    |                                                                                                                                                                          |
| T321-01  | 没有重载的用户定义函数                                                                   | 否{.text-danger}        |                                                                                                                                                                          |
| T321-02  | 没有重载的用户定义存储过程                                                               | 否{.text-danger}        |                                                                                                                                                                          |
| T321-03  | 功能调用                                                                                 | 否 {.text-danger}       |                                                                                                                                                                          |
| T321-04  | CALL 语句                                                                                 | 否 {.text-danger}       |                                                                                                                                                                          |
| T321-05  | RETURN 语句                                                                               | 否 {.text-danger}       |                                                                                                                                                                          |
| **T631** | **IN 谓词后接一个列表**                                                                   | **是**{.text-success}   |                                                                                                                                                                          |
