---
toc_priority: 5
toc_title: "ClickHouse用户"
---

# ClickHouse用户 {#clickhouse-adopters}

!!! warning "免责声明"
    如下使用ClickHouse的公司和他们的成功案例来源于公开资源，因此和实际情况可能有所出入。如果您分享您公司使用ClickHouse的故事，我们将不胜感激 [将其添加到列表](https://github.com/ClickHouse/ClickHouse/edit/master/docs/en/introduction/adopters.md)，但请确保你这样做不会有任何保密协议的问题。也欢迎提供来自其他公司的出版物的更新。

| 公司简介                                                        | 行业             | 用例           | 群集大小                                          | (Un)压缩数据大小<abbr title="of single replica"><sup>\*</sup></abbr> | 参考资料                                                                                                                                                                                                          |
|-----------------------------------------------------------------|------------------|----------------|---------------------------------------------------|----------------------------------------------------------------------|-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| [2gis](https://2gis.ru)                                         | 地图             | 监测           | —                                                 | —                                                                    | [俄文，2019年7月](https://youtu.be/58sPkXfq6nw)                                                                                                                                                                   |
| [阿里云](https://cn.aliyun.com/)                                | 公有云           | 全托管服务   | —                                                  | —                                                                    | [官方网站](https://help.aliyun.com/product/144466.html) |
| [阿里云](https://cn.aliyun.com/)                                | 公有云           | E-MapReduce   | —                                                  | —                                                                    | [官方网站](https://help.aliyun.com/document_detail/212195.html) |
| [Aloha 浏览器](https://alohabrowser.com/)                       | 移动应用程序     | 浏览器后端     | —                                                 | —                                                                    | [俄文幻灯片，2019年5月](https://github.com/ClickHouse/clickhouse-presentations/blob/master/meetup22/aloha.pdf)                                                                                                        |
| [阿玛迪斯](https://amadeus.com/)                                | 旅行             | 分析           | —                                                 | —                                                                    | [新闻稿,四月2018](https://www.altinity.com/blog/2018/4/5/amadeus-technologies-launches-investment-and-insights-tool-based-on-machine-learning-and-strategy-algorithms)                                            |
| [Appsflyer](https://www.appsflyer.com)                          | 移动分析         | 主要产品       | —                                                 | —                                                                    | [俄文，2019年7月](https://www.youtube.com/watch?v=M3wbRlcpBbY)                                                                                                                                                    |
| [ArenaData](https://arenadata.tech/)                            | 数据平台         | 主要产品       | —                                                 | —                                                                    | [俄文幻灯片，十二月2019](https://github.com/ClickHouse/clickhouse-presentations/blob/master/meetup38/indexes.pdf)                                                                                                 |
| [Badoo](https://badoo.com)                                      | 约会             | 时间序列       | —                                                 | —                                                                    | [俄文幻灯片，十二月2019](https://presentations.clickhouse.com/meetup38/forecast.pdf)                                                                                                                             |
| [Benocs](https://www.benocs.com/)                               | 网络遥测和分析   | 主要产品       | —                                                 | —                                                                    | [英文幻灯片，2017年10月](https://github.com/ClickHouse/clickhouse-presentations/blob/master/meetup9/lpm.pdf)                                                                                                      |
| [彭博社](https://www.bloomberg.com/)                            | 金融、媒体       | 监测           | 102个服务器                                       | —                                                                    | [幻灯片，2018年5月](https://www.slideshare.net/Altinity/http-analytics-for-6m-requests-per-second-using-clickhouse-by-alexander-bocharov)                                                                         |
| [Bloxy](https://bloxy.info)                                     | 区块链           | 分析           | —                                                 | —                                                                    | [俄文幻灯片，八月2018](https://github.com/ClickHouse/clickhouse-presentations/blob/master/meetup17/4_bloxy.pptx)                                                                                                  |
| `Dataliance/UltraPower`                                         | 电信             | 分析           | —                                                 | —                                                                    | [中文幻灯片，2018年1月](https://github.com/ClickHouse/clickhouse-presentations/blob/master/meetup12/telecom.pdf)                                                                                                  |
| [CARTO](https://carto.com/)                                     | 商业智能         | 地理分析       | —                                                 | —                                                                    | [地理空间处理与ClickHouse](https://carto.com/blog/geospatial-processing-with-clickhouse/)                                                                                                                         |
| [CERN](http://public.web.cern.ch/public/)                       | 研究             | 实验           | —                                                 | —                                                                    | [新闻稿,四月2012](https://www.yandex.com/company/press_center/press_releases/2012/2012-04-10/)                                                                                                                    |
| [思科](http://cisco.com/)                                       | 网络             | 流量分析       | —                                                 | —                                                                    | [闪电对话，十月2019](https://youtu.be/-hI1vDR2oPY?t=5057)                                                                                                                                                         |
| [城堡证券](https://www.citadelsecurities.com/)                  | 金融             | —              | —                                                 | —                                                                    | [贡献，2019年3月](https://github.com/ClickHouse/ClickHouse/pull/4774)                                                                                                                                             |
| [Citymobil](https://city-mobil.ru)                              | 出租车           | 分析           | —                                                 | —                                                                    | [俄文博客文章，三月2020](https://habr.com/en/company/citymobil/blog/490660/)                                                                                                                                      |
| [内容广场](https://contentsquare.com)                           | 网站分析         | 主要产品       | —                                                 | —                                                                    | [法文博客文章，十一月2018](http://souslecapot.net/2018/11/21/patrick-chatain-vp-engineering-chez-contentsquare-penser-davantage-amelioration-continue-que-revolution-constante/)                                  |
| [Cloudflare](https://cloudflare.com)                            | CDN              | 流量分析       | 36服务器                                          | —                                                                    | [博客文章,五月2017](https://blog.cloudflare.com/how-cloudflare-analyzes-1m-dns-queries-per-second/), [博客文章,三月2018](https://blog.cloudflare.com/http-analytics-for-6m-requests-per-second-using-clickhouse/) |
| [Corunet](https://coru.net/)                                    | 分析             | 主要产品       | —                                                 | —                                                                    | [英文幻灯片，2019年4月](https://github.com/ClickHouse/clickhouse-presentations/blob/master/meetup21/predictive_models.pdf)                                                                                        |
| [CraiditX 氪信](https://www.creditx.com)                        | 金融AI           | 分析           | —                                                 | —                                                                    | [英文幻灯片，2019年11月](https://github.com/ClickHouse/clickhouse-presentations/blob/master/meetup33/udf.pptx)                                                                                                    |
| [Criteo/Storetail](https://www.criteo.com/)                     | 零售             | 主要产品       | —                                                 | —                                                                    | [英文幻灯片，十月2018](https://github.com/ClickHouse/clickhouse-presentations/blob/master/meetup18/3_storetail.pptx)                                                                                              |
| [德意志银行](https://db.com)                                    | 金融             | 商业智能分析   | —                                                 | —                                                                    | [英文幻灯片，十月2019](https://bigdatadays.ru/wp-content/uploads/2019/10/D2-H3-3_Yakunin-Goihburg.pdf)                                                                                                            |
| [Diva-e](https://www.diva-e.com)                                | 数字咨询         | 主要产品       | —                                                 | —                                                                    | [英文幻灯片，2019年9月](https://github.com/ClickHouse/clickhouse-presentations/blob/master/meetup29/ClickHouse-MeetUp-Unusual-Applications-sd-2019-09-17.pdf)                                                     |
| [Exness](https://www.exness.com)                                | 交易             | 指标，日志记录 | —                                                 | —                                                                    | [俄语交谈，2019年5月](https://youtu.be/_rpU-TvSfZ8?t=3215)                                                                                                                                                        |
| [精灵](https://geniee.co.jp)                                    | 广告网络         | 主要产品       | —                                                 | —                                                                    | [日文博客，2017年7月](https://tech.geniee.co.jp/entry/2017/07/20/160100)                                                                                                                                          |
| [虎牙](https://www.huya.com/)                                   | 视频流           | 分析           | —                                                 | —                                                                    | [中文幻灯片，2018年10月](https://github.com/ClickHouse/clickhouse-presentations/blob/master/meetup19/7.%20ClickHouse万亿数据分析实践%20李本旺(sundy-li)%20虎牙.pdf)                                               |
| [Idealista](https://www.idealista.com)                          | 房地产           | 分析           | —                                                 | —                                                                    | [英文博客文章,四月2019](https://clickhouse.com/blog/en/clickhouse-meetup-in-madrid-on-april-2-2019)                                                                                                            |
| [Infovista](https://www.infovista.com/)                         | 网络             | 分析           | —                                                 | —                                                                    | [英文幻灯片，十月2019](https://github.com/ClickHouse/clickhouse-presentations/blob/master/meetup30/infovista.pdf)                                                                                                 |
| [InnoGames](https://www.innogames.com)                          | 游戏             | 指标，日志记录 | —                                                 | —                                                                    | [俄文幻灯片，2019年9月](https://github.com/ClickHouse/clickhouse-presentations/blob/master/meetup28/graphite_and_clickHouse.pdf)                                                                                  |
| [Integros](https://integros.com)                                | 视频服务平台     | 分析           | —                                                 | —                                                                    | [俄文幻灯片，2019年5月](https://github.com/ClickHouse/clickhouse-presentations/blob/master/meetup22/strategies.pdf)                                                                                               |
| [科迪亚克数据](https://www.kodiakdata.com/)                     | 云               | 主要产品       | —                                                 | —                                                                    | [虏茅驴麓卤戮碌禄路戮鲁拢](https://github.com/ClickHouse/clickhouse-presentations/blob/master/meetup13/kodiak_data.pdf)                                                                                           |
| [Kontur](https://kontur.ru)                                     | 软件开发         | 指标           | —                                                 | —                                                                    | [俄语交谈，2018年11月](https://www.youtube.com/watch?v=U4u4Bd0FtrY)                                                                                                                                               |
| [LifeStreet](https://lifestreet.com/)                           | 广告网络         | 主要产品       | 75台服务器（3个副本)                              | 5.27PiB                                                              | [俄文博客文章，2017年2月](https://habr.com/en/post/322620/)                                                                                                                                                       |
| [Mail.ru 云解决方案](https://mcs.mail.ru/)                      | 云服务           | 主要产品       | —                                                 | —                                                                    | [运行ClickHouse实例，俄语](https://mcs.mail.ru/help/db-create/clickhouse#)                                                                                                                                        |
| [MessageBird](https://www.messagebird.com)                      | 电信             | 统计           | —                                                 | —                                                                    | [英文幻灯片，2018年11月](https://github.com/ClickHouse/clickhouse-presentations/blob/master/meetup20/messagebird.pdf)                                                                                             |
| [MGID](https://www.mgid.com/)                                   | 广告网络         | 网络分析       | —                                                 | —                                                                    | [我们在实施分析DBMS ClickHouse的经验，俄文](http://gs-studio.com/news-about-it/32777----clickhouse---c)                                                                                                           |
| [OneAPM](https://www.oneapm.com/)                               | 监测和数据分析   | 主要产品       | —                                                 | —                                                                    | [中文幻灯片，2018年10月](https://github.com/ClickHouse/clickhouse-presentations/blob/master/meetup19/8.%20clickhouse在OneAPM的应用%20杜龙.pdf)                                                                    |
| [Pragma Innovation](http://www.pragma-innovation.fr/)           | 遥测和大数据分析 | 主要产品       | —                                                 | —                                                                    | [英文幻灯片，十月2018](https://github.com/ClickHouse/clickhouse-presentations/blob/master/meetup18/4_pragma_innovation.pdf)                                                                                       |
| [青云](https://www.qingcloud.com/)                              | 云服务           | 主要产品       | —                                                 | —                                                                    | [中文幻灯片，2018年10月](https://github.com/ClickHouse/clickhouse-presentations/blob/master/meetup19/4.%20Cloud%20%2B%20TSDB%20for%20ClickHouse%20张健%20QingCloud.pdf)                                           |
| [Qrator](https://qrator.net)                                    | DDoS保护         | 主要产品       | —                                                 | —                                                                    | [博客文章,三月2019](https://blog.qrator.net/en/clickhouse-ddos-mitigation_37/)                                                                                                                                    |
| [百分点](https://www.percent.cn/)                               | 分析             | 主要产品       | —                                                 | —                                                                    | [中文幻灯片，2019年6月](https://github.com/ClickHouse/clickhouse-presentations/blob/master/meetup24/4.%20ClickHouse万亿数据双中心的设计与实践%20.pdf)                                                             |
| [漫步者](https://rambler.ru)                                    | 互联网服务       | 分析           | —                                                 | —                                                                    | [俄语讲座，2018年4月](https://medium.com/@ramblertop/разработка-api-clickhouse-для-рамблер-топ-100-f4c7e56f3141)                                                                                                  |
| [腾讯](https://www.tencent.com)                                 | 通讯软件         | 日志记录       | —                                                 | —                                                                    | [中文讲座，2019年11月](https://youtu.be/T-iVQRuw-QY?t=5050)                                                                                                                                                       |
| [流量之星](https://trafficstars.com/)                           | 广告网络         | —              | —                                                 | —                                                                    | [俄文幻灯片，2018年5月](https://github.com/ClickHouse/clickhouse-presentations/blob/master/meetup15/lightning/ninja.pdf)                                                                                          |
| [S7航空公司](https://www.s7.ru)                                 | 航空公司         | 指标，日志记录 | —                                                 | —                                                                    | [俄文，2019年3月](https://www.youtube.com/watch?v=nwG68klRpPg&t=15s)                                                                                                                                              |
| [SEMrush](https://www.semrush.com/)                             | 营销             | 主要产品       | —                                                 | —                                                                    | [俄文幻灯片，八月2018](https://github.com/ClickHouse/clickhouse-presentations/blob/master/meetup17/5_semrush.pdf)                                                                                                 |
| [scireum GmbH](https://www.scireum.de/)                         | 电子商务         | 主要产品       | —                                                 | —                                                                    | [德语讲座，2020年2月](https://www.youtube.com/watch?v=7QWAn5RbyR4)                                                                                                                                                |
| [Sentry](https://sentry.io/)                                    | 软件开发         | 产品后端       | —                                                 | —                                                                    | [英文博客文章,五月2019](https://blog.sentry.io/2019/05/16/introducing-snuba-sentrys-new-search-infrastructure)                                                                                                    |
| [SGK](http://www.sgk.gov.tr/wps/portal/sgk/tr)                  | 政府社会保障     | 分析           | —                                                 | —                                                                    | [英文幻灯片，2019年11月](https://github.com/ClickHouse/clickhouse-presentations/blob/master/meetup35/ClickHouse%20Meetup-Ramazan%20POLAT.pdf)                                                                     |
| [seo.do](https://seo.do/)                                       | 分析             | 主要产品       | —                                                 | —                                                                    | [英文幻灯片，2019年11月](https://github.com/ClickHouse/clickhouse-presentations/blob/master/meetup35/CH%20Presentation-%20Metehan%20Çetinkaya.pdf)                                                                |
| [新浪](http://sina.com/)                                        | 新闻             | —              | —                                                 | —                                                                    | [中文幻灯片，2018年10月](https://github.com/ClickHouse/clickhouse-presentations/blob/master/meetup19/6.%20ClickHouse最佳实践%20高鹏_新浪.pdf)                                                                     |
| [SMI2](https://smi2.ru/)                                        | 新闻             | 分析           | —                                                 | —                                                                    | [俄文博客文章，2017年11月](https://habr.com/ru/company/smi2/blog/314558/)                                                                                                                                         |
| [Splunk](https://www.splunk.com/)                               | 业务分析         | 主要产品       | —                                                 | —                                                                    | [英文幻灯片，2018年1月](https://github.com/ClickHouse/clickhouse-presentations/blob/master/meetup12/splunk.pdf)                                                                                                   |
| [Spotify](https://www.spotify.com)                              | 音乐             | 实验           | —                                                 | —                                                                    | [幻灯片，七月2018](https://www.slideshare.net/glebus/using-clickhouse-for-experimentation-104247173)                                                                                                              |
| [腾讯](https://www.tencent.com)                                 | 大数据           | 数据处理       | —                                                 | —                                                                    | [中文幻灯片，2018年10月](https://github.com/ClickHouse/clickhouse-presentations/blob/master/meetup19/5.%20ClickHouse大数据集群应用_李俊飞腾讯网媒事业部.pdf)                                                      |
| <a href="https://www.tencentmusic.com/" class="favicon">腾讯QQ音乐(TME)</a>                                  | 大数据                       | 数据处理               | —                                                          | —                                                                            | [博客文章，2020年6月](https://cloud.tencent.com/developer/article/1637840)
| [优步](https://www.uber.com)                                    | 出租车           | 日志记录       | —                                                 | —                                                                    | [幻灯片，二月2020](https://presentations.clickhouse.com/meetup40/uber.pdf)                                                                                                                                       |
| [VKontakte](https://vk.com)                                     | 社交网络         | 统计，日志记录 | —                                                 | —                                                                    | [俄文幻灯片，八月2018](https://github.com/ClickHouse/clickhouse-presentations/blob/master/meetup17/3_vk.pdf)                                                                                                      |
| [Wisebits](https://wisebits.com/)                               | IT解决方案       | 分析           | —                                                 | —                                                                    | [俄文幻灯片，2019年5月](https://github.com/ClickHouse/clickhouse-presentations/blob/master/meetup22/strategies.pdf)                                                                                               |
| [晓信科技](https://www.xiaoheiban.cn/)                          | 教育             | 共同目的       | —                                                 | —                                                                    | [英文幻灯片，2019年11月](https://github.com/ClickHouse/clickhouse-presentations/blob/master/meetup33/sync-clickhouse-with-mysql-mongodb.pptx)                                                                     |
| [喜马拉雅](https://www.ximalaya.com/)                           | 音频共享         | OLAP           | —                                                 | —                                                                    | [英文幻灯片，2019年11月](https://github.com/ClickHouse/clickhouse-presentations/blob/master/meetup33/ximalaya.pdf)                                                                                                |
| [Yandex云](https://cloud.yandex.ru/services/managed-clickhouse) | 公有云           | 主要产品       | —                                                 | —                                                                    | [俄文，2019年12月](https://www.youtube.com/watch?v=pgnak9e_E0o)                                                                                                                                                   |
| [Yandex DataLens](https://cloud.yandex.ru/services/datalens)    | 商业智能         | 主要产品       | —                                                 | —                                                                    | [俄文幻灯片，十二月2019](https://presentations.clickhouse.com/meetup38/datalens.pdf)                                                                                                                             |
| [Yandex市场](https://market.yandex.ru/)                         | 电子商务         | 指标，日志记录 | —                                                 | —                                                                    | [俄文，2019年1月](https://youtu.be/_l1qP0DyBcA?t=478)                                                                                                                                                             |
| [Yandex Metrica](https://metrica.yandex.com)                    | 网站分析         | 主要产品       | 一个集群中的360台服务器，一个部门中的1862台服务器 | 66.41PiB/5.68PiB                                                     | [幻灯片，二月2020](https://presentations.clickhouse.com/meetup40/introduction/#13)                                                                                                                               |
| [ЦВТ](https://htc-cs.ru/)                                       | 软件开发         | 指标，日志记录 | —                                                 | —                                                                    | [博客文章,三月2019，俄文](https://vc.ru/dev/62715-kak-my-stroili-monitoring-na-prometheus-clickhouse-i-elk)                                                                                                       |
| [МКБ](https://mkb.ru/)                                          | 银行             | 网络系统监控   | —                                                 | —                                                                    | [俄文幻灯片，2019年9月](https://github.com/ClickHouse/clickhouse-presentations/blob/master/meetup28/mkb.pdf)                                                                                                      |
| [金数据](https://jinshuju.net)                                  | 商业智能分析     | 主要产品       | —                                                 | —                                                                    | [中文幻灯片，2019年10月](https://github.com/ClickHouse/clickhouse-presentations/blob/master/meetup24/3.%20金数据数据架构调整方案Public.pdf)                                                                       |
| [Instana](https://www.instana.com)                              | APM 平台         | 主要产品       | —                                                 | —                                                                    | [推特消息](https://twitter.com/mieldonkers/status/1248884119158882304)                                                                                                                                            |
| [Wargaming](https://wargaming.com/en/)                          | 游戏             |                | —                                                 | —                                                                    | [采访](https://habr.com/en/post/496954/)                                                                                                                                                                          |
| [Crazypanda](https://crazypanda.ru/en/)                         | 游戏             |                | —                                                 | —                                                                    | ClickHouse 社区会议                                                                                                                                                                                               |
| [FunCorp](https://fun.co/rp)                                    | 游戏             |                | —                                                 | —                                                                    | [文章](https://www.altinity.com/blog/migrating-from-redshift-to-clickhouse)                                                                                                                                       |

[原始文章](https://clickhouse.com/docs/en/introduction/adopters/) <!--hide-->
