---
toc_folder_title: F.A.Q.
toc_hidden: true
toc_priority: 76
---

# ClickHouse 问答 F.A.Q {#clickhouse-f-a-q}

本节文档是一个收集经常出现的ClickHouse相关问题的答案的地方。

类别:

-   **[常见问题](../faq/general/index.md)**
    -   [什么是 ClickHouse?](../index.md#what-is-clickhouse)
    -   [为何 ClickHouse 如此迅捷?](../faq/general/why-clickhouse-is-so-fast.md)
    -   [谁在使用 ClickHouse?](../faq/general/who-is-using-clickhouse.md)
    -   [“ClickHouse” 有什么含义?](../faq/general/dbms-naming.md)
    -   [ “Не тормозит” 有什么含义?](../faq/general/ne-tormozit.md)
    -   [什么是 OLAP?](../faq/general/olap.md)
    -   [什么是列存储数据库?](../faq/general/columnar-database.md)
    -   [为何不使用 MapReduce等技术?](../faq/general/mapreduce.md)
    -   [我如何为 ClickHouse贡献代码?](../faq/general/how-do-i-contribute-code-to-clickhouse.md)
-   **[应用案例](../faq/use-cases/index.md)**
    -   [我能把 ClickHouse 作为时序数据库来使用吗?](../faq/use-cases/time-series.md)
    -   [我能把 ClickHouse 作为 key-value 键值存储吗？](../faq/use-cases/key-value.md)
-   **[运维操作](../faq/operations/index.md)**
    -   [如果想在生产环境部署，需要用哪个版本的 ClickHouse 呢?](../faq/operations/production.md)
    -   [是否可能从 ClickHouse 数据表中删除所有旧的数据记录?](../faq/operations/delete-old-data.md)
    -   [ClickHouse支持多区域复制吗?](../faq/operations/multi-region-replication.md)
-   **[集成开发](../faq/integration/index.md)**
    -   [如何从 ClickHouse 导出数据到一个文件?](../faq/integration/file-export.md)
    -   [如果我用ODBC链接Oracle数据库出现编码问题该怎么办?](../faq/integration/oracle-odbc.md)

{## TODO
Question candidates:
- How to choose a primary key?
- How to add a column in ClickHouse?
- Too many parts
- How to filter ClickHouse table by an array column contents?
- How to insert all rows from one table to another of identical structure?
- How to kill a process (query) in ClickHouse?
- How to implement pivot (like in pandas)?
- How to remove the default ClickHouse user through users.d?
- Importing MySQL dump to ClickHouse
- Window function workarounds (row_number, lag/lead, running diff/sum/average)
##}

{## [原始文档](https://clickhouse.com/docs/en/faq) ##}
