---
toc_priority: 45
toc_title: s3
---

# Табличная Функция S3 {#s3-table-function}

Предоставляет табличный интерфейс для выбора/вставки файлов в [Amazon S3](https://aws.amazon.com/s3/). Эта табличная функция похожа на [hdfs](../../sql-reference/table-functions/hdfs.md), но обеспечивает специфические для S3 возможности.

**Синтаксис**

``` sql
s3(path, [aws_access_key_id, aws_secret_access_key,] format, structure, [compression])
```

**Aргументы**

-   `path` — URL-адрес бакета с указанием пути к файлу. Поддерживает следующие подстановочные знаки в режиме "только чтение": `*, ?, {abc,def} и {N..M}` где `N, M` — числа, `'abc', 'def'` — строки. Подробнее смотри [здесь](../../engines/table-engines/integrations/s3.md#wildcards-in-path).
-   `format` — [формат](../../interfaces/formats.md#formats) файла.
-   `structure` — cтруктура таблицы. Формат `'column1_name column1_type, column2_name column2_type, ...'`.
-   `compression` — автоматически обнаруживает сжатие по расширению файла. Возможные значения: `none`, `gzip/gz`, `brotli/br`, `xz/LZMA`, `zstd/zst`. Необязательный параметр.

**Возвращаемые значения**

Таблица с указанной структурой для чтения или записи данных в указанный файл.

**Примеры**

Создание таблицы из файла S3 `https://storage.yandexcloud.net/my-test-bucket-768/data.csv` и выбор первых трех столбцов из нее:

Запрос:

``` sql
SELECT *
FROM s3('https://storage.yandexcloud.net/my-test-bucket-768/data.csv', 'CSV', 'column1 UInt32, column2 UInt32, column3 UInt32')
LIMIT 2;
```

Результат:

``` text
┌─column1─┬─column2─┬─column3─┐
│       1 │       2 │       3 │
│       3 │       2 │       1 │
└─────────┴─────────┴─────────┘
```

То же самое, но файл со сжатием `gzip`:

Запрос:

``` sql
SELECT *
FROM s3('https://storage.yandexcloud.net/my-test-bucket-768/data.csv.gz', 'CSV', 'column1 UInt32, column2 UInt32, column3 UInt32', 'gzip')
LIMIT 2;
```

Результат:

``` text
┌─column1─┬─column2─┬─column3─┐
│       1 │       2 │       3 │
│       3 │       2 │       1 │
└─────────┴─────────┴─────────┘
```

## Примеры использования {#usage-examples}

Предположим, у нас есть несколько файлов со следующими URI на S3:

-   'https://storage.yandexcloud.net/my-test-bucket-768/some_prefix/some_file_1.csv'
-   'https://storage.yandexcloud.net/my-test-bucket-768/some_prefix/some_file_2.csv'
-   'https://storage.yandexcloud.net/my-test-bucket-768/some_prefix/some_file_3.csv'
-   'https://storage.yandexcloud.net/my-test-bucket-768/some_prefix/some_file_4.csv'
-   'https://storage.yandexcloud.net/my-test-bucket-768/another_prefix/some_file_1.csv'
-   'https://storage.yandexcloud.net/my-test-bucket-768/another_prefix/some_file_2.csv'
-   'https://storage.yandexcloud.net/my-test-bucket-768/another_prefix/some_file_3.csv'
-   'https://storage.yandexcloud.net/my-test-bucket-768/another_prefix/some_file_4.csv'

Подсчитаем количество строк в файлах, заканчивающихся цифрами от 1 до 3:

``` sql
SELECT count(*)
FROM s3('https://storage.yandexcloud.net/my-test-bucket-768/{some,another}_prefix/some_file_{1..3}.csv', 'CSV', 'name String, value UInt32');
```

``` text
┌─count()─┐
│      18 │
└─────────┘
```

Подсчитаем общее количество строк во всех файлах этих двух каталогов:

``` sql
SELECT count(*)
FROM s3('https://storage.yandexcloud.net/my-test-bucket-768/{some,another}_prefix/*', 'CSV', 'name String, value UInt32');
```

``` text
┌─count()─┐
│      24 │
└─────────┘
```

!!! warning "Warning"
    Если список файлов содержит диапазоны чисел с ведущими нулями, используйте конструкцию с фигурными скобками для каждой цифры отдельно или используйте `?`.

Подсчитаем общее количество строк в файлах с именами `file-000.csv`, `file-001.csv`, … , `file-999.csv`:

``` sql
SELECT count(*)
FROM s3('https://storage.yandexcloud.net/my-test-bucket-768/big_prefix/file-{000..999}.csv', 'CSV', 'name String, value UInt32');
```

``` text
┌─count()─┐
│      12 │
└─────────┘
```

Запишем данные в файл `test-data.csv.gz`:

``` sql
INSERT INTO FUNCTION s3('https://storage.yandexcloud.net/my-test-bucket-768/test-data.csv.gz', 'CSV', 'name String, value UInt32', 'gzip')
VALUES ('test-data', 1), ('test-data-2', 2);
```

Запишем данные из существующей таблицы в файл `test-data.csv.gz`:

``` sql
INSERT INTO FUNCTION s3('https://storage.yandexcloud.net/my-test-bucket-768/test-data.csv.gz', 'CSV', 'name String, value UInt32', 'gzip')
SELECT name, value FROM existing_table;
```

## Партиционирование при записи данных {#partitioned-write}

Если при добавлении данных в таблицу S3 указать выражение `PARTITION BY`, то для каждого значения ключа партиционирования создается отдельный файл. Это повышает эффективность операций чтения.

**Примеры**

1. При использовании ID партиции в имени ключа создаются отдельные файлы:

```sql
INSERT INTO TABLE FUNCTION
    s3('http://bucket.amazonaws.com/my_bucket/file_{_partition_id}.csv', 'CSV', 'a UInt32, b UInt32, c UInt32')
    PARTITION BY a VALUES ('x', 2, 3), ('x', 4, 5), ('y', 11, 12), ('y', 13, 14), ('z', 21, 22), ('z', 23, 24);
```
В результате данные будут записаны в три файла: `file_x.csv`, `file_y.csv` и `file_z.csv`.

2. При использовании ID партиции в названии бакета создаются файлы в разных бакетах:

```sql
INSERT INTO TABLE FUNCTION
    s3('http://bucket.amazonaws.com/my_bucket_{_partition_id}/file.csv', 'CSV', 'a UInt32, b UInt32, c UInt32')
    PARTITION BY a VALUES (1, 2, 3), (1, 4, 5), (10, 11, 12), (10, 13, 14), (20, 21, 22), (20, 23, 24);
```
В результате будут созданы три файла в разных бакетах: `my_bucket_1/file.csv`, `my_bucket_10/file.csv` и `my_bucket_20/file.csv`.

**Смотрите также**

-  [Движок таблиц S3](../../engines/table-engines/integrations/s3.md)

[Оригинальная статья](https://clickhouse.com/docs/ru/sql-reference/table-functions/s3/) <!--hide-->

