---
toc_title: FROM
---

# Секция FROM {#select-from}

В секции `FROM` указывается источник, из которого будут читаться данные:

-   [Таблица](../../../engines/table-engines/index.md)
-   [Подзапрос](index.md) {## TODO: better link ##}
-   [Табличная функция](../../table-functions/index.md#table-functions)

Секция [JOIN](join.md) и [ARRAY JOIN](array-join.md) могут быть использованы для расширения функциональных возможностей секции `FROM`.

Подзапрос — дополнительный `SELECT` запрос, который может быть указан в круглых скобках внутри секции `FROM`.

Секция `FROM` может содержать несколько источников данных, указанных через запятую, что эквивалентно выполнению [CROSS JOIN](join.md) на них.

## Модификатор FINAL {#select-from-final}

Если в запросе используется модификатор `FINAL`, то ClickHouse полностью мёржит данные перед выдачей результата, таким образом выполняя все преобразования данных, которые производятся движком таблиц при мёржах.

Он применим при выборе данных из таблиц, использующих [MergeTree](../../../engines/table-engines/mergetree-family/mergetree.md)- семейство движков. Также поддерживается для:

-   [Replicated](../../../engines/table-engines/mergetree-family/replication.md) варианты исполнения `MergeTree` движков.
-   [View](../../../engines/table-engines/special/view.md), [Buffer](../../../engines/table-engines/special/buffer.md), [Distributed](../../../engines/table-engines/special/distributed.md), и [MaterializedView](../../../engines/table-engines/special/materializedview.md), которые работают поверх других движков, если они созданы для таблиц с движками семейства `MergeTree`.

Теперь `SELECT` запросы с `FINAL` выполняются параллельно и, следовательно, немного быстрее. Но имеются серьезные недостатки при их использовании (смотрите ниже). Настройка [max_final_threads](../../../operations/settings/settings.md#max-final-threads) устанавливает максимальное количество потоков.

### Недостатки {#drawbacks}

Запросы, которые используют `FINAL` выполняются немного медленее, чем аналогичные запросы без него, потому что:

-   Данные мёржатся во время выполнения запроса.
-   Запросы с модификатором `FINAL` читают столбцы первичного ключа в дополнение к столбцам, используемым в запросе.

**В большинстве случаев избегайте использования `FINAL`.** Общий подход заключается в использовании агрегирующих запросов, которые предполагают, что фоновые процессы движков семейства `MergeTree` ещё не случились  (например, сами отбрасывают дубликаты). {## TODO: examples ##}

## Детали реализации {#implementation-details}

Если секция `FROM` опущена, данные будут считываться из таблицы `system.one`.
Таблица `system.one` содержит ровно одну строку.

Для выполнения запроса, из соответствующей таблицы, вынимаются все столбцы, перечисленные в запросе. Из подзапросов выкидываются столбцы, не нужные для внешнего запроса.

Если в запросе не перечислено ни одного столбца (например, `SELECT count() FROM t)`, то из таблицы всё равно вынимается один какой-нибудь столбец (предпочитается самый маленький), для того, чтобы можно было посчитать количество строк.
