---
toc_title: DISTINCT
---

# Секция DISTINCT {#select-distinct}

Если указан `SELECT DISTINCT`, то в результате запроса останутся только уникальные строки. Таким образом, из всех наборов полностью совпадающих строк в результате останется только одна строка.

Вы можете указать столбцы, по которым хотите отбирать уникальные значения: `SELECT DISTINCT ON (column1, column2,...)`. Если столбцы не указаны, то отбираются строки, в которых значения уникальны во всех столбцах. 

Рассмотрим таблицу:

```text
┌─a─┬─b─┬─c─┐
│ 1 │ 1 │ 1 │
│ 1 │ 1 │ 1 │
│ 2 │ 2 │ 2 │
│ 2 │ 2 │ 2 │
│ 1 │ 1 │ 2 │
│ 1 │ 2 │ 2 │
└───┴───┴───┘
```

Использование `DISTINCT` без указания столбцов:

```sql
SELECT DISTINCT * FROM t1;
```

```text
┌─a─┬─b─┬─c─┐
│ 1 │ 1 │ 1 │
│ 2 │ 2 │ 2 │
│ 1 │ 1 │ 2 │
│ 1 │ 2 │ 2 │
└───┴───┴───┘
```

Использование `DISTINCT` с указанием столбцов:

```sql
SELECT DISTINCT ON (a,b) * FROM t1;
```

```text
┌─a─┬─b─┬─c─┐
│ 1 │ 1 │ 1 │
│ 2 │ 2 │ 2 │
│ 1 │ 2 │ 2 │
└───┴───┴───┘
```

## DISTINCT и ORDER BY {#distinct-orderby}

ClickHouse поддерживает использование секций `DISTINCT` и `ORDER BY` для разных столбцов в одном запросе. Секция `DISTINCT` выполняется до секции `ORDER BY`.

Таблица для примера:

``` text
┌─a─┬─b─┐
│ 2 │ 1 │
│ 1 │ 2 │
│ 3 │ 3 │
│ 2 │ 4 │
└───┴───┘
```

При выборе данных с помощью `SELECT DISTINCT a FROM t1 ORDER BY b ASC`, мы получаем следующий результат:

``` text
┌─a─┐
│ 2 │
│ 1 │
│ 3 │
└───┘
```

Если мы изменим направление сортировки `SELECT DISTINCT a FROM t1 ORDER BY b DESC`, мы получаем следующий результат:

``` text
┌─a─┐
│ 3 │
│ 1 │
│ 2 │
└───┘
```

Ряд `2, 4` был разрезан перед сортировкой.

Учитывайте эту специфику при разработке запросов.

## Обработка NULL {#null-processing}

`DISTINCT` работает с [NULL](../../syntax.md#null-literal) как-будто `NULL` — обычное значение и `NULL==NULL`. Другими словами, в результате `DISTINCT`, различные комбинации с `NULL` встретятся только один раз. Это отличается от обработки `NULL` в большинстве других контекстов.

## Альтернативы {#alternatives}

Можно получить такой же результат, применив [GROUP BY](group-by.md) для того же набора значений, которые указан в секции `SELECT`, без использования каких-либо агрегатных функций. Но есть несколько отличий от `GROUP BY`:

-   `DISTINCT` может применяться вместе с `GROUP BY`.
-   Когда секция [ORDER BY](order-by.md) опущена, а секция [LIMIT](limit.md) присутствует, запрос прекращает выполнение сразу после считывания необходимого количества различных строк.
-   Блоки данных выводятся по мере их обработки, не дожидаясь завершения выполнения всего запроса.

