---
toc_priority: 40
toc_title: "Функции для работы со строками"
---

# Функции для работы со строками {#funktsii-dlia-raboty-so-strokami}

## empty {#empty}

Проверяет, является ли входная строка пустой.

**Синтаксис**

``` sql
empty(x)
```

Строка считается непустой, если содержит хотя бы один байт, пусть даже это пробел или нулевой байт. 

Функция также поддерживает работу с типами [Array](array-functions.md#function-empty) и [UUID](uuid-functions.md#empty).

**Параметры**

-   `x` — Входная строка. [String](../data-types/string.md).

**Возвращаемое значение**

-   Возвращает `1` для пустой строки и `0` — для непустой строки.

Тип: [UInt8](../data-types/int-uint.md).

**Пример**

Запрос:

```sql
SELECT empty('text');
```

Результат:

```text
┌─empty('text')─┐
│             0 │
└───────────────┘
```

## notEmpty {#notempty}

Проверяет, является ли входная строка непустой.

**Синтаксис**

``` sql
notEmpty(x)
```

Строка считается непустой, если содержит хотя бы один байт, пусть даже это пробел или нулевой байт. 

Функция также поддерживает работу с типами [Array](array-functions.md#function-notempty) и [UUID](uuid-functions.md#notempty).

**Параметры**

-   `x` — Входная строка. [String](../data-types/string.md).

**Возвращаемое значение**

-   Возвращает `1` для непустой строки и `0` — для пустой строки.

Тип: [UInt8](../data-types/int-uint.md).

**Пример**

Запрос:

```sql
SELECT notEmpty('text');
```

Результат:

```text
┌─notEmpty('text')─┐
│                1 │
└──────────────────┘
```

## length {#length}

Возвращает длину строки в байтах (не символах, не кодовых точках).
Тип результата — UInt64.
Функция также работает для массивов.

## lengthUTF8 {#lengthutf8}

Возвращает длину строки в кодовых точках Unicode (не символах), при допущении, что строка содержит набор байтов, являющийся текстом в кодировке UTF-8. Если допущение не выполнено, то возвращает какой-нибудь результат (не кидает исключение).
Тип результата — UInt64.

## char_length, CHAR_LENGTH {#char-length}

Возвращает длину строки в кодовых точках Unicode (не символах), при допущении, что строка содержит набор байтов, являющийся текстом в кодировке UTF-8. Если допущение не выполнено, возвращает какой-нибудь результат (не кидает исключение).
Тип результата — UInt64.

## character_length, CHARACTER_LENGTH {#character-length}

Возвращает длину строки в кодовых точках Unicode (не символах), при допущении, что строка содержит набор байтов, являющийся текстом в кодировке UTF-8. Если допущение не выполнено, возвращает какой-нибудь результат (не кидает исключение).
Тип результата — UInt64.

## leftPad {#leftpad}

Дополняет текущую строку слева пробелами или указанной строкой (несколько раз, если необходимо), пока результирующая строка не достигнет заданной длины. Соответствует MySQL функции `LPAD`.

**Синтаксис**

``` sql
leftPad('string', 'length'[, 'pad_string'])
```

**Параметры**

-   `string` — входная строка, которую необходимо дополнить. [String](../data-types/string.md).
-   `length` — длина результирующей строки. [UInt](../data-types/int-uint.md). Если указанное значение меньше, чем длина входной строки, то входная строка возвращается как есть.
-   `pad_string` — строка, используемая для дополнения входной строки. [String](../data-types/string.md). Необязательный параметр. Если не указано, то входная строка дополняется пробелами.

**Возвращаемое значение**

-   Результирующая строка заданной длины.

Type: [String](../data-types/string.md).

**Пример**

Запрос:

``` sql
SELECT leftPad('abc', 7, '*'), leftPad('def', 7);
```

Результат:

``` text
┌─leftPad('abc', 7, '*')─┬─leftPad('def', 7)─┐
│ ****abc                │     def           │
└────────────────────────┴───────────────────┘
```

## leftPadUTF8 {#leftpadutf8}

Дополняет текущую строку слева пробелами или указанной строкой (несколько раз, если необходимо), пока результирующая строка не достигнет заданной длины. Соответствует MySQL функции `LPAD`. В отличие от функции [leftPad](#leftpad), измеряет длину строки не в байтах, а в кодовых точках Unicode.

**Синтаксис**

``` sql
leftPadUTF8('string','length'[, 'pad_string'])
```

**Параметры**

-   `string` — входная строка, которую необходимо дополнить. [String](../data-types/string.md).
-   `length` — длина результирующей строки. [UInt](../data-types/int-uint.md). Если указанное значение меньше, чем длина входной строки, то входная строка возвращается как есть.
-   `pad_string` — строка, используемая для дополнения входной строки. [String](../data-types/string.md). Необязательный параметр. Если не указано, то входная строка дополняется пробелами.

**Возвращаемое значение**

-   Результирующая строка заданной длины.

Type: [String](../data-types/string.md).

**Пример**

Запрос:

``` sql
SELECT leftPadUTF8('абвг', 7, '*'), leftPadUTF8('дежз', 7);
```

Результат:

``` text
┌─leftPadUTF8('абвг', 7, '*')─┬─leftPadUTF8('дежз', 7)─┐
│ ***абвг                     │    дежз                │
└─────────────────────────────┴────────────────────────┘
```

## rightPad {#rightpad}

Дополняет текущую строку справа пробелами или указанной строкой (несколько раз, если необходимо), пока результирующая строка не достигнет заданной длины. Соответствует MySQL функции `RPAD`.

**Синтаксис**

``` sql
rightPad('string', 'length'[, 'pad_string'])
```

**Параметры**

-   `string` — входная строка, которую необходимо дополнить. [String](../data-types/string.md).
-   `length` — длина результирующей строки. [UInt](../data-types/int-uint.md). Если указанное значение меньше, чем длина входной строки, то входная строка возвращается как есть.
-   `pad_string` — строка, используемая для дополнения входной строки. [String](../data-types/string.md). Необязательный параметр. Если не указано, то входная строка дополняется пробелами.

**Возвращаемое значение**

-   Результирующая строка заданной длины.

Type: [String](../data-types/string.md).

**Пример**

Запрос:

``` sql
SELECT rightPad('abc', 7, '*'), rightPad('abc', 7);
```

Результат:

``` text
┌─rightPad('abc', 7, '*')─┬─rightPad('abc', 7)─┐
│ abc****                 │ abc                │
└─────────────────────────┴────────────────────┘
```

## rightPadUTF8 {#rightpadutf8}

Дополняет текущую строку слева пробелами или указанной строкой (несколько раз, если необходимо), пока результирующая строка не достигнет заданной длины. Соответствует MySQL функции `RPAD`. В отличие от функции [rightPad](#rightpad), измеряет длину строки не в байтах, а в кодовых точках Unicode.

**Синтаксис**

``` sql
rightPadUTF8('string','length'[, 'pad_string'])
```

**Параметры**

-   `string` — входная строка, которую необходимо дополнить. [String](../data-types/string.md).
-   `length` — длина результирующей строки. [UInt](../data-types/int-uint.md). Если указанное значение меньше, чем длина входной строки, то входная строка возвращается как есть.
-   `pad_string` — строка, используемая для дополнения входной строки. [String](../data-types/string.md). Необязательный параметр. Если не указано, то входная строка дополняется пробелами.

**Возвращаемое значение**

-   Результирующая строка заданной длины.

Type: [String](../data-types/string.md).

**Пример**

Запрос:

``` sql
SELECT rightPadUTF8('абвг', 7, '*'), rightPadUTF8('абвг', 7);
```

Результат:

``` text
┌─rightPadUTF8('абвг', 7, '*')─┬─rightPadUTF8('абвг', 7)─┐
│ абвг***                      │ абвг                    │
└──────────────────────────────┴─────────────────────────┘
```

## lower, lcase {#lower}

Переводит ASCII-символы латиницы в строке в нижний регистр.

## upper, ucase {#upper}

Переводит ASCII-символы латиницы в строке в верхний регистр.

## lowerUTF8 {#lowerutf8}

Переводит строку в нижний регистр, при допущении, что строка содержит набор байтов, представляющий текст в кодировке UTF-8.
Не учитывает язык. То есть, для турецкого языка, результат может быть не совсем верным.
Если длина UTF-8 последовательности байтов различна для верхнего и нижнего регистра кодовой точки, то для этой кодовой точки результат работы может быть некорректным.
Если строка содержит набор байтов, не являющийся UTF-8, то поведение не определено.

## upperUTF8 {#upperutf8}

Переводит строку в верхний регистр, при допущении, что строка содержит набор байтов, представляющий текст в кодировке UTF-8.
Не учитывает язык. То есть, для турецкого языка, результат может быть не совсем верным.
Если длина UTF-8 последовательности байтов различна для верхнего и нижнего регистра кодовой точки, то для этой кодовой точки, результат работы может быть некорректным.
Если строка содержит набор байтов, не являющийся UTF-8, то поведение не определено.

## isValidUTF8 {#isvalidutf8}

Возвращает 1, если набор байтов является корректным в кодировке UTF-8, 0 иначе.

## toValidUTF8 {#tovalidutf8}

Заменяет некорректные символы UTF-8 на символ `�` (U+FFFD). Все идущие подряд некорректные символы схлопываются в один заменяющий символ.

``` sql
toValidUTF8(input_string)
```

**Аргументы**

-   `input_string` — произвольный набор байтов, представленный как объект типа [String](../../sql-reference/functions/string-functions.md).

Возвращаемое значение: Корректная строка UTF-8.

**Пример**

``` sql
SELECT toValidUTF8('\x61\xF0\x80\x80\x80b');
```

``` text
┌─toValidUTF8('a����b')─┐
│ a�b                   │
└───────────────────────┘
```

## repeat {#repeat}

Повторяет строку определенное количество раз и объединяет повторяемые значения в одну строку.

Синоним: `REPEAT`.

**Синтаксис**

``` sql
repeat(s, n)
```

**Аргументы**

-   `s` — строка для повторения. [String](../../sql-reference/functions/string-functions.md).
-   `n` — количество повторов. [UInt](../../sql-reference/functions/string-functions.md).

**Возвращаемое значение**

Строка, состоящая из повторений `n` раз исходной строки `s`. Если `n` \< 1, то функция вернет пустую строку.

Тип: `String`.

**Пример**

Запрос:

``` sql
SELECT repeat('abc', 10);
```

Результат:

``` text
┌─repeat('abc', 10)──────────────┐
│ abcabcabcabcabcabcabcabcabcabc │
└────────────────────────────────┘
```

## reverse {#reverse}

Разворачивает строку (как последовательность байтов).

## reverseUTF8 {#reverseutf8}

Разворачивает последовательность кодовых точек Unicode, при допущении, что строка содержит набор байтов, представляющий текст в кодировке UTF-8. Иначе — что-то делает (не кидает исключение).

## format(pattern, s0, s1, …) {#format}

Форматирует константный шаблон со строками, перечисленными в аргументах. `pattern` — упрощенная версия шаблона в языке Python. Шаблон содержит «заменяющие поля», которые окружены фигурными скобками `{}`. Всё, что не содержится в скобках, интерпретируется как обычный текст и просто копируется. Если нужно использовать символ фигурной скобки, можно экранировать двойной скобкой `{{ '{{' }}` или `{{ '}}' }}`. Имя полей могут быть числами (нумерация с нуля) или пустыми (тогда они интерпретируются как последовательные числа).

``` sql
SELECT format('{1} {0} {1}', 'World', 'Hello')
```

``` text
┌─format('{1} {0} {1}', 'World', 'Hello')─┐
│ Hello World Hello                       │
└─────────────────────────────────────────┘
```

``` sql
SELECT format('{} {}', 'Hello', 'World')
```

``` text
┌─format('{} {}', 'Hello', 'World')─┐
│ Hello World                       │
└───────────────────────────────────┘
```

## concat {#concat}

Склеивает строки, переданные в аргументы, в одну строку без разделителей.

**Cинтаксис**

``` sql
concat(s1, s2, ...)
```

**Аргументы**

Значения типа String или FixedString.

**Возвращаемое значение**

Возвращает строку, полученную в результате склейки аргументов.

Если любой из аргументов имеет значение `NULL`, `concat` возвращает значение `NULL`.

**Пример**

Запрос:

``` sql
SELECT concat('Hello, ', 'World!');
```

Результат:

``` text
┌─concat('Hello, ', 'World!')─┐
│ Hello, World!               │
└─────────────────────────────┘
```

## concatAssumeInjective {#concatassumeinjective}

Аналогична [concat](#concat). Разница заключается в том, что вам нужно убедиться, что `concat(s1, s2, ...) → sn` является инъективным, так как это предположение будет использоваться для оптимизации GROUP BY.

Функция называется «инъективной», если она возвращает разные значения для разных аргументов. Или, иными словами, функция никогда не выдаёт одно и то же значение, если аргументы разные.

**Синтаксис**

``` sql
concatAssumeInjective(s1, s2, ...)
```

**Аргументы**

Значения типа String или FixedString.

**Возвращаемые значения**

Возвращает строку, полученную в результате объединения аргументов.

Если любой из аргументов имеет значение `NULL`, `concatAssumeInjective` возвращает значение `NULL`.

**Пример**

Вводная таблица:

``` sql
CREATE TABLE key_val(`key1` String, `key2` String, `value` UInt32) ENGINE = TinyLog
INSERT INTO key_val VALUES ('Hello, ','World',1)('Hello, ','World',2)('Hello, ','World!',3)('Hello',', World!',2)
SELECT * from key_val
```

``` text
┌─key1────┬─key2─────┬─value─┐
│ Hello,  │ World    │     1 │
│ Hello,  │ World    │     2 │
│ Hello,  │ World!   │     3 │
│ Hello   │ , World! │     2 │
└─────────┴──────────┴───────┘
```

Запрос:

``` sql
SELECT concat(key1, key2), sum(value) FROM key_val GROUP BY (key1, key2);
```

Результат:

``` text
┌─concat(key1, key2)─┬─sum(value)─┐
│ Hello, World!      │          3 │
│ Hello, World!      │          2 │
│ Hello, World       │          3 │
└────────────────────┴────────────┘
```

## substring(s, offset, length), mid(s, offset, length), substr(s, offset, length) {#substring}

Возвращает подстроку, начиная с байта по индексу offset, длины length байт. Индексация символов — начиная с единицы (как в стандартном SQL). Аргументы offset и length должны быть константами.

## substringUTF8(s, offset, length) {#substringutf8}

Так же, как substring, но для кодовых точек Unicode. Работает при допущении, что строка содержит набор байтов, представляющий текст в кодировке UTF-8. Если допущение не выполнено, то возвращает какой-нибудь результат (не кидает исключение).

## appendTrailingCharIfAbsent(s, c) {#appendtrailingcharifabsent}

Если строка s непустая и не содержит символ c на конце, то добавляет символ c в конец.

## convertCharset(s, from, to) {#convertcharset}

Возвращает сконвертированную из кодировки from в кодировку to строку s.

## base64Encode(s) {#base64encode}

Производит кодирование строки s в base64-представление.

Синоним: `TO_BASE64`.

## base64Decode(s) {#base64decode}

Декодирует base64-представление s в исходную строку. При невозможности декодирования выбрасывает исключение

Синоним: `FROM_BASE64`.

## tryBase64Decode(s) {#trybase64decode}

Функционал аналогичен base64Decode, но при невозможности декодирования возвращает пустую строку.

## endsWith(s, suffix) {#endswith}

Возвращает 1, если строка завершается указанным суффиксом, и 0 в противном случае.

## startsWith(str, prefix) {#startswith}

Возвращает 1, если строка начинается указанным префиксом, в противном случае 0.

``` sql
SELECT startsWith('Spider-Man', 'Spi');
```

**Возвращаемые значения**

-   1, если строка начинается указанным префиксом.
-   0, если строка не начинается указанным префиксом.

**Пример**

Запрос:

``` sql
SELECT startsWith('Hello, world!', 'He');
```

Результат:

``` text
┌─startsWith('Hello, world!', 'He')─┐
│                                 1 │
└───────────────────────────────────┘
```

## trim {#trim}

Удаляет все указанные символы с начала или окончания строки.
По умолчанию удаляет все последовательные вхождения обычных пробелов (32 символ ASCII) с обоих концов строки.

**Синтаксис**

``` sql
trim([[LEADING|TRAILING|BOTH] trim_character FROM] input_string)
```

**Аргументы**

-   `trim_character` — один или несколько символов, подлежащие удалению. [String](../../sql-reference/functions/string-functions.md).
-   `input_string` — строка для обрезки. [String](../../sql-reference/functions/string-functions.md).

**Возвращаемое значение**

Исходную строку после обрезки с левого и (или) правого концов строки.

Тип: `String`.

**Пример**

Запрос:

``` sql
SELECT trim(BOTH ' ()' FROM '(   Hello, world!   )');
```

Результат:

``` text
┌─trim(BOTH ' ()' FROM '(   Hello, world!   )')─┐
│ Hello, world!                                 │
└───────────────────────────────────────────────┘
```

## trimLeft {#trimleft}

Удаляет все последовательные вхождения обычных пробелов (32 символ ASCII) с левого конца строки. Не удаляет другие виды пробелов (табуляция, пробел без разрыва и т. д.).

**Синтаксис**

``` sql
trimLeft(input_string)
```

Алиас: `ltrim(input_string)`.

**Аргументы**

-   `input_string` — строка для обрезки. [String](../../sql-reference/functions/string-functions.md).

**Возвращаемое значение**

Исходную строку без общих пробельных символов слева.

Тип: `String`.

**Пример**

Запрос:

``` sql
SELECT trimLeft('     Hello, world!     ');
```

Результат:

``` text
┌─trimLeft('     Hello, world!     ')─┐
│ Hello, world!                       │
└─────────────────────────────────────┘
```

## trimRight {#trimright}

Удаляет все последовательные вхождения обычных пробелов (32 символ ASCII) с правого конца строки. Не удаляет другие виды пробелов (табуляция, пробел без разрыва и т. д.).

**Синтаксис**

``` sql
trimRight(input_string)
```

Алиас: `rtrim(input_string)`.

**Аргументы**

-   `input_string` — строка для обрезки. [String](../../sql-reference/functions/string-functions.md).

**Возвращаемое значение**

Исходную строку без общих пробельных символов справа.

Тип: `String`.

**Пример**

Запрос:

``` sql
SELECT trimRight('     Hello, world!     ');
```

Результат:

``` text
┌─trimRight('     Hello, world!     ')─┐
│      Hello, world!                   │
└──────────────────────────────────────┘
```

## trimBoth {#trimboth}

Удаляет все последовательные вхождения обычных пробелов (32 символ ASCII) с обоих концов строки. Не удаляет другие виды пробелов (табуляция, пробел без разрыва и т. д.).

**Синтаксис**

``` sql
trimBoth(input_string)
```

Алиас: `trim(input_string)`.

**Аргументы**

-   `input_string` — строка для обрезки. [String](../../sql-reference/functions/string-functions.md).

**Возвращаемое значение**

Исходную строку без общих пробельных символов с обоих концов строки.

Тип: `String`.

**Пример**

Запрос:

``` sql
SELECT trimBoth('     Hello, world!     ');
```

Результат:

``` text
┌─trimBoth('     Hello, world!     ')─┐
│ Hello, world!                       │
└─────────────────────────────────────┘
```

## CRC32(s) {#crc32}

Возвращает чексумму CRC32 данной строки, используется CRC-32-IEEE 802.3 многочлен и начальным значением `0xffffffff` (т.к. используется реализация из zlib).

Тип результата — UInt32.

## CRC32IEEE(s) {#crc32ieee}

Возвращает чексумму CRC32 данной строки, используется CRC-32-IEEE 802.3 многочлен.

Тип результата — UInt32.

## CRC64(s) {#crc64}

Возвращает чексумму CRC64 данной строки, используется CRC-64-ECMA многочлен.

Тип результата — UInt64.

## normalizeQuery {#normalized-query}

Заменяет литералы, последовательности литералов и сложные псевдонимы заполнителями.

**Синтаксис**

``` sql
normalizeQuery(x)
```

**Аргументы**

-   `x` — последовательность символов. [String](../../sql-reference/data-types/string.md).

**Возвращаемое значение**

-   Последовательность символов с заполнителями.

Тип: [String](../../sql-reference/data-types/string.md).

**Пример**

Запрос:

``` sql
SELECT normalizeQuery('[1, 2, 3, x]') AS query;
```

Результат:

``` text
┌─query────┐
│ [?.., x] │
└──────────┘
```

## normalizedQueryHash {#normalized-query-hash}

Возвращает идентичные 64-битные хэш - суммы без значений литералов для аналогичных запросов. Это помогает анализировать журнал запросов.

**Синтаксис**

``` sql
normalizedQueryHash(x)
```

**Аргументы**

-   `x` — последовательность символов. [String](../../sql-reference/data-types/string.md).

**Возвращаемое значение**

-   Хэш-сумма.

Тип: [UInt64](../../sql-reference/data-types/int-uint.md#uint-ranges).

**Пример**

Запрос:

``` sql
SELECT normalizedQueryHash('SELECT 1 AS `xyz`') != normalizedQueryHash('SELECT 1 AS `abc`') AS res;
```

Результат:

``` text
┌─res─┐
│   1 │
└─────┘
```

## normalizeUTF8NFC {#normalizeutf8nfc}

Преобразует строку в нормализованную форму [NFC](https://ru.wikipedia.org/wiki/Юникод#Алгоритмы_нормализации), предполагая, что строка содержит набор байтов, составляющих текст в кодировке UTF-8.

**Синтаксис**

``` sql
normalizeUTF8NFC(words)
```

**Аргументы**

-   `words` — входная строка, которая содержит набор байтов, составляющих текст в кодировке UTF-8. [String](../../sql-reference/data-types/string.md).

**Возвращаемое значение**

-   Строка, преобразованная в нормализированную форму NFC.

Тип: [String](../../sql-reference/data-types/string.md).

**Пример**

Запрос:

``` sql
SELECT length('â'), normalizeUTF8NFC('â') AS nfc, length(nfc) AS nfc_len;
```

Результат:

``` text
┌─length('â')─┬─nfc─┬─nfc_len─┐
│           2 │ â   │       2 │
└─────────────┴─────┴─────────┘
```

## normalizeUTF8NFD {#normalizeutf8nfd}

Преобразует строку в нормализованную форму [NFD](https://ru.wikipedia.org/wiki/Юникод#Алгоритмы_нормализации), предполагая, что строка содержит набор байтов, составляющих текст в кодировке UTF-8.

**Синтаксис**

``` sql
normalizeUTF8NFD(words)
```

**Аргументы**

-   `words` — входная строка, которая содержит набор байтов, составляющих текст в кодировке UTF-8. [String](../../sql-reference/data-types/string.md).

**Возвращаемое значение**

-   Строка, преобразованная в нормализированную форму NFD.

Тип: [String](../../sql-reference/data-types/string.md).

**Пример**

Запрос:

``` sql
SELECT length('â'), normalizeUTF8NFD('â') AS nfd, length(nfd) AS nfd_len;
```

Результат:

``` text
┌─length('â')─┬─nfd─┬─nfd_len─┐
│           2 │ â   │       3 │
└─────────────┴─────┴─────────┘
```

## normalizeUTF8NFKC {#normalizeutf8nfkc}

Преобразует строку в нормализованную форму [NFKC](https://ru.wikipedia.org/wiki/Юникод#Алгоритмы_нормализации), предполагая, что строка содержит набор байтов, составляющих текст в кодировке UTF-8.

**Синтаксис**

``` sql
normalizeUTF8NFKC(words)
```

**Аргументы**

-   `words` — входная строка, которая содержит набор байтов, составляющих текст в кодировке UTF-8. [String](../../sql-reference/data-types/string.md).

**Возвращаемое значение**

-   Строка, преобразованная в нормализированную форму NFKC.

Тип: [String](../../sql-reference/data-types/string.md).

**Пример**

Запрос:

``` sql
SELECT length('â'), normalizeUTF8NFKC('â') AS nfkc, length(nfkc) AS nfkc_len;
```

Результат:

``` text
┌─length('â')─┬─nfkc─┬─nfkc_len─┐
│           2 │ â    │        2 │
└─────────────┴──────┴──────────┘
```

## normalizeUTF8NFKD {#normalizeutf8nfkd}

Преобразует строку в нормализованную форму [NFKD](https://ru.wikipedia.org/wiki/Юникод#Алгоритмы_нормализации), предполагая, что строка содержит набор байтов, составляющих текст в кодировке UTF-8.

**Синтаксис**

``` sql
normalizeUTF8NFKD(words)
```

**Аргументы**

-   `words` — входная строка, которая содержит набор байтов, составляющих текст в кодировке UTF-8. [String](../../sql-reference/data-types/string.md).

**Возвращаемое значение**

-   Строка, преобразованная в нормализированную форму NFKD.

Тип: [String](../../sql-reference/data-types/string.md).

**Пример**

Запрос:

``` sql
SELECT length('â'), normalizeUTF8NFKD('â') AS nfkd, length(nfkd) AS nfkd_len;
```

Результат:

``` text
┌─length('â')─┬─nfkd─┬─nfkd_len─┐
│           2 │ â    │        3 │
└─────────────┴──────┴──────────┘
```

## encodeXMLComponent {#encode-xml-component}

Экранирует символы для размещения строки в текстовом узле или атрибуте XML.

Экранируются символы, которые в формате XML являются зарезервированными (служебными): `<`, `&`, `>`, `"`, `'`.

**Синтаксис**

``` sql
encodeXMLComponent(x)
```

**Аргументы**

-   `x` — последовательность символов. [String](../../sql-reference/data-types/string.md).

**Возвращаемое значение**

-   Строка, в которой зарезервированные символы экранированы.

Тип: [String](../../sql-reference/data-types/string.md).

**Пример**

Запрос:

``` sql
SELECT encodeXMLComponent('Hello, "world"!');
SELECT encodeXMLComponent('<123>');
SELECT encodeXMLComponent('&clickhouse');
SELECT encodeXMLComponent('\'foo\'');
```

Результат:

``` text
Hello, &quot;world&quot;!
&lt;123&gt;
&amp;clickhouse
&apos;foo&apos;
```

## decodeXMLComponent {#decode-xml-component}

Заменяет символами предопределенные мнемоники XML: `&quot;` `&amp;` `&apos;` `&gt;` `&lt;`
Также эта функция заменяет числовые ссылки соответствующими символами юникод. Поддерживаются десятичная (например, `&#10003;`) и шестнадцатеричная (`&#x2713;`) формы.

**Синтаксис**

``` sql
decodeXMLComponent(x)
```

**Аргументы**

-   `x` — последовательность символов. [String](../../sql-reference/data-types/string.md).

**Возвращаемое значение**

-   Строка с произведенными заменами.

Тип: [String](../../sql-reference/data-types/string.md).

**Пример**

Запрос:

``` sql
SELECT decodeXMLComponent('&apos;foo&apos;');
SELECT decodeXMLComponent('&lt; &#x3A3; &gt;');
```

Результат:

``` text
'foo'
< Σ >
```

**Смотрите также**

-   [Мнемоники в HTML](https://ru.wikipedia.org/wiki/%D0%9C%D0%BD%D0%B5%D0%BC%D0%BE%D0%BD%D0%B8%D0%BA%D0%B8_%D0%B2_HTML)



## extractTextFromHTML {#extracttextfromhtml}

Функция для извлечения текста из HTML или XHTML.
Она не соответствует всем HTML, XML или XHTML стандартам на 100%, но ее реализация достаточно точная и быстрая. Правила обработки следующие:

1. Комментарии удаляются. Пример: `<!-- test -->`. Комментарий должен оканчиваться символами `-->`. Вложенные комментарии недопустимы.
Примечание: конструкции наподобие `<!-->` и `<!--->` не являются допустимыми комментариями в HTML, но они будут удалены согласно другим правилам.
2. Содержимое CDATA вставляется дословно. Примечание: формат CDATA специфичен для XML/XHTML. Но он обрабатывается всегда по принципу "наилучшего возможного результата".
3. Элементы `script` и `style` удаляются вместе со всем содержимым. Примечание: предполагается, что закрывающий тег не может появиться внутри содержимого. Например, в JS строковый литерал должен быть экранирован как `"<\/script>"`.
Примечание: комментарии и CDATA возможны внутри `script` или `style` - тогда закрывающие теги не ищутся внутри CDATA. Пример: `<script><![CDATA[</script>]]></script>`. Но они ищутся внутри комментариев. Иногда возникают сложные случаи: `<script>var x = "<!--"; </script> var y = "-->"; alert(x + y);</script>`
Примечание: `script` и `style` могут быть названиями пространств имен XML - тогда они не обрабатываются как обычные элементы `script` или `style`. Пример: `<script:a>Hello</script:a>`.
Примечание: пробелы возможны после имени закрывающего тега: `</script >`, но не перед ним: `< / script>`.
4. Другие теги или элементы, подобные тегам, удаляются, а их внутреннее содержимое остается. Пример: `<a>.</a>`
Примечание: ожидается, что такой HTML является недопустимым: `<a test=">"></a>`
Примечание: функция также удаляет подобные тегам элементы: `<>`, `<!>`, и т. д.
Примечание: если встречается тег без завершающего символа `>`, то удаляется этот тег и весь следующий за ним текст: `<hello `
5. Мнемоники HTML и XML не декодируются. Они должны быть обработаны отдельной функцией.
6. Пробелы в тексте удаляются и добавляются по следующим правилам:
- Пробелы в начале и в конце извлеченного текста удаляются.
- Несколько пробелов подряд заменяются одним пробелом.
- Если текст разделен другими удаляемыми элементами и в этом месте нет пробела, он добавляется.
- Это может привести к появлению неестественного написания, например: `Hello<b>world</b>`, `Hello<!-- -->world` — в HTML нет пробелов, но функция вставляет их. Также следует учитывать такие варианты написания: `Hello<p>world</p>`, `Hello<br>world`. Подобные результаты выполнения функции могут использоваться для анализа данных, например, для преобразования HTML-текста в набор используемых слов.
7. Также обратите внимание, что правильная обработка пробелов требует поддержки `<pre></pre>` и свойств CSS `display` и `white-space`.

**Синтаксис**

``` sql
extractTextFromHTML(x)
```

**Аргументы**

-   `x` — текст для обработки. [String](../../sql-reference/data-types/string.md).

**Возвращаемое значение**

-   Извлеченный текст.

Тип: [String](../../sql-reference/data-types/string.md).

**Пример**

Первый пример содержит несколько тегов и комментарий. На этом примере также видно, как обрабатываются пробелы.
Второй пример показывает обработку `CDATA` и тега `script`.
В третьем примере текст выделяется из полного HTML ответа, полученного с помощью функции [url](../../sql-reference/table-functions/url.md).

Запрос:

``` sql
SELECT extractTextFromHTML(' <p> A text <i>with</i><b>tags</b>. <!-- comments --> </p> ');
SELECT extractTextFromHTML('<![CDATA[The content within <b>CDATA</b>]]> <script>alert("Script");</script>');
SELECT extractTextFromHTML(html) FROM url('http://www.donothingfor2minutes.com/', RawBLOB, 'html String');
```

Результат:

``` text
A text with tags .
The content within <b>CDATA</b>
Do Nothing for 2 Minutes 2:00 &nbsp;
```
