---
toc_priority: 45
toc_title: "Функции округления"
---

# Функции округления {#funktsii-okrugleniia}

## floor(x\[, N\]) {#floorx-n}

Возвращает наибольшее круглое число, которое меньше или равно, чем x.
Круглым называется число, кратное 1 / 10N или ближайшее к нему число соответствующего типа данных, если 1 / 10N не представимо точно.
N - целочисленная константа, не обязательный параметр. По умолчанию - ноль, что означает - округлять до целого числа.
N может быть отрицательным.

Примеры: `floor(123.45, 1) = 123.4, floor(123.45, -1) = 120.`

`x` - любой числовой тип. Результат - число того же типа.
Для целочисленных аргументов имеет смысл округление с отрицательным значением N (для неотрицательных N, функция ничего не делает).
В случае переполнения при округлении (например, floor(-128, -1)), возвращается implementation specific результат.

## ceil(x\[, N\]) {#ceilx-n}

Возвращает наименьшее круглое число, которое больше или равно, чем x.
В остальном, аналогично функции floor, см. выше.

## round(x\[, N\]) {#rounding_functions-round}

Округляет значение до указанного десятичного разряда.

Функция возвращает ближайшее значение указанного порядка. В случае, когда заданное число равноудалено от чисел необходимого порядка, для типов с плавающей точкой (Float32/64) функция возвращает то из них, которое имеет ближайшую чётную цифру (банковское округление), для типов с фиксированной точкой (Decimal) функция использует округление в бо́льшую по модулю сторону (математическое округление).

``` sql
round(expression [, decimal_places])
```

**Аргументы**

-   `expression` — число для округления. Может быть любым [выражением](../syntax.md#syntax-expressions), возвращающим числовой [тип данных](../../sql-reference/functions/rounding-functions.md#data_types).
-   `decimal-places` — целое значение.
    -   Если `decimal-places > 0`, то функция округляет значение справа от запятой.
    -   Если `decimal-places < 0` то функция округляет значение слева от запятой.
    -   Если `decimal-places = 0`, то функция округляет значение до целого. В этом случае аргумент можно опустить.

**Возвращаемое значение:**

Округлённое значение того же типа, что и входящее.

### Примеры {#primery}

**Пример использования с Float**

``` sql
SELECT number / 2 AS x, round(x) FROM system.numbers LIMIT 3
```

``` text
┌───x─┬─round(divide(number, 2))─┐
│   0 │                        0 │
│ 0.5 │                        0 │
│   1 │                        1 │
└─────┴──────────────────────────┘
```

**Пример использования с Decimal**


``` sql
SELECT cast(number / 2 AS  Decimal(10,4)) AS x, round(x) FROM system.numbers LIMIT 3
```

``` text
┌──────x─┬─round(CAST(divide(number, 2), 'Decimal(10, 4)'))─┐
│ 0.0000 │                                           0.0000 │
│ 0.5000 │                                           1.0000 │
│ 1.0000 │                                           1.0000 │
└────────┴──────────────────────────────────────────────────┘
```

**Примеры округления**

Округление до ближайшего числа.

``` text
round(3.2, 0) = 3
round(4.1267, 2) = 4.13
round(22,-1) = 20
round(467,-2) = 500
round(-467,-2) = -500
```

Банковское округление.

``` text
round(3.5) = 4
round(4.5) = 4
round(3.55, 1) = 3.6
round(3.65, 1) = 3.6
```

**Смотрите также**

-   [roundBankers](#roundbankers)

## roundBankers {#roundbankers}

Округляет число до указанного десятичного разряда.

-   Если округляемое число равноудалено от соседних чисел, то используется банковское округление.

        Банковское округление (англ. banker's rounding) — метод округления дробных чисел. Если округляемое число равноудалено от соседних чисел, то оно округляется до ближайшей чётной цифры заданного десятичного разряда. К примеру, 3,5 округляется до 4, а 2,5 до 2.

        Этот метод округления, используемый по умолчанию для чисел с плавающей запятой, определён в стандарте [IEEE 754](https://en.wikipedia.org/wiki/IEEE_754#Roundings_to_nearest). Функция [round](#rounding_functions-round) также округляет числа с плавающей запятой по этому методу. Функция `roundBankers` округляет не только числа с плавающей запятой, но и целые числа методом банковского округления, например, `roundBankers(45, -1) = 40`.

-   В других случаях функция округляет к ближайшему целому.

Банковское округление позволяет уменьшить влияние округления чисел на результат суммирования или вычитания этих чисел.

Пример суммирования чисел 1.5, 2.5, 3.5 и 4.5 с различным округлением:

-   Без округления: 1.5 + 2.5 + 3.5 + 4.5 = 12.
-   Банковское округление: 2 + 2 + 4 + 4 = 12.
-   Округление до ближайшего целого: 2 + 3 + 4 + 5 = 14.

**Синтаксис**

``` sql
roundBankers(expression [, decimal_places])
```

**Аргументы**

-   `expression` — число для округления. Может быть любым [выражением](../syntax.md#syntax-expressions), возвращающим числовой [тип данных](../../sql-reference/functions/rounding-functions.md#data_types).
-   `decimal-places` — десятичный разряд. Целое число.
    -   `decimal-places > 0` — функция округляет значение выражения до ближайшего чётного числа на соответствующей позиции справа от запятой. Например, `roundBankers(3.55, 1) = 3.6`.
    -   `decimal-places < 0` — функция округляет значение выражения до ближайшего чётного числа на соответствующей позиции слева от запятой. Например, `roundBankers(24.55, -1) = 20`.
    -   `decimal-places = 0` — функция округляет значение до целого. В этом случае аргумент можно не передавать. Например, `roundBankers(2.5) = 2`.

**Возвращаемое значение**

Округлённое значение по методу банковского округления.

**Пример использования**

Запрос:

``` sql
 SELECT number / 2 AS x, roundBankers(x, 0) AS b fROM system.numbers limit 10
```

Результат:

``` text
┌───x─┬─b─┐
│   0 │ 0 │
│ 0.5 │ 0 │
│   1 │ 1 │
│ 1.5 │ 2 │
│   2 │ 2 │
│ 2.5 │ 2 │
│   3 │ 3 │
│ 3.5 │ 4 │
│   4 │ 4 │
│ 4.5 │ 4 │
└─────┴───┘
```

**Примеры банковского округления**

``` text
roundBankers(0.4) = 0
roundBankers(-3.5) = -4
roundBankers(4.5) = 4
roundBankers(3.55, 1) = 3.6
roundBankers(3.65, 1) = 3.6
roundBankers(10.35, 1) = 10.4
roundBankers(10.755, 2) = 10,76
```

**Смотрите также**

-   [round](#rounding_functions-round)

## roundToExp2(num) {#roundtoexp2num}

Принимает число. Если число меньше единицы - возвращает 0. Иначе округляет число вниз до ближайшей (целой неотрицательной) степени двух.

## roundDuration(num) {#rounddurationnum}

Принимает число. Если число меньше единицы - возвращает 0. Иначе округляет число вниз до чисел из набора: 1, 10, 30, 60, 120, 180, 240, 300, 600, 1200, 1800, 3600, 7200, 18000, 36000. Эта функция специфична для Яндекс.Метрики и предназначена для реализации отчёта по длительности визита.

## roundAge(num) {#roundagenum}

Принимает число. Если число меньше 18 - возвращает 0. Иначе округляет число вниз до чисел из набора: 18, 25, 35, 45, 55. Эта функция специфична для Яндекс.Метрики и предназначена для реализации отчёта по возрасту посетителей.

