--- 
toc_title: "Функции для работы с индексами S2"
---

# Функции для работы с индексами S2 {#s2index}

[S2](https://s2geometry.io/) — это система геокодирования, в которой все географические данные представлены на трехмерной сфере (аналогично глобусу).

В библиотеке S2 точки представлены в виде индекса S2 — определенного числа, которое внутренне кодирует точку на поверхности трехмерной единичной сферы, в отличие от традиционных пар (широта, долгота). Чтобы получить индекс S2 для точки, заданной в формате (широта, долгота), используйте функцию [geoToS2](#geotools2). Также вы можете использовать функцию [s2togeo](#s2togeo) для получения географических координат, соответствующих заданному S2 индексу точки.

## geoToS2 {#geotos2}

Возвращает [S2](#s2index) индекс точки, соответствующий заданным координатам в формате `(долгота, широта)`.

**Синтаксис**

``` sql
geoToS2(lon, lat)
```

**Аргументы**

-   `lon` — долгота. [Float64](../../../sql-reference/data-types/float.md).
-   `lat` — широта. [Float64](../../../sql-reference/data-types/float.md).

**Возвращаемое значение**

-  S2 индекс точки.

Тип: [UInt64](../../../sql-reference/data-types/int-uint.md).

**Пример**

Запрос:

``` sql
SELECT geoToS2(37.79506683, 55.71290588) AS s2Index;
```

Результат:

``` text
┌─────────────s2Index─┐
│ 4704772434919038107 │
└─────────────────────┘
```

## s2ToGeo {#s2togeo}

Возвращает географические координаты `(долгота, широта)`, соответствующие заданному [S2](#s2index) индексу точки.

**Синтаксис**

``` sql
s2ToGeo(s2index)
```

**Аргументы**

-   `s2index` — [S2](#s2index) индекс. [UInt64](../../../sql-reference/data-types/int-uint.md).

**Возвращаемые значения**

-   Кортеж их двух значений: `tuple(lon,lat)`.

Тип: `lon` — [Float64](../../../sql-reference/data-types/float.md). `lat` — [Float64](../../../sql-reference/data-types/float.md).

**Пример**

Запрос:

``` sql
SELECT s2ToGeo(4704772434919038107) AS s2Coodrinates;
```

Результат:

``` text
┌─s2Coodrinates────────────────────────┐
│ (37.79506681471008,55.7129059052841) │
└──────────────────────────────────────┘
```

## s2GetNeighbors {#s2getneighbors}

Возвращает [S2](#s2index) индексы ячеек, которые являются соседними для заданного S2 индекса. Ячейка в системе S2 представляет собой прямоугольник, ограниченный четырьмя сторонами. Соответственно, у каждой ячейки есть 4 соседние ячейки.

**Синтаксис**

``` sql
s2GetNeighbors(s2index)
```

**Аргументы**

-   `s2index` — [S2](#s2index) индекс. [UInt64](../../../sql-reference/data-types/int-uint.md).

**Возвращаемые значения**

-   Массив, содержащий 4 значения — S2 индекса соседних ячеек: `array[s2index1, s2index3, s2index2, s2index4]`.

Тип: [UInt64](../../../sql-reference/data-types/int-uint.md).

**Пример**

Запрос:

``` sql
SELECT s2GetNeighbors(5074766849661468672) AS s2Neighbors;
```

Результат:

``` text
┌─s2Neighbors───────────────────────────────────────────────────────────────────────┐
│ [5074766987100422144,5074766712222515200,5074767536856236032,5074767261978329088] │
└───────────────────────────────────────────────────────────────────────────────────┘
```

## s2CellsIntersect {#s2cellsintersect}

Проверяет, пересекаются ли две заданные ячейки или нет.

**Синтаксис**

``` sql
s2CellsIntersect(s2index1, s2index2)
```

**Аргументы**

-   `siIndex1`, `s2index2` — S2 индексы первой и второй ячейки. [UInt64](../../../sql-reference/data-types/int-uint.md).

**Возвращаемые значения**

-   1 — ячейки пересекаются.
-   0 — ячейки не пересекаются.

Тип: [UInt8](../../../sql-reference/data-types/int-uint.md).

**Пример**

Запрос:

``` sql
SELECT s2CellsIntersect(9926595209846587392, 9926594385212866560) AS intersect;
```

Результат:

``` text
┌─intersect─┐
│         1 │
└───────────┘
```

## s2CapContains {#s2capcontains}

Определяет, содержит ли заданный купол указанную точку. Купол представляет собой часть сферы, которая была отрезана плоскостью. Купол задается точкой на сфере и радиусом в градусах.

**Синтаксис**

``` sql
s2CapContains(center, degrees, point)
```

**Аргументы**

-   `center` — S2 индекс точки, определяющей центр купола. [UInt64](../../../sql-reference/data-types/int-uint.md).
-   `degrees` — радиус купола в градусах. [Float64](../../../sql-reference/data-types/float.md).
-   `point` — S2 индекс проверяемой точки. [UInt64](../../../sql-reference/data-types/int-uint.md).

**Возвращаемые значения**

-   1 — купол содержит точку.
-   0 — купол не содержит точку.

Тип: [UInt8](../../../sql-reference/data-types/int-uint.md).

**Пример**

Запрос:

``` sql
SELECT s2CapContains(1157339245694594829, 1.0, 1157347770437378819) AS capContains;
```

Результат:

``` text
┌─capContains─┐
│           1 │
└─────────────┘
```

## s2CapUnion {#s2capunion}

Определяет наименьший купол, содержащий два заданных купола. Купол представляет собой часть сферы, которая была отрезана плоскостью. Купол задается точкой на сфере и радиусом в градусах.

**Синтаксис**

``` sql
s2CapUnion(center1, radius1, center2, radius2)
```

**Аргументы**

-   `center1`, `center2` — S2 индексы точек, определяющие два центра куполов. [UInt64](../../../sql-reference/data-types/int-uint.md).
-   `radius1`, `radius2` — значения радиусов в градусах, определяющие два радиуса куполов. [Float64](../../../sql-reference/data-types/float.md).

**Возвращаемые значения**

-   `center` — S2 индекс точки, соответствующий центру наименьшего купола, содержащего заданные купола. Тип: [UInt64](../../../sql-reference/data-types/int-uint.md).
-   `radius` — радиус в градусах наименьшего купола, содержащего заданные купола. Тип: [Float64](../../../sql-reference/data-types/float.md).

**Пример**

Запрос:

``` sql
SELECT s2CapUnion(3814912406305146967, 1.0, 1157347770437378819, 1.0) AS capUnion;
```

Результат:

``` text
┌─capUnion───────────────────────────────┐
│ (4534655147792050737,60.2088283994957) │
└────────────────────────────────────────┘
```

## s2RectAdd {#s2rectadd}

Увеличивает размер ограничивающего прямоугольника, чтобы включить в себя точку, заданную S2 индексом. В системе S2 прямоугольник представлен типом S2Region, называемым `S2LatLngRect`, который задает прямоугольник в пространстве широта-долгота.

**Синтаксис**

``` sql
s2RectAdd(s2pointLow, s2pointHigh, s2Point)
```

**Аргументы**

-   `s2PointLow` — S2 индекс нижней точки, которая задает ограничиваюший прямоугольник. [UInt64](../../../sql-reference/data-types/int-uint.md).
-   `s2PointHigh` — S2 индекс верхний точки, которая задает ограничиваюший прямоугольник. [UInt64](../../../sql-reference/data-types/int-uint.md).
-   `s2Point` — S2 индекс целевой точки, которая будет содержаться увеличенным ограничивающим прямоугольником. [UInt64](../../../sql-reference/data-types/int-uint.md).

**Возвращаемые значения**

-   `s2PointLow` — идентификатор нижней S2 ячейки, соответствующий увеличенному прямоугольнику. Тип: [UInt64](../../../sql-reference/data-types/int-uint.md).
-   `s2PointHigh` — идентификатор верхней S2 ячейки, соответствующий увеличенному прямоугольнику. Тип: [UInt64](../../../sql-reference/data-types/float.md).

**Пример**

Запрос:

``` sql
SELECT s2RectAdd(5178914411069187297, 5177056748191934217, 5179056748191934217) AS rectAdd;
```

Результат:

``` text
┌─rectAdd───────────────────────────────────┐
│ (5179062030687166815,5177056748191934217) │
└───────────────────────────────────────────┘
```

## s2RectContains {#s2rectcontains}

Проверяет, содержит ли заданный прямоугольник указанную S2 точку. В системе S2 прямоугольник представлен типом S2Region, называемым `S2LatLngRect`, который задает прямоугольник в пространстве широта-долгота.

**Синтаксис**

``` sql
s2RectContains(s2PointLow, s2PointHi, s2Point)
```

**Аргументы**

-   `s2PointLow` — S2 индекс самой низкой точки, которая задает прямоугольник. [UInt64](../../../sql-reference/data-types/int-uint.md).
-   `s2PointHigh` — S2 индекс самой высокой точки, которая задает прямоугольник. [UInt64](../../../sql-reference/data-types/int-uint.md).
-   `s2Point` — S2 индекс проверяемой точки. [UInt64](../../../sql-reference/data-types/int-uint.md).

**Возвращаемые значения**

-   1 — прямоугольник содержит заданную точку.
-   0 — прямоугольник не содержит заданную точку.

**Пример**

Запрос:

``` sql
SELECT s2RectContains(5179062030687166815, 5177056748191934217, 5177914411069187297) AS rectContains;
```

Результат:

``` text
┌─rectContains─┐
│            0 │
└──────────────┘
```

## s2RectUinion {#s2rectunion}

Возвращает наименьший прямоугольник, содержащий объединение двух заданных прямоугольников. В системе S2 прямоугольник представлен типом S2Region, называемым `S2LatLngRect`, который задает прямоугольник в пространстве широта-долгота.

**Синтаксис**

``` sql
s2RectUnion(s2Rect1PointLow, s2Rect1PointHi, s2Rect2PointLow, s2Rect2PointHi)
```

**Аргументы**

-   `s2Rect1PointLow`, `s2Rect1PointHi` — значения S2 индекса для самой низкой и самой высокой точек, которые задают первый прямоугольник. [UInt64](../../../sql-reference/data-types/int-uint.md).
-   `s2Rect2PointLow`, `s2Rect2PointHi` — значения S2 индекса для самой низкой и самой высокой точек, которые задают второй прямоугольник. [UInt64](../../../sql-reference/data-types/int-uint.md).

**Возвращаемые значения**

-   `s2UnionRect2PointLow` — идентификатор нижней ячейки, соответствующей объединенному прямоугольнику. Тип: [UInt64](../../../sql-reference/data-types/int-uint.md).
-   `s2UnionRect2PointHi` — идентификатор  верхней ячейки, соответствующей объединенному прямоугольнику. Тип: [UInt64](../../../sql-reference/data-types/int-uint.md).

**Пример**

Запрос:

``` sql
SELECT s2RectUnion(5178914411069187297, 5177056748191934217, 5179062030687166815, 5177056748191934217) AS rectUnion;
```

Результат:

``` text
┌─rectUnion─────────────────────────────────┐
│ (5179062030687166815,5177056748191934217) │
└───────────────────────────────────────────┘
```

## s2RectIntersection {#s2rectintersection}

Возвращает наименьший прямоугольник, содержащий пересечение двух заданных прямоугольников. В системе S2 прямоугольник представлен типом S2Region, называемым `S2LatLngRect`, который задает прямоугольник в пространстве широта-долгота.

**Синтаксис**

``` sql
s2RectIntersection(s2Rect1PointLow, s2Rect1PointHi, s2Rect2PointLow, s2Rect2PointHi)
```

**Аргументы**

-   `s2Rect1PointLow`, `s2Rect1PointHi` — значения S2 индекса для самой низкой и самой высокой точек, которые задают первый прямоугольник. [UInt64](../../../sql-reference/data-types/int-uint.md).
-   `s2Rect2PointLow`, `s2Rect2PointHi` — значения S2 индекса для самой низкой и самой высокой точек, которые задают второй прямоугольник. [UInt64](../../../sql-reference/data-types/int-uint.md).

**Возвращаемые значения**

-   `s2UnionRect2PointLow` — идентификатор нижней ячейки, соответствующей результирующему прямоугольнику. Тип: [UInt64](../../../sql-reference/data-types/int-uint.md).
-   `s2UnionRect2PointHi` — идентификатор верхней ячейки, соответствующей результирующему прямоугольнику. Тип: [UInt64](../../../sql-reference/data-types/int-uint.md).

**Пример**

Запрос:

``` sql
SELECT s2RectIntersection(5178914411069187297, 5177056748191934217, 5179062030687166815, 5177056748191934217) AS rectIntersection;
```

Результат:

``` text
┌─rectIntersection──────────────────────────┐
│ (5178914411069187297,5177056748191934217) │
└───────────────────────────────────────────┘
```
