---
toc_priority: 43
toc_title: "Условные функции"
---

# Условные функции {#uslovnye-funktsii}

## if {#if}

Условное выражение. В отличие от большинства систем, ClickHouse всегда считает оба выражения `then` и `else`.

**Синтаксис**

``` sql
if(cond, then, else)
```

Если условие `cond` не равно нулю, то возвращается результат выражения `then`. Если условие `cond` равно нулю или является NULL, то результат выражения `then` пропускается и возвращается результат выражения `else`.

Чтобы вычислять функцию `if` по короткой схеме, используйте настройку [short_circuit_function_evaluation](../../operations/settings/settings.md#short-circuit-function-evaluation). Если настройка включена, то выражение `then` вычисляется только для строк, где условие `cond` верно, а выражение `else` – для строк, где условие `cond` неверно. Например, при выполнении запроса `SELECT if(number = 0, 0, intDiv(42, number)) FROM numbers(10)` не будет сгенерировано исключение из-за деления на ноль, так как `intDiv(42, number)` будет вычислено только для чисел, которые не удовлетворяют условию `number = 0`.

**Аргументы**

-   `cond` – проверяемое условие. Может быть [UInt8](../../sql-reference/functions/conditional-functions.md) или `NULL`.
-   `then` – возвращается результат выражения, если условие `cond` истинно.
-   `else` – возвращается результат выражения, если условие `cond` ложно.

**Возвращаемые значения**

Функция выполняет выражения `then` или `else` и возвращает его результат, в зависимости от того, было ли условие `cond` равно нулю или нет.

**Пример**

Запрос:

``` sql
SELECT if(1, plus(2, 2), plus(2, 6));
```

Результат:

``` text
┌─plus(2, 2)─┐
│          4 │
└────────────┘
```

Запрос:

``` sql
SELECT if(0, plus(2, 2), plus(2, 6));
```

Результат:

``` text
┌─plus(2, 6)─┐
│          8 │
└────────────┘
```

## Тернарный оператор {#ternary-operator}

Работает так же, как функция `if`.

Синтаксис: `cond ? then : else`

Возвращает `then`, если `cond` верно (больше нуля), в остальных случаях возвращает `else`.

-   `cond` должно быть типа `UInt8`, `then` и `else` должны относиться к наименьшему общему типу.

-   `then` и `else` могут быть `NULL`.

**Смотрите также**

-   [ifNotFinite](other-functions.md#ifnotfinite).

## multiIf {#multiif}

Позволяет более компактно записать оператор [CASE](../operators/index.md#operator_case) в запросе.

**Синтаксис**

``` sql
multiIf(cond_1, then_1, cond_2, then_2, ..., else)
```

Чтобы вычислять функцию `multiIf` по короткой схеме, используйте настройку [short_circuit_function_evaluation](../../operations/settings/settings.md#short-circuit-function-evaluation). Если настройка включена, то выражение `then_i` вычисляется только для строк, где условие `((NOT cond_1) AND (NOT cond_2) AND ... AND (NOT cond_{i-1}) AND cond_i)` верно, `cond_i` вычисляется только для строк, где условие `((NOT cond_1) AND (NOT cond_2) AND ... AND (NOT cond_{i-1}))` верно. Например, при выполнении запроса `SELECT multiIf(number = 2, intDiv(1, number), number = 5) FROM numbers(10)` не будет сгенерировано исключение из-за деления на ноль.

**Аргументы**

-   `cond_N` — условие, при выполнении которого функция вернёт `then_N`.
-   `then_N` — результат функции при выполнении.
-   `else` — результат функции, если ни одно из условий не выполнено.

Функция принимает `2N+1` параметров.

**Возвращаемые значения**

Функция возвращает одно из значений `then_N` или `else`, в зависимости от условий `cond_N`.

**Пример**

Рассмотрим таблицу

``` text
┌─x─┬────y─┐
│ 1 │ ᴺᵁᴸᴸ │
│ 2 │    3 │
└───┴──────┘
```

Выполним запрос `SELECT multiIf(isNull(y), x, y < 3, y, NULL) FROM t_null`. Результат:

``` text
┌─multiIf(isNull(y), x, less(y, 3), y, NULL)─┐
│                                          1 │
│                                       ᴺᵁᴸᴸ │
└────────────────────────────────────────────┘
```
