---
toc_priority: 41
toc_title: Float32, Float64
---

# Float32, Float64 {#float32-float64}

[Числа с плавающей запятой](https://en.wikipedia.org/wiki/IEEE_754).

Типы эквивалентны типам языка С:

-   `Float32` — `float`.
-   `Float64` — `double`.

Синонимы:

-   `Float32` — `FLOAT`.
-   `Float64` — `DOUBLE`.

При создании таблиц для чисел с плавающей запятой можно указывать числовые параметры (например, `FLOAT(12)`, `FLOAT(15, 22)`, `DOUBLE(12)`, `DOUBLE(4, 18)`), но ClickHouse их проигнорирует.

Рекомендуется хранить данные в целочисленном виде всегда, когда это возможно. Например, переводите в целочисленные значения числа с фиксированной точностью, такие как денежные суммы или времена загрузки страниц в миллисекундах.

## Особенности использования чисел с плавающей запятой {#osobennosti-ispolzovaniia-chisel-s-plavaiushchei-zapiatoi}

-   При вычислениях с числами с плавающей запятой возможна ошибка округления.

<!-- -->

``` sql
SELECT 1 - 0.9
```

``` text
┌───────minus(1, 0.9)─┐
│ 0.09999999999999998 │
└─────────────────────┘
```

-   Результат вычисления зависит от метода вычисления (типа процессора и архитектуры вычислительной системы).
-   При вычислениях с плавающей запятой возможно появление таких категорий числа как бесконечность (`Inf`) и «не число» (`NaN`). Это необходимо учитывать при обработке результатов вычислений.
-   При чтении чисел с плавающей запятой из строк, в качестве результата может быть получено не обязательно ближайшее машинно-представимое число.

## NaN и Inf {#data_type-float-nan-inf}

В отличие от стандартного SQL, ClickHouse поддерживает следующие категории чисел с плавающей запятой:

-   `Inf` — бесконечность.

<!-- -->

``` sql
SELECT 0.5 / 0
```

``` text
┌─divide(0.5, 0)─┐
│            inf │
└────────────────┘
```

-   `-Inf` — отрицательная бесконечность.

<!-- -->

``` sql
SELECT -0.5 / 0
```

``` text
┌─divide(-0.5, 0)─┐
│            -inf │
└─────────────────┘
```

-   `NaN` — не число.

<!-- -->

``` sql
SELECT 0 / 0
```

``` text
┌─divide(0, 0)─┐
│          nan │
└──────────────┘
```

Смотрите правила сортировки `NaN` в разделе [Секция ORDER BY ](../../sql-reference/statements/select/order-by.md).

