---
toc_folder_title: "Домены"
toc_title_title: "Обзор"
toc_priority: 56
---


# Домены {#domeny}

Домены — это типы данных специального назначения, которые добавляют некоторые дополнительные функции поверх существующего базового типа. На данный момент ClickHouse не поддерживает пользовательские домены.

Вы можете использовать домены везде, где можно использовать соответствующий базовый тип:

-   Создание столбца с доменным типом данных.
-   Чтение/запись значений из/в столбец с доменным типом данных.
-   Используйте его как индекс, если базовый тип можно использовать в качестве индекса.
-   Вызов функций со значениями столбца, имеющего доменный тип данных.
-   и так далее.

### Дополнительные возможности доменов {#dopolnitelnye-vozmozhnosti-domenov}

-   Явное название типа данных столбца в запросах `SHOW CREATE TABLE` и `DESCRIBE TABLE`
-   Ввод данных в удобном человеку формате `INSERT INTO domain_table(domain_column) VALUES(...)`
-   Вывод данных в удобном человеку формате `SELECT domain_column FROM domain_table`
-   Загрузка данных из внешнего источника в удобном для человека формате: `INSERT INTO domain_table FORMAT CSV ...`

### Ограничения {#ogranicheniia}

-   Невозможно преобразовать базовый тип данных в доменный для индексного столбца с помощью `ALTER TABLE`.
-   Невозможно неявно преобразовывать строковые значение в значения с доменным типом данных при вставке данных из другого столбца или таблицы.
-   Домен не добавляет ограничения на хранимые значения.

