---
toc_priority: 205
---

# quantileTimingWeighted {#quantiletimingweighted}

С детерминированной точностью вычисляет [квантиль](https://ru.wikipedia.org/wiki/Квантиль) числовой последовательности, учитывая вес каждого элемента.

Результат детерминирован (не зависит от порядка обработки запроса). Функция оптимизирована для работы с последовательностями, описывающими такие распределения, как время загрузки веб-страниц или время отклика бэкенда.

Внутренние состояния функций `quantile*` не объединяются, если они используются в одном запросе. Если вам необходимо вычислить квантили нескольких уровней, используйте функцию [quantiles](#quantiles), это повысит эффективность запроса.

**Синтаксис**

``` sql
quantileTimingWeighted(level)(expr, weight)
```

Алиас: `medianTimingWeighted`.

**Аргументы**

-   `level` — уровень квантили. Опционально. Константное значение с плавающей запятой от 0 до 1. Мы рекомендуем использовать значение `level` из диапазона `[0.01, 0.99]`. Значение по умолчанию: 0.5. При `level=0.5` функция вычисляет [медиану](https://ru.wikipedia.org/wiki/Медиана_(статистика)).

-   `expr` — [выражение](../../syntax.md#syntax-expressions), зависящее от значений столбцов, возвращающее данные типа [Float\*](../../../sql-reference/data-types/float.md).

        - Если в функцию передать отрицательные значения, то её поведение не определено.
        - Если значение больше, чем 30 000 (например, время загрузки страницы превышает 30 секунд), то оно приравнивается к 30 000.

-   `weight` — столбец с весам элементов последовательности. Вес — это количество повторений элемента в последовательности.

**Точность**

Вычисления точны при соблюдении следующих условий:

-   Размер выборки не превышает 5670 элементов.
-   Размер выборки превышает 5670 элементов, но значение каждого элемента не больше 1024.

В противном случае, результат вычисления округляется до ближайшего множителя числа 16.

!!! note "Примечание"
    Для указанного типа последовательностей функция производительнее и точнее, чем [quantile](#quantile).

**Возвращаемое значение**

-   Квантиль заданного уровня.

Тип: `Float32`.

!!! note "Примечания"
    Если в функцию `quantileTimingIf` не передать значений, то вернётся [NaN](../../../sql-reference/data-types/float.md#data_type-float-nan-inf). Это необходимо для отделения подобных случаев от случаев, когда результат 0. Подробности про сортировку `NaN` cмотрите в разделе [Секция ORDER BY](../../../sql-reference/statements/select/order-by.md#select-order-by).

**Пример**

Входная таблица:

``` text
┌─response_time─┬─weight─┐
│            68 │      1 │
│           104 │      2 │
│           112 │      3 │
│           126 │      2 │
│           138 │      1 │
│           162 │      1 │
└───────────────┴────────┘
```

Запрос:

``` sql
SELECT quantileTimingWeighted(response_time, weight) FROM t
```

Результат:

``` text
┌─quantileTimingWeighted(response_time, weight)─┐
│                                           112 │
└───────────────────────────────────────────────┘
```

**Смотрите также**

-   [median](../../../sql-reference/aggregate-functions/reference/median.md#median)
-   [quantiles](../../../sql-reference/aggregate-functions/reference/quantiles.md#quantiles)

