---
toc_priority: 142
---

# minMap {#agg_functions-minmap}

Синтаксис: `minMap(key, value)` or `minMap(Tuple(key, value))`

Вычисляет минимальное значение массива `value` в соответствии с ключами, указанными в массиве `key`.

Передача кортежа ключей и массивов значений идентична передаче двух массивов ключей и значений.

Количество элементов в параметрах `key` и `value` должно быть одинаковым для каждой суммируемой строки.

Возвращает кортеж из двух массивов: ключи в отсортированном порядке и значения, рассчитанные для соответствующих ключей.

Пример:

``` sql
SELECT minMap(a, b)
FROM values('a Array(Int32), b Array(Int64)', ([1, 2], [2, 2]), ([2, 3], [1, 1]))
```

``` text
┌─minMap(a, b)──────┐
│ ([1,2,3],[2,1,1]) │
└───────────────────┘
```
