---
toc_priority: 143
---

# maxMap {#agg_functions-maxmap}

Синтаксис: `maxMap(key, value)` or `maxMap(Tuple(key, value))`

Вычисляет максимальные значения массива `value`, соответствующие ключам, указанным в массиве `key`.

Передача кортежа ключей и массивов значений идентична передаче двух массивов ключей и значений.

Количество элементов в параметрах `key` и `value` должно быть одинаковым для каждой суммируемой строки.

Возвращает кортеж из двух массивов: ключи и значения, рассчитанные для соответствующих ключей.

Пример:

``` sql
SELECT maxMap(a, b)
FROM values('a Array(Int32), b Array(Int64)', ([1, 2], [2, 2]), ([2, 3], [1, 1]))
```

``` text
┌─maxMap(a, b)──────┐
│ ([1,2,3],[2,2,1]) │
└───────────────────┘
```
