---
toc_priority: 61
toc_title: clickhouse-benchmark
---

# clickhouse-benchmark {#clickhouse-benchmark}

Устанавливает соединение с сервером ClickHouse и запускает циклическое выполнение указанных запросов.

**Синтаксис**

``` bash
$ clickhouse-benchmark --query ["single query"] [keys]
```

или

``` bash
$ echo "single query" | clickhouse-benchmark [keys]
```

или

``` bash
$ clickhouse-benchmark [keys] <<< "single query"
```

Если нужно выполнить набор запросов, создайте текстовый файл и расположите каждый запрос на отдельной строке в файле. Например:

``` sql
SELECT * FROM system.numbers LIMIT 10000000;
SELECT 1;
```

После этого передайте этот файл в стандартный ввод `clickhouse-benchmark`:

``` bash
clickhouse-benchmark [keys] < queries_file;
```

## Ключи {#clickhouse-benchmark-keys}

-   `--query=QUERY` — исполняемый запрос. Если параметр не передан, `clickhouse-benchmark` будет считывать запросы из стандартного ввода.
-   `-c N`, `--concurrency=N` — количество запросов, которые `clickhouse-benchmark` отправляет одновременно. Значение по умолчанию: 1.
-   `-d N`, `--delay=N` — интервал в секундах между промежуточными отчетами (чтобы отключить отчеты, установите 0). Значение по умолчанию: 1.
-   `-h HOST`, `--host=HOST` — хост сервера. Значение по умолчанию: `localhost`. Для [режима сравнения](#clickhouse-benchmark-comparison-mode) можно использовать несколько `-h` ключей.
-   `-p N`, `--port=N` — порт сервера. Значение по умолчанию: 9000. Для [режима сравнения](#clickhouse-benchmark-comparison-mode) можно использовать несколько `-p` ключей.
-   `-i N`, `--iterations=N` — общее число запросов. Значение по умолчанию: 0 (вечно будет повторяться).
-   `-r`, `--randomize` — использовать случайный порядок выполнения запросов при наличии более одного входного запроса.
-   `-s`, `--secure` — используется `TLS` соединение.
-   `-t N`, `--timelimit=N` — лимит по времени в секундах. `clickhouse-benchmark` перестает отправлять запросы при достижении лимита по времени. Значение по умолчанию: 0 (лимит отключен).
-   `--confidence=N` — уровень доверия для  T-критерия. Возможные значения: 0 (80%), 1 (90%), 2 (95%), 3 (98%), 4 (99%), 5 (99.5%). Значение по умолчанию: 5. В [режиме сравнения](#clickhouse-benchmark-comparison-mode) `clickhouse-benchmark` проверяет [двухвыборочный  t-критерий Стьюдента для независимых выборок](https://en.wikipedia.org/wiki/Student%27s_t-test#Independent_two-sample_t-test) чтобы определить, различны ли две выборки при выбранном уровне доверия.
-   `--cumulative` — выводить статистику за все время работы, а не за последний временной интервал.
-   `--database=DATABASE_NAME` — имя базы данных ClickHouse. Значение по умолчанию: `default`.
-   `--json=FILEPATH` — дополнительный вывод в формате `JSON`. Когда этот ключ указан, `clickhouse-benchmark` выводит отчет в указанный JSON-файл.
-   `--user=USERNAME` — имя пользователя ClickHouse. Значение по умолчанию: `default`.
-   `--password=PSWD` — пароль пользователя ClickHouse. Значение по умолчанию: пустая строка.
-   `--stacktrace` — вывод трассировки стека исключений. Когда этот ключ указан, `clickhouse-bencmark` выводит трассировку стека исключений.
-   `--stage=WORD` — стадия обработки запроса на сервере. ClickHouse останавливает обработку запроса и возвращает ответ `clickhouse-benchmark` на заданной стадии. Возможные значения: `complete`, `fetch_columns`, `with_mergeable_state`. Значение по умолчанию: `complete`.
-   `--help` — показывает справку.

Если нужно применить [настройки](../../operations/settings/index.md) для запросов, их можно передать как ключ `--<session setting name>= SETTING_VALUE`. Например, `--max_memory_usage=1048576`.

## Вывод {#clickhouse-benchmark-output}

По умолчанию, `clickhouse-benchmark` выводит сообщение для каждого `--delay` интервала.

Пример сообщения:

``` text
Queries executed: 10.

localhost:9000, queries 10, QPS: 6.772, RPS: 67904487.440, MiB/s: 518.070, result RPS: 67721584.984, result MiB/s: 516.675.

0.000%      0.145 sec.
10.000%     0.146 sec.
20.000%     0.146 sec.
30.000%     0.146 sec.
40.000%     0.147 sec.
50.000%     0.148 sec.
60.000%     0.148 sec.
70.000%     0.148 sec.
80.000%     0.149 sec.
90.000%     0.150 sec.
95.000%     0.150 sec.
99.000%     0.150 sec.
99.900%     0.150 sec.
99.990%     0.150 sec.
```

В сообщении можно найти:

-   Количество запросов в поле `Queries executed:`.

-   Строка статуса, содержащая (в таком же порядке):

    -   Endpoint сервера ClickHouse.
    -   Число обработанных запросов.
    -   QPS: количество запросов, выполняемых сервером за секунду в течение `--delay` интервала.
    -   RPS: количество строк, читаемых сервером за секунду в течение `--delay` интервала.
    -   MiB/s: количество Мебибайтов, считываемых сервером за секунду в течение `--delay` интервала.
    -   result RPS: количество строк, добавленное сервером в результат запроса за секунду в течение `--delay` интервала.
    -   result MiB/s. количество Мебибайтов, размещаемое сервером в результат запроса за секунду в течение `--delay` интервала.

-   Процентили времени выполнения запросов.

## Режим сравнения {#clickhouse-benchmark-comparison-mode}

`clickhouse-benchmark` может сравнивать производительность двух работающих серверов ClickHouse.

Для использования сравнительного режима укажите конечную точку двух серверов двумя парами ключей `--host`, `--port`. Связь ключей соответствует позициям в списке аргументов: первый `--host` соответствует первому `--port` и так далее. `clickhouse-benchmark` устанавливает соединение с обоими серверами и отсылает запросы. Каждый запрос адресован случайно выбранному серверу. Результаты выводятся отдельно для каждого сервера.

## Пример {#clickhouse-benchmark-example}

``` bash
$ echo "SELECT * FROM system.numbers LIMIT 10000000 OFFSET 10000000" | clickhouse-benchmark -i 10
```

``` text
Loaded 1 queries.

Queries executed: 6.

localhost:9000, queries 6, QPS: 6.153, RPS: 123398340.957, MiB/s: 941.455, result RPS: 61532982.200, result MiB/s: 469.459.

0.000%      0.159 sec.
10.000%     0.159 sec.
20.000%     0.159 sec.
30.000%     0.160 sec.
40.000%     0.160 sec.
50.000%     0.162 sec.
60.000%     0.164 sec.
70.000%     0.165 sec.
80.000%     0.166 sec.
90.000%     0.166 sec.
95.000%     0.167 sec.
99.000%     0.167 sec.
99.900%     0.167 sec.
99.990%     0.167 sec.



Queries executed: 10.

localhost:9000, queries 10, QPS: 6.082, RPS: 121959604.568, MiB/s: 930.478, result RPS: 60815551.642, result MiB/s: 463.986.

0.000%      0.159 sec.
10.000%     0.159 sec.
20.000%     0.160 sec.
30.000%     0.163 sec.
40.000%     0.164 sec.
50.000%     0.165 sec.
60.000%     0.166 sec.
70.000%     0.166 sec.
80.000%     0.167 sec.
90.000%     0.167 sec.
95.000%     0.170 sec.
99.000%     0.172 sec.
99.900%     0.172 sec.
99.990%     0.172 sec.
```

