# system.zookeeper {#system-zookeeper}

Таблицы не существует, если ZooKeeper не сконфигурирован. Позволяет читать данные из ZooKeeper кластера, описанного в конфигурации.
В запросе обязательно в секции WHERE должно присутствовать условие на равенство path - путь в ZooKeeper, для детей которого вы хотите получить данные.

Запрос `SELECT * FROM system.zookeeper WHERE path = '/clickhouse'` выведет данные по всем детям узла `/clickhouse`.
Чтобы вывести данные по всем узлам в корне, напишите path = ‘/’.
Если узла, указанного в path не существует, то будет брошено исключение.

Столбцы:

-   `name String` — Имя узла.
-   `path String` — Путь к узлу.
-   `value String` — Значение узла.
-   `dataLength Int32` — Размер значения.
-   `numChildren Int32` — Количество детей.
-   `czxid Int64` — Идентификатор транзакции, в которой узел был создан.
-   `mzxid Int64` — Идентификатор транзакции, в которой узел был последний раз изменён.
-   `pzxid Int64` — Идентификатор транзакции, последний раз удаливший или добавивший детей.
-   `ctime DateTime` — Время создания узла.
-   `mtime DateTime` — Время последней модификации узла.
-   `version Int32` — Версия узла - количество раз, когда узел был изменён.
-   `cversion Int32` — Количество добавлений или удалений детей.
-   `aversion Int32` — Количество изменений ACL.
-   `ephemeralOwner Int64` — Для эфемерных узлов - идентификатор сессии, которая владеет этим узлом.

Пример:

``` sql
SELECT *
FROM system.zookeeper
WHERE path = '/clickhouse/tables/01-08/visits/replicas'
FORMAT Vertical
```

``` text
Row 1:
──────
name:           example01-08-1.yandex.ru
value:
czxid:          932998691229
mzxid:          932998691229
ctime:          2015-03-27 16:49:51
mtime:          2015-03-27 16:49:51
version:        0
cversion:       47
aversion:       0
ephemeralOwner: 0
dataLength:     0
numChildren:    7
pzxid:          987021031383
path:           /clickhouse/tables/01-08/visits/replicas

Row 2:
──────
name:           example01-08-2.yandex.ru
value:
czxid:          933002738135
mzxid:          933002738135
ctime:          2015-03-27 16:57:01
mtime:          2015-03-27 16:57:01
version:        0
cversion:       37
aversion:       0
ephemeralOwner: 0
dataLength:     0
numChildren:    7
pzxid:          987021252247
path:           /clickhouse/tables/01-08/visits/replicas
```

