---
toc_priority: 59
toc_title: "Ограничения на сложность запроса"
---

# Ограничения на сложность запроса {#restrictions-on-query-complexity}

Ограничения на сложность запроса - часть настроек.
Используются, чтобы обеспечить более безопасное исполнение запросов из пользовательского интерфейса.
Почти все ограничения действуют только на SELECT-ы.
При распределённой обработке запроса, ограничения действуют на каждом сервере по отдельности.

Ограничения проверяются на каждый блок обработанных данных, а не на каждую строку. В связи с этим, ограничения могут быть превышены на размер блока.

Ограничения вида «максимальное количество чего-нибудь» могут принимать значение 0, которое обозначает «не ограничено».
Для большинства ограничений также присутствует настройка вида overflow_mode - что делать, когда ограничение превышено.
Оно может принимать одно из двух значений: `throw` или `break`; а для ограничения на агрегацию (group_by_overflow_mode) есть ещё значение `any`.

`throw` - кинуть исключение (по умолчанию).

`break` - прервать выполнение запроса и вернуть неполный результат, как будто исходные данные закончились.

`any (только для group_by_overflow_mode)` - продолжить агрегацию по ключам, которые успели войти в набор, но не добавлять новые ключи в набор.

## max_memory_usage {#settings_max_memory_usage}

Максимальный возможный объём оперативной памяти для выполнения запроса на одном сервере.

В конфигурационном файле по умолчанию, ограничение равно 10 ГБ.

Настройка не учитывает объём свободной памяти или общий объём памяти на машине.
Ограничение действует на один запрос, в пределах одного сервера.
Текущее потребление памяти для каждого запроса можно посмотреть с помощью `SHOW PROCESSLIST`.
Также отслеживается и выводится в лог пиковое потребление памяти для каждого запроса.

Потребление памяти не отслеживается для состояний некоторых агрегатных функций.

Потребление памяти не полностью учитывается для состояний агрегатных функций `min`, `max`, `any`, `anyLast`, `argMin`, `argMax` от аргументов `String` и `Array`.

Потребление памяти ограничивается также параметрами `max_memory_usage_for_user` и [max_server_memory_usage](../server-configuration-parameters/settings.md#max_server_memory_usage).

## max_memory_usage_for_user {#max-memory-usage-for-user}

Максимальный возможный объём оперативной памяти для запросов пользователя на одном сервере.

Значения по умолчанию определены в файле [Settings.h](https://github.com/ClickHouse/ClickHouse/blob/master/src/Core/Settings.h#L288). По умолчанию размер не ограничен (`max_memory_usage_for_user = 0`).

Смотрите также описание настройки [max_memory_usage](#settings_max_memory_usage).

## max_rows_to_read {#max-rows-to-read}

Следующие ограничения могут проверяться на каждый блок (а не на каждую строку). То есть, ограничения могут быть немного нарушены.

Максимальное количество строчек, которое можно прочитать из таблицы при выполнении запроса.

## max_bytes_to_read {#max-bytes-to-read}

Максимальное количество байт (несжатых данных), которое можно прочитать из таблицы при выполнении запроса.

## read_overflow_mode {#read-overflow-mode}

Что делать, когда количество прочитанных данных превысило одно из ограничений: throw или break. По умолчанию: throw.

## max_rows_to_read_leaf {#max-rows-to-read-leaf}

Следующие ограничения могут проверяться на каждый блок (а не на каждую строку). То есть, ограничения могут быть немного нарушены.

Максимальное количество строчек, которое можно прочитать из таблицы на удалённом сервере при выполнении
распределенного запроса. Распределенные запросы могут создавать несколько подзапросов к каждому из шардов в кластере и
тогда этот лимит будет применен при выполнении чтения на удаленных серверах (включая и сервер-инициатор) и проигнорирован
на сервере-инициаторе запроса во время обьединения полученных результатов. Например, кластер состоит из 2 шард и каждый
из них хранит таблицу с 100 строк. Тогда распределнный запрос для получения всех данных из этих таблиц и установленной
настройкой `max_rows_to_read=150` выбросит исключение, т.к. в общем он прочитает 200 строк. Но запрос
с настройкой  `max_rows_to_read_leaf=150` завершится успешно, потому что каждый из шардов прочитает максимум 100 строк.

## max_bytes_to_read_leaf {#max-bytes-to-read-leaf}

Максимальное количество байт (несжатых данных), которое можно прочитать из таблицы на удалённом сервере при
выполнении распределенного запроса. Распределенные запросы могут создавать несколько подзапросов к каждому из шардов в
кластере и тогда этот лимит будет применен при выполнении чтения на удаленных серверах (включая и сервер-инициатор)
и проигнорирован на сервере-инициаторе запроса во время обьединения полученных результатов. Например, кластер состоит
из 2 шард и каждый из них хранит таблицу со 100 байтами. Тогда распределнный запрос для получения всех данных из этих таблиц
и установленной настройкой `max_bytes_to_read=150` выбросит исключение, т.к. в общем он прочитает 200 байт. Но запрос
с настройкой  `max_bytes_to_read_leaf=150` завершится успешно, потому что каждый из шардов прочитает максимум 100 байт.

## read_overflow_mode_leaf {#read-overflow-mode-leaf}

Что делать, когда количество прочитанных данных на удаленном сервере превысило одно из ограничений: throw или break. По умолчанию: throw.

## max_rows_to_group_by {#settings-max-rows-to-group-by}

Максимальное количество уникальных ключей, получаемых в процессе агрегации. Позволяет ограничить потребление оперативки при агрегации.

## group_by_overflow_mode {#group-by-overflow-mode}

Что делать, когда количество уникальных ключей при агрегации превысило ограничение: throw, break или any. По умолчанию: throw.
Использование значения any позволяет выполнить GROUP BY приближённо. Качество такого приближённого вычисления сильно зависит от статистических свойств данных.

## max_bytes_before_external_group_by {#settings-max_bytes_before_external_group_by}

Включает или отключает выполнение секций `GROUP BY` во внешней памяти. Смотрите [GROUP BY во внешней памяти](../../sql-reference/statements/select/group-by.md#select-group-by-in-external-memory).

Возможные значения:

-   Максимальный объём RAM (в байтах), который может использовать отдельная операция [GROUP BY](../../sql-reference/statements/select/group-by.md#select-group-by-clause).
-   0 — `GROUP BY` во внешней памяти отключен.

Значение по умолчанию — 0.

## max_rows_to_sort {#max-rows-to-sort}

Максимальное количество строк до сортировки. Позволяет ограничить потребление оперативки при сортировке.

## max_bytes_to_sort {#max-bytes-to-sort}

Максимальное количество байт до сортировки.

## sort_overflow_mode {#sort-overflow-mode}

Что делать, если количество строк, полученное перед сортировкой, превысило одно из ограничений: throw или break. По умолчанию: throw.

## max_result_rows {#setting-max_result_rows}

Ограничение на количество строк результата. Проверяются также для подзапросов и на удалённых серверах при выполнении части распределённого запроса.

## max_result_bytes {#max-result-bytes}

Ограничение на количество байт результата. Аналогично.

## result_overflow_mode {#result-overflow-mode}

Что делать, если объём результата превысил одно из ограничений: throw или break. По умолчанию: throw.

Использование break по смыслу похоже на LIMIT. Break прерывает выполнение только на уровне блока. Т.е. число строк которые вернет запрос будет больше чем ограничение [max_result_rows](#setting-max_result_rows), кратно [max_block_size](../settings/settings.md#setting-max_block_size) и зависит от [max_threads](../settings/settings.md#settings-max_threads).

Пример:

``` sql
SET max_threads = 3, max_block_size = 3333;
SET max_result_rows = 3334, result_overflow_mode = 'break';

SELECT *
FROM numbers_mt(100000)
FORMAT Null;
```

Результат:

``` text
6666 rows in set. ...
```

## max_execution_time {#max-execution-time}

Максимальное время выполнения запроса в секундах.
На данный момент не проверяется при одной из стадий сортировки а также при слиянии и финализации агрегатных функций.

## timeout_overflow_mode {#timeout-overflow-mode}

Что делать, если запрос выполняется дольше max_execution_time: throw или break. По умолчанию: throw.

## min_execution_speed {#min-execution-speed}

Минимальная скорость выполнения запроса в строчках в секунду. Проверяется на каждый блок данных по истечении timeout_before_checking_execution_speed. Если скорость выполнения запроса оказывается меньше, то кидается исключение.

## min_execution_speed_bytes {#min-execution-speed-bytes}

Минимальная скорость выполнения запроса в строках на байт. Он проверяется для каждого блока данных после timeout_before_checking_execution_speed. Если скорость выполнения запроса меньше, исключение.

## max_execution_speed {#max-execution-speed}

Максимальная скорость выполнения запроса в строках в секунду. Он проверяется для каждого блока данных после timeout_before_checking_execution_speed. Если скорость выполнения запроса выше, скорость будет снижена.

## max_execution_speed_bytes {#max-execution-speed-bytes}

Максимальная скорость выполнения запроса в байтах в секунду. Он проверяется для каждого блока данных после timeout_before_checking_execution_speed. Если скорость выполнения запроса выше, скорость будет снижена.

## timeout_before_checking_execution_speed {#timeout-before-checking-execution-speed}

Проверять, что скорость выполнения запроса не слишком низкая (не меньше min_execution_speed), после прошествия указанного времени в секундах.

## max_columns_to_read {#max-columns-to-read}

Максимальное количество столбцов, которых можно читать из таблицы в одном запросе. Если запрос требует чтения большего количества столбцов - кинуть исключение.

## max_temporary_columns {#max-temporary-columns}

Максимальное количество временных столбцов, которых необходимо одновременно держать в оперативке, в процессе выполнения запроса, включая константные столбцы. Если временных столбцов оказалось больше - кидается исключение.

## max_temporary_non_const_columns {#max-temporary-non-const-columns}

То же самое, что и max_temporary_columns, но без учёта столбцов-констант.
Стоит заметить, что столбцы-константы довольно часто образуются в процессе выполнения запроса, но расходуют примерно нулевое количество вычислительных ресурсов.

## max_subquery_depth {#max-subquery-depth}

Максимальная вложенность подзапросов. Если подзапросы более глубокие - кидается исключение. По умолчанию: 100.

## max_pipeline_depth {#max-pipeline-depth}

Максимальная глубина конвейера выполнения запроса. Соответствует количеству преобразований, которое проходит каждый блок данных в процессе выполнения запроса. Считается в пределах одного сервера. Если глубина конвейера больше - кидается исключение. По умолчанию: 1000.

## max_ast_depth {#max-ast-depth}

Максимальная вложенность синтаксического дерева запроса. Если превышена - кидается исключение.
На данный момент, проверяются не во время парсинга а уже после парсинга запроса. То есть, во время парсинга может быть создано слишком глубокое синтаксическое дерево, но запрос не будет выполнен. По умолчанию: 1000.

## max_ast_elements {#max-ast-elements}

Максимальное количество элементов синтаксического дерева запроса. Если превышено - кидается исключение.
Аналогично, проверяется уже после парсинга запроса. По умолчанию: 50 000.

## max_rows_in_set {#max-rows-in-set}

Максимальное количество строчек для множества в секции IN, создаваемого из подзапроса.

## max_bytes_in_set {#max-bytes-in-set}

Максимальное количество байт (несжатых данных), занимаемое множеством в секции IN, создаваемым из подзапроса.

## set_overflow_mode {#set-overflow-mode}

Что делать, когда количество данных превысило одно из ограничений: throw или break. По умолчанию: throw.

## max_rows_in_distinct {#max-rows-in-distinct}

Максимальное количество различных строчек при использовании DISTINCT.

## max_bytes_in_distinct {#max-bytes-in-distinct}

Максимальное количество байт, занимаемых хэш-таблицей, при использовании DISTINCT.

## distinct_overflow_mode {#distinct-overflow-mode}

Что делать, когда количество данных превысило одно из ограничений: throw или break. По умолчанию: throw.

## max_rows_to_transfer {#max-rows-to-transfer}

Максимальное количество строчек, которых можно передать на удалённый сервер или сохранить во временную таблицу, при использовании GLOBAL IN.

## max_bytes_to_transfer {#max-bytes-to-transfer}

Максимальное количество байт (несжатых данных), которых можно передать на удалённый сервер или сохранить во временную таблицу, при использовании GLOBAL IN.

## transfer_overflow_mode {#transfer-overflow-mode}

Что делать, когда количество данных превысило одно из ограничений: throw или break. По умолчанию: throw.

## max_rows_in_join {#settings-max_rows_in_join}

Ограничивает количество строк в хэш-таблице, используемой при соединении таблиц.

Параметр применяется к операциям [SELECT… JOIN](../../sql-reference/statements/select/join.md#select-join) и к движку таблиц [Join](../../engines/table-engines/special/join.md).

Если запрос содержит несколько `JOIN`, то ClickHouse проверяет значение настройки для каждого промежуточного результата.

При достижении предела ClickHouse может выполнять различные действия. Используйте настройку [join_overflow_mode](#settings-join_overflow_mode) для выбора действия.

Возможные значения:

-   Положительное целое число.
-   0 — неограниченное количество строк.

Значение по умолчанию — 0.

## max_bytes_in_join {#settings-max_bytes_in_join}

Ограничивает размер (в байтах) хэш-таблицы, используемой при объединении таблиц.

Параметр применяется к операциям [SELECT… JOIN](../../sql-reference/statements/select/join.md#select-join) и к движку таблиц [Join](../../engines/table-engines/special/join.md).

Если запрос содержит несколько `JOIN`, то ClickHouse проверяет значение настройки для каждого промежуточного результата.

При достижении предела ClickHouse может выполнять различные действия. Используйте настройку [join_overflow_mode](#settings-join_overflow_mode) для выбора действия.

Возможные значения:

-   Положительное целое число.
-   0 — контроль памяти отключен.

Значение по умолчанию — 0.

## join_overflow_mode {#settings-join_overflow_mode}

Определяет, какое действие ClickHouse выполняет при достижении любого из следующих ограничений для `JOIN`:

-   [max_bytes_in_join](#settings-max_bytes_in_join)
-   [max_rows_in_join](#settings-max_rows_in_join)

Возможные значения:

-   `THROW` — ClickHouse генерирует исключение и прерывает операцию.
-   `BREAK` — ClickHouse прерывает операцию, но не генерирует исключение.

Значение по умолчанию — `THROW`.

**Смотрите также**

-   [Секция JOIN](../../sql-reference/statements/select/join.md#select-join)
-   [Движок таблиц Join](../../engines/table-engines/special/join.md)

## max_partitions_per_insert_block {#max-partitions-per-insert-block}

Ограничивает максимальное количество партиций в одном вставленном блоке.

-   Положительное целое число.
-   0 — неограниченное количество разделов.

Значение по умолчанию: 100.

**Подробности**

При вставке данных, ClickHouse вычисляет количество партиций во вставленном блоке. Если число партиций больше, чем `max_partitions_per_insert_block`, ClickHouse генерирует исключение со следующим текстом:

> «Too many partitions for single INSERT block (more than» + toString(max_parts) + «). The limit is controlled by ‘max_partitions_per_insert_block’ setting. Large number of partitions is a common misconception. It will lead to severe negative performance impact, including slow server startup, slow INSERT queries and slow SELECT queries. Recommended total number of partitions for a table is under 1000..10000. Please note, that partitioning is not intended to speed up SELECT queries (ORDER BY key is sufficient to make range queries fast). Partitions are intended for data manipulation (DROP PARTITION, etc).»

