# Настройки MergeTree таблиц {#merge-tree-settings}

Значения настроек всех MergeTree таблиц собраны в таблице `system.merge_tree_settings`. Их можно переопределить в разделе `merge_tree` файла `config.xml` или задать в секции `SETTINGS` каждой таблицы.

Пример переопределения в `config.xml`:

``` text
<merge_tree>
    <max_suspicious_broken_parts>5</max_suspicious_broken_parts>
</merge_tree>
```

Пример установки `SETTINGS` для конкретной таблицы:

``` sql
CREATE TABLE foo
(
    `A` Int64
)
ENGINE = MergeTree
ORDER BY tuple()
SETTINGS max_suspicious_broken_parts = 500;
```

Пример изменения настроек для конкретной таблицы при помощи команды `ALTER TABLE ... MODIFY SETTING`:

``` sql
ALTER TABLE foo
    MODIFY SETTING max_suspicious_broken_parts = 100;
```

## parts_to_throw_insert {#parts-to-throw-insert}

Eсли число активных кусков в партиции больше значения `parts_to_throw_insert`, то INSERT прерывается с исключением: `Too many parts (N). Merges are processing significantly slower than inserts`.

Возможные значения:

-   Положительное целое число.

Значение по умолчанию: 300.

Чтобы производительность запросов `SELECT` стала максимальной, необходимо минимизировать количество обрабатываемых кусков, см. [Дизайн MergeTree](../../development/architecture.md#merge-tree).

Можно установить значение больше — 600 (1200) кусков. Тогда ошибка `Too many parts` будет появляться реже, но при этом могут возникнуть проблемы с фоновыми слияниями и производительностью `SELECT`-запросов.

## parts_to_delay_insert {#parts-to-delay-insert}

Eсли число кусков в партиции больше значения `parts_to_delay_insert`, то `INSERT` искусственно замедляется.

Возможные значения:

-   Положительное целое число.

Значение по умолчанию: 150.

ClickHouse искусственно выполняет `INSERT` дольше (добавляет ‘sleep’) так, чтобы куски сливались в фоновом процессе быстрее, чем добавляются.

## inactive_parts_to_throw_insert {#inactive-parts-to-throw-insert}

Если число неактивных кусков в партиции больше значения `inactive_parts_to_throw_insert`, то `INSERT` прерывается с исключением `Too many inactive parts (N). Parts cleaning are processing significantly slower than inserts`.

Возможные значения:

-   Положительное целое число.

Значение по умолчанию: 0 (без ограничений).

## inactive_parts_to_delay_insert {#inactive-parts-to-delay-insert}

Если число неактивных кусков в партиции больше или равно значению `inactive_parts_to_delay_insert`, то `INSERT` искусственно замедляется. Это помогает, когда сервер не может быстро очистить неактивные куски.

Возможные значения:

-   Положительное целое число.

Значение по умолчанию: 0 (без ограничений).

## max_delay_to_insert {#max-delay-to-insert}

Величина в секундах, которая используется для расчета задержки `INSERT` в случаях, когда число кусков в партиции больше значения [parts_to_delay_insert](#parts-to-delay-insert).

Возможные значения:

-   Положительное целое число.

Значение по умолчанию: 1.

Величина задержки (в миллисекундах) для `INSERT` вычисляется по формуле:

```code
max_k = parts_to_throw_insert - parts_to_delay_insert
k = 1 + parts_count_in_partition - parts_to_delay_insert
delay_milliseconds = pow(max_delay_to_insert * 1000, k / max_k)
```

Т.е. если в партиции уже 299 кусков и parts_to_throw_insert = 300, parts_to_delay_insert = 150, а max_delay_to_insert = 1, то `INSERT` замедлится на `pow( 1 * 1000, (1 + 299 - 150) / (300 - 150) ) = 1000` миллисекунд.

## max_parts_in_total {#max-parts-in-total}

Eсли суммарное число активных кусков во всех партициях таблицы больше значения `max_parts_in_total`, то INSERT прерывается с исключением `Too many parts (N)`.

Возможные значения:

-   Положительное целое число.

Значение по умолчанию: 100000.

С большим числом кусков в таблице производительность запросов ClickHouse снижается, а время старта ClickHouse — увеличивается. Чаще всего это следствие неправильного дизайна (ошибки выбора стратегии партиционирования, например, слишком мелкие партиции).

## replicated_deduplication_window {#replicated-deduplication-window}

Количество хеш-сумм последних вставленных блоков, которые хранятся в Zookeeper.

Возможные значения:

-   Положительное целое число.
-   0 (без ограничений).

Значение по умолчанию: 100.

Команда `Insert` создает один или несколько блоков (кусков). При вставке в Replicated таблицы ClickHouse для [дедупликации вставок](../../engines/table-engines/mergetree-family/replication.md) записывает в Zookeeper хеш-суммы созданных кусков. Но хранятся только последние `replicated_deduplication_window` хеш-сумм. Самые старые хеш-суммы удаляются из Zookeeper.
Большое значение `replicated_deduplication_window` замедляет `Insert`, так как приходится сравнивать большее количество хеш-сумм.
Хеш-сумма рассчитывается по названиям и типам полей, а также по данным вставленного куска (потока байт).

## non_replicated_deduplication_window {#non-replicated-deduplication-window}

Количество последних вставленных блоков в нереплицированной [MergeTree](../../engines/table-engines/mergetree-family/mergetree.md) таблице, для которых хранятся хеш-суммы для проверки дубликатов.

Возможные значения:

-   Положительное целое число.
-   0 (дедупликация отключена).

Значение по умолчанию: 0.

Используется механизм дедупликации, аналогичный реплицированным таблицам (см. описание настройки [replicated_deduplication_window](#replicated-deduplication-window)). Хеш-суммы вставленных кусков записываются в локальный файл на диске.

## replicated_deduplication_window_seconds {#replicated-deduplication-window-seconds}

Время хранения (в секундах) хеш-сумм вставленных блоков в Zookeeper. По истечении этого времени хеш-суммы удаляются.

Возможные значения:

-   Положительное целое число.

Значение по умолчанию: 604800 (1 неделя).

Аналогично [replicated_deduplication_window](#replicated-deduplication-window), настройка `replicated_deduplication_window_seconds` задает время хранения хеш-сумм блоков для дедупликции `Insert`. Хеш-суммы старше значения `replicated_deduplication_window_seconds` удаляются из Zookeeper, даже если количество оставшихся хеш-сумм станет меньше чем `replicated_deduplication_window`.

## old_parts_lifetime {#old-parts-lifetime}

Время (в секундах) хранения неактивных кусков для защиты от потери данных при спонтанной перезагрузке сервера.

Возможные значения:

-   Положительное целое число.

Значение по умолчанию: 480.

После объединения нескольких кусков в один новый ClickHouse помечает исходные куски как неактивные и удаляет их по прошествии `old_parts_lifetime` секунд.
Неактивные куски удаляются, если они не нужны для текущих запросов, т.е. если счетчик ссылок куска `refcount` имеет нулевое значение.

При записи нового куска `fsync` не вызывается, поэтому неактивные куски удаляются позже. Это значит, что некоторое время новый кусок находится только в оперативной памяти сервера (кеш ОС). Если сервер перезагрузится спонтанно, новый слитый кусок может испортиться или потеряться.

Во время запуска сервер ClickHouse проверяет целостность кусков.
Если новый (слитый) кусок поврежден, ClickHouse возвращает неактивные куски в список активных и позже снова выполняет слияние. В этом случае испорченный кусок получает новое имя (добавляется префикс `broken_`) и попадает в каталог `detached`.
Если проверка целостности не выявляет проблем в слитом куске, то исходные неактивные куски переименовываются (добавляется префикс `ignored_`) и перемещаются в каталог `detached`.

Стандартное для Linux значение `dirty_expire_centisecs` — 30 секунд. Это максимальное время, в течение которого записанные данные хранятся только в оперативной памяти. Если нагрузка на дисковую систему большая, то данные записываются намного позже. Значение 480 секунд подобрали экспериментальным путем — это время, за которое новый кусок гарантированно запишется на диск.

## replicated_fetches_http_connection_timeout {#replicated_fetches_http_connection_timeout}

Тайм-аут HTTP-соединения (в секундах) для запросов на скачивание кусков. Наследуется из профиля по умолчанию [http_connection_timeout](./settings.md#http_connection_timeout), если не задан явно.

Возможные значения:

-   0 - используется значение `http_connection_timeout`.
-   Любое положительное целое число.

Значение по умолчанию: `0`.

## replicated_fetches_http_send_timeout {#replicated_fetches_http_send_timeout}

Тайм-аут (в секундах) для отправки HTTP-запросов на скачивание кусков. Наследуется из профиля по умолчанию [http_send_timeout](./settings.md#http_send_timeout), если не задан явно.

Возможные значения:

-   0 - используется значение `http_send_timeout`.
-   Любое положительное целое число.

Значение по умолчанию: `0`.

## replicated_fetches_http_receive_timeout {#replicated_fetches_http_receive_timeout}

Тайм-аут (в секундах) для получения HTTP-запросов на скачивание кусков. Наследуется из профиля по умолчанию [http_receive_timeout](./settings.md#http_receive_timeout), если не задан явно.

Возможные значения:

-   0 - используется значение `http_receive_timeout`.
-   Любое положительное целое число.

Значение по умолчанию: `0`.

## max_replicated_fetches_network_bandwidth {#max_replicated_fetches_network_bandwidth}

Ограничивает максимальную скорость скачивания данных в сети (в байтах в секунду) для синхронизаций между [репликами](../../engines/table-engines/mergetree-family/replication.md). Настройка применяется к конкретной таблице, в отличие от [max_replicated_fetches_network_bandwidth_for_server](settings.md#max_replicated_fetches_network_bandwidth_for_server), которая применяется к серверу.

Можно ограничить скорость обмена данными как для всего сервера, так и для конкретной таблицы, но для этого значение табличной настройки должно быть меньше серверной. Иначе сервер будет учитывать только настройку `max_replicated_fetches_network_bandwidth_for_server`.

Настройка соблюдается неточно.

Возможные значения:

-   Любое целое положительное число.
-   0 — Скорость не ограничена.

Значение по умолчанию: `0`.

**Использование**

Может быть использована для ограничения скорости передачи данных при репликации данных для добавления или замены новых узлов.

## max_replicated_sends_network_bandwidth {#max_replicated_sends_network_bandwidth}

Ограничивает максимальную скорость отправки данных по сети (в байтах в секунду) для синхронизации между [репликами](../../engines/table-engines/mergetree-family/replication.md). Настройка применяется к конкретной таблице, в отличие от [max_replicated_sends_network_bandwidth_for_server](settings.md#max_replicated_sends_network_bandwidth_for_server), которая применяется к серверу.

Можно ограничить скорость обмена данными как для всего сервера, так и для конкретной таблицы, но для этого значение табличной настройки должно быть меньше серверной. Иначе сервер будет учитывать только настройку `max_replicated_sends_network_bandwidth_for_server`.

Настройка следуется неточно.

Возможные значения:

-   Любое целое положительное число.
-   0 — Скорость не ограничена.

Значение по умолчанию: `0`.

**Использование**

Может быть использована для ограничения скорости сети при репликации данных для добавления или замены новых узлов.

## max_bytes_to_merge_at_max_space_in_pool {#max-bytes-to-merge-at-max-space-in-pool}

Максимальный суммарный размер кусков (в байтах) в одном слиянии, если есть свободные ресурсы в фоновом пуле.
`max_bytes_to_merge_at_max_space_in_pool` примерно соответствует максимально возможному размеру куска, созданного автоматическим фоновым слиянием.

Возможные значения:

-   Положительное целое число.

Значение по умолчанию: 161061273600 (150ГБ).

Планировщик слияний периодически анализирует размер и количество кусков в партициях, и если в пуле хватает ресурсов, то начинает фоновое слияние. Слияния выполняются до тех пор, пока суммарный размер входных кусков не достигнет `max_bytes_to_merge_at_max_space_in_pool`.

Слияния, начатые по [OPTIMIZE FINAL](../../sql-reference/statements/optimize.md), не учитывают `max_bytes_to_merge_at_max_space_in_pool` и объединяют куски пока есть доступные ресурсы (свободное дисковое пространство) до тех пор, пока в партиции не останется один кусок.

## max_bytes_to_merge_at_min_space_in_pool {#max-bytes-to-merge-at-min-space-in-pool}

Максимальный суммарный размер кусков (в байтах) в одном слиянии при минимуме свободных ресурсов в фоновом пуле.

Возможные значения:

-   Положительное целое число.

Значение по умолчанию: 1048576 (1 МБ).

`max_bytes_to_merge_at_min_space_in_pool` задает максимальный суммарный размер кусков, которые можно объединить несмотря на нехватку свободных ресурсов (дискового пространства) в фоновом пуле. Это нужно, чтобы уменьшить количество маленьких кусков и снизить вероятность ошибки `Too many parts`.

Слияния резервируют дисковое пространство, удваивая суммарный размер кусков в слиянии. Поэтому при малом объеме свободного места на диске может сложиться ситуация, когда свободное место есть, но оно уже зарезервировано текущими слияниями. Из-за этого другие слияния не начинаются, и количество маленьких кусков в партиции растет с каждым запросом `INSERT`.

## merge_max_block_size {#merge-max-block-size}

Количество строк в блоках, которые читаются из объединяемых кусков.

Возможные значения:

-   Положительное целое число.

Значение по умолчанию: 8192

Слияние читает строки из кусков блоками по `merge_max_block_size` строк, производит слияние и записывает результат в новый кусок. Читаемый блок помещается в оперативную память, т.е. `merge_max_block_size` влияет на размер оперативной памяти, необходимой для слияния. Таким образом, слияния могут потреблять большое количество оперативной памяти для таблиц, хранящих очень большие строки (если средний размер строки 100кб, то при слиянии 10 кусков будет использовано (100кб * 10 * 8192) =~ 8ГБ оперативной памяти). Уменьшив `merge_max_block_size`, можно сократить размер оперативной памяти, необходимой для слияния, но при этом процесс слияния замедлится.

## max_part_loading_threads {#max-part-loading-threads}

Максимальное количество потоков, которые читают куски при старте ClickHouse.

Возможные значения:

-   Положительное целое число.

Значение по умолчанию: определяется автоматически (по количеству ядер процессора).

На старте ClickHouse читает все куски из всех таблиц (читает файлы с метаданными кусков), чтобы построить в оперативной памяти список всех кусков. В некоторых системах с большим количеством кусков этот процесс может занимать длительное время. Это время можно сократить, увеличив `max_part_loading_threads` (если при этом хватает ресурсов процессора и диска).

## max_partitions_to_read {#max-partitions-to-read}

Ограничивает максимальное число партиций для чтения в одном запросе.

Указанное при создании таблицы значение настройки может быть переназначено настройкой на уровне запроса.

Возможные значения:

-   Любое положительное целое число.

Значение по умолчанию: -1 (неограниченно).

## allow_floating_point_partition_key {#allow_floating_point_partition_key}

Позволяет использовать число с плавающей запятой в качестве ключа партиционирования.

Возможные значения:

-   0 — Ключ партиционирования с плавающей запятой не разрешен.
-   1 — Ключ партиционирования с плавающей запятой разрешен.

Значение по умолчанию: `0`.

## check_sample_column_is_correct {#check_sample_column_is_correct}

Разрешает проверку того, что тип данных столбца для сэмплирования или выражения сэмплирования при создании таблицы верный. Тип данных должен соответствовать одному из беззнаковых [целочисленных типов](../../sql-reference/data-types/int-uint.md): `UInt8`, `UInt16`, `UInt32`, `UInt64`.

Возможные значения:

-   true  — проверка включена.
-   false — проверка при создании таблицы не проводится.

Значение по умолчанию: `true`.

По умолчанию сервер ClickHouse при создании таблицы проверяет тип данных столбца для сэмплирования или выражения сэмплирования. Если уже существуют таблицы с некорректным выражением сэмплирования, то чтобы не возникало исключение при запуске сервера, установите `check_sample_column_is_correct` в значение `false`.

## min_bytes_to_rebalance_partition_over_jbod {#min-bytes-to-rebalance-partition-over-jbod}

Устанавливает минимальное количество байтов для обеспечения балансировки при распределении новых больших кусков данных по дискам тома [JBOD](https://en.wikipedia.org/wiki/Non-RAID_drive_architectures).

Возможные значения:

-   Положительное целое число.
-   0 — балансировка отключена.

Значение по умолчанию: `0`.

**Использование**

Значение настройки `min_bytes_to_rebalance_partition_over_jbod` должно быть меньше значения настройки [max_bytes_to_merge_at_max_space_in_pool](../../operations/settings/merge-tree-settings.md#max-bytes-to-merge-at-max-space-in-pool). Иначе ClickHouse сгенерирует исключение.

## detach_not_byte_identical_parts {#detach_not_byte_identical_parts}

Настраивает отключение куска данных после выполнения слияния или мутации, если на одной реплике его содержимое побайтно не совпадает с кусками на других репликах. Если настройка отключена, то кусок удаляется. Активируйте это поведение, если хотите анализировать такие куски позже.

Эта настройка применяется к таблицам `MergeTree` с включенной [репликацией данных](../../engines/table-engines/mergetree-family/replication.md).

Возможные значения:

-   0 — куски данных удаляются.
-   1 — куски данных открепляются.

Значение по умолчанию: `0`.

## merge_tree_clear_old_temporary_directories_interval_seconds {#setting-merge-tree-clear-old-temporary-directories-interval-seconds}

Задает интервал в секундах для удаления старых временных каталогов на сервере ClickHouse.

Возможные значения:

-   Положительное целое число.

Значение по умолчанию: `60` секунд.

## merge_tree_clear_old_parts_interval_seconds {#setting-merge-tree-clear-old-parts-interval-seconds}

Задает интервал в секундах для удаления старых кусков данных, журналов предзаписи (WAL) и мутаций на сервере ClickHouse.

Возможные значения:

-   Положительное целое число.

Значение по умолчанию: `1` секунда.
