---
toc_folder_title: Settings
toc_priority: 55
toc_title: Introduction
---

# Настройки {#session-settings-intro}

Все настройки, описанные ниже, могут быть заданы несколькими способами.
Настройки задаются послойно, т.е. каждый следующий слой перезаписывает предыдущие настройки.

Способы задания настроек, упорядоченные по приоритету:

-   Настройки в конфигурационном файле сервера `users.xml`.

    Устанавливаются в элементе `<profiles>`.

-   Настройки для сессии.

    Из консольного клиента ClickHouse в интерактивном режиме отправьте запрос `SET setting=value`.
    Аналогично можно использовать ClickHouse-сессии в HTTP-протоколе, для этого необходимо указывать HTTP-параметр `session_id`.

-   Настройки для запроса.

    -   При запуске консольного клиента ClickHouse в не интерактивном режиме установите параметр запуска `--setting=value`.
    -   При использовании HTTP API передавайте cgi-параметры (`URL?setting_1=value&setting_2=value...`).
    -  Укажите необходимые настройки в секции [SETTINGS](../../sql-reference/statements/select/index.md#settings-in-select) запроса SELECT. Эти настройки действуют только в рамках данного запроса, а после его выполнения сбрасываются до предыдущего значения или значения по умолчанию.

Настройки, которые можно задать только в конфигурационном файле сервера, в разделе не рассматриваются.

## Пользовательские настройки {#custom_settings}

В дополнение к общим [настройкам](../../operations/settings/settings.md), пользователи могут определять собственные настройки.

Название пользовательской настройки должно начинаться с одного из предопределённых префиксов. Список этих префиксов должен быть задан в параметре [custom_settings_prefixes](../../operations/server-configuration-parameters/settings.md#custom_settings_prefixes) конфигурационнного файла сервера.

```xml
<custom_settings_prefixes>custom_</custom_settings_prefixes>
```

Чтобы задать значение пользовательской настройке, используйте команду `SET`:

```sql
SET custom_a = 123;
```

Чтобы получить текущее значение пользовательской настройки, используйте функцию `getSetting()`:

```sql
SELECT getSetting('custom_a');
```

**См. также**

-   [Конфигурационные параметры сервера](../../operations/server-configuration-parameters/settings.md)

