---
toc_priority: 28
toc_title: "Визуальные интерфейсы от сторонних разработчиков"
---


# Визуальные интерфейсы от сторонних разработчиков {#vizualnye-interfeisy-ot-storonnikh-razrabotchikov}

## С открытым исходным кодом {#s-otkrytym-iskhodnym-kodom}

### Tabix {#tabix}

Веб-интерфейс для ClickHouse в проекте [Tabix](https://github.com/tabixio/tabix).

Основные возможности:

-   Работает с ClickHouse напрямую из браузера, без необходимости установки дополнительного ПО;
-   Редактор запросов с подсветкой синтаксиса;
-   Автодополнение команд;
-   Инструменты графического анализа выполнения запросов;
-   Цветовые схемы на выбор.

[Документация Tabix](https://tabix.io/doc/).

### HouseOps {#houseops}

[HouseOps](https://github.com/HouseOps/HouseOps) — UI/IDE для OSX, Linux и Windows.

Основные возможности:

-   Построение запросов с подсветкой синтаксиса;
-   Просмотр ответа в табличном или JSON представлении;
-   Экспортирование результатов запроса в формате CSV или JSON;
-   Список процессов с описанием;
-   Режим записи;
-   Возможность остановки (`KILL`) запроса;
-   Граф базы данных. Показывает все таблицы и их столбцы с дополнительной информацией;
-   Быстрый просмотр размера столбца;
-   Конфигурирование сервера.

Планируется разработка следующих возможностей:

-   Управление базами;
-   Управление пользователями;
-   Анализ данных в режиме реального времени;
-   Мониторинг кластера;
-   Управление кластером;
-   Мониторинг реплицированных и Kafka таблиц.

### LightHouse {#lighthouse}

[LightHouse](https://github.com/VKCOM/lighthouse) — это легковесный веб-интерфейс для ClickHouse.

Основные возможности:

-   Список таблиц с фильтрацией и метаданными;
-   Предварительный просмотр таблицы с фильтрацией и сортировкой;
-   Выполнение запросов только для чтения.

### Redash {#redash}

[Redash](https://github.com/getredash/redash) — платформа для отображения данных.

Поддерживает множество источников данных, включая ClickHouse. Redash может объединять результаты запросов из разных источников в финальный набор данных.

Основные возможности:

-   Мощный редактор запросов.
-   Проводник по базе данных.
-   Инструменты визуализации, позволяющие представить данные в различных формах.

### Grafana {#grafana}

[Grafana](https://grafana.com/grafana/plugins/vertamedia-clickhouse-datasource) — платформа для мониторинга и визуализации.

"С помощью Grafana вы можете делать запросы, визуализировать, получать уведомления и разбираться в метриках, где бы они ни хранились. Создавайте, исследуйте, делитесь дашбордами с командой и прививайте культуру принятия решений на основе данных. Мы пользуемся доверием и любовью пользователей" — grafana.com.

Плагин источника данных ClickHouse поддерживает ClickHouse в качестве бэкенд базы данных.

### DBeaver {#dbeaver}

[DBeaver](https://dbeaver.io/) - универсальный desktop клиент баз данных с поддержкой ClickHouse.

Основные возможности:

-   Построение запросов с подсветкой синтаксиса.
-   Просмотр таблиц.
-   Автодополнение команд.
-   Полнотекстовый поиск.

По умолчанию DBeaver не использует сессии при подключении (в отличие от CLI, например). Если вам нужна поддержка сессий (например, для установки настроек на сессию), измените настройки подключения драйвера и укажите для настройки `session_id` любое произвольное значение (драйвер использует подключение по http). После этого вы можете использовать любую настройку (setting) в окне запроса. 

### clickhouse-cli {#clickhouse-cli}

[clickhouse-cli](https://github.com/hatarist/clickhouse-cli) - это альтернативный клиент командной строки для ClickHouse, написанный на Python 3.

Основные возможности:

-   Автодополнение;
-   Подсветка синтаксиса для запросов и вывода данных;
-   Поддержка постраничного просмотра для результирующих данных;
-   Дополнительные PostgreSQL-подобные команды.

### clickhouse-flamegraph {#clickhouse-flamegraph}

[clickhouse-flamegraph](https://github.com/Slach/clickhouse-flamegraph) — специализированный инструмент для визуализации `system.trace_log` в виде [flamegraph](http://www.brendangregg.com/flamegraphs.html).

### clickhouse-plantuml {#clickhouse-plantuml}

[cickhouse-plantuml](https://pypi.org/project/clickhouse-plantuml/) — скрипт, генерирующий [PlantUML](https://plantuml.com/) диаграммы схем таблиц.

### xeus-clickhouse {#xeus-clickhouse}

[xeus-clickhouse](https://github.com/wangfenjin/xeus-clickhouse) — это ядро Jupyter для ClickHouse, которое поддерживает запрос ClickHouse-данных с использованием SQL в Jupyter.

### MindsDB Studio {#mindsdb}

[MindsDB](https://mindsdb.com/) — это продукт с открытым исходным кодом, реализующий слой искусственного интеллекта (Artificial Intelligence, AI) для различных СУБД, в том числе для ClickHouse. MindsDB облегчает процессы создания, обучения и развертывания современных моделей машинного обучения. Графический пользовательский интерфейс MindsDB Studio позволяет обучать новые модели на основе данных в БД, интерпретировать сделанные моделями прогнозы, выявлять потенциальные ошибки в данных, визуализировать и оценивать достоверность моделей с помощью функции Explainable AI, так чтобы вы могли быстрее адаптировать и настраивать ваши модели машинного обучения.

### DBM {#dbm}

[DBM](https://dbm.incubator.edurt.io/) DBM — инструмент для визуального менеджмента в ClickHouse!

Основные возможности:

-   Поддержка истории запросов (пагинация, очистка и т.д.)
-   Поддержка отдельных секций запросов
-   Поддержка остановки запроса
-   Поддержка управления таблицами (метаданные, удаление, предпросмотр)
-   Поддержка управления базами данных (удаление, создание)
-   Поддержка пользовательских запросов
-   Поддержка управления различными источниками данных (проверка соединения, мониторинг)
-   Поддержка монитора (процессор, соединение, запрос)
-   Поддержка миграции данных

### Bytebase {#bytebase}

[Bytebase](https://bytebase.com) — сетевой инструмент для смены схем и контроля версий с открытым исходным кодом для работы в команде. Поддерживает различные базы данных, в том числе ClickHouse.

Основные возможности:

-   Проверка схемы для разработчиков и администраторов баз данных.
-   "База данных в виде кода", хранение схемы базы данных с помощью системы контроля версий, например, GitLab, а также активация развертывания по коммиту.
-   Рациональное развертывание и соответствующая среда.
-   Полная история миграций.
-   Определение смещения схемы.
-   Резервное копирование и восстановление.
-   Управление доступом на основе ролей.

## Коммерческие {#commercial}

### DataGrip {#datagrip}

[DataGrip](https://www.jetbrains.com/datagrip/) — это IDE для баз данных от JetBrains с выделенной поддержкой ClickHouse. Он также встроен в другие инструменты на основе IntelliJ: PyCharm, IntelliJ IDEA, GoLand, PhpStorm и другие.

Основные возможности:

-   Очень быстрое дополнение кода.
-   Подсветка синтаксиса для SQL диалекта ClickHouse.
-   Поддержка функций, специфичных для ClickHouse, например вложенных столбцов, движков таблиц.
-   Редактор данных.
-   Рефакторинги.
-   Поиск и навигация.

### Yandex DataLens {#yandex-datalens}

[Yandex DataLens](https://cloud.yandex.ru/services/datalens) — cервис визуализации и анализа данных.

Основные возможности:

-   Широкий выбор инструментов визуализации, от простых столбчатых диаграмм до сложных дашбордов.
-   Возможность опубликовать дашборды на широкую аудиторию.
-   Поддержка множества источников данных, включая ClickHouse.
-   Хранение материализованных данных в кластере ClickHouse DataLens.

Для небольших проектов DataLens [доступен бесплатно](https://cloud.yandex.ru/docs/datalens/pricing), в том числе и для коммерческого использования.

-   [Документация DataLens](https://cloud.yandex.ru/docs/datalens/).
-   [Пособие по визуализации данных из ClickHouse](https://cloud.yandex.ru/docs/solutions/datalens/data-from-ch-visualization).

### Holistics Software {#holistics-software}

[Holistics](https://www.holistics.io/) — full-stack платформа для обработки данных и бизнес-аналитики.

Основные возможности:

-   Автоматизированные отчёты на почту, Slack, и Google Sheet.
-   Редактор SQL c визуализацией, контролем версий, автодополнением, повторным использованием частей запроса и динамическими фильтрами.
-   Встроенные инструменты анализа отчётов и всплывающие (iframe) дашборды.
-   Подготовка данных и возможности ETL.
-   Моделирование данных с помощью SQL для их реляционного отображения.


### Looker {#looker}

[Looker](https://looker.com) — платформа для обработки данных и бизнес-аналитики. Поддерживает более 50 диалектов баз данных, включая ClickHouse. Looker можно установить самостоятельно или воспользоваться готовой платформой SaaS.

Просмотр данных, построение отображений и дашбордов, планирование отчётов и обмен данными с коллегами доступны с помощью браузера. Также, Looker предоставляет ряд инструментов, позволяющих встраивать сервис в другие приложения и API для обмена данными.

Основные возможности:

-   Язык LookML, поддерживающий [моделирование данных](https://looker.com/platform/data-modeling).
-   Интеграция с различными системами с помощью [Data Actions](https://looker.com/platform/actions).
-   Инструменты для встраивания сервиса в приложения.
-   API.

[Как сконфигурировать ClickHouse в Looker.](https://docs.looker.com/setup-and-management/database-config/clickhouse)

### SeekTable {#seektable}

[SeekTable](https://www.seektable.com) — это аналитический инструмент для самостоятельного анализа и обработки данных бизнес-аналитики. Он доступен как в виде облачного сервиса, так и в виде локальной версии. Отчеты из SeekTable могут быть встроены в любое веб-приложение.

Основные возможности:

-   Удобный конструктор отчетов.
-   Гибкая настройка отчетов SQL и создание запросов для специфичных отчетов.
-   Интегрируется с ClickHouse, используя собственную точку приема запроса TCP/IP или интерфейс HTTP(S) (два разных драйвера).
-   Поддерживает всю мощь диалекта ClickHouse SQL для построения запросов по различным измерениям и показателям.
-   [WEB-API](https://www.seektable.com/help/web-api-integration) для автоматизированной генерации отчетов.
-   Процесс разработки отчетов поддерживает [резервное копирование/восстановление данных](https://www.seektable.com/help/self-hosted-backup-restore); конфигурация моделей данных (кубов) / отчетов представляет собой удобочитаемый XML-файл, который может храниться в системе контроля версий.

SeekTable [бесплатен](https://www.seektable.com/help/cloud-pricing) для личного/индивидуального использования.

[Как сконфигурировать подключение ClickHouse в SeekTable.](https://www.seektable.com/help/clickhouse-pivot-table)

### Chadmin {#chadmin}

[Chadmin](https://github.com/bun4uk/chadmin) — простой графический интерфейс для визуализации запущенных запросов на вашем кластере ClickHouse. Он отображает информацию о запросах и дает возможность их завершать.

### TABLUM.IO {#tablum_io}

[TABLUM.IO](https://tablum.io/) — онлайн инструмент для загрузки и визуализации данных. Позволяет подключаться к БД ClickHouse, работать с базами и таблицами через многофункциональную SQL консоль, загружать данные из таблиц, объединять их с данными из других источников (файлов, сторонних сервисов) и визуализировать результаты в виде таблиц и графиков.

Основные возможности:
- Многофункциональный ETL: загрузка данных из популярных баз данных, локальных и удаленных файлов, загрузка результатов вызова REST API.
- Универсальная SQL консоль с подсветкой синтаксиса и визуальным генератором SQL запросов.
- Визуализация загруженных данных в виде графиков и таблиц.
- Материализация данных и подзапросы к загруженным данным.
- Отправка результатов визуализации в Slack, Telegram или на email.
- Организация потоков данных (data pipeline) через собственный API.
- Экспорт данных в форматах JSON, CSV, SQL, HTML.
- Веб-интерфейс.

Поддерживается установка TABLUM.IO на собственный сервер (в виде Docker образа) или работа с сервисом в облаке.
Лицензия: [коммерческий](https://tablum.io/pricing) продукт с периодом бесплатного тестирования 3 месяца. 

Протестировать TABLUM.IO без разворачивания на собственном сервере можно [здесь](https://tablum.io/try).
Подробно о продукте смотрите на [TABLUM.IO](https://tablum.io/)


[Original article](https://clickhouse.com/docs/en/interfaces/third-party/gui/) <!--hide-->
