---
toc_folder_title: F.A.Q.
toc_hidden: true
toc_priority: 76
---

# ClickHouse F.A.Q. {#clickhouse-f-a-q}

В этом разделе документации собраны ответы на вопросы о ClickHouse, которые задают чаще всего.

Категории:

-   **[Общие вопросы](general/index.md)**
    -   [Что такое ClickHouse?](../index.md#what-is-clickhouse)
    -   [Почему ClickHouse такой быстрый?](general/why-clickhouse-is-so-fast.md)
    -   [Кто пользуется ClickHouse?](general/who-is-using-clickhouse.md)
    -   [Что обозначает название ClickHouse?](general/dbms-naming.md)
    -   [Как фраза “Не тормозит” осталась на всех футболках?](general/ne-tormozit.md)
    -   [Что такое OLAP?](general/olap.md)
    -   [Что такое столбцовая база данных?](general/columnar-database.md)
    -   [Почему бы не использовать системы типа MapReduce?](general/mapreduce.md)
-   **[Применение](use-cases/index.md)**
    -   [Можно ли использовать ClickHouse как БД временных рядов?](use-cases/time-series.md)
    -   [Можно ли использовать ClickHouse для хранения данных вида "ключ-значение"?](use-cases/key-value.md)
-   **[Операции](operations/index.md)**
    -   [Какую версию ClickHouse использовать?](operations/production.md)
    -   [Возможно ли удалить старые записи из таблицы ClickHouse?](operations/delete-old-data.md)
-   **[Интеграция](integration/index.md)**
    -   [Как экспортировать данные из ClickHouse в файл?](integration/file-export.md)
    -   [Как импортировать JSON в ClickHouse?](integration/json-import.md)
    -   [Что делать, если у меня проблема с кодировками при использовании Oracle через ODBC?](integration/oracle-odbc.md)

{## TODO
Question candidates:
- How to choose a primary key?
- How to add a column in ClickHouse?
- Too many parts
- How to filter ClickHouse table by an array column contents?
- How to insert all rows from one table to another of identical structure?
- How to kill a process (query) in ClickHouse?
- How to implement pivot (like in pandas)?
- How to remove the default ClickHouse user through users.d?
- Importing MySQL dump to Clickhouse
- Window function workarounds (row\_number, lag/lead, running diff/sum/average)
##}
