---
title: Что такое столбцовая база данных?
toc_hidden: true
toc_priority: 101
---

# Что такое столбцовая (колоночная) база данных? {#what-is-a-columnar-database}

В столбцовой БД данные каждого столбца хранятся отдельно (независимо) от других столбцов. Такой принцип хранения позволяет при выполнении запроса считывать с диска данные только тех столбцов, которые непосредственно участвуют в этом запросе. Обратная сторона такого принципа хранения заключается в том, что выполнение операций над строками становится более затратным. ClickHouse — типичный пример столбцовой СУБД.

Ключевые преимущества столбцовой СУБД:

- выполнение запросов над отдельными столбцами таблицы, а не над всей таблицей сразу;
- агрегация запросов на больших объемах данных;
- сжатие данных в столбцах.

Ниже — иллюстрация того, как извлекаются данные для отчетов при использовании обычной строковой СУБД и столбцовой СУБД:

**Стандартная строковая СУБД**
![Стандартная строковая СУБД](/docs/en/images/row-oriented.gif#)

**Столбцовая СУБД**
![Столбцовая СУБД](/docs/en/images/column-oriented.gif#)

Для аналитических приложений столбцовые СУБД предпочтительнее, так как в них можно хранить много столбцов в таблице просто на всякий случай, и это не будет сказываться на скорости чтения данных. Столбцовые СУБД предназначены для обработки и хранения больших данных. Они прекрасно масштабируются при помощи распределенных кластеров на относительно недорогих серверах — для увеличения производительности. В ClickHouse для этого используются [распределенные](../../engines/table-engines/special/distributed.md) и [реплицированные](../../engines/table-engines/mergetree-family/replication.md) таблицы.
