---
toc_folder_title: "Семейство Log"
toc_title: "Введение"
toc_priority: 29
---

# Семейство Log {#semeistvo-log}

Движки разработаны для сценариев, когда необходимо быстро записывать много таблиц с небольшим объёмом данных (менее 1 миллиона строк), а затем читать их целиком.

Движки семейства:

-   [StripeLog](stripelog.md)
-   [Log](log.md)
-   [TinyLog](tinylog.md)

Табличные движки семейства `Log` могут хранить данные в распределенных файловых системах [HDFS](../../../engines/table-engines/mergetree-family/mergetree.md#table_engine-mergetree-hdfs) или [S3](../../../engines/table-engines/mergetree-family/mergetree.md#table_engine-mergetree-s3).

## Общие свойства {#obshchie-svoistva}

Движки:

-   Хранят данные на диске.

-   Добавляют данные в конец файла при записи.

-   Поддерживают блокировки для конкурентного доступа к данным.

        Во время запросов `INSERT` таблица блокируется, а другие запросы на чтение и запись ожидают разблокировки таблицы. Если запросов на запись данных нет, то можно выполнять любое количество конкуретных запросов на чтение.

-   Не поддерживают операции [мутации](../../../sql-reference/statements/alter/index.md#mutations).

-   Не поддерживают индексы.

        Это означает, что запросы `SELECT` не эффективны для выборки диапазонов данных.

-   Записывают данные не атомарно.

        Вы можете получить таблицу с повреждёнными данными, если что-то прервёт операцию записи (например, аварийное завершение работы сервера).

## Отличия {#otlichiia}

Движок `TinyLog` самый простой в семье и обеспечивает самые низкие функциональность и эффективность. Движок `TinyLog` не поддерживает параллельного чтения данных в несколько потоков. Движок читает данные медленнее, чем оба других движка с параллельным чтением, и использует почти столько же дескрипторов, сколько и движок `Log`, поскольку хранит каждый столбец в отдельном файле. Его можно использовать в простых сценариях с низкой нагрузкой.

Движки `Log` и `StripeLog` поддерживают параллельное чтение. При чтении данных, ClickHouse использует множество потоков. Каждый поток обрабатывает отдельный блок данных. Движок `Log` сохраняет каждый столбец таблицы в отдельном файле. Движок `StripeLog` хранит все данные в одном файле. Таким образом, движок `StripeLog` использует меньше дескрипторов в операционной системе, а движок `Log` обеспечивает более эффективное считывание данных.

