---
machine_translated: true
machine_translated_rev: ad252bbb4f7e2899c448eb42ecc39ff195c8faa1
toc_priority: 40
toc_title: "ANSI\u306E\u4E92\u63DB\u6027"
---

# ClickHouse SQLの方言のANSI SQLの互換性 {#ansi-sql-compatibility-of-clickhouse-sql-dialect}

!!! note "注"
    この記事では、表38に依存しています, “Feature taxonomy and definition for mandatory features”, Annex F of ISO/IEC CD 9075-2:2013.

## 行動の違い {#differences-in-behaviour}

次の表は、ClickHouseでクエリ機能が機能しますが、ANSI SQLで指定されているように動作しないケースを示しています。

| Feature ID | 機能名                           | 違い                                                                            |
|------------|----------------------------------|---------------------------------------------------------------------------------|
| E011       | 数値データ型                     | 数値リテラルと期間として解釈される近似 (`Float64`）の代わりに正確な (`Decimal`) |
| E051-05    | 選択した項目の名前を変更できます | アイテムの名前変更は、選択結果だけよりも可視性の範囲が広くなります              |
| E141-01    | NULLでない制約                   | `NOT NULL` は黙示のためのテーブル列によるデフォルト                             |
| E011-04    | 算術演算子                       | ClickHouse溢れの代わりに次の算術演算の結果のデータ型に基づくカスタムルール      |

## 機能の状態 {#feature-status}

| Feature ID | 機能名                                                                                            | 状態                       | コメント                                                                                                                                                                               |
|------------|---------------------------------------------------------------------------------------------------|----------------------------|----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| **E011**   | **数値データ型**                                                                                  | **部分的**{.text-warning}  |                                                                                                                                                                                        |
| E011-01    | 整数およびSMALLINTデータ型                                                                        | はい。 {.text-success}      |                                                                                                                                                                                        |
| E011-02    | 実数、倍精度および浮動小数点データ型データ型                                                      | 部分的 {.text-warning}      | `FLOAT(<binary_precision>)`, `REAL` と `DOUBLE PRECISION` 対応していません                                                                                                             |
| E011-03    | DECIMALおよびNUMERICデータ型                                                                      | 部分的 {.text-warning}      | のみ `DECIMAL(p,s)` サポートされています。 `NUMERIC`                                                                                                                                   |
| E011-04    | 算術演算子                                                                                        | はい。 {.text-success}      |                                                                                                                                                                                        |
| E011-05    | 数値比較                                                                                          | はい。 {.text-success}      |                                                                                                                                                                                        |
| E011-06    | 数値データ型間の暗黙的なキャスト                                                                  | いいえ。 {.text-danger}     | ANSI SQLできる任意の暗黙的な数値型の間のキャストがClickHouseに依存しての機能を有する複数の過負荷の代わりに暗黙的なキャスト                                                             |
| **E021**   | **文字列タイプ**                                                                                  | **部分的**{.text-warning}  |                                                                                                                                                                                        |
| E021-01    | 文字データ型                                                                                      | いいえ。{.text-danger}     |                                                                                                                                                                                        |
| E021-02    | 文字変化型データ型                                                                                | いいえ。 {.text-danger}     | `String` 動作同様に、長さの制限内                                                                                                                                                      |
| E021-03    | 文字リテラル                                                                                      | 部分的 {.text-warning}      | 連続したリテラルと文字セットの自動連結はサポートされません                                                                                                                             |
| E021-04    | CHARACTER_LENGTH関数                                                                             | 部分的 {.text-warning}      | いいえ。 `USING` 句                                                                                                                                                                    |
| E021-05    | OCTET_LENGTH関数                                                                                 | いいえ。 {.text-danger}     | `LENGTH` 同様に動作します                                                                                                                                                              |
| E021-06    | SUBSTRING                                                                                         | 部分的 {.text-warning}      | サポートなし `SIMILAR` と `ESCAPE` 句、ない `SUBSTRING_REGEX` バリアント                                                                                                               |
| E021-07    | 文字の連結                                                                                        | 部分的 {.text-warning}      | いいえ。 `COLLATE` 句                                                                                                                                                                  |
| E021-08    | 上部および下の機能                                                                                | はい。 {.text-success}      |                                                                                                                                                                                        |
| E021-09    | トリム機能                                                                                        | はい。 {.text-success}      |                                                                                                                                                                                        |
| E021-10    | 固定長および可変長文字ストリング型間の暗黙的なキャスト                                            | いいえ。 {.text-danger}     | ANSI SQLできる任意の暗黙の間のキャスト文字列の種類がClickHouseに依存しての機能を有する複数の過負荷の代わりに暗黙的なキャスト                                                           |
| E021-11    | 位置関数                                                                                          | 部分的 {.text-warning}      | サポートなし `IN` と `USING` 句、ない `POSITION_REGEX` バリアント                                                                                                                      |
| E021-12    | 文字の比較                                                                                        | はい。 {.text-success}      |                                                                                                                                                                                        |
| **E031**   | **識別子**                                                                                        | **部分的**{.text-warning}  |                                                                                                                                                                                        |
| E031-01    | 区切り識別子                                                                                      | 部分的 {.text-warning}      | Unicodeリテラルの支援は限られ                                                                                                                                                          |
| E031-02    | 小文字の識別子                                                                                    | はい。 {.text-success}      |                                                                                                                                                                                        |
| E031-03    | 末尾のアンダースコア                                                                              | はい。 {.text-success}      |                                                                                                                                                                                        |
| **E051**   | **基本的なクエリ仕様**                                                                            | **部分的**{.text-warning}  |                                                                                                                                                                                        |
| E051-01    | SELECT DISTINCT                                                                                   | はい。 {.text-success}      |                                                                                                                                                                                        |
| E051-02    | GROUP BY句                                                                                        | はい。 {.text-success}      |                                                                                                                                                                                        |
| E051-04    | グループによる列を含むことができない `<select list>`                                              | はい。 {.text-success}      |                                                                                                                                                                                        |
| E051-05    | 選択した項目の名前を変更できます                                                                  | はい。 {.text-success}      |                                                                                                                                                                                        |
| E051-06    | 句を持つ                                                                                          | はい。 {.text-success}      |                                                                                                                                                                                        |
| E051-07    | 選択リストの修飾\*                                                                                | はい。 {.text-success}      |                                                                                                                                                                                        |
| E051-08    | FROM句の相関名                                                                                    | はい。 {.text-success}      |                                                                                                                                                                                        |
| E051-09    | FROM句の列の名前を変更します                                                                      | いいえ。 {.text-danger}     |                                                                                                                                                                                        |
| **E061**   | **基本的な述語と検索条件**                                                                        | **部分的**{.text-warning}  |                                                                                                                                                                                        |
| E061-01    | 比較述語                                                                                          | はい。 {.text-success}      |                                                                                                                                                                                        |
| E061-02    | 述語の間                                                                                          | 部分的 {.text-warning}      | いいえ。 `SYMMETRIC` と `ASYMMETRIC` 句                                                                                                                                                |
| E061-03    | 値のリストを持つ述語で                                                                            | はい。 {.text-success}      |                                                                                                                                                                                        |
| E061-04    | 述語のように                                                                                      | はい。 {.text-success}      |                                                                                                                                                                                        |
| E061-05    | LIKE述語:エスケープ句                                                                             | いいえ。 {.text-danger}     |                                                                                                                                                                                        |
| E061-06    | Null述語                                                                                          | はい。 {.text-success}      |                                                                                                                                                                                        |
| E061-07    | 定量化された比較述語                                                                              | いいえ。 {.text-danger}     |                                                                                                                                                                                        |
| E061-08    | 存在する述語                                                                                      | いいえ。 {.text-danger}     |                                                                                                                                                                                        |
| E061-09    | 比較述語のサブクエリ                                                                              | はい。 {.text-success}      |                                                                                                                                                                                        |
| E061-11    | In述語のサブクエリ                                                                                | はい。 {.text-success}      |                                                                                                                                                                                        |
| E061-12    | 定量化された比較述語のサブクエリ                                                                  | いいえ。 {.text-danger}     |                                                                                                                                                                                        |
| E061-13    | 相関サブクエリ                                                                                    | いいえ。 {.text-danger}     |                                                                                                                                                                                        |
| E061-14    | 検索条件                                                                                          | はい。 {.text-success}      |                                                                                                                                                                                        |
| **E071**   | **基本的なクエリ式**                                                                              | **部分的**{.text-warning}  |                                                                                                                                                                                        |
| E071-01    | UNION DISTINCTテーブル演算子                                                                      | いいえ。 {.text-danger}     |                                                                                                                                                                                        |
| E071-02    | UNION ALLテーブル演算子                                                                           | はい。 {.text-success}      |                                                                                                                                                                                        |
| E071-03    | DISTINCTテーブル演算子を除く                                                                      | いいえ。 {.text-danger}     |                                                                                                                                                                                        |
| E071-05    | 列の結合経由でテーブル事業者の必要のない全く同じデータ型                                          | はい。 {.text-success}      |                                                                                                                                                                                        |
| E071-06    | サブクエリ内のテーブル演算子                                                                      | はい。 {.text-success}      |                                                                                                                                                                                        |
| **E081**   | **基本権限**                                                                                      | **部分的**{.text-warning}  | 進行中の作業                                                                                                                                                                           |
| **E091**   | **関数の設定**                                                                                    | **はい。**{.text-success}  |                                                                                                                                                                                        |
| E091-01    | AVG                                                                                               | はい。 {.text-success}      |                                                                                                                                                                                        |
| E091-02    | COUNT                                                                                             | はい。 {.text-success}      |                                                                                                                                                                                        |
| E091-03    | MAX                                                                                               | はい。 {.text-success}      |                                                                                                                                                                                        |
| E091-04    | MIN                                                                                               | はい。 {.text-success}      |                                                                                                                                                                                        |
| E091-05    | SUM                                                                                               | はい。 {.text-success}      |                                                                                                                                                                                        |
| E091-06    | すべての量指定子                                                                                  | いいえ。 {.text-danger}     |                                                                                                                                                                                        |
| E091-07    | 異なる量指定子                                                                                    | 部分的 {.text-warning}      | な集計機能に対応                                                                                                                                                                       |
| **E101**   | **基本的なデータ操作**                                                                            | **部分的**{.text-warning}  |                                                                                                                                                                                        |
| E101-01    | INSERT文                                                                                          | はい。 {.text-success}      | 注：ClickHouseの主キーは、 `UNIQUE` 制約                                                                                                                                               |
| E101-03    | 検索されたUPDATE文                                                                                | いいえ。 {.text-danger}     | そこには `ALTER UPDATE` バッチデータ変更のための命令                                                                                                                                   |
| E101-04    | 検索されたDELETE文                                                                                | いいえ。 {.text-danger}     | そこには `ALTER DELETE` バッチデータ削除のための命令                                                                                                                                   |
| **E111**   | **単一行SELECTステートメント**                                                                    | **いいえ。**{.text-danger} |                                                                                                                                                                                        |
| **E121**   | **基本的にカーソルを支援**                                                                        | **いいえ。**{.text-danger} |                                                                                                                                                                                        |
| E121-01    | DECLARE CURSOR                                                                                    | いいえ。 {.text-danger}     |                                                                                                                                                                                        |
| E121-02    | ORDER BY列を選択リストに含める必要はありません                                                    | いいえ。 {.text-danger}     |                                                                                                                                                                                        |
| E121-03    | ORDER BY句の値式                                                                                  | いいえ。 {.text-danger}     |                                                                                                                                                                                        |
| E121-04    | 開いた声明                                                                                        | いいえ。 {.text-danger}     |                                                                                                                                                                                        |
| E121-06    | 位置付きUPDATE文                                                                                  | いいえ。 {.text-danger}     |                                                                                                                                                                                        |
| E121-07    | 位置づけDELETEステートメント                                                                      | いいえ。 {.text-danger}     |                                                                                                                                                                                        |
| E121-08    | 閉じる文                                                                                          | いいえ。 {.text-danger}     |                                                                                                                                                                                        |
| E121-10    | FETCHステートメント:暗黙的なNEXT                                                                  | いいえ。 {.text-danger}     |                                                                                                                                                                                        |
| E121-17    | ホールドカーソル付き                                                                              | いいえ。 {.text-danger}     |                                                                                                                                                                                        |
| **E131**   | **Null値のサポート(値の代わりにnull)**                                                            | **部分的**{.text-warning}  | 一部の制限が適用されます                                                                                                                                                               |
| **E141**   | **基本的な整合性制約**                                                                            | **部分的**{.text-warning}  |                                                                                                                                                                                        |
| E141-01    | NULLでない制約                                                                                    | はい。 {.text-success}      | 注: `NOT NULL` は黙示のためのテーブル列によるデフォルト                                                                                                                                |
| E141-02    | NULLでない列の一意制約                                                                            | いいえ。 {.text-danger}     |                                                                                                                                                                                        |
| E141-03    | 主キー制約                                                                                        | いいえ。 {.text-danger}     |                                                                                                                                                                                        |
| E141-04    | 参照削除アクションと参照updateアクションの両方に対するNO ACTIONのデフォルトを持つ基本外部キー制約 | いいえ。 {.text-danger}     |                                                                                                                                                                                        |
| E141-06    | 制約のチェック                                                                                    | はい。 {.text-success}      |                                                                                                                                                                                        |
| E141-07    | 列の既定値                                                                                        | はい。 {.text-success}      |                                                                                                                                                                                        |
| E141-08    | 主キーで推論されるNULLではありません                                                              | はい。 {.text-success}      |                                                                                                                                                                                        |
| E141-10    | 外部キーの名前は任意の順序で指定できます                                                          | いいえ。 {.text-danger}     |                                                                                                                                                                                        |
| **E151**   | **取引サポート**                                                                                  | **いいえ。**{.text-danger} |                                                                                                                                                                                        |
| E151-01    | COMMIT文                                                                                          | いいえ。 {.text-danger}     |                                                                                                                                                                                        |
| E151-02    | ROLLBACKステートメント                                                                            | いいえ。 {.text-danger}     |                                                                                                                                                                                        |
| **E152**   | **基本セット取引明細書**                                                                          | **いいえ。**{.text-danger} |                                                                                                                                                                                        |
| E152-01    | SET TRANSACTION文:分離レベルSERIALIZABLE句                                                        | いいえ。 {.text-danger}     |                                                                                                                                                                                        |
| E152-02    | SET TRANSACTION文:READ ONLY句とREAD WRITE句                                                       | いいえ。 {.text-danger}     |                                                                                                                                                                                        |
| **E153**   | **サブクエリを使用した更新可能なクエリ**                                                          | **いいえ。**{.text-danger} |                                                                                                                                                                                        |
| **E161**   | **先頭のdouble minusを使用したSQLコメント**                                                       | **はい。**{.text-success}  |                                                                                                                                                                                        |
| **E171**   | **SQLSTATEサポート**                                                                              | **いいえ。**{.text-danger} |                                                                                                                                                                                        |
| **E182**   | **ホスト言語バインド**                                                                            | **いいえ。**{.text-danger} |                                                                                                                                                                                        |
| **F031**   | **基本的なスキーマ操作**                                                                          | **部分的**{.text-warning}  |                                                                                                                                                                                        |
| F031-01    | 永続ベーステーブルを作成するCREATE TABLE文                                                        | 部分的 {.text-warning}      | いいえ。 `SYSTEM VERSIONING`, `ON COMMIT`, `GLOBAL`, `LOCAL`, `PRESERVE`, `DELETE`, `REF IS`, `WITH OPTIONS`, `UNDER`, `LIKE`, `PERIOD FOR` 句およびユーザー解決データ型のサポートなし |
| F031-02    | CREATE VIEW文                                                                                     | 部分的 {.text-warning}      | いいえ。 `RECURSIVE`, `CHECK`, `UNDER`, `WITH OPTIONS` 句およびユーザー解決データ型のサポートなし                                                                                      |
| F031-03    | グラント声明                                                                                      | はい。 {.text-success}      |                                                                                                                                                                                        |
| F031-04    | ALTER TABLE文:ADD COLUMN句                                                                        | 部分的 {.text-warning}      | サポートなし `GENERATED` 節およびシステム期間                                                                                                                                          |
| F031-13    | DROP TABLE文:RESTRICT句                                                                           | いいえ。 {.text-danger}     |                                                                                                                                                                                        |
| F031-16    | DROP VIEW文:RESTRICT句                                                                            | いいえ。 {.text-danger}     |                                                                                                                                                                                        |
| F031-19    | REVOKEステートメント:RESTRICT句                                                                   | いいえ。 {.text-danger}     |                                                                                                                                                                                        |
| **F041**   | **基本的な結合テーブル**                                                                          | **部分的**{.text-warning}  |                                                                                                                                                                                        |
| F041-01    | Inner join必ずというわけではないが、内側のキーワード)                                             | はい。 {.text-success}      |                                                                                                                                                                                        |
| F041-02    | 内部キーワード                                                                                    | はい。 {.text-success}      |                                                                                                                                                                                        |
| F041-03    | LEFT OUTER JOIN                                                                                   | はい。 {.text-success}      |                                                                                                                                                                                        |
| F041-04    | RIGHT OUTER JOIN                                                                                  | はい。 {.text-success}      |                                                                                                                                                                                        |
| F041-05    | 外部結合は入れ子にできます                                                                        | はい。 {.text-success}      |                                                                                                                                                                                        |
| F041-07    | 左外部結合または右外部結合の内部テーブルは、内部結合でも使用できます                              | はい。 {.text-success}      |                                                                                                                                                                                        |
| F041-08    | すべての比較演算子がサポ)                                                                         | いいえ。 {.text-danger}     |                                                                                                                                                                                        |
| **F051**   | **基本日時**                                                                                      | **部分的**{.text-warning}  |                                                                                                                                                                                        |
| F051-01    | 日付データ型(日付リテラルのサポートを含む)                                                        | 部分的 {.text-warning}      | リテラルなし                                                                                                                                                                           |
| F051-02    | 秒の小数部の精度が0以上の時刻データ型(時刻リテラルのサポートを含む)                               | いいえ。 {.text-danger}     |                                                                                                                                                                                        |
| F051-03    | タイムスタンプのデータ型を含む支援のタイムスタンプ文字と小数点以下の秒の精度で少なくとも0-6       | いいえ。 {.text-danger}     | `DateTime64` timeは同様の機能を提供します                                                                                                                                              |
| F051-04    | 日付、時刻、およびタイムスタンプのデータ型の比較述語                                              | 部分的 {.text-warning}      | 使用可能なデータ型は一つだけです                                                                                                                                                       |
| F051-05    | Datetime型と文字列型の間の明示的なキャスト                                                        | はい。 {.text-success}      |                                                                                                                                                                                        |
| F051-06    | CURRENT_DATE                                                                                     | いいえ。 {.text-danger}     | `today()` 似ています                                                                                                                                                                   |
| F051-07    | LOCALTIME                                                                                         | いいえ。 {.text-danger}     | `now()` 似ています                                                                                                                                                                     |
| F051-08    | LOCALTIMESTAMP                                                                                    | いいえ。 {.text-danger}     |                                                                                                                                                                                        |
| **F081**   | **ビュー内の組合および除く**                                                                      | **部分的**{.text-warning}  |                                                                                                                                                                                        |
| **F131**   | **グループ化操作**                                                                                | **部分的**{.text-warning}  |                                                                                                                                                                                        |
| F131-01    | ここで、グループにより、条項対応してクエリを処理するクラウドの場合グ眺望                          | はい。 {.text-success}      |                                                                                                                                                                                        |
| F131-02    | グループ化されたビュ                                                                              | はい。 {.text-success}      |                                                                                                                                                                                        |
| F131-03    | セット機能に対応してクエリを処理するクラウドの場合グ眺望                                          | はい。 {.text-success}      |                                                                                                                                                                                        |
| F131-04    | GROUP BY句とHAVING句およびグループ化ビューを持つサブクエリ                                        | はい。 {.text-success}      |                                                                                                                                                                                        |
| F131-05    | GROUP BY句およびHAVING句およびグループ化ビューを使用した単一行選択                                | いいえ。 {.text-danger}     |                                                                                                                                                                                        |
| **F181**   | **複数モジュール対応**                                                                            | **いいえ。**{.text-danger} |                                                                                                                                                                                        |
| **F201**   | **キャスト機能**                                                                                  | **はい。**{.text-success}  |                                                                                                                                                                                        |
| **F221**   | **明示的な既定値**                                                                                | **いいえ。**{.text-danger} |                                                                                                                                                                                        |
| **F261**   | **大文字と小文字の式**                                                                            | **はい。**{.text-success}  |                                                                                                                                                                                        |
| F261-01    | 簡単な場合                                                                                        | はい。 {.text-success}      |                                                                                                                                                                                        |
| F261-02    | 検索ケース                                                                                        | はい。 {.text-success}      |                                                                                                                                                                                        |
| F261-03    | NULLIF                                                                                            | はい。 {.text-success}      |                                                                                                                                                                                        |
| F261-04    | COALESCE                                                                                          | はい。 {.text-success}      |                                                                                                                                                                                        |
| **F311**   | **スキーマ定義文**                                                                                | **部分的**{.text-warning}  |                                                                                                                                                                                        |
| F311-01    | CREATE SCHEMA                                                                                     | いいえ。 {.text-danger}     |                                                                                                                                                                                        |
| F311-02    | 永続ベーステーブルのテーブルの作成                                                                | はい。 {.text-success}      |                                                                                                                                                                                        |
| F311-03    | CREATE VIEW                                                                                       | はい。 {.text-success}      |                                                                                                                                                                                        |
| F311-04    | CREATE VIEW: WITH CHECK OPTION                                                                    | いいえ。 {.text-danger}     |                                                                                                                                                                                        |
| F311-05    | グラント声明                                                                                      | はい。 {.text-success}      |                                                                                                                                                                                        |
| **F471**   | **スカラーサブクエリ値**                                                                          | **はい。**{.text-success}  |                                                                                                                                                                                        |
| **F481**   | **展開されたNULL述語**                                                                            | **はい。**{.text-success}  |                                                                                                                                                                                        |
| **F812**   | **基本的なフラグ設定**                                                                            | **いいえ。**{.text-danger} |                                                                                                                                                                                        |
| **T321**   | **基本的なSQL呼び出しルーチン**                                                                   | **いいえ。**{.text-danger} |                                                                                                                                                                                        |
| T321-01    | オーバーロードのないユーザー定義関数                                                              | いいえ。 {.text-danger}     |                                                                                                                                                                                        |
| T321-02    | 過負荷のないユーザー定義ストアドプロシージャ                                                      | いいえ。 {.text-danger}     |                                                                                                                                                                                        |
| T321-03    | 関数呼び出し                                                                                      | いいえ。 {.text-danger}     |                                                                                                                                                                                        |
| T321-04    | CALL文                                                                                            | いいえ。 {.text-danger}     |                                                                                                                                                                                        |
| T321-05    | RETURN文                                                                                          | いいえ。 {.text-danger}     |                                                                                                                                                                                        |
| **T631**   | **一つのリスト要素を持つ述語で**                                                                  | **はい。**{.text-success}  |                                                                                                                                                                                        |
