---
toc_priority: 7
toc_title: "\u6B74\u53F2"
---

# ClickHouseの歴史 {#clickhousenoli-shi}

ClickHouseは元々、 [世界で2番目に大きなWeb分析プラットフォーム](http://w3techs.com/technologies/overview/traffic_analysis/all) である [Yandex.Metrica](https://metrica.yandex.com/)を強化するために開発されたもので、このシステムのコアコンポーネントであり続けています。データベースには13兆を超えるレコードがあり、毎日200億を超えるイベントが発生しますが、ClickHouseでは集計されていないデータから直接カスタムレポートを生成できます。この記事では、ClickHouseの開発の初期段階におけるClickHouseの目標について簡単に説明します。

Yandex.Metricaは、ユーザーが定義した任意のセグメントを使用して、ヒットとセッションに基づいてカスタマイズされたレポートをその都度作成します。これには、多くの場合、一意のユーザー数などの複雑な集計を作成する必要があり、レポートを作成するための新しいデータがリアルタイムで受信されます。

2014年4月の時点で、Yandex.Metricaは毎日約120億のイベント(ページビューとクリック)を追跡していました。カスタムレポートを作成するには、これらすべてのイベントを保存する必要があります。単一のクエリで、数百ミリ秒以内に数百万行をスキャンしたり、わずか数秒で数億行をスキャンする必要があります。

## Yandex.Metricaおよびその他のYandexサービスでの用途 {#yandex-metricaoyobisonota-noyandexsabisudenoyong-tu}

ClickHouseは、Yandex.Metricaで複数の目的に使用されます。その主なタスクは、非集計データを使用してオンラインでレポートを作成することです。 374台のサーバーからなるクラスターを使用し、20.3兆行をデータベースに保存します。圧縮されたデータの量は、重複データとレプリケーションを除いて約2PBです。非圧縮データ(TSV形式)の量は約17PBにもなります。

ClickHouseは以下の目的にも使用されます。

-   Yandex.Metricaのデータをセッションリプレイのために保存する。
-   中間データを処理する。
-   Analyticsを使用したグローバルレポートの作成。
-   Yandex.Metricaエンジンをデバッグするためのクエリの実行。
-   APIおよびユーザーインターフェイスからのログの分析。

ClickHouseは少なくとも、そのほか12のYandexのサービス(検索分野、Market、Direct、ビジネス分析、モバイル開発、AdFox、パーソナルサービスなど)で利用されています。

## 集約されたデータと非集約データ {#ji-yue-saretadetatofei-ji-yue-deta}

統計を効果的に計算するには、データの量を減らすため、データを集計する必要があるという一般的な意見があります。

ただし次の理由により、データ集約は非常に限られた解決策です。

-   ユーザーが必要とするレポートの事前定義リストが必要です。
-   ユーザーはカスタムレポートを作成できません。
-   大量のキーを集約する場合、データ量は削減されず、集約は役に立ちません。
-   多数のレポートの場合、集計のバリエーションが多すぎます(組み合わせ爆発)
-   カーディナリティの高いキー(URLなど)を集約する場合、データの量はそれほど減少しません(たかだか半分程度)。
-   このため、集約されたデータの量は減少するどころか増加する場合があります。
-   生成した全てのレポートをユーザが見るわけではありません。計算の大部分は無駄になっています。
-   データの論理的な整合性は、さまざまな集計に対して違反する可能性があります。

何も集約せず、集約されていないデータを操作する場合、実際には計算量が減る可能性があります。

しかしながら集約は、その大部分がオフラインで実行され、比較的ゆったりと処理します。対照的に、オンライン計算では、ユーザーが結果を待っているため、できるだけ高速に計算する必要があります。

Yandex.Metricaには、Metrageと呼ばれるデータを集計するための特別なシステムがあり、これはほとんどのレポートで使用されています。 2009年以降、Yandex.Metricaは、以前にレポートビルダーで使用されていたOLAPServerと呼ばれる非集計データ用の特殊なOLAPデータベースも使用しました。 OLAPServerは非集計データに対してはうまく機能しましたが、多くの制限があり、必要に応じてすべてのレポートに使用することはできませんでした。制限とは、(数値のみしか扱えない)データ型サポートの欠如や、リアルタイムでデータを段階的に更新できないこと(毎日データを書き換えることによってのみ更新可能)がありました。 OLAPServerはDBMSではなく、特殊なDBだったのです。

OLAPServerの制限を取り除き、レポートのための非集計データを扱う問題を解決するために、私達は ClickHouse DBMSを開発しました。

[Original article](https://clickhouse.com/docs/en/introduction/history/) <!--hide-->
