---
toc_priority: 4
toc_title: "\u7279\u5FB4\u7684\u306A\u6A5F\u80FD"
---

# ClickHouseの特徴 {#clickhousenote-zheng}

## 真の列指向DBMS {#zhen-nolie-zhi-xiang-dbms}

真の列指向DBMSでは、値に関する余分なデータは保存されません。 これは、固定長の値がサポートされ、「データ長」が格納されないことを意味します。 例として、10億個のUInt8型の値は、圧縮されていない状態で約1 GBを消費しますが、そうしないとCPU負荷に大きく影響します。 これは、データの展開速度(CPU使用率)が、主に非圧縮データのサイズに依存するため、データを(冗長なデータが含まれないように)コンパクトに格納することが非常に重要であるためです。

値を列ごとに保存できるシステムは他にもありますが、それらは「分析クエリの効果的な処理」以外のシナリオに最適化されているため、ClickHouseは注目に値します。 例えば、HBase、BigTable、Cassandra、およびHyperTableなどです。これらのシステムでは、毎秒数十万行のスループットが得られますが、毎秒数億行ではありません。

また、ClickHouseは単一のデータベースではなく、データベース管理システムであることに注意してください。 ClickHouseを使用すると、サーバーを再構成および再起動することなく、実行時にテーブルとデータベースを作成し、データを読み込み、クエリを実行できます。

## データ圧縮 {#detaya-suo}

一部の列指向DBMS（InfiniDB CEおよびMonetDB）は、データ圧縮を使用しません。ただし、優れたパフォーマンスを実現するには、データ圧縮が重要な役割を果たします。

## データのディスクストレージ {#detanodeisukusutorezi}

データを主キーで物理的に並べ替えておくと、特定の値または値範囲のデータを数十ミリ秒未満の低遅延で抽出できます。一部の列指向DBMS（SAP HANAやGoogle PowerDrillなど）は、RAMでのみ機能します。このアプローチでは、リアルタイム分析を行う上で、実際に必要なハードウェアよりも規模の大きな予算の割り当てが推奨されます。 これに対しClickHouseは、通常のハードドライブで動作するように設計されています。 つまり、データストレージのGBあたりのコストは低くなり、さらに利用可能なSSDや追加のRAMがあれば、それらもフルに使用されます。

## マルチコアでの並列処理 {#marutikoadenobing-lie-chu-li}

大規模なクエリは、現在のサーバーで使用可能なすべての必要なリソースを使用して、自然な方法で並列化されます。

## 複数のサーバーでの分散処理 {#fu-shu-nosabadenofen-san-chu-li}

前述の列指向DBMSのほとんどは、分散クエリ処理をサポートしていません。 ClickHouseでは、データを異なるシャードに置くことができます。各シャードは、フォールトトレランスに使用されるレプリカのグループにすることができます。クエリは、すべてのシャードで並行して処理されます。これはユーザーにとって透過的です。

## SQLのサポート {#sqlnosapoto}

ClickHouseは、多くの場合、標準SQLと同一のSQLに基づく宣言的なクエリ言語をサポートしています。サポートされるクエリには、GROUP BY、ORDER BYや、FROM、IN、およびJOIN句中のサブクエリ、およびスカラーサブクエリが含まれます。従属サブクエリとウィンドウ関数はサポートされていません。

## ベクトルエンジン {#bekutoruenzin}

データは列ごとに格納されるだけでなく、ベクトル（列の一部）によって処理されます。これにより、高いCPU効率を実現できます。

## リアルタイムのデータ更新 {#riarutaimunodetageng-xin}

ClickHouseは、主キーを持つテーブルをサポートします。 主キーの範囲でクエリをすばやく実行するために、データはマージツリーを使用して随時並べ替えられます。これにより、データを継続的にテーブルに追加できます。新しいデータが取り込まれたときにロックは取得されません。

## インデックス {#indetukusu}

データを主キーで物理的に並べ替えることにより、特定の値または値範囲のデータを数十ミリ秒未満の低遅延で抽出できます。

## オンラインクエリとの親和性 {#onrainkueritonoqin-he-xing}

低レイテンシであるとは、UIページの読み込み中に、事前計算を伴わないでクエリを遅延なく処理できることを意味します。これはオンラインであるとも言えます。

## 近似計算のサポート {#jin-si-ji-suan-nosapoto}

ClickHouseには、精度を犠牲にしてパフォーマンスを得るための様々な方法が用意されています。

1.  ユニーク値、中央値、および分位数を近似計算のための集計関数。
2.  データの一部（サンプル）に基づいてクエリを実行し、近似結果を取得します。この場合、ディスクから取得されるデータは近似に比例して少なくなります。
3.  すべてのキーではなく、限られた数のランダムキーに対して集計を実行します。データ内のキー分布が特定の条件下であれば、使用するリソースが少なくなり、かなり正確な結果が得られます。

## データのレプリケーションとデータ整合性のサポート {#detanorepurikesiyontodetazheng-he-xing-nosapoto}

非同期マルチマスターレプリケーションを使用します。使用可能なレプリカに書き込まれた後、データはバックグラウンドで残りのすべてのレプリカに配布されます。システムは、異なるレプリカで同一のデータを維持します。ほとんどの障害後の回復は、自動的に、複雑な場合には半自動的に実行されます。

詳細については、[データ複製](../engines/table-engines/mergetree-family/replication.md) セクションを参照してください。

## 欠点と考えられるClickHouseの機能 {#qian-dian-tokao-erareruclickhousenoji-neng}

1.  本格的なトランザクションはありません。
2.  既に挿入されたデータの変更または削除を、高頻度かつ低遅延に行う機能はありません。 [GDPR](https://gdpr-info.eu)に準拠するなど、データをクリーンアップまたは変更するために、バッチ削除およびバッチ更新が利用可能です。
3.  インデックスが疎であるため、ClickHouseは、キーで単一行を取得するようなクエリにはあまり適していません。

[Original article](https://clickhouse.com/docs/en/introduction/distinctive_features/) <!--hide-->
