---
machine_translated: true
machine_translated_rev: 72537a2d527c63c07aa5d2361a8829f3895cf2bd
toc_folder_title: "\u30ED\u30B0\u30D5\u30A1\u30DF\u30EA"
toc_priority: 29
toc_title: "\u306F\u3058\u3081\u306B"
---

# ログエンジン家族 {#log-engine-family}

これらのエンジンは、多くの小さなテーブル（最大1万行）をすばやく書き込み、後で全体として読み込む必要があるシナリオ用に開発されました。

家族のエンジン:

-   [ストリップログ](stripelog.md)
-   [ログ](log.md)
-   [TinyLog](tinylog.md)

## 共通プロパティ {#common-properties}

エンジン:

-   ディスクにデータを格納します。

-   書き込み時にファイルの末尾にデータを追加します。

-   同時データアクセスのサポートロック。

    中 `INSERT` クエリのテーブルがロックされ、その他の質問を読み込みおよび書き込みデータの両方のテーブルを作成する データ書き込みクエリがない場合は、任意の数のデータ読み込みクエリを同時に実行できます。

-   サポートしない [突然変異](../../../sql-reference/statements/alter.md#alter-mutations) 作戦だ

-   索引をサポートしません。

    つまり `SELECT` データ範囲のクエリは効率的ではありません。

-   書くわけではありませんデータを原子的に.

    取得できるテーブルデータが破損した場合も破れ、書き込み操作は、例えば、異常サーバをシャットダウンしました。

## 違い {#differences}

その `TinyLog` エンジンは家族の最も簡単、最も悪い機能性および最も低い効率を提供する。 その `TinyLog` エンジンをサポートしていない並列データの読み取りによる複数のスレッド）。 でデータを読み込む代わりに、各エンジンの家族を支援する並列読みでの使用がほとんど同じになりました記述子としての `Log` エンジンは、各列を別々のファイルに格納するためです。 単純な低負荷のシナリオで使用します。

その `Log` と `StripeLog` エンジンの支援並列データです。 読み込み時にデータClickHouse使複数のスレッド）。 各スレッドプロセス別データブロックです。 その `Log` エンジンは、テーブルの各列に個別のファイルを使用します。 `StripeLog` すべてのデータファイルです。 その結果、 `StripeLog` エンジンは、オペレーティングシス `Log` エンジンはデータを読むとき高性能を提供する。

[元の記事](https://clickhouse.com/docs/en/operations/table_engines/log_family/) <!--hide-->
