# system.crash_log {#system-tables_crash_log}

Contains information about stack traces for fatal errors. The table does not exist in the database by default, it is created only when fatal errors occur.

Columns:

-   `event_date` ([Datetime](../../sql-reference/data-types/datetime.md)) — Date of the event.
-   `event_time` ([Datetime](../../sql-reference/data-types/datetime.md)) — Time of the event.
-   `timestamp_ns` ([UInt64](../../sql-reference/data-types/int-uint.md)) — Timestamp of the event with nanoseconds.
-   `signal` ([Int32](../../sql-reference/data-types/int-uint.md)) — Signal number.
-   `thread_id` ([UInt64](../../sql-reference/data-types/int-uint.md)) — Thread ID.
-   `query_id` ([String](../../sql-reference/data-types/string.md)) — Query ID.
-   `trace` ([Array](../../sql-reference/data-types/array.md)([UInt64](../../sql-reference/data-types/int-uint.md))) — Stack trace at the moment of crash. Each element is a virtual memory address inside ClickHouse server process.
-   `trace_full` ([Array](../../sql-reference/data-types/array.md)([String](../../sql-reference/data-types/string.md))) — Stack trace at the moment of crash. Each element contains a called method inside ClickHouse server process.
-   `version` ([String](../../sql-reference/data-types/string.md)) — ClickHouse server version.
-   `revision` ([UInt32](../../sql-reference/data-types/int-uint.md)) — ClickHouse server revision.
-   `build_id` ([String](../../sql-reference/data-types/string.md)) — BuildID that is generated by compiler.

**Example**

Query:

``` sql
SELECT * FROM system.crash_log ORDER BY event_time DESC LIMIT 1;
```

Result (not full):

``` text
Row 1:
──────
event_date:   2020-10-14
event_time:   2020-10-14 15:47:40
timestamp_ns: 1602679660271312710
signal:       11
thread_id:    23624
query_id:     428aab7c-8f5c-44e9-9607-d16b44467e69
trace:        [188531193,...]
trace_full:   ['3. DB::(anonymous namespace)::FunctionFormatReadableTimeDelta::executeImpl(std::__1::vector<DB::ColumnWithTypeAndName, std::__1::allocator<DB::ColumnWithTypeAndName> >&, std::__1::vector<unsigned long, std::__1::allocator<unsigned long> > const&, unsigned long, unsigned long) const @ 0xb3cc1f9 in /home/username/work/ClickHouse/build/programs/clickhouse',...]
version:      ClickHouse 20.11.1.1
revision:     54442
build_id:
```

**See also**
-   [trace_log](../../operations/system-tables/trace_log.md) system table

[Original article](https://clickhouse.com/docs/en/operations/system-tables/crash-log)
