---
toc_folder_title: F.A.Q.
toc_hidden: true
toc_priority: 76
---

# ClickHouse F.A.Q {#clickhouse-f-a-q}

This section of the documentation is a place to collect answers to ClickHouse-related questions that arise often.

Categories:

-   **[General](../faq/general/index.md)**
    -   [What is ClickHouse?](../index.md#what-is-clickhouse)
    -   [Why ClickHouse is so fast?](../faq/general/why-clickhouse-is-so-fast.md)
    -   [Who is using ClickHouse?](../faq/general/who-is-using-clickhouse.md)
    -   [What does “ClickHouse” mean?](../faq/general/dbms-naming.md)
    -   [What does “Не тормозит” mean?](../faq/general/ne-tormozit.md)
    -   [What is OLAP?](../faq/general/olap.md)
    -   [What is a columnar database?](../faq/general/columnar-database.md)
    -   [Why not use something like MapReduce?](../faq/general/mapreduce.md)
-   **[Use Cases](../faq/use-cases/index.md)**
    -   [Can I use ClickHouse as a time-series database?](../faq/use-cases/time-series.md)
    -   [Can I use ClickHouse as a key-value storage?](../faq/use-cases/key-value.md)
-   **[Operations](../faq/operations/index.md)**
    -   [Which ClickHouse version to use in production?](../faq/operations/production.md)
    -   [Is it possible to delete old records from a ClickHouse table?](../faq/operations/delete-old-data.md)
    -   [Does ClickHouse support multi-region replication?](../faq/operations/multi-region-replication.md)
-   **[Integration](../faq/integration/index.md)**
    -   [How do I export data from ClickHouse to a file?](../faq/integration/file-export.md)
    -   [What if I have a problem with encodings when connecting to Oracle via ODBC?](../faq/integration/oracle-odbc.md)

{## TODO
Question candidates:
- How to choose a primary key?
- How to add a column in ClickHouse?
- Too many parts
- How to filter ClickHouse table by an array column contents?
- How to insert all rows from one table to another of identical structure?
- How to kill a process (query) in ClickHouse?
- How to implement pivot (like in pandas)?
- How to remove the default ClickHouse user through users.d?
- Importing MySQL dump to ClickHouse
- Window function workarounds (row_number, lag/lead, running diff/sum/average)
##}

{## [Original article](https://clickhouse.com/docs/en/faq) ##}
