# Waterfox Localization

Welcome to the Waterfox localization repository! This repository contains the Fluent (.ftl) files used for translating the Waterfox browser into various languages.

## Contributing Translations via Weblate

We use Weblate, an open-source web-based translation tool, to manage our localization efforts. Here's how you can contribute:

### Getting Started with Weblate

1. Visit our Weblate project page at [https://hosted.weblate.org/engage/waterfox/](https://hosted.weblate.org/engage/waterfox/).
2. Create an account or log in if you already have one.
3. Choose the language you want to translate to from the list of available languages.

### Using Weblate

1. **Browse Translations**:
   - After selecting a language, you'll see a list of files or components that need translation.
   - Click on a file to start translating.

2. **Translate Strings**:
   - You'll see the original text (usually in English) and a box where you can enter your translation.
   - Type your translation and click 'Save'.

3. **Use Translation Memory**:
   - Weblate will suggest translations based on previous work. Use these if they fit the context.

4. **Add Comments**:
   - If you're unsure about a translation or need clarification, use the comment feature to discuss with other translators.

5. **Review Translations**:
   - You can also review existing translations and suggest improvements.

### Best Practices

- Stay true to the original meaning while making the translation natural in the target language.
- Be consistent with terminology across the project.
- Pay attention to placeholders (like {$variable}) and make sure to include them in your translations.
- If you're unsure about a translation, it's better to leave it untranslated than to guess.

### Need Help?

If you have any questions or need assistance, please:
- Check the Weblate documentation at [https://docs.weblate.org](https://docs.weblate.org/en/latest/user/basic.html)
- Ask in the comments section on Weblate
- Ask in the [Reddit community](https://www.reddit.com/r/waterfox)

Thank you for contributing to making Waterfox accessible to users around the world!
